#
#    Makefile.PL
#
#    $Id: Makefile.PL,v 1.17 2002/07/22 02:05:44 bstell Exp $
#
#    Copyright (c) 2000 Brian Stell
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License 
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

use ExtUtils::MakeMaker;
use Cwd;

require Config;
$Verbose = 1;
$version = '1.00.00';

# don't really understand why we need to say g++
# but ICU header files need the g++ headers
$CC = 'g++';

$typemap = [cwd() . "/perlobject.map", cwd() . "/icu_typemap"];
$inc = "-I./include";

#
# List the parts that make up the output
#
@xsfiles = qw(
              classes/BiDi/BiDi.xs
              classes/BreakIterator/BreakIterator.xs
              classes/Calendar/Calendar.xs
              classes/DateFormat/DateFormat.xs
              classes/DateFormatSymbols/DateFormatSymbols.xs
              classes/DecimalFormatSymbols/DecimalFormatSymbols.xs
              classes/ICU/ICU.xs
              classes/Locale/Locale.xs
              classes/MessageFormat/MessageFormat.xs
              classes/Normalizer/Normalizer.xs
              classes/NumberFormat/NumberFormat.xs
              classes/TimeZone/TimeZone.xs
              classes/UConverter/UConverter.xs
              classes/Unicode/Unicode.xs
             );

@cfiles  = qw(
           util/picu_debug.c
           util/picu_utf8.c
           util/picu_util.c
          );

#
# process the parts into a list of objects
# process the parts into a list of things to clean up
#
@objects = ();
@clean = ();
foreach $xs (@xsfiles) {
  ($xs_ofile = $xs) =~ s/\.xs$/.o/;
  push(@objects, $xs_ofile);
  push(@clean,   $xs_ofile);
  ($xs_cfile = $xs) =~ s/\.xs$/.c/;
  push(@clean, $xs_cfile);
}
foreach $c (@cfiles) {
  ($c_ofile = $c) =~ s/\.c$/.o/;
  push(@objects, $c_ofile);
  push(@clean,   $c_ofile);
}

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    'NAME'        => 'ICU',
    'DISTNAME'    => 'Icu-Wrapper',
    'VERSION'     => $version,
    'LIBS'        => ['-licui18n', '-licutoolutil',
                      '-licuuc', '-licustdio'],   # e.g., '-lm' 
    'PM'          => {
                      'classes/BiDi/BiDi.pm'     
                               => '$(INST_LIBDIR)/ICU/BiDi.pm',
                      'classes/BreakIterator/BreakIterator.pm'     
                               => '$(INST_LIBDIR)/ICU/BreakIterator.pm',
                      'classes/Calendar/Calendar.pm'     
                               => '$(INST_LIBDIR)/ICU/Calendar.pm',
                      'classes/DateFormat/DateFormat.pm'     
                               => '$(INST_LIBDIR)/ICU/DateFormat.pm',
                      'classes/DateFormatSymbols/DateFormatSymbols.pm'     
                               => '$(INST_LIBDIR)/ICU/DateFormatSymbols.pm',
                      'classes/DecimalFormatSymbols/DecimalFormatSymbols.pm'
                               => '$(INST_LIBDIR)/ICU/DecimalFormatSymbols.pm',
                      'classes/ICU/ICU.pm'
                               => '$(INST_LIBDIR)/ICU.pm',
                      'classes/Locale/Locale.pm'
                               => '$(INST_LIBDIR)/ICU/Locale.pm',
                      'classes/MessageFormat/MessageFormat.pm'
                               => '$(INST_LIBDIR)/ICU/MessageFormat.pm',
                      'classes/Normalizer/Normalizer.pm'
                               => '$(INST_LIBDIR)/ICU/Normalizer.pm',
                      'classes/NumberFormat/NumberFormat.pm'
                               => '$(INST_LIBDIR)/ICU/NumberFormat.pm',
                      'CharacterSet/SJIS.pm'     
                               => '$(INST_LIBDIR)/CharacterSet/SJIS.pm',
                      'classes/TimeZone/TimeZone.pm'
                               => '$(INST_LIBDIR)/ICU/TimeZone.pm',
                      'classes/UConverter/UConverter.pm'
                               => '$(INST_LIBDIR)/ICU/UConverter.pm',
                      'classes/Unicode/Unicode.pm'
                               => '$(INST_LIBDIR)/ICU/Unicode.pm',
                   },
    'depend'      => { Makefile => icu_typemap },
    'TYPEMAPS'    => $typemap,
    'DEFINE'      => '',     # e.g., '-DHAVE_SOMETHING' 
    'INC'         => '',     # e.g., '-I/usr/include/other' 
    'CC'          => $CC,
    'INC'         => $inc,
    'LD'          => '$(CC)',
    'clean'       => {FILES => join(' ', @clean) },
    'XS'          => "@xsfiles",
    'OBJECT'      =>  "@objects",
    'XSPROTOARG'  => '-noprototypes',
    'XSOPT'       => '-noversioncheck',
);

#
# change the .c.o suffix rule to put the .o in the same dir as the .c
#
sub MY::c_o {
    package MY; # so that "SUPER" works right
    my $inherited = shift->SUPER::c_o(@_);
    $inherited =~ s/CCCMD.*$/$&\n\t\@if test -f `basename \$*.o` -a "`basename \$*.o`" != "\$*.o"; then mv `basename \$*.o` \$*.o; fi/gm;
    return($inherited);
}

#
# change the .xs.o suffix rule to put the .o in the same dir as the .xs
#
sub MY::xs_o {
    package MY; # so that "SUPER" works right
    my $inherited = shift->SUPER::xs_o(@_);
    $inherited =~ s/CCCMD.*$/$&\n\t\@if test -f `basename \$*.o` -a "`basename \$*.o`" != "\$*.o"; then mv `basename \$*.o` \$*.o; fi/gm;
    return($inherited);
}


#
# change the manifypods rule to use 'ICU' instead of 'classes'
#
sub MY::manifypods {
    package MY; # so that "SUPER" works right
    my $inherited = shift->SUPER::manifypods(@_);
    $inherited =~ s|\$\(INST_MAN3DIR\)/classes::.*?::|\$(INST_MAN3DIR)/ICU::|gm;
    $inherited =~ s|\bICU::ICU\b|ICU|gm;
    return($inherited);
}

