# Generated by default/object.tt
package Paws::AccessAnalyzer::KmsKeyConfiguration;
  use Moose;
  has Grants => (is => 'ro', isa => 'ArrayRef[Paws::AccessAnalyzer::KmsGrantConfiguration]', request_name => 'grants', traits => ['NameInRequest']);
  has KeyPolicies => (is => 'ro', isa => 'Paws::AccessAnalyzer::KmsKeyPoliciesMap', request_name => 'keyPolicies', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::KmsKeyConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::KmsKeyConfiguration object:

  $service_obj->Method(Att1 => { Grants => $value, ..., KeyPolicies => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::KmsKeyConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->Grants

=head1 DESCRIPTION

Proposed access control configuration for a KMS key. You can propose a
configuration for a new KMS key or an existing KMS key that you own by
specifying the key policy and KMS grant configuration. If the
configuration is for an existing key and you do not specify the key
policy, the access preview uses the existing policy for the key. If the
access preview is for a new resource and you do not specify the key
policy, then the access preview uses the default key policy. The
proposed key policy cannot be an empty string. For more information,
see Default key policy
(https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default).
For more information about key policy limits, see Resource quotas
(https://docs.aws.amazon.com/kms/latest/developerguide/resource-limits.html).

=head1 ATTRIBUTES


=head2 Grants => ArrayRef[L<Paws::AccessAnalyzer::KmsGrantConfiguration>]

A list of proposed grant configurations for the KMS key. If the
proposed grant configuration is for an existing key, the access preview
uses the proposed list of grant configurations in place of the existing
grants. Otherwise, the access preview uses the existing grants for the
key.


=head2 KeyPolicies => L<Paws::AccessAnalyzer::KmsKeyPoliciesMap>

Resource policy configuration for the KMS key. The only valid value for
the name of the key policy is C<default>. For more information, see
Default key policy
(https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

