package ICU::BreakIterator;
#
#    BreakIterator.pm
#
#    $Id: BreakIterator.pm,v 1.1 2001/02/12 02:07:38 bstell Exp $
#
#    Copyright (c) 2000 Brian Stell
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License 
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

use strict;
use Carp;
use vars qw(@ISA @EXPORT_OK $AUTOLOAD);

use Exporter;
@ISA = qw(Exporter);
use AutoLoader;

use ICU;

@EXPORT_OK = qw(
    &DONE
);

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.  If a constant is not found then control is passed
    # to the AUTOLOAD in AutoLoader.

    my $constname;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "& not defined" if $constname eq 'constant';
    my $val = constant_iv($constname, @_ ? $_[0] : 0);
    if ($! != 0) { 
        if ($! =~ /Invalid/) {
            $AutoLoader::AUTOLOAD = $AUTOLOAD;
            goto &AutoLoader::AUTOLOAD;
        }
        else {
                croak "Your vendor has not defined ICU::BreakIterator macro $constname";
        }
    }
    no strict 'refs';
    *$AUTOLOAD = sub { $val };
    goto &$AUTOLOAD;
}

1;

__END__

=head1 NAME

ICU::BreakIterator 

=head1 SYNOPSIS

  use ICU::BreakIterator;

=head1 DESCRIPTION

TBD

