#include <unistd.h>
#include <errno.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <qdir.h>
#include <qfile.h>
#include <qpixmap.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qtextstream.h>
#include <qpopupmenu.h>
#include <qprogressbar.h>
#include <qmenubar.h>
#include <qkeycode.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qprinter.h>
#include <qapplication.h>
#include <qaccel.h>
#include <qcursor.h>
#include <qlayout.h>
#include <assert.h>
#include <qregexp.h>
#include <qheader.h>
#include <qtimer.h>
#include "qbibman.h" 
#include "EditMask.h" 
#include "MyLV.h" 
#include "FindDial.h" 

#include "filesave.xpm"
#include "fileopen.xpm"
#include "fileprint.xpm"
#include "about.h"

#ifndef LATEXCOMMAND
 #error no LATEXCOMMAND defined
#endif

#ifndef PRINTCOMMAND
 #error no PRINTCOMMAND defined
#endif

#ifndef VIEWCOMMAND
 #error no VIEWCOMMAND defined
#endif

const char *CITATION="%CITATION";

ApplicationWindow *CurAW;
const QString maincaption( "Bibliography Manager" );
ApplicationWindow::ApplicationWindow(int isFind=0)
    : QMainWindow( 0, "application main window" )
{
    fw=isFind;
    if (isFind) {edited=1;} else edited=0;
    fn="";
    QPixmap openIcon, saveIcon, printIcon,findIcon;
    setStyle(MotifStyle);

    fileTools = new QToolBar( this, "file operations" );

    openIcon = QPixmap( fileopen );
    saveIcon = QPixmap( filesave );
    printIcon = QPixmap( fileprint );
    
    if (!fw) {
     fileOpen = new QToolButton( openIcon, "Open File", 0,
					       this, SLOT(load()),
					       fileTools, "open file" );

     fileSave = new QToolButton( saveIcon, "Save File", 0,
					       this, SLOT(save()),
					       fileTools, "save file" );
    } else {
     fileSave = new QToolButton( saveIcon, "Save File", 0,
					       this, SLOT(save()),
					       fileTools, "save file" );
    
    }

    filePrint = new QToolButton( printIcon, "Print File", 0,
					       this, SLOT(print()),
					       fileTools, "print file" );

    QPopupMenu * file = new QPopupMenu();
    QPopupMenu * edit = new QPopupMenu();
    QPopupMenu * help = new QPopupMenu();
    help->insertItem("&about",this,SLOT(about()));
    lv = new MyLV ( this, "Liste" );
    menuBar()->insertItem( "&File", file );
    menuBar()->insertItem( "&Entry", edit );
    if (!fw) edit->insertItem("&new\tIns",lv,SLOT(newItem()));
    edit->insertItem("&delete\tDel",lv,SLOT(deleteItem()));
    edit->insertItem("&modify\tEnter",this,SLOT(edit_Entry()));
    if (!fw) {
     menuBar()->insertSeparator();
     menuBar()->insertItem( "&Help", help );
     edit->insertSeparator();
     edit->insertItem("Find",this,SLOT(find()));
     file->insertItem("Open",this,SLOT(load()),Key_F3);
     file->insertItem("Save", this, SLOT(save()), Key_F2);
     file->insertItem("Close",this,SLOT(closeFile_slot()));
    } 
    file->insertItem("Save as", this, SLOT(save_as()), SHIFT+Key_F2);
    file->insertItem("Print", this, SLOT(print()), ALT+Key_P );
    file->insertSeparator();
    if (!fw) file->insertItem( "Quit", this, SLOT(closeDoc()), ALT+Key_Q );
     else file->insertItem( "Close", this, SLOT(closeDoc()), Key_Escape);

    lv->setFocus();
    lv->setVScrollBarMode(QScrollView::AlwaysOn);
    lv->setHScrollBarMode(QScrollView::AlwaysOff);
    int w=lv->width()-lv->verticalScrollBar()->width();
    lv->addColumn("ID");
    lv->addColumn("Type");
    lv->addColumn("Author");
    lv->addColumn("Year");
    lv->addColumn("Title");
    lv->addColumn("Source");
    lv->setColumnAlignment(3,AlignHCenter);
    for (int i=0;i<6;i++)
     lv->setColumnWidthMode(i,QListView::Manual);
    lv->setAllColumnsShowFocus(1);
    lv->setItemMargin(3);
    setCentralWidget( lv );
    if (fw) db=((ApplicationWindow*)qApp->mainWidget())->db;
     else db=new_db();
    connect(lv,SIGNAL(doubleClicked(QListViewItem*)),SLOT(edit_Entry(QListViewItem*)));
    connect(lv,SIGNAL(returnPressed(QListViewItem*)),SLOT(edit_Entry(QListViewItem*)));
    statusBar()->message("Ready",4000);
}


ApplicationWindow::~ApplicationWindow()
{
}

void ApplicationWindow::closeFile_slot(){
 if (edited) 
 switch  (QMessageBox::warning(this,"Warning",
     "Changes have not been saved!","Save",
     "Don't save","Cancel",0,2)){
   case 0:save();if (!edited) closeFile();break;
   case 1:closeFile();break;
   case 2:return;
  } 
 else closeFile();
}

void ApplicationWindow::closeFile(){
  free_db(db);
  db=new_db();
  lv->clear();
  fn="";
  setCaption(maincaption);
  edited=0;
}

QString ApplicationWindow::getFileName(int opendial){
 const char *F[]={"Bibliographies (*.bib)","Auxiliary files (*.aux)",NULL};
 static QFileDialog* qfd=new QFileDialog(this,"static File Dialog",TRUE);
 static int isinitialized=0;
 static char *dir=getenv("BIBINPUTS");
 char *cc;
 if (!isinitialized){
  if (dir) 
   for (;(cc=strrchr(dir,':'));){
    qfd->setDir(cc+1);
    *cc='\0';
   }
  qfd->setDir(dir);
  qfd->setFilters(F);
  isinitialized=1;  
 } 
 switch (opendial) {
  case 1: qfd->setCaption("Open");
          qfd->setMode(QFileDialog::ExistingFile);break;
  case 2: qfd->setCaption("Save as");
          qfd->setMode(QFileDialog::AnyFile);qfd->setFilter(F[0]);
 } 
 if (qfd->exec())
  return qfd->selectedFile();else return QString("");
}

void ApplicationWindow::load() {
 if (edited){ 
   if (!QMessageBox::warning(this,"Warning","Changes have not been saved!",
       "Save before closing","Close without saving",NULL,0,1)){
    save();
    if (edited) return;
   }   
  } 
  QString filename(getFileName(1));
  if (!filename.isEmpty()){
      closeFile();
      load(filename.data());
    } else statusBar()->message("Loading aborted",4000);
}

MyLVI* ApplicationWindow::addEntry(Record e){
 char *F1=NULL, *F2=NULL, *F3=NULL, *F4=NULL, *F5=NULL, *F6=NULL;
 for (int i=2;i<e->rc_free;i+=2){
  if ((!F1) && ((RecordHeap(e))[i]==symbol("author"))) F1=(RecordHeap(e))[i+1];
  if ((!F2) && ((RecordHeap(e))[i]==symbol("year"))) F2=(RecordHeap(e))[i+1];
  if ((!F3) && ((RecordHeap(e))[i]==symbol("title"))) F3=(RecordHeap(e))[i+1];
  if ((!F4) && ((RecordHeap(e))[i]==symbol("journal"))) F4=(RecordHeap(e))[i+1];
  if ((!F5) && ((RecordHeap(e))[i]==symbol("booktitle"))) F5=(RecordHeap(e))[i+1];
  if ((!F6) && ((RecordHeap(e))[i]==symbol("editor"))) F6=(RecordHeap(e))[i+1];
 }
 if (F1) {
  QStrList authors=getnames(F1);
  for (unsigned i=0;i<authors.count();i++)
   if (!authornames.contains(authors.at(i))) authornames.append(authors.at(i));
 }
 if (F4) {
  if (!journalnames.contains(F4)) journalnames.append(F4);
 }
 if (F6) {
  QStrList authors=getnames(F6);
  for (unsigned i=0;i<authors.count();i++)
  if (!authornames.contains(authors.at(i))) authornames.append(authors.at(i));
 }
 if (!F4) F4=F5;
 lvi=new MyLVI(e,lv,(RecordHeap(e))[0],entry_type[(RecordType(e))],strip_braces(F1),strip_braces(F2),strip_braces(F3),strip_braces(F4));
 return lvi;
}

void ApplicationWindow::edit_Entry(){
 edit_Entry(lv->currentItem());
}

void ApplicationWindow::edit_Entry(QListViewItem *lvi){
 if (!lvi) return;
 ApplicationWindow *maw=((ApplicationWindow*)(qApp->mainWidget()));
 Record e=((MyLVI*)lvi)->r;
 EditMask em(this,"Edit Mask",e);
 if (em.exec()) {
  delete ((MyLVI*)lvi);
  addEntry(e);
  lv->triggerUpdate();
  edited=1;
  if (fw){
   for (QListViewItem *i=maw->lv->firstChild();i;i=i->nextSibling()){
    if (((MyLVI*)(i))->r==e) {((MyLVI*)(i))->~MyLVI();break;}
   }
   maw->addEntry(e);
   maw->lv->triggerUpdate();
   maw->edited=1;
  }
 }
}

void readfromauxc(char *f){
 ((ApplicationWindow*)(qApp->mainWidget()))->readfromaux(f);
}

void ApplicationWindow::readfromaux(char *f){
 read_db(db,f,ch_ent,0);
}

void ApplicationWindow::load( char *fileName ){
  int lp,*p;
  int nn=0;
  QString ss;
  FILE *f;

  CurAW=this;
  if (!(f=fopen(fileName,"r"))){
   ss.sprintf("Could not open file %s: %s",fileName,strerror(errno));
   statusBar()->message(ss,4000);
   return;
  }
  fclose(f);
  setCursor(waitCursor);
  if (QString(fileName).right(4).find(".aux")!=-1){ //aux file
   if (read_aux(fileName,readfromauxc,0)) {
    ss.sprintf("There was an error while importing from auxfile %s",fileName);
    statusBar()->message(ss,4000);
    setCursor(arrowCursor);
    return;
   }
   apply_aux(db);
   edited=1;
  } else {
   read_db(db,fileName,ch_ent,0);
   fn=fileName;
   setCaption((maincaption+": ")+fileName);
   edited=0;
  } 
  db_forall(db,addit);
//  Record gc_start=((MyLVI *)lv->firstChild())->r;
//  record_gc(gc_start);
  setCursor(arrowCursor);
  p=db_count(db,&lp);
  for (int i=0;i<lp;i++)
   nn+=p[i];
  ss.sprintf( "Loaded document %s: %d entries", fileName, nn);
  statusBar()->message(ss,4000);
  lv->setSelected(lv->firstChild(),1);
}

void ApplicationWindow::save(const  char* name,int real=1){
 FILE *f;
 int rn=1;
 char SaveMode[]="p$nciam";
 QString backup(name);
 if (QFile::exists(name)) rn=rename (name,(backup+"~").data());
 QString ss;
 f=fopen(name,"w");
 if (!f) {
  ss.sprintf("File %s could not be saved: %s",name,strerror(errno));
  statusBar()->message(ss,4000);
  return;
 }
 print_db(f,db,SaveMode);
 fclose(f);
 if (real) {
  edited=0;
  ss.sprintf("File %s saved%s",name,rn ? ": Backup was not written":"");
  statusBar()->message(ss,4000);
  setCaption((maincaption+": ")+name);
 } 
}

void ApplicationWindow::save() {
 if (!edited) {
  statusBar()->message("File has not been modified",4000);
  return;
 }
 if (fn.isEmpty()) save_as(); else save(fn);
}

void ApplicationWindow::save_as() {
   char *dir=getenv("BIBINPUTS"),*cc;
   if (dir) {
    if ((cc=strchr(dir,':'))) *cc='\0';
   }
   QString nfn = getFileName(2);
   if (nfn.isEmpty()){
    statusBar()->message("Save aborted",4000);
    return;
   } 
   if ((fn!=nfn) && QFile::exists(nfn.data()))
    if (QMessageBox::warning(this,"Warning","File exists! Overwrite?","Yes","No")) {save_as();return;}
   fn=nfn;
   save(fn);
}

void ApplicationWindow::hide(){
 if (fw){
  ApplicationWindow *aw=((ApplicationWindow*)(qApp->mainWidget()));
  aw->lv->setEnabled(1);
  aw->menuBar()->setEnabled(1);
  aw->fileTools->setEnabled(1);
  aw->fileOpen->setEnabled(1);
  aw->filePrint->setEnabled(1);
  aw->fileSave->setEnabled(1);
  connect(aw->lv,SIGNAL(doubleClicked(QListViewItem*)),aw,SLOT(edit_Entry(QListViewItem*)));
  connect(aw->lv,SIGNAL(returnPressed(QListViewItem*)),aw,SLOT(edit_Entry(QListViewItem*)));
  aw->lv->setFocus();
  this->QMainWindow::hide();
  return;
 }
}

bool ApplicationWindow::close(bool force){
 if ((!fw) && (edited))
 switch (QMessageBox::warning(this,"Warning","Changes have been made!","Save and exit","Exit without saving","Cancel quit",0,2)) {
  case 0:save();if (!edited) return this->QMainWindow::close(force);
         else return 0;break;
  case 1: return this->QMainWindow::close(force);
  case 2: return 0;
 }
 return this->QMainWindow::close(force);
}

void ApplicationWindow::find()
{
 static FindDial *fd=new FindDial(this,0);
 if (!fd->exec()) return;
 QRegExp regex(fd->exp->text());
 regex.setCaseSensitive(fd->Case_sens->isOn());
 int id=(fd->sfield->find(0)->isOn() | fd->all->isOn());
 QStrList searchfields;
 for (int i=1;i<26;i++)
  if (fd->sfield->find(i)->isOn() | fd->all->isOn())
   searchfields.append(symbol((char *)fd->sfield->find(i)->text()));
 int n=0;
 ApplicationWindow *Find=new ApplicationWindow(1);
 Find->setCaption("Find Results");
 for (QListViewItem *i=lv->firstChild();i;i=i->nextSibling()){
  Record r=((MyLVI*)(i))->r;
  if ((id) && (regex.match(RecordHeap(r)[0])!=-1)){
   n++;Find->addEntry(r);continue;}
  for (int j=2;j<RecordFree(r);j++){
   if (searchfields.contains((RecordHeap(r))[j]) && (regex.match((RecordHeap(r))[j+1])!=-1)){
    n++;Find->addEntry(r);break;}
  } 
 } 
 if (!n) {
  statusBar()->message("No matching records found",4000);
  delete Find;
 } else { 
  lv->setEnabled(0);
  menuBar()->setEnabled(0);
  disconnect(lv,SIGNAL(doubleClicked(QListViewItem*)),this,SLOT(edit_Entry(QListViewItem*)));
  disconnect(lv,SIGNAL(returnPressed(QListViewItem*)),this,SLOT(edit_Entry(QListViewItem*)));
  fileOpen->setEnabled(0);
  filePrint->setEnabled(0);
  fileSave->setEnabled(0);
  Find->show();
  QString m;
  m.sprintf("Found %d matching record(s)",n);
  Find->statusBar()->message(m,4000);
 } 
}

void ApplicationWindow::print(){
 realprint=QMessageBox::query("Print","Do you want to have a hardcopy or see the result on screen?","Hardcopy","Screen");
 if (realprint) statusBar()->message("Printing ...",4000);
 repaint();
 qApp->processEvents();
 QTimer::singleShot(0,this,SLOT(doprint()));
}

void ApplicationWindow::doprint()
{
 char *c=tempnam(NULL,"bibman");
 QString tmpdir(c);
 QDir d,home(QDir::current());
 if (!(c && d.mkdir(c,TRUE)))  {QMessageBox::critical(this,"Error","Could not get a temporary directory");free(c);return;}
 free(c);
 d.setCurrent(tmpdir.data());
 save((tmpdir+"/bibman.bib").data(),0);  
 FILE *l=fopen("bibman.tex","w");
 char *Home=getenv("HOME");
 QString conf("/.qbibman");
 if (Home) conf.prepend(Home);
 QFile qf(conf);
 QTextStream st(&qf);
 if (qf.exists()) {
  qf.open(IO_ReadOnly);
  while (!qf.atEnd()){
   conf=st.readLine();
   if (conf==CITATION) break;
   fprintf(l,"%s\n",conf.data());
  } 
 if (conf!=CITATION) {
  QString m;
  m.sprintf("Could not find \"%s\" in your $HOME/.qbibman file",CITATION);
  QMessageBox::information(this,"Problem",m.data(),1);
  fclose(l);
  QFile::remove("bibman.tex");
  QFile::remove("bibman.bib");
  QFile::remove("printbib");
  d.setCurrent(home.path());
  d.rmdir(tmpdir.data());
  return;
 }
 } else {
  fprintf(l,"\\documentclass{article}\n");
  fprintf(l,"\\begin{document}\n");
 }
 for (QListViewItem *i=lv->firstChild();i;i=i->nextSibling())
  if (!lv->isMultiSelection() || lv->isSelected(i)) fprintf(l,"\\nocite{%s}\n",*RecordHeap(((MyLVI*)i)->r));
 fprintf(l,"\\bibliography{./bibman}\n");
 if (qf.exists()) {
  while (!qf.atEnd()){
   conf=st.readLine();
   fprintf(l,"%s\n",conf.data());
  } 
 } else {
  fprintf(l,"\\bibliographystyle{plain}\n");
  fprintf(l,"\\end{document}\n");
 }
 fclose(l);
 QString script(tmpdir+"/printbib");
 FILE *f=fopen(script.data(),"a");
 if (!f) return;
 fprintf(f,"#!/bin/sh\n");
 fprintf(f,"%s bibman && ",LATEXCOMMAND);
 fprintf(f,"bibtex bibman && ");
 fprintf(f,"%s bibman && ",LATEXCOMMAND);
 fprintf(f,"%s bibman && ",LATEXCOMMAND);
 fprintf(f,"%s bibman || exit 1\n",(realprint?PRINTCOMMAND:VIEWCOMMAND));
 fprintf(f,"rm bibman.*\n");
 fclose(f);
 setCursor(waitCursor);
 f=popen("sh "+script+" 2>&1","r");
 char buf[1025];
 QString res;
 while (!feof(f)){
  int i=fread(buf,1,1024,f);
  buf[i]='\0';
  res.append(buf);
 }
 if (pclose(f)) QMessageBox::information(this,"Output from subprocess",res,1);
 setCursor(ArrowCursor);
 QFile::remove("bibman.tex");
 QFile::remove("printbib");
 d.setCurrent(home.path());
 d.rmdir(tmpdir.data());
 if (realprint) statusBar()->message("Print command executed",4000);
}

void ApplicationWindow::closeDoc(){
    close(FALSE); 
}

void ApplicationWindow::about(){
 About *a=new About(this,NULL);
 a->exec();
}

void ApplicationWindow::resizeEvent(QResizeEvent *re){
 
 int w=re->size().width()-lv->verticalScrollBar()->width();
 lv->setColumnWidth(0,w/8);
 lv->setColumnWidth(1,w/8);
 lv->setColumnWidth(2,w/4);
 lv->setColumnWidth(3,w/16);
 lv->setColumnWidth(4,w/4);
 lv->setColumnWidth(5,3*w/16);
 this->QMainWindow::resizeEvent(re);
}

char KEYFORMAT[]="%-1n(author):%2d(year)";

void add_rewrite_rules();

int main(int argc, char ** argv ) {
    init_bibtool(argv[0]);
    add_rewrite_rules();
    add_format(KEYFORMAT);
    QApplication a( argc, argv );
    ApplicationWindow * mw = new ApplicationWindow(0);
    a.setMainWidget(mw);
    mw->setCaption(maincaption);
    mw->show();
    a.connect( &a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()) );
    return a.exec();
}

