---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, listes, énumérations, style, 
              description, babel
---

# Comment changer le style des étiquettes d'une liste `description` ?

## Avec les commandes de base

La commande `\descriptionlabel` détermine le style des étiquettes 
de l'environnement `description`. Il suffit donc de la 
[redéfinir](/2_programmation/macros/commande_newcommand) pour obtenir 
le résultat souhaité.

L'exemple qui suit produit des étiquettes en italique :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
En synthèse additive des couleurs (pour la combinaison de sources 
lumineuses), il existe trois couleurs primaires :
\begin{description}
   \item[Rouge]
   \item[Bleu]
   \item[Vert]  
\end{description}

\renewcommand\descriptionlabel[1]{%
    \hspace\labelsep\normalfont
    \itshape #1}

En synthèse soustractive des couleurs (pour la photographie ou 
l'impression), il existe trois couleurs primaires :
\begin{description}
   \item[Jaune]
   \item[Magenta] 
   \item[Cyan]
\end{description}
\end{document}
```