---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes, polices de caractères
---

# Comment utiliser les fontes *Concrete* ?

Les polices *[Concrete Roman](wp:Concrete_Roman)* ont été conçues par Don Knuth 
pour un livre intitulé "Concrete Mathematics", qu'il a écrit avec Graham et Patashnik 
(*le* Patashnik, célèbre pour BibTeX). Knuth n'a conçu que des polices de texte, 
le livre utilisant les polices *Euler* pour les mathématiques. 
Ce livre a été composé en utilisant Plain TeX, bien sûr, avec des commandes supplémentaires
qui peuvent être visualisées dans le fichier `gkpmac.tex` de l'extension <ctanpkg:gkpmac>.

Les extensions <ctanpkg:beton>, <ctanpkg:concmath> et <ctanpkg:ccfonts> 
changent les polices de texte par défaut de *Computer Modern* à *Concrete*. 
Les extensions <ctanpkg:beton> et <ctanpkg:ccfonts> augmentent aussi légèrement la valeur 
par défaut de `baselineskip` pour tenir compte du poids plus important des polices *Concrete*.
Si vous souhaitez utiliser les polices *Euler* pour les mathématiques, comme le faisait Knuth, 
il existe l'extension <ctanpkg:euler> développée à partir du jeu de polices Plain TeX de Knuth :
ces commandes sont cependant de moins en moins recommandées 
(elles sont en conflit avec beaucoup de choses, y compris <ctanpkg:amsmath>). 
L'extension <ctanpkg:eulervm>, développée indépendamment, 
est donc préférée à l'extension <ctanpkg:euler>. 
Notez que l'installation de cette extension implique l'installation de polices virtuelles. 
Bien que la plupart des distributions modernes semblent avoir les fichiers requis 
installés par défaut, il se peut que vous deviez les installer. 
Dans ce cas, consultez le fichier `readme` dans la distribution <ctanpkg:eulervm>.

Quelques années après le travail initial de Knuth, 
Ulrik Vieth a conçu les polices *Concrete Math*.
Les extensions <ctanpkg:concmath> et <ctanpkg:ccfonts> font également la bascule 
des polices mathématiques par défaut de *Computer Modern* à *Concrete* 
et utilisent les versions *Concrete* des polices de l'AMS 
(ce dernier comportement est optionnel dans le cas du paquet <ctanpkg:concmath>).

Il n'y a pas de fonte *Concrete* en gras, 
mais il est généralement admis que la fonte *Computer Modern Sans Serif demibold condensed* 
est un substitut adéquat. Si vous utilisez <ctanpkg:concmath> ou <ctanpkg:ccfonts> 
et que vous voulez suivre cette suggestion, 
utilisez l'extesnion avec l'option de classe `boldsans` 
(bien que la documentation de <ctanpkg:concmath> l'appelle cette option de classe `sansbold`). 
Si vous utilisez <ctanpkg:beton>, ajoutez ce qui suit dans le préambule de votre document.

```{noedit}
\renewcommand{\bfdefault}{sbc}
```

Les versions Type 1 des polices sont disponibles. 
Pour l'encodage OT1, elles sont disponibles auprès de 
[MicroPress](/5_fichiers/formats/fontes/fontes_t1_pour_les_mathematiques). 
Les fontes *[CM-Super](/5_fichiers/formats/fontes/tracer_les_contours_d_une_police_metafont)*
contiennent les versions Type 1 des polices *Concrete* en encodage T1.


:::{sources}
[Using the "Concrete fonts](faquk:FAQ-concrete)
:::