/* 
 * HISTORY
 * $Log: wavelan.h,v $
 * Revision 1.1  1994/06/02  20:31:11  klemets
 * Initial revision
 *
 */
#ifndef	_CHIPS_WAVELAN_H
#define _CHIPS_WAVELAN_H

/* This file contains definitions that are common for all versions of
 * the NCR WaveLAN
 */

#define WAVELAN_ADDR_SIZE	6	/* Size of a MAC address */
#define WAVELAN_MTU		1500	/* Maximum size of Wavelan packet */

struct wl_cntrs {
	struct {
		u_int xmt, xmti;
		u_int defer;
		u_int busy;
		u_int sleaze, intrinsic, intrinsic_count;
		u_int chain;
		u_int heart;
		u_int coll;
		u_int ncoll;
		u_int nodcd;
		u_int nocts;
		u_int dma;
	} xmt; 
	struct {
		u_int rcv;
		u_int ovw;
		u_int crc;
		u_int frame;
		u_int rscerrs, ovrnerrs;
		u_int partial;
		u_int snr[5];
	} rcv;
	struct {
		u_short status;
		u_short nwids;
		u_short badnwids;
		u_short thrpreset;
		u_short siglvl;
		u_short sillvl;
		u_short sigqual;
		u_short netwidl;
		u_short des;
	} mmc;
	u_int watch;
};
typedef	struct wl_cntrs *wl_cntrs_t;

#define	CNTR_NAME	"_wl_cntrs"

/* command unit for wlsetstat */
struct wl_ucmd {
  int cmd;
  int param;
};
typedef struct wl_ucmd *wl_ucmd_t;

#ifdef	IF_CNTRS
/* interface driver specific counters */
struct wl_ifcntrs {
  int pkt_arp;
  int pkt_ein[32];
  int pkt_lin[128/8];
  int pkt_eout[32]; 
  int pkt_lout[128/8]; 
};
typedef struct wl_ifcntrs *wl_ifcntrs_t;
#define	NET_WL_IFCNTRS		(('w'<<16) + 3)
#define NET_WL_IFCNTRS_CNT	(sizeof (struct wl_ifcntrs)/sizeof(int))
#endif	IF_CNTRS

/* local flavor value for wlsetstat and wlgetstat */
#define	NET_WL_CNTRS		(('w'<<16) + 1)
#define	NET_WL_CMD		(('w'<<16) + 2)
#define	NET_WL_PSA		(('w'<<24) + ('l'<<16))
#define NET_WL_CNTRS_CNT	(sizeof (struct wl_cntrs)/sizeof(int))
#define NET_WL_CMD_CNT		(sizeof (struct wl_ucmd)/sizeof(int))
#define	NET_WL_PSA_CNT	1

#ifdef	IF_LINKSTATUS
#define NET_LINKSTATE		(('w'<<16) + 4)
#define NET_LADDR_ADD		(('w'<<16) + 5)
#define NET_LADDR_DEL		(('w'<<16) + 6)
#define NET_LADDR_ADD_CNT	((WAVELAN_ADDR_SIZE + sizeof(int) - 1)/sizeof(int))
#define NET_LADDR_DEL_CNT	((WAVELAN_ADDR_SIZE + sizeof(int) - 1)/sizeof(int))
#define	MAX_LINKADDR		64
#endif	IF_LINKSTATUS


/* local commands */
#define	WLCMD_CLEAR		1
#define WLCMD_SENDCMD		2
#define WLCMD_SETNWID		3
#define WLCMD_SETIRQ		4
#define WLCMD_PARAM		5
#define WLCMD_POWER_DOWN	6
#define WLCMD_POWER_UP		7

#define	DEFAULT_PSA_OFFSET	0xe00

/* Allocations in general purpose software block */

#define NETW_ADDR		0x10	/* Factory network address */
#define NETW_ADDR_LOCAL		0x16	/* Local network address */
#define PSA_MAC_SELECT		0x1c	/* 0=factory, 1=local address */
#define PSA_COMP_NUMBER		0x1d	/* 0=PC-AT 915 MHz, 1=PC-MC 915 MHz
					   2=PC-AT 2.4 GHz, 3=PC-MC 2.4 GHz
					   4=PCMCIA 915 MHz */
#define PSA_THR_PRE_SET		0x1e
#define PSA_FEATURE_SELECT	0x1f
#define PSA_SUBBAND		0x20	/* 1=2425 MHz, 2=2460 MHz, 3=2484 MHz
					   4=2430.5 MHz */
#define	PSA_QUALITY_THR		0x21
#define NETW_ID			0x23	/* Network ID */
#define	PSA_NETW_ID_SELECT	0x25
#define PSA_SECURITY_SELECT	0x26
#define PSA_ENCRYPTION_KEY	0x27
#define PSA_DATABUS_WIDTH	0x2f
#define PSA_CALL_CODE		0x30
#define PSA_NWID_PREFIX		0x38
#define PSA_CONF_STATUS		0x3c
#define PSA_CRC			0x3d
#define PSA_CRC_STATUS		0x3f

/* Modem Management Controler write commands */

#define MMC_LOOPT_SEL		0x10
#define MMC_JABBER_ENABLE	0x11
#define MMC_FREEZE		0x12
#define MMC_ANTEN_SEL		0x13
#define MMC_IFS			0x14
#define MMC_MOD_DELAY		0x15
#define MMC_JAM_TIME		0x16
#define MMC_THR_PRE_SET		0x18
#define MMC_DECAY_PRM		0x19
#define MMC_DECAY_UPDAT_PRM	0x1a
#define MMC_QUALITY_THR		0x1b
#define MMC_NETW_ID_L		0x1c
#define MMC_NETW_ID_H		0x1d
#define MMC_MODE_SEL		0x1e
#define MMC_ENCR_KEY		0x00	/* to 0x07 */
#define MMC_ENCR_ENABLE		0x08
#define MMC_DES_IO_INVERT	0x0a

/* MMC read register names */

#define MMC_DCE_STATUS		0x10
#define MMC_CORRECT_NWID_L	0x14
#define MMC_CORRECT_NWID_H	0x15
#define MMC_WRONG_NWID_L	0x16
#define MMC_WRONG_NWID_H	0x17
#define MMC_THR_PRE_SET		0x18
#define MMC_SIGNAL_LVL		0x19
#define MMC_SILENCE_LVL		0x1a
#define MMC_SIGN_QUAL		0x1b
#define MMC_DES_AVAIL		0x09

struct wavelan_conf {
	u_char	wc_confstat;
	u_char	wc_nwid[2];
	u_char	wc_macaddr[6];
	u_char	wc_comp_number;
	u_char	wc_subband;
	u_char	wc_netw_id_sel;
	u_char	wc_thr_pre_set;
	u_char	wc_quality_thr;
};


/* additional socket ioctl params for wl card   
 * see sys/sockio.h for numbers.  The 2nd params here
 * must be greater than any values in sockio.h
 */

#define SIOCGWLNWID   _IOWR('i', 60, struct ifreq)    /* get wlan nwid */
#define SIOCSWLNWID   _IOWR('i', 61, struct ifreq)    /* set wlan nwid */

/* 
 * signal strength cache
 *
 * driver (wlp only at the moment) keeps cache of last
 * IP (only) packets to arrive including signal strength info.
 * daemons may read this with kvm.  See if_wlp.c for globals
 * that may be accessed through kvm.
 *
 * Each entry in the w_sigcache has a unique macsrc and age.
 * Each entry is identified by its macsrc field.
 * Age of the packet is identified by its age field.
 */

#define	MAXCACHEITEMS	10
#ifndef	INT_MAX
#define	INT_MAX		2147483647
#endif
#define	MAX_AGE		(INT_MAX - MAXCACHEITEMS)

/* signal is 7 bits, 0..63, although it doesn't seem to get to 63.
 * silence is 7 bits, 0..63
 * quality is 4 bits, 0..15
 */
struct w_sigcache {
	char	macsrc[6];	/* unique MAC address for entry */
	int	ipsrc;		/* ip address associated with packet */
	int	signal;		/* signal strength of the packet */
	int	silence;	/* silence of the packet */
	int	quality;	/* quality of the packet */
	int	age;		/* packet has unique age between 1 to MAX_AGE - 1 */
};


#endif	_CHIPS_WAVELAN_H

