/*
 * Copyright (c) 1995,1996,1997 Jun-ichiro Itoh <itojun@itojun.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Jun-ichiro Itoh.
 * 4. The name of Jun-ichiro Itoh may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * Hitachi microcomputer system Speech Synthesis card (MSSHVPC02E) driver
 *
 * To purchasing the card, contact the following address:
 *	Tokyo office, Hitachi microcomputer system co.
 *	J tower 9th floor, 1-1, Higane-machi,
 *	Fuchu, Tokyo 183 JAPAN
 *	(voice) +81-423-51-6600 / (fax) +81-423-51-6601
 */
/*
 * Special thanks to: Yasuhito riho-m Watanabe <riho-m@sfc.wide.ad.jp>
 */

struct hss_softc {
#ifdef __bsdi__
	struct	device sc_dev;  		/* base device */
	struct	isadev sc_id;   		/* ISA device */
#endif /*__bsdi__*/
	int	hss_flags;			/* software flags   */
	caddr_t	hss_io_addr;			/* hss io addr */
	int	hss_io_size;			/* hss io addr */
#if 0
	caddr_t	hss_mem_addr;			/* hss memory addr  */
	int	hss_mem_size;			/* hss memory size  */
#endif
#ifdef PCCARD_BSDI
	CliHandle_t	hss_clihdl;
	cs_cfg_t	hss_rcfg;
	int		hss_configured;
	u_char		hss_vstr[255];		/* VERS_1 tuple */
	int		hss_vlen;		/* VERS_1 tuple */
	cs_rio_t	hss_rio;
#if 0
	WinHandle_t	hss_whdl;		/* memwin for chip registers */
#endif
#endif /*PCCARD_BSDI*/
#ifdef PCCARD_FREEBSD
	int		hss_configured;
#endif /*PCCARD_FREEBSD*/
};

#define HSS_DEAD	0x00	
#define HSS_OPEN	0x02
#define HSS_PRIV	0x04

#define HSS_PORTB	0x0002
#define HSS_PORTC	0x0002
#define HSS_SHIRQ	0x000C

#define HSSUNIT(d)	((d) & 0x7)
