/*
 * Copyright (c) 1996 Berkeley Software Design, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that this notice is retained,
 * the conditions in the following notices are met, and terms applying
 * to contributors in the following notices also apply to Berkeley
 * Software Design, Inc.
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by
 *	Berkeley Software Design, Inc.
 * 4. Neither the name of the Berkeley Software Design, Inc. nor the names
 *    of its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY BERKELEY SOFTWARE DESIGN, INC. ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL BERKELEY SOFTWARE DESIGN, INC. BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	BSDI $Id: if_cnwreg.h,v 1.3 1997/12/07 10:21:57 prb Exp $
 *
 *  This driver is derived from a generic frame work which is
 *  Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  A linux driver was used as the "hardware reference manual" and
 *  is copyright by:
 *
 *   John Markus Bjrndalen
 *   Department of Computer Science
 *   University of Troms
 *   Norway             
 *   johnm@staff.cs.uit.no, http://www.cs.uit.no/~johnm/
 */

/*
 * Netwave AirSurfer Wireless LAN
 * (Formerly known as the Xircom CreditCard Netwave Adapter)
 */

/*
 * Memory based control registers
 */
#define	NW_MEM_ADDR	0x20000

struct nwreg {
/*000*/ u_char	nwr_rsv00[0x100];
/*100*/	u_char	nwr_cmd[0x10];		/* Command buffer (write) */
/*110*/	u_char	nwr_rsv01[4];
	u_char	nwr_runstate;		/* Run state (write) */
#	define	NWR_RUN		0x00
#	define	NWR_READY	0x08	/* Ready for command/status read */
#	define	NWR_HALT	0x40
	u_char	nwr_rsv02[11];

/*120*/	u_char	nwr_rstat;		/* status on rx interrupt */
#define	NWR_RSTAT_RXAVAIL	0x80
#define	NWR_RSTAT_RXERROR	0x40
#define	NWR_RSTAT_OVERFLOW	0x10
#define	NWR_RSTAT_OVERRUN	0x08
#define	NWR_RSTAT_CRCERR	0x04
#define	NWR_RSTAT_FRAME		0x02
	u_char	nwr_rsv03[3];
	u_char	nwr_rclr;		/* bits to clear in rstat (write) */
	u_char	nwr_rsv04[11];

/*130*/	u_char	nwr_tstat;		/* status on tx interrupt */
#define	NWR_TSTAT_ABORT		0x80	/* abort */
#define	NWR_TSTAT_CARRLOST	0x40	/* No access point */
#define	NWR_TSTAT_OKAY		0x20	/* packet sent okay */
#define	NWR_TSTAT_TERR		0x10	/* Trasmitter error summary */
#define	NWR_TSTAT_RETRYMASK	0x0f
	u_char	nwr_rsv05[3];
	u_char	nwr_tclr;		/* bits to clear in tstat (write) */
	u_char	nwr_rsv06[11];

/*140*/	u_short	nwr_tbuffer;		/* first available transmit buffer */
	u_short nwr_tlen;		/* data bytes per buffer */
	u_short nwr_toff;		/* starting offset into buffer */
	u_char	nwr_rsv07[8];
	u_char	nwr_lif;		/* link integrity field */
	u_char	nwr_rsv08[1];

/*150*/	short	nwr_rlen;		/* length of recieved packet */
	short	nwr_rbuffer;		/* first receive buffer of list */
	u_char	nwr_spcq;		/* connection quality? */
	u_char	nwr_spu;
	u_char	nwr_isplq;		/* link quality? */
	u_char	nwr_rsv09[1];
	u_char	nwr_hhc;
	u_char	nwr_rsv10[7];

/*160*/	u_char	nwr_addr[6];		/* boards ethernet address */
	u_short	nwr_rev[2];		/* revision number */
	u_char	nwr_rsv11[1];
	u_char	nwr_mhs;
	u_char	nwr_rsv12[2];
	char	nwr_id[2];		/* boards id (NW) */

/*170*/	short	nwr_bmemlen;
	short	nwr_bmembas;
	u_char	nwr_rsv13[12];

/*180*/	u_short	nwr_rsv14[2];
	u_short	nwr_rxerr;		/* # of recieve errors */
	u_short	nwr_frame;		/* # of framing errors */
	u_short	nwr_ihb;		/* input heart beat count */
	u_short	nwr_rsv15[2];
	u_short	nwr_rxbufs;		/* # of buffers received */
/*190*/	u_short	nwr_rxmulti;		/* # of multi-buffer packets */
	u_short	nwr_txretries;		/* # of transmit retries */
	u_short	nwr_txabort;		/* # of transmit aborts */
	u_short	nwr_rsv16[1];
	u_short	nwr_ohb;		/* output heart beat count */
	u_short	nwr_txokay;		/* # of transmits okay */
	u_short	nwr_txsent;		/* # of transmits requested */
	u_short	nwr_rsv17[1];
/*1A0*/
};

/*
 * ioport/memory based control registers
 * These can either be gotten to by ioports or by memory mapping
 */

#define	NW_REG_ADDR	0x28000

struct nwcreg {
/*00*/	u_char	nwc_enable;		/* Interrupt enable register */
#	define	NWR_IENA	0x01	/* Interrupt enable */
#	define	NWR_LVLREQ	0x40	/* Level request */
#	define	NWR_ENORMAL	(NWR_IENA | NWR_LVLREQ)
/*01*/	u_char	nwc_rsv00[1];
/*02*/	u_char	nwc_ccsr;		/* command complete status register */
#	define	NWR_IREADY	0x02	/* Interrupt Ready */
/*03*/	u_char	nwc_rsv01[1];
/*04*/	u_char	nwc_isr;		/* interupt status register */
#	define	NWR_RXAVAIL	0x80	/* Packet Received */
#	define	NWR_RXERR	0x40	/* Receive status change */
#	define	NWR_TXSTAT	0x20	/* Transmit status change */
#	define	NWR_READY	0x08	/* Ready for command/status read */
#	define	NWR_TXEMP	0x01	/* Transmit descriptor available */
/*05*/	u_char	nwc_rsv02[1];
/*06*/	u_short	nwc_io;
/*08*/	u_char	nwc_ioctl;
/*09*/	u_char	nwc_rsv03[1];
/*0A*/	u_char	nwc_ictrl;		/* interrupt control register */
#	define	NWR_IDISABLE	0x00
#	define	NWR_IENABLE	0x02
#	define	NWR_IDISUS	0x10	/* make unused sources not interrupt */
#	define	NWR_INORMAL	(NWR_IENABLE | NWR_IDISUS)
/*0B*/	u_char	nwc_rsv04[1];
/*0C*/	u_char	nwc_reset;		/* resetting runstate */
#	define	NWR_RESET	0x80
#	define	NWR_NOTRESET	0
/*0D*/	u_char	nwc_rsv05[3];
};


/* command bytes */

#define	SHORT_ARG	0x10000		/* Argument is 16 bits, not 8 */
#define	SA(x)		(x | SHORT_ARG)

#define	NW_CMD_INIT		0x0	/* Initialize */
#define	NW_CMD_SET_RXMODE	0x1	/* Set receive mode */
#    define NW_RXENA		0x80	/* Receive Enable */
#    define NW_RXMAC		0x20	/* MAC host receive mode*/
#    define NW_RXPROM		0x10	/* Promiscuous */
#    define NW_RXMCAST		0x08	/* Accept Multicast Packets */
#    define NW_RXBCAST		0x04	/* Accept Broadcast Packets */
    /*
     * Determine the default receive mode
     */
#    define NW_RXMODE(nw) ((nw->nw_if.if_flags & IFF_PROMISC) ? \
	(NW_RXENA | NW_RXMCAST | NW_RXBCAST | NW_RXPROM) : \
	(NW_RXENA | NW_RXMCAST | NW_RXBCAST))

#define	NW_CMD_SET_TXMODE	0x2	/* Set transmit mode */
#    define NW_TXENA		0x80	/* Transmit Enable */
#    define NW_TXMAC		0x20	/* Host sends MAC mode */
#    define NW_TXUDATA		0x10	/* Enable Uni-Data packets */
#    define NW_TXSCRAMBLE	0x02	/* Scramble data packets */
#    define NW_TXLOOPBACK	0x01	/* Loopback mode */
#define	NW_CMD_ADD_MCADDR	0x3	/* Add mc addr */
#define	NW_CMD_DEL_MCADDR	0x4	/* Delete mc addr */
#define	NW_CMD_MC_CTRL		0x5	/* Enable/Disable mc (?) */
#define	NW_CMD_RUN		0x6	/* You can move */
#define	NW_CMD_HALT		0x7	/* Don't move */
#define	NW_CMD_TX_START		0x8	/* Start tx on current tx desc */
#define	NW_CMD_RX_RELEASE	0x9	/* Release current rx desc */
#define	NW_CMD_SET_SKEY		0xa	/* Set scramble key */
#define	NW_CMD_SET_DOMAIN	0xb	/* Set domain */
#    define NW_ACCESSPOINT	0x100	/* Default access point domain */
#    define NW_ADDHOC		0x0	/* Default add hoc domain */
#    define NW_DOMAIN		NW_ADDHOC /* Default domain */
