/*
 * IBM Smart Capture Card driver.
 *
 * Copyright (c) 1995
 *	International Business Machines Corporation.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by International
 *      Business Machines Corporation.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 5. Redistributions are permitted provided for Linux/FreeBSD systems.
 *    If you want to support other operating system, please contact with
 *    IBM Smart Capture Card technical support desk.
 * 6. Do not ask IBM product services and support about Linux/FreeBSD
 *    drivers since International Business Machines Corporation does
 *    not officially support them.
 * THIS SOFTWARE IS PROVIDED BY INTERNATIONAL BUSINESS MACHINES
 * CORPORATION AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL INTERNATIONAL BUSINESS MACHINES
 * CORPORATION OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Changed by Koji OKAMURA <oka@kobe-u.ac.jp>
 * Changed by Yoshihisa NAKAGAWA <y-nakaga@ssc.mt.nec.co.jp>
 * Changed by Takeshi OHASHI <ohashi@mickey.ai.kyutech.ac.jp>
 * Version 0.34, Aug 11, 1996.
 *
 */

#if defined(__linux__)
#define MAXPCMCIA 2
#define NSCC      MAXPCMCIA
#endif /* linux */

/* flags in softc */
#define	SCC_OPEN		0x01		/* device open */
#define	SCC_ALIVE		0x02		/* probed and attached */

typedef unsigned char	BYTE;
typedef	unsigned short	WORD;
typedef	unsigned long	DWORD;

void 	WriteReg(BYTE, BYTE);
BYTE 	ReadReg(BYTE);
BYTE 	FPbusy(void);
void 	i2cwr8(BYTE, BYTE, BYTE);
BYTE 	i2crd8(BYTE, BYTE);
void 	i2cwr16(BYTE, BYTE, WORD);
WORD 	i2crd16(BYTE, BYTE);
void 	i2cwdata(BYTE);
BYTE 	i2crdata(void);
void 	i2cstart(void);
void 	i2cstop(void);
BYTE 	i2crack(void);
BYTE 	i2cwack(void);
BYTE 	i2cwnack(void);
void 	i2cbwr(BYTE, BYTE);
BYTE 	i2cbrd(BYTE);
BYTE 	i2cwait(void);

void 	SetTVStandard(WORD,int);
BYTE 	SetTVChannel(BYTE, BYTE, BYTE, BYTE, int);
void 	FreezeVPX(BYTE,int);
void 	SetVPXRect(WORD, WORD, int);
void 	InitVPX(WORD, BYTE, BYTE, WORD, WORD, BYTE, BYTE, int);
void 	SetVPXColor(BYTE, BYTE, WORD, WORD, int);
void	WaitCapture(BYTE,int );
void    SetVPXFmt(BYTE, int);
void    SetVideoFilter(WORD, int);
void    SetIRQState(BYTE, int);


#define DATA            0x03BC          /* addresses to support accesses to*/
#define STATUS          0x03BD          /* the Parallel Port 1 - Type 1    */
#define CONTROL         0x03BE
#define DACMASK         0x03C6
#define DACSTAT         0x03C7
#define DACRMDX         0x03C7
#define DACINDX         0x03C8
#define DACDATA         0x03C9

/* I2C addresses */
#define VPXI2C          0x43 /* I2C address of VPX version TC5, overraids previous */
/* #define VPXI2C          0x01 // I2C address of VPX version TC4 */
#define PETI2C          0x61 /* I2C address of the Philips European Tuner */

/* VPX registers */
#define FPRD            0x0026
#define FPWR            0x0027
#define FPDAT           0x0028
#define FPSTA           0x0029

#define VSDT            0x00E7
#define AGCREF          0x00B2
#define ACCREF          0x00A0
#define CLPPK           0x0027
#define SPL             0x0023
#define BKS             0x0040
#define BKR             0x0041
#define SDT             0x001B

#define I2C_ID0         0x0000	/* Manufacture ID (0xEC for VPX C4) */
#define I2C_ID1         0x0001	/* VPX PN         (0x80 for VPX C4) */
#define I2C_ID2         0x0002	/* VPX PN         (0x46 for VPX C4) */
#define DEEM            0x0022
#define STS             0x0034
#define LDF             0x0031
#define YNF             0x0030
#define AFEND           0x0033
#define STS             0x0034
#define REFSIG          0x00D8	/* HREF VREF control for VPX C4 */
#define CBM_BRI         0x00E6
#define CBM_CON         0x00E7
#define FORMAT          0x00E8
#define FORMAT_C4	0x00E8  /* for C4 */
#define OFIFO           0x00F0	/* for C4 */
#define OMUX            0x00F1
#define OENA            0x00F2	/* Output Enbale for C4 */

#define VBEG1           0x0088
#define VLINEI1         0x0089
#define VLINEO1         0x008A
#define HBEG1           0x008B
#define HLEN1           0x008C
#define NPIX1           0x008D

#define VBEG2           0x008E
#define VLINEI2         0x008F
#define VLINEO2         0x0090
#define HBEG2           0x0091
#define HLEN2           0x0092
#define NPIX2           0x0093

#define IF1IF2          0x004b

#define CWDWD           0x009A
#define	CWDWD_C4	0x00F0	/* CMD reg for VPX C4 */
#define TVSTD           0x00f2	/* TV STANDARD for VPX C4 */

#define CBM_BRI         0x00E6
#define CBM_CON         0x00E7
#define ACCREF          0x00A0
#define TINT            0x001C
#define FORMAT          0x00E8
#define OMUX            0x00F1
#define OENA            0x00F2

#define I2CRET          15
#define FBTBYTES        0x7FFFF

#define MIX(r,g,b) (((r)*G+(g))*B+(b))

#define R 5                /* number of red shades */
#define G 9                /* number of green shades */
#define B 5                /* number of blue shades */

#define YRG     200
#define XRG     320
#define YRV     240
#define XRV     720
/* Graphics Modes */
#define PMONO   0
#define P332    1
#define P332D   2
#define PHICO   3

#define         REV     "1.0"           /* program revision code           */

#define         SEL_MAX 8               /* number of selections available  */
                                        /* in the main menu.               */
                                        /* This number MUST match the num. */
                                        /* of entries in opt_max[] array   */
#define MEMSEG_DFLT     0xD000
#define GRPSEG_DFLT     0xA000
#define MEMWTH_DFLT     0x0FFF
/* #define PCICBA_DFLT     0x03E0 */
#define PCICBA_DFLT     0x03E4
#define BEBA_DFLT       0x0800

#define VCNF0_REG       0x04    /* Video Config. Settings LB Offset */
#define VCNF1_REG       0x04    /* Video Config. Settings HB Offset */
#define IOIF_REG        0x05    /* I/O Interface Pins Register Offset */

#define SCLW_MSK        0x01    /* mask of the SCLW bit in the IOIF_REG */
#define SDAW_MSK        0x02    /* mask of the SDAW bit in the IOIF_REG */
#define SCLR_MSK        0x08    /* mask of the SCLW bit in the IOIF_REG */
#define SDAR_MSK        0x10    /* mask of the SDAW bit in the IOIF_REG */


#define LOCLK           0
#define HICLK           1
#define LODAT           0
#define HIDAT           1

#define I2C_BUSY        0x00010000
#define I2C_ADR         0
#define I2C_SUBADR      1
#define I2C_DAT         2

#define I2C_SCL         0
#define I2C_SDA         1

#define NO_COLOR_SETTINGS 8             /* Available color controls */
#define NO_COLOR_CONTROLS 7             /* Actual number of color controls */

/* #define MK_FP(seg,off) ((long)(((WORD)(off)) | (((DWORD)((WORD)(seg))) << 16))) */

typedef struct
{
        BYTE bpos;      /* X position of the field on the screen */
        BYTE row;       /* Y position of the field on the screen */
        BYTE size;      /* size of the field, max integer        */
        BYTE scrn;      /* number of the screen                  */
        WORD indx_port; /* index port address                    */
        BYTE indx;      /* index value                           */
        WORD data_port; /* data port address                     */
} REGFIELD;

typedef struct
{
        char    r;
        char    g;
        char    b;
} RGB;

typedef struct CFGSTRUCT
{
        WORD    wPortAddr;
        WORD    wVideoAddr;
        WORD    wCfgFlags;
        WORD    wVideoSource;
        BYTE    bColorSettings[NO_COLOR_SETTINGS];
        BYTE    aReserved[60];
} CFGSTRUCT;

#define MONO_M     1
#define DITHER_M   2

typedef struct VIDEOCFG_S
{
        WORD    psrc   ;
        WORD    pdst   ;
        WORD    ofst   ;
        WORD    mode   ;
        WORD    direction   ;
        WORD    xd     ;
        WORD    yd     ;
        WORD    h      ;
        WORD    w      ;
        WORD    yStart ;
        WORD    rs     ;
        WORD    rd     ;
} VIDEOCFG_S;

#define TUNETYPE 0x61  

