/*
 * Copyright (c) 2000 Naoyuki,Mori.  All rights reserved.
 *                    mori@jp.FreeBSD.org
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint
static const char rcsid[] =
  "$Id: config.c,v 1.6 2000/06/22 12:05:39 toshi Exp $";
#endif /* not lint */

#include <err.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include <pccard/cardinfo.h>
#include <pccard/cis.h>
#include "readcis.h"

#define	  DEF_DEVNAM	"XXX"

static char *
rep_escape(char *moto, char *keyword, char keyword2)
{
	int count;
	char *pt, *pt2, *pt3, *pt4;
	unsigned int flag = 0;

	/* meta_command count */
	pt = moto;
	count = 0;

	while (*pt != '\0') {

		/* order = n^2 */

		pt2 = keyword;
		while (*pt2 != '\0') {
			if (*pt == *pt2)
				count++;
			pt2++;
		}
		pt++;
	}

	/* memory allocate */
	pt3 = malloc(strlen(moto) + count + 1);
	if (pt3 == NULL)
		return (NULL);
	pt4 = pt3;

	/* strings copy */
	pt = moto;
	while (*pt != '\0') {

		pt2 = keyword;
		while (*pt2 != '\0') {
			/* list hit? */
 			if (*pt == *pt2) {
				/* 'no copy' command check */
				if (keyword2 != 0x00)
					*pt4++ = keyword2;
				else
					flag = 1;
				break;
			}
			pt2++;
		}

		/* space cut? */
		if (flag == 0)
			*pt4++ = *pt;
		else
			flag = 0;
		pt++;
	}

	/* final string copy */
	*pt4 = '\0';
	return (pt3);
}

static void
config_scan(int slot, char *devname)
{
	int     fd;
	char    name[64];
	char	*srpstr[] = { "", "#" };
	char	*defstr[] = { "#default", "" };
	char	*strp[3];
	unsigned int flag = 0;
	struct cis *cp;
	struct slotstate st;
	struct cis_config *bk;

	sprintf(name, CARD_DEVICE, slot);
	fd = open(name, O_RDONLY);
	if (fd < 0)
		return;

	if (ioctl(fd, PIOCGSTATE, &st))
		err(1, "ioctl (PIOCGSTATE)");

	if (st.state == filled) {
		cp = readcis(fd);
		if (cp) {
			/* string cording */
			strp[1] = rep_escape(cp->vers , "\\.*()", '\\');
			strp[2] = rep_escape(cp->manuf, "\\.*()", '\\');

			/* card info */
			printf("card \"%s\" \"%s\"", strp[2], strp[1]);

			/* mem free */
			if (strp[1] != NULL)
				free(strp[1]);
			if (strp[2] != NULL)
				free(strp[2]);

			/* add info write */
			if (cp->add_info1 != NULL) {
				strp[0] = rep_escape(cp->add_info1, "\\.*()", '\\');
				printf(" \"%s\"", strp[0]);
				free(strp[0]);
			}
			if (cp->add_info2 != NULL) {
				strp[0] = rep_escape(cp->add_info2, "\\.*()", '\\');
				printf(" \"%s\"", strp[0]);
				free(strp[0]);
			}
			printf("\n");

			/* ID Map List write */	
			bk = cp->conf;
			flag = 0;
			while (bk != NULL) {
				printf("\t%sconfig 0x%02X \"%s\" any %s\n",
				       srpstr[flag], bk->id, devname,
				       defstr[flag]);
				flag = 1;
				bk = bk->next;
			}

			strp[0] = rep_escape(cp->vers, "*.\\()", '\\');
			strp[1] = rep_escape(strp[0], " " , 0x00);

			printf("\tinsert logger -s \"%s inserted\"\n", strp[1]);

			switch (cp->func_id1) {
			case 0x06:
				printf("\tinsert /etc/pccard_ether $device\n");
				break;
			case 0x08:
				printf("\tinsert /etc/pccard_scsi $device\n");
				break;
			default:
				printf("\t#device_id:(0x%02X)\n",
				       cp->func_id1);
				break;
			}

			printf("\tremove logger -s \"%s removed\"\n", strp[1]);

			switch (cp->func_id1) {
			case 0x06:
				printf("\tremove /etc/pccard_ether_remove $device\n");
				break;
			default:
				/* empty */
				break;
			}
			printf("\n");
			if (strp[0] != NULL)
				free(strp[0]);
			if (strp[1] != NULL)
				free(strp[1]);
			freecis(cp);
		}
	}
	close(fd);
}

int
config_main(int argc, char **argv)
{
	int node;

	if (argc >= 2) {
		config_scan(atoi(argv[1]),
			    (argc == 2) ? DEF_DEVNAM : argv[2]);
	} else {
		for (node = 0; node < 8; node++)
			config_scan(node, DEF_DEVNAM);
	}

	return 0;
}
