/**
 *
 * $Id: axis.c,v 1.2 1999/04/15 12:15:27 isizaka Exp $
 *
 * Copyright (C) 1997, Satoshi ISHIZAKA.
 *
 * This file is part of Ngraph.
 *
 * This is free software; you can redistribute it and/or modify it.
 * However, it is prohibited to compile this on the "Windows" environment.
 *
 * Original author: Satoshi ISHIZAKA
 *                  isizaka@msa.biglobe.ne.jp
 **/

/**
 *
 * $Log: axis.c,v $
 * Revision 1.2  1999/04/15 12:15:27  isizaka
 * for release 6.03.01
 *
 * Revision 1.1  1999/03/17 13:46:09  isizaka
 * Initial revision
 *
 *
 **/

#include <math.h>
#include <string.h>
#include "mathfn.h"
#include "axis.h"

#define TRUE  1
#define FALSE 0


double scale(double x)
{
  return pow(10.0,cutdown(log10(fabs(x))));
}

double roundmin(double min,double sc)
{
  return nraise(min/sc)*sc;
}

void getaxispositionfirst(struct axislocal *alocal)
{
  double min,max,inc;
  int numlim1,numlim2,numlim3;

  if (alocal->tighten) {
    numlim1=6;
    numlim2=11;
    numlim3=21;
  } else {
    numlim1=2;
    numlim2=3;
    numlim3=6;
  }

  if ((alocal->atype==AXISNORMAL) || (alocal->atype==AXISLOGBIG)) {
    if (alocal->div<=0) {
      if (alocal->num<=numlim1) alocal->countsend=10;
      else if (alocal->num<=numlim2) alocal->countsend=5;
      else if (alocal->num<=numlim3) alocal->countsend=2;
      else alocal->countsend=1;
    } else alocal->countsend=alocal->div;
    alocal->dposl=alocal->inc*10;
    alocal->posl=roundmin(alocal->posst,alocal->dposl)-alocal->dposl;
    alocal->dposm=alocal->inc;
    alocal->posm=roundmin(alocal->posst,alocal->dposm)-alocal->dposm;
    alocal->countmend=10;
    alocal->countm=
     round((roundmin(alocal->posst,alocal->dposm)-alocal->posl)/alocal->dposm);
    alocal->dposs=alocal->dposm/alocal->countsend;
    alocal->counts=1;
  } else if (alocal->atype==AXISINVERSE) {
    if (alocal->div<=0) {
      if (alocal->num<=numlim1) alocal->countsend=10;
      else if (alocal->num<=numlim2) alocal->countsend=5;
      else if (alocal->num<=numlim3) alocal->countsend=2;
      else alocal->countsend=1;
    } else alocal->countsend=alocal->div;
    if (((alocal->max>alocal->min) && (alocal->min>0))
     || ((alocal->max<alocal->min) && (alocal->min<0))) {
      max=alocal->min;
      min=alocal->max;
      inc=alocal->inc*(-1);
    } else {
      min=alocal->min;
      max=alocal->max;
      inc=alocal->inc;
    }
    alocal->dposm=inc;
    alocal->posm=roundmin(min,alocal->dposm)-alocal->dposm;
    alocal->countmend=(max-alocal->posm)/alocal->dposm;
    alocal->countm=1;
    alocal->dposl=alocal->dposm*alocal->countmend;
    alocal->posl=alocal->posm;
    alocal->dposs=alocal->dposm/alocal->countsend;
    alocal->counts=1;
  } else if (alocal->atype==AXISLOGNORM) {
    if (alocal->div==1) {
      alocal->countsend=1;
      if (alocal->dposm>0) alocal->dposs=9;
      else alocal->dposs=-0.9;
    } else if (alocal->div==2) {
      alocal->countsend=2;
      if (alocal->dposm>0) alocal->dposs=4;
      else alocal->dposs=-0.5;
    } else {
      alocal->countsend=9;
      if (alocal->dposm>0) alocal->dposs=1;
      else alocal->dposs=-0.1;
    }
    alocal->dposl=alocal->inc*10;
    alocal->posl=roundmin(alocal->posst,alocal->dposl)-alocal->dposl;
    alocal->dposm=alocal->inc;
    alocal->posm=roundmin(alocal->posst,alocal->dposm)-alocal->dposm;
    alocal->countmend=10;
    alocal->countm=
      round((roundmin(alocal->posst,alocal->dposm)-alocal->posl)/alocal->dposm);
    alocal->counts=1;
  } else if (alocal->atype==AXISLOGSMALL) {
    if (alocal->div<=0) {
      if (alocal->num<=numlim1) alocal->countsend=10;
      else if (alocal->num<=numlim2) alocal->countsend=5;
      else if (alocal->num<=numlim3) alocal->countsend=2;
      else alocal->countsend=1;
    } else alocal->countsend=alocal->div;
    alocal->dposl=alocal->inc;
    alocal->posl=roundmin(alocal->posst,alocal->dposl)-alocal->dposl;
    if (alocal->dposl>0) alocal->dposm=1;
    else alocal->dposm=-0.1;
    alocal->posm=alocal->posl;
    alocal->countmend=9;
    alocal->countm=1;
    alocal->dposs=1.0/alocal->countsend;
    alocal->counts=1;
  }    
  alocal->count=0;
}

int getaxisposition(struct axislocal *alocal,double *po)
{
  int rcode;
  double dd;

  if (alocal->counts>=alocal->countsend) {
    if (alocal->atype==AXISLOGSMALL) 
      *po=alocal->posl+log10(1.0+alocal->countm*alocal->dposm);
    else *po=alocal->posm+alocal->dposm;
    alocal->posm=*po;
    alocal->counts=1;
    rcode=2;
    if (alocal->countm==alocal->countmend) {
      *po=alocal->posl+alocal->dposl;
      alocal->posl=*po;
      alocal->countm=1;
      rcode=3;
      if (alocal->atype==AXISINVERSE) {
        if (((alocal->dposm>=0) && (alocal->min>=0))
         || ((alocal->dposm<0) && (alocal->min<0))) dd=10;
        else dd=0.1;
        alocal->dposl*=dd;
        alocal->dposm*=dd;
        alocal->dposs*=dd;
        alocal->countmend=-1;
      }
    } else alocal->countm++;
  } else {
    rcode=1;
    if (alocal->atype==AXISLOGNORM) 
      *po=alocal->posm+log10(1.0+alocal->counts*alocal->dposs);
    else if (alocal->atype==AXISLOGSMALL)
      *po=log10(pow(10.0,alocal->posm)
         +alocal->counts*alocal->dposs*pow(10.0,alocal->posl)*alocal->dposm);
    else *po=alocal->posm+alocal->counts*alocal->dposs;
    alocal->counts++;
  }
  if (fabs(*po/alocal->dposs)<1E-14) *po=0;
  if ((*po-alocal->posst)*(*po-alocal->posed)>0) {
    if (alocal->dposm>=0) {
      if (((alocal->posst<=alocal->posed) && (*po<alocal->posst))
       || ((alocal->posst>=alocal->posed) && (*po<alocal->posed))) rcode=-1;
      else rcode=-2;
    } else {
      if (((alocal->posst<=alocal->posed) && (*po>alocal->posed))
       || ((alocal->posst>=alocal->posed) && (*po>alocal->posst))) rcode=-1;
      else rcode=-2;
    }
  }
  if ((alocal->atype==AXISINVERSE) && (rcode>=0)) *po=1 / *po;
  alocal->count++;
  if (alocal->count>=10000) rcode=-2;
  return rcode;
}

int getaxispositionini(struct axislocal *alocal,
                 int type,double min,double max,double inc,int div,int tighten)
{
  double po;
  int rcode;
  int num;

  if (min==max) return -1;
  if (inc==0) return -1;
  if (type==1) {
    if ((min<=0) || (max<=0)) return -1;
    if (fabs(inc)==10) alocal->atype=AXISLOGNORM;
    else if (fabs(inc)==1) alocal->atype=AXISLOGSMALL;
    else alocal->atype=AXISLOGBIG;
    alocal->min=log10(min);
    alocal->max=log10(max);
    alocal->inc=log10(fabs(inc));
    if (alocal->atype==AXISLOGSMALL) alocal->inc=1;
  } else if (type==2) {
    if (min*max<=0) return -1;
    alocal->atype=AXISINVERSE;
    alocal->min=min;
    alocal->max=max;
    alocal->inc=inc;
  } else {
    alocal->atype=AXISNORMAL;
    alocal->min=min;
    alocal->max=max;
    alocal->inc=inc;
  }
  if (alocal->max<alocal->min) alocal->inc=-fabs(alocal->inc);
  else alocal->inc=fabs(alocal->inc);
  alocal->div=div;
  alocal->posst=alocal->min;
  alocal->posed=alocal->max;
  alocal->num=100;
  alocal->tighten=tighten;
  getaxispositionfirst(alocal);
  num=0;
  while ((rcode=getaxisposition(alocal,&po))!=-2) {
    if (rcode>=2) num++;
  }
  alocal->num=num;
  if (alocal->count>1000) return -1;
  getaxispositionfirst(alocal);
  return 0;
}


