/**
 *
 * $Id: ioutil.h,v 1.1 1999/03/17 13:46:09 isizaka Exp $
 *
 * Copyright (C) 1997, Satoshi ISHIZAKA.
 *
 * This file is part of Ngraph.
 *
 * This is free software; you can redistribute it and/or modify it.
 * However, it is prohibited to compile this on the "Windows" environment.
 *
 * Original author: Satoshi ISHIZAKA
 *                  isizaka@msa.biglobe.ne.jp
 **/

/**
 *
 * $Log: ioutil.h,v $
 * Revision 1.1  1999/03/17 13:46:09  isizaka
 * Initial revision
 *
 *
 **/

#include <sys/stat.h>
#include <dirent.h>

#ifndef WINDOWS
#define DIRSEP '/'
#define PATHSEP ":"
#define CONFSEP "/"
#define CONFTOP "/."
typedef int HANDLE;
#define NOHANDLE -1
#define NFMODE 384
#else
#define DIRSEP '/'
#define PATHSEP ";"
#define CONFSEP "/"
#define CONFTOP "/_"
typedef void *HANDLE;
#define NOHANDLE NULL
#define NFMODE S_IREAD|S_IWRITE
#endif

void changefilename(char *name);
#ifdef WINDOWS
void unchangefilename(char *name);
#endif
char *getfullpath(char *name);
char *getrelativepath(char *name);
char *getbasename(char *name);
char *getextention(char *name);
char *getfilename(char *dir,char *sep,char *file);
int findfilename(char *dir,char *sep,char *file);
char *ngetcwd(void);
char *nsearchpath(char *path,char *name,int shellscript);
int nglob(char *path,char ***namelist);
int fgetline(FILE *fp,char **buf);
int fgetnline(FILE *fp,char *buf,int len);
int nisatty(HANDLE fd);
FILE *nfopen(char *filename,const char *mode);
HANDLE nopen(char *path,int access,int mode);
void nclose(HANDLE fd);
HANDLE nredirect(int fd,HANDLE newfd);
void nredirect2(int fd,HANDLE savefd);
void nlseek(HANDLE fd,long offset,int fromwhere);
int nread(HANDLE fd,char *buf,unsigned len);
int nwrite(HANDLE fd,char *buf,unsigned len);
HANDLE stdinfd(void);
HANDLE stdoutfd(void);
HANDLE stderrfd(void);
