/**
 *
 * $Id: mathfn.h,v 1.1 1999/03/17 13:46:09 isizaka Exp $
 *
 * Copyright (C) 1997, Satoshi ISHIZAKA.
 *
 * This file is part of Ngraph.
 *
 * This is free software; you can redistribute it and/or modify it.
 * However, it is prohibited to compile this on the "Windows" environment.
 *
 * Original author: Satoshi ISHIZAKA
 *                  isizaka@msa.biglobe.ne.jp
 **/

/**
 *
 * $Log: mathfn.h,v $
 * Revision 1.1  1999/03/17 13:46:09  isizaka
 * Initial revision
 *
 *
 **/

#define MPI 3.1415926535897932385
#define MEXP1 2.71828182845905
#define MEULER 0.57721566490153286

typedef double vector[11];
typedef vector matrix[11];

double cutdown(double x);
double nraise(double x);
double frand(double a);
int round(double x);
int matinv(int dim,matrix m,matrix mi);
int matsolv(int dim,matrix a,vector b,vector x);
int gamma2(double x,double *val);
int exp1(double x,double *val);
int icgamma(double mu,double x,double *val);
int erfc1(double x,double *val);
int qinv1(double x,double *val);
int beta(double p,double q,double *val);
int jbessel(int n,double x,double *val);
int ybessel(int n,double x,double *val);
int legendre(int n,double x,double *val);
int laguer(int n,double alp,double x,double *val);
int hermite(int n,double x,double *val);
int chebyshev(int n,double x,double *val);
