/**
 *
 * $Id: ntime.c,v 1.1 1999/03/17 13:46:09 isizaka Exp $
 *
 * Copyright (C) 1997, Satoshi ISHIZAKA.
 *
 * This file is part of Ngraph.
 *
 * This is free software; you can redistribute it and/or modify it.
 * However, it is prohibited to compile this on the "Windows" environment.
 *
 * Original author: Satoshi ISHIZAKA
 *                  isizaka@msa.biglobe.ne.jp
 **/

/**
 *
 * $Log: ntime.c,v $
 * Revision 1.1  1999/03/17 13:46:09  isizaka
 * Initial revision
 *
 *
 **/

#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include "object.h"
#include "ntime.h"

char *weekstr[7]={"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};
char *monthstr[12]={"Jan","Feb","Mar","Apr","May","Jun",
                    "Jul","Aug","Sep","Oct","Nov","Dec"};

char *ndate(time_t *timep,int style)
{
  struct tm *ltime;
  char *c;

  ltime=localtime(timep);
  if ((c=memalloc(16))==NULL) return NULL;
  switch (style) {
  case 1:
    sprintf(c,"%d-%d-%d",ltime->tm_mon+1,ltime->tm_mday,1900+ltime->tm_year);
    break;
  case 2:
    sprintf(c,"%s %d %d",monthstr[ltime->tm_mon],
                         ltime->tm_mday,1900+ltime->tm_year);
    break;
  case 3:
    sprintf(c,"%d-%d-%d",ltime->tm_mday,ltime->tm_mon+1,1900+ltime->tm_year);
    break;
  case 4:
    sprintf(c,"%d/%d/%d",ltime->tm_mon+1,ltime->tm_mday,1900+ltime->tm_year);
    break;
  default:
    sprintf(c,"%s %s %d %d",weekstr[ltime->tm_wday],monthstr[ltime->tm_mon],
                              ltime->tm_mday,1900+ltime->tm_year);
    break;
  }
  return c;
}

char *ntime(time_t *timep,int style)
{
  struct tm *ltime;
  char *c;

  ltime=localtime(timep);
  if ((c=memalloc(12))==NULL) return NULL;
  switch (style) {
  case 1:
    if (ltime->tm_hour<12)
      sprintf(c,"%02d:%02d:%02d am",ltime->tm_hour,
                                    ltime->tm_min,ltime->tm_sec);
    else
      sprintf(c,"%02d:%02d:%02d pm",ltime->tm_hour-12,
                                    ltime->tm_min,ltime->tm_sec);
    break;
  case 2:
    sprintf(c,"%02d:%02d",ltime->tm_hour,ltime->tm_min);
    break;
  case 3:
    if (ltime->tm_hour<12)
      sprintf(c,"%02d:%02d am",ltime->tm_hour,ltime->tm_min);
    else
      sprintf(c,"%02d:%02d pm",ltime->tm_hour-12,ltime->tm_min);
    break;
  default:
    sprintf(c,"%02d:%02d:%02d",ltime->tm_hour,ltime->tm_min,ltime->tm_sec);
    break;
  }
  return c;
}

int gettimeval(char *s,time_t *time)
{
  char *endptr;
  struct tm tm;
  int year;

  tm.tm_mday=strtol(s,&endptr,10);
  if (endptr[0]!='-') return -1;
  s=endptr+1;
  tm.tm_mon=strtol(s,&endptr,10)-1;
  if (endptr[0]!='-') return -1;
  s=endptr+1;
  year=strtol(s,&endptr,10)-1900;
  if (year<0) year+=1900;
  tm.tm_year=year;
  if (endptr[0]!=' ') return -1;
  s=endptr+1;
  tm.tm_hour=strtol(s,&endptr,10);
  if (endptr[0]!=':') return -1;
  s=endptr+1;
  tm.tm_min=strtol(s,&endptr,10);
  if (endptr[0]!=':') return -1;
  s=endptr+1;
  tm.tm_sec=strtol(s,&endptr,10);
  tm.tm_isdst=0;
  *time=mktime(&tm);
  return 0;
}

int gettimeval2(char *s,time_t *time)
{
  char *endptr;
  struct tm tm;

  tm.tm_year=strtol(s,&endptr,10)-1900;
  if (endptr[0]!='-') return -1;
  s=endptr+1;
  tm.tm_mon=strtol(s,&endptr,10)-1;
  if (endptr[0]!='-') return -1;
  s=endptr+1;
  tm.tm_mday=strtol(s,&endptr,10);
  if (endptr[0]!=' ') return -1;
  s=endptr+1;
  tm.tm_hour=strtol(s,&endptr,10);
  if (endptr[0]!=':') return -1;
  s=endptr+1;
  tm.tm_min=strtol(s,&endptr,10);
  if (endptr[0]!=':') return -1;
  s=endptr+1;
  tm.tm_sec=strtol(s,&endptr,10);
  tm.tm_isdst=0;
  *time=mktime(&tm);
  return 0;
}

