/**
 *
 * $Id: object.h,v 1.3 1999/04/15 12:15:27 isizaka Exp $
 *
 * Copyright (C) 1997, Satoshi ISHIZAKA.
 *
 * This file is part of Ngraph.
 *
 * This is free software; you can redistribute it and/or modify it.
 * However, it is prohibited to compile this on the "Windows" environment.
 *
 * Original author: Satoshi ISHIZAKA
 *                  isizaka@msa.biglobe.ne.jp
 **/

/**
 *
 * $Log: object.h,v $
 * Revision 1.3  1999/04/15 12:15:27  isizaka
 * for release 6.03.01
 *
 * Revision 1.2  1999/04/11 06:08:10  isizaka
 * *** empty log message ***
 *
 * Revision 1.1  1999/03/17 13:46:09  isizaka
 * Initial revision
 *
 *
 **/

#ifdef DEBUG
extern struct plist *memallocroot;

struct plist;
struct plist {
    void *val;
    struct plist *next;
};
#endif

struct objlist;
struct objtable;

typedef
  int (*Proc)(struct objlist *obj,char *inst,char *rval,int argc,char **argv);

typedef
  int (*DoneProc)(struct objlist *obj,void *local);

struct objtable {
    char *name;
    int type;
    int attrib;
    Proc proc;
    void *arglist;
    int offset;
};

struct objlist {
    int id;
    int curinst;
    int lastinst;
    int lastoid;
    char *name;
    char *alias;
    char *ver;
    int tblnum;
    struct objtable *table;
    int size;
    int errnum;
    char **errtable;
    void *root;
    void *root2;
    int lastinst2;
    struct objlist *parent;
    struct objlist *next;
    int idp,oidp,nextp;
    void *local;
    DoneProc doneproc;
};

struct narray {
    unsigned int size;
    unsigned int base;
    unsigned int num;
    void *data;
};

struct loopproc;
struct loopproc {
  struct loopproc *next;
  char *objname;
  char *evname;
  struct objlist *obj;
  int idn;
  char *inst;
  void *local;
};
extern struct loopproc *looproot;

#define NVOID 0
#define NBOOL 1
#define NCHAR 2
#define NINT 3
#define NDOUBLE 4
#define NSTR 5
#define NPOINTER 6
#define NIARRAY 7
#define NDARRAY 8
#define NSARRAY 9
#define NENUM 10
#define NOBJ  11
#define NLABEL 12
#define NVFUNC 20
#define NBFUNC 21
#define NCFUNC 22
#define NIFUNC 23
#define NDFUNC 24
#define NSFUNC 25
#define NIAFUNC 26
#define NDAFUNC 27
#define NSAFUNC 28

#define NREAD 1
#define NWRITE 2
#define NEXEC 4

#define ERRUNKNOWN 0
#define ERRHEAP 1
#define ERRPARENT 2
#define ERRDUP 3
#define ERROBJNUM 4
#define ERRINSTNUM 5
#define ERROBJFOUND 6
#define ERRVALFOUND 7
#define ERRNONEXT 8
#define ERRNOID 9
#define ERRIDFOUND 10
#define ERROIDFOUND 11
#define ERRNMFOUND 12
#define ERRDESTRUCT 13
#define ERRPERMISSION 14
#define ERROBJCINST 15
#define ERRNOINST 16
#define ERRILOBJ 17
#define ERRILINST 18
#define ERRFIELD 19
#define ERROEXTARG 20
#define ERROSMLARG 21
#define ERROVALUE  22
#define ERROVERWRITE 23

extern char errormsg1[256];
extern char errormsg2[256];
extern char errormsg[256];

extern int (*getstdin)(void);
extern int (*putstdout)(char *s);
extern int (*putstderr)(char *s);
extern int (*printfstdout)(char *fmt,...);
extern int (*printfstderr)(char *fmt,...);
extern int (*ninterrupt)(void);
extern int (*inputyn)(char *mes);
extern void (*ndisplaydialog)(char *str);
extern void (*ndisplaystatus)(char *str);

struct savedstdio {
  int (*getstdin)(void);
  int (*putstdout)(char *s);
  int (*putstderr)(char *s);
  int (*printfstdout)(char *fmt,...);
  int (*printfstderr)(char *fmt,...);
  int (*ninterrupt)(void);
  int (*inputyn)(char *mes);
  void (*ndisplaydialog)(char *str);
  void (*ndisplaystatus)(char *str);
};

extern struct savedstdio stdiosave;

extern int vinterrupt(void);
extern int vinputyn(char *mes);
extern int seputs(char *s);
extern int seprintf(char *fmt,...);

void error(struct objlist *obj,int code);
void error2(struct objlist *obj,int code,char *mes);
void error3(struct objlist *obj,int code,int num);

void ignorestdio(struct savedstdio *save);
void restorestdio(struct savedstdio *save);
void savestdio(struct savedstdio *save);
void loadstdio(struct savedstdio *save);

void *memalloc(size_t size);
void *memrealloc(void *ptr,size_t size);
void memfree(void *ptr);

void arrayinit(struct narray *array,unsigned int base);
struct narray *arraynew(unsigned int base);
void *arraydata(struct narray *array);
unsigned int arraynum(struct narray *array);
unsigned int arraybase(struct narray *array);
void arraydel(struct narray *array);
void arraydel2(struct narray *array);
void arrayfree(struct narray *array);
void arrayfree2(struct narray *array);
struct narray *arrayadd(struct narray *array,void *val);
struct narray *arrayadd2(struct narray *array,char **val);
struct narray *arrayins(struct narray *array,void *val,unsigned int idx);
struct narray *arrayins2(struct narray *array,char **val,unsigned int idx);
struct narray *arrayndel(struct narray *array,unsigned int idx);
struct narray *arrayndel2(struct narray *array,unsigned int idx);
struct narray *arrayput(struct narray *array,void *val,unsigned int idx);
struct narray *arrayput2(struct narray *array,char **val,unsigned int idx);
void *arraynget(struct narray *array,unsigned int idx);
void *arraylast(struct narray *array);

int getargc(char **arg);
char **arg_add(char ***arg,void *ptr);
char **arg_add2(char ***arg,int argc,...);
void arg_del(char **arg);

void registerevloop(char *objname,char *evname,
                    struct objlist *obj,int idn,char *inst,void *local);
void unregisterevloop(struct objlist *obj,int idn,char *inst);
void unregisterallevloop(void);
void eventloop(void);

struct objlist *chkobjroot(void);
void *addobject(char *name,char *alias,char *parentname,
                char *ver,int tblnum,struct objtable *table,
                int errnum,char **errtable,void *local,DoneProc doneproc);
void hideinstance(struct objlist *obj);
void recoverinstance(struct objlist *obj);
struct objlist *chkobject(char *name);
void *chkobjectlocal(struct objlist *obj);
int chkobjectid(struct objlist *obj);
char *chkobjectname(struct objlist *obj);
char *chkobjectalias(struct objlist *obj);
struct objlist *chkobjparent(struct objlist *obj);
int chkobjchild(struct objlist *parent,struct objlist *child);
char *chkobjver(struct objlist *obj);
int chkobjsize(struct objlist *obj);
int chkobjlastinst(struct objlist *obj);
int chkobjcurinst(struct objlist *obj);
int chkobjoffset(struct objlist *obj,char *name);
int chkobjoffset2(struct objlist *obj,int tblpos);
int chkobjtblpos(struct objlist *obj,char *name,struct objlist **robj);
char *chkobjinstoid(struct objlist *obj,int oid);
char *chkobjinst(struct objlist *obj,int id);
int chkobjid(struct objlist *obj,int id);
int chkobjoid(struct objlist *obj,int oid);
int chkobjname(struct objlist *obj,int *id,char *name);
int chkobjfieldnum(struct objlist *obj);
char *chkobjfieldname(struct objlist *obj,int num);
int chkobjfield(struct objlist *obj,char *name);
int chkobjperm(struct objlist *obj,char *name);
int chkobjfieldtype(struct objlist *obj,char *name);
char *chkobjarglist(struct objlist *obj,char *name);

struct objlist *getobject(char *name);
char *getobjver(char *name);
char *getobjectname(struct objlist *obj);
int getobjcurinst(struct objlist *obj);
int getobjlastinst(struct objlist *obj);
int getobjoffset(struct objlist *obj,char *name);
int getobjtblpos(struct objlist *obj,char *name,struct objlist **robj);
char *getobjinstoid(struct objlist *obj,int oid);
char *getobjinst(struct objlist *obj,int id);
int getobjname(struct objlist *obj,int *id,char *name);
int getobjid(struct objlist *obj,int id);
int getobjoid(struct objlist *obj,int oid);
int getobjfield(struct objlist *obj,char *name);

int _putobj(struct objlist *obj,char *vname,char *inst,void *val);
int _getobj(struct objlist *obj,char *vname,char *inst,void *val);
int _exeparent(struct objlist *obj,char *vname,char *inst,char *rval,
               int argc,char **argv);
int _exeobj(struct objlist *obj,char *vname,char *inst,int argc,char **argv);
int __exeobj(struct objlist *obj,int idn,char *inst,int argc,char **argv);
int _newobj(struct objlist *obj);
int _delobj(struct objlist *obj,int delid);
int copyobj(struct objlist *obj,char *vname,int did,int sid);
int _copyobj(struct objlist *obj,int did,int sid);
int newobj(struct objlist *obj);
int delobj(struct objlist *obj,int delid);
void delchildobj(struct objlist *parent);
int putobj(struct objlist *obj,char *vname,int id,void *val);
int getobj(struct objlist *obj,char *vname,int id,
           int argc,char **argv,void *val);
int exeobj(struct objlist *obj,char *vname,int id,int argc,char **argv);
int moveobj(struct objlist *obj,int did,int sid);
int moveupobj(struct objlist *obj,int id);
int movetopobj(struct objlist *obj,int id);
int movedownobj(struct objlist *obj,int id);
int movelastobj(struct objlist *obj,int id);
int exchobj(struct objlist *obj,int id1,int id2);
char *saveobj(struct objlist *obj,int id);
char *restoreobj(struct objlist *obj,int id,char *image);

int chkilist(struct objlist *obj,char *ilist,struct narray *iarray,int def,int *spc);
int getilist(struct objlist *obj,char *ilist,struct narray *iarray,int def,int *spc);
int chkobjilist(char *s,struct objlist **obj,struct narray *iarray,
                int def,int *spc);
int getobjilist(char *s,struct objlist **obj,struct narray *iarray,
                int def,int *spc);
int chkobjilist2(char **s,struct objlist **obj,struct narray *iarray,
                 int def);
int getobjilist2(char **s,struct objlist **obj,struct narray *iarray,
                 int def);
char *mkobjlist(struct objlist *obj,char *objname,int id,char *field,int oid);
struct objlist *getobjlist(char *list,int *id,char **field,int *oid);
char *chgobjlist(char *olist);
char *getvaluestr(struct objlist *obj,char *field,void *val,int cr,int quote);
int getargument(int type,char *arglist,char *val,int *argc,char ***rargv);
void freeargument(int type,char *arglist,int argc,char **argv,int full);
int isobject(char **s);

int schkobjfield(struct objlist *obj,int id,char *field,char *arg,
                 char **valstr,int limittype,int cr,int quote);
int sgetobjfield(struct objlist *obj,int id,char *field,char *arg,
                 char **valstr,int limittype,int cr,int quote);
int schkfield(struct objlist *obj,int id,char *arg,char **valstr,
              int limittype,int cr,int quote);
int sgetfield(struct objlist *obj,int id,char *arg,char **valstr,
              int limittype,int cr,int quote);
struct narray *sgetobj(char *arg,int limittype,int cr,int quote);
int sputobjfield(struct objlist *obj,int id,char *field,char *arg);
int sputfield(struct objlist *obj,int id,char *arg);
int sputobj(char *arg);
int sexeobjfield(struct objlist *obj,int id,char *field,char *arg);
int sexefield(struct objlist *obj,int id,char *arg);
int sexeobj(char *arg);
char *getuniqname(struct objlist *obj,char *prefix,char sep);
