/**
 *
 * $Id: omerge.c,v 1.2 1999/04/15 12:15:27 isizaka Exp $
 *
 * Copyright (C) 1997, Satoshi ISHIZAKA.
 *
 * This file is part of Ngraph.
 *
 * This is free software; you can redistribute it and/or modify it.
 * However, it is prohibited to compile this on the "Windows" environment.
 *
 * Original author: Satoshi ISHIZAKA
 *                  isizaka@msa.biglobe.ne.jp
 **/

/**
 *
 * $Log: omerge.c,v $
 * Revision 1.2  1999/04/15 12:15:27  isizaka
 * for release 6.03.01
 *
 * Revision 1.1  1999/03/17 13:46:09  isizaka
 * Initial revision
 *
 *
 **/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <fcntl.h>
#include <utime.h>
#include <time.h>
#ifndef WINDOWS
#include <unistd.h>
#else
#include <io.h>
#endif
#include "ngraph.h"
#include "object.h"
#include "nstring.h"
#include "ntime.h"
#include "ioutil.h"
#include "gra.h"
#include "oroot.h"
#include "odraw.h"

#define NAME "merge"
#define PARENT "draw"
#define VERSION  "1.00.00"
#define TRUE  1
#define FALSE 0

#define ERRFILE 100
#define ERROPEN 101
#define ERRGRA  102
#define ERRGRAFM 103

#define ERRNUM 4

char *mergeerrorlist[ERRNUM]={
  "GRA file is not specified.",
  "I/O error: open file",
  "not GRA file",
  "illegal GRA format"
};

struct mergelocal {
  FILE *storefd;
  int endstore;
};

int mergeinit(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  int zm,greek;
  struct mergelocal *mergelocal;

  if (_exeparent(obj,(char *)argv[1],inst,rval,argc,argv)) return 1;
  zm=10000;
  greek=TRUE;
  if (_putobj(obj,"zoom",inst,&zm)) return 1;
  if (_putobj(obj,"symbol_greek",inst,&greek)) return 1;
  if ((mergelocal=memalloc(sizeof(struct mergelocal)))==NULL) goto errexit;
  if (_putobj(obj,"_local",inst,mergelocal)) goto errexit;
  mergelocal->storefd=NULL;
  mergelocal->endstore=FALSE;
  return 0;

errexit:
  memfree(mergelocal);
  return 1;
}

int mergedone(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  if (_exeparent(obj,(char *)argv[1],inst,rval,argc,argv)) return 1;
  return 0;
}

int mergedraw(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  int GC;
  char *file,*graf;
  struct objlist *sys;
  FILE *fd;
  char *buf;
  int lm,tm,zm;
  int newgra,rcode,greek;

  if (_exeparent(obj,(char *)argv[1],inst,rval,argc,argv)) return 1;
  _getobj(obj,"GC",inst,&GC);
  if (GC<0) return 0;
  _getobj(obj,"file",inst,&file);
  _getobj(obj,"left_margin",inst,&lm);
  _getobj(obj,"top_margin",inst,&tm);
  _getobj(obj,"zoom",inst,&zm);
  _getobj(obj,"symbol_greek",inst,&greek);

  if (file==NULL) {
    error(obj,ERRFILE);
    return 1;
  }
  if ((sys=getobject("system"))==NULL) return 1;
  if (getobj(sys,"GRAF",0,0,NULL,&graf)) return 1;
  if ((fd=nfopen(file,"rt"))==NULL) {
    error2(obj,ERROPEN,file);
    return 1;
  }

  if ((rcode=fgetline(fd,&buf))==1) error2(obj,ERRGRA,file);
  if (rcode!=0) {
    fclose(fd);
    return 1;
  }
  if (strcmp(graf,buf)==0) newgra=TRUE;
  else if (strcmp(" Ngraph GRA file",buf)==0) newgra=FALSE;
  else {
    error2(obj,ERRGRA,file);
    memfree(buf);
    fclose(fd);
    return 1;
  }
  memfree(buf);
  if (!newgra) {
    if ((rcode=fgetline(fd,&buf))==1) error2(obj,ERRGRA,file);
    memfree(buf);
    if (rcode!=0) {
      fclose(fd);
      return 1;
    }
  }
  while ((rcode=fgetline(fd,&buf))!=1) {
    if (rcode==-1) {
      fclose(fd);
      return 1;
    }
    if (newgra) rcode=GRAinput(GC,buf,lm,tm,zm);
    else rcode=GRAinputold(GC,buf,lm,tm,zm,greek);
    if (!rcode) {
      error2(obj,ERRGRAFM,buf);
      memfree(buf);
      fclose(fd);
      return 1;
    }
    memfree(buf);
  }
  fclose(fd);
  GRAaddlist(GC,obj,inst,(char *)argv[0],"redraw");
  return 0;
}

int mergeredraw(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  int redrawf;
  int GC;

  if (_exeparent(obj,(char *)argv[1],inst,rval,argc,argv)) return 1;
  _getobj(obj,"redraw_flag",inst,&redrawf);
  if (redrawf) mergedraw(obj,inst,rval,argc,argv);
  else {
    _getobj(obj,"GC",inst,&GC);
    if (GC<0) return 0;
    GRAaddlist(GC,obj,inst,(char *)argv[0],(char *)argv[1]);
  }
  return 0;
}

int mergefile(struct objlist *obj,char *inst,char *rval,
            int argc,char **argv)
{
  struct objlist *sys;
  int ignorepath;
  char *file,*file2;

  sys=getobject("system");
  getobj(sys,"ignore_path",0,0,NULL,&ignorepath);
  if (!ignorepath) return 0;
  file=(char *)(argv[2]);
  file2=getbasename(file);
  memfree(file);
  argv[2]=file2;
  return 0;
}

int mergetime(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  char *file;
  struct stat buf;
  int style;

  memfree(*(char **)rval);
  *(char **)rval=NULL;
  _getobj(obj,"file",inst,&file);
  if (file==NULL) return 0;
  if (stat(file,&buf)!=0) return 1;
  style=*(int *)(argv[2]);
  *(char **)rval=ntime(&(buf.st_mtime),style);
  return 0;
}

int mergedate(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  char *file;
  struct stat buf;
  int style;

  memfree(*(char **)rval);
  *(char **)rval=NULL;
  _getobj(obj,"file",inst,&file);
  if (file==NULL) return 0;
  if (stat(file,&buf)!=0) return 1;
  style=*(int *)(argv[2]);
  *(char **)rval=ndate(&(buf.st_mtime),style);
  return 0;
}

int mergestore(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  struct mergelocal *mergelocal;
  char *file,*base,*date,*time;
  int style;
  char *buf;
  char *argv2[2];

  memfree(*(char **)rval);
  *(char **)rval=NULL;
  _getobj(obj,"_local",inst,&mergelocal);
  if (mergelocal->endstore) {
    mergelocal->endstore=FALSE;
    return 1;
  } else if (mergelocal->storefd==NULL) {
    _getobj(obj,"file",inst,&file);
    if (file==NULL) return 1;
    style=3;
    argv2[0]=(char *)&style;
    argv2[1]=NULL;
    if (_exeobj(obj,"date",inst,1,argv2)) return 1;
    style=0;
    argv2[0]=(char *)&style;
    argv2[1]=NULL;
    if (_exeobj(obj,"time",inst,1,argv2)) return 1;
    _getobj(obj,"date",inst,&date);
    _getobj(obj,"time",inst,&time);
    if ((base=getbasename(file))==NULL) return 1;
    if ((mergelocal->storefd=nfopen(file,"rt"))==NULL) {
      memfree(base);
      return 1;
    }
    if ((buf=memalloc(strlen(file)+50))==NULL) {
      fclose(mergelocal->storefd);
      mergelocal->storefd=NULL;
      memfree(base);
      return 1;
    }
    sprintf(buf,"merge::load_data '%s' '%s %s' <<'[EOF]'",base,date,time);
    memfree(base);
    *(char **)rval=buf;
    return 0;
  } else {
    if (fgetline(mergelocal->storefd,&buf)!=0) {
      fclose(mergelocal->storefd);
      mergelocal->storefd=NULL;
      if ((buf=memalloc(6))==NULL) return 1;
      strcpy(buf,"[EOF]\n");
      mergelocal->endstore=TRUE;
      *(char **)rval=buf;
      return 0;
    } else {
      *(char **)rval=buf;
      return 0;
    }
  }
}

int mergeload(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  char *s;
  int len;
  char *file,*fullname,*oldfile,*mes;
  time_t ftime;
  int mkdata;
  char buf[2];
  FILE *fp;
  struct utimbuf tm;

  s=(char *)argv[2];
  if ((file=getitok2(&s,&len," \t"))==NULL) return 1;
  if ((fullname=getfullpath(file))==NULL) {
    memfree(file);
    return 1;
  }
  _getobj(obj,"file",inst,&oldfile);
  memfree(oldfile);
  _putobj(obj,"file",inst,fullname);
  if (gettimeval(s,&ftime)) {
    memfree(file);
    return 1;
  }
  if (access(file,04)!=0) mkdata=TRUE;
  else {
    if ((mes=memalloc(strlen(file)+256))==NULL) {
      memfree(file);
      return 1;
    }
    sprintf(mes,"`%s' Overwrite existing file?",file);
    mkdata=inputyn(mes);
    memfree(mes);
  }
  if (mkdata) {
    if ((fp=nfopen(file,"wt"))==NULL) {
      error2(obj,ERROPEN,file);
      memfree(file);
      return 1;
    }
    while (nread(stdinfd(),buf,1)==1) fputc(buf[0],fp);
    fclose(fp);
    tm.actime=ftime;
    tm.modtime=ftime;
    utime(file,&tm);
  }
  memfree(file);
  return 0;
}

int mergestoredum(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  struct mergelocal *mergelocal;
  char *file,*base,*date,*time;
  int style;
  char *buf;
  char *argv2[2];

  memfree(*(char **)rval);
  *(char **)rval=NULL;
  _getobj(obj,"_local",inst,&mergelocal);
  if (mergelocal->endstore) {
    mergelocal->endstore=FALSE;
    return 1;
  } else {
    _getobj(obj,"file",inst,&file);
    if (file==NULL) return 1;
    style=3;
    argv2[0]=(char *)&style;
    argv2[1]=NULL;
    if (_exeobj(obj,"date",inst,1,argv2)) return 1;
    style=0;
    argv2[0]=(char *)&style;
    argv2[1]=NULL;
    if (_exeobj(obj,"time",inst,1,argv2)) return 1;
    _getobj(obj,"date",inst,&date);
    _getobj(obj,"time",inst,&time);
    if ((base=getbasename(file))==NULL) return 1;
    if ((buf=memalloc(strlen(file)+50))==NULL) {
      mergelocal->storefd=NULL;
      memfree(base);
      return 1;
    }
    sprintf(buf,"merge::load_dummy '%s' '%s %s'\n",base,date,time);
    memfree(base);
    *(char **)rval=buf;
    mergelocal->endstore=TRUE;
    return 0;
  }
}

int mergeloaddum(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  char *s;
  int len;
  char *file,*fullname,*oldfile;

  s=(char *)argv[2];
  if ((file=getitok2(&s,&len," \t"))==NULL) return 1;
  if ((fullname=getfullpath(file))==NULL) {
    memfree(file);
    return 1;
  }
  _getobj(obj,"file",inst,&oldfile);
  memfree(oldfile);
  _putobj(obj,"file",inst,fullname);
  return 0;
}


#define TBLNUM 19

struct objtable merge[TBLNUM] = {
  {"init",NVFUNC,NEXEC,mergeinit,NULL,0},
  {"done",NVFUNC,NEXEC,mergedone,NULL,0},
  {"next",NPOINTER,0,NULL,NULL,0},
  {"file",NSTR,NREAD|NWRITE,mergefile,NULL,0},
  {"save_path",NENUM,NREAD|NWRITE,NULL,pathchar,0},
  {"top_margin",NINT,NREAD|NWRITE,NULL,NULL,0},
  {"left_margin",NINT,NREAD|NWRITE,NULL,NULL,0},
  {"zoom",NINT,NREAD|NWRITE,oputge1,NULL,0},
  {"symbol_greek",NBOOL,NREAD|NWRITE,NULL,NULL,0},
  {"draw",NVFUNC,NREAD|NEXEC,mergedraw,"i",0},
  {"redraw",NVFUNC,NREAD|NEXEC,mergeredraw,"i",0},
  {"save",NSFUNC,NREAD|NEXEC,pathsave,"sa",0},
  {"store_data",NSFUNC,NREAD|NEXEC,mergestore,NULL,0},
  {"load_data",NVFUNC,NREAD|NEXEC,mergeload,"s"},
  {"store_dummy",NSFUNC,NREAD|NEXEC,mergestoredum,NULL,0},
  {"load_dummy",NVFUNC,NREAD|NEXEC,mergeloaddum,"s"},
  {"time",NSFUNC,NREAD|NEXEC,mergetime,"i",0},
  {"date",NSFUNC,NREAD|NEXEC,mergedate,"i",0},
  {"_local",NPOINTER,0,NULL,NULL,0}
};

void *addmerge()
/* addmerge() returns NULL on error */
{
  return addobject(NAME,NULL,PARENT,VERSION,TBLNUM,merge,ERRNUM,mergeerrorlist,NULL,NULL);
}
