/**
 *
 * $Id: x11cood.c,v 1.5 1999/05/08 13:31:30 isizaka Exp $
 *
 * Copyright (C) 1997, Satoshi ISHIZAKA.
 *
 * This file is part of Ngraph
 *
 * This is free software; you can redistribute it and/or modify it.
 * However, it is prohibited to compile this on the "Windows" environment.
 *
 * Original author: Satoshi ISHIZAKA
 *                  isizaka@msa.biglobe.ne.jp
 **/

/**
 *
 * $Log: x11cood.c,v $
 * Revision 1.5  1999/05/08 13:31:30  isizaka
 * for release 6.03.02
 *
 * Revision 1.4  1999/04/15 12:14:26  isizaka
 * for release 6.03.01
 *
 * Revision 1.3  1999/04/11 06:09:20  isizaka
 * *** empty log message ***
 *
 * Revision 1.2  1999/03/20 12:32:54  isizaka
 * minor change
 *
 * Revision 1.1  1999/03/17 13:28:56  isizaka
 * Initial revision
 *
 *
 **/

#include <Xm/XmAll.h>

#include "ngraph.h"
#include "object.h"

#include "x11gui.h"
#include "ox11menu.h"
#include "x11menu.h"
#include "x11cood.h"

void CoordWinDrawText(GC gc)
{
  int x,y,len,j,k;
  Display *disp;
  Window win;
  struct CoordWin *d;

  d=&(NgraphApp.CoordWin);
  if (d->str==NULL) return;
  disp=XtDisplay(d->text);
  win=XtWindow(d->text);
  x=FWidth;
  y=FAscent;
  len=0;
  j=k=0;
  while (TRUE) {
    if (d->str[j]=='\0') {
      XDrawString(disp,win,gc,x,y,d->str+k,len);
      k=j+1;
      len=0;
      break;
    } else if (d->str[j]=='\n') {
      XDrawString(disp,win,gc,x,y,d->str+k,len);
      k=j+1;
      len=0;
      y+=FHeight;
    } else len++;
    j++;
  }
}

void CoordWinSetCoord(int x, int y)
{
  struct objlist *obj;
  int i,j,num;
  char *argv[3];
  double a;
  GC gc;
  char *name;
  struct CoordWin *d;

  d=&(NgraphApp.CoordWin);
  memfree(d->str);
  obj=chkobject("axis");
  if (obj!=NULL) {
    num=chkobjlastinst(obj)+1;
    d->str=(char *)memalloc(45*(num+1));
    if (d->str!=NULL) {
      j=0;
      j+=sprintf(d->str+j,"(X:%d  Y:%d)\n",x,y);
      argv[0]=(char *)&x;
      argv[1]=(char *)&y;
      argv[2]=NULL;
      for (i=0;i<num;i++) {
        getobj(obj,"group",i,0,NULL,&name);
        if (getobj(obj,"coordinate",i,2,argv,&a)!=-1) {
          j+=sprintf(d->str+j,"%d %5s %+.7e\n",i,name,a);
        }
      }
    }
  }
  if (d->text==NULL) return;
  gc=XCreateGC(XtDisplay(d->text),XtWindow(d->text),0,0);
  XClearArea(XtDisplay(d->text),XtWindow(d->text),0,0,0,0,FALSE);
  CoordWinDrawText(gc);
  XFreeGC(XtDisplay(d->text),gc);
}

void CoordWinUpdate(int clear)
{
  struct CoordWin *d;

  d=&(NgraphApp.CoordWin);
  if (d->text==NULL) return;
  XClearArea(XtDisplay(d->text),XtWindow(d->text),0,0,0,0,TRUE);
}

void CoordWinExpose(Widget w,XtPointer client_data,XtPointer call_data)
{
  struct CoordWin *d;
  XmDrawingAreaCallbackStruct *dd;
  XExposeEvent *e;
  GC gc;

  d=&(NgraphApp.CoordWin);
  if (d->text==NULL) return;
  dd=(XmDrawingAreaCallbackStruct *)call_data;
  e=(XExposeEvent *)(dd->event);
  gc=XCreateGC(e->display,e->window,0,0);
  CoordWinDrawText(gc);
  XFreeGC(e->display,gc);
}

void CoordWinUnmap(Widget w,XtPointer client_data,XtPointer call_data)
{
  struct CoordWin *d;
  Position x,y,x0,y0;

  d=&(NgraphApp.CoordWin);
  if (d->Win!=NULL) {
    XtVaGetValues(d->Win,XmNx,&x,XmNy,&y,
                         XmNwidth,&(menulocal.coordwidth),
                         XmNheight,&(menulocal.coordheight),NULL);
    XtTranslateCoords(TopLevel,0,0,&x0,&y0);
    menulocal.coordx=x-x0;
    menulocal.coordy=y-y0;
    XtDestroyWidget(d->Win);
    d->Win=NULL;
    d->text=NULL;
    XmToggleButtonSetState(XtNameToWidget(TopLevel,"*windowmenu.button_4"),
                           False,False);
  }
}

void CmCoordinateWindow(Widget w,XtPointer client_data,XtPointer call_data)
{
  Arg al[20];
  Cardinal ac;
  Widget dlg;
  unsigned int width,height;
  Position x,y;
  struct CoordWin *d;

  d=&(NgraphApp.CoordWin);
  if (d->Win!=NULL) {
    XtUnmanageChild(d->Win);
  } else {
    if (menulocal.coordwidth==CW_USEDEFAULT) width=FWidth*25;
    else width=menulocal.coordwidth;
    if (menulocal.coordheight==CW_USEDEFAULT) height=FHeight*6;
    else height=menulocal.coordheight;
    ac=0;
    XtSetArg(al[ac],XmNborderWidth,1);ac++;
    XtSetArg(al[ac],XmNdialogStyle,XmDIALOG_MODELESS); ac++;
    XtSetArg(al[ac],XmNautoUnmanage,FALSE); ac++;
    XtSetArg(al[ac],XmNwidth,width); ac++;
    XtSetArg(al[ac],XmNheight,height); ac++;
    if ((menulocal.coordx!=CW_USEDEFAULT)
     && (menulocal.coordy!=CW_USEDEFAULT)) {
      XtTranslateCoords(TopLevel,menulocal.coordx,menulocal.coordy,&x,&y);
      XtSetArg(al[ac],XmNdefaultPosition,False); ac++;
      x-=menulocal.framex;
      y-=menulocal.framey;
      if (x<0) x=0;
      if (y<0) y=0;
      XtSetArg(al[ac],XmNx,x); ac++;
      XtSetArg(al[ac],XmNy,y); ac++;
    } else {
      XtSetArg(al[ac],XmNdefaultPosition,True); ac++;
    }
    XtManageChild(dlg=XmCreateFormDialog(TopLevel,"coordinatewindow",al,ac));
    d->Win=dlg;
    XtAddCallback(dlg,XmNunmapCallback,CoordWinUnmap,NULL);
    ac=0;
    XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM); ac++;
    XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_FORM); ac++;
    XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM); ac++;
    XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM); ac++;
    XtSetArg(al[ac],XmNalignment,XmALIGNMENT_BEGINNING); ac++;
    XtSetArg(al[ac],XmNbackground,WhitePixel(XtDisplay(TopLevel),0)); ac++;
    XtSetArg(al[ac],XmNwidth,width); ac++;
    XtSetArg(al[ac],XmNheight,height); ac++;
    XtSetArg(al[ac],XmNborderWidth,0);ac++;
    XtManageChild(d->text=XmCreateDrawingArea(dlg,"window",al,ac));
    XtAddCallback(d->text,XmNexposeCallback,CoordWinExpose,NULL);
    XmToggleButtonSetState(XtNameToWidget(TopLevel,"*windowmenu.button_4"),
                           True,False);
  }
}
