/**
 *
 * $Id: x11lgndx.c,v 1.2 1999/04/11 06:09:20 isizaka Exp $
 *
 * Copyright (C) 1997, Satoshi ISHIZAKA.
 *
 * This file is part of Ngraph
 *
 * This is free software; you can redistribute it and/or modify it.
 * However, it is prohibited to compile this on the "Windows" environment.
 *
 * Original author: Satoshi ISHIZAKA
 *                  isizaka@msa.biglobe.ne.jp
 **/

/**
 *
 * $Log: x11lgndx.c,v $
 * Revision 1.2  1999/04/11 06:09:20  isizaka
 * *** empty log message ***
 *
 * Revision 1.1  1999/03/17 13:29:01  isizaka
 * Initial revision
 *
 *
 **/

#include <Xm/XmAll.h>
#include <math.h>

#include "motif12.h"

#include "ngraph.h"
#include "object.h"
#include "gra.h"
#include "mathfn.h"
#include "spline.h"

#include "x11gui.h"
#include "x11dialg.h"
#include "x11menu.h"
#include "ox11menu.h"

double *spx,*spy,*spz;
double *spc[6];

void LegendGaussDialogSetupItem(Widget w,struct LegendGaussDialog *d,int id)
{
  SetStyleFromObjField(w,"*style",d->Obj,id,"style");
  SetComboList(w,"*width",cblinewidth,CBLINEWIDTH);
  SetTextFromObjField(GetComboBoxText(w,"*width"),NULL,d->Obj,id,"width");
  SetListFromObjField(w,"*join",d->Obj,id,"join");
  SetTextFromObjField(w,"*miter",d->Obj,id,"miter_limit");
  getobj(d->Obj,"R",id,0,NULL,&d->R);
  getobj(d->Obj,"G",id,0,NULL,&d->G);
  getobj(d->Obj,"B",id,0,NULL,&d->B);
  XtVaSetValues(XtNameToWidget(w,"*col"),XmNbackground,RGB(d->R,d->G,d->B),NULL);
  XmToggleButtonSetState(XtNameToWidget(w,"*T"),FALSE,TRUE);
  XmToggleButtonSetState(XtNameToWidget(w,"*B"),FALSE,TRUE);
  XmToggleButtonSetState(XtNameToWidget(w,"*L"),FALSE,TRUE);
  XmToggleButtonSetState(XtNameToWidget(w,"*R"),FALSE,TRUE);
  if (d->Dir==0) XmToggleButtonSetState(XtNameToWidget(w,"*T"),TRUE,TRUE);
  else if (d->Dir==1) XmToggleButtonSetState(XtNameToWidget(w,"*B"),TRUE,TRUE);
  else if (d->Dir==2) XmToggleButtonSetState(XtNameToWidget(w,"*L"),TRUE,TRUE);
  else if (d->Dir==3) XmToggleButtonSetState(XtNameToWidget(w,"*R"),TRUE,TRUE);
  XmToggleButtonSetState(XtNameToWidget(w,"*Gauss"),FALSE,TRUE);
  XmToggleButtonSetState(XtNameToWidget(w,"*Lorentz"),FALSE,TRUE);
  XmToggleButtonSetState(XtNameToWidget(w,"*Parabola"),FALSE,TRUE);
  XmToggleButtonSetState(XtNameToWidget(w,"*Sin"),FALSE,TRUE);
  if (d->Mode==0) 
    XmToggleButtonSetState(XtNameToWidget(w,"*Gauss"),TRUE,TRUE);
  else if (d->Mode==1) 
    XmToggleButtonSetState(XtNameToWidget(w,"*Lorentz"),TRUE,TRUE);
  else if (d->Mode==2) 
    XmToggleButtonSetState(XtNameToWidget(w,"*Parabola"),TRUE,TRUE);
  else if (d->Mode==3) 
    XmToggleButtonSetState(XtNameToWidget(w,"*Sin"),TRUE,TRUE);
  XtVaSetValues(XtNameToWidget(w,"*div"),XmNvalue,d->Div,NULL);
  XtVaSetValues(XtNameToWidget(w,"*sch"),XmNvalue,round(d->Position*100),NULL);
  XtVaSetValues(XtNameToWidget(w,"*scv"),XmNvalue,round(d->Param*1000),NULL);
}

void LegendGaussDialogPaint(Widget w,XtPointer client_data,XtPointer call_data)
{
  struct LegendGaussDialog *d;
  XmDrawingAreaCallbackStruct *dd;
  Window root,win;
  Display *disp;
  int i,j,k,xx,yy,pw,dw;
  int minx,miny,maxx,maxy;
  unsigned int ww,hh,border,depth;
  GC gc;
  double ppd,x,y=0,tmp;
  int Amp,Wd;
  int dpi,GC,spnum;
  struct mxlocal mxsave;
  double spc2[6];

  d=(struct LegendGaussDialog *)client_data;
  dd=(XmDrawingAreaCallbackStruct *)call_data;
  disp=XtDisplay(w);
  win=XtWindow(w);
  gc=XCreateGC(disp,win,0,0);
  XGetGeometry(disp,win,&root,&xx,&yy,&ww,&hh,&border,&depth);
  XSetForeground(disp,gc,WhitePixel(XtDisplay(TopLevel),0));
  XFillRectangle(disp,win,gc,0,0,ww,hh);
  if (ww<hh) pw=ww-1;
  else pw=hh-1;
  if (d->Wdx<d->Wdy) dw=d->Wdy;
  else dw=d->Wdx;
  ppd=pw/((double )dw);
  dpi=round(ppd*2540);
  minx=ww/2-d->Wdx*ppd/2;
  miny=hh/2-d->Wdy*ppd/2;
  maxx=ww/2+d->Wdx*ppd/2;
  maxy=hh/2+d->Wdy*ppd/2;
  XSetForeground(disp,gc,BlackPixel(XtDisplay(TopLevel),0));
  XSetLineAttributes(disp,gc,0,LineOnOffDash,CapButt,JoinMiter);
  XSetDashes(disp,gc,0,dashes,2);
  XDrawRectangle(disp,win,gc,minx,miny,maxx-minx,maxy-miny);
  XSetLineAttributes(disp,gc,0,LineSolid,CapButt,JoinMiter);
  if ((d->Dir==0) || (d->Dir==1)) {
    Amp=d->Wdy;
    Wd=d->Wdx;
  } else {
    Amp=d->Wdx;
    Wd=d->Wdy;
  }
  if (d->alloc) {
    mxsaveGC(gc,win,0,0,&mxsave,dpi,NULL);
    GC=_GRAopen(chkobjectname(menulocal.obj),"_output",menulocal.outputobj,
                menulocal.inst,menulocal.output,-1,-1,-1,NULL,mxlocal);
    if (GC>=0) {
      GRAview(GC,mxp2d(minx),mxp2d(miny),
                 mxp2d(maxx),mxp2d(maxy),1);
      for (i=0;i<=(d->Div);i++) {
        x=Wd/((double )(d->Div))*i;
        if (d->Mode==0) {
          tmp=(x-Wd*0.5-Wd*d->Position*0.5)/(Wd/(1+10*d->Param)/2);
          y=Amp*exp(-tmp*tmp);
        } else if (d->Mode==1) {
          tmp=(x-Wd*0.5-Wd*d->Position*0.5)/(Wd/(1+10*d->Param)/2);
          y=Amp/(tmp*tmp+1);
        } else if (d->Mode==2) {
          if (d->Position>=0) {
            tmp=(x-Wd*0.5-Wd*d->Position*0.5)/(-Wd*0.5-Wd*d->Position*0.5);
          } else {
            tmp=(x-Wd*0.5-Wd*d->Position*0.5)/(Wd*0.5-Wd*d->Position*0.5);
          }
          y=Amp*tmp*tmp;
        } else if (d->Mode==3) {
          tmp=x/(Wd/(0.25+10*d->Param));
          y=Amp*0.5*(sin(2.0*MPI*(tmp-d->Position*0.5))+1);
        }
        if (d->Dir==0) {
          spx[i]=round(x);
          spy[i]=d->Wdy-round(y);
        } else if (d->Dir==1) {
          spx[i]=round(x);
          spy[i]=round(y);
        } else if (d->Dir==2) {
          spx[i]=d->Wdx-round(y);
          spy[i]=d->Wdy-round(x);
        } else if (d->Dir==3) {
          spx[i]=round(y);
          spy[i]=d->Wdy-round(x);
        }
        spz[i]=i;
      }
      spnum=d->Div+1;
      spline(spz,spx,spc[0],spc[1],spc[2],spnum,SPLCND2NDDIF,SPLCND2NDDIF,0,0);
      spline(spz,spy,spc[3],spc[4],spc[5],spnum,SPLCND2NDDIF,SPLCND2NDDIF,0,0);
      GRAcolor(GC,0,0,0);
      GRAcurvefirst(GC,0,NULL,NULL,NULL,
                    splinedif,splineint,NULL,spx[0],spy[0]);
      for (j=0;j<spnum-1;j++) {
        for (k=0;k<6;k++) spc2[k]=spc[k][j];
         if (!GRAcurve(GC,spc2,spx[j],spy[j])) break;
      }
    }
    _GRAclose(GC);
    mxrestoreGC(&mxsave);
  }
  XFreeGC(disp,gc);
}

void LegendGaussDialogScaleV(Widget w,XtPointer client_data,XtPointer call_data)
{
  struct LegendGaussDialog *d;
  XmScaleCallbackStruct *dd;
  Widget win;

  d=(struct LegendGaussDialog *)client_data;
  dd=(XmScaleCallbackStruct *)call_data;
  d->Param=dd->value/1000.0;
  win=XtNameToWidget(d->widget,"*win");
  XClearArea(XtDisplay(win),XtWindow(win),0,0,0,0,TRUE); 
}

void LegendGaussDialogScaleH(Widget w,XtPointer client_data,XtPointer call_data)
{
  struct LegendGaussDialog *d;
  XmScaleCallbackStruct *dd;
  Widget win;

  d=(struct LegendGaussDialog *)client_data;
  dd=(XmScaleCallbackStruct *)call_data;
  d->Position=dd->value/100.0;
  win=XtNameToWidget(d->widget,"*win");
  XClearArea(XtDisplay(win),XtWindow(win),0,0,0,0,TRUE); 
}

void LegendGaussDialogMode(Widget w,XtPointer client_data,XtPointer call_data)
{
  struct LegendGaussDialog *d;
  Widget win;

  d=(struct LegendGaussDialog *)client_data;
  if (w==XtNameToWidget(d->widget,"*Gauss")) d->Mode=0;
  else if (w==XtNameToWidget(d->widget,"*Lorentz")) d->Mode=1;
  else if (w==XtNameToWidget(d->widget,"*Parabola")) d->Mode=2;
  else if (w==XtNameToWidget(d->widget,"*Sin")) d->Mode=3;
  win=XtNameToWidget(d->widget,"*win");
  XClearArea(XtDisplay(win),XtWindow(win),0,0,0,0,TRUE); 
}

void LegendGaussDialogDir(Widget w,XtPointer client_data,XtPointer call_data)
{
  struct LegendGaussDialog *d;
  Widget win;

  d=(struct LegendGaussDialog *)client_data;
  if (w==XtNameToWidget(d->widget,"*T")) d->Dir=0;
  else if (w==XtNameToWidget(d->widget,"*B")) d->Dir=1;
  else if (w==XtNameToWidget(d->widget,"*L")) d->Dir=2;
  else if (w==XtNameToWidget(d->widget,"*R")) d->Dir=3;
  win=XtNameToWidget(d->widget,"*win");
  XClearArea(XtDisplay(win),XtWindow(win),0,0,0,0,TRUE); 
}

void LegendGaussDialogDiv(Widget w,XtPointer client_data,XtPointer call_data)
{
  struct LegendGaussDialog *d;
  XmScaleCallbackStruct *dd;
  Widget win;

  d=(struct LegendGaussDialog *)client_data;
  dd=(XmScaleCallbackStruct *)call_data;
  d->Div=dd->value;
  win=XtNameToWidget(d->widget,"*win");
  XClearArea(XtDisplay(win),XtWindow(win),0,0,0,0,TRUE); 
}

void LegendGaussDialogColor(Widget w,XtPointer client_data,XtPointer call_data)
{
  struct LegendGaussDialog *d;

  d=(struct LegendGaussDialog *)client_data;
  GetColor(TopLevel,&d->R,&d->G,&d->B);
  XtVaSetValues(w,XmNbackground,RGB(d->R,d->G,d->B),NULL);
}

void LegendGaussDialogSetup(Widget w,void *data,int makewidget)
{
  Arg al[20];
  Cardinal ac;
  Widget rc0,rc,rc2,rb,button,da,sc;
  struct LegendGaussDialog *d;
  char title[60];
  XmString xs;
  
  d=(struct LegendGaussDialog *)data;
  sprintf(title,"Legend Gaussian/Lorentzian/Parabola/Sin %d",d->Id);
  xs=XmStringCreateLocalized(title);
  XtVaSetValues(w,XmNdialogTitle,xs,NULL);
  XmStringFree(xs);
  if (makewidget) {
  ac=0;
  XtSetArg(al[ac],XmNorientation,XmVERTICAL); ac++;
  XtManageChild(rc=XmCreateRowColumn(w,"rc",al,ac));

  ac=0;
  XtSetArg(al[ac],XmNorientation,XmHORIZONTAL); ac++;
  XtManageChild(rb=XmCreateRadioBox(rc,"buttonrc",al,ac));
  ac=0;
  XtManageChild(button=XmCreateToggleButton(rb,"Gauss",al,ac));
  XtAddCallback(button,XmNarmCallback,LegendGaussDialogMode,d);
  XtManageChild(button=XmCreateToggleButton(rb,"Lorentz",al,ac));
  XtAddCallback(button,XmNarmCallback,LegendGaussDialogMode,d);
  XtManageChild(button=XmCreateToggleButton(rb,"Parabola",al,ac));
  XtAddCallback(button,XmNarmCallback,LegendGaussDialogMode,d);
  XtManageChild(button=XmCreateToggleButton(rb,"Sin",al,ac));
  XtAddCallback(button,XmNarmCallback,LegendGaussDialogMode,d);

  ac=0;
  XtSetArg(al[ac],XmNorientation,XmHORIZONTAL); ac++;
  XtManageChild(rc0=XmCreateRowColumn(rc,"rc2",al,ac));

  ac=0;
  XtSetArg(al[ac],XmNorientation,XmVERTICAL); ac++;
  XtManageChild(rc=XmCreateRowColumn(rc0,"rc3",al,ac));

  ac=0;
  XtSetArg(al[ac],XmNorientation,XmHORIZONTAL); ac++;
  XtManageChild(rc2=XmCreateRowColumn(rc,"stylerc",al,ac));
  ac=0;
  XtManageChild(XmCreateLabel(rc2,"Style",al,ac));
  ac=0;
  XtSetArg(al[ac],XmNcomboBoxType,XmDROP_DOWN_COMBO_BOX); ac++;
  XtManageChild(XmCreateComboBox(rc2,"style",al,ac));

  ac=0;
  XtSetArg(al[ac],XmNorientation,XmHORIZONTAL); ac++;
  XtManageChild(rc2=XmCreateRowColumn(rc,"widthrc",al,ac));
  ac=0;
  XtManageChild(XmCreateLabel(rc2,"Width",al,ac));
  ac=0;
  XtSetArg(al[ac],XmNcomboBoxType,XmDROP_DOWN_COMBO_BOX); ac++;
  XtManageChild(XmCreateComboBox(rc2,"width",al,ac));

  ac=0;
  XtSetArg(al[ac],XmNorientation,XmHORIZONTAL); ac++;
  XtManageChild(rc2=XmCreateRowColumn(rc,"miterrc",al,ac));
  ac=0;
  XtManageChild(XmCreateLabel(rc2,"Miter",al,ac));
  ac=0;
  XtManageChild(XmCreateTextField(rc2,"miter",al,ac));

  ac=0;
  XtSetArg(al[ac],XmNorientation,XmHORIZONTAL); ac++;
  XtManageChild(rc2=XmCreateRowColumn(rc,"joinrc",al,ac));
  ac=0;
  XtManageChild(XmCreateLabel(rc2,"Join",al,ac));
  ac=0;
  XtSetArg(al[ac],XmNcomboBoxType,XmDROP_DOWN_LIST); ac++;
  XtManageChild(XmCreateComboBox(rc2,"join",al,ac));

  ac=0;
  XtSetArg(al[ac],XmNorientation,XmHORIZONTAL); ac++;
  XtManageChild(rc2=XmCreateRowColumn(rc,"colorrc",al,ac));
  ac=0;
  XtManageChild(XmCreateLabel(rc2,"Color",al,ac));
  ac=0;
  XtManageChild(button=XmCreateDrawnButton(rc2,"col",al,ac));
  XtAddCallback(button,XmNdisarmCallback,LegendGaussDialogColor,d);

  ac=0;
  XtSetArg(al[ac],XmNorientation,XmHORIZONTAL); ac++;
  XtManageChild(rc2=XmCreateRowColumn(rc,"divrc",al,ac));
  ac=0;
  XtManageChild(XmCreateLabel(rc2,"Div",al,ac));
  ac=0;
  XtSetArg(al[ac],XmNminimum,10); ac++;
  XtSetArg(al[ac],XmNmaximum,200); ac++;
  XtSetArg(al[ac],XmNorientation,XmHORIZONTAL); ac++;
  XtSetArg(al[ac],XmNshowValue,XmNEAR_SLIDER); ac++;
  XtManageChild(sc=XmCreateScale(rc2,"div",al,ac));
  XtAddCallback(sc,XmNvalueChangedCallback,LegendGaussDialogDiv,d);
  XtAddCallback(sc,XmNdragCallback,LegendGaussDialogDiv,d);

  ac=0;
  XtSetArg(al[ac],XmNorientation,XmHORIZONTAL); ac++;
  XtManageChild(rb=XmCreateRadioBox(rc,"alignrc",al,ac));
  ac=0;
  XtManageChild(button=XmCreateToggleButton(rb,"T",al,ac));
  XtAddCallback(button,XmNarmCallback,LegendGaussDialogDir,d);
  XtManageChild(button=XmCreateToggleButton(rb,"B",al,ac));
  XtAddCallback(button,XmNarmCallback,LegendGaussDialogDir,d);
  XtManageChild(button=XmCreateToggleButton(rb,"L",al,ac));
  XtAddCallback(button,XmNarmCallback,LegendGaussDialogDir,d);
  XtManageChild(button=XmCreateToggleButton(rb,"R",al,ac));
  XtAddCallback(button,XmNarmCallback,LegendGaussDialogDir,d);

  ac=0;
  XtSetArg(al[ac],XmNorientation,XmVERTICAL); ac++;
  XtManageChild(rc=XmCreateRowColumn(rc0,"winrc",al,ac));
  ac=0;
  XtSetArg(al[ac],XmNminimum,0); ac++;
  XtSetArg(al[ac],XmNmaximum,1000); ac++;
  XtSetArg(al[ac],XmNorientation,XmHORIZONTAL); ac++;
  XtSetArg(al[ac],XmNshowValue,XmNEAR_SLIDER); ac++;
  XtSetArg(al[ac],XmNdecimalPoints,3); ac++;
  XtManageChild(sc=XmCreateScale(rc,"scv",al,ac));
  XtAddCallback(sc,XmNvalueChangedCallback,LegendGaussDialogScaleV,d);
  XtAddCallback(sc,XmNdragCallback,LegendGaussDialogScaleV,d);
  ac=0;
  XtSetArg(al[ac],XmNresizeWidth,FALSE); ac++;
  XtSetArg(al[ac],XmNresizeHeight,FALSE); ac++;
  XtManageChild(da=XmCreateDrawnButton(rc,"win",al,ac));
  XtAddCallback(da,XmNexposeCallback,LegendGaussDialogPaint,d);
  ac=0;
  XtSetArg(al[ac],XmNminimum,-100); ac++;
  XtSetArg(al[ac],XmNmaximum,100); ac++;
  XtSetArg(al[ac],XmNorientation,XmHORIZONTAL); ac++;
  XtSetArg(al[ac],XmNshowValue,XmNEAR_SLIDER); ac++;
  XtSetArg(al[ac],XmNdecimalPoints,2); ac++;
  XtManageChild(sc=XmCreateScale(rc,"sch",al,ac));
  XtAddCallback(sc,XmNvalueChangedCallback,LegendGaussDialogScaleH,d);
  XtAddCallback(sc,XmNdragCallback,LegendGaussDialogScaleH,d);
  }
  LegendGaussDialogSetupItem(w,d,d->Id); 

}

void LegendGaussDialogClose(Widget w,void *data)
{
  struct LegendGaussDialog *d;
  int ret;
  int a;
  double x,y=0,tmp;
  int Amp,Wd,gx,gy;
  struct narray *parray;
  int i;

  d=(struct LegendGaussDialog *)data;
  if (d->ret!=IDOK) return;
  ret=d->ret;
  d->ret=IDLOOP;
  if (SetObjFieldFromStyle(w,"*style",d->Obj,d->Id,"style")) return;
  if (SetObjFieldFromText(GetComboBoxText(w,"*width"),NULL,
                          d->Obj,d->Id,"width")) return;
  if (SetObjFieldFromList(w,"*join",d->Obj,d->Id,"join")) return;
  if (SetObjFieldFromText(w,"*miter",d->Obj,d->Id,"miter_limit")) return;
  if (putobj(d->Obj,"R",d->Id,&(d->R))==-1) return;
  if (putobj(d->Obj,"G",d->Id,&(d->G))==-1) return;
  if (putobj(d->Obj,"B",d->Id,&(d->B))==-1) return;
  if ((d->Dir==0) || (d->Dir==1)) {
    Amp=d->Wdy;
    Wd=d->Wdx;
  } else {
    Amp=d->Wdx;
    Wd=d->Wdy;
  }
  parray=arraynew(sizeof(int));
  for (i=0;i<=d->Div;i++) {
    x=Wd/((double )(d->Div))*i;
    if (d->Mode==0) {
      tmp=(x-Wd*0.5-Wd*d->Position*0.5)/(Wd/(1+10*d->Param)/2);
      y=Amp*exp(-tmp*tmp);
    } else if (d->Mode==1) {
      tmp=(x-Wd*0.5-Wd*d->Position*0.5)/(Wd/(1+10*d->Param)/2);
      y=Amp/(tmp*tmp+1);
    } else if (d->Mode==2) {
      if (d->Position>=0) {
        tmp=(x-Wd*0.5-Wd*d->Position*0.5)/(-Wd*0.5-Wd*d->Position*0.5);
      } else {
        tmp=(x-Wd*0.5-Wd*d->Position*0.5)/(Wd*0.5-Wd*d->Position*0.5);
      }
      y=Amp*tmp*tmp;
    } else if (d->Mode==3) {
      tmp=x/(Wd/(0.25+10*d->Param));
      y=Amp*0.5*(sin(2.0*MPI*(tmp-d->Position*0.5))+1);
    }
    if (d->Dir==0) {
      gx=round(x);
      gy=d->Wdy-round(y);
    } else if (d->Dir==1) {
      gx=round(x);
      gy=round(y);
    } else if (d->Dir==2) {
      gx=d->Wdx-round(y);
      gy=d->Wdy-round(x);
    } else if (d->Dir==3) {
      gx=round(y);
      gy=d->Wdy-round(x);
    }
    gx+=d->Minx;
    gy+=d->Miny;
    arrayadd(parray,&gx);
    arrayadd(parray,&gy);
  }
  putobj(d->Obj,"points",d->Id,parray);
  a=0;
  putobj(d->Obj,"interpolation",d->Id,&a);
  d->ret=ret;
  for (i=0;i<6;i++) memfree(spc[i]);
  memfree(spz);
  memfree(spy);
  memfree(spx);
}

void LegendGaussDialog(struct LegendGaussDialog *data,
                       struct objlist *obj,int id,
                       int minx,int miny,int wdx,int wdy)
{
  int i;

  data->SetupWindow=LegendGaussDialogSetup;
  data->CloseWindow=LegendGaussDialogClose;
  data->Obj=obj;
  data->Id=id;
  data->Minx=minx;
  data->Miny=miny;
  data->Wdx=wdx;
  data->Wdy=wdy;
  data->Div=20;
  data->Position=0;
  data->Param=0.175;
  data->Dir=0;
  data->Mode=0;
  data->alloc=TRUE;
  if ((spx=(double *)memalloc(sizeof(double)*201))==NULL) data->alloc=FALSE;
  if ((spy=(double *)memalloc(sizeof(double)*201))==NULL) data->alloc=FALSE;
  if ((spz=(double *)memalloc(sizeof(double)*201))==NULL) data->alloc=FALSE;
  for (i=0;i<6;i++)
    if ((spc[i]=(double *)memalloc(sizeof(double)*201))==NULL)
      data->alloc=FALSE;
}

