/**
 *
 * $Id: x11menu.h,v 1.4 1999/04/15 12:14:26 isizaka Exp $
 *
 * Copyright (C) 1997, Satoshi ISHIZAKA.
 *
 * This file is part of Ngraph
 *
 * This is free software; you can redistribute it and/or modify it.
 * However, it is prohibited to compile this on the "Windows" environment.
 *
 * Original author: Satoshi ISHIZAKA
 *                  isizaka@msa.biglobe.ne.jp
 **/

/**
 *
 * $Log: x11menu.h,v $
 * Revision 1.4  1999/04/15 12:14:26  isizaka
 * for release 6.03.01
 *
 * Revision 1.3  1999/04/11 06:09:20  isizaka
 * *** empty log message ***
 *
 * Revision 1.2  1999/03/20 12:32:54  isizaka
 * minor change
 *
 * Revision 1.1  1999/03/17 13:29:01  isizaka
 * Initial revision
 *
 *
 **/

extern Widget TopLevel,MainWin;
extern Display *Disp;
extern XtAppContext Application;
extern unsigned int black,white,gray,red,blue;
extern Atom NgraphClose;
extern struct narray childlist;
extern int FAscent,FDescent,FHeight,FWidth;
extern XFontSet FFont;

#define XC_centering XC_target
#define XC_zoomin XC_dotbox
#define XC_zoomout XC_dot

struct Viewer {
  Widget Win;
  Window win;
  Widget VScroll,HScroll,popup;
  int ShowFrame,ShowLine,ShowRect,ShowCross;
  int Mode,Capture,MoveData,MouseMode;
  struct narray *focusobj,*points;
  int FrameOfsX,FrameOfsY;
  int MouseX1,MouseY1,MouseX2,MouseY2,MouseDX,MouseDY;
  int RefX1,RefY1,RefX2,RefY2,ChangePoint;
  int LineX,LineY,CrossX,CrossY;
  int allclear;    
  int cx,cy,width,height;
  int ignoreredraw;
  int vscroll,hscroll;
};

struct FileWin {
  Widget Win;
  Widget text,popup;
  int select;
  int filenum;
  struct objlist *obj;
};

struct AxisWin {
  Widget Win;
  Widget text,popup;
  int select;
  int axisnum;
  struct objlist *obj;
};

#define LEGENDNUM 7

struct LegendWin {
  Widget Win;
  Widget text,popup;
  int select;
  int legend[LEGENDNUM];
  struct objlist *obj[LEGENDNUM];
};

struct MergeWin {
  Widget Win;
  Widget text,popup;
  int select;
  int filenum;
  struct objlist *obj;
};

struct InfoWin {
  Widget Win;
  Widget text;
  char *str;
};

struct CoordWin {
  Widget Win;
  Widget text;
  char *str;
};

struct NgraphApp {
  int Interrupt;
  int Changed;
  char *FileName;
  Widget Message,Message1,Message2,Message3;
  Widget ghistory[10],fhistory[10];
  Widget viewb[19];
  Widget interrupt;
  Pixmap com1pix[17];
  Pixmap com2pix[19][2];
  Pixmap markpix[90];
  Pixmap iconpix;
  Cursor cursor[11];
  struct Viewer Viewer;
  struct FileWin FileWin;
  struct AxisWin AxisWin;
  struct LegendWin LegendWin;
  struct MergeWin MergeWin;
  struct CoordWin CoordWin;
  struct InfoWin InfoWin;
};

extern struct NgraphApp NgraphApp;

void application(char *file);

void AxisWinUpdate(int clear);
void UpdateAll();
void UpdateAll2();
void ChangePage();
void SetCaption(char *file);
void SetCursor(unsigned int type);
void SetPoint(int x,int y);
void SetZoom(double zm);
void ResetZoom();
void ResetEvent();
void WaitForMap();
void GetWMFrame();
void SetStatusBar(char *mes);
void SetStatusBarXm(XmString s);
void ResetStatusBar();
int PutStderr(char *s);
void DisplayStatus(char *str);
void DisplayDialog(char *str);
int ChkInterrupt();
int InputYN(char *mes);
