/**
 *
 * $Id: x11scrip.c,v 1.3 1999/04/15 12:14:26 isizaka Exp $
 *
 * Copyright (C) 1997, Satoshi ISHIZAKA.
 *
 * This file is part of Ngraph
 *
 * This is free software; you can redistribute it and/or modify it.
 * However, it is prohibited to compile this on the "Windows" environment.
 *
 * Original author: Satoshi ISHIZAKA
 *                  isizaka@msa.biglobe.ne.jp
 **/

/**
 *
 * $Log: x11scrip.c,v $
 * Revision 1.3  1999/04/15 12:14:26  isizaka
 * for release 6.03.01
 *
 * Revision 1.2  1999/04/11 06:09:20  isizaka
 * *** empty log message ***
 *
 * Revision 1.1  1999/03/17 13:29:01  isizaka
 * Initial revision
 *
 *
 **/

#include <Xm/XmAll.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include "ngraph.h"
#include "object.h"
#include "nstring.h"

#include "x11gui.h"
#include "x11dialg.h"
#include "x11menu.h"
#include "ox11menu.h"
#include "x11view.h"
#include "x11scrip.h"
#include "x11commn.h"

void ScriptDialogSetupItem(Widget w,struct ScriptDialog *d)
{
  int i;
  struct script *scur;
  XmString xs;

  XmListDeleteAllItems(XtNameToWidget(w,"*list"));
  scur=menulocal.scriptroot;
  i=0;
  while (scur!=NULL) {
    xs=XmStringCreateLocalized(scur->name);
    XmListAddItem(XtNameToWidget(w,"*list"),xs,0);
    XmStringFree(xs);
    scur=scur->next;
    i++;
  }
}

void ScriptDialogSelected(Widget w,XtPointer client_data,XtPointer call_data)
{
  struct script *scur;
  int a,i;
  struct ScriptDialog *d;
  XmListCallbackStruct *dd;
  
  d=(struct ScriptDialog *)client_data;
  dd=(XmListCallbackStruct *)call_data;
  a=dd->item_position;
  scur=menulocal.scriptroot;
  i=0;
  while (scur!=NULL) {
    if (i==a-1) {
      XtVaSetValues(XtNameToWidget(d->widget,"*option"),
                    XmNvalue,scur->option,NULL);
      break;
    }
    scur=scur->next;
    i++;
  }
}

void ScriptDialogDbl(Widget w,XtPointer client_data,XtPointer call_data)
{
  struct ScriptDialog *data;

  data=(struct ScriptDialog *)client_data;
  data->ret=IDOK;
  data->CloseWindow(data->widget,data); 
}

void ScriptDialogSetup(Widget w,void *data,int makewidget)
{
  Arg al[20];
  Cardinal ac;
  Widget rc,rc2,list;
  struct ScriptDialog *d;
  
  d=(struct ScriptDialog *)data;
  if (makewidget) {
    ac=0;
    XtSetArg(al[ac],XmNorientation,XmVERTICAL); ac++;
    XtManageChild(rc=XmCreateRowColumn(w,"rc",al,ac));
    ac=0;
    XtSetArg(al[ac],XmNvisibleItemCount,10); ac++;
    XtSetArg(al[ac],XmNlistSizePolicy,XmCONSTANT); ac++;
    XtSetArg(al[ac],XmNscrollBarDisplayPolicy,XmSTATIC); ac++;
    XtSetArg(al[ac],XmNselectionPolicy,XmBROWSE_SELECT); ac++;
    XtManageChild(list=XmCreateScrolledList(rc,"list",al,ac));
    XtAddCallback(list,XmNbrowseSelectionCallback,ScriptDialogSelected,data);
    XtAddCallback(list,XmNdefaultActionCallback,ScriptDialogDbl,data);
    ac=0;
    XtSetArg(al[ac],XmNorientation,XmHORIZONTAL); ac++;
    XtManageChild(rc2=XmCreateRowColumn(rc,"optionrc",al,ac));
    ac=0;
    XtManageChild(XmCreateLabel(rc2,"Option",al,ac));
    ac=0;
    XtManageChild(XmCreateTextField(rc2,"option",al,ac));
  }
  ScriptDialogSetupItem(w,d);
}

void ScriptDialogClose(Widget w,void *data)
{
  struct ScriptDialog *d;
  char *buf;
  int i,*selected,num;
  struct script *pcur;

  d=(struct ScriptDialog *)data;
  if (d->ret!=IDOK) return;
  XtVaGetValues(XtNameToWidget(w,"*option"),XmNvalue,&buf,NULL);
  strncpy(d->option,buf,255);
  XtFree(buf);
  d->execscript=NULL;
  XmListGetSelectedPos(XtNameToWidget(w,"*list"),&selected,&num);
  if (num!=0) {
    pcur=menulocal.scriptroot;
    i=0;
    while (pcur!=NULL) {
      if (i==(selected[0]-1)) {
        if (pcur->script!=NULL) {
          if ((d->execscript=(char *)memalloc(strlen(pcur->script)+1))!=NULL) {
            strcpy(d->execscript,pcur->script);
          }
        }
        break;
      }
      pcur=pcur->next;
      i++;
    }
    XtFree((char *)selected);
  }
}

void ScriptDialog(struct ScriptDialog *data)
{
  data->SetupWindow=ScriptDialogSetup;
  data->CloseWindow=ScriptDialogClose;
}

void CmScriptExec()
{
  struct objlist *obj;
  char *name;
  int newid,allocnow=FALSE;
  char *option,*s;
  int len;
  char *argv[2];
  struct narray sarray;
  char mes[256];
  struct objlist *robj,*shell;
  char *inst;
  int idn;

  if (menulock || globallock) return;
  if ((shell=chkobject("shell"))==NULL) return;
  ScriptDialog(&DlgScript);
  if ((DialogExecute(TopLevel,&DlgScript)==IDOK)
  && (DlgScript.execscript!=NULL)) {
    name=DlgScript.execscript;
    newid=newobj(shell);
    if (newid>=0) {
      arrayinit(&sarray,sizeof(char *));
      if (arrayadd(&sarray,&name)==NULL) {
        memfree(name);
        arraydel2(&sarray);
        return;
      }
      option=DlgScript.option;
      while ((s=getitok2(&option,&len," \t"))!=NULL) {
        if (arrayadd(&sarray,&s)==NULL) {
          memfree(s);
          arraydel2(&sarray);
          return;
        }
      }
      if (menulocal.scriptconsole) {
        allocnow=AllocConsole();
      }
      argv[0]=(char *)&sarray;
      argv[1]=NULL;
      sprintf(mes,"Executing `%.128s'.",name);
      SetStatusBar(mes);

      menulock=TRUE;
      obj=menulocal.obj;
      inst=menulocal.inst;
      idn=getobjtblpos(obj,"_evloop",&robj);
      registerevloop(chkobjectname(obj),"_evloop",robj,idn,inst,NULL);

      exeobj(shell,"shell",newid,1,argv);

      unregisterevloop(robj,idn,inst);
      menulock=FALSE;

      ResetStatusBar();
      arraydel2(&sarray);
      if (menulocal.scriptconsole) FreeConsole(allocnow);
      GetPageSettingsFromGRA();
      UpdateAll2();
      NgraphApp.Changed=TRUE;
    } else memfree(name);
    delobj(shell,newid);
  }
}
