/* -*- tab-width: 4 -*-
 *
 * Electric(tm) VLSI Design System
 *
 * File: WireLengthMetric.java
 *
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.sun.electric.tool.routing.metrics;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.technology.technologies.Generic;

import java.util.Iterator;

/**
 * @author Felix Schmidt
 *
 */
public class WireLengthMetric extends RoutingMetric<Double> {

	/* (non-Javadoc)
	 * @see com.sun.electric.tool.routing.metrics.RoutingMetric#calculate(com.sun.electric.database.hierarchy.Cell)
	 */
	public Double calculate(Cell cell) {
		return processNets(cell, 0.0);
	}

	/* (non-Javadoc)
	 * @see com.sun.electric.tool.routing.metrics.RoutingMetric#reduce(java.lang.Object, com.sun.electric.database.topology.ArcInst)
	 */
	@Override
	protected Double reduce(Double result, ArcInst instance, Network net)
    {
        double val = (instance.getProto() != Generic.tech().unrouted_arc) ? instance.getLambdaLength() : 0;
		return result + val;
	}

    @Override
	protected Double reduce(Double result, Network net)
    {
        for(Iterator<ArcInst> arcIt = net.getArcs(); arcIt.hasNext();)
			result = reduce(result, arcIt.next(), net);
        return result;
	}
}
