/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file exchangedb/pg_mark_refresh_reveal_success.h
 * @brief Mark the successful reveal of a refresh in the database
 * @author Özgür Kesim
 */
#ifndef PG_MARK_REFRESH_REVEAL_SUCCESS_H
#define PG_MARK_REFRESH_REVEAL_SUCCESS_H

#include "taler/taler_util.h"
#include "taler/taler_json_lib.h"
#include "taler/taler_exchangedb_plugin.h"


/**
 * Mark a refresh, given by the commitment, as successfully revealed.
 *
 * @param cls closure
 * @param rc commitment for the refresh
 * @return transaction status code
 */
enum GNUNET_DB_QueryStatus
TEH_PG_mark_refresh_reveal_success (
  void *cls,
  const struct TALER_RefreshCommitmentP *rc);

#endif
