/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __CAPABLE_BPF_SKEL_H__
#define __CAPABLE_BPF_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

#define BPF_SKEL_SUPPORTS_MAP_AUTO_ATTACH 1

struct capable_bpf {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *start;
		struct bpf_map *cgroup_map;
		struct bpf_map *events;
		struct bpf_map *stackmap;
		struct bpf_map *info;
		struct bpf_map *seen;
		struct bpf_map *rodata;
		struct bpf_map *kconfig;
	} maps;
	struct {
		struct bpf_program *kprobe__cap_capable_entry;
		struct bpf_program *kprobe__cap_capable_exit;
	} progs;
	struct {
		struct bpf_link *kprobe__cap_capable_entry;
		struct bpf_link *kprobe__cap_capable_exit;
	} links;
	struct capable_bpf__rodata {
		pid_t my_pid;
		enum uniqueness unique_type;
		bool kernel_stack;
		bool user_stack;
		bool filter_cg;
		pid_t targ_pid;
	} *rodata;
	struct capable_bpf__kconfig {
		int LINUX_KERNEL_VERSION;
	} *kconfig;

#ifdef __cplusplus
	static inline struct capable_bpf *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct capable_bpf *open_and_load();
	static inline int load(struct capable_bpf *skel);
	static inline int attach(struct capable_bpf *skel);
	static inline void detach(struct capable_bpf *skel);
	static inline void destroy(struct capable_bpf *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
capable_bpf__destroy(struct capable_bpf *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
capable_bpf__create_skeleton(struct capable_bpf *obj);

static inline struct capable_bpf *
capable_bpf__open_opts(const struct bpf_object_open_opts *opts)
{
	struct capable_bpf *obj;
	int err;

	obj = (struct capable_bpf *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = capable_bpf__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	capable_bpf__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct capable_bpf *
capable_bpf__open(void)
{
	return capable_bpf__open_opts(NULL);
}

static inline int
capable_bpf__load(struct capable_bpf *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct capable_bpf *
capable_bpf__open_and_load(void)
{
	struct capable_bpf *obj;
	int err;

	obj = capable_bpf__open();
	if (!obj)
		return NULL;
	err = capable_bpf__load(obj);
	if (err) {
		capable_bpf__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
capable_bpf__attach(struct capable_bpf *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
capable_bpf__detach(struct capable_bpf *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *capable_bpf__elf_bytes(size_t *sz);

static inline int
capable_bpf__create_skeleton(struct capable_bpf *obj)
{
	struct bpf_object_skeleton *s;
	struct bpf_map_skeleton *map __attribute__((unused));
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "capable_bpf";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 8;
	s->map_skel_sz = 24;
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt,
			sizeof(*s->maps) > 24 ? sizeof(*s->maps) : 24);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	map = (struct bpf_map_skeleton *)((char *)s->maps + 0 * s->map_skel_sz);
	map->name = "start";
	map->map = &obj->maps.start;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 1 * s->map_skel_sz);
	map->name = "cgroup_map";
	map->map = &obj->maps.cgroup_map;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 2 * s->map_skel_sz);
	map->name = "events";
	map->map = &obj->maps.events;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 3 * s->map_skel_sz);
	map->name = "stackmap";
	map->map = &obj->maps.stackmap;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 4 * s->map_skel_sz);
	map->name = "info";
	map->map = &obj->maps.info;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 5 * s->map_skel_sz);
	map->name = "seen";
	map->map = &obj->maps.seen;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 6 * s->map_skel_sz);
	map->name = "capable_.rodata";
	map->map = &obj->maps.rodata;
	map->mmaped = (void **)&obj->rodata;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 7 * s->map_skel_sz);
	map->name = "capable.kconfig";
	map->map = &obj->maps.kconfig;
	map->mmaped = (void **)&obj->kconfig;

	/* programs */
	s->prog_cnt = 2;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "kprobe__cap_capable_entry";
	s->progs[0].prog = &obj->progs.kprobe__cap_capable_entry;
	s->progs[0].link = &obj->links.kprobe__cap_capable_entry;

	s->progs[1].name = "kprobe__cap_capable_exit";
	s->progs[1].prog = &obj->progs.kprobe__cap_capable_exit;
	s->progs[1].link = &obj->links.kprobe__cap_capable_exit;

	s->data = capable_bpf__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *capable_bpf__elf_bytes(size_t *sz)
{
	static const char data[] __attribute__((__aligned__(8))) = "\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\xe8\x28\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x10\0\
\x01\0\x79\x16\x58\0\0\0\0\0\x79\x17\x60\0\0\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x71\x11\0\0\0\0\0\0\x56\x01\x05\0\x01\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\xb4\x02\0\0\0\0\0\0\x85\0\0\0\x25\0\0\0\x15\0\x17\0\0\0\0\0\x85\0\0\
\0\x0e\0\0\0\x7b\x0a\xf8\xff\0\0\0\0\x77\0\0\0\x20\0\0\0\x18\x01\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x61\x11\0\0\0\0\0\0\x1e\x01\x10\0\0\0\0\0\x18\x01\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x61\x12\0\0\0\0\0\0\x16\x02\x02\0\xff\xff\xff\xff\x61\x11\0\0\0\
\0\0\0\x5e\x01\x0a\0\0\0\0\0\x63\x6a\xf4\xff\0\0\0\0\x63\x7a\xf0\xff\0\0\0\0\
\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xf8\xff\xff\xff\xbf\xa3\0\0\0\0\0\0\x07\x03\0\
\0\xf0\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb7\x04\0\0\0\0\0\0\x85\
\0\0\0\x02\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xbf\x16\0\0\0\0\0\0\x85\0\
\0\0\x0e\0\0\0\x7b\x0a\xf8\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xf8\xff\
\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\xbf\x07\0\0\0\
\0\0\0\x15\x07\x7f\0\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xf8\xff\xff\xff\
\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x03\0\0\0\xb4\x01\0\0\0\0\0\0\
\x63\x1a\xe4\xff\0\0\0\0\xb7\x01\0\0\0\0\0\0\x63\x1a\xe0\xff\0\0\0\0\x63\x1a\
\xdc\xff\0\0\0\0\x63\x1a\xd8\xff\0\0\0\0\x63\x1a\xd4\xff\0\0\0\0\x63\x1a\xd0\
\xff\0\0\0\0\x63\x1a\xcc\xff\0\0\0\0\x79\xa1\xf8\xff\0\0\0\0\x63\x1a\xc4\xff\0\
\0\0\0\x77\x01\0\0\x20\0\0\0\x63\x1a\xbc\xff\0\0\0\0\x61\x71\0\0\0\0\0\0\x63\
\x1a\xc0\xff\0\0\0\0\x85\0\0\0\x0f\0\0\0\x63\x0a\xc8\xff\0\0\0\0\xbf\xa1\0\0\0\
\0\0\0\x07\x01\0\0\xd8\xff\xff\xff\xb4\x02\0\0\x10\0\0\0\x85\0\0\0\x10\0\0\0\
\x79\x61\x50\0\0\0\0\0\x63\x1a\xd4\xff\0\0\0\0\xb4\x02\0\0\xff\xff\xff\xff\x61\
\x71\x04\0\0\0\0\0\x18\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x61\x33\0\0\0\0\0\0\xc6\
\x03\x06\0\0\x01\x05\0\xbc\x12\0\0\0\0\0\0\x74\x02\0\0\x02\0\0\0\x54\x02\0\0\
\x01\0\0\0\xa4\x01\0\0\xff\xff\xff\xff\x74\x01\0\0\x01\0\0\0\x54\x01\0\0\x01\0\
\0\0\x63\x2a\xd0\xff\0\0\0\0\x63\x1a\xcc\xff\0\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x61\x12\0\0\0\0\0\0\x16\x02\x1d\0\0\0\0\0\x61\x72\0\0\0\0\0\0\xb7\
\x03\0\0\0\0\0\0\x7b\x3a\xf0\xff\0\0\0\0\xb4\x03\0\0\0\0\0\0\x63\x3a\xec\xff\0\
\0\0\0\x63\x2a\xe8\xff\0\0\0\0\x61\x11\0\0\0\0\0\0\x56\x01\x03\0\x02\0\0\0\x85\
\0\0\0\x50\0\0\0\x7b\x0a\xf0\xff\0\0\0\0\x05\0\x02\0\0\0\0\0\x79\xa1\xf8\xff\0\
\0\0\0\x63\x1a\xec\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xe8\xff\xff\xff\
\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\x55\0\x3e\0\0\0\0\0\
\xb7\x01\0\0\0\0\0\0\x7b\x1a\xb0\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\
\xe8\xff\xff\xff\xbf\xa3\0\0\0\0\0\0\x07\x03\0\0\xb0\xff\xff\xff\x18\x01\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\xb7\x04\0\0\0\0\0\0\x85\0\0\0\x02\0\0\0\x18\x01\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x71\x11\0\0\0\0\0\0\x56\x01\x04\0\0\0\0\0\x18\x01\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x71\x11\0\0\0\0\0\0\x56\x01\x23\0\x01\0\0\0\xb4\x01\0\0\
\xff\xff\xff\xff\x63\x1a\xf4\xff\0\0\0\0\x63\x1a\xf0\xff\0\0\0\0\x79\xa1\xf8\
\xff\0\0\0\0\x63\x1a\xec\xff\0\0\0\0\x77\x01\0\0\x20\0\0\0\x63\x1a\xe8\xff\0\0\
\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x71\x11\0\0\0\0\0\0\x56\x01\x06\0\x01\
\0\0\0\xbf\x61\0\0\0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb7\x03\0\0\0\
\x01\0\0\x85\0\0\0\x1b\0\0\0\x63\x0a\xf0\xff\0\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x71\x11\0\0\0\0\0\0\x56\x01\x06\0\x01\0\0\0\xbf\x61\0\0\0\0\0\0\x18\
\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb7\x03\0\0\0\0\0\0\x85\0\0\0\x1b\0\0\0\x63\
\x0a\xf4\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xe8\xff\xff\xff\xbf\xa3\0\
\0\0\0\0\0\x07\x03\0\0\xbc\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb7\
\x04\0\0\x01\0\0\0\x85\0\0\0\x02\0\0\0\xbf\xa4\0\0\0\0\0\0\x07\x04\0\0\xbc\xff\
\xff\xff\xbf\x61\0\0\0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x18\x03\0\0\
\xff\xff\xff\xff\0\0\0\0\0\0\0\0\xb7\x05\0\0\x2c\0\0\0\x85\0\0\0\x19\0\0\0\xb4\
\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xff\xff\xff\xff\0\0\0\0\0\0\0\0\xff\xff\xff\
\xff\x47\x50\x4c\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x9f\xeb\x01\0\x18\0\0\0\0\0\
\0\0\x14\x09\0\0\x14\x09\0\0\xee\x09\0\0\0\0\0\0\0\0\0\x02\x03\0\0\0\x01\0\0\0\
\0\0\0\x01\x04\0\0\0\x20\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\
\x01\0\0\0\x05\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\x02\x06\0\0\0\
\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\0\x28\0\0\0\0\0\0\0\0\0\x02\x08\
\0\0\0\x19\0\0\0\0\0\0\x08\x09\0\0\0\x1d\0\0\0\0\0\0\x08\x0a\0\0\0\x23\0\0\0\0\
\0\0\x01\x08\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\x02\x0c\0\0\0\x36\0\0\0\x02\0\0\x04\
\x08\0\0\0\x3d\0\0\0\x02\0\0\0\0\0\0\0\x41\0\0\0\x02\0\0\0\x20\0\0\0\0\0\0\0\
\x04\0\0\x04\x20\0\0\0\x49\0\0\0\x01\0\0\0\0\0\0\0\x4e\0\0\0\x05\0\0\0\x40\0\0\
\0\x5a\0\0\0\x07\0\0\0\x80\0\0\0\x5e\0\0\0\x0b\0\0\0\xc0\0\0\0\x64\0\0\0\0\0\0\
\x0e\x0d\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x10\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\
\x02\0\0\0\x04\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\x02\x12\0\0\0\x6a\0\0\0\0\0\0\x08\
\x13\0\0\0\x6e\0\0\0\0\0\0\x08\x14\0\0\0\x74\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\
\0\0\0\0\0\x04\0\0\x04\x20\0\0\0\x49\0\0\0\x0f\0\0\0\0\0\0\0\x5a\0\0\0\x11\0\0\
\0\x40\0\0\0\x5e\0\0\0\x11\0\0\0\x80\0\0\0\x4e\0\0\0\x01\0\0\0\xc0\0\0\0\x81\0\
\0\0\0\0\0\x0e\x15\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x18\0\0\0\0\0\0\0\0\0\0\
\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x04\0\0\0\0\0\0\0\x03\0\0\x04\x18\0\0\0\x49\0\
\0\0\x17\0\0\0\0\0\0\0\x8c\0\0\0\x17\0\0\0\x40\0\0\0\x95\0\0\0\x17\0\0\0\x80\0\
\0\0\xa0\0\0\0\0\0\0\x0e\x19\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x1c\0\0\0\0\0\0\
\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x07\0\0\0\0\0\0\0\x02\0\0\x04\x10\0\0\
\0\x49\0\0\0\x1b\0\0\0\0\0\0\0\x8c\0\0\0\x17\0\0\0\x40\0\0\0\xa7\0\0\0\0\0\0\
\x0e\x1d\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x20\0\0\0\xb0\0\0\0\x04\0\0\x04\x10\
\0\0\0\xb6\0\0\0\x13\0\0\0\0\0\0\0\xba\0\0\0\x13\0\0\0\x20\0\0\0\xbf\0\0\0\x02\
\0\0\0\x40\0\0\0\xcd\0\0\0\x02\0\0\0\x60\0\0\0\0\0\0\0\0\0\0\x02\x22\0\0\0\xdb\
\0\0\0\x08\0\0\x04\x2c\0\0\0\xb6\0\0\0\x13\0\0\0\0\0\0\0\x3d\0\0\0\x13\0\0\0\
\x20\0\0\0\xba\0\0\0\x23\0\0\0\x40\0\0\0\xe5\0\0\0\x25\0\0\0\x60\0\0\0\xe9\0\0\
\0\x02\0\0\0\x80\0\0\0\xef\0\0\0\x02\0\0\0\xa0\0\0\0\xf7\0\0\0\x02\0\0\0\xc0\0\
\0\0\xfb\0\0\0\x28\0\0\0\xe0\0\0\0\0\x01\0\0\0\0\0\x08\x24\0\0\0\x06\x01\0\0\0\
\0\0\x08\x14\0\0\0\x17\x01\0\0\0\0\0\x08\x26\0\0\0\x1d\x01\0\0\0\0\0\x08\x14\0\
\0\0\x2e\x01\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x27\
\0\0\0\x04\0\0\0\x10\0\0\0\0\0\0\0\x04\0\0\x04\x20\0\0\0\x49\0\0\0\x01\0\0\0\0\
\0\0\0\x5a\0\0\0\x1f\0\0\0\x40\0\0\0\x5e\0\0\0\x21\0\0\0\x80\0\0\0\x4e\0\0\0\
\x05\0\0\0\xc0\0\0\0\x33\x01\0\0\0\0\0\x0e\x29\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\
\x02\x2c\0\0\0\x38\x01\0\0\x03\0\0\x04\x10\0\0\0\x3d\0\0\0\x02\0\0\0\0\0\0\0\
\xba\0\0\0\x12\0\0\0\x20\0\0\0\x43\x01\0\0\x08\0\0\0\x40\0\0\0\0\0\0\0\x04\0\0\
\x04\x20\0\0\0\x49\0\0\0\x01\0\0\0\0\0\0\0\x4e\0\0\0\x05\0\0\0\x40\0\0\0\x5a\0\
\0\0\x2b\0\0\0\x80\0\0\0\x5e\0\0\0\x07\0\0\0\xc0\0\0\0\x4c\x01\0\0\0\0\0\x0e\
\x2d\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x30\0\0\0\x51\x01\0\0\x15\0\0\x04\xa8\0\
\0\0\x59\x01\0\0\x31\0\0\0\0\0\0\0\x5d\x01\0\0\x31\0\0\0\x40\0\0\0\x61\x01\0\0\
\x31\0\0\0\x80\0\0\0\x65\x01\0\0\x31\0\0\0\xc0\0\0\0\x69\x01\0\0\x31\0\0\0\0\
\x01\0\0\x6c\x01\0\0\x31\0\0\0\x40\x01\0\0\x6f\x01\0\0\x31\0\0\0\x80\x01\0\0\
\x73\x01\0\0\x31\0\0\0\xc0\x01\0\0\x77\x01\0\0\x31\0\0\0\0\x02\0\0\x7a\x01\0\0\
\x31\0\0\0\x40\x02\0\0\x7d\x01\0\0\x31\0\0\0\x80\x02\0\0\x80\x01\0\0\x31\0\0\0\
\xc0\x02\0\0\x83\x01\0\0\x31\0\0\0\0\x03\0\0\x86\x01\0\0\x31\0\0\0\x40\x03\0\0\
\x89\x01\0\0\x31\0\0\0\x80\x03\0\0\x8c\x01\0\0\x31\0\0\0\xc0\x03\0\0\x94\x01\0\
\0\x31\0\0\0\0\x04\0\0\0\0\0\0\x32\0\0\0\x40\x04\0\0\x97\x01\0\0\x31\0\0\0\x80\
\x04\0\0\x9d\x01\0\0\x31\0\0\0\xc0\x04\0\0\0\0\0\0\x37\0\0\0\0\x05\0\0\xa0\x01\
\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\0\0\0\0\0\x03\0\0\x05\x08\0\0\0\xae\x01\0\0\
\x33\0\0\0\0\0\0\0\xb1\x01\0\0\x08\0\0\0\0\0\0\0\xb5\x01\0\0\x36\0\0\0\0\0\0\0\
\xbd\x01\0\0\0\0\0\x08\x34\0\0\0\xc1\x01\0\0\0\0\0\x08\x35\0\0\0\xc7\x01\0\0\0\
\0\0\x01\x02\0\0\0\x10\0\0\0\xb5\x01\0\0\x03\0\0\x84\x08\0\0\0\xae\x01\0\0\x08\
\0\0\0\0\0\0\x10\xd6\x01\0\0\x08\0\0\0\x10\0\0\x02\xd9\x01\0\0\x08\0\0\0\x12\0\
\0\x01\0\0\0\0\x03\0\0\x05\x08\0\0\0\xdd\x01\0\0\x33\0\0\0\0\0\0\0\xe0\x01\0\0\
\x08\0\0\0\0\0\0\0\xe4\x01\0\0\x38\0\0\0\0\0\0\0\xe4\x01\0\0\x0a\0\0\x84\x08\0\
\0\0\xdd\x01\0\0\x08\0\0\0\0\0\0\x10\xec\x01\0\0\x08\0\0\0\x10\0\0\x01\xf0\x01\
\0\0\x08\0\0\0\x11\0\0\x01\xf8\x01\0\0\x08\0\0\0\x12\0\0\x01\xfc\x01\0\0\x08\0\
\0\0\x20\0\0\x08\x49\0\0\0\x08\0\0\0\x30\0\0\x04\x03\x02\0\0\x08\0\0\0\x38\0\0\
\x01\x0b\x02\0\0\x08\0\0\0\x39\0\0\x01\x0e\x02\0\0\x08\0\0\0\x3a\0\0\x01\x15\
\x02\0\0\x08\0\0\0\x3c\0\0\x04\0\0\0\0\x01\0\0\x0d\x02\0\0\0\x1d\x02\0\0\x2f\0\
\0\0\x21\x02\0\0\x01\0\0\x0c\x39\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\x1d\x02\0\
\0\x2f\0\0\0\x19\x04\0\0\x01\0\0\x0c\x3b\0\0\0\0\0\0\0\0\0\0\x0a\x3e\0\0\0\0\0\
\0\0\0\0\0\x09\x3f\0\0\0\x2e\x09\0\0\0\0\0\x08\x40\0\0\0\x34\x09\0\0\0\0\0\x08\
\x02\0\0\0\x43\x09\0\0\0\0\0\x0e\x3d\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x0a\x43\0\0\
\0\0\0\0\0\0\0\0\x09\x44\0\0\0\x4a\x09\0\0\x03\0\0\x06\x04\0\0\0\x55\x09\0\0\0\
\0\0\0\x5d\x09\0\0\x01\0\0\0\x65\x09\0\0\x02\0\0\0\x70\x09\0\0\0\0\0\x0e\x42\0\
\0\0\x01\0\0\0\0\0\0\0\0\0\0\x0a\x47\0\0\0\0\0\0\0\0\0\0\x09\x48\0\0\0\x7c\x09\
\0\0\0\0\0\x08\x49\0\0\0\x81\x09\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\x04\x87\x09\0\
\0\0\0\0\x0e\x46\0\0\0\x01\0\0\0\x94\x09\0\0\0\0\0\x0e\x46\0\0\0\x01\0\0\0\x9f\
\x09\0\0\0\0\0\x0e\x46\0\0\0\x01\0\0\0\xa9\x09\0\0\0\0\0\x0e\x3d\0\0\0\x01\0\0\
\0\0\0\0\0\0\0\0\x03\0\0\0\0\x27\0\0\0\x04\0\0\0\x04\0\0\0\xb2\x09\0\0\0\0\0\
\x0e\x4e\0\0\0\x01\0\0\0\xba\x09\0\0\0\0\0\x0e\x02\0\0\0\x02\0\0\0\xcf\x09\0\0\
\x01\0\0\x0f\0\0\0\0\x50\0\0\0\0\0\0\0\x04\0\0\0\xd8\x09\0\0\x06\0\0\x0f\0\0\0\
\0\x0e\0\0\0\0\0\0\0\x20\0\0\0\x16\0\0\0\0\0\0\0\x20\0\0\0\x1a\0\0\0\0\0\0\0\
\x18\0\0\0\x1e\0\0\0\0\0\0\0\x10\0\0\0\x2a\0\0\0\0\0\0\0\x20\0\0\0\x2e\0\0\0\0\
\0\0\0\x20\0\0\0\xde\x09\0\0\x06\0\0\x0f\0\0\0\0\x41\0\0\0\0\0\0\0\x04\0\0\0\
\x45\0\0\0\0\0\0\0\x04\0\0\0\x4a\0\0\0\0\0\0\0\x01\0\0\0\x4b\0\0\0\0\0\0\0\x01\
\0\0\0\x4c\0\0\0\0\0\0\0\x01\0\0\0\x4d\0\0\0\0\0\0\0\x04\0\0\0\xe6\x09\0\0\x01\
\0\0\x0f\0\0\0\0\x4f\0\0\0\0\0\0\0\x04\0\0\0\0\x69\x6e\x74\0\x5f\x5f\x41\x52\
\x52\x41\x59\x5f\x53\x49\x5a\x45\x5f\x54\x59\x50\x45\x5f\x5f\0\x75\x36\x34\0\
\x5f\x5f\x75\x36\x34\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x6c\x6f\x6e\x67\x20\
\x6c\x6f\x6e\x67\0\x61\x72\x67\x73\x5f\x74\0\x63\x61\x70\0\x63\x61\x70\x5f\x6f\
\x70\x74\0\x74\x79\x70\x65\0\x6d\x61\x78\x5f\x65\x6e\x74\x72\x69\x65\x73\0\x6b\
\x65\x79\0\x76\x61\x6c\x75\x65\0\x73\x74\x61\x72\x74\0\x75\x33\x32\0\x5f\x5f\
\x75\x33\x32\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x69\x6e\x74\0\x63\x67\x72\
\x6f\x75\x70\x5f\x6d\x61\x70\0\x6b\x65\x79\x5f\x73\x69\x7a\x65\0\x76\x61\x6c\
\x75\x65\x5f\x73\x69\x7a\x65\0\x65\x76\x65\x6e\x74\x73\0\x73\x74\x61\x63\x6b\
\x6d\x61\x70\0\x6b\x65\x79\x5f\x74\0\x70\x69\x64\0\x74\x67\x69\x64\0\x75\x73\
\x65\x72\x5f\x73\x74\x61\x63\x6b\x5f\x69\x64\0\x6b\x65\x72\x6e\x5f\x73\x74\x61\
\x63\x6b\x5f\x69\x64\0\x63\x61\x70\x5f\x65\x76\x65\x6e\x74\0\x75\x69\x64\0\x61\
\x75\x64\x69\x74\0\x69\x6e\x73\x65\x74\x69\x64\0\x72\x65\x74\0\x74\x61\x73\x6b\
\0\x67\x69\x64\x5f\x74\0\x5f\x5f\x6b\x65\x72\x6e\x65\x6c\x5f\x67\x69\x64\x33\
\x32\x5f\x74\0\x75\x69\x64\x5f\x74\0\x5f\x5f\x6b\x65\x72\x6e\x65\x6c\x5f\x75\
\x69\x64\x33\x32\x5f\x74\0\x63\x68\x61\x72\0\x69\x6e\x66\x6f\0\x75\x6e\x69\x71\
\x75\x65\x5f\x6b\x65\x79\0\x63\x67\x72\x6f\x75\x70\x69\x64\0\x73\x65\x65\x6e\0\
\x70\x74\x5f\x72\x65\x67\x73\0\x72\x31\x35\0\x72\x31\x34\0\x72\x31\x33\0\x72\
\x31\x32\0\x62\x70\0\x62\x78\0\x72\x31\x31\0\x72\x31\x30\0\x72\x39\0\x72\x38\0\
\x61\x78\0\x63\x78\0\x64\x78\0\x73\x69\0\x64\x69\0\x6f\x72\x69\x67\x5f\x61\x78\
\0\x69\x70\0\x66\x6c\x61\x67\x73\0\x73\x70\0\x75\x6e\x73\x69\x67\x6e\x65\x64\
\x20\x6c\x6f\x6e\x67\0\x63\x73\0\x63\x73\x78\0\x66\x72\x65\x64\x5f\x63\x73\0\
\x75\x31\x36\0\x5f\x5f\x75\x31\x36\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x73\
\x68\x6f\x72\x74\0\x73\x6c\0\x77\x66\x65\0\x73\x73\0\x73\x73\x78\0\x66\x72\x65\
\x64\x5f\x73\x73\0\x73\x74\x69\0\x73\x77\x65\x76\x65\x6e\x74\0\x6e\x6d\x69\0\
\x76\x65\x63\x74\x6f\x72\0\x65\x6e\x63\x6c\x61\x76\x65\0\x6c\x6d\0\x6e\x65\x73\
\x74\x65\x64\0\x69\x6e\x73\x6e\x6c\x65\x6e\0\x63\x74\x78\0\x6b\x70\x72\x6f\x62\
\x65\x5f\x5f\x63\x61\x70\x5f\x63\x61\x70\x61\x62\x6c\x65\x5f\x65\x6e\x74\x72\
\x79\0\x6b\x70\x72\x6f\x62\x65\x2f\x63\x61\x70\x5f\x63\x61\x70\x61\x62\x6c\x65\
\0\x30\x3a\x31\x31\0\x2f\x62\x75\x69\x6c\x64\x2f\x62\x63\x63\x2f\x73\x72\x63\
\x2f\x62\x63\x63\x2f\x6c\x69\x62\x62\x70\x66\x2d\x74\x6f\x6f\x6c\x73\x2f\x63\
\x61\x70\x61\x62\x6c\x65\x2e\x62\x70\x66\x2e\x63\0\x69\x6e\x74\x20\x42\x50\x46\
\x5f\x4b\x50\x52\x4f\x42\x45\x28\x6b\x70\x72\x6f\x62\x65\x5f\x5f\x63\x61\x70\
\x5f\x63\x61\x70\x61\x62\x6c\x65\x5f\x65\x6e\x74\x72\x79\x2c\x20\x63\x6f\x6e\
\x73\x74\x20\x73\x74\x72\x75\x63\x74\x20\x63\x72\x65\x64\x20\x2a\x63\x72\x65\
\x64\x2c\x20\x73\x74\x72\x75\x63\x74\x20\x75\x73\x65\x72\x5f\x6e\x61\x6d\x65\
\x73\x70\x61\x63\x65\x20\x2a\x74\x61\x72\x67\x5f\x6e\x73\x2c\x20\x69\x6e\x74\
\x20\x63\x61\x70\x2c\x20\x69\x6e\x74\x20\x63\x61\x70\x5f\x6f\x70\x74\x29\0\x30\
\x3a\x31\x32\0\x09\x69\x66\x20\x28\x66\x69\x6c\x74\x65\x72\x5f\x63\x67\x20\x26\
\x26\x20\x21\x62\x70\x66\x5f\x63\x75\x72\x72\x65\x6e\x74\x5f\x74\x61\x73\x6b\
\x5f\x75\x6e\x64\x65\x72\x5f\x63\x67\x72\x6f\x75\x70\x28\x26\x63\x67\x72\x6f\
\x75\x70\x5f\x6d\x61\x70\x2c\x20\x30\x29\x29\0\x09\x70\x69\x64\x5f\x74\x67\x69\
\x64\x20\x3d\x20\x62\x70\x66\x5f\x67\x65\x74\x5f\x63\x75\x72\x72\x65\x6e\x74\
\x5f\x70\x69\x64\x5f\x74\x67\x69\x64\x28\x29\x3b\0\x09\x70\x69\x64\x20\x3d\x20\
\x70\x69\x64\x5f\x74\x67\x69\x64\x20\x3e\x3e\x20\x33\x32\x3b\0\x09\x69\x66\x20\
\x28\x70\x69\x64\x20\x3d\x3d\x20\x6d\x79\x5f\x70\x69\x64\x29\0\x09\x69\x66\x20\
\x28\x74\x61\x72\x67\x5f\x70\x69\x64\x20\x21\x3d\x20\x2d\x31\x20\x26\x26\x20\
\x74\x61\x72\x67\x5f\x70\x69\x64\x20\x21\x3d\x20\x70\x69\x64\x29\0\x09\x61\x72\
\x67\x73\x2e\x63\x61\x70\x5f\x6f\x70\x74\x20\x3d\x20\x63\x61\x70\x5f\x6f\x70\
\x74\x3b\0\x09\x61\x72\x67\x73\x2e\x63\x61\x70\x20\x3d\x20\x63\x61\x70\x3b\0\
\x09\x62\x70\x66\x5f\x6d\x61\x70\x5f\x75\x70\x64\x61\x74\x65\x5f\x65\x6c\x65\
\x6d\x28\x26\x73\x74\x61\x72\x74\x2c\x20\x26\x70\x69\x64\x5f\x74\x67\x69\x64\
\x2c\x20\x26\x61\x72\x67\x73\x2c\x20\x30\x29\x3b\0\x6b\x70\x72\x6f\x62\x65\x5f\
\x5f\x63\x61\x70\x5f\x63\x61\x70\x61\x62\x6c\x65\x5f\x65\x78\x69\x74\0\x6b\x72\
\x65\x74\x70\x72\x6f\x62\x65\x2f\x63\x61\x70\x5f\x63\x61\x70\x61\x62\x6c\x65\0\
\x69\x6e\x74\x20\x42\x50\x46\x5f\x4b\x52\x45\x54\x50\x52\x4f\x42\x45\x28\x6b\
\x70\x72\x6f\x62\x65\x5f\x5f\x63\x61\x70\x5f\x63\x61\x70\x61\x62\x6c\x65\x5f\
\x65\x78\x69\x74\x29\0\x09\x61\x70\x20\x3d\x20\x62\x70\x66\x5f\x6d\x61\x70\x5f\
\x6c\x6f\x6f\x6b\x75\x70\x5f\x65\x6c\x65\x6d\x28\x26\x73\x74\x61\x72\x74\x2c\
\x20\x26\x70\x69\x64\x5f\x74\x67\x69\x64\x29\x3b\0\x09\x69\x66\x20\x28\x21\x61\
\x70\x29\0\x09\x62\x70\x66\x5f\x6d\x61\x70\x5f\x64\x65\x6c\x65\x74\x65\x5f\x65\
\x6c\x65\x6d\x28\x26\x73\x74\x61\x72\x74\x2c\x20\x26\x70\x69\x64\x5f\x74\x67\
\x69\x64\x29\x3b\0\x09\x73\x74\x72\x75\x63\x74\x20\x63\x61\x70\x5f\x65\x76\x65\
\x6e\x74\x20\x65\x76\x65\x6e\x74\x20\x3d\x20\x7b\x7d\x3b\0\x09\x65\x76\x65\x6e\
\x74\x2e\x70\x69\x64\x20\x3d\x20\x70\x69\x64\x5f\x74\x67\x69\x64\x20\x3e\x3e\
\x20\x33\x32\x3b\0\x09\x65\x76\x65\x6e\x74\x2e\x74\x67\x69\x64\x20\x3d\x20\x70\
\x69\x64\x5f\x74\x67\x69\x64\x3b\0\x09\x65\x76\x65\x6e\x74\x2e\x63\x61\x70\x20\
\x3d\x20\x61\x70\x2d\x3e\x63\x61\x70\x3b\0\x09\x65\x76\x65\x6e\x74\x2e\x75\x69\
\x64\x20\x3d\x20\x62\x70\x66\x5f\x67\x65\x74\x5f\x63\x75\x72\x72\x65\x6e\x74\
\x5f\x75\x69\x64\x5f\x67\x69\x64\x28\x29\x3b\0\x09\x62\x70\x66\x5f\x67\x65\x74\
\x5f\x63\x75\x72\x72\x65\x6e\x74\x5f\x63\x6f\x6d\x6d\x28\x26\x65\x76\x65\x6e\
\x74\x2e\x74\x61\x73\x6b\x2c\x20\x73\x69\x7a\x65\x6f\x66\x28\x65\x76\x65\x6e\
\x74\x2e\x74\x61\x73\x6b\x29\x29\x3b\0\x30\x3a\x31\x30\0\x09\x65\x76\x65\x6e\
\x74\x2e\x72\x65\x74\x20\x3d\x20\x50\x54\x5f\x52\x45\x47\x53\x5f\x52\x43\x28\
\x63\x74\x78\x29\x3b\0\x09\x69\x66\x20\x28\x4c\x49\x4e\x55\x58\x5f\x4b\x45\x52\
\x4e\x45\x4c\x5f\x56\x45\x52\x53\x49\x4f\x4e\x20\x3e\x3d\x20\x4b\x45\x52\x4e\
\x45\x4c\x5f\x56\x45\x52\x53\x49\x4f\x4e\x28\x35\x2c\x20\x31\x2c\x20\x30\x29\
\x29\x20\x7b\0\x09\x09\x65\x76\x65\x6e\x74\x2e\x69\x6e\x73\x65\x74\x69\x64\x20\
\x3d\x20\x28\x61\x70\x2d\x3e\x63\x61\x70\x5f\x6f\x70\x74\x20\x26\x20\x30\x62\
\x31\x30\x30\x29\x20\x21\x3d\x20\x30\x3b\0\x09\x09\x65\x76\x65\x6e\x74\x2e\x61\
\x75\x64\x69\x74\x20\x3d\x20\x28\x61\x70\x2d\x3e\x63\x61\x70\x5f\x6f\x70\x74\
\x20\x26\x20\x30\x62\x31\x30\x29\x20\x3d\x3d\x20\x30\x3b\0\x09\x69\x66\x20\x28\
\x75\x6e\x69\x71\x75\x65\x5f\x74\x79\x70\x65\x29\x20\x7b\0\x09\x09\x73\x74\x72\
\x75\x63\x74\x20\x75\x6e\x69\x71\x75\x65\x5f\x6b\x65\x79\x20\x6b\x65\x79\x20\
\x3d\x20\x7b\x2e\x63\x61\x70\x20\x3d\x20\x61\x70\x2d\x3e\x63\x61\x70\x7d\x3b\0\
\x09\x09\x69\x66\x20\x28\x75\x6e\x69\x71\x75\x65\x5f\x74\x79\x70\x65\x20\x3d\
\x3d\x20\x55\x4e\x51\x5f\x43\x47\x52\x4f\x55\x50\x29\0\x09\x09\x09\x6b\x65\x79\
\x2e\x63\x67\x72\x6f\x75\x70\x69\x64\x20\x3d\x20\x62\x70\x66\x5f\x67\x65\x74\
\x5f\x63\x75\x72\x72\x65\x6e\x74\x5f\x63\x67\x72\x6f\x75\x70\x5f\x69\x64\x28\
\x29\x3b\0\x09\x09\x09\x6b\x65\x79\x2e\x74\x67\x69\x64\x20\x3d\x20\x70\x69\x64\
\x5f\x74\x67\x69\x64\x3b\0\x09\x09\x69\x66\x20\x28\x62\x70\x66\x5f\x6d\x61\x70\
\x5f\x6c\x6f\x6f\x6b\x75\x70\x5f\x65\x6c\x65\x6d\x28\x26\x73\x65\x65\x6e\x2c\
\x20\x26\x6b\x65\x79\x29\x20\x21\x3d\x20\x4e\x55\x4c\x4c\x29\0\x09\x09\x75\x36\
\x34\x20\x7a\x65\x72\x6f\x20\x3d\x20\x30\x3b\0\x09\x09\x62\x70\x66\x5f\x6d\x61\
\x70\x5f\x75\x70\x64\x61\x74\x65\x5f\x65\x6c\x65\x6d\x28\x26\x73\x65\x65\x6e\
\x2c\x20\x26\x6b\x65\x79\x2c\x20\x26\x7a\x65\x72\x6f\x2c\x20\x30\x29\x3b\0\x09\
\x69\x66\x20\x28\x6b\x65\x72\x6e\x65\x6c\x5f\x73\x74\x61\x63\x6b\x20\x7c\x7c\
\x20\x75\x73\x65\x72\x5f\x73\x74\x61\x63\x6b\x29\x20\x7b\0\x09\x09\x69\x5f\x6b\
\x65\x79\x2e\x6b\x65\x72\x6e\x5f\x73\x74\x61\x63\x6b\x5f\x69\x64\x20\x3d\x20\
\x69\x5f\x6b\x65\x79\x2e\x75\x73\x65\x72\x5f\x73\x74\x61\x63\x6b\x5f\x69\x64\
\x20\x3d\x20\x2d\x31\x3b\0\x09\x09\x69\x5f\x6b\x65\x79\x2e\x70\x69\x64\x20\x3d\
\x20\x70\x69\x64\x5f\x74\x67\x69\x64\x20\x3e\x3e\x20\x33\x32\x3b\0\x09\x09\x69\
\x5f\x6b\x65\x79\x2e\x74\x67\x69\x64\x20\x3d\x20\x70\x69\x64\x5f\x74\x67\x69\
\x64\x3b\0\x09\x09\x69\x66\x20\x28\x75\x73\x65\x72\x5f\x73\x74\x61\x63\x6b\x29\
\0\x09\x09\x09\x69\x5f\x6b\x65\x79\x2e\x75\x73\x65\x72\x5f\x73\x74\x61\x63\x6b\
\x5f\x69\x64\x20\x3d\x20\x62\x70\x66\x5f\x67\x65\x74\x5f\x73\x74\x61\x63\x6b\
\x69\x64\x28\x63\x74\x78\x2c\x20\x26\x73\x74\x61\x63\x6b\x6d\x61\x70\x2c\x20\
\x42\x50\x46\x5f\x46\x5f\x55\x53\x45\x52\x5f\x53\x54\x41\x43\x4b\x29\x3b\0\x09\
\x09\x69\x66\x20\x28\x6b\x65\x72\x6e\x65\x6c\x5f\x73\x74\x61\x63\x6b\x29\0\x09\
\x09\x09\x69\x5f\x6b\x65\x79\x2e\x6b\x65\x72\x6e\x5f\x73\x74\x61\x63\x6b\x5f\
\x69\x64\x20\x3d\x20\x62\x70\x66\x5f\x67\x65\x74\x5f\x73\x74\x61\x63\x6b\x69\
\x64\x28\x63\x74\x78\x2c\x20\x26\x73\x74\x61\x63\x6b\x6d\x61\x70\x2c\x20\x30\
\x29\x3b\0\x09\x09\x62\x70\x66\x5f\x6d\x61\x70\x5f\x75\x70\x64\x61\x74\x65\x5f\
\x65\x6c\x65\x6d\x28\x26\x69\x6e\x66\x6f\x2c\x20\x26\x69\x5f\x6b\x65\x79\x2c\
\x20\x26\x65\x76\x65\x6e\x74\x2c\x20\x42\x50\x46\x5f\x4e\x4f\x45\x58\x49\x53\
\x54\x29\x3b\0\x09\x62\x70\x66\x5f\x70\x65\x72\x66\x5f\x65\x76\x65\x6e\x74\x5f\
\x6f\x75\x74\x70\x75\x74\x28\x63\x74\x78\x2c\x20\x26\x65\x76\x65\x6e\x74\x73\
\x2c\x20\x42\x50\x46\x5f\x46\x5f\x43\x55\x52\x52\x45\x4e\x54\x5f\x43\x50\x55\
\x2c\x20\x26\x65\x76\x65\x6e\x74\x2c\x20\x73\x69\x7a\x65\x6f\x66\x28\x65\x76\
\x65\x6e\x74\x29\x29\x3b\0\x70\x69\x64\x5f\x74\0\x5f\x5f\x6b\x65\x72\x6e\x65\
\x6c\x5f\x70\x69\x64\x5f\x74\0\x6d\x79\x5f\x70\x69\x64\0\x75\x6e\x69\x71\x75\
\x65\x6e\x65\x73\x73\0\x55\x4e\x51\x5f\x4f\x46\x46\0\x55\x4e\x51\x5f\x50\x49\
\x44\0\x55\x4e\x51\x5f\x43\x47\x52\x4f\x55\x50\0\x75\x6e\x69\x71\x75\x65\x5f\
\x74\x79\x70\x65\0\x62\x6f\x6f\x6c\0\x5f\x42\x6f\x6f\x6c\0\x6b\x65\x72\x6e\x65\
\x6c\x5f\x73\x74\x61\x63\x6b\0\x75\x73\x65\x72\x5f\x73\x74\x61\x63\x6b\0\x66\
\x69\x6c\x74\x65\x72\x5f\x63\x67\0\x74\x61\x72\x67\x5f\x70\x69\x64\0\x4c\x49\
\x43\x45\x4e\x53\x45\0\x4c\x49\x4e\x55\x58\x5f\x4b\x45\x52\x4e\x45\x4c\x5f\x56\
\x45\x52\x53\x49\x4f\x4e\0\x2e\x6b\x63\x6f\x6e\x66\x69\x67\0\x2e\x6d\x61\x70\
\x73\0\x2e\x72\x6f\x64\x61\x74\x61\0\x6c\x69\x63\x65\x6e\x73\x65\0\0\0\x9f\xeb\
\x01\0\x20\0\0\0\0\0\0\0\x24\0\0\0\x24\0\0\0\xb4\x04\0\0\xd8\x04\0\0\x44\0\0\0\
\x08\0\0\0\x3b\x02\0\0\x01\0\0\0\0\0\0\0\x3a\0\0\0\x32\x04\0\0\x01\0\0\0\0\0\0\
\0\x3c\0\0\0\x10\0\0\0\x3b\x02\0\0\x12\0\0\0\0\0\0\0\x53\x02\0\0\x81\x02\0\0\
\x05\x2c\x01\0\x10\0\0\0\x53\x02\0\0\xff\x02\0\0\x06\x40\x01\0\x28\0\0\0\x53\
\x02\0\0\xff\x02\0\0\x10\x40\x01\0\x30\0\0\0\x53\x02\0\0\xff\x02\0\0\x14\x40\
\x01\0\x50\0\0\0\x53\x02\0\0\xff\x02\0\0\x10\x40\x01\0\x58\0\0\0\x53\x02\0\0\
\x41\x03\0\0\x0d\x4c\x01\0\x60\0\0\0\x53\x02\0\0\x41\x03\0\0\x0b\x4c\x01\0\x68\
\0\0\0\x53\x02\0\0\x69\x03\0\0\x11\x50\x01\0\x70\0\0\0\x53\x02\0\0\x80\x03\0\0\
\x0d\x58\x01\0\x88\0\0\0\x53\x02\0\0\x80\x03\0\0\x0a\x58\x01\0\x90\0\0\0\x53\
\x02\0\0\x94\x03\0\0\x06\x64\x01\0\xa8\0\0\0\x53\x02\0\0\x94\x03\0\0\x15\x64\
\x01\0\xb0\0\0\0\x53\x02\0\0\x94\x03\0\0\x18\x64\x01\0\xb8\0\0\0\x53\x02\0\0\
\x94\x03\0\0\x15\x64\x01\0\xc0\0\0\0\x53\x02\0\0\xbc\x03\0\0\x0f\x78\x01\0\xc8\
\0\0\0\x53\x02\0\0\xd5\x03\0\0\x0b\x74\x01\0\xf0\0\0\0\x53\x02\0\0\xe6\x03\0\0\
\x02\x7c\x01\0\x10\x01\0\0\x53\x02\0\0\x81\x02\0\0\x05\x2c\x01\0\x32\x04\0\0\
\x38\0\0\0\0\0\0\0\x53\x02\0\0\x48\x04\0\0\0\x94\x01\0\x08\0\0\0\x53\x02\0\0\
\x41\x03\0\0\x0d\xac\x01\0\x10\0\0\0\x53\x02\0\0\x41\x03\0\0\x0b\xac\x01\0\x28\
\0\0\0\x53\x02\0\0\x74\x04\0\0\x07\xb0\x01\0\x48\0\0\0\x53\x02\0\0\xa2\x04\0\0\
\x06\xb4\x01\0\x60\0\0\0\x53\x02\0\0\xac\x04\0\0\x02\xc0\x01\0\x80\0\0\0\x53\
\x02\0\0\xd5\x04\0\0\x13\xc8\x01\0\xc0\0\0\0\x53\x02\0\0\xf3\x04\0\0\x0e\xcc\
\x01\0\xc8\0\0\0\x53\x02\0\0\x10\x05\0\0\x0d\xd0\x01\0\xd0\0\0\0\x53\x02\0\0\
\xf3\x04\0\0\x17\xcc\x01\0\xd8\0\0\0\x53\x02\0\0\xf3\x04\0\0\x0c\xcc\x01\0\xe0\
\0\0\0\x53\x02\0\0\x28\x05\0\0\x12\xd4\x01\0\xe8\0\0\0\x53\x02\0\0\x28\x05\0\0\
\x0c\xd4\x01\0\xf0\0\0\0\x53\x02\0\0\x3e\x05\0\0\x0e\xd8\x01\0\xf8\0\0\0\x53\
\x02\0\0\x3e\x05\0\0\x0c\xd8\x01\0\0\x01\0\0\x53\x02\0\0\xd5\x04\0\0\x13\xc8\
\x01\0\x10\x01\0\0\x53\x02\0\0\x66\x05\0\0\x02\xdc\x01\0\x20\x01\0\0\x53\x02\0\
\0\xa3\x05\0\0\x0e\xe0\x01\0\x28\x01\0\0\x53\x02\0\0\xa3\x05\0\0\x0c\xe0\x01\0\
\x40\x01\0\0\x53\x02\0\0\xc1\x05\0\0\x06\xe8\x01\0\x58\x01\0\0\x53\x02\0\0\xc1\
\x05\0\0\x1b\xe8\x01\0\x60\x01\0\0\x53\x02\0\0\xf9\x05\0\0\x29\xf4\x01\0\x78\
\x01\0\0\x53\x02\0\0\x27\x06\0\0\x26\xf0\x01\0\xa0\x01\0\0\x53\x02\0\0\x52\x06\
\0\0\x06\x0c\x02\0\xc0\x01\0\0\x53\x02\0\0\x66\x06\0\0\x27\x10\x02\0\xd0\x01\0\
\0\x53\x02\0\0\x66\x06\0\0\x1b\x10\x02\0\xf0\x01\0\0\x53\x02\0\0\x92\x06\0\0\
\x07\x14\x02\0\xf8\x01\0\0\x53\x02\0\0\x92\x06\0\0\x13\x14\x02\0\0\x02\0\0\x53\
\x02\0\0\xb3\x06\0\0\x13\x18\x02\0\x08\x02\0\0\x53\x02\0\0\xb3\x06\0\0\x11\x18\
\x02\0\x10\x02\0\0\x53\x02\0\0\xb3\x06\0\0\x04\x18\x02\0\x18\x02\0\0\x53\x02\0\
\0\xe2\x06\0\0\x0f\x20\x02\0\x20\x02\0\0\x53\x02\0\0\xe2\x06\0\0\x0d\x20\x02\0\
\x38\x02\0\0\x53\x02\0\0\xfa\x06\0\0\x07\x28\x02\0\x50\x02\0\0\x53\x02\0\0\xfa\
\x06\0\0\x28\x28\x02\0\x60\x02\0\0\x53\x02\0\0\x2a\x07\0\0\x07\x34\x02\0\x88\
\x02\0\0\x53\x02\0\0\x3a\x07\0\0\x03\x38\x02\0\xa8\x02\0\0\x53\x02\0\0\x68\x07\
\0\0\x06\x44\x02\0\xc0\x02\0\0\x53\x02\0\0\x68\x07\0\0\x13\x44\x02\0\xc8\x02\0\
\0\x53\x02\0\0\x68\x07\0\0\x16\x44\x02\0\xe0\x02\0\0\x53\x02\0\0\x68\x07\0\0\
\x13\x44\x02\0\xf0\x02\0\0\x53\x02\0\0\x8b\x07\0\0\x17\x54\x02\0\xf8\x02\0\0\
\x53\x02\0\0\x8b\x07\0\0\x2d\x54\x02\0\0\x03\0\0\x53\x02\0\0\xbd\x07\0\0\x0f\
\x48\x02\0\x08\x03\0\0\x53\x02\0\0\xdb\x07\0\0\x0e\x4c\x02\0\x10\x03\0\0\x53\
\x02\0\0\xbd\x07\0\0\x18\x48\x02\0\x18\x03\0\0\x53\x02\0\0\xbd\x07\0\0\x0d\x48\
\x02\0\x20\x03\0\0\x53\x02\0\0\xf4\x07\0\0\x07\x58\x02\0\x40\x03\0\0\x53\x02\0\
\0\x06\x08\0\0\x1a\x5c\x02\0\x68\x03\0\0\x53\x02\0\0\x06\x08\0\0\x18\x5c\x02\0\
\x70\x03\0\0\x53\x02\0\0\x52\x08\0\0\x07\x60\x02\0\x90\x03\0\0\x53\x02\0\0\x66\
\x08\0\0\x1a\x64\x02\0\xb8\x03\0\0\x53\x02\0\0\x66\x08\0\0\x18\x64\x02\0\xe0\
\x03\0\0\x53\x02\0\0\xa3\x08\0\0\x03\x6c\x02\0\x10\x04\0\0\x53\x02\0\0\xde\x08\
\0\0\x02\x74\x02\0\x48\x04\0\0\x53\x02\0\0\x48\x04\0\0\x05\x94\x01\0\x10\0\0\0\
\x3b\x02\0\0\x02\0\0\0\0\0\0\0\x30\0\0\0\x4e\x02\0\0\0\0\0\0\x08\0\0\0\x30\0\0\
\0\xfa\x02\0\0\0\0\0\0\x32\x04\0\0\x01\0\0\0\x20\x01\0\0\x30\0\0\0\x9e\x05\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x03\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x05\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x01\0\0\0\x12\0\x03\0\0\0\0\0\0\0\0\0\x20\x01\0\0\0\0\0\0\x9e\0\0\0\x11\0\
\x07\0\x0a\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\x63\0\0\0\x11\0\x09\0\x20\0\0\0\0\0\
\0\0\x20\0\0\0\0\0\0\0\xed\0\0\0\x11\0\x07\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\
\xf4\0\0\0\x11\0\x07\0\x0c\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\x2e\0\0\0\x11\0\x09\
\0\0\0\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x34\0\0\0\x12\0\x05\0\0\0\0\0\0\0\0\0\x58\
\x04\0\0\0\0\0\0\x15\x01\0\0\x10\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb0\0\0\
\0\x11\0\x07\0\x04\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\x73\0\0\0\x11\0\x09\0\x88\0\
\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x83\0\0\0\x11\0\x07\0\x08\0\0\0\0\0\0\0\x01\0\0\
\0\0\0\0\0\x78\0\0\0\x11\0\x07\0\x09\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\x5a\0\0\0\
\x11\0\x09\0\x58\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x6e\0\0\0\x11\0\x09\0\x68\0\0\
\0\0\0\0\0\x20\0\0\0\0\0\0\0\x4d\0\0\0\x11\0\x09\0\x40\0\0\0\0\0\0\0\x18\0\0\0\
\0\0\0\0\x33\x01\0\0\x11\0\x08\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\x10\0\0\0\0\
\0\0\0\x01\0\0\0\x04\0\0\0\x30\0\0\0\0\0\0\0\x01\0\0\0\x05\0\0\0\x70\0\0\0\0\0\
\0\0\x01\0\0\0\x06\0\0\0\x90\0\0\0\0\0\0\0\x01\0\0\0\x07\0\0\0\xf0\0\0\0\0\0\0\
\0\x01\0\0\0\x08\0\0\0\x28\0\0\0\0\0\0\0\x01\0\0\0\x08\0\0\0\x60\0\0\0\0\0\0\0\
\x01\0\0\0\x08\0\0\0\x40\x01\0\0\0\0\0\0\x01\0\0\0\x0a\0\0\0\xa0\x01\0\0\0\0\0\
\0\x01\0\0\0\x0b\0\0\0\x38\x02\0\0\0\0\0\0\x01\0\0\0\x0c\0\0\0\x88\x02\0\0\0\0\
\0\0\x01\0\0\0\x0c\0\0\0\xa8\x02\0\0\0\0\0\0\x01\0\0\0\x0d\0\0\0\xc8\x02\0\0\0\
\0\0\0\x01\0\0\0\x0e\0\0\0\x20\x03\0\0\0\0\0\0\x01\0\0\0\x0e\0\0\0\x48\x03\0\0\
\0\0\0\0\x01\0\0\0\x0f\0\0\0\x70\x03\0\0\0\0\0\0\x01\0\0\0\x0d\0\0\0\x98\x03\0\
\0\0\0\0\0\x01\0\0\0\x0f\0\0\0\xe0\x03\0\0\0\0\0\0\x01\0\0\0\x10\0\0\0\x18\x04\
\0\0\0\0\0\0\x01\0\0\0\x11\0\0\0\x64\x08\0\0\0\0\0\0\x03\0\0\0\x0a\0\0\0\x7c\
\x08\0\0\0\0\0\0\x04\0\0\0\x08\0\0\0\x88\x08\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\
\x94\x08\0\0\0\0\0\0\x04\0\0\0\x11\0\0\0\xa0\x08\0\0\0\0\0\0\x04\0\0\0\x0f\0\0\
\0\xac\x08\0\0\0\0\0\0\x04\0\0\0\x10\0\0\0\xb8\x08\0\0\0\0\0\0\x04\0\0\0\x0c\0\
\0\0\xd0\x08\0\0\0\0\0\0\x03\0\0\0\x06\0\0\0\xdc\x08\0\0\0\0\0\0\x03\0\0\0\x0b\
\0\0\0\xe8\x08\0\0\0\0\0\0\x03\0\0\0\x0d\0\0\0\xf4\x08\0\0\0\0\0\0\x03\0\0\0\
\x0e\0\0\0\0\x09\0\0\0\0\0\0\x03\0\0\0\x04\0\0\0\x0c\x09\0\0\0\0\0\0\x03\0\0\0\
\x07\0\0\0\x24\x09\0\0\0\0\0\0\x04\0\0\0\x12\0\0\0\x2c\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\x3c\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x50\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\x60\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x70\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\x80\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x90\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\xa0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xb0\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\xc0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xd0\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\xe0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xf0\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\0\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x10\x01\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\x20\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x30\x01\0\0\0\0\0\0\x04\0\0\
\0\x01\0\0\0\x40\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x50\x01\0\0\0\0\0\0\x04\0\
\0\0\x01\0\0\0\x60\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x78\x01\0\0\0\0\0\0\x04\
\0\0\0\x02\0\0\0\x88\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x98\x01\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\xa8\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xb8\x01\0\0\0\0\0\
\0\x04\0\0\0\x02\0\0\0\xc8\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xd8\x01\0\0\0\0\
\0\0\x04\0\0\0\x02\0\0\0\xe8\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xf8\x01\0\0\0\
\0\0\0\x04\0\0\0\x02\0\0\0\x08\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x18\x02\0\0\
\0\0\0\0\x04\0\0\0\x02\0\0\0\x28\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x38\x02\0\
\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x48\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x58\x02\
\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x68\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x78\
\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x88\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\
\x98\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xa8\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\
\0\xb8\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xc8\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\
\0\0\xd8\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xe8\x02\0\0\0\0\0\0\x04\0\0\0\x02\
\0\0\0\xf8\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x08\x03\0\0\0\0\0\0\x04\0\0\0\
\x02\0\0\0\x18\x03\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x28\x03\0\0\0\0\0\0\x04\0\0\
\0\x02\0\0\0\x38\x03\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x48\x03\0\0\0\0\0\0\x04\0\
\0\0\x02\0\0\0\x58\x03\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x68\x03\0\0\0\0\0\0\x04\
\0\0\0\x02\0\0\0\x78\x03\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x88\x03\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\x98\x03\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xa8\x03\0\0\0\0\0\
\0\x04\0\0\0\x02\0\0\0\xb8\x03\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xc8\x03\0\0\0\0\
\0\0\x04\0\0\0\x02\0\0\0\xd8\x03\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xe8\x03\0\0\0\
\0\0\0\x04\0\0\0\x02\0\0\0\xf8\x03\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x08\x04\0\0\
\0\0\0\0\x04\0\0\0\x02\0\0\0\x18\x04\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x28\x04\0\
\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x38\x04\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x48\x04\
\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x58\x04\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x68\
\x04\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x78\x04\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\
\x88\x04\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x98\x04\0\0\0\0\0\0\x04\0\0\0\x02\0\0\
\0\xa8\x04\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xb8\x04\0\0\0\0\0\0\x04\0\0\0\x02\0\
\0\0\xc8\x04\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xd8\x04\0\0\0\0\0\0\x04\0\0\0\x02\
\0\0\0\xe8\x04\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x04\x05\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\x14\x05\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x2c\x05\0\0\0\0\0\0\x04\0\0\
\0\x02\0\0\0\x0d\x13\x10\x15\x17\x18\x0e\x11\x1c\x12\x0f\x1b\x19\x1a\x16\0\x6b\
\x70\x72\x6f\x62\x65\x5f\x5f\x63\x61\x70\x5f\x63\x61\x70\x61\x62\x6c\x65\x5f\
\x65\x6e\x74\x72\x79\0\x2e\x74\x65\x78\x74\0\x2e\x72\x65\x6c\x2e\x42\x54\x46\
\x2e\x65\x78\x74\0\x73\x74\x61\x72\x74\0\x6b\x70\x72\x6f\x62\x65\x5f\x5f\x63\
\x61\x70\x5f\x63\x61\x70\x61\x62\x6c\x65\x5f\x65\x78\x69\x74\0\x65\x76\x65\x6e\
\x74\x73\0\x2e\x6d\x61\x70\x73\0\x73\x74\x61\x63\x6b\x6d\x61\x70\0\x63\x67\x72\
\x6f\x75\x70\x5f\x6d\x61\x70\0\x69\x6e\x66\x6f\0\x73\x65\x65\x6e\0\x75\x73\x65\
\x72\x5f\x73\x74\x61\x63\x6b\0\x6b\x65\x72\x6e\x65\x6c\x5f\x73\x74\x61\x63\x6b\
\0\x2e\x6c\x6c\x76\x6d\x5f\x61\x64\x64\x72\x73\x69\x67\0\x66\x69\x6c\x74\x65\
\x72\x5f\x63\x67\0\x6c\x69\x63\x65\x6e\x73\x65\0\x75\x6e\x69\x71\x75\x65\x5f\
\x74\x79\x70\x65\0\x2e\x72\x65\x6c\x6b\x72\x65\x74\x70\x72\x6f\x62\x65\x2f\x63\
\x61\x70\x5f\x63\x61\x70\x61\x62\x6c\x65\0\x2e\x72\x65\x6c\x6b\x70\x72\x6f\x62\
\x65\x2f\x63\x61\x70\x5f\x63\x61\x70\x61\x62\x6c\x65\0\x6d\x79\x5f\x70\x69\x64\
\0\x74\x61\x72\x67\x5f\x70\x69\x64\0\x2e\x73\x74\x72\x74\x61\x62\0\x2e\x73\x79\
\x6d\x74\x61\x62\0\x2e\x72\x6f\x64\x61\x74\x61\0\x4c\x49\x4e\x55\x58\x5f\x4b\
\x45\x52\x4e\x45\x4c\x5f\x56\x45\x52\x53\x49\x4f\x4e\0\x2e\x72\x65\x6c\x2e\x42\
\x54\x46\0\x4c\x49\x43\x45\x4e\x53\x45\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\xfd\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\xa7\x27\0\0\0\0\0\0\x3b\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x1b\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xda\0\
\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\x20\x01\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xd6\0\0\0\x09\0\0\0\
\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x98\x20\0\0\0\0\0\0\x50\0\0\0\0\0\0\0\x0f\0\
\0\0\x03\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xc0\0\0\0\x01\0\0\0\x06\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x60\x01\0\0\0\0\0\0\x58\x04\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xbc\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\xe8\x20\0\0\0\0\0\0\xe0\0\0\0\0\0\0\0\x0f\0\0\0\x05\0\0\0\x08\0\
\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x0d\x01\0\0\x01\0\0\0\x02\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\xb8\x05\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\xa8\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xc8\
\x05\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\x54\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xd0\x05\0\0\0\0\0\
\0\xa8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x2e\x01\
\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x78\x06\0\0\0\0\0\0\x1a\x13\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x2a\x01\0\0\x09\0\0\
\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xc8\x21\0\0\0\0\0\0\xe0\0\0\0\0\0\0\0\x0f\
\0\0\0\x0a\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x25\0\0\0\x01\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x94\x19\0\0\0\0\0\0\x3c\x05\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x21\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\xa8\x22\0\0\0\0\0\0\xf0\x04\0\0\0\0\0\0\x0f\0\0\0\x0c\0\0\0\x08\
\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x90\0\0\0\x03\x4c\xff\x6f\0\0\0\x80\0\0\0\0\0\
\0\0\0\0\0\0\0\x98\x27\0\0\0\0\0\0\x0f\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x05\x01\0\0\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\xd0\x1e\0\0\0\0\0\0\xc8\x01\0\0\0\0\0\0\x01\0\0\0\x03\0\0\0\x08\0\0\0\0\0\0\0\
\x18\0\0\0\0\0\0\0";

	*sz = sizeof(data) - 1;
	return (const void *)data;
}

#ifdef __cplusplus
struct capable_bpf *capable_bpf::open(const struct bpf_object_open_opts *opts) { return capable_bpf__open_opts(opts); }
struct capable_bpf *capable_bpf::open_and_load() { return capable_bpf__open_and_load(); }
int capable_bpf::load(struct capable_bpf *skel) { return capable_bpf__load(skel); }
int capable_bpf::attach(struct capable_bpf *skel) { return capable_bpf__attach(skel); }
void capable_bpf::detach(struct capable_bpf *skel) { capable_bpf__detach(skel); }
void capable_bpf::destroy(struct capable_bpf *skel) { capable_bpf__destroy(skel); }
const void *capable_bpf::elf_bytes(size_t *sz) { return capable_bpf__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
capable_bpf__assert(struct capable_bpf *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
	_Static_assert(sizeof(s->rodata->my_pid) == 4, "unexpected size of 'my_pid'");
	_Static_assert(sizeof(s->rodata->unique_type) == 4, "unexpected size of 'unique_type'");
	_Static_assert(sizeof(s->rodata->kernel_stack) == 1, "unexpected size of 'kernel_stack'");
	_Static_assert(sizeof(s->rodata->user_stack) == 1, "unexpected size of 'user_stack'");
	_Static_assert(sizeof(s->rodata->filter_cg) == 1, "unexpected size of 'filter_cg'");
	_Static_assert(sizeof(s->rodata->targ_pid) == 4, "unexpected size of 'targ_pid'");
	_Static_assert(sizeof(s->kconfig->LINUX_KERNEL_VERSION) == 4, "unexpected size of 'LINUX_KERNEL_VERSION'");
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __CAPABLE_BPF_SKEL_H__ */
