/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __JAVAGC_BPF_SKEL_H__
#define __JAVAGC_BPF_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

#define BPF_SKEL_SUPPORTS_MAP_AUTO_ATTACH 1

struct javagc_bpf {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *__bpf_usdt_specs;
		struct bpf_map *__bpf_usdt_ip_to_spec_id;
		struct bpf_map *data_map;
		struct bpf_map *perf_map;
		struct bpf_map *bss;
		struct bpf_map *kconfig;
	} maps;
	struct {
		struct bpf_program *handle_gc_start;
		struct bpf_program *handle_gc_end;
		struct bpf_program *handle_mem_pool_gc_start;
		struct bpf_program *handle_mem_pool_gc_end;
	} progs;
	struct {
		struct bpf_link *handle_gc_start;
		struct bpf_link *handle_gc_end;
		struct bpf_link *handle_mem_pool_gc_start;
		struct bpf_link *handle_mem_pool_gc_end;
	} links;
	struct javagc_bpf__bss {
		__u32 time;
	} *bss;
	struct javagc_bpf__kconfig {
		const _Bool LINUX_HAS_BPF_COOKIE;
	} *kconfig;

#ifdef __cplusplus
	static inline struct javagc_bpf *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct javagc_bpf *open_and_load();
	static inline int load(struct javagc_bpf *skel);
	static inline int attach(struct javagc_bpf *skel);
	static inline void detach(struct javagc_bpf *skel);
	static inline void destroy(struct javagc_bpf *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
javagc_bpf__destroy(struct javagc_bpf *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
javagc_bpf__create_skeleton(struct javagc_bpf *obj);

static inline struct javagc_bpf *
javagc_bpf__open_opts(const struct bpf_object_open_opts *opts)
{
	struct javagc_bpf *obj;
	int err;

	obj = (struct javagc_bpf *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = javagc_bpf__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	javagc_bpf__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct javagc_bpf *
javagc_bpf__open(void)
{
	return javagc_bpf__open_opts(NULL);
}

static inline int
javagc_bpf__load(struct javagc_bpf *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct javagc_bpf *
javagc_bpf__open_and_load(void)
{
	struct javagc_bpf *obj;
	int err;

	obj = javagc_bpf__open();
	if (!obj)
		return NULL;
	err = javagc_bpf__load(obj);
	if (err) {
		javagc_bpf__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
javagc_bpf__attach(struct javagc_bpf *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
javagc_bpf__detach(struct javagc_bpf *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *javagc_bpf__elf_bytes(size_t *sz);

static inline int
javagc_bpf__create_skeleton(struct javagc_bpf *obj)
{
	struct bpf_object_skeleton *s;
	struct bpf_map_skeleton *map __attribute__((unused));
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "javagc_bpf";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 6;
	s->map_skel_sz = 24;
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt,
			sizeof(*s->maps) > 24 ? sizeof(*s->maps) : 24);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	map = (struct bpf_map_skeleton *)((char *)s->maps + 0 * s->map_skel_sz);
	map->name = "__bpf_usdt_specs";
	map->map = &obj->maps.__bpf_usdt_specs;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 1 * s->map_skel_sz);
	map->name = "__bpf_usdt_ip_to_spec_id";
	map->map = &obj->maps.__bpf_usdt_ip_to_spec_id;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 2 * s->map_skel_sz);
	map->name = "data_map";
	map->map = &obj->maps.data_map;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 3 * s->map_skel_sz);
	map->name = "perf_map";
	map->map = &obj->maps.perf_map;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 4 * s->map_skel_sz);
	map->name = "javagc_b.bss";
	map->map = &obj->maps.bss;
	map->mmaped = (void **)&obj->bss;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 5 * s->map_skel_sz);
	map->name = "javagc_.kconfig";
	map->map = &obj->maps.kconfig;
	map->mmaped = (void **)&obj->kconfig;

	/* programs */
	s->prog_cnt = 4;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "handle_gc_start";
	s->progs[0].prog = &obj->progs.handle_gc_start;
	s->progs[0].link = &obj->links.handle_gc_start;

	s->progs[1].name = "handle_gc_end";
	s->progs[1].prog = &obj->progs.handle_gc_end;
	s->progs[1].link = &obj->links.handle_gc_end;

	s->progs[2].name = "handle_mem_pool_gc_start";
	s->progs[2].prog = &obj->progs.handle_mem_pool_gc_start;
	s->progs[2].link = &obj->links.handle_mem_pool_gc_start;

	s->progs[3].name = "handle_mem_pool_gc_end";
	s->progs[3].prog = &obj->progs.handle_mem_pool_gc_end;
	s->progs[3].link = &obj->links.handle_mem_pool_gc_end;

	s->data = javagc_bpf__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *javagc_bpf__elf_bytes(size_t *sz)
{
	static const char data[] __attribute__((__aligned__(8))) = "\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x50\x36\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x0f\0\
\x01\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x71\x22\0\0\0\0\0\0\x56\x02\x0c\0\0\
\0\0\0\x79\x11\x80\0\0\0\0\0\x7b\x1a\xf8\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\
\x02\0\0\xf8\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\
\0\xbf\x01\0\0\0\0\0\0\xb4\0\0\0\xfd\xff\xff\xff\x15\x01\x03\0\0\0\0\0\x61\x10\
\0\0\0\0\0\0\x05\0\x01\0\0\0\0\0\x85\0\0\0\xae\0\0\0\xb4\x06\0\0\xfd\xff\xff\
\xff\x63\x0a\xf4\xff\0\0\0\0\xc6\0\x09\0\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\
\0\xf4\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\x15\
\0\x03\0\0\0\0\0\x69\x06\x28\x01\0\0\0\0\x64\x06\0\0\x10\0\0\0\xc4\x06\0\0\x10\
\0\0\0\xbc\x60\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xbf\x36\0\0\0\0\0\0\xbf\x29\0\0\0\
\0\0\0\xbf\x17\0\0\0\0\0\0\xb7\x01\0\0\0\0\0\0\x7b\x16\0\0\0\0\0\0\x18\x01\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x71\x11\0\0\0\0\0\0\x56\x01\x0c\0\0\0\0\0\x79\x71\x80\
\0\0\0\0\0\x7b\x1a\xf8\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xf8\xff\xff\
\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\xbf\x01\0\0\0\0\0\
\0\xb4\0\0\0\xfd\xff\xff\xff\x15\x01\x04\0\0\0\0\0\x61\x10\0\0\0\0\0\0\x05\0\
\x02\0\0\0\0\0\xbf\x71\0\0\0\0\0\0\x85\0\0\0\xae\0\0\0\xb4\x08\0\0\xfd\xff\xff\
\xff\x63\x0a\xec\xff\0\0\0\0\xc6\0\x5d\0\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\
\0\xec\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\x15\
\0\x57\0\0\0\0\0\xb4\x08\0\0\xfe\xff\xff\xff\x25\x09\x55\0\x0b\0\0\0\x69\x01\
\x28\x01\0\0\0\0\x67\x01\0\0\x30\0\0\0\xc7\x01\0\0\x30\0\0\0\x3d\x19\x51\0\0\0\
\0\0\x27\x09\0\0\x18\0\0\0\x0f\x90\0\0\0\0\0\0\xb4\x08\0\0\xea\xff\xff\xff\x61\
\x01\x08\0\0\0\0\0\x54\x01\0\0\xff\0\0\0\x66\x01\x11\0\x01\0\0\0\x16\x01\x4c\0\
\0\0\0\0\x16\x01\x01\0\x01\0\0\0\x05\0\x48\0\0\0\0\0\x69\x01\x0e\0\0\0\0\0\x67\
\x01\0\0\x30\0\0\0\xc7\x01\0\0\x30\0\0\0\x0f\x17\0\0\0\0\0\0\xbf\xa1\0\0\0\0\0\
\0\x07\x01\0\0\xf8\xff\xff\xff\xb4\x02\0\0\x08\0\0\0\xbf\x73\0\0\0\0\0\0\xbf\
\x07\0\0\0\0\0\0\x85\0\0\0\x71\0\0\0\xbf\x08\0\0\0\0\0\0\xbf\x70\0\0\0\0\0\0\
\x16\x08\x2c\0\0\0\0\0\x05\0\x3a\0\0\0\0\0\x16\x01\x3e\0\x02\0\0\0\x16\x01\x01\
\0\x03\0\0\0\x05\0\x37\0\0\0\0\0\x69\x01\x0e\0\0\0\0\0\x67\x01\0\0\x30\0\0\0\
\xc7\x01\0\0\x30\0\0\0\xbf\x73\0\0\0\0\0\0\x0f\x13\0\0\0\0\0\0\xbf\xa1\0\0\0\0\
\0\0\x07\x01\0\0\xf8\xff\xff\xff\xb4\x02\0\0\x08\0\0\0\xbf\x09\0\0\0\0\0\0\x85\
\0\0\0\x71\0\0\0\xbf\x08\0\0\0\0\0\0\xbf\x91\0\0\0\0\0\0\x56\x08\x2a\0\0\0\0\0\
\x61\x11\x08\0\0\0\0\0\x74\x01\0\0\x10\0\0\0\x54\x01\0\0\xff\x0f\0\0\x0f\x17\0\
\0\0\0\0\0\xbf\xa1\0\0\0\0\0\0\x07\x01\0\0\xf0\xff\xff\xff\xb4\x02\0\0\x08\0\0\
\0\xbf\x73\0\0\0\0\0\0\x85\0\0\0\x71\0\0\0\xbf\x08\0\0\0\0\0\0\xbf\x91\0\0\0\0\
\0\0\x56\x08\x1e\0\0\0\0\0\x79\x13\0\0\0\0\0\0\x79\xa2\xf8\xff\0\0\0\0\x0f\x23\
\0\0\0\0\0\0\x61\x11\x08\0\0\0\0\0\x74\x01\0\0\x1c\0\0\0\x79\xa2\xf0\xff\0\0\0\
\0\x6f\x12\0\0\0\0\0\0\x0f\x23\0\0\0\0\0\0\xbf\xa1\0\0\0\0\0\0\x07\x01\0\0\xf8\
\xff\xff\xff\xb4\x02\0\0\x08\0\0\0\x85\0\0\0\x70\0\0\0\xbf\x08\0\0\0\0\0\0\xbf\
\x90\0\0\0\0\0\0\x56\x08\x0f\0\0\0\0\0\x71\x01\x11\0\0\0\0\0\x67\x01\0\0\x38\0\
\0\0\xc7\x01\0\0\x38\0\0\0\x67\x01\0\0\x20\0\0\0\x77\x01\0\0\x20\0\0\0\x79\xa2\
\xf8\xff\0\0\0\0\x6f\x12\0\0\0\0\0\0\xbf\x23\0\0\0\0\0\0\xcf\x13\0\0\0\0\0\0\
\x71\x04\x10\0\0\0\0\0\x56\x04\x02\0\0\0\0\0\x7f\x12\0\0\0\0\0\0\xbf\x23\0\0\0\
\0\0\0\x7b\x36\0\0\0\0\0\0\xb4\x08\0\0\0\0\0\0\xbc\x80\0\0\0\0\0\0\x95\0\0\0\0\
\0\0\0\x79\x01\0\0\0\0\0\0\x7b\x1a\xf8\xff\0\0\0\0\x05\0\xec\xff\0\0\0\0\x69\
\x01\x0e\0\0\0\0\0\x67\x01\0\0\x30\0\0\0\xc7\x01\0\0\x30\0\0\0\x0f\x17\0\0\0\0\
\0\0\xbf\xa1\0\0\0\0\0\0\x07\x01\0\0\xf8\xff\xff\xff\xb4\x02\0\0\x08\0\0\0\xbf\
\x73\0\0\0\0\0\0\xbf\x07\0\0\0\0\0\0\x85\0\0\0\x71\0\0\0\xbf\x08\0\0\0\0\0\0\
\xbf\x71\0\0\0\0\0\0\x56\x08\xee\xff\0\0\0\0\x79\x11\0\0\0\0\0\0\x79\xa3\xf8\
\xff\0\0\0\0\x0f\x13\0\0\0\0\0\0\xbf\xa1\0\0\0\0\0\0\x07\x01\0\0\xf8\xff\xff\
\xff\xb4\x02\0\0\x08\0\0\0\x85\0\0\0\x70\0\0\0\xbf\x08\0\0\0\0\0\0\xbf\x70\0\0\
\0\0\0\0\x16\x08\xd5\xff\0\0\0\0\x05\0\xe3\xff\0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x71\x22\0\0\0\0\0\0\x56\x02\x0c\0\0\0\0\0\x79\x11\x80\0\0\0\0\0\
\x7b\x1a\xf8\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xf8\xff\xff\xff\x18\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\xbf\x01\0\0\0\0\0\0\xb4\0\
\0\0\xfd\xff\xff\xff\x15\x01\x03\0\0\0\0\0\x61\x10\0\0\0\0\0\0\x05\0\x01\0\0\0\
\0\0\x85\0\0\0\xae\0\0\0\xb7\x06\0\0\0\0\0\0\x63\x0a\xf4\xff\0\0\0\0\xc6\0\x07\
\0\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xf4\xff\xff\xff\x18\x01\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\x15\0\x01\0\0\0\0\0\x79\x06\x20\x01\0\0\0\
\0\xbf\x60\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\x85\0\0\0\x08\0\0\0\x63\x0a\xf0\xff\0\
\0\0\0\x85\0\0\0\x0e\0\0\0\x77\0\0\0\x20\0\0\0\x63\x0a\xf4\xff\0\0\0\0\x85\0\0\
\0\x05\0\0\0\x7b\x0a\xf8\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xf4\xff\
\xff\xff\xbf\xa3\0\0\0\0\0\0\x07\x03\0\0\xf0\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\xb7\x04\0\0\0\0\0\0\x85\0\0\0\x02\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\
\0\0\0\0\0\0\xbf\x16\0\0\0\0\0\0\x85\0\0\0\x08\0\0\0\x63\x0a\xf0\xff\0\0\0\0\
\x85\0\0\0\x0e\0\0\0\x77\0\0\0\x20\0\0\0\x63\x0a\xf4\xff\0\0\0\0\x85\0\0\0\x05\
\0\0\0\x7b\x0a\xf8\xff\0\0\0\0\xbf\xa7\0\0\0\0\0\0\x07\x07\0\0\xf4\xff\xff\xff\
\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xbf\x72\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\
\x15\0\x17\0\0\0\0\0\x79\x02\x08\0\0\0\0\0\x79\xa1\xf8\xff\0\0\0\0\x1f\x21\0\0\
\0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x61\x22\0\0\0\0\0\0\x3e\x12\x0c\0\
\0\0\0\0\x67\x01\0\0\x20\0\0\0\x77\x01\0\0\x20\0\0\0\x7b\x1a\xf8\xff\0\0\0\0\
\xbf\xa4\0\0\0\0\0\0\x07\x04\0\0\xf0\xff\xff\xff\xbf\x61\0\0\0\0\0\0\x18\x02\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x18\x03\0\0\xff\xff\xff\xff\0\0\0\0\0\0\0\0\xb7\x05\
\0\0\x10\0\0\0\x85\0\0\0\x19\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xbf\x72\
\0\0\0\0\0\0\x85\0\0\0\x03\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\x85\0\0\0\
\x08\0\0\0\x63\x0a\xf0\xff\0\0\0\0\x85\0\0\0\x0e\0\0\0\x77\0\0\0\x20\0\0\0\x63\
\x0a\xf4\xff\0\0\0\0\x85\0\0\0\x05\0\0\0\x7b\x0a\xf8\xff\0\0\0\0\xbf\xa2\0\0\0\
\0\0\0\x07\x02\0\0\xf4\xff\xff\xff\xbf\xa3\0\0\0\0\0\0\x07\x03\0\0\xf0\xff\xff\
\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb7\x04\0\0\0\0\0\0\x85\0\0\0\x02\0\0\
\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xbf\x16\0\0\0\0\0\0\x85\0\0\0\x08\0\0\0\
\x63\x0a\xf0\xff\0\0\0\0\x85\0\0\0\x0e\0\0\0\x77\0\0\0\x20\0\0\0\x63\x0a\xf4\
\xff\0\0\0\0\x85\0\0\0\x05\0\0\0\x7b\x0a\xf8\xff\0\0\0\0\xbf\xa7\0\0\0\0\0\0\
\x07\x07\0\0\xf4\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xbf\x72\0\0\0\
\0\0\0\x85\0\0\0\x01\0\0\0\x15\0\x17\0\0\0\0\0\x79\x02\x08\0\0\0\0\0\x79\xa1\
\xf8\xff\0\0\0\0\x1f\x21\0\0\0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x61\
\x22\0\0\0\0\0\0\x3e\x12\x0c\0\0\0\0\0\x67\x01\0\0\x20\0\0\0\x77\x01\0\0\x20\0\
\0\0\x7b\x1a\xf8\xff\0\0\0\0\xbf\xa4\0\0\0\0\0\0\x07\x04\0\0\xf0\xff\xff\xff\
\xbf\x61\0\0\0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x18\x03\0\0\xff\xff\
\xff\xff\0\0\0\0\0\0\0\0\xb7\x05\0\0\x10\0\0\0\x85\0\0\0\x19\0\0\0\x18\x01\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\xbf\x72\0\0\0\0\0\0\x85\0\0\0\x03\0\0\0\xb4\0\0\0\0\0\
\0\0\x95\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x44\x75\x61\x6c\x20\x42\x53\x44\x2f\x47\x50\x4c\0\
\0\0\0\x9f\xeb\x01\0\x18\0\0\0\0\0\0\0\x60\x08\0\0\x60\x08\0\0\x48\x0a\0\0\0\0\
\0\0\0\0\0\x02\x03\0\0\0\x01\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\x01\0\0\0\0\0\0\
\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x02\0\0\0\x05\0\0\0\0\0\0\x01\x04\0\0\0\x20\
\0\0\0\0\0\0\0\0\0\0\x02\x06\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\
\0\0\x01\0\0\0\0\0\0\0\0\0\x02\x02\0\0\0\0\0\0\0\0\0\0\x02\x09\0\0\0\x19\0\0\0\
\x03\0\0\x04\x30\x01\0\0\x29\0\0\0\x16\0\0\0\0\0\0\0\x2e\0\0\0\x0b\0\0\0\0\x09\
\0\0\x3a\0\0\0\x12\0\0\0\x40\x09\0\0\x42\0\0\0\x08\0\0\x84\x18\0\0\0\x56\0\0\0\
\x0b\0\0\0\0\0\0\0\x5e\0\0\0\x0d\0\0\0\x40\0\0\x08\x67\0\0\0\x0e\0\0\0\x50\0\0\
\x0c\x73\0\0\0\x0e\0\0\0\x5c\0\0\x04\x82\0\0\0\x10\0\0\0\x60\0\0\x08\x8d\0\0\0\
\x12\0\0\0\x70\0\0\0\x95\0\0\0\x13\0\0\0\x80\0\0\0\xa0\0\0\0\x15\0\0\0\x88\0\0\
\0\xad\0\0\0\0\0\0\x08\x0c\0\0\0\xb3\0\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\0\xc6\0\
\0\0\x04\0\0\x06\x04\0\0\0\xda\0\0\0\0\0\0\0\xed\0\0\0\x01\0\0\0\xfe\0\0\0\x02\
\0\0\0\x15\x01\0\0\x03\0\0\0\x26\x01\0\0\0\0\0\x08\x0f\0\0\0\x2c\x01\0\0\0\0\0\
\x01\x02\0\0\0\x10\0\0\0\x3b\x01\0\0\0\0\0\x08\x11\0\0\0\x40\x01\0\0\0\0\0\x01\
\x01\0\0\0\x08\0\0\0\x4e\x01\0\0\0\0\0\x01\x02\0\0\0\x10\0\0\x01\x54\x01\0\0\0\
\0\0\x08\x14\0\0\0\x59\x01\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\x04\x5f\x01\0\0\0\0\
\0\x01\x01\0\0\0\x08\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x0a\0\0\0\x04\0\0\0\x0c\
\0\0\0\0\0\0\0\x04\0\0\x04\x20\0\0\0\x64\x01\0\0\x01\0\0\0\0\0\0\0\x69\x01\0\0\
\x05\0\0\0\x40\0\0\0\x75\x01\0\0\x07\0\0\0\x80\0\0\0\x79\x01\0\0\x08\0\0\0\xc0\
\0\0\0\x7f\x01\0\0\0\0\0\x0e\x17\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x1a\0\0\0\0\
\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x1c\0\
\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\x02\
\x1e\0\0\0\x90\x01\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\x01\0\0\0\0\0\0\0\x02\x20\0\
\0\0\x95\x01\0\0\0\0\0\x08\x21\0\0\0\x9b\x01\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\
\0\0\0\0\x04\0\0\x04\x20\0\0\0\x64\x01\0\0\x19\0\0\0\0\0\0\0\x69\x01\0\0\x1b\0\
\0\0\x40\0\0\0\x75\x01\0\0\x1d\0\0\0\x80\0\0\0\x79\x01\0\0\x1f\0\0\0\xc0\0\0\0\
\xa8\x01\0\0\0\0\0\x0e\x22\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x25\0\0\0\0\0\0\0\
\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x64\0\0\0\0\0\0\0\0\0\0\x02\x27\0\0\0\
\xc1\x01\0\0\0\0\0\x08\x28\0\0\0\xca\x01\0\0\0\0\0\x08\x20\0\0\0\0\0\0\0\0\0\0\
\x02\x2a\0\0\0\xce\x01\0\0\x03\0\0\x04\x10\0\0\0\xd5\x01\0\0\x20\0\0\0\0\0\0\0\
\xd9\x01\0\0\x20\0\0\0\x20\0\0\0\xdd\x01\0\0\x0b\0\0\0\x40\0\0\0\0\0\0\0\x04\0\
\0\x04\x20\0\0\0\x64\x01\0\0\x19\0\0\0\0\0\0\0\x69\x01\0\0\x24\0\0\0\x40\0\0\0\
\x75\x01\0\0\x26\0\0\0\x80\0\0\0\x79\x01\0\0\x29\0\0\0\xc0\0\0\0\xe0\x01\0\0\0\
\0\0\x0e\x2b\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x2e\0\0\0\0\0\0\0\0\0\0\x03\0\0\
\0\0\x02\0\0\0\x04\0\0\0\x04\0\0\0\0\0\0\0\x03\0\0\x04\x18\0\0\0\x64\x01\0\0\
\x2d\0\0\0\0\0\0\0\x75\x01\0\0\x07\0\0\0\x40\0\0\0\x79\x01\0\0\x07\0\0\0\x80\0\
\0\0\xe9\x01\0\0\0\0\0\x0e\x2f\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x32\0\0\0\xf2\
\x01\0\0\x15\0\0\x04\xa8\0\0\0\xfa\x01\0\0\x33\0\0\0\0\0\0\0\xfe\x01\0\0\x33\0\
\0\0\x40\0\0\0\x02\x02\0\0\x33\0\0\0\x80\0\0\0\x06\x02\0\0\x33\0\0\0\xc0\0\0\0\
\x0a\x02\0\0\x33\0\0\0\0\x01\0\0\x0d\x02\0\0\x33\0\0\0\x40\x01\0\0\x10\x02\0\0\
\x33\0\0\0\x80\x01\0\0\x14\x02\0\0\x33\0\0\0\xc0\x01\0\0\x18\x02\0\0\x33\0\0\0\
\0\x02\0\0\x1b\x02\0\0\x33\0\0\0\x40\x02\0\0\x1e\x02\0\0\x33\0\0\0\x80\x02\0\0\
\x21\x02\0\0\x33\0\0\0\xc0\x02\0\0\x24\x02\0\0\x33\0\0\0\0\x03\0\0\x27\x02\0\0\
\x33\0\0\0\x40\x03\0\0\x2a\x02\0\0\x33\0\0\0\x80\x03\0\0\x2d\x02\0\0\x33\0\0\0\
\xc0\x03\0\0\x35\x02\0\0\x33\0\0\0\0\x04\0\0\0\0\0\0\x34\0\0\0\x40\x04\0\0\x38\
\x02\0\0\x33\0\0\0\x80\x04\0\0\x3e\x02\0\0\x33\0\0\0\xc0\x04\0\0\0\0\0\0\x38\0\
\0\0\0\x05\0\0\x41\x02\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\0\0\0\0\0\x03\0\0\x05\
\x08\0\0\0\x4f\x02\0\0\x35\0\0\0\0\0\0\0\x52\x02\0\0\x36\0\0\0\0\0\0\0\x56\x02\
\0\0\x37\0\0\0\0\0\0\0\x5e\x02\0\0\0\0\0\x08\x0e\0\0\0\x62\x02\0\0\0\0\0\x08\
\x0b\0\0\0\x56\x02\0\0\x03\0\0\x84\x08\0\0\0\x4f\x02\0\0\x36\0\0\0\0\0\0\x10\
\x66\x02\0\0\x36\0\0\0\x10\0\0\x02\x69\x02\0\0\x36\0\0\0\x12\0\0\x01\0\0\0\0\
\x03\0\0\x05\x08\0\0\0\x6d\x02\0\0\x35\0\0\0\0\0\0\0\x70\x02\0\0\x36\0\0\0\0\0\
\0\0\x74\x02\0\0\x39\0\0\0\0\0\0\0\x74\x02\0\0\x0a\0\0\x84\x08\0\0\0\x6d\x02\0\
\0\x36\0\0\0\0\0\0\x10\x7c\x02\0\0\x36\0\0\0\x10\0\0\x01\x80\x02\0\0\x36\0\0\0\
\x11\0\0\x01\x88\x02\0\0\x36\0\0\0\x12\0\0\x01\x8c\x02\0\0\x36\0\0\0\x20\0\0\
\x08\x64\x01\0\0\x36\0\0\0\x30\0\0\x04\x93\x02\0\0\x36\0\0\0\x38\0\0\x01\x9b\
\x02\0\0\x36\0\0\0\x39\0\0\x01\x9e\x02\0\0\x36\0\0\0\x3a\0\0\x01\xa5\x02\0\0\
\x36\0\0\0\x3c\0\0\x04\0\0\0\0\x01\0\0\x0d\x02\0\0\0\xad\x02\0\0\x31\0\0\0\xb1\
\x02\0\0\x01\0\0\x0c\x3a\0\0\0\0\0\0\0\x03\0\0\x0d\x02\0\0\0\xad\x02\0\0\x31\0\
\0\0\x6b\x04\0\0\x0b\0\0\0\x73\x04\0\0\x1d\0\0\0\x77\x04\0\0\x01\0\0\x0c\x3c\0\
\0\0\0\0\0\0\x01\0\0\x0d\x1e\0\0\0\xad\x02\0\0\x31\0\0\0\x3f\x07\0\0\x01\0\0\
\x0c\x3e\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\xad\x02\0\0\x31\0\0\0\x6a\x07\0\0\
\x01\0\0\x0c\x40\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\xad\x02\0\0\x31\0\0\0\x6e\
\x08\0\0\x01\0\0\x0c\x42\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\xad\x02\0\0\x31\0\
\0\0\xaa\x09\0\0\x01\0\0\x0c\x44\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\xad\x02\0\
\0\x31\0\0\0\xc3\x09\0\0\x01\0\0\x0c\x46\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x15\0\
\0\0\x04\0\0\0\x0d\0\0\0\x0a\x0a\0\0\0\0\0\x0e\x48\0\0\0\x01\0\0\0\x12\x0a\0\0\
\0\0\0\x0e\x20\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x0a\x14\0\0\0\x17\x0a\0\0\0\0\0\
\x0e\x4b\0\0\0\x02\0\0\0\x2c\x0a\0\0\x01\0\0\x0f\0\0\0\0\x4a\0\0\0\0\0\0\0\x04\
\0\0\0\x31\x0a\0\0\x01\0\0\x0f\0\0\0\0\x4c\0\0\0\0\0\0\0\x01\0\0\0\x3a\x0a\0\0\
\x04\0\0\x0f\0\0\0\0\x18\0\0\0\0\0\0\0\x20\0\0\0\x23\0\0\0\0\0\0\0\x20\0\0\0\
\x2c\0\0\0\0\0\0\0\x20\0\0\0\x30\0\0\0\0\0\0\0\x18\0\0\0\x40\x0a\0\0\x01\0\0\
\x0f\0\0\0\0\x49\0\0\0\0\0\0\0\x0d\0\0\0\0\x69\x6e\x74\0\x5f\x5f\x41\x52\x52\
\x41\x59\x5f\x53\x49\x5a\x45\x5f\x54\x59\x50\x45\x5f\x5f\0\x5f\x5f\x62\x70\x66\
\x5f\x75\x73\x64\x74\x5f\x73\x70\x65\x63\0\x61\x72\x67\x73\0\x75\x73\x64\x74\
\x5f\x63\x6f\x6f\x6b\x69\x65\0\x61\x72\x67\x5f\x63\x6e\x74\0\x5f\x5f\x62\x70\
\x66\x5f\x75\x73\x64\x74\x5f\x61\x72\x67\x5f\x73\x70\x65\x63\0\x76\x61\x6c\x5f\
\x6f\x66\x66\0\x61\x72\x67\x5f\x74\x79\x70\x65\0\x69\x64\x78\x5f\x72\x65\x67\
\x5f\x6f\x66\x66\0\x73\x63\x61\x6c\x65\x5f\x62\x69\x74\x73\x68\x69\x66\x74\0\
\x5f\x5f\x72\x65\x73\x65\x72\x76\x65\x64\0\x72\x65\x67\x5f\x6f\x66\x66\0\x61\
\x72\x67\x5f\x73\x69\x67\x6e\x65\x64\0\x61\x72\x67\x5f\x62\x69\x74\x73\x68\x69\
\x66\x74\0\x5f\x5f\x75\x36\x34\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x6c\x6f\
\x6e\x67\x20\x6c\x6f\x6e\x67\0\x5f\x5f\x62\x70\x66\x5f\x75\x73\x64\x74\x5f\x61\
\x72\x67\x5f\x74\x79\x70\x65\0\x42\x50\x46\x5f\x55\x53\x44\x54\x5f\x41\x52\x47\
\x5f\x43\x4f\x4e\x53\x54\0\x42\x50\x46\x5f\x55\x53\x44\x54\x5f\x41\x52\x47\x5f\
\x52\x45\x47\0\x42\x50\x46\x5f\x55\x53\x44\x54\x5f\x41\x52\x47\x5f\x52\x45\x47\
\x5f\x44\x45\x52\x45\x46\0\x42\x50\x46\x5f\x55\x53\x44\x54\x5f\x41\x52\x47\x5f\
\x53\x49\x42\0\x5f\x5f\x75\x31\x36\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x73\
\x68\x6f\x72\x74\0\x5f\x5f\x75\x38\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x63\
\x68\x61\x72\0\x73\x68\x6f\x72\x74\0\x62\x6f\x6f\x6c\0\x5f\x42\x6f\x6f\x6c\0\
\x63\x68\x61\x72\0\x74\x79\x70\x65\0\x6d\x61\x78\x5f\x65\x6e\x74\x72\x69\x65\
\x73\0\x6b\x65\x79\0\x76\x61\x6c\x75\x65\0\x5f\x5f\x62\x70\x66\x5f\x75\x73\x64\
\x74\x5f\x73\x70\x65\x63\x73\0\x6c\x6f\x6e\x67\0\x5f\x5f\x75\x33\x32\0\x75\x6e\
\x73\x69\x67\x6e\x65\x64\x20\x69\x6e\x74\0\x5f\x5f\x62\x70\x66\x5f\x75\x73\x64\
\x74\x5f\x69\x70\x5f\x74\x6f\x5f\x73\x70\x65\x63\x5f\x69\x64\0\x75\x69\x6e\x74\
\x33\x32\x5f\x74\0\x75\x33\x32\0\x64\x61\x74\x61\x5f\x74\0\x63\x70\x75\0\x70\
\x69\x64\0\x74\x73\0\x64\x61\x74\x61\x5f\x6d\x61\x70\0\x70\x65\x72\x66\x5f\x6d\
\x61\x70\0\x70\x74\x5f\x72\x65\x67\x73\0\x72\x31\x35\0\x72\x31\x34\0\x72\x31\
\x33\0\x72\x31\x32\0\x62\x70\0\x62\x78\0\x72\x31\x31\0\x72\x31\x30\0\x72\x39\0\
\x72\x38\0\x61\x78\0\x63\x78\0\x64\x78\0\x73\x69\0\x64\x69\0\x6f\x72\x69\x67\
\x5f\x61\x78\0\x69\x70\0\x66\x6c\x61\x67\x73\0\x73\x70\0\x75\x6e\x73\x69\x67\
\x6e\x65\x64\x20\x6c\x6f\x6e\x67\0\x63\x73\0\x63\x73\x78\0\x66\x72\x65\x64\x5f\
\x63\x73\0\x75\x31\x36\0\x75\x36\x34\0\x73\x6c\0\x77\x66\x65\0\x73\x73\0\x73\
\x73\x78\0\x66\x72\x65\x64\x5f\x73\x73\0\x73\x74\x69\0\x73\x77\x65\x76\x65\x6e\
\x74\0\x6e\x6d\x69\0\x76\x65\x63\x74\x6f\x72\0\x65\x6e\x63\x6c\x61\x76\x65\0\
\x6c\x6d\0\x6e\x65\x73\x74\x65\x64\0\x69\x6e\x73\x6e\x6c\x65\x6e\0\x63\x74\x78\
\0\x62\x70\x66\x5f\x75\x73\x64\x74\x5f\x61\x72\x67\x5f\x63\x6e\x74\0\x2e\x74\
\x65\x78\x74\0\x2f\x62\x75\x69\x6c\x64\x2f\x62\x63\x63\x2f\x73\x72\x63\x2f\x62\
\x63\x63\x2f\x6c\x69\x62\x62\x70\x66\x2d\x74\x6f\x6f\x6c\x73\x2f\x2e\x6f\x75\
\x74\x70\x75\x74\x2f\x62\x70\x66\x2f\x75\x73\x64\x74\x2e\x62\x70\x66\x2e\x68\0\
\x09\x69\x66\x20\x28\x21\x4c\x49\x4e\x55\x58\x5f\x48\x41\x53\x5f\x42\x50\x46\
\x5f\x43\x4f\x4f\x4b\x49\x45\x29\x20\x7b\0\x30\x3a\x31\x36\0\x09\x09\x6c\x6f\
\x6e\x67\x20\x69\x70\x20\x3d\x20\x50\x54\x5f\x52\x45\x47\x53\x5f\x49\x50\x28\
\x63\x74\x78\x29\x3b\0\x09\x09\x73\x70\x65\x63\x5f\x69\x64\x5f\x70\x74\x72\x20\
\x3d\x20\x62\x70\x66\x5f\x6d\x61\x70\x5f\x6c\x6f\x6f\x6b\x75\x70\x5f\x65\x6c\
\x65\x6d\x28\x26\x5f\x5f\x62\x70\x66\x5f\x75\x73\x64\x74\x5f\x69\x70\x5f\x74\
\x6f\x5f\x73\x70\x65\x63\x5f\x69\x64\x2c\x20\x26\x69\x70\x29\x3b\0\x09\x09\x72\
\x65\x74\x75\x72\x6e\x20\x73\x70\x65\x63\x5f\x69\x64\x5f\x70\x74\x72\x20\x3f\
\x20\x2a\x73\x70\x65\x63\x5f\x69\x64\x5f\x70\x74\x72\x20\x3a\x20\x2d\x45\x53\
\x52\x43\x48\x3b\0\x09\x72\x65\x74\x75\x72\x6e\x20\x62\x70\x66\x5f\x67\x65\x74\
\x5f\x61\x74\x74\x61\x63\x68\x5f\x63\x6f\x6f\x6b\x69\x65\x28\x63\x74\x78\x29\
\x3b\0\x09\x73\x70\x65\x63\x5f\x69\x64\x20\x3d\x20\x5f\x5f\x62\x70\x66\x5f\x75\
\x73\x64\x74\x5f\x73\x70\x65\x63\x5f\x69\x64\x28\x63\x74\x78\x29\x3b\0\x09\x69\
\x66\x20\x28\x73\x70\x65\x63\x5f\x69\x64\x20\x3c\x20\x30\x29\0\x09\x73\x70\x65\
\x63\x20\x3d\x20\x62\x70\x66\x5f\x6d\x61\x70\x5f\x6c\x6f\x6f\x6b\x75\x70\x5f\
\x65\x6c\x65\x6d\x28\x26\x5f\x5f\x62\x70\x66\x5f\x75\x73\x64\x74\x5f\x73\x70\
\x65\x63\x73\x2c\x20\x26\x73\x70\x65\x63\x5f\x69\x64\x29\x3b\0\x09\x69\x66\x20\
\x28\x21\x73\x70\x65\x63\x29\0\x09\x72\x65\x74\x75\x72\x6e\x20\x73\x70\x65\x63\
\x2d\x3e\x61\x72\x67\x5f\x63\x6e\x74\x3b\0\x7d\0\x61\x72\x67\x5f\x6e\x75\x6d\0\
\x72\x65\x73\0\x62\x70\x66\x5f\x75\x73\x64\x74\x5f\x61\x72\x67\0\x69\x6e\x74\
\x20\x62\x70\x66\x5f\x75\x73\x64\x74\x5f\x61\x72\x67\x28\x73\x74\x72\x75\x63\
\x74\x20\x70\x74\x5f\x72\x65\x67\x73\x20\x2a\x63\x74\x78\x2c\x20\x5f\x5f\x75\
\x36\x34\x20\x61\x72\x67\x5f\x6e\x75\x6d\x2c\x20\x6c\x6f\x6e\x67\x20\x2a\x72\
\x65\x73\x29\0\x09\x2a\x72\x65\x73\x20\x3d\x20\x30\x3b\0\x09\x69\x66\x20\x28\
\x61\x72\x67\x5f\x6e\x75\x6d\x20\x3e\x3d\x20\x42\x50\x46\x5f\x55\x53\x44\x54\
\x5f\x4d\x41\x58\x5f\x41\x52\x47\x5f\x43\x4e\x54\x29\0\x09\x69\x66\x20\x28\x61\
\x72\x67\x5f\x6e\x75\x6d\x20\x3e\x3d\x20\x73\x70\x65\x63\x2d\x3e\x61\x72\x67\
\x5f\x63\x6e\x74\x29\0\x09\x61\x72\x67\x5f\x73\x70\x65\x63\x20\x3d\x20\x26\x73\
\x70\x65\x63\x2d\x3e\x61\x72\x67\x73\x5b\x61\x72\x67\x5f\x6e\x75\x6d\x5d\x3b\0\
\x09\x73\x77\x69\x74\x63\x68\x20\x28\x61\x72\x67\x5f\x73\x70\x65\x63\x2d\x3e\
\x61\x72\x67\x5f\x74\x79\x70\x65\x29\x20\x7b\0\x09\x09\x65\x72\x72\x20\x3d\x20\
\x62\x70\x66\x5f\x70\x72\x6f\x62\x65\x5f\x72\x65\x61\x64\x5f\x6b\x65\x72\x6e\
\x65\x6c\x28\x26\x76\x61\x6c\x2c\x20\x73\x69\x7a\x65\x6f\x66\x28\x76\x61\x6c\
\x29\x2c\x20\x28\x76\x6f\x69\x64\x20\x2a\x29\x63\x74\x78\x20\x2b\x20\x61\x72\
\x67\x5f\x73\x70\x65\x63\x2d\x3e\x72\x65\x67\x5f\x6f\x66\x66\x29\x3b\0\x09\x09\
\x69\x66\x20\x28\x65\x72\x72\x29\0\x09\x09\x65\x72\x72\x20\x3d\x20\x62\x70\x66\
\x5f\x70\x72\x6f\x62\x65\x5f\x72\x65\x61\x64\x5f\x6b\x65\x72\x6e\x65\x6c\x28\
\x26\x69\x64\x78\x2c\x20\x73\x69\x7a\x65\x6f\x66\x28\x69\x64\x78\x29\x2c\x20\
\x28\x76\x6f\x69\x64\x20\x2a\x29\x63\x74\x78\x20\x2b\x20\x61\x72\x67\x5f\x73\
\x70\x65\x63\x2d\x3e\x69\x64\x78\x5f\x72\x65\x67\x5f\x6f\x66\x66\x29\x3b\0\x09\
\x09\x65\x72\x72\x20\x3d\x20\x62\x70\x66\x5f\x70\x72\x6f\x62\x65\x5f\x72\x65\
\x61\x64\x5f\x75\x73\x65\x72\x28\x26\x76\x61\x6c\x2c\x20\x73\x69\x7a\x65\x6f\
\x66\x28\x76\x61\x6c\x29\x2c\x20\x28\x76\x6f\x69\x64\x20\x2a\x29\x28\x76\x61\
\x6c\x20\x2b\x20\x28\x69\x64\x78\x20\x3c\x3c\x20\x61\x72\x67\x5f\x73\x70\x65\
\x63\x2d\x3e\x73\x63\x61\x6c\x65\x5f\x62\x69\x74\x73\x68\x69\x66\x74\x29\x20\
\x2b\x20\x61\x72\x67\x5f\x73\x70\x65\x63\x2d\x3e\x76\x61\x6c\x5f\x6f\x66\x66\
\x29\x29\x3b\0\x09\x76\x61\x6c\x20\x3c\x3c\x3d\x20\x61\x72\x67\x5f\x73\x70\x65\
\x63\x2d\x3e\x61\x72\x67\x5f\x62\x69\x74\x73\x68\x69\x66\x74\x3b\0\x09\x69\x66\
\x20\x28\x61\x72\x67\x5f\x73\x70\x65\x63\x2d\x3e\x61\x72\x67\x5f\x73\x69\x67\
\x6e\x65\x64\x29\0\x09\x2a\x72\x65\x73\x20\x3d\x20\x76\x61\x6c\x3b\0\x09\x09\
\x76\x61\x6c\x20\x3d\x20\x61\x72\x67\x5f\x73\x70\x65\x63\x2d\x3e\x76\x61\x6c\
\x5f\x6f\x66\x66\x3b\0\x09\x09\x62\x72\x65\x61\x6b\x3b\0\x09\x09\x65\x72\x72\
\x20\x3d\x20\x62\x70\x66\x5f\x70\x72\x6f\x62\x65\x5f\x72\x65\x61\x64\x5f\x75\
\x73\x65\x72\x28\x26\x76\x61\x6c\x2c\x20\x73\x69\x7a\x65\x6f\x66\x28\x76\x61\
\x6c\x29\x2c\x20\x28\x76\x6f\x69\x64\x20\x2a\x29\x76\x61\x6c\x20\x2b\x20\x61\
\x72\x67\x5f\x73\x70\x65\x63\x2d\x3e\x76\x61\x6c\x5f\x6f\x66\x66\x29\x3b\0\x62\
\x70\x66\x5f\x75\x73\x64\x74\x5f\x63\x6f\x6f\x6b\x69\x65\0\x09\x72\x65\x74\x75\
\x72\x6e\x20\x73\x70\x65\x63\x2d\x3e\x75\x73\x64\x74\x5f\x63\x6f\x6f\x6b\x69\
\x65\x3b\0\x68\x61\x6e\x64\x6c\x65\x5f\x67\x63\x5f\x73\x74\x61\x72\x74\0\x75\
\x73\x64\x74\0\x2f\x62\x75\x69\x6c\x64\x2f\x62\x63\x63\x2f\x73\x72\x63\x2f\x62\
\x63\x63\x2f\x6c\x69\x62\x62\x70\x66\x2d\x74\x6f\x6f\x6c\x73\x2f\x6a\x61\x76\
\x61\x67\x63\x2e\x62\x70\x66\x2e\x63\0\x09\x64\x61\x74\x61\x2e\x63\x70\x75\x20\
\x3d\x20\x62\x70\x66\x5f\x67\x65\x74\x5f\x73\x6d\x70\x5f\x70\x72\x6f\x63\x65\
\x73\x73\x6f\x72\x5f\x69\x64\x28\x29\x3b\0\x09\x64\x61\x74\x61\x2e\x70\x69\x64\
\x20\x3d\x20\x62\x70\x66\x5f\x67\x65\x74\x5f\x63\x75\x72\x72\x65\x6e\x74\x5f\
\x70\x69\x64\x5f\x74\x67\x69\x64\x28\x29\x20\x3e\x3e\x20\x33\x32\x3b\0\x09\x64\
\x61\x74\x61\x2e\x74\x73\x20\x3d\x20\x62\x70\x66\x5f\x6b\x74\x69\x6d\x65\x5f\
\x67\x65\x74\x5f\x6e\x73\x28\x29\x3b\0\x09\x62\x70\x66\x5f\x6d\x61\x70\x5f\x75\
\x70\x64\x61\x74\x65\x5f\x65\x6c\x65\x6d\x28\x26\x64\x61\x74\x61\x5f\x6d\x61\
\x70\x2c\x20\x26\x64\x61\x74\x61\x2e\x70\x69\x64\x2c\x20\x26\x64\x61\x74\x61\
\x2c\x20\x30\x29\x3b\0\x09\x72\x65\x74\x75\x72\x6e\x20\x67\x63\x5f\x73\x74\x61\
\x72\x74\x28\x63\x74\x78\x29\x3b\0\x68\x61\x6e\x64\x6c\x65\x5f\x67\x63\x5f\x65\
\x6e\x64\0\x69\x6e\x74\x20\x68\x61\x6e\x64\x6c\x65\x5f\x67\x63\x5f\x65\x6e\x64\
\x28\x73\x74\x72\x75\x63\x74\x20\x70\x74\x5f\x72\x65\x67\x73\x20\x2a\x63\x74\
\x78\x29\0\x09\x70\x20\x3d\x20\x62\x70\x66\x5f\x6d\x61\x70\x5f\x6c\x6f\x6f\x6b\
\x75\x70\x5f\x65\x6c\x65\x6d\x28\x26\x64\x61\x74\x61\x5f\x6d\x61\x70\x2c\x20\
\x26\x64\x61\x74\x61\x2e\x70\x69\x64\x29\x3b\0\x09\x69\x66\x20\x28\x21\x70\x29\
\0\x09\x76\x61\x6c\x20\x3d\x20\x64\x61\x74\x61\x2e\x74\x73\x20\x2d\x20\x70\x2d\
\x3e\x74\x73\x3b\0\x09\x69\x66\x20\x28\x76\x61\x6c\x20\x3e\x20\x74\x69\x6d\x65\
\x29\x20\x7b\0\x09\x09\x64\x61\x74\x61\x2e\x74\x73\x20\x3d\x20\x76\x61\x6c\x3b\
\0\x09\x09\x62\x70\x66\x5f\x70\x65\x72\x66\x5f\x65\x76\x65\x6e\x74\x5f\x6f\x75\
\x74\x70\x75\x74\x28\x63\x74\x78\x2c\x20\x26\x70\x65\x72\x66\x5f\x6d\x61\x70\
\x2c\x20\x42\x50\x46\x5f\x46\x5f\x43\x55\x52\x52\x45\x4e\x54\x5f\x43\x50\x55\
\x2c\x20\x26\x64\x61\x74\x61\x2c\x20\x73\x69\x7a\x65\x6f\x66\x28\x64\x61\x74\
\x61\x29\x29\x3b\0\x09\x62\x70\x66\x5f\x6d\x61\x70\x5f\x64\x65\x6c\x65\x74\x65\
\x5f\x65\x6c\x65\x6d\x28\x26\x64\x61\x74\x61\x5f\x6d\x61\x70\x2c\x20\x26\x64\
\x61\x74\x61\x2e\x70\x69\x64\x29\x3b\0\x09\x72\x65\x74\x75\x72\x6e\x20\x67\x63\
\x5f\x65\x6e\x64\x28\x63\x74\x78\x29\x3b\0\x68\x61\x6e\x64\x6c\x65\x5f\x6d\x65\
\x6d\x5f\x70\x6f\x6f\x6c\x5f\x67\x63\x5f\x73\x74\x61\x72\x74\0\x68\x61\x6e\x64\
\x6c\x65\x5f\x6d\x65\x6d\x5f\x70\x6f\x6f\x6c\x5f\x67\x63\x5f\x65\x6e\x64\0\x69\
\x6e\x74\x20\x68\x61\x6e\x64\x6c\x65\x5f\x6d\x65\x6d\x5f\x70\x6f\x6f\x6c\x5f\
\x67\x63\x5f\x65\x6e\x64\x28\x73\x74\x72\x75\x63\x74\x20\x70\x74\x5f\x72\x65\
\x67\x73\x20\x2a\x63\x74\x78\x29\0\x4c\x49\x43\x45\x4e\x53\x45\0\x74\x69\x6d\
\x65\0\x4c\x49\x4e\x55\x58\x5f\x48\x41\x53\x5f\x42\x50\x46\x5f\x43\x4f\x4f\x4b\
\x49\x45\0\x2e\x62\x73\x73\0\x2e\x6b\x63\x6f\x6e\x66\x69\x67\0\x2e\x6d\x61\x70\
\x73\0\x6c\x69\x63\x65\x6e\x73\x65\0\x9f\xeb\x01\0\x20\0\0\0\0\0\0\0\x4c\0\0\0\
\x4c\0\0\0\x84\x09\0\0\xd0\x09\0\0\x3c\0\0\0\x08\0\0\0\xc2\x02\0\0\x03\0\0\0\0\
\0\0\0\x3b\0\0\0\xf8\0\0\0\x3d\0\0\0\x98\x05\0\0\x3f\0\0\0\x7a\x07\0\0\x04\0\0\
\0\0\0\0\0\x41\0\0\0\x88\0\0\0\x43\0\0\0\xc8\x01\0\0\x45\0\0\0\x50\x02\0\0\x47\
\0\0\0\x10\0\0\0\xc2\x02\0\0\x59\0\0\0\0\0\0\0\xc8\x02\0\0\xff\x02\0\0\x07\x94\
\x01\0\x18\0\0\0\xc8\x02\0\0\xff\x02\0\0\x06\x94\x01\0\x20\0\0\0\xc8\x02\0\0\
\x22\x03\0\0\x0d\x98\x01\0\x28\0\0\0\xc8\x02\0\0\x22\x03\0\0\x08\x98\x01\0\x40\
\0\0\0\xc8\x02\0\0\x3f\x03\0\0\x11\xa4\x01\0\x68\0\0\0\xc8\x02\0\0\x84\x03\0\0\
\x0a\xa8\x01\0\x70\0\0\0\xc8\x02\0\0\x84\x03\0\0\x18\xa8\x01\0\x80\0\0\0\xc8\
\x02\0\0\xb2\x03\0\0\x09\xb4\x01\0\x90\0\0\0\xc8\x02\0\0\xd6\x03\0\0\x0a\xdc\
\x01\0\x98\0\0\0\xc8\x02\0\0\xfa\x03\0\0\x0e\xe0\x01\0\xb0\0\0\0\xc8\x02\0\0\
\x0c\x04\0\0\x09\xec\x01\0\xc8\0\0\0\xc8\x02\0\0\x46\x04\0\0\x06\xf0\x01\0\xd0\
\0\0\0\xc8\x02\0\0\x52\x04\0\0\x0f\xfc\x01\0\xe8\0\0\0\xc8\x02\0\0\x69\x04\0\0\
\x01\0\x02\0\xf8\0\0\0\xc8\x02\0\0\x84\x04\0\0\0\x9c\x02\0\x18\x01\0\0\xc8\x02\
\0\0\xc4\x04\0\0\x07\xb8\x02\0\x20\x01\0\0\xc8\x02\0\0\xff\x02\0\0\x07\x94\x01\
\0\x38\x01\0\0\xc8\x02\0\0\xff\x02\0\0\x06\x94\x01\0\x40\x01\0\0\xc8\x02\0\0\
\x22\x03\0\0\x0d\x98\x01\0\x48\x01\0\0\xc8\x02\0\0\x22\x03\0\0\x08\x98\x01\0\
\x60\x01\0\0\xc8\x02\0\0\x3f\x03\0\0\x11\xa4\x01\0\x88\x01\0\0\xc8\x02\0\0\x84\
\x03\0\0\x0a\xa8\x01\0\x90\x01\0\0\xc8\x02\0\0\x84\x03\0\0\x18\xa8\x01\0\xa0\
\x01\0\0\xc8\x02\0\0\xb2\x03\0\0\x09\xb4\x01\0\xb8\x01\0\0\xc8\x02\0\0\xd6\x03\
\0\0\x0a\xc0\x02\0\xc0\x01\0\0\xc8\x02\0\0\xfa\x03\0\0\x0e\xc4\x02\0\xd8\x01\0\
\0\xc8\x02\0\0\x0c\x04\0\0\x09\xd0\x02\0\xf0\x01\0\0\xc8\x02\0\0\x46\x04\0\0\
\x06\xd4\x02\0\0\x02\0\0\xc8\x02\0\0\xcf\x04\0\0\x0e\xe0\x02\0\x08\x02\0\0\xc8\
\x02\0\0\xf5\x04\0\0\x17\xec\x02\0\x20\x02\0\0\xc8\x02\0\0\xf5\x04\0\0\x0e\xec\
\x02\0\x28\x02\0\0\xc8\x02\0\0\x14\x05\0\0\x0e\xf8\x02\0\x40\x02\0\0\xc8\x02\0\
\0\x36\x05\0\0\x14\xfc\x02\0\x48\x02\0\0\xc8\x02\0\0\x36\x05\0\0\x02\xfc\x02\0\
\x70\x02\0\0\xc8\x02\0\0\x55\x05\0\0\x4a\x30\x03\0\x88\x02\0\0\xc8\x02\0\0\x55\
\x05\0\0\x3e\x30\x03\0\xa0\x02\0\0\xc8\x02\0\0\x55\x05\0\0\x09\x30\x03\0\xd0\
\x02\0\0\xc8\x02\0\0\xa8\x05\0\0\x07\x34\x03\0\xe0\x02\0\0\xc8\x02\0\0\x36\x05\
\0\0\x02\xfc\x02\0\xf8\x02\0\0\xc8\x02\0\0\x55\x05\0\0\x4a\xa8\x03\0\x10\x03\0\
\0\xc8\x02\0\0\x55\x05\0\0\x3e\xa8\x03\0\x30\x03\0\0\xc8\x02\0\0\x55\x05\0\0\
\x09\xa8\x03\0\x58\x03\0\0\xc8\x02\0\0\xa8\x05\0\0\x07\xac\x03\0\x60\x03\0\0\
\xc8\x02\0\0\xb3\x05\0\0\x4a\xb4\x03\0\x78\x03\0\0\xc8\x02\0\0\xb3\x05\0\0\x3e\
\xb4\x03\0\x90\x03\0\0\xc8\x02\0\0\xb3\x05\0\0\x09\xb4\x03\0\xb8\x03\0\0\xc8\
\x02\0\0\xa8\x05\0\0\x07\xb8\x03\0\xc0\x03\0\0\xc8\x02\0\0\x0a\x06\0\0\x6d\xc0\
\x03\0\xc8\x03\0\0\xc8\x02\0\0\x0a\x06\0\0\x39\xc0\x03\0\xd0\x03\0\0\xc8\x02\0\
\0\x0a\x06\0\0\x3d\xc0\x03\0\xd8\x03\0\0\xc8\x02\0\0\x0a\x06\0\0\x51\xc0\x03\0\
\xe8\x03\0\0\xc8\x02\0\0\x0a\x06\0\0\x40\xc0\x03\0\xf0\x03\0\0\xc8\x02\0\0\x0a\
\x06\0\0\x44\xc0\x03\0\xf8\x03\0\0\xc8\x02\0\0\x0a\x06\0\0\x61\xc0\x03\0\x10\
\x04\0\0\xc8\x02\0\0\x0a\x06\0\0\x09\xc0\x03\0\x30\x04\0\0\xc8\x02\0\0\xa8\x05\
\0\0\x07\xc4\x03\0\x38\x04\0\0\xc8\x02\0\0\x81\x06\0\0\x14\xfc\x03\0\x50\x04\0\
\0\xc8\x02\0\0\x81\x06\0\0\x06\xfc\x03\0\x70\x04\0\0\xc8\x02\0\0\xa2\x06\0\0\
\x06\0\x04\0\x80\x04\0\0\xc8\x02\0\0\xa2\x06\0\0\x10\0\x04\0\x88\x04\0\0\xc8\
\x02\0\0\xa2\x06\0\0\x06\0\x04\0\xa0\x04\0\0\xc8\x02\0\0\xbd\x06\0\0\x07\x10\
\x04\0\xb0\x04\0\0\xc8\x02\0\0\x69\x04\0\0\x01\x18\x04\0\xc0\x04\0\0\xc8\x02\0\
\0\xca\x06\0\0\x13\x10\x03\0\xc8\x04\0\0\xc8\x02\0\0\xca\x06\0\0\x07\x10\x03\0\
\xd0\x04\0\0\xc8\x02\0\0\xe5\x06\0\0\x03\x14\x03\0\xd8\x04\0\0\xc8\x02\0\0\x55\
\x05\0\0\x4a\x60\x03\0\xf0\x04\0\0\xc8\x02\0\0\x55\x05\0\0\x3e\x60\x03\0\x08\
\x05\0\0\xc8\x02\0\0\x55\x05\0\0\x09\x60\x03\0\x38\x05\0\0\xc8\x02\0\0\xa8\x05\
\0\0\x07\x64\x03\0\x40\x05\0\0\xc8\x02\0\0\xee\x06\0\0\x48\x6c\x03\0\x48\x05\0\
\0\xc8\x02\0\0\xee\x06\0\0\x38\x6c\x03\0\x50\x05\0\0\xc8\x02\0\0\xee\x06\0\0\
\x3c\x6c\x03\0\x68\x05\0\0\xc8\x02\0\0\xee\x06\0\0\x09\x6c\x03\0\x88\x05\0\0\
\xc8\x02\0\0\xa8\x05\0\0\x07\x70\x03\0\x98\x05\0\0\xc8\x02\0\0\xff\x02\0\0\x07\
\x94\x01\0\xb0\x05\0\0\xc8\x02\0\0\xff\x02\0\0\x06\x94\x01\0\xb8\x05\0\0\xc8\
\x02\0\0\x22\x03\0\0\x0d\x98\x01\0\xc0\x05\0\0\xc8\x02\0\0\x22\x03\0\0\x08\x98\
\x01\0\xd8\x05\0\0\xc8\x02\0\0\x3f\x03\0\0\x11\xa4\x01\0\0\x06\0\0\xc8\x02\0\0\
\x84\x03\0\0\x0a\xa8\x01\0\x08\x06\0\0\xc8\x02\0\0\x84\x03\0\0\x18\xa8\x01\0\
\x18\x06\0\0\xc8\x02\0\0\xb2\x03\0\0\x09\xb4\x01\0\x28\x06\0\0\xc8\x02\0\0\xd6\
\x03\0\0\x0a\x50\x04\0\x30\x06\0\0\xc8\x02\0\0\xfa\x03\0\0\x0e\x54\x04\0\x48\
\x06\0\0\xc8\x02\0\0\x0c\x04\0\0\x09\x60\x04\0\x60\x06\0\0\xc8\x02\0\0\x46\x04\
\0\0\x06\x64\x04\0\x68\x06\0\0\xc8\x02\0\0\x4f\x07\0\0\x0f\x70\x04\0\x70\x06\0\
\0\xc8\x02\0\0\x69\x04\0\0\x01\x74\x04\0\x7a\x07\0\0\x3e\0\0\0\0\0\0\0\x7f\x07\
\0\0\xac\x07\0\0\x0d\x70\0\0\x08\0\0\0\x7f\x07\0\0\xac\x07\0\0\x0b\x70\0\0\x10\
\0\0\0\x7f\x07\0\0\xd4\x07\0\0\x0d\x74\0\0\x18\0\0\0\x7f\x07\0\0\xd4\x07\0\0\
\x28\x74\0\0\x20\0\0\0\x7f\x07\0\0\xd4\x07\0\0\x0b\x74\0\0\x28\0\0\0\x7f\x07\0\
\0\x02\x08\0\0\x0c\x78\0\0\x30\0\0\0\x7f\x07\0\0\x02\x08\0\0\x0a\x78\0\0\x38\0\
\0\0\x7f\x07\0\0\xd4\x07\0\0\x07\x74\0\0\x58\0\0\0\x7f\x07\0\0\x21\x08\0\0\x02\
\x7c\0\0\x78\0\0\0\x7f\x07\0\0\x57\x08\0\0\x02\xf0\0\0\x88\0\0\0\x7f\x07\0\0\
\x7c\x08\0\0\0\0\x01\0\x90\0\0\0\x7f\x07\0\0\xac\x07\0\0\x0d\xa4\0\0\x98\0\0\0\
\x7f\x07\0\0\xac\x07\0\0\x0b\xa4\0\0\xa0\0\0\0\x7f\x07\0\0\xd4\x07\0\0\x0d\xa8\
\0\0\xa8\0\0\0\x7f\x07\0\0\xd4\x07\0\0\x28\xa8\0\0\xb0\0\0\0\x7f\x07\0\0\xd4\
\x07\0\0\x0b\xa8\0\0\xb8\0\0\0\x7f\x07\0\0\x02\x08\0\0\x0c\xac\0\0\xc0\0\0\0\
\x7f\x07\0\0\x02\x08\0\0\x0a\xac\0\0\xc8\0\0\0\x7f\x07\0\0\xd4\x07\0\0\x07\xa8\
\0\0\xd8\0\0\0\x7f\x07\0\0\xa3\x08\0\0\x06\xb0\0\0\xf8\0\0\0\x7f\x07\0\0\xd3\
\x08\0\0\x06\xb4\0\0\0\x01\0\0\x7f\x07\0\0\xdc\x08\0\0\x15\xc0\0\0\x08\x01\0\0\
\x7f\x07\0\0\xdc\x08\0\0\x0d\xc0\0\0\x10\x01\0\0\x7f\x07\0\0\xdc\x08\0\0\x10\
\xc0\0\0\x18\x01\0\0\x7f\x07\0\0\xf4\x08\0\0\x0c\xc4\0\0\x30\x01\0\0\x7f\x07\0\
\0\xf4\x08\0\0\x0a\xc4\0\0\x38\x01\0\0\x7f\x07\0\0\x07\x09\0\0\x0d\xc8\0\0\x48\
\x01\0\0\x7f\x07\0\0\x07\x09\0\0\x0b\xc8\0\0\x60\x01\0\0\x7f\x07\0\0\x18\x09\0\
\0\x03\xcc\0\0\x98\x01\0\0\x7f\x07\0\0\x69\x09\0\0\x02\xd4\0\0\xb8\x01\0\0\x7f\
\x07\0\0\x95\x09\0\0\x02\x08\x01\0\xc8\x01\0\0\x7f\x07\0\0\xac\x07\0\0\x0d\x70\
\0\0\xd0\x01\0\0\x7f\x07\0\0\xac\x07\0\0\x0b\x70\0\0\xd8\x01\0\0\x7f\x07\0\0\
\xd4\x07\0\0\x0d\x74\0\0\xe0\x01\0\0\x7f\x07\0\0\xd4\x07\0\0\x28\x74\0\0\xe8\
\x01\0\0\x7f\x07\0\0\xd4\x07\0\0\x0b\x74\0\0\xf0\x01\0\0\x7f\x07\0\0\x02\x08\0\
\0\x0c\x78\0\0\xf8\x01\0\0\x7f\x07\0\0\x02\x08\0\0\x0a\x78\0\0\0\x02\0\0\x7f\
\x07\0\0\xd4\x07\0\0\x07\x74\0\0\x20\x02\0\0\x7f\x07\0\0\x21\x08\0\0\x02\x7c\0\
\0\x40\x02\0\0\x7f\x07\0\0\x57\x08\0\0\x02\x20\x01\0\x50\x02\0\0\x7f\x07\0\0\
\xda\x09\0\0\0\x30\x01\0\x58\x02\0\0\x7f\x07\0\0\xac\x07\0\0\x0d\xa4\0\0\x60\
\x02\0\0\x7f\x07\0\0\xac\x07\0\0\x0b\xa4\0\0\x68\x02\0\0\x7f\x07\0\0\xd4\x07\0\
\0\x0d\xa8\0\0\x70\x02\0\0\x7f\x07\0\0\xd4\x07\0\0\x28\xa8\0\0\x78\x02\0\0\x7f\
\x07\0\0\xd4\x07\0\0\x0b\xa8\0\0\x80\x02\0\0\x7f\x07\0\0\x02\x08\0\0\x0c\xac\0\
\0\x88\x02\0\0\x7f\x07\0\0\x02\x08\0\0\x0a\xac\0\0\x90\x02\0\0\x7f\x07\0\0\xd4\
\x07\0\0\x07\xa8\0\0\xa0\x02\0\0\x7f\x07\0\0\xa3\x08\0\0\x06\xb0\0\0\xc0\x02\0\
\0\x7f\x07\0\0\xd3\x08\0\0\x06\xb4\0\0\xc8\x02\0\0\x7f\x07\0\0\xdc\x08\0\0\x15\
\xc0\0\0\xd0\x02\0\0\x7f\x07\0\0\xdc\x08\0\0\x0d\xc0\0\0\xd8\x02\0\0\x7f\x07\0\
\0\xdc\x08\0\0\x10\xc0\0\0\xe0\x02\0\0\x7f\x07\0\0\xf4\x08\0\0\x0c\xc4\0\0\xf8\
\x02\0\0\x7f\x07\0\0\xf4\x08\0\0\x0a\xc4\0\0\0\x03\0\0\x7f\x07\0\0\x07\x09\0\0\
\x0d\xc8\0\0\x10\x03\0\0\x7f\x07\0\0\x07\x09\0\0\x0b\xc8\0\0\x28\x03\0\0\x7f\
\x07\0\0\x18\x09\0\0\x03\xcc\0\0\x60\x03\0\0\x7f\x07\0\0\x69\x09\0\0\x02\xd4\0\
\0\x80\x03\0\0\x7f\x07\0\0\x95\x09\0\0\x02\x38\x01\0\x10\0\0\0\xc2\x02\0\0\x03\
\0\0\0\x20\0\0\0\x32\0\0\0\x1d\x03\0\0\0\0\0\0\x40\x01\0\0\x32\0\0\0\x1d\x03\0\
\0\0\0\0\0\xb8\x05\0\0\x32\0\0\0\x1d\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x03\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x41\0\0\0\x22\x02\x02\
\0\0\0\0\0\0\0\0\0\xf8\0\0\0\0\0\0\0\x20\x01\0\0\x10\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\xe6\0\0\0\x21\0\x06\0\x20\0\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x66\0\0\
\0\x21\0\x06\0\0\0\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x89\0\0\0\x22\x02\x02\0\xf8\0\
\0\0\0\0\0\0\xa0\x04\0\0\0\0\0\0\xb1\0\0\0\x22\x02\x02\0\x98\x05\0\0\0\0\0\0\
\xe8\0\0\0\0\0\0\0\x31\0\0\0\x12\0\x04\0\0\0\0\0\0\0\0\0\x88\0\0\0\0\0\0\0\x80\
\0\0\0\x11\0\x06\0\x40\0\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\xd8\0\0\0\x12\0\x04\0\
\x88\0\0\0\0\0\0\0\x40\x01\0\0\0\0\0\0\xac\0\0\0\x11\0\x08\0\0\0\0\0\0\0\0\0\
\x04\0\0\0\0\0\0\0\x77\0\0\0\x11\0\x06\0\x60\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\0\
\x18\0\0\0\x12\0\x04\0\xc8\x01\0\0\0\0\0\0\x88\0\0\0\0\0\0\0\xc1\0\0\0\x12\0\
\x04\0\x50\x02\0\0\0\0\0\0\x40\x01\0\0\0\0\0\0\x18\x01\0\0\x11\0\x07\0\0\0\0\0\
\0\0\0\0\x0d\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\x04\0\0\0\x40\0\0\0\0\0\0\
\0\x01\0\0\0\x05\0\0\0\xb0\0\0\0\0\0\0\0\x01\0\0\0\x06\0\0\0\x20\x01\0\0\0\0\0\
\0\x01\0\0\0\x04\0\0\0\x60\x01\0\0\0\0\0\0\x01\0\0\0\x05\0\0\0\xd8\x01\0\0\0\0\
\0\0\x01\0\0\0\x06\0\0\0\x98\x05\0\0\0\0\0\0\x01\0\0\0\x04\0\0\0\xd8\x05\0\0\0\
\0\0\0\x01\0\0\0\x05\0\0\0\x48\x06\0\0\0\0\0\0\x01\0\0\0\x06\0\0\0\x58\0\0\0\0\
\0\0\0\x01\0\0\0\x0a\0\0\0\xd8\0\0\0\0\0\0\0\x01\0\0\0\x0a\0\0\0\x18\x01\0\0\0\
\0\0\0\x01\0\0\0\x0c\0\0\0\x68\x01\0\0\0\0\0\0\x01\0\0\0\x0d\0\0\0\x98\x01\0\0\
\0\0\0\0\x01\0\0\0\x0a\0\0\0\x20\x02\0\0\0\0\0\0\x01\0\0\0\x0a\0\0\0\xa0\x02\0\
\0\0\0\0\0\x01\0\0\0\x0a\0\0\0\xe0\x02\0\0\0\0\0\0\x01\0\0\0\x0c\0\0\0\x30\x03\
\0\0\0\0\0\0\x01\0\0\0\x0d\0\0\0\x60\x03\0\0\0\0\0\0\x01\0\0\0\x0a\0\0\0\x04\
\x08\0\0\0\0\0\0\x04\0\0\0\x0c\0\0\0\x1c\x08\0\0\0\0\0\0\x03\0\0\0\x04\0\0\0\
\x34\x08\0\0\0\0\0\0\x04\0\0\0\x06\0\0\0\x40\x08\0\0\0\0\0\0\x04\0\0\0\x05\0\0\
\0\x4c\x08\0\0\0\0\0\0\x04\0\0\0\x0a\0\0\0\x58\x08\0\0\0\0\0\0\x04\0\0\0\x0d\0\
\0\0\x70\x08\0\0\0\0\0\0\x04\0\0\0\x10\0\0\0\x2c\0\0\0\0\0\0\0\x04\0\0\0\x01\0\
\0\0\x34\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x3c\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\
\0\x4c\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x54\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\
\x5c\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x64\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\
\x78\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x88\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\
\x98\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xa8\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\
\xb8\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xc8\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\
\xd8\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xe8\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\
\xf8\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x08\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\
\x18\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x28\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\
\0\x38\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x48\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\
\0\0\x58\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x68\x01\0\0\0\0\0\0\x04\0\0\0\x01\
\0\0\0\x78\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x88\x01\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\x98\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xa8\x01\0\0\0\0\0\0\x04\0\0\
\0\x01\0\0\0\xb8\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xc8\x01\0\0\0\0\0\0\x04\0\
\0\0\x01\0\0\0\xd8\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xe8\x01\0\0\0\0\0\0\x04\
\0\0\0\x01\0\0\0\xf8\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x08\x02\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\x18\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x28\x02\0\0\0\0\0\
\0\x04\0\0\0\x01\0\0\0\x38\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x48\x02\0\0\0\0\
\0\0\x04\0\0\0\x01\0\0\0\x58\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x68\x02\0\0\0\
\0\0\0\x04\0\0\0\x01\0\0\0\x78\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x88\x02\0\0\
\0\0\0\0\x04\0\0\0\x01\0\0\0\x98\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xa8\x02\0\
\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xb8\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xc8\x02\
\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xd8\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xe8\
\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xf8\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\
\x08\x03\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x18\x03\0\0\0\0\0\0\x04\0\0\0\x01\0\0\
\0\x28\x03\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x38\x03\0\0\0\0\0\0\x04\0\0\0\x01\0\
\0\0\x48\x03\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x58\x03\0\0\0\0\0\0\x04\0\0\0\x01\
\0\0\0\x68\x03\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x78\x03\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\x88\x03\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x98\x03\0\0\0\0\0\0\x04\0\0\
\0\x01\0\0\0\xa8\x03\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xb8\x03\0\0\0\0\0\0\x04\0\
\0\0\x01\0\0\0\xc8\x03\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xd8\x03\0\0\0\0\0\0\x04\
\0\0\0\x01\0\0\0\xe8\x03\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xf8\x03\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\x08\x04\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x18\x04\0\0\0\0\0\
\0\x04\0\0\0\x01\0\0\0\x28\x04\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x38\x04\0\0\0\0\
\0\0\x04\0\0\0\x01\0\0\0\x48\x04\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x58\x04\0\0\0\
\0\0\0\x04\0\0\0\x01\0\0\0\x68\x04\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x78\x04\0\0\
\0\0\0\0\x04\0\0\0\x01\0\0\0\x88\x04\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x98\x04\0\
\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xa8\x04\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xb8\x04\
\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xc8\x04\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xd8\
\x04\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xe8\x04\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\
\xf8\x04\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x08\x05\0\0\0\0\0\0\x04\0\0\0\x01\0\0\
\0\x18\x05\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x28\x05\0\0\0\0\0\0\x04\0\0\0\x01\0\
\0\0\x38\x05\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x48\x05\0\0\0\0\0\0\x04\0\0\0\x01\
\0\0\0\x58\x05\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x68\x05\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\x78\x05\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x88\x05\0\0\0\0\0\0\x04\0\0\
\0\x01\0\0\0\x98\x05\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xa8\x05\0\0\0\0\0\0\x04\0\
\0\0\x01\0\0\0\xb8\x05\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xc8\x05\0\0\0\0\0\0\x04\
\0\0\0\x01\0\0\0\xd8\x05\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xe8\x05\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\xf8\x05\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x10\x06\0\0\0\0\0\
\0\x04\0\0\0\x02\0\0\0\x20\x06\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x30\x06\0\0\0\0\
\0\0\x04\0\0\0\x02\0\0\0\x40\x06\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x50\x06\0\0\0\
\0\0\0\x04\0\0\0\x02\0\0\0\x60\x06\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x70\x06\0\0\
\0\0\0\0\x04\0\0\0\x02\0\0\0\x80\x06\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x90\x06\0\
\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xa0\x06\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xb0\x06\
\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xc0\x06\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xd0\
\x06\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xe0\x06\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\
\xf0\x06\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\0\x07\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\
\x10\x07\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x20\x07\0\0\0\0\0\0\x04\0\0\0\x02\0\0\
\0\x30\x07\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x40\x07\0\0\0\0\0\0\x04\0\0\0\x02\0\
\0\0\x50\x07\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x60\x07\0\0\0\0\0\0\x04\0\0\0\x02\
\0\0\0\x70\x07\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x80\x07\0\0\0\0\0\0\x04\0\0\0\
\x02\0\0\0\x90\x07\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xa0\x07\0\0\0\0\0\0\x04\0\0\
\0\x02\0\0\0\xb0\x07\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xc0\x07\0\0\0\0\0\0\x04\0\
\0\0\x02\0\0\0\xd0\x07\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xe0\x07\0\0\0\0\0\0\x04\
\0\0\0\x02\0\0\0\xf0\x07\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\0\x08\0\0\0\0\0\0\x04\
\0\0\0\x02\0\0\0\x10\x08\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x20\x08\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\x30\x08\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x40\x08\0\0\0\0\0\
\0\x04\0\0\0\x02\0\0\0\x50\x08\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x60\x08\0\0\0\0\
\0\0\x04\0\0\0\x02\0\0\0\x70\x08\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x80\x08\0\0\0\
\0\0\0\x04\0\0\0\x02\0\0\0\x90\x08\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xa0\x08\0\0\
\0\0\0\0\x04\0\0\0\x02\0\0\0\xb0\x08\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xc0\x08\0\
\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xd0\x08\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xe0\x08\
\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xf0\x08\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\0\x09\
\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x10\x09\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x20\
\x09\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x30\x09\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\
\x40\x09\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x50\x09\0\0\0\0\0\0\x04\0\0\0\x02\0\0\
\0\x60\x09\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x70\x09\0\0\0\0\0\0\x04\0\0\0\x02\0\
\0\0\x80\x09\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x90\x09\0\0\0\0\0\0\x04\0\0\0\x02\
\0\0\0\xa0\x09\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xb0\x09\0\0\0\0\0\0\x04\0\0\0\
\x02\0\0\0\xc0\x09\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xd0\x09\0\0\0\0\0\0\x04\0\0\
\0\x02\0\0\0\xe0\x09\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xfc\x09\0\0\0\0\0\0\x04\0\
\0\0\x01\0\0\0\x0c\x0a\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x1c\x0a\0\0\0\0\0\0\x04\
\0\0\0\x01\0\0\0\x13\x15\x18\x19\x10\x1a\x0f\x14\x17\0\x2e\x72\x65\x6c\x2e\x74\
\x65\x78\x74\0\x2e\x72\x65\x6c\x2e\x42\x54\x46\x2e\x65\x78\x74\0\x68\x61\x6e\
\x64\x6c\x65\x5f\x6d\x65\x6d\x5f\x70\x6f\x6f\x6c\x5f\x67\x63\x5f\x73\x74\x61\
\x72\x74\0\x68\x61\x6e\x64\x6c\x65\x5f\x67\x63\x5f\x73\x74\x61\x72\x74\0\x62\
\x70\x66\x5f\x75\x73\x64\x74\x5f\x61\x72\x67\x5f\x63\x6e\x74\0\x2e\x72\x65\x6c\
\x75\x73\x64\x74\0\x2e\x62\x73\x73\0\x2e\x6d\x61\x70\x73\0\x5f\x5f\x62\x70\x66\
\x5f\x75\x73\x64\x74\x5f\x73\x70\x65\x63\x73\0\x70\x65\x72\x66\x5f\x6d\x61\x70\
\0\x64\x61\x74\x61\x5f\x6d\x61\x70\0\x62\x70\x66\x5f\x75\x73\x64\x74\x5f\x61\
\x72\x67\0\x2e\x6c\x6c\x76\x6d\x5f\x61\x64\x64\x72\x73\x69\x67\0\x6c\x69\x63\
\x65\x6e\x73\x65\0\x74\x69\x6d\x65\0\x62\x70\x66\x5f\x75\x73\x64\x74\x5f\x63\
\x6f\x6f\x6b\x69\x65\0\x68\x61\x6e\x64\x6c\x65\x5f\x6d\x65\x6d\x5f\x70\x6f\x6f\
\x6c\x5f\x67\x63\x5f\x65\x6e\x64\0\x68\x61\x6e\x64\x6c\x65\x5f\x67\x63\x5f\x65\
\x6e\x64\0\x5f\x5f\x62\x70\x66\x5f\x75\x73\x64\x74\x5f\x69\x70\x5f\x74\x6f\x5f\
\x73\x70\x65\x63\x5f\x69\x64\0\x2e\x73\x74\x72\x74\x61\x62\0\x2e\x73\x79\x6d\
\x74\x61\x62\0\x2e\x72\x65\x6c\x2e\x42\x54\x46\0\x4c\x49\x43\x45\x4e\x53\x45\0\
\x4c\x49\x4e\x55\x58\x5f\x48\x41\x53\x5f\x42\x50\x46\x5f\x43\x4f\x4f\x4b\x49\
\x45\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\0\0\x03\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x19\x35\0\0\0\0\0\0\x35\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x05\0\0\0\x01\0\0\0\x06\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\x80\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x60\x29\0\0\0\0\0\0\x90\0\0\0\0\0\0\0\x0e\0\0\0\x02\0\0\0\x08\0\0\0\
\0\0\0\0\x10\0\0\0\0\0\0\0\x56\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\xc0\x06\0\0\0\0\0\0\x90\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x52\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xf0\x29\0\
\0\0\0\0\0\xa0\0\0\0\0\0\0\0\x0e\0\0\0\x04\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\
\0\0\0\x60\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x50\x0a\0\0\0\0\0\
\0\x78\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa4\0\0\
\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xc8\x0a\0\0\0\0\0\0\x0d\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x5b\0\0\0\x08\0\0\0\
\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xd8\x0a\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x13\x01\0\0\x01\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\xd8\x0a\0\0\0\0\0\0\xc0\x12\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x0f\x01\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x90\x2a\0\0\0\0\0\0\x70\0\0\0\0\0\0\0\x0e\0\0\0\x09\0\0\0\x08\0\0\
\0\0\0\0\0\x10\0\0\0\0\0\0\0\x0f\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x98\x1d\0\0\0\0\0\0\x2c\x0a\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x0b\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x2b\0\0\
\0\0\0\0\x10\x0a\0\0\0\0\0\0\x0e\0\0\0\x0b\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\
\0\0\0\x96\0\0\0\x03\x4c\xff\x6f\0\0\0\x80\0\0\0\0\0\0\0\0\0\0\0\0\x10\x35\0\0\
\0\0\0\0\x09\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x07\x01\0\0\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xc8\x27\0\0\0\0\0\0\x98\
\x01\0\0\0\0\0\0\x01\0\0\0\x03\0\0\0\x08\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\0";

	*sz = sizeof(data) - 1;
	return (const void *)data;
}

#ifdef __cplusplus
struct javagc_bpf *javagc_bpf::open(const struct bpf_object_open_opts *opts) { return javagc_bpf__open_opts(opts); }
struct javagc_bpf *javagc_bpf::open_and_load() { return javagc_bpf__open_and_load(); }
int javagc_bpf::load(struct javagc_bpf *skel) { return javagc_bpf__load(skel); }
int javagc_bpf::attach(struct javagc_bpf *skel) { return javagc_bpf__attach(skel); }
void javagc_bpf::detach(struct javagc_bpf *skel) { javagc_bpf__detach(skel); }
void javagc_bpf::destroy(struct javagc_bpf *skel) { javagc_bpf__destroy(skel); }
const void *javagc_bpf::elf_bytes(size_t *sz) { return javagc_bpf__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
javagc_bpf__assert(struct javagc_bpf *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
	_Static_assert(sizeof(s->bss->time) == 4, "unexpected size of 'time'");
	_Static_assert(sizeof(s->kconfig->LINUX_HAS_BPF_COOKIE) == 1, "unexpected size of 'LINUX_HAS_BPF_COOKIE'");
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __JAVAGC_BPF_SKEL_H__ */
