/* WorkspacesApplet.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WorkspacesApplet.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "workspacesapplet.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "plugin.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <libxfce4windowing/libxfce4windowing.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <libpeas/peas.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	WORKSPACES_WORKSPACES_PLUGIN_0_PROPERTY,
	WORKSPACES_WORKSPACES_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* workspaces_workspaces_plugin_properties[WORKSPACES_WORKSPACES_PLUGIN_NUM_PROPERTIES];
enum  {
	WORKSPACES_WORKSPACES_APPLET_SETTINGS_0_PROPERTY,
	WORKSPACES_WORKSPACES_APPLET_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* workspaces_workspaces_applet_settings_properties[WORKSPACES_WORKSPACES_APPLET_SETTINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef GDBusProxy WorkspacesBudgieWMProxy;
typedef GDBusProxyClass WorkspacesBudgieWMProxyClass;
enum  {
	WORKSPACES_WORKSPACES_APPLET_0_PROPERTY,
	WORKSPACES_WORKSPACES_APPLET_UUID_PROPERTY,
	WORKSPACES_WORKSPACES_APPLET_NUM_PROPERTIES
};
static GParamSpec* workspaces_workspaces_applet_properties[WORKSPACES_WORKSPACES_APPLET_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _WorkspacesWorkspacesAppletUpdateWorkspacesData WorkspacesWorkspacesAppletUpdateWorkspacesData;

struct _WorkspacesWorkspacesAppletSettingsPrivate {
	GtkComboBoxText* combobox_visibility;
	GtkComboBoxText* combobox_multiplier;
	GSettings* settings;
};

struct _WorkspacesWorkspacesAppletPrivate {
	WorkspacesBudgieWM* wm_proxy;
	GtkEventBox* ebox;
	GtkBox* main_layout;
	GtkBox* workspaces_layout;
	GtkRevealer* add_button_revealer;
	GtkRevealerTransitionType show_transition;
	GtkRevealerTransitionType hide_transition;
	gboolean startup;
	gint size_change;
	gboolean updating;
	gulong* connections;
	gint connections_length1;
	gint _connections_size_;
	GHashTable* window_connections;
	GList* dynamically_created_workspaces;
	GSettings* settings;
	WorkspacesAddButtonVisibility button_visibility;
	gfloat item_size_multiplier;
	gchar* _uuid;
	gint64 last_scroll_time;
};

struct _Block1Data {
	int _ref_count_;
	WorkspacesWorkspacesApplet* self;
	GtkWidget* widget;
};

struct _Block2Data {
	int _ref_count_;
	WorkspacesWorkspacesApplet* self;
	XfwWindow* window;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	gint index;
};

struct _Block4Data {
	int _ref_count_;
	WorkspacesWorkspacesApplet* self;
	WorkspacesWorkspaceItem* item;
	GList* window_list;
	gint index;
};

struct _WorkspacesWorkspacesAppletUpdateWorkspacesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	WorkspacesWorkspacesApplet* self;
	gboolean _tmp0_;
	GtkContainer* _tmp1_;
	GtkBox* _tmp2_;
	GList* _tmp3_;
	GList* widget_collection;
	GList* widget_it;
	GtkWidget* _tmp4_;
	GtkWidget* widget;
	Block4Data* _data4_;
	GtkRevealer* revealer;
	GtkWidget* _tmp5_;
	GtkRevealer* _tmp6_;
	GtkRevealer* _tmp7_;
	GtkWidget* _tmp8_;
	WorkspacesWorkspaceItem* _tmp9_;
	GList* windows;
	XfwScreen* _tmp10_;
	GList* _tmp11_;
	GList* _tmp12_;
	GList* _tmp13_;
	WorkspacesWorkspaceItem* _tmp14_;
	XfwWorkspace* _tmp15_;
	XfwWorkspace* _tmp16_;
	gint _tmp17_;
	GList* dyn;
	GList* _tmp18_;
	GList* _tmp19_;
	gboolean _tmp20_;
	GList* _tmp21_;
	GList* _tmp22_;
	GList* _tmp23_;
	GList* _tmp24_;
	GList* _tmp25_;
	WorkspacesWorkspaceItem* _tmp26_;
	GList* _tmp27_;
};

static gpointer workspaces_workspaces_plugin_parent_class = NULL;
static BudgiePluginIface * workspaces_workspaces_plugin_budgie_plugin_parent_iface = NULL;
static GType workspaces_workspaces_plugin_type_id = 0;
static gint WorkspacesWorkspacesAppletSettings_private_offset;
static gpointer workspaces_workspaces_applet_settings_parent_class = NULL;
static GType workspaces_workspaces_applet_settings_type_id = 0;
static GType workspaces_budgie_wm_type_id = 0;
static gint WorkspacesWorkspacesApplet_private_offset;
static gpointer workspaces_workspaces_applet_parent_class = NULL;
BudgiePanelPosition workspaces_workspaces_applet_panel_position = BUDGIE_PANEL_POSITION_BOTTOM;
gint workspaces_workspaces_applet_panel_size = 0;
BudgiePopoverManager* workspaces_workspaces_applet_manager = NULL;
XfwScreen* workspaces_workspaces_applet_xfce_screen = NULL;
XfwWorkspaceManager* workspaces_workspaces_applet_workspace_manager = NULL;
XfwWorkspaceGroup* workspaces_workspaces_applet_workspace_group = NULL;
gboolean workspaces_workspaces_applet_dragging = FALSE;
static GType workspaces_workspaces_applet_type_id = 0;

static BudgieApplet* workspaces_workspaces_plugin_real_get_panel_widget (BudgiePlugin* base,
                                                                  const gchar* uuid);
static void workspaces_workspaces_applet_settings_finalize (GObject * obj);
static void workspaces_budgie_wm_proxy_g_signal (GDBusProxy* proxy,
                                          const gchar* sender_name,
                                          const gchar* signal_name,
                                          GVariant* parameters);
static void workspaces_budgie_wm_proxy_RemoveWorkspaceByIndex (WorkspacesBudgieWM* self,
                                                        gint index,
                                                        guint32 time,
                                                        GError** error);
static gint workspaces_budgie_wm_proxy_AppendNewWorkspace (WorkspacesBudgieWM* self,
                                                    guint32 time,
                                                    GError** error);
static void workspaces_budgie_wm_proxy_workspaces_budgie_wm_interface_init (WorkspacesBudgieWMIface* iface);
static void _dbus_workspaces_budgie_wm_RemoveWorkspaceByIndex (WorkspacesBudgieWM* self,
                                                        GVariant* _parameters_,
                                                        GDBusMethodInvocation* invocation);
static void _dbus_workspaces_budgie_wm_AppendNewWorkspace (WorkspacesBudgieWM* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation);
static void workspaces_budgie_wm_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data);
static GVariant* workspaces_budgie_wm_dbus_interface_get_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GError** error,
                                                            gpointer user_data);
static gboolean workspaces_budgie_wm_dbus_interface_set_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GVariant* value,
                                                           GError** error,
                                                           gpointer user_data);
static void _workspaces_budgie_wm_unregister_object (gpointer user_data);
static GtkWidget* workspaces_workspaces_applet_real_get_settings_ui (BudgieApplet* base);
static gboolean workspaces_workspaces_applet_real_supports_settings (BudgieApplet* base);
static void workspaces_workspaces_applet_on_settings_change (WorkspacesWorkspacesApplet* self,
                                                      const gchar* key);
static void _workspaces_workspaces_applet_on_settings_change_g_settings_changed (GSettings* _sender,
                                                                          const gchar* key,
                                                                          gpointer self);
static void workspaces_workspaces_applet_has_wm (WorkspacesWorkspacesApplet* self);
static void _workspaces_workspaces_applet_has_wm_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                       const gchar* name,
                                                                       const gchar* name_owner,
                                                                       gpointer self);
static void workspaces_workspaces_applet_lost_wm (WorkspacesWorkspacesApplet* self);
static void _workspaces_workspaces_applet_lost_wm_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                        const gchar* name,
                                                                        gpointer self);
static gboolean workspaces_workspaces_applet_on_add_button_drag_drop (WorkspacesWorkspacesApplet* self,
                                                               GtkWidget* widget,
                                                               GdkDragContext* context,
                                                               gint x,
                                                               gint y,
                                                               guint time);
static gboolean _workspaces_workspaces_applet_on_add_button_drag_drop_gtk_widget_drag_drop (GtkWidget* _sender,
                                                                                     GdkDragContext* context,
                                                                                     gint x,
                                                                                     gint y,
                                                                                     guint time_,
                                                                                     gpointer self);
static void workspaces_workspaces_applet_on_add_button_drag_data_received (WorkspacesWorkspacesApplet* self,
                                                                    GtkWidget* widget,
                                                                    GdkDragContext* context,
                                                                    gint x,
                                                                    gint y,
                                                                    GtkSelectionData* selection_data,
                                                                    guint target_type,
                                                                    guint time);
static void _workspaces_workspaces_applet_on_add_button_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                                                   GdkDragContext* context,
                                                                                                   gint x,
                                                                                                   gint y,
                                                                                                   GtkSelectionData* selection_data,
                                                                                                   guint info,
                                                                                                   guint time_,
                                                                                                   gpointer self);
static gboolean __lambda19_ (WorkspacesWorkspacesApplet* self,
                      GdkEventButton* event);
static void workspaces_workspaces_applet_set_current_workspace (WorkspacesWorkspacesApplet* self);
static gboolean workspaces_workspaces_applet_below_max_workspace_count (WorkspacesWorkspacesApplet* self);
static gboolean ___lambda19__gtk_widget_button_release_event (GtkWidget* _sender,
                                                       GdkEventButton* event,
                                                       gpointer self);
static gboolean __lambda20_ (WorkspacesWorkspacesApplet* self);
static gboolean __lambda21_ (WorkspacesWorkspacesApplet* self);
static void workspaces_workspaces_applet_update_workspaces (WorkspacesWorkspacesApplet* self,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static void workspaces_workspaces_applet_update_workspaces_finish (WorkspacesWorkspacesApplet* self,
                                                            GAsyncResult* _res_);
static gboolean ___lambda21__gsource_func (gpointer self);
static gboolean ___lambda20__gsource_func (gpointer self);
static void workspaces_workspaces_applet_populate_workspaces (WorkspacesWorkspacesApplet* self);
static gboolean __lambda23_ (WorkspacesWorkspacesApplet* self);
static gboolean ___lambda23__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                     GdkEventCrossing* event,
                                                     gpointer self);
static gboolean __lambda24_ (WorkspacesWorkspacesApplet* self);
static gboolean ___lambda24__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                     GdkEventCrossing* event,
                                                     gpointer self);
static gboolean __lambda25_ (WorkspacesWorkspacesApplet* self,
                      GdkEventScroll* e);
static gboolean ___lambda25__gtk_widget_scroll_event (GtkWidget* _sender,
                                               GdkEventScroll* event,
                                               gpointer self);
static gboolean ____lambda14_ (WorkspacesWorkspacesApplet* self);
static gboolean _____lambda14__gsource_func (gpointer self);
static void workspaces_workspaces_applet_workspace_added (WorkspacesWorkspacesApplet* self,
                                                   XfwWorkspace* space);
static void workspaces_workspaces_applet_connect_signals (WorkspacesWorkspacesApplet* self);
static void workspaces_workspaces_applet_window_opened (WorkspacesWorkspacesApplet* self,
                                                 XfwWindow* window);
static void workspaces_workspaces_applet_on_wm_get (WorkspacesWorkspacesApplet* self,
                                             GObject* o,
                                             GAsyncResult* res);
static void _workspaces_workspaces_applet_on_wm_get_gasync_ready_callback (GObject* source_object,
                                                                    GAsyncResult* res,
                                                                    gpointer self);
static void _workspaces_workspaces_applet_workspace_added_libxfce4windowing_workspace_group_workspace_added (XfwWorkspaceGroup* _sender,
                                                                                                      XfwWorkspace* workspace,
                                                                                                      gpointer self);
static void _vala_array_add1 (gulong* * array,
                       gint* length,
                       gint* size,
                       gulong value);
static void workspaces_workspaces_applet_workspace_removed (WorkspacesWorkspacesApplet* self,
                                                     XfwWorkspace* space);
static void _workspaces_workspaces_applet_workspace_removed_libxfce4windowing_workspace_group_workspace_removed (XfwWorkspaceGroup* _sender,
                                                                                                          XfwWorkspace* workspace,
                                                                                                          gpointer self);
static void _vala_array_add2 (gulong* * array,
                       gint* length,
                       gint* size,
                       gulong value);
static void _workspaces_workspaces_applet_set_current_workspace_libxfce4windowing_workspace_group_active_workspace_changed (XfwWorkspaceGroup* _sender,
                                                                                                                     XfwWorkspace* previously_active_workspace,
                                                                                                                     gpointer self);
static void _vala_array_add3 (gulong* * array,
                       gint* length,
                       gint* size,
                       gulong value);
static void _workspaces_workspaces_applet_update_workspaces_libxfce4windowing_screen_active_window_changed (XfwScreen* _sender,
                                                                                                     XfwWindow* window,
                                                                                                     gpointer self);
static void _vala_array_add4 (gulong* * array,
                       gint* length,
                       gint* size,
                       gulong value);
static void _workspaces_workspaces_applet_window_opened_libxfce4windowing_screen_window_opened (XfwScreen* _sender,
                                                                                         XfwWindow* window,
                                                                                         gpointer self);
static void _vala_array_add5 (gulong* * array,
                       gint* length,
                       gint* size,
                       gulong value);
static void workspaces_workspaces_applet_window_closed (WorkspacesWorkspacesApplet* self,
                                                 XfwWindow* window);
static void _workspaces_workspaces_applet_window_closed_libxfce4windowing_screen_window_closed (XfwScreen* _sender,
                                                                                         XfwWindow* window,
                                                                                         gpointer self);
static void _vala_array_add6 (gulong* * array,
                       gint* length,
                       gint* size,
                       gulong value);
static void workspaces_workspaces_applet_disconnect_signals (WorkspacesWorkspacesApplet* self);
static void __lambda15_ (WorkspacesWorkspacesApplet* self,
                  XfwWindow* key,
                  gulong val);
static void ___lambda15__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
static void workspaces_workspaces_applet_remove_workspace (WorkspacesWorkspacesApplet* self,
                                                    guint index,
                                                    guint32 time);
static void _workspaces_workspaces_applet_remove_workspace_workspaces_workspace_item_remove_workspace (WorkspacesWorkspaceItem* _sender,
                                                                                                guint index,
                                                                                                guint32 time,
                                                                                                gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean _____lambda22_ (Block1Data* _data1_);
static gboolean ______lambda22__gsource_func (gpointer self);
static void _workspaces_workspaces_applet_update_workspaces_libxfce4windowing_window_workspace_changed (XfwWindow* _sender,
                                                                                                 gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean ____lambda18_ (Block3Data* _data3_);
static XfwWorkspace* workspaces_workspaces_applet_get_workspace_by_index (WorkspacesWorkspacesApplet* self,
                                                                   guint num);
static gboolean _____lambda18__gsource_func (gpointer self);
static void workspaces_workspaces_applet_real_panel_size_changed (BudgieApplet* base,
                                                           gint panel_size,
                                                           gint icon_size,
                                                           gint small_icon_size);
static void workspaces_workspaces_applet_real_panel_position_changed (BudgieApplet* base,
                                                               BudgiePanelPosition position);
static gboolean ___lambda26_ (WorkspacesWorkspacesApplet* self);
static gboolean ____lambda26__gsource_func (gpointer self);
static void workspaces_workspaces_applet_update_workspaces_data_free (gpointer _data);
static gboolean workspaces_workspaces_applet_update_workspaces_co (WorkspacesWorkspacesAppletUpdateWorkspacesData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void ____lambda16_ (Block4Data* _data4_,
                    XfwWindow* window);
static void _____lambda16__gfunc (gconstpointer data,
                           gpointer self);
static gboolean ______lambda17_ (Block4Data* _data4_);
static gboolean _______lambda17__gsource_func (gpointer self);
static void workspaces_workspaces_applet_real_update_popovers (BudgieApplet* base,
                                                        BudgiePopoverManager* manager);
static void workspaces_workspaces_applet_finalize (GObject * obj);
static void _vala_workspaces_workspaces_applet_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_workspaces_workspaces_applet_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
GType workspaces_workspace_item_register_type (GTypeModule * module);
GType workspaces_window_icon_register_type (GTypeModule * module);

static const GDBusArgInfo _workspaces_budgie_wm_dbus_arg_info_RemoveWorkspaceByIndex_index = {-1, "index", "i", NULL};
static const GDBusArgInfo _workspaces_budgie_wm_dbus_arg_info_RemoveWorkspaceByIndex_time = {-1, "time", "u", NULL};
static const GDBusArgInfo * const _workspaces_budgie_wm_dbus_arg_info_RemoveWorkspaceByIndex_in[] = {&_workspaces_budgie_wm_dbus_arg_info_RemoveWorkspaceByIndex_index, &_workspaces_budgie_wm_dbus_arg_info_RemoveWorkspaceByIndex_time, NULL};
static const GDBusArgInfo * const _workspaces_budgie_wm_dbus_arg_info_RemoveWorkspaceByIndex_out[] = {NULL};
static const GDBusMethodInfo _workspaces_budgie_wm_dbus_method_info_RemoveWorkspaceByIndex = {-1, "RemoveWorkspaceByIndex", (GDBusArgInfo **) (&_workspaces_budgie_wm_dbus_arg_info_RemoveWorkspaceByIndex_in), (GDBusArgInfo **) (&_workspaces_budgie_wm_dbus_arg_info_RemoveWorkspaceByIndex_out), NULL};
static const GDBusArgInfo _workspaces_budgie_wm_dbus_arg_info_AppendNewWorkspace_time = {-1, "time", "u", NULL};
static const GDBusArgInfo _workspaces_budgie_wm_dbus_arg_info_AppendNewWorkspace_result = {-1, "result", "i", NULL};
static const GDBusArgInfo * const _workspaces_budgie_wm_dbus_arg_info_AppendNewWorkspace_in[] = {&_workspaces_budgie_wm_dbus_arg_info_AppendNewWorkspace_time, NULL};
static const GDBusArgInfo * const _workspaces_budgie_wm_dbus_arg_info_AppendNewWorkspace_out[] = {&_workspaces_budgie_wm_dbus_arg_info_AppendNewWorkspace_result, NULL};
static const GDBusMethodInfo _workspaces_budgie_wm_dbus_method_info_AppendNewWorkspace = {-1, "AppendNewWorkspace", (GDBusArgInfo **) (&_workspaces_budgie_wm_dbus_arg_info_AppendNewWorkspace_in), (GDBusArgInfo **) (&_workspaces_budgie_wm_dbus_arg_info_AppendNewWorkspace_out), NULL};
static const GDBusMethodInfo * const _workspaces_budgie_wm_dbus_method_info[] = {&_workspaces_budgie_wm_dbus_method_info_RemoveWorkspaceByIndex, &_workspaces_budgie_wm_dbus_method_info_AppendNewWorkspace, NULL};
static const GDBusSignalInfo * const _workspaces_budgie_wm_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _workspaces_budgie_wm_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _workspaces_budgie_wm_dbus_interface_info = {-1, "org.budgie_desktop.BudgieWM", (GDBusMethodInfo **) (&_workspaces_budgie_wm_dbus_method_info), (GDBusSignalInfo **) (&_workspaces_budgie_wm_dbus_signal_info), (GDBusPropertyInfo **) (&_workspaces_budgie_wm_dbus_property_info), NULL};
static const GDBusInterfaceVTable _workspaces_budgie_wm_dbus_interface_vtable = {workspaces_budgie_wm_dbus_interface_method_call, workspaces_budgie_wm_dbus_interface_get_property, workspaces_budgie_wm_dbus_interface_set_property};
VALA_EXTERN const GtkTargetEntry WORKSPACES_target_list[1];

static GType
workspaces_add_button_visibility_get_type_once (void)
{
	static const GFlagsValue values[] = {{WORKSPACES_ADD_BUTTON_VISIBILITY_NEVER, "WORKSPACES_ADD_BUTTON_VISIBILITY_NEVER", "never"}, {WORKSPACES_ADD_BUTTON_VISIBILITY_HOVER, "WORKSPACES_ADD_BUTTON_VISIBILITY_HOVER", "hover"}, {WORKSPACES_ADD_BUTTON_VISIBILITY_ALWAYS, "WORKSPACES_ADD_BUTTON_VISIBILITY_ALWAYS", "always"}, {0, NULL, NULL}};
	GType workspaces_add_button_visibility_type_id;
	workspaces_add_button_visibility_type_id = g_flags_register_static ("WorkspacesAddButtonVisibility", values);
	return workspaces_add_button_visibility_type_id;
}

GType
workspaces_add_button_visibility_get_type (void)
{
	static volatile gsize workspaces_add_button_visibility_type_id__once = 0;
	if (g_once_init_enter (&workspaces_add_button_visibility_type_id__once)) {
		GType workspaces_add_button_visibility_type_id;
		workspaces_add_button_visibility_type_id = workspaces_add_button_visibility_get_type_once ();
		g_once_init_leave (&workspaces_add_button_visibility_type_id__once, workspaces_add_button_visibility_type_id);
	}
	return workspaces_add_button_visibility_type_id__once;
}

static BudgieApplet*
workspaces_workspaces_plugin_real_get_panel_widget (BudgiePlugin* base,
                                                    const gchar* uuid)
{
	WorkspacesWorkspacesPlugin * self;
	WorkspacesWorkspacesApplet* _tmp0_;
	BudgieApplet* result;
	self = (WorkspacesWorkspacesPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = workspaces_workspaces_applet_new (uuid);
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

WorkspacesWorkspacesPlugin*
workspaces_workspaces_plugin_construct (GType object_type)
{
	WorkspacesWorkspacesPlugin * self = NULL;
	self = (WorkspacesWorkspacesPlugin*) g_object_new (object_type, NULL);
	return self;
}

WorkspacesWorkspacesPlugin*
workspaces_workspaces_plugin_new (void)
{
	return workspaces_workspaces_plugin_construct (WORKSPACES_TYPE_WORKSPACES_PLUGIN);
}

static void
workspaces_workspaces_plugin_class_init (WorkspacesWorkspacesPluginClass * klass,
                                         gpointer klass_data)
{
	workspaces_workspaces_plugin_parent_class = g_type_class_peek_parent (klass);
}

static void
workspaces_workspaces_plugin_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                                           gpointer iface_data)
{
	workspaces_workspaces_plugin_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) workspaces_workspaces_plugin_real_get_panel_widget;
}

static void
workspaces_workspaces_plugin_instance_init (WorkspacesWorkspacesPlugin * self,
                                            gpointer klass)
{
}

GType
workspaces_workspaces_plugin_get_type (void)
{
	return workspaces_workspaces_plugin_type_id;
}

GType
workspaces_workspaces_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (WorkspacesWorkspacesPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) workspaces_workspaces_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WorkspacesWorkspacesPlugin), 0, (GInstanceInitFunc) workspaces_workspaces_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) workspaces_workspaces_plugin_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	workspaces_workspaces_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "WorkspacesWorkspacesPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, workspaces_workspaces_plugin_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return workspaces_workspaces_plugin_type_id;
}

static inline gpointer
workspaces_workspaces_applet_settings_get_instance_private (WorkspacesWorkspacesAppletSettings* self)
{
	return G_STRUCT_MEMBER_P (self, WorkspacesWorkspacesAppletSettings_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

WorkspacesWorkspacesAppletSettings*
workspaces_workspaces_applet_settings_construct (GType object_type,
                                                 GSettings* settings)
{
	WorkspacesWorkspacesAppletSettings * self = NULL;
	GSettings* _tmp0_;
	GtkComboBoxText* _tmp1_;
	GtkComboBoxText* _tmp2_;
	self = (WorkspacesWorkspacesAppletSettings*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->combobox_visibility;
	g_settings_bind (settings, "addbutton-visibility", (GObject*) _tmp1_, "active_id", G_SETTINGS_BIND_DEFAULT);
	_tmp2_ = self->priv->combobox_multiplier;
	g_settings_bind (settings, "item-size-multiplier", (GObject*) _tmp2_, "active_id", G_SETTINGS_BIND_DEFAULT);
	return self;
}

WorkspacesWorkspacesAppletSettings*
workspaces_workspaces_applet_settings_new (GSettings* settings)
{
	return workspaces_workspaces_applet_settings_construct (WORKSPACES_TYPE_WORKSPACES_APPLET_SETTINGS, settings);
}

static void
workspaces_workspaces_applet_settings_class_init (WorkspacesWorkspacesAppletSettingsClass * klass,
                                                  gpointer klass_data)
{
	workspaces_workspaces_applet_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WorkspacesWorkspacesAppletSettings_private_offset);
	G_OBJECT_CLASS (klass)->finalize = workspaces_workspaces_applet_settings_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/solus-project/workspaces/settings.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "combobox_visibility", FALSE, WorkspacesWorkspacesAppletSettings_private_offset + G_STRUCT_OFFSET (WorkspacesWorkspacesAppletSettingsPrivate, combobox_visibility));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "combobox_multiplier", FALSE, WorkspacesWorkspacesAppletSettings_private_offset + G_STRUCT_OFFSET (WorkspacesWorkspacesAppletSettingsPrivate, combobox_multiplier));
}

static void
workspaces_workspaces_applet_settings_instance_init (WorkspacesWorkspacesAppletSettings * self,
                                                     gpointer klass)
{
	self->priv = workspaces_workspaces_applet_settings_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
workspaces_workspaces_applet_settings_finalize (GObject * obj)
{
	WorkspacesWorkspacesAppletSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WORKSPACES_TYPE_WORKSPACES_APPLET_SETTINGS, WorkspacesWorkspacesAppletSettings);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (workspaces_workspaces_applet_settings_parent_class)->finalize (obj);
}

GType
workspaces_workspaces_applet_settings_get_type (void)
{
	return workspaces_workspaces_applet_settings_type_id;
}

GType
workspaces_workspaces_applet_settings_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (WorkspacesWorkspacesAppletSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) workspaces_workspaces_applet_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WorkspacesWorkspacesAppletSettings), 0, (GInstanceInitFunc) workspaces_workspaces_applet_settings_instance_init, NULL };
	workspaces_workspaces_applet_settings_type_id = g_type_module_register_type (module, gtk_grid_get_type (), "WorkspacesWorkspacesAppletSettings", &g_define_type_info, 0);
	WorkspacesWorkspacesAppletSettings_private_offset = sizeof (WorkspacesWorkspacesAppletSettingsPrivate);
	return workspaces_workspaces_applet_settings_type_id;
}

void
workspaces_budgie_wm_RemoveWorkspaceByIndex (WorkspacesBudgieWM* self,
                                             gint index,
                                             guint32 time,
                                             GError** error)
{
	WorkspacesBudgieWMIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = WORKSPACES_BUDGIE_WM_GET_INTERFACE (self);
	if (_iface_->RemoveWorkspaceByIndex) {
		_iface_->RemoveWorkspaceByIndex (self, index, time, error);
	}
}

gint
workspaces_budgie_wm_AppendNewWorkspace (WorkspacesBudgieWM* self,
                                         guint32 time,
                                         GError** error)
{
	WorkspacesBudgieWMIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = WORKSPACES_BUDGIE_WM_GET_INTERFACE (self);
	if (_iface_->AppendNewWorkspace) {
		return _iface_->AppendNewWorkspace (self, time, error);
	}
	return -1;
}

static void
workspaces_budgie_wm_default_init (WorkspacesBudgieWMIface * iface,
                                   gpointer iface_data)
{
}

GType
workspaces_budgie_wm_get_type (void)
{
	return workspaces_budgie_wm_type_id;
}

GType
workspaces_budgie_wm_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (WorkspacesBudgieWMIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) workspaces_budgie_wm_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	workspaces_budgie_wm_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "WorkspacesBudgieWM", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (workspaces_budgie_wm_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (workspaces_budgie_wm_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) workspaces_budgie_wm_proxy_get_type);
	g_type_set_qdata (workspaces_budgie_wm_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.budgie_desktop.BudgieWM");
	g_type_set_qdata (workspaces_budgie_wm_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_workspaces_budgie_wm_dbus_interface_info));
	g_type_set_qdata (workspaces_budgie_wm_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) workspaces_budgie_wm_register_object);
	return workspaces_budgie_wm_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (WorkspacesBudgieWMProxy, workspaces_budgie_wm_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (WORKSPACES_TYPE_BUDGIE_WM, workspaces_budgie_wm_proxy_workspaces_budgie_wm_interface_init) )
static void
workspaces_budgie_wm_proxy_class_init (WorkspacesBudgieWMProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = workspaces_budgie_wm_proxy_g_signal;
}

static void
workspaces_budgie_wm_proxy_g_signal (GDBusProxy* proxy,
                                     const gchar* sender_name,
                                     const gchar* signal_name,
                                     GVariant* parameters)
{
}

static void
workspaces_budgie_wm_proxy_class_finalize (WorkspacesBudgieWMProxyClass* klass)
{
}

void
workspaces_budgie_wm_proxy_register_dynamic_type (GTypeModule* module)
{
	workspaces_budgie_wm_proxy_register_type (module);
}

static void
workspaces_budgie_wm_proxy_init (WorkspacesBudgieWMProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_workspaces_budgie_wm_dbus_interface_info));
}

static void
workspaces_budgie_wm_proxy_RemoveWorkspaceByIndex (WorkspacesBudgieWM* self,
                                                   gint index,
                                                   guint32 time,
                                                   GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.BudgieWM", "RemoveWorkspaceByIndex");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (index));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (time));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gint
workspaces_budgie_wm_proxy_AppendNewWorkspace (WorkspacesBudgieWM* self,
                                               guint32 time,
                                               GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gint _result = 0;
	GVariant* _tmp2_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.BudgieWM", "AppendNewWorkspace");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (time));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		gint _tmp0_ = 0;
		return _tmp0_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		gint _tmp1_ = 0;
		g_object_unref (_reply_message);
		return _tmp1_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp2_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_int32 (_tmp2_);
	g_variant_unref (_tmp2_);
	g_object_unref (_reply_message);
	return _result;
}

static void
workspaces_budgie_wm_proxy_workspaces_budgie_wm_interface_init (WorkspacesBudgieWMIface* iface)
{
	iface->RemoveWorkspaceByIndex = workspaces_budgie_wm_proxy_RemoveWorkspaceByIndex;
	iface->AppendNewWorkspace = workspaces_budgie_wm_proxy_AppendNewWorkspace;
}

static void
_dbus_workspaces_budgie_wm_RemoveWorkspaceByIndex (WorkspacesBudgieWM* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint index = 0;
	GVariant* _tmp3_;
	guint32 time = 0U;
	GVariant* _tmp4_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	index = g_variant_get_int32 (_tmp3_);
	g_variant_unref (_tmp3_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	time = g_variant_get_uint32 (_tmp4_);
	g_variant_unref (_tmp4_);
	workspaces_budgie_wm_RemoveWorkspaceByIndex (self, index, time, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_workspaces_budgie_wm_AppendNewWorkspace (WorkspacesBudgieWM* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 time = 0U;
	GVariant* _tmp5_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gint result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	time = g_variant_get_uint32 (_tmp5_);
	g_variant_unref (_tmp5_);
	result = workspaces_budgie_wm_AppendNewWorkspace (self, time, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_int32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
workspaces_budgie_wm_dbus_interface_method_call (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* method_name,
                                                 GVariant* parameters,
                                                 GDBusMethodInvocation* invocation,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "RemoveWorkspaceByIndex") == 0) {
		_dbus_workspaces_budgie_wm_RemoveWorkspaceByIndex (object, parameters, invocation);
	} else if (strcmp (method_name, "AppendNewWorkspace") == 0) {
		_dbus_workspaces_budgie_wm_AppendNewWorkspace (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
workspaces_budgie_wm_dbus_interface_get_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
workspaces_budgie_wm_dbus_interface_set_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GVariant* value,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
workspaces_budgie_wm_register_object (gpointer object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_workspaces_budgie_wm_dbus_interface_info), &_workspaces_budgie_wm_dbus_interface_vtable, data, _workspaces_budgie_wm_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_workspaces_budgie_wm_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
workspaces_workspaces_applet_get_instance_private (WorkspacesWorkspacesApplet* self)
{
	return G_STRUCT_MEMBER_P (self, WorkspacesWorkspacesApplet_private_offset);
}

static GtkWidget*
workspaces_workspaces_applet_real_get_settings_ui (BudgieApplet* base)
{
	WorkspacesWorkspacesApplet * self;
	const gchar* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	WorkspacesWorkspacesAppletSettings* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* result;
	self = (WorkspacesWorkspacesApplet*) base;
	_tmp0_ = self->priv->_uuid;
	_tmp1_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = workspaces_workspaces_applet_settings_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = (GtkWidget*) _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static gboolean
workspaces_workspaces_applet_real_supports_settings (BudgieApplet* base)
{
	WorkspacesWorkspacesApplet * self;
	gboolean result;
	self = (WorkspacesWorkspacesApplet*) base;
	result = TRUE;
	return result;
}

static void
_workspaces_workspaces_applet_on_settings_change_g_settings_changed (GSettings* _sender,
                                                                     const gchar* key,
                                                                     gpointer self)
{
	workspaces_workspaces_applet_on_settings_change ((WorkspacesWorkspacesApplet*) self, key);
}

static void
_workspaces_workspaces_applet_has_wm_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                  const gchar* name,
                                                                  const gchar* name_owner,
                                                                  gpointer self)
{
	workspaces_workspaces_applet_has_wm ((WorkspacesWorkspacesApplet*) self);
}

static void
_workspaces_workspaces_applet_lost_wm_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                   const gchar* name,
                                                                   gpointer self)
{
	workspaces_workspaces_applet_lost_wm ((WorkspacesWorkspacesApplet*) self);
}

static gboolean
_workspaces_workspaces_applet_on_add_button_drag_drop_gtk_widget_drag_drop (GtkWidget* _sender,
                                                                            GdkDragContext* context,
                                                                            gint x,
                                                                            gint y,
                                                                            guint time_,
                                                                            gpointer self)
{
	gboolean result;
	result = workspaces_workspaces_applet_on_add_button_drag_drop ((WorkspacesWorkspacesApplet*) self, _sender, context, x, y, time_);
	return result;
}

static void
_workspaces_workspaces_applet_on_add_button_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                                              GdkDragContext* context,
                                                                                              gint x,
                                                                                              gint y,
                                                                                              GtkSelectionData* selection_data,
                                                                                              guint info,
                                                                                              guint time_,
                                                                                              gpointer self)
{
	workspaces_workspaces_applet_on_add_button_drag_data_received ((WorkspacesWorkspacesApplet*) self, _sender, context, x, y, selection_data, info, time_);
}

static gboolean
__lambda19_ (WorkspacesWorkspacesApplet* self,
             GdkEventButton* event)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	{
		gint new_index = 0;
		WorkspacesBudgieWM* _tmp0_;
		_tmp0_ = self->priv->wm_proxy;
		new_index = workspaces_budgie_wm_AppendNewWorkspace (_tmp0_, event->time, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (new_index != -1) {
			workspaces_workspaces_applet_set_current_workspace (self);
		} else {
			if (!workspaces_workspaces_applet_below_max_workspace_count (self)) {
				GtkRevealer* _tmp1_;
				_tmp1_ = self->priv->add_button_revealer;
				gtk_revealer_set_reveal_child (_tmp1_, FALSE);
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("WorkspacesApplet.vala:154: Failed to append new workspace: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda19__gtk_widget_button_release_event (GtkWidget* _sender,
                                              GdkEventButton* event,
                                              gpointer self)
{
	gboolean result;
	result = __lambda19_ ((WorkspacesWorkspacesApplet*) self, event);
	return result;
}

static gboolean
__lambda21_ (WorkspacesWorkspacesApplet* self)
{
	gboolean result;
	self->priv->startup = FALSE;
	workspaces_workspaces_applet_update_workspaces (self, NULL, NULL);
	result = FALSE;
	return result;
}

static gboolean
___lambda21__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda21_ ((WorkspacesWorkspacesApplet*) self);
	return result;
}

static gboolean
__lambda20_ (WorkspacesWorkspacesApplet* self)
{
	gboolean result;
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda21__gsource_func, g_object_ref (self), g_object_unref);
	result = FALSE;
	return result;
}

static gboolean
___lambda20__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda20_ ((WorkspacesWorkspacesApplet*) self);
	return result;
}

static gboolean
__lambda23_ (WorkspacesWorkspacesApplet* self)
{
	gboolean result;
	if (self->priv->button_visibility != WORKSPACES_ADD_BUTTON_VISIBILITY_HOVER) {
		result = FALSE;
		return result;
	}
	if (workspaces_workspaces_applet_below_max_workspace_count (self)) {
		GtkRevealer* _tmp0_;
		GtkRevealer* _tmp1_;
		_tmp0_ = self->priv->add_button_revealer;
		gtk_revealer_set_transition_type (_tmp0_, self->priv->show_transition);
		_tmp1_ = self->priv->add_button_revealer;
		gtk_revealer_set_reveal_child (_tmp1_, TRUE);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda23__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                            GdkEventCrossing* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda23_ ((WorkspacesWorkspacesApplet*) self);
	return result;
}

static gboolean
__lambda24_ (WorkspacesWorkspacesApplet* self)
{
	gboolean _tmp0_ = FALSE;
	GtkRevealer* _tmp1_;
	GtkRevealer* _tmp2_;
	gboolean result;
	if (workspaces_workspaces_applet_dragging) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->button_visibility != WORKSPACES_ADD_BUTTON_VISIBILITY_HOVER;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->add_button_revealer;
	gtk_revealer_set_transition_type (_tmp1_, self->priv->hide_transition);
	_tmp2_ = self->priv->add_button_revealer;
	gtk_revealer_set_reveal_child (_tmp2_, FALSE);
	result = FALSE;
	return result;
}

static gboolean
___lambda24__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                            GdkEventCrossing* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda24_ ((WorkspacesWorkspacesApplet*) self);
	return result;
}

static gboolean
__lambda25_ (WorkspacesWorkspacesApplet* self,
             GdkEventScroll* e)
{
	gboolean down = FALSE;
	gboolean up = FALSE;
	gboolean _tmp0_ = FALSE;
	XfwWorkspace* current = NULL;
	XfwWorkspaceGroup* _tmp1_;
	XfwWorkspace* _tmp2_;
	XfwDirection _tmp3_ = 0;
	XfwWorkspace* next = NULL;
	XfwWorkspace* _tmp4_;
	XfwWorkspace* _tmp5_;
	XfwWorkspace* _tmp6_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->direction >= 4) {
		result = GDK_EVENT_STOP;
		return result;
	}
	down = e->direction == GDK_SCROLL_DOWN;
	up = e->direction == GDK_SCROLL_UP;
	if (!down) {
		_tmp0_ = !up;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = GDK_EVENT_STOP;
		return result;
	}
	if ((g_get_monotonic_time () - self->priv->last_scroll_time) < ((gint64) 300000)) {
		result = GDK_EVENT_STOP;
		return result;
	}
	_tmp1_ = workspaces_workspaces_applet_workspace_group;
	_tmp2_ = xfw_workspace_group_get_active_workspace (_tmp1_);
	current = _tmp2_;
	if (down) {
		_tmp3_ = XFW_DIRECTION_RIGHT;
	} else {
		_tmp3_ = XFW_DIRECTION_DOWN;
	}
	_tmp4_ = current;
	_tmp5_ = xfw_workspace_get_neighbor (_tmp4_, _tmp3_);
	next = _tmp5_;
	_tmp6_ = next;
	if (_tmp6_ != NULL) {
		{
			XfwWorkspace* _tmp7_;
			_tmp7_ = next;
			xfw_workspace_activate (_tmp7_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_warning ("WorkspacesApplet.vala:217: Failed to switch to workspace: %s", _tmp9_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp10_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp10_;
		}
		self->priv->last_scroll_time = g_get_monotonic_time ();
	}
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
___lambda25__gtk_widget_scroll_event (GtkWidget* _sender,
                                      GdkEventScroll* event,
                                      gpointer self)
{
	gboolean result;
	result = __lambda25_ ((WorkspacesWorkspacesApplet*) self, event);
	return result;
}

WorkspacesWorkspacesApplet*
workspaces_workspaces_applet_construct (GType object_type,
                                        const gchar* uuid)
{
	WorkspacesWorkspacesApplet * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	XfwScreen* _tmp2_;
	XfwScreen* _tmp3_;
	XfwWorkspaceManager* _tmp4_;
	XfwWorkspaceManager* _tmp5_;
	XfwWorkspaceManager* _tmp6_;
	GList* _tmp7_;
	gconstpointer _tmp8_;
	XfwWorkspaceGroup* _tmp9_;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	GHashTable* _tmp12_;
	GtkEventBox* _tmp13_;
	GtkEventBox* _tmp14_;
	GtkEventBox* _tmp15_;
	GtkBox* _tmp16_;
	GtkBox* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkBox* _tmp19_;
	GtkEventBox* _tmp20_;
	GtkBox* _tmp21_;
	GtkBox* _tmp22_;
	GtkBox* _tmp23_;
	GtkStyleContext* _tmp24_;
	GtkBox* _tmp25_;
	GtkBox* _tmp26_;
	GtkRevealer* _tmp27_;
	GtkRevealer* _tmp28_;
	GtkRevealer* _tmp29_;
	GtkRevealer* _tmp30_;
	GtkButton* add_button = NULL;
	GtkButton* _tmp31_;
	GtkStyleContext* _tmp32_;
	GtkRevealer* _tmp33_;
	GtkBox* _tmp34_;
	GtkRevealer* _tmp35_;
	GtkEventBox* _tmp36_;
	GtkEventBox* _tmp37_;
	GtkEventBox* _tmp38_;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (WorkspacesWorkspacesApplet*) g_object_new (object_type, "uuid", uuid, NULL);
	budgie_applet_set_settings_schema ((BudgieApplet*) self, "com.solus-project.workspaces");
	budgie_applet_set_settings_prefix ((BudgieApplet*) self, "/com/solus-project/budgie-panel/instance/workspaces");
	_tmp0_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, uuid);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	g_signal_connect_object (_tmp1_, "changed", (GCallback) _workspaces_workspaces_applet_on_settings_change_g_settings_changed, self, 0);
	_tmp2_ = xfw_screen_get_default ();
	_g_object_unref0 (workspaces_workspaces_applet_xfce_screen);
	workspaces_workspaces_applet_xfce_screen = _tmp2_;
	_tmp3_ = workspaces_workspaces_applet_xfce_screen;
	_tmp4_ = xfw_screen_get_workspace_manager (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (workspaces_workspaces_applet_workspace_manager);
	workspaces_workspaces_applet_workspace_manager = _tmp5_;
	_tmp6_ = workspaces_workspaces_applet_workspace_manager;
	_tmp7_ = xfw_workspace_manager_list_workspace_groups (_tmp6_);
	_tmp8_ = g_list_nth_data (_tmp7_, (guint) 0);
	_tmp9_ = _g_object_ref0 ((XfwWorkspaceGroup*) _tmp8_);
	_g_object_unref0 (workspaces_workspaces_applet_workspace_group);
	workspaces_workspaces_applet_workspace_group = _tmp9_;
	(self->priv->dynamically_created_workspaces == NULL) ? NULL : (self->priv->dynamically_created_workspaces = (g_list_free (self->priv->dynamically_created_workspaces), NULL));
	self->priv->dynamically_created_workspaces = NULL;
	_tmp10_ = g_str_hash;
	_tmp11_ = g_str_equal;
	_tmp12_ = g_hash_table_new_full (_tmp10_, _tmp11_, NULL, NULL);
	_g_hash_table_unref0 (self->priv->window_connections);
	self->priv->window_connections = _tmp12_;
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, "org.budgie_desktop.BudgieWM", G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_workspaces_workspaces_applet_has_wm_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _workspaces_workspaces_applet_has_wm_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_workspaces_workspaces_applet_lost_wm_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _workspaces_workspaces_applet_lost_wm_gbus_name_vanished_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
	_tmp13_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->ebox);
	self->priv->ebox = _tmp13_;
	_tmp14_ = self->priv->ebox;
	gtk_widget_add_events ((GtkWidget*) _tmp14_, (gint) GDK_SCROLL_MASK);
	_tmp15_ = self->priv->ebox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp15_);
	_tmp16_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->main_layout);
	self->priv->main_layout = _tmp16_;
	_tmp17_ = self->priv->main_layout;
	_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) _tmp17_);
	gtk_style_context_add_class (_tmp18_, "workspace-switcher");
	_tmp19_ = self->priv->main_layout;
	gtk_box_set_spacing (_tmp19_, 4);
	_tmp20_ = self->priv->ebox;
	_tmp21_ = self->priv->main_layout;
	gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->workspaces_layout);
	self->priv->workspaces_layout = _tmp22_;
	_tmp23_ = self->priv->workspaces_layout;
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) _tmp23_);
	gtk_style_context_add_class (_tmp24_, "workspace-layout");
	_tmp25_ = self->priv->main_layout;
	_tmp26_ = self->priv->workspaces_layout;
	gtk_box_pack_start (_tmp25_, (GtkWidget*) _tmp26_, TRUE, TRUE, (guint) 0);
	_tmp27_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->add_button_revealer);
	self->priv->add_button_revealer = _tmp27_;
	_tmp28_ = self->priv->add_button_revealer;
	gtk_revealer_set_transition_duration (_tmp28_, (guint) 200);
	_tmp29_ = self->priv->add_button_revealer;
	gtk_revealer_set_transition_type (_tmp29_, self->priv->hide_transition);
	_tmp30_ = self->priv->add_button_revealer;
	gtk_revealer_set_reveal_child (_tmp30_, FALSE);
	_tmp31_ = (GtkButton*) gtk_button_new_from_icon_name ("list-add-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp31_);
	add_button = _tmp31_;
	_tmp32_ = gtk_widget_get_style_context ((GtkWidget*) add_button);
	gtk_style_context_add_class (_tmp32_, "workspace-add-button");
	gtk_widget_set_valign ((GtkWidget*) add_button, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) add_button, GTK_ALIGN_CENTER);
	_tmp33_ = self->priv->add_button_revealer;
	gtk_container_add ((GtkContainer*) _tmp33_, (GtkWidget*) add_button);
	_tmp34_ = self->priv->main_layout;
	_tmp35_ = self->priv->add_button_revealer;
	gtk_box_pack_start (_tmp34_, (GtkWidget*) _tmp35_, FALSE, FALSE, (guint) 0);
	workspaces_workspaces_applet_on_settings_change (self, "addbutton-visibility");
	workspaces_workspaces_applet_on_settings_change (self, "item-size-multiplier");
	gtk_drag_dest_set ((GtkWidget*) add_button, GTK_DEST_DEFAULT_MOTION | GTK_DEST_DEFAULT_HIGHLIGHT, WORKSPACES_target_list, (gint) G_N_ELEMENTS (WORKSPACES_target_list), GDK_ACTION_MOVE);
	g_signal_connect_object ((GtkWidget*) add_button, "drag-drop", (GCallback) _workspaces_workspaces_applet_on_add_button_drag_drop_gtk_widget_drag_drop, self, 0);
	g_signal_connect_object ((GtkWidget*) add_button, "drag-data-received", (GCallback) _workspaces_workspaces_applet_on_add_button_drag_data_received_gtk_widget_drag_data_received, self, 0);
	g_signal_connect_object ((GtkWidget*) add_button, "button-release-event", (GCallback) ___lambda19__gtk_widget_button_release_event, self, 0);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda20__gsource_func, g_object_ref (self), g_object_unref);
	workspaces_workspaces_applet_populate_workspaces (self);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp36_ = self->priv->ebox;
	g_signal_connect_object ((GtkWidget*) _tmp36_, "enter-notify-event", (GCallback) ___lambda23__gtk_widget_enter_notify_event, self, 0);
	_tmp37_ = self->priv->ebox;
	g_signal_connect_object ((GtkWidget*) _tmp37_, "leave-notify-event", (GCallback) ___lambda24__gtk_widget_leave_notify_event, self, 0);
	_tmp38_ = self->priv->ebox;
	g_signal_connect_object ((GtkWidget*) _tmp38_, "scroll-event", (GCallback) ___lambda25__gtk_widget_scroll_event, self, 0);
	_g_object_unref0 (add_button);
	return self;
}

WorkspacesWorkspacesApplet*
workspaces_workspaces_applet_new (const gchar* uuid)
{
	return workspaces_workspaces_applet_construct (WORKSPACES_TYPE_WORKSPACES_APPLET, uuid);
}

static gboolean
____lambda14_ (WorkspacesWorkspacesApplet* self)
{
	gboolean result;
	workspaces_workspaces_applet_update_workspaces (self, NULL, NULL);
	result = FALSE;
	return result;
}

static gboolean
_____lambda14__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda14_ ((WorkspacesWorkspacesApplet*) self);
	return result;
}

static void
workspaces_workspaces_applet_on_settings_change (WorkspacesWorkspacesApplet* self,
                                                 const gchar* key)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "addbutton-visibility") == 0) {
		GSettings* _tmp0_;
		gboolean _tmp1_ = FALSE;
		GtkRevealer* _tmp2_;
		_tmp0_ = self->priv->settings;
		self->priv->button_visibility = (WorkspacesAddButtonVisibility) g_settings_get_enum (_tmp0_, key);
		if (self->priv->button_visibility == WORKSPACES_ADD_BUTTON_VISIBILITY_ALWAYS) {
			_tmp1_ = workspaces_workspaces_applet_below_max_workspace_count (self);
		} else {
			_tmp1_ = FALSE;
		}
		_tmp2_ = self->priv->add_button_revealer;
		gtk_revealer_set_reveal_child (_tmp2_, _tmp1_);
	} else {
		if (g_strcmp0 (key, "item-size-multiplier") == 0) {
			GSettings* _tmp3_;
			GtkBox* _tmp4_;
			GList* _tmp5_;
			_tmp3_ = self->priv->settings;
			self->priv->item_size_multiplier = ((gfloat) g_settings_get_enum (_tmp3_, key)) / 4;
			_tmp4_ = self->priv->workspaces_layout;
			_tmp5_ = gtk_container_get_children ((GtkContainer*) _tmp4_);
			{
				GList* widget_collection = NULL;
				GList* widget_it = NULL;
				widget_collection = _tmp5_;
				for (widget_it = widget_collection; widget_it != NULL; widget_it = widget_it->next) {
					GtkWidget* _tmp6_;
					GtkWidget* widget = NULL;
					_tmp6_ = _g_object_ref0 ((GtkWidget*) widget_it->data);
					widget = _tmp6_;
					{
						GtkRevealer* revealer = NULL;
						GtkWidget* _tmp7_;
						GtkRevealer* _tmp8_;
						WorkspacesWorkspaceItem* item = NULL;
						GtkRevealer* _tmp9_;
						GtkWidget* _tmp10_;
						WorkspacesWorkspaceItem* _tmp11_;
						WorkspacesWorkspaceItem* _tmp12_;
						WorkspacesWorkspaceItem* _tmp13_;
						_tmp7_ = widget;
						_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_revealer_get_type ()) ? ((GtkRevealer*) _tmp7_) : NULL);
						revealer = _tmp8_;
						_tmp9_ = revealer;
						_tmp10_ = gtk_bin_get_child ((GtkBin*) _tmp9_);
						_tmp11_ = _g_object_ref0 (WORKSPACES_IS_WORKSPACE_ITEM (_tmp10_) ? ((WorkspacesWorkspaceItem*) _tmp10_) : NULL);
						item = _tmp11_;
						_tmp12_ = item;
						workspaces_workspace_item_set_size_multiplier (_tmp12_, self->priv->item_size_multiplier);
						_tmp13_ = item;
						gtk_widget_queue_resize ((GtkWidget*) _tmp13_);
						_g_object_unref0 (item);
						_g_object_unref0 (revealer);
						_g_object_unref0 (widget);
					}
				}
				(widget_collection == NULL) ? NULL : (widget_collection = (g_list_free (widget_collection), NULL));
			}
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _____lambda14__gsource_func, g_object_ref (self), g_object_unref);
		}
	}
}

static void
workspaces_workspaces_applet_populate_workspaces (WorkspacesWorkspacesApplet* self)
{
	XfwWorkspaceGroup* _tmp0_;
	GList* _tmp1_;
	XfwScreen* _tmp4_;
	GList* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = workspaces_workspaces_applet_workspace_group;
	_tmp1_ = xfw_workspace_group_list_workspaces (_tmp0_);
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp1_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			XfwWorkspace* _tmp2_;
			XfwWorkspace* workspace = NULL;
			_tmp2_ = _g_object_ref0 ((XfwWorkspace*) workspace_it->data);
			workspace = _tmp2_;
			{
				XfwWorkspace* _tmp3_;
				_tmp3_ = workspace;
				workspaces_workspaces_applet_workspace_added (self, _tmp3_);
				_g_object_unref0 (workspace);
			}
		}
	}
	workspaces_workspaces_applet_connect_signals (self);
	gtk_widget_queue_resize ((GtkWidget*) self);
	_tmp4_ = workspaces_workspaces_applet_xfce_screen;
	_tmp5_ = xfw_screen_get_windows (_tmp4_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp5_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			XfwWindow* _tmp6_;
			XfwWindow* window = NULL;
			_tmp6_ = _g_object_ref0 ((XfwWindow*) window_it->data);
			window = _tmp6_;
			{
				XfwWindow* _tmp7_;
				_tmp7_ = window;
				workspaces_workspaces_applet_window_opened (self, _tmp7_);
				_g_object_unref0 (window);
			}
		}
	}
}

static void
workspaces_workspaces_applet_lost_wm (WorkspacesWorkspacesApplet* self)
{
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->wm_proxy);
	self->priv->wm_proxy = NULL;
}

static void
workspaces_workspaces_applet_on_wm_get (WorkspacesWorkspacesApplet* self,
                                        GObject* o,
                                        GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		WorkspacesBudgieWM* _tmp0_ = NULL;
		WorkspacesBudgieWM* _tmp1_;
		WorkspacesBudgieWM* _tmp2_;
		WorkspacesBudgieWM* _tmp3_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (WorkspacesBudgieWM*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (WorkspacesBudgieWM*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->wm_proxy);
		self->priv->wm_proxy = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("WorkspacesApplet.vala:264: Failed to get BudgieWM proxy: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_workspaces_workspaces_applet_on_wm_get_gasync_ready_callback (GObject* source_object,
                                                               GAsyncResult* res,
                                                               gpointer self)
{
	workspaces_workspaces_applet_on_wm_get ((WorkspacesWorkspacesApplet*) self, source_object, res);
	g_object_unref (self);
}

static void
workspaces_workspaces_applet_has_wm (WorkspacesWorkspacesApplet* self)
{
	WorkspacesBudgieWM* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wm_proxy;
	if (_tmp0_ == NULL) {
		g_async_initable_new_async (WORKSPACES_TYPE_BUDGIE_WM_PROXY, 0, NULL, _workspaces_workspaces_applet_on_wm_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", "org.budgie_desktop.BudgieWM", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/budgie_desktop/BudgieWM", "g-interface-name", "org.budgie_desktop.BudgieWM", NULL);
	}
}

static gboolean
workspaces_workspaces_applet_below_max_workspace_count (WorkspacesWorkspacesApplet* self)
{
	XfwWorkspaceGroup* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = workspaces_workspaces_applet_workspace_group;
	result = xfw_workspace_group_get_workspace_count (_tmp0_) < ((guint) 8);
	return result;
}

static void
_workspaces_workspaces_applet_workspace_added_libxfce4windowing_workspace_group_workspace_added (XfwWorkspaceGroup* _sender,
                                                                                                 XfwWorkspace* workspace,
                                                                                                 gpointer self)
{
	workspaces_workspaces_applet_workspace_added ((WorkspacesWorkspacesApplet*) self, workspace);
}

static void
_vala_array_add1 (gulong* * array,
                  gint* length,
                  gint* size,
                  gulong value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gulong, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_workspaces_workspaces_applet_workspace_removed_libxfce4windowing_workspace_group_workspace_removed (XfwWorkspaceGroup* _sender,
                                                                                                     XfwWorkspace* workspace,
                                                                                                     gpointer self)
{
	workspaces_workspaces_applet_workspace_removed ((WorkspacesWorkspacesApplet*) self, workspace);
}

static void
_vala_array_add2 (gulong* * array,
                  gint* length,
                  gint* size,
                  gulong value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gulong, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_workspaces_workspaces_applet_set_current_workspace_libxfce4windowing_workspace_group_active_workspace_changed (XfwWorkspaceGroup* _sender,
                                                                                                                XfwWorkspace* previously_active_workspace,
                                                                                                                gpointer self)
{
	workspaces_workspaces_applet_set_current_workspace ((WorkspacesWorkspacesApplet*) self);
}

static void
_vala_array_add3 (gulong* * array,
                  gint* length,
                  gint* size,
                  gulong value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gulong, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_workspaces_workspaces_applet_update_workspaces_libxfce4windowing_screen_active_window_changed (XfwScreen* _sender,
                                                                                                XfwWindow* window,
                                                                                                gpointer self)
{
	workspaces_workspaces_applet_update_workspaces ((WorkspacesWorkspacesApplet*) self, NULL, NULL);
}

static void
_vala_array_add4 (gulong* * array,
                  gint* length,
                  gint* size,
                  gulong value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gulong, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_workspaces_workspaces_applet_window_opened_libxfce4windowing_screen_window_opened (XfwScreen* _sender,
                                                                                    XfwWindow* window,
                                                                                    gpointer self)
{
	workspaces_workspaces_applet_window_opened ((WorkspacesWorkspacesApplet*) self, window);
}

static void
_vala_array_add5 (gulong* * array,
                  gint* length,
                  gint* size,
                  gulong value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gulong, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_workspaces_workspaces_applet_window_closed_libxfce4windowing_screen_window_closed (XfwScreen* _sender,
                                                                                    XfwWindow* window,
                                                                                    gpointer self)
{
	workspaces_workspaces_applet_window_closed ((WorkspacesWorkspacesApplet*) self, window);
}

static void
_vala_array_add6 (gulong* * array,
                  gint* length,
                  gint* size,
                  gulong value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gulong, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
workspaces_workspaces_applet_connect_signals (WorkspacesWorkspacesApplet* self)
{
	XfwWorkspaceGroup* _tmp0_;
	gulong _tmp1_;
	XfwWorkspaceGroup* _tmp2_;
	gulong _tmp3_;
	XfwWorkspaceGroup* _tmp4_;
	gulong _tmp5_;
	XfwScreen* _tmp6_;
	gulong _tmp7_;
	XfwScreen* _tmp8_;
	gulong _tmp9_;
	XfwScreen* _tmp10_;
	gulong _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = workspaces_workspaces_applet_workspace_group;
	_tmp1_ = g_signal_connect_object (_tmp0_, "workspace-added", (GCallback) _workspaces_workspaces_applet_workspace_added_libxfce4windowing_workspace_group_workspace_added, self, 0);
	_vala_array_add1 (&self->priv->connections, &self->priv->connections_length1, &self->priv->_connections_size_, _tmp1_);
	_tmp2_ = workspaces_workspaces_applet_workspace_group;
	_tmp3_ = g_signal_connect_object (_tmp2_, "workspace-removed", (GCallback) _workspaces_workspaces_applet_workspace_removed_libxfce4windowing_workspace_group_workspace_removed, self, 0);
	_vala_array_add2 (&self->priv->connections, &self->priv->connections_length1, &self->priv->_connections_size_, _tmp3_);
	_tmp4_ = workspaces_workspaces_applet_workspace_group;
	_tmp5_ = g_signal_connect_object (_tmp4_, "active-workspace-changed", (GCallback) _workspaces_workspaces_applet_set_current_workspace_libxfce4windowing_workspace_group_active_workspace_changed, self, 0);
	_vala_array_add3 (&self->priv->connections, &self->priv->connections_length1, &self->priv->_connections_size_, _tmp5_);
	_tmp6_ = workspaces_workspaces_applet_xfce_screen;
	_tmp7_ = g_signal_connect_object (_tmp6_, "active-window-changed", (GCallback) _workspaces_workspaces_applet_update_workspaces_libxfce4windowing_screen_active_window_changed, self, 0);
	_vala_array_add4 (&self->priv->connections, &self->priv->connections_length1, &self->priv->_connections_size_, _tmp7_);
	_tmp8_ = workspaces_workspaces_applet_xfce_screen;
	_tmp9_ = g_signal_connect_object (_tmp8_, "window-opened", (GCallback) _workspaces_workspaces_applet_window_opened_libxfce4windowing_screen_window_opened, self, 0);
	_vala_array_add5 (&self->priv->connections, &self->priv->connections_length1, &self->priv->_connections_size_, _tmp9_);
	_tmp10_ = workspaces_workspaces_applet_xfce_screen;
	_tmp11_ = g_signal_connect_object (_tmp10_, "window-closed", (GCallback) _workspaces_workspaces_applet_window_closed_libxfce4windowing_screen_window_closed, self, 0);
	_vala_array_add6 (&self->priv->connections, &self->priv->connections_length1, &self->priv->_connections_size_, _tmp11_);
}

static void
__lambda15_ (WorkspacesWorkspacesApplet* self,
             XfwWindow* key,
             gulong val)
{
	GHashTable* _tmp0_;
	g_return_if_fail (key != NULL);
	if (g_signal_handler_is_connected (key, val)) {
		g_signal_handler_disconnect (key, val);
	}
	_tmp0_ = self->priv->window_connections;
	g_hash_table_remove (_tmp0_, key);
}

static void
___lambda15__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda15_ ((WorkspacesWorkspacesApplet*) self, (XfwWindow*) key, (gulong) ((guintptr) value));
}

static void
workspaces_workspaces_applet_disconnect_signals (WorkspacesWorkspacesApplet* self)
{
	gulong* _tmp0_;
	gint _tmp0__length1;
	GHashTable* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->connections;
	_tmp0__length1 = self->priv->connections_length1;
	{
		gulong* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp0_;
		id_collection_length1 = _tmp0__length1;
		for (id_it = 0; id_it < id_collection_length1; id_it = id_it + 1) {
			gulong id = 0UL;
			id = id_collection[id_it];
			{
				XfwWorkspaceGroup* _tmp1_;
				_tmp1_ = workspaces_workspaces_applet_workspace_group;
				if (g_signal_handler_is_connected (_tmp1_, id)) {
					XfwWorkspaceGroup* _tmp2_;
					_tmp2_ = workspaces_workspaces_applet_workspace_group;
					g_signal_handler_disconnect (_tmp2_, id);
				} else {
					XfwScreen* _tmp3_;
					_tmp3_ = workspaces_workspaces_applet_xfce_screen;
					if (g_signal_handler_is_connected (_tmp3_, id)) {
						XfwScreen* _tmp4_;
						_tmp4_ = workspaces_workspaces_applet_xfce_screen;
						g_signal_handler_disconnect (_tmp4_, id);
					}
				}
			}
		}
	}
	_tmp5_ = self->priv->window_connections;
	g_hash_table_foreach (_tmp5_, ___lambda15__gh_func, self);
}

static void
_workspaces_workspaces_applet_remove_workspace_workspaces_workspace_item_remove_workspace (WorkspacesWorkspaceItem* _sender,
                                                                                           guint index,
                                                                                           guint32 time,
                                                                                           gpointer self)
{
	workspaces_workspaces_applet_remove_workspace ((WorkspacesWorkspacesApplet*) self, index, time);
}

static void
workspaces_workspaces_applet_workspace_added (WorkspacesWorkspacesApplet* self,
                                              XfwWorkspace* space)
{
	WorkspacesWorkspaceItem* item = NULL;
	WorkspacesWorkspaceItem* _tmp0_;
	XfwWorkspace* _workspace = NULL;
	XfwWorkspaceGroup* _tmp1_;
	XfwWorkspace* _tmp2_;
	XfwWorkspace* _tmp3_;
	gboolean _tmp4_ = FALSE;
	XfwWorkspace* _tmp5_;
	WorkspacesWorkspaceItem* _tmp9_;
	GtkRevealer* revealer = NULL;
	GtkRevealer* _tmp10_;
	GtkRevealer* _tmp11_;
	WorkspacesWorkspaceItem* _tmp12_;
	GtkRevealer* _tmp13_;
	GtkRevealer* _tmp14_;
	GtkRevealer* _tmp15_;
	GtkRevealer* _tmp16_;
	GtkRevealer* _tmp17_;
	GtkBox* _tmp18_;
	GtkRevealer* _tmp19_;
	GtkRevealer* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (space != NULL);
	_tmp0_ = workspaces_workspace_item_new (space, self->priv->item_size_multiplier);
	g_object_ref_sink (_tmp0_);
	item = _tmp0_;
	_tmp1_ = workspaces_workspaces_applet_workspace_group;
	_tmp2_ = xfw_workspace_group_get_active_workspace (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_workspace = _tmp3_;
	_tmp5_ = _workspace;
	if (_tmp5_ != NULL) {
		XfwWorkspace* _tmp6_;
		_tmp6_ = _workspace;
		_tmp4_ = _tmp6_ == space;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		WorkspacesWorkspaceItem* _tmp7_;
		GtkStyleContext* _tmp8_;
		_tmp7_ = item;
		_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
		gtk_style_context_add_class (_tmp8_, "current-workspace");
	}
	_tmp9_ = item;
	g_signal_connect_object (_tmp9_, "remove-workspace", (GCallback) _workspaces_workspaces_applet_remove_workspace_workspaces_workspace_item_remove_workspace, self, 0);
	_tmp10_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp10_);
	revealer = _tmp10_;
	_tmp11_ = revealer;
	_tmp12_ = item;
	gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = revealer;
	gtk_revealer_set_transition_type (_tmp13_, self->priv->show_transition);
	_tmp14_ = revealer;
	gtk_revealer_set_transition_duration (_tmp14_, (guint) 200);
	_tmp15_ = revealer;
	gtk_widget_set_valign ((GtkWidget*) _tmp15_, GTK_ALIGN_CENTER);
	_tmp16_ = revealer;
	gtk_widget_set_halign ((GtkWidget*) _tmp16_, GTK_ALIGN_CENTER);
	_tmp17_ = revealer;
	gtk_widget_show_all ((GtkWidget*) _tmp17_);
	_tmp18_ = self->priv->workspaces_layout;
	_tmp19_ = revealer;
	gtk_box_pack_start (_tmp18_, (GtkWidget*) _tmp19_, TRUE, TRUE, (guint) 0);
	_tmp20_ = revealer;
	gtk_revealer_set_reveal_child (_tmp20_, TRUE);
	if (!workspaces_workspaces_applet_below_max_workspace_count (self)) {
		GtkRevealer* _tmp21_;
		_tmp21_ = self->priv->add_button_revealer;
		gtk_revealer_set_reveal_child (_tmp21_, FALSE);
	}
	_g_object_unref0 (revealer);
	_g_object_unref0 (_workspace);
	_g_object_unref0 (item);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		WorkspacesWorkspacesApplet* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
_____lambda22_ (Block1Data* _data1_)
{
	WorkspacesWorkspacesApplet* self;
	GtkWidget* _tmp0_;
	gboolean result;
	self = _data1_->self;
	_tmp0_ = _data1_->widget;
	gtk_widget_destroy (_tmp0_);
	result = FALSE;
	return result;
}

static gboolean
______lambda22__gsource_func (gpointer self)
{
	gboolean result;
	result = _____lambda22_ (self);
	return result;
}

static void
workspaces_workspaces_applet_workspace_removed (WorkspacesWorkspacesApplet* self,
                                                XfwWorkspace* space)
{
	GtkBox* _tmp0_;
	GList* _tmp1_;
	GtkRevealer* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (space != NULL);
	_tmp0_ = self->priv->workspaces_layout;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* widget_collection = NULL;
		GList* widget_it = NULL;
		widget_collection = _tmp1_;
		for (widget_it = widget_collection; widget_it != NULL; widget_it = widget_it->next) {
			GtkWidget* widget = NULL;
			widget = (GtkWidget*) widget_it->data;
			{
				Block1Data* _data1_;
				GtkRevealer* revealer = NULL;
				GtkWidget* _tmp2_;
				GtkRevealer* _tmp3_;
				WorkspacesWorkspaceItem* item = NULL;
				GtkRevealer* _tmp4_;
				GtkWidget* _tmp5_;
				WorkspacesWorkspaceItem* _tmp6_;
				WorkspacesWorkspaceItem* _tmp7_;
				XfwWorkspace* _tmp8_;
				XfwWorkspace* _tmp9_;
				gboolean _tmp10_;
				_data1_ = g_slice_new0 (Block1Data);
				_data1_->_ref_count_ = 1;
				_data1_->self = g_object_ref (self);
				_data1_->widget = widget;
				_tmp2_ = _data1_->widget;
				_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_revealer_get_type ()) ? ((GtkRevealer*) _tmp2_) : NULL);
				revealer = _tmp3_;
				_tmp4_ = revealer;
				_tmp5_ = gtk_bin_get_child ((GtkBin*) _tmp4_);
				_tmp6_ = _g_object_ref0 (WORKSPACES_IS_WORKSPACE_ITEM (_tmp5_) ? ((WorkspacesWorkspaceItem*) _tmp5_) : NULL);
				item = _tmp6_;
				_tmp7_ = item;
				_tmp8_ = workspaces_workspace_item_get_workspace (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_ == space;
				_g_object_unref0 (_tmp9_);
				if (_tmp10_) {
					GtkRevealer* _tmp11_;
					GtkRevealer* _tmp12_;
					_tmp11_ = revealer;
					gtk_revealer_set_transition_type (_tmp11_, self->priv->hide_transition);
					_tmp12_ = revealer;
					gtk_revealer_set_reveal_child (_tmp12_, FALSE);
					g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, ______lambda22__gsource_func, block1_data_ref (_data1_), block1_data_unref);
					_g_object_unref0 (item);
					_g_object_unref0 (revealer);
					block1_data_unref (_data1_);
					_data1_ = NULL;
					break;
				}
				_g_object_unref0 (item);
				_g_object_unref0 (revealer);
				block1_data_unref (_data1_);
				_data1_ = NULL;
			}
		}
		(widget_collection == NULL) ? NULL : (widget_collection = (g_list_free (widget_collection), NULL));
	}
	_tmp13_ = self->priv->add_button_revealer;
	gtk_revealer_set_reveal_child (_tmp13_, TRUE);
}

static void
_workspaces_workspaces_applet_update_workspaces_libxfce4windowing_window_workspace_changed (XfwWindow* _sender,
                                                                                            gpointer self)
{
	workspaces_workspaces_applet_update_workspaces ((WorkspacesWorkspacesApplet*) self, NULL, NULL);
}

static void
workspaces_workspaces_applet_window_opened (WorkspacesWorkspacesApplet* self,
                                            XfwWindow* window)
{
	GHashTable* _tmp0_;
	gulong conn = 0UL;
	gulong _tmp4_;
	GHashTable* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	if (xfw_window_get_window_type (window) != XFW_WINDOW_TYPE_NORMAL) {
		return;
	}
	_tmp0_ = self->priv->window_connections;
	if (g_hash_table_contains (_tmp0_, window)) {
		gulong conn = 0UL;
		GHashTable* _tmp1_;
		gconstpointer _tmp2_;
		GHashTable* _tmp3_;
		_tmp1_ = self->priv->window_connections;
		_tmp2_ = g_hash_table_lookup (_tmp1_, window);
		conn = (gulong) ((guintptr) _tmp2_);
		if (g_signal_handler_is_connected (window, conn)) {
			g_signal_handler_disconnect (window, conn);
		}
		_tmp3_ = self->priv->window_connections;
		g_hash_table_remove (_tmp3_, window);
	}
	_tmp4_ = g_signal_connect_object (window, "workspace-changed", (GCallback) _workspaces_workspaces_applet_update_workspaces_libxfce4windowing_window_workspace_changed, self, 0);
	conn = _tmp4_;
	_tmp5_ = self->priv->window_connections;
	g_hash_table_insert (_tmp5_, window, (gpointer) ((guintptr) conn));
}

static void
workspaces_workspaces_applet_window_closed (WorkspacesWorkspacesApplet* self,
                                            XfwWindow* window)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->window_connections;
	if (g_hash_table_contains (_tmp0_, window)) {
		gulong conn = 0UL;
		GHashTable* _tmp1_;
		gconstpointer _tmp2_;
		GHashTable* _tmp3_;
		_tmp1_ = self->priv->window_connections;
		_tmp2_ = g_hash_table_lookup (_tmp1_, window);
		conn = (gulong) ((guintptr) _tmp2_);
		if (g_signal_handler_is_connected (window, conn)) {
			g_signal_handler_disconnect (window, conn);
		}
		_tmp3_ = self->priv->window_connections;
		g_hash_table_remove (_tmp3_, window);
	}
	workspaces_workspaces_applet_update_workspaces (self, NULL, NULL);
}

static gboolean
workspaces_workspaces_applet_on_add_button_drag_drop (WorkspacesWorkspacesApplet* self,
                                                      GtkWidget* widget,
                                                      GdkDragContext* context,
                                                      gint x,
                                                      gint y,
                                                      guint time)
{
	gboolean is_valid_drop_site = FALSE;
	GList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	is_valid_drop_site = TRUE;
	_tmp0_ = gdk_drag_context_list_targets (context);
	if (_tmp0_ != NULL) {
		GdkAtom target_type = (GdkAtom) 0U;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp1_ = gdk_drag_context_list_targets (context);
		_tmp2_ = g_list_nth_data (_tmp1_, (guint) 0);
		target_type = (GdkAtom) ((GdkAtom) ((guintptr) _tmp2_));
		gtk_drag_get_data (widget, context, target_type, (guint32) time);
	} else {
		is_valid_drop_site = FALSE;
	}
	result = is_valid_drop_site;
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		WorkspacesWorkspacesApplet* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->window);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		WorkspacesWorkspacesApplet* self;
		self = _data3_->_data2_->self;
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
____lambda18_ (Block3Data* _data3_)
{
	Block2Data* _data2_;
	WorkspacesWorkspacesApplet* self;
	XfwWorkspace* workspace = NULL;
	XfwWorkspace* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	_tmp0_ = workspaces_workspaces_applet_get_workspace_by_index (self, (guint) _data3_->index);
	workspace = _tmp0_;
	{
		XfwWorkspace* _tmp1_;
		_tmp1_ = workspace;
		if (_tmp1_ != NULL) {
			XfwWindow* _tmp2_;
			XfwWorkspace* _tmp3_;
			_tmp2_ = _data2_->window;
			_tmp3_ = workspace;
			xfw_window_move_to_workspace (_tmp2_, _tmp3_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("WorkspacesApplet.vala:427: Failed to move window to workspace: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		_g_object_unref0 (workspace);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	result = FALSE;
	_g_object_unref0 (workspace);
	return result;
}

static gboolean
_____lambda18__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda18_ (self);
	return result;
}

static void
workspaces_workspaces_applet_on_add_button_drag_data_received (WorkspacesWorkspacesApplet* self,
                                                               GtkWidget* widget,
                                                               GdkDragContext* context,
                                                               gint x,
                                                               gint y,
                                                               GtkSelectionData* selection_data,
                                                               guint target_type,
                                                               guint time)
{
	Block2Data* _data2_;
	gboolean _tmp0_ = FALSE;
	gulong* data = NULL;
	guint8* _tmp1_;
	gulong* _tmp2_;
	XfwScreen* _tmp3_;
	GList* _tmp4_;
	XfwWindow* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (selection_data != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	if (selection_data == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = gtk_selection_data_get_length (selection_data) == 0;
	}
	if (_tmp0_) {
		gtk_drag_finish (context, FALSE, TRUE, (guint32) time);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	_tmp1_ = gtk_selection_data_get_data (selection_data);
	data = (gulong*) _tmp1_;
	_tmp2_ = data;
	if (_tmp2_ == NULL) {
		gtk_drag_finish (context, FALSE, TRUE, (guint32) time);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	_data2_->window = NULL;
	_tmp3_ = workspaces_workspaces_applet_xfce_screen;
	_tmp4_ = xfw_screen_get_windows (_tmp3_);
	{
		GList* win_collection = NULL;
		GList* win_it = NULL;
		win_collection = _tmp4_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XfwWindow* _tmp5_;
			XfwWindow* win = NULL;
			_tmp5_ = _g_object_ref0 ((XfwWindow*) win_it->data);
			win = _tmp5_;
			{
				XfwWindow* _tmp6_;
				gulong* _tmp7_;
				_tmp6_ = win;
				_tmp7_ = data;
				if (xfw_window_x11_get_xid (_tmp6_) == ((Window) (*_tmp7_))) {
					XfwWindow* _tmp8_;
					XfwWindow* _tmp9_;
					_tmp8_ = win;
					_tmp9_ = _g_object_ref0 (_tmp8_);
					_g_object_unref0 (_data2_->window);
					_data2_->window = _tmp9_;
					_g_object_unref0 (win);
					break;
				}
				_g_object_unref0 (win);
			}
		}
	}
	_tmp10_ = _data2_->window;
	if (_tmp10_ == NULL) {
		gtk_drag_finish (context, FALSE, TRUE, (guint32) time);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	{
		Block3Data* _data3_;
		WorkspacesBudgieWM* _tmp11_;
		_data3_ = g_slice_new0 (Block3Data);
		_data3_->_ref_count_ = 1;
		_data3_->_data2_ = block2_data_ref (_data2_);
		_tmp11_ = self->priv->wm_proxy;
		_data3_->index = workspaces_budgie_wm_AppendNewWorkspace (_tmp11_, (guint32) time, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block3_data_unref (_data3_);
			_data3_ = NULL;
			goto __catch0_g_error;
		}
		if (_data3_->index != -1) {
			self->priv->dynamically_created_workspaces = g_list_append (self->priv->dynamically_created_workspaces, (gpointer) ((gintptr) _data3_->index));
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 50, _____lambda18__gsource_func, block3_data_ref (_data3_), block3_data_unref);
		}
		block3_data_unref (_data3_);
		_data3_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("WorkspacesApplet.vala:433: Failed to append new workspace: %s", _tmp13_);
		gtk_drag_finish (context, FALSE, TRUE, (guint32) time);
		_g_error_free0 (e);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	gtk_drag_finish (context, TRUE, TRUE, (guint32) time);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
workspaces_workspaces_applet_real_panel_size_changed (BudgieApplet* base,
                                                      gint panel_size,
                                                      gint icon_size,
                                                      gint small_icon_size)
{
	WorkspacesWorkspacesApplet * self;
	gint _tmp0_;
	self = (WorkspacesWorkspacesApplet*) base;
	workspaces_workspaces_applet_panel_size = panel_size;
	if (self->priv->startup) {
		return;
	}
	_tmp0_ = self->priv->size_change;
	self->priv->size_change = _tmp0_ + 1;
	if (self->priv->size_change == 2) {
		workspaces_workspaces_applet_update_workspaces (self, NULL, NULL);
		self->priv->size_change = 0;
	}
}

static gboolean
___lambda26_ (WorkspacesWorkspacesApplet* self)
{
	gboolean result;
	workspaces_workspaces_applet_update_workspaces (self, NULL, NULL);
	result = FALSE;
	return result;
}

static gboolean
____lambda26__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda26_ ((WorkspacesWorkspacesApplet*) self);
	return result;
}

static void
workspaces_workspaces_applet_real_panel_position_changed (BudgieApplet* base,
                                                          BudgiePanelPosition position)
{
	WorkspacesWorkspacesApplet * self;
	GtkOrientation orient = 0;
	gboolean _tmp0_ = FALSE;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	self = (WorkspacesWorkspacesApplet*) base;
	workspaces_workspaces_applet_panel_position = position;
	orient = GTK_ORIENTATION_HORIZONTAL;
	if (position == BUDGIE_PANEL_POSITION_LEFT) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = position == BUDGIE_PANEL_POSITION_RIGHT;
	}
	if (_tmp0_) {
		orient = GTK_ORIENTATION_VERTICAL;
	}
	_tmp1_ = self->priv->main_layout;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp1_, orient);
	_tmp2_ = self->priv->workspaces_layout;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp2_, orient);
	if (workspaces_workspaces_applet_get_orientation () == GTK_ORIENTATION_HORIZONTAL) {
		self->priv->show_transition = GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT;
		self->priv->hide_transition = GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT;
	} else {
		self->priv->show_transition = GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN;
		self->priv->hide_transition = GTK_REVEALER_TRANSITION_TYPE_SLIDE_UP;
	}
	if (!self->priv->startup) {
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ____lambda26__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
workspaces_workspaces_applet_remove_workspace (WorkspacesWorkspacesApplet* self,
                                               guint index,
                                               guint32 time)
{
	WorkspacesBudgieWM* _tmp0_;
	XfwWorkspace* workspace = NULL;
	XfwWorkspace* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wm_proxy;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = workspaces_workspaces_applet_get_workspace_by_index (self, (guint) index);
	workspace = _tmp1_;
	{
		WorkspacesBudgieWM* _tmp2_;
		XfwWorkspace* _workspace = NULL;
		XfwWorkspaceGroup* _tmp3_;
		XfwWorkspace* _tmp4_;
		XfwWorkspace* _tmp5_;
		gboolean _tmp6_ = FALSE;
		XfwWorkspace* _tmp7_;
		_tmp2_ = self->priv->wm_proxy;
		workspaces_budgie_wm_RemoveWorkspaceByIndex (_tmp2_, (gint) index, time, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = workspaces_workspaces_applet_workspace_group;
		_tmp4_ = xfw_workspace_group_get_active_workspace (_tmp3_);
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_workspace = _tmp5_;
		_tmp7_ = _workspace;
		if (_tmp7_ != NULL) {
			XfwWorkspace* _tmp8_;
			XfwWorkspace* _tmp9_;
			_tmp8_ = _workspace;
			_tmp9_ = workspace;
			_tmp6_ = _tmp8_ == _tmp9_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			guint _tmp10_ = 0U;
			XfwWorkspace* previous = NULL;
			XfwWorkspace* _tmp11_;
			XfwWorkspace* _tmp12_;
			if (index == ((guint) 0)) {
				_tmp10_ = index;
			} else {
				_tmp10_ = index - 1;
			}
			_tmp11_ = workspaces_workspaces_applet_get_workspace_by_index (self, _tmp10_);
			previous = _tmp11_;
			_tmp12_ = previous;
			if (_tmp12_ != NULL) {
				XfwWorkspace* _tmp13_;
				_tmp13_ = previous;
				xfw_workspace_activate (_tmp13_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (previous);
					_g_object_unref0 (_workspace);
					goto __catch0_g_error;
				}
			}
			_g_object_unref0 (previous);
		}
		_g_object_unref0 (_workspace);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("WorkspacesApplet.vala:498: Failed to remove workspace at index %lu: %s", (gulong) index, _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (workspace);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (workspace);
}

static void
workspaces_workspaces_applet_set_current_workspace (WorkspacesWorkspacesApplet* self)
{
	GtkBox* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->workspaces_layout;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* widget_collection = NULL;
		GList* widget_it = NULL;
		widget_collection = _tmp1_;
		for (widget_it = widget_collection; widget_it != NULL; widget_it = widget_it->next) {
			GtkWidget* _tmp2_;
			GtkWidget* widget = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWidget*) widget_it->data);
			widget = _tmp2_;
			{
				GtkRevealer* revealer = NULL;
				GtkWidget* _tmp3_;
				GtkRevealer* _tmp4_;
				WorkspacesWorkspaceItem* item = NULL;
				GtkRevealer* _tmp5_;
				GtkWidget* _tmp6_;
				WorkspacesWorkspaceItem* _tmp7_;
				WorkspacesWorkspaceItem* _tmp8_;
				GtkStyleContext* _tmp9_;
				WorkspacesWorkspaceItem* _tmp10_;
				XfwWorkspace* _tmp11_;
				XfwWorkspace* _tmp12_;
				XfwWorkspaceGroup* _tmp13_;
				XfwWorkspace* _tmp14_;
				gboolean _tmp15_;
				_tmp3_ = widget;
				_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_revealer_get_type ()) ? ((GtkRevealer*) _tmp3_) : NULL);
				revealer = _tmp4_;
				_tmp5_ = revealer;
				_tmp6_ = gtk_bin_get_child ((GtkBin*) _tmp5_);
				_tmp7_ = _g_object_ref0 (WORKSPACES_IS_WORKSPACE_ITEM (_tmp6_) ? ((WorkspacesWorkspaceItem*) _tmp6_) : NULL);
				item = _tmp7_;
				_tmp8_ = item;
				_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
				gtk_style_context_remove_class (_tmp9_, "current-workspace");
				_tmp10_ = item;
				_tmp11_ = workspaces_workspace_item_get_workspace (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = workspaces_workspaces_applet_workspace_group;
				_tmp14_ = xfw_workspace_group_get_active_workspace (_tmp13_);
				_tmp15_ = _tmp12_ == _tmp14_;
				_g_object_unref0 (_tmp12_);
				if (_tmp15_) {
					WorkspacesWorkspaceItem* _tmp16_;
					GtkStyleContext* _tmp17_;
					_tmp16_ = item;
					_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) _tmp16_);
					gtk_style_context_add_class (_tmp17_, "current-workspace");
				}
				_g_object_unref0 (item);
				_g_object_unref0 (revealer);
				_g_object_unref0 (widget);
			}
		}
		(widget_collection == NULL) ? NULL : (widget_collection = (g_list_free (widget_collection), NULL));
	}
}

static void
workspaces_workspaces_applet_update_workspaces_data_free (gpointer _data)
{
	WorkspacesWorkspacesAppletUpdateWorkspacesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (WorkspacesWorkspacesAppletUpdateWorkspacesData, _data_);
}

static void
workspaces_workspaces_applet_update_workspaces (WorkspacesWorkspacesApplet* self,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	WorkspacesWorkspacesAppletUpdateWorkspacesData* _data_;
	WorkspacesWorkspacesApplet* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (WorkspacesWorkspacesAppletUpdateWorkspacesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, workspaces_workspaces_applet_update_workspaces_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	workspaces_workspaces_applet_update_workspaces_co (_data_);
}

static void
workspaces_workspaces_applet_update_workspaces_finish (WorkspacesWorkspacesApplet* self,
                                                       GAsyncResult* _res_)
{
	WorkspacesWorkspacesAppletUpdateWorkspacesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		WorkspacesWorkspacesApplet* self;
		self = _data4_->self;
		(_data4_->window_list == NULL) ? NULL : (_data4_->window_list = (g_list_free (_data4_->window_list), NULL));
		_g_object_unref0 (_data4_->item);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
____lambda16_ (Block4Data* _data4_,
               XfwWindow* window)
{
	WorkspacesWorkspacesApplet* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	XfwWorkspace* _tmp3_;
	WorkspacesWorkspaceItem* _tmp4_;
	XfwWorkspace* _tmp5_;
	XfwWorkspace* _tmp6_;
	gboolean _tmp7_;
	self = _data4_->self;
	g_return_if_fail (window != NULL);
	_tmp3_ = xfw_window_get_workspace (window);
	_tmp4_ = _data4_->item;
	_tmp5_ = workspaces_workspace_item_get_workspace (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp3_ == _tmp6_;
	_g_object_unref0 (_tmp6_);
	if (_tmp7_) {
		_tmp2_ = !xfw_window_is_skip_tasklist (window);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = !xfw_window_is_skip_pager (window);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = xfw_window_get_window_type (window) == XFW_WINDOW_TYPE_NORMAL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_data4_->window_list = g_list_append (_data4_->window_list, window);
	}
}

static void
_____lambda16__gfunc (gconstpointer data,
                      gpointer self)
{
	____lambda16_ (self, (XfwWindow*) data);
}

static inline gboolean
vala_g_list_is_empty (GList* self)
{
	gboolean result;
	result = ((GList*) self) == NULL;
	return result;
}

static gboolean
______lambda17_ (Block4Data* _data4_)
{
	WorkspacesWorkspacesApplet* self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = _data4_->self;
	{
		WorkspacesBudgieWM* _tmp0_;
		_tmp0_ = self->priv->wm_proxy;
		workspaces_budgie_wm_RemoveWorkspaceByIndex (_tmp0_, _data4_->index, (guint32) GDK_CURRENT_TIME, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("WorkspacesApplet.vala:546: Failed to remove workspace at index %i: %s", _data4_->index, _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	result = FALSE;
	return result;
}

static gboolean
_______lambda17__gsource_func (gpointer self)
{
	gboolean result;
	result = ______lambda17_ (self);
	return result;
}

static gboolean
workspaces_workspaces_applet_update_workspaces_co (WorkspacesWorkspacesAppletUpdateWorkspacesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->self->priv->updating) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp0_ = _data_->self->priv->startup;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->updating = TRUE;
	_data_->_tmp1_ = gtk_widget_get_parent ((GtkWidget*) _data_->self);
	if (_data_->_tmp1_ == NULL) {
		workspaces_workspaces_applet_disconnect_signals (_data_->self);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->workspaces_layout;
	_data_->_tmp3_ = gtk_container_get_children ((GtkContainer*) _data_->_tmp2_);
	{
		_data_->widget_collection = _data_->_tmp3_;
		for (_data_->widget_it = _data_->widget_collection; _data_->widget_it != NULL; _data_->widget_it = _data_->widget_it->next) {
			_data_->_tmp4_ = _g_object_ref0 ((GtkWidget*) _data_->widget_it->data);
			_data_->widget = _data_->_tmp4_;
			{
				_data_->_data4_ = g_slice_new0 (Block4Data);
				_data_->_data4_->_ref_count_ = 1;
				_data_->_data4_->self = g_object_ref (_data_->self);
				_data_->_tmp5_ = _data_->widget;
				_data_->_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp5_, gtk_revealer_get_type ()) ? ((GtkRevealer*) _data_->_tmp5_) : NULL);
				_data_->revealer = _data_->_tmp6_;
				_data_->_tmp7_ = _data_->revealer;
				_data_->_tmp8_ = gtk_bin_get_child ((GtkBin*) _data_->_tmp7_);
				_data_->_tmp9_ = _g_object_ref0 (WORKSPACES_IS_WORKSPACE_ITEM (_data_->_tmp8_) ? ((WorkspacesWorkspaceItem*) _data_->_tmp8_) : NULL);
				_data_->_data4_->item = _data_->_tmp9_;
				_data_->_tmp10_ = workspaces_workspaces_applet_xfce_screen;
				_data_->_tmp11_ = xfw_screen_get_windows_stacked (_data_->_tmp10_);
				_data_->_tmp12_ = g_list_copy (_data_->_tmp11_);
				_data_->windows = _data_->_tmp12_;
				_data_->windows = g_list_reverse (_data_->windows);
				_data_->_data4_->window_list = NULL;
				_data_->_tmp13_ = _data_->windows;
				g_list_foreach (_data_->_tmp13_, _____lambda16__gfunc, _data_->_data4_);
				_data_->_tmp14_ = _data_->_data4_->item;
				_data_->_tmp15_ = workspaces_workspace_item_get_workspace (_data_->_tmp14_);
				_data_->_tmp16_ = _data_->_tmp15_;
				_data_->_tmp17_ = (gint) xfw_workspace_get_number (_data_->_tmp16_);
				_g_object_unref0 (_data_->_tmp16_);
				_data_->_data4_->index = _data_->_tmp17_;
				_data_->_tmp18_ = _data_->self->priv->dynamically_created_workspaces;
				_data_->_tmp19_ = g_list_find (_data_->_tmp18_, (gpointer) ((gintptr) _data_->_data4_->index));
				_data_->dyn = _data_->_tmp19_;
				_data_->_tmp21_ = _data_->_data4_->window_list;
				if (vala_g_list_is_empty (_data_->_tmp21_)) {
					_data_->_tmp22_ = _data_->dyn;
					_data_->_tmp20_ = _data_->_tmp22_ != NULL;
				} else {
					_data_->_tmp20_ = FALSE;
				}
				if (_data_->_tmp20_) {
					_data_->self->priv->dynamically_created_workspaces = g_list_remove (_data_->self->priv->dynamically_created_workspaces, (gpointer) ((gintptr) _data_->_data4_->index));
					_data_->_tmp23_ = _data_->self->priv->dynamically_created_workspaces;
					_data_->_tmp24_ = g_list_find (_data_->_tmp23_, (gpointer) ((gintptr) (_data_->_data4_->index + 1)));
					_data_->dyn = _data_->_tmp24_;
					_data_->_tmp25_ = _data_->dyn;
					if (_data_->_tmp25_ == NULL) {
						g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _______lambda17__gsource_func, block4_data_ref (_data_->_data4_), block4_data_unref);
					}
				}
				_data_->_tmp26_ = _data_->_data4_->item;
				_data_->_tmp27_ = _data_->_data4_->window_list;
				workspaces_workspace_item_update_windows (_data_->_tmp26_, _data_->_tmp27_);
				(_data_->windows == NULL) ? NULL : (_data_->windows = (g_list_free (_data_->windows), NULL));
				_g_object_unref0 (_data_->revealer);
				_g_object_unref0 (_data_->widget);
				block4_data_unref (_data_->_data4_);
				_data_->_data4_ = NULL;
			}
		}
		(_data_->widget_collection == NULL) ? NULL : (_data_->widget_collection = (g_list_free (_data_->widget_collection), NULL));
	}
	_data_->self->priv->updating = FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
workspaces_workspaces_applet_real_update_popovers (BudgieApplet* base,
                                                   BudgiePopoverManager* manager)
{
	WorkspacesWorkspacesApplet * self;
	self = (WorkspacesWorkspacesApplet*) base;
	workspaces_workspaces_applet_manager = manager;
}

GtkOrientation
workspaces_workspaces_applet_get_orientation (void)
{
	GtkOrientation result;
	switch (workspaces_workspaces_applet_panel_position) {
		case BUDGIE_PANEL_POSITION_TOP:
		case BUDGIE_PANEL_POSITION_BOTTOM:
		{
			result = GTK_ORIENTATION_HORIZONTAL;
			return result;
		}
		default:
		{
			result = GTK_ORIENTATION_VERTICAL;
			return result;
		}
	}
}

static XfwWorkspace*
workspaces_workspaces_applet_get_workspace_by_index (WorkspacesWorkspacesApplet* self,
                                                     guint num)
{
	GList* workspaces = NULL;
	XfwWorkspaceGroup* _tmp0_;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	XfwWorkspace* _tmp3_;
	XfwWorkspace* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = workspaces_workspaces_applet_workspace_group;
	_tmp1_ = xfw_workspace_group_list_workspaces (_tmp0_);
	workspaces = _tmp1_;
	_tmp2_ = g_list_nth_data (workspaces, num);
	_tmp3_ = _g_object_ref0 ((XfwWorkspace*) _tmp2_);
	result = _tmp3_;
	return result;
}

const gchar*
workspaces_workspaces_applet_get_uuid (WorkspacesWorkspacesApplet* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}

void
workspaces_workspaces_applet_set_uuid (WorkspacesWorkspacesApplet* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = workspaces_workspaces_applet_get_uuid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uuid);
		self->priv->_uuid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, workspaces_workspaces_applet_properties[WORKSPACES_WORKSPACES_APPLET_UUID_PROPERTY]);
	}
}

static void
workspaces_workspaces_applet_class_init (WorkspacesWorkspacesAppletClass * klass,
                                         gpointer klass_data)
{
	workspaces_workspaces_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WorkspacesWorkspacesApplet_private_offset);
	((BudgieAppletClass *) klass)->get_settings_ui = (GtkWidget* (*) (BudgieApplet*)) workspaces_workspaces_applet_real_get_settings_ui;
	((BudgieAppletClass *) klass)->supports_settings = (gboolean (*) (BudgieApplet*)) workspaces_workspaces_applet_real_supports_settings;
	((BudgieAppletClass *) klass)->panel_size_changed = (void (*) (BudgieApplet*, gint, gint, gint)) workspaces_workspaces_applet_real_panel_size_changed;
	((BudgieAppletClass *) klass)->panel_position_changed = (void (*) (BudgieApplet*, BudgiePanelPosition)) workspaces_workspaces_applet_real_panel_position_changed;
	((BudgieAppletClass *) klass)->update_popovers = (void (*) (BudgieApplet*, BudgiePopoverManager*)) workspaces_workspaces_applet_real_update_popovers;
	G_OBJECT_CLASS (klass)->get_property = _vala_workspaces_workspaces_applet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_workspaces_workspaces_applet_set_property;
	G_OBJECT_CLASS (klass)->finalize = workspaces_workspaces_applet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORKSPACES_WORKSPACES_APPLET_UUID_PROPERTY, workspaces_workspaces_applet_properties[WORKSPACES_WORKSPACES_APPLET_UUID_PROPERTY] = g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
workspaces_workspaces_applet_instance_init (WorkspacesWorkspacesApplet * self,
                                            gpointer klass)
{
	gulong* _tmp0_;
	self->priv = workspaces_workspaces_applet_get_instance_private (self);
	self->priv->wm_proxy = NULL;
	self->priv->show_transition = GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT;
	self->priv->hide_transition = GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT;
	self->priv->startup = TRUE;
	self->priv->size_change = 0;
	self->priv->updating = FALSE;
	_tmp0_ = g_new0 (gulong, 0);
	self->priv->connections = _tmp0_;
	self->priv->connections_length1 = 0;
	self->priv->_connections_size_ = self->priv->connections_length1;
	self->priv->button_visibility = WORKSPACES_ADD_BUTTON_VISIBILITY_ALWAYS;
	self->priv->item_size_multiplier = 1.0f;
	self->priv->last_scroll_time = (gint64) 0;
}

static void
workspaces_workspaces_applet_finalize (GObject * obj)
{
	WorkspacesWorkspacesApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WORKSPACES_TYPE_WORKSPACES_APPLET, WorkspacesWorkspacesApplet);
	_g_object_unref0 (self->priv->wm_proxy);
	_g_object_unref0 (self->priv->ebox);
	_g_object_unref0 (self->priv->main_layout);
	_g_object_unref0 (self->priv->workspaces_layout);
	_g_object_unref0 (self->priv->add_button_revealer);
	self->priv->connections = (g_free (self->priv->connections), NULL);
	_g_hash_table_unref0 (self->priv->window_connections);
	(self->priv->dynamically_created_workspaces == NULL) ? NULL : (self->priv->dynamically_created_workspaces = (g_list_free (self->priv->dynamically_created_workspaces), NULL));
	_g_object_unref0 (self->priv->settings);
	_g_free0 (self->priv->_uuid);
	G_OBJECT_CLASS (workspaces_workspaces_applet_parent_class)->finalize (obj);
}

GType
workspaces_workspaces_applet_get_type (void)
{
	return workspaces_workspaces_applet_type_id;
}

GType
workspaces_workspaces_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (WorkspacesWorkspacesAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) workspaces_workspaces_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WorkspacesWorkspacesApplet), 0, (GInstanceInitFunc) workspaces_workspaces_applet_instance_init, NULL };
	workspaces_workspaces_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "WorkspacesWorkspacesApplet", &g_define_type_info, 0);
	WorkspacesWorkspacesApplet_private_offset = sizeof (WorkspacesWorkspacesAppletPrivate);
	return workspaces_workspaces_applet_type_id;
}

static void
_vala_workspaces_workspaces_applet_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	WorkspacesWorkspacesApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WORKSPACES_TYPE_WORKSPACES_APPLET, WorkspacesWorkspacesApplet);
	switch (property_id) {
		case WORKSPACES_WORKSPACES_APPLET_UUID_PROPERTY:
		g_value_set_string (value, workspaces_workspaces_applet_get_uuid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_workspaces_workspaces_applet_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	WorkspacesWorkspacesApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WORKSPACES_TYPE_WORKSPACES_APPLET, WorkspacesWorkspacesApplet);
	switch (property_id) {
		case WORKSPACES_WORKSPACES_APPLET_UUID_PROPERTY:
		workspaces_workspaces_applet_set_uuid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	workspaces_workspaces_plugin_register_type (module);
	workspaces_workspaces_applet_settings_register_type (module);
	workspaces_workspaces_applet_register_type (module);
	workspaces_workspace_item_register_type (module);
	workspaces_window_icon_register_type (module);
	workspaces_budgie_wm_register_type (module);
	workspaces_budgie_wm_proxy_register_dynamic_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), WORKSPACES_TYPE_WORKSPACES_PLUGIN);
	_g_object_unref0 (objmodule);
}

