/* CommonAction.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CommonAction.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include "slingshot.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SYNAPSE_COMMON_ACTIONS_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_properties[SYNAPSE_COMMON_ACTIONS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SYNAPSE_TYPE_RUNNER_ACTION (synapse_runner_action_get_type ())
#define SYNAPSE_RUNNER_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RUNNER_ACTION, SynapseRunnerAction))
#define SYNAPSE_RUNNER_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RUNNER_ACTION, SynapseRunnerActionClass))
#define SYNAPSE_IS_RUNNER_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RUNNER_ACTION))
#define SYNAPSE_IS_RUNNER_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RUNNER_ACTION))
#define SYNAPSE_RUNNER_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RUNNER_ACTION, SynapseRunnerActionClass))

typedef struct _SynapseRunnerAction SynapseRunnerAction;
typedef struct _SynapseRunnerActionClass SynapseRunnerActionClass;

#define SYNAPSE_TYPE_TERMINAL_RUNNER_ACTION (synapse_terminal_runner_action_get_type ())
#define SYNAPSE_TERMINAL_RUNNER_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_TERMINAL_RUNNER_ACTION, SynapseTerminalRunnerAction))
#define SYNAPSE_TERMINAL_RUNNER_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_TERMINAL_RUNNER_ACTION, SynapseTerminalRunnerActionClass))
#define SYNAPSE_IS_TERMINAL_RUNNER_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_TERMINAL_RUNNER_ACTION))
#define SYNAPSE_IS_TERMINAL_RUNNER_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_TERMINAL_RUNNER_ACTION))
#define SYNAPSE_TERMINAL_RUNNER_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_TERMINAL_RUNNER_ACTION, SynapseTerminalRunnerActionClass))

typedef struct _SynapseTerminalRunnerAction SynapseTerminalRunnerAction;
typedef struct _SynapseTerminalRunnerActionClass SynapseTerminalRunnerActionClass;

#define SYNAPSE_TYPE_CLIPBOARD_COPY_ACTION (synapse_clipboard_copy_action_get_type ())
#define SYNAPSE_CLIPBOARD_COPY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_CLIPBOARD_COPY_ACTION, SynapseClipboardCopyAction))
#define SYNAPSE_CLIPBOARD_COPY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_CLIPBOARD_COPY_ACTION, SynapseClipboardCopyActionClass))
#define SYNAPSE_IS_CLIPBOARD_COPY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_CLIPBOARD_COPY_ACTION))
#define SYNAPSE_IS_CLIPBOARD_COPY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_CLIPBOARD_COPY_ACTION))
#define SYNAPSE_CLIPBOARD_COPY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_CLIPBOARD_COPY_ACTION, SynapseClipboardCopyActionClass))

typedef struct _SynapseClipboardCopyAction SynapseClipboardCopyAction;
typedef struct _SynapseClipboardCopyActionClass SynapseClipboardCopyActionClass;

struct _SynapseCommonActionsPrivate {
	gboolean _enabled;
	GeeList* actions;
};

static gint SynapseCommonActions_private_offset;
static gpointer synapse_common_actions_parent_class = NULL;
static SynapseActivatableIface * synapse_common_actions_synapse_activatable_parent_iface = NULL;
static SynapseActionProviderIface * synapse_common_actions_synapse_action_provider_parent_iface = NULL;
static GType synapse_common_actions_type_id = 0;

static void synapse_common_actions_real_activate (SynapseActivatable* base);
static void synapse_common_actions_real_deactivate (SynapseActivatable* base);
static SynapseResultSet* synapse_common_actions_real_find_for_match (SynapseActionProvider* base,
                                                              SynapseQuery* query,
                                                              SynapseMatch* match);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static GObject * synapse_common_actions_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
VALA_EXTERN SynapseRunnerAction* synapse_runner_action_new (void);
VALA_EXTERN SynapseRunnerAction* synapse_runner_action_construct (GType object_type);
GType synapse_runner_action_register_type (GTypeModule * module);
VALA_EXTERN GType synapse_runner_action_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SynapseTerminalRunnerAction* synapse_terminal_runner_action_new (void);
VALA_EXTERN SynapseTerminalRunnerAction* synapse_terminal_runner_action_construct (GType object_type);
GType synapse_terminal_runner_action_register_type (GTypeModule * module);
VALA_EXTERN GType synapse_terminal_runner_action_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SynapseClipboardCopyAction* synapse_clipboard_copy_action_new (void);
VALA_EXTERN SynapseClipboardCopyAction* synapse_clipboard_copy_action_construct (GType object_type);
GType synapse_clipboard_copy_action_register_type (GTypeModule * module);
VALA_EXTERN GType synapse_clipboard_copy_action_get_type (void) G_GNUC_CONST ;
static void synapse_common_actions_finalize (GObject * obj);
static void _vala_synapse_common_actions_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_synapse_common_actions_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
synapse_common_actions_get_instance_private (SynapseCommonActions* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCommonActions_private_offset);
}

static void
synapse_common_actions_real_activate (SynapseActivatable* base)
{
	SynapseCommonActions * self;
	self = (SynapseCommonActions*) base;
}

static void
synapse_common_actions_real_deactivate (SynapseActivatable* base)
{
	SynapseCommonActions * self;
	self = (SynapseCommonActions*) base;
}

static SynapseResultSet*
synapse_common_actions_real_find_for_match (SynapseActionProvider* base,
                                            SynapseQuery* query,
                                            SynapseMatch* match)
{
	SynapseCommonActions * self;
	gboolean query_empty = FALSE;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	SynapseResultSet* results = NULL;
	SynapseResultSet* _tmp2_;
	SynapseResultSet* result;
	self = (SynapseCommonActions*) base;
	g_return_val_if_fail (query != NULL, NULL);
	g_return_val_if_fail (match != NULL, NULL);
	_tmp0_ = *query;
	_tmp1_ = _tmp0_.query_string;
	query_empty = g_strcmp0 (_tmp1_, "") == 0;
	_tmp2_ = synapse_result_set_new ();
	results = _tmp2_;
	if (query_empty) {
		{
			GeeList* _action_list = NULL;
			GeeList* _tmp3_;
			gint _action_size = 0;
			GeeList* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _action_index = 0;
			_tmp3_ = self->priv->actions;
			_action_list = _tmp3_;
			_tmp4_ = _action_list;
			_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
			_tmp6_ = _tmp5_;
			_action_size = _tmp6_;
			_action_index = -1;
			while (TRUE) {
				gint _tmp7_;
				gint _tmp8_;
				SynapseBaseAction* action = NULL;
				GeeList* _tmp9_;
				gpointer _tmp10_;
				SynapseBaseAction* _tmp11_;
				_action_index = _action_index + 1;
				_tmp7_ = _action_index;
				_tmp8_ = _action_size;
				if (!(_tmp7_ < _tmp8_)) {
					break;
				}
				_tmp9_ = _action_list;
				_tmp10_ = gee_list_get (_tmp9_, _action_index);
				action = (SynapseBaseAction*) _tmp10_;
				_tmp11_ = action;
				if (synapse_base_action_valid_for_match (_tmp11_, match)) {
					SynapseResultSet* _tmp12_;
					SynapseBaseAction* _tmp13_;
					SynapseBaseAction* _tmp14_;
					_tmp12_ = results;
					_tmp13_ = action;
					_tmp14_ = action;
					synapse_result_set_add (_tmp12_, (SynapseMatch*) _tmp13_, synapse_base_action_get_relevancy_for_match (_tmp14_, match));
				}
				_g_object_unref0 (action);
			}
		}
	} else {
		GeeList* matchers = NULL;
		SynapseQuery _tmp15_;
		const gchar* _tmp16_;
		GeeList* _tmp17_;
		_tmp15_ = *query;
		_tmp16_ = _tmp15_.query_string;
		_tmp17_ = synapse_query_get_matchers_for_query (_tmp16_, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
		matchers = _tmp17_;
		{
			GeeList* _action_list = NULL;
			GeeList* _tmp18_;
			gint _action_size = 0;
			GeeList* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			gint _action_index = 0;
			_tmp18_ = self->priv->actions;
			_action_list = _tmp18_;
			_tmp19_ = _action_list;
			_tmp20_ = gee_collection_get_size ((GeeCollection*) _tmp19_);
			_tmp21_ = _tmp20_;
			_action_size = _tmp21_;
			_action_index = -1;
			while (TRUE) {
				gint _tmp22_;
				gint _tmp23_;
				SynapseBaseAction* action = NULL;
				GeeList* _tmp24_;
				gpointer _tmp25_;
				SynapseBaseAction* _tmp26_;
				_action_index = _action_index + 1;
				_tmp22_ = _action_index;
				_tmp23_ = _action_size;
				if (!(_tmp22_ < _tmp23_)) {
					break;
				}
				_tmp24_ = _action_list;
				_tmp25_ = gee_list_get (_tmp24_, _action_index);
				action = (SynapseBaseAction*) _tmp25_;
				_tmp26_ = action;
				if (!synapse_base_action_valid_for_match (_tmp26_, match)) {
					_g_object_unref0 (action);
					continue;
				}
				{
					GeeList* _matcher_list = NULL;
					GeeList* _tmp27_;
					gint _matcher_size = 0;
					GeeList* _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					gint _matcher_index = 0;
					_tmp27_ = matchers;
					_matcher_list = _tmp27_;
					_tmp28_ = _matcher_list;
					_tmp29_ = gee_collection_get_size ((GeeCollection*) _tmp28_);
					_tmp30_ = _tmp29_;
					_matcher_size = _tmp30_;
					_matcher_index = -1;
					while (TRUE) {
						gint _tmp31_;
						gint _tmp32_;
						GeeMapEntry* matcher = NULL;
						GeeList* _tmp33_;
						gpointer _tmp34_;
						GeeMapEntry* _tmp35_;
						gconstpointer _tmp36_;
						gconstpointer _tmp37_;
						SynapseBaseAction* _tmp38_;
						const gchar* _tmp39_;
						const gchar* _tmp40_;
						_matcher_index = _matcher_index + 1;
						_tmp31_ = _matcher_index;
						_tmp32_ = _matcher_size;
						if (!(_tmp31_ < _tmp32_)) {
							break;
						}
						_tmp33_ = _matcher_list;
						_tmp34_ = gee_list_get (_tmp33_, _matcher_index);
						matcher = (GeeMapEntry*) _tmp34_;
						_tmp35_ = matcher;
						_tmp36_ = gee_map_entry_get_key (_tmp35_);
						_tmp37_ = _tmp36_;
						_tmp38_ = action;
						_tmp39_ = synapse_match_get_title ((SynapseMatch*) _tmp38_);
						_tmp40_ = _tmp39_;
						if (g_regex_match ((GRegex*) _tmp37_, _tmp40_, 0, NULL)) {
							SynapseResultSet* _tmp41_;
							SynapseBaseAction* _tmp42_;
							GeeMapEntry* _tmp43_;
							gconstpointer _tmp44_;
							gconstpointer _tmp45_;
							_tmp41_ = results;
							_tmp42_ = action;
							_tmp43_ = matcher;
							_tmp44_ = gee_map_entry_get_value (_tmp43_);
							_tmp45_ = _tmp44_;
							synapse_result_set_add (_tmp41_, (SynapseMatch*) _tmp42_, (gint) ((gintptr) _tmp45_));
							_g_object_unref0 (matcher);
							break;
						}
						_g_object_unref0 (matcher);
					}
				}
				_g_object_unref0 (action);
			}
		}
		_g_object_unref0 (matchers);
	}
	result = results;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
synapse_common_actions_open_uri (const gchar* uri)
{
	GFile* f = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_file_new_for_uri (uri);
	f = _tmp0_;
	{
		GAppInfo* app_info = NULL;
		GFile* _tmp1_;
		GAppInfo* _tmp2_;
		GList* files = NULL;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GdkDisplay* display = NULL;
		GdkDisplay* _tmp5_;
		GdkDisplay* _tmp6_;
		GAppInfo* _tmp7_;
		GList* _tmp8_;
		GdkDisplay* _tmp9_;
		GdkAppLaunchContext* _tmp10_;
		GdkAppLaunchContext* _tmp11_;
		_tmp1_ = f;
		_tmp2_ = g_file_query_default_handler (_tmp1_, NULL, &_inner_error0_);
		app_info = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		files = NULL;
		_tmp3_ = f;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		files = g_list_prepend (files, _tmp4_);
		_tmp5_ = gdk_display_get_default ();
		_tmp6_ = _g_object_ref0 (_tmp5_);
		display = _tmp6_;
		_tmp7_ = app_info;
		_tmp8_ = files;
		_tmp9_ = display;
		_tmp10_ = gdk_display_get_app_launch_context (_tmp9_);
		_tmp11_ = _tmp10_;
		g_app_info_launch (_tmp7_, _tmp8_, (GAppLaunchContext*) _tmp11_, &_inner_error0_);
		_g_object_unref0 (_tmp11_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (display);
			(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
			_g_object_unref0 (app_info);
			goto __catch0_g_error;
		}
		_g_object_unref0 (display);
		(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
		_g_object_unref0 (app_info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = err;
		_tmp13_ = _tmp12_->message;
		g_critical ("CommonAction.vala:84: %s", _tmp13_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (f);
}

SynapseCommonActions*
synapse_common_actions_construct (GType object_type)
{
	SynapseCommonActions * self = NULL;
	self = (SynapseCommonActions*) g_object_new (object_type, NULL);
	return self;
}

SynapseCommonActions*
synapse_common_actions_new (void)
{
	return synapse_common_actions_construct (SYNAPSE_TYPE_COMMON_ACTIONS);
}

static gboolean
synapse_common_actions_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseCommonActions* self;
	self = (SynapseCommonActions*) base;
	result = self->priv->_enabled;
	return result;
}

static void
synapse_common_actions_real_set_enabled (SynapseActivatable* base,
                                         gboolean value)
{
	SynapseCommonActions* self;
	gboolean old_value;
	self = (SynapseCommonActions*) base;
	old_value = synapse_common_actions_real_get_enabled (base);
	if (old_value != value) {
		self->priv->_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_common_actions_properties[SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY]);
	}
}

static GObject *
synapse_common_actions_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCommonActions * self;
	GeeArrayList* _tmp0_;
	GeeList* _tmp1_;
	SynapseRunnerAction* _tmp2_;
	SynapseRunnerAction* _tmp3_;
	GeeList* _tmp4_;
	SynapseTerminalRunnerAction* _tmp5_;
	SynapseTerminalRunnerAction* _tmp6_;
	GeeList* _tmp7_;
	SynapseClipboardCopyAction* _tmp8_;
	SynapseClipboardCopyAction* _tmp9_;
	parent_class = G_OBJECT_CLASS (synapse_common_actions_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions);
	_tmp0_ = gee_array_list_new (SYNAPSE_TYPE_BASE_ACTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->actions);
	self->priv->actions = (GeeList*) _tmp0_;
	_tmp1_ = self->priv->actions;
	_tmp2_ = synapse_runner_action_new ();
	_tmp3_ = _tmp2_;
	gee_collection_add ((GeeCollection*) _tmp1_, (SynapseBaseAction*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->actions;
	_tmp5_ = synapse_terminal_runner_action_new ();
	_tmp6_ = _tmp5_;
	gee_collection_add ((GeeCollection*) _tmp4_, (SynapseBaseAction*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->actions;
	_tmp8_ = synapse_clipboard_copy_action_new ();
	_tmp9_ = _tmp8_;
	gee_collection_add ((GeeCollection*) _tmp7_, (SynapseBaseAction*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	return obj;
}

static void
synapse_common_actions_class_init (SynapseCommonActionsClass * klass,
                                   gpointer klass_data)
{
	synapse_common_actions_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseCommonActions_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_common_actions_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_common_actions_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_common_actions_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_common_actions_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY, synapse_common_actions_properties[SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
synapse_common_actions_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                           gpointer iface_data)
{
	synapse_common_actions_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*) (SynapseActivatable*)) synapse_common_actions_real_activate;
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_common_actions_real_deactivate;
	iface->get_enabled = synapse_common_actions_real_get_enabled;
	iface->set_enabled = synapse_common_actions_real_set_enabled;
}

static void
synapse_common_actions_synapse_action_provider_interface_init (SynapseActionProviderIface * iface,
                                                               gpointer iface_data)
{
	synapse_common_actions_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->find_for_match = (SynapseResultSet* (*) (SynapseActionProvider*, SynapseQuery*, SynapseMatch*)) synapse_common_actions_real_find_for_match;
}

static void
synapse_common_actions_instance_init (SynapseCommonActions * self,
                                      gpointer klass)
{
	self->priv = synapse_common_actions_get_instance_private (self);
	self->priv->_enabled = TRUE;
}

static void
synapse_common_actions_finalize (GObject * obj)
{
	SynapseCommonActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions);
	_g_object_unref0 (self->priv->actions);
	G_OBJECT_CLASS (synapse_common_actions_parent_class)->finalize (obj);
}

GType
synapse_common_actions_get_type (void)
{
	return synapse_common_actions_type_id;
}

GType
synapse_common_actions_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActions), 0, (GInstanceInitFunc) synapse_common_actions_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_common_actions_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_common_actions_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	synapse_common_actions_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "SynapseCommonActions", &g_define_type_info, 0);
	g_type_module_add_interface (module, synapse_common_actions_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_module_add_interface (module, synapse_common_actions_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
	SynapseCommonActions_private_offset = sizeof (SynapseCommonActionsPrivate);
	return synapse_common_actions_type_id;
}

static void
_vala_synapse_common_actions_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SynapseCommonActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions);
	switch (property_id) {
		case SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_synapse_common_actions_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	SynapseCommonActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions);
	switch (property_id) {
		case SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

