// Copyright 2019 Drone.IO Inc. All rights reserved.
// Use of this source code is governed by the Drone Non-Commercial License
// that can be found in the LICENSE file.

//go:build !oss
// +build !oss

package secrets

import (
	"net/http"

	"github.com/drone/drone/core"
	"github.com/drone/drone/handler/api/render"

	"github.com/go-chi/chi"
)

// HandleFind returns an http.HandlerFunc that writes json-encoded
// secret details to the response body.
func HandleFind(
	repos core.RepositoryStore,
	secrets core.SecretStore,
) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var (
			namespace = chi.URLParam(r, "owner")
			name      = chi.URLParam(r, "name")
			secret    = chi.URLParam(r, "secret")
		)
		repo, err := repos.FindName(r.Context(), namespace, name)
		if err != nil {
			render.NotFound(w, err)
			return
		}
		result, err := secrets.FindName(r.Context(), repo.ID, secret)
		if err != nil {
			render.NotFound(w, err)
			return
		}
		safe := result.Copy()
		render.JSON(w, safe, 200)
	}
}
