
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "externaljsobject_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_ExternalJsObject_Type = nullptr;
static PyTypeObject *Sbk_ExternalJsObject_TypeF(void)
{
    return _Sbk_ExternalJsObject_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void ExternalJsObjectWrapper::pysideInitQtMetaTypes()
{
}

void ExternalJsObjectWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

ExternalJsObjectWrapper::ExternalJsObjectWrapper(::WebPage * page) : ExternalJsObject(page)
{
}

void ExternalJsObjectWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ExternalJsObject_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("ExternalJsObject", funcName, gil, pyOverride, event);
}

void ExternalJsObjectWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ExternalJsObject_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("ExternalJsObject", funcName, gil, pyOverride, signal);
}

void ExternalJsObjectWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ExternalJsObject_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("ExternalJsObject", funcName, gil, pyOverride, event);
}

void ExternalJsObjectWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ExternalJsObject_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("ExternalJsObject", funcName, gil, pyOverride, signal);
}

bool ExternalJsObjectWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ExternalJsObject_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("ExternalJsObject", funcName, gil, pyOverride, event);
}

bool ExternalJsObjectWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ExternalJsObject_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("ExternalJsObject", funcName, gil, pyOverride, watched, event);
}

void ExternalJsObjectWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ExternalJsObject_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("ExternalJsObject", funcName, gil, pyOverride, event);
}

const QMetaObject *ExternalJsObjectWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return ExternalJsObject::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int ExternalJsObjectWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = ExternalJsObject::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *ExternalJsObjectWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< ExternalJsObjectWrapper *>(this));
    }
    return ExternalJsObject::qt_metacast(_clname);
}

ExternalJsObjectWrapper::~ExternalJsObjectWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_ExternalJsObject_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_ExternalJsObject_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::ExternalJsObject >()))
        return -1;

    ExternalJsObjectWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "ExternalJsObject", 1, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: ExternalJsObject::ExternalJsObject(WebPage*)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), (pyArgs[0])))) {
        overloadId = 0; // ExternalJsObject(WebPage*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_ExternalJsObject_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_ExternalJsObject_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::WebPage *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // ExternalJsObject(WebPage*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) ExternalJsObjectWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new ExternalJsObjectWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ExternalJsObject >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_ExternalJsObject_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_ExternalJsObject_IDX]);
    };


    return 1;
}

static PyObject *Sbk_ExternalJsObjectFunc_page(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ExternalJsObjectWrapper *>(reinterpret_cast< ::ExternalJsObject *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ExternalJsObject_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // page()const
        WebPage * cppResult = const_cast<const ExternalJsObjectWrapper *>(cppSelf)->page();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ExternalJsObjectFunc_registerExtraObject(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "registerExtraObject", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static ExternalJsObject::registerExtraObject(QString,QObject*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))) {
        overloadId = 0; // registerExtraObject(QString,QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "registerExtraObject", errInfo, SbkPyFalkonTypeStructs[SBK_ExternalJsObject_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // registerExtraObject(QString,QObject*)
            ::ExternalJsObject::registerExtraObject(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ExternalJsObjectFunc_setupWebChannel(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setupWebChannel", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static ExternalJsObject::setupWebChannel(QWebChannel*,WebPage*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWebChannelTypeStructs[SBK_QWebChannel_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setupWebChannel(QWebChannel*,WebPage*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setupWebChannel", errInfo, SbkPyFalkonTypeStructs[SBK_ExternalJsObject_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWebChannel *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::WebPage *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setupWebChannel(QWebChannel*,WebPage*)
            ::ExternalJsObject::setupWebChannel(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ExternalJsObjectFunc_unregisterExtraObject(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static ExternalJsObject::unregisterExtraObject(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArg)))) {
        overloadId = 0; // unregisterExtraObject(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "unregisterExtraObject", errInfo, SbkPyFalkonTypeStructs[SBK_ExternalJsObject_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // unregisterExtraObject(QObject*)
            ::ExternalJsObject::unregisterExtraObject(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_ExternalJsObject_PropertyStrings[] = {
    "autoFill:",
    "recovery:",
    "speedDial:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_ExternalJsObject_methods[] = {
    {"page", reinterpret_cast<PyCFunction>(Sbk_ExternalJsObjectFunc_page), METH_NOARGS, nullptr},
    {"registerExtraObject", reinterpret_cast<PyCFunction>(Sbk_ExternalJsObjectFunc_registerExtraObject), METH_VARARGS|METH_STATIC, nullptr},
    {"setupWebChannel", reinterpret_cast<PyCFunction>(Sbk_ExternalJsObjectFunc_setupWebChannel), METH_VARARGS|METH_STATIC, nullptr},
    {"unregisterExtraObject", reinterpret_cast<PyCFunction>(Sbk_ExternalJsObjectFunc_unregisterExtraObject), METH_O|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_ExternalJsObject_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::ExternalJsObject *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ExternalJsObject_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<ExternalJsObjectWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_ExternalJsObject_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_ExternalJsObject_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_ExternalJsObject_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_ExternalJsObject_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_ExternalJsObject_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_ExternalJsObject_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_ExternalJsObject_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_ExternalJsObject_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_ExternalJsObject_spec = {
    "1:PyFalkon.ExternalJsObject",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_ExternalJsObject_slots
};

} //extern "C"

static void *Sbk_ExternalJsObject_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::ExternalJsObject *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void ExternalJsObject_PythonToCpp_ExternalJsObject_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_ExternalJsObject_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_ExternalJsObject_PythonToCpp_ExternalJsObject_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_ExternalJsObject_TypeF()))
        return ExternalJsObject_PythonToCpp_ExternalJsObject_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *ExternalJsObject_PTR_CppToPython_ExternalJsObject(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::ExternalJsObject *>(const_cast<void *>(cppIn)), Sbk_ExternalJsObject_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *ExternalJsObject_SignatureStrings[] = {
    "PyFalkon.ExternalJsObject(self,page:PyFalkon.WebPage,*:KeywordOnly=None,speedDial:QObject=None,autoFill:QObject=None,recovery:QObject=None)",
    "PyFalkon.ExternalJsObject.page(self)->PyFalkon.WebPage",
    "PyFalkon.ExternalJsObject.registerExtraObject(id:QString,object:PySide6.QtCore.QObject)",
    "PyFalkon.ExternalJsObject.setupWebChannel(webChannel:PySide6.QtWebChannel.QWebChannel,page:PyFalkon.WebPage)",
    "PyFalkon.ExternalJsObject.unregisterExtraObject(object:PySide6.QtCore.QObject)",
    nullptr}; // Sentinel
#else
static constexpr size_t ExternalJsObject_SignatureByteSize = 197;
static constexpr uint8_t ExternalJsObject_SignatureBytes[197] = {
    0x78, 0xda, 0x85, 0x90, 0xb1, 0x0e, 0x82, 0x30, 0x10, 0x86, 0x77, 0x9f, 0x04, 0x0c, 0x76, 0x74,
    0x20, 0xd1, 0x05, 0x65, 0xd0, 0x44, 0x4a, 0x18, 0x9c, 0x0b, 0x3d, 0xb1, 0xda, 0xb4, 0xa4, 0x2d,
    0x22, 0x6f, 0x6f, 0x05, 0x14, 0x25, 0x88, 0xdb, 0xe5, 0xbb, 0xbb, 0xde, 0xf7, 0x17, 0xd7, 0x21,
    0xe1, 0x57, 0x29, 0xd0, 0xf6, 0x6e, 0x40, 0x09, 0xc2, 0x77, 0x3a, 0x4a, 0x2f, 0x90, 0x19, 0x47,
    0x03, 0x3f, 0x79, 0x05, 0xc9, 0xc1, 0xc7, 0xaf, 0x99, 0x23, 0xa4, 0xd8, 0x02, 0x6f, 0xee, 0xef,
    0xa1, 0xae, 0xa4, 0xa2, 0x91, 0xe0, 0xf5, 0xea, 0x20, 0x05, 0x78, 0xba, 0x00, 0xa0, 0x1b, 0x46,
    0xb8, 0x1f, 0xb7, 0xfb, 0x2d, 0x26, 0xa5, 0x91, 0x21, 0xe3, 0x03, 0xaa, 0x20, 0x93, 0x37, 0x50,
    0xf5, 0x17, 0x75, 0x67, 0xf8, 0x97, 0x0b, 0x7a, 0x6a, 0x34, 0x42, 0xee, 0x62, 0x3d, 0xb4, 0x99,
    0x58, 0x53, 0x90, 0x33, 0x6d, 0x99, 0x6d, 0x28, 0xd2, 0xc5, 0x62, 0xd4, 0x8f, 0x13, 0xa3, 0x98,
    0xc8, 0x3d, 0xd9, 0x10, 0x1b, 0x2f, 0x61, 0x14, 0x96, 0x28, 0x36, 0x81, 0x54, 0x80, 0x3a, 0xa7,
    0x29, 0x1d, 0x0d, 0xa6, 0x2c, 0xec, 0xf9, 0xe0, 0x4c, 0x84, 0x00, 0xee, 0x54, 0xef, 0xf2, 0xe3,
    0xb1, 0xbe, 0x8f, 0xe2, 0xbe, 0x1e, 0xff, 0xd1, 0xa9, 0x63, 0xa5, 0x18, 0x8b, 0xf1, 0xc7, 0xfd,
    0x01, 0xc7, 0x30, 0xac, 0xee
};
#endif

PyTypeObject *init_ExternalJsObject(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_ExternalJsObject_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_ExternalJsObject_IDX].type;

    Shiboken::AutoDecRef Sbk_ExternalJsObject_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_ExternalJsObject_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "ExternalJsObject",
        "ExternalJsObject*",
        &Sbk_ExternalJsObject_spec,
        &Shiboken::callCppDestructor< ExternalJsObject >,
        Sbk_ExternalJsObject_Type_bases.object(),
        0);
    auto *pyType = Sbk_ExternalJsObject_TypeF(); // references _Sbk_ExternalJsObject_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, ExternalJsObject_SignatureStrings);
#else
    InitSignatureBytes(pyType, ExternalJsObject_SignatureBytes, ExternalJsObject_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_ExternalJsObject_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_ExternalJsObject_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        ExternalJsObject_PythonToCpp_ExternalJsObject_PTR,
        is_ExternalJsObject_PythonToCpp_ExternalJsObject_PTR_Convertible,
        ExternalJsObject_PTR_CppToPython_ExternalJsObject);

    Shiboken::Conversions::registerConverterName(converter, "ExternalJsObject");
    Shiboken::Conversions::registerConverterName(converter, "ExternalJsObject*");
    Shiboken::Conversions::registerConverterName(converter, "ExternalJsObject&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::ExternalJsObject).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(ExternalJsObjectWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_ExternalJsObject_TypeF(), &Sbk_ExternalJsObject_typeDiscovery);

    ExternalJsObjectWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::ExternalJsObject::staticMetaObject, sizeof(ExternalJsObjectWrapper));

    return pyType;
}
