/* gitg-commit-action-create-patch.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-commit-action-create-patch.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2014 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include "libgitg-ext.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "libgitg.h"
#include <libgit2-glib/ggit.h>
#include "config.h"
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>

#define GITG_COMMIT_ACTION_CREATE_PATCH_version VERSION
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GITG_TYPE_COMMIT_ACTION_CREATE_PATCH (gitg_commit_action_create_patch_get_type ())
#define GITG_COMMIT_ACTION_CREATE_PATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_COMMIT_ACTION_CREATE_PATCH, GitgCommitActionCreatePatch))
#define GITG_COMMIT_ACTION_CREATE_PATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_COMMIT_ACTION_CREATE_PATCH, GitgCommitActionCreatePatchClass))
#define GITG_IS_COMMIT_ACTION_CREATE_PATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_COMMIT_ACTION_CREATE_PATCH))
#define GITG_IS_COMMIT_ACTION_CREATE_PATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_COMMIT_ACTION_CREATE_PATCH))
#define GITG_COMMIT_ACTION_CREATE_PATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_COMMIT_ACTION_CREATE_PATCH, GitgCommitActionCreatePatchClass))

typedef struct _GitgCommitActionCreatePatch GitgCommitActionCreatePatch;
typedef struct _GitgCommitActionCreatePatchClass GitgCommitActionCreatePatchClass;
typedef struct _GitgCommitActionCreatePatchPrivate GitgCommitActionCreatePatchPrivate;
enum  {
	GITG_COMMIT_ACTION_CREATE_PATCH_0_PROPERTY,
	GITG_COMMIT_ACTION_CREATE_PATCH_APPLICATION_PROPERTY,
	GITG_COMMIT_ACTION_CREATE_PATCH_ACTION_INTERFACE_PROPERTY,
	GITG_COMMIT_ACTION_CREATE_PATCH_COMMIT_PROPERTY,
	GITG_COMMIT_ACTION_CREATE_PATCH_DIFF_PROPERTY,
	GITG_COMMIT_ACTION_CREATE_PATCH_ID_PROPERTY,
	GITG_COMMIT_ACTION_CREATE_PATCH_DISPLAY_NAME_PROPERTY,
	GITG_COMMIT_ACTION_CREATE_PATCH_DESCRIPTION_PROPERTY,
	GITG_COMMIT_ACTION_CREATE_PATCH_NUM_PROPERTIES
};
static GParamSpec* gitg_commit_action_create_patch_properties[GITG_COMMIT_ACTION_CREATE_PATCH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
typedef struct _Block57Data Block57Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GitgCommitActionCreatePatch {
	GObject parent_instance;
	GitgCommitActionCreatePatchPrivate * priv;
};

struct _GitgCommitActionCreatePatchClass {
	GObjectClass parent_class;
	void (*activate) (GitgCommitActionCreatePatch* self);
	gchar* (*get_id) (GitgCommitActionCreatePatch* self);
	gchar* (*get_description) (GitgCommitActionCreatePatch* self);
};

struct _GitgCommitActionCreatePatchPrivate {
	GitgExtApplication* _application;
	GitgExtRefActionInterface* _action_interface;
	GitgCommit* _commit;
	GgitDiff* _diff;
};

struct _Block57Data {
	int _ref_count_;
	GitgCommitActionCreatePatch* self;
	GtkFileChooserDialog* chooser;
};

static gint GitgCommitActionCreatePatch_private_offset;
static gpointer gitg_commit_action_create_patch_parent_class = NULL;
static GRegex* gitg_commit_action_create_patch_s_subject_regex;
static GRegex* gitg_commit_action_create_patch_s_subject_regex = NULL;
static GitgExtUIElementIface * gitg_commit_action_create_patch_gitg_ext_ui_element_parent_iface = NULL;
static GitgExtActionIface * gitg_commit_action_create_patch_gitg_ext_action_parent_iface = NULL;
static GitgExtCommitActionIface * gitg_commit_action_create_patch_gitg_ext_commit_action_parent_iface = NULL;

VALA_EXTERN GType gitg_commit_action_create_patch_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgCommitActionCreatePatch, g_object_unref)
VALA_EXTERN void gitg_commit_action_create_patch_activate (GitgCommitActionCreatePatch* self);
VALA_EXTERN gchar* gitg_commit_action_create_patch_get_id (GitgCommitActionCreatePatch* self);
VALA_EXTERN gchar* gitg_commit_action_create_patch_get_description (GitgCommitActionCreatePatch* self);
VALA_EXTERN GitgCommitActionCreatePatch* gitg_commit_action_create_patch_new (GitgExtApplication* application,
                                                                  GitgExtRefActionInterface* action_interface,
                                                                  GitgCommit* commit);
VALA_EXTERN GitgCommitActionCreatePatch* gitg_commit_action_create_patch_construct (GType object_type,
                                                                        GitgExtApplication* application,
                                                                        GitgExtRefActionInterface* action_interface,
                                                                        GitgCommit* commit);
static gchar* gitg_commit_action_create_patch_patch_filename (GitgCommitActionCreatePatch* self,
                                                       gint i);
static GgitDiff* gitg_commit_action_create_patch_create_diff_from_commit (GitgCommitActionCreatePatch* self,
                                                                   GError** error);
static void gitg_commit_action_create_patch_create_patch (GitgCommitActionCreatePatch* self,
                                                   GFile* file,
                                                   GError** error);
VALA_EXTERN GgitDiff* gitg_commit_action_create_patch_get_diff (GitgCommitActionCreatePatch* self);
VALA_EXTERN void gitg_commit_action_create_patch_set_diff (GitgCommitActionCreatePatch* self,
                                               GgitDiff* value);
static void _vala_GgitOId_free (GgitOId* self);
static void gitg_commit_action_create_patch_real_activate (GitgCommitActionCreatePatch* self);
static Block57Data* block57_data_ref (Block57Data* _data57_);
static void block57_data_unref (void * _userdata_);
static void __lambda123_ (Block57Data* _data57_,
                   GtkDialog* dialog,
                   gint id);
static void ___lambda123__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static void gitg_commit_action_create_patch_finalize (GObject * obj);
static GType gitg_commit_action_create_patch_get_type_once (void);
static void _vala_gitg_commit_action_create_patch_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_gitg_commit_action_create_patch_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);

static inline gpointer
gitg_commit_action_create_patch_get_instance_private (GitgCommitActionCreatePatch* self)
{
	return G_STRUCT_MEMBER_P (self, GitgCommitActionCreatePatch_private_offset);
}

GitgCommitActionCreatePatch*
gitg_commit_action_create_patch_construct (GType object_type,
                                           GitgExtApplication* application,
                                           GitgExtRefActionInterface* action_interface,
                                           GitgCommit* commit)
{
	GitgCommitActionCreatePatch * self = NULL;
	g_return_val_if_fail (application != NULL, NULL);
	g_return_val_if_fail (action_interface != NULL, NULL);
	g_return_val_if_fail (commit != NULL, NULL);
	self = (GitgCommitActionCreatePatch*) g_object_new (object_type, "application", application, "action-interface", action_interface, "commit", commit, NULL);
	return self;
}

GitgCommitActionCreatePatch*
gitg_commit_action_create_patch_new (GitgExtApplication* application,
                                     GitgExtRefActionInterface* action_interface,
                                     GitgCommit* commit)
{
	return gitg_commit_action_create_patch_construct (GITG_TYPE_COMMIT_ACTION_CREATE_PATCH, application, action_interface, commit);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
gitg_commit_action_create_patch_patch_filename (GitgCommitActionCreatePatch* self,
                                                gint i)
{
	gchar* subject = NULL;
	GitgCommit* _tmp0_;
	GitgCommit* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gitg_ext_commit_action_get_commit ((GitgExtCommitAction*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = ggit_commit_get_subject ((GgitCommit*) _tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	subject = _tmp3_;
	{
		gchar* _tmp4_ = NULL;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp5_ = gitg_commit_action_create_patch_s_subject_regex;
		_tmp6_ = subject;
		_tmp7_ = subject;
		_tmp8_ = strlen (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_regex_replace (_tmp5_, _tmp6_, (gssize) _tmp9_, 0, "", 0, &_inner_error0_);
		_tmp4_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp11_ = _tmp4_;
		_tmp4_ = NULL;
		_g_free0 (subject);
		subject = _tmp11_;
		_tmp12_ = subject;
		_tmp13_ = string_replace (_tmp12_, " ", "-");
		_g_free0 (subject);
		subject = _tmp13_;
		_tmp14_ = subject;
		_tmp15_ = g_strdup_printf ("%04d-%s", i, _tmp14_);
		_g_free0 (subject);
		subject = _tmp15_;
		_g_free0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar* _tmp16_;
		g_clear_error (&_inner_error0_);
		_tmp16_ = g_strdup ("");
		result = _tmp16_;
		_g_free0 (subject);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (subject);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp17_ = subject;
	_tmp18_ = g_strconcat (_tmp17_, ".patch", NULL);
	result = _tmp18_;
	_g_free0 (subject);
	return result;
}

static GgitDiff*
gitg_commit_action_create_patch_create_diff_from_commit (GitgCommitActionCreatePatch* self,
                                                         GError** error)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GgitDiffOptions* opts = NULL;
	GgitDiffOptions* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp7_;
	gint nc = 0;
	GSettings* _tmp12_;
	GgitDiffOptions* _tmp13_;
	GgitDiffOptions* _tmp14_;
	GgitDiffOptions* _tmp15_;
	GgitDiffOptions* _tmp16_;
	GgitDiffOption _tmp17_;
	GgitDiffOption _tmp18_;
	GitgCommit* _tmp19_;
	GitgCommit* _tmp20_;
	GgitDiffOptions* _tmp21_;
	GgitDiff* _tmp22_;
	GgitDiff* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_settings_new (APPLICATION_ID ".preferences.diff");
	settings = _tmp0_;
	_tmp1_ = ggit_diff_options_new ();
	opts = _tmp1_;
	_tmp2_ = settings;
	if (g_settings_get_boolean (_tmp2_, "ignore-whitespace")) {
		GgitDiffOptions* _tmp3_;
		GgitDiffOptions* _tmp4_;
		GgitDiffOption _tmp5_;
		GgitDiffOption _tmp6_;
		_tmp3_ = opts;
		_tmp4_ = opts;
		_tmp5_ = ggit_diff_options_get_flags (_tmp4_);
		_tmp6_ = _tmp5_;
		ggit_diff_options_set_flags (_tmp4_, _tmp6_ | GGIT_DIFF_IGNORE_WHITESPACE);
	}
	_tmp7_ = settings;
	if (g_settings_get_boolean (_tmp7_, "patience")) {
		GgitDiffOptions* _tmp8_;
		GgitDiffOptions* _tmp9_;
		GgitDiffOption _tmp10_;
		GgitDiffOption _tmp11_;
		_tmp8_ = opts;
		_tmp9_ = opts;
		_tmp10_ = ggit_diff_options_get_flags (_tmp9_);
		_tmp11_ = _tmp10_;
		ggit_diff_options_set_flags (_tmp9_, _tmp11_ | GGIT_DIFF_PATIENCE);
	}
	_tmp12_ = settings;
	nc = g_settings_get_int (_tmp12_, "context-lines");
	_tmp13_ = opts;
	ggit_diff_options_set_n_context_lines (_tmp13_, nc);
	_tmp14_ = opts;
	ggit_diff_options_set_n_interhunk_lines (_tmp14_, nc);
	_tmp15_ = opts;
	_tmp16_ = opts;
	_tmp17_ = ggit_diff_options_get_flags (_tmp16_);
	_tmp18_ = _tmp17_;
	ggit_diff_options_set_flags (_tmp16_, _tmp18_ | GGIT_DIFF_SHOW_BINARY);
	_tmp19_ = gitg_ext_commit_action_get_commit ((GitgExtCommitAction*) self);
	_tmp20_ = _tmp19_;
	_tmp21_ = opts;
	_tmp22_ = gitg_commit_get_diff (_tmp20_, _tmp21_, 0);
	result = _tmp22_;
	_g_object_unref0 (opts);
	_g_object_unref0 (settings);
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
_vala_GgitOId_free (GgitOId* self)
{
	g_boxed_free (ggit_oid_get_type (), self);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
gitg_commit_action_create_patch_create_patch (GitgCommitActionCreatePatch* self,
                                              GFile* file,
                                              GError** error)
{
	GgitDiff* _tmp0_;
	GgitDiffFormatEmailOptions* opts = NULL;
	GgitDiffFormatEmailOptions* _tmp3_;
	gchar* message = NULL;
	GitgCommit* _tmp4_;
	GitgCommit* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GgitDiffFormatEmailOptions* _tmp8_;
	const gchar* _tmp9_;
	gint pos = 0;
	const gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GgitDiffFormatEmailOptions* _tmp22_;
	GgitDiffFormatEmailOptions* _tmp23_;
	GgitDiffFormatEmailOptions* _tmp24_;
	GitgCommit* _tmp25_;
	GitgCommit* _tmp26_;
	GgitOId* _tmp27_;
	GgitOId* _tmp28_;
	GgitDiffFormatEmailOptions* _tmp29_;
	GitgCommit* _tmp30_;
	GitgCommit* _tmp31_;
	GgitSignature* _tmp32_;
	GgitSignature* _tmp33_;
	gchar* content = NULL;
	GgitDiff* _tmp34_;
	GgitDiffFormatEmailOptions* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	guint8* _tmp38_;
	gint _tmp38__length1;
	gint _tmp39_ = 0;
	guint8* _tmp40_;
	gint _tmp40__length1;
	const gchar* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->_diff;
	if (_tmp0_ == NULL) {
		GgitDiff* _tmp1_ = NULL;
		GgitDiff* _tmp2_;
		_tmp2_ = gitg_commit_action_create_patch_create_diff_from_commit (self, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
		gitg_commit_action_create_patch_set_diff (self, _tmp1_);
		_g_object_unref0 (_tmp1_);
	}
	_tmp3_ = ggit_diff_format_email_options_new ();
	opts = _tmp3_;
	_tmp4_ = gitg_ext_commit_action_get_commit ((GitgExtCommitAction*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = ggit_commit_get_message ((GgitCommit*) _tmp5_);
	_tmp7_ = g_strdup (_tmp6_);
	message = _tmp7_;
	_tmp8_ = opts;
	_tmp9_ = message;
	ggit_diff_format_email_options_set_summary (_tmp8_, _tmp9_);
	_tmp10_ = message;
	pos = string_index_of_char (_tmp10_, (gunichar) '\n', 0);
	if (pos != -1) {
		const gchar* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp12_ = message;
		_tmp13_ = strlen (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp11_ = (pos + 1) != _tmp14_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		GgitDiffFormatEmailOptions* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp15_ = opts;
		_tmp16_ = message;
		_tmp17_ = message;
		_tmp18_ = strlen (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = string_substring (_tmp16_, (glong) (pos + 2), (glong) (_tmp19_ - (pos + 2)));
		_tmp21_ = _tmp20_;
		ggit_diff_format_email_options_set_body (_tmp15_, _tmp21_);
		_g_free0 (_tmp21_);
	}
	_tmp22_ = opts;
	ggit_diff_format_email_options_set_patch_number (_tmp22_, (guint64) 1);
	_tmp23_ = opts;
	ggit_diff_format_email_options_set_total_patches (_tmp23_, (guint64) 1);
	_tmp24_ = opts;
	_tmp25_ = gitg_ext_commit_action_get_commit ((GitgExtCommitAction*) self);
	_tmp26_ = _tmp25_;
	_tmp27_ = ggit_object_get_id ((GgitObject*) _tmp26_);
	_tmp28_ = _tmp27_;
	ggit_diff_format_email_options_set_id (_tmp24_, _tmp28_);
	__vala_GgitOId_free0 (_tmp28_);
	_tmp29_ = opts;
	_tmp30_ = gitg_ext_commit_action_get_commit ((GitgExtCommitAction*) self);
	_tmp31_ = _tmp30_;
	_tmp32_ = ggit_commit_get_author ((GgitCommit*) _tmp31_);
	_tmp33_ = _tmp32_;
	ggit_diff_format_email_options_set_author (_tmp29_, _tmp33_);
	_g_object_unref0 (_tmp33_);
	_tmp34_ = self->priv->_diff;
	_tmp35_ = opts;
	_tmp36_ = ggit_diff_format_email (_tmp34_, _tmp35_, &_inner_error0_);
	content = _tmp36_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (message);
		_g_object_unref0 (opts);
		return;
	}
	_tmp37_ = content;
	_tmp38_ = string_get_data (_tmp37_, &_tmp39_);
	_tmp38__length1 = _tmp39_;
	_tmp40_ = _tmp38_;
	_tmp40__length1 = _tmp38__length1;
	_tmp41_ = content;
	_tmp42_ = strlen (_tmp41_);
	_tmp43_ = _tmp42_;
	g_file_replace_contents (file, (const char*) (_tmp40_ + 0), (gsize) (_tmp43_ - 0), NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (content);
		_g_free0 (message);
		_g_object_unref0 (opts);
		return;
	}
	_g_free0 (content);
	_g_free0 (message);
	_g_object_unref0 (opts);
}

static Block57Data*
block57_data_ref (Block57Data* _data57_)
{
	g_atomic_int_inc (&_data57_->_ref_count_);
	return _data57_;
}

static void
block57_data_unref (void * _userdata_)
{
	Block57Data* _data57_;
	_data57_ = (Block57Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data57_->_ref_count_)) {
		GitgCommitActionCreatePatch* self;
		self = _data57_->self;
		_g_object_unref0 (_data57_->chooser);
		_g_object_unref0 (self);
		g_slice_free (Block57Data, _data57_);
	}
}

static void
__lambda123_ (Block57Data* _data57_,
              GtkDialog* dialog,
              gint id)
{
	GitgCommitActionCreatePatch* self;
	GError* _inner_error0_ = NULL;
	self = _data57_->self;
	g_return_if_fail (dialog != NULL);
	if (id == ((gint) GTK_RESPONSE_OK)) {
		{
			GFile* _tmp0_;
			GFile* _tmp1_;
			_tmp0_ = gtk_file_chooser_get_file ((GtkFileChooser*) _data57_->chooser);
			_tmp1_ = _tmp0_;
			gitg_commit_action_create_patch_create_patch (self, _tmp1_, &_inner_error0_);
			_g_object_unref0 (_tmp1_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GitgExtApplication* _tmp2_;
			GitgExtApplication* _tmp3_;
			GitgExtApplication* _tmp4_;
			GError* _tmp5_;
			const gchar* _tmp6_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
			_tmp3_ = _tmp2_;
			_tmp4_ = _tmp3_;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			gitg_ext_application_show_infobar (_tmp4_, _ ("Failed to create patch"), _tmp6_, GTK_MESSAGE_ERROR);
			_g_object_unref0 (_tmp4_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	gtk_widget_destroy ((GtkWidget*) _data57_->chooser);
	g_signal_emit_by_name ((GitgExtCommitAction*) self, "finished");
}

static void
___lambda123__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	__lambda123_ (self, _sender, response_id);
}

static void
gitg_commit_action_create_patch_real_activate (GitgCommitActionCreatePatch* self)
{
	Block57Data* _data57_;
	GtkFileChooserDialog* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GitgExtApplication* _tmp11_;
	GitgExtApplication* _tmp12_;
	GtkWindow* _tmp13_;
	GError* _inner_error0_ = NULL;
	_data57_ = g_slice_new0 (Block57Data);
	_data57_->_ref_count_ = 1;
	_data57_->self = g_object_ref (self);
	_tmp0_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Save Patch File"), NULL, GTK_FILE_CHOOSER_ACTION_SAVE, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Save Patch"), GTK_RESPONSE_OK, NULL);
	g_object_ref_sink (_tmp0_);
	_data57_->chooser = _tmp0_;
	gtk_dialog_set_default_response ((GtkDialog*) _data57_->chooser, (gint) GTK_RESPONSE_OK);
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _data57_->chooser, TRUE);
	_tmp1_ = gitg_commit_action_create_patch_patch_filename (self, 1);
	_tmp2_ = _tmp1_;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _data57_->chooser, _tmp2_);
	_g_free0 (_tmp2_);
	{
		GitgExtApplication* _tmp3_;
		GitgExtApplication* _tmp4_;
		GitgExtApplication* _tmp5_;
		GitgRepository* _tmp6_;
		GitgRepository* _tmp7_;
		GitgRepository* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		_tmp3_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = gitg_ext_application_get_repository (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = ggit_repository_get_workdir ((GgitRepository*) _tmp8_);
		_tmp10_ = _tmp9_;
		gtk_file_chooser_set_current_folder_file ((GtkFileChooser*) _data57_->chooser, _tmp10_, &_inner_error0_);
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (_tmp8_);
		_g_object_unref0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block57_data_unref (_data57_);
		_data57_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp11_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
	_tmp12_ = _tmp11_;
	_tmp13_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_window_get_type (), GtkWindow);
	gtk_window_set_transient_for ((GtkWindow*) _data57_->chooser, _tmp13_);
	_g_object_unref0 (_tmp13_);
	gtk_widget_show ((GtkWidget*) _data57_->chooser);
	g_signal_connect_data ((GtkDialog*) _data57_->chooser, "response", (GCallback) ___lambda123__gtk_dialog_response, block57_data_ref (_data57_), (GClosureNotify) block57_data_unref, 0);
	block57_data_unref (_data57_);
	_data57_ = NULL;
}

void
gitg_commit_action_create_patch_activate (GitgCommitActionCreatePatch* self)
{
	GitgCommitActionCreatePatchClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = GITG_COMMIT_ACTION_CREATE_PATCH_GET_CLASS (self);
	if (_klass_->activate) {
		_klass_->activate (self);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GitgExtApplication*
gitg_commit_action_create_patch_real_get_application (GitgExtUIElement* base)
{
	GitgExtApplication* result;
	GitgCommitActionCreatePatch* self;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	self = (GitgCommitActionCreatePatch*) base;
	_tmp0_ = self->priv->_application;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
gitg_commit_action_create_patch_real_set_application (GitgExtUIElement* base,
                                                      GitgExtApplication* value)
{
	GitgCommitActionCreatePatch* self;
	GitgExtApplication* old_value;
	self = (GitgCommitActionCreatePatch*) base;
	old_value = gitg_commit_action_create_patch_real_get_application (base);
	if (old_value != value) {
		GitgExtApplication* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_application);
		self->priv->_application = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_commit_action_create_patch_properties[GITG_COMMIT_ACTION_CREATE_PATCH_APPLICATION_PROPERTY]);
	}
	_g_object_unref0 (old_value);
}

static GitgExtRefActionInterface*
gitg_commit_action_create_patch_real_get_action_interface (GitgExtCommitAction* base)
{
	GitgExtRefActionInterface* result;
	GitgCommitActionCreatePatch* self;
	GitgExtRefActionInterface* _tmp0_;
	self = (GitgCommitActionCreatePatch*) base;
	_tmp0_ = self->priv->_action_interface;
	result = _tmp0_;
	return result;
}

static void
gitg_commit_action_create_patch_real_set_action_interface (GitgExtCommitAction* base,
                                                           GitgExtRefActionInterface* value)
{
	GitgCommitActionCreatePatch* self;
	GitgExtRefActionInterface* old_value;
	self = (GitgCommitActionCreatePatch*) base;
	old_value = gitg_commit_action_create_patch_real_get_action_interface (base);
	if (old_value != value) {
		GitgExtRefActionInterface* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_action_interface);
		self->priv->_action_interface = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_commit_action_create_patch_properties[GITG_COMMIT_ACTION_CREATE_PATCH_ACTION_INTERFACE_PROPERTY]);
	}
}

static GitgCommit*
gitg_commit_action_create_patch_real_get_commit (GitgExtCommitAction* base)
{
	GitgCommit* result;
	GitgCommitActionCreatePatch* self;
	GitgCommit* _tmp0_;
	self = (GitgCommitActionCreatePatch*) base;
	_tmp0_ = self->priv->_commit;
	result = _tmp0_;
	return result;
}

static void
gitg_commit_action_create_patch_real_set_commit (GitgExtCommitAction* base,
                                                 GitgCommit* value)
{
	GitgCommitActionCreatePatch* self;
	GitgCommit* old_value;
	self = (GitgCommitActionCreatePatch*) base;
	old_value = gitg_commit_action_create_patch_real_get_commit (base);
	if (old_value != value) {
		GitgCommit* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_commit);
		self->priv->_commit = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_commit_action_create_patch_properties[GITG_COMMIT_ACTION_CREATE_PATCH_COMMIT_PROPERTY]);
	}
}

GgitDiff*
gitg_commit_action_create_patch_get_diff (GitgCommitActionCreatePatch* self)
{
	GgitDiff* result;
	GgitDiff* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_diff;
	result = _tmp0_;
	return result;
}

void
gitg_commit_action_create_patch_set_diff (GitgCommitActionCreatePatch* self,
                                          GgitDiff* value)
{
	GgitDiff* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_commit_action_create_patch_get_diff (self);
	if (old_value != value) {
		GgitDiff* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_diff);
		self->priv->_diff = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_commit_action_create_patch_properties[GITG_COMMIT_ACTION_CREATE_PATCH_DIFF_PROPERTY]);
	}
}

gchar*
gitg_commit_action_create_patch_get_id (GitgCommitActionCreatePatch* self)
{
	GitgCommitActionCreatePatchClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = GITG_COMMIT_ACTION_CREATE_PATCH_GET_CLASS (self);
	if (_klass_->get_id) {
		return _klass_->get_id (self);
	}
	return NULL;
}

static gchar*
gitg_commit_action_create_patch_real_get_id (GitgCommitActionCreatePatch* base)
{
	gchar* result;
	GitgCommitActionCreatePatch* self;
	gchar* _tmp0_;
	self = base;
	_tmp0_ = g_strdup ("/org/gnome/gitg/commit-actions/create-patch");
	result = _tmp0_;
	return result;
}

static gchar*
gitg_commit_action_create_patch_real_get_display_name (GitgExtUIElement* base)
{
	gchar* result;
	GitgCommitActionCreatePatch* self;
	gchar* _tmp0_;
	self = (GitgCommitActionCreatePatch*) base;
	_tmp0_ = g_strdup (_ ("Create patch"));
	result = _tmp0_;
	return result;
}

gchar*
gitg_commit_action_create_patch_get_description (GitgCommitActionCreatePatch* self)
{
	GitgCommitActionCreatePatchClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = GITG_COMMIT_ACTION_CREATE_PATCH_GET_CLASS (self);
	if (_klass_->get_description) {
		return _klass_->get_description (self);
	}
	return NULL;
}

static gchar*
gitg_commit_action_create_patch_real_get_description (GitgCommitActionCreatePatch* base)
{
	gchar* result;
	GitgCommitActionCreatePatch* self;
	gchar* _tmp0_;
	self = base;
	_tmp0_ = g_strdup (_ ("Create a patch from the selected commit"));
	result = _tmp0_;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
gitg_commit_action_create_patch_class_init (GitgCommitActionCreatePatchClass * klass,
                                            gpointer klass_data)
{
	GError* _inner_error0_ = NULL;
	gitg_commit_action_create_patch_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgCommitActionCreatePatch_private_offset);
	((GitgCommitActionCreatePatchClass *) klass)->activate = (void (*) (GitgCommitActionCreatePatch*)) gitg_commit_action_create_patch_real_activate;
	GITG_COMMIT_ACTION_CREATE_PATCH_CLASS (klass)->get_id = (gchar* (*) (GitgCommitActionCreatePatch*)) gitg_commit_action_create_patch_real_get_id;
	GITG_COMMIT_ACTION_CREATE_PATCH_CLASS (klass)->get_description = (gchar* (*) (GitgCommitActionCreatePatch*)) gitg_commit_action_create_patch_real_get_description;
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_commit_action_create_patch_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_commit_action_create_patch_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_commit_action_create_patch_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_ACTION_CREATE_PATCH_APPLICATION_PROPERTY, gitg_commit_action_create_patch_properties[GITG_COMMIT_ACTION_CREATE_PATCH_APPLICATION_PROPERTY] = g_param_spec_object ("application", "application", "application", GITG_EXT_TYPE_APPLICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_ACTION_CREATE_PATCH_ACTION_INTERFACE_PROPERTY, gitg_commit_action_create_patch_properties[GITG_COMMIT_ACTION_CREATE_PATCH_ACTION_INTERFACE_PROPERTY] = g_param_spec_object ("action-interface", "action-interface", "action-interface", GITG_EXT_TYPE_REF_ACTION_INTERFACE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_ACTION_CREATE_PATCH_COMMIT_PROPERTY, gitg_commit_action_create_patch_properties[GITG_COMMIT_ACTION_CREATE_PATCH_COMMIT_PROPERTY] = g_param_spec_object ("commit", "commit", "commit", GITG_TYPE_COMMIT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_ACTION_CREATE_PATCH_DIFF_PROPERTY, gitg_commit_action_create_patch_properties[GITG_COMMIT_ACTION_CREATE_PATCH_DIFF_PROPERTY] = g_param_spec_object ("diff", "diff", "diff", ggit_diff_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_ACTION_CREATE_PATCH_ID_PROPERTY, gitg_commit_action_create_patch_properties[GITG_COMMIT_ACTION_CREATE_PATCH_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_ACTION_CREATE_PATCH_DISPLAY_NAME_PROPERTY, gitg_commit_action_create_patch_properties[GITG_COMMIT_ACTION_CREATE_PATCH_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_ACTION_CREATE_PATCH_DESCRIPTION_PROPERTY, gitg_commit_action_create_patch_properties[GITG_COMMIT_ACTION_CREATE_PATCH_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		_tmp1_ = g_regex_new ("[^\\d\\w \\_\\-]", 0, 0, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (gitg_commit_action_create_patch_s_subject_regex);
		gitg_commit_action_create_patch_s_subject_regex = _tmp2_;
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = string_to_string (_tmp5_);
		_tmp7_ = g_strconcat ("Failed to compile subject regex: ", _tmp6_, "\n", NULL);
		_tmp8_ = _tmp7_;
		fprintf (_tmp3_, "%s", _tmp8_);
		_g_free0 (_tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
}

static void
gitg_commit_action_create_patch_gitg_ext_ui_element_interface_init (GitgExtUIElementIface * iface,
                                                                    gpointer iface_data)
{
	gitg_commit_action_create_patch_gitg_ext_ui_element_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*) (GitgExtUIElement*)) gitg_commit_action_create_patch_activate;
	iface->get_application = gitg_commit_action_create_patch_real_get_application;
	iface->set_application = gitg_commit_action_create_patch_real_set_application;
	iface->get_id = (gchar* (*) (GitgExtUIElement*)) gitg_commit_action_create_patch_get_id;
	iface->get_display_name = gitg_commit_action_create_patch_real_get_display_name;
	iface->get_description = (gchar* (*) (GitgExtUIElement*)) gitg_commit_action_create_patch_get_description;
}

static void
gitg_commit_action_create_patch_gitg_ext_action_interface_init (GitgExtActionIface * iface,
                                                                gpointer iface_data)
{
	gitg_commit_action_create_patch_gitg_ext_action_parent_iface = g_type_interface_peek_parent (iface);
}

static void
gitg_commit_action_create_patch_gitg_ext_commit_action_interface_init (GitgExtCommitActionIface * iface,
                                                                       gpointer iface_data)
{
	gitg_commit_action_create_patch_gitg_ext_commit_action_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_action_interface = gitg_commit_action_create_patch_real_get_action_interface;
	iface->set_action_interface = gitg_commit_action_create_patch_real_set_action_interface;
	iface->get_commit = gitg_commit_action_create_patch_real_get_commit;
	iface->set_commit = gitg_commit_action_create_patch_real_set_commit;
}

static void
gitg_commit_action_create_patch_instance_init (GitgCommitActionCreatePatch * self,
                                               gpointer klass)
{
	self->priv = gitg_commit_action_create_patch_get_instance_private (self);
}

static void
gitg_commit_action_create_patch_finalize (GObject * obj)
{
	GitgCommitActionCreatePatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_COMMIT_ACTION_CREATE_PATCH, GitgCommitActionCreatePatch);
	_g_object_unref0 (self->priv->_application);
	_g_object_unref0 (self->priv->_action_interface);
	_g_object_unref0 (self->priv->_commit);
	_g_object_unref0 (self->priv->_diff);
	G_OBJECT_CLASS (gitg_commit_action_create_patch_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_commit_action_create_patch_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgCommitActionCreatePatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_commit_action_create_patch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgCommitActionCreatePatch), 0, (GInstanceInitFunc) gitg_commit_action_create_patch_instance_init, NULL };
	static const GInterfaceInfo gitg_ext_ui_element_info = { (GInterfaceInitFunc) gitg_commit_action_create_patch_gitg_ext_ui_element_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gitg_ext_action_info = { (GInterfaceInitFunc) gitg_commit_action_create_patch_gitg_ext_action_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gitg_ext_commit_action_info = { (GInterfaceInitFunc) gitg_commit_action_create_patch_gitg_ext_commit_action_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gitg_commit_action_create_patch_type_id;
	gitg_commit_action_create_patch_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgCommitActionCreatePatch", &g_define_type_info, 0);
	g_type_add_interface_static (gitg_commit_action_create_patch_type_id, GITG_EXT_TYPE_UI_ELEMENT, &gitg_ext_ui_element_info);
	g_type_add_interface_static (gitg_commit_action_create_patch_type_id, GITG_EXT_TYPE_ACTION, &gitg_ext_action_info);
	g_type_add_interface_static (gitg_commit_action_create_patch_type_id, GITG_EXT_TYPE_COMMIT_ACTION, &gitg_ext_commit_action_info);
	GitgCommitActionCreatePatch_private_offset = g_type_add_instance_private (gitg_commit_action_create_patch_type_id, sizeof (GitgCommitActionCreatePatchPrivate));
	return gitg_commit_action_create_patch_type_id;
}

GType
gitg_commit_action_create_patch_get_type (void)
{
	static gsize gitg_commit_action_create_patch_type_id__once = 0;
	if (g_once_init_enter (&gitg_commit_action_create_patch_type_id__once)) {
		GType gitg_commit_action_create_patch_type_id;
		gitg_commit_action_create_patch_type_id = gitg_commit_action_create_patch_get_type_once ();
		g_once_init_leave (&gitg_commit_action_create_patch_type_id__once, gitg_commit_action_create_patch_type_id);
	}
	return gitg_commit_action_create_patch_type_id__once;
}

static void
_vala_gitg_commit_action_create_patch_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	GitgCommitActionCreatePatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_COMMIT_ACTION_CREATE_PATCH, GitgCommitActionCreatePatch);
	switch (property_id) {
		case GITG_COMMIT_ACTION_CREATE_PATCH_APPLICATION_PROPERTY:
		g_value_take_object (value, gitg_ext_ui_element_get_application ((GitgExtUIElement*) self));
		break;
		case GITG_COMMIT_ACTION_CREATE_PATCH_ACTION_INTERFACE_PROPERTY:
		g_value_set_object (value, gitg_ext_commit_action_get_action_interface ((GitgExtCommitAction*) self));
		break;
		case GITG_COMMIT_ACTION_CREATE_PATCH_COMMIT_PROPERTY:
		g_value_set_object (value, gitg_ext_commit_action_get_commit ((GitgExtCommitAction*) self));
		break;
		case GITG_COMMIT_ACTION_CREATE_PATCH_DIFF_PROPERTY:
		g_value_set_object (value, gitg_commit_action_create_patch_get_diff (self));
		break;
		case GITG_COMMIT_ACTION_CREATE_PATCH_ID_PROPERTY:
		g_value_take_string (value, gitg_commit_action_create_patch_get_id (self));
		break;
		case GITG_COMMIT_ACTION_CREATE_PATCH_DISPLAY_NAME_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_display_name ((GitgExtUIElement*) self));
		break;
		case GITG_COMMIT_ACTION_CREATE_PATCH_DESCRIPTION_PROPERTY:
		g_value_take_string (value, gitg_commit_action_create_patch_get_description (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_commit_action_create_patch_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	GitgCommitActionCreatePatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_COMMIT_ACTION_CREATE_PATCH, GitgCommitActionCreatePatch);
	switch (property_id) {
		case GITG_COMMIT_ACTION_CREATE_PATCH_APPLICATION_PROPERTY:
		gitg_ext_ui_element_set_application ((GitgExtUIElement*) self, g_value_get_object (value));
		break;
		case GITG_COMMIT_ACTION_CREATE_PATCH_ACTION_INTERFACE_PROPERTY:
		gitg_ext_commit_action_set_action_interface ((GitgExtCommitAction*) self, g_value_get_object (value));
		break;
		case GITG_COMMIT_ACTION_CREATE_PATCH_COMMIT_PROPERTY:
		gitg_ext_commit_action_set_commit ((GitgExtCommitAction*) self, g_value_get_object (value));
		break;
		case GITG_COMMIT_ACTION_CREATE_PATCH_DIFF_PROPERTY:
		gitg_commit_action_create_patch_set_diff (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

