/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "cc-realm-generated.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_string,
        GVariant *arg_options,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_variant (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_VOID__STRING_STRING (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringStringFunc)
       (void *data1,
        const gchar *arg_data,
        const gchar *arg_operation,
        void *data2);
  _GDbusCodegenMarshalVoid_StringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_string (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_operation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_options,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOXED_BOXED_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringBoxedBoxedVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_login_policy,
        const gchar *const *arg_permitted_add,
        const gchar *const *arg_permitted_remove,
        GVariant *arg_options,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringBoxedBoxedVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringBoxedBoxedVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_boxed (param_values + 3),
              g_marshal_value_peek_boxed (param_values + 4),
              g_marshal_value_peek_variant (param_values + 5),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_credentials,
        GVariant *arg_options,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              g_marshal_value_peek_variant (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.realmd.Provider
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:CcRealmProvider
 * @title: CcRealmProvider
 * @short_description: Generated C code for the org.freedesktop.realmd.Provider D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-realmd-Provider.top_of_page">org.freedesktop.realmd.Provider</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.realmd.Provider ---- */

static const _ExtendedGDBusArgInfo _cc_realm_provider_method_info_discover_IN_ARG_string =
{
  {
    -1,
    (gchar *) "string",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _cc_realm_provider_method_info_discover_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _cc_realm_provider_method_info_discover_IN_ARG_pointers[] =
{
  &_cc_realm_provider_method_info_discover_IN_ARG_string.parent_struct,
  &_cc_realm_provider_method_info_discover_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _cc_realm_provider_method_info_discover_OUT_ARG_relevance =
{
  {
    -1,
    (gchar *) "relevance",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _cc_realm_provider_method_info_discover_OUT_ARG_realm =
{
  {
    -1,
    (gchar *) "realm",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _cc_realm_provider_method_info_discover_OUT_ARG_pointers[] =
{
  &_cc_realm_provider_method_info_discover_OUT_ARG_relevance.parent_struct,
  &_cc_realm_provider_method_info_discover_OUT_ARG_realm.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _cc_realm_provider_method_info_discover =
{
  {
    -1,
    (gchar *) "Discover",
    (GDBusArgInfo **) &_cc_realm_provider_method_info_discover_IN_ARG_pointers,
    (GDBusArgInfo **) &_cc_realm_provider_method_info_discover_OUT_ARG_pointers,
    NULL
  },
  "handle-discover",
  FALSE
};

static const GDBusMethodInfo * const _cc_realm_provider_method_info_pointers[] =
{
  &_cc_realm_provider_method_info_discover.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _cc_realm_provider_property_info_name =
{
  {
    -1,
    (gchar *) "Name",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _cc_realm_provider_property_info_version =
{
  {
    -1,
    (gchar *) "Version",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _cc_realm_provider_property_info_realms =
{
  {
    -1,
    (gchar *) "Realms",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "realms",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _cc_realm_provider_property_info_pointers[] =
{
  &_cc_realm_provider_property_info_name.parent_struct,
  &_cc_realm_provider_property_info_version.parent_struct,
  &_cc_realm_provider_property_info_realms.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _cc_realm_provider_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.realmd.Provider",
    (GDBusMethodInfo **) &_cc_realm_provider_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_cc_realm_provider_property_info_pointers,
    NULL
  },
  "provider",
};


/**
 * cc_realm_provider_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-realmd-Provider.top_of_page">org.freedesktop.realmd.Provider</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
cc_realm_provider_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_cc_realm_provider_interface_info.parent_struct;
}

/**
 * cc_realm_provider_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #CcRealmProvider interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
cc_realm_provider_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "name");
  g_object_class_override_property (klass, property_id_begin++, "version");
  g_object_class_override_property (klass, property_id_begin++, "realms");
  return property_id_begin - 1;
}


inline static void
cc_realm_provider_method_marshal_discover (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * CcRealmProvider:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Provider.top_of_page">org.freedesktop.realmd.Provider</link>.
 */

/**
 * CcRealmProviderIface:
 * @parent_iface: The parent interface.
 * @handle_discover: Handler for the #CcRealmProvider::handle-discover signal.
 * @get_name: Getter for the #CcRealmProvider:name property.
 * @get_realms: Getter for the #CcRealmProvider:realms property.
 * @get_version: Getter for the #CcRealmProvider:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Provider.top_of_page">org.freedesktop.realmd.Provider</link>.
 */

typedef CcRealmProviderIface CcRealmProviderInterface;
G_DEFINE_INTERFACE (CcRealmProvider, cc_realm_provider, G_TYPE_OBJECT)

static void
cc_realm_provider_default_init (CcRealmProviderIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * CcRealmProvider::handle-discover:
   * @object: A #CcRealmProvider.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_string: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-realmd-Provider.Discover">Discover()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cc_realm_provider_complete_discover() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-discover",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CcRealmProviderIface, handle_discover),
    g_signal_accumulator_true_handled,
    NULL,
      cc_realm_provider_method_marshal_discover,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * CcRealmProvider:name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Name">"Name"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("name", "Name", "Name", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CcRealmProvider:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Version">"Version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("version", "Version", "Version", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CcRealmProvider:realms:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Realms">"Realms"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("realms", "Realms", "Realms", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * cc_realm_provider_get_name: (skip)
 * @object: A #CcRealmProvider.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use cc_realm_provider_dup_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
cc_realm_provider_get_name (CcRealmProvider *object)
{
  g_return_val_if_fail (CC_REALM_IS_PROVIDER (object), NULL);

  return CC_REALM_PROVIDER_GET_IFACE (object)->get_name (object);
}

/**
 * cc_realm_provider_dup_name: (skip)
 * @object: A #CcRealmProvider.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
cc_realm_provider_dup_name (CcRealmProvider *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "name", &value, NULL);
  return value;
}

/**
 * cc_realm_provider_set_name: (skip)
 * @object: A #CcRealmProvider.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Name">"Name"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cc_realm_provider_set_name (CcRealmProvider *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "name", value, NULL);
}

/**
 * cc_realm_provider_get_version: (skip)
 * @object: A #CcRealmProvider.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Version">"Version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use cc_realm_provider_dup_version() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
cc_realm_provider_get_version (CcRealmProvider *object)
{
  g_return_val_if_fail (CC_REALM_IS_PROVIDER (object), NULL);

  return CC_REALM_PROVIDER_GET_IFACE (object)->get_version (object);
}

/**
 * cc_realm_provider_dup_version: (skip)
 * @object: A #CcRealmProvider.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Version">"Version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
cc_realm_provider_dup_version (CcRealmProvider *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "version", &value, NULL);
  return value;
}

/**
 * cc_realm_provider_set_version: (skip)
 * @object: A #CcRealmProvider.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Version">"Version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cc_realm_provider_set_version (CcRealmProvider *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * cc_realm_provider_get_realms: (skip)
 * @object: A #CcRealmProvider.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Realms">"Realms"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use cc_realm_provider_dup_realms() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
cc_realm_provider_get_realms (CcRealmProvider *object)
{
  g_return_val_if_fail (CC_REALM_IS_PROVIDER (object), NULL);

  return CC_REALM_PROVIDER_GET_IFACE (object)->get_realms (object);
}

/**
 * cc_realm_provider_dup_realms: (skip)
 * @object: A #CcRealmProvider.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Realms">"Realms"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
cc_realm_provider_dup_realms (CcRealmProvider *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "realms", &value, NULL);
  return value;
}

/**
 * cc_realm_provider_set_realms: (skip)
 * @object: A #CcRealmProvider.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Realms">"Realms"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cc_realm_provider_set_realms (CcRealmProvider *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "realms", value, NULL);
}

/**
 * cc_realm_provider_call_discover:
 * @proxy: A #CcRealmProviderProxy.
 * @arg_string: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Provider.Discover">Discover()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_realm_provider_call_discover_finish() to get the result of the operation.
 *
 * See cc_realm_provider_call_discover_sync() for the synchronous, blocking version of this method.
 */
void
cc_realm_provider_call_discover (
    CcRealmProvider *proxy,
    const gchar *arg_string,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Discover",
    g_variant_new ("(s@a{sv})",
                   arg_string,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cc_realm_provider_call_discover_finish:
 * @proxy: A #CcRealmProviderProxy.
 * @out_relevance: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_realm: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_realm_provider_call_discover().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cc_realm_provider_call_discover().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cc_realm_provider_call_discover_finish (
    CcRealmProvider *proxy,
    gint *out_relevance,
    gchar ***out_realm,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i^ao)",
                 out_relevance,
                 out_realm);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cc_realm_provider_call_discover_sync:
 * @proxy: A #CcRealmProviderProxy.
 * @arg_string: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_relevance: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_realm: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Provider.Discover">Discover()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cc_realm_provider_call_discover() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cc_realm_provider_call_discover_sync (
    CcRealmProvider *proxy,
    const gchar *arg_string,
    GVariant *arg_options,
    gint *out_relevance,
    gchar ***out_realm,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Discover",
    g_variant_new ("(s@a{sv})",
                   arg_string,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i^ao)",
                 out_relevance,
                 out_realm);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cc_realm_provider_complete_discover:
 * @object: A #CcRealmProvider.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @relevance: Parameter to return.
 * @realm: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-realmd-Provider.Discover">Discover()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cc_realm_provider_complete_discover (
    CcRealmProvider *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint relevance,
    const gchar *const *realm)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i^ao)",
                   relevance,
                   realm));
}

/* ------------------------------------------------------------------------ */

/**
 * CcRealmProviderProxy:
 *
 * The #CcRealmProviderProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CcRealmProviderProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CcRealmProviderProxy.
 */

struct _CcRealmProviderProxyPrivate
{
  GData *qdata;
};

static void cc_realm_provider_proxy_iface_init (CcRealmProviderIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CcRealmProviderProxy, cc_realm_provider_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (CcRealmProviderProxy)
                         G_IMPLEMENT_INTERFACE (CC_REALM_TYPE_PROVIDER, cc_realm_provider_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CcRealmProviderProxy, cc_realm_provider_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (CC_REALM_TYPE_PROVIDER, cc_realm_provider_proxy_iface_init))

#endif
static void
cc_realm_provider_proxy_finalize (GObject *object)
{
  CcRealmProviderProxy *proxy = CC_REALM_PROVIDER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (cc_realm_provider_proxy_parent_class)->finalize (object);
}

static void
cc_realm_provider_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _cc_realm_provider_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
cc_realm_provider_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.realmd.Provider: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
cc_realm_provider_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _cc_realm_provider_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.realmd.Provider", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) cc_realm_provider_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
cc_realm_provider_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_cc_realm_provider_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], CC_REALM_TYPE_PROVIDER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CC_REALM_TYPE_PROVIDER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
cc_realm_provider_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  CcRealmProviderProxy *proxy = CC_REALM_PROVIDER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_realm_provider_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_realm_provider_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
cc_realm_provider_proxy_get_name (CcRealmProvider *object)
{
  CcRealmProviderProxy *proxy = CC_REALM_PROVIDER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Name");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
cc_realm_provider_proxy_get_version (CcRealmProvider *object)
{
  CcRealmProviderProxy *proxy = CC_REALM_PROVIDER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Version");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
cc_realm_provider_proxy_get_realms (CcRealmProvider *object)
{
  CcRealmProviderProxy *proxy = CC_REALM_PROVIDER_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Realms");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Realms");
  if (variant != NULL)
    {
      value = g_variant_get_objv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Realms", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static void
cc_realm_provider_proxy_init (CcRealmProviderProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = cc_realm_provider_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, CC_REALM_TYPE_PROVIDER_PROXY, CcRealmProviderProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), cc_realm_provider_interface_info ());
}

static void
cc_realm_provider_proxy_class_init (CcRealmProviderProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = cc_realm_provider_proxy_finalize;
  gobject_class->get_property = cc_realm_provider_proxy_get_property;
  gobject_class->set_property = cc_realm_provider_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = cc_realm_provider_proxy_g_signal;
  proxy_class->g_properties_changed = cc_realm_provider_proxy_g_properties_changed;

  cc_realm_provider_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CcRealmProviderProxyPrivate));
#endif
}

static void
cc_realm_provider_proxy_iface_init (CcRealmProviderIface *iface)
{
  iface->get_name = cc_realm_provider_proxy_get_name;
  iface->get_version = cc_realm_provider_proxy_get_version;
  iface->get_realms = cc_realm_provider_proxy_get_realms;
}

/**
 * cc_realm_provider_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Provider.top_of_page">org.freedesktop.realmd.Provider</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_realm_provider_proxy_new_finish() to get the result of the operation.
 *
 * See cc_realm_provider_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
cc_realm_provider_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CC_REALM_TYPE_PROVIDER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Provider", NULL);
}

/**
 * cc_realm_provider_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_realm_provider_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with cc_realm_provider_proxy_new().
 *
 * Returns: (transfer full) (type CcRealmProviderProxy): The constructed proxy object or %NULL if @error is set.
 */
CcRealmProvider *
cc_realm_provider_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CC_REALM_PROVIDER (ret);
  else
    return NULL;
}

/**
 * cc_realm_provider_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Provider.top_of_page">org.freedesktop.realmd.Provider</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See cc_realm_provider_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CcRealmProviderProxy): The constructed proxy object or %NULL if @error is set.
 */
CcRealmProvider *
cc_realm_provider_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CC_REALM_TYPE_PROVIDER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Provider", NULL);
  if (ret != NULL)
    return CC_REALM_PROVIDER (ret);
  else
    return NULL;
}


/**
 * cc_realm_provider_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like cc_realm_provider_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_realm_provider_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See cc_realm_provider_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
cc_realm_provider_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CC_REALM_TYPE_PROVIDER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Provider", NULL);
}

/**
 * cc_realm_provider_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_realm_provider_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with cc_realm_provider_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type CcRealmProviderProxy): The constructed proxy object or %NULL if @error is set.
 */
CcRealmProvider *
cc_realm_provider_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CC_REALM_PROVIDER (ret);
  else
    return NULL;
}

/**
 * cc_realm_provider_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like cc_realm_provider_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See cc_realm_provider_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CcRealmProviderProxy): The constructed proxy object or %NULL if @error is set.
 */
CcRealmProvider *
cc_realm_provider_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CC_REALM_TYPE_PROVIDER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Provider", NULL);
  if (ret != NULL)
    return CC_REALM_PROVIDER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * CcRealmProviderSkeleton:
 *
 * The #CcRealmProviderSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CcRealmProviderSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CcRealmProviderSkeleton.
 */

struct _CcRealmProviderSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_cc_realm_provider_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  CcRealmProviderSkeleton *skeleton = CC_REALM_PROVIDER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], CC_REALM_TYPE_PROVIDER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CC_REALM_TYPE_PROVIDER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_cc_realm_provider_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  CcRealmProviderSkeleton *skeleton = CC_REALM_PROVIDER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_realm_provider_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_cc_realm_provider_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  CcRealmProviderSkeleton *skeleton = CC_REALM_PROVIDER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_realm_provider_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _cc_realm_provider_skeleton_vtable =
{
  _cc_realm_provider_skeleton_handle_method_call,
  _cc_realm_provider_skeleton_handle_get_property,
  _cc_realm_provider_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
cc_realm_provider_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return cc_realm_provider_interface_info ();
}

static GDBusInterfaceVTable *
cc_realm_provider_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_cc_realm_provider_skeleton_vtable;
}

static GVariant *
cc_realm_provider_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  CcRealmProviderSkeleton *skeleton = CC_REALM_PROVIDER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_cc_realm_provider_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _cc_realm_provider_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _cc_realm_provider_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _cc_realm_provider_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.realmd.Provider", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _cc_realm_provider_emit_changed (gpointer user_data);

static void
cc_realm_provider_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  CcRealmProviderSkeleton *skeleton = CC_REALM_PROVIDER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _cc_realm_provider_emit_changed (skeleton);
}

static void cc_realm_provider_skeleton_iface_init (CcRealmProviderIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CcRealmProviderSkeleton, cc_realm_provider_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (CcRealmProviderSkeleton)
                         G_IMPLEMENT_INTERFACE (CC_REALM_TYPE_PROVIDER, cc_realm_provider_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CcRealmProviderSkeleton, cc_realm_provider_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (CC_REALM_TYPE_PROVIDER, cc_realm_provider_skeleton_iface_init))

#endif
static void
cc_realm_provider_skeleton_finalize (GObject *object)
{
  CcRealmProviderSkeleton *skeleton = CC_REALM_PROVIDER_SKELETON (object);
  guint n;
  for (n = 0; n < 3; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (cc_realm_provider_skeleton_parent_class)->finalize (object);
}

static void
cc_realm_provider_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  CcRealmProviderSkeleton *skeleton = CC_REALM_PROVIDER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_cc_realm_provider_emit_changed (gpointer user_data)
{
  CcRealmProviderSkeleton *skeleton = CC_REALM_PROVIDER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.realmd.Provider",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_cc_realm_provider_schedule_emit_changed (CcRealmProviderSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
cc_realm_provider_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  CcRealmProviderSkeleton *skeleton = CC_REALM_PROVIDER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _cc_realm_provider_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _cc_realm_provider_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
cc_realm_provider_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  CcRealmProviderSkeleton *skeleton = CC_REALM_PROVIDER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _cc_realm_provider_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _cc_realm_provider_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
cc_realm_provider_skeleton_init (CcRealmProviderSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = cc_realm_provider_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, CC_REALM_TYPE_PROVIDER_SKELETON, CcRealmProviderSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 3);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRV);
}

static const gchar *
cc_realm_provider_skeleton_get_name (CcRealmProvider *object)
{
  CcRealmProviderSkeleton *skeleton = CC_REALM_PROVIDER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
cc_realm_provider_skeleton_get_version (CcRealmProvider *object)
{
  CcRealmProviderSkeleton *skeleton = CC_REALM_PROVIDER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
cc_realm_provider_skeleton_get_realms (CcRealmProvider *object)
{
  CcRealmProviderSkeleton *skeleton = CC_REALM_PROVIDER_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
cc_realm_provider_skeleton_class_init (CcRealmProviderSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = cc_realm_provider_skeleton_finalize;
  gobject_class->get_property = cc_realm_provider_skeleton_get_property;
  gobject_class->set_property = cc_realm_provider_skeleton_set_property;
  gobject_class->notify       = cc_realm_provider_skeleton_notify;


  cc_realm_provider_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = cc_realm_provider_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = cc_realm_provider_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = cc_realm_provider_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = cc_realm_provider_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CcRealmProviderSkeletonPrivate));
#endif
}

static void
cc_realm_provider_skeleton_iface_init (CcRealmProviderIface *iface)
{
  iface->get_name = cc_realm_provider_skeleton_get_name;
  iface->get_version = cc_realm_provider_skeleton_get_version;
  iface->get_realms = cc_realm_provider_skeleton_get_realms;
}

/**
 * cc_realm_provider_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Provider.top_of_page">org.freedesktop.realmd.Provider</link>.
 *
 * Returns: (transfer full) (type CcRealmProviderSkeleton): The skeleton object.
 */
CcRealmProvider *
cc_realm_provider_skeleton_new (void)
{
  return CC_REALM_PROVIDER (g_object_new (CC_REALM_TYPE_PROVIDER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.realmd.Service
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:CcRealmService
 * @title: CcRealmService
 * @short_description: Generated C code for the org.freedesktop.realmd.Service D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-realmd-Service.top_of_page">org.freedesktop.realmd.Service</link> D-Bus interface in C.
 */

enum
{
  CC_REALM__SERVICE_DIAGNOSTICS,
};

static unsigned CC_REALM__SERVICE_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.freedesktop.realmd.Service ---- */

static const _ExtendedGDBusArgInfo _cc_realm_service_method_info_cancel_IN_ARG_operation =
{
  {
    -1,
    (gchar *) "operation",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _cc_realm_service_method_info_cancel_IN_ARG_pointers[] =
{
  &_cc_realm_service_method_info_cancel_IN_ARG_operation.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _cc_realm_service_method_info_cancel =
{
  {
    -1,
    (gchar *) "Cancel",
    (GDBusArgInfo **) &_cc_realm_service_method_info_cancel_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-cancel",
  FALSE
};

static const _ExtendedGDBusArgInfo _cc_realm_service_method_info_set_locale_IN_ARG_locale =
{
  {
    -1,
    (gchar *) "locale",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _cc_realm_service_method_info_set_locale_IN_ARG_pointers[] =
{
  &_cc_realm_service_method_info_set_locale_IN_ARG_locale.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _cc_realm_service_method_info_set_locale =
{
  {
    -1,
    (gchar *) "SetLocale",
    (GDBusArgInfo **) &_cc_realm_service_method_info_set_locale_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-locale",
  FALSE
};

static const _ExtendedGDBusMethodInfo _cc_realm_service_method_info_release =
{
  {
    -1,
    (gchar *) "Release",
    NULL,
    NULL,
    NULL
  },
  "handle-release",
  FALSE
};

static const GDBusMethodInfo * const _cc_realm_service_method_info_pointers[] =
{
  &_cc_realm_service_method_info_cancel.parent_struct,
  &_cc_realm_service_method_info_set_locale.parent_struct,
  &_cc_realm_service_method_info_release.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _cc_realm_service_signal_info_diagnostics_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _cc_realm_service_signal_info_diagnostics_ARG_operation =
{
  {
    -1,
    (gchar *) "operation",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _cc_realm_service_signal_info_diagnostics_ARG_pointers[] =
{
  &_cc_realm_service_signal_info_diagnostics_ARG_data.parent_struct,
  &_cc_realm_service_signal_info_diagnostics_ARG_operation.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _cc_realm_service_signal_info_diagnostics =
{
  {
    -1,
    (gchar *) "Diagnostics",
    (GDBusArgInfo **) &_cc_realm_service_signal_info_diagnostics_ARG_pointers,
    NULL
  },
  "diagnostics"
};

static const GDBusSignalInfo * const _cc_realm_service_signal_info_pointers[] =
{
  &_cc_realm_service_signal_info_diagnostics.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _cc_realm_service_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.realmd.Service",
    (GDBusMethodInfo **) &_cc_realm_service_method_info_pointers,
    (GDBusSignalInfo **) &_cc_realm_service_signal_info_pointers,
    NULL,
    NULL
  },
  "service",
};


/**
 * cc_realm_service_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-realmd-Service.top_of_page">org.freedesktop.realmd.Service</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
cc_realm_service_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_cc_realm_service_interface_info.parent_struct;
}

/**
 * cc_realm_service_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #CcRealmService interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
cc_realm_service_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
cc_realm_service_signal_marshal_diagnostics (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cc_realm_service_method_marshal_cancel (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cc_realm_service_method_marshal_set_locale (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cc_realm_service_method_marshal_release (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * CcRealmService:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Service.top_of_page">org.freedesktop.realmd.Service</link>.
 */

/**
 * CcRealmServiceIface:
 * @parent_iface: The parent interface.
 * @handle_cancel: Handler for the #CcRealmService::handle-cancel signal.
 * @handle_release: Handler for the #CcRealmService::handle-release signal.
 * @handle_set_locale: Handler for the #CcRealmService::handle-set-locale signal.
 * @diagnostics: Handler for the #CcRealmService::diagnostics signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Service.top_of_page">org.freedesktop.realmd.Service</link>.
 */

typedef CcRealmServiceIface CcRealmServiceInterface;
G_DEFINE_INTERFACE (CcRealmService, cc_realm_service, G_TYPE_OBJECT)

static void
cc_realm_service_default_init (CcRealmServiceIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * CcRealmService::handle-cancel:
   * @object: A #CcRealmService.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_operation: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-realmd-Service.Cancel">Cancel()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cc_realm_service_complete_cancel() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-cancel",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CcRealmServiceIface, handle_cancel),
    g_signal_accumulator_true_handled,
    NULL,
      cc_realm_service_method_marshal_cancel,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * CcRealmService::handle-set-locale:
   * @object: A #CcRealmService.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_locale: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-realmd-Service.SetLocale">SetLocale()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cc_realm_service_complete_set_locale() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-locale",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CcRealmServiceIface, handle_set_locale),
    g_signal_accumulator_true_handled,
    NULL,
      cc_realm_service_method_marshal_set_locale,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * CcRealmService::handle-release:
   * @object: A #CcRealmService.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-realmd-Service.Release">Release()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cc_realm_service_complete_release() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CcRealmServiceIface, handle_release),
    g_signal_accumulator_true_handled,
    NULL,
      cc_realm_service_method_marshal_release,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * CcRealmService::diagnostics:
   * @object: A #CcRealmService.
   * @arg_data: Argument.
   * @arg_operation: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-realmd-Service.Diagnostics">"Diagnostics"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  CC_REALM__SERVICE_SIGNALS[CC_REALM__SERVICE_DIAGNOSTICS] =
    g_signal_new ("diagnostics",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (CcRealmServiceIface, diagnostics),
      NULL,
      NULL,
      cc_realm_service_signal_marshal_diagnostics,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_STRING);

}

/**
 * cc_realm_service_emit_diagnostics:
 * @object: A #CcRealmService.
 * @arg_data: Argument to pass with the signal.
 * @arg_operation: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-realmd-Service.Diagnostics">"Diagnostics"</link> D-Bus signal.
 */
void
cc_realm_service_emit_diagnostics (
    CcRealmService *object,
    const gchar *arg_data,
    const gchar *arg_operation)
{
  g_signal_emit (object, CC_REALM__SERVICE_SIGNALS[CC_REALM__SERVICE_DIAGNOSTICS], 0, arg_data, arg_operation);
}

/**
 * cc_realm_service_call_cancel:
 * @proxy: A #CcRealmServiceProxy.
 * @arg_operation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Service.Cancel">Cancel()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_realm_service_call_cancel_finish() to get the result of the operation.
 *
 * See cc_realm_service_call_cancel_sync() for the synchronous, blocking version of this method.
 */
void
cc_realm_service_call_cancel (
    CcRealmService *proxy,
    const gchar *arg_operation,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Cancel",
    g_variant_new ("(s)",
                   arg_operation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cc_realm_service_call_cancel_finish:
 * @proxy: A #CcRealmServiceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_realm_service_call_cancel().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cc_realm_service_call_cancel().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cc_realm_service_call_cancel_finish (
    CcRealmService *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cc_realm_service_call_cancel_sync:
 * @proxy: A #CcRealmServiceProxy.
 * @arg_operation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Service.Cancel">Cancel()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cc_realm_service_call_cancel() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cc_realm_service_call_cancel_sync (
    CcRealmService *proxy,
    const gchar *arg_operation,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Cancel",
    g_variant_new ("(s)",
                   arg_operation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cc_realm_service_call_set_locale:
 * @proxy: A #CcRealmServiceProxy.
 * @arg_locale: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Service.SetLocale">SetLocale()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_realm_service_call_set_locale_finish() to get the result of the operation.
 *
 * See cc_realm_service_call_set_locale_sync() for the synchronous, blocking version of this method.
 */
void
cc_realm_service_call_set_locale (
    CcRealmService *proxy,
    const gchar *arg_locale,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetLocale",
    g_variant_new ("(s)",
                   arg_locale),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cc_realm_service_call_set_locale_finish:
 * @proxy: A #CcRealmServiceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_realm_service_call_set_locale().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cc_realm_service_call_set_locale().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cc_realm_service_call_set_locale_finish (
    CcRealmService *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cc_realm_service_call_set_locale_sync:
 * @proxy: A #CcRealmServiceProxy.
 * @arg_locale: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Service.SetLocale">SetLocale()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cc_realm_service_call_set_locale() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cc_realm_service_call_set_locale_sync (
    CcRealmService *proxy,
    const gchar *arg_locale,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetLocale",
    g_variant_new ("(s)",
                   arg_locale),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cc_realm_service_call_release:
 * @proxy: A #CcRealmServiceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Service.Release">Release()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_realm_service_call_release_finish() to get the result of the operation.
 *
 * See cc_realm_service_call_release_sync() for the synchronous, blocking version of this method.
 */
void
cc_realm_service_call_release (
    CcRealmService *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cc_realm_service_call_release_finish:
 * @proxy: A #CcRealmServiceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_realm_service_call_release().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cc_realm_service_call_release().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cc_realm_service_call_release_finish (
    CcRealmService *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cc_realm_service_call_release_sync:
 * @proxy: A #CcRealmServiceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Service.Release">Release()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cc_realm_service_call_release() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cc_realm_service_call_release_sync (
    CcRealmService *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cc_realm_service_complete_cancel:
 * @object: A #CcRealmService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-realmd-Service.Cancel">Cancel()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cc_realm_service_complete_cancel (
    CcRealmService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * cc_realm_service_complete_set_locale:
 * @object: A #CcRealmService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-realmd-Service.SetLocale">SetLocale()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cc_realm_service_complete_set_locale (
    CcRealmService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * cc_realm_service_complete_release:
 * @object: A #CcRealmService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-realmd-Service.Release">Release()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cc_realm_service_complete_release (
    CcRealmService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * CcRealmServiceProxy:
 *
 * The #CcRealmServiceProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CcRealmServiceProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CcRealmServiceProxy.
 */

struct _CcRealmServiceProxyPrivate
{
  GData *qdata;
};

static void cc_realm_service_proxy_iface_init (CcRealmServiceIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CcRealmServiceProxy, cc_realm_service_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (CcRealmServiceProxy)
                         G_IMPLEMENT_INTERFACE (CC_REALM_TYPE_SERVICE, cc_realm_service_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CcRealmServiceProxy, cc_realm_service_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (CC_REALM_TYPE_SERVICE, cc_realm_service_proxy_iface_init))

#endif
static void
cc_realm_service_proxy_finalize (GObject *object)
{
  CcRealmServiceProxy *proxy = CC_REALM_SERVICE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (cc_realm_service_proxy_parent_class)->finalize (object);
}

static void
cc_realm_service_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
cc_realm_service_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
cc_realm_service_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_cc_realm_service_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], CC_REALM_TYPE_SERVICE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CC_REALM_TYPE_SERVICE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
cc_realm_service_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  CcRealmServiceProxy *proxy = CC_REALM_SERVICE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_realm_service_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_realm_service_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
cc_realm_service_proxy_init (CcRealmServiceProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = cc_realm_service_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, CC_REALM_TYPE_SERVICE_PROXY, CcRealmServiceProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), cc_realm_service_interface_info ());
}

static void
cc_realm_service_proxy_class_init (CcRealmServiceProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = cc_realm_service_proxy_finalize;
  gobject_class->get_property = cc_realm_service_proxy_get_property;
  gobject_class->set_property = cc_realm_service_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = cc_realm_service_proxy_g_signal;
  proxy_class->g_properties_changed = cc_realm_service_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CcRealmServiceProxyPrivate));
#endif
}

static void
cc_realm_service_proxy_iface_init (CcRealmServiceIface *iface G_GNUC_UNUSED)
{
}

/**
 * cc_realm_service_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Service.top_of_page">org.freedesktop.realmd.Service</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_realm_service_proxy_new_finish() to get the result of the operation.
 *
 * See cc_realm_service_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
cc_realm_service_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CC_REALM_TYPE_SERVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Service", NULL);
}

/**
 * cc_realm_service_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_realm_service_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with cc_realm_service_proxy_new().
 *
 * Returns: (transfer full) (type CcRealmServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
CcRealmService *
cc_realm_service_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CC_REALM_SERVICE (ret);
  else
    return NULL;
}

/**
 * cc_realm_service_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Service.top_of_page">org.freedesktop.realmd.Service</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See cc_realm_service_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CcRealmServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
CcRealmService *
cc_realm_service_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CC_REALM_TYPE_SERVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Service", NULL);
  if (ret != NULL)
    return CC_REALM_SERVICE (ret);
  else
    return NULL;
}


/**
 * cc_realm_service_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like cc_realm_service_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_realm_service_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See cc_realm_service_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
cc_realm_service_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CC_REALM_TYPE_SERVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Service", NULL);
}

/**
 * cc_realm_service_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_realm_service_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with cc_realm_service_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type CcRealmServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
CcRealmService *
cc_realm_service_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CC_REALM_SERVICE (ret);
  else
    return NULL;
}

/**
 * cc_realm_service_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like cc_realm_service_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See cc_realm_service_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CcRealmServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
CcRealmService *
cc_realm_service_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CC_REALM_TYPE_SERVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Service", NULL);
  if (ret != NULL)
    return CC_REALM_SERVICE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * CcRealmServiceSkeleton:
 *
 * The #CcRealmServiceSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CcRealmServiceSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CcRealmServiceSkeleton.
 */

struct _CcRealmServiceSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_cc_realm_service_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  CcRealmServiceSkeleton *skeleton = CC_REALM_SERVICE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], CC_REALM_TYPE_SERVICE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CC_REALM_TYPE_SERVICE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_cc_realm_service_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  CcRealmServiceSkeleton *skeleton = CC_REALM_SERVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_realm_service_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_cc_realm_service_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  CcRealmServiceSkeleton *skeleton = CC_REALM_SERVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_realm_service_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _cc_realm_service_skeleton_vtable =
{
  _cc_realm_service_skeleton_handle_method_call,
  _cc_realm_service_skeleton_handle_get_property,
  _cc_realm_service_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
cc_realm_service_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return cc_realm_service_interface_info ();
}

static GDBusInterfaceVTable *
cc_realm_service_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_cc_realm_service_skeleton_vtable;
}

static GVariant *
cc_realm_service_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  CcRealmServiceSkeleton *skeleton = CC_REALM_SERVICE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_cc_realm_service_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _cc_realm_service_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _cc_realm_service_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _cc_realm_service_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.realmd.Service", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
cc_realm_service_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_cc_realm_service_on_signal_diagnostics (
    CcRealmService *object,
    const gchar *arg_data,
    const gchar *arg_operation)
{
  CcRealmServiceSkeleton *skeleton = CC_REALM_SERVICE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss)",
                   arg_data,
                   arg_operation));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.realmd.Service", "Diagnostics",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void cc_realm_service_skeleton_iface_init (CcRealmServiceIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CcRealmServiceSkeleton, cc_realm_service_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (CcRealmServiceSkeleton)
                         G_IMPLEMENT_INTERFACE (CC_REALM_TYPE_SERVICE, cc_realm_service_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CcRealmServiceSkeleton, cc_realm_service_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (CC_REALM_TYPE_SERVICE, cc_realm_service_skeleton_iface_init))

#endif
static void
cc_realm_service_skeleton_finalize (GObject *object)
{
  CcRealmServiceSkeleton *skeleton = CC_REALM_SERVICE_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (cc_realm_service_skeleton_parent_class)->finalize (object);
}

static void
cc_realm_service_skeleton_init (CcRealmServiceSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = cc_realm_service_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, CC_REALM_TYPE_SERVICE_SKELETON, CcRealmServiceSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
cc_realm_service_skeleton_class_init (CcRealmServiceSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = cc_realm_service_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = cc_realm_service_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = cc_realm_service_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = cc_realm_service_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = cc_realm_service_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CcRealmServiceSkeletonPrivate));
#endif
}

static void
cc_realm_service_skeleton_iface_init (CcRealmServiceIface *iface)
{
  iface->diagnostics = _cc_realm_service_on_signal_diagnostics;
}

/**
 * cc_realm_service_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Service.top_of_page">org.freedesktop.realmd.Service</link>.
 *
 * Returns: (transfer full) (type CcRealmServiceSkeleton): The skeleton object.
 */
CcRealmService *
cc_realm_service_skeleton_new (void)
{
  return CC_REALM_SERVICE (g_object_new (CC_REALM_TYPE_SERVICE_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.realmd.Realm
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:CcRealmCommon
 * @title: CcRealmCommon
 * @short_description: Generated C code for the org.freedesktop.realmd.Realm D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-realmd-Realm.top_of_page">org.freedesktop.realmd.Realm</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.realmd.Realm ---- */

static const _ExtendedGDBusArgInfo _cc_realm_common_method_info_deconfigure_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _cc_realm_common_method_info_deconfigure_IN_ARG_pointers[] =
{
  &_cc_realm_common_method_info_deconfigure_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _cc_realm_common_method_info_deconfigure =
{
  {
    -1,
    (gchar *) "Deconfigure",
    (GDBusArgInfo **) &_cc_realm_common_method_info_deconfigure_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-deconfigure",
  FALSE
};

static const _ExtendedGDBusArgInfo _cc_realm_common_method_info_change_login_policy_IN_ARG_login_policy =
{
  {
    -1,
    (gchar *) "login_policy",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _cc_realm_common_method_info_change_login_policy_IN_ARG_permitted_add =
{
  {
    -1,
    (gchar *) "permitted_add",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _cc_realm_common_method_info_change_login_policy_IN_ARG_permitted_remove =
{
  {
    -1,
    (gchar *) "permitted_remove",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _cc_realm_common_method_info_change_login_policy_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _cc_realm_common_method_info_change_login_policy_IN_ARG_pointers[] =
{
  &_cc_realm_common_method_info_change_login_policy_IN_ARG_login_policy.parent_struct,
  &_cc_realm_common_method_info_change_login_policy_IN_ARG_permitted_add.parent_struct,
  &_cc_realm_common_method_info_change_login_policy_IN_ARG_permitted_remove.parent_struct,
  &_cc_realm_common_method_info_change_login_policy_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _cc_realm_common_method_info_change_login_policy =
{
  {
    -1,
    (gchar *) "ChangeLoginPolicy",
    (GDBusArgInfo **) &_cc_realm_common_method_info_change_login_policy_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-change-login-policy",
  FALSE
};

static const GDBusMethodInfo * const _cc_realm_common_method_info_pointers[] =
{
  &_cc_realm_common_method_info_deconfigure.parent_struct,
  &_cc_realm_common_method_info_change_login_policy.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _cc_realm_common_property_info_name =
{
  {
    -1,
    (gchar *) "Name",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _cc_realm_common_property_info_configured =
{
  {
    -1,
    (gchar *) "Configured",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "configured",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _cc_realm_common_property_info_supported_interfaces =
{
  {
    -1,
    (gchar *) "SupportedInterfaces",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-interfaces",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _cc_realm_common_property_info_details =
{
  {
    -1,
    (gchar *) "Details",
    (gchar *) "a(ss)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "details",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _cc_realm_common_property_info_login_formats =
{
  {
    -1,
    (gchar *) "LoginFormats",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "login-formats",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _cc_realm_common_property_info_login_policy =
{
  {
    -1,
    (gchar *) "LoginPolicy",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "login-policy",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _cc_realm_common_property_info_permitted_logins =
{
  {
    -1,
    (gchar *) "PermittedLogins",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "permitted-logins",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _cc_realm_common_property_info_pointers[] =
{
  &_cc_realm_common_property_info_name.parent_struct,
  &_cc_realm_common_property_info_configured.parent_struct,
  &_cc_realm_common_property_info_supported_interfaces.parent_struct,
  &_cc_realm_common_property_info_details.parent_struct,
  &_cc_realm_common_property_info_login_formats.parent_struct,
  &_cc_realm_common_property_info_login_policy.parent_struct,
  &_cc_realm_common_property_info_permitted_logins.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _cc_realm_common_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.realmd.Realm",
    (GDBusMethodInfo **) &_cc_realm_common_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_cc_realm_common_property_info_pointers,
    NULL
  },
  "common",
};


/**
 * cc_realm_common_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-realmd-Realm.top_of_page">org.freedesktop.realmd.Realm</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
cc_realm_common_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_cc_realm_common_interface_info.parent_struct;
}

/**
 * cc_realm_common_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #CcRealmCommon interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
cc_realm_common_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "name");
  g_object_class_override_property (klass, property_id_begin++, "configured");
  g_object_class_override_property (klass, property_id_begin++, "supported-interfaces");
  g_object_class_override_property (klass, property_id_begin++, "details");
  g_object_class_override_property (klass, property_id_begin++, "login-formats");
  g_object_class_override_property (klass, property_id_begin++, "login-policy");
  g_object_class_override_property (klass, property_id_begin++, "permitted-logins");
  return property_id_begin - 1;
}


inline static void
cc_realm_common_method_marshal_deconfigure (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cc_realm_common_method_marshal_change_login_policy (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOXED_BOXED_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * CcRealmCommon:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Realm.top_of_page">org.freedesktop.realmd.Realm</link>.
 */

/**
 * CcRealmCommonIface:
 * @parent_iface: The parent interface.
 * @handle_change_login_policy: Handler for the #CcRealmCommon::handle-change-login-policy signal.
 * @handle_deconfigure: Handler for the #CcRealmCommon::handle-deconfigure signal.
 * @get_configured: Getter for the #CcRealmCommon:configured property.
 * @get_details: Getter for the #CcRealmCommon:details property.
 * @get_login_formats: Getter for the #CcRealmCommon:login-formats property.
 * @get_login_policy: Getter for the #CcRealmCommon:login-policy property.
 * @get_name: Getter for the #CcRealmCommon:name property.
 * @get_permitted_logins: Getter for the #CcRealmCommon:permitted-logins property.
 * @get_supported_interfaces: Getter for the #CcRealmCommon:supported-interfaces property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Realm.top_of_page">org.freedesktop.realmd.Realm</link>.
 */

typedef CcRealmCommonIface CcRealmCommonInterface;
G_DEFINE_INTERFACE (CcRealmCommon, cc_realm_common, G_TYPE_OBJECT)

static void
cc_realm_common_default_init (CcRealmCommonIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * CcRealmCommon::handle-deconfigure:
   * @object: A #CcRealmCommon.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-realmd-Realm.Deconfigure">Deconfigure()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cc_realm_common_complete_deconfigure() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-deconfigure",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CcRealmCommonIface, handle_deconfigure),
    g_signal_accumulator_true_handled,
    NULL,
      cc_realm_common_method_marshal_deconfigure,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * CcRealmCommon::handle-change-login-policy:
   * @object: A #CcRealmCommon.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_login_policy: Argument passed by remote caller.
   * @arg_permitted_add: Argument passed by remote caller.
   * @arg_permitted_remove: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-realmd-Realm.ChangeLoginPolicy">ChangeLoginPolicy()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cc_realm_common_complete_change_login_policy() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-change-login-policy",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CcRealmCommonIface, handle_change_login_policy),
    g_signal_accumulator_true_handled,
    NULL,
      cc_realm_common_method_marshal_change_login_policy,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_STRV, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * CcRealmCommon:name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Name">"Name"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("name", "Name", "Name", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CcRealmCommon:configured:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Configured">"Configured"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("configured", "Configured", "Configured", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CcRealmCommon:supported-interfaces:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Realm.SupportedInterfaces">"SupportedInterfaces"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("supported-interfaces", "SupportedInterfaces", "SupportedInterfaces", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CcRealmCommon:details:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Details">"Details"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("details", "Details", "Details", G_VARIANT_TYPE ("a(ss)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CcRealmCommon:login-formats:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Realm.LoginFormats">"LoginFormats"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("login-formats", "LoginFormats", "LoginFormats", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CcRealmCommon:login-policy:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Realm.LoginPolicy">"LoginPolicy"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("login-policy", "LoginPolicy", "LoginPolicy", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CcRealmCommon:permitted-logins:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Realm.PermittedLogins">"PermittedLogins"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("permitted-logins", "PermittedLogins", "PermittedLogins", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * cc_realm_common_get_name: (skip)
 * @object: A #CcRealmCommon.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use cc_realm_common_dup_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
cc_realm_common_get_name (CcRealmCommon *object)
{
  g_return_val_if_fail (CC_REALM_IS_COMMON (object), NULL);

  return CC_REALM_COMMON_GET_IFACE (object)->get_name (object);
}

/**
 * cc_realm_common_dup_name: (skip)
 * @object: A #CcRealmCommon.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
cc_realm_common_dup_name (CcRealmCommon *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "name", &value, NULL);
  return value;
}

/**
 * cc_realm_common_set_name: (skip)
 * @object: A #CcRealmCommon.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Name">"Name"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cc_realm_common_set_name (CcRealmCommon *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "name", value, NULL);
}

/**
 * cc_realm_common_get_configured: (skip)
 * @object: A #CcRealmCommon.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Configured">"Configured"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use cc_realm_common_dup_configured() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
cc_realm_common_get_configured (CcRealmCommon *object)
{
  g_return_val_if_fail (CC_REALM_IS_COMMON (object), NULL);

  return CC_REALM_COMMON_GET_IFACE (object)->get_configured (object);
}

/**
 * cc_realm_common_dup_configured: (skip)
 * @object: A #CcRealmCommon.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Configured">"Configured"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
cc_realm_common_dup_configured (CcRealmCommon *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "configured", &value, NULL);
  return value;
}

/**
 * cc_realm_common_set_configured: (skip)
 * @object: A #CcRealmCommon.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Configured">"Configured"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cc_realm_common_set_configured (CcRealmCommon *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "configured", value, NULL);
}

/**
 * cc_realm_common_get_supported_interfaces: (skip)
 * @object: A #CcRealmCommon.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.SupportedInterfaces">"SupportedInterfaces"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use cc_realm_common_dup_supported_interfaces() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
cc_realm_common_get_supported_interfaces (CcRealmCommon *object)
{
  g_return_val_if_fail (CC_REALM_IS_COMMON (object), NULL);

  return CC_REALM_COMMON_GET_IFACE (object)->get_supported_interfaces (object);
}

/**
 * cc_realm_common_dup_supported_interfaces: (skip)
 * @object: A #CcRealmCommon.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.SupportedInterfaces">"SupportedInterfaces"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
cc_realm_common_dup_supported_interfaces (CcRealmCommon *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "supported-interfaces", &value, NULL);
  return value;
}

/**
 * cc_realm_common_set_supported_interfaces: (skip)
 * @object: A #CcRealmCommon.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.SupportedInterfaces">"SupportedInterfaces"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cc_realm_common_set_supported_interfaces (CcRealmCommon *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "supported-interfaces", value, NULL);
}

/**
 * cc_realm_common_get_details: (skip)
 * @object: A #CcRealmCommon.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Details">"Details"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use cc_realm_common_dup_details() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
cc_realm_common_get_details (CcRealmCommon *object)
{
  g_return_val_if_fail (CC_REALM_IS_COMMON (object), NULL);

  return CC_REALM_COMMON_GET_IFACE (object)->get_details (object);
}

/**
 * cc_realm_common_dup_details: (skip)
 * @object: A #CcRealmCommon.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Details">"Details"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
cc_realm_common_dup_details (CcRealmCommon *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "details", &value, NULL);
  return value;
}

/**
 * cc_realm_common_set_details: (skip)
 * @object: A #CcRealmCommon.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Details">"Details"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cc_realm_common_set_details (CcRealmCommon *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "details", value, NULL);
}

/**
 * cc_realm_common_get_login_formats: (skip)
 * @object: A #CcRealmCommon.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.LoginFormats">"LoginFormats"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use cc_realm_common_dup_login_formats() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
cc_realm_common_get_login_formats (CcRealmCommon *object)
{
  g_return_val_if_fail (CC_REALM_IS_COMMON (object), NULL);

  return CC_REALM_COMMON_GET_IFACE (object)->get_login_formats (object);
}

/**
 * cc_realm_common_dup_login_formats: (skip)
 * @object: A #CcRealmCommon.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.LoginFormats">"LoginFormats"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
cc_realm_common_dup_login_formats (CcRealmCommon *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "login-formats", &value, NULL);
  return value;
}

/**
 * cc_realm_common_set_login_formats: (skip)
 * @object: A #CcRealmCommon.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.LoginFormats">"LoginFormats"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cc_realm_common_set_login_formats (CcRealmCommon *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "login-formats", value, NULL);
}

/**
 * cc_realm_common_get_login_policy: (skip)
 * @object: A #CcRealmCommon.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.LoginPolicy">"LoginPolicy"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use cc_realm_common_dup_login_policy() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
cc_realm_common_get_login_policy (CcRealmCommon *object)
{
  g_return_val_if_fail (CC_REALM_IS_COMMON (object), NULL);

  return CC_REALM_COMMON_GET_IFACE (object)->get_login_policy (object);
}

/**
 * cc_realm_common_dup_login_policy: (skip)
 * @object: A #CcRealmCommon.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.LoginPolicy">"LoginPolicy"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
cc_realm_common_dup_login_policy (CcRealmCommon *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "login-policy", &value, NULL);
  return value;
}

/**
 * cc_realm_common_set_login_policy: (skip)
 * @object: A #CcRealmCommon.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.LoginPolicy">"LoginPolicy"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cc_realm_common_set_login_policy (CcRealmCommon *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "login-policy", value, NULL);
}

/**
 * cc_realm_common_get_permitted_logins: (skip)
 * @object: A #CcRealmCommon.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.PermittedLogins">"PermittedLogins"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use cc_realm_common_dup_permitted_logins() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
cc_realm_common_get_permitted_logins (CcRealmCommon *object)
{
  g_return_val_if_fail (CC_REALM_IS_COMMON (object), NULL);

  return CC_REALM_COMMON_GET_IFACE (object)->get_permitted_logins (object);
}

/**
 * cc_realm_common_dup_permitted_logins: (skip)
 * @object: A #CcRealmCommon.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.PermittedLogins">"PermittedLogins"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
cc_realm_common_dup_permitted_logins (CcRealmCommon *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "permitted-logins", &value, NULL);
  return value;
}

/**
 * cc_realm_common_set_permitted_logins: (skip)
 * @object: A #CcRealmCommon.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.PermittedLogins">"PermittedLogins"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cc_realm_common_set_permitted_logins (CcRealmCommon *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "permitted-logins", value, NULL);
}

/**
 * cc_realm_common_call_deconfigure:
 * @proxy: A #CcRealmCommonProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Realm.Deconfigure">Deconfigure()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_realm_common_call_deconfigure_finish() to get the result of the operation.
 *
 * See cc_realm_common_call_deconfigure_sync() for the synchronous, blocking version of this method.
 */
void
cc_realm_common_call_deconfigure (
    CcRealmCommon *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Deconfigure",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cc_realm_common_call_deconfigure_finish:
 * @proxy: A #CcRealmCommonProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_realm_common_call_deconfigure().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cc_realm_common_call_deconfigure().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cc_realm_common_call_deconfigure_finish (
    CcRealmCommon *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cc_realm_common_call_deconfigure_sync:
 * @proxy: A #CcRealmCommonProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Realm.Deconfigure">Deconfigure()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cc_realm_common_call_deconfigure() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cc_realm_common_call_deconfigure_sync (
    CcRealmCommon *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Deconfigure",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cc_realm_common_call_change_login_policy:
 * @proxy: A #CcRealmCommonProxy.
 * @arg_login_policy: Argument to pass with the method invocation.
 * @arg_permitted_add: Argument to pass with the method invocation.
 * @arg_permitted_remove: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Realm.ChangeLoginPolicy">ChangeLoginPolicy()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_realm_common_call_change_login_policy_finish() to get the result of the operation.
 *
 * See cc_realm_common_call_change_login_policy_sync() for the synchronous, blocking version of this method.
 */
void
cc_realm_common_call_change_login_policy (
    CcRealmCommon *proxy,
    const gchar *arg_login_policy,
    const gchar *const *arg_permitted_add,
    const gchar *const *arg_permitted_remove,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ChangeLoginPolicy",
    g_variant_new ("(s^as^as@a{sv})",
                   arg_login_policy,
                   arg_permitted_add,
                   arg_permitted_remove,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cc_realm_common_call_change_login_policy_finish:
 * @proxy: A #CcRealmCommonProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_realm_common_call_change_login_policy().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cc_realm_common_call_change_login_policy().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cc_realm_common_call_change_login_policy_finish (
    CcRealmCommon *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cc_realm_common_call_change_login_policy_sync:
 * @proxy: A #CcRealmCommonProxy.
 * @arg_login_policy: Argument to pass with the method invocation.
 * @arg_permitted_add: Argument to pass with the method invocation.
 * @arg_permitted_remove: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Realm.ChangeLoginPolicy">ChangeLoginPolicy()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cc_realm_common_call_change_login_policy() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cc_realm_common_call_change_login_policy_sync (
    CcRealmCommon *proxy,
    const gchar *arg_login_policy,
    const gchar *const *arg_permitted_add,
    const gchar *const *arg_permitted_remove,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ChangeLoginPolicy",
    g_variant_new ("(s^as^as@a{sv})",
                   arg_login_policy,
                   arg_permitted_add,
                   arg_permitted_remove,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cc_realm_common_complete_deconfigure:
 * @object: A #CcRealmCommon.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-realmd-Realm.Deconfigure">Deconfigure()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cc_realm_common_complete_deconfigure (
    CcRealmCommon *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * cc_realm_common_complete_change_login_policy:
 * @object: A #CcRealmCommon.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-realmd-Realm.ChangeLoginPolicy">ChangeLoginPolicy()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cc_realm_common_complete_change_login_policy (
    CcRealmCommon *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * CcRealmCommonProxy:
 *
 * The #CcRealmCommonProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CcRealmCommonProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CcRealmCommonProxy.
 */

struct _CcRealmCommonProxyPrivate
{
  GData *qdata;
};

static void cc_realm_common_proxy_iface_init (CcRealmCommonIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CcRealmCommonProxy, cc_realm_common_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (CcRealmCommonProxy)
                         G_IMPLEMENT_INTERFACE (CC_REALM_TYPE_COMMON, cc_realm_common_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CcRealmCommonProxy, cc_realm_common_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (CC_REALM_TYPE_COMMON, cc_realm_common_proxy_iface_init))

#endif
static void
cc_realm_common_proxy_finalize (GObject *object)
{
  CcRealmCommonProxy *proxy = CC_REALM_COMMON_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (cc_realm_common_proxy_parent_class)->finalize (object);
}

static void
cc_realm_common_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _cc_realm_common_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
cc_realm_common_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.realmd.Realm: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
cc_realm_common_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _cc_realm_common_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.realmd.Realm", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) cc_realm_common_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
cc_realm_common_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_cc_realm_common_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], CC_REALM_TYPE_COMMON);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CC_REALM_TYPE_COMMON);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
cc_realm_common_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  CcRealmCommonProxy *proxy = CC_REALM_COMMON_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_realm_common_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_realm_common_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
cc_realm_common_proxy_get_name (CcRealmCommon *object)
{
  CcRealmCommonProxy *proxy = CC_REALM_COMMON_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Name");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
cc_realm_common_proxy_get_configured (CcRealmCommon *object)
{
  CcRealmCommonProxy *proxy = CC_REALM_COMMON_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Configured");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
cc_realm_common_proxy_get_supported_interfaces (CcRealmCommon *object)
{
  CcRealmCommonProxy *proxy = CC_REALM_COMMON_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "SupportedInterfaces");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SupportedInterfaces");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "SupportedInterfaces", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
cc_realm_common_proxy_get_details (CcRealmCommon *object)
{
  CcRealmCommonProxy *proxy = CC_REALM_COMMON_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Details");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static const gchar *const *
cc_realm_common_proxy_get_login_formats (CcRealmCommon *object)
{
  CcRealmCommonProxy *proxy = CC_REALM_COMMON_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "LoginFormats");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LoginFormats");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "LoginFormats", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
cc_realm_common_proxy_get_login_policy (CcRealmCommon *object)
{
  CcRealmCommonProxy *proxy = CC_REALM_COMMON_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LoginPolicy");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
cc_realm_common_proxy_get_permitted_logins (CcRealmCommon *object)
{
  CcRealmCommonProxy *proxy = CC_REALM_COMMON_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "PermittedLogins");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PermittedLogins");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "PermittedLogins", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static void
cc_realm_common_proxy_init (CcRealmCommonProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = cc_realm_common_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, CC_REALM_TYPE_COMMON_PROXY, CcRealmCommonProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), cc_realm_common_interface_info ());
}

static void
cc_realm_common_proxy_class_init (CcRealmCommonProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = cc_realm_common_proxy_finalize;
  gobject_class->get_property = cc_realm_common_proxy_get_property;
  gobject_class->set_property = cc_realm_common_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = cc_realm_common_proxy_g_signal;
  proxy_class->g_properties_changed = cc_realm_common_proxy_g_properties_changed;

  cc_realm_common_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CcRealmCommonProxyPrivate));
#endif
}

static void
cc_realm_common_proxy_iface_init (CcRealmCommonIface *iface)
{
  iface->get_name = cc_realm_common_proxy_get_name;
  iface->get_configured = cc_realm_common_proxy_get_configured;
  iface->get_supported_interfaces = cc_realm_common_proxy_get_supported_interfaces;
  iface->get_details = cc_realm_common_proxy_get_details;
  iface->get_login_formats = cc_realm_common_proxy_get_login_formats;
  iface->get_login_policy = cc_realm_common_proxy_get_login_policy;
  iface->get_permitted_logins = cc_realm_common_proxy_get_permitted_logins;
}

/**
 * cc_realm_common_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Realm.top_of_page">org.freedesktop.realmd.Realm</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_realm_common_proxy_new_finish() to get the result of the operation.
 *
 * See cc_realm_common_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
cc_realm_common_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CC_REALM_TYPE_COMMON_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Realm", NULL);
}

/**
 * cc_realm_common_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_realm_common_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with cc_realm_common_proxy_new().
 *
 * Returns: (transfer full) (type CcRealmCommonProxy): The constructed proxy object or %NULL if @error is set.
 */
CcRealmCommon *
cc_realm_common_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CC_REALM_COMMON (ret);
  else
    return NULL;
}

/**
 * cc_realm_common_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Realm.top_of_page">org.freedesktop.realmd.Realm</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See cc_realm_common_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CcRealmCommonProxy): The constructed proxy object or %NULL if @error is set.
 */
CcRealmCommon *
cc_realm_common_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CC_REALM_TYPE_COMMON_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Realm", NULL);
  if (ret != NULL)
    return CC_REALM_COMMON (ret);
  else
    return NULL;
}


/**
 * cc_realm_common_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like cc_realm_common_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_realm_common_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See cc_realm_common_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
cc_realm_common_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CC_REALM_TYPE_COMMON_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Realm", NULL);
}

/**
 * cc_realm_common_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_realm_common_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with cc_realm_common_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type CcRealmCommonProxy): The constructed proxy object or %NULL if @error is set.
 */
CcRealmCommon *
cc_realm_common_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CC_REALM_COMMON (ret);
  else
    return NULL;
}

/**
 * cc_realm_common_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like cc_realm_common_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See cc_realm_common_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CcRealmCommonProxy): The constructed proxy object or %NULL if @error is set.
 */
CcRealmCommon *
cc_realm_common_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CC_REALM_TYPE_COMMON_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Realm", NULL);
  if (ret != NULL)
    return CC_REALM_COMMON (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * CcRealmCommonSkeleton:
 *
 * The #CcRealmCommonSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CcRealmCommonSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CcRealmCommonSkeleton.
 */

struct _CcRealmCommonSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_cc_realm_common_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  CcRealmCommonSkeleton *skeleton = CC_REALM_COMMON_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], CC_REALM_TYPE_COMMON);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CC_REALM_TYPE_COMMON);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_cc_realm_common_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  CcRealmCommonSkeleton *skeleton = CC_REALM_COMMON_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_realm_common_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_cc_realm_common_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  CcRealmCommonSkeleton *skeleton = CC_REALM_COMMON_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_realm_common_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _cc_realm_common_skeleton_vtable =
{
  _cc_realm_common_skeleton_handle_method_call,
  _cc_realm_common_skeleton_handle_get_property,
  _cc_realm_common_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
cc_realm_common_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return cc_realm_common_interface_info ();
}

static GDBusInterfaceVTable *
cc_realm_common_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_cc_realm_common_skeleton_vtable;
}

static GVariant *
cc_realm_common_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  CcRealmCommonSkeleton *skeleton = CC_REALM_COMMON_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_cc_realm_common_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _cc_realm_common_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _cc_realm_common_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _cc_realm_common_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.realmd.Realm", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _cc_realm_common_emit_changed (gpointer user_data);

static void
cc_realm_common_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  CcRealmCommonSkeleton *skeleton = CC_REALM_COMMON_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _cc_realm_common_emit_changed (skeleton);
}

static void cc_realm_common_skeleton_iface_init (CcRealmCommonIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CcRealmCommonSkeleton, cc_realm_common_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (CcRealmCommonSkeleton)
                         G_IMPLEMENT_INTERFACE (CC_REALM_TYPE_COMMON, cc_realm_common_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CcRealmCommonSkeleton, cc_realm_common_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (CC_REALM_TYPE_COMMON, cc_realm_common_skeleton_iface_init))

#endif
static void
cc_realm_common_skeleton_finalize (GObject *object)
{
  CcRealmCommonSkeleton *skeleton = CC_REALM_COMMON_SKELETON (object);
  guint n;
  for (n = 0; n < 7; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (cc_realm_common_skeleton_parent_class)->finalize (object);
}

static void
cc_realm_common_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  CcRealmCommonSkeleton *skeleton = CC_REALM_COMMON_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_cc_realm_common_emit_changed (gpointer user_data)
{
  CcRealmCommonSkeleton *skeleton = CC_REALM_COMMON_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.realmd.Realm",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_cc_realm_common_schedule_emit_changed (CcRealmCommonSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
cc_realm_common_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  CcRealmCommonSkeleton *skeleton = CC_REALM_COMMON_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _cc_realm_common_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _cc_realm_common_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
cc_realm_common_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  CcRealmCommonSkeleton *skeleton = CC_REALM_COMMON_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _cc_realm_common_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _cc_realm_common_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
cc_realm_common_skeleton_init (CcRealmCommonSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = cc_realm_common_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, CC_REALM_TYPE_COMMON_SKELETON, CcRealmCommonSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 7);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_STRV);
}

static const gchar *
cc_realm_common_skeleton_get_name (CcRealmCommon *object)
{
  CcRealmCommonSkeleton *skeleton = CC_REALM_COMMON_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
cc_realm_common_skeleton_get_configured (CcRealmCommon *object)
{
  CcRealmCommonSkeleton *skeleton = CC_REALM_COMMON_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
cc_realm_common_skeleton_get_supported_interfaces (CcRealmCommon *object)
{
  CcRealmCommonSkeleton *skeleton = CC_REALM_COMMON_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
cc_realm_common_skeleton_get_details (CcRealmCommon *object)
{
  CcRealmCommonSkeleton *skeleton = CC_REALM_COMMON_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
cc_realm_common_skeleton_get_login_formats (CcRealmCommon *object)
{
  CcRealmCommonSkeleton *skeleton = CC_REALM_COMMON_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
cc_realm_common_skeleton_get_login_policy (CcRealmCommon *object)
{
  CcRealmCommonSkeleton *skeleton = CC_REALM_COMMON_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
cc_realm_common_skeleton_get_permitted_logins (CcRealmCommon *object)
{
  CcRealmCommonSkeleton *skeleton = CC_REALM_COMMON_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
cc_realm_common_skeleton_class_init (CcRealmCommonSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = cc_realm_common_skeleton_finalize;
  gobject_class->get_property = cc_realm_common_skeleton_get_property;
  gobject_class->set_property = cc_realm_common_skeleton_set_property;
  gobject_class->notify       = cc_realm_common_skeleton_notify;


  cc_realm_common_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = cc_realm_common_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = cc_realm_common_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = cc_realm_common_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = cc_realm_common_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CcRealmCommonSkeletonPrivate));
#endif
}

static void
cc_realm_common_skeleton_iface_init (CcRealmCommonIface *iface)
{
  iface->get_name = cc_realm_common_skeleton_get_name;
  iface->get_configured = cc_realm_common_skeleton_get_configured;
  iface->get_supported_interfaces = cc_realm_common_skeleton_get_supported_interfaces;
  iface->get_details = cc_realm_common_skeleton_get_details;
  iface->get_login_formats = cc_realm_common_skeleton_get_login_formats;
  iface->get_login_policy = cc_realm_common_skeleton_get_login_policy;
  iface->get_permitted_logins = cc_realm_common_skeleton_get_permitted_logins;
}

/**
 * cc_realm_common_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Realm.top_of_page">org.freedesktop.realmd.Realm</link>.
 *
 * Returns: (transfer full) (type CcRealmCommonSkeleton): The skeleton object.
 */
CcRealmCommon *
cc_realm_common_skeleton_new (void)
{
  return CC_REALM_COMMON (g_object_new (CC_REALM_TYPE_COMMON_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.realmd.Kerberos
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:CcRealmKerberos
 * @title: CcRealmKerberos
 * @short_description: Generated C code for the org.freedesktop.realmd.Kerberos D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-realmd-Kerberos.top_of_page">org.freedesktop.realmd.Kerberos</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.realmd.Kerberos ---- */

static const _ExtendedGDBusPropertyInfo _cc_realm_kerberos_property_info_realm_name =
{
  {
    -1,
    (gchar *) "RealmName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "realm-name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _cc_realm_kerberos_property_info_domain_name =
{
  {
    -1,
    (gchar *) "DomainName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "domain-name",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _cc_realm_kerberos_property_info_pointers[] =
{
  &_cc_realm_kerberos_property_info_realm_name.parent_struct,
  &_cc_realm_kerberos_property_info_domain_name.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _cc_realm_kerberos_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.realmd.Kerberos",
    NULL,
    NULL,
    (GDBusPropertyInfo **) &_cc_realm_kerberos_property_info_pointers,
    NULL
  },
  "kerberos",
};


/**
 * cc_realm_kerberos_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-realmd-Kerberos.top_of_page">org.freedesktop.realmd.Kerberos</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
cc_realm_kerberos_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_cc_realm_kerberos_interface_info.parent_struct;
}

/**
 * cc_realm_kerberos_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #CcRealmKerberos interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
cc_realm_kerberos_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "realm-name");
  g_object_class_override_property (klass, property_id_begin++, "domain-name");
  return property_id_begin - 1;
}



/**
 * CcRealmKerberos:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Kerberos.top_of_page">org.freedesktop.realmd.Kerberos</link>.
 */

/**
 * CcRealmKerberosIface:
 * @parent_iface: The parent interface.
 * @get_domain_name: Getter for the #CcRealmKerberos:domain-name property.
 * @get_realm_name: Getter for the #CcRealmKerberos:realm-name property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Kerberos.top_of_page">org.freedesktop.realmd.Kerberos</link>.
 */

typedef CcRealmKerberosIface CcRealmKerberosInterface;
G_DEFINE_INTERFACE (CcRealmKerberos, cc_realm_kerberos, G_TYPE_OBJECT)

static void
cc_realm_kerberos_default_init (CcRealmKerberosIface *iface)
{
  /* GObject properties for D-Bus properties: */
  /**
   * CcRealmKerberos:realm-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Kerberos.RealmName">"RealmName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("realm-name", "RealmName", "RealmName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CcRealmKerberos:domain-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Kerberos.DomainName">"DomainName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("domain-name", "DomainName", "DomainName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * cc_realm_kerberos_get_realm_name: (skip)
 * @object: A #CcRealmKerberos.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Kerberos.RealmName">"RealmName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use cc_realm_kerberos_dup_realm_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
cc_realm_kerberos_get_realm_name (CcRealmKerberos *object)
{
  g_return_val_if_fail (CC_REALM_IS_KERBEROS (object), NULL);

  return CC_REALM_KERBEROS_GET_IFACE (object)->get_realm_name (object);
}

/**
 * cc_realm_kerberos_dup_realm_name: (skip)
 * @object: A #CcRealmKerberos.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Kerberos.RealmName">"RealmName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
cc_realm_kerberos_dup_realm_name (CcRealmKerberos *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "realm-name", &value, NULL);
  return value;
}

/**
 * cc_realm_kerberos_set_realm_name: (skip)
 * @object: A #CcRealmKerberos.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Kerberos.RealmName">"RealmName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cc_realm_kerberos_set_realm_name (CcRealmKerberos *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "realm-name", value, NULL);
}

/**
 * cc_realm_kerberos_get_domain_name: (skip)
 * @object: A #CcRealmKerberos.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Kerberos.DomainName">"DomainName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use cc_realm_kerberos_dup_domain_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
cc_realm_kerberos_get_domain_name (CcRealmKerberos *object)
{
  g_return_val_if_fail (CC_REALM_IS_KERBEROS (object), NULL);

  return CC_REALM_KERBEROS_GET_IFACE (object)->get_domain_name (object);
}

/**
 * cc_realm_kerberos_dup_domain_name: (skip)
 * @object: A #CcRealmKerberos.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Kerberos.DomainName">"DomainName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
cc_realm_kerberos_dup_domain_name (CcRealmKerberos *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "domain-name", &value, NULL);
  return value;
}

/**
 * cc_realm_kerberos_set_domain_name: (skip)
 * @object: A #CcRealmKerberos.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Kerberos.DomainName">"DomainName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cc_realm_kerberos_set_domain_name (CcRealmKerberos *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "domain-name", value, NULL);
}

/* ------------------------------------------------------------------------ */

/**
 * CcRealmKerberosProxy:
 *
 * The #CcRealmKerberosProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CcRealmKerberosProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CcRealmKerberosProxy.
 */

struct _CcRealmKerberosProxyPrivate
{
  GData *qdata;
};

static void cc_realm_kerberos_proxy_iface_init (CcRealmKerberosIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CcRealmKerberosProxy, cc_realm_kerberos_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (CcRealmKerberosProxy)
                         G_IMPLEMENT_INTERFACE (CC_REALM_TYPE_KERBEROS, cc_realm_kerberos_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CcRealmKerberosProxy, cc_realm_kerberos_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (CC_REALM_TYPE_KERBEROS, cc_realm_kerberos_proxy_iface_init))

#endif
static void
cc_realm_kerberos_proxy_finalize (GObject *object)
{
  CcRealmKerberosProxy *proxy = CC_REALM_KERBEROS_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (cc_realm_kerberos_proxy_parent_class)->finalize (object);
}

static void
cc_realm_kerberos_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _cc_realm_kerberos_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
cc_realm_kerberos_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.realmd.Kerberos: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
cc_realm_kerberos_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _cc_realm_kerberos_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.realmd.Kerberos", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) cc_realm_kerberos_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
cc_realm_kerberos_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_cc_realm_kerberos_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], CC_REALM_TYPE_KERBEROS);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CC_REALM_TYPE_KERBEROS);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
cc_realm_kerberos_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  CcRealmKerberosProxy *proxy = CC_REALM_KERBEROS_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_realm_kerberos_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_realm_kerberos_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
cc_realm_kerberos_proxy_get_realm_name (CcRealmKerberos *object)
{
  CcRealmKerberosProxy *proxy = CC_REALM_KERBEROS_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RealmName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
cc_realm_kerberos_proxy_get_domain_name (CcRealmKerberos *object)
{
  CcRealmKerberosProxy *proxy = CC_REALM_KERBEROS_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DomainName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
cc_realm_kerberos_proxy_init (CcRealmKerberosProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = cc_realm_kerberos_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, CC_REALM_TYPE_KERBEROS_PROXY, CcRealmKerberosProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), cc_realm_kerberos_interface_info ());
}

static void
cc_realm_kerberos_proxy_class_init (CcRealmKerberosProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = cc_realm_kerberos_proxy_finalize;
  gobject_class->get_property = cc_realm_kerberos_proxy_get_property;
  gobject_class->set_property = cc_realm_kerberos_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = cc_realm_kerberos_proxy_g_signal;
  proxy_class->g_properties_changed = cc_realm_kerberos_proxy_g_properties_changed;

  cc_realm_kerberos_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CcRealmKerberosProxyPrivate));
#endif
}

static void
cc_realm_kerberos_proxy_iface_init (CcRealmKerberosIface *iface)
{
  iface->get_realm_name = cc_realm_kerberos_proxy_get_realm_name;
  iface->get_domain_name = cc_realm_kerberos_proxy_get_domain_name;
}

/**
 * cc_realm_kerberos_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Kerberos.top_of_page">org.freedesktop.realmd.Kerberos</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_realm_kerberos_proxy_new_finish() to get the result of the operation.
 *
 * See cc_realm_kerberos_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
cc_realm_kerberos_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CC_REALM_TYPE_KERBEROS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Kerberos", NULL);
}

/**
 * cc_realm_kerberos_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_realm_kerberos_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with cc_realm_kerberos_proxy_new().
 *
 * Returns: (transfer full) (type CcRealmKerberosProxy): The constructed proxy object or %NULL if @error is set.
 */
CcRealmKerberos *
cc_realm_kerberos_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CC_REALM_KERBEROS (ret);
  else
    return NULL;
}

/**
 * cc_realm_kerberos_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Kerberos.top_of_page">org.freedesktop.realmd.Kerberos</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See cc_realm_kerberos_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CcRealmKerberosProxy): The constructed proxy object or %NULL if @error is set.
 */
CcRealmKerberos *
cc_realm_kerberos_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CC_REALM_TYPE_KERBEROS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Kerberos", NULL);
  if (ret != NULL)
    return CC_REALM_KERBEROS (ret);
  else
    return NULL;
}


/**
 * cc_realm_kerberos_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like cc_realm_kerberos_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_realm_kerberos_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See cc_realm_kerberos_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
cc_realm_kerberos_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CC_REALM_TYPE_KERBEROS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Kerberos", NULL);
}

/**
 * cc_realm_kerberos_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_realm_kerberos_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with cc_realm_kerberos_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type CcRealmKerberosProxy): The constructed proxy object or %NULL if @error is set.
 */
CcRealmKerberos *
cc_realm_kerberos_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CC_REALM_KERBEROS (ret);
  else
    return NULL;
}

/**
 * cc_realm_kerberos_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like cc_realm_kerberos_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See cc_realm_kerberos_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CcRealmKerberosProxy): The constructed proxy object or %NULL if @error is set.
 */
CcRealmKerberos *
cc_realm_kerberos_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CC_REALM_TYPE_KERBEROS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Kerberos", NULL);
  if (ret != NULL)
    return CC_REALM_KERBEROS (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * CcRealmKerberosSkeleton:
 *
 * The #CcRealmKerberosSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CcRealmKerberosSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CcRealmKerberosSkeleton.
 */

struct _CcRealmKerberosSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_cc_realm_kerberos_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  CcRealmKerberosSkeleton *skeleton = CC_REALM_KERBEROS_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], CC_REALM_TYPE_KERBEROS);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CC_REALM_TYPE_KERBEROS);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_cc_realm_kerberos_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  CcRealmKerberosSkeleton *skeleton = CC_REALM_KERBEROS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_realm_kerberos_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_cc_realm_kerberos_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  CcRealmKerberosSkeleton *skeleton = CC_REALM_KERBEROS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_realm_kerberos_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _cc_realm_kerberos_skeleton_vtable =
{
  _cc_realm_kerberos_skeleton_handle_method_call,
  _cc_realm_kerberos_skeleton_handle_get_property,
  _cc_realm_kerberos_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
cc_realm_kerberos_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return cc_realm_kerberos_interface_info ();
}

static GDBusInterfaceVTable *
cc_realm_kerberos_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_cc_realm_kerberos_skeleton_vtable;
}

static GVariant *
cc_realm_kerberos_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  CcRealmKerberosSkeleton *skeleton = CC_REALM_KERBEROS_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_cc_realm_kerberos_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _cc_realm_kerberos_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _cc_realm_kerberos_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _cc_realm_kerberos_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.realmd.Kerberos", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _cc_realm_kerberos_emit_changed (gpointer user_data);

static void
cc_realm_kerberos_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  CcRealmKerberosSkeleton *skeleton = CC_REALM_KERBEROS_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _cc_realm_kerberos_emit_changed (skeleton);
}

static void cc_realm_kerberos_skeleton_iface_init (CcRealmKerberosIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CcRealmKerberosSkeleton, cc_realm_kerberos_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (CcRealmKerberosSkeleton)
                         G_IMPLEMENT_INTERFACE (CC_REALM_TYPE_KERBEROS, cc_realm_kerberos_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CcRealmKerberosSkeleton, cc_realm_kerberos_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (CC_REALM_TYPE_KERBEROS, cc_realm_kerberos_skeleton_iface_init))

#endif
static void
cc_realm_kerberos_skeleton_finalize (GObject *object)
{
  CcRealmKerberosSkeleton *skeleton = CC_REALM_KERBEROS_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (cc_realm_kerberos_skeleton_parent_class)->finalize (object);
}

static void
cc_realm_kerberos_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  CcRealmKerberosSkeleton *skeleton = CC_REALM_KERBEROS_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_cc_realm_kerberos_emit_changed (gpointer user_data)
{
  CcRealmKerberosSkeleton *skeleton = CC_REALM_KERBEROS_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.realmd.Kerberos",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_cc_realm_kerberos_schedule_emit_changed (CcRealmKerberosSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
cc_realm_kerberos_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  CcRealmKerberosSkeleton *skeleton = CC_REALM_KERBEROS_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _cc_realm_kerberos_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _cc_realm_kerberos_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
cc_realm_kerberos_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  CcRealmKerberosSkeleton *skeleton = CC_REALM_KERBEROS_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _cc_realm_kerberos_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _cc_realm_kerberos_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
cc_realm_kerberos_skeleton_init (CcRealmKerberosSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = cc_realm_kerberos_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, CC_REALM_TYPE_KERBEROS_SKELETON, CcRealmKerberosSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
}

static const gchar *
cc_realm_kerberos_skeleton_get_realm_name (CcRealmKerberos *object)
{
  CcRealmKerberosSkeleton *skeleton = CC_REALM_KERBEROS_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
cc_realm_kerberos_skeleton_get_domain_name (CcRealmKerberos *object)
{
  CcRealmKerberosSkeleton *skeleton = CC_REALM_KERBEROS_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
cc_realm_kerberos_skeleton_class_init (CcRealmKerberosSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = cc_realm_kerberos_skeleton_finalize;
  gobject_class->get_property = cc_realm_kerberos_skeleton_get_property;
  gobject_class->set_property = cc_realm_kerberos_skeleton_set_property;
  gobject_class->notify       = cc_realm_kerberos_skeleton_notify;


  cc_realm_kerberos_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = cc_realm_kerberos_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = cc_realm_kerberos_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = cc_realm_kerberos_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = cc_realm_kerberos_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CcRealmKerberosSkeletonPrivate));
#endif
}

static void
cc_realm_kerberos_skeleton_iface_init (CcRealmKerberosIface *iface)
{
  iface->get_realm_name = cc_realm_kerberos_skeleton_get_realm_name;
  iface->get_domain_name = cc_realm_kerberos_skeleton_get_domain_name;
}

/**
 * cc_realm_kerberos_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Kerberos.top_of_page">org.freedesktop.realmd.Kerberos</link>.
 *
 * Returns: (transfer full) (type CcRealmKerberosSkeleton): The skeleton object.
 */
CcRealmKerberos *
cc_realm_kerberos_skeleton_new (void)
{
  return CC_REALM_KERBEROS (g_object_new (CC_REALM_TYPE_KERBEROS_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.realmd.KerberosMembership
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:CcRealmKerberosMembership
 * @title: CcRealmKerberosMembership
 * @short_description: Generated C code for the org.freedesktop.realmd.KerberosMembership D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-realmd-KerberosMembership.top_of_page">org.freedesktop.realmd.KerberosMembership</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.realmd.KerberosMembership ---- */

static const _ExtendedGDBusArgInfo _cc_realm_kerberos_membership_method_info_join_IN_ARG_credentials =
{
  {
    -1,
    (gchar *) "credentials",
    (gchar *) "(ssv)",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _cc_realm_kerberos_membership_method_info_join_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _cc_realm_kerberos_membership_method_info_join_IN_ARG_pointers[] =
{
  &_cc_realm_kerberos_membership_method_info_join_IN_ARG_credentials.parent_struct,
  &_cc_realm_kerberos_membership_method_info_join_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _cc_realm_kerberos_membership_method_info_join =
{
  {
    -1,
    (gchar *) "Join",
    (GDBusArgInfo **) &_cc_realm_kerberos_membership_method_info_join_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-join",
  FALSE
};

static const _ExtendedGDBusArgInfo _cc_realm_kerberos_membership_method_info_leave_IN_ARG_credentials =
{
  {
    -1,
    (gchar *) "credentials",
    (gchar *) "(ssv)",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _cc_realm_kerberos_membership_method_info_leave_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _cc_realm_kerberos_membership_method_info_leave_IN_ARG_pointers[] =
{
  &_cc_realm_kerberos_membership_method_info_leave_IN_ARG_credentials.parent_struct,
  &_cc_realm_kerberos_membership_method_info_leave_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _cc_realm_kerberos_membership_method_info_leave =
{
  {
    -1,
    (gchar *) "Leave",
    (GDBusArgInfo **) &_cc_realm_kerberos_membership_method_info_leave_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-leave",
  FALSE
};

static const GDBusMethodInfo * const _cc_realm_kerberos_membership_method_info_pointers[] =
{
  &_cc_realm_kerberos_membership_method_info_join.parent_struct,
  &_cc_realm_kerberos_membership_method_info_leave.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _cc_realm_kerberos_membership_property_info_suggested_administrator =
{
  {
    -1,
    (gchar *) "SuggestedAdministrator",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "suggested-administrator",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _cc_realm_kerberos_membership_property_info_supported_join_credentials =
{
  {
    -1,
    (gchar *) "SupportedJoinCredentials",
    (gchar *) "a(ss)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-join-credentials",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _cc_realm_kerberos_membership_property_info_supported_leave_credentials =
{
  {
    -1,
    (gchar *) "SupportedLeaveCredentials",
    (gchar *) "a(ss)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-leave-credentials",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _cc_realm_kerberos_membership_property_info_pointers[] =
{
  &_cc_realm_kerberos_membership_property_info_suggested_administrator.parent_struct,
  &_cc_realm_kerberos_membership_property_info_supported_join_credentials.parent_struct,
  &_cc_realm_kerberos_membership_property_info_supported_leave_credentials.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _cc_realm_kerberos_membership_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.realmd.KerberosMembership",
    (GDBusMethodInfo **) &_cc_realm_kerberos_membership_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_cc_realm_kerberos_membership_property_info_pointers,
    NULL
  },
  "kerberos-membership",
};


/**
 * cc_realm_kerberos_membership_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-realmd-KerberosMembership.top_of_page">org.freedesktop.realmd.KerberosMembership</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
cc_realm_kerberos_membership_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_cc_realm_kerberos_membership_interface_info.parent_struct;
}

/**
 * cc_realm_kerberos_membership_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #CcRealmKerberosMembership interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
cc_realm_kerberos_membership_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "suggested-administrator");
  g_object_class_override_property (klass, property_id_begin++, "supported-join-credentials");
  g_object_class_override_property (klass, property_id_begin++, "supported-leave-credentials");
  return property_id_begin - 1;
}


inline static void
cc_realm_kerberos_membership_method_marshal_join (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cc_realm_kerberos_membership_method_marshal_leave (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * CcRealmKerberosMembership:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-KerberosMembership.top_of_page">org.freedesktop.realmd.KerberosMembership</link>.
 */

/**
 * CcRealmKerberosMembershipIface:
 * @parent_iface: The parent interface.
 * @handle_join: Handler for the #CcRealmKerberosMembership::handle-join signal.
 * @handle_leave: Handler for the #CcRealmKerberosMembership::handle-leave signal.
 * @get_suggested_administrator: Getter for the #CcRealmKerberosMembership:suggested-administrator property.
 * @get_supported_join_credentials: Getter for the #CcRealmKerberosMembership:supported-join-credentials property.
 * @get_supported_leave_credentials: Getter for the #CcRealmKerberosMembership:supported-leave-credentials property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-KerberosMembership.top_of_page">org.freedesktop.realmd.KerberosMembership</link>.
 */

typedef CcRealmKerberosMembershipIface CcRealmKerberosMembershipInterface;
G_DEFINE_INTERFACE (CcRealmKerberosMembership, cc_realm_kerberos_membership, G_TYPE_OBJECT)

static void
cc_realm_kerberos_membership_default_init (CcRealmKerberosMembershipIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * CcRealmKerberosMembership::handle-join:
   * @object: A #CcRealmKerberosMembership.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_credentials: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-realmd-KerberosMembership.Join">Join()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cc_realm_kerberos_membership_complete_join() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-join",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CcRealmKerberosMembershipIface, handle_join),
    g_signal_accumulator_true_handled,
    NULL,
      cc_realm_kerberos_membership_method_marshal_join,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * CcRealmKerberosMembership::handle-leave:
   * @object: A #CcRealmKerberosMembership.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_credentials: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-realmd-KerberosMembership.Leave">Leave()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cc_realm_kerberos_membership_complete_leave() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-leave",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CcRealmKerberosMembershipIface, handle_leave),
    g_signal_accumulator_true_handled,
    NULL,
      cc_realm_kerberos_membership_method_marshal_leave,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * CcRealmKerberosMembership:suggested-administrator:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SuggestedAdministrator">"SuggestedAdministrator"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("suggested-administrator", "SuggestedAdministrator", "SuggestedAdministrator", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CcRealmKerberosMembership:supported-join-credentials:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SupportedJoinCredentials">"SupportedJoinCredentials"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("supported-join-credentials", "SupportedJoinCredentials", "SupportedJoinCredentials", G_VARIANT_TYPE ("a(ss)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CcRealmKerberosMembership:supported-leave-credentials:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SupportedLeaveCredentials">"SupportedLeaveCredentials"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("supported-leave-credentials", "SupportedLeaveCredentials", "SupportedLeaveCredentials", G_VARIANT_TYPE ("a(ss)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * cc_realm_kerberos_membership_get_suggested_administrator: (skip)
 * @object: A #CcRealmKerberosMembership.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SuggestedAdministrator">"SuggestedAdministrator"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use cc_realm_kerberos_membership_dup_suggested_administrator() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
cc_realm_kerberos_membership_get_suggested_administrator (CcRealmKerberosMembership *object)
{
  g_return_val_if_fail (CC_REALM_IS_KERBEROS_MEMBERSHIP (object), NULL);

  return CC_REALM_KERBEROS_MEMBERSHIP_GET_IFACE (object)->get_suggested_administrator (object);
}

/**
 * cc_realm_kerberos_membership_dup_suggested_administrator: (skip)
 * @object: A #CcRealmKerberosMembership.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SuggestedAdministrator">"SuggestedAdministrator"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
cc_realm_kerberos_membership_dup_suggested_administrator (CcRealmKerberosMembership *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "suggested-administrator", &value, NULL);
  return value;
}

/**
 * cc_realm_kerberos_membership_set_suggested_administrator: (skip)
 * @object: A #CcRealmKerberosMembership.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SuggestedAdministrator">"SuggestedAdministrator"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cc_realm_kerberos_membership_set_suggested_administrator (CcRealmKerberosMembership *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "suggested-administrator", value, NULL);
}

/**
 * cc_realm_kerberos_membership_get_supported_join_credentials: (skip)
 * @object: A #CcRealmKerberosMembership.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SupportedJoinCredentials">"SupportedJoinCredentials"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use cc_realm_kerberos_membership_dup_supported_join_credentials() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
cc_realm_kerberos_membership_get_supported_join_credentials (CcRealmKerberosMembership *object)
{
  g_return_val_if_fail (CC_REALM_IS_KERBEROS_MEMBERSHIP (object), NULL);

  return CC_REALM_KERBEROS_MEMBERSHIP_GET_IFACE (object)->get_supported_join_credentials (object);
}

/**
 * cc_realm_kerberos_membership_dup_supported_join_credentials: (skip)
 * @object: A #CcRealmKerberosMembership.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SupportedJoinCredentials">"SupportedJoinCredentials"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
cc_realm_kerberos_membership_dup_supported_join_credentials (CcRealmKerberosMembership *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "supported-join-credentials", &value, NULL);
  return value;
}

/**
 * cc_realm_kerberos_membership_set_supported_join_credentials: (skip)
 * @object: A #CcRealmKerberosMembership.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SupportedJoinCredentials">"SupportedJoinCredentials"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cc_realm_kerberos_membership_set_supported_join_credentials (CcRealmKerberosMembership *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "supported-join-credentials", value, NULL);
}

/**
 * cc_realm_kerberos_membership_get_supported_leave_credentials: (skip)
 * @object: A #CcRealmKerberosMembership.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SupportedLeaveCredentials">"SupportedLeaveCredentials"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use cc_realm_kerberos_membership_dup_supported_leave_credentials() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
cc_realm_kerberos_membership_get_supported_leave_credentials (CcRealmKerberosMembership *object)
{
  g_return_val_if_fail (CC_REALM_IS_KERBEROS_MEMBERSHIP (object), NULL);

  return CC_REALM_KERBEROS_MEMBERSHIP_GET_IFACE (object)->get_supported_leave_credentials (object);
}

/**
 * cc_realm_kerberos_membership_dup_supported_leave_credentials: (skip)
 * @object: A #CcRealmKerberosMembership.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SupportedLeaveCredentials">"SupportedLeaveCredentials"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
cc_realm_kerberos_membership_dup_supported_leave_credentials (CcRealmKerberosMembership *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "supported-leave-credentials", &value, NULL);
  return value;
}

/**
 * cc_realm_kerberos_membership_set_supported_leave_credentials: (skip)
 * @object: A #CcRealmKerberosMembership.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SupportedLeaveCredentials">"SupportedLeaveCredentials"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cc_realm_kerberos_membership_set_supported_leave_credentials (CcRealmKerberosMembership *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "supported-leave-credentials", value, NULL);
}

/**
 * cc_realm_kerberos_membership_call_join:
 * @proxy: A #CcRealmKerberosMembershipProxy.
 * @arg_credentials: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-KerberosMembership.Join">Join()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_realm_kerberos_membership_call_join_finish() to get the result of the operation.
 *
 * See cc_realm_kerberos_membership_call_join_sync() for the synchronous, blocking version of this method.
 */
void
cc_realm_kerberos_membership_call_join (
    CcRealmKerberosMembership *proxy,
    GVariant *arg_credentials,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Join",
    g_variant_new ("(@(ssv)@a{sv})",
                   arg_credentials,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cc_realm_kerberos_membership_call_join_finish:
 * @proxy: A #CcRealmKerberosMembershipProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_realm_kerberos_membership_call_join().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cc_realm_kerberos_membership_call_join().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cc_realm_kerberos_membership_call_join_finish (
    CcRealmKerberosMembership *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cc_realm_kerberos_membership_call_join_sync:
 * @proxy: A #CcRealmKerberosMembershipProxy.
 * @arg_credentials: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-KerberosMembership.Join">Join()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cc_realm_kerberos_membership_call_join() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cc_realm_kerberos_membership_call_join_sync (
    CcRealmKerberosMembership *proxy,
    GVariant *arg_credentials,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Join",
    g_variant_new ("(@(ssv)@a{sv})",
                   arg_credentials,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cc_realm_kerberos_membership_call_leave:
 * @proxy: A #CcRealmKerberosMembershipProxy.
 * @arg_credentials: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-KerberosMembership.Leave">Leave()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_realm_kerberos_membership_call_leave_finish() to get the result of the operation.
 *
 * See cc_realm_kerberos_membership_call_leave_sync() for the synchronous, blocking version of this method.
 */
void
cc_realm_kerberos_membership_call_leave (
    CcRealmKerberosMembership *proxy,
    GVariant *arg_credentials,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Leave",
    g_variant_new ("(@(ssv)@a{sv})",
                   arg_credentials,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cc_realm_kerberos_membership_call_leave_finish:
 * @proxy: A #CcRealmKerberosMembershipProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_realm_kerberos_membership_call_leave().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cc_realm_kerberos_membership_call_leave().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cc_realm_kerberos_membership_call_leave_finish (
    CcRealmKerberosMembership *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cc_realm_kerberos_membership_call_leave_sync:
 * @proxy: A #CcRealmKerberosMembershipProxy.
 * @arg_credentials: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-KerberosMembership.Leave">Leave()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cc_realm_kerberos_membership_call_leave() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cc_realm_kerberos_membership_call_leave_sync (
    CcRealmKerberosMembership *proxy,
    GVariant *arg_credentials,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Leave",
    g_variant_new ("(@(ssv)@a{sv})",
                   arg_credentials,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cc_realm_kerberos_membership_complete_join:
 * @object: A #CcRealmKerberosMembership.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-realmd-KerberosMembership.Join">Join()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cc_realm_kerberos_membership_complete_join (
    CcRealmKerberosMembership *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * cc_realm_kerberos_membership_complete_leave:
 * @object: A #CcRealmKerberosMembership.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-realmd-KerberosMembership.Leave">Leave()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cc_realm_kerberos_membership_complete_leave (
    CcRealmKerberosMembership *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * CcRealmKerberosMembershipProxy:
 *
 * The #CcRealmKerberosMembershipProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CcRealmKerberosMembershipProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CcRealmKerberosMembershipProxy.
 */

struct _CcRealmKerberosMembershipProxyPrivate
{
  GData *qdata;
};

static void cc_realm_kerberos_membership_proxy_iface_init (CcRealmKerberosMembershipIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CcRealmKerberosMembershipProxy, cc_realm_kerberos_membership_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (CcRealmKerberosMembershipProxy)
                         G_IMPLEMENT_INTERFACE (CC_REALM_TYPE_KERBEROS_MEMBERSHIP, cc_realm_kerberos_membership_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CcRealmKerberosMembershipProxy, cc_realm_kerberos_membership_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (CC_REALM_TYPE_KERBEROS_MEMBERSHIP, cc_realm_kerberos_membership_proxy_iface_init))

#endif
static void
cc_realm_kerberos_membership_proxy_finalize (GObject *object)
{
  CcRealmKerberosMembershipProxy *proxy = CC_REALM_KERBEROS_MEMBERSHIP_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (cc_realm_kerberos_membership_proxy_parent_class)->finalize (object);
}

static void
cc_realm_kerberos_membership_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _cc_realm_kerberos_membership_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
cc_realm_kerberos_membership_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.realmd.KerberosMembership: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
cc_realm_kerberos_membership_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _cc_realm_kerberos_membership_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.realmd.KerberosMembership", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) cc_realm_kerberos_membership_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
cc_realm_kerberos_membership_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_cc_realm_kerberos_membership_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], CC_REALM_TYPE_KERBEROS_MEMBERSHIP);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CC_REALM_TYPE_KERBEROS_MEMBERSHIP);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
cc_realm_kerberos_membership_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  CcRealmKerberosMembershipProxy *proxy = CC_REALM_KERBEROS_MEMBERSHIP_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_realm_kerberos_membership_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_realm_kerberos_membership_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
cc_realm_kerberos_membership_proxy_get_suggested_administrator (CcRealmKerberosMembership *object)
{
  CcRealmKerberosMembershipProxy *proxy = CC_REALM_KERBEROS_MEMBERSHIP_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SuggestedAdministrator");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
cc_realm_kerberos_membership_proxy_get_supported_join_credentials (CcRealmKerberosMembership *object)
{
  CcRealmKerberosMembershipProxy *proxy = CC_REALM_KERBEROS_MEMBERSHIP_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SupportedJoinCredentials");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
cc_realm_kerberos_membership_proxy_get_supported_leave_credentials (CcRealmKerberosMembership *object)
{
  CcRealmKerberosMembershipProxy *proxy = CC_REALM_KERBEROS_MEMBERSHIP_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SupportedLeaveCredentials");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static void
cc_realm_kerberos_membership_proxy_init (CcRealmKerberosMembershipProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = cc_realm_kerberos_membership_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, CC_REALM_TYPE_KERBEROS_MEMBERSHIP_PROXY, CcRealmKerberosMembershipProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), cc_realm_kerberos_membership_interface_info ());
}

static void
cc_realm_kerberos_membership_proxy_class_init (CcRealmKerberosMembershipProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = cc_realm_kerberos_membership_proxy_finalize;
  gobject_class->get_property = cc_realm_kerberos_membership_proxy_get_property;
  gobject_class->set_property = cc_realm_kerberos_membership_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = cc_realm_kerberos_membership_proxy_g_signal;
  proxy_class->g_properties_changed = cc_realm_kerberos_membership_proxy_g_properties_changed;

  cc_realm_kerberos_membership_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CcRealmKerberosMembershipProxyPrivate));
#endif
}

static void
cc_realm_kerberos_membership_proxy_iface_init (CcRealmKerberosMembershipIface *iface)
{
  iface->get_suggested_administrator = cc_realm_kerberos_membership_proxy_get_suggested_administrator;
  iface->get_supported_join_credentials = cc_realm_kerberos_membership_proxy_get_supported_join_credentials;
  iface->get_supported_leave_credentials = cc_realm_kerberos_membership_proxy_get_supported_leave_credentials;
}

/**
 * cc_realm_kerberos_membership_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-KerberosMembership.top_of_page">org.freedesktop.realmd.KerberosMembership</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_realm_kerberos_membership_proxy_new_finish() to get the result of the operation.
 *
 * See cc_realm_kerberos_membership_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
cc_realm_kerberos_membership_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CC_REALM_TYPE_KERBEROS_MEMBERSHIP_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.KerberosMembership", NULL);
}

/**
 * cc_realm_kerberos_membership_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_realm_kerberos_membership_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with cc_realm_kerberos_membership_proxy_new().
 *
 * Returns: (transfer full) (type CcRealmKerberosMembershipProxy): The constructed proxy object or %NULL if @error is set.
 */
CcRealmKerberosMembership *
cc_realm_kerberos_membership_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CC_REALM_KERBEROS_MEMBERSHIP (ret);
  else
    return NULL;
}

/**
 * cc_realm_kerberos_membership_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-KerberosMembership.top_of_page">org.freedesktop.realmd.KerberosMembership</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See cc_realm_kerberos_membership_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CcRealmKerberosMembershipProxy): The constructed proxy object or %NULL if @error is set.
 */
CcRealmKerberosMembership *
cc_realm_kerberos_membership_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CC_REALM_TYPE_KERBEROS_MEMBERSHIP_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.KerberosMembership", NULL);
  if (ret != NULL)
    return CC_REALM_KERBEROS_MEMBERSHIP (ret);
  else
    return NULL;
}


/**
 * cc_realm_kerberos_membership_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like cc_realm_kerberos_membership_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_realm_kerberos_membership_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See cc_realm_kerberos_membership_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
cc_realm_kerberos_membership_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CC_REALM_TYPE_KERBEROS_MEMBERSHIP_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.KerberosMembership", NULL);
}

/**
 * cc_realm_kerberos_membership_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_realm_kerberos_membership_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with cc_realm_kerberos_membership_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type CcRealmKerberosMembershipProxy): The constructed proxy object or %NULL if @error is set.
 */
CcRealmKerberosMembership *
cc_realm_kerberos_membership_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CC_REALM_KERBEROS_MEMBERSHIP (ret);
  else
    return NULL;
}

/**
 * cc_realm_kerberos_membership_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like cc_realm_kerberos_membership_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See cc_realm_kerberos_membership_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CcRealmKerberosMembershipProxy): The constructed proxy object or %NULL if @error is set.
 */
CcRealmKerberosMembership *
cc_realm_kerberos_membership_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CC_REALM_TYPE_KERBEROS_MEMBERSHIP_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.KerberosMembership", NULL);
  if (ret != NULL)
    return CC_REALM_KERBEROS_MEMBERSHIP (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * CcRealmKerberosMembershipSkeleton:
 *
 * The #CcRealmKerberosMembershipSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CcRealmKerberosMembershipSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CcRealmKerberosMembershipSkeleton.
 */

struct _CcRealmKerberosMembershipSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_cc_realm_kerberos_membership_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  CcRealmKerberosMembershipSkeleton *skeleton = CC_REALM_KERBEROS_MEMBERSHIP_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], CC_REALM_TYPE_KERBEROS_MEMBERSHIP);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CC_REALM_TYPE_KERBEROS_MEMBERSHIP);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_cc_realm_kerberos_membership_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  CcRealmKerberosMembershipSkeleton *skeleton = CC_REALM_KERBEROS_MEMBERSHIP_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_realm_kerberos_membership_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_cc_realm_kerberos_membership_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  CcRealmKerberosMembershipSkeleton *skeleton = CC_REALM_KERBEROS_MEMBERSHIP_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cc_realm_kerberos_membership_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _cc_realm_kerberos_membership_skeleton_vtable =
{
  _cc_realm_kerberos_membership_skeleton_handle_method_call,
  _cc_realm_kerberos_membership_skeleton_handle_get_property,
  _cc_realm_kerberos_membership_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
cc_realm_kerberos_membership_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return cc_realm_kerberos_membership_interface_info ();
}

static GDBusInterfaceVTable *
cc_realm_kerberos_membership_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_cc_realm_kerberos_membership_skeleton_vtable;
}

static GVariant *
cc_realm_kerberos_membership_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  CcRealmKerberosMembershipSkeleton *skeleton = CC_REALM_KERBEROS_MEMBERSHIP_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_cc_realm_kerberos_membership_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _cc_realm_kerberos_membership_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _cc_realm_kerberos_membership_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _cc_realm_kerberos_membership_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.realmd.KerberosMembership", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _cc_realm_kerberos_membership_emit_changed (gpointer user_data);

static void
cc_realm_kerberos_membership_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  CcRealmKerberosMembershipSkeleton *skeleton = CC_REALM_KERBEROS_MEMBERSHIP_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _cc_realm_kerberos_membership_emit_changed (skeleton);
}

static void cc_realm_kerberos_membership_skeleton_iface_init (CcRealmKerberosMembershipIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CcRealmKerberosMembershipSkeleton, cc_realm_kerberos_membership_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (CcRealmKerberosMembershipSkeleton)
                         G_IMPLEMENT_INTERFACE (CC_REALM_TYPE_KERBEROS_MEMBERSHIP, cc_realm_kerberos_membership_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CcRealmKerberosMembershipSkeleton, cc_realm_kerberos_membership_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (CC_REALM_TYPE_KERBEROS_MEMBERSHIP, cc_realm_kerberos_membership_skeleton_iface_init))

#endif
static void
cc_realm_kerberos_membership_skeleton_finalize (GObject *object)
{
  CcRealmKerberosMembershipSkeleton *skeleton = CC_REALM_KERBEROS_MEMBERSHIP_SKELETON (object);
  guint n;
  for (n = 0; n < 3; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (cc_realm_kerberos_membership_skeleton_parent_class)->finalize (object);
}

static void
cc_realm_kerberos_membership_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  CcRealmKerberosMembershipSkeleton *skeleton = CC_REALM_KERBEROS_MEMBERSHIP_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_cc_realm_kerberos_membership_emit_changed (gpointer user_data)
{
  CcRealmKerberosMembershipSkeleton *skeleton = CC_REALM_KERBEROS_MEMBERSHIP_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.realmd.KerberosMembership",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_cc_realm_kerberos_membership_schedule_emit_changed (CcRealmKerberosMembershipSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
cc_realm_kerberos_membership_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  CcRealmKerberosMembershipSkeleton *skeleton = CC_REALM_KERBEROS_MEMBERSHIP_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _cc_realm_kerberos_membership_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _cc_realm_kerberos_membership_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
cc_realm_kerberos_membership_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  CcRealmKerberosMembershipSkeleton *skeleton = CC_REALM_KERBEROS_MEMBERSHIP_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _cc_realm_kerberos_membership_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _cc_realm_kerberos_membership_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
cc_realm_kerberos_membership_skeleton_init (CcRealmKerberosMembershipSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = cc_realm_kerberos_membership_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, CC_REALM_TYPE_KERBEROS_MEMBERSHIP_SKELETON, CcRealmKerberosMembershipSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 3);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_VARIANT);
}

static const gchar *
cc_realm_kerberos_membership_skeleton_get_suggested_administrator (CcRealmKerberosMembership *object)
{
  CcRealmKerberosMembershipSkeleton *skeleton = CC_REALM_KERBEROS_MEMBERSHIP_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
cc_realm_kerberos_membership_skeleton_get_supported_join_credentials (CcRealmKerberosMembership *object)
{
  CcRealmKerberosMembershipSkeleton *skeleton = CC_REALM_KERBEROS_MEMBERSHIP_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
cc_realm_kerberos_membership_skeleton_get_supported_leave_credentials (CcRealmKerberosMembership *object)
{
  CcRealmKerberosMembershipSkeleton *skeleton = CC_REALM_KERBEROS_MEMBERSHIP_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
cc_realm_kerberos_membership_skeleton_class_init (CcRealmKerberosMembershipSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = cc_realm_kerberos_membership_skeleton_finalize;
  gobject_class->get_property = cc_realm_kerberos_membership_skeleton_get_property;
  gobject_class->set_property = cc_realm_kerberos_membership_skeleton_set_property;
  gobject_class->notify       = cc_realm_kerberos_membership_skeleton_notify;


  cc_realm_kerberos_membership_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = cc_realm_kerberos_membership_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = cc_realm_kerberos_membership_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = cc_realm_kerberos_membership_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = cc_realm_kerberos_membership_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CcRealmKerberosMembershipSkeletonPrivate));
#endif
}

static void
cc_realm_kerberos_membership_skeleton_iface_init (CcRealmKerberosMembershipIface *iface)
{
  iface->get_suggested_administrator = cc_realm_kerberos_membership_skeleton_get_suggested_administrator;
  iface->get_supported_join_credentials = cc_realm_kerberos_membership_skeleton_get_supported_join_credentials;
  iface->get_supported_leave_credentials = cc_realm_kerberos_membership_skeleton_get_supported_leave_credentials;
}

/**
 * cc_realm_kerberos_membership_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-KerberosMembership.top_of_page">org.freedesktop.realmd.KerberosMembership</link>.
 *
 * Returns: (transfer full) (type CcRealmKerberosMembershipSkeleton): The skeleton object.
 */
CcRealmKerberosMembership *
cc_realm_kerberos_membership_skeleton_new (void)
{
  return CC_REALM_KERBEROS_MEMBERSHIP (g_object_new (CC_REALM_TYPE_KERBEROS_MEMBERSHIP_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for Object, ObjectProxy and ObjectSkeleton
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:CcRealmObject
 * @title: CcRealmObject
 * @short_description: Specialized GDBusObject types
 *
 * This section contains the #CcRealmObject, #CcRealmObjectProxy, and #CcRealmObjectSkeleton types which make it easier to work with objects implementing generated types for D-Bus interfaces.
 */

/**
 * CcRealmObject:
 *
 * The #CcRealmObject type is a specialized container of interfaces.
 */

/**
 * CcRealmObjectIface:
 * @parent_iface: The parent interface.
 *
 * Virtual table for the #CcRealmObject interface.
 */

typedef CcRealmObjectIface CcRealmObjectInterface;
G_DEFINE_INTERFACE_WITH_CODE (CcRealmObject, cc_realm_object, G_TYPE_OBJECT, g_type_interface_add_prerequisite (g_define_type_id, G_TYPE_DBUS_OBJECT);)

static void
cc_realm_object_default_init (CcRealmObjectIface *iface)
{
  /**
   * CcRealmObject:provider:
   *
   * The #CcRealmProvider instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Provider.top_of_page">org.freedesktop.realmd.Provider</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("provider", "provider", "provider", CC_REALM_TYPE_PROVIDER, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

  /**
   * CcRealmObject:service:
   *
   * The #CcRealmService instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Service.top_of_page">org.freedesktop.realmd.Service</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("service", "service", "service", CC_REALM_TYPE_SERVICE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

  /**
   * CcRealmObject:common:
   *
   * The #CcRealmCommon instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Realm.top_of_page">org.freedesktop.realmd.Realm</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("common", "common", "common", CC_REALM_TYPE_COMMON, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

  /**
   * CcRealmObject:kerberos:
   *
   * The #CcRealmKerberos instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Kerberos.top_of_page">org.freedesktop.realmd.Kerberos</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("kerberos", "kerberos", "kerberos", CC_REALM_TYPE_KERBEROS, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

  /**
   * CcRealmObject:kerberos-membership:
   *
   * The #CcRealmKerberosMembership instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-KerberosMembership.top_of_page">org.freedesktop.realmd.KerberosMembership</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("kerberos-membership", "kerberos-membership", "kerberos-membership", CC_REALM_TYPE_KERBEROS_MEMBERSHIP, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

}

/**
 * cc_realm_object_get_provider:
 * @object: A #CcRealmObject.
 *
 * Gets the #CcRealmProvider instance for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Provider.top_of_page">org.freedesktop.realmd.Provider</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #CcRealmProvider that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
CcRealmProvider *cc_realm_object_get_provider (CcRealmObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.freedesktop.realmd.Provider");
  if (ret == NULL)
    return NULL;
  return CC_REALM_PROVIDER (ret);
}

/**
 * cc_realm_object_get_service:
 * @object: A #CcRealmObject.
 *
 * Gets the #CcRealmService instance for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Service.top_of_page">org.freedesktop.realmd.Service</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #CcRealmService that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
CcRealmService *cc_realm_object_get_service (CcRealmObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.freedesktop.realmd.Service");
  if (ret == NULL)
    return NULL;
  return CC_REALM_SERVICE (ret);
}

/**
 * cc_realm_object_get_common:
 * @object: A #CcRealmObject.
 *
 * Gets the #CcRealmCommon instance for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Realm.top_of_page">org.freedesktop.realmd.Realm</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #CcRealmCommon that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
CcRealmCommon *cc_realm_object_get_common (CcRealmObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.freedesktop.realmd.Realm");
  if (ret == NULL)
    return NULL;
  return CC_REALM_COMMON (ret);
}

/**
 * cc_realm_object_get_kerberos:
 * @object: A #CcRealmObject.
 *
 * Gets the #CcRealmKerberos instance for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Kerberos.top_of_page">org.freedesktop.realmd.Kerberos</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #CcRealmKerberos that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
CcRealmKerberos *cc_realm_object_get_kerberos (CcRealmObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.freedesktop.realmd.Kerberos");
  if (ret == NULL)
    return NULL;
  return CC_REALM_KERBEROS (ret);
}

/**
 * cc_realm_object_get_kerberos_membership:
 * @object: A #CcRealmObject.
 *
 * Gets the #CcRealmKerberosMembership instance for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-KerberosMembership.top_of_page">org.freedesktop.realmd.KerberosMembership</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #CcRealmKerberosMembership that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
CcRealmKerberosMembership *cc_realm_object_get_kerberos_membership (CcRealmObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.freedesktop.realmd.KerberosMembership");
  if (ret == NULL)
    return NULL;
  return CC_REALM_KERBEROS_MEMBERSHIP (ret);
}


/**
 * cc_realm_object_peek_provider: (skip)
 * @object: A #CcRealmObject.
 *
 * Like cc_realm_object_get_provider() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #CcRealmProvider or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
CcRealmProvider *cc_realm_object_peek_provider (CcRealmObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.freedesktop.realmd.Provider");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return CC_REALM_PROVIDER (ret);
}

/**
 * cc_realm_object_peek_service: (skip)
 * @object: A #CcRealmObject.
 *
 * Like cc_realm_object_get_service() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #CcRealmService or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
CcRealmService *cc_realm_object_peek_service (CcRealmObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.freedesktop.realmd.Service");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return CC_REALM_SERVICE (ret);
}

/**
 * cc_realm_object_peek_common: (skip)
 * @object: A #CcRealmObject.
 *
 * Like cc_realm_object_get_common() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #CcRealmCommon or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
CcRealmCommon *cc_realm_object_peek_common (CcRealmObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.freedesktop.realmd.Realm");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return CC_REALM_COMMON (ret);
}

/**
 * cc_realm_object_peek_kerberos: (skip)
 * @object: A #CcRealmObject.
 *
 * Like cc_realm_object_get_kerberos() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #CcRealmKerberos or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
CcRealmKerberos *cc_realm_object_peek_kerberos (CcRealmObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.freedesktop.realmd.Kerberos");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return CC_REALM_KERBEROS (ret);
}

/**
 * cc_realm_object_peek_kerberos_membership: (skip)
 * @object: A #CcRealmObject.
 *
 * Like cc_realm_object_get_kerberos_membership() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #CcRealmKerberosMembership or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
CcRealmKerberosMembership *cc_realm_object_peek_kerberos_membership (CcRealmObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.freedesktop.realmd.KerberosMembership");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return CC_REALM_KERBEROS_MEMBERSHIP (ret);
}


static void
cc_realm_object_notify (GDBusObject *object, GDBusInterface *interface)
{
  _ExtendedGDBusInterfaceInfo *info = (_ExtendedGDBusInterfaceInfo *) g_dbus_interface_get_info (interface);
  /* info can be NULL if the other end is using a D-Bus interface we don't know
   * anything about, for example old generated code in this process talking to
   * newer generated code in the other process. */
  if (info != NULL)
    g_object_notify (G_OBJECT (object), info->hyphen_name);
}

/**
 * CcRealmObjectProxy:
 *
 * The #CcRealmObjectProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CcRealmObjectProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CcRealmObjectProxy.
 */

static void
cc_realm_object_proxy__cc_realm_object_iface_init (CcRealmObjectIface *iface G_GNUC_UNUSED)
{
}

static void
cc_realm_object_proxy__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = cc_realm_object_notify;
  iface->interface_removed = cc_realm_object_notify;
}


G_DEFINE_TYPE_WITH_CODE (CcRealmObjectProxy, cc_realm_object_proxy, G_TYPE_DBUS_OBJECT_PROXY,
                         G_IMPLEMENT_INTERFACE (CC_REALM_TYPE_OBJECT, cc_realm_object_proxy__cc_realm_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, cc_realm_object_proxy__g_dbus_object_iface_init))

static void
cc_realm_object_proxy_init (CcRealmObjectProxy *object G_GNUC_UNUSED)
{
}

static void
cc_realm_object_proxy_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec)
{
  G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
}

static void
cc_realm_object_proxy_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  CcRealmObjectProxy *object = CC_REALM_OBJECT_PROXY (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.freedesktop.realmd.Provider");
      g_value_take_object (value, interface);
      break;

    case 2:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.freedesktop.realmd.Service");
      g_value_take_object (value, interface);
      break;

    case 3:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.freedesktop.realmd.Realm");
      g_value_take_object (value, interface);
      break;

    case 4:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.freedesktop.realmd.Kerberos");
      g_value_take_object (value, interface);
      break;

    case 5:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.freedesktop.realmd.KerberosMembership");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
cc_realm_object_proxy_class_init (CcRealmObjectProxyClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = cc_realm_object_proxy_set_property;
  gobject_class->get_property = cc_realm_object_proxy_get_property;

  g_object_class_override_property (gobject_class, 1, "provider");
  g_object_class_override_property (gobject_class, 2, "service");
  g_object_class_override_property (gobject_class, 3, "common");
  g_object_class_override_property (gobject_class, 4, "kerberos");
  g_object_class_override_property (gobject_class, 5, "kerberos-membership");
}

/**
 * cc_realm_object_proxy_new:
 * @connection: A #GDBusConnection.
 * @object_path: An object path.
 *
 * Creates a new proxy object.
 *
 * Returns: (transfer full): The proxy object.
 */
CcRealmObjectProxy *
cc_realm_object_proxy_new (GDBusConnection *connection,
  const gchar *object_path)
{
  g_return_val_if_fail (G_IS_DBUS_CONNECTION (connection), NULL);
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return CC_REALM_OBJECT_PROXY (g_object_new (CC_REALM_TYPE_OBJECT_PROXY, "g-connection", connection, "g-object-path", object_path, NULL));
}

/**
 * CcRealmObjectSkeleton:
 *
 * The #CcRealmObjectSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CcRealmObjectSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CcRealmObjectSkeleton.
 */

static void
cc_realm_object_skeleton__cc_realm_object_iface_init (CcRealmObjectIface *iface G_GNUC_UNUSED)
{
}


static void
cc_realm_object_skeleton__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = cc_realm_object_notify;
  iface->interface_removed = cc_realm_object_notify;
}

G_DEFINE_TYPE_WITH_CODE (CcRealmObjectSkeleton, cc_realm_object_skeleton, G_TYPE_DBUS_OBJECT_SKELETON,
                         G_IMPLEMENT_INTERFACE (CC_REALM_TYPE_OBJECT, cc_realm_object_skeleton__cc_realm_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, cc_realm_object_skeleton__g_dbus_object_iface_init))

static void
cc_realm_object_skeleton_init (CcRealmObjectSkeleton *object G_GNUC_UNUSED)
{
}

static void
cc_realm_object_skeleton_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  CcRealmObjectSkeleton *object = CC_REALM_OBJECT_SKELETON (gobject);
  GDBusInterfaceSkeleton *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (CC_REALM_IS_PROVIDER (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.freedesktop.realmd.Provider");
        }
      break;

    case 2:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (CC_REALM_IS_SERVICE (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.freedesktop.realmd.Service");
        }
      break;

    case 3:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (CC_REALM_IS_COMMON (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.freedesktop.realmd.Realm");
        }
      break;

    case 4:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (CC_REALM_IS_KERBEROS (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.freedesktop.realmd.Kerberos");
        }
      break;

    case 5:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (CC_REALM_IS_KERBEROS_MEMBERSHIP (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.freedesktop.realmd.KerberosMembership");
        }
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
cc_realm_object_skeleton_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  CcRealmObjectSkeleton *object = CC_REALM_OBJECT_SKELETON (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.freedesktop.realmd.Provider");
      g_value_take_object (value, interface);
      break;

    case 2:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.freedesktop.realmd.Service");
      g_value_take_object (value, interface);
      break;

    case 3:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.freedesktop.realmd.Realm");
      g_value_take_object (value, interface);
      break;

    case 4:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.freedesktop.realmd.Kerberos");
      g_value_take_object (value, interface);
      break;

    case 5:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.freedesktop.realmd.KerberosMembership");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
cc_realm_object_skeleton_class_init (CcRealmObjectSkeletonClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = cc_realm_object_skeleton_set_property;
  gobject_class->get_property = cc_realm_object_skeleton_get_property;

  g_object_class_override_property (gobject_class, 1, "provider");
  g_object_class_override_property (gobject_class, 2, "service");
  g_object_class_override_property (gobject_class, 3, "common");
  g_object_class_override_property (gobject_class, 4, "kerberos");
  g_object_class_override_property (gobject_class, 5, "kerberos-membership");
}

/**
 * cc_realm_object_skeleton_new:
 * @object_path: An object path.
 *
 * Creates a new skeleton object.
 *
 * Returns: (transfer full): The skeleton object.
 */
CcRealmObjectSkeleton *
cc_realm_object_skeleton_new (const gchar *object_path)
{
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return CC_REALM_OBJECT_SKELETON (g_object_new (CC_REALM_TYPE_OBJECT_SKELETON, "g-object-path", object_path, NULL));
}

/**
 * cc_realm_object_skeleton_set_provider:
 * @object: A #CcRealmObjectSkeleton.
 * @interface_: (nullable): A #CcRealmProvider or %NULL to clear the interface.
 *
 * Sets the #CcRealmProvider instance for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Provider.top_of_page">org.freedesktop.realmd.Provider</link> on @object.
 */
void cc_realm_object_skeleton_set_provider (CcRealmObjectSkeleton *object, CcRealmProvider *interface_)
{
  g_object_set (G_OBJECT (object), "provider", interface_, NULL);
}

/**
 * cc_realm_object_skeleton_set_service:
 * @object: A #CcRealmObjectSkeleton.
 * @interface_: (nullable): A #CcRealmService or %NULL to clear the interface.
 *
 * Sets the #CcRealmService instance for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Service.top_of_page">org.freedesktop.realmd.Service</link> on @object.
 */
void cc_realm_object_skeleton_set_service (CcRealmObjectSkeleton *object, CcRealmService *interface_)
{
  g_object_set (G_OBJECT (object), "service", interface_, NULL);
}

/**
 * cc_realm_object_skeleton_set_common:
 * @object: A #CcRealmObjectSkeleton.
 * @interface_: (nullable): A #CcRealmCommon or %NULL to clear the interface.
 *
 * Sets the #CcRealmCommon instance for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Realm.top_of_page">org.freedesktop.realmd.Realm</link> on @object.
 */
void cc_realm_object_skeleton_set_common (CcRealmObjectSkeleton *object, CcRealmCommon *interface_)
{
  g_object_set (G_OBJECT (object), "common", interface_, NULL);
}

/**
 * cc_realm_object_skeleton_set_kerberos:
 * @object: A #CcRealmObjectSkeleton.
 * @interface_: (nullable): A #CcRealmKerberos or %NULL to clear the interface.
 *
 * Sets the #CcRealmKerberos instance for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Kerberos.top_of_page">org.freedesktop.realmd.Kerberos</link> on @object.
 */
void cc_realm_object_skeleton_set_kerberos (CcRealmObjectSkeleton *object, CcRealmKerberos *interface_)
{
  g_object_set (G_OBJECT (object), "kerberos", interface_, NULL);
}

/**
 * cc_realm_object_skeleton_set_kerberos_membership:
 * @object: A #CcRealmObjectSkeleton.
 * @interface_: (nullable): A #CcRealmKerberosMembership or %NULL to clear the interface.
 *
 * Sets the #CcRealmKerberosMembership instance for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-KerberosMembership.top_of_page">org.freedesktop.realmd.KerberosMembership</link> on @object.
 */
void cc_realm_object_skeleton_set_kerberos_membership (CcRealmObjectSkeleton *object, CcRealmKerberosMembership *interface_)
{
  g_object_set (G_OBJECT (object), "kerberos-membership", interface_, NULL);
}


/* ------------------------------------------------------------------------
 * Code for ObjectManager client
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:CcRealmObjectManagerClient
 * @title: CcRealmObjectManagerClient
 * @short_description: Generated GDBusObjectManagerClient type
 *
 * This section contains a #GDBusObjectManagerClient that uses cc_realm_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc.
 */

/**
 * CcRealmObjectManagerClient:
 *
 * The #CcRealmObjectManagerClient structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CcRealmObjectManagerClientClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CcRealmObjectManagerClient.
 */

G_DEFINE_TYPE (CcRealmObjectManagerClient, cc_realm_object_manager_client, G_TYPE_DBUS_OBJECT_MANAGER_CLIENT)

static void
cc_realm_object_manager_client_init (CcRealmObjectManagerClient *manager G_GNUC_UNUSED)
{
}

static void
cc_realm_object_manager_client_class_init (CcRealmObjectManagerClientClass *klass G_GNUC_UNUSED)
{
}

/**
 * cc_realm_object_manager_client_get_proxy_type:
 * @manager: A #GDBusObjectManagerClient.
 * @object_path: The object path of the remote object (unused).
 * @interface_name: (nullable): Interface name of the remote object or %NULL to get the object proxy #GType.
 * @user_data: User data (unused).
 *
 * A #GDBusProxyTypeFunc that maps @interface_name to the generated #GDBusObjectProxy derived and #GDBusProxy derived types.
 *
 * Returns: A #GDBusProxy derived #GType if @interface_name is not %NULL, otherwise the #GType for #CcRealmObjectProxy.
 */
GType
cc_realm_object_manager_client_get_proxy_type (GDBusObjectManagerClient *manager G_GNUC_UNUSED, const gchar *object_path G_GNUC_UNUSED, const gchar *interface_name, gpointer user_data G_GNUC_UNUSED)
{
  static gsize once_init_value = 0;
  static GHashTable *lookup_hash;
  GType ret;

  if (interface_name == NULL)
    return CC_REALM_TYPE_OBJECT_PROXY;
  if (g_once_init_enter (&once_init_value))
    {
      lookup_hash = g_hash_table_new (g_str_hash, g_str_equal);
      g_hash_table_insert (lookup_hash, (gpointer) "org.freedesktop.realmd.Provider", (gpointer) (guintptr) (CC_REALM_TYPE_PROVIDER_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.freedesktop.realmd.Service", (gpointer) (guintptr) (CC_REALM_TYPE_SERVICE_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.freedesktop.realmd.Realm", (gpointer) (guintptr) (CC_REALM_TYPE_COMMON_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.freedesktop.realmd.Kerberos", (gpointer) (guintptr) (CC_REALM_TYPE_KERBEROS_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.freedesktop.realmd.KerberosMembership", (gpointer) (guintptr) (CC_REALM_TYPE_KERBEROS_MEMBERSHIP_PROXY));
      g_once_init_leave (&once_init_value, 1);
    }
  ret = (GType) (guintptr) (g_hash_table_lookup (lookup_hash, interface_name));
  if (ret == (GType) 0)
    ret = G_TYPE_DBUS_PROXY;
  return ret;
}

/**
 * cc_realm_object_manager_client_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates #GDBusObjectManagerClient using cc_realm_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_realm_object_manager_client_new_finish() to get the result of the operation.
 *
 * See cc_realm_object_manager_client_new_sync() for the synchronous, blocking version of this constructor.
 */
void
cc_realm_object_manager_client_new (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (CC_REALM_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", cc_realm_object_manager_client_get_proxy_type, NULL);
}

/**
 * cc_realm_object_manager_client_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_realm_object_manager_client_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with cc_realm_object_manager_client_new().
 *
 * Returns: (transfer full) (type CcRealmObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
cc_realm_object_manager_client_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * cc_realm_object_manager_client_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates #GDBusObjectManagerClient using cc_realm_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See cc_realm_object_manager_client_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CcRealmObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
cc_realm_object_manager_client_new_sync (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (CC_REALM_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", cc_realm_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


/**
 * cc_realm_object_manager_client_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like cc_realm_object_manager_client_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cc_realm_object_manager_client_new_for_bus_finish() to get the result of the operation.
 *
 * See cc_realm_object_manager_client_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
cc_realm_object_manager_client_new_for_bus (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (CC_REALM_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", cc_realm_object_manager_client_get_proxy_type, NULL);
}

/**
 * cc_realm_object_manager_client_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cc_realm_object_manager_client_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with cc_realm_object_manager_client_new_for_bus().
 *
 * Returns: (transfer full) (type CcRealmObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
cc_realm_object_manager_client_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * cc_realm_object_manager_client_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like cc_realm_object_manager_client_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See cc_realm_object_manager_client_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CcRealmObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
cc_realm_object_manager_client_new_for_bus_sync (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (CC_REALM_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", cc_realm_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


