/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_constellation = R"doc(An abstracted constellation object.

The constellation objects hold the necessary information to pass around constellation information for modulators and demodulators. These objects contain the mapping between the bits and the constellation points used to represent them as well as methods for slicing the symbol space. Various implementations are possible for efficiency and ease of use.


Standard constellations (BPSK, QPSK, QAM, etc) can be inherited from this class and overloaded to perform optimized slicing and constellation mappings.)doc";


static const char* __doc_gr_digital_constellation_constellation_0 = R"doc()doc";


static const char* __doc_gr_digital_constellation_constellation_1 = R"doc()doc";


static const char* __doc_gr_digital_constellation_constellation_2 = R"doc()doc";


static const char* __doc_gr_digital_constellation_map_to_points = R"doc(Returns the constellation points for a symbol value.)doc";


static const char* __doc_gr_digital_constellation_map_to_points_v = R"doc()doc";


static const char* __doc_gr_digital_constellation_decision_maker = R"doc(Returns the constellation point that matches best.)doc";


static const char* __doc_gr_digital_constellation_decision_maker_v = R"doc(Takes a vector rather than a pointer. Better for SWIG wrapping.)doc";


static const char* __doc_gr_digital_constellation_decision_maker_pe = R"doc(Also calculates the phase error.)doc";


static const char* __doc_gr_digital_constellation_calc_metric = R"doc(Calculates distance.

Calculates metrics for all points in the constellation. For use with the viterbi algorithm.)doc";


static const char* __doc_gr_digital_constellation_calc_euclidean_metric = R"doc()doc";


static const char* __doc_gr_digital_constellation_calc_hard_symbol_metric = R"doc()doc";


static const char* __doc_gr_digital_constellation_points = R"doc(Returns the set of points in this constellation.)doc";


static const char* __doc_gr_digital_constellation_s_points = R"doc(Returns the vector of points in this constellation. Raise error if dimensionality is not one.)doc";


static const char* __doc_gr_digital_constellation_v_points = R"doc(Returns a vector of vectors of points.)doc";


static const char* __doc_gr_digital_constellation_apply_pre_diff_code = R"doc(Whether to apply an encoding before doing differential encoding. (e.g. gray coding))doc";


static const char* __doc_gr_digital_constellation_set_pre_diff_code = R"doc(Whether to apply an encoding before doing differential encoding. (e.g. gray coding))doc";


static const char* __doc_gr_digital_constellation_pre_diff_code = R"doc(Returns the encoding to apply before differential encoding.)doc";


static const char* __doc_gr_digital_constellation_rotational_symmetry = R"doc(Returns the order of rotational symmetry.)doc";


static const char* __doc_gr_digital_constellation_dimensionality = R"doc(Returns the number of complex numbers in a single symbol.)doc";


static const char* __doc_gr_digital_constellation_bits_per_symbol = R"doc()doc";


static const char* __doc_gr_digital_constellation_arity = R"doc()doc";


static const char* __doc_gr_digital_constellation_base = R"doc()doc";


static const char* __doc_gr_digital_constellation_as_pmt = R"doc()doc";


static const char* __doc_gr_digital_constellation_gen_soft_dec_lut = R"doc(Generates the soft decision LUT based on constellation and symbol map.

Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



This is expensive to compute.)doc";


static const char* __doc_gr_digital_constellation_calc_soft_dec = R"doc(Calculate soft decisions for the given .

Calculate the soft decisions from the given  at the given noise power .


This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.)doc";


static const char* __doc_gr_digital_constellation_set_soft_dec_lut = R"doc(Define a soft decision look-up table.

Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.)doc";


static const char* __doc_gr_digital_constellation_set_npwr = R"doc(Sets the constellation noise power and recalculates LUT given .

Sets the constellation noise power and recalculates LUT given . If a LUT was defined via manual entry of a table, it will be a left alone. Otherwise, the LUT will be recalculated with the new noise power. This member is used by calc_soft_dec primarily.)doc";


static const char* __doc_gr_digital_constellation_normalize = R"doc(Normalizes the constellation.)doc";


static const char* __doc_gr_digital_constellation_has_soft_dec_lut = R"doc(Returns True if the soft decision LUT has been defined, False otherwise.)doc";


static const char* __doc_gr_digital_constellation_soft_dec_lut = R"doc()doc";


static const char* __doc_gr_digital_constellation_soft_decision_maker = R"doc(Returns the soft decisions for the given .

Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.)doc";


static const char* __doc_gr_digital_constellation_calcdist = R"doc(Calculate Euclidean distance for any constellation.

Constellation which calculates the distance to each point in the constellation for decision making. Inefficient for large constellations.

Constructor Specific Documentation:

Make a general constellation object that calculates the Euclidean distance for hard decisions.

Args:
    constell : List of constellation points (order of list matches pre_diff_code)
    pre_diff_code : List of alphabet symbols (before applying any differential coding) (order of list matches constell)
    rotational_symmetry : Number of rotations around unit circle that have the same representation.
    dimensionality : Number of dimensions to the constellation.
    normalization : Use AMPLITUDE_NORMALIZATION to normalize points to mean(abs(points))=1 (default), POWER_NORMALIZATION to normalize points to mean(abs(points)^2)=1 or NO_NORMALIZATION to keep the original amplitude.)doc";


static const char* __doc_gr_digital_constellation_calcdist_constellation_calcdist =
    R"doc()doc";


static const char* __doc_gr_digital_constellation_calcdist_make = R"doc(Calculate Euclidean distance for any constellation.

Constellation which calculates the distance to each point in the constellation for decision making. Inefficient for large constellations.

Constructor Specific Documentation:

Make a general constellation object that calculates the Euclidean distance for hard decisions.

Args:
    constell : List of constellation points (order of list matches pre_diff_code)
    pre_diff_code : List of alphabet symbols (before applying any differential coding) (order of list matches constell)
    rotational_symmetry : Number of rotations around unit circle that have the same representation.
    dimensionality : Number of dimensions to the constellation.
    normalization : Use AMPLITUDE_NORMALIZATION to normalize points to mean(abs(points))=1 (default), POWER_NORMALIZATION to normalize points to mean(abs(points)^2)=1 or NO_NORMALIZATION to keep the original amplitude.)doc";


static const char* __doc_gr_digital_constellation_calcdist_decision_maker = R"doc(Returns the constellation point that matches best.)doc";


static const char* __doc_gr_digital_constellation_sector = R"doc(Sectorized digital constellation.

constellation_sector


Constellation space is divided into sectors. Each sector is associated with the nearest constellation point.)doc";


static const char* __doc_gr_digital_constellation_sector_constellation_sector_0 =
    R"doc()doc";


static const char* __doc_gr_digital_constellation_sector_constellation_sector_1 =
    R"doc()doc";


static const char* __doc_gr_digital_constellation_sector_decision_maker = R"doc(Returns the constellation point that matches best.)doc";


static const char* __doc_gr_digital_constellation_rect = R"doc(Rectangular digital constellation.

Only implemented for 1-(complex)dimensional constellation.


Constellation space is divided into rectangular sectors. Each sector is associated with the nearest constellation point.


Works well for square QAM.


Works for any generic constellation provided sectors are not too large.

Constructor Specific Documentation:

Make a rectangular constellation object.

Args:
    constell : List of constellation points (order of list matches pre_diff_code)
    pre_diff_code : List of alphabet symbols (before applying any differential coding) (order of list matches constell)
    rotational_symmetry : Number of rotations around unit circle that have the same representation.
    real_sectors : Number of sectors the real axis is split in to.
    imag_sectors : Number of sectors the imag axis is split in to.
    width_real_sectors : width of each real sector to calculate decision boundaries.
    width_imag_sectors : width of each imag sector to calculate decision boundaries.
    normalization : Use AMPLITUDE_NORMALIZATION to normalize points to mean(abs(points))=1 (default), POWER_NORMALIZATION to normalize points to mean(abs(points)^2)=1 or NO_NORMALIZATION to keep the original amplitude.)doc";


static const char* __doc_gr_digital_constellation_rect_constellation_rect = R"doc()doc";


static const char* __doc_gr_digital_constellation_rect_make = R"doc(Rectangular digital constellation.

Only implemented for 1-(complex)dimensional constellation.


Constellation space is divided into rectangular sectors. Each sector is associated with the nearest constellation point.


Works well for square QAM.


Works for any generic constellation provided sectors are not too large.

Constructor Specific Documentation:

Make a rectangular constellation object.

Args:
    constell : List of constellation points (order of list matches pre_diff_code)
    pre_diff_code : List of alphabet symbols (before applying any differential coding) (order of list matches constell)
    rotational_symmetry : Number of rotations around unit circle that have the same representation.
    real_sectors : Number of sectors the real axis is split in to.
    imag_sectors : Number of sectors the imag axis is split in to.
    width_real_sectors : width of each real sector to calculate decision boundaries.
    width_imag_sectors : width of each imag sector to calculate decision boundaries.
    normalization : Use AMPLITUDE_NORMALIZATION to normalize points to mean(abs(points))=1 (default), POWER_NORMALIZATION to normalize points to mean(abs(points)^2)=1 or NO_NORMALIZATION to keep the original amplitude.)doc";


static const char* __doc_gr_digital_constellation_expl_rect = R"doc(Rectangular digital constellation.

Only implemented for 1-(complex)dimensional constellation.


Constellation space is divided into rectangular sectors. Each sector is associated with the nearest constellation point.


This class is different from constellation_rect in that the mapping from sector to constellation point is explicitly passed into the constructor as sector_values. Usually we do not need this, since we want each sector to be automatically mapped to the closest constellation point, however sometimes it's nice to have the flexibility.

Constructor Specific Documentation:



Args:
    constellation : 
    pre_diff_code : 
    rotational_symmetry : 
    real_sectors : 
    imag_sectors : 
    width_real_sectors : 
    width_imag_sectors : 
    sector_values : )doc";


static const char* __doc_gr_digital_constellation_expl_rect_constellation_expl_rect =
    R"doc()doc";


static const char* __doc_gr_digital_constellation_expl_rect_make = R"doc(Rectangular digital constellation.

Only implemented for 1-(complex)dimensional constellation.


Constellation space is divided into rectangular sectors. Each sector is associated with the nearest constellation point.


This class is different from constellation_rect in that the mapping from sector to constellation point is explicitly passed into the constructor as sector_values. Usually we do not need this, since we want each sector to be automatically mapped to the closest constellation point, however sometimes it's nice to have the flexibility.

Constructor Specific Documentation:



Args:
    constellation : 
    pre_diff_code : 
    rotational_symmetry : 
    real_sectors : 
    imag_sectors : 
    width_real_sectors : 
    width_imag_sectors : 
    sector_values : )doc";


static const char* __doc_gr_digital_constellation_psk = R"doc(constellation_psk

Constellation space is divided into pie slices sectors.


Each slice is associated with the nearest constellation point.


Works well for PSK but nothing else.


Assumes that there is a constellation point at 1.x

Constructor Specific Documentation:



Args:
    constell : 
    pre_diff_code : 
    n_sectors : )doc";


static const char* __doc_gr_digital_constellation_psk_constellation_psk = R"doc()doc";


static const char* __doc_gr_digital_constellation_psk_make = R"doc(constellation_psk

Constellation space is divided into pie slices sectors.


Each slice is associated with the nearest constellation point.


Works well for PSK but nothing else.


Assumes that there is a constellation point at 1.x

Constructor Specific Documentation:



Args:
    constell : 
    pre_diff_code : 
    n_sectors : )doc";


static const char* __doc_gr_digital_constellation_bpsk = R"doc(Digital constellation for BPSK .

Constructor Specific Documentation:

)doc";


static const char* __doc_gr_digital_constellation_bpsk_constellation_bpsk = R"doc()doc";


static const char* __doc_gr_digital_constellation_bpsk_make = R"doc(Digital constellation for BPSK .

Constructor Specific Documentation:

)doc";


static const char* __doc_gr_digital_constellation_bpsk_decision_maker = R"doc(Returns the constellation point that matches best.)doc";


static const char* __doc_gr_digital_constellation_qpsk = R"doc(Digital constellation for QPSK.

Constellation diagram assumes little endian format e.g. top, left means 2 not 1.

Constructor Specific Documentation:

)doc";


static const char* __doc_gr_digital_constellation_qpsk_constellation_qpsk = R"doc()doc";


static const char* __doc_gr_digital_constellation_qpsk_make = R"doc(Digital constellation for QPSK.

Constellation diagram assumes little endian format e.g. top, left means 2 not 1.

Constructor Specific Documentation:

)doc";


static const char* __doc_gr_digital_constellation_qpsk_decision_maker = R"doc(Returns the constellation point that matches best.)doc";


static const char* __doc_gr_digital_constellation_dqpsk = R"doc(Digital constellation for DQPSK.

Constructor Specific Documentation:

)doc";


static const char* __doc_gr_digital_constellation_dqpsk_constellation_dqpsk = R"doc()doc";


static const char* __doc_gr_digital_constellation_dqpsk_make = R"doc(Digital constellation for DQPSK.

Constructor Specific Documentation:

)doc";


static const char* __doc_gr_digital_constellation_dqpsk_decision_maker = R"doc(Returns the constellation point that matches best.)doc";


static const char* __doc_gr_digital_constellation_8psk = R"doc(Digital constellation for 8PSK.

Constructor Specific Documentation:

)doc";


static const char* __doc_gr_digital_constellation_8psk_constellation_8psk = R"doc()doc";


static const char* __doc_gr_digital_constellation_8psk_make = R"doc(Digital constellation for 8PSK.

Constructor Specific Documentation:

)doc";


static const char* __doc_gr_digital_constellation_8psk_decision_maker = R"doc(Returns the constellation point that matches best.)doc";


static const char* __doc_gr_digital_constellation_8psk_natural = R"doc(Digital constellation for natually mapped 8PSK.

Constructor Specific Documentation:

)doc";


static const char*
    __doc_gr_digital_constellation_8psk_natural_constellation_8psk_natural = R"doc()doc";


static const char* __doc_gr_digital_constellation_8psk_natural_make = R"doc(Digital constellation for natually mapped 8PSK.

Constructor Specific Documentation:

)doc";


static const char* __doc_gr_digital_constellation_8psk_natural_decision_maker =
    R"doc()doc";


static const char* __doc_gr_digital_constellation_16qam = R"doc(Digital constellation for 16qam.

Constructor Specific Documentation:

)doc";


static const char* __doc_gr_digital_constellation_16qam_constellation_16qam = R"doc()doc";


static const char* __doc_gr_digital_constellation_16qam_make = R"doc(Digital constellation for 16qam.

Constructor Specific Documentation:

)doc";


static const char* __doc_gr_digital_constellation_16qam_decision_maker = R"doc(Returns the constellation point that matches best.)doc";
