/*
 * CLOUD API
 *
 *  IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
	"fmt"
)

// Type the model 'Type'
type Type string

// List of Type
const (
	DATACENTER              Type = "datacenter"
	SERVER                  Type = "server"
	VOLUME                  Type = "volume"
	NIC                     Type = "nic"
	LOADBALANCER            Type = "loadbalancer"
	LOCATION                Type = "location"
	FIREWALL_RULE           Type = "firewall-rule"
	FLOW_LOG                Type = "flow-log"
	IMAGE                   Type = "image"
	SNAPSHOT                Type = "snapshot"
	LAN                     Type = "lan"
	IPBLOCK                 Type = "ipblock"
	PCC                     Type = "pcc"
	CONTRACT                Type = "contract"
	USER                    Type = "user"
	GROUP                   Type = "group"
	COLLECTION              Type = "collection"
	RESOURCE                Type = "resource"
	REQUEST                 Type = "request"
	REQUEST_STATUS          Type = "request-status"
	S3KEY                   Type = "s3key"
	BACKUPUNIT              Type = "backupunit"
	LABEL                   Type = "label"
	K8S                     Type = "k8s"
	NODEPOOL                Type = "nodepool"
	TEMPLATE                Type = "template"
	NETWORKLOADBALANCER     Type = "networkloadbalancer"
	FORWARDING_RULE         Type = "forwarding-rule"
	NATGATEWAY              Type = "natgateway"
	NATGATEWAY_RULE         Type = "natgateway-rule"
	NODE                    Type = "node"
	APPLICATIONLOADBALANCER Type = "applicationloadbalancer"
	TARGET_GROUP            Type = "target-group"
	SECURITY_GROUP          Type = "security-group"
)

func (v *Type) UnmarshalJSON(src []byte) error {
	var value string
	err := json.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	enumTypeValue := Type(value)
	for _, existing := range []Type{"datacenter", "server", "volume", "nic", "loadbalancer", "location", "firewall-rule", "flow-log", "image", "snapshot", "lan", "ipblock", "pcc", "contract", "user", "group", "collection", "resource", "request", "request-status", "s3key", "backupunit", "label", "k8s", "nodepool", "template", "networkloadbalancer", "forwarding-rule", "natgateway", "natgateway-rule", "node", "applicationloadbalancer", "target-group", "security-group"} {
		if existing == enumTypeValue {
			*v = enumTypeValue
			return nil
		}
	}

	return fmt.Errorf("%+v is not a valid Type", value)
}

// Ptr returns reference to Type value
func (v Type) Ptr() *Type {
	return &v
}

type NullableType struct {
	value *Type
	isSet bool
}

func (v NullableType) Get() *Type {
	return v.value
}

func (v *NullableType) Set(val *Type) {
	v.value = val
	v.isSet = true
}

func (v NullableType) IsSet() bool {
	return v.isSet
}

func (v *NullableType) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableType(val *Type) *NullableType {
	return &NullableType{value: val, isSet: true}
}

func (v NullableType) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableType) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
