/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	apiv1 "sigs.k8s.io/gateway-api-inference-extension/api/v1"
)

// EndpointPickerRefApplyConfiguration represents a declarative configuration of the EndpointPickerRef type for use
// with apply.
type EndpointPickerRefApplyConfiguration struct {
	Group       *apiv1.Group                     `json:"group,omitempty"`
	Kind        *apiv1.Kind                      `json:"kind,omitempty"`
	Name        *apiv1.ObjectName                `json:"name,omitempty"`
	Port        *PortApplyConfiguration          `json:"port,omitempty"`
	FailureMode *apiv1.EndpointPickerFailureMode `json:"failureMode,omitempty"`
}

// EndpointPickerRefApplyConfiguration constructs a declarative configuration of the EndpointPickerRef type for use with
// apply.
func EndpointPickerRef() *EndpointPickerRefApplyConfiguration {
	return &EndpointPickerRefApplyConfiguration{}
}

// WithGroup sets the Group field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Group field is set to the value of the last call.
func (b *EndpointPickerRefApplyConfiguration) WithGroup(value apiv1.Group) *EndpointPickerRefApplyConfiguration {
	b.Group = &value
	return b
}

// WithKind sets the Kind field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Kind field is set to the value of the last call.
func (b *EndpointPickerRefApplyConfiguration) WithKind(value apiv1.Kind) *EndpointPickerRefApplyConfiguration {
	b.Kind = &value
	return b
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *EndpointPickerRefApplyConfiguration) WithName(value apiv1.ObjectName) *EndpointPickerRefApplyConfiguration {
	b.Name = &value
	return b
}

// WithPort sets the Port field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Port field is set to the value of the last call.
func (b *EndpointPickerRefApplyConfiguration) WithPort(value *PortApplyConfiguration) *EndpointPickerRefApplyConfiguration {
	b.Port = value
	return b
}

// WithFailureMode sets the FailureMode field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the FailureMode field is set to the value of the last call.
func (b *EndpointPickerRefApplyConfiguration) WithFailureMode(value apiv1.EndpointPickerFailureMode) *EndpointPickerRefApplyConfiguration {
	b.FailureMode = &value
	return b
}
