
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kurlmimedata_wrapper.h"

// Argument includes
#include <QList>
#include <QMap>
#include <QString>
#include <QStringList>
#include <qurl.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KUrlMimeData_Type = nullptr;
static PyTypeObject *Sbk_KUrlMimeData_TypeF(void)
{
    return _Sbk_KUrlMimeData_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KUrlMimeData_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KUrlMimeData");
    return -1;
}

static PyObject *Sbk_KUrlMimeDataFunc_exportUrlsToPortal(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KUrlMimeData::exportUrlsToPortal(QMimeData*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMimeData_IDX]), (pyArg)))) {
        overloadId = 0; // exportUrlsToPortal(QMimeData*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "exportUrlsToPortal", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKUrlMimeData_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMimeData *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // exportUrlsToPortal(QMimeData*)
            bool cppResult = ::KUrlMimeData::exportUrlsToPortal(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUrlMimeDataFunc_mimeDataTypes(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // mimeDataTypes()
        QStringList cppResult = ::KUrlMimeData::mimeDataTypes();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUrlMimeDataFunc_setMetaData(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setMetaData", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KUrlMimeData::setMetaData(QMap<QString,QString>,QMimeData*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QMap_QString_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMimeData_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setMetaData(QMap<QString,QString>,QMimeData*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setMetaData", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKUrlMimeData_IDX]);

    // Call function/method
    {
        ::QMap<QString,QString> cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QMimeData *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMetaData(QMap<QString,QString>,QMimeData*)
            ::KUrlMimeData::setMetaData(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUrlMimeDataFunc_setUrls(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setUrls", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KUrlMimeData::setUrls(QList<QUrl>,QList<QUrl>,QMimeData*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_QUrl_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_QUrl_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMimeData_IDX]), (pyArgs[2])))) {
        overloadId = 0; // setUrls(QList<QUrl>,QList<QUrl>,QMimeData*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setUrls", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKUrlMimeData_IDX]);

    // Call function/method
    {
        ::QList<QUrl> cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QList<QUrl> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QMimeData *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setUrls(QList<QUrl>,QList<QUrl>,QMimeData*)
            ::KUrlMimeData::setUrls(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUrlMimeDataFunc_urlsFromMimeData(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "urlsFromMimeData", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKUrlMimeData_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:urlsFromMimeData", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KUrlMimeData::urlsFromMimeData(const QMimeData*,QFlags<KUrlMimeData::DecodeOption>=,QMap<QString,QString>*=)->QList<QUrl>
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMimeData_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // urlsFromMimeData(const QMimeData*,QFlags<KUrlMimeData::DecodeOption>,QMap<QString,QString>*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KUrlMimeData_DecodeOption_IDX])))->flagsConverter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // urlsFromMimeData(const QMimeData*,QFlags<KUrlMimeData::DecodeOption>,QMap<QString,QString>*)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QMap_QString_QString_IDX], (pyArgs[2])))) {
                overloadId = 0; // urlsFromMimeData(const QMimeData*,QFlags<KUrlMimeData::DecodeOption>,QMap<QString,QString>*)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "urlsFromMimeData", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKUrlMimeData_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"decodeOptions", 1}, {"metaData", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KUrlMimeData_DecodeOption_IDX])))->flagsConverter, (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QMap_QString_QString_IDX], (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "urlsFromMimeData", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKUrlMimeData_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QMimeData *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<KUrlMimeData::DecodeOption> cppArg1(KUrlMimeData::DecodeOption::PreferKdeUrls);
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QMap<QString,QString> cppArg2_local;
        ::QMap<QString,QString> *cppArg2 = &cppArg2_local;
        if (pythonToCpp[2]) {
            if (pythonToCpp[2].isValue())
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);
            }

        if (Shiboken::Errors::occurred() == nullptr) {
            // urlsFromMimeData(const QMimeData*,QFlags<KUrlMimeData::DecodeOption>,QMap<QString,QString>*)
            QList<QUrl> cppResult = ::KUrlMimeData::urlsFromMimeData(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_QUrl_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KUrlMimeData_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KUrlMimeData_EnumFlagInfo[] = {
    "DecodeOption:IntFlag:DecodeOptions",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KUrlMimeData_methods[] = {
    {"exportUrlsToPortal", reinterpret_cast<PyCFunction>(Sbk_KUrlMimeDataFunc_exportUrlsToPortal), METH_O|METH_STATIC, nullptr},
    {"mimeDataTypes", reinterpret_cast<PyCFunction>(Sbk_KUrlMimeDataFunc_mimeDataTypes), METH_NOARGS|METH_STATIC, nullptr},
    {"setMetaData", reinterpret_cast<PyCFunction>(Sbk_KUrlMimeDataFunc_setMetaData), METH_VARARGS|METH_STATIC, nullptr},
    {"setUrls", reinterpret_cast<PyCFunction>(Sbk_KUrlMimeDataFunc_setUrls), METH_VARARGS|METH_STATIC, nullptr},
    {"urlsFromMimeData", reinterpret_cast<PyCFunction>(Sbk_KUrlMimeDataFunc_urlsFromMimeData), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KUrlMimeData_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KUrlMimeData_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KUrlMimeData_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KUrlMimeData_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KUrlMimeData_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KUrlMimeData_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KUrlMimeData_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KUrlMimeData_spec = {
    "1:KCoreAddons.KUrlMimeData",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KUrlMimeData_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KUrlMimeData_DecodeOption(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KUrlMimeData::DecodeOption>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KUrlMimeData::DecodeOption *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KUrlMimeData_DecodeOption_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUrlMimeData_DecodeOption_IDX])))
        return Enum_PythonToCpp_KUrlMimeData_DecodeOption;
    return {};
}

static PyObject *KUrlMimeData_DecodeOption_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KUrlMimeData::DecodeOption>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KUrlMimeData::DecodeOption *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KUrlMimeData_DecodeOption(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KUrlMimeData::DecodeOption>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KUrlMimeData::DecodeOption> *>(cppOut) = value;

}

static PyObject *KUrlMimeData_DecodeOption_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KUrlMimeData::DecodeOption> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUrlMimeData_DecodeOption_IDX]), flags.toInt());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCoreAddonsKUrlMimeData_SignatureStrings[] = {
    "KCoreAddons.KUrlMimeData.exportUrlsToPortal(mimeData:PySide6.QtCore.QMimeData)->bool",
    "KCoreAddons.KUrlMimeData.mimeDataTypes()->QStringList",
    "KCoreAddons.KUrlMimeData.setMetaData(metaData:QMap[QString, QString],mimeData:PySide6.QtCore.QMimeData)",
    "KCoreAddons.KUrlMimeData.setUrls(urls:QList[PySide6.QtCore.QUrl],mostLocalUrls:QList[PySide6.QtCore.QUrl],mimeData:PySide6.QtCore.QMimeData)",
    "KCoreAddons.KUrlMimeData.urlsFromMimeData(mimeData:PySide6.QtCore.QMimeData,decodeOptions:KCoreAddons.KUrlMimeData.DecodeOption=KUrlMimeData.DecodeOption.PreferKdeUrls,metaData:QMap[QString, QString]=nullptr)->QList[PySide6.QtCore.QUrl]",
    nullptr}; // Sentinel
#else
static constexpr size_t KCoreAddonsKUrlMimeData_SignatureByteSize = 217;
static constexpr uint8_t KCoreAddonsKUrlMimeData_SignatureBytes[217] = {
    0x78, 0xda, 0xa5, 0x51, 0xb1, 0x0a, 0xc2, 0x30, 0x10, 0xdd, 0xfd, 0x0a, 0xc7, 0x0a, 0x35, 0xa3,
    0x43, 0x41, 0x41, 0x2c, 0x2e, 0xb5, 0xd8, 0xa0, 0x9d, 0x8a, 0x43, 0x6c, 0x4e, 0x09, 0xa4, 0xbd,
    0x90, 0x9c, 0xa0, 0x7f, 0x6f, 0x02, 0x2d, 0x88, 0x10, 0x3b, 0xb8, 0x84, 0xc7, 0xbd, 0x7b, 0xef,
    0xde, 0x5d, 0x8a, 0x1d, 0x5a, 0xd8, 0x4a, 0x89, 0xbd, 0x63, 0x45, 0x6d, 0x75, 0xa9, 0x3a, 0xc8,
    0x05, 0x09, 0x06, 0x4f, 0x83, 0x96, 0x7c, 0xc5, 0x9d, 0xb1, 0xf2, 0x48, 0xe8, 0xa4, 0x1b, 0xb8,
    0xac, 0x7a, 0x9d, 0x94, 0x84, 0x15, 0xe3, 0x14, 0xd4, 0x8c, 0x8f, 0xa2, 0xc5, 0x72, 0x73, 0x45,
    0xd4, 0xb3, 0x22, 0x66, 0x3a, 0x3a, 0x9c, 0x5f, 0x06, 0x5c, 0xe2, 0xdb, 0xf9, 0x89, 0xac, 0xea,
    0xef, 0x07, 0xe5, 0x28, 0xae, 0x72, 0x40, 0x25, 0x90, 0x08, 0x38, 0xe9, 0x06, 0x90, 0xf1, 0x52,
    0x98, 0x66, 0x90, 0xa7, 0xf3, 0x01, 0x5c, 0xd2, 0xe9, 0x8c, 0x3f, 0xe7, 0x84, 0x7d, 0x93, 0x87,
    0x7f, 0x32, 0x1e, 0x32, 0x35, 0xdf, 0x2e, 0x9e, 0xf7, 0x33, 0xd0, 0xd1, 0x01, 0x5b, 0xa1, 0xeb,
    0xa9, 0xc6, 0x3f, 0xc2, 0x84, 0x10, 0x7b, 0x8b, 0xdd, 0x58, 0x98, 0xbe, 0x7e, 0x2a, 0xa1, 0x45,
    0x09, 0x47, 0x43, 0xca, 0xbb, 0x65, 0x51, 0xe7, 0xfc, 0xa3, 0x6d, 0x1d, 0x65, 0x58, 0x65, 0xe1,
    0x06, 0xb6, 0x90, 0x10, 0xb6, 0x4c, 0x27, 0xee, 0xbe, 0xee, 0x1f, 0x5a, 0x1b, 0xb2, 0xe1, 0x4b,
    0xa3, 0xf7, 0x98, 0xbd, 0x01, 0x0c, 0x83, 0xe0, 0xc6
};
#endif

PyTypeObject *init_KCoreAddonsKUrlMimeData(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKUrlMimeData_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKUrlMimeData_IDX].type;

    Shiboken::AutoDecRef Sbk_KUrlMimeData_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KUrlMimeData_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KUrlMimeData",
        "KUrlMimeData",
        &Sbk_KUrlMimeData_spec,
        nullptr,
        Sbk_KUrlMimeData_Type_bases.object(),
        0);
    auto *pyType = Sbk_KUrlMimeData_TypeF(); // references _Sbk_KUrlMimeData_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCoreAddonsKUrlMimeData_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCoreAddonsKUrlMimeData_SignatureBytes, KCoreAddonsKUrlMimeData_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KUrlMimeData_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKUrlMimeData_IDX].type = pyType;


    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KUrlMimeData_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'DecodeOption'.
    const char *DecodeOption_Initializer[] = {
        "PreferKdeUrls",
        "PreferLocalUrls",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t DecodeOption_InitializerValues[] = {
        uint8_t(KUrlMimeData::DecodeOption::PreferKdeUrls),  //  0x00  0
        uint8_t(KUrlMimeData::DecodeOption::PreferLocalUrls) //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KUrlMimeData_TypeF(),
        "1:KCoreAddons.KUrlMimeData.DecodeOption",
        DecodeOption_Initializer, DecodeOption_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KUrlMimeData_DecodeOption_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKCoreAddonsTypeStructs[SBK_QFlags_KUrlMimeData_DecodeOption_IDX].type =
        EType;
    // Register converter for enum 'KUrlMimeData::DecodeOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KUrlMimeData_DecodeOption_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KUrlMimeData_DecodeOption,
            is_Enum_PythonToCpp_KUrlMimeData_DecodeOption_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KUrlMimeData::DecodeOption");
        Shiboken::Conversions::registerConverterAlias(converter, "DecodeOption");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KUrlMimeData_DecodeOption_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KUrlMimeData_DecodeOption,
            is_Enum_PythonToCpp_KUrlMimeData_DecodeOption_Convertible);
        // Register converter for flag 'QFlags<KUrlMimeData::DecodeOption>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KUrlMimeData::DecodeOption>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KUrlMimeData::DecodeOptions");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'DecodeOption' enum/flags.

    qRegisterMetaType< ::KUrlMimeData::DecodeOption >("KUrlMimeData::DecodeOption");

    return pyType;
}
