
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kdatetimeedit_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"
#include "ktimecombobox_wrapper.h"

// Argument includes
#include <QList>
#include <QMap>
#include <QString>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qdatetime.h>
#include <qevent.h>
#include <qlocale.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qtimezone.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KDateTimeEdit_Type = nullptr;
static PyTypeObject *Sbk_KDateTimeEdit_TypeF(void)
{
    return _Sbk_KDateTimeEdit_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KDateTimeEditWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KDateTimeEditWrapper::KDateTimeEditWrapper(::QWidget * parent) : KDateTimeEdit(parent)
{
}

void KDateTimeEditWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

void KDateTimeEditWrapper::assignDate(const ::QDate & date)
{
    static const char *funcName = "assignDate";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDateTimeEdit::assignDate(date);
    }
    sbk_o_assignDate("KDateTimeEdit", funcName, gil, pyOverride, date);
}

void KDateTimeEditWrapper::sbk_o_assignDate(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QDate & date)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), &date)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), &date)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KDateTimeEditWrapper::assignDateTime(const ::QDateTime & dateTime)
{
    static const char *funcName = "assignDateTime";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDateTimeEdit::assignDateTime(dateTime);
    }
    sbk_o_assignDateTime("KDateTimeEdit", funcName, gil, pyOverride, dateTime);
}

void KDateTimeEditWrapper::sbk_o_assignDateTime(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QDateTime & dateTime)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDateTime_IDX]), &dateTime)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDateTime_IDX]), &dateTime)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KDateTimeEditWrapper::assignTime(const ::QTime & time)
{
    static const char *funcName = "assignTime";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDateTimeEdit::assignTime(time);
    }
    KTimeComboBoxWrapper::sbk_o_assignTime("KDateTimeEdit", funcName, gil, pyOverride, time);
}

void KDateTimeEditWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

void KDateTimeEditWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

void KDateTimeEditWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

void KDateTimeEditWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KDateTimeEdit", funcName, gil, pyOverride, signal);
}

void KDateTimeEditWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

void KDateTimeEditWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

int KDateTimeEditWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KDateTimeEdit", funcName, gil, pyOverride);
}

void KDateTimeEditWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KDateTimeEdit", funcName, gil, pyOverride, signal);
}

void KDateTimeEditWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

void KDateTimeEditWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

void KDateTimeEditWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

void KDateTimeEditWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

void KDateTimeEditWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

bool KDateTimeEditWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KDateTimeEdit", funcName, gil, pyOverride, event);
}

bool KDateTimeEditWrapper::eventFilter(::QObject * object, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDateTimeEdit::eventFilter(object, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KDateTimeEdit", funcName, gil, pyOverride, object, event);
}

void KDateTimeEditWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDateTimeEdit::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

bool KDateTimeEditWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KDateTimeEdit", funcName, gil, pyOverride, next);
}

void KDateTimeEditWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDateTimeEdit::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

bool KDateTimeEditWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KDateTimeEdit", funcName, gil, pyOverride);
}

int KDateTimeEditWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KDateTimeEdit", funcName, gil, pyOverride, arg__1);
}

void KDateTimeEditWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

void KDateTimeEditWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KDateTimeEdit", funcName, gil, pyOverride, painter);
}

void KDateTimeEditWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

::QVariant KDateTimeEditWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KDateTimeEdit", funcName, gil, pyOverride, arg__1);
}

void KDateTimeEditWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

void KDateTimeEditWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

void KDateTimeEditWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

int KDateTimeEditWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KDateTimeEdit", funcName, gil, pyOverride, arg__1);
}

::QSize KDateTimeEditWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KDateTimeEdit", funcName, gil, pyOverride);
}

void KDateTimeEditWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

void KDateTimeEditWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

void KDateTimeEditWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

void KDateTimeEditWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

void KDateTimeEditWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

bool KDateTimeEditWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KDateTimeEdit", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KDateTimeEditWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KDateTimeEdit", funcName, gil, pyOverride);
}

void KDateTimeEditWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

::QPaintDevice * KDateTimeEditWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KDateTimeEdit", funcName, gil, pyOverride, offset);
}

void KDateTimeEditWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDateTimeEdit::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

void KDateTimeEditWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KDateTimeEdit", funcName, gil, pyOverride, visible);
}

::QPainter * KDateTimeEditWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KDateTimeEdit", funcName, gil, pyOverride);
}

void KDateTimeEditWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

::QSize KDateTimeEditWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KDateTimeEdit", funcName, gil, pyOverride);
}

void KDateTimeEditWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

void KDateTimeEditWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

void KDateTimeEditWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateTimeEdit_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KDateTimeEdit", funcName, gil, pyOverride, event);
}

const QMetaObject *KDateTimeEditWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KDateTimeEdit::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KDateTimeEditWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KDateTimeEdit::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KDateTimeEditWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KDateTimeEditWrapper *>(this));
    }
    return KDateTimeEdit::qt_metacast(_clname);
}

KDateTimeEditWrapper::~KDateTimeEditWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KDateTimeEdit_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KDateTimeEdit_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KDateTimeEdit >()))
        return -1;

    KDateTimeEditWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KDateTimeEdit", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KDateTimeEdit::KDateTimeEdit(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KDateTimeEdit(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KDateTimeEdit(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KDateTimeEdit(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KDateTimeEditWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KDateTimeEditWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KDateTimeEdit >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KDateTimeEditFunc_assignDate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDateTimeEdit::assignDate(QDate)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), (pyArg)))) {
        overloadId = 0; // assignDate(QDate)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "assignDate", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDate cppArg0_local;
        ::QDate *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // assignDate(QDate)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDateTimeEdit::assignDate(*cppArg0)
                : cppSelf->assignDate(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_assignDateTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDateTimeEdit::assignDateTime(QDateTime)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDateTime_IDX]), (pyArg)))) {
        overloadId = 0; // assignDateTime(QDateTime)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "assignDateTime", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // assignDateTime(QDateTime)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDateTimeEdit::assignDateTime(*cppArg0)
                : cppSelf->assignDateTime(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_assignTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDateTimeEdit::assignTime(QTime)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTime_IDX]), (pyArg)))) {
        overloadId = 0; // assignTime(QTime)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "assignTime", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTime cppArg0_local;
        ::QTime *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // assignTime(QTime)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDateTimeEdit::assignTime(*cppArg0)
                : cppSelf->assignTime(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_assignTimeZone(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDateTimeEdit::assignTimeZone(QTimeZone)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTimeZone_IDX]), (pyArg)))) {
        overloadId = 0; // assignTimeZone(QTimeZone)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "assignTimeZone", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTimeZone cppArg0_local;
        ::QTimeZone *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // assignTimeZone(QTimeZone)
            cppSelf->assignTimeZone(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_calendarLocalesList(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // calendarLocalesList()const
        QList<QLocale> cppResult = const_cast<const ::KDateTimeEdit *>(cppSelf)->calendarLocalesList();
        pyResult = Shiboken::Conversions::copyToPython(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QLocale_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateTimeEditFunc_date(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // date()const
        QDate cppResult = const_cast<const ::KDateTimeEdit *>(cppSelf)->date();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateTimeEditFunc_dateDisplayFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // dateDisplayFormat()const
        QLocale::FormatType cppResult = const_cast<const ::KDateTimeEdit *>(cppSelf)->dateDisplayFormat();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QLocale_FormatType_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateTimeEditFunc_dateMap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // dateMap()const
        QMap<QDate,QString> cppResult = const_cast<const ::KDateTimeEdit *>(cppSelf)->dateMap();
        pyResult = Shiboken::Conversions::copyToPython(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_QDate_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateTimeEditFunc_dateTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // dateTime()const
        QDateTime cppResult = const_cast<const ::KDateTimeEdit *>(cppSelf)->dateTime();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDateTime_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateTimeEditFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QObject::eventFilter(QObject*,QEvent*)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "eventFilter", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDateTimeEdit::eventFilter(cppArg0, cppArg1)
                : cppSelf->eventFilter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateTimeEditFunc_focusInEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::focusInEvent(QFocusEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFocusEvent_IDX]), (pyArg)))) {
        overloadId = 0; // focusInEvent(QFocusEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "focusInEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFocusEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // focusInEvent(QFocusEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDateTimeEdit::focusInEvent(cppArg0)
                : cppSelf->focusInEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_focusOutEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::focusOutEvent(QFocusEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFocusEvent_IDX]), (pyArg)))) {
        overloadId = 0; // focusOutEvent(QFocusEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "focusOutEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFocusEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // focusOutEvent(QFocusEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDateTimeEdit::focusOutEvent(cppArg0)
                : cppSelf->focusOutEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isNull()const
        bool cppResult = const_cast<const ::KDateTimeEdit *>(cppSelf)->isNull();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateTimeEditFunc_isNullDate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isNullDate()const
        bool cppResult = const_cast<const ::KDateTimeEdit *>(cppSelf)->isNullDate();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateTimeEditFunc_isNullTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isNullTime()const
        bool cppResult = const_cast<const ::KDateTimeEdit *>(cppSelf)->isNullTime();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateTimeEditFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isValid()const
        bool cppResult = const_cast<const ::KDateTimeEdit *>(cppSelf)->isValid();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateTimeEditFunc_isValidDate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isValidDate()const
        bool cppResult = const_cast<const ::KDateTimeEdit *>(cppSelf)->isValidDate();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateTimeEditFunc_isValidTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isValidTime()const
        bool cppResult = const_cast<const ::KDateTimeEdit *>(cppSelf)->isValidTime();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateTimeEditFunc_maximumDateTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // maximumDateTime()const
        QDateTime cppResult = const_cast<const ::KDateTimeEdit *>(cppSelf)->maximumDateTime();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDateTime_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateTimeEditFunc_minimumDateTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // minimumDateTime()const
        QDateTime cppResult = const_cast<const ::KDateTimeEdit *>(cppSelf)->minimumDateTime();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDateTime_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateTimeEditFunc_options(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // options()const
        QFlags<KDateTimeEdit::Option> cppResult = const_cast<const ::KDateTimeEdit *>(cppSelf)->options();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KDateTimeEdit_Option_IDX])))->flagsConverter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateTimeEditFunc_resetDateTimeRange(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // resetDateTimeRange()
        cppSelf->resetDateTimeRange();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_resetMaximumDateTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // resetMaximumDateTime()
        cppSelf->resetMaximumDateTime();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_resetMinimumDateTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // resetMinimumDateTime()
        cppSelf->resetMinimumDateTime();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_resizeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::resizeEvent(QResizeEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QResizeEvent_IDX]), (pyArg)))) {
        overloadId = 0; // resizeEvent(QResizeEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "resizeEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QResizeEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // resizeEvent(QResizeEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDateTimeEdit::resizeEvent(cppArg0)
                : cppSelf->resizeEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_setCalendarLocalesList(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDateTimeEdit::setCalendarLocalesList(QList<QLocale>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QLocale_IDX], (pyArg)))) {
        overloadId = 0; // setCalendarLocalesList(QList<QLocale>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCalendarLocalesList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        ::QList<QLocale> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCalendarLocalesList(QList<QLocale>)
            cppSelf->setCalendarLocalesList(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_setDate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDateTimeEdit::setDate(QDate)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), (pyArg)))) {
        overloadId = 0; // setDate(QDate)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDate", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDate cppArg0_local;
        ::QDate *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setDate(QDate)
            cppSelf->setDate(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_setDateDisplayFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDateTimeEdit::setDateDisplayFormat(QLocale::FormatType)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QLocale_FormatType_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setDateDisplayFormat(QLocale::FormatType)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDateDisplayFormat", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        ::QLocale::FormatType cppArg0{QLocale::LongFormat};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDateDisplayFormat(QLocale::FormatType)
            cppSelf->setDateDisplayFormat(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_setDateMap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDateTimeEdit::setDateMap(QMap<QDate,QString>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_QDate_QString_IDX], (pyArg)))) {
        overloadId = 0; // setDateMap(QMap<QDate,QString>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDateMap", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        ::QMap<QDate,QString> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDateMap(QMap<QDate,QString>)
            cppSelf->setDateMap(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_setDateTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDateTimeEdit::setDateTime(QDateTime)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDateTime_IDX]), (pyArg)))) {
        overloadId = 0; // setDateTime(QDateTime)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDateTime", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setDateTime(QDateTime)
            cppSelf->setDateTime(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_setDateTimeRange(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 4));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setDateTimeRange", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    if (PyArg_ParseTuple(args, "|OOOO:setDateTimeRange", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KDateTimeEdit::setDateTimeRange(QDateTime,QDateTime,const QString&=,const QString&=)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDateTime_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDateTime_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // setDateTimeRange(QDateTime,QDateTime,QString,QString)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // setDateTimeRange(QDateTime,QDateTime,QString,QString)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
                overloadId = 0; // setDateTimeRange(QDateTime,QDateTime,QString,QString)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setDateTimeRange", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"minWarnMsg", 2}, {"maxWarnMsg", 3}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setDateTimeRange", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QDateTime cppArg1_local;
        ::QDateTime *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        ::QString cppArg2 = QString();
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDateTimeRange(QDateTime,QDateTime,QString,QString)
            cppSelf->setDateTimeRange(*cppArg0, *cppArg1, cppArg2, cppArg3);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_setMaximumDateTime(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setMaximumDateTime", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setMaximumDateTime", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KDateTimeEdit::setMaximumDateTime(QDateTime,const QString&=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDateTime_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setMaximumDateTime(QDateTime,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 0; // setMaximumDateTime(QDateTime,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setMaximumDateTime", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"maxWarnMsg", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setMaximumDateTime", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1 = QString();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMaximumDateTime(QDateTime,QString)
            cppSelf->setMaximumDateTime(*cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_setMinimumDateTime(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setMinimumDateTime", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setMinimumDateTime", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KDateTimeEdit::setMinimumDateTime(QDateTime,const QString&=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDateTime_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setMinimumDateTime(QDateTime,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 0; // setMinimumDateTime(QDateTime,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setMinimumDateTime", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"minWarnMsg", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setMinimumDateTime", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1 = QString();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMinimumDateTime(QDateTime,QString)
            cppSelf->setMinimumDateTime(*cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_setOptions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDateTimeEdit::setOptions(QFlags<KDateTimeEdit::Option>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KDateTimeEdit_Option_IDX])))->flagsConverter, (pyArg)))) {
        overloadId = 0; // setOptions(QFlags<KDateTimeEdit::Option>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setOptions", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        ::QFlags<KDateTimeEdit::Option> cppArg0 = QFlags<KDateTimeEdit::Option>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setOptions(QFlags<KDateTimeEdit::Option>)
            cppSelf->setOptions(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_setTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDateTimeEdit::setTime(QTime)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTime_IDX]), (pyArg)))) {
        overloadId = 0; // setTime(QTime)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setTime", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTime cppArg0_local;
        ::QTime *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setTime(QTime)
            cppSelf->setTime(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_setTimeDisplayFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDateTimeEdit::setTimeDisplayFormat(QLocale::FormatType)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QLocale_FormatType_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setTimeDisplayFormat(QLocale::FormatType)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setTimeDisplayFormat", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        ::QLocale::FormatType cppArg0{QLocale::LongFormat};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTimeDisplayFormat(QLocale::FormatType)
            cppSelf->setTimeDisplayFormat(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_setTimeList(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setTimeList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:setTimeList", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KDateTimeEdit::setTimeList(QList<QTime>,const QString&=,const QString&=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QTime_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setTimeList(QList<QTime>,QString,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // setTimeList(QList<QTime>,QString,QString)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
                overloadId = 0; // setTimeList(QList<QTime>,QString,QString)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setTimeList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"minWarnMsg", 1}, {"maxWarnMsg", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setTimeList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);
            }
        }
        ::QList<QTime> cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTimeList(QList<QTime>,QString,QString)
            cppSelf->setTimeList(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_setTimeListInterval(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDateTimeEdit::setTimeListInterval(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setTimeListInterval(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setTimeListInterval", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTimeListInterval(int)
            cppSelf->setTimeListInterval(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_setTimeZone(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDateTimeEdit::setTimeZone(QTimeZone)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTimeZone_IDX]), (pyArg)))) {
        overloadId = 0; // setTimeZone(QTimeZone)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setTimeZone", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTimeZone cppArg0_local;
        ::QTimeZone *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setTimeZone(QTimeZone)
            cppSelf->setTimeZone(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_setTimeZones(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDateTimeEdit::setTimeZones(QList<QTimeZone>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QTimeZone_IDX], (pyArg)))) {
        overloadId = 0; // setTimeZones(QList<QTimeZone>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setTimeZones", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);

    // Call function/method
    {
        ::QList<QTimeZone> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTimeZones(QList<QTimeZone>)
            cppSelf->setTimeZones(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateTimeEditFunc_time(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // time()const
        QTime cppResult = const_cast<const ::KDateTimeEdit *>(cppSelf)->time();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTime_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateTimeEditFunc_timeDisplayFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // timeDisplayFormat()const
        QLocale::FormatType cppResult = const_cast<const ::KDateTimeEdit *>(cppSelf)->timeDisplayFormat();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QLocale_FormatType_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateTimeEditFunc_timeList(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // timeList()const
        QList<QTime> cppResult = const_cast<const ::KDateTimeEdit *>(cppSelf)->timeList();
        pyResult = Shiboken::Conversions::copyToPython(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QTime_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateTimeEditFunc_timeListInterval(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // timeListInterval()const
        int cppResult = const_cast<const ::KDateTimeEdit *>(cppSelf)->timeListInterval();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateTimeEditFunc_timeZone(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // timeZone()const
        QTimeZone cppResult = const_cast<const ::KDateTimeEdit *>(cppSelf)->timeZone();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTimeZone_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateTimeEditFunc_timeZones(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // timeZones()const
        QList<QTimeZone> cppResult = const_cast<const ::KDateTimeEdit *>(cppSelf)->timeZones();
        pyResult = Shiboken::Conversions::copyToPython(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QTimeZone_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KDateTimeEdit_PropertyStrings[] = {
    "date::",
    "options::",
    "time::",
    "timeListInterval::",
    nullptr // Sentinel
};

static const char *Sbk_KDateTimeEdit_EnumFlagInfo[] = {
    "Option:IntFlag:Options",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KDateTimeEdit_methods[] = {
    {"assignDate", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_assignDate), METH_O, nullptr},
    {"assignDateTime", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_assignDateTime), METH_O, nullptr},
    {"assignTime", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_assignTime), METH_O, nullptr},
    {"assignTimeZone", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_assignTimeZone), METH_O, nullptr},
    {"calendarLocalesList", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_calendarLocalesList), METH_NOARGS, nullptr},
    {"date", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_date), METH_NOARGS, nullptr},
    {"dateDisplayFormat", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_dateDisplayFormat), METH_NOARGS, nullptr},
    {"dateMap", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_dateMap), METH_NOARGS, nullptr},
    {"dateTime", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_dateTime), METH_NOARGS, nullptr},
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_eventFilter), METH_VARARGS, nullptr},
    {"focusInEvent", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_focusInEvent), METH_O, nullptr},
    {"focusOutEvent", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_focusOutEvent), METH_O, nullptr},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_isNull), METH_NOARGS, nullptr},
    {"isNullDate", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_isNullDate), METH_NOARGS, nullptr},
    {"isNullTime", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_isNullTime), METH_NOARGS, nullptr},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_isValid), METH_NOARGS, nullptr},
    {"isValidDate", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_isValidDate), METH_NOARGS, nullptr},
    {"isValidTime", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_isValidTime), METH_NOARGS, nullptr},
    {"maximumDateTime", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_maximumDateTime), METH_NOARGS, nullptr},
    {"minimumDateTime", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_minimumDateTime), METH_NOARGS, nullptr},
    {"options", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_options), METH_NOARGS, nullptr},
    {"resetDateTimeRange", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_resetDateTimeRange), METH_NOARGS, nullptr},
    {"resetMaximumDateTime", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_resetMaximumDateTime), METH_NOARGS, nullptr},
    {"resetMinimumDateTime", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_resetMinimumDateTime), METH_NOARGS, nullptr},
    {"resizeEvent", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_resizeEvent), METH_O, nullptr},
    {"setCalendarLocalesList", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_setCalendarLocalesList), METH_O, nullptr},
    {"setDate", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_setDate), METH_O, nullptr},
    {"setDateDisplayFormat", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_setDateDisplayFormat), METH_O, nullptr},
    {"setDateMap", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_setDateMap), METH_O, nullptr},
    {"setDateTime", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_setDateTime), METH_O, nullptr},
    {"setDateTimeRange", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_setDateTimeRange), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setMaximumDateTime", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_setMaximumDateTime), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setMinimumDateTime", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_setMinimumDateTime), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setOptions", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_setOptions), METH_O, nullptr},
    {"setTime", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_setTime), METH_O, nullptr},
    {"setTimeDisplayFormat", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_setTimeDisplayFormat), METH_O, nullptr},
    {"setTimeList", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_setTimeList), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setTimeListInterval", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_setTimeListInterval), METH_O, nullptr},
    {"setTimeZone", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_setTimeZone), METH_O, nullptr},
    {"setTimeZones", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_setTimeZones), METH_O, nullptr},
    {"time", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_time), METH_NOARGS, nullptr},
    {"timeDisplayFormat", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_timeDisplayFormat), METH_NOARGS, nullptr},
    {"timeList", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_timeList), METH_NOARGS, nullptr},
    {"timeListInterval", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_timeListInterval), METH_NOARGS, nullptr},
    {"timeZone", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_timeZone), METH_NOARGS, nullptr},
    {"timeZones", reinterpret_cast<PyCFunction>(Sbk_KDateTimeEditFunc_timeZones), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KDateTimeEdit_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KDateTimeEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KDateTimeEditWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KDateTimeEdit_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KDateTimeEdit_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KDateTimeEditSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KDateTimeEdit *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KDateTimeEdit_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KDateTimeEdit_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KDateTimeEdit_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KDateTimeEdit_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KDateTimeEdit_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KDateTimeEdit_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KDateTimeEdit_spec = {
    "1:KWidgetsAddons.KDateTimeEdit",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KDateTimeEdit_slots
};

} //extern "C"

static void *Sbk_KDateTimeEdit_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KDateTimeEdit *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KDateTimeEdit *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KDateTimeEdit *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KDateTimeEdit_Option(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KDateTimeEdit::Option>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KDateTimeEdit::Option *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KDateTimeEdit_Option_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_Option_IDX])))
        return Enum_PythonToCpp_KDateTimeEdit_Option;
    return {};
}

static PyObject *KDateTimeEdit_Option_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KDateTimeEdit::Option>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KDateTimeEdit::Option *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KDateTimeEdit_Option(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KDateTimeEdit::Option>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KDateTimeEdit::Option> *>(cppOut) = value;

}

static PyObject *KDateTimeEdit_Option_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KDateTimeEdit::Option> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_Option_IDX]), flags.toInt());

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KDateTimeEdit_PythonToCpp_KDateTimeEdit_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KDateTimeEdit_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KDateTimeEdit_PythonToCpp_KDateTimeEdit_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KDateTimeEdit_TypeF()))
        return KDateTimeEdit_PythonToCpp_KDateTimeEdit_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KDateTimeEdit_PTR_CppToPython_KDateTimeEdit(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KDateTimeEdit *>(const_cast<void *>(cppIn)), Sbk_KDateTimeEdit_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KDateTimeEdit_SignatureStrings[] = {
    "KWidgetsAddons.KDateTimeEdit(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,date:QDate=None,time:QTime=None,timeListInterval:int=None,options:KWidgetsAddons.KDateComboBox.Option=None)",
    "KWidgetsAddons.KDateTimeEdit.assignDate(self,date:PySide6.QtCore.QDate)",
    "KWidgetsAddons.KDateTimeEdit.assignDateTime(self,dateTime:PySide6.QtCore.QDateTime)",
    "KWidgetsAddons.KDateTimeEdit.assignTime(self,time:PySide6.QtCore.QTime)",
    "KWidgetsAddons.KDateTimeEdit.assignTimeZone(self,zone:typing.Union[PySide6.QtCore.QTimeZone, PySide6.QtCore.QTimeZone.Initialization])",
    "KWidgetsAddons.KDateTimeEdit.calendarLocalesList(self)->QList[PySide6.QtCore.QLocale]",
    "KWidgetsAddons.KDateTimeEdit.date(self)->PySide6.QtCore.QDate",
    "KWidgetsAddons.KDateTimeEdit.dateDisplayFormat(self)->PySide6.QtCore.QLocale.FormatType",
    "KWidgetsAddons.KDateTimeEdit.dateMap(self)->QMap[PySide6.QtCore.QDate, QString]",
    "KWidgetsAddons.KDateTimeEdit.dateTime(self)->PySide6.QtCore.QDateTime",
    "KWidgetsAddons.KDateTimeEdit.eventFilter(self,object:PySide6.QtCore.QObject,event:PySide6.QtCore.QEvent)->bool",
    "KWidgetsAddons.KDateTimeEdit.focusInEvent(self,event:PySide6.QtGui.QFocusEvent)",
    "KWidgetsAddons.KDateTimeEdit.focusOutEvent(self,event:PySide6.QtGui.QFocusEvent)",
    "KWidgetsAddons.KDateTimeEdit.isNull(self)->bool",
    "KWidgetsAddons.KDateTimeEdit.isNullDate(self)->bool",
    "KWidgetsAddons.KDateTimeEdit.isNullTime(self)->bool",
    "KWidgetsAddons.KDateTimeEdit.isValid(self)->bool",
    "KWidgetsAddons.KDateTimeEdit.isValidDate(self)->bool",
    "KWidgetsAddons.KDateTimeEdit.isValidTime(self)->bool",
    "KWidgetsAddons.KDateTimeEdit.maximumDateTime(self)->PySide6.QtCore.QDateTime",
    "KWidgetsAddons.KDateTimeEdit.minimumDateTime(self)->PySide6.QtCore.QDateTime",
    "KWidgetsAddons.KDateTimeEdit.options(self)->KWidgetsAddons.KDateTimeEdit.Option",
    "KWidgetsAddons.KDateTimeEdit.resetDateTimeRange(self)",
    "KWidgetsAddons.KDateTimeEdit.resetMaximumDateTime(self)",
    "KWidgetsAddons.KDateTimeEdit.resetMinimumDateTime(self)",
    "KWidgetsAddons.KDateTimeEdit.resizeEvent(self,event:PySide6.QtGui.QResizeEvent)",
    "KWidgetsAddons.KDateTimeEdit.setCalendarLocalesList(self,calendarLocales:QList[PySide6.QtCore.QLocale])",
    "KWidgetsAddons.KDateTimeEdit.setDate(self,date:PySide6.QtCore.QDate)",
    "KWidgetsAddons.KDateTimeEdit.setDateDisplayFormat(self,format:PySide6.QtCore.QLocale.FormatType)",
    "KWidgetsAddons.KDateTimeEdit.setDateMap(self,dateMap:QMap[PySide6.QtCore.QDate, QString])",
    "KWidgetsAddons.KDateTimeEdit.setDateTime(self,dateTime:PySide6.QtCore.QDateTime)",
    "KWidgetsAddons.KDateTimeEdit.setDateTimeRange(self,minDateTime:PySide6.QtCore.QDateTime,maxDateTime:PySide6.QtCore.QDateTime,minWarnMsg:QString=QString(),maxWarnMsg:QString=QString())",
    "KWidgetsAddons.KDateTimeEdit.setMaximumDateTime(self,maxDateTime:PySide6.QtCore.QDateTime,maxWarnMsg:QString=QString())",
    "KWidgetsAddons.KDateTimeEdit.setMinimumDateTime(self,minDateTime:PySide6.QtCore.QDateTime,minWarnMsg:QString=QString())",
    "KWidgetsAddons.KDateTimeEdit.setOptions(self,options:KWidgetsAddons.KDateTimeEdit.Option)",
    "KWidgetsAddons.KDateTimeEdit.setTime(self,time:PySide6.QtCore.QTime)",
    "KWidgetsAddons.KDateTimeEdit.setTimeDisplayFormat(self,format:PySide6.QtCore.QLocale.FormatType)",
    "KWidgetsAddons.KDateTimeEdit.setTimeList(self,timeList:QList[PySide6.QtCore.QTime],minWarnMsg:QString=QString(),maxWarnMsg:QString=QString())",
    "KWidgetsAddons.KDateTimeEdit.setTimeListInterval(self,minutes:int)",
    "KWidgetsAddons.KDateTimeEdit.setTimeZone(self,zone:typing.Union[PySide6.QtCore.QTimeZone, PySide6.QtCore.QTimeZone.Initialization])",
    "KWidgetsAddons.KDateTimeEdit.setTimeZones(self,zones:QList[PySide6.QtCore.QTimeZone])",
    "KWidgetsAddons.KDateTimeEdit.time(self)->PySide6.QtCore.QTime",
    "KWidgetsAddons.KDateTimeEdit.timeDisplayFormat(self)->PySide6.QtCore.QLocale.FormatType",
    "KWidgetsAddons.KDateTimeEdit.timeList(self)->QList[PySide6.QtCore.QTime]",
    "KWidgetsAddons.KDateTimeEdit.timeListInterval(self)->int",
    "KWidgetsAddons.KDateTimeEdit.timeZone(self)->PySide6.QtCore.QTimeZone",
    "KWidgetsAddons.KDateTimeEdit.timeZones(self)->QList[PySide6.QtCore.QTimeZone]",
    nullptr}; // Sentinel
#else
static constexpr size_t KDateTimeEdit_SignatureByteSize = 677;
static constexpr uint8_t KDateTimeEdit_SignatureBytes[677] = {
    0x78, 0xda, 0xc5, 0x97, 0xdf, 0x6f, 0xda, 0x30, 0x10, 0xc7, 0xdf, 0xfb, 0x57, 0xf4, 0xb1, 0x4c,
    0x5e, 0x1e, 0xf7, 0x60, 0x89, 0x49, 0x5b, 0x29, 0x13, 0xa2, 0x94, 0xa5, 0x65, 0xab, 0xb4, 0x8a,
    0x07, 0x43, 0x0c, 0xf2, 0x94, 0xd8, 0x51, 0x7c, 0xe9, 0x1a, 0xfe, 0xfa, 0xf9, 0x47, 0x20, 0x0c,
    0x9c, 0xd8, 0x08, 0xaa, 0x3d, 0xe1, 0xd8, 0x77, 0x1f, 0x7f, 0x7d, 0x3e, 0x9f, 0xcd, 0xf8, 0x99,
    0x25, 0x6b, 0x0a, 0xf2, 0x4b, 0x92, 0x08, 0x2e, 0xa3, 0xf1, 0x80, 0x00, 0x9d, 0xb1, 0x8c, 0xde,
    0x25, 0x0c, 0x6e, 0x24, 0x4d, 0x57, 0x28, 0x27, 0x05, 0xe5, 0x80, 0xbf, 0x57, 0x4f, 0x2c, 0xa1,
    0x9f, 0xa2, 0x18, 0x6a, 0x8f, 0x28, 0xb6, 0x8d, 0x3e, 0x2f, 0xd3, 0x34, 0x87, 0x02, 0x7d, 0xc0,
    0x63, 0x5a, 0xfd, 0x11, 0x45, 0x32, 0xe5, 0x69, 0xd5, 0x7f, 0x10, 0x9c, 0xa2, 0x44, 0xd1, 0x70,
    0xac, 0x99, 0xf6, 0x1b, 0x14, 0x19, 0xc7, 0x9a, 0xdf, 0x7c, 0xdf, 0x33, 0x09, 0x23, 0x0e, 0xb4,
    0x78, 0x25, 0x29, 0x66, 0x1c, 0xec, 0x88, 0xc8, 0x81, 0x29, 0x41, 0x78, 0xec, 0xd0, 0x77, 0x2b,
    0xb2, 0x85, 0xf8, 0x2a, 0xde, 0xa2, 0xa9, 0x31, 0x32, 0x0e, 0xbd, 0xab, 0x71, 0xc7, 0x4a, 0x22,
    0x22, 0x25, 0x5b, 0x73, 0xdd, 0x65, 0x17, 0x65, 0x84, 0x35, 0x4b, 0xba, 0x15, 0x05, 0x8d, 0x8c,
    0xce, 0x60, 0x8e, 0xee, 0x6a, 0x58, 0xfa, 0xcb, 0xc9, 0xd3, 0x03, 0x41, 0xcc, 0x86, 0x07, 0x2e,
    0xd6, 0x49, 0x9c, 0x5f, 0x2a, 0x20, 0x96, 0xb5, 0x51, 0x2d, 0x0c, 0x55, 0xce, 0xf8, 0x3a, 0xfa,
    0xc1, 0x55, 0xb0, 0x5e, 0x5c, 0x60, 0x6d, 0x8f, 0xae, 0xdb, 0x46, 0xa2, 0x11, 0x67, 0xc0, 0x48,
    0xca, 0x36, 0x44, 0x87, 0x7b, 0xee, 0x91, 0xb1, 0x24, 0x29, 0xe5, 0x09, 0x29, 0xee, 0x85, 0x6e,
    0x49, 0xbd, 0xbd, 0x46, 0x4b, 0xef, 0xe3, 0xe7, 0x58, 0x7f, 0x1c, 0x29, 0xb0, 0x86, 0xf3, 0x6e,
    0x6a, 0xb2, 0xdd, 0x3a, 0x85, 0x71, 0xc5, 0xd9, 0xef, 0x3d, 0x60, 0x32, 0x4f, 0x49, 0x35, 0x14,
    0x45, 0x46, 0xa0, 0x0d, 0x65, 0xb5, 0x44, 0xd6, 0x68, 0x56, 0xe5, 0x01, 0xdc, 0x09, 0xc9, 0x77,
    0xeb, 0x53, 0xed, 0x17, 0x97, 0x3a, 0x74, 0x1d, 0x3f, 0x41, 0xa1, 0x36, 0x21, 0x60, 0x95, 0xbb,
    0x44, 0x68, 0x59, 0xa9, 0x1e, 0xef, 0xa6, 0xd0, 0x57, 0x75, 0x60, 0x87, 0x2c, 0x55, 0x67, 0xca,
    0x66, 0x81, 0x58, 0xfc, 0xa6, 0x4b, 0x38, 0xca, 0xa9, 0xa9, 0xe9, 0x46, 0xc6, 0xfc, 0x68, 0xf0,
    0x4e, 0xf7, 0x2a, 0x09, 0x0b, 0x21, 0xd2, 0xee, 0xe9, 0x56, 0x62, 0x59, 0xca, 0x11, 0x37, 0x0e,
    0x76, 0xbe, 0x43, 0xe2, 0xb7, 0x92, 0x45, 0xf1, 0x50, 0x9b, 0x59, 0x6a, 0x00, 0x6f, 0x5a, 0xc2,
    0xc5, 0x80, 0x4c, 0x3e, 0xa8, 0x12, 0xb5, 0x8d, 0xa9, 0x7f, 0x41, 0xd6, 0x7e, 0xb0, 0x97, 0x71,
    0xa1, 0x3e, 0xfb, 0x7b, 0x17, 0xe2, 0xf3, 0x53, 0x9d, 0xaa, 0xe4, 0x64, 0x87, 0x53, 0x95, 0x19,
    0xa7, 0xd3, 0xa4, 0x65, 0xe4, 0x8d, 0x65, 0x65, 0x36, 0xb8, 0x48, 0x3e, 0x66, 0x8c, 0x5f, 0x0e,
    0x56, 0x5f, 0x0c, 0x5b, 0x48, 0xa7, 0xad, 0xbd, 0x1f, 0xba, 0x79, 0x05, 0x95, 0x14, 0xb6, 0x3d,
    0x8f, 0x84, 0xaf, 0x6b, 0x7d, 0x01, 0x5e, 0x13, 0x57, 0x90, 0x42, 0xfc, 0x5c, 0xf1, 0xf0, 0xfa,
    0xb1, 0x0d, 0xf5, 0x9d, 0x88, 0xc7, 0xc6, 0xca, 0xc3, 0x53, 0x2a, 0x6e, 0x5b, 0xea, 0x34, 0x3a,
    0x28, 0xe0, 0xb8, 0xb3, 0x6a, 0xfb, 0xe7, 0x39, 0xff, 0xd2, 0xad, 0x21, 0xc7, 0x05, 0x1c, 0xad,
    0x4c, 0x1b, 0x7b, 0xab, 0x78, 0xd8, 0x04, 0xdb, 0x4a, 0x8e, 0xea, 0xb2, 0x8e, 0x03, 0xea, 0x79,
    0x18, 0xf9, 0x72, 0x8f, 0x05, 0x67, 0xb2, 0x22, 0x75, 0xc2, 0x06, 0x3e, 0x30, 0x52, 0x67, 0x3a,
    0xc0, 0x88, 0xf1, 0x67, 0x52, 0xf0, 0x89, 0x5c, 0xe3, 0x7a, 0x89, 0xfd, 0xfa, 0xf7, 0xa6, 0xa7,
    0x09, 0xad, 0x83, 0x7e, 0xdd, 0xae, 0xe3, 0x12, 0x28, 0xea, 0xbc, 0x79, 0x1d, 0xc7, 0x2d, 0x30,
    0x62, 0x1d, 0xc1, 0xf0, 0xcf, 0x3b, 0xdd, 0xab, 0x54, 0x9d, 0xef, 0xd9, 0x83, 0x7a, 0xe5, 0x27,
    0x9f, 0xff, 0x56, 0xac, 0x21, 0xef, 0x7a, 0xa4, 0x66, 0xf5, 0xe3, 0xbe, 0x51, 0xaa, 0xbf, 0x5a,
    0xca, 0x89, 0x36, 0x9e, 0xbf, 0x67, 0xf6, 0xcd, 0x0e, 0xfe, 0x6a, 0xec, 0xd2, 0xa0, 0x04, 0x55,
    0xe3, 0x58, 0x48, 0xc5, 0xfc, 0xef, 0x4f, 0xeb, 0x3d, 0x0d, 0xb2, 0x11, 0x21, 0x3b, 0x42, 0xaa,
    0x4d, 0x7d, 0x54, 0xe8, 0xb8, 0x93, 0xfd, 0xf7, 0x31, 0x38, 0xd3, 0xe8, 0xfc, 0xa7, 0x35, 0xec,
    0x67, 0x4f, 0xeb, 0x7f, 0x07, 0x93, 0x36, 0x61, 0xa0, 0x7f, 0x36, 0x5e, 0x01, 0xd5, 0x96, 0xfb,
    0x1d, 0x77, 0xdb, 0xdd, 0x12, 0x1b, 0x3d, 0x1e, 0x46, 0x91, 0xfe, 0x85, 0x98, 0xcd, 0xba, 0xfa,
    0x0b, 0xa4, 0x9c, 0xa9, 0x53
};
#endif

PyTypeObject *init_KDateTimeEdit(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX].type;

    Shiboken::AutoDecRef Sbk_KDateTimeEdit_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_KDateTimeEdit_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KDateTimeEdit",
        "KDateTimeEdit*",
        &Sbk_KDateTimeEdit_spec,
        &Shiboken::callCppDestructor< KDateTimeEdit >,
        Sbk_KDateTimeEdit_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_KDateTimeEdit_TypeF(); // references _Sbk_KDateTimeEdit_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KDateTimeEdit_SignatureStrings);
#else
    InitSignatureBytes(pyType, KDateTimeEdit_SignatureBytes, KDateTimeEdit_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KDateTimeEdit_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KDateTimeEdit_PythonToCpp_KDateTimeEdit_PTR,
        is_KDateTimeEdit_PythonToCpp_KDateTimeEdit_PTR_Convertible,
        KDateTimeEdit_PTR_CppToPython_KDateTimeEdit);

    Shiboken::Conversions::registerConverterName(converter, "KDateTimeEdit");
    Shiboken::Conversions::registerConverterName(converter, "KDateTimeEdit*");
    Shiboken::Conversions::registerConverterName(converter, "KDateTimeEdit&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KDateTimeEdit).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KDateTimeEditWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KDateTimeEdit_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KDateTimeEdit_TypeF(), &Sbk_KDateTimeEditSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KDateTimeEdit_TypeF(), &Sbk_KDateTimeEdit_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KDateTimeEdit_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Option'.
    const char *Option_Initializer[] = {
        "ShowCalendar",
        "ShowDate",
        "ShowTime",
        "ShowTimeZone",
        "EditDate",
        "EditTime",
        "SelectCalendar",
        "SelectDate",
        "SelectTime",
        "SelectTimeZone",
        "DatePicker",
        "DateKeywords",
        "ForceTime",
        "WarnOnInvalid",
        nullptr};
    // "uint16_t" used instead of "unsigned int"
    constexpr uint16_t Option_InitializerValues[] = {
        uint16_t(KDateTimeEdit::Option::ShowCalendar),   //  0x0001  1
        uint16_t(KDateTimeEdit::Option::ShowDate),       //  0x0002  2
        uint16_t(KDateTimeEdit::Option::ShowTime),       //  0x0004  4
        uint16_t(KDateTimeEdit::Option::ShowTimeZone),   //  0x0008  8
        uint16_t(KDateTimeEdit::Option::EditDate),       //  0x0020  32
        uint16_t(KDateTimeEdit::Option::EditTime),       //  0x0040  64
        uint16_t(KDateTimeEdit::Option::SelectCalendar), //  0x0100  256
        uint16_t(KDateTimeEdit::Option::SelectDate),     //  0x0200  512
        uint16_t(KDateTimeEdit::Option::SelectTime),     //  0x0400  1024
        uint16_t(KDateTimeEdit::Option::SelectTimeZone), //  0x0800  2048
        uint16_t(KDateTimeEdit::Option::DatePicker),     //  0x1000  4096
        uint16_t(KDateTimeEdit::Option::DateKeywords),   //  0x2000  8192
        uint16_t(KDateTimeEdit::Option::ForceTime),      //  0x4000  16384
        uint16_t(KDateTimeEdit::Option::WarnOnInvalid)   //  0x8000  32768
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KDateTimeEdit_TypeF(),
        "1:KWidgetsAddons.KDateTimeEdit.Option",
        Option_Initializer, Option_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_Option_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KDateTimeEdit_Option_IDX].type =
        EType;
    // Register converter for enum 'KDateTimeEdit::Option'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KDateTimeEdit_Option_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KDateTimeEdit_Option,
            is_Enum_PythonToCpp_KDateTimeEdit_Option_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KDateTimeEdit::Option");
        Shiboken::Conversions::registerConverterAlias(converter, "Option");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KDateTimeEdit_Option_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KDateTimeEdit_Option,
            is_Enum_PythonToCpp_KDateTimeEdit_Option_Convertible);
        // Register converter for flag 'QFlags<KDateTimeEdit::Option>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KDateTimeEdit::Option>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KDateTimeEdit::Options");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'Option' enum/flags.

    PySide::Signal::registerSignals(pyType, &::KDateTimeEdit::staticMetaObject);
    qRegisterMetaType< ::KDateTimeEdit::Option >("KDateTimeEdit::Option");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KDateTimeEdit::staticMetaObject, sizeof(KDateTimeEditWrapper));

    return pyType;
}
