
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "knewpassworddialog_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"
#include "kpixmapregionselectordialog_wrapper.h"
#include "ktimecombobox_wrapper.h"

// Argument includes
#include <QString>
#include <kpassword.h>
#include <qbytearray.h>
#include <qcolor.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qicon.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KNewPasswordDialog_Type = nullptr;
static PyTypeObject *Sbk_KNewPasswordDialog_TypeF(void)
{
    return _Sbk_KNewPasswordDialog_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KNewPasswordDialogWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KNewPasswordDialogWrapper::KNewPasswordDialogWrapper(::QWidget * parent) : KNewPasswordDialog(parent)
{
}

void KNewPasswordDialogWrapper::accept()
{
    static const char *funcName = "accept";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::KNewPasswordDialog::accept();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KNewPasswordDialog", funcName, gil, pyOverride);
}

void KNewPasswordDialogWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

void KNewPasswordDialogWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

bool KNewPasswordDialogWrapper::checkPassword(const ::QString & arg__1)
{
    static const char *funcName = "checkPassword";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::KNewPasswordDialog::checkPassword(arg__1);
    }
    return sbk_o_checkPassword("KNewPasswordDialog", funcName, gil, pyOverride, arg__1);
}

bool KNewPasswordDialogWrapper::sbk_o_checkPassword(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QString & arg__1)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &arg__1)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &arg__1)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void KNewPasswordDialogWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

void KNewPasswordDialogWrapper::closeEvent(::QCloseEvent * arg__1)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::closeEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KNewPasswordDialog", funcName, gil, pyOverride, arg__1);
}

void KNewPasswordDialogWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KNewPasswordDialog", funcName, gil, pyOverride, signal);
}

void KNewPasswordDialogWrapper::contextMenuEvent(::QContextMenuEvent * arg__1)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::contextMenuEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KNewPasswordDialog", funcName, gil, pyOverride, arg__1);
}

void KNewPasswordDialogWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

int KNewPasswordDialogWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KNewPasswordDialog", funcName, gil, pyOverride);
}

void KNewPasswordDialogWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KNewPasswordDialog", funcName, gil, pyOverride, signal);
}

void KNewPasswordDialogWrapper::done(int arg__1)
{
    static const char *funcName = "done";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::done(arg__1);
    }
    KPixmapRegionSelectorDialogWrapper::sbk_o_done("KNewPasswordDialog", funcName, gil, pyOverride, arg__1);
}

void KNewPasswordDialogWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

void KNewPasswordDialogWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

void KNewPasswordDialogWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

void KNewPasswordDialogWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

void KNewPasswordDialogWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

bool KNewPasswordDialogWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

bool KNewPasswordDialogWrapper::eventFilter(::QObject * arg__1, ::QEvent * arg__2)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::eventFilter(arg__1, arg__2);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KNewPasswordDialog", funcName, gil, pyOverride, arg__1, arg__2);
}

int KNewPasswordDialogWrapper::exec()
{
    static const char *funcName = "exec";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::exec();
    }
    return KPixmapRegionSelectorDialogWrapper::sbk_o_exec("KNewPasswordDialog", funcName, gil, pyOverride);
}

void KNewPasswordDialogWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

bool KNewPasswordDialogWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KNewPasswordDialog", funcName, gil, pyOverride, next);
}

void KNewPasswordDialogWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

bool KNewPasswordDialogWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KNewPasswordDialog", funcName, gil, pyOverride);
}

int KNewPasswordDialogWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KNewPasswordDialog", funcName, gil, pyOverride, arg__1);
}

void KNewPasswordDialogWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

void KNewPasswordDialogWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KNewPasswordDialog", funcName, gil, pyOverride, painter);
}

void KNewPasswordDialogWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

::QVariant KNewPasswordDialogWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KNewPasswordDialog", funcName, gil, pyOverride, arg__1);
}

void KNewPasswordDialogWrapper::keyPressEvent(::QKeyEvent * arg__1)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::keyPressEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KNewPasswordDialog", funcName, gil, pyOverride, arg__1);
}

void KNewPasswordDialogWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

void KNewPasswordDialogWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

int KNewPasswordDialogWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KNewPasswordDialog", funcName, gil, pyOverride, arg__1);
}

::QSize KNewPasswordDialogWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KNewPasswordDialog", funcName, gil, pyOverride);
}

void KNewPasswordDialogWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

void KNewPasswordDialogWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

void KNewPasswordDialogWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

void KNewPasswordDialogWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

void KNewPasswordDialogWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

bool KNewPasswordDialogWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KNewPasswordDialog", funcName, gil, pyOverride, eventType, message, result);
}

void KNewPasswordDialogWrapper::open()
{
    static const char *funcName = "open";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::open();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KNewPasswordDialog", funcName, gil, pyOverride);
}

::QPaintEngine * KNewPasswordDialogWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KNewPasswordDialog", funcName, gil, pyOverride);
}

void KNewPasswordDialogWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

::QPaintDevice * KNewPasswordDialogWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KNewPasswordDialog", funcName, gil, pyOverride, offset);
}

void KNewPasswordDialogWrapper::reject()
{
    static const char *funcName = "reject";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::reject();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KNewPasswordDialog", funcName, gil, pyOverride);
}

void KNewPasswordDialogWrapper::resizeEvent(::QResizeEvent * arg__1)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::resizeEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KNewPasswordDialog", funcName, gil, pyOverride, arg__1);
}

void KNewPasswordDialogWrapper::setVisible(bool visible)
{
    static const char *funcName = "setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KNewPasswordDialog", funcName, gil, pyOverride, visible);
}

::QPainter * KNewPasswordDialogWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KNewPasswordDialog", funcName, gil, pyOverride);
}

void KNewPasswordDialogWrapper::showEvent(::QShowEvent * arg__1)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::showEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KNewPasswordDialog", funcName, gil, pyOverride, arg__1);
}

::QSize KNewPasswordDialogWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KNewPasswordDialog", funcName, gil, pyOverride);
}

void KNewPasswordDialogWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[50], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

void KNewPasswordDialogWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[51], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

void KNewPasswordDialogWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[52], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KNewPasswordDialog", funcName, gil, pyOverride, event);
}

const QMetaObject *KNewPasswordDialogWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KNewPasswordDialog::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KNewPasswordDialogWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KNewPasswordDialog::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KNewPasswordDialogWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KNewPasswordDialogWrapper *>(this));
    }
    return KNewPasswordDialog::qt_metacast(_clname);
}

KNewPasswordDialogWrapper::~KNewPasswordDialogWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KNewPasswordDialog_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KNewPasswordDialog_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KNewPasswordDialog >()))
        return -1;

    KNewPasswordDialogWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KNewPasswordDialog", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KNewPasswordDialog::KNewPasswordDialog(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KNewPasswordDialog(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KNewPasswordDialog(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KNewPasswordDialog(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KNewPasswordDialogWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KNewPasswordDialogWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KNewPasswordDialog >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KNewPasswordDialogFunc_accept(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // accept()
        Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KNewPasswordDialog::accept()
            : cppSelf->accept();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNewPasswordDialogFunc_allowEmptyPasswords(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // allowEmptyPasswords()const
        bool cppResult = const_cast<const ::KNewPasswordDialog *>(cppSelf)->allowEmptyPasswords();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordDialogFunc_backgroundWarningColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // backgroundWarningColor()const
        QColor cppResult = const_cast<const ::KNewPasswordDialog *>(cppSelf)->backgroundWarningColor();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordDialogFunc_checkAndGetPassword(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNewPasswordDialog::checkAndGetPassword(QString*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // checkAndGetPassword(QString*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "checkAndGetPassword", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]);

    // Call function/method
    {
        ::QString *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // checkAndGetPassword(QString*)
            bool cppResult = cppSelf->checkAndGetPassword(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordDialogFunc_checkPassword(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNewPasswordDialog::checkPassword(QString)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // checkPassword(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "checkPassword", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // checkPassword(QString)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KNewPasswordDialog::checkPassword(cppArg0)
                : cppSelf->checkPassword(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordDialogFunc_icon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // icon()const
        QIcon cppResult = const_cast<const ::KNewPasswordDialog *>(cppSelf)->icon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordDialogFunc_isRevealPasswordAvailable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KNewPasswordDialog", "isRevealPasswordAvailable() const");
        if (Shiboken::Errors::occurred() != nullptr)
            return {};

        // isRevealPasswordAvailable()const
        bool cppResult = const_cast<const ::KNewPasswordDialog *>(cppSelf)->isRevealPasswordAvailable();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordDialogFunc_maximumPasswordLength(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // maximumPasswordLength()const
        int cppResult = const_cast<const ::KNewPasswordDialog *>(cppSelf)->maximumPasswordLength();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordDialogFunc_minimumPasswordLength(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // minimumPasswordLength()const
        int cppResult = const_cast<const ::KNewPasswordDialog *>(cppSelf)->minimumPasswordLength();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordDialogFunc_password(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // password()const
        QString cppResult = const_cast<const ::KNewPasswordDialog *>(cppSelf)->password();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordDialogFunc_passwordStrengthWarningLevel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // passwordStrengthWarningLevel()const
        int cppResult = const_cast<const ::KNewPasswordDialog *>(cppSelf)->passwordStrengthWarningLevel();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordDialogFunc_prompt(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // prompt()const
        QString cppResult = const_cast<const ::KNewPasswordDialog *>(cppSelf)->prompt();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordDialogFunc_reasonablePasswordLength(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // reasonablePasswordLength()const
        int cppResult = const_cast<const ::KNewPasswordDialog *>(cppSelf)->reasonablePasswordLength();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordDialogFunc_revealPasswordMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // revealPasswordMode()const
        KPassword::RevealMode cppResult = const_cast<const ::KNewPasswordDialog *>(cppSelf)->revealPasswordMode();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPassword_RevealMode_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordDialogFunc_setAllowEmptyPasswords(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNewPasswordDialog::setAllowEmptyPasswords(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAllowEmptyPasswords(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAllowEmptyPasswords", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAllowEmptyPasswords(bool)
            cppSelf->setAllowEmptyPasswords(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNewPasswordDialogFunc_setBackgroundWarningColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNewPasswordDialog::setBackgroundWarningColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArg)))) {
        overloadId = 0; // setBackgroundWarningColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setBackgroundWarningColor", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setBackgroundWarningColor(QColor)
            cppSelf->setBackgroundWarningColor(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNewPasswordDialogFunc_setIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNewPasswordDialog::setIcon(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArg)))) {
        overloadId = 0; // setIcon(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setIcon", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setIcon(QIcon)
            cppSelf->setIcon(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNewPasswordDialogFunc_setMaximumPasswordLength(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNewPasswordDialog::setMaximumPasswordLength(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMaximumPasswordLength(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMaximumPasswordLength", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMaximumPasswordLength(int)
            cppSelf->setMaximumPasswordLength(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNewPasswordDialogFunc_setMinimumPasswordLength(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNewPasswordDialog::setMinimumPasswordLength(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMinimumPasswordLength(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMinimumPasswordLength", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMinimumPasswordLength(int)
            cppSelf->setMinimumPasswordLength(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNewPasswordDialogFunc_setPasswordStrengthWarningLevel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNewPasswordDialog::setPasswordStrengthWarningLevel(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setPasswordStrengthWarningLevel(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPasswordStrengthWarningLevel", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPasswordStrengthWarningLevel(int)
            cppSelf->setPasswordStrengthWarningLevel(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNewPasswordDialogFunc_setPrompt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNewPasswordDialog::setPrompt(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setPrompt(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPrompt", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPrompt(QString)
            cppSelf->setPrompt(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNewPasswordDialogFunc_setReasonablePasswordLength(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNewPasswordDialog::setReasonablePasswordLength(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setReasonablePasswordLength(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setReasonablePasswordLength", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setReasonablePasswordLength(int)
            cppSelf->setReasonablePasswordLength(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNewPasswordDialogFunc_setRevealPasswordAvailable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNewPasswordDialog::setRevealPasswordAvailable(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setRevealPasswordAvailable(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setRevealPasswordAvailable", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]);

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KNewPasswordDialog", "setRevealPasswordAvailable(bool reveal)");
        if (Shiboken::Errors::occurred() != nullptr)
            return {};
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setRevealPasswordAvailable(bool)
            cppSelf->setRevealPasswordAvailable(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNewPasswordDialogFunc_setRevealPasswordMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNewPasswordDialog::setRevealPasswordMode(KPassword::RevealMode)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPassword_RevealMode_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setRevealPasswordMode(KPassword::RevealMode)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setRevealPasswordMode", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]);

    // Call function/method
    {
        ::KPassword::RevealMode cppArg0{KPassword::RevealMode::OnlyNew};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setRevealPasswordMode(KPassword::RevealMode)
            cppSelf->setRevealPasswordMode(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KNewPasswordDialog_PropertyStrings[] = {
    "revealPasswordMode::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KNewPasswordDialog_methods[] = {
    {"accept", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_accept), METH_NOARGS, nullptr},
    {"allowEmptyPasswords", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_allowEmptyPasswords), METH_NOARGS, nullptr},
    {"backgroundWarningColor", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_backgroundWarningColor), METH_NOARGS, nullptr},
    {"checkAndGetPassword", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_checkAndGetPassword), METH_O, nullptr},
    {"checkPassword", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_checkPassword), METH_O, nullptr},
    {"icon", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_icon), METH_NOARGS, nullptr},
    {"isRevealPasswordAvailable", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_isRevealPasswordAvailable), METH_NOARGS, nullptr},
    {"maximumPasswordLength", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_maximumPasswordLength), METH_NOARGS, nullptr},
    {"minimumPasswordLength", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_minimumPasswordLength), METH_NOARGS, nullptr},
    {"password", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_password), METH_NOARGS, nullptr},
    {"passwordStrengthWarningLevel", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_passwordStrengthWarningLevel), METH_NOARGS, nullptr},
    {"prompt", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_prompt), METH_NOARGS, nullptr},
    {"reasonablePasswordLength", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_reasonablePasswordLength), METH_NOARGS, nullptr},
    {"revealPasswordMode", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_revealPasswordMode), METH_NOARGS, nullptr},
    {"setAllowEmptyPasswords", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_setAllowEmptyPasswords), METH_O, nullptr},
    {"setBackgroundWarningColor", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_setBackgroundWarningColor), METH_O, nullptr},
    {"setIcon", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_setIcon), METH_O, nullptr},
    {"setMaximumPasswordLength", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_setMaximumPasswordLength), METH_O, nullptr},
    {"setMinimumPasswordLength", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_setMinimumPasswordLength), METH_O, nullptr},
    {"setPasswordStrengthWarningLevel", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_setPasswordStrengthWarningLevel), METH_O, nullptr},
    {"setPrompt", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_setPrompt), METH_O, nullptr},
    {"setReasonablePasswordLength", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_setReasonablePasswordLength), METH_O, nullptr},
    {"setRevealPasswordAvailable", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_setRevealPasswordAvailable), METH_O, nullptr},
    {"setRevealPasswordMode", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordDialogFunc_setRevealPasswordMode), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KNewPasswordDialog_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KNewPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KNewPasswordDialogWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KNewPasswordDialog_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KNewPasswordDialog_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KNewPasswordDialogSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KNewPasswordDialog *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX]))
        return static_cast< ::QDialog *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KNewPasswordDialog_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KNewPasswordDialog_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KNewPasswordDialog_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KNewPasswordDialog_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KNewPasswordDialog_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KNewPasswordDialog_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KNewPasswordDialog_spec = {
    "1:KWidgetsAddons.KNewPasswordDialog",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KNewPasswordDialog_slots
};

} //extern "C"

static void *Sbk_KNewPasswordDialog_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KNewPasswordDialog *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KNewPasswordDialog *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KNewPasswordDialog *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KNewPasswordDialog_PythonToCpp_KNewPasswordDialog_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KNewPasswordDialog_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KNewPasswordDialog_PythonToCpp_KNewPasswordDialog_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KNewPasswordDialog_TypeF()))
        return KNewPasswordDialog_PythonToCpp_KNewPasswordDialog_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KNewPasswordDialog_PTR_CppToPython_KNewPasswordDialog(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KNewPasswordDialog *>(const_cast<void *>(cppIn)), Sbk_KNewPasswordDialog_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KNewPasswordDialog_SignatureStrings[] = {
    "KWidgetsAddons.KNewPasswordDialog(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,revealPasswordMode:KWidgetsAddons.KPassword.RevealMode=None)",
    "KWidgetsAddons.KNewPasswordDialog.accept(self)",
    "KWidgetsAddons.KNewPasswordDialog.allowEmptyPasswords(self)->bool",
    "KWidgetsAddons.KNewPasswordDialog.backgroundWarningColor(self)->PySide6.QtGui.QColor",
    "KWidgetsAddons.KNewPasswordDialog.checkAndGetPassword(self,pwd:QString*)->bool",
    "KWidgetsAddons.KNewPasswordDialog.checkPassword(self,arg__1:QString)->bool",
    "KWidgetsAddons.KNewPasswordDialog.icon(self)->PySide6.QtGui.QIcon",
    "KWidgetsAddons.KNewPasswordDialog.isRevealPasswordAvailable(self)->bool",
    "KWidgetsAddons.KNewPasswordDialog.maximumPasswordLength(self)->int",
    "KWidgetsAddons.KNewPasswordDialog.minimumPasswordLength(self)->int",
    "KWidgetsAddons.KNewPasswordDialog.password(self)->QString",
    "KWidgetsAddons.KNewPasswordDialog.passwordStrengthWarningLevel(self)->int",
    "KWidgetsAddons.KNewPasswordDialog.prompt(self)->QString",
    "KWidgetsAddons.KNewPasswordDialog.reasonablePasswordLength(self)->int",
    "KWidgetsAddons.KNewPasswordDialog.revealPasswordMode(self)->KWidgetsAddons.KPassword.RevealMode",
    "KWidgetsAddons.KNewPasswordDialog.setAllowEmptyPasswords(self,allowed:bool)",
    "KWidgetsAddons.KNewPasswordDialog.setBackgroundWarningColor(self,color:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int])",
    "KWidgetsAddons.KNewPasswordDialog.setIcon(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap])",
    "KWidgetsAddons.KNewPasswordDialog.setMaximumPasswordLength(self,maxLength:int)",
    "KWidgetsAddons.KNewPasswordDialog.setMinimumPasswordLength(self,minLength:int)",
    "KWidgetsAddons.KNewPasswordDialog.setPasswordStrengthWarningLevel(self,warningLevel:int)",
    "KWidgetsAddons.KNewPasswordDialog.setPrompt(self,prompt:QString)",
    "KWidgetsAddons.KNewPasswordDialog.setReasonablePasswordLength(self,reasonableLength:int)",
    "KWidgetsAddons.KNewPasswordDialog.setRevealPasswordAvailable(self,reveal:bool)",
    "KWidgetsAddons.KNewPasswordDialog.setRevealPasswordMode(self,revealPasswordMode:KWidgetsAddons.KPassword.RevealMode)",
    nullptr}; // Sentinel
#else
static constexpr size_t KNewPasswordDialog_SignatureByteSize = 488;
static constexpr uint8_t KNewPasswordDialog_SignatureBytes[488] = {
    0x78, 0xda, 0xa5, 0x95, 0x4b, 0x4f, 0xe3, 0x30, 0x10, 0x80, 0xef, 0xfc, 0x8a, 0x1e, 0x29, 0x32,
    0x91, 0x90, 0x10, 0x87, 0x48, 0xac, 0xd4, 0x85, 0x55, 0x85, 0x52, 0xd8, 0x26, 0x68, 0xe1, 0xb0,
    0x42, 0xc8, 0x89, 0x87, 0x60, 0xe1, 0x8c, 0x23, 0xdb, 0x21, 0xe4, 0xdf, 0xaf, 0xf3, 0x30, 0x2d,
    0x8f, 0x14, 0x67, 0x39, 0x35, 0xf5, 0xcc, 0x7c, 0x1e, 0x8f, 0xfc, 0x25, 0xd1, 0x2d, 0x67, 0x39,
    0x18, 0xbd, 0x60, 0x4c, 0xa2, 0x0e, 0xa2, 0x2b, 0xa8, 0xd7, 0x54, 0xeb, 0x5a, 0x2a, 0x76, 0xce,
    0xa9, 0x90, 0xf9, 0xbe, 0x06, 0xf1, 0x40, 0x4a, 0xaa, 0x00, 0x4d, 0xb8, 0x6e, 0xae, 0x39, 0x83,
    0x93, 0x20, 0x36, 0x43, 0x59, 0x10, 0xf7, 0x0f, 0xa7, 0x58, 0x09, 0x51, 0x1a, 0x45, 0x0e, 0xc2,
    0x08, 0x9a, 0xb6, 0xfa, 0x37, 0x8a, 0xe6, 0xf4, 0x4a, 0x22, 0x10, 0x05, 0xcf, 0x40, 0x85, 0xa3,
    0x5e, 0x4a, 0x06, 0x61, 0xf4, 0x6e, 0x57, 0x17, 0x0c, 0x92, 0x2e, 0xb7, 0xcd, 0xe9, 0x6a, 0xe7,
    0x7b, 0xd1, 0x57, 0xfd, 0x05, 0x34, 0xcb, 0xa0, 0x34, 0x5d, 0x9b, 0x5e, 0xe9, 0x42, 0xc8, 0xfa,
    0x57, 0x51, 0x9a, 0xc6, 0x05, 0x74, 0x5f, 0x7b, 0xf8, 0x23, 0x95, 0x52, 0x78, 0x10, 0x52, 0x9a,
    0x3d, 0xe5, 0x4a, 0x56, 0xc8, 0x6e, 0xa9, 0x42, 0x8e, 0xf9, 0x99, 0x14, 0x52, 0x39, 0xc8, 0x66,
    0x44, 0xcb, 0x8a, 0x07, 0x71, 0x17, 0xf3, 0x80, 0x66, 0x8f, 0x90, 0x3d, 0x2d, 0x90, 0x2d, 0xc1,
    0xb8, 0xc8, 0x30, 0xf9, 0x9a, 0x85, 0xf1, 0xb5, 0x51, 0x76, 0x9f, 0x03, 0xff, 0x1e, 0x3b, 0xdc,
    0x5b, 0x10, 0x55, 0xf9, 0xfd, 0xfd, 0x91, 0x63, 0xf9, 0xa3, 0x78, 0x26, 0x71, 0xe4, 0x70, 0x17,
    0x36, 0xe4, 0x43, 0xd0, 0xc9, 0x9b, 0x2b, 0xb0, 0x78, 0xa6, 0x5c, 0xd0, 0x54, 0xc0, 0xc4, 0xc1,
    0x17, 0xf4, 0x85, 0x17, 0x55, 0xe1, 0x56, 0x57, 0x80, 0xb9, 0x79, 0x74, 0x0c, 0x8e, 0xc6, 0x07,
    0xc1, 0xf1, 0xbb, 0x88, 0x72, 0x7b, 0xaa, 0xb6, 0x6a, 0x18, 0xe8, 0x84, 0x4a, 0x5b, 0xd0, 0xed,
    0x3b, 0x5c, 0x9f, 0x95, 0x1d, 0x8e, 0x98, 0xd8, 0x83, 0x92, 0x85, 0xbb, 0xf3, 0x53, 0x3a, 0x50,
    0x40, 0xb5, 0xc4, 0x76, 0xf4, 0xdf, 0x99, 0xc0, 0x47, 0xa1, 0x5d, 0xbd, 0x87, 0xd7, 0x1e, 0x7c,
    0x0d, 0x66, 0x31, 0x62, 0x29, 0xe9, 0xf4, 0x05, 0x16, 0xb6, 0x57, 0x66, 0xee, 0xc7, 0xfa, 0x39,
    0xee, 0x2b, 0xc9, 0xda, 0xc7, 0xd0, 0x34, 0xa5, 0x5d, 0x0e, 0xfe, 0x20, 0x97, 0xf8, 0xf7, 0x33,
    0x81, 0xc9, 0x2c, 0x5e, 0x51, 0xc3, 0xf1, 0xa8, 0x9f, 0x34, 0x99, 0xbd, 0x4b, 0x4a, 0xf2, 0x94,
    0x9e, 0x1c, 0xdb, 0xac, 0x1b, 0xaa, 0x38, 0x45, 0xb3, 0x9d, 0x70, 0x26, 0x15, 0xd8, 0x9f, 0x60,
    0x29, 0x64, 0x4a, 0x85, 0xc3, 0x39, 0x50, 0x85, 0x9a, 0xe7, 0x08, 0x6c, 0x66, 0x47, 0x7f, 0xe7,
    0x79, 0xa0, 0x0b, 0x67, 0x24, 0x69, 0xdd, 0xdc, 0xd9, 0x7d, 0x9b, 0xfa, 0xa1, 0xdb, 0x35, 0x7f,
    0x29, 0x68, 0xe9, 0xbb, 0xdb, 0xe5, 0xa8, 0x75, 0xc4, 0x0a, 0xd9, 0xff, 0x0d, 0x6d, 0xf7, 0xbe,
    0xb8, 0x51, 0x03, 0x89, 0x95, 0x73, 0x32, 0x6e, 0xfd, 0x95, 0x53, 0xa4, 0xde, 0x5a, 0x99, 0x02,
    0xde, 0x28, 0x46, 0x7a, 0xdd, 0x5e, 0x5f, 0x9d, 0x7e, 0x80, 0x64, 0x97, 0x6b, 0x64, 0x63, 0xe2,
    0xe4, 0x23, 0xef, 0x7a, 0x99, 0x0e, 0x1f, 0xdb, 0x29, 0x7a, 0x24, 0x9f, 0xdb, 0xfc, 0x9f, 0x9f,
    0xed, 0xf9, 0xde, 0x3f, 0xea, 0x64, 0x1d, 0x74
};
#endif

PyTypeObject *init_KNewPasswordDialog(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX].type;

    Shiboken::AutoDecRef Sbk_KNewPasswordDialog_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX]))));

    _Sbk_KNewPasswordDialog_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KNewPasswordDialog",
        "KNewPasswordDialog*",
        &Sbk_KNewPasswordDialog_spec,
        &Shiboken::callCppDestructor< KNewPasswordDialog >,
        Sbk_KNewPasswordDialog_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_KNewPasswordDialog_TypeF(); // references _Sbk_KNewPasswordDialog_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KNewPasswordDialog_SignatureStrings);
#else
    InitSignatureBytes(pyType, KNewPasswordDialog_SignatureBytes, KNewPasswordDialog_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KNewPasswordDialog_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KNewPasswordDialog_PythonToCpp_KNewPasswordDialog_PTR,
        is_KNewPasswordDialog_PythonToCpp_KNewPasswordDialog_PTR_Convertible,
        KNewPasswordDialog_PTR_CppToPython_KNewPasswordDialog);

    Shiboken::Conversions::registerConverterName(converter, "KNewPasswordDialog");
    Shiboken::Conversions::registerConverterName(converter, "KNewPasswordDialog*");
    Shiboken::Conversions::registerConverterName(converter, "KNewPasswordDialog&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KNewPasswordDialog).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KNewPasswordDialogWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KNewPasswordDialog_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KNewPasswordDialog_TypeF(), &Sbk_KNewPasswordDialogSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KNewPasswordDialog_TypeF(), &Sbk_KNewPasswordDialog_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::KNewPasswordDialog::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KNewPasswordDialog::staticMetaObject, sizeof(KNewPasswordDialogWrapper));

    return pyType;
}
