
//
// @(#)btyaccpar, based on byacc 1.8 (Berkeley)
// Parser skeleton modified for use in the Firebird project by Nickolay Samofatov
//
#define YYBTYACC 1

#include "firebird.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "../dsql/Nodes.h"
#include "../dsql/AggNodes.h"
#include "../dsql/DdlNodes.h"
#include "../dsql/BoolNodes.h"
#include "../dsql/ExprNodes.h"
#include "../dsql/PackageNodes.h"
#include "../dsql/StmtNodes.h"
#include "../dsql/WinNodes.h"
#include "../jrd/RecordSourceNodes.h"
#include "../common/classes/Nullable.h"
#include "gen/parse.h"
#include "../dsql/Parser.h"

#define YYERROR_DETAILED

/*
*	PROGRAM:	Dynamic SQL runtime support
*	MODULE:		parse.y
*	DESCRIPTION:	Dynamic SQL parser
*
* The contents of this file are subject to the Interbase Public
* License Version 1.0 (the "License"); you may not use this file
* except in compliance with the License. You may obtain a copy
* of the License at http://www.Inprise.com/IPL.html
*
* Software distributed under the License is distributed on an
* "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
* or implied. See the License for the specific language governing
* rights and limitations under the License.
*
* The Original Code was created by Inprise Corporation
* and its predecessors. Portions created by Inprise Corporation are
* Copyright (C) Inprise Corporation.
*
* All Rights Reserved.
* Contributor(s): ______________________________________.
*
* 2002-02-24 Sean Leyne - Code Cleanup of old Win 3.1 port (WINDOWS_ONLY)
* 2001.05.20 Neil McCalden: Allow a udf to be used in a 'group by' clause.
* 2001.05.30 Claudio Valderrama: DROP TABLE and DROP VIEW lead now to two
*   different node types so DDL can tell which is which.
* 2001.06.13 Claudio Valderrama: SUBSTRING is being surfaced.
* 2001.06.30 Claudio valderrama: Feed (line,column) for each node. See node.h.
* 2001.07.10 Claudio Valderrama: Better (line,column) report and "--" for comments.
* 2001.07.28 John Bellardo: Changes to support parsing LIMIT and FIRST
* 2001.08.03 John Bellardo: Finalized syntax for LIMIT, change LIMIT to SKIP
* 2001.08.05 Claudio Valderrama: closed Bug #448062 and other spaces that appear
*   in rdb$*_source fields when altering domains plus one unexpected null pointer.
* 2001.08.12 Claudio Valderrama: adjust SUBSTRING's starting pos argument here
*   and not in gen.c; this closes Bug #450301.
* 2001.10.01 Claudio Valderrama: enable explicit GRANT...to ROLE role_name.
* 2001.10.06 Claudio Valderrama: Honor explicit USER keyword in GRANTs and REVOKEs.
* 2002.07.05 Mark O'Donohue: change keyword DEBUG to KW_DEBUG to avoid
*			clashes with normal DEBUG macro.
* 2002.07.30 Arno Brinkman:
* 2002.07.30 	Let IN predicate handle value_expressions
* 2002.07.30 	tokens CASE, NULLIF, COALESCE added
* 2002.07.30 	See block < CASE expression > what is added to value as case_expression
* 2002.07.30 	function is split up into aggregate_function, numeric_value_function, string_value_function, generate_value_function
* 2002.07.30 	new group_by_function and added to grp_column_elem
* 2002.07.30 	cast removed from function and added as cast_specification to value
* 2002.08.04 Claudio Valderrama: allow declaring and defining variables at the same time
* 2002.08.04 Dmitry Yemanov: ALTER VIEW
* 2002.08.06 Arno Brinkman: ordinal added to grp_column_elem for using positions in group by
* 2002.08.07 Dmitry Yemanov: INT64/LARGEINT are replaced with BIGINT and available in dialect 3 only
* 2002.08.31 Dmitry Yemanov: allowed user-defined index names for PK/FK/UK constraints
* 2002.09.01 Dmitry Yemanov: RECREATE VIEW
* 2002.09.28 Dmitry Yemanov: Reworked internal_info stuff, enhanced
*							exception handling in SPs/triggers,
*							implemented ROWS_AFFECTED system variable
* 2002.10.21 Nickolay Samofatov: Added support for explicit pessimistic locks
* 2002.10.29 Nickolay Samofatov: Added support for savepoints
* 2002.12.03 Dmitry Yemanov: Implemented ORDER BY clause in subqueries.
* 2002.12.18 Dmitry Yemanov: Added support for SQL-compliant labels and LEAVE statement
* 2002.12.28 Dmitry Yemanov: Added support for parametrized events.
* 2003.01.14 Dmitry Yemanov: Fixed bug with cursors in triggers.
* 2003.01.15 Dmitry Yemanov: Added support for runtime trigger action checks.
* 2003.02.10 Mike Nordell  : Undefined Microsoft introduced macros to get a clean compile.
* 2003.05.24 Nickolay Samofatov: Make SKIP and FIRST non-reserved keywords
* 2003.06.13 Nickolay Samofatov: Make INSERTING/UPDATING/DELETING non-reserved keywords
* 2003.07.01 Blas Rodriguez Somoza: Change DEBUG and IN to avoid conflicts in win32 build/bison
* 2003.08.11 Arno Brinkman: Changed GROUP BY to support all expressions and added "AS" support
*						   with table alias. Also removed group_by_function and ordinal.
* 2003.08.14 Arno Brinkman: Added support for derived tables.
* 2003.10.05 Dmitry Yemanov: Added support for explicit cursors in PSQL.
* 2004.01.16 Vlad Horsun: added support for default parameters and
*   EXECUTE BLOCK statement
* Adriano dos Santos Fernandes
*/

#include "firebird.h"
#include "dyn_consts.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#include "gen/iberror.h"
#include "../dsql/dsql.h"
#include "../jrd/ibase.h"
#include "../jrd/flags.h"
#include "../jrd/jrd.h"
#include "../jrd/DataTypeUtil.h"
#include "../dsql/errd_proto.h"
#include "../dsql/make_proto.h"
#include "../yvalve/gds_proto.h"
#include "../jrd/err_proto.h"
#include "../common/intlobj_new.h"
#include "../jrd/Attachment.h"
#include "../common/StatusArg.h"

/* This is needed here to provide backward compatibility when working with SSPI plugin*/
#include "../auth/trusted/AuthSspi.h"

/* since UNIX isn't standard, we have to define*/
/* stuff which is in <limits.h> (which isn't available on all UNIXes...*/

const long SHRT_POS_MAX			= 32767;
const long SHRT_UNSIGNED_MAX	= 65535;
const long SHRT_NEG_MAX			= 32768;
const int POSITIVE	= 0;
const int NEGATIVE	= 1;
const int UNSIGNED	= 2;

/*const int MIN_CACHE_BUFFERS	= 250;*/
/*const int DEF_CACHE_BUFFERS	= 1000;*/

#define YYSTYPE YYSTYPE
#if defined(DEBUG) || defined(DEV_BUILD)
#define YYDEBUG		1
#endif

#define YYREDUCEPOSNFUNC yyReducePosn
#define YYREDUCEPOSNFUNCARG NULL


/* ASF: Inherited attributes (aka rule parameters) are executed even when in trial mode, but action*/
/* rules ({}) are executed only when in full parse mode. NOTRIAL should be used to avoid segfaults*/
/* due to accessing invalid pointers in parameters (not yet returned from action rules).*/
#define NOTRIAL(x) (yytrial ? NULL : (x))


inline unsigned trigger_type_suffix(const unsigned slot1, const unsigned slot2, const unsigned slot3)
{
	return ((slot1 << 1) | (slot2 << 3) | (slot3 << 5));
}


#include "../dsql/chars.h"

using namespace Jrd;
using namespace Firebird;

static int yylhs[] = {                                        -1,
    0,    0,    1,    1,    1,    2,    2,    2,    2,    2,
    2,    2,    2,    2,    3,    3,    3,    3,    3,    3,
    3,    3,    3,    3,    4,    4,    4,    4,  552,  553,
    5,  554,  556,    6,    6,    6,    6,    6,    6,    6,
  557,    6,    6,  558,  559,    6,    7,    7,    7,    7,
    7,    7,    7,    7,    7,    7,    7,    7,    7,  555,
  555,    8,    8,  560,    8,    9,  561,    9,   10,   11,
   12,   12,   12,   12,   12,   13,   13,  562,  562,   14,
   14,   15,   15,   15,   16,   16,   17,   17,   18,   18,
   18,   19,   19,   20,   20,   21,   21,  563,  563,   22,
   22,  564,   23,  565,  566,   24,   24,   24,   24,   24,
   24,   24,  567,   24,   24,  568,   24,   24,   25,   25,
   26,   26,  569,   27,   27,  570,   27,   27,   28,   28,
   28,   28,   28,   28,   29,   29,   29,   30,   30,   31,
   32,   32,   33,   34,   35,   35,  571,  572,  573,   36,
   37,   37,   37,   38,  574,   38,  575,   38,   39,  576,
   39,   40,   41,   41,   41,   41,  577,   42,  578,   42,
   43,   43,   44,   44,   44,   44,   44,   45,   46,   46,
   47,   48,  579,  580,   48,   48,   48,   48,   48,   48,
   48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
   48,  581,   48,  582,   48,   49,   50,   50,   50,   50,
   50,   50,   50,   50,   50,   50,   50,   51,   52,   52,
   52,   52,   52,   52,   52,   52,   52,   52,   52,   53,
   54,   55,   56,   56,   57,   57,   57,  584,  585,   58,
   59,   59,   59,   60,   60,   61,   61,   62,  588,   62,
   63,   63,  590,  591,   64,   65,   65,   66,  592,   66,
   67,   67,  589,  589,   68,   69,   69,  593,   70,   71,
   72,   72,   73,   74,   74,  594,  594,   75,   76,   76,
   77,   78,   78,   79,   79,   80,   81,   81,   81,   82,
  595,  596,  597,  598,   83,   84,   84,   84,   85,   85,
   86,  599,   86,   87,   87,   87,   88,   88,   89,   89,
   90,   90,   91,   91,   92,  600,  601,  602,   93,  586,
  586,   94,   95,   95,   96,  603,   96,   97,   97,   97,
   97,   97,   97,   97,   97,   98,   98,   99,   99,  100,
  100,  100,  100,  604,  605,  101,  102,  102,  103,  606,
  103,  104,  104,  607,  607,  607,  587,  587,  587,  608,
  609,  105,  610,  106,  107,  107,  107,  108,  108,  108,
  611,  109,  612,  109,  613,  110,  110,  614,  615,  111,
  616,  111,  111,  111,  112,  113,  113,  114,  617,  617,
  618,  583,  583,  115,  115,  116,  116,  117,  117,  117,
  117,  118,  118,  118,  118,  118,  118,  119,  619,  119,
  120,  620,  120,  121,  122,  122,  122,  122,  122,  621,
  123,  124,  124,  125,  125,  125,  125,  126,  126,  127,
  127,  127,  127,  127,  128,  129,  130,  130,  130,  130,
  131,  131,  132,  133,  622,  623,  624,  134,  135,  136,
  137,  137,  137,  138,  138,  139,  139,  140,  141,  141,
  142,  143,  144,  144,  144,  145,  145,  146,  147,  625,
  148,  149,  149,  149,  150,  150,  151,  151,  152,  153,
  154,  155,  155,  156,  156,  157,  157,  158,  159,  160,
  160,  161,  161,  162,  162,  163,  163,  163,  163,  164,
  164,  165,  165,  166,  627,  628,  629,  166,  630,  166,
  167,  167,  168,  626,  626,  169,  170,  170,  170,  171,
  171,  172,  173,  173,  173,  174,  174,  175,  175,  176,
  176,  176,  176,  176,  176,  176,  176,  176,  176,  176,
  176,  176,  176,  176,  176,  176,  176,  176,  176,  177,
  177,  178,  178,  178,  178,  178,  179,  180,  180,  180,
  181,  631,  632,  182,  183,  183,  184,  184,  185,  633,
  634,  635,  186,  187,  188,  189,  636,  189,  189,  190,
  190,  191,  192,  192,  193,  194,  194,  637,  195,  195,
  196,  196,  196,  196,  196,  196,  196,  196,  197,  197,
  198,  199,  200,  201,  202,  202,  202,  202,  203,  204,
  204,  205,  205,  206,  207,  207,  208,  208,  209,  210,
  210,  638,  639,  211,  640,  212,  641,  212,  213,  213,
  213,  213,  213,  214,  214,  214,  215,  216,  642,  643,
  217,  217,  218,  218,  218,  218,  218,  218,  219,  219,
  220,  220,  220,  221,  221,  221,  644,  222,  223,  223,
  224,  224,  225,  226,  227,  228,  229,  229,  230,  230,
  230,  230,  230,  230,  231,  232,  232,  232,  233,  233,
  233,  234,  234,  234,  234,  234,  235,  235,  236,  236,
  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,
  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,
  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,
  236,  236,  236,  236,  236,  236,  236,  236,  236,  236,
  236,  236,  236,  237,  237,  238,  238,  238,  238,  238,
  238,  238,  238,  238,  238,  238,  238,  238,  238,  238,
  239,  239,  240,  240,  241,  645,  646,  241,  241,  241,
  241,  241,  647,  241,  241,  241,  241,  241,  241,  241,
  241,  241,  241,  241,  241,  241,  648,  649,  242,  243,
  650,  243,  244,  244,  244,  244,  244,  244,  244,  244,
  244,  245,  651,  245,  246,  246,  246,  246,  246,  246,
  246,  246,  246,  246,  246,  246,  246,  246,  247,  248,
  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,
  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,
  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,
  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,
  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,
  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,
  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,
  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,
  248,  652,  652,  249,  249,  250,  250,  250,  251,  251,
  252,  253,  253,  254,  254,  255,  256,  256,  257,  257,
  653,  258,  258,  258,  258,  258,  258,  654,  258,  258,
  258,  258,  259,  259,  260,  260,  260,  261,  261,  262,
  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,
  263,  263,  263,  263,  263,  263,  263,  263,  263,  263,
  263,  264,  264,  264,  265,  265,  266,  266,  267,  267,
  268,  268,  268,  269,  269,  270,  270,  271,  271,  272,
  272,  273,  273,  274,  274,  274,  274,  274,  274,  274,
  274,  274,  274,  655,  655,  656,  657,  275,  275,  275,
  275,  276,  276,  277,  277,  277,  278,  278,  279,  279,
  279,  280,  280,  280,  660,  660,  660,  659,  659,  658,
  658,  658,  281,  281,  282,  282,  282,  661,  661,  283,
  283,  283,  283,  284,  284,  285,  285,  285,  286,  287,
  288,  288,  289,  663,  663,  290,  291,  662,  662,  292,
  292,  664,  664,  665,  666,  293,  294,  294,  295,  295,
  296,  667,  296,  297,  297,  297,  297,  297,  297,  297,
  297,  297,  668,  669,  297,  298,  298,  299,  299,  299,
  300,  300,  300,  301,  301,  301,  302,  302,  302,  303,
  303,  304,  304,  305,  306,  306,  307,  307,  308,  309,
  309,  309,  309,  309,  309,  310,  311,  311,  311,  311,
  311,  311,  311,  311,  311,  311,  311,  311,  311,  312,
  313,  313,  313,  314,  314,  314,  315,  316,  316,  317,
  317,  318,  319,  319,  320,  320,  321,  321,  322,  322,
  323,  323,  323,  324,  324,  325,  326,  327,  328,  328,
  328,  329,  330,  331,  331,  331,  331,  332,  332,  332,
  333,  333,  333,  334,  334,  335,  335,  336,  336,  337,
  337,  338,  338,  672,  672,  339,  340,  340,  341,  341,
  342,  342,  342,  343,  344,  344,  345,  345,  346,  346,
  347,  347,  347,  348,  349,  350,  350,  351,  352,  353,
  353,  353,  353,  354,  354,  355,  355,  356,  357,  357,
  357,  357,  357,  673,  673,  358,  358,  359,  359,  360,
  361,  361,  362,  362,  363,  363,  675,  676,  364,  674,
  674,  674,  674,  674,  674,  365,  365,  366,  366,  367,
  367,  368,  677,  678,  368,  679,  368,  369,  369,  370,
  680,  370,  371,  371,  372,  372,  373,  374,  374,  374,
  375,  375,  376,  376,  377,  377,  378,  378,  681,  681,
  379,  379,  682,  682,  380,  380,  380,  683,  381,  381,
  381,  382,  684,  685,  383,  384,  384,  686,  384,  384,
  687,  688,  385,  689,  690,  386,  387,  387,  387,  387,
  691,  388,  692,  388,  389,  389,  390,  391,  392,  392,
  393,  394,  693,  694,  695,  395,  396,  696,  396,  397,
  397,  397,  398,  398,  399,  400,  400,  401,  402,  402,
  403,  403,  404,  405,  405,  406,  697,  406,  407,  408,
  408,  409,  409,  409,  410,  411,  411,  412,  413,  413,
  413,  413,  413,  413,  413,  414,  414,  414,  414,  414,
  414,  414,  414,  414,  414,  414,  415,  416,  416,  416,
  416,  416,  416,  416,  416,  417,  418,  418,  418,  419,
  419,  420,  420,  421,  421,  422,  422,  423,  423,  423,
  424,  424,  424,  424,  424,  424,  424,  424,  425,  425,
  426,  427,  428,  428,  428,  429,  429,  429,  429,  430,
  430,  431,  698,  699,  700,  432,  702,  433,  703,  434,
  704,  435,  701,  701,  436,  436,  437,  705,  437,  438,
  438,  438,  438,  438,  438,  438,  438,  438,  439,  439,
  440,  440,  441,  441,  706,  707,  708,  442,  709,  710,
  443,  711,  712,  444,  445,  713,  714,  715,  446,  447,
  448,  448,  449,  449,  449,  450,  450,  451,  451,  451,
  451,  451,  452,  452,  453,  453,  454,  454,  455,  455,
  456,  456,  457,  457,  457,  458,  458,  458,  458,  458,
  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,
  458,  458,  458,  458,  458,  458,  458,  458,  458,  458,
  458,  458,  458,  459,  459,  460,  460,  460,  460,  460,
  461,  461,  462,  462,  463,  464,  464,  465,  465,  466,
  466,  466,  467,  467,  467,  467,  468,  468,  468,  468,
  468,  469,  469,  470,  471,  471,  472,  473,  473,  473,
  473,  473,  473,  474,  474,  475,  476,  476,  477,  478,
  479,  480,  481,  481,  482,  483,  483,  483,  484,  484,
  484,  485,  485,  485,  485,  485,  485,  485,  485,  485,
  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,
  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,
  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,
  486,  486,  487,  487,  487,  488,  488,  489,  490,  490,
  491,  491,  492,  492,  493,  494,  494,  494,  495,  496,
  496,  497,  498,  498,  499,  499,  499,  499,  499,  499,
  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,
  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,
  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,
  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,
  499,  499,  499,  499,  499,  500,  500,  500,  500,  500,
  500,  500,  500,  501,  501,  501,  501,  502,  502,  503,
  503,  504,  504,  504,  504,  505,  505,  505,  506,  506,
  506,  506,  507,  508,  508,  509,  509,  509,  509,  509,
  510,  510,  716,  717,  718,  511,  512,  512,  513,  513,
  514,  514,  515,  515,  516,  517,  518,  519,  519,  520,
  520,  521,  521,  521,  521,  521,  521,  521,  521,  521,
  521,  671,  671,  670,  670,  522,  522,  523,  524,  525,
  526,  527,  528,  529,  530,  531,  532,  533,  534,  535,
  536,  537,  538,  539,  540,  541,  542,  543,  544,  545,
  546,  547,  548,  549,  550,  550,  551,  551,  551,  551,
  551,  551,  551,  551,  551,  551,  551,  551,  551,  551,
  551,  551,  551,  551,  551,  551,  551,  551,  551,  551,
  551,  551,  551,  551,  551,  551,  551,  551,  551,  551,
  551,  551,  551,  551,  551,  551,  551,  551,  551,  551,
  551,  551,  551,  551,  551,  551,  551,  551,  551,  551,
  551,  551,  551,  551,  551,  551,  551,  551,  551,  551,
  551,  551,  551,  551,  551,  551,  551,  551,  551,  551,
  551,  551,  551,  551,  551,  551,  551,  551,  551,  551,
  551,  551,  551,  551,  551,  551,  551,  551,  551,  551,
  551,  551,  551,  551,  551,  551,  551,  551,  551,  551,
  551,  551,  551,  551,  551,  551,  551,  551,  551,  551,
  551,  551,  551,  551,  551,  551,  551,  551,  551,  551,
  551,  551,  551,  551,  551,  551,  551,  551,  551,  551,
  551,  551,  551,  551,  551,  551,  551,  551,  551,  551,
  551,  551,  551,  551,  551,  551,  551,  551,  551,  551,
  551,  551,  551,  551,  551,  551,  551,  551,  551,  551,
  551,  551,  551,  551,  551,  551,  551,  551,  551,  551,
  551,  551,  551,  551,  551,  551,  551,  551,  551,  551,
  551,  551,  551,  551,  551,  551,  551,  551,  551,  551,
  551,  551,  551,  551,  551,  551,
};
static int yylen[] = {                                         2,
    1,    2,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    0,    0,
    4,    0,    0,   10,   10,   10,   10,   10,   10,   10,
    0,    8,    8,    0,    0,    7,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    2,    1,    1,    0,
    1,    1,    2,    0,    2,    2,    0,    4,    1,    1,
    1,    1,    1,    2,    2,    2,    2,    0,    1,    2,
    4,    1,    2,    2,    2,    2,    2,    4,    1,    1,
    1,    0,    3,    0,    3,    0,    2,    2,    1,    1,
    2,    0,    4,    0,    0,   10,   10,   10,   10,   10,
   10,   10,    0,    8,    8,    0,    7,    6,    0,    3,
    0,    3,    0,    2,    2,    0,    4,    4,    2,    2,
    2,    2,    2,    2,    1,    2,    2,    2,    4,    1,
    2,    4,    1,    2,    2,    3,    0,    0,    0,   11,
    1,    1,    5,    0,    0,    2,    0,    4,    2,    0,
    4,    2,    0,    2,    2,    1,    0,    2,    0,    4,
    2,    2,    0,    2,    2,    1,    3,    9,    1,    1,
    2,    2,    0,    0,    9,    2,    2,    2,    4,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    3,    0,    3,    0,    4,    2,    2,    2,    2,    4,
    2,    2,    2,    3,    2,    2,    2,    4,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    3,    4,    2,
    2,    2,    0,    1,    1,    1,    4,    0,    0,    8,
    0,    1,    1,    0,    1,    0,    4,    0,    0,    2,
    1,    2,    0,    0,    8,    0,    2,    2,    0,    3,
    1,    1,    0,    1,    2,    0,    1,    2,    4,    3,
    0,    1,    3,    0,    3,    0,    1,    3,    1,    3,
    3,    1,    3,    0,    1,    5,    1,    1,    2,    1,
    0,    0,    0,    0,   10,    0,    2,    5,    0,    2,
    2,    0,    3,    2,    2,    2,    2,    2,    2,    2,
    2,    2,    0,    1,    5,    0,    0,    0,    6,    0,
    1,    1,    0,    2,    2,    0,    3,    3,    2,    2,
    2,    2,    2,    3,    4,    0,    2,    2,    3,    1,
    4,    6,    3,    0,    0,    5,    0,    2,    2,    0,
    3,    3,    4,    0,    1,    2,    0,    1,    1,    0,
    0,    7,    0,    7,    0,    4,    4,    0,    3,    2,
    0,    2,    0,    4,    0,    2,    2,    0,    0,    7,
    0,    7,    3,    2,    6,    0,    3,    4,    1,    1,
    3,    2,    1,    1,    1,    0,    2,    1,    3,    6,
    1,    1,    1,    1,    1,    1,    1,    0,    0,    2,
    2,    0,    3,    3,    1,    1,    5,    2,    3,    0,
    3,    0,    2,    3,    4,    8,    1,    0,    4,    0,
    1,    1,    2,    2,    3,    3,    1,    2,    2,    2,
    1,    1,    4,    3,    0,    0,    0,    6,    1,    1,
    0,    2,    4,    0,    5,    2,    4,    3,    1,    4,
    2,    2,    0,    2,    2,    1,    1,    4,    3,    0,
    8,    0,    2,    1,    5,    3,    0,    2,    1,    1,
    5,    1,    0,    1,    2,    3,    3,    1,    1,    6,
    5,    0,    1,    1,    2,    2,    3,    2,    3,    0,
    1,    1,    2,    4,    0,    0,    0,   11,    0,   13,
    1,    1,    3,    0,    1,    7,    0,    2,    1,    1,
    1,    3,    0,    1,    2,    1,    2,    2,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    2,    1,
    2,    1,    1,    1,    1,    1,    5,    2,    3,    6,
    1,    0,    0,    8,    2,    2,    0,    1,    2,    0,
    0,    0,    7,    3,    5,    1,    0,    7,    7,    2,
    4,    3,    2,    4,    1,    0,    2,    0,    3,    2,
    5,    3,    3,    2,    2,    3,    3,    3,    8,    6,
    3,    0,    3,    2,    1,    1,    3,    3,    7,    0,
    2,    1,    2,    2,    0,    1,    0,    1,    3,    1,
    2,    0,    0,    6,    0,    2,    0,    4,    2,    2,
    2,    2,    1,    1,    1,    1,    2,    2,    0,    0,
    7,    3,    1,    1,    1,    1,    2,    2,    5,    7,
    0,    1,    3,    0,    2,    4,    0,   10,    0,    4,
    2,    4,    4,    5,    1,    1,    0,    3,    7,    6,
    9,    8,    9,    8,    1,    1,    1,    0,    2,    2,
    2,    1,    1,    2,    2,    2,    1,    3,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    3,    2,    2,    2,    3,    3,    2,
    2,    2,    3,    1,    1,    1,    1,    1,    3,    3,
    3,    3,    3,    3,    5,    5,    5,    5,    5,    5,
    0,    2,    2,    1,    2,    0,    0,    5,    2,    2,
    2,    2,    0,    4,    2,    2,    3,    2,    2,    2,
    3,    3,    2,    2,    3,    4,    0,    0,    4,    2,
    0,    3,    2,    3,    2,    2,    2,    3,    3,    2,
    2,    2,    0,    4,    3,    3,    3,    3,    4,    4,
    5,    5,    4,    5,    3,    4,    4,    3,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    2,    1,    1,    0,    1,    1,    2,    2,
    3,    0,    2,    0,    2,    5,    1,    1,    2,    3,
    0,    3,    4,    3,    2,    2,    5,    0,    5,    1,
    4,    2,    0,    2,    7,    6,    4,    2,    0,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    3,    2,
    3,    2,    2,    2,    2,    5,    2,    2,    3,    3,
    4,    0,    2,    2,    1,    1,    1,    3,    1,    1,
    3,    6,    1,    1,    1,    4,    5,    1,    3,    1,
    3,    1,    2,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    0,    0,    6,    4,    6,
    5,    0,    3,    0,    2,    2,    0,    3,    4,    1,
    5,    4,    1,    4,    1,    2,    2,    1,    1,    1,
    2,    2,    2,    2,    0,    3,    5,    1,    1,    2,
    3,    1,    2,    0,    3,    1,    1,    1,    2,    4,
    0,    1,    5,    0,    1,    3,    3,    0,    1,    0,
    2,    0,    1,    0,    0,    5,    3,    3,    0,    2,
    2,    0,    3,    2,    2,    1,    2,    1,    3,    2,
    2,    3,    0,    0,    4,    3,    1,    1,    3,    3,
    1,    2,    3,    0,    1,    2,    0,    1,    1,    1,
    1,    1,    3,    2,    0,    3,    1,    3,    4,    5,
    6,    7,    7,    6,    6,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    2,    1,    1,    1,
    1,    2,    2,    1,    2,    1,    2,    1,    3,    1,
    1,    3,    0,    3,    0,    2,    0,    2,    4,    5,
    0,    3,    2,    1,    3,    6,    1,    1,    1,    4,
    4,    1,    9,    0,    2,    1,    1,    2,    4,    2,
    2,    4,    2,    1,    1,    1,    1,    1,    3,    1,
    3,    1,    3,    0,    1,    2,    1,    3,    1,    1,
    1,    1,    3,    6,    0,    1,    0,    3,    1,    3,
    1,    1,    1,    4,    5,    5,    5,    2,    4,    4,
    2,    6,    4,    0,    3,    1,    3,    1,    0,    1,
    2,    2,    2,    0,    1,    0,    3,    1,    3,    1,
    0,    2,    0,    2,    0,    2,    0,    0,    6,    0,
    1,    2,    1,    1,    1,    1,    3,    2,    1,    1,
    2,    1,    0,    0,    6,    0,    5,    1,    3,    0,
    0,    5,    0,    3,    1,    3,    3,    0,    1,    1,
    0,    2,    1,    1,    2,    4,    0,    1,    1,    1,
    0,    3,    1,    1,    0,    5,    4,    0,    8,    5,
    4,    3,    0,    0,   11,    2,    2,    0,    3,    3,
    0,    0,    5,    0,    0,    6,    4,    6,    2,    4,
    0,    8,    0,   10,    1,    1,    8,    5,    1,    1,
    9,    6,    0,    0,    0,   15,    0,    0,    3,    0,
    2,    4,    1,    3,    4,    1,    3,    3,    1,    1,
    0,    1,    3,    1,    3,    0,    0,    2,    4,    1,
    3,    1,    3,    4,    1,    1,    3,    1,    1,    3,
    3,    2,    3,    3,    4,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    3,    1,    1,    1,
    1,    1,    1,    1,    1,    6,    1,    1,    1,    5,
    6,    5,    6,    1,    3,    3,    4,    1,    1,    2,
    3,    5,    4,    6,    4,    6,    5,    7,    3,    4,
    4,    4,    1,    1,    1,    3,    3,    4,    4,    1,
    3,    3,    0,    0,    0,    6,    0,    7,    0,    6,
    0,    7,    0,    1,    0,    2,    2,    0,    3,    2,
    2,    2,    2,    3,    3,    1,    1,    3,    0,    5,
    2,    4,    3,    2,    0,    0,    0,    5,    0,    0,
    5,    0,    0,    5,    1,    0,    0,    0,    8,    1,
    2,    2,    1,    1,    1,    1,    1,    3,    3,    3,
    2,    2,    0,    2,    3,    2,    1,    1,    1,    1,
    1,    3,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    2,    2,    3,    3,
    3,    3,    3,    3,    3,    1,    1,    1,    1,    3,
    1,    1,    1,    1,    1,    1,    2,    2,    2,    2,
    0,    3,    0,    3,    4,    0,    1,    1,    3,    1,
    2,    1,    1,    1,    1,    1,    1,    1,    2,    2,
    2,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    2,    1,    1,    2,    1,    1,
    1,    1,    1,    2,    1,    1,    1,    1,    1,    1,
    1,    4,    5,    5,    5,    5,    5,    5,    5,    5,
    5,    5,    6,    6,    4,    4,    4,    4,    6,    6,
    6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
    3,    3,    3,    4,    4,    7,    8,    6,    4,    8,
    6,    4,    0,    2,    2,    1,    1,    6,    0,    3,
    0,    2,    1,    1,    6,    1,    1,    1,    4,    4,
    4,    4,    4,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    7,    8,    8,    8,   10,
    8,    6,    4,    1,    1,    4,    4,    7,    8,    0,
    2,    7,    6,    6,    4,    1,    1,    1,    4,    3,
    6,    5,    6,    1,    1,    6,    8,    6,    6,    8,
    1,    1,    0,    0,    0,    8,    4,    5,    0,    2,
    3,    5,    4,    5,    1,    1,    1,    3,    5,    4,
    6,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    0,    1,    0,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,
};
static int yydefred[] = {                                      0,
    0,    0,    0,    0,    0,    0,    0,   29,    0,    0,
  102,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    3,    4,    5,   21,   23,   19,   17,   22,   18,
  754,    9,   10,   15,   20,   11, 1026, 1027, 1028,   26,
   27,   25,   28,   24,   16,   12,    0,    0,    7,    0,
    8,    6, 1295, 1296,   13, 1299, 1300,   14,    0,    0,
  763,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  202,    0,  753, 1039,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  234,    0,    0,    0,    0,    0,    0,  202,    0,  181,
    0,    0,    0,  144,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  202,    0,  930,    0,  657,   30,    0,    0,
   30,    0,    0,    0, 1044,    0,    0, 1885, 1886, 1887,
 1888, 1889, 1890, 1891, 1892, 1893, 1894, 1895, 1896, 1897,
 1898, 1899, 1900, 1901, 1903, 1904, 1905, 1906, 1907, 1908,
 1909, 1902, 1910, 1911, 1912, 1913, 1914, 1915,    0, 1916,
 1917, 1918, 1919, 1920, 1921, 1922, 1923, 1924, 1925, 1926,
 1927, 1928, 1929, 1930, 1931, 1932, 1933, 1934, 1935, 1936,
 1937, 1938, 1939, 1940, 1941, 1942, 1943, 1775, 1777, 1778,
 1779, 1780, 1781, 1782, 1800, 1801, 1783, 1785, 1784, 1793,
 1794, 1790, 1786, 1791, 1787, 1789, 1792, 1788, 1796, 1797,
 1795, 1798, 1799, 1803, 1802, 1804, 1805, 1806, 1807, 1808,
 1809, 1810, 1811, 1812, 1813, 1814, 1815, 1816, 1817, 1818,
 1819, 1820, 1821, 1822, 1823, 1824, 1825, 1826, 1827, 1828,
 1829, 1830, 1831, 1832, 1833, 1834, 1835, 1836, 1837, 1838,
 1839, 1840, 1841, 1842, 1843, 1844, 1845, 1846, 1847, 1848,
 1849, 1850, 1851, 1852, 1853, 1854, 1855, 1856, 1857, 1858,
 1859, 1860, 1861, 1862, 1863, 1864, 1865, 1866, 1867, 1868,
 1869, 1870, 1871, 1872, 1878, 1874, 1873, 1875, 1876, 1877,
 1879, 1880, 1881, 1882, 1883, 1884, 1948, 1949, 1950, 1951,
 1952, 1953, 1955, 1956, 1957, 1959, 1960, 1958, 1944, 1961,
 1945, 1946, 1947, 1954, 1962, 1963, 1964, 1965, 1966, 1967,
 1968, 1969, 1970, 1971, 1972, 1973, 1974, 1975, 1976,    0,
 1196,    0, 1768, 1776,    0,    0, 1134,    0, 1767,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  206,
 1029, 1773,    0,    0,    2,    0,    0,    0,    0, 1139,
 1142,    0,    0,    0,    0,  317,  811,  812,  813,  814,
  815,  816,  817,  818,  819,  820,  821,  822,  823,  824,
  825,  826,  827,  828,  829,  830,  831,  839,  833,  834,
  832,  866,  887,  863,  835,  836,  837,  838,  840,  842,
  845,  841,  843,  844,  846,  847,  848,  849,  850,  851,
  852,  853,  854,  855,  856,  857,  858,  868,  881,  878,
  864,  882,  859,  865,  885,  886,  879,  880,  867,  883,
  884,  888,  889,  862,  861,  860,  869,  870,  871,  872,
  873,  874,  875,  876,  877,  890,  891,  765,  777,  810,
  755,    0, 1757,    0,  479,  466,  467,    0,  768,  470,
 1749,  773,    0, 1760,  766,    0, 1761,  449,  441,  442,
    0,  761,  445, 1765,  756, 1198,  760,    0, 1769,  770,
    0, 1770,  666,  759,    0,  769,    0, 1766,  774,  204,
 1439,  488,  762,    0, 1774,    0, 1036, 1544,    0,  194,
  316, 1546,  322,  195,    0, 1753,  182,    0,  186,  192,
    0,    0,  187, 1549,  196, 1551,    0,  188,    0,  190,
    0,  199, 1403,  191,  197,  290,  193,  198,    0, 1752,
    0,  204, 1435,    0,  200, 1249, 1250,    0,    0,  145,
    0, 1758,    0,  938, 1756,  931,    0,  937,  940,  943,
  932,  933,    0,  934,  935,    0,  936, 1772,  942,  944,
  945,  204,    0,    0,  948,    0,    0,    0,  506,    0,
 1272,    0,    0,    0, 1037,    0,    0, 1045, 1047, 1048,
    0,    0, 1165,    0,    0,    0,    0,    0,  215,  208,
  216,  207,  209,  212,  211,  217,    0,    0,  213,    0,
    0, 1096, 1097, 1102,    0, 1101,    0, 1103, 1105, 1111,
    0, 1098, 1100,    0, 1099, 1106, 1110, 1104, 1108, 1109,
    0,    0,    0,    0,    0,    0,    0, 1122,    0,    0,
    0,    0, 1147,    0,    0,    0,    0,    0,    0,  772,
    0, 1751, 1414,  771, 1409,  317,  778,  232,  767,    0,
    0,    0,    0,  148,    0,  285,    0,  899,  900,    0,
    0,  446,  757,  676,  677,    0, 1407,    0,    0, 1322,
  908,  907,    0, 1439,  775,    0,    0, 1043, 1041, 1545,
  317,  264,    0,  230,    0,    0,  272,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  202,    0,  218,  243,
  242,    0,    0,  360,    0,    0, 1404,    0,    0, 1435,
  203,    0,  201,    0,    0,  146,  147,    0,    0,    0,
    0,  939,    0,    0,  941,    0,    0,  950, 1445, 1450,
  949,    0,    0,    0,    0, 1504,    0, 1540,    0, 1746,
    0, 1501, 1650,    0,    0,    0,    0, 1665,    0, 1541,
    0, 1535, 1524,    0, 1523,    0,    0,    0, 1506,    0,
    0, 1525, 1526, 1536, 1537,    0, 1538, 1539,    0,    0,
    0, 1543, 1393, 1394, 1395,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1542, 1532, 1533, 1747, 1505,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1534, 1482,    0,    0, 1332, 1470, 1339, 1346,
 1353, 1347, 1348, 1349, 1350, 1351, 1354, 1355, 1356, 1352,
    0,    0, 1471, 1499, 1502, 1477,    0, 1527, 1479, 1480,
 1481, 1496, 1497, 1498, 1528, 1478, 1557,    0, 1607,    0,
 1558, 1559, 1613, 1614, 1616, 1617, 1618, 1561,    0, 1624,
 1560, 1684, 1685, 1486, 1483, 1484, 1704, 1705, 1711, 1712,
 1485, 1503,    0, 1335,    0,    0,    0,    0,    0,   31,
    0,  123,    0,    0,    0,    0,  103,  104,  116, 1035,
    0,    0, 1089,    0,    0,    0, 1316, 1336,    0,    0,
    0, 1197, 1135,    0, 1179, 1762,    0,    0,  214, 1032,
 1030, 1107, 1115, 1113, 1112,    0,    0,    0, 1764,    0,
    0,    0,    0,    0, 1124, 1128, 1555,    0, 1150, 1148,
    0, 1153, 1151, 1743, 1154,    0, 1155, 1145,    0,    0,
 1745,    0,    0,    0, 1129,    0,    0, 1271,    0,    0,
 1308, 1328,    0, 1404,    0,    0,  778,    0,    0,    0,
    0,    0,  502,    0,    0,    0,  469,    0,    0,    0,
  281,    0,  444,    0,  757,  735,  734,    0,    0, 1404,
    0, 1324,    0,    0,  776, 1440, 1446,    0,    0,    0,
    0,  980, 1018,  984,    0, 1019,    0,    0,  985,    0,
    0,    0, 1010, 1022,  979, 1005,  981,  982,  977,  983,
    0,  955,  956,  964,    0,  965,  974,    0,  975,  976,
  978,    0,    0,    0,    0,    0,  270,  224,    0,  480,
  220,  225,    0,  450,  219,  675,  221,  227,    0,  665,
  223,  226,  204, 1442,  489,  222,  245,    0,    0,  370,
    0,    0,    0,    0,    0,    0,  291,  189,  363,  205,
 1436,    0,    0,  148,    0,    0,  180, 1547,  179, 1750,
    0,    0, 1214,    0,    0,    0, 1298,  954,  953,    0,
  951,    0,    0,    0, 1529,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1530, 1531,    0, 1507,    0,
 1509,    0,    0,    0,    0, 1713,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1508, 1510,    0,    0,    0,
 1137, 1138,    0,    0,    0,    0,    0,  604,    0,    0,
  649,    0,    0,    0, 1378, 1361,    0,    0, 1362,    0,
 1365,    0, 1363, 1364,    0,    0,    0, 1358, 1359, 1360,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  157,  507,    0,   69,   70,
    0,    0,    0,    0,    0,   64,    0,    0,    0,    0,
 1170, 1172, 1169, 1181, 1182, 1183, 1171,    0,    0,    0,
    0,    0,    0,  123, 1033,  288,    0,  286,  287, 1553,
 1046, 1045, 1303,    0,    0,    0,    0,    0,    0, 1178,
    0,  210,    0, 1121, 1090, 1120,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1157,    0,    0, 1158, 1160,
    0,    0,    0, 1245,    0, 1141, 1140,    0,    0,    0,
 1474,    0, 1473, 1520, 1522, 1475,    0, 1130, 1313,    0,
    0, 1270,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  920,    0,  909,    0,    0,  903,    0,  901,    0,
    0,  515,    0,    0,  468,  503,  476,    0,  478,    0,
    0,  283,  277,    0,  443,  447,    0,    0,    0,    0,
    0,  928,    0,    0,    0,    0, 1323,    0,    0, 1437,
    0,    0,    0,    0,    0,  484,  318,  317,    0,  987,
 1006, 1007, 1023,    0, 1020,    0,    0, 1013, 1011, 1012,
    0,  267,  253,    0,    0,    0,  973,    0,    0,    0,
    0, 1014,  273,  231,  279,    0,    0, 1411, 1442,  228,
    0,    0,  369,  361,    0,    0,  682,  683,  680,    0,
    0,    0,    0,    0,    0,  687,  679, 1405, 1404,  292,
    0, 1437,    0,    0,    0, 1550, 1548,    0,    0,    0,
 1221, 1223,    0, 1224, 1216, 1217,    0,  946,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1732, 1733, 1734,
 1735, 1736, 1737, 1740, 1741, 1738, 1739,    0,    0,    0,
    0,    0,    0, 1721,    0, 1714,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1696, 1698, 1697,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1591,    0,    0,    0,    0,    0, 1592, 1593,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1495, 1343, 1472,  653,
    0,    0,  605,    0,  606,    0,    0,    0,    0,    0,
    0,    0, 1389, 1400,    0, 1396,    0, 1397, 1344,    0,
    0,    0,    0,    0,    0,    0, 1380,    0, 1367, 1369,
 1368,    0,    0,    0, 1491,    0,    0,    0,    0,    0,
    0,    0,    0, 1700,    0, 1500, 1333,    0,    0,  155,
    0,    0,    0,    0,    0,    0,    0,   54,   55,   59,
   50,   52,   49,   47,   48,   56,   53,   58,   51,    0,
    0,    0,    0,    0,    0,   45,  126,  138,  140,    0,
    0,    0,    0, 1200,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  120,  122,    0,    0,    0,    0,
    0,    0,  289, 1554,    0,    0, 1304, 1317,    0, 1302,
    0, 1337, 1180,    0, 1095, 1091, 1117,    0,    0, 1119,
 1094, 1149, 1152,    0,    0,    0,    0,    0,    0,    0,
    0, 1521, 1771, 1260, 1259, 1262, 1263, 1264,    0,    0,
    0,    0,    0, 1330,    0, 1405,  910,    0,    0,  915,
    0,  922,  916,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  780,  905,  509,  505,    0,    0,  511,  512,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  526,  521,
    0,    0,  520,    0,  530,  529,  552,  541,  542,  555,
    0,  539,  556,  553,  543,  536,  554,    0,  545,  546,
  544,  634,  636,  635,  537,    0,  531,  532,  535,  533,
  534,  550,  540, 1320, 1319,    0,    0,    0,  452,  155,
    0,    0,  275,    0,  793,  420,    0,    0,  792,    0,
    0,    0,    0,  752,    0,    0, 1405, 1325,    0,  664,
  906,    0, 1447,    0,    0,  481,  485,    0,    0,    0,
 1552,    0,    0,    0,    0, 1021,    0,  265,  407,  402,
  403,  404,  405,  406,  254,    0,  968,    0,    0,    0,
    0,    0,    0,    0,    0,  278, 1404,  229, 1443,    0,
  238,  371,    0,  685,  686,  684,    0,    0,    0,    0,
  708,  702,  696,  720,  693,  690,  699,  717,  705,  711,
  714,  731,  726,    0,  707,  701,  695,  719,  692,  689,
  698,  716,  704,  710,  713,  722,  730,    0,  709,  703,
  697,  721,  694,  691,  700,  718,  706,  712,  715,  723,
  732,    0,    0,    0,    0,    0,    0,  361,    0,    0,
    0,    0,    0,    0,  494,  183,  157,    0,  155,    0,
 1315, 1755, 1222,    0, 1258,    0,    0,    0,    0,    0,
 1562,    0, 1391,    0, 1686,    0,    0,    0,    0,    0,
 1683, 1392,    0,    0,    0, 1512, 1514,    0,    0,    0,
    0,    0,    0, 1715,    0,    0,    0, 1730, 1619, 1620,
 1621, 1687, 1622,    0, 1695,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1594,    0, 1595,    0, 1599,
    0, 1602, 1575, 1576, 1577, 1578,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1334,    0,
    0,    0, 1515,    0,    0,    0,    0,    0,    0, 1398,
 1399, 1345,    0,    0, 1390,    0,    0,    0,    0,    0,
    0,    0, 1623, 1699,    0,  650,    0,    0,    0,    0,
   61,    0,    0,    0,    0,    0,    0,    0,   57,   41,
   41,   67,   67,   67,    0,    0,   73,    0,   72,    0,
   71,    0,   66,   80,   87,  123,    0,    0, 1173, 1205,
 1203, 1201,    0, 1273, 1202,    0,    0,    0,    0,    0,
   41,    0,    0,    0,    0,    0,   41,    0,    0,    0,
    0, 1063,    0, 1056,    0,    0,    0, 1051, 1058, 1067,
 1068,    0,    0, 1136, 1092, 1093,    0,    0,    0,    0,
 1159, 1163, 1161, 1246,    0, 1247,    0,    0,    0,    0,
 1314,    0,    0, 1329,  315,    0,    0,    0,    0,  251,
  914,    0,    0,  918,  782,    0,    0,  785,  787,  786,
    0,    0,  783,  790,  791,  972,    0,  506,  506,    0,
    0,  504,    0,  462,    0,  960,  959,  963,    0,  519,
    0,    0,  570,    0,    0,    0,  613,  616, 1763,  637,
  638,    0,  640,  614,    0,  551,  522,  622,  527,    0,
  620,  528,    0,    0,    0,    0,  611,  475,    0,    0,
    0,  448,    0,    0,  893,    0,    0,    0,  809,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  926,    0,
    0,    0, 1441,    0,  486,  487,  319,  317,    0,    0,
    0,    0,    0,    0,    0,  325,    0,    0,  989,    0,
    0, 1025,    0, 1016,    0,    0,  966,    0,  998,    0,
    0,  999, 1002, 1004,  280,    0, 1437,  321,    0,  239,
    0,  375,    0,    0,    0,  670,  724,  688,  728,  729,
  733,    0, 1406,    0, 1426,    0, 1427,    0,    0,    0,
    0,    0,    0, 1417,    0,  293,  371, 1438,  496,    0,
    0,  498,    0,    0,    0,  491,    0,    0,  495,  184,
  155,  149,    0,    0,    0, 1218, 1297, 1568, 1567,    0,
    0,  398,  401, 1564, 1563,    0, 1572, 1571, 1570, 1569,
    0,    0, 1566, 1565,    0,    0,    0, 1723, 1722,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  656,  608,  607, 1375, 1372, 1402, 1401, 1370,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1702,
    0,  160,  660,    0,  661,  160,    0,    0,    0,    0,
    0,    0,    0,    0,  123,  123,    0,    0,    0,   83,
   84,   75,   74,    0,    0,  139,    0,    0, 1274, 1184,
    0, 1195, 1190,    0,  123,    0,    0,    0,    0,    0,
    0,    0,  113,  113,  123, 1053,    0,    0, 1057,    0,
 1054,    0, 1055, 1064,    0,    0, 1061, 1060,    0,    0,
    0,    0,    0, 1253, 1254, 1252,    0, 1267, 1269, 1331,
 1410,  913,  344,  252,    0,  921,    0,    0,  784,  788,
  789,    0,    0,  397,    0,    0,  513,    0,    0,  518,
    0,    0,    0,  571,    0,    0,  601,    0,  642,  568,
    0,  623,  621,    0,    0,    0,    0,  562,    0,    0,
  160,  453,  456,    0,    0,  794,    0,  797,  798,  420,
    0,  796, 1754,  898,  897,  795,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  808,  805,  389,    0,  390,
    0,    0,    0,    0,    0,    0,  925, 1408,  668, 1468,
 1467,    0,    0,    0,    0,    0,    0,    0,    0,  327,
    0,    0,  333,    0,  330,  329,  332,  331,  991,    0,
  995,  996,    0,    0,    0,    0,  254,  969,  971,  967,
 1001, 1405,    0,    0,    0,  373,  362,  372,    0,    0,
    0,  669,    0,    0, 1405, 1419,    0, 1423,    0,    0,
 1420, 1422, 1421,    0,  297,    0,    0,  497,  499,  490,
    0,    0,    0,  160,  152,    0,    0,  159,  151,    0,
    0,    0, 1703, 1731,    0, 1682, 1615,    0,    0,    0,
 1724,    0,    0, 1706, 1708,    0, 1693, 1694,    0,    0,
    0,    0,    0,    0,    0, 1709,    0, 1574, 1573,    0,
    0,    0, 1598,    0, 1601, 1579, 1580, 1581, 1582, 1583,
 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1371, 1373,    0,
    0,    0, 1366,    0, 1608, 1701,    0,    0,    0,    0,
   33,   33,   33,   33,   33,   33,   33,    0,    0,    0,
   68,    0,   82,    0,   81,   90,   89,   91,   88,    0,
  126,    0,    0,  143,  141,  100,    0, 1176, 1185, 1274,
    0,    0, 1186, 1187,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  123,  123,    0,    0, 1066, 1059,    0,
 1075, 1070, 1069,    0, 1073, 1062,    0, 1301,    0,    0,
    0,    0, 1266,  345,  917,    0,  919,    0,    0,  507,
  464,  465,    0,  961,  958,    0,    0,    0,    0,    0,
    0,  643,  644,  646,  645,    0,    0,    0,  625,    0,
  563,    0,    0,    0,    0,  474,  471,  423,    0,    0,
    0,  384,    0,  394,    0,  395,    0,  799,    0,  800,
  392,  807,  806,  803,    0,  895,    0,    0,  749,  750,
  746,  745,  748,  747, 1465,    0,    0, 1461,    0, 1462,
 1448,    0,    0,    0,  338,  340,    0,  328,  334,  990,
    0,  988, 1017,  255,    0,    0,    0, 1444,  358,  359,
  247,  240,    0,  375,  376,  377,    0,  674,    0,  672,
 1404, 1424, 1425, 1428,    0,  294,  292,    0,  185,  236,
    0,    0,  158,  169,    0,    0,    0,    0,    0,  166,
  162,    0,    0,    0, 1229,    0, 1226,    0, 1230,    0,
  399,    0, 1688,    0,    0,    0,    0,    0,    0,    0,
 1692, 1676,    0,    0,    0,    0,    0,    0,    0, 1596,
    0,    0,    0,  662,    0,    0,  459,    0,  658,  123,
  123,  123,  123,  123,  123,  123,    0,  126,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  124,  125,  135,
    0,    0,    0,   99,    0,   46,    0,  101, 1174,    0,
    0, 1188,    0, 1192,  105,  105,  105,  105,  105,  105,
  105,    0,    0,  117, 1076,    0, 1082,    0, 1087,    0,
    0, 1208,    0, 1212, 1143,    0,  924,  269,    0,    0,
    0,    0,    0,    0,  572,    0,    0,  557,    0,    0,
    0,    0,    0,  575,    0,    0,  457,  458,  473,    0,
    0,    0,  427,  421,    0,  378,  381,  383,  801,  802,
  804,  391,    0, 1460, 1459, 1464, 1458,    0,  339,    0,
    0,  335,  993,    0,    0,  258,  262,  261, 1412,    0,
  374,  673,  671,    0,    0,    0,    0,    0,  292,    0,
  364,    0,    0,    0,    0,    0,  168,  161,    0,  164,
  165,  178,    0, 1219, 1233, 1232, 1236, 1228, 1231,    0,
 1689,    0, 1720,    0, 1716, 1707, 1677, 1678, 1679,    0,
 1710,    0, 1681, 1604, 1605, 1597, 1600,  663,  160,  455,
  461,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   42,  130,  137,  129,  132,  136,  133,  134,  131,   43,
   95,  142,   98,   97, 1275,    0,    0, 1276, 1277,    0,
  123,  123,  123,  123,  123,  123,  123,  114,  115,    0,
    0,    0, 1084,    0,    0,  346,  345,    0,    0,    0,
    0,  560,    0,    0,    0,    0,    0,  627,  633,    0,
    0,    0,    0,  626,    0,    0,    0,    0,    0,    0,
    0,    0,  379,  379,  388,    0, 1455, 1454, 1449,    0,
 1453,    0,  343,  260,  268, 1405, 1430,    0, 1431,    0,
  298,  295,  314,  292,  301,    0,    0,    0,    0,    0,
  172,    0,  176,  171,    0, 1227,    0,    0,    0, 1717,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   93,  127,  128, 1279, 1280,    0, 1281, 1189,    0,
    0,    0,    0,    0,    0,    0, 1083, 1079, 1078,    0,
 1088, 1305, 1209,    0,    0,    0,    0,  962,  516,    0,
  573,  571,    0,  641,  624,    0,  632,  631, 1759,  629,
  630,    0,    0,  566,  565,  618,  609,    0,    0,    0,
  424,    0,    0,    0, 1452, 1451, 1456, 1457,    0,    0,
 1434,    0,  303,    0,    0,    0,    0,  304,  305,  306,
    0,    0,  237,  170,    0,  174,    0,  153, 1234, 1234,
  400, 1718, 1680,  460,   34,   36,   35,   37,   38,   39,
   40, 1284, 1282,  106,  108,  107,  109,  110,  111,  112,
 1080, 1081, 1086,    0,    0,    0,    0,  349,    0,    0,
  577,    0,    0,  599,  628,  564,    0,    0,  425,    0,
    0,    0,  409,    0,    0, 1432, 1433,  307,  310,  309,
  312,  311,  308,  366,  367,  150,  177,    0,    0, 1285,
    0, 1308,    0,  351,    0,    0,    0,    0,  508,  571,
    0,    0,    0,    0,    0,    0,  590,  619,    0,    0,
    0,  380,    0,    0,  382,  342,    0, 1238,    0, 1237,
    0,    0,    0, 1283,    0, 1306,    0,  356,  352,    0,
    0,    0,    0,  589,    0,    0,    0,    0,    0,    0,
    0,    0,  429,    0,  385,    0,  411,  412,    0, 1235,
 1241,    0,    0, 1286,    0, 1289,    0, 1309,  353,  510,
  572,  578,  572,  579,  580,  583,    0,    0,    0,    0,
    0,    0,  596,  598,  597,    0,    0,    0,    0,    0,
  413,    0, 1239,    0,    0, 1291,    0,    0,    0,    0,
    0,    0,    0,    0,  426,    0,  434,    0,  433,  387,
    0,    0,    0,  416,  414,  415,    0,    0,    0, 1290,
    0,    0,  581,  584,    0,    0,    0,    0,  437,  436,
  435,    0,    0,  418, 1242, 1293,    0,    0,  440,  438,
  439,  419,    0,    0,    0,    0,    0,    0,    0,  417,
    0,    0,    0, 1292,    0, 1294,
};
static int yydgoto[] = {                                      20,
   21,   22,   23,   24,   25,  950, 1640, 1271, 1642, 1272,
 1273, 2063, 1274, 1643, 2064, 1275, 1644, 2065, 2879, 2672,
 2896, 2674,   26,  957,  958,  959, 2658, 2888, 2889, 1277,
 1648, 2394, 2675,   27,  104,  726, 2587, 1928, 2293, 2588,
 2831, 2825, 2997, 3134,  550, 1136,   28,  100,   29,  360,
   30,  709,  517, 1098,  461,  101, 2819,  525,  712, 1118,
 1861, 2802, 2129,  514, 2546, 2795, 2976, 1422, 1423, 2977,
  520,  696,  697, 1041, 1102, 1437,  472,  666,  667,   31,
 1298,  535,  538, 2276, 2816, 2988, 3125, 3218, 3219, 3220,
 3122,  650,  510,  511, 1407, 1829, 2226, 2217, 2528, 2785,
 2130, 3076, 3174, 3258,  528, 1128, 2991,  714, 2251, 2558,
 2488, 2957, 3345, 2507, 2753, 2151, 2301, 1838, 3272, 3313,
 3347, 3405, 2489, 2490, 2954, 3201, 3377, 3378, 3379, 3420,
  478,  479,  480,  481,  482, 1105, 1381, 2040, 2189, 2483,
 2866, 2867, 2374, 2457,  465,  466,  467,  468, 2747,  663,
 1037,  469, 1101,  502, 1404, 1405, 1406,  503, 1116,  723,
 1923, 1924, 1925, 1031, 1032, 1033, 1738, 1739, 1740, 2161,
 1759, 1760, 1761, 1762, 1763, 1764, 1765, 1766, 1767, 1768,
 1769, 1770, 3095, 2469, 2470, 1771, 1772, 1773, 2935, 3331,
 3365, 3332, 3366, 3181, 3262, 3307, 1774, 1775, 2467, 1776,
  884, 1574, 1777, 1778, 1779, 1780, 2167, 3195, 3194, 2180,
 2181, 2942, 3094, 1781, 1782, 1783, 1784, 2738, 1785,  885,
 1231,   33, 1267, 2037, 2375,  493, 1111,  494, 1820,  530,
 1107,  676, 1124, 1449, 1455, 1456, 1125, 1392, 1394,   34,
   78,  458, 1365, 1733, 1387, 1809, 2198,  459, 2764, 2496,
  475,  659, 1029, 1369,  496,  683, 1025, 1364, 2717,  487,
 1049,   35,  125,  735, 1081, 2154, 2155, 2156, 2157, 1083,
 1846, 1847, 1084, 2146, 1086, 2544, 2231, 1427, 1087, 2147,
 1089, 1418, 1090, 1415,   36,   37,   38,  981,   39,   40,
   41,  507,   42,   43, 1301, 1675, 2098, 2099, 2100, 2101,
 2702, 3170, 3253, 2916, 2917, 3073, 2918,   44,   45,  631,
  632,  633,  634,  635, 1319,  991, 1315, 1786,  367,  995,
  638,   47,   48,  346,  347, 1222, 1223,  369,  370,  371,
  641,  642,  643, 1006, 1327, 1328, 1329, 1330, 1695, 2107,
 1280, 1281, 1282, 2677,  598,  974, 1283, 1284, 1285, 1286,
 2683, 2684, 1287, 1662,  340,  495, 1660, 2433, 2921, 2922,
 2712,  730, 1146, 2835, 2836, 2837, 2838, 3008, 3317, 3320,
  646, 1333, 1334,  548, 2116, 2436, 1935, 1936, 1016, 1348,
 1787,   50, 1788, 2900, 3058, 3059, 3324, 3354, 1789,   53,
   54, 1790,   56,   57, 1791, 3293, 1018, 1350,  731,  966,
 1792, 1793,  679,  680, 1051,  648, 1022, 1713,  886,  887,
  969, 1143,  888,  889,  890, 1251,  891, 1602,  892,  893,
 1580,  894, 1252,  895,  896,  897,  898,  899,  900, 1583,
 1584,  532,  490,  654, 1108, 1458, 1915, 2274, 2263, 2984,
 3119,  721,  685, 1440,  738, 1056, 1057, 3109, 3110, 3206,
 2527, 2778, 2213, 2522,  901,  902, 1342,  903,  904,  905,
 1169, 1171,  906, 1493,  907, 1840,  908,  909,  910,  911,
  912,  913,  914,  915, 1316, 1137,  526, 1467,  527, 1833,
 1299, 1300,  916,  917,  918,  919, 2860,  920,  921, 2032,
 2335,  922,  923,  924,  925,  926,  927,  928,  929,  930,
  931,  932, 2599,  933, 1530,  934,  935,  936,  937,  938,
  939, 2603, 2849,  940, 1175, 2846, 1176, 1962, 2333,  941,
 1508,  942,  943,  470, 1139,  651,  539,  944, 2492, 1742,
  554,  518,  551, 3188,  521, 3318,  975, 1796,  992,  483,
 1649,  945,  486,  531, 2676, 1228,  567,  361,  946,  947,
  344,  128,  580,  951, 2042, 2870, 2385,  952, 2066, 1276,
 2387, 1623, 2897,  131, 1293, 3061, 2694, 1294, 2659, 2067,
 1134, 1038, 2583, 2294, 1620, 2647, 2826, 2993, 2290, 2581,
  501,  684, 2508, 2250, 2555, 2249, 2801, 2803,  693, 1845,
 2235, 2974, 2978, 1384, 1460, 3126, 2576, 2987, 3124,  691,
  656, 1828, 1356, 2714, 2926, 3255, 3297, 1121, 1862, 1461,
 2252, 2804, 2559, 3103, 3203, 3104, 2509, 2510, 3273, 3346,
 2194,  672, 1044, 1804,  664, 1373, 2149,  949, 1621, 2148,
 2741, 2945, 2464, 2728, 3084, 3300, 3301, 2472, 2739, 2943,
 3186, 2173, 2471,  579,  673, 1045,  376,  657, 1027, 1727,
 2193, 1810, 1719, 2447, 1091, 1410, 1834, 1092, 1093, 1094,
 1095,   80,  961,  689,  588,  964, 2088, 2424, 2704, 1012,
 1007,  594, 2071, 1476, 1934, 2591, 3137, 3288, 3138, 3384,
 1706, 1709,  373, 2399, 2680, 3056, 3243, 3291, 3290, 3321,
 3409, 3434, 1677, 2102, 3254, 1353,  649,  717, 1459, 1914,
  655, 1050, 1024, 1857, 2264,  722, 1462, 1822,  686, 1400,
 1441, 2247, 1401, 2214, 2968, 1516, 1964, 2321,
};
static int yysindex[] = {                                   6841,
37558,  -31,39391, 1553,  758,30181,  -40,    0,  858,  935,
    0,  -31,  578,95701,96094, 2678,99238,  837, 1017,    0,
 1373,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1136, 1066,    0, 1176,
    0,    0,    0,    0,    0,    0,    0,    0, 1098, 1206,
    0,89373,99238, 1292,99238,99238,99238,99238,99238,99238,
99238,99238,99238,99238, 1064,    0,99238,    0,    0, 1322,
  859,99238,99238,99238,99238, 1407,99238, 1348,99238,99238,
    0,99238,99238,99238,99238,99238, 1317,    0,99631,    0,
  123, 1487,99238,    0,99238,99238,99238, 1508,99238,99238,
99238,99238,99238, 1348,99238,99238,99238,99238,99238,99238,
99238, 1250,    0,100024,    0,99238,    0,    0,99238,99238,
    0, 1297,99238, 1558,    0,99238, 1517,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1643,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1591,
    0, 1736,    0,    0,99238, 1975,    0, 1999,    0,99238,
99238,99238,99238,99238,99238,99238,99238, 1474,100417,    0,
    0,    0,99238,38179,    0, 1622, 1656,    0,    1,    0,
    0, 1653,    0,99238, 1701,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  859,    0,99238,    0,    0,    0, 1160,    0,    0,
    0,    0, 1605,    0,    0,  946,    0,    0,    0,    0,
 1483,    0,    0,    0,    0,    0,    0, 1088,    0,    0,
 1701,    0,    0,    0, 2091,    0,   85,    0,    0,    0,
    0,    0,    0, 1889,    0, 1752,    0,    0, 1731,    0,
    0,    0,    0,    0, 1930,    0,    0,  859,    0,    0,
 1616, 5637,    0,    0,    0,    0,  735,    0, 1896,    0,
 1163,    0,    0,    0,    0,    0,    0,    0, 1918,    0,
 1833,    0,    0,99238,    0,    0,    0, 1941,99238,    0,
 1948,    0, 1862,    0,    0,    0,99238,    0,    0,    0,
    0,    0,  -50,    0,    0, 1802,    0,    0,    0,    0,
    0,    0,99238,99238,    0,77758, 2268,    0,    0,    0,
    0, 1841,  640, 1851,    0, 1937,99238,    0,    0,    0,
 2028,99238,    0,99238, 1975,99238,99238, 2108,    0,    0,
    0,    0,    0,    0,    0,    0, 1970,99238,    0, 2022,
 2013,    0,    0,    0, 2116,    0, 2021,    0,    0,    0,
 2055,    0,    0,99238,    0,    0,    0,    0,    0,    0,
 2123,99238,99238,99238,99238, 2093, 1978,    0,  167,  172,
 1309,    0,    0, 2198, 1462, -129, 1974,  541, 2458,    0,
 2098,    0,    0,    0,    0,    0,    0,    0,    0, 2202,
 2221, 1458, 2259,    0, 2088,    0, 1886,    0,    0, 2221,
 2259,    0,    0,    0,    0, 1514,    0,99238, 2279,    0,
    0,    0, 2280,    0,    0,99238, 2289,    0,    0,    0,
    0,    0,21065,    0, 2137, 1886,    0,99238,99238,99238,
99238,99238,99238,99238,99238, 1964,    0,99238,    0,    0,
    0, 2283, 1129,    0,99238, 1383,    0,99238,99238,    0,
    0,99238,    0, 2311,99238,    0,    0,86601,70828, 2199,
 1974,    0, 2247, 2264,    0, 1956,99238,    0,    0,    0,
    0, 2563, 2568, 2573, 2177,    0, 2585,    0, 2590,    0,
 2602,    0,    0, 2609, 2617,78388, 2626,    0, 2634,    0,
 2635,    0,    0,    0,    0, 2640, 2238, 2249,    0, 2664,
 2665,    0,    0,    0,    0, 2668,    0,    0,71458, 2670,
 2671,    0,    0,    0,    0, 2675, 2340, 2677, 2679, 2692,
 2695, 2702, 2703,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 2704,
 2707, 2709,    0,    0,    0,    0, 2712,    0,    0,    0,
    0,    0,    0,    0, 2714,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 2715, 2720, 2721,
 2724, 2725, 2727, 2728, 2729,    0,    0,    0,    0,    0,
 2731, 2734, 2735, 2736, 2739, 2740, 2741, 2742, 2743, 2746,
 2749, 2750, 2754, 2755, 2756, 2757, 2664, 2665,82798,82798,
72088,99238,    0,    0, 2324, 2646,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
25321, 1655,    0,    0,    0,    0, 2758,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 2186,
    0,    0,    0,    0,    0,    0,    0,    0, 2766,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 2767,    0, 2769, 2773,    0,99238, 2780,    0,
   14,    0,85419, 2453, 2452, 2455,    0,    0,    0,    0,
99238,  226,    0,    0,99238,  272,    0,    0, 2768, 2781,
    0,    0,    0, 1741,    0,    0, 2788,99238,    0,    0,
    0,    0,    0,    0,    0, 2497,  575, 2499,    0, 2790,
 2790,    0, 2504,99238,    0,    0,    0,78388,    0,    0,
78388,    0,    0,    0,    0,72718,    0,    0,78388, 1066,
    0, 1066,78388, 1546,    0, 2339,78388,    0, 2802, 1974,
    0,    0, 2551,    0,    0, 1230,    0,  859, 2492,  984,
 2580, 2221,    0,99238,  859,  859,    0, 2815,  226, 2583,
    0, 2580,    0, 2815,    0,    0,    0, 1080, 2477,    0,
 1924,    0, 2423, 2415,    0,    0,    0,   32,    0, 2822,
 2435,    0,    0,    0, 2444,    0, 2491, 2836,    0, 2536,
 2838,   95,    0,    0,    0,    0,    0,    0,    0,    0,
 2595,    0,    0,    0, 2797,    0,    0,  253,    0,    0,
    0,  232, 2851, 2854, 2838,  226,    0,    0,  859,    0,
    0,    0, -142,    0,    0,    0,    0,    0, 1701,    0,
    0,    0,    0,    0,    0,    0,    0,  859,  859,    0,
 2855, 1088,  804, 2477, 1570,    0,    0,    0,    0,    0,
    0, 2630, 2528,    0, 2462, 2532,    0,    0,    0,    0,
 2541,72088,    0,25321,  682, 2537,    0,    0,    0,99238,
    0, 1593,78388,  882,    0, 2423,99238,78388, 1679, 1785,
 1069,78388, 2423, 1794, 3235,    0,    0, 1348,    0, 1348,
    0,78388,78388,25321,  611,    0,78388,78388,78388, 2604,
78388,78388,78388,78388,78388,68938,68308, 3235,78388, 1819,
78388, 2873,78388,78388,78388,78388,78388, 2879, 2880,78388,
78388,78388,78388,78388,78388,78388,78388,78388,78388,78388,
78388,78388,78388,78388,78388,    0,    0,82168, 1824, 1824,
    0,    0, 2881,    0, 1655, 2179, 2883,    0,    0,84631,
    0,78388,78388,83428,    0,    0, 2885,  856,    0,78388,
    0, 1270,    0,    0,78388, 2495, 2507,    0,    0,    0,
69568,78388,99238,82798,82798,82798,82798,82798,78388, 2891,
78388,73348,94129,99238,77758,    0,    0, 2547,    0,    0,
 2571, 2572, 2575,28968, 2651,    0,  242,99238,85025, 1602,
    0,    0,    0,    0,    0,    0,    0, 2904, 2899, 2689,
 2641, 2644,   14,    0,    0,    0,  926,    0,    0,    0,
    0,    0,    0,99238, 2199, 1974,78388,99238,99238,    0,
 2423,    0,  575,    0,    0,    0,  575,99238, 2619, 2625,
99238,  575, 2906, 4779, 4855,    0, 2648, 2919,    0,    0,
 2697, 2918, 2921,    0,21637,    0,    0,36941, 1980,99238,
    0, -143,    0,    0,    0,    0, -109,    0,    0,  207,
78388,    0,99238, 2457,    0, 1230, 2474, 2478,  435, 2479,
  -52,    0, 2535,    0,    0, 1334,    0,  859,    0,99238,
99238,    0,99238,87780,    0,    0,    0, 2364,    0, 2938,
 2588,    0,    0,  184,    0,    0, 2941, 1498, 2615, 2616,
 2621,    0, 1348, 1515,    0,99238,    0, 2553, 2399,    0,
 2505,99238,99238, 2696,   32,    0,    0,    0,  181,    0,
    0,    0,    0, 1348,    0, 2836,  184,    0,    0,    0,
 4144,    0,    0,  184, 2599,  184,    0, 2962, 1348, 1348,
 1348,    0,    0,    0,    0, 2566, 1886,    0,    0,    0,
99238, 2658,    0,    0, 1383,    2,    0,    0,    0, 1273,
21609, 2400,30776,31390, 2637,    0,    0,    0,    0,    0,
 2970,    0,  910,99238, 2971,    0,    0,86601,99238,25321,
    0,    0, 2659,    0,    0,    0, 2516,    0,78388,78388,
22251,78388, 2976,78388, 2979, 2977, 4900,78388,78388,78388,
78388,25935, 2982, 2758, 2983,78388,78388,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 2711, 2986, 2988,
22865, 2613,78388,    0,78388,    0,22206,22820, 2989,99238,
 4961, 5030, 6267, 6291, 6881,    0,    0,    0, 4386,73978,
    0,    0,    0,    0,36328, 2991,  248,23434,78388,78388,
36967,    0, 6905,24048, 7495, 3225, 4453,    0,    0, 7519,
 8109, 8133, 8723,24662,25276,25890,26504,27118,27732,28346,
28960,29574,30188,30802,31416, 2295,    0,    0,    0,    0,
99238,88173,    0, 2992,    0, 2993, 1533, 5024,72088, 2770,
 1655,72088,    0,    0, 2723,    0,  572,    0,    0, 2705,
83428, 2885,78388, 2623,78388,27163,    0,78388,    0,    0,
    0, 3003, 2705, 2705,    0, 2771, 1437, 1437, 1824, 1824,
25321, 2430, 3010,    0, 2257,    0,    0, 3004, 2324,    0,
 2657,    0,    0, 2643,  525,  653, 2656,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 2636,
 2652, 3020, 3023, 3028, 2027,    0,    0,    0,    0, 3013,
 1644, 3034, 2710,    0, 2710, 1477,78388, 2710, 2745, 2747,
78388,    0,99238, 2764,    0,    0, 2718, 2722, 2726,28968,
 2798,  335,    0,    0,    0, 3116,    0,    0, 2537,    0,
25321,    0,    0, 3052,    0,    0,    0,  575,  575,    0,
    0,    0,    0,85419, 2666,78388,99238,86206,78388, 2618,
78388,    0,    0,    0,    0,    0,    0,    0, 2084,88173,
78388, 2278, 2291,    0,99238,    0,    0, 2760, 2763,    0,
 2765,    0,    0, 2831, 2688,99238, 1334, 1727, 1181, 1199,
99238,21065,    0,    0,    0,    0, 2832, 3053,    0,    0,
90592,  448,    0,99238,   -6,    0, 3071, 2523,78388,    0,
    0,99238,99238,99238,103954,99238,78388,99238,    0,    0,
 2811,87387,    0, 3056,    0,    0,    0,    0,    0,    0,
 2786,    0,    0,    0,    0,    0,    0,  676,    0,    0,
    0,    0,    0,    0,    0, 2789,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 3064,    0,99238,    0,    0,
90592, 2684,    0, 2657,    0,    0, 2680,96487,    0,89373,
  867,  987,   88,    0, 2221, 2259,    0,    0, 2852,    0,
    0, 2713,    0, 3070, 3074,    0,    0,    0,    0, 1530,
    0,  221, 2314, 2732, 3093,    0, 2345,    0,    0,    0,
    0,    0,    0,    0,    0, 1596,    0, 3078,99238, 1650,
 1348, 3097, 3098, 3099,  226,    0,    0,    0,    0, 3080,
    0,    0, 2477,    0,    0,    0, 2221,99238, 2259, 2744,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 2661,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 2540,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 2545, 1993, 2498,    0, 2654, 2843,    0, 2713,99238,
99238,  910, 2856,  962,    0,    0,    0, 2759,    0, 2857,
    0,    0,    0, 3118,    0, 1974, 8747, 9337,90985, 9361,
    0, 9951,    0,78388,    0, 9975,10565,10589,11179,79018,
    0,    0,11203,11793,78388,    0,    0,78388,74608,78388,
25321, 2859, 2752,    0,78388,78388,78388,    0,    0,    0,
    0,    0,    0,78388,    0,78388,23479, 2748,78388,78388,
78388,78388,32030,32030,78388,    0,78388,    0,78388,    0,
78388,    0,    0,    0,    0,    0,78388,78388,78388,78388,
78388,78388,78388,78388,78388,78388,78388,78388,    0, 2361,
88173,99238,    0, 3122,83428, 3123, 2375,78388, 2858,    0,
    0,    0,78388, 2903,    0, 2705,78388, 2705, 2705, 2423,
 2895, 2537,    0,    0,75238,    0, 2384,99238, 3131, 2909,
    0,99238,99238,99238,99238,99238,99238,99238,    0,    0,
    0,    0,    0,    0, 2912,    0,    0, 2913,    0, 2091,
    0, 2091,    0,    0,    0,    0,99238,    0,    0,    0,
    0,    0, 2844,    0,    0,85419,85419, 2392,99238, 2904,
    0, 2643,  636,  738, 2866, 2867,    0, 3116, 2846,   61,
 1225,    0, 2777,    0, 2674, 2660, 2682,    0,    0,    0,
    0,    0, 2516,    0,    0,    0, 3155, 1644,78388, 2884,
    0,    0,    0,    0, 1059,    0,25321, -143, 2839, 2992,
    0, 1974,99238,    0,    0, 2498,  859,  859, 2763,    0,
    0, 2806, 2684,    0,    0, 3169, 2935,    0,    0,    0,
 2871, 2872,    0,    0,    0,    0, 2944,    0,    0,99238,
  757,    0, 2860,    0,    0,    0,    0,    0, 2603,    0,
 2934,75868,    0,78388, 2804,25321,    0,    0,    0,    0,
    0, 2896,    0,    0,25321,    0,    0,    0,    0, 2795,
    0,    0,88173,  972, 3193,88173,    0,    0, 2401,99238,
 2832,    0, 1498,96880,    0,99238, 1795, 1850,    0, 1683,
    0, 2863, 2864, 2868, 2869, 2874, 2886, 2580,    0, 2498,
 2882,  -29,    0,  153,    0,    0,    0,    0, 1530, 3080,
 3080,  859, 2893,94522,94522,    0, 3201,  221,    0,86601,
 2845,    0,  184,    0,    0,  184,    0,  184,    0, 2944,
 3215,    0,    0,    0,    0,    0,    0,    0, 2684,    0,
 2402,    0, 1566, 2580, 1681,    0,    0,    0,    0,    0,
    0, 3227,    0, 2654,    0, 2819,    0,  859, 2824, 2627,
  859,  859,  859,    0,97273,    0,    0,    0,    0, 3217,
  864,    0, 3219, 1052, 2980,    0,99238,99238,    0,    0,
    0,    0, 3238,28344,  859,    0,    0,    0,    0, 2917,
 3248,    0,    0,    0,    0,11817,    0,    0,    0,    0,
72088,12407,    0,    0,12431,24093,37555,    0,    0,78388,
 2865,13021, 2409,32644,13045,13635,78388,78388,33258,37566,
33872,34486, 2428,78388, 3250, 3253,24707,13659, 4574, 4617,
14249,14273,14863,14887,15477,15501,16091,16115,16705,16729,
17319,17343,    0,    0,    0,    0,    0,    0,    0,    0,
78388, 2705,83428,78388, 2705,78388, 3256,78388, 3263,    0,
 2456,    0,    0, 2832,    0,    0, 2221, 2888, 2889, 2890,
 2897, 2898, 2901, 2907,    0,    0, 1062,  122, 1966,    0,
    0,    0,    0,  243,97666,    0,103168,85419,    0,    0,
 2134,    0,    0,    0,    0,99238,99238,99238,99238,99238,
99238,99238,    0,    0,    0,    0,   -2, 2792,    0, 2887,
    0, 2887,    0,    0, 2914, 1348,    0,    0, 2900, 1974,
85419, 3037, 3006,    0,    0,    0, 2943,    0,    0,    0,
    0,    0,    0,    0,99238,    0, 2994,78388,    0,    0,
    0, 2815, 2815,    0, 4144, 4144,    0,98059, 2987,    0,
 3021, 3275,25321,    0, 3293, 3040,    0,88173,    0,    0,
 1638,    0,    0, 2992, 2850, 2786, 3042,    0,78388, 2992,
    0,    0,    0, 2832,  145,    0,99238,    0,    0,    0,
91378,    0,    0,    0,    0,    0, 2978, 1348, 2984,99238,
 3073, 3048, 2595,91771, 2816,    0,    0,    0, 3307,    0,
 2924, 3022, 2925, 3058, 3025, 3061,    0,    0,    0,    0,
    0,99238, 2716, 3033,99238, 3033, 3045,    0,  971,    0,
 2684, 1348,    0,  859,    0,    0,    0,    0,    0, 3322,
    0,    0, 2959, 2944, 3324, 2832,    0,    0,    0,    0,
    0,    0, 2713, 1749,    0,    0,    0,    0,96880, 2221,
 2259,    0, 2221, 2259,    0,    0, 2916,    0, 2922,99238,
    0,    0,    0, 3327,    0,    0, 2463,    0,    0,    0,
85813, 2489, 3328,    0,    0, 3331, 1039,    0,    0, 3016,
94915,98452,    0,    0,    0,    0,    0,78388, 3335,78388,
    0,78388,  107,    0,    0,78388,    0,    0,17933,17957,
78388,78388,78388,78388,78388,    0,25321,    0,    0,78388,
 3063,78388,    0,78388,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 2705,
78388, 2705,    0, 2758,    0,    0,99238, 3318,99238, 2580,
    0,    0,    0,    0,    0,    0,    0,  245,92950,  245,
    0, 2912,    0, 2913,    0,    0,    0,    0,    0, 2936,
    0,  246,99238,    0,    0,    0, 1999,    0,    0,    0,
78388, 3340,    0,    0,99238, 3339, 3072, 3076, 3079, 3081,
 3083, 3085, 3086,    0,    0,  165,  731,    0,    0, 2956,
    0,    0,    0,99238,    0,    0, 3352,    0, 1644,78388,
78388, 2199,    0,    0,    0,99238,    0, 3353, 3007,    0,
    0,    0,99238,    0,    0, 3361,78388,79648, 2985,87780,
 2992,    0,    0,    0,    0,78388,78388, 3094,    0,87780,
    0, 3364,99238,  757, 2782,    0,    0,    0, 1238, 3073,
 2816,    0,  596,    0, 3127,    0, 3068,    0, 3075,    0,
    0,    0,    0,    0,   45,    0, 3152,78388,    0,    0,
    0,    0,    0,    0,    0,  -32,99238,    0, 3033,    0,
    0,  971, 3142, 3082,    0,    0, 1749,    0,    0,    0,
 2981,    0,    0,    0,    0,   92, 2498,    0,    0,    0,
    0,    0, 2763,    0,    0,    0, 2580,    0, 2580,    0,
    0,    0,    0,    0,  859,    0,    0, 3050,    0,    0,
 2906, 3381,    0,    0, 3125, 5626,28344, 1348, 1479,    0,
    0,  859, 2659,    0,    0, 2494,    0,93343,    0,99238,
    0,25321,    0,18547,25321, 3008,78388,78388, 3124,18571,
    0,    0,19161,19185,19775,25321, 4682, 4749, 1473,    0,
19799,20389, 2705,    0, 3368, 2500,    0, 2832,    0,    0,
    0,    0,    0,    0,    0,    0, 3111,    0,  246,99238,
99238,99238,99238,99238,99238,103561,103561,    0,    0,    0,
  246, 3066,97666,    0, 3160,    0,97666,    0,    0, 1974,
 3018,    0,99238,    0,    0,    0,    0,    0,    0,    0,
    0,  171,  171,    0,    0, 3393,    0, 3130,    0,78388,
 3417,    0,25321,    0,    0,    0,    0,    0,90592, 2657,
 3432, 2423, 2509,72088,    0,25321,87780,    0,25321,25321,
99238,  759,  820,    0, 2896, 3182,    0,    0,    0, 3146,
 3148, 2091,    0,    0, 3212,    0,    0,    0,    0,    0,
    0,    0,20413,    0,    0,    0,    0,93736,    0, 3088,
  859,    0,    0,   92, 3147,    0,    0,    0,    0, 2763,
    0,    0,    0, 2517,98845, 3445,  859,    0,    0, 3214,
    0,78388, 5626,  859, 1348,   55,    0,    0, 3449,    0,
    0,    0,94915,    0,    0,    0,    0,    0,    0, 3447,
    0,78388,    0, 3092,    0,    0,    0,    0,    0,78388,
    0,78388,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  245,  245,  245,  245,  245,  245,  245, 3129,92950,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 3018,  490,    0,    0, 2544,
    0,    0,    0,    0,    0,    0,    0,    0,    0,99238,
 1123,99238,    0, 2548,78388,    0,    0, 2832, 3230,99238,
 3456,    0,21003,    0, 3198, 2896,87780,    0,    0,99238,
99238,  221, 3060,    0, 3202, 3240,    0,87780, 2091, 2091,
 3029, 3211,    0,    0,    0,95308,    0,    0,    0,94522,
    0,99238,    0,    0,    0,    0,    0,99238,    0, 3454,
    0,    0,    0,    0,    0,  839,  -19,21027, 3475, 3161,
    0,  533,    0,    0, 2944,    0, 3477,99238,99238,    0,
78388,25321,21617,99238,  246,  246,  246,  246,  246,  246,
  246,    0,    0,    0,    0,    0, 2965,    0,    0,  171,
  171,  171,  171,  171,  171,  171,    0,    0,    0,  766,
    0,    0,    0,    0,  817,  145, 2221,    0,    0, 3479,
    0,    0,87780,    0,    0,  820,    0,    0,    0,    0,
    0,87780, 3233,    0,    0,    0,    0, 3137, 3029,  123,
    0, 3265,    0,    0,    0,    0,    0,    0, 3024,98845,
    0,  859,    0, 2963,  431, 1035, 2949,    0,    0,    0,
 3032, 3036,    0,    0,  859,    0, 3096,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 2973,  817, 3080, 3274,    0, 3277, 2580,
    0,    0, 1079,    0,    0,    0,99238,99238,    0, 3218,
 2920, 2832,    0, 2832,99238,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,99238, 3222,    0,
   22,    0, 1974,    0, 2684, 3170, 2684, 2221,    0,    0,
 1079, 3126, 3243,78388, 1567,78388,    0,    0, 2091,99238,
 3514,    0,    0, 3272,    0,    0, 2550,    0, 3516,    0,
   70,78388,  997,    0, 2458,    0, 1749,    0,    0, 2580,
 2554, 2555,78388,    0,78388,80278,25321, 3139, 3174, 3141,
25321, 3194,    0, 1616,    0, 3272,    0,    0,99238,    0,
    0,78388, 3237,    0, 3156,    0, 3164,    0,    0,    0,
    0,    0,    0,    0,    0,    0,25321, 2968,    0,25321,
 2967,25321,    0,    0,    0, 1040, 3029, 3208, 3213, 3538,
    0,   82,    0,99238, 3162,    0, 1085,99238,99238,78388,
78388,78388, 1411, 1411,    0, 3286,    0, 3158,    0,    0,
 3249,99238, 3029,    0,    0,    0, 2577, 3254,    0,    0,
 3191, 3549,    0,    0,25321,25321, 3149, 1472,    0,    0,
    0, 3029, 2091,    0,    0,    0, 3168,99238,    0,    0,
    0,    0, 3194,    0, 3557, 3549, 3029, 3172,78388,    0,
 3560, 2593,78388,    0, 2600,    0,
};
static int yyrindex[] = {                                   3204,
    0,  254,  102,    0,    0,    0,    0,    0,    0,    0,
    0,  205,    0,    0,    0,    0,    0,    0,    0,    0,
 3601,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  238,    0,    0,  498,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  975,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 3273,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  975,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,67487,    0,    0,    0, 3205,    0, 3344,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1296,76498, 1166,    0,
    0,    0,  518,    0,  395,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  174,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  840,    0,    0,
  395,    0,    0,    0, 3345,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  979,    0,    0,    0,    0,
    0,    0,    0,    0,28385,    0,    0,    0,    0,    0,
  175,    0,    0,    0,    0,    0,  633,    0, 3570,    0,
 1502,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 3348,    0,    0,    0,    0,    0,    0,
    0,    0,  334,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1263,    0,    0, 1538,    0,    0,    0,    0,
    0,    0,    0, 1610,    0,  315,    0, 5197,    0,92164,
    0,    0,92557,100810,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 3216,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 3348,    0, 1620,
    0,    0,    0,    0,    0,    0,101203,    0,    0,    0,
101596,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  512,    0,    0,    0,    0,
77128,70198,    0,    0, 3224,  199, 1721, 3204,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  563,
 3347,    0, 1764,    0,  173,    0, 1800,    0,    0, 3347,
 1764,    0,    0,    0,    0, 1021,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1800,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1778,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  369,
 1721,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,40219,    0,
    0,    0,    0,    0,    0,    0,    0,    0,40833,    0,
    0,    0,    0, 7063,    0,    0,    0,    0,    0, 5835,
 6449,    0,    0,    0,    0,37763,    0,    0,    0,41447,
42061,    0,    0,    0,    0,42675,43289,    0,    0,    0,
    0,    0,    0, 7677, 8291, 8905, 9519,10133,10747,11361,
11975,12589,13203,13817,14431,15045,15659,16273,16887,38377,
38991,43903,17501,18115,18729,19343,44517,19957,20571,21185,
21799,22413,23027,23641,39605,24255,24869,25483,26097,26711,
27325,27939,28553,29167,29781,30395,31009,31623,32237,32851,
33465,34079,34693,35307,35921,36535,37149,45131,45745,46359,
46973,47587,48201,48815,49429,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 5835, 6449,    0,    0,
 3204,    0,    0,    0, 1827,51890,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1046,56802,    0,    0,    0,    0,  351,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,50043,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,50662,    0,  658,    0,
 2557,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1342,    0,  334,    0,    0,    0,    0,
 1981,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 3282,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  208,    0,    0,    0, 1721,
    0,    0,    0,    0,  247,    0,    0,    0, 1855,101989,
    0, 3349,    0,    0,    0,    0,    0, 3234,    0,  255,
    0,    0,    0,  532,    0,    0,    0,    0,  995,    0,
    0,    0, 3204,    0,    0,    0,    0, 3319, 2090, 3908,
 2937,    0,    0,    0, 3262,    0,    0, 3527,    0,    0,
 3704,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  884,    0,    0,    0, 2329,    0,    0, 2840,    0,    0,
    0, 4015, 3369,    0, 3704,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  395,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1502,    0, 1323,    0, 1327,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 3204,    0, 2304, 3585,  210,    0,    0,    0,    0,
    0,80908,    0,80908,    0, 3204,    0,    0,80908,80908,
64591, 3587, 3204,80908,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 3196,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,80908,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 3204,53118,53732,
    0,    0,    0,35100,35714,    0,    0,    0,51276,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,81538,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 3587,    0,    0,    0,  315,    0,    0, 4212,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 3204, 3296,
    0,    0,    0,    0,    0,    0,    0,65854,    0,    0,
    0,    0, 2557,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  369, 1721,    0,    0,    0,    0,
 3204,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  992,    0,    0,    0,    0, 3320,    0,    0,
67883,    0, 1289,    0,  942,    0,    0,  214,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1861,
    0,    0,    0,    0, 1327,    0, 3295,    0,    0,    0,
    0,    0,    0,    0,  231,    0,    0,    0,    0,    0,
    0,    0,    0, 1049,    0,    0,    0,    0,    0,102382,
    0,    0,    0,    0,    0,    0, 1882,    0, 1135, 1182,
 1276,    0,    0, 1901, 1327,    0,    0, 1915,    0,    0,
    0,    0,    0,    0, 3336,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 3527,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1800,    0,    0,    0,
    0,  492,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1304,    0,    0,    0,    0,    0,
    0,    0, 3338,    0,27730,    0,    0,    0,    0,    0,
    0,    0, 3598,    0,    0,    0,  211,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 2606,    0, 3599,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
88781,88792,88851,89058,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1952,    0,    0,    0,65012, 3204,    0,
57416, 3204,    0,    0,    0,    0,    0,    0,    0,62328,
    0,    0,    0,    0,    0,65433,    0,    0,    0,    0,
    0,    0,58030,58644,    0,52504,55574,56188,54346,54960,
 1108,  285,    0,    0,    0,    0,    0,    0, 1827,    0,
 3379, 5636,38755,102775,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 3287,29582, 3360,    0,    0,    0,    0,    0,    0,
 3296, 2152, 3321,    0, 3321, 3296,    0, 3321,    0,    0,
    0,66682,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 2103,    0,    0,    0,  210,    0,
 1056,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  513,    0,    0,    0,    0,  474,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  982,    0,    0,    0,
    0, 3365,90199, 2180,    0, 2225, 2308,    0,    0, 2244,
 2303, 2365,    0,    0,    0, 2496,    0,    0,    0,    0,
    0, 1704,    0,    0,    0,    0,    0,    0,    0,    0,
 3600,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 2348,    0,    0,    0,
    0,    0,    0, 1057,    0,    0,89786,    0,    0,    0,
    0,    0,    0,    0, 3347, 1764,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  294, 2320,    0,
    0,    0,    0, 4053,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1754,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 3226,
    0,    0, 1705,    0,    0,    0, 3347,    0, 1764,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1275,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1501,    0, 1961, 1493,    0,  403,    0,    0,    0,
    0, 3338,    0, 3355,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1721,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  679,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 3619, 3619,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,26549,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,62942,    0,59258,63556, 3204,
    0, 3620,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  765,38793,    0,  842,    0,  270,
    0,  270,    0,    0,    0,    0,    0,66272,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,65854,
    0,102775,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 2344,    0,    0,    0,    0,    0,    0,    0,
    0,  202,  211,    0,    0,    0, 1258,  244,    0, 1852,
    0,    0,    0,    0,    0,    0, 1006,    0,    0, 2075,
    0, 1721,    0,    0,    0, 1961,    0,    0,  330,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 3806,    0,    0,    0,
 3608,    0,  204,    0,  180,    0,    0,    0,    0,    0,
    0, 3610,    0,    0,    0, 3612,    0,    0,    0,    0,
    0, 3613,    0,    0, 3615,    0,    0,    0,    0, 3372,
    0,    0,    0, 3204,    0,    0,    0,    0,    0,    0,
  161,    0,    0, 1286,    0,    0, 1629,    0,    0,    0,
 1127, 1423, 1460, 1512, 1762, 1836, 1985,    0,    0, 1961,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 3226,
 3226,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 4098,    0,    0,    0, 1005,    0,    0,    0,    0, 2960,
    0,    0,    0,    0,    0, 1327,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 3281,    0,    0,    0,    0,    0,    0, 3636,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 3204,    0,    0,    0,    0, 3637,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,59872,    0,    0,64170,    0,    0,    0,    0,    0,
    0,    0,    0, 3622,    0,    0, 3347,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  194,    0,    0, 1615,    0,    0,    0,
 3296,    0,    0,67092,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1839,
    0, 1839,    0,    0, 2785,    0,    0,    0,    0, 1721,
    0,    0, 1397,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  607,    0,    0,    0,
    0, 3234,  707,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 3623,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  828,    0,    0,    0,    0,    0, 3625,
    0,    0,    0, 1329, 1086,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 3645,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 2082,    0, 3373,    0, 3373,    0,  318,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 4282,    0, 2086,    0,    0,    0,    0,
    0,    0,    0,  542,  774,    0,    0,    0, 1286, 3347,
 1764,    0, 3347, 1764,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  581,    0,    0,    0,    0,
    0,    0,27771,    0,    0,    0,  278,    0,    0,    0,
 3585,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 3385,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 3656,    0,    0,    0,
 3084,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,60486,
    0,61100,    0,  455,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  200,    0,  200,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 2097,    0,    0,    0,    0, 2570,    0,    0,    0,
    0,    0,    0,    0,    0, 2099,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 2097,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  438,    0,
    0,  305,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1016,
 1007,    0,    0,    0,    0,    0,    0,    0,    0, 1016,
    0,    0,    0, 2607,    0,    0,    0,    0,    0, 2237,
 3337,    0, 4296,    0, 2522,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1884,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 3373,    0,    0, 3373,    0,
    0,    0,    0,    0,    0,    0, 2910,    0,    0,    0,
    0,    0,    0,    0, 1011,    0, 1961,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 2111,    0,    0,
 2118,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,83842,84236,    0,    0,    0,    0,    0,    0,
    0, 3658,    0,    0, 3284,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 2629,    0,    0,    0,    0,
    0,    0,61714,    0,    0,    0,    0, 2638,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 2097,    0,
    0,    0,    0,    0,    0,  378,  439,    0,    0,    0,
 2097,    0,    0,    0,    0,    0,    0,    0,    0,  237,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 2097, 2097,    0,    0, 2793,    0, 3091,    0,    0,
 2018,    0, 1151,    0,    0, 1654,    0,    0,    0, 3379,
    0, 3204,    0, 3204,    0,  778, 1016,    0, 3386, 3389,
    0,    0,    0,    0, 3441,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 2124,
    0,    0,    0,    0,    0,    0, 2128,  719,    0,    0,
    0,    0,    0,    0,    0,  516,    0,    0,    0,    0,
    0,    0, 3585,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  200,  200,  200,  200,  200,  200,  200,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1177,    0,    0,    0,    0,    0,    0,  140,    0,    0,
    0,    0,    0, 1175,86994, 3613, 1016,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 3407, 1016,    0,    0,
 2005,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1333,    0,    0,    0,    0,    0,
    0, 2645,    0,    0, 2097, 2097, 2097, 2097, 2097, 2097,
 2097,    0,    0,    0,    0,    0,    0,    0,    0, 2097,
 2097, 2097, 2097, 2097, 2097, 2097,    0,    0,    0,    0,
    0,    0,    0, 2073,    0, 3443, 3347,    0,    0,    0,
    0,    0, 1016,    0,    0,    0,    0,    0,    0,    0,
    0, 1016,    0,    0,    0,    0,    0,    0, 2005, 3273,
    0,    0, 4561, 4561,    0,    0,    0,    0,  534,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  562,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  252,    0, 3226, 3266,    0,    0,    0,
    0, 1295,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 2037,    0, 2037,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 2647,    0,
    0,    0, 1721,    0,    0, 3267,    0, 3347,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  276,    0,
 4654,    0, 5014,  956,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 2181,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1586,    0,    0,    0,
 1742,  268,    0,    0,    0,  956,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 2653,    0, 3676, 1875,
89212, 2275,    0,    0,    0,    0, 2005, 1844, 3607,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 6222,    0,    0,    0,    0,    0,  202,    0,
    0,  201,    0,    0, 2655, 2398,    0,    0,    0,    0,
    0, 6222, 3621,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 4136,  202,    0,  236, 6222,    0,    0,    0,
    0,    0,    0,    0,    0,    0,
};
static int yycindex[] = {                                      0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 3192,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1787,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 3087,
    0,    0,  120,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 3236,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 3669,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 3670,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 3683, 3684,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  779,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 3421,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  584,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1686,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 3681,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 3425,    0,    0, 3426,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 3688,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 3470,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 3371,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  595,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 3434,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 3221,    0,    0,    0,
    0,    0,    0,  615,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 3380,
    0, 3384,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 3708,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 3206,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 3163, 3173,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 3711,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 3498,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 3722,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,
};
static int yygindex[] = {                                      0,
    0,    0,    0,    0,    0,    0, 2101, 2476,    0, 2480,
 2481, 1385, 2483,    0, 1390, 2486,    0, 1391,-1914,    0,
 2263,  885,    0,    0,    0,    0,-1969,  741,  743, 2490,
 1719, 1372,  896,    0,    0,    0,-2474,    0, 1499,  967,
    0,    0,  803,    0,    0, 2331,    0,    0,    0,    0,
    0,    0, 3455,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  994,    0,    0,    0,  834,-1582, 1058,-1678,
  717,    0,  465, -537, 3107,    0, 3740, 1618,    0,    0,
 -893,    0,    0,    0,    0,    0,  691,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1597,    0,    0, 1037,
-1980,    0,    0,  565, 3471, 2848,    0,    0, 1550, 1025,
 1271,    0,    0,-2200,    0,-2051,    0, -163,  628,    0,
  487,    0, 1277,-2045,    0,-2184,  401,  456,  460,  445,
   94,-1724,-1660,-1181,    0,    0, -980,-1675,    0, 1097,
    0,  698,-1326, 1099,  109,-1587,-1522,-1152,  668, -446,
 -638,    0,    0,   84,    0, 2382,-1209,    0,    0, 3241,
 1926,    0, 1922, -658,    0, 2820,    0,    0,    0,    0,
-1662,-1012,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,-2586,  906, 1669, 1670,    0,    0,    0,
  467,    0,  468,    0,    0,  558,    0,    0,    0,    0,
 -926,-1429,    0,    0,    0,    0, 2105,    0,  767,    0,
 1682,    0,  677,    0,    0,    0,    0,    0, 3866, 2605,
 2250,    0,    0,    0, 1221,   96,    0,    0,    0,  -72,
    0, -340, 2427,    0, 1960,    0, 3199, 2751, -973,    0,
    0,    0,    0, 2147,    0, 1684,    0, 2068,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 2524,    0,    0,
    0,    0,    0,    0,-1735,-1668,    0,    0, -659,    0,
 2459, 1645,-2131, -648,    0,    0,    0,-2099,    0, -610,
    0, 2784,    0, 2466,    0,    0,    0,    0,    0,    0,
    0, 3754,    0,    0,    0,    0, 1799,    0, 1475,    0,
 1471,    0,    0,    0,  824,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 2905, 3260, -837,    4,    0,    0,
    0, -619,    0, 3554, 3304,-1418,    0,    0, 1370,    0,
    0,    0, 3259,    0,    0,    0, 2206, -848,    0,    0,
-1147,-1560,    0,    0, 1226,    0, 2628,    0,    0,    0,
    0,    0,    0, 1825, 1760,   97, 2253,    0,    0,  831,
    0, -806,-1188, 2772,    0,  907,    0,    0,  527,    0,
-1010,    0, 2214,-1308,    0,    0, 3268, 1812,    0,    0,
 3916,    0, 3921,    0,  868,  869,    0,    0, 3923,    0,
    0, 3926,    0,    0, 3927,    0, -722,    0, 2964,-2024,
 -587,    0,-1937,-2365, -970,-1976,  604,    0,-1102, -525,
-1197,-1133, -867,    0,    0,    0,    0,    0,    0,    0,
-1430,    0, 2690,    0,    0,    0,    0,    0,    0, 2341,
    0,    0,    0,    0,    0,-1211,    0, 1667,-1954,    0,
  724, 3220, 3251, 2502, 3200, -560, -272,    0,  830,    0,
    0,-2202,-1740,    0, 2262, -843, 2230,    0,-1057,-1287,
 3065, 3067,    0, 2683, -860, -849, 2611, -920, -928, -608,
-1279,-1271,-1269,  -70,  -59,-1701, -715,    0,  -97, 1152,
-1239, -632,    0,-1335,    0,    0,    0,    0,    0,    0,
 1971,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,-1332,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1100,    0,-1833,    0,    0,
 -880,-1267,    0, -108, 1724, -708, -115,    5, 1469,-1392,
    0,  -45, 3850,    0,   47,  -51,-1086,  535, -462,  -98,
  -53,   10,    9,  -44,  -27,-2387, 1081, -181,   31,  -14,
    0,    0, 3833,    0, 1883,  157,  166,    0,    0, 2694,
  427,    0,    0,    0,    0,  280, 1560,    0, -868,-2317,
    0, 2842,    0, -667,-1190,-2199,    0,    0,    0,    0,
   90, -344, 1401,    0,    0,-2083,-2595,    0,    0,    0,
-1957,    0,  590,    0,    0,-1340,    0,    0,    0,    0,
 -582,    0,-1661,    0,-2532,    0,    0,    0, 2060,    0,
    0,    0,    0,    0,  879,    0,    0,    0,  713,  642,
 1503,    0,    0,    0,    0,    0,    0,  340, 1268,    0,
    0,    0,    0,-2156, -953,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 2946,    0,    0, 2975,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 3983,    0,    0,    0, -707,    0,    0,    0,    0,
 1157,-1196, 1048,    0,    0,    0,    0,  770,    0,    0,
-1491,    0,    0,    0, 1324,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  705,    0,    0, -674,-1598,
 -315,    0,    0,    0,    0,    0,    0,-1315,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
};
#define YYTABLESIZE 104603
static int yytable[] = {                                     343,
  349,  559,  362,   46,  967,  571, 1000, 1003, 1147, 1127,
  512, 1042, 1138, 1224,  562,  476,  563,  462, 1375,  497,
 1226,  513,  342, 1323,  348,  488, 1700,  576, 1020, 1385,
  999, 1002, 1043, 1082,  671, 1219, 1220, 1225, 1794, 1512,
  536, 1795, 1126,  491, 1085, 1519, 1737,  460,  463, 2138,
  471,  474,  477,  484,  343,  489,  492,  343,  498,  474,
  561,  556,  505, 1386,  533,  569,  968,  516,  463,  471,
  474,  565,  484, 1026,  343,  489, 1931,  492,  343,  498,
  474,  540, 1088, 1278,  505, 1345,  515, 1341,  552,  566,
  343,  555,  463, 1344,  552,  471,  474,  477,  484, 2179,
  343,  489,  492,  568,  498,  474,  540,  504, 1059,  505,
  341,  578,  473,  342,  343,  343, 1679, 2126,  474, 1917,
  473,  589, 2392,  564, 2393, 2429, 2318, 1575, 2192,  504,
 2227, 1651, 2191, 1839, 1697, 1477, 2531, 2532,  342, 2485,
 2550, 1841, 2010, 1716, 1803, 1382, 1919, 2143, 2444, 1842,
 1450, 1843, 1052, 1844,  575, 1714,  577,  560, 1097, 1305,
 2024, 1131, 2589, 2016, 1343,  485,  570, 2219, 1349,  988,
  990, 2441,  282,  284,  271,  677, 2649, 1837, 2278,  586,
  523,  610,  545, 1817, 1848,  529, 1848,  543,  534, 1800,
  716, 2972,  519,   94, 2526, 1827, 2282,  720, 1261,   92,
 1287,  341, 1433, 2302, 1038, 1616,  998, 1265, 2671, 1243,
 1257, 1001,  573, 1255, 2878, 2820,  282, 2119, 2210,  396,
  957, 1825, 1683,  957, 1832,  581,  341,  737, 1802,  883,
  779,  282,  284,  271,  883, 1288, 1310, 1123,  957, 1261,
  957, 1327, 1724, 1167, 1782,  733,  764, 1782, 1265, 1824,
 1711, 1307,   94, 1038, 1255, 2518, 1302, 1261,   92, 1287,
 2283, 1221, 1782, 1038, 1782, 1135, 1265,  430, 1243, 1257,
 1297, 1429, 1255, 1268, 1224, 1321, 3221, 2547, 1123, 1864,
 2120, 2743,  604, 3322, 1167, 1647, 2671, 1167, 2878,  779,
 2752, 1981, 2777,  336, 1288, 1310, 1123, 1352, 1225,  276,
  739, 1494, 1167, 1573, 1215,  764, 1536, 1537,  430, 1589,
 1307,  430, 1038, 1321,  651, 1304, 1321,  337,  163, 1321,
 1269,  163, 2648, 2780, 2501, 1609,  430, 3132, 2418,  912,
  349, 3352, 2279, 1213, 1321,  463,  471,  474,  484,  343,
  489,  343,  474, 1426,  505, 1215,  126, 1402,  362, 1355,
  652, 2996,  336, 2893,  348,  660, 1704, 2136, 3096,  652,
 2170, 2171, 2172, 1215, 1435, 1707,  233, 2136, 1215, 1419,
 1013, 1577,  644,  651, 1566, 1395,  337, 1781, 1647,   13,
  126, 1963, 2662, 2206, 2827,  681, 2697,  546,  912,  504,
 1581,  658, 1213, 3077, 1413, 1708, 2520, 2280,  233, 1865,
 1494, 1615,  296,  396, 2093, 1346,   79, 2663, 2847,  652,
 1606, 1607, 1608, 1609, 1610, 2523, 2660, 2207, 1403,  547,
 2521, 1781, 2664,  645,  396, 1278, 1794, 1215, 2894, 1795,
  233, 1420, 2744, 1398, 2894, 2686, 1781, 1168, 1956, 3323,
  727, 1436,  609,  957, 2792, 2975,  602,  694,  732,  471,
  529,  605, 1509, 1413, 1510, 2975,  957,   94, 2449,  600,
  127,  296, 1261,   92,  739, 2079, 3401, 1782, 1052, 1575,
  396, 1265, 3402, 1251,  957, 1685, 1408, 1255, 1168, 1686,
 1782, 1168, 1956, 2163, 1691,  682, 2601, 3353,  781,  957,
 1712,  246, 1345, 2419, 2794, 1610, 1168, 1956, 1782, 3184,
 1344, 1123, 3133,  396,  326, 3403, 1705, 1167, 2745, 2894,
 1261, 1125, 1213, 1782, 1251, 2400,  326, 1251, 2996, 1265,
  734, 1014, 1221, 2074,  396, 1255, 2540, 1425, 2541,  505,
 1261,  781, 1251,  341,  471,  963, 1485, 1268, 1710, 1265,
 2848,  357,  471, 1495, 3175, 1255, 2108,  326, 2786,  326,
  246, 3222, 1125, 1213, 2958, 1167,  173, 1327,  740,  505,
 3040, 1980,  902, 2282, 2961, 1167, 1167, 1782, 1215, 1123,
 1125, 1213,  477, 2965,  724, 1167, 2967,  971, 1199,  349,
  299,  349,  976, 1680, 2357, 1866, 3101,  912,  317, 2796,
  451, 1725,  341,  505, 1676, 2505,  986, 1038, 1221,  912,
  357,  970,  175,  972,  741,  348,  923, 1575,  997,  492,
 2112, 2367,  326,  997, 2964, 1167, 1215,  989,  989,  989,
  989,  902, 1831, 1038, 1167,  997, 2437, 2283, 1326, 1106,
  912,  781,  912,  317, 1287, 1261, 1215, 1321,  724,  299,
 1616, 1781,  512, 1321, 1265, 1573, 1038,  326, 2087,  781,
 1255, 1413, 1099, 1120, 1978, 1270, 1609,  326, 2022, 1650,
 1646, 1428,  524,  516, 1674,  923, 1167,  997, 2103, 1288,
 1278,  740,  163, 1133, 1123, 1109, 1215, 1814, 1167, 2670,
 1167, 2877,  781,  463,  471,  474,  484,  489,  492,  343,
  474, 1684, 1296,  505, 2589, 2589,  276, 1261, 1835, 2279,
  343, 1168, 1956,  652,  343, 1213,  729,  740,  651, 1243,
  477, 2014, 1827, 1140, 1213, 1413, 1678, 1261,  300, 1287,
 1413, 2017,  740, 1122, 2912, 2913, 1265, 1215, 1243, 1257,
  912, 3359, 1255, 3198, 3199, 1225, 2291, 1251,  504, 2284,
 1215, 1215, 1167, 1167,  652, 2891, 1103, 1581, 2524, 1168,
  430, 1103, 1138, 2474, 1288, 2754, 2480, 2895, 1321, 1168,
 1168,   15, 1167, 2895, 2280,  296,  396, 2281, 1439, 1168,
 1307, 2746, 1199,  248, 1413, 1125, 1213,  300,  968, 1295,
 1345, 1445, 1341, 1573, 1916, 1251,   94,  396, 1344,  317,
 1413, 1115,   92, 1438, 1104,  451, 1114, 1929, 2525, 1110,
 2078, 2786, 3088, 1215, 1215, 1251,  957, 1100,   90, 1168,
 2159,  537, 2798,  326, 1781, 1129, 3031, 2456, 1168,  173,
  282,  284,  271, 1215, 1213, 1830, 1610,  968,  341, 3144,
 1782,  246,  248, 1213, 1213, 1213,  576, 2679, 2895,  678,
 2043,  451, 2979, 1125, 1213,  296,  296,   43,  968, 1265,
 2105, 2106, 1213, 3157, 1288, 1687,  326,  326, 1690, 1343,
 1168, 2589, 2121, 2484,  923,  175, 2782, 1229, 1215, 2019,
 1818, 2397, 1168,  341, 1168, 1956,  923, 1413,   91, 3226,
 1859,  357,  296,  266, 1213,   91,  574, 1215, 2110, 2253,
 1421, 1227, 2595, 1213, 1167,   81,  133, 1268,  678, 1856,
 3032, 3033, 3034, 3035, 3036, 3037, 3038,  923, 2355,  923,
 1251, 2044, 1513, 1514,  241, 2020,  512, 1326, 1314,  902,
 2763,  659, 2215, 1483, 1268, 2440,  451, 3182,  296, 2401,
 1721, 2553, 2639,  484, 1268, 1213, 1168, 1168,  578,  912,
  912, 1248,  266,  292, 1326, 3368,  362, 1816, 1125, 1213,
  343, 2407, 2038, 2797, 1326, 1215, 1168,  512, 2046, 1221,
  955, 2245, 1221,  343,  512,  512, 2811, 1019, 1367,  296,
  451, 2047, 1251, 1251, 1040, 1378, 1379,   15, 1042,  516,
 1727, 1727, 1248, 1289, 3279, 1248, 1413, 2184, 1413, 1413,
  134, 1126, 1251, 2545,  751,   81, 1848,  135, 2549, 2444,
 1248, 3368,  710, 1869,  256, 1256, 3227,  923, 3280, 2420,
  257, 1213, 1213, 3013, 3269, 1332, 1471,  508,  509, 1377,
  929, 2369, 2408,  299,  299, 3263, 3176,  136, 1434,  341,
 2465, 1213, 1126, 1040, 2552, 3228, 1472, 1042, 2731, 1413,
  396,  576,  396, 2410, 1515, 1518, 1256,  512,  512, 3158,
 1126, 2455,  659,  751,   90, 1318, 2411, 3087, 1442, 1443,
  292, 1303,   34,  256, 1256,  569, 2160, 2938,  601,  257,
 2953,  105, 2145,  606, 1129,  241,  241, 2944, 1722,  929,
 1575,  302, 3089, 1575, 2354,  956, 1518,  711, 1168, 1518,
 1473, 3160, 3161, 3162, 3163, 3164, 3165, 3166,  678, 1318,
 1346,  451,   45,  678, 1518, 2323,  292, 1519,  678,  576,
 2216, 2185, 1727,  249, 1318,  454, 1138, 3145, 3146, 3147,
 3148, 3149, 3150, 3151, 1251, 3090,  574,  661, 1249, 1248,
 1250,   91, 2190,   93,  738, 1478, 3091, 1605, 1518, 2045,
 2239, 1004,  474, 3333,  472,  576, 2955,  292, 1519,  678,
 1210, 1519, 2422, 1585, 3251, 1618, 2208,  576, 2048,  266,
  266,  300,  300, 1213, 3256, 1243, 1519, 1839, 1839, 1674,
 2176, 1581, 3295,  662, 2371, 1841, 1841, 2209, 3140, 1482,
 1288,  736, 2246, 1842, 1842, 1843, 1843, 1844, 1844,  129,
   37, 1210, 3395,  738, 1210, 2517, 2202, 2395,  302, 1586,
 1519, 3214,  668, 1486, 3252, 1248, 1243, 2685, 2254, 1210,
  857,  858, 2021, 2297,  576,  971,  923,  923, 3424, 1587,
 3312,  678, 3315, 1446, 1243, 1920,  137,  576, 3257, 3092,
 2256,  422,  968,  586, 1474, 2817,  968, 3432,  540, 1576,
  736, 2562,  512, 2412,  302, 2218,  512,  266,  516,  471,
 2409,  512, 3440, 1248, 3079, 1126, 1573, 1166,  751, 1573,
 3078, 1735,  952,  498,  578, 2783,  130, 1617, 3348, 1256,
  569,  669, 1736, 1248, 3085,  737,  396, 2287, 2475, 1082,
  254,  256, 2204, 2709,  929,  302,  259,  257, 1244,  971,
 1085, 2203, 3356,  516,  976, 1127, 1921,  512, 1166, 1370,
 3348,  508,  509,  989,  751,  569,  989, 3232, 1734, 1289,
 2128, 2829, 1682,  970, 2718,  670, 1166, 1256, 3215,  422,
  454,  952, 2868, 1126,  363, 1703, 1415,  610, 1088, 1244,
  929, 1852, 1853, 1854,  737, 3393, 1127, 1256,  971, 1234,
  422, 1049, 3302, 1447,  674, 2742,  422, 1244, 2288,  472,
 1448,  523, 1235,  587, 1127,  471,  484, 2057, 1743, 1797,
  610,  662,  970, 3412, 3216, 1575,  454,  997,  254,  396,
 1371, 3342,  396,  997,  259, 1389,  997, 1741, 1248,  422,
 3410,  516, 2830,  970,  364, 1415, 1236,  471,  484,  396,
 3190, 2059, 1673, 1237, 1794,  472, 1211, 1795,  738, 2439,
 1049, 1238,  929, 3436, 1794, 3217, 1753, 1795,   15, 1390,
 1221, 2205, 1372,  675, 1210, 1131, 2484, 1518, 1239,  674,
 1240, 3357,  743,  661, 3185, 1248,  740, 1318, 1126, 1243,
 1241,  365, 3427, 1243, 1244, 3197, 1318, 1211,  571, 1518,
 1248, 1248, 1256, 1224,  738,  736, 3303,  366, 1131,  343,
 2017,  610, 2060, 1140, 1932, 1211, 3093, 3438, 3304,  744,
 1248, 2061, 1210, 2139, 3394,  368, 2784, 1225, 1119,  662,
  372, 2719, 2720, 1210,  715, 2140, 2989, 1243, 1257, 1519,
 1246,  743, 1210, 1258,  610, 3433, 2062, 1357,  675, 1318,
 1318,  736, 1416, 1421,  857,  858, 1588, 1243,  374, 1358,
 2446, 1519,  738, 2420, 1391,  474,  586, 2644,  810, 3411,
 3168,  740, 1138, 2136, 1138, 3305,  738, 3210,  744, 1581,
 3264, 1166, 1210, 2925, 1256, 3169, 1345, 1345, 3306, 3266,
 1359, 1210, 1360, 2434, 1344, 1344, 1867,  947,  725,  737,
 1591, 1573,  571, 2435, 2141,  810, 2395, 2902, 3086,  736,
 2950, 1416, 1244, 1235,  571, 1318,  516,  971,  588, 1127,
 1926,  422, 2142,  736, 2080, 1077, 1968,  681, 1004, 1166,
  740,  508,  509, 1210, 1318, 2009, 1259, 2924, 1753, 1166,
 1166, 1576,  662, 1404,  725,  737,  751, 1210, 3281, 1166,
 1339, 1728, 1248, 2421, 1592, 1288,  947,  968,  422, 2125,
 1244, 1794, 1243, 1340, 1795,  997, 1005,  464,  883, 1948,
 2821,  571, 3282,  681, 1175, 1077, 2554,  512,  512, 1031,
 1244, 1593, 2951,  396,  571, 2013,  587, 1127,  896, 1166,
 1361,  375,  751, 1753, 1729, 2529,  997, 2869, 1166, 2236,
 1868, 1046,  725,  737,  594,  725, 2422, 1404,  484, 1210,
 1210, 1047, 1404,  347, 1175, 1175,  725,  737, 1175,  500,
 1211, 2952,  588, 2423, 1243, 1243, 1247,  522, 1948, 1210,
  422,  681,  896, 1175,  588, 1045,  997, 1753, 1031,  578,
 1166, 1246,  976,  516, 1243,  681,  743,  896, 2237,  506,
  751, 1221, 1166, 2236, 1166,  971, 1257, 1255, 2162, 1256,
  540, 1258, 1617, 3404, 1045, 1332, 1404, 2708, 1211,  422,
 2706, 2134,  347, 1253,  506,  584,  516, 1254, 2650, 1576,
 1310, 1010, 1404,  744, 1289, 1244,  516,  997, 1211,  463,
 1045,  588,  743, 1045, 1730, 2144, 2715, 2169, 1932, 1932,
 1932, 2169, 2240,  971,  588, 2158,  670, 1797, 1045, 1418,
 1123, 1794, 1731, 2241, 1795, 1806, 1166, 1166, 1807, 1011,
  678,  739, 1794,  477,  727, 1795, 3430,  970, 1211,  744,
  678,  970, 1046, 3417, 1045,  740, 1166, 1211, 1815, 1310,
  997, 1310, 1047, 2188, 1309, 1732,  516, 1244, 1244,  524,
  743, 1653,  662,  516, 2982, 2201, 2983,  970, 1808,  274,
  595, 1210,  549, 1654,  743, 2158, 2561, 1244, 2564, 1404,
  727, 3418, 2197, 1418, 2200, 3431, 1243, 2868, 1418, 1211,
  739,  740,  477,  557,  662, 1655,  654,  744, 1045, 2560,
 1451, 2755, 1452, 1211,  652,  742,  745,  671, 1074, 1362,
 1363,  744, 1085,  431, 2765,  572,  970, 1794, 1045,  594,
 1795, 1206, 1004,  343,  904, 1453, 1794, 3419,  274, 1795,
 1311, 1045,  102,  103,  553, 1389, 2933, 1594,  727,  678,
 1454,  727, 1418, 1658, 3308,  662, 2255, 2220, 1175,  740,
 1088,  758,  727,  894,  431,  654,  587,  431, 1418,  582,
 1479, 3270, 1206,  740,  742, 1211, 1211, 1074, 2787, 1390,
  927, 2807,  431,  541, 2809,  471,  484, 2221, 1166, 2222,
 1206,  347,  542,  904,  667, 1211, 1653,  594, 1404, 1311,
 1404, 1404, 2808,  347,  516, 2810, 1175,  894, 1654, 1175,
 2223, 1253, 3060,  593, 2379, 1254, 1175, 1175, 1004, 1244,
  758, 1175,  894, 2303, 2563, 2380, 1175, 3024,  347, 1175,
 1655,  655, 3000,  594,  347, 2224,  347, 3025, 1653,  927,
 1429, 1656, 2501, 1175, 1397,  594,  590, 1396,  751, 1657,
 1654, 1415,  591,  667, 1175, 1418, 1488, 1288, 1288, 2225,
 1753, 3001, 1175, 2502,  741,  763, 1175,  765,  508,  509,
  662,  592, 1655,  347, 1391, 1175,  971,  516, 1658,  593,
 2382,  345, 2136, 1656,  428,  595,  524,  767,  768, 2137,
  655, 1175,  772,  773,  751,  610, 1617, 1207,  596, 1429,
 1576, 1753,  594,  516, 1753,  739, 1767,  343,  471,  484,
  505,  463,  474,  474, 2454,  594,  396, 1175,  597, 1753,
 1658, 1753, 1741,  741, 1004,  428,  636, 1211,  428, 1175,
 2378, 1175,  498, 1004,  347, 1052,  512,  512, 1207, 3074,
  607,  578,  578,  428,  349,  345, 1224, 2442, 2443, 1034,
 1035,  739,  348,  595, 1312, 2381, 1207,  396, 1004,  647,
  396, 1466, 1490, 2503, 1418,  396, 1418, 1418, 2403,  323,
 1225, 1496,  637, 2383, 2384,  396,   96, 1175,  118,  742,
 1253,  653, 1050, 1131, 1254, 1659, 1289, 1289,  971,  595,
  365,  665, 2732, 1175, 1175, 1206, 1539,  235, 1175,  431,
  431,  595, 2733,  250, 2799, 2800,  431,  313, 1339,  739,
  678,  348,  970, 1312, 2504,  540, 2985, 1416,  593,  610,
 1466, 1340, 2734,  739,  396,  742,  883, 1659,  323,  347,
 2497,  512,  687,  512,  512,   96, 3338,  118,  688, 2575,
   49, 1050, 2533, 1206, 2535, 2537, 3339, 3340,  971,  365,
   52,  971, 1074,  690, 1206,  516,  235, 3055,  595,  516,
  357, 2493,  250, 1206,  857,  858,  313, 2478, 3355,  665,
   55,  595, 1576,  692, 1741, 1576, 2536,  512, 2491,  695,
  512,  512,  512,  742,  968,  713,  593,  431, 2568,  492,
 2538, 2571, 2572, 2573,  968, 1140, 2386,  742, 3385, 1570,
  244,  244, 1259, 1206,  512, 1900, 2666, 1074,  431,  718,
 1074, 2498, 1206, 2505,  431, 2590, 1891, 1900,  561,  357,
 1900, 2494,  593, 2495, 1753, 1074, 2405, 3299,  741,  719,
 2499, 2667, 2415, 1451,  593, 1452, 3028, 2735, 2736, 2737,
  540,    4,    7,  347,  347, 1175, 2668,  431, 2500,  725,
 1901, 1074,  471,  484, 1206,  728,  393, 1891, 1453, 1753,
 1891, 1207, 1901,  548,  736, 1901, 2168, 2055, 1206, 1938,
 2168, 2721, 2722, 1454,  741, 1891,  729, 2034, 2688, 1288,
 1259, 1938,  547, 1338, 1938,   58,   61,   64, 1480, 2689,
 1484,  593, 2056,  948, 1221, 1489, 1491, 3360, 2122,  324,
 1497, 1259, 2057,  953,  593, 1074,  431, 2058,  972, 1207,
  348, 2124, 1288,  592, 2123, 1569, 1257, 1255,  960, 1256,
 1207, 1258,  348, 1071, 1338, 1074, 1540, 1338, 1783, 1207,
 1206, 1206,  741, 1905, 2229,  962, 2059, 2228, 1074,  965,
 1783,  612, 1338, 1783, 2691, 1905,  741,  348, 1905,  972,
 1206,  977,  972,  348,  745,  348, 1138, 1052,  324, 1336,
  492, 1337,  349,  578,  323, 2234,  978,  972, 2233, 1207,
  980,  343,  471,  484,  505,  463,  474,  474, 1207,  984,
 2758, 2353, 1071, 3209, 2011, 1763, 2678, 3389, 1753, 3390,
 1788,  968,  348,  982, 2687, 2359,  578, 2060, 1259,  763,
  350,  765, 1788,  615, 2373, 1788, 2061, 2372, 1289,  323,
  652,  983, 2402,  985, 2788, 1259, 1052,  317,  357, 2690,
 1207, 2482, 2557,  516, 2481, 2556,  772,  773, 1653, 2605,
  357, 2062, 1259,  971, 1207,  987,  591, 2692, 2693,  994,
 1654, 1289, 2724,  512,  996, 1052, 1169,  317, 2616,  317,
 1009, 2615, 2493,  348, 2789,  357,  516, 1576, 1169, 2388,
 2389,  357, 1655,  357,  350,  516, 1169, 2452, 2453,  516,
  317, 1052, 1017, 1656, 1052, 2756, 2646, 1021, 1023, 1259,
 1169, 2681, 1206, 2818, 2760, 1028, 2556, 2775, 2766, 1052,
 2779, 1169, 1891, 1891, 1030,  317, 1207, 1207, 3260, 1891,
  357,  955, 1036,  763, 1039,  765,  508,  509,  357, 2823,
 1658, 1891, 2584, 1040, 3004, 1052, 1207, 3003,  592,  317,
 3030, 1949, 1053, 3029,  516,  767,  768, 1054, 1169, 3082,
  772,  773, 1259, 1949,  615, 2814, 1949, 3117, 1058, 1113,
 3116,  968,  955, 2491, 1117,  955,  516, 1338,  348, 1177,
 3326, 1253,  968, 1096, 1132, 1254,  343,  516, 3442, 1145,
  955,  357, 3445, 1704, 3159,  323, 1148, 1396, 3172, 1052,
 3350, 1259,  357, 3349, 3362, 3364, 2841, 3361, 3363, 2839,
 1891, 1150, 1152, 1149,  972,  972,  592, 1153,  972, 1052,
 1177,  972, 1154, 1177,  324, 1338, 2682, 3425, 1338, 1155,
 3349, 1891, 1052,  972, 1156, 1338, 1338, 1891, 1177, 1157,
 1338, 2890,  516, 3444,  516, 1338, 1259, 1659, 1338, 3330,
 3446, 1158,  592, 1259,  492, 2898, 1518,  463, 1159, 1518,
  463, 1741, 1338, 1741,  592, 1169, 1160,  968,  492,  324,
 1891,  591, 3327, 1338, 3329, 1162,  968,  326, 1207, 1728,
  349, 1338, 1728, 1163, 1164, 1338,  357, 1071,  396, 1165,
 1166,  396,  348,  348, 1338, 1729, 1180, 1240, 1729,  343,
 1240, 1167,  972,  585, 2904,  582,  585,  326,  582,  326,
 1338, 2927, 2072, 1168, 1170, 2075, 1071, 1172,  516, 1177,
 1178,  592, 2919,  972, 1179, 1797, 1181, 1230, 1182,  972,
  326, 1338,  857,  858,  592, 1797, 1338, 2931,  516,  591,
 2999, 1183, 1071, 1705, 1184, 1071, 1232, 1338, 1338,  970,
 1338, 1185, 1186, 1187,  512,  326, 1188, 1741, 1189,  970,
 1071, 1190,  972, 1191, 1192, 2986, 1249, 1248, 1250, 1193,
 1194,  512, 2966, 1195, 1196,  591, 1197, 1198, 1199,  326,
 1200, 3042, 3002, 1201, 1202, 1203, 1071,  591, 1204, 1205,
 1206, 1207, 1208, 3044, 1072, 1209, 1338, 1891, 1210, 1211,
  357,  357, 1065, 1212, 1213, 1214, 1215,  955,  955, 1260,
  967, 1259, 1338, 1338,  955, 1261, 1262, 1338, 2871, 2872,
 2873, 2874, 2875, 2876, 1263,  324,  955,   64, 1264, 1266,
 1290, 1291, 1338,  343, 1292,  516, 1308, 1311, 1307, 1313,
 1071, 1317, 3048, 1177,  591, 1318, 1322, 1347, 3045,  997,
  967, 1351,   64, 1072, 3010, 1354, 3009,  591, 1368, 1374,
 1071, 1065,   64, 3043, 1380, 1383, 3046,   64, 1393,   15,
 1399, 1409,  968, 1071, 1411,  471,  492,  484,  489,  492,
  568,  498,  505, 1412, 1413, 1414, 1416, 1417,  492,  972,
  997, 1177,  492,  997, 1177,  955,   64, 1424,  516, 1421,
 1430, 1177, 1177, 1431, 1444, 1464, 1177, 3131,  997, 1463,
  512, 1177,  968, 1466, 1177, 1468,  955, 1469,  644,  357,
 2265, 3113,  955, 1542,  516, 1520,  512, 3049, 1177, 1548,
 1549, 1567, 1797,  512, 1582, 1598, 1932, 3123, 1571, 1177,
 1612, 1597, 1622, 2158, 3130, 3081, 1008, 1177, 1624, 1625,
 1641, 1177, 1626, 1661, 1663,  955,  970,   64, 1664, 1396,
 1177, 1688, 1665, 3111, 1338, 1666,   64, 1689, 1233,  997,
  593, 1694, 1696, 1698, 1699, 1715, 1177, 1234,  357, 1718,
 3120, 1726, 1720, 1723, 2266, 1798, 1008, 1008, 1799, 2267,
 1008,   64, 1801,  350, 1805, 1811, 1812, 1823,  343, 1819,
 1144, 1813, 1177,  351, 1821, 1008,  352, 1008, 1826, 1849,
  997, 1851, 1855,  997, 1177, 1860, 1177, 1913, 1884, 1918,
 1927, 2839, 2890, 1933, 1236, 1013, 1941, 1161,  997, 1943,
 1944, 1237, 1951, 1952, 1955,  492, 1956, 1008, 1957, 1238,
 1960, 2015, 1967, 2268, 1979, 2011, 2018, 1238, 2012, 3207,
 1174, 2027, 2030, 2035, 3187, 2031, 1239, 1253, 1240, 2269,
 2033, 2039, 1177, 2068, 2050,  343, 2049,  343, 1241, 2041,
 1242, 1243, 1244, 2052,  353,  516, 2053, 1245, 1177, 1177,
 2051, 2054, 1797, 1177, 2069,  463, 3189, 2081, 2919, 2076,
 3171, 2077, 2070, 1797, 3178, 2082, 3230, 2086, 1177, 2083,
 1085, 3111, 2104, 2084,  354, 3208,  970,  652,  355, 2127,
 2109, 2115, 2128, 3211, 2131, 2132, 2133,  970, 2150,  356,
 2164, 2152, 2165, 2177, 2182,  997,  997, 2183, 1072,  997,
 2186, 2187,  997,  477,  516,  997, 1065, 2211, 2215,  516,
 2195, 2212, 2216, 2232,  997, 2238, 2270, 2242, 2243, 2244,
 2248,  512, 2262, 3231, 2257, 2230, 2259, 1072, 1741, 1085,
 2258, 2260, 3277, 2292,  512, 1065, 2275, 2296, 2286, 3316,
 2295, 2319, 2356, 2358, 2363, 3286, 2328, 2368, 1797, 2320,
 2376, 2361, 2377, 1072, 2390, 2391, 1072, 1797, 2398, 2413,
 2414, 1065, 2427,  357, 1065, 3062, 3063, 3064, 3065, 3066,
 3067, 1072,  970, 2425, 1008, 3120, 2417, 2426, 2431, 1065,
 1008,  970, 2428,  997,  357, 2432, 2445, 2438, 2448, 1008,
 2136, 1008, 1008, 1008, 2450, 2451, 1008, 1072, 1425, 1008,
 1177, 2460, 2461, 2466,  997, 1065, 2458, 2468, 2178,  358,
  997, 1008, 2479, 2511, 2512,  997,  997, 1008, 2513, 2514,
 1008, 2539,  997, 2543, 2515, 2271, 1008, 2272, 2273,  357,
 2534, 2519, 1932,  343,  997, 2551, 2516,  357, 3343, 1324,
  540, 1009, 1325,  997, 2567, 1990, 2565, 1331, 1989, 2569,
 1335, 1072, 2570,  477, 1338, 2578, 3309, 2579, 1331, 1065,
 1008, 2584, 2580, 2592, 1249, 1248, 1250,  357, 2593,  357,
 2618, 1072,  359, 2619, 1247,  477, 2643, 3383, 2602, 1065,
 1008, 1009, 1009, 2645, 1072, 1009, 2651, 2652, 2653, 2710,
  357, 2713, 1065, 2699, 2727, 2654, 2655, 2701, 3369, 2656,
 1009, 1008, 1009,  997, 2705, 2657, 2707, 1008, 2711, 2716,
 2725, 1008, 2726, 2729,  477,  357, 1836, 1008, 2730, 2163,
 2740, 2757, 2762, 2767,  997, 2761, 2768, 2759, 2769, 2771,
  997, 2770, 1009, 2772, 2773, 1008, 2774, 2777, 2781,  357,
 1008, 2776, 2790, 2791, 2793, 2812, 2815, 2824, 1003,  477,
 2828, 2813, 2832,  971, 1703, 2843, 2859, 1836, 2865, 2903,
 1836, 2892, 2878,  997, 1008, 2905, 2915,  343, 1008, 2906,
  997, 2920, 2907, 2928, 2908, 1836, 2909,  970, 2910, 2911,
 2932, 2929, 2937, 1470, 2946,  357, 2501, 2941, 2949, 1003,
 3423, 2959, 1003,  971, 1481, 2962, 2970, 2990, 2960, 1487,
 2992, 2971, 1831, 1492, 1085, 3012, 3015, 1003, 2994, 1003,
  883, 3039, 3053, 1511, 1144, 3051, 3070,  970, 1517, 1518,
 1144, 3071, 1521, 1522, 1523, 1524, 1525, 1529, 1535, 2089,
 1538, 3057, 1541, 1085, 1543, 1544, 1545, 1546, 1547, 1003,
 3075, 1550, 1551, 1552, 1553, 1554, 1555, 1556, 1557, 1558,
 1559, 1560, 1561, 1562, 1563, 1564, 1565, 3080, 2090, 1085,
 3098, 3099, 1085, 3100, 3102, 3121, 1233, 1008, 3112, 3135,
 3115, 3127, 3139, 3177, 1578, 1234, 3179, 1085, 3152, 3183,
 3192, 1590, 3191, 3193, 2091, 3202, 1596, 2092, 1235, 3141,
  997, 3200, 1603, 1604, 3212, 3224, 3229, 3225, 3261, 1009,
 1611, 3267, 2093, 1085, 3242, 1009, 1024, 3268, 3271, 3278,
 3283, 3284, 3275, 3292, 1009, 3285, 1009, 1009, 1009, 3296,
 3298, 1009, 1236, 3287, 1009, 3328, 3310, 3311, 2094, 1237,
 3319, 3335, 3336, 3344, 2487, 3351, 1009, 1238, 3373, 3374,
 3375, 3376, 1009, 1008, 3388, 1009, 3386, 1024, 1681, 3392,
 1024, 1009, 3391, 3387, 1239, 3396, 1240, 1085, 3400, 3408,
 3398, 3393, 3394, 3426, 3422, 1024, 1241, 1024, 1242, 1243,
 1244, 3428, 1304, 3429, 3435, 1245, 3439, 1085, 3441, 3443,
    1, 1248, 2095, 1131, 1133, 1009,  432, 1177, 1321,  368,
 1085, 1948, 1836, 1836, 1118, 1132,  500, 1024,  501, 1836,
 1321,  483, 2096, 1744, 1220, 1009, 1003, 1516,  451, 1726,
 1199, 1836, 1003, 1156,  911, 2097, 1246, 1225,  482, 1517,
  492, 1003,  454, 1003, 1003, 1003, 1009,  432, 1003,   86,
  432, 1003, 1009,  517,   65, 1204, 1009,  493,  538, 1611,
 1243, 1321, 1009, 1003, 1321,  432,  463,  320,  558, 1003,
  602,  567, 1003,  549,  525,  156, 1782, 1690, 1003, 1321,
 1009,  559,  396,  603,  393, 1009, 1463, 1719, 1498, 1499,
 1500, 1501, 1502, 1503, 1504, 1505, 1612, 1603, 1691,  647,
 1836, 1725,  648, 1015,  567,  617,  472,  354,  355, 1009,
    0,   19, 1003, 1009,   21,   25, 1753, 1753, 1753, 1753,
 1753, 1836, 1753,   28,   31,   40,   21, 1836,    9,   67,
   70,   72, 1003,   76,   79, 1753, 1753, 1753,   85,   88,
 1937, 1938,   97, 1940, 1015, 1942,   97, 1015,  100, 1946,
 1947, 1948, 1949, 1003,  112,  106,  103, 1953, 1954, 1003,
 1836,  115, 1015, 1003, 1015,  109, 1753,   21, 1667, 1003,
 2085, 2661, 1668, 1669, 1961, 1670, 1144, 2665, 1671, 2669,
 3153, 3054, 3154, 1672, 1024, 2396, 2696, 1003, 3052, 2582,
 1024, 1977, 1003, 2998, 1015, 3129, 2980, 1506, 1930, 1024,
 1983, 1984, 1024, 1024,  599,  997, 1024, 3114, 3380, 1024,
 2956, 1112, 1009,  499, 3213, 2530, 1003, 2506, 2969, 3294,
 1003, 1024, 1247, 1507,  603, 1312, 2577, 1024, 2981, 2805,
 1024, 3274, 3381, 3437, 3399, 2806, 1024, 3397, 3421, 2947,
 1470, 3234, 2948, 3259, 1922, 2289,  997, 2285,  979,  997,
 3097, 1376, 2476, 2477, 2026, 3413, 2028, 3414, 3334, 2029,
 2174, 2473, 3265, 3196,  997,   32,  997, 2864, 2036, 1619,
 1024, 1863, 2261, 2135, 1048, 1457, 2486, 2199, 1432, 1717,
 2548, 1836,  432,  432, 1850,  585, 2416, 1836, 1009,  432,
 1024, 2698, 2703, 3167,  993, 1320, 1321, 1321,  595,  973,
 1008, 2111, 2899, 1321, 2404, 3173, 1652,  986, 2073, 3136,
 3407, 1024, 2114, 1015, 2430,   49, 1475, 1024, 1144, 1003,
   51, 1024,   52, 3155, 3156,   55,   58, 1024, 3358, 1306,
 2566, 1595, 2025, 3276, 1055, 3205, 1151, 1753, 2118, 1130,
 1858, 1216, 2973, 1613, 1217, 1024, 1753, 3014,  986, 1702,
 1024,  986, 1753, 2542, 2336, 2748, 1753, 1331,  558, 1753,
 1335, 1015, 2117,  583, 2406, 3047,  986, 1015,  986, 1645,
  432, 3406, 1331, 2695, 1024, 1465, 1015, 2277, 1024, 1015,
 1015, 2822, 3204, 1015, 1321, 3314, 1015, 2930, 1321, 3382,
 1388,  432, 2749, 1753,  132, 1003, 3325,  432, 1015, 3289,
 1753, 1366,    0, 2901, 1015, 1321,    0, 1015, 1753,    0,
 2166, 1321,    0, 1015, 1000,    0,    0,    0, 2175,    0,
    0,    0,    0,    0,    0, 1753,    0, 1753,    0,    0,
  432,    0,    0,    0,    0,    0,    0, 1753,    0, 1753,
 1753, 1753,    0,    0, 1321,    0, 1753, 1015,    0,    0,
    0,    0,  994,    0,    0, 1000,    0,    0, 1000,    0,
    0,    0,    0,  997,    0,    0,    0, 1015,    0,  997,
    0,    0,    0, 1000,    0, 1000,    0, 1024,  997,    0,
    0,    0,  997,    0,    0,  997,    0, 1753, 1015,  432,
    0,    0,    0,  994, 1015,    0,  994,  992, 1015,    0,
  997,    0,    0, 1321, 1015, 1000,  997,    0,    0,  997,
    0,  994,    0,  994,    0,  997,    0,    0,    0,    0,
    0,    0, 1015,    0,    0,    0,    0, 1015,    0,    0,
    0,    0,    0,    0,    0,  430,    0,    0,  992,    0,
    0,  992,    0,    0,    0,    0,    0,    0,    0,  997,
    0, 1015,    0, 1024,    0, 1015,  992,    0,  992,    0,
    0,    0,    0,    0,    0,  986,    0,    0,    0,  997,
    0,  986,    0,    0,    0,    0,  430,    0,    0,  430,
    0,    0,  986,  986,  986,    0,    0,  986, 1339,    0,
  986,    0,    0,    0,  430,    0,    0,    0,    0,    0,
  997,    0,  986,    0,    0, 2306,  997,    0,  986,    0,
    0, 2312,    0,    0,    0,    0, 2315,  986,    0, 2316,
 2317, 1961,    0,    0,  997,    0, 2322,    0, 2324,    0,
    0,    0,    0,    0,    0, 2325,    0, 2326,    0,    0,
 2329, 2330, 2331, 2332,    0,    0, 2337,    0, 2338,    0,
 2339,    0, 2340,  997, 1015,    0,    0,  997, 2341, 2342,
 2343, 2344, 2345, 2346, 2347, 2348, 2349, 2350, 2351, 2352,
    0,  986, 1000, 1753,    0,    0,    0,    0, 1000, 2360,
 1771,  997,    0,    0, 2362,    0,    0, 1000, 2365,    0,
 1000, 1000,  986,    0, 1000,  266,    0, 1000,  986,    0,
    0,    0,    0,    0,    0,    0,  986,    0,  986, 1000,
  994,    0,    0,    0,    0, 1000,  994,    0, 1000,    0,
    0,  986,  997,    0, 1000,  997,  986,  994,  994,  994,
 1015,  986,  994,    0,    0,  994,  266,    0,    0,  266,
  997,    0,  997,    0,    0,    0,    0,  994,    0,    0,
    0,    0,    0,  994,  266,  992,  997,    0, 1000,  986,
    0,  992,  994,    0,    0,    0,    0,    0,    0,    0,
 1144,    0,  992,  992,  992,    0,    0,  992, 1000,    0,
  992,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  992,    0,    0,    0,    0,    0,  992, 1000,
    0,    0,    0,    0,    0, 1000,    0,  992,    0, 1000,
    0,  430,  430,    0,    0, 1000,  994,    0,  430,    0,
    0,    0,    0, 2463,    0, 1144, 1975,    0,    0,    0,
    0,    0,  997, 1000,  745,    0,    0,  994, 1000,    0,
    0,    0,    0,  994,    0, 1249, 1248, 1250,    0,    0,
    0,  994,    0,  994,    0,    0,    0,    0,  986,    0,
  748,  992, 1000,    0,    0,    0, 1000,    0,    0,    0,
    0,  994,    0,    0,    0,    0,  994,    0,    0,    0,
    0,    0,  992,    0,    0,    0,   78,  750,  992,    0,
    0,    0,    0, 1992,    0,    0, 1991,    0,  992,  430,
    0,   78,    0,    0,  994,    0,    0,    0,    0,    0,
    0,   78, 1249, 1248, 1250,    0,  992,   78,    0,    0,
  430,  992,   78,    0,    0,    0,  430,   78,    0,    0,
   78,    0,    0,    0,  986,    0,    0,    0,    0,  997,
    0,    0,    0,    0,    0,  997,    0,    0,    0,  992,
    0,    0,    0,  760,    0,    0,    0,  997,  997,  430,
  408,  997,    0,    0,  997, 1000,    0,    0,    0,  762,
    0,  266,  266,    0,    0,    0,  997,    0,  266,   62,
    0, 1961,  997,  763,    0,  765,  508,  509, 2609, 2610,
    0,  997,    0,    0,    0, 2617,    0,    0,   78,    0,
    0,  408,    0,  994,  408,  767,  768,  769,  770,  771,
  772,  773,  774,  775, 2623,    0,    0, 2622,  430,  408,
  777,  778, 2638,    0,    0, 2640,    0, 2642,   78,  782,
    0,    0,    0, 1249, 1248, 1250,    0,    0,    0,    0,
    0, 1000,    0,   78,    0,  997,    0, 1233,  992,    0,
    0,    0,    0,  386,    0,    0, 1234, 2625,    0,  266,
 2624,   78,    0,    0,    0,    0,  997,    0,    0, 1235,
    0,    0,  997,    0,    0,    0, 1249, 1248, 1250,  994,
  266,    0,  997,    0,    0,    0,  266,    0,    0,    0,
    0,    0,    0,    0,  386,    0,    0,  386,    0, 1974,
  997,    0,    0, 1236,    0,  997,    0,    0,    0, 1144,
 1237,    0,  386,    0, 1233,    0,    0,   78, 1238,  266,
   78,    0, 3021, 1234,  992, 3020,    0,    0,    0,    0,
    0,    0,    0,  997,    0, 1239, 1235, 1240,    0,    0,
 1144, 1249, 1248, 1250,    0,    0,    0, 1241,    0, 1242,
 1243, 1244,    0,    0,    0,    0, 1245,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1236,    0,    0,    0,    0,    0,    0, 1237,    0,    0,
  856,    0,  857,  858,  859, 1238,    0,    0,    0, 3023,
    0,    0,    0,    0,    0,    0,    0, 1246,    0,    0,
    0,    0, 1239,    0, 1240,    0,    0,    0, 1249, 1248,
 1250,  877,  878,    0, 1241,    0, 1242, 1243, 1244, 1692,
    0,    0,    0, 1245,    0,    0,   78,    0,    0,    0,
    0,    0,  997,    0,    0, 1233,  409,  408, 1249, 1248,
 1250,    0,    0,  409, 1234,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1235,    0, 2842,
    0, 2844,    0, 2845, 1246,    0,    0, 2850,    0,    0,
    0,    0, 2853, 2854, 2855, 2856, 2857,    0, 1233,    0,
    0, 2858,    0, 2861,    0, 2862,    0, 1234,    0,    0,
    0, 1236,    0,    0,    0, 1693,    0,    0, 1237,    0,
 1235,    0, 2863,    0,    0,    0, 1238,    0,  997,    0,
    0,    0,    0,    0, 1249, 1248, 1250,    0,    0,    0,
    0,    0,    0, 1239,  409, 1240,    0,    0,    0,  386,
  386,    0,    0,    0, 1236, 1241,  386, 1242, 1243, 1244,
 1945, 1237, 1144, 1233, 1245,  409,    0,    0,    0, 1238,
    0,  409, 1234,    0,    0,    0,    0,    0, 2914, 1249,
 1248, 1250,    0,    0,    0, 1235, 1239,    0, 1240,    0,
    0, 2923, 1144,    0,    0,    0,    0,    0, 1241,    0,
 1242, 1243, 1244, 1247,  409, 1246,    0, 1245,    0, 2936,
    0,    0,    0,    0,    0,    0,    0, 2939, 2940, 1236,
    0, 1969,    0,    0,    0,    0, 1237,    0,    0,    0,
 1233,    0,    0,  410, 1238,    0,    0,  386,    0, 1234,
 1249, 1248, 1250,    0,    0,    0,    0,    0, 1246, 2963,
    0, 1239, 1235, 1240,    0,    0,    0,    0,  386,    0,
 1233,    0,    0, 1241,  386, 1242, 1243, 1244,    0, 1234,
 1247,    0, 1245,    0,  410,    0,    0,  410,    0,    0,
 3022,    0, 1235,    0,    0,    0, 1236,    0,    0,    0,
 1970,    0,  410, 1237,    0,    0,    0,  386,    0,    0,
    0, 1238,    0, 1249, 1248, 1250,    0,    0,    0, 1249,
 1248, 1250,    0, 1246,    0,    0, 1236,    0, 1239,    0,
 1240,    0,    0, 1237,    0,    0,    0,    0, 1961, 2845,
 1241, 1238, 1242, 1243, 1244,    0, 1233,    0,    0, 1245,
    0,    0,    0,    0,    0, 1234,    0,    0, 1239,    0,
 1240,    0,    0,    0,    0,    0,    0,    0, 1235,    0,
 1241, 3041, 1242, 1243, 1244,    0,    0,    0,    0, 1245,
    0,    0,    0, 3050,    0,    0,    0,    0,    0,    0,
 1246, 1233,    0,    0,    0,    0,    0,    0,    0,    0,
 1234, 1247, 1236,    0, 3068, 3069,    0,    0,    0, 1237,
    0,    0,    0, 1235,    0,    0,    0, 1238,    0,    0,
 1246,    0,    0,    0,    0, 3083, 1765,    0,    0,    0,
    0,    0,    0,    0, 1239,    0, 1240,    0,    0,    0,
    0,    0,    0,    0, 1247,    0, 1241, 1236, 1242, 1243,
 1244,    0, 1233,    0, 1237, 1245,    0,    0,    0,    0,
    0, 1234, 1238,    0,    0,    0, 1765, 1765,    0, 1765,
 1765, 1765, 1774,    0, 1235,    0,    0,    0,    0, 1239,
    0, 1240,    0, 3128, 1765, 1765,    0,    0,    0, 1765,
    0, 1241,    0, 1242, 1243, 1244, 1246,    0,    0,    0,
 1245,    0,    0, 1961,    0,    0,    0,    0, 1236, 1247,
    0, 3142,    0, 3143,    0, 1237,    0,    0,    0,  412,
  410, 1233,    0, 1238, 1234,    0,  412,    0,    0,    0,
 1234,    0,    0,    0,    0,    0,    0, 1235,    0,    0,
 1239, 1246, 1240, 1235,    0,    0,    0,    0,    0,    0,
    0,    0, 1241,    0, 1242, 1243, 1244,    0,    0,    0,
    0, 1245,    0,    0,    0,    0, 2923,    0,    0,    0,
    0, 1236,    0,    0,    0,    0, 1247, 1236, 1237,    0,
    0,    0,    0,    0, 1237,    0, 1238,    0,    0,    0,
    0,    0, 1238,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1246, 1239,    0, 1240, 1247,  412,    0, 1239,
    0, 1240,    0,    0,    0, 1241,    0, 1242, 1243, 1244,
    0, 1241,    0, 1242, 1243, 1244,    0,    0,  412,    0,
 1245,    0, 1961,    0,  412,    0,    0, 3235, 3236, 3237,
 3238, 3239, 3240, 3241,    0,    0,    0,    0,    0,    0,
    0,    0, 3244, 3245, 3246, 3247, 3248, 3249, 3250,    0,
    0,    0,    0,    0,    0, 1246,    0,  412,    0,    0,
    0, 1246,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1247, 1765,    0, 1765,    0,    0,    0,    0,
 1765, 1765,    0, 1765, 1765, 1765,    0,    0,    0,    0,
 1765,    0,    0,    0,    0, 1765, 1765,    0, 1765,    0,
 1765, 1765,    0, 1765,    0,    0, 1765, 1765, 1765,    0,
    0,    0,    0, 1765,    0, 1765, 1765, 1247,    0,    0,
 1765,    0, 1765,    0, 1765, 1765,    0,    0, 1765,    0,
    0, 1765,    0, 1765,    0, 1765, 1765,    0, 1765, 1765,
 1765,    0, 1765, 1765, 1765,    0,    0,    0, 1765,    0,
 1765, 1765, 1765,    0,    0,    0, 1765,    0,    0,    0,
 1765,    0, 1765, 1765, 1765, 1765,    0, 1765,    0, 1765,
 1765,    0, 1765, 1765, 1765,    0, 1765,    0, 1247,    0,
 1765,    0,    0,    0, 1765, 3337, 1765, 3341, 1765,    0,
 1765, 1765, 1765, 1765, 1765,    0, 1765, 1765, 1765,    0,
    0,    0, 1765, 1144, 1765, 1765,    0,    0, 1765, 1765,
 1765,    0,    0, 1765, 3367, 1765, 3370, 3372, 1765, 1765,
 1765, 1765,    0, 1765,    0, 1765, 1765, 1765, 1765, 1765,
 1765, 1765, 1765, 1144,    0,    0, 1765,    0, 1765, 1765,
    0, 1247, 1765,    0,    0,    0,    0, 1247,    0, 1765,
    0, 1765,    0, 1765, 1765, 1765, 1765, 1765, 1765, 1765,
 1765, 1765,    0, 1765, 1765, 1765, 1765,    0, 1765, 1765,
    0, 3367, 3415, 3416,    0,    0, 1765, 1765, 1765, 1765,
 1765, 1765, 1765, 1765, 1765, 1765, 1765, 1765, 1765,    0,
 1765, 1765, 1765, 1765, 1765,    0, 1765, 1765, 1765, 1765,
 1765, 1765, 1765, 1765,    0,    0, 1765, 1765, 1765, 1765,
 1765, 1765, 1765,    0,    0, 1765, 1765, 1765, 1765, 1765,
 1765, 1765, 1765, 1765,    0, 1765,    0, 1765, 1765, 1765,
    0, 1765, 1765,    0, 1765, 1765, 1765, 1765, 1765, 1765,
 1765, 1765, 1765, 1765, 1765, 1765, 1765, 1765, 1765, 1765,
 1765, 1765, 1765, 1765, 1765, 1765,    0, 1765, 1765, 1765,
 1765, 1765, 1765,    0, 1765, 1765, 1765, 1765,    0, 1765,
    0, 1765, 1765, 1765, 1765, 1765, 1765, 1765, 1765, 1765,
 1765, 1765, 1765, 1765, 1765, 1765, 1765, 1765, 1765,    0,
 1765, 1765, 1765, 1765,    0, 1765, 1765, 1765, 1765, 1765,
    0, 1765, 1765, 1765, 1765, 1765, 1765, 1765, 1765, 1765,
 1765, 1765, 1765, 1765,    0, 1765, 1765, 1765, 1765, 1765,
 1765,    0, 1765, 1765, 1765, 1765, 1765, 1765, 1765, 1765,
    0, 1765, 1765, 1765, 1765,    0, 1765, 1765, 1765, 1765,
 1765, 1765,    0,    0, 1765, 1765, 1765, 1765, 1765, 1765,
 1765, 1765, 1765, 1765, 1511, 1765, 1765, 1765, 1765, 1765,
 1765, 1765, 1765, 1765, 1765, 1765,    0, 1765, 1765, 1765,
 1765, 1765, 1765, 1765, 1765, 1765, 1765, 1765, 1765, 1765,
 1765, 1765, 1765, 1765, 1765, 1765,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1511, 1511, 1511, 1511, 1511,
    0, 1511,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1511, 1511, 1511, 1511, 2585,    0,    0,
 1061,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   79,    0, 2586,    0,    0,    0, 1062,    0, 1063,    0,
    0,    0,    0,    0,    0,   79,    0, 1511,    0,    0,
    0,    0,    0,    0,    0,   79,    0,    0,    0,    0,
    0,   79,  698,    0,    0,    0,   79,    0,    0,    0,
    0,   79,  699,    0,   79,  700, 1064,    0,    0,    0,
    0,    0, 1065, 1066, 1067,    0, 1068, 1069, 1070,    0,
 1071,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1072,    0, 1073,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   63, 2995,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1074,    0,    0,    0,    0,
    0,    0,   79,  701,    0,    0,    0,    0,    0,    0,
    0, 1075,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   79, 1076,    0,    0,    0,  702,    0,    0,
    0,    0,  703,    0,    0,    0,    0,   79,  704,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   79,    0, 1077, 1078,    0,
    0, 1511, 1511, 1511,    0,    0, 1511,    0, 1511, 1511,
    0,    0, 1511, 1511, 1079, 1511,    0,    0,    0,    0,
 1511, 1511,    0, 1511, 1511, 1511, 1511, 1511, 1511,    0,
    0, 1511,    0,    0, 1511,    0,    0,    0,    0,    0,
    0, 1511,    0, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
 1511,   79,  705, 1511,   79,    0, 1511,    0, 1511, 1511,
    0,    0, 1511, 1511, 1511,    0, 1511, 1511, 1511, 1511,
 1511, 1511, 1511,    0,    0,    0, 1511, 1511, 1511, 1511,
 1511,    0,    0,    0, 1511,    0,    0,    0,    0,    0,
    0,    0, 1511, 1511, 1511, 1511, 1511, 1511,  706,    0,
    0, 1511, 1511,    0, 1511,    0, 1511,    0, 1511, 1511,
 1511,    0, 1511,    0, 1511, 1511, 1511,    0, 1511, 1511,
 1511, 1511, 1511,    0, 1511, 1511,    0,    0,    0, 1511,
 1511,  428, 1511, 1511,    0, 1511, 1511, 1511, 1511,    0,
    0, 1511,  707, 1511,    0, 1511, 1511, 1511, 1511, 1511,
    0, 1511,    0, 1511,    0, 1511, 1511, 1511, 1511, 1511,
   79,  708, 1511, 1511, 1511,    0, 1511, 1511, 1511,    0,
    0,    0,  428, 1080,    0,  428,    0, 1511, 1511, 1511,
    0, 1511, 1511, 1511,    0, 1511,    0,    0,    0, 1511,
  428, 1511, 1511, 1511, 1511,    0, 1511,    0, 1511, 1511,
 1511, 1511, 1511, 1511, 1511, 1511,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1511, 1511, 1971, 1511, 1511,
 1511,    0,    0,    0,    0, 1511, 1511, 1511, 1511, 1511,
    0, 1511,    0,    0, 1511, 1511, 1249, 1248, 1250, 1511,
 1511, 1972,    0, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
 1511, 1511,    0, 1511,    0,    0,    0,    0,    0,    0,
 1249, 1248, 1250, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
 1511, 1511, 1511, 1511,    0, 1511, 1511, 1511, 1511, 1511,
 1511,    0, 1511, 1511, 1511, 1511,    0, 1511,    0, 1511,
 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
 1511, 1511, 1511, 1511, 1511, 1511, 1511,    0, 1511, 1511,
 1511, 1511,    0, 1511, 1511, 1511, 1511, 1511,    0, 1511,
 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,    0,
 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1513, 1511,
 1511, 1511, 1511,    0, 1511, 1511, 1511, 1511, 1511, 1511,
    0,    0, 1511, 1511, 1511, 1511, 1511, 1511, 1511, 1511,
 1511,    0,    0,    0,    0,    0, 1511,    0, 1511, 1511,
 1511, 1511, 1511, 1511,    0, 1511,    0,    0,    0, 1513,
 1513, 1513, 1513, 1513,    0, 1513,    0,  428,  428,    0,
    0,    0,    0,    0,  428,    0,    0, 1513, 1513, 1513,
 1513,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1233,    0,
    0,    0,    0,    0,    0,    0,    0, 1234,    0,    0,
    0, 1513,    0,    0,    0,    0,    0,    0,    0,    0,
 1235,    0, 1233,    0,    0,    0,    0,    0,    0,    0,
    0, 1234,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1235,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1236,  428,    0,    0,    0,    0,
    0, 1237,    0,    0,    0,    0,    0,    0,    0, 1238,
    0,    0,    0,    0,    0,    0,  428,    0, 1236,    0,
    0,    0,  428,    0,    0, 1237, 1239,    0, 1240,    0,
    0,    0,    0, 1238,    0,    0,    0,    0, 1241,    0,
 1242, 1243, 1244,    0,    0,    0,    0, 1245,    0,    0,
 1239,    0, 1240,    0,    0,  428,    0,    0,    0,    0,
    0,    0, 1241,    0, 1242, 1243, 1244,    0,    0,    0,
    0, 1245,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1246,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1246,    0,    0, 1513, 1513, 1513,    0,    0,
 1513,    0, 1513, 1513,    0,    0, 1513, 1513,    0, 1513,
    0,    0,    0,    0, 1513, 1513,    0, 1513, 1513, 1513,
 1513, 1513, 1513,    0,    0, 1513,    0,    0, 1513,    0,
    0,    0,    0,    0,    0, 1513,    0, 1513, 1513, 1513,
 1513, 1513, 1513, 1513, 1513,    0,    0, 1513,    0,    0,
 1513,    0, 1513, 1513,    0,    0, 1513, 1513, 1513,    0,
 1513, 1513, 1513, 1513, 1513, 1513, 1513,    0,    0,    0,
 1513, 1513, 1513, 1513, 1513,    0,    0,    0, 1513,    0,
    0,    0,    0,    0,    0,    0, 1513, 1513, 1513, 1513,
 1513, 1513,    0,    0,    0, 1513, 1513,    0, 1513,    0,
 1513,    0, 1513, 1513, 1513,    0, 1513,    0, 1513, 1513,
 1513,    0, 1513, 1513, 1513, 1513, 1513,    0, 1513, 1513,
    0,    0,    0, 1513, 1513,    0, 1513, 1513,    0, 1513,
 1513, 1513, 1513,    0,    0, 1513,    0, 1513,    0, 1513,
 1513, 1513, 1513, 1513,    0, 1513,    0, 1513,    0, 1513,
 1513, 1513, 1513, 1513, 1247,    0, 1513, 1513, 1513,    0,
 1513, 1513, 1513,    0,    0,    0,    0,    0,    0,    0,
    0, 1513, 1513, 1513,    0, 1513, 1513, 1513, 1247, 1513,
    0,    0,    0, 1513,    0, 1513, 1513, 1513, 1513,    0,
 1513,    0, 1513, 1513, 1513, 1513, 1513, 1513, 1513, 1513,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1513,
 1513, 1973, 1513, 1513, 1513,    0,    0,    0,    0, 1513,
 1513, 1513, 1513, 1513,    0, 1513,    0,    0, 1513, 1513,
 1249, 1248, 1250, 1513, 1513, 1986,    0, 1513, 1513, 1513,
 1513, 1513, 1513, 1513, 1513, 1513,    0, 1513,    0,    0,
    0,    0,    0,    0, 1249, 1248, 1250, 1513, 1513, 1513,
 1513, 1513, 1513, 1513, 1513, 1513, 1513, 1513, 1513, 1513,
 1513, 1513, 1513, 1513, 1513, 1513, 1513, 1513,    0, 1513,
 1513, 1513, 1513, 1513, 1513,    0, 1513, 1513, 1513, 1513,
    0, 1513,    0, 1513, 1513, 1513, 1513, 1513, 1513, 1513,
 1513, 1513, 1513, 1513, 1513, 1513, 1513, 1513, 1513, 1513,
 1513,    0, 1513, 1513, 1513, 1513,    0, 1513, 1513, 1513,
 1513, 1513,    0, 1513, 1513, 1513, 1513, 1513, 1513, 1513,
 1513, 1513, 1513, 1513, 1513, 1513, 1513, 1513, 1513, 1513,
 1513, 1513, 1513,    0, 1513, 1513, 1513, 1513, 1513, 1513,
 1513, 1513, 1775, 1513, 1513, 1513, 1513,    0, 1513, 1513,
 1513, 1513, 1513, 1513,    0,    0, 1513, 1513, 1513, 1513,
 1513, 1513, 1513, 1513, 1513,    0,    0,    0,    0,    0,
 1513,    0, 1513, 1513, 1513, 1513, 1513, 1513,    0, 1513,
    0,    1, 1748, 1775, 1775, 1775, 1775, 1775, 1775, 1775,
    0,    0,    0,    0,    0,    0,    0,    0,    2,    0,
 1775, 1775, 1775, 1775, 1775,    0,    3,    0,    0,    0,
    0,    0,    0,    0,    4,    0,    5,    0,    0,    0,
    0,    6, 1233,    0,    0,    0,    0,    7,    0,    0,
    0, 1234,    0, 1775,    0, 1775,    0,    0,    0,    0,
    0,    8,    0,    0, 1235,    0, 1233,    0,    0,    0,
    9,    0,    0,    0,    0, 1234,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1235,    0,
    0,    0,    0,    0,    0,   10,    0,    0, 1236,    0,
    0,    0,    0,    0,    0, 1237,    0,    0,    0,    0,
    0,    0,    0, 1238,    0,    0,    0,    0,    0,    0,
    0,    0, 1236,    0,    0,    0,    0,    0,    0, 1237,
 1239,    0, 1240,    0,    0,    0,   11, 1238,   12,    0,
    0,   13, 1241,    0, 1242, 1243, 1244,    0,    0,    0,
    0, 1245,    0,    0, 1239,    0, 1240,    0,    0,    0,
    0,    0,    0,    0,    0,   14, 1241,    0, 1242, 1243,
 1244,    0,    0,    0,    0, 1245,    0,   15,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1246,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   16,    0,    0, 1246,    0,    0, 1775,
    0, 1775,    0,    0, 1775,    0, 1775, 1775,   17,   18,
 1775, 1775,    0, 1775,    0,    0,    0,    0,    0, 1775,
    0, 1775, 1775, 1775, 1775,    0, 1775,    0,    0, 1775,
   19,    0, 1775,    0,    0,    0,    0,    0,    0, 1775,
    0, 1775, 1775,    0, 1775, 1775, 1775, 1775, 1775,    0,
    0, 1775,    0,    0, 1775,    0, 1775, 1775,    0,    0,
 1775, 1775, 1775,    0, 1775, 1775, 1775, 1775, 1775, 1775,
 1775,    0,    0,    0, 1775, 1775, 1775, 1775, 1775,    0,
    0,    0, 1775,    0,    0,    0,    0,    0,    0,    0,
 1775, 1775, 1775, 1775, 1775, 1775,    0,    0,    0, 1775,
 1775,    0, 1775,    0, 1775,    0, 1775, 1775, 1775,    0,
 1775,    0, 1775, 1775, 1775,    0, 1775, 1775, 1775, 1775,
 1775,    0, 1775, 1775,    0,    0,    0,    0, 1775,    0,
 1775, 1775,    0,    0, 1775, 1775, 1775,    0,    0, 1775,
    0, 1775,    0,    0, 1775, 1775, 1775, 1775,    0, 1775,
    0, 1775,    0, 1775, 1775, 1775, 1775, 1775, 1247,    0,
 1775, 1775, 1775,    0, 1775, 1775,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1775, 1775, 1775,    0, 1775,
 1775, 1775, 1247, 1775,    0,    0,    0, 1775,    0, 1775,
 1775, 1775, 1775,    0, 1775,    0, 1775, 1775, 1775, 1775,
 1775, 1775, 1775, 1775,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1775, 1775, 1988, 1775, 1775, 1775,    0,
    0,    0,    0, 1775, 1775, 1775, 1775, 1775,    0, 1775,
    0,    0, 1775, 1775, 1249, 1248, 1250, 1775, 1775, 1993,
    0, 1775, 1775, 1775, 1775, 1775, 1775, 1775, 1775, 1775,
    0, 1775,    0,    0,    0,    0,    0,    0, 1249, 1248,
 1250, 1775, 1775, 1775, 1775, 1775, 1775, 1775, 1775, 1775,
 1775, 1775, 1775, 1775, 1775, 1775, 1775, 1775, 1775, 1775,
 1775, 1775,    0, 1775, 1775, 1775, 1775, 1775, 1775,    0,
 1775, 1775, 1775, 1775,    0, 1775,    0, 1775, 1775, 1775,
 1775, 1775, 1775, 1775, 1775, 1775, 1775, 1775, 1775, 1775,
 1775, 1775, 1775, 1775, 1775,    0, 1775, 1775, 1775, 1775,
    0, 1775, 1775, 1775, 1775, 1775,    0, 1775, 1775, 1775,
 1775, 1775, 1775, 1775, 1775, 1775, 1775, 1775, 1775, 1775,
 1775, 1775, 1775, 1775, 1775, 1775, 1775, 1775, 1775, 1775,
 1775, 1775, 1775, 1775, 1775, 1775, 1812, 1775, 1775, 1775,
 1775,    0, 1775, 1775, 1775, 1775, 1775, 1775,    0,    0,
 1775, 1775, 1775, 1775, 1775, 1775, 1775, 1775, 1775,    0,
    0,    0,    0,    0, 1775,    0, 1775, 1775, 1775, 1775,
 1775, 1775,    0, 1775,    0,    0, 1625, 1812, 1812, 1812,
 1812, 1812, 1812, 1812,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1812, 1812, 1812, 1812, 1812,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1233,    0,    0,    0,
    0,    0,    0,    0,    0, 1234,    0, 1812,    0, 1812,
    0,    0,    0,    0,    0,    0,    0,    0, 1235,    0,
 1233,    0,    0,    0,    0,    0,    0,    0,    0, 1234,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1235,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1236,    0,    0,    0,    0,    0,    0, 1237,
    0,    0,    0,    0,    0,    0,    0, 1238,    0,    0,
    0,    0,    0,    0,    0,    0, 1236,    0,    0,    0,
    0,    0,    0, 1237, 1239,    0, 1240,    0,    0,    0,
    0, 1238,    0,    0,    0,    0, 1241,    0, 1242, 1243,
 1244,    0,    0,    0,    0, 1245,    0,    0, 1239,    0,
 1240,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1241,    0, 1242, 1243, 1244,    0,    0,    0,    0, 1245,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1246,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1246,    0,    0, 1812,    0, 1812,    0,    0, 1812,    0,
 1812, 1812,    0,    0, 1812, 1812,    0, 1812,    0,    0,
    0,    0,    0, 1812,    0, 1812, 1812, 1812, 1812,    0,
 1812,    0,    0, 1812,    0,    0, 1812,    0,    0,    0,
    0,    0,    0, 1812,    0, 1812, 1812,    0, 1812, 1812,
 1812, 1812, 1812,    0,    0, 1812,    0,    0, 1812,    0,
 1812, 1812,    0,    0, 1812, 1812, 1812,    0, 1812, 1812,
 1812, 1812, 1812, 1812, 1812,    0,    0,    0, 1812, 1812,
 1812, 1812, 1812,    0,    0,    0, 1812,    0,    0,    0,
    0,    0,    0,    0, 1812, 1812, 1812, 1812, 1812, 1812,
    0,    0,    0, 1812, 1812,    0, 1812,    0, 1812,    0,
 1812, 1812, 1812,    0, 1812,    0, 1812, 1812, 1812,    0,
 1812, 1812, 1812, 1812, 1812,    0, 1812, 1812,    0,    0,
    0,    0, 1812,    0, 1812, 1812,    0,    0, 1812, 1812,
 1812,    0,    0, 1812,    0, 1812,    0,    0, 1812, 1812,
 1812, 1812,    0, 1812,    0, 1812,    0, 1812, 1812, 1812,
 1812, 1812, 1247,    0, 1812, 1812, 1812,    0, 1812, 1812,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1812,
 1812, 1812,    0, 1812, 1812, 1812, 1247, 1812,    0,    0,
    0, 1812,    0, 1812, 1812, 1812, 1812,    0, 1812,    0,
 1812, 1812, 1812, 1812, 1812, 1812, 1812, 1812,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1812, 1812, 1994,
 1812, 1812, 1812,    0,    0,    0,    0, 1812, 1812, 1812,
 1812, 1812,    0, 1812,    0,    0, 1812, 1812, 1249, 1248,
 1250, 1812, 1812, 1995,    0, 1812, 1812, 1812, 1812, 1812,
 1812, 1812, 1812, 1812,    0, 1812,    0,    0,    0,    0,
    0,    0, 1249, 1248, 1250, 1812, 1812, 1812, 1812, 1812,
 1812, 1812, 1812, 1812, 1812, 1812, 1812, 1812, 1812, 1812,
 1812, 1812, 1812, 1812, 1812, 1812,    0, 1812, 1812, 1812,
 1812, 1812, 1812,    0, 1812, 1812, 1812, 1812,    0, 1812,
    0, 1812, 1812, 1812, 1812, 1812, 1812, 1812, 1812, 1812,
 1812, 1812, 1812, 1812, 1812, 1812, 1812, 1812, 1812,    0,
 1812, 1812, 1812, 1812,    0, 1812, 1812, 1812, 1812, 1812,
    0, 1812, 1812, 1812, 1812, 1812, 1812, 1812, 1812, 1812,
 1812, 1812, 1812, 1812, 1812, 1812, 1812, 1812, 1812, 1812,
 1812, 1812, 1812, 1812, 1812, 1812, 1812, 1812, 1812, 1812,
 1814, 1812, 1812, 1812, 1812,    0, 1812, 1812, 1812, 1812,
 1812, 1812,    0,    0, 1812, 1812, 1812, 1812, 1812, 1812,
 1812, 1812, 1812,    0,    0,    0,    0,    0, 1812,    0,
 1812, 1812, 1812, 1812, 1812, 1812,    0, 1812,    0,    0,
 1626, 1814, 1814, 1814, 1814, 1814, 1814, 1814,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1814, 1814,
 1814, 1814, 1814,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1233,    0,    0,    0,    0,    0,    0,    0,    0, 1234,
    0, 1814,    0, 1814,    0,    0,    0,    0,    0,    0,
    0,    0, 1235,    0, 1233,    0,    0,    0,    0,    0,
    0,    0,    0, 1234,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1235,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1236,    0,    0,    0,
    0,    0,    0, 1237,    0,    0,    0,    0,    0,    0,
    0, 1238,    0,    0,    0,    0,    0,    0,    0,    0,
 1236,    0,    0,    0,    0,    0,    0, 1237, 1239,    0,
 1240,    0,    0,    0,    0, 1238,    0,    0,    0,    0,
 1241,    0, 1242, 1243, 1244,    0,    0,    0,    0, 1245,
    0,    0, 1239,    0, 1240,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1241,    0, 1242, 1243, 1244,    0,
    0,    0,    0, 1245,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1246,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1246,    0,    0, 1814,    0, 1814,
    0,    0, 1814,    0, 1814, 1814,    0,    0, 1814, 1814,
    0, 1814,    0,    0,    0,    0,    0, 1814,    0, 1814,
 1814, 1814, 1814,    0, 1814,    0,    0, 1814,    0,    0,
 1814,    0,    0,    0,    0,    0,    0, 1814,    0, 1814,
 1814,    0, 1814, 1814, 1814, 1814, 1814,    0,    0, 1814,
    0,    0, 1814,    0, 1814, 1814,    0,    0, 1814, 1814,
 1814,    0, 1814, 1814, 1814, 1814, 1814, 1814, 1814,    0,
    0,    0, 1814, 1814, 1814, 1814, 1814,    0,    0,    0,
 1814,    0,    0,    0,    0,    0,    0,    0, 1814, 1814,
 1814, 1814, 1814, 1814,    0,    0,    0, 1814, 1814,    0,
 1814,    0, 1814,    0, 1814, 1814, 1814,    0, 1814,    0,
 1814, 1814, 1814,    0, 1814, 1814, 1814, 1814, 1814,    0,
 1814, 1814,    0,    0,    0,    0, 1814,    0, 1814, 1814,
    0,    0, 1814, 1814, 1814,    0,    0, 1814,    0, 1814,
    0,    0, 1814, 1814, 1814, 1814,    0, 1814,    0, 1814,
    0, 1814, 1814, 1814, 1814, 1814, 1247,    0, 1814, 1814,
 1814,    0, 1814, 1814,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1814, 1814, 1814,    0, 1814, 1814, 1814,
 1247, 1814,    0,    0,    0, 1814,    0, 1814, 1814, 1814,
 1814,    0, 1814,    0, 1814, 1814, 1814, 1814, 1814, 1814,
 1814, 1814,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1814, 1814, 1996, 1814, 1814, 1814,    0,    0,    0,
    0, 1814, 1814, 1814, 1814, 1814,    0, 1814,    0,    0,
 1814, 1814, 1249, 1248, 1250, 1814, 1814, 2298,    0, 1814,
 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,    0, 1814,
    0,    0,    0,    0,    0,    0, 1249, 1248, 1250, 1814,
 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    0, 1814, 1814, 1814, 1814, 1814, 1814,    0, 1814, 1814,
 1814, 1814,    0, 1814,    0, 1814, 1814, 1814, 1814, 1814,
 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
 1814, 1814, 1814,    0, 1814, 1814, 1814, 1814,    0, 1814,
 1814, 1814, 1814, 1814,    0, 1814, 1814, 1814, 1814, 1814,
 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
 1814, 1814, 1814, 1814, 1816, 1814, 1814, 1814, 1814,    0,
 1814, 1814, 1814, 1814, 1814, 1814,    0,    0, 1814, 1814,
 1814, 1814, 1814, 1814, 1814, 1814, 1814,    0,    0,    0,
    0,    0, 1814,    0, 1814, 1814, 1814, 1814, 1814, 1814,
    0, 1814,    0,    0, 1628, 1816, 1816, 1816, 1816, 1816,
 1816, 1816,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1816, 1816, 1816, 1816, 1816,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1233,    0,    0,    0,    0,    0,
    0,    0,    0, 1234,    0, 1816,    0, 1816,    0,    0,
    0,    0,    0,    0,    0,    0, 1235,    0, 1233,    0,
    0,    0,    0,    0,    0,    0,    0, 1234,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1235,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1236,    0,    0,    0,    0,    0,    0, 1237,    0,    0,
    0,    0,    0,    0,    0, 1238,    0,    0,    0,    0,
    0,    0,    0,    0, 1236,    0,    0,    0,    0,    0,
    0, 1237, 1239,    0, 1240,    0,    0,    0,    0, 1238,
    0,    0,    0,    0, 1241,    0, 1242, 1243, 1244,    0,
    0,    0,    0, 1245,    0,    0, 1239,    0, 1240,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1241,    0,
 1242, 1243, 1244,    0,    0,    0,    0, 1245,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1246,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1246,    0,
    0, 1816,    0, 1816,    0,    0, 1816,    0, 1816, 1816,
    0,    0, 1816, 1816,    0, 1816,    0,    0,    0,    0,
    0, 1816,    0, 1816, 1816, 1816, 1816,    0, 1816,    0,
    0, 1816,    0,    0, 1816,    0,    0,    0,    0,    0,
    0, 1816,    0, 1816, 1816,    0, 1816, 1816, 1816, 1816,
 1816,    0,    0, 1816,    0,    0, 1816,    0, 1816, 1816,
    0,    0, 1816, 1816, 1816,    0, 1816, 1816, 1816, 1816,
 1816, 1816, 1816,    0,    0,    0, 1816, 1816, 1816, 1816,
 1816,    0,    0,    0, 1816,    0,    0,    0,    0,    0,
    0,    0, 1816, 1816, 1816, 1816, 1816, 1816,    0,    0,
    0, 1816, 1816,    0, 1816,    0, 1816,    0, 1816, 1816,
 1816,    0, 1816,    0, 1816, 1816, 1816,    0, 1816, 1816,
 1816, 1816, 1816,    0, 1816, 1816,    0,    0,    0,    0,
 1816,    0, 1816, 1816,    0,    0, 1816, 1816, 1816,    0,
    0, 1816,    0, 1816,    0,    0, 1816, 1816, 1816, 1816,
    0, 1816,    0, 1816,    0, 1816, 1816, 1816, 1816, 1816,
 1247,    0, 1816, 1816, 1816,    0, 1816, 1816,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1816, 1816, 1816,
    0, 1816, 1816, 1816, 1247, 1816,    0,    0,    0, 1816,
    0, 1816, 1816, 1816, 1816,    0, 1816,    0, 1816, 1816,
 1816, 1816, 1816, 1816, 1816, 1816,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1816, 1816, 2299, 1816, 1816,
 1816,    0,    0,    0,    0, 1816, 1816, 1816, 1816, 1816,
    0, 1816,    0,    0, 1816, 1816, 1249, 1248, 1250, 1816,
 1816, 2304,    0, 1816, 1816, 1816, 1816, 1816, 1816, 1816,
 1816, 1816,    0, 1816,    0,    0,    0,    0,    0,    0,
 1249, 1248, 1250, 1816, 1816, 1816, 1816, 1816, 1816, 1816,
 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816,
 1816, 1816, 1816, 1816,    0, 1816, 1816, 1816, 1816, 1816,
 1816,    0, 1816, 1816, 1816, 1816,    0, 1816,    0, 1816,
 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816,
 1816, 1816, 1816, 1816, 1816, 1816, 1816,    0, 1816, 1816,
 1816, 1816,    0, 1816, 1816, 1816, 1816, 1816,    0, 1816,
 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816,
 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816,
 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1817, 1816,
 1816, 1816, 1816,    0, 1816, 1816, 1816, 1816, 1816, 1816,
    0,    0, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816,
 1816,    0,    0,    0,    0,    0, 1816,    0, 1816, 1816,
 1816, 1816, 1816, 1816,    0, 1816,    0,    0, 1629, 1817,
 1817, 1817, 1817, 1817, 1817, 1817,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1817, 1817, 1817, 1817,
 1817,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1233,    0,
    0,    0,    0,    0,    0,    0,    0, 1234,    0, 1817,
    0, 1817,    0,    0,    0,    0,    0,    0,    0,    0,
 1235,    0, 1233,    0,    0,    0,    0,    0,    0,    0,
    0, 1234,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1235,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1236,    0,    0,    0,    0,    0,
    0, 1237,    0,    0,    0,    0,    0,    0,    0, 1238,
    0,    0,    0,    0,    0,    0,    0,    0, 1236,    0,
    0,    0,    0,    0,    0, 1237, 1239,    0, 1240,    0,
    0,    0,    0, 1238,    0,    0,    0,    0, 1241,    0,
 1242, 1243, 1244,    0,    0,    0,    0, 1245,    0,    0,
 1239,    0, 1240,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1241,    0, 1242, 1243, 1244,    0,    0,    0,
    0, 1245,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1246,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1246,    0,    0, 1817,    0, 1817,    0,    0,
 1817,    0, 1817, 1817,    0,    0, 1817, 1817,    0, 1817,
    0,    0,    0,    0,    0, 1817,    0, 1817, 1817, 1817,
 1817,    0, 1817,    0,    0, 1817,    0,    0, 1817,    0,
    0,    0,    0,    0,    0, 1817,    0, 1817, 1817,    0,
 1817, 1817, 1817, 1817, 1817,    0,    0, 1817,    0,    0,
 1817,    0, 1817, 1817,    0,    0, 1817, 1817, 1817,    0,
 1817, 1817, 1817, 1817, 1817, 1817, 1817,    0,    0,    0,
 1817, 1817, 1817, 1817, 1817,    0,    0,    0, 1817,    0,
    0,    0,    0,    0,    0,    0, 1817, 1817, 1817, 1817,
 1817, 1817,    0,    0,    0, 1817, 1817,    0, 1817,    0,
 1817,    0, 1817, 1817, 1817,    0, 1817,    0, 1817, 1817,
 1817,    0, 1817, 1817, 1817, 1817, 1817,    0, 1817, 1817,
    0,    0,    0,    0, 1817,    0, 1817, 1817,    0,    0,
 1817, 1817, 1817,    0,    0, 1817,    0, 1817,    0,    0,
 1817, 1817, 1817, 1817,    0, 1817,    0, 1817,    0, 1817,
 1817, 1817, 1817, 1817, 1247,    0, 1817, 1817, 1817,    0,
 1817, 1817,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1817, 1817, 1817,    0, 1817, 1817, 1817, 1247, 1817,
    0,    0,    0, 1817,    0, 1817, 1817, 1817, 1817,    0,
 1817,    0, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1817,
 1817, 2305, 1817, 1817, 1817,    0,    0,    0,    0, 1817,
 1817, 1817, 1817, 1817,    0, 1817,    0,    0, 1817, 1817,
 1249, 1248, 1250, 1817, 1817, 2307,    0, 1817, 1817, 1817,
 1817, 1817, 1817, 1817, 1817, 1817,    0, 1817,    0,    0,
    0,    0,    0,    0, 1249, 1248, 1250, 1817, 1817, 1817,
 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817,
 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817,    0, 1817,
 1817, 1817, 1817, 1817, 1817,    0, 1817, 1817, 1817, 1817,
    0, 1817,    0, 1817, 1817, 1817, 1817, 1817, 1817, 1817,
 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817,
 1817,    0, 1817, 1817, 1817, 1817,    0, 1817, 1817, 1817,
 1817, 1817,    0, 1817, 1817, 1817, 1817, 1817, 1817, 1817,
 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817,
 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817,
 1817, 1817, 1818, 1817, 1817, 1817, 1817,    0, 1817, 1817,
 1817, 1817, 1817, 1817,    0,    0, 1817, 1817, 1817, 1817,
 1817, 1817, 1817, 1817, 1817,    0,    0,    0,    0,    0,
 1817,    0, 1817, 1817, 1817, 1817, 1817, 1817,    0, 1817,
    0,    0, 1630, 1818, 1818, 1818, 1818, 1818, 1818, 1818,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1818, 1818, 1818, 1818, 1818,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1233,    0,    0,    0,    0,    0,    0,    0,
    0, 1234,    0, 1818,    0, 1818,    0,    0,    0,    0,
    0,    0,    0,    0, 1235,    0, 1233,    0,    0,    0,
    0,    0,    0,    0,    0, 1234,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1235,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1236,    0,
    0,    0,    0,    0,    0, 1237,    0,    0,    0,    0,
    0,    0,    0, 1238,    0,    0,    0,    0,    0,    0,
    0,    0, 1236,    0,    0,    0,    0,    0,    0, 1237,
 1239,    0, 1240,    0,    0,    0,    0, 1238,    0,    0,
    0,    0, 1241,    0, 1242, 1243, 1244,    0,    0,    0,
    0, 1245,    0,    0, 1239,    0, 1240,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1241,    0, 1242, 1243,
 1244,    0,    0,    0,    0, 1245,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1246,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1246,    0,    0, 1818,
    0, 1818,    0,    0, 1818,    0, 1818, 1818,    0,    0,
 1818, 1818,    0, 1818,    0,    0,    0,    0,    0, 1818,
    0, 1818, 1818, 1818, 1818,    0, 1818,    0,    0, 1818,
    0,    0, 1818,    0,    0,    0,    0,    0,    0, 1818,
    0, 1818, 1818,    0, 1818, 1818, 1818, 1818, 1818,    0,
    0, 1818,    0,    0, 1818,    0, 1818, 1818,    0,    0,
 1818, 1818, 1818,    0, 1818, 1818, 1818, 1818, 1818, 1818,
 1818,    0,    0,    0, 1818, 1818, 1818, 1818, 1818,    0,
    0,    0, 1818,    0,    0,    0,    0,    0,    0,    0,
 1818, 1818, 1818, 1818, 1818, 1818,    0,    0,    0, 1818,
 1818,    0, 1818,    0, 1818,    0, 1818, 1818, 1818,    0,
 1818,    0, 1818, 1818, 1818,    0, 1818, 1818, 1818, 1818,
 1818,    0, 1818, 1818,    0,    0,    0,    0, 1818,    0,
 1818, 1818,    0,    0, 1818, 1818, 1818,    0,    0, 1818,
    0, 1818,    0,    0, 1818, 1818, 1818, 1818,    0, 1818,
    0, 1818,    0, 1818, 1818, 1818, 1818, 1818, 1247,    0,
 1818, 1818, 1818,    0, 1818, 1818,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1818, 1818, 1818,    0, 1818,
 1818, 1818, 1247, 1818,    0,    0,    0, 1818,    0, 1818,
 1818, 1818, 1818,    0, 1818,    0, 1818, 1818, 1818, 1818,
 1818, 1818, 1818, 1818,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1818, 1818, 2308, 1818, 1818, 1818,    0,
    0,    0,    0, 1818, 1818, 1818, 1818, 1818,    0, 1818,
    0,    0, 1818, 1818, 1249, 1248, 1250, 1818, 1818, 2309,
    0, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818,
    0, 1818,    0,    0,    0,    0,    0,    0, 1249, 1248,
 1250, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818,
 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818,
 1818, 1818,    0, 1818, 1818, 1818, 1818, 1818, 1818,    0,
 1818, 1818, 1818, 1818,    0, 1818,    0, 1818, 1818, 1818,
 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818,
 1818, 1818, 1818, 1818, 1818,    0, 1818, 1818, 1818, 1818,
    0, 1818, 1818, 1818, 1818, 1818,    0, 1818, 1818, 1818,
 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818,
 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818,
 1818, 1818, 1818, 1818, 1818, 1818, 1819, 1818, 1818, 1818,
 1818,    0, 1818, 1818, 1818, 1818, 1818, 1818,    0,    0,
 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818,    0,
    0,    0,    0,    0, 1818,    0, 1818, 1818, 1818, 1818,
 1818, 1818,    0, 1818,    0,    0, 1632, 1819, 1819, 1819,
 1819, 1819, 1819, 1819,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1819, 1819, 1819, 1819, 1819,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1233,    0,    0,    0,
    0,    0,    0,    0,    0, 1234,    0, 1819,    0, 1819,
    0,    0,    0,    0,    0,    0,    0,    0, 1235,    0,
 1233,    0,    0,    0,    0,    0,    0,    0,    0, 1234,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1235,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1236,    0,    0,    0,    0,    0,    0, 1237,
    0,    0,    0,    0,    0,    0,    0, 1238,    0,    0,
    0,    0,    0,    0,    0,    0, 1236,    0,    0,    0,
    0,    0,    0, 1237, 1239,    0, 1240,    0,    0,    0,
    0, 1238,    0,    0,    0,    0, 1241,    0, 1242, 1243,
 1244,    0,    0,    0,    0, 1245,    0,    0, 1239,    0,
 1240,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1241,    0, 1242, 1243, 1244,    0,    0,    0,    0, 1245,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1246,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1246,    0,    0, 1819,    0, 1819,    0,    0, 1819,    0,
 1819, 1819,    0,    0, 1819, 1819,    0, 1819,    0,    0,
    0,    0,    0, 1819,    0, 1819, 1819, 1819, 1819,    0,
 1819,    0,    0, 1819,    0,    0, 1819,    0,    0,    0,
    0,    0,    0, 1819,    0, 1819, 1819,    0, 1819, 1819,
 1819, 1819, 1819,    0,    0, 1819,    0,    0, 1819,    0,
 1819, 1819,    0,    0, 1819, 1819, 1819,    0, 1819, 1819,
 1819, 1819, 1819, 1819, 1819,    0,    0,    0, 1819, 1819,
 1819, 1819, 1819,    0,    0,    0, 1819,    0,    0,    0,
    0,    0,    0,    0, 1819, 1819, 1819, 1819, 1819, 1819,
    0,    0,    0, 1819, 1819,    0, 1819,    0, 1819,    0,
 1819, 1819, 1819,    0, 1819,    0, 1819, 1819, 1819,    0,
 1819, 1819, 1819, 1819, 1819,    0, 1819, 1819,    0,    0,
    0,    0, 1819,    0, 1819, 1819,    0,    0, 1819, 1819,
 1819,    0,    0, 1819,    0, 1819,    0,    0, 1819, 1819,
 1819, 1819,    0, 1819,    0, 1819,    0, 1819, 1819, 1819,
 1819, 1819, 1247,    0, 1819, 1819, 1819,    0, 1819, 1819,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1819,
 1819, 1819,    0, 1819, 1819, 1819, 1247, 1819,    0,    0,
    0, 1819,    0, 1819, 1819, 1819, 1819,    0, 1819,    0,
 1819, 1819, 1819, 1819, 1819, 1819, 1819, 1819,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1819, 1819, 2310,
 1819, 1819, 1819,    0,    0,    0,    0, 1819, 1819, 1819,
 1819, 1819,    0, 1819,    0,    0, 1819, 1819, 1249, 1248,
 1250, 1819, 1819, 2313,    0, 1819, 1819, 1819, 1819, 1819,
 1819, 1819, 1819, 1819,    0, 1819,    0,    0,    0,    0,
    0,    0, 1249, 1248, 1250, 1819, 1819, 1819, 1819, 1819,
 1819, 1819, 1819, 1819, 1819, 1819, 1819, 1819, 1819, 1819,
 1819, 1819, 1819, 1819, 1819, 1819,    0, 1819, 1819, 1819,
 1819, 1819, 1819,    0, 1819, 1819, 1819, 1819,    0, 1819,
    0, 1819, 1819, 1819, 1819, 1819, 1819, 1819, 1819, 1819,
 1819, 1819, 1819, 1819, 1819, 1819, 1819, 1819, 1819,    0,
 1819, 1819, 1819, 1819,    0, 1819, 1819, 1819, 1819, 1819,
    0, 1819, 1819, 1819, 1819, 1819, 1819, 1819, 1819, 1819,
 1819, 1819, 1819, 1819, 1819, 1819, 1819, 1819, 1819, 1819,
 1819, 1819, 1819, 1819, 1819, 1819, 1819, 1819, 1819, 1819,
 1820, 1819, 1819, 1819, 1819,    0, 1819, 1819, 1819, 1819,
 1819, 1819,    0,    0, 1819, 1819, 1819, 1819, 1819, 1819,
 1819, 1819, 1819,    0,    0,    0,    0,    0, 1819,    0,
 1819, 1819, 1819, 1819, 1819, 1819,    0, 1819,    0,    0,
 1633, 1820, 1820, 1820, 1820, 1820, 1820, 1820,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1820, 1820,
 1820, 1820, 1820,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1233,    0,    0,    0,    0,    0,    0,    0,    0, 1234,
    0, 1820,    0, 1820,    0,    0,    0,    0,    0,    0,
    0,    0, 1235,    0, 1233,    0,    0,    0,    0,    0,
    0,    0,    0, 1234,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1235,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1236,    0,    0,    0,
    0,    0,    0, 1237,    0,    0,    0,    0,    0,    0,
    0, 1238,    0,    0,    0,    0,    0,    0,    0,    0,
 1236,    0,    0,    0,    0,    0,    0, 1237, 1239,    0,
 1240,    0,    0,    0,    0, 1238,    0,    0,    0,    0,
 1241,    0, 1242, 1243, 1244,    0,    0,    0,    0, 1245,
    0,    0, 1239,    0, 1240,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1241,    0, 1242, 1243, 1244,    0,
    0,    0,    0, 1245,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1246,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1246,    0,    0, 1820,    0, 1820,
    0,    0, 1820,    0, 1820, 1820,    0,    0, 1820, 1820,
    0, 1820,    0,    0,    0,    0,    0, 1820,    0, 1820,
 1820, 1820, 1820,    0, 1820,    0,    0, 1820,    0,    0,
 1820,    0,    0,    0,    0,    0,    0, 1820,    0, 1820,
 1820,    0, 1820, 1820, 1820, 1820, 1820,    0,    0, 1820,
    0,    0, 1820,    0, 1820, 1820,    0,    0, 1820, 1820,
 1820,    0, 1820, 1820, 1820, 1820, 1820, 1820, 1820,    0,
    0,    0, 1820, 1820, 1820, 1820, 1820,    0,    0,    0,
 1820,    0,    0,    0,    0,    0,    0,    0, 1820, 1820,
 1820, 1820, 1820, 1820,    0,    0,    0, 1820, 1820,    0,
 1820,    0, 1820,    0, 1820, 1820, 1820,    0, 1820,    0,
 1820, 1820, 1820,    0, 1820, 1820, 1820, 1820, 1820,    0,
 1820, 1820,    0,    0,    0,    0, 1820,    0, 1820, 1820,
    0,    0, 1820, 1820, 1820,    0,    0, 1820,    0, 1820,
    0,    0, 1820, 1820, 1820, 1820,    0, 1820,    0, 1820,
    0, 1820, 1820, 1820, 1820, 1820, 1247,    0, 1820, 1820,
 1820,    0, 1820, 1820,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1820, 1820, 1820,    0, 1820, 1820, 1820,
 1247, 1820,    0,    0,    0, 1820,    0, 1820, 1820, 1820,
 1820,    0, 1820,    0, 1820, 1820, 1820, 1820, 1820, 1820,
 1820, 1820,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1820, 1820, 2314, 1820, 1820, 1820,    0,    0,    0,
    0, 1820, 1820, 1820, 1820, 1820,    0, 1820,    0,    0,
 1820, 1820, 1249, 1248, 1250, 1820, 1820, 2594,    0, 1820,
 1820, 1820, 1820, 1820, 1820, 1820, 1820, 1820,    0, 1820,
    0,    0,    0,    0,    0,    0, 1249, 1248, 1250, 1820,
 1820, 1820, 1820, 1820, 1820, 1820, 1820, 1820, 1820, 1820,
 1820, 1820, 1820, 1820, 1820, 1820, 1820, 1820, 1820, 1820,
    0, 1820, 1820, 1820, 1820, 1820, 1820,    0, 1820, 1820,
 1820, 1820,    0, 1820,    0, 1820, 1820, 1820, 1820, 1820,
 1820, 1820, 1820, 1820, 1820, 1820, 1820, 1820, 1820, 1820,
 1820, 1820, 1820,    0, 1820, 1820, 1820, 1820,    0, 1820,
 1820, 1820, 1820, 1820,    0, 1820, 1820, 1820, 1820, 1820,
 1820, 1820, 1820, 1820, 1820, 1820, 1820, 1820, 1820, 1820,
 1820, 1820, 1820, 1820, 1820, 1820, 1820, 1820, 1820, 1820,
 1820, 1820, 1820, 1820, 1821, 1820, 1820, 1820, 1820,    0,
 1820, 1820, 1820, 1820, 1820, 1820,    0,    0, 1820, 1820,
 1820, 1820, 1820, 1820, 1820, 1820, 1820,    0,    0,    0,
    0,    0, 1820,    0, 1820, 1820, 1820, 1820, 1820, 1820,
    0, 1820,    0,    0, 1635, 1821, 1821, 1821, 1821, 1821,
 1821, 1821,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1821, 1821, 1821, 1821, 1821,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1233,    0,    0,    0,    0,    0,
    0,    0,    0, 1234,    0, 1821,    0, 1821,    0,    0,
    0,    0,    0,    0,    0,    0, 1235,    0, 1233,    0,
    0,    0,    0,    0,    0,    0,    0, 1234,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1235,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1236,    0,    0,    0,    0,    0,    0, 1237,    0,    0,
    0,    0,    0,    0,    0, 1238,    0,    0,    0,    0,
    0,    0,    0,    0, 1236,    0,    0,    0,    0,    0,
    0, 1237, 1239,    0, 1240,    0,    0,    0,    0, 1238,
    0,    0,    0,    0, 1241,    0, 1242, 1243, 1244,    0,
    0,    0,    0, 1245,    0,    0, 1239,    0, 1240,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1241,    0,
 1242, 1243, 1244,    0,    0,    0,    0, 1245,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1246,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1246,    0,
    0, 1821,    0, 1821,    0,    0, 1821,    0, 1821, 1821,
    0,    0, 1821, 1821,    0, 1821,    0,    0,    0,    0,
    0, 1821,    0, 1821, 1821, 1821, 1821,    0, 1821,    0,
    0, 1821,    0,    0, 1821,    0,    0,    0,    0,    0,
    0, 1821,    0, 1821, 1821,    0, 1821, 1821, 1821, 1821,
 1821,    0,    0, 1821,    0,    0, 1821,    0, 1821, 1821,
    0,    0, 1821, 1821, 1821,    0, 1821, 1821, 1821, 1821,
 1821, 1821, 1821,    0,    0,    0, 1821, 1821, 1821, 1821,
 1821,    0,    0,    0, 1821,    0,    0,    0,    0,    0,
    0,    0, 1821, 1821, 1821, 1821, 1821, 1821,    0,    0,
    0, 1821, 1821,    0, 1821,    0, 1821,    0, 1821, 1821,
 1821,    0, 1821,    0, 1821, 1821, 1821,    0, 1821, 1821,
 1821, 1821, 1821,    0, 1821, 1821,    0,    0,    0,    0,
 1821,    0, 1821, 1821,    0,    0, 1821, 1821, 1821,    0,
    0, 1821,    0, 1821,    0,    0, 1821, 1821, 1821, 1821,
    0, 1821,    0, 1821,    0, 1821, 1821, 1821, 1821, 1821,
 1247,    0, 1821, 1821, 1821,    0, 1821, 1821,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1821, 1821, 1821,
    0, 1821, 1821, 1821, 1247, 1821,    0,    0,    0, 1821,
    0, 1821, 1821, 1821, 1821,    0, 1821,    0, 1821, 1821,
 1821, 1821, 1821, 1821, 1821, 1821,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1821, 1821, 2596, 1821, 1821,
 1821,    0,    0,    0,    0, 1821, 1821, 1821, 1821, 1821,
    0, 1821,    0,    0, 1821, 1821, 1249, 1248, 1250, 1821,
 1821, 2597,    0, 1821, 1821, 1821, 1821, 1821, 1821, 1821,
 1821, 1821,    0, 1821,    0,    0,    0,    0,    0,    0,
 1249, 1248, 1250, 1821, 1821, 1821, 1821, 1821, 1821, 1821,
 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821,
 1821, 1821, 1821, 1821,    0, 1821, 1821, 1821, 1821, 1821,
 1821,    0, 1821, 1821, 1821, 1821,    0, 1821,    0, 1821,
 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821,
 1821, 1821, 1821, 1821, 1821, 1821, 1821,    0, 1821, 1821,
 1821, 1821,    0, 1821, 1821, 1821, 1821, 1821,    0, 1821,
 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821,
 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821,
 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1822, 1821,
 1821, 1821, 1821,    0, 1821, 1821, 1821, 1821, 1821, 1821,
    0,    0, 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821,
 1821,    0,    0,    0,    0,    0, 1821,    0, 1821, 1821,
 1821, 1821, 1821, 1821,    0, 1821,    0,    0, 1637, 1822,
 1822, 1822, 1822, 1822, 1822, 1822,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1822, 1822, 1822, 1822,
 1822,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1233,    0,
    0,    0,    0,    0,    0,    0,    0, 1234,    0, 1822,
    0, 1822,    0,    0,    0,    0,    0,    0,    0,    0,
 1235,    0, 1233,    0,    0,    0,    0,    0,    0,    0,
    0, 1234,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1235,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1236,    0,    0,    0,    0,    0,
    0, 1237,    0,    0,    0,    0,    0,    0,    0, 1238,
    0,    0,    0,    0,    0,    0,    0,    0, 1236,    0,
    0,    0,    0,    0,    0, 1237, 1239,    0, 1240,    0,
    0,    0,    0, 1238,    0,    0,    0,    0, 1241,    0,
 1242, 1243, 1244,    0,    0,    0,    0, 1245,    0,    0,
 1239,    0, 1240,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1241,    0, 1242, 1243, 1244,    0,    0,    0,
    0, 1245,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1246,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1246,    0,    0, 1822,    0, 1822,    0,    0,
 1822,    0, 1822, 1822,    0,    0, 1822, 1822,    0, 1822,
    0,    0,    0,    0,    0, 1822,    0, 1822, 1822, 1822,
 1822,    0, 1822,    0,    0, 1822,    0,    0, 1822,    0,
    0,    0,    0,    0,    0, 1822,    0, 1822, 1822,    0,
 1822, 1822, 1822, 1822, 1822,    0,    0, 1822,    0,    0,
 1822,    0, 1822, 1822,    0,    0, 1822, 1822, 1822,    0,
 1822, 1822, 1822, 1822, 1822, 1822, 1822,    0,    0,    0,
 1822, 1822, 1822, 1822, 1822,    0,    0,    0, 1822,    0,
    0,    0,    0,    0,    0,    0, 1822, 1822, 1822, 1822,
 1822, 1822,    0,    0,    0, 1822, 1822,    0, 1822,    0,
 1822,    0, 1822, 1822, 1822,    0, 1822,    0, 1822, 1822,
 1822,    0, 1822, 1822, 1822, 1822, 1822,    0, 1822, 1822,
    0,    0,    0,    0, 1822,    0, 1822, 1822,    0,    0,
 1822, 1822, 1822,    0,    0, 1822,    0, 1822,    0,    0,
 1822, 1822, 1822, 1822,    0, 1822,    0, 1822,    0, 1822,
 1822, 1822, 1822, 1822, 1247,    0, 1822, 1822, 1822,    0,
 1822, 1822,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1822, 1822, 1822,    0, 1822, 1822, 1822, 1247, 1822,
    0,    0,    0, 1822,    0, 1822, 1822, 1822, 1822,    0,
 1822,    0, 1822, 1822, 1822, 1822, 1822, 1822, 1822, 1822,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1822,
 1822, 2604, 1822, 1822, 1822,    0,    0,    0,    0, 1822,
 1822, 1822, 1822, 1822,    0, 1822,    0,    0, 1822, 1822,
 1249, 1248, 1250, 1822, 1822, 2607,    0, 1822, 1822, 1822,
 1822, 1822, 1822, 1822, 1822, 1822,    0, 1822,    0,    0,
    0,    0,    0,    0, 1249, 1248, 1250, 1822, 1822, 1822,
 1822, 1822, 1822, 1822, 1822, 1822, 1822, 1822, 1822, 1822,
 1822, 1822, 1822, 1822, 1822, 1822, 1822, 1822,    0, 1822,
 1822, 1822, 1822, 1822, 1822,    0, 1822, 1822, 1822, 1822,
    0, 1822,    0, 1822, 1822, 1822, 1822, 1822, 1822, 1822,
 1822, 1822, 1822, 1822, 1822, 1822, 1822, 1822, 1822, 1822,
 1822,    0, 1822, 1822, 1822, 1822,    0, 1822, 1822, 1822,
 1822, 1822,    0, 1822, 1822, 1822, 1822, 1822, 1822, 1822,
 1822, 1822, 1822, 1822, 1822, 1822, 1822, 1822, 1822, 1822,
 1822, 1822, 1822, 1822, 1822, 1822, 1822, 1822, 1822, 1822,
 1822, 1822, 1823, 1822, 1822, 1822, 1822,    0, 1822, 1822,
 1822, 1822, 1822, 1822,    0,    0, 1822, 1822, 1822, 1822,
 1822, 1822, 1822, 1822, 1822,    0,    0,    0,    0,    0,
 1822,    0, 1822, 1822, 1822, 1822, 1822, 1822,    0, 1822,
    0,    0, 1638, 1823, 1823, 1823, 1823, 1823, 1823, 1823,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1823, 1823, 1823, 1823, 1823,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1233,    0,    0,    0,    0,    0,    0,    0,
    0, 1234,    0, 1823,    0, 1823,    0,    0,    0,    0,
    0,    0,    0,    0, 1235,    0, 1233,    0,    0,    0,
    0,    0,    0,    0,    0, 1234,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1235,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1236,    0,
    0,    0,    0,    0,    0, 1237,    0,    0,    0,    0,
    0,    0,    0, 1238,    0,    0,    0,    0,    0,    0,
    0,    0, 1236,    0,    0,    0,    0,    0,    0, 1237,
 1239,    0, 1240,    0,    0,    0,    0, 1238,    0,    0,
    0,    0, 1241,    0, 1242, 1243, 1244,    0,    0,    0,
    0, 1245,    0,    0, 1239,    0, 1240,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1241,    0, 1242, 1243,
 1244,    0,    0,    0,    0, 1245,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1246,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1246,    0,    0, 1823,
    0, 1823,    0,    0, 1823,    0, 1823, 1823,    0,    0,
 1823, 1823,    0, 1823,    0,    0,    0,    0,    0, 1823,
    0, 1823, 1823, 1823, 1823,    0, 1823,    0,    0, 1823,
    0,    0, 1823,    0,    0,    0,    0,    0,    0, 1823,
    0, 1823, 1823,    0, 1823, 1823, 1823, 1823, 1823,    0,
    0, 1823,    0,    0, 1823,    0, 1823, 1823,    0,    0,
 1823, 1823, 1823,    0, 1823, 1823, 1823, 1823, 1823, 1823,
 1823,    0,    0,    0, 1823, 1823, 1823, 1823, 1823,    0,
    0,    0, 1823,    0,    0,    0,    0,    0,    0,    0,
 1823, 1823, 1823, 1823, 1823, 1823,    0,    0,    0, 1823,
 1823,    0, 1823,    0, 1823,    0, 1823, 1823, 1823,    0,
 1823,    0, 1823, 1823, 1823,    0, 1823, 1823, 1823, 1823,
 1823,    0, 1823, 1823,    0,    0,    0,    0, 1823,    0,
 1823, 1823,    0,    0, 1823, 1823, 1823,    0,    0, 1823,
    0, 1823,    0,    0, 1823, 1823, 1823, 1823,    0, 1823,
    0, 1823,    0, 1823, 1823, 1823, 1823, 1823, 1247,    0,
 1823, 1823, 1823,    0, 1823, 1823,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1823, 1823, 1823,    0, 1823,
 1823, 1823, 1247, 1823,    0,    0,    0, 1823,    0, 1823,
 1823, 1823, 1823,    0, 1823,    0, 1823, 1823, 1823, 1823,
 1823, 1823, 1823, 1823,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1823, 1823, 2608, 1823, 1823, 1823,    0,
    0,    0,    0, 1823, 1823, 1823, 1823, 1823,    0, 1823,
    0,    0, 1823, 1823, 1249, 1248, 1250, 1823, 1823, 2621,
    0, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823,
    0, 1823,    0,    0,    0,    0,    0,    0, 1249, 1248,
 1250, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823,
 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823,
 1823, 1823,    0, 1823, 1823, 1823, 1823, 1823, 1823,    0,
 1823, 1823, 1823, 1823,    0, 1823,    0, 1823, 1823, 1823,
 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823,
 1823, 1823, 1823, 1823, 1823,    0, 1823, 1823, 1823, 1823,
    0, 1823, 1823, 1823, 1823, 1823,    0, 1823, 1823, 1823,
 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823,
 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823,
 1823, 1823, 1823, 1823, 1823, 1823, 1824, 1823, 1823, 1823,
 1823,    0, 1823, 1823, 1823, 1823, 1823, 1823,    0,    0,
 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823,    0,
    0,    0,    0,    0, 1823,    0, 1823, 1823, 1823, 1823,
 1823, 1823,    0, 1823,    0,    0, 1639, 1824, 1824, 1824,
 1824, 1824, 1824, 1824,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1824, 1824, 1824, 1824, 1824,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1233,    0,    0,    0,
    0,    0,    0,    0,    0, 1234,    0, 1824,    0, 1824,
    0,    0,    0,    0,    0,    0,    0,    0, 1235,    0,
 1233,    0,    0,    0,    0,    0,    0,    0,    0, 1234,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1235,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1236,    0,    0,    0,    0,    0,    0, 1237,
    0,    0,    0,    0,    0,    0,    0, 1238,    0,    0,
    0,    0,    0,    0,    0,    0, 1236,    0,    0,    0,
    0,    0,    0, 1237, 1239,    0, 1240,    0,    0,    0,
    0, 1238,    0,    0,    0,    0, 1241,    0, 1242, 1243,
 1244,    0,    0,    0,    0, 1245,    0,    0, 1239,    0,
 1240,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1241,    0, 1242, 1243, 1244,    0,    0,    0,    0, 1245,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1246,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1246,    0,    0, 1824,    0, 1824,    0,    0, 1824,    0,
 1824, 1824,    0,    0, 1824, 1824,    0, 1824,    0,    0,
    0,    0,    0, 1824,    0, 1824, 1824, 1824, 1824,    0,
 1824,    0,    0, 1824,    0,    0, 1824,    0,    0,    0,
    0,    0,    0, 1824,    0, 1824, 1824,    0, 1824, 1824,
 1824, 1824, 1824,    0,    0, 1824,    0,    0, 1824,    0,
 1824, 1824,    0,    0, 1824, 1824, 1824,    0, 1824, 1824,
 1824, 1824, 1824, 1824, 1824,    0,    0,    0, 1824, 1824,
 1824, 1824, 1824,    0,    0,    0, 1824,    0,    0,    0,
    0,    0,    0,    0, 1824, 1824, 1824, 1824, 1824, 1824,
    0,    0,    0, 1824, 1824,    0, 1824,    0, 1824,    0,
 1824, 1824, 1824,    0, 1824,    0, 1824, 1824, 1824,    0,
 1824, 1824, 1824, 1824, 1824,    0, 1824, 1824,    0,    0,
    0,    0, 1824,    0, 1824, 1824,    0,    0, 1824, 1824,
 1824,    0,    0, 1824,    0, 1824,    0,    0, 1824, 1824,
 1824, 1824,    0, 1824,    0, 1824,    0, 1824, 1824, 1824,
 1824, 1824, 1247,    0, 1824, 1824, 1824,    0, 1824, 1824,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1824,
 1824, 1824,    0, 1824, 1824, 1824, 1247, 1824,    0,    0,
    0, 1824,    0, 1824, 1824, 1824, 1824,    0, 1824,    0,
 1824, 1824, 1824, 1824, 1824, 1824, 1824, 1824,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1824, 1824, 2626,
 1824, 1824, 1824,    0,    0,    0,    0, 1824, 1824, 1824,
 1824, 1824,    0, 1824,    0,    0, 1824, 1824, 1249, 1248,
 1250, 1824, 1824, 2627,    0, 1824, 1824, 1824, 1824, 1824,
 1824, 1824, 1824, 1824,    0, 1824,    0,    0,    0,    0,
    0,    0, 1249, 1248, 1250, 1824, 1824, 1824, 1824, 1824,
 1824, 1824, 1824, 1824, 1824, 1824, 1824, 1824, 1824, 1824,
 1824, 1824, 1824, 1824, 1824, 1824,    0, 1824, 1824, 1824,
 1824, 1824, 1824,    0, 1824, 1824, 1824, 1824,    0, 1824,
    0, 1824, 1824, 1824, 1824, 1824, 1824, 1824, 1824, 1824,
 1824, 1824, 1824, 1824, 1824, 1824, 1824, 1824, 1824,    0,
 1824, 1824, 1824, 1824,    0, 1824, 1824, 1824, 1824, 1824,
    0, 1824, 1824, 1824, 1824, 1824, 1824, 1824, 1824, 1824,
 1824, 1824, 1824, 1824, 1824, 1824, 1824, 1824, 1824, 1824,
 1824, 1824, 1824, 1824, 1824, 1824, 1824, 1824, 1824, 1824,
 1825, 1824, 1824, 1824, 1824,    0, 1824, 1824, 1824, 1824,
 1824, 1824,    0,    0, 1824, 1824, 1824, 1824, 1824, 1824,
 1824, 1824, 1824,    0,    0,    0,    0,    0, 1824,    0,
 1824, 1824, 1824, 1824, 1824, 1824,    0, 1824,    0,    0,
 1640, 1825, 1825, 1825, 1825, 1825, 1825, 1825,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1825, 1825,
 1825, 1825, 1825,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1233,    0,    0,    0,    0,    0,    0,    0,    0, 1234,
    0, 1825,    0, 1825,    0,    0,    0,    0,    0,    0,
    0,    0, 1235,    0, 1233,    0,    0,    0,    0,    0,
    0,    0,    0, 1234,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1235,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1236,    0,    0,    0,
    0,    0,    0, 1237,    0,    0,    0,    0,    0,    0,
    0, 1238,    0,    0,    0,    0,    0,    0,    0,    0,
 1236,    0,    0,    0,    0,    0,    0, 1237, 1239,    0,
 1240,    0,    0,    0,    0, 1238,    0,    0,    0,    0,
 1241,    0, 1242, 1243, 1244,    0,    0,    0,    0, 1245,
    0,    0, 1239,    0, 1240,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1241,    0, 1242, 1243, 1244,    0,
    0,    0,    0, 1245,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1246,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1246,    0,    0, 1825,    0, 1825,
    0,    0, 1825,    0, 1825, 1825,    0,    0, 1825, 1825,
    0, 1825,    0,    0,    0,    0,    0, 1825,    0, 1825,
 1825, 1825, 1825,    0, 1825,    0,    0, 1825,    0,    0,
 1825,    0,    0,    0,    0,    0,    0, 1825,    0, 1825,
 1825,    0, 1825, 1825, 1825, 1825, 1825,    0,    0, 1825,
    0,    0, 1825,    0, 1825, 1825,    0,    0, 1825, 1825,
 1825,    0, 1825, 1825, 1825, 1825, 1825, 1825, 1825,    0,
    0,    0, 1825, 1825, 1825, 1825, 1825,    0,    0,    0,
 1825,    0,    0,    0,    0,    0,    0,    0, 1825, 1825,
 1825, 1825, 1825, 1825,    0,    0,    0, 1825, 1825,    0,
 1825,    0, 1825,    0, 1825, 1825, 1825,    0, 1825,    0,
 1825, 1825, 1825,    0, 1825, 1825, 1825, 1825, 1825,    0,
 1825, 1825,    0,    0,    0,    0, 1825,    0, 1825, 1825,
    0,    0, 1825, 1825, 1825,    0,    0, 1825,    0, 1825,
    0,    0, 1825, 1825, 1825, 1825,    0, 1825,    0, 1825,
    0, 1825, 1825, 1825, 1825, 1825, 1247,    0, 1825, 1825,
 1825,    0, 1825, 1825,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1825, 1825, 1825,    0, 1825, 1825, 1825,
 1247, 1825,    0,    0,    0, 1825,    0, 1825, 1825, 1825,
 1825,    0, 1825,    0, 1825, 1825, 1825, 1825, 1825, 1825,
 1825, 1825,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1825, 1825, 2628, 1825, 1825, 1825,    0,    0,    0,
    0, 1825, 1825, 1825, 1825, 1825,    0, 1825,    0,    0,
 1825, 1825, 1249, 1248, 1250, 1825, 1825, 2629,    0, 1825,
 1825, 1825, 1825, 1825, 1825, 1825, 1825, 1825,    0, 1825,
    0,    0,    0,    0,    0,    0, 1249, 1248, 1250, 1825,
 1825, 1825, 1825, 1825, 1825, 1825, 1825, 1825, 1825, 1825,
 1825, 1825, 1825, 1825, 1825, 1825, 1825, 1825, 1825, 1825,
    0, 1825, 1825, 1825, 1825, 1825, 1825,    0, 1825, 1825,
 1825, 1825,    0, 1825,    0, 1825, 1825, 1825, 1825, 1825,
 1825, 1825, 1825, 1825, 1825, 1825, 1825, 1825, 1825, 1825,
 1825, 1825, 1825,    0, 1825, 1825, 1825, 1825,    0, 1825,
 1825, 1825, 1825, 1825,    0, 1825, 1825, 1825, 1825, 1825,
 1825, 1825, 1825, 1825, 1825, 1825, 1825, 1825, 1825, 1825,
 1825, 1825, 1825, 1825, 1825, 1825, 1825, 1825, 1825, 1825,
 1825, 1825, 1825, 1825, 1826, 1825, 1825, 1825, 1825,    0,
 1825, 1825, 1825, 1825, 1825, 1825,    0,    0, 1825, 1825,
 1825, 1825, 1825, 1825, 1825, 1825, 1825,    0,    0,    0,
    0,    0, 1825,    0, 1825, 1825, 1825, 1825, 1825, 1825,
    0, 1825,    0,    0, 1641, 1826, 1826, 1826, 1826, 1826,
 1826, 1826,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1826, 1826, 1826, 1826, 1826,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1233,    0,    0,    0,    0,    0,
    0,    0,    0, 1234,    0, 1826,    0, 1826,    0,    0,
    0,    0,    0,    0,    0,    0, 1235,    0, 1233,    0,
    0,    0,    0,    0,    0,    0,    0, 1234,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1235,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1236,    0,    0,    0,    0,    0,    0, 1237,    0,    0,
    0,    0,    0,    0,    0, 1238,    0,    0,    0,    0,
    0,    0,    0,    0, 1236,    0,    0,    0,    0,    0,
    0, 1237, 1239,    0, 1240,    0,    0,    0,    0, 1238,
    0,    0,    0,    0, 1241,    0, 1242, 1243, 1244,    0,
    0,    0,    0, 1245,    0,    0, 1239,    0, 1240,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1241,    0,
 1242, 1243, 1244,    0,    0,    0,    0, 1245,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1246,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1246,    0,
    0, 1826,    0, 1826,    0,    0, 1826,    0, 1826, 1826,
    0,    0, 1826, 1826,    0, 1826,    0,    0,    0,    0,
    0, 1826,    0, 1826, 1826, 1826, 1826,    0, 1826,    0,
    0, 1826,    0,    0, 1826,    0,    0,    0,    0,    0,
    0, 1826,    0, 1826, 1826,    0, 1826, 1826, 1826, 1826,
 1826,    0,    0, 1826,    0,    0, 1826,    0, 1826, 1826,
    0,    0, 1826, 1826, 1826,    0, 1826, 1826, 1826, 1826,
 1826, 1826, 1826,    0,    0,    0, 1826, 1826, 1826, 1826,
 1826,    0,    0,    0, 1826,    0,    0,    0,    0,    0,
    0,    0, 1826, 1826, 1826, 1826, 1826, 1826,    0,    0,
    0, 1826, 1826,    0, 1826,    0, 1826,    0, 1826, 1826,
 1826,    0, 1826,    0, 1826, 1826, 1826,    0, 1826, 1826,
 1826, 1826, 1826,    0, 1826, 1826,    0,    0,    0,    0,
 1826,    0, 1826, 1826,    0,    0, 1826, 1826, 1826,    0,
    0, 1826,    0, 1826,    0,    0, 1826, 1826, 1826, 1826,
    0, 1826,    0, 1826,    0, 1826, 1826, 1826, 1826, 1826,
 1247,    0, 1826, 1826, 1826,    0, 1826, 1826,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1826, 1826, 1826,
    0, 1826, 1826, 1826, 1247, 1826,    0,    0,    0, 1826,
    0, 1826, 1826, 1826, 1826,    0, 1826,    0, 1826, 1826,
 1826, 1826, 1826, 1826, 1826, 1826,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1826, 1826, 2630, 1826, 1826,
 1826,    0,    0,    0,    0, 1826, 1826, 1826, 1826, 1826,
    0, 1826,    0,    0, 1826, 1826, 1249, 1248, 1250, 1826,
 1826, 2631,    0, 1826, 1826, 1826, 1826, 1826, 1826, 1826,
 1826, 1826,    0, 1826,    0,    0,    0,    0,    0,    0,
 1249, 1248, 1250, 1826, 1826, 1826, 1826, 1826, 1826, 1826,
 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826,
 1826, 1826, 1826, 1826,    0, 1826, 1826, 1826, 1826, 1826,
 1826,    0, 1826, 1826, 1826, 1826,    0, 1826,    0, 1826,
 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826,
 1826, 1826, 1826, 1826, 1826, 1826, 1826,    0, 1826, 1826,
 1826, 1826,    0, 1826, 1826, 1826, 1826, 1826,    0, 1826,
 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826,
 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826,
 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1827, 1826,
 1826, 1826, 1826,    0, 1826, 1826, 1826, 1826, 1826, 1826,
    0,    0, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826,
 1826,    0,    0,    0,    0,    0, 1826,    0, 1826, 1826,
 1826, 1826, 1826, 1826,    0, 1826,    0,    0, 1643, 1827,
 1827, 1827, 1827, 1827, 1827, 1827,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1827, 1827, 1827, 1827,
 1827,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1233,    0,
    0,    0,    0,    0,    0,    0,    0, 1234,    0, 1827,
    0, 1827,    0,    0,    0,    0,    0,    0,    0,    0,
 1235,    0, 1233,    0,    0,    0,    0,    0,    0,    0,
    0, 1234,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1235,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1236,    0,    0,    0,    0,    0,
    0, 1237,    0,    0,    0,    0,    0,    0,    0, 1238,
    0,    0,    0,    0,    0,    0,    0,    0, 1236,    0,
    0,    0,    0,    0,    0, 1237, 1239,    0, 1240,    0,
    0,    0,    0, 1238,    0,    0,    0,    0, 1241,    0,
 1242, 1243, 1244,    0,    0,    0,    0, 1245,    0,    0,
 1239,    0, 1240,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1241,    0, 1242, 1243, 1244,    0,    0,    0,
    0, 1245,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1246,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1246,    0,    0, 1827,    0, 1827,    0,    0,
 1827,    0, 1827, 1827,    0,    0, 1827, 1827,    0, 1827,
    0,    0,    0,    0,    0, 1827,    0, 1827, 1827, 1827,
 1827,    0, 1827,    0,    0, 1827,    0,    0, 1827,    0,
    0,    0,    0,    0,    0, 1827,    0, 1827, 1827,    0,
 1827, 1827, 1827, 1827, 1827,    0,    0, 1827,    0,    0,
 1827,    0, 1827, 1827,    0,    0, 1827, 1827, 1827,    0,
 1827, 1827, 1827, 1827, 1827, 1827, 1827,    0,    0,    0,
 1827, 1827, 1827, 1827, 1827,    0,    0,    0, 1827,    0,
    0,    0,    0,    0,    0,    0, 1827, 1827, 1827, 1827,
 1827, 1827,    0,    0,    0, 1827, 1827,    0, 1827,    0,
 1827,    0, 1827, 1827, 1827,    0, 1827,    0, 1827, 1827,
 1827,    0, 1827, 1827, 1827, 1827, 1827,    0, 1827, 1827,
    0,    0,    0,    0, 1827,    0, 1827, 1827,    0,    0,
 1827, 1827, 1827,    0,    0, 1827,    0, 1827,    0,    0,
 1827, 1827, 1827, 1827,    0, 1827,    0, 1827,    0, 1827,
 1827, 1827, 1827, 1827, 1247,    0, 1827, 1827, 1827,    0,
 1827, 1827,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1827, 1827, 1827,    0, 1827, 1827, 1827, 1247, 1827,
    0,    0,    0, 1827,    0, 1827, 1827, 1827, 1827,    0,
 1827,    0, 1827, 1827, 1827, 1827, 1827, 1827, 1827, 1827,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1827,
 1827, 2632, 1827, 1827, 1827,    0,    0,    0,    0, 1827,
 1827, 1827, 1827, 1827,    0, 1827,    0,    0, 1827, 1827,
 1249, 1248, 1250, 1827, 1827, 2633,    0, 1827, 1827, 1827,
 1827, 1827, 1827, 1827, 1827, 1827,    0, 1827,    0,    0,
    0,    0,    0,    0, 1249, 1248, 1250, 1827, 1827, 1827,
 1827, 1827, 1827, 1827, 1827, 1827, 1827, 1827, 1827, 1827,
 1827, 1827, 1827, 1827, 1827, 1827, 1827, 1827,    0, 1827,
 1827, 1827, 1827, 1827, 1827,    0, 1827, 1827, 1827, 1827,
    0, 1827,    0, 1827, 1827, 1827, 1827, 1827, 1827, 1827,
 1827, 1827, 1827, 1827, 1827, 1827, 1827, 1827, 1827, 1827,
 1827,    0, 1827, 1827, 1827, 1827,    0, 1827, 1827, 1827,
 1827, 1827,    0, 1827, 1827, 1827, 1827, 1827, 1827, 1827,
 1827, 1827, 1827, 1827, 1827, 1827, 1827, 1827, 1827, 1827,
 1827, 1827, 1827, 1827, 1827, 1827, 1827, 1827, 1827, 1827,
 1827, 1827, 1828, 1827, 1827, 1827, 1827,    0, 1827, 1827,
 1827, 1827, 1827, 1827,    0,    0, 1827, 1827, 1827, 1827,
 1827, 1827, 1827, 1827, 1827,    0,    0,    0,    0,    0,
 1827,    0, 1827, 1827, 1827, 1827, 1827, 1827,    0, 1827,
    0,    0, 1644, 1828, 1828, 1828, 1828, 1828, 1828, 1828,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1828, 1828, 1828, 1828, 1828,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1233,    0,    0,    0,    0,    0,    0,    0,
    0, 1234,    0, 1828,    0, 1828,    0,    0,    0,    0,
    0,    0,    0,    0, 1235,    0, 1233,    0,    0,    0,
    0,    0,    0,    0,    0, 1234,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1235,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1236,    0,
    0,    0,    0,    0,    0, 1237,    0,    0,    0,    0,
    0,    0,    0, 1238,    0,    0,    0,    0,    0,    0,
    0,    0, 1236,    0,    0,    0,    0,    0,    0, 1237,
 1239,    0, 1240,    0,    0,    0,    0, 1238,    0,    0,
    0,    0, 1241,    0, 1242, 1243, 1244,    0,    0,    0,
    0, 1245,    0,    0, 1239,    0, 1240,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1241,    0, 1242, 1243,
 1244,    0,    0,    0,    0, 1245,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1246,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1246,    0,    0, 1828,
    0, 1828,    0,    0, 1828,    0, 1828, 1828,    0,    0,
 1828, 1828,    0, 1828,    0,    0,    0,    0,    0, 1828,
    0, 1828, 1828, 1828, 1828,    0, 1828,    0,    0, 1828,
    0,    0, 1828,    0,    0,    0,    0,    0,    0, 1828,
    0, 1828, 1828,    0, 1828, 1828, 1828, 1828, 1828,    0,
    0, 1828,    0,    0, 1828,    0, 1828, 1828,    0,    0,
 1828, 1828, 1828,    0, 1828, 1828, 1828, 1828, 1828, 1828,
 1828,    0,    0,    0, 1828, 1828, 1828, 1828, 1828,    0,
    0,    0, 1828,    0,    0,    0,    0,    0,    0,    0,
 1828, 1828, 1828, 1828, 1828, 1828,    0,    0,    0, 1828,
 1828,    0, 1828,    0, 1828,    0, 1828, 1828, 1828,    0,
 1828,    0, 1828, 1828, 1828,    0, 1828, 1828, 1828, 1828,
 1828,    0, 1828, 1828,    0,    0,    0,    0, 1828,    0,
 1828, 1828,    0,    0, 1828, 1828, 1828,    0,    0, 1828,
    0, 1828,    0,    0, 1828, 1828, 1828, 1828,    0, 1828,
    0, 1828,    0, 1828, 1828, 1828, 1828, 1828, 1247,    0,
 1828, 1828, 1828,    0, 1828, 1828,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1828, 1828, 1828,    0, 1828,
 1828, 1828, 1247, 1828,    0,    0,    0, 1828,    0, 1828,
 1828, 1828, 1828,    0, 1828,    0, 1828, 1828, 1828, 1828,
 1828, 1828, 1828, 1828,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1828, 1828, 2634, 1828, 1828, 1828,    0,
    0,    0,    0, 1828, 1828, 1828, 1828, 1828,    0, 1828,
    0,    0, 1828, 1828, 1249, 1248, 1250, 1828, 1828, 2635,
    0, 1828, 1828, 1828, 1828, 1828, 1828, 1828, 1828, 1828,
    0, 1828,    0,    0,    0,    0,    0,    0, 1249, 1248,
 1250, 1828, 1828, 1828, 1828, 1828, 1828, 1828, 1828, 1828,
 1828, 1828, 1828, 1828, 1828, 1828, 1828, 1828, 1828, 1828,
 1828, 1828,    0, 1828, 1828, 1828, 1828, 1828, 1828,    0,
 1828, 1828, 1828, 1828,    0, 1828,    0, 1828, 1828, 1828,
 1828, 1828, 1828, 1828, 1828, 1828, 1828, 1828, 1828, 1828,
 1828, 1828, 1828, 1828, 1828,    0, 1828, 1828, 1828, 1828,
    0, 1828, 1828, 1828, 1828, 1828,    0, 1828, 1828, 1828,
 1828, 1828, 1828, 1828, 1828, 1828, 1828, 1828, 1828, 1828,
 1828, 1828, 1828, 1828, 1828, 1828, 1828, 1828, 1828, 1828,
 1828, 1828, 1828, 1828, 1828, 1828, 1829, 1828, 1828, 1828,
 1828,    0, 1828, 1828, 1828, 1828, 1828, 1828,    0,    0,
 1828, 1828, 1828, 1828, 1828, 1828, 1828, 1828, 1828,    0,
    0,    0,    0,    0, 1828,    0, 1828, 1828, 1828, 1828,
 1828, 1828,    0, 1828,    0,    0, 1645, 1829, 1829, 1829,
 1829, 1829, 1829, 1829,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1829, 1829, 1829, 1829, 1829,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1233,    0,    0,    0,
    0,    0,    0,    0,    0, 1234,    0, 1829,    0, 1829,
    0,    0,    0,    0,    0,    0,    0,    0, 1235,    0,
 1233,    0,    0,    0,    0,    0,    0,    0,    0, 1234,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1235,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1236,    0,    0,    0,    0,    0,    0, 1237,
    0,    0,    0,    0,    0,    0,    0, 1238,    0,    0,
    0,    0,    0,    0,    0,    0, 1236,    0,    0,    0,
    0,    0,    0, 1237, 1239,    0, 1240,    0,    0,    0,
    0, 1238,    0,    0,    0,    0, 1241,    0, 1242, 1243,
 1244,    0,    0,    0,    0, 1245,    0,    0, 1239,    0,
 1240,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1241,    0, 1242, 1243, 1244,    0,    0,    0,    0, 1245,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1246,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1246,    0,    0, 1829,    0, 1829,    0,    0, 1829,    0,
 1829, 1829,    0,    0, 1829, 1829,    0, 1829,    0,    0,
    0,    0,    0, 1829,    0, 1829, 1829, 1829, 1829,    0,
 1829,    0,    0, 1829,    0,    0, 1829,    0,    0,    0,
    0,    0,    0, 1829,    0, 1829, 1829,    0, 1829, 1829,
 1829, 1829, 1829,    0,    0, 1829,    0,    0, 1829,    0,
 1829, 1829,    0,    0, 1829, 1829, 1829,    0, 1829, 1829,
 1829, 1829, 1829, 1829, 1829,    0,    0,    0, 1829, 1829,
 1829, 1829, 1829,    0,    0,    0, 1829,    0,    0,    0,
    0,    0,    0,    0, 1829, 1829, 1829, 1829, 1829, 1829,
    0,    0,    0, 1829, 1829,    0, 1829,    0, 1829,    0,
 1829, 1829, 1829,    0, 1829,    0, 1829, 1829, 1829,    0,
 1829, 1829, 1829, 1829, 1829,    0, 1829, 1829,    0,    0,
    0,    0, 1829,    0, 1829, 1829,    0,    0, 1829, 1829,
 1829,    0,    0, 1829,    0, 1829,    0,    0, 1829, 1829,
 1829, 1829,    0, 1829,    0, 1829,    0, 1829, 1829, 1829,
 1829, 1829, 1247,    0, 1829, 1829, 1829,    0, 1829, 1829,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1829,
 1829, 1829,    0, 1829, 1829, 1829, 1247, 1829,    0,    0,
    0, 1829,    0, 1829, 1829, 1829, 1829,    0, 1829,    0,
 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1829, 1829, 2636,
 1829, 1829, 1829,    0,    0,    0,    0, 1829, 1829, 1829,
 1829, 1829,    0, 1829,    0,    0, 1829, 1829, 1249, 1248,
 1250, 1829, 1829, 2637,    0, 1829, 1829, 1829, 1829, 1829,
 1829, 1829, 1829, 1829,    0, 1829,    0,    0,    0,    0,
    0,    0, 1249, 1248, 1250, 1829, 1829, 1829, 1829, 1829,
 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829,
 1829, 1829, 1829, 1829, 1829, 1829,    0, 1829, 1829, 1829,
 1829, 1829, 1829,    0, 1829, 1829, 1829, 1829,    0, 1829,
    0, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829,
 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829,    0,
 1829, 1829, 1829, 1829,    0, 1829, 1829, 1829, 1829, 1829,
    0, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829,
 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829,
 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829,
 1833, 1829, 1829, 1829, 1829,    0, 1829, 1829, 1829, 1829,
 1829, 1829,    0,    0, 1829, 1829, 1829, 1829, 1829, 1829,
 1829, 1829, 1829,    0,    0,    0,    0,    0, 1829,    0,
 1829, 1829, 1829, 1829, 1829, 1829,    0, 1829,    0,    0,
 1646, 1833, 1833, 1833, 1833, 1833, 1833, 1833,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1833, 1833,
 1833, 1833, 1833,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1233,    0,    0,    0,    0,    0,    0,    0,    0, 1234,
    0, 1833,    0, 1833,    0,    0,    0,    0,    0,    0,
    0,    0, 1235,    0, 1233,    0,    0,    0,    0,    0,
    0,    0,    0, 1234,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1235,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1236,    0,    0,    0,
    0,    0,    0, 1237,    0,    0,    0,    0,    0,    0,
    0, 1238,    0,    0,    0,    0,    0,    0,    0,    0,
 1236,    0,    0,    0,    0,    0,    0, 1237, 1239,    0,
 1240,    0,    0,    0,    0, 1238,    0,    0,    0,    0,
 1241,    0, 1242, 1243, 1244,    0,    0,    0,    0, 1245,
    0,    0, 1239,    0, 1240,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1241,    0, 1242, 1243, 1244,    0,
    0,    0,    0, 1245,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1246,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1246,    0,    0, 1833,    0, 1833,
    0,    0, 1833,    0, 1833, 1833,    0,    0, 1833, 1833,
    0, 1833,    0,    0,    0,    0,    0, 1833,    0, 1833,
 1833, 1833, 1833,    0, 1833,    0,    0, 1833,    0,    0,
 1833,    0,    0,    0,    0,    0,    0, 1833,    0, 1833,
 1833,    0, 1833, 1833, 1833, 1833, 1833,    0,    0, 1833,
    0,    0, 1833,    0, 1833, 1833,    0,    0, 1833, 1833,
 1833,    0, 1833, 1833, 1833, 1833, 1833, 1833, 1833,    0,
    0,    0, 1833, 1833, 1833, 1833, 1833,    0,    0,    0,
 1833,    0,    0,    0,    0,    0,    0,    0, 1833, 1833,
 1833, 1833, 1833, 1833,    0,    0,    0, 1833, 1833,    0,
 1833,    0, 1833,    0, 1833, 1833, 1833,    0, 1833,    0,
 1833, 1833, 1833,    0, 1833, 1833, 1833, 1833, 1833,    0,
 1833, 1833,    0,    0,    0,    0, 1833,    0, 1833, 1833,
    0,    0, 1833, 1833, 1833,    0,    0, 1833,    0, 1833,
    0,    0, 1833, 1833, 1833, 1833,    0, 1833,    0, 1833,
    0, 1833, 1833, 1833, 1833, 1833, 1247,    0, 1833, 1833,
 1833,    0, 1833, 1833,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1833, 1833, 1833,    0, 1833, 1833, 1833,
 1247, 1833,    0,    0,    0, 1833,    0, 1833, 1833, 1833,
 1833,    0, 1833,    0, 1833, 1833, 1833, 1833, 1833, 1833,
 1833, 1833,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1833, 1833, 2851, 1833, 1833, 1833,    0,    0,    0,
    0, 1833, 1833, 1833, 1833, 1833,    0, 1833,    0,    0,
 1833, 1833, 1249, 1248, 1250, 1833, 1833, 2852,    0, 1833,
 1833, 1833, 1833, 1833, 1833, 1833, 1833, 1833,    0, 1833,
    0,    0,    0,    0,    0,    0, 1249, 1248, 1250, 1833,
 1833, 1833, 1833, 1833, 1833, 1833, 1833, 1833, 1833, 1833,
 1833, 1833, 1833, 1833, 1833, 1833, 1833, 1833, 1833, 1833,
    0, 1833, 1833, 1833, 1833, 1833, 1833,    0, 1833, 1833,
 1833, 1833,    0, 1833,    0, 1833, 1833, 1833, 1833, 1833,
 1833, 1833, 1833, 1833, 1833, 1833, 1833, 1833, 1833, 1833,
 1833, 1833, 1833,    0, 1833, 1833, 1833, 1833,    0, 1833,
 1833, 1833, 1833, 1833,    0, 1833, 1833, 1833, 1833, 1833,
 1833, 1833, 1833, 1833, 1833, 1833, 1833, 1833, 1833, 1833,
 1833, 1833, 1833, 1833, 1833, 1833, 1833, 1833, 1833, 1833,
 1833, 1833, 1833, 1833, 1834, 1833, 1833, 1833, 1833,    0,
 1833, 1833, 1833, 1833, 1833, 1833,    0,    0, 1833, 1833,
 1833, 1833, 1833, 1833, 1833, 1833, 1833,    0,    0,    0,
    0,    0, 1833,    0, 1833, 1833, 1833, 1833, 1833, 1833,
    0, 1833,    0,    0, 1647, 1834, 1834, 1834, 1834, 1834,
 1834, 1834,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1834, 1834, 1834, 1834, 1834,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1233,    0,    0,    0,    0,    0,
    0,    0,    0, 1234,    0, 1834,    0, 1834,    0,    0,
    0,    0,    0,    0,    0,    0, 1235,    0, 1233,    0,
    0,    0,    0,    0,    0,    0,    0, 1234,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1235,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1236,    0,    0,    0,    0,    0,    0, 1237,    0,    0,
    0,    0,    0,    0,    0, 1238,    0,    0,    0,    0,
    0,    0,    0,    0, 1236,    0,    0,    0,    0,    0,
    0, 1237, 1239,    0, 1240,    0,    0,    0,    0, 1238,
    0,    0,    0,    0, 1241,    0, 1242, 1243, 1244,    0,
    0,    0,    0, 1245,    0,    0, 1239,    0, 1240,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1241,    0,
 1242, 1243, 1244,    0,    0,    0,    0, 1245,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1246,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1246,    0,
    0, 1834,    0, 1834,    0,    0, 1834,    0, 1834, 1834,
    0,    0, 1834, 1834,    0, 1834,    0,    0,    0,    0,
    0, 1834,    0, 1834, 1834, 1834, 1834,    0, 1834,    0,
    0, 1834,    0,    0, 1834,    0,    0,    0,    0,    0,
    0, 1834,    0, 1834, 1834,    0, 1834, 1834, 1834, 1834,
 1834,    0,    0, 1834,    0,    0, 1834,    0, 1834, 1834,
    0,    0, 1834, 1834, 1834,    0, 1834, 1834, 1834, 1834,
 1834, 1834, 1834,    0,    0,    0, 1834, 1834, 1834, 1834,
 1834,    0,    0,    0, 1834,    0,    0,    0,    0,    0,
    0,    0, 1834, 1834, 1834, 1834, 1834, 1834,    0,    0,
    0, 1834, 1834,    0, 1834,    0, 1834,    0, 1834, 1834,
 1834,    0, 1834,    0, 1834, 1834, 1834,    0, 1834, 1834,
 1834, 1834, 1834,    0, 1834, 1834,    0,    0,    0,    0,
 1834,    0, 1834, 1834,    0,    0, 1834, 1834, 1834,    0,
    0, 1834,    0, 1834,    0,    0, 1834, 1834, 1834, 1834,
    0, 1834,    0, 1834,    0, 1834, 1834, 1834, 1834, 1834,
 1247,    0, 1834, 1834, 1834,    0, 1834, 1834,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1834, 1834, 1834,
    0, 1834, 1834, 1834, 1247, 1834,    0,    0,    0, 1834,
    0, 1834, 1834, 1834, 1834,    0, 1834,    0, 1834, 1834,
 1834, 1834, 1834, 1834, 1834, 1834,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1834, 1834, 3011, 1834, 1834,
 1834,    0,    0,    0,    0, 1834, 1834, 1834, 1834, 1834,
    0, 1834,    0,    0, 1834, 1834, 1249, 1248, 1250, 1834,
 1834, 3016,    0, 1834, 1834, 1834, 1834, 1834, 1834, 1834,
 1834, 1834,    0, 1834,    0,    0,    0,    0,    0,    0,
 1249, 1248, 1250, 1834, 1834, 1834, 1834, 1834, 1834, 1834,
 1834, 1834, 1834, 1834, 1834, 1834, 1834, 1834, 1834, 1834,
 1834, 1834, 1834, 1834,    0, 1834, 1834, 1834, 1834, 1834,
 1834,    0, 1834, 1834, 1834, 1834,    0, 1834,    0, 1834,
 1834, 1834, 1834, 1834, 1834, 1834, 1834, 1834, 1834, 1834,
 1834, 1834, 1834, 1834, 1834, 1834, 1834,    0, 1834, 1834,
 1834, 1834,    0, 1834, 1834, 1834, 1834, 1834,    0, 1834,
 1834, 1834, 1834, 1834, 1834, 1834, 1834, 1834, 1834, 1834,
 1834, 1834, 1834, 1834, 1834, 1834, 1834, 1834, 1834, 1834,
 1834, 1834, 1834, 1834, 1834, 1834, 1834, 1834, 1835, 1834,
 1834, 1834, 1834,    0, 1834, 1834, 1834, 1834, 1834, 1834,
    0,    0, 1834, 1834, 1834, 1834, 1834, 1834, 1834, 1834,
 1834,    0,    0,    0,    0,    0, 1834,    0, 1834, 1834,
 1834, 1834, 1834, 1834,    0, 1834,    0,    0, 1648, 1835,
 1835, 1835, 1835, 1835, 1835, 1835,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1835, 1835, 1835, 1835,
 1835,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1233,    0,
    0,    0,    0,    0,    0,    0,    0, 1234,    0, 1835,
    0, 1835,    0,    0,    0,    0,    0,    0,    0,    0,
 1235,    0, 1233,    0,    0,    0,    0,    0,    0,    0,
    0, 1234,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1235,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1236,    0,    0,    0,    0,    0,
    0, 1237,    0,    0,    0,    0,    0,    0,    0, 1238,
    0,    0,    0,    0,    0,    0,    0,    0, 1236,    0,
    0,    0,    0,    0,    0, 1237, 1239,    0, 1240,    0,
    0,    0,    0, 1238,    0,    0,    0,    0, 1241,    0,
 1242, 1243, 1244,    0,    0,    0,    0, 1245,    0,    0,
 1239,    0, 1240,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1241,    0, 1242, 1243, 1244,    0,    0,    0,
    0, 1245,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1246,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1246,    0,    0, 1835,    0, 1835,    0,    0,
 1835,    0, 1835, 1835,    0,    0, 1835, 1835,    0, 1835,
    0,    0,    0,    0,    0, 1835,    0, 1835, 1835, 1835,
 1835,    0, 1835,    0,    0, 1835,    0,    0, 1835,    0,
    0,    0,    0,    0,    0, 1835,    0, 1835, 1835,    0,
 1835, 1835, 1835, 1835, 1835,    0,    0, 1835,    0,    0,
 1835,    0, 1835, 1835,    0,    0, 1835, 1835, 1835,    0,
 1835, 1835, 1835, 1835, 1835, 1835, 1835,    0,    0,    0,
 1835, 1835, 1835, 1835, 1835,    0,    0,    0, 1835,    0,
    0,    0,    0,    0,    0,    0, 1835, 1835, 1835, 1835,
 1835, 1835,    0,    0,    0, 1835, 1835,    0, 1835,    0,
 1835,    0, 1835, 1835, 1835,    0, 1835,    0, 1835, 1835,
 1835,    0, 1835, 1835, 1835, 1835, 1835,    0, 1835, 1835,
    0,    0,    0,    0, 1835,    0, 1835, 1835,    0,    0,
 1835, 1835, 1835,    0,    0, 1835,    0, 1835,    0,    0,
 1835, 1835, 1835, 1835,    0, 1835,    0, 1835,    0, 1835,
 1835, 1835, 1835, 1835, 1247,    0, 1835, 1835, 1835,    0,
 1835, 1835,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1835, 1835, 1835,    0, 1835, 1835, 1835, 1247, 1835,
    0,    0,    0, 1835,    0, 1835, 1835, 1835, 1835,    0,
 1835,    0, 1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1835,
 1835, 3017, 1835, 1835, 1835,    0,    0,    0,    0, 1835,
 1835, 1835, 1835, 1835,    0, 1835,    0,    0, 1835, 1835,
 1249, 1248, 1250, 1835, 1835, 3018,    0, 1835, 1835, 1835,
 1835, 1835, 1835, 1835, 1835, 1835,    0, 1835,    0,    0,
    0,    0,    0,    0, 1249, 1248, 1250, 1835, 1835, 1835,
 1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835,
 1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835,    0, 1835,
 1835, 1835, 1835, 1835, 1835,    0, 1835, 1835, 1835, 1835,
    0, 1835,    0, 1835, 1835, 1835, 1835, 1835, 1835, 1835,
 1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835,
 1835,    0, 1835, 1835, 1835, 1835,    0, 1835, 1835, 1835,
 1835, 1835,    0, 1835, 1835, 1835, 1835, 1835, 1835, 1835,
 1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835,
 1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835,
 1835, 1835, 1837, 1835, 1835, 1835, 1835,    0, 1835, 1835,
 1835, 1835, 1835, 1835,    0,    0, 1835, 1835, 1835, 1835,
 1835, 1835, 1835, 1835, 1835,    0,    0,    0,    0,    0,
 1835,    0, 1835, 1835, 1835, 1835, 1835, 1835,    0, 1835,
    0,    0, 1649, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1837, 1837, 1837, 1837, 1837,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1233,    0,    0,    0,    0,    0,    0,    0,
    0, 1234,    0, 1837,    0, 1837,    0,    0,    0,    0,
    0,    0,    0,    0, 1235,    0, 1233,    0,    0,    0,
    0,    0,    0,    0,    0, 1234,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1235,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1236,    0,
    0,    0,    0,    0,    0, 1237,    0,    0,    0,    0,
    0,    0,    0, 1238,    0,    0,    0,    0,    0,    0,
    0,    0, 1236,    0,    0,    0,    0,    0,    0, 1237,
 1239,    0, 1240,    0,    0,    0,    0, 1238,    0,    0,
    0,    0, 1241,    0, 1242, 1243, 1244,    0,    0,    0,
    0, 1245,    0,    0, 1239,    0, 1240,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1241,    0, 1242, 1243,
 1244,    0,    0,    0,    0, 1245,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1246,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1246,    0,    0, 1837,
    0, 1837,    0,    0, 1837,    0, 1837, 1837,    0,    0,
 1837, 1837,    0, 1837,    0,    0,    0,    0,    0, 1837,
    0, 1837, 1837, 1837, 1837,    0, 1837,    0,    0, 1837,
    0,    0, 1837,    0,    0,    0,    0,    0,    0, 1837,
    0, 1837, 1837,    0, 1837, 1837, 1837, 1837, 1837,    0,
    0, 1837,    0,    0, 1837,    0, 1837, 1837,    0,    0,
 1837, 1837, 1837,    0, 1837, 1837, 1837, 1837, 1837, 1837,
 1837,    0,    0,    0, 1837, 1837, 1837, 1837, 1837,    0,
    0,    0, 1837,    0,    0,    0,    0,    0,    0,    0,
 1837, 1837, 1837, 1837, 1837, 1837,    0,    0,    0, 1837,
 1837,    0, 1837,    0, 1837,    0, 1837, 1837, 1837,    0,
 1837,    0, 1837, 1837, 1837,    0, 1837, 1837, 1837, 1837,
 1837,    0, 1837, 1837,    0,    0,    0,    0, 1837,    0,
 1837, 1837,    0,    0, 1837, 1837, 1837,    0,    0, 1837,
    0, 1837,    0,    0, 1837, 1837, 1837, 1837,    0, 1837,
    0, 1837,    0, 1837, 1837, 1837, 1837, 1837, 1247,    0,
 1837, 1837, 1837,    0, 1837, 1837,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1837, 1837, 1837,    0, 1837,
 1837, 1837, 1247, 1837,    0,    0,    0, 1837,    0, 1837,
 1837, 1837, 1837,    0, 1837,    0, 1837, 1837, 1837, 1837,
 1837, 1837, 1837, 1837,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1837, 1837, 3019, 1837, 1837, 1837,    0,
    0,    0,    0, 1837, 1837, 1837, 1837, 1837,    0, 1837,
    0,    0, 1837, 1837, 1249, 1248, 1250, 1837, 1837, 3026,
    0, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    0, 1837,    0,    0,    0,    0,    0,    0, 1249, 1248,
 1250, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
 1837, 1837,    0, 1837, 1837, 1837, 1837, 1837, 1837,    0,
 1837, 1837, 1837, 1837,    0, 1837,    0, 1837, 1837, 1837,
 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
 1837, 1837, 1837, 1837, 1837,    0, 1837, 1837, 1837, 1837,
    0, 1837, 1837, 1837, 1837, 1837,    0, 1837, 1837, 1837,
 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
 1837, 1837, 1837, 1837, 1837, 1837, 1839, 1837, 1837, 1837,
 1837,    0, 1837, 1837, 1837, 1837, 1837, 1837,    0,    0,
 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,    0,
    0,    0,    0,    0, 1837,    0, 1837, 1837, 1837, 1837,
 1837, 1837,    0, 1837,    0,    0, 1651, 1839, 1839, 1839,
 1839, 1839, 1839, 1839,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1839, 1839, 1839, 1839, 1839,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1233,    0,    0,    0,
    0,    0,    0,    0,    0, 1234,    0, 1839,    0, 1839,
    0,    0,    0,    0,    0,    0,    0,    0, 1235,    0,
 1233,    0,    0,    0,    0,    0,    0,    0,    0, 1234,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1235,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1236,    0,    0,    0,    0,    0,    0, 1237,
    0,    0,    0,    0,    0,    0,    0, 1238,    0,    0,
    0,    0,    0,    0,    0,    0, 1236,    0,    0,    0,
    0,    0,    0, 1237, 1239,    0, 1240,    0,    0,    0,
    0, 1238,    0,    0,    0,    0, 1241,    0, 1242, 1243,
 1244,    0,    0,    0,    0, 1245,    0,    0, 1239,    0,
 1240,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1241,    0, 1242, 1243, 1244,    0,    0,    0,    0, 1245,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1246,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1246,    0,    0, 1839,    0, 1839,    0,    0, 1839,    0,
 1839, 1839,    0,    0, 1839, 1839,    0, 1839,    0,    0,
    0,    0,    0, 1839,    0, 1839, 1839, 1839, 1839,    0,
 1839,    0,    0, 1839,    0,    0, 1839,    0,    0,    0,
    0,    0,    0, 1839,    0, 1839, 1839,    0, 1839, 1839,
 1839, 1839, 1839,    0,    0, 1839,    0,    0, 1839,    0,
 1839, 1839,    0,    0, 1839, 1839, 1839,    0, 1839, 1839,
 1839, 1839, 1839, 1839, 1839,    0,    0,    0, 1839, 1839,
 1839, 1839, 1839,    0,    0,    0, 1839,    0,    0,    0,
    0,    0,    0,    0, 1839, 1839, 1839, 1839, 1839, 1839,
    0,    0,    0, 1839, 1839,    0, 1839,    0, 1839,    0,
 1839, 1839, 1839,    0, 1839,    0, 1839, 1839, 1839,    0,
 1839, 1839, 1839, 1839, 1839,    0, 1839, 1839,    0,    0,
    0,    0, 1839,    0, 1839, 1839,    0,    0, 1839, 1839,
 1839,    0,    0, 1839,    0, 1839,    0,    0, 1839, 1839,
 1839, 1839,    0, 1839,    0, 1839,    0, 1839, 1839, 1839,
 1839, 1839, 1247,    0, 1839, 1839, 1839,    0, 1839, 1839,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1839,
 1839, 1839,    0, 1839, 1839, 1839, 1247, 1839,    0,    0,
    0, 1839,    0, 1839, 1839, 1839, 1839,    0, 1839,    0,
 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1839, 1839, 3027,
 1839, 1839, 1839,    0,    0,    0,    0, 1839, 1839, 1839,
 1839, 1839,    0, 1839,    0,    0, 1839, 1839, 1249, 1248,
 1250, 1839, 1839, 3105,    0, 1839, 1839, 1839, 1839, 1839,
 1839, 1839, 1839, 1839,    0, 1839,    0,    0,    0,    0,
    0,    0, 1249, 1248, 1250, 1839, 1839, 1839, 1839, 1839,
 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839,
 1839, 1839, 1839, 1839, 1839, 1839,    0, 1839, 1839, 1839,
 1839, 1839, 1839,    0, 1839, 1839, 1839, 1839,    0, 1839,
    0, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839,
 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839,    0,
 1839, 1839, 1839, 1839,    0, 1839, 1839, 1839, 1839, 1839,
    0, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839,
 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839,
 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839,
 1840, 1839, 1839, 1839, 1839,    0, 1839, 1839, 1839, 1839,
 1839, 1839,    0,    0, 1839, 1839, 1839, 1839, 1839, 1839,
 1839, 1839, 1839,    0,    0,    0,    0,    0, 1839,    0,
 1839, 1839, 1839, 1839, 1839, 1839,    0, 1839,    0,    0,
 1652, 1840, 1840, 1840, 1840, 1840, 1840, 1840,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1840, 1840,
 1840, 1840, 1840,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1233,    0,    0,    0,    0,    0,    0,    0,    0, 1234,
    0, 1840,    0, 1840,    0,    0,    0,    0,    0,    0,
    0,    0, 1235,    0, 1233,    0,    0,    0,    0,    0,
    0,    0,    0, 1234,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1235,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1236,    0,    0,    0,
    0,    0,    0, 1237,    0,    0,    0,    0,    0,    0,
    0, 1238,    0,    0,    0,    0,    0,    0,    0,    0,
 1236,    0,    0,    0,    0,    0,    0, 1237, 1239,    0,
 1240,    0,    0,    0,    0, 1238,    0,    0,    0,    0,
 1241,    0, 1242, 1243, 1244,    0,    0,    0,    0, 1245,
    0,    0, 1239,    0, 1240,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1241,    0, 1242, 1243, 1244,    0,
    0,    0,    0, 1245,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1246,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1246,    0,    0, 1840,    0, 1840,
    0,    0, 1840,    0, 1840, 1840,    0,    0, 1840, 1840,
    0, 1840,    0,    0,    0,    0,    0, 1840,    0, 1840,
 1840, 1840, 1840,    0, 1840,    0,    0, 1840,    0,    0,
 1840,    0,    0,    0,    0,    0,    0, 1840,    0, 1840,
 1840,    0, 1840, 1840, 1840, 1840, 1840,    0,    0, 1840,
    0,    0, 1840,    0, 1840, 1840,    0,    0, 1840, 1840,
 1840,    0, 1840, 1840, 1840, 1840, 1840, 1840, 1840,    0,
    0,    0, 1840, 1840, 1840, 1840, 1840,    0,    0,    0,
 1840,    0,    0,    0,    0,    0,    0,    0, 1840, 1840,
 1840, 1840, 1840, 1840,    0,    0,    0, 1840, 1840,    0,
 1840,    0, 1840,    0, 1840, 1840, 1840,    0, 1840,    0,
 1840, 1840, 1840,    0, 1840, 1840, 1840, 1840, 1840,    0,
 1840, 1840,    0,    0,    0,    0, 1840,    0, 1840, 1840,
    0,    0, 1840, 1840, 1840,    0,    0, 1840,    0, 1840,
    0,    0, 1840, 1840, 1840, 1840,    0, 1840,    0, 1840,
    0, 1840, 1840, 1840, 1840, 1840, 1247,    0, 1840, 1840,
 1840,    0, 1840, 1840,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1840, 1840, 1840,    0, 1840, 1840, 1840,
 1247, 1840,    0,    0,    0, 1840,    0, 1840, 1840, 1840,
 1840,    0, 1840,    0, 1840, 1840, 1840, 1840, 1840, 1840,
 1840, 1840,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1840, 1840, 3180, 1840, 1840, 1840,    0,    0,    0,
    0, 1840, 1840, 1840, 1840, 1840,    0, 1840,    0,    0,
 1840, 1840, 1249, 1248, 1250, 1840, 1840, 3223,    0, 1840,
 1840, 1840, 1840, 1840, 1840, 1840, 1840, 1840,    0, 1840,
    0,    0,    0,    0,    0,    0, 1249, 1248, 1250, 1840,
 1840, 1840, 1840, 1840, 1840, 1840, 1840, 1840, 1840, 1840,
 1840, 1840, 1840, 1840, 1840, 1840, 1840, 1840, 1840, 1840,
    0, 1840, 1840, 1840, 1840, 1840, 1840,    0, 1840, 1840,
 1840, 1840,    0, 1840,    0, 1840, 1840, 1840, 1840, 1840,
 1840, 1840, 1840, 1840, 1840, 1840, 1840, 1840, 1840, 1840,
 1840, 1840, 1840,    0, 1840, 1840, 1840, 1840,    0, 1840,
 1840, 1840, 1840, 1840,    0, 1840, 1840, 1840, 1840, 1840,
 1840, 1840, 1840, 1840, 1840, 1840, 1840, 1840, 1840, 1840,
 1840, 1840, 1840, 1840, 1840, 1840, 1840, 1840, 1840, 1840,
 1840, 1840, 1840, 1840, 1841, 1840, 1840, 1840, 1840,    0,
 1840, 1840, 1840, 1840, 1840, 1840,    0,    0, 1840, 1840,
 1840, 1840, 1840, 1840, 1840, 1840, 1840,    0,    0,    0,
    0,    0, 1840,    0, 1840, 1840, 1840, 1840, 1840, 1840,
    0, 1840,    0,    0, 1653, 1841, 1841, 1841, 1841, 1841,
 1841, 1841,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1841, 1841, 1841, 1841, 1841,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1233,    0,    0,    0,    0,    0,
    0,    0,    0, 1234,    0, 1841,    0, 1841,    0,    0,
    0,    0,    0,    0,    0,    0, 1235,    0, 1233,    0,
    0,    0,    0,    0,    0,    0,    0, 1234,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1235,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1236,    0,    0,    0,    0,    0,    0, 1237,    0,    0,
    0,    0,    0,    0,    0, 1238, 1060,    0,    0, 1061,
    0,    0,    0,    0, 1236,    0,    0,    0,    0,    0,
    0, 1237, 1239,    0, 1240, 1062,    0, 1063,    0, 1238,
    0,    0,    0,    0, 1241,    0, 1242, 1243, 1244,    0,
    0,    0,    0, 1245,    0,    0, 1239,    0, 1240,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1241,    0,
 1242, 1243, 1244,    0,    0, 1064,    0, 1245,    0,    0,
    0, 1065, 1066, 1067,    0, 1068, 1069, 1070,    0, 1071,
    0,    0,    0,    0, 1246,    0,    0,    0,    0,    0,
    0,    0,    0, 1072,    0, 1073,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1246,    0,
    0, 1841,    0, 1841,    0,    0, 1841,    0, 1841, 1841,
    0,    0, 1841, 1841, 1074, 1841,    0,    0,    0,    0,
    0, 1841,    0, 1841, 1841, 1841, 1841,    0, 1841,    0,
 1075, 1841,    0,    0, 1841,    0,    0,    0,    0,    0,
    0, 1841,    0, 1841, 1841,    0, 1841, 1841, 1841, 1841,
 1841,    0, 1076, 1841,    0,    0, 1841,    0, 1841, 1841,
    0,    0, 1841, 1841, 1841,    0, 1841, 1841, 1841, 1841,
 1841, 1841, 1841,    0,    0,    0, 1841, 1841, 1841, 1841,
 1841,    0,    0,    0, 1841,    0, 1077, 1078,    0,    0,
    0,    0, 1841, 1841, 1841, 1841, 1841, 1841,    0,    0,
    0, 1841, 1841, 1079, 1841,    0, 1841,    0, 1841, 1841,
 1841,    0, 1841,    0, 1841, 1841, 1841,    0, 1841, 1841,
 1841, 1841, 1841,    0, 1841, 1841,    0,    0,    0,    0,
 1841,    0, 1841, 1841,    0,    0, 1841, 1841, 1841,    0,
    0, 1841,    0, 1841,    0,    0, 1841, 1841, 1841, 1841,
    0, 1841,    0, 1841,    0, 1841, 1841, 1841, 1841, 1841,
 1247,    0, 1841, 1841, 1841,    0, 1841, 1841,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1841, 1841, 1841,
    0, 1841, 1841, 1841, 1247, 1841,    0,    0,    0, 1841,
    0, 1841, 1841, 1841, 1841,    0, 1841,    0, 1841, 1841,
 1841, 1841, 1841, 1841, 1841, 1841,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1841, 1841, 3233, 1841, 1841,
 1841,    0,    0,    0,    0, 1841, 1841, 1841, 1841, 1841,
    0, 1841,    0,    0, 1841, 1841, 1249, 1248, 1250, 1841,
 1841,    0,    0, 1841, 1841, 1841, 1841, 1841, 1841, 1841,
 1841, 1841,    0, 1841,    0,    0, 1249, 1248, 1250,    0,
    0,    0, 1080, 1841, 1841, 1841, 1841, 1841, 1841, 1841,
 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841,
 1841, 1841, 1841, 1841,    0, 1841, 1841, 1841, 1841, 1841,
 1841,    0, 1841, 1841, 1841, 1841,    0, 1841,    0, 1841,
 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841,
 1841, 1841, 1841, 1841, 1841, 1841, 1841,    0, 1841, 1841,
 1841, 1841,    0, 1841, 1841, 1841, 1841, 1841,    0, 1841,
 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841,
 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841,
 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1842, 1841,
 1841, 1841, 1841,    0, 1841, 1841, 1841, 1841, 1841, 1841,
    0,    0, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841,
 1841,    0,    0,    0,    0,    0, 1841,    0, 1841, 1841,
 1841, 1841, 1841, 1841,    0, 1841,    0,    0, 1654, 1842,
 1842, 1842, 1842, 1842, 1842, 1842,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1842, 1842, 1842, 1842,
 1842,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1233,    0,
    0,    0,    0, 1870,    0,    0,    0, 1234,    0, 1842,
    0, 1842,    0,    0,    0,    0,    0,    0, 1233,    0,
 1235,  546,    0,    0,    0,    0,    0, 1234, 1871,    0,
    0,    0,    0,    0, 1872,    0,    0,    0,    0,    0,
 1235,    0,    0,    0, 1873,    0,    0,    0,    0,    0,
    0,    0,    0,  547, 1236,    0,    0, 1874,    0,    0,
    0, 1237,    0,    0,    0,    0,    0,    0,    0, 1238,
    0,    0,    0,    0, 1236,    0,    0,    0,    0,    0,
    0, 1237,    0,    0,    0,    0, 1239,    0, 1240, 1238,
    0,    0,    0,    0,    0,    0,    0,    0, 1241,    0,
 1242, 1243, 1244,    0,    0,    0, 1239, 1245, 1240,    0,
    0,    0,    0,    0,    0, 1875,    0,    0, 1241,    0,
 1242, 1243, 1244,    0,    0,    0,    0, 1245,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1876,    0,    0, 1246, 1877,
    0,    0,    0,    0, 1878,    0,    0,    0,    0,    0,
 1879,    0,    0,    0,    0,    0,    0,    0, 1246,    0,
    0,    0,    0,    0,    0, 1842,    0, 1842, 1880,    0,
 1842,    0, 1842, 1842,    0,    0, 1842, 1842,    0, 1842,
    0,    0,    0,    0,    0, 1842,    0, 1842, 1842, 1842,
 1842,    0, 1842,    0,    0, 1842,    0,    0, 1842,    0,
    0,    0,    0,    0,    0, 1842,    0, 1842, 1842,    0,
 1842, 1842, 1842, 1842, 1842,    0,    0, 1842,    0,    0,
 1842,    0, 1842, 1842, 1881,    0, 1842, 1842, 1842,    0,
 1842, 1842, 1842, 1842, 1842, 1842, 1842,    0,    0,    0,
 1842, 1842, 1842, 1842, 1842,    0,    0,    0, 1842,    0,
    0,    0,    0,    0,    0,    0, 1842, 1842, 1842, 1842,
 1842, 1842,    0,    0,    0, 1842, 1842,    0, 1842,    0,
 1842,    0, 1842, 1842, 1842,    0, 1842,    0, 1842, 1842,
 1842,    0, 1842, 1842, 1842, 1842, 1842,    0, 1842, 1842,
    0,    0,    0,    0, 1842,    0, 1842, 1842,    0,    0,
 1842, 1842, 1842,    0,    0, 1842,    0, 1842,    0,    0,
 1842, 1842, 1842, 1842, 1882, 1842,    0, 1842,    0, 1842,
 1842, 1842, 1842, 1842, 1247,    0, 1842, 1842, 1842,    0,
 1842, 1842,    0, 1883,    0,    0,    0,    0,    0,    0,
    0, 1842, 1842, 1842, 1247, 1842, 1842, 1842,    0, 1842,
    0,    0,    0, 1842,    0, 1842, 1842, 1842, 1842, 1965,
 1842,    0, 1842, 1842, 1842, 1842, 1842, 1842, 1842, 1842,
    0,    0,    0,    0,    0, 1249, 1248, 1250,    0, 1842,
 1842,    0, 1842, 1842, 1842,    0,    0,    0,    0, 1842,
 1842, 1842, 1842, 1842,    0, 1842,    0,    0, 1842, 1842,
    0,    0,    0, 1842, 1842,    0,    0, 1842, 1842, 1842,
 1842, 1842, 1842, 1842, 1842, 1842,    0, 1842,    0,    0,
 1249, 1248, 1250,    0,    0,    0,    0, 1842, 1842, 1842,
 1842, 1842, 1842, 1842, 1842, 1842, 1842, 1842, 1842, 1842,
 1842, 1842, 1842, 1842, 1842, 1842, 1842, 1842,    0, 1842,
 1842, 1842, 1842, 1842, 1842,    0, 1842, 1842, 1842, 1842,
    0, 1842,    0, 1842, 1842, 1842, 1842, 1842, 1842, 1842,
 1842, 1842, 1842, 1842, 1842, 1842, 1842, 1842, 1842, 1842,
 1842,    0, 1842, 1842, 1842, 1842,    0, 1842, 1842, 1842,
 1842, 1842,    0, 1842, 1842, 1842, 1842, 1842, 1842, 1842,
 1842, 1842, 1842, 1842, 1842, 1842, 1842, 1842, 1842, 1842,
 1842, 1842, 1842, 1842, 1842, 1842, 1842, 1842, 1842, 1842,
 1842, 1842, 1845, 1842, 1842, 1842, 1842,    0, 1842, 1842,
 1842, 1842, 1842, 1842,    0,    0, 1842, 1842, 1842, 1842,
 1842, 1842, 1842, 1842, 1842,    0,    0,    0,    0,    0,
 1842,    0, 1842, 1842, 1842, 1842, 1842, 1842,    0, 1842,
    0,    0, 1655, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
    0,    0,    0,    0,    0,    0,    0, 1233,    0,    0,
 1845, 1845, 1845, 1845, 1845,    0, 1234,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1235,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1845,    0, 1845,    0,    0,    0,    0,
    0,    0, 1233,    0, 1939,    0,    0,    0,    0,    0,
    0, 1234,    0, 1236,    0,    0,    0,    0,    0,    0,
 1237,    0,    0,    0, 1235,    0,    0,    0, 1238,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1239,    0, 1240,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1241, 1236, 1242,
 1243, 1244,    0,    0,    0, 1237, 1245,    0,    0,    0,
    0,    0,    0, 1238,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1239,    0, 1240,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1241,    0, 1242, 1243, 1244, 1246,    0,    0,
    0, 1245,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1246,    0,    0,    0,    0,    0,    0, 1845,
    0, 1845,    0,    0, 1845,    0, 1845, 1845,    0,    0,
 1845, 1845,    0, 1845,    0,    0,    0,    0,    0, 1845,
    0, 1845, 1845, 1845, 1845,    0, 1845,    0,    0, 1845,
    0,    0, 1845,    0,    0,    0,    0,    0,    0, 1845,
    0, 1845, 1845,    0, 1845, 1845, 1845, 1845, 1845,    0,
    0, 1845,    0,    0, 1845,    0, 1845, 1845,    0,    0,
 1845, 1845, 1845,    0, 1845, 1845, 1845, 1845, 1845, 1845,
 1845,    0,    0,    0, 1845, 1845, 1845, 1845, 1845,    0,
    0,    0, 1845,    0,    0,    0,    0,    0,    0,    0,
 1845, 1845, 1845, 1845, 1845, 1845,    0,    0,    0, 1845,
 1845,    0, 1845,    0, 1845,    0, 1845, 1845, 1845,    0,
 1845,    0, 1845, 1845, 1845,    0, 1845, 1845, 1845, 1845,
 1845,    0, 1845, 1845,    0,    0,    0,    0, 1845,    0,
 1845, 1845,    0, 1247, 1845, 1845, 1845,    0,    0, 1845,
    0, 1845,    0,    0, 1845, 1845, 1845, 1845,    0, 1845,
    0, 1845,    0, 1845, 1845, 1845, 1845, 1845,    0,    0,
 1845, 1845, 1845,    0, 1845, 1845,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1845, 1845, 1845, 1247, 1845,
 1845, 1845,    0, 1845,    0,    0,    0, 1845,    0, 1845,
 1845, 1845, 1845, 1966, 1845,    0, 1845, 1845, 1845, 1845,
 1845, 1845, 1845, 1845,    0,    0,    0,    0,    0, 1249,
 1248, 1250,    0, 1845, 1845,    0, 1845, 1845, 1845,    0,
    0,    0,    0, 1845, 1845, 1845, 1845, 1845,    0, 1845,
    0,    0, 1845, 1845,    0,    0,    0, 1845, 1845,    0,
    0, 1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
    0, 1845,    0,    0, 1249, 1248, 1250,    0,    0,    0,
    0, 1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
 1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
 1845, 1845,    0, 1845, 1845, 1845, 1845, 1845, 1845,    0,
 1845, 1845, 1845, 1845,    0, 1845,    0, 1845, 1845, 1845,
 1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
 1845, 1845, 1845, 1845, 1845,    0, 1845, 1845, 1845, 1845,
    0, 1845, 1845, 1845, 1845, 1845,    0, 1845, 1845, 1845,
 1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
 1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,
 1845, 1845, 1845, 1845, 1845, 1845, 1847, 1845, 1845, 1845,
 1845,    0, 1845, 1845, 1845, 1845, 1845, 1845,    0,    0,
 1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845, 1845,    0,
    0,    0,    0,    0, 1845,    0, 1845, 1845, 1845, 1845,
 1845, 1845,    0, 1845,    0,    0, 1656, 1847, 1847, 1847,
 1847, 1847, 1847, 1847,    0,    0,    0,    0,    0,    0,
    0, 1233,    0,    0, 1847, 1847, 1847, 1847, 1847,    0,
 1234,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1235,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1847,    0, 1847,
    0,    0,    0,    0,    0,    0, 1233,    0,    0,    0,
    0,    0,    0,    0,    0, 1234,    0, 1236,    0,    0,
    0,    0,    0,    0, 1237,    0,    0,    0, 1235,    0,
    0,    0, 1238,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1239,
    0, 1240,    0,    0,    0,    0,    0,    0, 1958,    0,
    0, 1241, 1236, 1242, 1243, 1244,    0,    0,    0, 1237,
 1245,    0,    0,    0,    0,    0,    0, 1238,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1239,    0, 1240,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1241,    0, 1242, 1243,
 1244, 1246,    0,    0,    0, 1245,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1246,    0,    0,    0,
    0,    0,    0, 1847,    0, 1847,    0,    0, 1847,    0,
 1847, 1847,    0,    0, 1847, 1847,    0, 1847,    0,    0,
    0,    0,    0, 1847,    0, 1847, 1847, 1847, 1847,    0,
 1847,    0,    0, 1847,    0,    0, 1847,    0,    0,    0,
    0,    0,    0, 1847,    0, 1847, 1847,    0, 1847, 1847,
 1847, 1847, 1847,    0,    0, 1847,    0,    0, 1847,    0,
 1847, 1847,    0,    0, 1847, 1847, 1847,    0, 1847, 1847,
 1847, 1847, 1847, 1847, 1847,    0,    0,    0, 1847, 1847,
 1847, 1847, 1847,    0,    0,    0, 1847,    0,    0,    0,
    0,    0,    0,    0, 1847, 1847, 1847, 1847, 1847, 1847,
    0,    0,    0, 1847, 1847,    0, 1847,    0, 1847,    0,
 1847, 1847, 1847,    0, 1847,    0, 1847, 1847, 1847,    0,
 1847, 1847, 1847, 1847, 1847,    0, 1847, 1847,    0,    0,
    0,    0, 1847,    0, 1847, 1847,    0, 1247, 1847, 1847,
 1847,    0,    0, 1847,    0, 1847,    0,    0, 1847, 1847,
 1847, 1847,    0, 1847,    0, 1847,    0, 1847, 1847, 1847,
 1847, 1847,    0,    0, 1847, 1847, 1847,    0, 1847, 1847,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1847,
 1847, 1847, 1959, 1847, 1847, 1847,    0, 1847,    0,    0,
    0, 1847,    0, 1847, 1847, 1847, 1847, 1982, 1847,    0,
 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847,    0,    0,
    0,    0,    0, 1249, 1248, 1250,    0, 1847, 1847,    0,
 1847, 1847, 1847,    0,    0,    0,    0, 1847, 1847, 1847,
 1847, 1847,    0, 1847,    0,    0, 1847, 1847,    0,    0,
    0, 1847, 1847,    0,    0, 1847, 1847, 1847, 1847, 1847,
 1847, 1847, 1847, 1847,    0, 1847,    0,    0, 1249, 1248,
 1250,    0,    0,    0,    0, 1847, 1847, 1847, 1847, 1847,
 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847,
 1847, 1847, 1847, 1847, 1847, 1847,    0, 1847, 1847, 1847,
 1847, 1847, 1847,    0, 1847, 1847, 1847, 1847,    0, 1847,
    0, 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847,
 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847,    0,
 1847, 1847, 1847, 1847,    0, 1847, 1847, 1847, 1847, 1847,
    0, 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847,
 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847,
 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847,
 1848, 1847, 1847, 1847, 1847,    0, 1847, 1847, 1847, 1847,
 1847, 1847,    0,    0, 1847, 1847, 1847, 1847, 1847, 1847,
 1847, 1847, 1847,    0,    0,    0,    0,    0, 1847,    0,
 1847, 1847, 1847, 1847, 1847, 1847,    0, 1847,    0,    0,
 1657, 1848, 1848, 1848, 1848, 1848, 1848, 1848,    0,    0,
    0,    0,    0,    0,    0, 1233,    0,    0, 1848, 1848,
 1848, 1848, 1848,    0, 1234,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1235,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1848,    0, 1848,    0,    0,    0,    0,    0,    0,
 1233,    0,    0,    0,    0,    0,    0,    0,    0, 1234,
    0, 1236,    0,    0,    0,    0,    0,    0, 1237,    0,
    0,    0, 1235,    0,    0,    0, 1238,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1239,    0, 1240,    0,    0,    0,    0,
    0,    0, 2327,    0,    0, 1241, 1236, 1242, 1243, 1244,
    0,    0,    0, 1237, 1245,    0,    0,    0,    0,    0,
    0, 1238,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1239,    0,
 1240,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1241,    0, 1242, 1243, 1244, 1246,    0,    0,    0, 1245,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1246,    0,    0,    0,    0,    0,    0, 1848,    0, 1848,
    0,    0, 1848,    0, 1848, 1848,    0,    0, 1848, 1848,
    0, 1848,    0,    0,    0,    0,    0, 1848,    0, 1848,
 1848, 1848, 1848,    0, 1848,    0,    0, 1848,    0,    0,
 1848,    0,    0,    0,    0,    0,    0, 1848,    0, 1848,
 1848,    0, 1848, 1848, 1848, 1848, 1848,    0,    0, 1848,
    0,    0, 1848,    0, 1848, 1848,    0,    0, 1848, 1848,
 1848,    0, 1848, 1848, 1848, 1848, 1848, 1848, 1848,    0,
    0,    0, 1848, 1848, 1848, 1848, 1848,    0,    0,    0,
 1848,    0,    0,    0,    0,    0,    0,    0, 1848, 1848,
 1848, 1848, 1848, 1848,    0,    0,    0, 1848, 1848,    0,
 1848,    0, 1848,    0, 1848, 1848, 1848,    0, 1848,    0,
 1848, 1848, 1848,    0, 1848, 1848, 1848, 1848, 1848,    0,
 1848, 1848,    0,    0,    0,    0, 1848,    0, 1848, 1848,
    0, 1247, 1848, 1848, 1848,    0,    0, 1848,    0, 1848,
    0,    0, 1848, 1848, 1848, 1848,    0, 1848,    0, 1848,
    0, 1848, 1848, 1848, 1848, 1848,    0,    0, 1848, 1848,
 1848,    0, 1848, 1848,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1848, 1848, 1848, 1247, 1848, 1848, 1848,
    0, 1848,    0,    0,    0, 1848,    0, 1848, 1848, 1848,
 1848, 1987, 1848,    0, 1848, 1848, 1848, 1848, 1848, 1848,
 1848, 1848,    0,    0,    0,    0,    0, 1249, 1248, 1250,
    0, 1848, 1848,    0, 1848, 1848, 1848,    0,    0,    0,
    0, 1848, 1848, 1848, 1848, 1848,    0, 1848,    0,    0,
 1848, 1848,    0,    0,    0, 1848, 1848,    0,    0, 1848,
 1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848,    0, 1848,
    0,    0, 1249, 1248, 1250,    0,    0,    0,    0, 1848,
 1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848,
 1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848,
    0, 1848, 1848, 1848, 1848, 1848, 1848,    0, 1848, 1848,
 1848, 1848,    0, 1848,    0, 1848, 1848, 1848, 1848, 1848,
 1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848,
 1848, 1848, 1848,    0, 1848, 1848, 1848, 1848,    0, 1848,
 1848, 1848, 1848, 1848,    0, 1848, 1848, 1848, 1848, 1848,
 1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848,
 1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848,
 1848, 1848, 1848, 1848, 1851, 1848, 1848, 1848, 1848,    0,
 1848, 1848, 1848, 1848, 1848, 1848,    0,    0, 1848, 1848,
 1848, 1848, 1848, 1848, 1848, 1848, 1848,    0,    0,    0,
    0,    0, 1848,    0, 1848, 1848, 1848, 1848, 1848, 1848,
    0, 1848,    0,    0, 1658, 1851, 1851, 1851, 1851, 1851,
 1851, 1851,    0,    0,    0,    0,    0,    0,    0, 1233,
    0,    0, 1851, 1851, 1851, 1851, 1851,    0, 1234,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1235,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1851,    0, 1851,    0,    0,
    0,    0,    0,    0, 1233,    0,    0,    0,    0,    0,
    0,    0,    0, 1234,    0, 1236,    0,    0,    0,    0,
    0,    0, 1237,    0,    0,    0, 1235,    0,    0,    0,
 1238,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1239,    0, 1240,
    0,    0,    0,    0, 2598,    0,    0,    0,    0, 1241,
 1236, 1242, 1243, 1244,    0,    0,    0, 1237, 1245,    0,
    0,    0,    0,    0,    0, 1238,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1239,    0, 1240,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1241,    0, 1242, 1243, 1244, 1246,
    0,    0,    0, 1245,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1246,    0,    0,    0,    0,    0,
    0, 1851,    0, 1851,    0,    0, 1851,    0, 1851, 1851,
    0,    0, 1851, 1851,    0, 1851,    0,    0,    0,    0,
    0, 1851,    0, 1851, 1851, 1851, 1851,    0, 1851,    0,
    0, 1851,    0,    0, 1851,    0,    0,    0,    0,    0,
    0, 1851,    0, 1851, 1851,    0, 1851, 1851, 1851, 1851,
 1851,    0,    0, 1851,    0,    0, 1851,    0, 1851, 1851,
    0,    0, 1851, 1851, 1851,    0, 1851, 1851, 1851, 1851,
 1851, 1851, 1851,    0,    0,    0, 1851, 1851, 1851, 1851,
 1851,    0,    0,    0, 1851,    0,    0,    0,    0,    0,
    0,    0, 1851, 1851, 1851, 1851, 1851, 1851,    0,    0,
    0, 1851, 1851,    0, 1851,    0, 1851,    0, 1851, 1851,
 1851,    0, 1851,    0, 1851, 1851, 1851,    0, 1851, 1851,
 1851, 1851, 1851,    0, 1851, 1851,    0,    0,    0,    0,
 1851,    0, 1851, 1851,    0, 1247, 1851, 1851, 1851,    0,
    0, 1851,    0, 1851,    0,    0, 1851, 1851, 1851, 1851,
    0, 1851,    0, 1851,    0, 1851, 1851, 1851, 1851, 1851,
    0,    0, 1851, 1851, 1851,    0, 1851, 1851,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1851, 1851, 1851,
 1247, 1851, 1851, 1851,    0, 1851,    0,    0,    0, 1851,
    0, 1851, 1851, 1851, 1851, 1997, 1851,    0, 1851, 1851,
 1851, 1851, 1851, 1851, 1851, 1851,    0,    0,    0,    0,
    0, 1249, 1248, 1250,    0, 1851, 1851,    0, 1851, 1851,
 1851,    0,    0,    0,    0, 1851, 1851, 1851, 1851, 1851,
    0, 1851,    0,    0, 1851, 1851,    0,    0,    0, 1851,
 1851,    0,    0, 1851, 1851, 1851, 1851, 1851, 1851, 1851,
 1851, 1851,    0, 1851,    0,    0, 1249, 1248, 1250,    0,
    0,    0,    0, 1851, 1851, 1851, 1851, 1851, 1851, 1851,
 1851, 1851, 1851, 1851, 1851, 1851, 1851, 1851, 1851, 1851,
 1851, 1851, 1851, 1851,    0, 1851, 1851, 1851, 1851, 1851,
 1851,    0, 1851, 1851, 1851, 1851,    0, 1851,    0, 1851,
 1851, 1851, 1851, 1851, 1851, 1851, 1851, 1851, 1851, 1851,
 1851, 1851, 1851, 1851, 1851, 1851, 1851,    0, 1851, 1851,
 1851, 1851,    0, 1851, 1851, 1851, 1851, 1851,    0, 1851,
 1851, 1851, 1851, 1851, 1851, 1851, 1851, 1851, 1851, 1851,
 1851, 1851, 1851, 1851, 1851, 1851, 1851, 1851, 1851, 1851,
 1851, 1851, 1851, 1851, 1851, 1851, 1851, 1851, 1853, 1851,
 1851, 1851, 1851,    0, 1851, 1851, 1851, 1851, 1851, 1851,
    0,    0, 1851, 1851, 1851, 1851, 1851, 1851, 1851, 1851,
 1851,    0,    0,    0,    0,    0, 1851,    0, 1851, 1851,
 1851, 1851, 1851, 1851,    0, 1851,    0,    0, 1659, 1853,
 1853, 1853, 1853, 1853, 1853, 1853,    0,    0,    0,    0,
    0,    0,    0, 1233,    0,    0, 1853, 1853, 1853, 1853,
 1853,    0, 1234,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1235,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1853,
    0, 1853,    0,    0,    0,    0,    0,    0, 1233,    0,
    0,    0,    0,    0,    0,    0,    0, 1234,    0, 1236,
    0,    0,    0,    0,    0,    0, 1237,    0,    0,    0,
 1235,    0,    0,    0, 1238,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1239,    0, 1240,    0,    0,    0,    0,    0,    0,
 2620,    0,    0, 1241, 1236, 1242, 1243, 1244,    0,    0,
    0, 1237, 1245,    0,    0,    0,    0,    0,    0, 1238,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1239,    0, 1240,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1241,    0,
 1242, 1243, 1244, 1246,    0,    0,    0, 1245,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1246,    0,
    0,    0,    0,    0,    0, 1853,    0, 1853,    0,    0,
 1853,    0, 1853, 1853,    0,    0, 1853, 1853,    0, 1853,
    0,    0,    0,    0,    0, 1853,    0, 1853, 1853, 1853,
 1853,    0, 1853,    0,    0, 1853,    0,    0, 1853,    0,
    0,    0,    0,    0,    0, 1853,    0, 1853, 1853,    0,
 1853, 1853, 1853, 1853, 1853,    0,    0, 1853,    0,    0,
 1853,    0, 1853, 1853,    0,    0, 1853, 1853, 1853,    0,
 1853, 1853, 1853, 1853, 1853, 1853, 1853,    0,    0,    0,
 1853, 1853, 1853, 1853, 1853,    0,    0,    0, 1853,    0,
    0,    0,    0,    0,    0,    0, 1853, 1853, 1853, 1853,
 1853, 1853,    0,    0,    0, 1853, 1853,    0, 1853,    0,
 1853,    0, 1853, 1853, 1853,    0, 1853,    0, 1853, 1853,
 1853,    0, 1853, 1853, 1853, 1853, 1853,    0, 1853, 1853,
    0,    0,    0,    0, 1853,    0, 1853, 1853,    0, 1247,
 1853, 1853, 1853,    0,    0, 1853,    0, 1853,    0,    0,
 1853, 1853, 1853, 1853,    0, 1853,    0, 1853,    0, 1853,
 1853, 1853, 1853, 1853,    0,    0, 1853, 1853, 1853,    0,
 1853, 1853,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1853, 1853, 1853, 1247, 1853, 1853, 1853,    0, 1853,
    0,    0,    0, 1853,    0, 1853, 1853, 1853, 1853, 1998,
 1853,    0, 1853, 1853, 1853, 1853, 1853, 1853, 1853, 1853,
    0,    0,    0,    0,    0, 1249, 1248, 1250,    0, 1853,
 1853,    0, 1853, 1853, 1853,    0,    0,    0,    0, 1853,
 1853, 1853, 1853, 1853,    0, 1853,    0,    0, 1853, 1853,
    0,    0,    0, 1853, 1853,    0,    0, 1853, 1853, 1853,
 1853, 1853, 1853, 1853, 1853, 1853,    0, 1853,    0,    0,
 1249, 1248, 1250,    0,    0,    0,    0, 1853, 1853, 1853,
 1853, 1853, 1853, 1853, 1853, 1853, 1853, 1853, 1853, 1853,
 1853, 1853, 1853, 1853, 1853, 1853, 1853, 1853,    0, 1853,
 1853, 1853, 1853, 1853, 1853,    0, 1853, 1853, 1853, 1853,
    0, 1853,    0, 1853, 1853, 1853, 1853, 1853, 1853, 1853,
 1853, 1853, 1853, 1853, 1853, 1853, 1853, 1853, 1853, 1853,
 1853,    0, 1853, 1853, 1853, 1853,    0, 1853, 1853, 1853,
 1853, 1853,    0, 1853, 1853, 1853, 1853, 1853, 1853, 1853,
 1853, 1853, 1853, 1853, 1853, 1853, 1853, 1853, 1853, 1853,
 1853, 1853, 1853, 1853, 1853, 1853, 1853, 1853, 1853, 1853,
 1853, 1853, 1855, 1853, 1853, 1853, 1853,    0, 1853, 1853,
 1853, 1853, 1853, 1853,    0,    0, 1853, 1853, 1853, 1853,
 1853, 1853, 1853, 1853, 1853,    0,    0,    0,    0,    0,
 1853,    0, 1853, 1853, 1853, 1853, 1853, 1853,    0, 1853,
    0,    0, 1660, 1855, 1855, 1855, 1855, 1855, 1855, 1855,
    0,    0,    0,    0,    0,    0,    0, 1233,    0,    0,
 1855, 1855, 1855, 1855, 1855,    0, 1234,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1235,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1855,    0, 1855,    0,    0,    0,    0,
    0,    0, 1233,    0,    0,    0,    0,    0,    0,    0,
    0, 1234,    0, 1236,    0,    0,    0,    0,    0,    0,
 1237,    0,    0,    0, 1235,    0,    0,    0, 1238,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1239,    0, 1240,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1241, 1236, 1242,
 1243, 1244,    0,    0,    0, 1237, 1245,    0,    0,    0,
    0,    0,    0, 1238,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1239,    0, 1240,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1241,    0, 1242, 1243, 1244, 1246,    0,    0,
    0, 1245,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1246,    0,    0,    0,    0,    0,    0, 1855,
    0, 1855,    0,    0, 1855,    0, 1855, 1855,    0,    0,
 1855, 1855,    0, 1855,    0,    0,    0,    0,    0, 1855,
    0, 1855, 1855, 1855, 1855,    0, 1855,    0,    0, 1855,
    0,    0, 1855,    0,    0,    0,    0,    0,    0, 1855,
    0, 1855, 1855,    0, 1855, 1855, 1855, 1855, 1855,    0,
    0, 1855,    0,    0, 1855,    0, 1855, 1855,    0,    0,
 1855, 1855, 1855,    0, 1855, 1855, 1855, 1855, 1855, 1855,
 1855,    0,    0,    0, 1855, 1855, 1855, 1855, 1855,    0,
    0,    0, 1855,    0,    0,    0,    0,    0,    0,    0,
 1855, 1855, 1855, 1855, 1855, 1855,    0,    0,    0, 1855,
 1855,    0, 1855,    0, 1855,    0, 1855, 1855, 1855,    0,
 1855,    0, 1855, 1855, 1855,    0, 1855, 1855, 1855, 1855,
 1855,    0, 1855, 1855,    0,    0,    0,    0, 1855,    0,
 1855, 1855,    0, 1247, 1855, 1855, 1855,    0,    0, 1855,
    0, 1855,    0,    0, 1855, 1855, 1855, 1855,    0, 1855,
    0, 1855,    0, 1855, 1855, 1855, 1855, 1855,    0,    0,
 1855, 1855, 1855,    0, 1855, 1855,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1855, 1855, 1855, 1247, 1855,
 1855, 1855,    0, 1855,    0,    0,    0, 1855,    0, 1855,
 1855, 1855, 1855, 1999, 1855,    0, 1855, 1855, 1855, 1855,
 1855, 1855, 1855, 1855,    0,    0,    0,    0,    0, 1249,
 1248, 1250,    0, 1855, 1855,    0, 1855, 1855, 1855,    0,
    0,    0,    0, 1855, 1855, 1855, 1855, 1855,    0, 1855,
    0,    0, 1855, 1855,    0,    0,    0, 1855, 1855,    0,
    0, 1855, 1855, 1855, 1855, 1855, 1855, 1855, 1855, 1855,
    0, 1855,    0,    0, 1249, 1248, 1250,    0,    0,    0,
    0, 1855, 1855, 1855, 1855, 1855, 1855, 1855, 1855, 1855,
 1855, 1855, 1855, 1855, 1855, 1855, 1855, 1855, 1855, 1855,
 1855, 1855,    0, 1855, 1855, 1855, 1855, 1855, 1855,    0,
 1855, 1855, 1855, 1855,    0, 1855,    0, 1855, 1855, 1855,
 1855, 1855, 1855, 1855, 1855, 1855, 1855, 1855, 1855, 1855,
 1855, 1855, 1855, 1855, 1855,    0, 1855, 1855, 1855, 1855,
    0, 1855, 1855, 1855, 1855, 1855,    0, 1855, 1855, 1855,
 1855, 1855, 1855, 1855, 1855, 1855, 1855, 1855, 1855, 1855,
 1855, 1855, 1855, 1855, 1855, 1855, 1855, 1855, 1855, 1855,
 1855, 1855, 1855, 1855, 1855, 1855, 1856, 1855, 1855, 1855,
 1855,    0, 1855, 1855, 1855, 1855, 1855, 1855,    0,    0,
 1855, 1855, 1855, 1855, 1855, 1855, 1855, 1855, 1855,    0,
    0,    0,    0,    0, 1855,    0, 1855, 1855, 1855, 1855,
 1855, 1855,    0, 1855,    0,    0, 1663, 1856, 1856, 1856,
 1856, 1856, 1856, 1856,    0,    0,    0,    0,    0,    0,
    0, 1233,    0,    0, 1856, 1856, 1856, 1856, 1856,    0,
 1234,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1235,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1856,    0, 1856,
    0,    0,    0,    0,    0,    0, 1233,    0,    0,    0,
    0,    0,    0,    0,    0, 1234,    0, 1236,    0,    0,
    0,    0,    0,    0, 1237,    0,    0,    0, 1235,    0,
    0,    0, 1238,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1239,
    0, 1240,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1241, 1236, 1242, 1243, 1244,    0,    0,    0, 1950,
 1245,    0,    0,    0,    0,    0,    0, 1238,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1239,    0, 1240,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1241,    0, 1242, 1243,
 1244, 1246,    0,    0,    0, 1245,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1246,    0,    0,    0,
    0,    0,    0, 1856,    0, 1856,    0,    0, 1856,    0,
 1856, 1856,    0,    0, 1856, 1856,    0, 1856,    0,    0,
    0,    0,    0, 1856,    0, 1856, 1856, 1856, 1856,    0,
 1856,    0,    0, 1856,    0,    0, 1856,    0,    0,    0,
    0,    0,    0, 1856,    0, 1856, 1856,    0, 1856, 1856,
 1856, 1856, 1856,    0,    0, 1856,    0,    0, 1856,    0,
 1856, 1856,    0,    0, 1856, 1856, 1856,    0, 1856, 1856,
 1856, 1856, 1856, 1856, 1856,    0,    0,    0, 1856, 1856,
 1856, 1856, 1856,    0,    0,    0, 1856,    0,    0,    0,
    0,    0,    0,    0, 1856, 1856, 1856, 1856, 1856, 1856,
    0,    0,    0, 1856, 1856,    0, 1856,    0, 1856,    0,
 1856, 1856, 1856,    0, 1856,    0, 1856, 1856, 1856,    0,
 1856, 1856, 1856, 1856, 1856,    0, 1856, 1856,    0,    0,
    0,    0, 1856,    0, 1856, 1856,    0, 1247, 1856, 1856,
 1856,    0,    0, 1856,    0, 1856,    0,    0, 1856, 1856,
 1856, 1856,    0, 1856,    0, 1856,    0, 1856, 1856, 1856,
 1856, 1856,    0,    0, 1856, 1856, 1856,    0, 1856, 1856,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1856,
 1856, 1856, 1247, 1856, 1856, 1856,    0, 1856,    0,    0,
    0, 1856,    0, 1856, 1856, 1856, 1856, 2000, 1856,    0,
 1856, 1856, 1856, 1856, 1856, 1856, 1856, 1856,    0,    0,
    0,    0,    0, 1249, 1248, 1250,    0, 1856, 1856,    0,
 1856, 1856, 1856,    0,    0,    0,    0, 1856, 1856, 1856,
 1856, 1856,    0, 1856,    0,    0, 1856, 1856,    0,    0,
    0, 1856, 1856,    0,    0, 1856, 1856, 1856, 1856, 1856,
 1856, 1856, 1856, 1856,    0, 1856,    0,    0, 1470, 1470,
 1470,    0,    0,    0,    0, 1856, 1856, 1856, 1856, 1856,
 1856, 1856, 1856, 1856, 1856, 1856, 1856, 1856, 1856, 1856,
 1856, 1856, 1856, 1856, 1856, 1856,    0, 1856, 1856, 1856,
 1856, 1856, 1856,    0, 1856, 1856, 1856, 1856,    0, 1856,
    0, 1856, 1856, 1856, 1856, 1856, 1856, 1856, 1856, 1856,
 1856, 1856, 1856, 1856, 1856, 1856, 1856, 1856, 1856,    0,
 1856, 1856, 1856, 1856,    0, 1856, 1856, 1856, 1856, 1856,
    0, 1856, 1856, 1856, 1856, 1856, 1856, 1856, 1856, 1856,
 1856, 1856, 1856, 1856, 1856, 1856, 1856, 1856, 1856, 1856,
 1856, 1856, 1856, 1856, 1856, 1856, 1856, 1856, 1856, 1856,
 1857, 1856, 1856, 1856, 1856,    0, 1856, 1856, 1856, 1856,
 1856, 1856,    0,    0, 1856, 1856, 1856, 1856, 1856, 1856,
 1856, 1856, 1856,    0,    0,    0,    0,    0, 1856,    0,
 1856, 1856, 1856, 1856, 1856, 1856,    0, 1856,    0,    0,
 1664, 1857, 1857, 1857, 1857, 1857, 1857, 1857,    0,    0,
    0,    0,    0,    0,    0, 1233,    0,    0, 1857, 1857,
 1857, 1857, 1857,    0, 1234,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1235,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1857,    0, 1857,    0,    0,    0,    0,    0,    0,
 1470,    0,    0,    0,    0,    0,    0,    0,    0, 1470,
    0, 1236,    0,    0,    0,    0,    0,    0, 1237,    0,
    0,    0, 1470,    0,    0,    0, 1238,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1239,    0, 1240,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1241, 1470, 1242, 1243, 1244,
    0,    0,    0, 1470, 1245,    0,    0,    0,    0,    0,
    0, 1470,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1470,    0,
 1470,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1470,    0, 1470, 1470, 1470, 1246,    0,    0,    0, 1470,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1470,    0,    0,    0,    0,    0,    0, 1857,    0, 1857,
    0,    0, 1857,    0, 1857, 1857,    0,    0, 1857, 1857,
    0, 1857,    0,    0,    0,    0,    0, 1857,    0, 1857,
 1857, 1857, 1857,    0, 1857,    0,    0, 1857,    0,    0,
 1857,    0,    0,    0,    0,    0,    0, 1857,    0, 1857,
 1857,    0, 1857, 1857, 1857, 1857, 1857,    0,    0, 1857,
    0,    0, 1857,    0, 1857, 1857,    0,    0, 1857, 1857,
 1857,    0, 1857, 1857, 1857, 1857, 1857, 1857, 1857,    0,
    0,    0, 1857, 1857, 1857, 1857, 1857,    0,    0,    0,
 1857,    0,    0,    0,    0,    0,    0,    0, 1857, 1857,
 1857, 1857, 1857, 1857,    0,    0,    0, 1857, 1857,    0,
 1857,    0, 1857,    0, 1857, 1857, 1857,    0, 1857,    0,
 1857, 1857, 1857,    0, 1857, 1857, 1857, 1857, 1857,    0,
 1857, 1857,    0,    0,    0,    0, 1857,    0, 1857, 1857,
    0, 1247, 1857, 1857, 1857,    0,    0, 1857,    0, 1857,
    0,    0, 1857, 1857, 1857, 1857,    0, 1857,    0, 1857,
    0, 1857, 1857, 1857, 1857, 1857,    0,    0, 1857, 1857,
 1857,    0, 1857, 1857,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1857, 1857, 1857, 1470, 1857, 1857, 1857,
    0, 1857,    0,    0,    0, 1857,    0, 1857, 1857, 1857,
 1857, 2001, 1857,    0, 1857, 1857, 1857, 1857, 1857, 1857,
 1857, 1857,    0,    0,    0,    0,    0, 1249, 1248, 1250,
    0, 1857, 1857,    0, 1857, 1857, 1857,    0,    0,    0,
    0, 1857, 1857, 1857, 1857, 1857,    0, 1857,    0,    0,
 1857, 1857,    0,    0,    0, 1857, 1857,    0,    0, 1857,
 1857, 1857, 1857, 1857, 1857, 1857, 1857, 1857,    0, 1857,
    0,    0, 1249, 1248, 1250,    0,    0,    0,    0, 1857,
 1857, 1857, 1857, 1857, 1857, 1857, 1857, 1857, 1857, 1857,
 1857, 1857, 1857, 1857, 1857, 1857, 1857, 1857, 1857, 1857,
    0, 1857, 1857, 1857, 1857, 1857, 1857,    0, 1857, 1857,
 1857, 1857,    0, 1857,    0, 1857, 1857, 1857, 1857, 1857,
 1857, 1857, 1857, 1857, 1857, 1857, 1857, 1857, 1857, 1857,
 1857, 1857, 1857,    0, 1857, 1857, 1857, 1857,    0, 1857,
 1857, 1857, 1857, 1857,    0, 1857, 1857, 1857, 1857, 1857,
 1857, 1857, 1857, 1857, 1857, 1857, 1857, 1857, 1857, 1857,
 1857, 1857, 1857, 1857, 1857, 1857, 1857, 1857, 1857, 1857,
 1857, 1857, 1857, 1857, 1858, 1857, 1857, 1857, 1857,    0,
 1857, 1857, 1857, 1857, 1857, 1857,    0,    0, 1857, 1857,
 1857, 1857, 1857, 1857, 1857, 1857, 1857,    0,    0,    0,
    0,    0, 1857,    0, 1857, 1857, 1857, 1857, 1857, 1857,
    0, 1857,    0,    0, 1666, 1858, 1858, 1858, 1858, 1858,
 1858, 1858,    0,    0,    0,    0,    0,    0,    0, 1233,
    0,    0, 1858, 1858, 1858, 1858, 1858,    0, 1234,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1235,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1858,    0, 1858,    0,    0,
    0,    0,    0,    0, 1233,    0,    0,    0,    0,    0,
    0,    0,    0, 1234,    0, 1236,    0,    0,    0,    0,
    0,    0, 1237,    0,    0,    0, 1235,    0,    0,    0,
 1238,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1239,    0, 1240,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1241,
 1236, 1242, 1243, 1244,    0,    0,    0, 1237, 1245,    0,
    0,    0,    0,    0,    0, 1238,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1239,    0, 1240,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1241,    0, 1242, 1243, 1244, 1246,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1246,    0,    0,    0,    0,    0,
    0, 1858,    0, 1858,    0,    0, 1858,    0, 1858, 1858,
    0,    0, 1858, 1858,    0, 1858,    0,    0,    0,    0,
    0, 1858,    0, 1858, 1858, 1858, 1858,    0, 1858,    0,
    0, 1858,    0,    0, 1858,    0,    0,    0,    0,    0,
    0, 1858,    0, 1858, 1858,    0, 1858, 1858, 1858, 1858,
 1858,    0,    0, 1858,    0,    0, 1858,    0, 1858, 1858,
    0,    0, 1858, 1858, 1858,    0, 1858, 1858, 1858, 1858,
 1858, 1858, 1858,    0,    0,    0, 1858, 1858, 1858, 1858,
 1858,    0,    0,    0, 1858,    0,    0,    0,    0,    0,
    0,    0, 1858, 1858, 1858, 1858, 1858, 1858,    0,    0,
    0, 1858, 1858,    0, 1858,    0, 1858,    0, 1858, 1858,
 1858,    0, 1858,    0, 1858, 1858, 1858,    0, 1858, 1858,
 1858, 1858, 1858,    0, 1858, 1858,    0,    0,    0,    0,
 1858,    0, 1858, 1858,    0, 1247, 1858, 1858, 1858,    0,
    0, 1858,    0, 1858,    0,    0, 1858, 1858, 1858, 1858,
    0, 1858,    0, 1858,    0, 1858, 1858, 1858, 1858, 1858,
    0,    0, 1858, 1858, 1858,    0, 1858, 1858,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1858, 1858, 1858,
 1247, 1858, 1858, 1858,    0, 1858,    0,    0,    0, 1858,
    0, 1858, 1858, 1858, 1858, 2002, 1858,    0, 1858, 1858,
 1858, 1858, 1858, 1858, 1858, 1858,    0,    0,    0,    0,
    0, 1249, 1248, 1250,    0, 1858, 1858,    0, 1858, 1858,
 1858,    0,    0,    0,    0, 1858, 1858, 1858, 1858, 1858,
    0, 1858,    0,    0, 1858, 1858,    0,    0,    0, 1858,
 1858,    0,    0, 1858, 1858, 1858, 1858, 1858, 1858, 1858,
 1858, 1858,    0, 1858,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1858, 1858, 1858, 1858, 1858, 1858, 1858,
 1858, 1858, 1858, 1858, 1858, 1858, 1858, 1858, 1858, 1858,
 1858, 1858, 1858, 1858,    0, 1858, 1858, 1858, 1858, 1858,
 1858,    0, 1858, 1858, 1858, 1858,    0, 1858,    0, 1858,
 1858, 1858, 1858, 1858, 1858, 1858, 1858, 1858, 1858, 1858,
 1858, 1858, 1858, 1858, 1858, 1858, 1858,    0, 1858, 1858,
 1858, 1858,    0, 1858, 1858, 1858, 1858, 1858,    0, 1858,
 1858, 1858, 1858, 1858, 1858, 1858, 1858, 1858, 1858, 1858,
 1858, 1858, 1858, 1858, 1858, 1858, 1858, 1858, 1858, 1858,
 1858, 1858, 1858, 1858, 1858, 1858, 1858, 1858, 1859, 1858,
 1858, 1858, 1858,    0, 1858, 1858, 1858, 1858, 1858, 1858,
    0,    0, 1858, 1858, 1858, 1858, 1858, 1858, 1858, 1858,
 1858,    0,    0,    0,    0,    0, 1858,    0, 1858, 1858,
 1858, 1858, 1858, 1858,    0, 1858,    0,    0, 1667, 1859,
 1859, 1859, 1859, 1859, 1859, 1859,    0,    0,    0,    0,
    0,    0,    0, 1233,    0,    0, 1859, 1859, 1859, 1859,
 1859,  155, 1234,    0,  155,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1235,  155,    0,    0,    0,
  155,    0,  155,    0,    0,    0,    0,    0,    0, 1859,
    0, 1859,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  167,    0,    0,  167,    0,    0,    0, 1236,
    0,    0,    0,    0,    0,    0, 1237,  167,    0,    0,
  155,  167,    0,  167, 1238,    0,  155,  155,  155,    0,
  155,  155,  155,    0,  155,    0,    0,    0,    0,    0,
    0, 1239,    0, 1240,    0,    0,    0,    0,  155,    0,
  155,    0,    0, 1241,    0, 1242, 1243, 1244,    0,    0,
    0,  167, 1245,    0,    0,    0,    0,  167,  167,  167,
    0,  167,  167,  167,    0,  167,    0,    0,    0,  155,
    0,    0,    0,    0,  154,    0,    0,    0,    0,  167,
    0,  167,    0,    0,    0,  155,    0,    0,    0,    0,
    0,    0,    0, 1246,    0,    0,    0,    0,    0,  167,
    0,    0,    0,    0,    0,    0,    0,  155,    0,    0,
  167,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  167,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  155,  155,    0,    0, 1859,    0, 1859,  167,    0,
 1859,    0, 1859, 1859,    0,    0, 1859, 1859,  155, 1859,
    0,    0,    0,    0,    0, 1859,    0, 1859, 1859, 1859,
 1859,    0, 1859,    0,    0, 1859,    0,    0, 1859,    0,
    0,    0,  167,  167,    0, 1859,    0, 1859, 1859,    0,
 1859, 1859, 1859, 1859, 1859,    0,    0, 1859,    0,  167,
 1859,    0, 1859, 1859,    0,    0, 1859, 1859, 1859,    0,
 1859, 1859, 1859, 1859, 1859, 1859, 1859,    0,    0,    0,
 1859, 1859, 1859, 1859, 1859,    0,    0,    0, 1859,    0,
    0,    0,    0,    0,    0,    0, 1859, 1859, 1859, 1859,
 1859, 1859,    0,    0,    0, 1859, 1859,    0, 1859,    0,
 1859,    0, 1859, 1859, 1859,    0, 1859,    0, 1859, 1859,
 1859,    0, 1859, 1859, 1859, 1859, 1859,    0, 1859, 1859,
    0,    0,    0,    0, 1859,    0, 1859, 1859,    0, 1247,
 1859, 1859, 1859,    0,    0, 1859,    0, 1859,    0,    0,
 1859, 1859, 1859, 1859,    0, 1859,    0, 1859,    0, 1859,
 1859, 1859, 1859, 1859,    0,    0, 1859, 1859, 1859,    0,
 1859, 1859,    0,    0,    0,    0,    0,  155,    0,    0,
    0, 1859, 1859, 1859,    0, 1859, 1859, 1859,    0, 1859,
    0,    0,    0, 1859,    0, 1859, 1859, 1859, 1859, 2003,
 1859,    0, 1859, 1859, 1859, 1859, 1859, 1859, 1859, 1859,
    0,    0,    0,    0,    0, 1249, 1248, 1250,  167, 1859,
 1859,    0, 1859, 1859, 1859,    0,    0,    0,    0, 1859,
 1859, 1859, 1859, 1859,    0, 1859,    0,    0, 1859, 1859,
    0,    0,    0, 1859, 1859,    0,    0, 1859, 1859, 1859,
 1859, 1859, 1859, 1859, 1859, 1859,    0, 1859,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1859, 1859, 1859,
 1859, 1859, 1859, 1859, 1859, 1859, 1859, 1859, 1859, 1859,
 1859, 1859, 1859, 1859, 1859, 1859, 1859, 1859,    0, 1859,
 1859, 1859, 1859, 1859, 1859,    0, 1859, 1859, 1859, 1859,
    0, 1859,    0, 1859, 1859, 1859, 1859, 1859, 1859, 1859,
 1859, 1859, 1859, 1859, 1859, 1859, 1859, 1859, 1859, 1859,
 1859,    0, 1859, 1859, 1859, 1859,    0, 1859, 1859, 1859,
 1859, 1859,    0, 1859, 1859, 1859, 1859, 1859, 1859, 1859,
 1859, 1859, 1859, 1859, 1859, 1859, 1859, 1859, 1859, 1859,
 1859, 1859, 1859, 1859, 1859, 1859, 1859, 1859, 1859, 1859,
 1859, 1859, 1860, 1859, 1859, 1859, 1859,    0, 1859, 1859,
 1859, 1859, 1859, 1859,    0,    0, 1859, 1859, 1859, 1859,
 1859, 1859, 1859, 1859, 1859,    0,    0,    0,    0,    0,
 1859,    0, 1859, 1859, 1859, 1859, 1859, 1859,    0, 1859,
    0,    0, 1668, 1860, 1860, 1860, 1860, 1860, 1860, 1860,
    0,    0,    0,    0,    0,    0,    0, 1233,    0,    0,
 1860, 1860, 1860, 1860, 1860, 2585, 1234,    0, 1061,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1235,
 2586,    0,    0,    0, 1062,    0, 1063,    0,    0,    0,
    0,    0,    0, 1860,    0, 1860,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  263,    0,    0,  263,
    0,    0,    0, 1236,    0,    0,    0,    0,    0,    0,
 1237,    0,    0,    0, 1064,  263,    0,  263, 1238,    0,
 1065, 1066, 1067,    0, 1068, 1069, 1070,    0, 1071,    0,
    0,    0,    0,    0,    0, 1239,    0, 1240,    0,    0,
    0,    0, 1072,    0, 1073,    0,    0, 1241,    0, 1242,
 1243, 1244,    0,    0,    0,  263, 1245,    0,    0,    0,
    0,  263,  263,  263,    0,  263,  263,  263,    0,  263,
    0,    0,    0, 1074,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  263,    0,  263,    0,    0,    0, 1075,
    0,    0,    0,    0,    0,    0,    0, 1246,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1076,    0,    0,  263,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  263,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1077, 1078,    0,    0, 1860,
    0, 1860,  263,    0, 1860,    0, 1860, 1860,    0,    0,
 1860, 1860, 1079, 1860,    0,    0,    0,    0,    0, 1860,
    0, 1860, 1860, 1860, 1860,    0, 1860,    0,    0, 1860,
    0,    0, 1860,    0,    0,    0,  263,  263,    0, 1860,
    0, 1860, 1860,    0, 1860, 1860, 1860, 1860, 1860,    0,
    0, 1860,    0,  263, 1860,    0, 1860, 1860,    0,    0,
 1860, 1860, 1860,    0, 1860, 1860, 1860, 1860, 1860, 1860,
 1860,    0,    0,    0, 1860, 1860, 1860, 1860, 1860,    0,
    0,    0, 1860,    0,    0,    0,    0,    0,    0,    0,
 1860, 1860, 1860, 1860, 1860, 1860,    0,    0,    0, 1860,
 1860,    0, 1860,    0, 1860,    0, 1860, 1860, 1860,    0,
 1860,    0, 1860, 1860, 1860,    0, 1860, 1860, 1860, 1860,
 1860,    0, 1860, 1860,    0,    0,    0,    0, 1860,    0,
 1860, 1860,    0, 1247, 1860, 1860, 1860,    0,    0, 1860,
    0, 1860,    0,    0, 1860, 1860, 1860, 1860,    0, 1860,
    0, 1860,    0, 1860, 1860, 1860, 1860, 1860,    0,    0,
 1860, 1860, 1860,    0, 1860, 1860,    0,    0,    0,    0,
    0, 1080,    0,    0,    0, 1860, 1860, 1860,    0, 1860,
 1860, 1860,    0, 1860,    0,    0,    0, 1860,    0, 1860,
 1860, 1860, 1860, 2004, 1860,    0, 1860, 1860, 1860, 1860,
 1860, 1860, 1860, 1860,    0,    0,    0,    0,    0, 1249,
 1248, 1250,  263, 1860, 1860,    0, 1860, 1860, 1860,    0,
    0,    0,    0, 1860, 1860, 1860, 1860, 1860,    0, 1860,
    0,    0, 1860, 1860,    0,    0,    0, 1860, 1860,    0,
    0, 1860, 1860, 1860, 1860, 1860, 1860, 1860, 1860, 1860,
    0, 1860,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1860, 1860, 1860, 1860, 1860, 1860, 1860, 1860, 1860,
 1860, 1860, 1860, 1860, 1860, 1860, 1860, 1860, 1860, 1860,
 1860, 1860,    0, 1860, 1860, 1860, 1860, 1860, 1860,    0,
 1860, 1860, 1860, 1860,    0, 1860,    0, 1860, 1860, 1860,
 1860, 1860, 1860, 1860, 1860, 1860, 1860, 1860, 1860, 1860,
 1860, 1860, 1860, 1860, 1860,    0, 1860, 1860, 1860, 1860,
    0, 1860, 1860, 1860, 1860, 1860,    0, 1860, 1860, 1860,
 1860, 1860, 1860, 1860, 1860, 1860, 1860, 1860, 1860, 1860,
 1860, 1860, 1860, 1860, 1860, 1860, 1860, 1860, 1860, 1860,
 1860, 1860, 1860, 1860, 1860, 1860, 1861, 1860, 1860, 1860,
 1860,    0, 1860, 1860, 1860, 1860, 1860, 1860,    0,    0,
 1860, 1860, 1860, 1860, 1860, 1860, 1860, 1860, 1860,    0,
    0,    0,    0,    0, 1860,    0, 1860, 1860, 1860, 1860,
 1860, 1860,    0, 1860,    0,    0, 1669, 1861, 1861, 1861,
 1861, 1861, 1861, 1861,    0,    0,    0,    0,    0,    0,
    0, 1233,    0,    0, 1861, 1861, 1861, 1861, 1861,    0,
 1234,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1627, 1235,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1861,    0, 1861,
    0,    0,    0,    0,    0,    0,    0, 1628,    0,    0,
    0,    0,    0, 1629,    0,    0,    0, 1236, 1630,    0,
    0,    0,    0, 1631, 1237,    0, 1632,    0,    0,    0,
    0,    0, 1238,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1239,
    0, 1240,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1241,    0, 1242, 1243, 1244,    0,    0,    0,    0,
 1245,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1633,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1246,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1634,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1635,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1636,    0,    0,
    0,    0,    0, 1861,    0, 1861,    0,    0, 1861,    0,
 1861, 1861,    0,    0, 1861, 1861,    0, 1861,    0,    0,
    0,    0,    0, 1861,    0, 1861, 1861, 1861, 1861,    0,
 1861,    0,    0, 1861,    0,    0, 1861,    0,    0,    0,
    0,    0,    0, 1861,    0, 1861, 1861,    0, 1861, 1861,
 1861, 1861, 1861, 1637,    0, 1861, 1638,    0, 1861,    0,
 1861, 1861,    0,    0, 1861, 1861, 1861,    0, 1861, 1861,
 1861, 1861, 1861, 1861, 1861,    0,    0,    0, 1861, 1861,
 1861, 1861, 1861,    0,    0,    0, 1861,    0,    0,    0,
    0,    0,    0,    0, 1861, 1861, 1861, 1861, 1861, 1861,
    0,    0,    0, 1861, 1861,    0, 1861,    0, 1861,    0,
 1861, 1861, 1861,    0, 1861,    0, 1861, 1861, 1861,    0,
 1861, 1861, 1861, 1861, 1861,    0, 1861, 1861,    0,    0,
    0,    0, 1861,    0, 1861, 1861,    0, 1247, 1861, 1861,
 1861,    0,    0, 1861,    0, 1861,    0,    0, 1861, 1861,
 1861, 1861,    0, 1861,    0, 1861,    0, 1861, 1861, 1861,
 1861, 1861, 1639,    0, 1861, 1861, 1861,    0, 1861, 1861,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1861,
 1861, 1861,    0, 1861, 1861, 1861,    0, 1861,    0,    0,
    0, 1861,    0, 1861, 1861, 1861, 1861, 2005, 1861,    0,
 1861, 1861, 1861, 1861, 1861, 1861, 1861, 1861,    0,    0,
    0,    0,    0, 1249, 1248, 1250,    0, 1861, 1861,    0,
 1861, 1861, 1861,    0,    0,    0,    0, 1861, 1861, 1861,
 1861, 1861,    0, 1861,    0,    0, 1861, 1861,    0,    0,
    0, 1861, 1861,    0,    0, 1861, 1861, 1861, 1861, 1861,
 1861, 1861, 1861, 1861,    0, 1861,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1861, 1861, 1861, 1861, 1861,
 1861, 1861, 1861, 1861, 1861, 1861, 1861, 1861, 1861, 1861,
 1861, 1861, 1861, 1861, 1861, 1861,    0, 1861, 1861, 1861,
 1861, 1861, 1861,    0, 1861, 1861, 1861, 1861,    0, 1861,
    0, 1861, 1861, 1861, 1861, 1861, 1861, 1861, 1861, 1861,
 1861, 1861, 1861, 1861, 1861, 1861, 1861, 1861, 1861,    0,
 1861, 1861, 1861, 1861,    0, 1861, 1861, 1861, 1861, 1861,
    0, 1861, 1861, 1861, 1861, 1861, 1861, 1861, 1861, 1861,
 1861, 1861, 1861, 1861, 1861, 1861, 1861, 1861, 1861, 1861,
 1861, 1861, 1861, 1861, 1861, 1861, 1861, 1861, 1861, 1861,
 1862, 1861, 1861, 1861, 1861,    0, 1861, 1861, 1861, 1861,
 1861, 1861,    0,    0, 1861, 1861, 1861, 1861, 1861, 1861,
 1861, 1861, 1861,    0,    0,    0,    0,    0, 1861,    0,
 1861, 1861, 1861, 1861, 1861, 1861,    0, 1861,    0,    0,
 1670, 1862, 1862, 1862, 1862, 1862, 1862, 1862,    0,    0,
    0,    0,    0,    0,    0, 1233,    0,    0, 1862, 1862,
 1862, 1862, 1862,    0, 1234,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   77, 1235,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1862,    0, 1862,    0,    0,    0,    0,    0,    0,
    0,   77,    0,    0,    0,    0,    0,   77,    0,    0,
    0, 1236,   77,    0,    0,    0,    0,   77, 1237,    0,
   77,    0,    0,    0,    0,    0, 1238,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1239,    0, 1240,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1241,    0, 1242, 1243, 1244,
    0,    0,    0,    0, 1245,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   77,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1246,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   77,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   77,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   77,    0,    0,    0,    0,    0, 1862,    0, 1862,
    0,    0, 1862,    0, 1862, 1862,    0,    0, 1862, 1862,
    0, 1862,    0,    0,    0,    0,    0, 1862,    0, 1862,
 1862, 1862, 1862,    0, 1862,    0,    0, 1862,    0,    0,
 1862,    0,    0,    0,    0,    0,    0, 1862,    0, 1862,
 1862,    0, 1862, 1862, 1862, 1862, 1862,   77,    0, 1862,
   77,    0, 1862,    0, 1862, 1862,    0,    0, 1862, 1862,
 1862,    0, 1862, 1862, 1862, 1862, 1862, 1862, 1862,    0,
    0,    0, 1862, 1862, 1862, 1862, 1862,    0,    0,    0,
 1862,    0,    0,    0,    0,    0,    0,    0, 1862, 1862,
 1862, 1862, 1862, 1862,    0,    0,    0, 1862, 1862,    0,
 1862,    0, 1862,    0, 1862, 1862, 1862,    0, 1862,    0,
 1862, 1862, 1862,    0, 1862, 1862, 1862, 1862, 1862,    0,
 1862, 1862,    0,    0,    0,    0, 1862,    0, 1862, 1862,
    0, 1247, 1862, 1862, 1862,    0,    0, 1862,    0, 1862,
    0,    0, 1862, 1862, 1862, 1862,    0, 1862,    0, 1862,
    0, 1862, 1862, 1862, 1862, 1862,   77,    0, 1862, 1862,
 1862,    0, 1862, 1862,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1862, 1862, 1862,    0, 1862, 1862, 1862,
    0, 1862,    0,    0,    0, 1862,    0, 1862, 1862, 1862,
 1862, 2006, 1862,    0, 1862, 1862, 1862, 1862, 1862, 1862,
 1862, 1862,    0,    0,    0,    0,    0, 1249, 1248, 1250,
    0, 1862, 1862,    0, 1862, 1862, 1862,    0,    0,    0,
    0, 1862, 1862, 1862, 1862, 1862,    0, 1862,    0,    0,
 1862, 1862,    0,    0,    0, 1862, 1862,    0,    0, 1862,
 1862, 1862, 1862, 1862, 1862, 1862, 1862, 1862,    0, 1862,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1862,
 1862, 1862, 1862, 1862, 1862, 1862, 1862, 1862, 1862, 1862,
 1862, 1862, 1862, 1862, 1862, 1862, 1862, 1862, 1862, 1862,
    0, 1862, 1862, 1862, 1862, 1862, 1862,    0, 1862, 1862,
 1862, 1862,    0, 1862,    0, 1862, 1862, 1862, 1862, 1862,
 1862, 1862, 1862, 1862, 1862, 1862, 1862, 1862, 1862, 1862,
 1862, 1862, 1862,    0, 1862, 1862, 1862, 1862,    0, 1862,
 1862, 1862, 1862, 1862,    0, 1862, 1862, 1862, 1862, 1862,
 1862, 1862, 1862, 1862, 1862, 1862, 1862, 1862, 1862, 1862,
 1862, 1862, 1862, 1862, 1862, 1862, 1862, 1862, 1862, 1862,
 1862, 1862, 1862, 1862, 1864, 1862, 1862, 1862, 1862,    0,
 1862, 1862, 1862, 1862, 1862, 1862,    0,    0, 1862, 1862,
 1862, 1862, 1862, 1862, 1862, 1862, 1862,    0,    0,    0,
    0,    0, 1862,    0, 1862, 1862, 1862, 1862, 1862, 1862,
    0, 1862,    0,    0, 1671, 1864, 1864, 1864, 1864, 1864,
 1864, 1864,    0,    0,    0,    0,    0,    0,    0, 1233,
    0,    0, 1864, 1864, 1864, 1864, 1864,    0, 1234,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1235,    0,    0,    0,    0,    0,    0,    0,    0,
  106,    0,    0,    0,    0, 1864,  107, 1864,    0,    0,
  108,  109,    0,    0,    0,    0,  110,    0,    0,  111,
    0,    0,    0,    0,    0, 1236,    0,    0,    0,  112,
    0,    0, 1237,    0,    0,    0,    0,    0,    0,    0,
 1238,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1239,    0, 1240,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1241,
    0, 1242, 1243, 1244,    0,    0,    0,    0, 1245,    0,
    0,    0,    0,    0,    0,    0,    0,  113,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  114,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  115,    0, 1246,
    0,  116,    0,    0,    0,    0,  117,    0,    0,    0,
    0,    0,  118,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  119,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1864,    0, 1864,    0,    0, 1864,    0, 1864, 1864,
    0,    0, 1864, 1864,    0, 1864,    0,    0,    0,    0,
    0, 1864,    0, 1864, 1864, 1864, 1864,    0, 1864,    0,
    0, 1864,    0,    0, 1864,    0,  120,    0,    0,  121,
    0, 1864,    0, 1864, 1864,    0, 1864, 1864, 1864, 1864,
 1864,    0,    0, 1864,    0,    0, 1864,    0, 1864, 1864,
    0,    0, 1864, 1864, 1864,    0, 1864, 1864, 1864, 1864,
 1864, 1864, 1864,    0,    0,    0, 1864, 1864, 1864, 1864,
 1864,    0,  122,    0, 1864,    0,    0,    0,    0,    0,
    0,    0, 1864, 1864, 1864, 1864, 1864, 1864,    0,    0,
    0, 1864, 1864,    0, 1864,    0, 1864,    0, 1864, 1864,
 1864,    0, 1864,    0, 1864, 1864, 1864,    0, 1864, 1864,
 1864, 1864, 1864,    0, 1864, 1864,  123,    0,    0,    0,
 1864,    0, 1864, 1864,    0, 1247, 1864, 1864, 1864,    0,
    0, 1864,    0, 1864,    0,  124, 1864, 1864, 1864, 1864,
    0, 1864,    0, 1864,    0, 1864, 1864, 1864, 1864, 1864,
    0,    0, 1864, 1864, 1864,    0, 1864, 1864,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1864, 1864, 1864,
    0, 1864, 1864, 1864,    0, 1864,    0,    0,    0, 1864,
    0, 1864, 1864, 1864, 1864, 2007, 1864,    0, 1864, 1864,
 1864, 1864, 1864, 1864, 1864, 1864,    0,    0,    0,    0,
    0, 1249, 1248, 1250,    0, 1864, 1864,    0, 1864, 1864,
 1864,    0,    0,    0,    0, 1864, 1864, 1864, 1864, 1864,
    0, 1864,    0,    0, 1864, 1864,    0,    0,    0, 1864,
 1864,    0,    0, 1864, 1864, 1864, 1864, 1864, 1864, 1864,
 1864, 1864,    0, 1864,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1864, 1864, 1864, 1864, 1864, 1864, 1864,
 1864, 1864, 1864, 1864, 1864, 1864, 1864, 1864, 1864, 1864,
 1864, 1864, 1864, 1864,    0, 1864, 1864, 1864, 1864, 1864,
 1864,    0, 1864, 1864, 1864, 1864,    0, 1864,    0, 1864,
 1864, 1864, 1864, 1864, 1864, 1864, 1864, 1864, 1864, 1864,
 1864, 1864, 1864, 1864, 1864, 1864, 1864,    0, 1864, 1864,
 1864, 1864,    0, 1864, 1864, 1864, 1864, 1864,    0, 1864,
 1864, 1864, 1864, 1864, 1864, 1864, 1864, 1864, 1864, 1864,
 1864, 1864, 1864, 1864, 1864, 1864, 1864, 1864, 1864, 1864,
 1864, 1864, 1864, 1864, 1864, 1864, 1864, 1864, 1865, 1864,
 1864, 1864, 1864,    0, 1864, 1864, 1864, 1864, 1864, 1864,
    0,    0, 1864, 1864, 1864, 1864, 1864, 1864, 1864, 1864,
 1864,    0,    0,    0,    0,    0, 1864,    0, 1864, 1864,
 1864, 1864, 1864, 1864,    0, 1864,    0,    0, 1672, 1865,
 1865, 1865, 1865, 1865, 1865, 1865,    0,    0,    0,    0,
    0,    0,    0, 1233,    0,    0, 1865, 1865, 1865, 1865,
 1865,    0, 1234,    0,    0, 1885,    0,    0,    0,    0,
    0, 1886,    0,    0,    0, 1235,    0,    0,    0,    0,
    0, 1887,    0,    0,    0,    0,    0,    0,    0, 1865,
    0, 1865,    0,    0, 1888,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1236,
    0,    0,    0,    0,    0,    0, 1237,    0,    0,    0,
    0,    0,    0,    0, 1238,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1239,    0, 1240,    0,    0,    0,    0,    0,    0,
    0,    0, 1889, 1241,    0, 1242, 1243, 1244,    0,    0,
    0,    0, 1245,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1890,    0,    0,    0, 1891,    0,    0,    0,
    0, 1892,    0,    0,    0,    0,    0, 1893,    0,    0,
    0,    0,    0, 1246,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1894,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1865,    0, 1865,    0,    0,
 1865,    0, 1865, 1865,    0,    0, 1865, 1865,    0, 1865,
    0, 1895,    0,    0, 1896, 1865,    0, 1865, 1865, 1865,
 1865,    0, 1865,    0,    0, 1865,    0,    0, 1865,    0,
    0,    0,    0,    0,    0, 1865,    0, 1865, 1865,    0,
 1865, 1865, 1865, 1865, 1865,    0,    0, 1865,    0,    0,
 1865,    0, 1865, 1865,    0,    0, 1865, 1865, 1865,    0,
 1865, 1865, 1865, 1865, 1865, 1865, 1865,    0,    0,    0,
 1865, 1865, 1865, 1865, 1865,    0,    0,    0, 1865,    0,
    0,    0,    0,    0,    0,    0, 1865, 1865, 1865, 1865,
 1865, 1865,    0,    0,    0, 1865, 1865,    0, 1865,    0,
 1865, 1897, 1865, 1865, 1865,    0, 1865,    0, 1865, 1865,
 1865,    0, 1865, 1865, 1865, 1865, 1865,    0, 1865, 1865,
 1898,    0,    0,    0, 1865,    0, 1865, 1865,    0, 1247,
 1865, 1865, 1865,    0,    0, 1865,    0, 1865,    0,    0,
 1865, 1865, 1865, 1865,    0, 1865,    0, 1865,    0, 1865,
 1865, 1865, 1865, 1865,    0,    0, 1865, 1865, 1865,    0,
 1865, 1865,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1865, 1865, 1865,    0, 1865, 1865, 1865,    0, 1865,
    0,    0,    0, 1865,    0, 1865, 1865, 1865, 1865, 2008,
 1865,    0, 1865, 1865, 1865, 1865, 1865, 1865, 1865, 1865,
    0,    0,    0,    0,    0, 1249, 1248, 1250,    0, 1865,
 1865,    0, 1865, 1865, 1865,    0,    0,    0,    0, 1865,
 1865, 1865, 1865, 1865,    0, 1865,    0,    0, 1865, 1865,
    0,    0,    0, 1865, 1865,    0,    0, 1865, 1865, 1865,
 1865, 1865, 1865, 1865, 1865, 1865,    0, 1865,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1865, 1865, 1865,
 1865, 1865, 1865, 1865, 1865, 1865, 1865, 1865, 1865, 1865,
 1865, 1865, 1865, 1865, 1865, 1865, 1865, 1865,    0, 1865,
 1865, 1865, 1865, 1865, 1865,    0, 1865, 1865, 1865, 1865,
    0, 1865,    0, 1865, 1865, 1865, 1865, 1865, 1865, 1865,
 1865, 1865, 1865, 1865, 1865, 1865, 1865, 1865, 1865, 1865,
 1865,    0, 1865, 1865, 1865, 1865,    0, 1865, 1865, 1865,
 1865, 1865,    0, 1865, 1865, 1865, 1865, 1865, 1865, 1865,
 1865, 1865, 1865, 1865, 1865, 1865, 1865, 1865, 1865, 1865,
 1865, 1865, 1865, 1865, 1865, 1865, 1865, 1865, 1865, 1865,
 1865, 1865, 1866, 1865, 1865, 1865, 1865,    0, 1865, 1865,
 1865, 1865, 1865, 1865,    0,    0, 1865, 1865, 1865, 1865,
 1865, 1865, 1865, 1865, 1865,    0,    0,    0,    0,    0,
 1865,    0, 1865, 1865, 1865, 1865, 1865, 1865,    0, 1865,
    0,    0, 1673, 1866, 1866, 1866, 1866, 1866, 1866, 1866,
    0,    0,    0,    0,    0,    0,    0, 1233,    0,    0,
 1866, 1866, 1866, 1866, 1866,    0, 1234,    0,    0, 1899,
    0,    0,    0,    0,    0, 1900,    0,    0,    0, 1235,
    0,    0,    0,    0,    0, 1901,    0,    0,    0,    0,
    0,    0,    0, 1866,    0, 1866,    0,    0, 1902,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1236,    0,    0,    0,    0,    0,    0,
 1237,    0,    0,    0,    0,    0,    0,    0, 1238,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1239,    0, 1240,    0,    0,
    0,    0,    0,    0,    0,    0, 1903, 1241,    0, 1242,
 1243, 1244,    0,    0,    0,    0, 1245,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1904,    0,    0,    0,
 1905,    0,    0,    0,    0, 1906,    0,    0,    0,    0,
    0, 1907,    0,    0,    0,    0,    0, 1246,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1908,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1866,
    0, 1866,    0,    0, 1866,    0, 1866, 1866,    0,    0,
 1866, 1866,    0, 1866,    0, 1909,    0,    0, 1910, 1866,
    0, 1866, 1866, 1866, 1866,    0, 1866,    0,    0, 1866,
    0,    0, 1866,    0,    0,    0,    0,    0,    0, 1866,
    0, 1866, 1866,    0, 1866, 1866, 1866, 1866, 1866,    0,
    0, 1866,    0,    0, 1866,    0, 1866, 1866,    0,    0,
 1866, 1866, 1866,    0, 1866, 1866, 1866, 1866, 1866, 1866,
 1866,    0,    0,    0, 1866, 1866, 1866, 1866, 1866,    0,
    0,    0, 1866,    0,    0,    0,    0,    0,    0,    0,
 1866, 1866, 1866, 1866, 1866, 1866,    0,    0,    0, 1866,
 1866,    0, 1866,    0, 1866, 1911, 1866, 1866, 1866,    0,
 1866,    0, 1866, 1866, 1866,    0, 1866, 1866, 1866, 1866,
 1866,    0, 1866, 1866, 1912,    0,    0,    0, 1866,    0,
 1866, 1866,    0, 1247, 1866, 1866, 1866,    0,    0, 1866,
    0, 1866,    0,    0, 1866, 1866, 1866, 1866,    0, 1866,
    0, 1866,    0, 1866, 1866, 1866, 1866, 1866,    0,    0,
 1866, 1866, 1866,    0, 1866, 1866,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1866, 1866, 1866,    0, 1866,
 1866, 1866,    0, 1866,    0,    0,    0, 1866,    0, 1866,
 1866, 1866, 1866, 2334, 1866,    0, 1866, 1866, 1866, 1866,
 1866, 1866, 1866, 1866,    0,    0,    0,    0,    0, 1249,
 1248, 1250,    0, 1866, 1866,    0, 1866, 1866, 1866,    0,
    0,    0,    0, 1866, 1866, 1866, 1866, 1866,    0, 1866,
    0,    0, 1866, 1866,    0,    0,    0, 1866, 1866,    0,
    0, 1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866,
    0, 1866,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866,
 1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866,
 1866, 1866,    0, 1866, 1866, 1866, 1866, 1866, 1866,    0,
 1866, 1866, 1866, 1866,    0, 1866,    0, 1866, 1866, 1866,
 1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866,
 1866, 1866, 1866, 1866, 1866,    0, 1866, 1866, 1866, 1866,
    0, 1866, 1866, 1866, 1866, 1866,    0, 1866, 1866, 1866,
 1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866,
 1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866,
 1866, 1866, 1866, 1866, 1866, 1866, 1868, 1866, 1866, 1866,
 1866,    0, 1866, 1866, 1866, 1866, 1866, 1866,    0,    0,
 1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866, 1866,    0,
    0,    0,    0,    0, 1866,    0, 1866, 1866, 1866, 1866,
 1866, 1866,    0, 1866,    0,    0, 1674, 1868, 1868, 1868,
 1868, 1868, 1868, 1868,    0,    0,    0,    0,    0,    0,
    0, 1233,    0,    0, 1868, 1868, 1868, 1868, 1868,    0,
 1234,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1235,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1868,    0, 1868,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1236,    0,    0,
    0,    0,    0,    0, 1237,    0,    0,    0,    0,    0,
    0,    0, 1238,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1239,
    0, 1240,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1241,    0, 1242, 1243, 1244,    0,    0,    0,    0,
 1245,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1246,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1868,    0, 1868,    0,    0, 1868,    0,
 1868, 1868,    0,    0, 1868, 1868,    0, 1868,    0,    0,
    0,    0,    0, 1868,    0, 1868, 1868, 1868, 1868,    0,
 1868,    0,    0, 1868,    0,    0, 1868,    0,    0,    0,
    0,    0,    0, 1868,    0, 1868, 1868,    0, 1868, 1868,
 1868, 1868, 1868,    0,    0, 1868,    0,    0, 1868,    0,
 1868, 1868,    0,    0, 1868, 1868, 1868,    0, 1868, 1868,
 1868, 1868, 1868, 1868, 1868,    0,    0,    0, 1868, 1868,
 1868, 1868, 1868,    0,    0,    0, 1868,    0,    0,    0,
    0,    0,    0,    0, 1868, 1868, 1868, 1868, 1868, 1868,
    0,    0,    0, 1868, 1868,    0, 1868,    0, 1868,    0,
 1868, 1868, 1868,    0, 1868,    0, 1868, 1868, 1868,    0,
 1868, 1868, 1868, 1868, 1868,    0, 1868, 1868,    0,    0,
    0,    0, 1868,    0, 1868, 1868,    0, 1247, 1868, 1868,
 1868,    0,    0, 1868,    0, 1868,    0,    0, 1868, 1868,
 1868, 1868,    0, 1868,    0, 1868,    0, 1868, 1868, 1868,
 1868, 1868,    0,    0, 1868, 1868, 1868,    0, 1868, 1868,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1868,
 1868, 1868,    0, 1868, 1868, 1868,    0, 1868,    0,    0,
    0, 1868,    0, 1868, 1868, 1868, 1868, 2606, 1868,    0,
 1868, 1868, 1868, 1868, 1868, 1868, 1868, 1868,    0,    0,
    0,    0,    0, 1249, 1248, 1250,    0, 1868, 1868,    0,
 1868, 1868, 1868,    0,    0,    0,    0, 1868, 1868, 1868,
 1868, 1868,    0, 1868,    0,    0, 1868, 1868,    0,    0,
    0, 1868, 1868,    0,    0, 1868, 1868, 1868, 1868, 1868,
 1868, 1868, 1868, 1868,    0, 1868,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1868, 1868, 1868, 1868, 1868,
 1868, 1868, 1868, 1868, 1868, 1868, 1868, 1868, 1868, 1868,
 1868, 1868, 1868, 1868, 1868, 1868,    0, 1868, 1868, 1868,
 1868, 1868, 1868,    0, 1868, 1868, 1868, 1868,    0, 1868,
    0, 1868, 1868, 1868, 1868, 1868, 1868, 1868, 1868, 1868,
 1868, 1868, 1868, 1868, 1868, 1868, 1868, 1868, 1868,    0,
 1868, 1868, 1868, 1868,    0, 1868, 1868, 1868, 1868, 1868,
    0, 1868, 1868, 1868, 1868, 1868, 1868, 1868, 1868, 1868,
 1868, 1868, 1868, 1868, 1868, 1868, 1868, 1868, 1868, 1868,
 1868, 1868, 1868, 1868, 1868, 1868, 1868, 1868, 1868, 1868,
 1871, 1868, 1868, 1868, 1868,    0, 1868, 1868, 1868, 1868,
 1868, 1868,    0,    0, 1868, 1868, 1868, 1868, 1868, 1868,
 1868, 1868, 1868,    0,    0,    0,    0,    0, 1868,    0,
 1868, 1868, 1868, 1868, 1868, 1868,    0, 1868,    0,    0,
 1642, 1871, 1871, 1871, 1871, 1871, 1871, 1871,    0,    0,
    0,    0,    0,    0,    0, 1233,    0,    0, 1871, 1871,
 1871, 1871, 1871,    0, 1234,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1235,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1871,    0, 1871,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1236,    0,    0,    0,    0,    0,    0, 1237,    0,
    0,    0,    0,    0,    0,    0, 1238,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1239,    0, 1240,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1241,    0, 1242, 1243, 1244,
    0,    0,    0,    0, 1245,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1246,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1871,    0, 1871,
    0,    0, 1871,    0, 1871, 1871,    0,    0, 1871, 1871,
    0, 1871,    0,    0,    0,    0,    0, 1871,    0, 1871,
 1871, 1871, 1871,    0, 1871,    0,    0, 1871,    0,    0,
 1871,    0,    0,    0,    0,    0,    0, 1871,    0, 1871,
 1871,    0, 1871, 1871, 1871, 1871, 1871,    0,    0, 1871,
    0,    0, 1871,    0, 1871, 1871,    0,    0, 1871, 1871,
 1871,    0, 1871, 1871, 1871, 1871, 1871, 1871, 1871,    0,
    0,    0, 1871, 1871, 1871, 1871, 1871,    0,    0,    0,
 1871,    0,    0,    0,    0,    0,    0,    0, 1871, 1871,
 1871, 1871, 1871, 1871,    0,    0,    0, 1871, 1871,    0,
 1871,    0, 1871,    0, 1871, 1871, 1871,    0, 1871,    0,
 1871, 1871, 1871,    0, 1871, 1871, 1871, 1871, 1871,    0,
 1871, 1871,    0,    0,    0,    0, 1871,    0, 1871, 1871,
    0, 1247, 1871, 1871, 1871,    0,    0, 1871,    0, 1871,
    0,    0, 1871, 1871, 1871, 1871,    0, 1871,    0, 1871,
    0, 1871, 1871, 1871, 1871, 1871,    0,    0, 1871, 1871,
 1871,    0, 1871, 1871,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1871, 1871, 1871,    0, 1871, 1871, 1871,
    0, 1871,    0,    0,    0, 1871,    0, 1871, 1871, 1871,
 1871, 2611, 1871,    0, 1871, 1871, 1871, 1871, 1871, 1871,
 1871, 1871,    0,    0,    0,    0,    0, 1249, 1248, 1250,
    0, 1871, 1871,    0, 1871, 1871, 1871,    0,    0,    0,
    0, 1871, 1871, 1871, 1871, 1871,    0, 1871,    0,    0,
 1871, 1871,    0,    0,    0, 1871, 1871,    0,    0, 1871,
 1871, 1871, 1871, 1871, 1871, 1871, 1871, 1871,    0, 1871,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1871,
 1871, 1871, 1871, 1871, 1871, 1871, 1871, 1871, 1871, 1871,
 1871, 1871, 1871, 1871, 1871, 1871, 1871, 1871, 1871, 1871,
    0, 1871, 1871, 1871, 1871, 1871, 1871,    0, 1871, 1871,
 1871, 1871,    0, 1871,    0, 1871, 1871, 1871, 1871, 1871,
 1871, 1871, 1871, 1871, 1871, 1871, 1871, 1871, 1871, 1871,
 1871, 1871, 1871,    0, 1871, 1871, 1871, 1871,    0, 1871,
 1871, 1871, 1871, 1871,    0, 1871, 1871, 1871, 1871, 1871,
 1871, 1871, 1871, 1871, 1871, 1871, 1871, 1871, 1871, 1871,
 1871, 1871, 1871, 1871, 1871, 1871, 1871, 1871, 1871, 1871,
 1871, 1871, 1871, 1871, 1877, 1871, 1871, 1871, 1871,    0,
 1871, 1871, 1871, 1871, 1871, 1871,    0,    0, 1871, 1871,
 1871, 1871, 1871, 1871, 1871, 1871, 1871,    0,    0,    0,
    0,    0, 1871,    0, 1871, 1871, 1871, 1871, 1871, 1871,
    0, 1871,    0,    0, 1675, 1877, 1877, 1877, 1877, 1877,
 1877, 1877,    0,    0,    0,    0,    0,    0,    0, 1233,
    0,    0, 1877, 1877, 1877, 1877, 1877,    0, 1234,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1235,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1877,    0, 1877,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1236,    0,    0,    0,    0,
    0,    0, 1237,    0,    0,    0,    0,    0,    0,    0,
 1238,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1239,    0, 1240,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1241,
    0, 1242, 1243, 1244,    0,    0,    0,    0, 1245,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1246,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1877,    0, 1877,    0,    0, 1877,    0, 1877, 1877,
    0,    0, 1877, 1877,    0, 1877,    0,    0,    0,    0,
    0, 1877,    0, 1877, 1877, 1877, 1877,    0, 1877,    0,
    0, 1877,    0,    0, 1877,    0,    0,    0,    0,    0,
    0, 1877,    0, 1877, 1877,    0, 1877, 1877, 1877, 1877,
 1877,    0,    0, 1877,    0,    0, 1877,    0, 1877, 1877,
    0,    0, 1877, 1877, 1877,    0, 1877, 1877, 1877, 1877,
 1877, 1877, 1877,    0,    0,    0, 1877, 1877, 1877, 1877,
 1877,    0,    0,    0, 1877,    0,    0,    0,    0,    0,
    0,    0, 1877, 1877, 1877, 1877, 1877, 1877,    0,    0,
    0, 1877, 1877,    0, 1877,    0, 1877,    0, 1877, 1877,
 1877,    0, 1877,    0, 1877, 1877, 1877,    0, 1877, 1877,
 1877, 1877, 1877,    0, 1877, 1877,    0,    0,    0,    0,
 1877,    0, 1877, 1877,    0, 1247, 1877, 1877, 1877,    0,
    0, 1877,    0, 1877,    0,    0, 1877, 1877, 1877, 1877,
    0, 1877,    0, 1877,    0, 1877, 1877, 1877, 1877, 1877,
    0,    0, 1877, 1877, 1877,    0, 1877, 1877,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1877, 1877, 1877,
    0, 1877, 1877, 1877,    0, 1877,    0,    0,    0, 1877,
    0, 1877, 1877, 1877, 1877, 2613, 1877,    0, 1877, 1877,
 1877, 1877, 1877, 1877, 1877, 1877,    0,    0,    0,    0,
    0, 1249, 1248, 1250,    0, 1877, 1877,    0, 1877, 1877,
 1877,    0,    0,    0,    0, 1877, 1877, 1877, 1877, 1877,
    0, 1877,    0,    0, 1877, 1877,    0,    0,    0, 1877,
 1877,    0,    0, 1877, 1877, 1877, 1877, 1877, 1877, 1877,
 1877, 1877,    0, 1877,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1877, 1877, 1877, 1877, 1877, 1877, 1877,
 1877, 1877, 1877, 1877, 1877, 1877, 1877, 1877, 1877, 1877,
 1877, 1877, 1877, 1877,    0, 1877, 1877, 1877, 1877, 1877,
 1877,    0, 1877, 1877, 1877, 1877,    0, 1877,    0, 1877,
 1877, 1877, 1877, 1877, 1877, 1877, 1877, 1877, 1877, 1877,
 1877, 1877, 1877, 1877, 1877, 1877, 1877,    0, 1877, 1877,
 1877, 1877,    0, 1877, 1877, 1877, 1877, 1877,    0, 1877,
 1877, 1877, 1877, 1877, 1877, 1877, 1877, 1877, 1877, 1877,
 1877, 1877, 1877, 1877, 1877, 1877, 1877, 1877, 1877, 1877,
 1877, 1877, 1877, 1877, 1877, 1877, 1877, 1877, 1884, 1877,
 1877, 1877, 1877,    0, 1877, 1877, 1877, 1877, 1877, 1877,
    0,    0, 1877, 1877, 1877, 1877, 1877, 1877, 1877, 1877,
 1877,    0,    0,    0,    0,    0, 1877,    0, 1877, 1877,
 1877, 1877, 1877, 1877,    0, 1877,    0,    0, 1636, 1884,
 1884, 1884, 1884, 1884, 1884, 1884,    0,    0,    0,    0,
    0,    0,    0, 1233,    0,    0, 1884, 1884, 1884, 1884,
 1884,    0, 1234,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1235,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1884,
    0, 1884,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1236,
    0,    0,    0,    0,    0,    0, 1237,    0,    0,    0,
    0,    0,    0,    0, 1238,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1239,    0, 1240,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1241,    0, 1242, 1243, 1244,    0,    0,
    0,    0, 1245,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1246,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1884,    0, 1884,    0,    0,
 1884,    0, 1884, 1884,    0,    0, 1884, 1884,    0, 1884,
    0,    0,    0,    0,    0, 1884,    0, 1884, 1884, 1884,
 1884,    0, 1884,    0,    0, 1884,    0,    0, 1884,    0,
    0,    0,    0,    0,    0, 1884,    0, 1884, 1884,    0,
 1884, 1884, 1884, 1884, 1884,    0,    0, 1884,    0,    0,
 1884,    0, 1884, 1884,    0,    0, 1884, 1884, 1884,    0,
 1884, 1884, 1884, 1884, 1884, 1884, 1884,    0,    0,    0,
 1884, 1884, 1884, 1884, 1884,    0,    0,    0, 1884,    0,
    0,    0,    0,    0,    0,    0, 1884, 1884, 1884, 1884,
 1884, 1884,    0,    0,    0, 1884, 1884,    0, 1884,    0,
 1884,    0, 1884, 1884, 1884,    0, 1884,    0, 1884, 1884,
 1884,    0, 1884, 1884, 1884, 1884, 1884,    0, 1884, 1884,
    0,    0,    0,    0, 1884,    0, 1884, 1884,    0, 1247,
 1884, 1884, 1884,    0,    0, 1884,    0, 1884,    0,    0,
 1884, 1884, 1884, 1884,    0, 1884,    0, 1884,    0, 1884,
 1884, 1884, 1884, 1884,    0,    0, 1884, 1884, 1884,    0,
 1884, 1884,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1884, 1884, 1884,    0, 1884, 1884, 1884,    0, 1884,
    0,    0,    0, 1884,    0, 1884, 1884, 1884, 1884, 2614,
 1884,    0, 1884, 1884, 1884, 1884, 1884, 1884, 1884, 1884,
    0,    0,    0,    0,    0, 1249, 1248, 1250,    0, 1884,
 1884,    0, 1884, 1884, 1884,    0,    0,    0,    0, 1884,
 1884, 1884, 1884, 1884,    0, 1884,    0,    0, 1884, 1884,
    0,    0,    0, 1884, 1884,    0,    0, 1884, 1884, 1884,
 1884, 1884, 1884, 1884, 1884, 1884,    0, 1884,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1884, 1884, 1884,
 1884, 1884, 1884, 1884, 1884, 1884, 1884, 1884, 1884, 1884,
 1884, 1884, 1884, 1884, 1884, 1884, 1884, 1884,    0, 1884,
 1884, 1884, 1884, 1884, 1884,    0, 1884, 1884, 1884, 1884,
    0, 1884,    0, 1884, 1884, 1884, 1884, 1884, 1884, 1884,
 1884, 1884, 1884, 1884, 1884, 1884, 1884, 1884, 1884, 1884,
 1884,    0, 1884, 1884, 1884, 1884,    0, 1884, 1884, 1884,
 1884, 1884,    0, 1884, 1884, 1884, 1884, 1884, 1884, 1884,
 1884, 1884, 1884, 1884, 1884, 1884, 1884, 1884, 1884, 1884,
 1884, 1884, 1884, 1884, 1884, 1884, 1884, 1884, 1884, 1884,
 1884, 1884, 1959, 1884, 1884, 1884, 1884,    0, 1884, 1884,
 1884, 1884, 1884, 1884,    0,    0, 1884, 1884, 1884, 1884,
 1884, 1884, 1884, 1884, 1884,    0,    0,    0,    0,    0,
 1884,    0, 1884, 1884, 1884, 1884, 1884, 1884,    0, 1884,
    0,    0, 1661, 1959, 1959, 1959, 1959, 1959, 1959, 1959,
    0,    0,    0,    0,    0,    0,    0, 1233,    0,    0,
 1959, 1959, 1959, 1959, 1959,    0, 1234,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1235,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1959,    0, 1959,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1236,    0,    0,    0,    0,    0,    0,
 1237,    0,    0,    0,    0,    0,    0,    0, 1238,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1239,    0, 1240,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1241,    0, 1242,
 1243, 1244,    0,    0,    0,    0, 1245,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1246,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1959,
    0, 1959,    0,    0, 1959,    0, 1959, 1959,    0,    0,
 1959, 1959,    0, 1959,    0,    0,    0,    0,    0, 1959,
    0, 1959, 1959, 1959, 1959,    0, 1959,    0,    0, 1959,
    0,    0, 1959,    0,    0,    0,    0,    0,    0, 1959,
    0, 1959, 1959,    0, 1959, 1959, 1959, 1959, 1959,    0,
    0, 1959,    0,    0, 1959,    0, 1959, 1959,    0,    0,
 1959, 1959, 1959,    0, 1959, 1959, 1959, 1959, 1959, 1959,
 1959,    0,    0,    0, 1959, 1959, 1959, 1959, 1959,    0,
    0,    0, 1959,    0,    0,    0,    0,    0,    0,    0,
 1959, 1959, 1959, 1959, 1959, 1959,    0,    0,    0, 1959,
 1959,    0, 1959,    0, 1959,    0, 1959, 1959, 1959,    0,
 1959,    0, 1959, 1959, 1959,    0, 1959, 1959, 1959, 1959,
 1959,    0, 1959, 1959,    0,    0,    0,    0, 1959,    0,
 1959, 1959,    0, 1247, 1959, 1959, 1959,    0,    0, 1959,
    0, 1959,    0,    0, 1959, 1959, 1959, 1959,    0, 1959,
    0, 1959,    0, 1959, 1959, 1959, 1959, 1959,    0,    0,
 1959, 1959, 1959,    0, 1959, 1959,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1959, 1959, 1959,    0, 1959,
 1959, 1959,    0, 1959,    0,    0,    0, 1959,    0, 1959,
 1959, 1959, 1959, 1470, 1959,    0, 1959, 1959, 1959, 1959,
 1959, 1959, 1959, 1959,    0,    0,    0,    0,    0, 1470,
 1470, 1470,    0, 1959, 1959,    0, 1959, 1959, 1959,    0,
    0,    0,    0, 1959, 1959, 1959, 1959, 1959,    0, 1959,
    0,    0, 1959, 1959,    0,    0,    0, 1959, 1959,    0,
    0, 1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959,
    0, 1959,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959,
 1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959,
 1959, 1959,    0, 1959, 1959, 1959, 1959, 1959, 1959,    0,
 1959, 1959, 1959, 1959,    0, 1959,    0, 1959, 1959, 1959,
 1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959,
 1959, 1959, 1959, 1959, 1959,    0, 1959, 1959, 1959, 1959,
    0, 1959, 1959, 1959, 1959, 1959,    0, 1959, 1959, 1959,
 1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959,
 1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959,
 1959, 1959, 1959, 1959, 1959, 1959, 1960, 1959, 1959, 1959,
 1959,    0, 1959, 1959, 1959, 1959, 1959, 1959,    0,    0,
 1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959, 1959,    0,
    0,    0,    0,    0, 1959,    0, 1959, 1959, 1959, 1959,
 1959, 1959,    0, 1959,    0,    0, 1662, 1960, 1960, 1960,
 1960, 1960, 1960, 1960,    0,    0,    0,    0,    0,    0,
    0, 1470,    0,    0, 1960, 1960, 1960, 1960, 1960,    0,
 1470,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1470,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1960,    0, 1960,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1470,    0,    0,
    0,    0,    0,    0, 1470,    0,    0,    0,    0,    0,
    0,    0, 1470,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1470,
    0, 1470,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1470,    0, 1470, 1470, 1470,    0,    0,    0,    0,
 1470,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1470,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1960,    0, 1960,    0,    0, 1960,    0,
 1960, 1960,    0,    0, 1960, 1960,    0, 1960,    0,    0,
    0,    0,    0, 1960,    0, 1960, 1960, 1960, 1960,    0,
 1960,    0,    0, 1960,    0,    0, 1960,    0,    0,    0,
    0,    0,    0, 1960,    0, 1960, 1960,    0, 1960, 1960,
 1960, 1960, 1960,    0,    0, 1960,    0,    0, 1960,    0,
 1960, 1960,    0,    0, 1960, 1960, 1960,    0, 1960, 1960,
 1960, 1960, 1960, 1960, 1960,    0,    0,    0, 1960, 1960,
 1960, 1960, 1960,    0,    0,    0, 1960,    0,    0,    0,
    0,    0,    0,    0, 1960, 1960, 1960, 1960, 1960, 1960,
    0,    0,    0, 1960, 1960,    0, 1960,    0, 1960,    0,
 1960, 1960, 1960,    0, 1960,    0, 1960, 1960, 1960,    0,
 1960, 1960, 1960, 1960, 1960,    0, 1960, 1960,    0,    0,
    0,    0, 1960,    0, 1960, 1960,    0, 1470, 1960, 1960,
 1960,    0,    0, 1960,    0, 1960,    0,    0, 1960, 1960,
 1960, 1960,    0, 1960,    0, 1960,    0, 1960, 1960, 1960,
 1960, 1960,    0,    0, 1960, 1960, 1960,    0, 1960, 1960,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1960,
 1960, 1960,    0, 1960, 1960, 1960,    0, 1960,    0,    0,
    0, 1960,    0, 1960, 1960, 1960, 1960, 1469, 1960,    0,
 1960, 1960, 1960, 1960, 1960, 1960, 1960, 1960,    0,    0,
    0,    0,    0, 1469, 1469, 1469,    0, 1960, 1960,    0,
 1960, 1960, 1960,    0,    0,    0,    0, 1960, 1960, 1960,
 1960, 1960,    0, 1960,    0,    0, 1960, 1960,    0,    0,
    0, 1960, 1960,    0,    0, 1960, 1960, 1960, 1960, 1960,
 1960, 1960, 1960, 1960,    0, 1960,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1960, 1960, 1960, 1960, 1960,
 1960, 1960, 1960, 1960, 1960, 1960, 1960, 1960, 1960, 1960,
 1960, 1960, 1960, 1960, 1960, 1960,    0, 1960, 1960, 1960,
 1960, 1960, 1960,    0, 1960, 1960, 1960, 1960,    0, 1960,
    0, 1960, 1960, 1960, 1960, 1960, 1960, 1960, 1960, 1960,
 1960, 1960, 1960, 1960, 1960, 1960, 1960, 1960, 1960,    0,
 1960, 1960, 1960, 1960,    0, 1960, 1960, 1960, 1960, 1960,
    0, 1960, 1960, 1960, 1960, 1960, 1960, 1960, 1960, 1960,
 1960, 1960, 1960, 1960, 1960, 1960, 1960, 1960, 1960, 1960,
 1960, 1960, 1960, 1960, 1960, 1960, 1960, 1960, 1960, 1960,
 1945, 1960, 1960, 1960, 1960,    0, 1960, 1960, 1960, 1960,
 1960, 1960,    0,    0, 1960, 1960, 1960, 1960, 1960, 1960,
 1960, 1960, 1960,    0,    0,    0,    0,    0, 1960,    0,
 1960, 1960, 1960, 1960, 1960, 1960,    0, 1960,    0,    0,
 1627, 1945, 1945, 1945, 1945, 1945, 1945, 1945,    0,    0,
    0,    0,    0,    0,    0, 1469,    0,    0, 1945, 1945,
 1945, 1945, 1945,    0, 1469,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1469,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1945,    0, 1945,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1469,    0,    0,    0,    0,    0,    0, 1469,    0,
    0,    0,    0,    0,    0,    0, 1469,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1469,    0, 1469,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1469,    0, 1469, 1469, 1469,
    0,    0,    0,    0, 1469,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1469,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1945,    0, 1945,
    0,    0, 1945,    0, 1945, 1945,    0,    0, 1945, 1945,
    0, 1945,    0,    0,    0,    0,    0, 1945,    0, 1945,
 1945, 1945, 1945,    0, 1945,    0,    0, 1945,    0,    0,
 1945,    0,    0,    0,    0,    0,    0, 1945,    0, 1945,
 1945,    0, 1945, 1945, 1945, 1945, 1945,    0,    0, 1945,
    0,    0, 1945,    0, 1945, 1945,    0,    0, 1945, 1945,
 1945,    0, 1945, 1945, 1945, 1945, 1945, 1945, 1945,    0,
    0,    0, 1945, 1945, 1945, 1945, 1945,    0,    0,    0,
 1945,    0,    0,    0,    0,    0,    0,    0, 1945, 1945,
 1945, 1945, 1945, 1945,    0,    0,    0, 1945, 1945,    0,
 1945,    0, 1945,    0, 1945, 1945, 1945,    0, 1945,    0,
 1945, 1945, 1945,    0, 1945, 1945, 1945, 1945, 1945,    0,
 1945, 1945,    0,    0,    0,    0, 1945,    0, 1945, 1945,
    0, 1469, 1945, 1945, 1945,    0,    0, 1945,    0, 1945,
    0,    0, 1945, 1945, 1945, 1945,    0, 1945,    0, 1945,
    0, 1945, 1945, 1945, 1945, 1945,    0,    0, 1945, 1945,
 1945,    0, 1945, 1945,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1945, 1945, 1945,    0, 1945, 1945, 1945,
    0, 1945,    0,    0,    0, 1945,    0, 1945, 1945, 1945,
 1945,    0, 1945,    0, 1945, 1945, 1945, 1945, 1945, 1945,
 1945, 1945,    0,    0,    0,    0,    0, 1249, 1248, 1250,
    0, 1945, 1945,    0, 1945, 1945, 1945,    0,    0,    0,
    0, 1945, 1945, 1945, 1945, 1945,    0, 1945,    0,    0,
 1945, 1945,    0,    0,    0, 1945, 1945,    0,    0, 1945,
 1945, 1945, 1945, 1945, 1945, 1945, 1945, 1945,    0, 1945,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1945,
 1945, 1945, 1945, 1945, 1945, 1945, 1945, 1945, 1945, 1945,
 1945, 1945, 1945, 1945, 1945, 1945, 1945, 1945, 1945, 1945,
    0, 1945, 1945, 1945, 1945, 1945, 1945,    0, 1945, 1945,
 1945, 1945,    0, 1945,    0, 1945, 1945, 1945, 1945, 1945,
 1945, 1945, 1945, 1945, 1945, 1945, 1945, 1945, 1945, 1945,
 1945, 1945, 1945,    0, 1945, 1945, 1945, 1945,    0, 1945,
 1945, 1945, 1945, 1945,    0, 1945, 1945, 1945, 1945, 1945,
 1945, 1945, 1945, 1945, 1945, 1945, 1945, 1945, 1945, 1945,
 1945, 1945, 1945, 1945, 1945, 1945, 1945, 1945, 1945, 1945,
 1945, 1945, 1945, 1945, 1946, 1945, 1945, 1945, 1945,    0,
 1945, 1945, 1945, 1945, 1945, 1945,    0,    0, 1945, 1945,
 1945, 1945, 1945, 1945, 1945, 1945, 1945,    0,    0,    0,
    0,    0, 1945,    0, 1945, 1945, 1945, 1945, 1945, 1945,
    0, 1945,    0,    0, 1631, 1946, 1946, 1946, 1946, 1946,
 1946, 1946,    0,    0,    0,    0,    0,    0,    0, 1233,
    0,    0, 1946, 1946, 1946, 1946, 1946,    0, 1234,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1235,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1946,    0, 1946,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1236,    0,    0,    0,    0,
    0,    0, 1237,    0,    0,    0,    0,    0,    0,    0,
 1238,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1239,    0, 1240,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1241,
    0, 1242, 1243, 1244,    0,    0,    0,    0, 1245,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1246,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1498, 1499, 1500, 1501, 1502, 1503, 1504, 1505,    0,
    0, 1946,    0, 1946,    0,    0, 1946,    0, 1946, 1946,
    0,    0, 1946, 1946,    0, 1946,    0,    0,    0,    0,
    0, 1946,    0, 1946, 1946, 1946, 1946,    0, 1946,    0,
    0, 1946,    0,    0, 1946,    0,    0,    0,    0,    0,
    0, 1946,    0, 1946, 1946,    0, 1946, 1946, 1946, 1946,
 1946,    0,    0, 1946,    0,    0, 1946,    0, 1946, 1946,
    0,    0, 1946, 1946, 1946,    0, 1946, 1946, 1946, 1946,
 1946, 1946, 1946,    0,    0,    0, 1946, 1946, 1946, 1946,
 1946,    0,    0,    0, 1946,    0,    0,    0,    0,    0,
    0,    0, 1946, 1946, 1946, 1946, 1946, 1946,    0,    0,
 1506, 1946, 1946,    0, 1946,    0, 1946,    0, 1946, 1946,
 1946,    0, 1946,    0, 1946, 1946, 1946,    0, 1946, 1946,
 1946, 1946, 1946,    0, 1946, 1946, 1507,    0,    0,    0,
 1946,    0, 1946, 1946,    0, 1247, 1946, 1946, 1946,    0,
    0, 1946,    0, 1946,    0,    0, 1946, 1946, 1946, 1946,
    0, 1946,    0, 1946,    0, 1946, 1946, 1946, 1946, 1946,
    0,    0, 1946, 1946, 1946,    0, 1946, 1946,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1946, 1946, 1946,
    0, 1946, 1946, 1946,    0, 1946,    0,    0,    0, 1946,
    0, 1946, 1946, 1946, 1946,    0, 1946,    0, 1946, 1946,
 1946, 1946, 1946, 1946, 1946, 1946,    0,    0,    0,    0,
 1249, 1248, 1250,    0,    0, 1946, 1946,    0, 1946, 1946,
 1946,    0,    0,    0,    0, 1946, 1946, 1946, 1946, 1946,
    0, 1946,    0,    0, 1946, 1946, 1249, 1248, 1250, 1946,
 1946,    0,    0, 1946, 1946, 1946, 1946, 1946, 1946, 1946,
 1946, 1946,    0, 1946,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1946, 1946, 1946, 1946, 1946, 1946, 1946,
 1946, 1946, 1946, 1946, 1946, 1946, 1946, 1946, 1946, 1946,
 1946, 1946, 1946, 1946,    0, 1946, 1946, 1946, 1946, 1946,
 1946,    0, 1946, 1946, 1946, 1946,    0, 1946,    0, 1946,
 1946, 1946, 1946, 1946, 1946, 1946, 1946, 1946, 1946, 1946,
 1946, 1946, 1946, 1946, 1946, 1946, 1946,    0, 1946, 1946,
 1946, 1946,    0, 1946, 1946, 1946, 1946, 1946,    0, 1946,
 1946, 1946, 1946, 1946, 1946, 1946, 1946, 1946, 1946, 1946,
 1946, 1946, 1946, 1946, 1946, 1946, 1946, 1946, 1946, 1946,
 1946, 1946, 1946, 1946, 1946, 1946, 1946, 1946, 1947, 1946,
 1946, 1946, 1946,    0, 1946, 1946, 1946, 1946, 1946, 1946,
    0,    0, 1946, 1946, 1946, 1946, 1946, 1946, 1946, 1946,
 1946,    0,    0,    0,    0,    0, 1946,    0, 1946, 1946,
 1946, 1946, 1946, 1946,    0, 1946,    0,    0, 1634, 1947,
 1947, 1947, 1947, 1947, 1947, 1947,    0,    0,    0,    0,
    0,    0, 1233,    0,    0,    0, 1947, 1947, 1947, 1947,
 1947, 1234,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1235,    0,    0,    0, 1233,    0,
    0,    0,    0,    0,    0,    0,    0, 1234,    0, 1947,
    0, 1947,    0,    0,    0,    0,    0,    0,    0,    0,
 1235,    0,    0,    0,    0,    0,    0,    0, 1236,    0,
    0,    0,    0,    0,    0, 1237,    0,    0,    0,    0,
    0,    0,    0, 1238,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1236,    0,    0,    0,    0,    0,
 1239, 1237, 1240,    0,    0,    0,    0,    0,    0, 1238,
    0,    0, 1241,    0, 1242, 1243, 1244,    0,    0,    0,
    0, 1245,    0,    0,    0,    0, 1239,    0, 1240,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1241,    0,
 1242, 1243, 1244,    0,    0,    0,    0, 1245,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1246,    0,    0,    0,    0,    0,    0, 1701,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1246,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1947,    0, 1947,    0,    0,
 1947,    0, 1947, 1947,    0,    0, 1947, 1947,    0, 1947,
    0,    0,    0,    0,    0, 1947,    0, 1947, 1947, 1947,
 1947,    0, 1947,    0,    0, 1947,    0,    0, 1947,    0,
    0,    0,    0,    0,    0, 1947,    0, 1947, 1947,    0,
 1947, 1947, 1947, 1947, 1947,    0,    0, 1947,    0,    0,
 1947,    0, 1947, 1947,    0,    0, 1947, 1947, 1947,    0,
 1947, 1947, 1947, 1947, 1947, 1947, 1947,    0,    0,    0,
 1947, 1947, 1947, 1947, 1947,    0,    0,    0, 1947,    0,
    0,    0,    0,    0,    0,    0, 1947, 1947, 1947, 1947,
 1947, 1947,    0,    0,    0, 1947, 1947,    0, 1947,    0,
 1947,    0, 1947, 1947, 1947,    0, 1947,    0, 1947, 1947,
 1947,    0, 1947, 1947, 1947, 1947, 1947,    0, 1947, 1947,
    0,    0,    0,    0, 1947, 1985, 1947, 1947, 1247,    0,
 1947, 1947, 1947,    0,    0, 1947,    0, 1947,    0,    0,
 1947, 1947, 1947, 1947,    0, 1947,    0, 1947,    0, 1947,
 1947, 1947, 1947, 1947, 1247,    0, 1947, 1947, 1947,    0,
 1947, 1947,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1947, 1947, 1947,    0, 1947, 1947, 1947,    0, 1947,
    0,    0,    0, 1947,    0, 1947, 1947, 1947, 1947,    0,
 1947,    0, 1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
    0,    0,    0,    0, 1249, 1248, 1250,    0,    0, 1947,
 1947,    0, 1947, 1947, 1947, 1249, 1248, 1250,    0, 1947,
 1947, 1947, 1947, 1947,    0, 1947,    0,    0, 1947, 1947,
    0,    0,    0, 1947, 1947,    0,    0, 1947, 1947, 1947,
 1947, 1947, 1947, 1947, 1947, 1947,    0, 1947,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1947, 1947, 1947,
 1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
 1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,    0, 1947,
 1947, 1947, 1947, 1947, 1947,    0, 1947, 1947, 1947, 1947,
    0, 1947,    0, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
 1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
 1947,    0, 1947, 1947, 1947, 1947,    0, 1947, 1947, 1947,
 1947, 1947,    0, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
 1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
 1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
 1947, 1947, 1785, 1947, 1947, 1947, 1947,    0, 1947, 1947,
 1947, 1947, 1947, 1947,    0,    0, 1947, 1947, 1947, 1947,
 1947, 1947, 1947, 1947, 1947,    0,    0,    0,    0,    0,
 1947,    0, 1947, 1947, 1947, 1947, 1947, 1947,    0, 1947,
    0,    0,    0, 1785, 1785, 1785, 1785, 1785, 1785, 1785,
    0,    0,    0,    0,    0,    0, 1233,    0,    0,    0,
 1785, 1785, 1785, 1785, 1785, 1234,    0, 1233,    0,    0,
    0,    0,   59,    0,    0,    0, 1234,    0, 1235,    0,
    0,    0,    0,    0,    0,   60,    0,   61,    0, 1235,
    0,    0,    0, 1785,    0, 1785,    0,   62,    0, 2600,
    0,    0,    0,   63,    0,    0,    0,   64,    0,    0,
    0,    0, 1236,   65,    0,    0,   66,    0,    0, 1237,
    0,    0,    0, 1236,    0,    0,   67, 1238,    0,    0,
 1237,    0,    0,    0,    0,    0,    0,    0, 1238,    0,
    0,    0,    0,    0, 1239,    0, 1240,    0,    0,    0,
    0,    0,    0,    0,    0, 1239, 1241, 1240, 1242, 1243,
 1244,    0,    0,    0,    0, 1245,    0, 1241,    0, 1242,
 1243, 1244,    0,    0,    0,    0, 1245,    0,    0,    0,
    0,    0,    0,    0,   68,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1246,    0,    0,    0,
    0,    0,    0,    0,   69,    0,    0, 1246,   70,    0,
    0,    0,    0,   71, 2612,    0,    0,    0,    0,   72,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   73,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1785,
    0, 1785,    0,    0, 1785,    0, 1785, 1785,    0,    0,
 1785, 1785,    0, 1785,    0,    0,    0,    0,    0, 1785,
    0, 1785, 1785, 1785, 1785,    0, 1785,    0,    0, 1785,
    0,    0, 1785,    0,    0,    0,    0,    0,    0, 1785,
    0, 1785, 1785,   74, 1785, 1785, 1785, 1785, 1785,    0,
    0, 1785,    0,    0, 1785,    0, 1785, 1785,    0,    0,
 1785, 1785, 1785,    0, 1785, 1785, 1785, 1785, 1785, 1785,
 1785,    0,    0,    0, 1785, 1785, 1785, 1785, 1785,    0,
    0,    0, 1785,    0,    0,    0,    0,    0,    0,   75,
 1785, 1785, 1785, 1785, 1785, 1785,    0,    0,    0, 1785,
 1785,    0, 1785,    0, 1785,    0, 1785, 1785, 1785,    0,
 1785,    0, 1785, 1785, 1785,    0, 1785, 1785, 1785, 1785,
 1785,    0, 1785, 1785,    0,    0,    0,    0, 1785,    0,
 1785, 1785, 1247,   76, 1785, 1785, 1785,    0,    0, 1785,
    0, 1785,    0, 1247, 1785, 1785, 1785, 1785,    0, 1785,
    0, 1785,   77, 1785, 1785, 1785, 1785, 1785,    0,    0,
 1785, 1785, 1785,    0, 1785, 1785,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1785, 1785, 1785,    0, 1785,
 1785, 1785,    0, 1785,    0,    0,    0, 1785,    0, 1785,
 1785, 1785, 1785,    0, 1785,    0, 1785, 1785, 1785, 1785,
 1785, 1785, 1785, 1785,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1785, 1785,    0, 1785, 1785, 1785,    0,
    0,    0,    0, 1785, 1785, 1785, 1785, 1785,    0, 1785,
    0,    0, 1785, 1785,    0,    0,    0, 1785, 1785,    0,
    0, 1785, 1785, 1785, 1785, 1785, 1785, 1785, 1785, 1785,
    0, 1785,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1785, 1785, 1785, 1785, 1785, 1785, 1785, 1785, 1785,
 1785, 1785, 1785, 1785, 1785, 1785, 1785, 1785, 1785, 1785,
 1785, 1785,    0, 1785, 1785, 1785, 1785, 1785, 1785,    0,
 1785, 1785, 1785, 1785,    0, 1785,    0, 1785, 1785, 1785,
 1785, 1785, 1785, 1785, 1785, 1785, 1785, 1785, 1785, 1785,
 1785, 1785, 1785, 1785, 1785,    0, 1785, 1785, 1785, 1785,
    0, 1785, 1785, 1785, 1785, 1785,    0, 1785, 1785, 1785,
 1785, 1785, 1785, 1785, 1785, 1785, 1785, 1785, 1785, 1785,
 1785, 1785, 1785, 1785, 1785, 1785, 1785, 1785, 1785, 1785,
 1785, 1785, 1785, 1785, 1785, 1785, 1830, 1785, 1785, 1785,
 1785,    0, 1785, 1785, 1785, 1785, 1785, 1785,    0,    0,
 1785, 1785, 1785, 1785, 1785, 1785, 1785, 1785, 1785,    0,
    0,    0,    0,    0, 1785,    0, 1785, 1785, 1785, 1785,
 1785, 1785,    0, 1785,    0,    0,    0, 1830, 1830, 1830,
 1830, 1830, 1830, 1830,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1830, 1830, 1830, 1830, 1830,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  611,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1830,  612, 1830,
    0,    0,    0,    0,    0,    0,    0,    0,  613,    0,
    0,    0,    0,    0,  614,    0,    0,    0,  615,  616,
    0,    0,    0,    0,  617,    0,    0,  618,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  619,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  620,    0,    0,
    0,    0,    0,    0,    0,  621,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  622,    0,    0,    0,  623,
    0,    0,    0,    0,  624,    0,    0,    0,    0,    0,
  625,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  626,  627,
    0,    0,    0, 1830,    0, 1830,    0,    0, 1830,    0,
 1830, 1830,    0,    0, 1830, 1830,    0, 1830,    0,    0,
    0,    0,    0, 1830,    0, 1830, 1830, 1830, 1830,    0,
 1830,    0,    0, 1830,    0,    0, 1830,    0,    0,    0,
    0,    0,    0, 1830,    0, 1830, 1830,    0, 1830, 1830,
 1830, 1830, 1830,    0,  628, 1830,    0,  629, 1830,    0,
 1830, 1830,    0,    0, 1830, 1830, 1830,    0, 1830, 1830,
 1830, 1830, 1830, 1830, 1830,    0,    0,    0, 1830, 1830,
 1830, 1830, 1830,    0,    0,    0, 1830,    0,    0,    0,
    0,    0,    0,    0, 1830, 1830, 1830, 1830, 1830, 1830,
    0,    0,    0, 1830, 1830,    0, 1830,    0, 1830,    0,
 1830, 1830, 1830,    0, 1830,    0, 1830, 1830, 1830,    0,
 1830, 1830, 1830, 1830, 1830,    0, 1830, 1830,    0,    0,
    0,    0, 1830,    0, 1830, 1830,    0,    0, 1830, 1830,
 1830,    0,    0, 1830,    0, 1830,    0,    0, 1830, 1830,
 1830, 1830,    0, 1830,    0, 1830,    0, 1830, 1830, 1830,
 1830, 1830,    0,  630, 1830, 1830, 1830,    0, 1830, 1830,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1830,
 1830, 1830,    0, 1830, 1830, 1830,    0, 1830,    0,    0,
    0, 1830,    0, 1830, 1830, 1830, 1830,    0, 1830,    0,
 1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1830, 1830,    0,
 1830, 1830, 1830,    0,    0,    0,    0, 1830, 1830, 1830,
 1830, 1830,    0, 1830,    0,    0, 1830, 1830,    0,    0,
    0, 1830, 1830,    0,    0, 1830, 1830, 1830, 1830, 1830,
 1830, 1830, 1830, 1830,    0, 1830,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1830, 1830, 1830, 1830, 1830,
 1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
 1830, 1830, 1830, 1830, 1830, 1830,    0, 1830, 1830, 1830,
 1830, 1830, 1830,    0, 1830, 1830, 1830, 1830,    0, 1830,
    0, 1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
 1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,    0,
 1830, 1830, 1830, 1830,    0, 1830, 1830, 1830, 1830, 1830,
    0, 1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
 1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
 1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830, 1830,
 1831, 1830, 1830, 1830, 1830,    0, 1830, 1830, 1830, 1830,
 1830, 1830,    0,    0, 1830, 1830, 1830, 1830, 1830, 1830,
 1830, 1830, 1830,    0,    0,    0,    0,    0, 1830,    0,
 1830, 1830, 1830, 1830, 1830, 1830,    0, 1830,    0,   76,
    0, 1831, 1831, 1831, 1831, 1831, 1831, 1831,    0,    0,
    0,    0,    0,    0,   85,    0,    0,    0, 1831, 1831,
 1831, 1831, 1831,    0,   76,    0,    0,    0,    0,    0,
   76,    0,    0,    0,    0,   76,    0,   82,    0,    0,
   76,    0,    0,   76,    0,    0,    0,    0,    0,    0,
    0, 1831,   89, 1831,    0,    0,    0,    0,    0,    0,
    0,    0,   82,    0,    0,    0,    0,    0,   82,    0,
    0,    0,    0,   82,    0,    0,    0,    0,   82,    0,
    0,   82,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   76,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   76,    0,    0,    0,    0,    0,    0,    0,   82,
    0,    0,    0,    0,    0,    0,   76,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   76,    0,    0,    0,    0,   82,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   82,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   82,    0,    0,    0,    0, 1831,    0, 1831,
    0,    0, 1831,    0, 1831, 1831,    0,    0, 1831, 1831,
   76, 1831,    0,   76,    0,    0,    0, 1831,    0, 1831,
 1831, 1831, 1831,    0, 1831,    0,    0, 1831,    0,    0,
 1831,    0,    0,    0,    0,    0,    0, 1831,    0, 1831,
 1831,    0, 1831, 1831, 1831, 1831, 1831,    0,   82, 1831,
    0,   82, 1831,    0, 1831, 1831,    0,    0, 1831, 1831,
 1831,    0, 1831, 1831, 1831, 1831, 1831, 1831, 1831,    0,
    0,    0, 1831, 1831, 1831, 1831, 1831,    0,    0,    0,
 1831,    0,    0,    0,    0,    0,    0,    0, 1831, 1831,
 1831, 1831, 1831, 1831,    0,    0,    0, 1831, 1831,    0,
 1831,    0, 1831,    0, 1831, 1831, 1831,    0, 1831,    0,
 1831, 1831, 1831,    0, 1831, 1831, 1831, 1831, 1831,   76,
 1831, 1831,    0,    0,    0,    0, 1831,    0, 1831, 1831,
    0,    0, 1831, 1831, 1831,    0,    0, 1831,    0, 1831,
    0,    0, 1831, 1831, 1831, 1831,    0, 1831,    0, 1831,
    0, 1831, 1831, 1831, 1831, 1831,    0,   82, 1831, 1831,
 1831,    0, 1831, 1831,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1831, 1831, 1831,    0, 1831, 1831, 1831,
    0, 1831,    0,    0,    0, 1831,    0, 1831, 1831, 1831,
 1831,    0, 1831,    0, 1831, 1831, 1831, 1831, 1831, 1831,
 1831, 1831,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1831, 1831,    0, 1831, 1831, 1831,    0,    0,    0,
    0, 1831, 1831, 1831, 1831, 1831,    0, 1831,    0,    0,
 1831, 1831,    0,    0,    0, 1831, 1831,    0,    0, 1831,
 1831, 1831, 1831, 1831, 1831, 1831, 1831, 1831,    0, 1831,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1831,
 1831, 1831, 1831, 1831, 1831, 1831, 1831, 1831, 1831, 1831,
 1831, 1831, 1831, 1831, 1831, 1831, 1831, 1831, 1831, 1831,
    0, 1831, 1831, 1831, 1831, 1831, 1831,    0, 1831, 1831,
 1831, 1831,    0, 1831,    0, 1831, 1831, 1831, 1831, 1831,
 1831, 1831, 1831, 1831, 1831, 1831, 1831, 1831, 1831, 1831,
 1831, 1831, 1831,    0, 1831, 1831, 1831, 1831,    0, 1831,
 1831, 1831, 1831, 1831,    0, 1831, 1831, 1831, 1831, 1831,
 1831, 1831, 1831, 1831, 1831, 1831, 1831, 1831, 1831, 1831,
 1831, 1831, 1831, 1831, 1831, 1831, 1831, 1831, 1831, 1831,
 1831, 1831, 1831, 1831, 1849, 1831, 1831, 1831, 1831,    0,
 1831, 1831, 1831, 1831, 1831, 1831,    0,    0, 1831, 1831,
 1831, 1831, 1831, 1831, 1831, 1831, 1831,    0,    0,    0,
    0,    0, 1831,    0, 1831, 1831, 1831, 1831, 1831, 1831,
    0, 1831,    0,    0,    0, 1849, 1849, 1849, 1849, 1849,
 1849, 1849,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1849, 1849, 1849, 1849, 1849,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   81,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   82,    0,    0,    0,    0, 1849,   83, 1849,    0,    0,
    0,    0,    0,    0,    0,    0,   84,    0,    0,   85,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   86,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   87,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   88,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   89,    0,    0,
    0,   90,    0,    0,   91,    0,   92,    0,    0,    0,
    0,    0,   93,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   94,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1849,    0, 1849,    0,    0, 1849,    0, 1849, 1849,
    0,    0, 1849, 1849,    0, 1849,    0,    0,    0,    0,
    0, 1849,    0, 1849, 1849, 1849, 1849,    0, 1849,    0,
    0, 1849,    0,    0, 1849,    0,   95,    0,    0,   96,
    0, 1849,    0, 1849, 1849,    0, 1849, 1849, 1849, 1849,
 1849,    0,    0, 1849,    0,    0, 1849,    0, 1849, 1849,
    0,    0, 1849, 1849, 1849,    0, 1849, 1849, 1849, 1849,
 1849, 1849, 1849,    0,    0,    0, 1849, 1849, 1849, 1849,
 1849,    0,   97,    0, 1849,    0,    0,    0,    0,    0,
    0,    0, 1849, 1849, 1849, 1849, 1849, 1849,    0,    0,
    0, 1849, 1849,    0, 1849,    0, 1849,    0, 1849, 1849,
 1849,    0, 1849,    0, 1849, 1849, 1849,    0, 1849, 1849,
 1849, 1849, 1849,    0, 1849, 1849,   98,    0,    0,    0,
 1849,    0, 1849, 1849,    0,    0, 1849, 1849, 1849,    0,
    0, 1849,    0, 1849,    0,   99, 1849, 1849, 1849, 1849,
    0, 1849,    0, 1849,    0, 1849, 1849, 1849, 1849, 1849,
    0,    0, 1849, 1849, 1849,    0, 1849, 1849,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1849, 1849, 1849,
    0, 1849, 1849, 1849,    0, 1849,    0,    0,    0, 1849,
    0, 1849, 1849, 1849, 1849,    0, 1849,    0, 1849, 1849,
 1849, 1849, 1849, 1849, 1849, 1849,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1849, 1849,    0, 1849, 1849,
 1849,    0,    0,    0,    0, 1849, 1849, 1849, 1849, 1849,
    0, 1849,    0,    0, 1849, 1849,    0,    0,    0, 1849,
 1849,    0,    0, 1849, 1849, 1849, 1849, 1849, 1849, 1849,
 1849, 1849,    0, 1849,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1849, 1849, 1849, 1849, 1849, 1849, 1849,
 1849, 1849, 1849, 1849, 1849, 1849, 1849, 1849, 1849, 1849,
 1849, 1849, 1849, 1849,    0, 1849, 1849, 1849, 1849, 1849,
 1849,    0, 1849, 1849, 1849, 1849,    0, 1849,    0, 1849,
 1849, 1849, 1849, 1849, 1849, 1849, 1849, 1849, 1849, 1849,
 1849, 1849, 1849, 1849, 1849, 1849, 1849,    0, 1849, 1849,
 1849, 1849,    0, 1849, 1849, 1849, 1849, 1849,    0, 1849,
 1849, 1849, 1849, 1849, 1849, 1849, 1849, 1849, 1849, 1849,
 1849, 1849, 1849, 1849, 1849, 1849, 1849, 1849, 1849, 1849,
 1849, 1849, 1849, 1849, 1849, 1849, 1849, 1849, 1904, 1849,
 1849, 1849, 1849,    0, 1849, 1849, 1849, 1849, 1849, 1849,
    0,    0, 1849, 1849, 1849, 1849, 1849, 1849, 1849, 1849,
 1849,    0,    0,    0,    0,    0, 1849,    0, 1849, 1849,
 1849, 1849, 1849, 1849,    0, 1849,    0,    0,    0, 1904,
 1904, 1904, 1904, 1904, 1904, 1904,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1904, 1904, 1904,
 1904,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1904,
    0, 1904,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1904,    0, 1904,    0,    0,
 1904,    0, 1904, 1904,    0,    0, 1904, 1904,    0, 1904,
    0,    0,    0,    0,    0, 1904,    0, 1904, 1904, 1904,
 1904,    0, 1904,    0,    0, 1904,    0,    0, 1904,    0,
    0,    0,    0,    0,    0, 1904,    0, 1904, 1904,    0,
 1904, 1904, 1904, 1904, 1904,    0,    0, 1904,    0,    0,
 1904,    0, 1904, 1904,    0,    0, 1904, 1904, 1904,    0,
 1904, 1904, 1904, 1904, 1904, 1904, 1904,    0,    0,    0,
 1904, 1904, 1904, 1904, 1904,    0,    0,    0, 1904,    0,
    0,    0,    0,    0,    0,    0, 1904, 1904, 1904, 1904,
 1904, 1904,    0,    0,    0, 1904, 1904,    0, 1904,    0,
 1904,    0, 1904, 1904, 1904,    0, 1904,    0, 1904, 1904,
 1904,    0, 1904, 1904, 1904, 1904, 1904,    0, 1904, 1904,
    0,    0,    0,    0, 1904,    0, 1904, 1904,    0,    0,
 1904, 1904, 1904,    0,    0, 1904,    0, 1904,    0,    0,
 1904, 1904, 1904, 1904,    0, 1904,    0, 1904,    0, 1904,
 1904, 1904, 1904, 1904,    0,    0, 1904, 1904, 1904,    0,
 1904, 1904,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1904, 1904, 1904,    0, 1904, 1904, 1904,    0, 1904,
    0,    0,    0, 1904,    0, 1904, 1904, 1904, 1904,    0,
 1904,    0, 1904, 1904, 1904, 1904, 1904, 1904, 1904, 1904,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1904,
 1904,    0, 1904, 1904, 1904,    0,    0,    0,    0, 1904,
 1904, 1904, 1904, 1904,    0, 1904,    0,    0, 1904, 1904,
    0,    0,    0, 1904, 1904,    0,    0, 1904, 1904, 1904,
 1904, 1904, 1904, 1904, 1904, 1904,    0, 1904,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1904, 1904, 1904,
 1904, 1904, 1904, 1904, 1904, 1904, 1904, 1904, 1904, 1904,
 1904, 1904, 1904, 1904, 1904, 1904, 1904, 1904,    0, 1904,
 1904, 1904, 1904, 1904, 1904,    0, 1904, 1904, 1904, 1904,
    0, 1904,    0, 1904, 1904, 1904, 1904, 1904, 1904, 1904,
 1904, 1904, 1904, 1904, 1904, 1904, 1904, 1904, 1904, 1904,
 1904,    0, 1904, 1904, 1904, 1904,    0, 1904, 1904, 1904,
 1904, 1904,    0, 1904, 1904, 1904, 1904, 1904, 1904, 1904,
 1904, 1904, 1904, 1904, 1904, 1904, 1904, 1904, 1904, 1904,
 1904, 1904, 1904, 1904, 1904, 1904, 1904, 1904, 1904, 1904,
 1904, 1904, 1930, 1904, 1904, 1904, 1904,    0, 1904, 1904,
 1904, 1904, 1904, 1904,    0,    0, 1904, 1904, 1904, 1904,
 1904, 1904, 1904, 1904, 1904,    0,    0,    0,    0,    0,
 1904,    0, 1904, 1904, 1904, 1904, 1904, 1904,    0, 1904,
    0,    0,    0, 1930, 1930, 1930, 1930, 1930, 1930, 1930,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1930, 1930, 1930, 1930,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1930,    0, 1930,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1930,
    0, 1930,    0,    0, 1930,    0, 1930, 1930,    0,    0,
 1930, 1930,    0, 1930,    0,    0,    0,    0,    0, 1930,
    0, 1930, 1930, 1930, 1930,    0, 1930,    0,    0, 1930,
    0,    0, 1930,    0,    0,    0,    0,    0,    0, 1930,
    0, 1930, 1930,    0, 1930, 1930, 1930, 1930, 1930,    0,
    0, 1930,    0,    0, 1930,    0, 1930, 1930,    0,    0,
 1930, 1930, 1930,    0, 1930, 1930, 1930, 1930, 1930, 1930,
 1930,    0,    0,    0, 1930, 1930, 1930, 1930, 1930,    0,
    0,    0, 1930,    0,    0,    0,    0,    0,    0,    0,
 1930, 1930, 1930, 1930, 1930, 1930,    0,    0,    0, 1930,
 1930,    0, 1930,    0, 1930,    0, 1930, 1930, 1930,    0,
 1930,    0, 1930, 1930, 1930,    0, 1930, 1930, 1930, 1930,
 1930,    0, 1930, 1930,    0,    0,    0,    0, 1930,    0,
 1930, 1930,    0,    0, 1930, 1930, 1930,    0,    0, 1930,
    0, 1930,    0,    0, 1930, 1930, 1930, 1930,    0, 1930,
    0, 1930,    0, 1930, 1930, 1930, 1930, 1930,    0,    0,
 1930, 1930, 1930,    0, 1930, 1930,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1930, 1930, 1930,    0, 1930,
 1930, 1930,    0, 1930,    0,    0,    0, 1930,    0, 1930,
 1930, 1930, 1930,    0, 1930,    0, 1930, 1930, 1930, 1930,
 1930, 1930, 1930, 1930,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1930, 1930,    0, 1930, 1930, 1930,    0,
    0,    0,    0, 1930, 1930, 1930, 1930, 1930,    0, 1930,
    0,    0, 1930, 1930,    0,    0,    0, 1930, 1930,    0,
    0, 1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930,
    0, 1930,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930,
 1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930,
 1930, 1930,    0, 1930, 1930, 1930, 1930, 1930, 1930,    0,
 1930, 1930, 1930, 1930,    0, 1930,    0, 1930, 1930, 1930,
 1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930,
 1930, 1930, 1930, 1930, 1930,    0, 1930, 1930, 1930, 1930,
    0, 1930, 1930, 1930, 1930, 1930,    0, 1930, 1930, 1930,
 1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930,
 1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930,
 1930, 1930, 1930, 1930, 1930, 1930, 1790, 1930, 1930, 1930,
 1930,    0, 1930, 1930, 1930, 1930, 1930, 1930,    0,    0,
 1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930,    0,
    0,    0,    0,    0, 1930,    0, 1930, 1930, 1930, 1930,
 1930, 1930,    0, 1930,    0,    0,    0, 1790, 1790, 1790,
 1790, 1790, 1790, 1790,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1790, 1790, 1790, 1790,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1790,    0, 1790,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1790,    0, 1790,    0,    0, 1790,    0,
 1790, 1790,    0,    0, 1790, 1790,    0, 1790,    0,    0,
    0,    0,    0, 1790,    0, 1790, 1790, 1790, 1790,    0,
 1790,    0,    0, 1790,    0,    0, 1790,    0,    0,    0,
    0,    0,    0, 1790,    0, 1790, 1790,    0, 1790, 1790,
 1790, 1790, 1790,    0,    0, 1790,    0,    0, 1790,    0,
 1790, 1790,    0,    0, 1790, 1790, 1790,    0, 1790, 1790,
 1790, 1790, 1790, 1790, 1790,    0,    0,    0, 1790, 1790,
 1790, 1790, 1790,    0,    0,    0, 1790,    0,    0,    0,
    0,    0,    0,    0, 1790, 1790, 1790, 1790, 1790, 1790,
    0,    0,    0, 1790, 1790,    0, 1790,    0, 1790,    0,
 1790, 1790, 1790,    0, 1790,    0, 1790, 1790, 1790,    0,
 1790, 1790, 1790, 1790, 1790,    0, 1790, 1790,    0,    0,
    0,    0, 1790,    0, 1790, 1790,    0,    0, 1790, 1790,
 1790,    0,    0, 1790,    0, 1790,    0,    0, 1790, 1790,
 1790, 1790,    0, 1790,    0, 1790,    0, 1790, 1790, 1790,
 1790, 1790,    0,    0, 1790, 1790, 1790,    0, 1790, 1790,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1790,
 1790, 1790,    0, 1790, 1790, 1790,    0, 1790,    0,    0,
    0, 1790,    0, 1790, 1790, 1790, 1790,    0, 1790,    0,
 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1790, 1790,    0,
 1790, 1790, 1790,    0,    0,    0,    0, 1790, 1790, 1790,
 1790, 1790,    0, 1790,    0,    0, 1790, 1790,    0,    0,
    0, 1790, 1790,    0,    0, 1790, 1790, 1790, 1790, 1790,
 1790, 1790, 1790, 1790,    0, 1790,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1790, 1790, 1790, 1790, 1790,
 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790,
 1790, 1790, 1790, 1790, 1790, 1790,    0, 1790, 1790, 1790,
 1790, 1790, 1790,    0, 1790, 1790, 1790, 1790,    0, 1790,
    0, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790,
 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790,    0,
 1790, 1790, 1790, 1790,    0, 1790, 1790, 1790, 1790, 1790,
    0, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790,
 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790,
 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790,
 1786, 1790, 1790, 1790, 1790,    0, 1790, 1790, 1790, 1790,
 1790, 1790,    0,    0, 1790, 1790, 1790, 1790, 1790, 1790,
 1790, 1790, 1790,    0,    0,    0,    0,    0, 1790,    0,
 1790, 1790, 1790, 1790, 1790, 1790,    0, 1790,    0,    0,
    0, 1786, 1786, 1786, 1786, 1786, 1786, 1786,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1786,
 1786, 1786, 1786,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1786,    0, 1786,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1786,    0, 1786,
    0,    0, 1786,    0, 1786, 1786,    0,    0, 1786, 1786,
    0, 1786,    0,    0,    0,    0,    0, 1786,    0, 1786,
 1786, 1786, 1786,    0, 1786,    0,    0, 1786,    0,    0,
 1786,    0,    0,    0,    0,    0,    0, 1786,    0, 1786,
 1786,    0, 1786, 1786, 1786, 1786, 1786,    0,    0, 1786,
    0,    0, 1786,    0, 1786, 1786,    0,    0, 1786, 1786,
 1786,    0, 1786, 1786, 1786, 1786, 1786, 1786, 1786,    0,
    0,    0, 1786, 1786, 1786, 1786, 1786,    0,    0,    0,
 1786,    0,    0,    0,    0,    0,    0,    0, 1786, 1786,
 1786, 1786, 1786, 1786,    0,    0,    0, 1786, 1786,    0,
 1786,    0, 1786,    0, 1786, 1786, 1786,    0, 1786,    0,
 1786, 1786, 1786,    0, 1786, 1786, 1786, 1786, 1786,    0,
 1786, 1786,    0,    0,    0,    0, 1786,    0, 1786, 1786,
    0,    0, 1786, 1786, 1786,    0,    0, 1786,    0, 1786,
    0,    0, 1786, 1786, 1786, 1786,    0, 1786,    0, 1786,
    0, 1786, 1786, 1786, 1786, 1786,    0,    0, 1786, 1786,
 1786,    0, 1786, 1786,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1786, 1786, 1786,    0, 1786, 1786, 1786,
    0, 1786,    0,    0,    0, 1786,    0, 1786, 1786, 1786,
 1786,    0, 1786,    0, 1786, 1786, 1786, 1786, 1786, 1786,
 1786, 1786,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1786, 1786,    0, 1786, 1786, 1786,    0,    0,    0,
    0, 1786, 1786, 1786, 1786, 1786,    0, 1786,    0,    0,
 1786, 1786,    0,    0,    0, 1786, 1786,    0,    0, 1786,
 1786, 1786, 1786, 1786, 1786, 1786, 1786, 1786,    0, 1786,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1786,
 1786, 1786, 1786, 1786, 1786, 1786, 1786, 1786, 1786, 1786,
 1786, 1786, 1786, 1786, 1786, 1786, 1786, 1786, 1786, 1786,
    0, 1786, 1786, 1786, 1786, 1786, 1786,    0, 1786, 1786,
 1786, 1786,    0, 1786,    0, 1786, 1786, 1786, 1786, 1786,
 1786, 1786, 1786, 1786, 1786, 1786, 1786, 1786, 1786, 1786,
 1786, 1786, 1786,    0, 1786, 1786, 1786, 1786,    0, 1786,
 1786, 1786, 1786, 1786,    0, 1786, 1786, 1786, 1786, 1786,
 1786, 1786, 1786, 1786, 1786, 1786, 1786, 1786, 1786, 1786,
 1786, 1786, 1786, 1786, 1786, 1786, 1786, 1786, 1786, 1786,
 1786, 1786, 1786, 1786, 1798, 1786, 1786, 1786, 1786,    0,
 1786, 1786, 1786, 1786, 1786, 1786,    0,    0, 1786, 1786,
 1786, 1786, 1786, 1786, 1786, 1786, 1786,    0,    0,    0,
    0,    0, 1786,    0, 1786, 1786, 1786, 1786, 1786, 1786,
    0, 1786,    0,    0,    0, 1798, 1798, 1798, 1798, 1798,
 1798, 1798,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1798, 1798, 1798, 1798,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1798,    0, 1798,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1798,    0, 1798,    0,    0, 1798,    0, 1798, 1798,
    0,    0, 1798, 1798,    0, 1798,    0,    0,    0,    0,
    0, 1798,    0, 1798, 1798, 1798, 1798,    0, 1798,    0,
    0, 1798,    0,    0, 1798,    0,    0,    0,    0,    0,
    0, 1798,    0, 1798, 1798,    0, 1798, 1798, 1798, 1798,
 1798,    0,    0, 1798,    0,    0, 1798,    0, 1798, 1798,
    0,    0, 1798, 1798, 1798,    0, 1798, 1798, 1798, 1798,
 1798, 1798, 1798,    0,    0,    0, 1798, 1798, 1798, 1798,
 1798,    0,    0,    0, 1798,    0,    0,    0,    0,    0,
    0,    0, 1798, 1798, 1798, 1798, 1798, 1798,    0,    0,
    0, 1798, 1798,    0, 1798,    0, 1798,    0, 1798, 1798,
 1798,    0, 1798,    0, 1798, 1798, 1798,    0, 1798, 1798,
 1798, 1798, 1798,    0, 1798, 1798,    0,    0,    0,    0,
 1798,    0, 1798, 1798,    0,    0, 1798, 1798, 1798,    0,
    0, 1798,    0, 1798,    0,    0, 1798, 1798, 1798, 1798,
    0, 1798,    0, 1798,    0, 1798, 1798, 1798, 1798, 1798,
    0,    0, 1798, 1798, 1798,    0, 1798, 1798,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1798, 1798, 1798,
    0, 1798, 1798, 1798,    0, 1798,    0,    0,    0, 1798,
    0, 1798, 1798, 1798, 1798,    0, 1798,    0, 1798, 1798,
 1798, 1798, 1798, 1798, 1798, 1798,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1798, 1798,    0, 1798, 1798,
 1798,    0,    0,    0,    0, 1798, 1798, 1798, 1798, 1798,
    0, 1798,    0,    0, 1798, 1798,    0,    0,    0, 1798,
 1798,    0,    0, 1798, 1798, 1798, 1798, 1798, 1798, 1798,
 1798, 1798,    0, 1798,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1798, 1798, 1798, 1798, 1798, 1798, 1798,
 1798, 1798, 1798, 1798, 1798, 1798, 1798, 1798, 1798, 1798,
 1798, 1798, 1798, 1798,    0, 1798, 1798, 1798, 1798, 1798,
 1798,    0, 1798, 1798, 1798, 1798,    0, 1798,    0, 1798,
 1798, 1798, 1798, 1798, 1798, 1798, 1798, 1798, 1798, 1798,
 1798, 1798, 1798, 1798, 1798, 1798, 1798,    0, 1798, 1798,
 1798, 1798,    0, 1798, 1798, 1798, 1798, 1798,    0, 1798,
 1798, 1798, 1798, 1798, 1798, 1798, 1798, 1798, 1798, 1798,
 1798, 1798, 1798, 1798, 1798, 1798, 1798, 1798, 1798, 1798,
 1798, 1798, 1798, 1798, 1798, 1798, 1798, 1798, 1803, 1798,
 1798, 1798, 1798,    0, 1798, 1798, 1798, 1798, 1798, 1798,
    0,    0, 1798, 1798, 1798, 1798, 1798, 1798, 1798, 1798,
 1798,    0,    0,    0,    0,    0, 1798,    0, 1798, 1798,
 1798, 1798, 1798, 1798,    0, 1798,    0,    0,    0, 1803,
 1803, 1803, 1803, 1803, 1803, 1803,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1803, 1803, 1803,
 1803,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1803,
    0, 1803,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1803,    0, 1803,    0,    0,
 1803,    0, 1803, 1803,    0,    0, 1803, 1803,    0, 1803,
    0,    0,    0,    0,    0, 1803,    0, 1803, 1803, 1803,
 1803,    0, 1803,    0,    0, 1803,    0,    0, 1803,    0,
    0,    0,    0,    0,    0, 1803,    0, 1803, 1803,    0,
 1803, 1803, 1803, 1803, 1803,    0,    0, 1803,    0,    0,
 1803,    0, 1803, 1803,    0,    0, 1803, 1803, 1803,    0,
 1803, 1803, 1803, 1803, 1803, 1803, 1803,    0,    0,    0,
 1803, 1803, 1803, 1803, 1803,    0,    0,    0, 1803,    0,
    0,    0,    0,    0,    0,    0, 1803, 1803, 1803, 1803,
 1803, 1803,    0,    0,    0, 1803, 1803,    0, 1803,    0,
 1803,    0, 1803, 1803, 1803,    0, 1803,    0, 1803, 1803,
 1803,    0, 1803, 1803, 1803, 1803, 1803,    0, 1803, 1803,
    0,    0,    0,    0, 1803,    0, 1803, 1803,    0,    0,
 1803, 1803, 1803,    0,    0, 1803,    0, 1803,    0,    0,
 1803, 1803, 1803, 1803,    0, 1803,    0, 1803,    0, 1803,
 1803, 1803, 1803, 1803,    0,    0, 1803, 1803, 1803,    0,
 1803, 1803,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1803, 1803, 1803,    0, 1803, 1803, 1803,    0, 1803,
    0,    0,    0, 1803,    0, 1803, 1803, 1803, 1803,    0,
 1803,    0, 1803, 1803, 1803, 1803, 1803, 1803, 1803, 1803,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1803,
 1803,    0, 1803, 1803, 1803,    0,    0,    0,    0, 1803,
 1803, 1803, 1803, 1803,    0, 1803,    0,    0, 1803, 1803,
    0,    0,    0, 1803, 1803,    0,    0, 1803, 1803, 1803,
 1803, 1803, 1803, 1803, 1803, 1803,    0, 1803,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1803, 1803, 1803,
 1803, 1803, 1803, 1803, 1803, 1803, 1803, 1803, 1803, 1803,
 1803, 1803, 1803, 1803, 1803, 1803, 1803, 1803,    0, 1803,
 1803, 1803, 1803, 1803, 1803,    0, 1803, 1803, 1803, 1803,
    0, 1803,    0, 1803, 1803, 1803, 1803, 1803, 1803, 1803,
 1803, 1803, 1803, 1803, 1803, 1803, 1803, 1803, 1803, 1803,
 1803,    0, 1803, 1803, 1803, 1803,    0, 1803, 1803, 1803,
 1803, 1803,    0, 1803, 1803, 1803, 1803, 1803, 1803, 1803,
 1803, 1803, 1803, 1803, 1803, 1803, 1803, 1803, 1803, 1803,
 1803, 1803, 1803, 1803, 1803, 1803, 1803, 1803, 1803, 1803,
 1803, 1803, 1832, 1803, 1803, 1803, 1803,    0, 1803, 1803,
 1803, 1803, 1803, 1803,    0,    0, 1803, 1803, 1803, 1803,
 1803, 1803, 1803, 1803, 1803,    0,    0,    0,    0,    0,
 1803,    0, 1803, 1803, 1803, 1803, 1803, 1803,    0, 1803,
    0,    0,    0, 1832, 1832, 1832, 1832, 1832, 1832, 1832,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1832, 1832, 1832, 1832,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1832,    0, 1832,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1832,
    0, 1832,    0,    0, 1832,    0, 1832, 1832,    0,    0,
 1832, 1832,    0, 1832,    0,    0,    0,    0,    0, 1832,
    0, 1832, 1832, 1832, 1832,    0, 1832,    0,    0, 1832,
    0,    0, 1832,    0,    0,    0,    0,    0,    0, 1832,
    0, 1832, 1832,    0, 1832, 1832, 1832, 1832, 1832,    0,
    0, 1832,    0,    0, 1832,    0, 1832, 1832,    0,    0,
 1832, 1832, 1832,    0, 1832, 1832, 1832, 1832, 1832, 1832,
 1832,    0,    0,    0, 1832, 1832, 1832, 1832, 1832,    0,
    0,    0, 1832,    0,    0,    0,    0,    0,    0,    0,
 1832, 1832, 1832, 1832, 1832, 1832,    0,    0,    0, 1832,
 1832,    0, 1832,    0, 1832,    0, 1832, 1832, 1832,    0,
 1832,    0, 1832, 1832, 1832,    0, 1832, 1832, 1832, 1832,
 1832,    0, 1832, 1832,    0,    0,    0,    0, 1832,    0,
 1832, 1832,    0,    0, 1832, 1832, 1832,    0,    0, 1832,
    0, 1832,    0,    0, 1832, 1832, 1832, 1832,    0, 1832,
    0, 1832,    0, 1832, 1832, 1832, 1832, 1832,    0,    0,
 1832, 1832, 1832,    0, 1832, 1832,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1832, 1832, 1832,    0, 1832,
 1832, 1832,    0, 1832,    0,    0,    0, 1832,    0, 1832,
 1832, 1832, 1832,    0, 1832,    0, 1832, 1832, 1832, 1832,
 1832, 1832, 1832, 1832,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1832, 1832,    0, 1832, 1832, 1832,    0,
    0,    0,    0, 1832, 1832, 1832, 1832, 1832,    0, 1832,
    0,    0, 1832, 1832,    0,    0,    0, 1832, 1832,    0,
    0, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832,
    0, 1832,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832,
 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832,
 1832, 1832,    0, 1832, 1832, 1832, 1832, 1832, 1832,    0,
 1832, 1832, 1832, 1832,    0, 1832,    0, 1832, 1832, 1832,
 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832,
 1832, 1832, 1832, 1832, 1832,    0, 1832, 1832, 1832, 1832,
    0, 1832, 1832, 1832, 1832, 1832,    0, 1832, 1832, 1832,
 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832,
 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832,
 1832, 1832, 1832, 1832, 1832, 1832, 1838, 1832, 1832, 1832,
 1832,    0, 1832, 1832, 1832, 1832, 1832, 1832,    0,    0,
 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832,    0,
    0,    0,    0,    0, 1832,    0, 1832, 1832, 1832, 1832,
 1832, 1832,    0, 1832,    0,    0,    0, 1838, 1838, 1838,
 1838, 1838, 1838, 1838,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1838, 1838, 1838, 1838,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1838,    0, 1838,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1838,    0, 1838,    0,    0, 1838,    0,
 1838, 1838,    0,    0, 1838, 1838,    0, 1838,    0,    0,
    0,    0,    0, 1838,    0, 1838, 1838, 1838, 1838,    0,
 1838,    0,    0, 1838,    0,    0, 1838,    0,    0,    0,
    0,    0,    0, 1838,    0, 1838, 1838,    0, 1838, 1838,
 1838, 1838, 1838,    0,    0, 1838,    0,    0, 1838,    0,
 1838, 1838,    0,    0, 1838, 1838, 1838,    0, 1838, 1838,
 1838, 1838, 1838, 1838, 1838,    0,    0,    0, 1838, 1838,
 1838, 1838, 1838,    0,    0,    0, 1838,    0,    0,    0,
    0,    0,    0,    0, 1838, 1838, 1838, 1838, 1838, 1838,
    0,    0,    0, 1838, 1838,    0, 1838,    0, 1838,    0,
 1838, 1838, 1838,    0, 1838,    0, 1838, 1838, 1838,    0,
 1838, 1838, 1838, 1838, 1838,    0, 1838, 1838,    0,    0,
    0,    0, 1838,    0, 1838, 1838,    0,    0, 1838, 1838,
 1838,    0,    0, 1838,    0, 1838,    0,    0, 1838, 1838,
 1838, 1838,    0, 1838,    0, 1838,    0, 1838, 1838, 1838,
 1838, 1838,    0,    0, 1838, 1838, 1838,    0, 1838, 1838,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1838,
 1838, 1838,    0, 1838, 1838, 1838,    0, 1838,    0,    0,
    0, 1838,    0, 1838, 1838, 1838, 1838,    0, 1838,    0,
 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1838, 1838,    0,
 1838, 1838, 1838,    0,    0,    0,    0, 1838, 1838, 1838,
 1838, 1838,    0, 1838,    0,    0, 1838, 1838,    0,    0,
    0, 1838, 1838,    0,    0, 1838, 1838, 1838, 1838, 1838,
 1838, 1838, 1838, 1838,    0, 1838,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1838, 1838, 1838, 1838, 1838,
 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838,
 1838, 1838, 1838, 1838, 1838, 1838,    0, 1838, 1838, 1838,
 1838, 1838, 1838,    0, 1838, 1838, 1838, 1838,    0, 1838,
    0, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838,
 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838,    0,
 1838, 1838, 1838, 1838,    0, 1838, 1838, 1838, 1838, 1838,
    0, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838,
 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838,
 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838,
 1962, 1838, 1838, 1838, 1838,    0, 1838, 1838, 1838, 1838,
 1838, 1838,    0,    0, 1838, 1838, 1838, 1838, 1838, 1838,
 1838, 1838, 1838,    0,    0,    0,    0,    0, 1838,    0,
 1838, 1838, 1838, 1838, 1838, 1838,    0, 1838,    0,    0,
    0, 1962, 1962, 1962, 1962, 1962, 1962, 1962,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1962,
 1962, 1962, 1962,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1962,    0, 1962,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1962,    0, 1962,
    0,    0, 1962,    0, 1962, 1962,    0,    0, 1962, 1962,
    0, 1962,    0,    0,    0,    0,    0, 1962,    0, 1962,
 1962, 1962, 1962,    0, 1962,    0,    0, 1962,    0,    0,
 1962,    0,    0,    0,    0,    0,    0, 1962,    0, 1962,
 1962,    0, 1962, 1962, 1962, 1962, 1962,    0,    0, 1962,
    0,    0, 1962,    0, 1962, 1962,    0,    0, 1962, 1962,
 1962,    0, 1962, 1962, 1962, 1962, 1962, 1962, 1962,    0,
    0,    0, 1962, 1962, 1962, 1962, 1962,    0,    0,    0,
 1962,    0,    0,    0,    0,    0,    0,    0, 1962, 1962,
 1962, 1962, 1962, 1962,    0,    0,    0, 1962, 1962,    0,
 1962,    0, 1962,    0, 1962, 1962, 1962,    0, 1962,    0,
 1962, 1962, 1962,    0, 1962, 1962, 1962, 1962, 1962,    0,
 1962, 1962,    0,    0,    0,    0, 1962,    0, 1962, 1962,
    0,    0, 1962, 1962, 1962,    0,    0, 1962,    0, 1962,
    0,    0, 1962, 1962, 1962, 1962,    0, 1962,    0, 1962,
    0, 1962, 1962, 1962, 1962, 1962,    0,    0, 1962, 1962,
 1962,    0, 1962, 1962,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1962, 1962, 1962,    0, 1962, 1962, 1962,
    0, 1962,    0,    0,    0, 1962,    0, 1962, 1962, 1962,
 1962,    0, 1962,    0, 1962, 1962, 1962, 1962, 1962, 1962,
 1962, 1962,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1962, 1962,    0, 1962, 1962, 1962,    0,    0,    0,
    0, 1962, 1962, 1962, 1962, 1962,    0, 1962,    0,    0,
 1962, 1962,    0,    0,    0, 1962, 1962,    0,    0, 1962,
 1962, 1962, 1962, 1962, 1962, 1962, 1962, 1962,    0, 1962,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1962,
 1962, 1962, 1962, 1962, 1962, 1962, 1962, 1962, 1962, 1962,
 1962, 1962, 1962, 1962, 1962, 1962, 1962, 1962, 1962, 1962,
    0, 1962, 1962, 1962, 1962, 1962, 1962,    0, 1962, 1962,
 1962, 1962,    0, 1962,    0, 1962, 1962, 1962, 1962, 1962,
 1962, 1962, 1962, 1962, 1962, 1962, 1962, 1962, 1962, 1962,
 1962, 1962, 1962,    0, 1962, 1962, 1962, 1962,    0, 1962,
 1962, 1962, 1962, 1962,    0, 1962, 1962, 1962, 1962, 1962,
 1962, 1962, 1962, 1962, 1962, 1962, 1962, 1962, 1962, 1962,
 1962, 1962, 1962, 1962, 1962, 1962, 1962, 1962, 1962, 1962,
 1962, 1962, 1962, 1962, 1963, 1962, 1962, 1962, 1962,    0,
 1962, 1962, 1962, 1962, 1962, 1962,    0,    0, 1962, 1962,
 1962, 1962, 1962, 1962, 1962, 1962, 1962,    0,    0,    0,
    0,    0, 1962,    0, 1962, 1962, 1962, 1962, 1962, 1962,
    0, 1962,    0,    0,    0, 1963, 1963, 1963, 1963, 1963,
 1963, 1963,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1963, 1963, 1963, 1963,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1963,    0, 1963,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1963,    0, 1963,    0,    0, 1963,    0, 1963, 1963,
    0,    0, 1963, 1963,    0, 1963,    0,    0,    0,    0,
    0, 1963,    0, 1963, 1963, 1963, 1963,    0, 1963,    0,
    0, 1963,    0,    0, 1963,    0,    0,    0,    0,    0,
    0, 1963,    0, 1963, 1963,    0, 1963, 1963, 1963, 1963,
 1963,    0,    0, 1963,    0,    0, 1963,    0, 1963, 1963,
    0,    0, 1963, 1963, 1963,    0, 1963, 1963, 1963, 1963,
 1963, 1963, 1963,    0,    0,    0, 1963, 1963, 1963, 1963,
 1963,    0,    0,    0, 1963,    0,    0,    0,    0,    0,
    0,    0, 1963, 1963, 1963, 1963, 1963, 1963,    0,    0,
    0, 1963, 1963,    0, 1963,    0, 1963,    0, 1963, 1963,
 1963,    0, 1963,    0, 1963, 1963, 1963,    0, 1963, 1963,
 1963, 1963, 1963,    0, 1963, 1963,    0,    0,    0,    0,
 1963,    0, 1963, 1963,    0,    0, 1963, 1963, 1963,    0,
    0, 1963,    0, 1963,    0,    0, 1963, 1963, 1963, 1963,
    0, 1963,    0, 1963,    0, 1963, 1963, 1963, 1963, 1963,
    0,    0, 1963, 1963, 1963,    0, 1963, 1963,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1963, 1963, 1963,
    0, 1963, 1963, 1963,    0, 1963,    0,    0,    0, 1963,
    0, 1963, 1963, 1963, 1963,    0, 1963,    0, 1963, 1963,
 1963, 1963, 1963, 1963, 1963, 1963,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1963, 1963,    0, 1963, 1963,
 1963,    0,    0,    0,    0, 1963, 1963, 1963, 1963, 1963,
    0, 1963,    0,    0, 1963, 1963,    0,    0,    0, 1963,
 1963,    0,    0, 1963, 1963, 1963, 1963, 1963, 1963, 1963,
 1963, 1963,    0, 1963,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1963, 1963, 1963, 1963, 1963, 1963, 1963,
 1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963,
 1963, 1963, 1963, 1963,    0, 1963, 1963, 1963, 1963, 1963,
 1963,    0, 1963, 1963, 1963, 1963,    0, 1963,    0, 1963,
 1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963,
 1963, 1963, 1963, 1963, 1963, 1963, 1963,    0, 1963, 1963,
 1963, 1963,    0, 1963, 1963, 1963, 1963, 1963,    0, 1963,
 1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963,
 1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963,
 1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963, 1964, 1963,
 1963, 1963, 1963,    0, 1963, 1963, 1963, 1963, 1963, 1963,
    0,    0, 1963, 1963, 1963, 1963, 1963, 1963, 1963, 1963,
 1963,    0,    0,    0,    0,    0, 1963,    0, 1963, 1963,
 1963, 1963, 1963, 1963,    0, 1963,    0,    0,    0, 1964,
 1964, 1964, 1964, 1964, 1964, 1964,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1964, 1964, 1964,
 1964,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1964,
    0, 1964,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1964,    0, 1964,    0,    0,
 1964,    0, 1964, 1964,    0,    0, 1964, 1964,    0, 1964,
    0,    0,    0,    0,    0, 1964,    0, 1964, 1964, 1964,
 1964,    0, 1964,    0,    0, 1964,    0,    0, 1964,    0,
    0,    0,    0,    0,    0, 1964,    0, 1964, 1964,    0,
 1964, 1964, 1964, 1964, 1964,    0,    0, 1964,    0,    0,
 1964,    0, 1964, 1964,    0,    0, 1964, 1964, 1964,    0,
 1964, 1964, 1964, 1964, 1964, 1964, 1964,    0,    0,    0,
 1964, 1964, 1964, 1964, 1964,    0,    0,    0, 1964,    0,
    0,    0,    0,    0,    0,    0, 1964, 1964, 1964, 1964,
 1964, 1964,    0,    0,    0, 1964, 1964,    0, 1964,    0,
 1964,    0, 1964, 1964, 1964,    0, 1964,    0, 1964, 1964,
 1964,    0, 1964, 1964, 1964, 1964, 1964,    0, 1964, 1964,
    0,    0,    0,    0, 1964,    0, 1964, 1964,    0,    0,
 1964, 1964, 1964,    0,    0, 1964,    0, 1964,    0,    0,
 1964, 1964, 1964, 1964,    0, 1964,    0, 1964,    0, 1964,
 1964, 1964, 1964, 1964,    0,    0, 1964, 1964, 1964,    0,
 1964, 1964,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1964, 1964, 1964,    0, 1964, 1964, 1964,    0, 1964,
    0,    0,    0, 1964,    0, 1964, 1964, 1964, 1964,    0,
 1964,    0, 1964, 1964, 1964, 1964, 1964, 1964, 1964, 1964,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1964,
 1964,    0, 1964, 1964, 1964,    0,    0,    0,    0, 1964,
 1964, 1964, 1964, 1964,    0, 1964,    0,    0, 1964, 1964,
    0,    0,    0, 1964, 1964,    0,    0, 1964, 1964, 1964,
 1964, 1964, 1964, 1964, 1964, 1964,    0, 1964,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1964, 1964, 1964,
 1964, 1964, 1964, 1964, 1964, 1964, 1964, 1964, 1964, 1964,
 1964, 1964, 1964, 1964, 1964, 1964, 1964, 1964,    0, 1964,
 1964, 1964, 1964, 1964, 1964,    0, 1964, 1964, 1964, 1964,
    0, 1964,    0, 1964, 1964, 1964, 1964, 1964, 1964, 1964,
 1964, 1964, 1964, 1964, 1964, 1964, 1964, 1964, 1964, 1964,
 1964,    0, 1964, 1964, 1964, 1964,    0, 1964, 1964, 1964,
 1964, 1964,    0, 1964, 1964, 1964, 1964, 1964, 1964, 1964,
 1964, 1964, 1964, 1964, 1964, 1964, 1964, 1964, 1964, 1964,
 1964, 1964, 1964, 1964, 1964, 1964, 1964, 1964, 1964, 1964,
 1964, 1964, 1965, 1964, 1964, 1964, 1964,    0, 1964, 1964,
 1964, 1964, 1964, 1964,    0,    0, 1964, 1964, 1964, 1964,
 1964, 1964, 1964, 1964, 1964,    0,    0,    0,    0,    0,
 1964,    0, 1964, 1964, 1964, 1964, 1964, 1964,    0, 1964,
    0,    0,    0, 1965, 1965, 1965, 1965, 1965, 1965, 1965,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1965, 1965, 1965, 1965,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1965,    0, 1965,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1965,
    0, 1965,    0,    0, 1965,    0, 1965, 1965,    0,    0,
 1965, 1965,    0, 1965,    0,    0,    0,    0,    0, 1965,
    0, 1965, 1965, 1965, 1965,    0, 1965,    0,    0, 1965,
    0,    0, 1965,    0,    0,    0,    0,    0,    0, 1965,
    0, 1965, 1965,    0, 1965, 1965, 1965, 1965, 1965,    0,
    0, 1965,    0,    0, 1965,    0, 1965, 1965,    0,    0,
 1965, 1965, 1965,    0, 1965, 1965, 1965, 1965, 1965, 1965,
 1965,    0,    0,    0, 1965, 1965, 1965, 1965, 1965,    0,
    0,    0, 1965,    0,    0,    0,    0,    0,    0,    0,
 1965, 1965, 1965, 1965, 1965, 1965,    0,    0,    0, 1965,
 1965,    0, 1965,    0, 1965,    0, 1965, 1965, 1965,    0,
 1965,    0, 1965, 1965, 1965,    0, 1965, 1965, 1965, 1965,
 1965,    0, 1965, 1965,    0,    0,    0,    0, 1965,    0,
 1965, 1965,    0,    0, 1965, 1965, 1965,    0,    0, 1965,
    0, 1965,    0,    0, 1965, 1965, 1965, 1965,    0, 1965,
    0, 1965,    0, 1965, 1965, 1965, 1965, 1965,    0,    0,
 1965, 1965, 1965,    0, 1965, 1965,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1965, 1965, 1965,    0, 1965,
 1965, 1965,    0, 1965,    0,    0,    0, 1965,    0, 1965,
 1965, 1965, 1965,    0, 1965,    0, 1965, 1965, 1965, 1965,
 1965, 1965, 1965, 1965,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1965, 1965,    0, 1965, 1965, 1965,    0,
    0,    0,    0, 1965, 1965, 1965, 1965, 1965,    0, 1965,
    0,    0, 1965, 1965,    0,    0,    0, 1965, 1965,    0,
    0, 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965,
    0, 1965,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965,
 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965,
 1965, 1965,    0, 1965, 1965, 1965, 1965, 1965, 1965,    0,
 1965, 1965, 1965, 1965,    0, 1965,    0, 1965, 1965, 1965,
 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965,
 1965, 1965, 1965, 1965, 1965,    0, 1965, 1965, 1965, 1965,
    0, 1965, 1965, 1965, 1965, 1965,    0, 1965, 1965, 1965,
 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965,
 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965,
 1965, 1965, 1965, 1965, 1965, 1965, 1966, 1965, 1965, 1965,
 1965,    0, 1965, 1965, 1965, 1965, 1965, 1965,    0,    0,
 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965,    0,
    0,    0,    0,    0, 1965,    0, 1965, 1965, 1965, 1965,
 1965, 1965,    0, 1965,    0,    0,    0, 1966, 1966, 1966,
 1966, 1966, 1966, 1966,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1966, 1966, 1966, 1966,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1966,    0, 1966,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1966,    0, 1966,    0,    0, 1966,    0,
 1966, 1966,    0,    0, 1966, 1966,    0, 1966,    0,    0,
    0,    0,    0, 1966,    0, 1966, 1966, 1966, 1966,    0,
 1966,    0,    0, 1966,    0,    0, 1966,    0,    0,    0,
    0,    0,    0, 1966,    0, 1966, 1966,    0, 1966, 1966,
 1966, 1966, 1966,    0,    0, 1966,    0,    0, 1966,    0,
 1966, 1966,    0,    0, 1966, 1966, 1966,    0, 1966, 1966,
 1966, 1966, 1966, 1966, 1966,    0,    0,    0, 1966, 1966,
 1966, 1966, 1966,    0,    0,    0, 1966,    0,    0,    0,
    0,    0,    0,    0, 1966, 1966, 1966, 1966, 1966, 1966,
    0,    0,    0, 1966, 1966,    0, 1966,    0, 1966,    0,
 1966, 1966, 1966,    0, 1966,    0, 1966, 1966, 1966,    0,
 1966, 1966, 1966, 1966, 1966,    0, 1966, 1966,    0,    0,
    0,    0, 1966,    0, 1966, 1966,    0,    0, 1966, 1966,
 1966,    0,    0, 1966,    0, 1966,    0,    0, 1966, 1966,
 1966, 1966,    0, 1966,    0, 1966,    0, 1966, 1966, 1966,
 1966, 1966,    0,    0, 1966, 1966, 1966,    0, 1966, 1966,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1966,
 1966, 1966,    0, 1966, 1966, 1966,    0, 1966,    0,    0,
    0, 1966,    0, 1966, 1966, 1966, 1966,    0, 1966,    0,
 1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1966, 1966,    0,
 1966, 1966, 1966,    0,    0,    0,    0, 1966, 1966, 1966,
 1966, 1966,    0, 1966,    0,    0, 1966, 1966,    0,    0,
    0, 1966, 1966,    0,    0, 1966, 1966, 1966, 1966, 1966,
 1966, 1966, 1966, 1966,    0, 1966,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1966, 1966, 1966, 1966, 1966,
 1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966,
 1966, 1966, 1966, 1966, 1966, 1966,    0, 1966, 1966, 1966,
 1966, 1966, 1966,    0, 1966, 1966, 1966, 1966,    0, 1966,
    0, 1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966,
 1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966,    0,
 1966, 1966, 1966, 1966,    0, 1966, 1966, 1966, 1966, 1966,
    0, 1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966,
 1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966,
 1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966,
 1967, 1966, 1966, 1966, 1966,    0, 1966, 1966, 1966, 1966,
 1966, 1966,    0,    0, 1966, 1966, 1966, 1966, 1966, 1966,
 1966, 1966, 1966,    0,    0,    0,    0,    0, 1966,    0,
 1966, 1966, 1966, 1966, 1966, 1966,    0, 1966,    0,    0,
    0, 1967, 1967, 1967, 1967, 1967, 1967, 1967,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1967,
 1967, 1967, 1967,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1967,    0, 1967,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1967,    0, 1967,
    0,    0, 1967,    0, 1967, 1967,    0,    0, 1967, 1967,
    0, 1967,    0,    0,    0,    0,    0, 1967,    0, 1967,
 1967, 1967, 1967,    0, 1967,    0,    0, 1967,    0,    0,
 1967,    0,    0,    0,    0,    0,    0, 1967,    0, 1967,
 1967,    0, 1967, 1967, 1967, 1967, 1967,    0,    0, 1967,
    0,    0, 1967,    0, 1967, 1967,    0,    0, 1967, 1967,
 1967,    0, 1967, 1967, 1967, 1967, 1967, 1967, 1967,    0,
    0,    0, 1967, 1967, 1967, 1967, 1967,    0,    0,    0,
 1967,    0,    0,    0,    0,    0,    0,    0, 1967, 1967,
 1967, 1967, 1967, 1967,    0,    0,    0, 1967, 1967,    0,
 1967,    0, 1967,    0, 1967, 1967, 1967,    0, 1967,    0,
 1967, 1967, 1967,    0, 1967, 1967, 1967, 1967, 1967,    0,
 1967, 1967,    0,    0,    0,    0, 1967,    0, 1967, 1967,
    0,    0, 1967, 1967, 1967,    0,    0, 1967,    0, 1967,
    0,    0, 1967, 1967, 1967, 1967,    0, 1967,    0, 1967,
    0, 1967, 1967, 1967, 1967, 1967,    0,    0, 1967, 1967,
 1967,    0, 1967, 1967,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1967, 1967, 1967,    0, 1967, 1967, 1967,
    0, 1967,    0,    0,    0, 1967,    0, 1967, 1967, 1967,
 1967,    0, 1967,    0, 1967, 1967, 1967, 1967, 1967, 1967,
 1967, 1967,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1967, 1967,    0, 1967, 1967, 1967,    0,    0,    0,
    0, 1967, 1967, 1967, 1967, 1967,    0, 1967,    0,    0,
 1967, 1967,    0,    0,    0, 1967, 1967,    0,    0, 1967,
 1967, 1967, 1967, 1967, 1967, 1967, 1967, 1967,    0, 1967,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1967,
 1967, 1967, 1967, 1967, 1967, 1967, 1967, 1967, 1967, 1967,
 1967, 1967, 1967, 1967, 1967, 1967, 1967, 1967, 1967, 1967,
    0, 1967, 1967, 1967, 1967, 1967, 1967,    0, 1967, 1967,
 1967, 1967,    0, 1967,    0, 1967, 1967, 1967, 1967, 1967,
 1967, 1967, 1967, 1967, 1967, 1967, 1967, 1967, 1967, 1967,
 1967, 1967, 1967,    0, 1967, 1967, 1967, 1967,    0, 1967,
 1967, 1967, 1967, 1967,    0, 1967, 1967, 1967, 1967, 1967,
 1967, 1967, 1967, 1967, 1967, 1967, 1967, 1967, 1967, 1967,
 1967, 1967, 1967, 1967, 1967, 1967, 1967, 1967, 1967, 1967,
 1967, 1967, 1967, 1967, 1968, 1967, 1967, 1967, 1967,    0,
 1967, 1967, 1967, 1967, 1967, 1967,    0,    0, 1967, 1967,
 1967, 1967, 1967, 1967, 1967, 1967, 1967,    0,    0,    0,
    0,    0, 1967,    0, 1967, 1967, 1967, 1967, 1967, 1967,
    0, 1967,    0,    0,    0, 1968, 1968, 1968, 1968, 1968,
 1968, 1968,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1968, 1968, 1968, 1968,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1968,    0, 1968,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1968,    0, 1968,    0,    0, 1968,    0, 1968, 1968,
    0,    0, 1968, 1968,    0, 1968,    0,    0,    0,    0,
    0, 1968,    0, 1968, 1968, 1968, 1968,    0, 1968,    0,
    0, 1968,    0,    0, 1968,    0,    0,    0,    0,    0,
    0, 1968,    0, 1968, 1968,    0, 1968, 1968, 1968, 1968,
 1968,    0,    0, 1968,    0,    0, 1968,    0, 1968, 1968,
    0,    0, 1968, 1968, 1968,    0, 1968, 1968, 1968, 1968,
 1968, 1968, 1968,    0,    0,    0, 1968, 1968, 1968, 1968,
 1968,    0,    0,    0, 1968,    0,    0,    0,    0,    0,
    0,    0, 1968, 1968, 1968, 1968, 1968, 1968,    0,    0,
    0, 1968, 1968,    0, 1968,    0, 1968,    0, 1968, 1968,
 1968,    0, 1968,    0, 1968, 1968, 1968,    0, 1968, 1968,
 1968, 1968, 1968,    0, 1968, 1968,    0,    0,    0,    0,
 1968,    0, 1968, 1968,    0,    0, 1968, 1968, 1968,    0,
    0, 1968,    0, 1968,    0,    0, 1968, 1968, 1968, 1968,
    0, 1968,    0, 1968,    0, 1968, 1968, 1968, 1968, 1968,
    0,    0, 1968, 1968, 1968,    0, 1968, 1968,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1968, 1968, 1968,
    0, 1968, 1968, 1968,    0, 1968,    0,    0,    0, 1968,
    0, 1968, 1968, 1968, 1968,    0, 1968,    0, 1968, 1968,
 1968, 1968, 1968, 1968, 1968, 1968,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1968, 1968,    0, 1968, 1968,
 1968,    0,    0,    0,    0, 1968, 1968, 1968, 1968, 1968,
    0, 1968,    0,    0, 1968, 1968,    0,    0,    0, 1968,
 1968,    0,    0, 1968, 1968, 1968, 1968, 1968, 1968, 1968,
 1968, 1968,    0, 1968,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1968, 1968, 1968, 1968, 1968, 1968, 1968,
 1968, 1968, 1968, 1968, 1968, 1968, 1968, 1968, 1968, 1968,
 1968, 1968, 1968, 1968,    0, 1968, 1968, 1968, 1968, 1968,
 1968,    0, 1968, 1968, 1968, 1968,    0, 1968,    0, 1968,
 1968, 1968, 1968, 1968, 1968, 1968, 1968, 1968, 1968, 1968,
 1968, 1968, 1968, 1968, 1968, 1968, 1968,    0, 1968, 1968,
 1968, 1968,    0, 1968, 1968, 1968, 1968, 1968,    0, 1968,
 1968, 1968, 1968, 1968, 1968, 1968, 1968, 1968, 1968, 1968,
 1968, 1968, 1968, 1968, 1968, 1968, 1968, 1968, 1968, 1968,
 1968, 1968, 1968, 1968, 1968, 1968, 1968, 1968, 1969, 1968,
 1968, 1968, 1968,    0, 1968, 1968, 1968, 1968, 1968, 1968,
    0,    0, 1968, 1968, 1968, 1968, 1968, 1968, 1968, 1968,
 1968,    0,    0,    0,    0,    0, 1968,    0, 1968, 1968,
 1968, 1968, 1968, 1968,    0, 1968,    0,    0,    0, 1969,
 1969, 1969, 1969, 1969, 1969, 1969,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1969, 1969, 1969,
 1969,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1969,
    0, 1969,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1969,    0, 1969,    0,    0,
 1969,    0, 1969, 1969,    0,    0, 1969, 1969,    0, 1969,
    0,    0,    0,    0,    0, 1969,    0, 1969, 1969, 1969,
 1969,    0, 1969,    0,    0, 1969,    0,    0, 1969,    0,
    0,    0,    0,    0,    0, 1969,    0, 1969, 1969,    0,
 1969, 1969, 1969, 1969, 1969,    0,    0, 1969,    0,    0,
 1969,    0, 1969, 1969,    0,    0, 1969, 1969, 1969,    0,
 1969, 1969, 1969, 1969, 1969, 1969, 1969,    0,    0,    0,
 1969, 1969, 1969, 1969, 1969,    0,    0,    0, 1969,    0,
    0,    0,    0,    0,    0,    0, 1969, 1969, 1969, 1969,
 1969, 1969,    0,    0,    0, 1969, 1969,    0, 1969,    0,
 1969,    0, 1969, 1969, 1969,    0, 1969,    0, 1969, 1969,
 1969,    0, 1969, 1969, 1969, 1969, 1969,    0, 1969, 1969,
    0,    0,    0,    0, 1969,    0, 1969, 1969,    0,    0,
 1969, 1969, 1969,    0,    0, 1969,    0, 1969,    0,    0,
 1969, 1969, 1969, 1969,    0, 1969,    0, 1969,    0, 1969,
 1969, 1969, 1969, 1969,    0,    0, 1969, 1969, 1969,    0,
 1969, 1969,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1969, 1969, 1969,    0, 1969, 1969, 1969,    0, 1969,
    0,    0,    0, 1969,    0, 1969, 1969, 1969, 1969,    0,
 1969,    0, 1969, 1969, 1969, 1969, 1969, 1969, 1969, 1969,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1969,
 1969,    0, 1969, 1969, 1969,    0,    0,    0,    0, 1969,
 1969, 1969, 1969, 1969,    0, 1969,    0,    0, 1969, 1969,
    0,    0,    0, 1969, 1969,    0,    0, 1969, 1969, 1969,
 1969, 1969, 1969, 1969, 1969, 1969,    0, 1969,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1969, 1969, 1969,
 1969, 1969, 1969, 1969, 1969, 1969, 1969, 1969, 1969, 1969,
 1969, 1969, 1969, 1969, 1969, 1969, 1969, 1969,    0, 1969,
 1969, 1969, 1969, 1969, 1969,    0, 1969, 1969, 1969, 1969,
    0, 1969,    0, 1969, 1969, 1969, 1969, 1969, 1969, 1969,
 1969, 1969, 1969, 1969, 1969, 1969, 1969, 1969, 1969, 1969,
 1969,    0, 1969, 1969, 1969, 1969,    0, 1969, 1969, 1969,
 1969, 1969,    0, 1969, 1969, 1969, 1969, 1969, 1969, 1969,
 1969, 1969, 1969, 1969, 1969, 1969, 1969, 1969, 1969, 1969,
 1969, 1969, 1969, 1969, 1969, 1969, 1969, 1969, 1969, 1969,
 1969, 1969, 1556, 1969, 1969, 1969, 1969,    0, 1969, 1969,
 1969, 1969, 1969, 1969,    0,    0, 1969, 1969, 1969, 1969,
 1969, 1969, 1969, 1969, 1969,    0,    0,    0,    0,    0,
 1969,    0, 1969, 1969, 1969, 1969, 1969, 1969,    0, 1969,
    0,    0,    0, 1556, 1556, 1556, 1556, 1556,    0, 1556,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1556, 1556, 1556, 1556,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1556,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1556,
    0, 1556,    0,    0, 1556,    0, 1556, 1556,    0,    0,
 1556, 1556,    0, 1556,    0,    0,    0,    0,    0, 1556,
    0, 1556, 1556, 1556, 1556,    0, 1556,    0,    0, 1556,
    0,    0, 1556,    0,    0,    0,    0,    0,    0, 1556,
    0, 1556, 1556,    0, 1556, 1556, 1556, 1556, 1556,    0,
    0, 1556,    0,    0, 1556,    0, 1556, 1556,    0,    0,
 1556, 1556, 1556,    0, 1556, 1556, 1556, 1556, 1556, 1556,
 1556,    0,    0,    0, 1556, 1556, 1556, 1556, 1556,    0,
    0,    0, 1556,    0,    0,    0,    0,    0,    0,    0,
 1556, 1556, 1556, 1556, 1556, 1556,    0,    0,    0, 1556,
 1556,    0, 1556,    0, 1556,    0, 1556, 1556, 1556,    0,
 1556,    0, 1556, 1556, 1556,    0, 1556, 1556, 1556, 1556,
 1556,    0, 1556, 1556,    0,    0,    0,    0, 1556,    0,
 1556, 1556,    0,    0, 1556, 1556, 1556,    0,    0, 1556,
    0, 1556,    0,    0, 1556, 1556, 1556, 1556,    0, 1556,
    0, 1556,    0, 1556, 1556, 1556, 1556, 1556,    0,    0,
 1556, 1556, 1556,    0, 1556, 1556,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1556, 1556, 1556,    0, 1556,
 1556, 1556,    0, 1556,    0,    0,    0, 1556,    0, 1556,
 1556, 1556, 1556,    0, 1556,    0, 1556, 1556, 1556, 1556,
 1556, 1556, 1556, 1556,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1556, 1556,    0, 1556, 1556, 1556,    0,
    0,    0,    0, 1556, 1556, 1556, 1556, 1556,    0, 1556,
    0,    0, 1556, 1556,    0,    0,    0, 1556, 1556,    0,
    0, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
    0, 1556,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 1556, 1556,    0, 1556, 1556, 1556, 1556, 1556, 1556,    0,
 1556, 1556, 1556, 1556,    0, 1556,    0, 1556, 1556, 1556,
 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 1556, 1556, 1556, 1556, 1556,    0, 1556, 1556, 1556, 1556,
    0, 1556, 1556, 1556, 1556, 1556,    0, 1556, 1556, 1556,
 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 1556, 1556, 1556, 1556, 1556, 1556, 1556,    0, 1556, 1556,
 1556, 1556, 1556, 1556, 1556, 1556, 1606, 1556, 1556, 1556,
 1556, 1753, 1556, 1556, 1556, 1556, 1556, 1556,    0,    0,
 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,    0,
    0,    0,    0,    0, 1556,    0, 1556, 1556, 1556, 1556,
 1556, 1556,    0, 1556,    0,    0,    0,    0,    0,    0,
    0,    0, 1753, 1753, 1753, 1753, 1753,    0, 1753,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1753, 1753, 1753, 1753,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1753,    0, 1753,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1753,    0,
 1753,    0,    0, 1753,    0, 1753, 1753,    0,    0, 1753,
 1753,    0, 1753,    0,    0,    0,    0,    0, 1753,    0,
 1753, 1753, 1753, 1753,    0, 1753,    0,    0, 1753,    0,
    0, 1753,    0,    0,    0,    0,    0,    0, 1753,    0,
 1753, 1753,    0, 1753, 1753, 1753, 1753, 1753,    0,    0,
 1753,    0,    0, 1753,    0, 1753, 1753,    0,    0, 1753,
 1753, 1753,    0, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
    0,    0,    0, 1753, 1753, 1753, 1753, 1753,    0,    0,
    0, 1753,    0,    0,    0,    0,    0,    0,    0, 1753,
 1753, 1753, 1753, 1753, 1753,    0,    0,    0, 1753, 1753,
    0, 1753,    0, 1753,    0, 1753, 1753, 1753,    0, 1753,
    0, 1753, 1753, 1753,    0, 1753, 1753, 1753, 1753, 1753,
    0, 1753, 1753,    0,    0,    0,    0, 1753,    0, 1753,
 1753,    0,    0, 1753, 1753, 1753,    0,    0, 1753,    0,
 1753,    0,    0, 1753, 1753, 1753, 1753,    0, 1753,    0,
 1753,    0, 1753, 1753, 1753, 1753, 1753,    0,    0, 1753,
 1753, 1753,    0, 1753, 1753,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1753, 1753, 1753,    0, 1753, 1753,
 1753,    0, 1753,    0,    0,    0, 1753,    0, 1753, 1753,
 1753, 1753,    0, 1753,    0, 1753, 1753, 1753, 1753, 1753,
 1753, 1753, 1753,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1753, 1753,    0, 1753, 1753, 1753,    0,    0,
    0,    0, 1753, 1753, 1753, 1753, 1753,    0, 1753,    0,
    0, 1753, 1753,    0,    0,    0, 1753, 1753,    0,    0,
 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,    0,
 1753,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 1753,    0, 1753, 1753, 1753, 1753, 1753, 1753,    0, 1753,
 1753, 1753, 1753,    0, 1753,    0, 1753, 1753, 1753, 1753,
 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 1753, 1753, 1753, 1753,    0, 1753, 1753, 1753, 1753,    0,
 1753, 1753, 1753, 1753, 1753,    0, 1753, 1753, 1753, 1753,
 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 1753, 1753, 1753, 1753, 1753, 1753,    0, 1753, 1753, 1753,
 1753, 1753, 1753, 1753, 1753, 1771, 1753, 1753, 1753, 1753,
    0, 1753, 1753, 1753, 1753, 1753, 1753,    0,    0, 1753,
 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,    0,    0,
    0,    0,    0, 1753,    0, 1753, 1753, 1753, 1753, 1753,
 1753,    0, 1753,    0,    0,    0, 1771, 1771, 1771, 1771,
 1771, 1767, 1771,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1771, 1771, 1771, 1771,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1771,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1771,    0, 1771,    0,    0, 1771,    0, 1771,
 1771,    0,    0, 1771, 1771,    0, 1771,    0,    0,    0,
    0,    0, 1771,    0, 1771, 1771, 1771, 1771,    0, 1771,
    0,    0, 1771,    0,    0, 1771,    0,    0,    0,    0,
    0,    0, 1771,    0, 1771, 1771,    0, 1771, 1771, 1771,
 1771, 1771,    0,    0, 1771,    0,    0, 1771,    0, 1771,
 1771,    0,    0, 1771, 1771, 1771,    0, 1771, 1771, 1771,
 1771, 1771, 1771, 1771,    0,    0,    0, 1771, 1771, 1771,
 1771, 1771,    0,    0,    0, 1771,    0,    0,    0,    0,
    0,    0,    0, 1771, 1771, 1771, 1771, 1771, 1771,    0,
    0,    0, 1771, 1771,    0, 1771,    0, 1771,    0, 1771,
 1771, 1771,    0, 1771,    0, 1771, 1771, 1771,    0, 1771,
 1771, 1771, 1771, 1771,    0, 1771, 1771,    0,    0,    0,
    0, 1771,    0, 1771, 1771,    0,    0, 1771, 1771, 1771,
    0,    0, 1771,    0, 1771,    0,    0, 1771, 1771, 1771,
 1771,    0, 1771,    0, 1771,    0, 1771, 1771, 1771, 1771,
 1771,    0,    0, 1771, 1771, 1771,    0, 1771, 1771,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1771, 1771,
 1771,    0, 1771, 1771, 1771,    0, 1771,    0,    0,    0,
 1771,    0, 1771, 1771, 1771, 1771,    0, 1771,    0, 1771,
 1771, 1771, 1771, 1771, 1771, 1771, 1771,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1771, 1771,    0, 1771,
 1771, 1771,    0,    0,    0,    0, 1771, 1771, 1771, 1771,
 1771,    0, 1771,    0,    0, 1771, 1771,    0,    0,    0,
 1771, 1771,    0,    0, 1771, 1771, 1771, 1771, 1771, 1771,
 1771, 1771, 1771,    0, 1771,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1771, 1771, 1771, 1771, 1771, 1771,
 1771, 1771, 1771, 1771, 1771, 1771, 1771, 1771, 1771, 1771,
 1771, 1771, 1771, 1771, 1771,    0, 1771, 1771, 1771, 1771,
 1771, 1771,    0, 1771, 1771, 1771, 1771,    0, 1771,    0,
 1771, 1771, 1771, 1771, 1771, 1771, 1771, 1771, 1771, 1771,
 1771, 1771, 1771, 1771, 1771, 1771, 1771, 1771,    0, 1771,
 1771, 1771, 1771,    0, 1771, 1771, 1771, 1771, 1771,    0,
 1771, 1771, 1771, 1771, 1771, 1771, 1771, 1771, 1771, 1771,
 1771, 1771, 1771, 1771, 1771, 1771, 1771, 1771, 1771, 1771,
    0, 1771, 1771, 1771, 1771, 1771, 1771, 1771, 1771, 1476,
 1771, 1771, 1771, 1771,    0, 1771, 1771, 1771, 1771, 1771,
 1771,    0,    0, 1771, 1771, 1771, 1771, 1771, 1771, 1771,
 1771, 1771,    0,    0,    0,    0,    0, 1771,    0, 1771,
 1771, 1771, 1771, 1771, 1771,    0, 1771,    0,    0,    0,
 1476, 1476, 1476, 1476, 1476,    0, 1476,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1476, 1476,
 1476, 1476,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1476,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1476,    0, 1476,    0,
    0, 1476,    0, 1476, 1476,    0,    0, 1476, 1476,    0,
 1476,    0,    0,    0,    0,    0, 1476,    0, 1476, 1476,
 1476, 1476,    0, 1476,    0,    0, 1476,    0,    0, 1476,
    0,    0,    0,    0,    0,    0, 1476,    0, 1476, 1476,
    0, 1476, 1476, 1476, 1476, 1476,    0,    0, 1476,    0,
    0, 1476,    0, 1476, 1476,    0,    0, 1476, 1476, 1476,
    0, 1476, 1476, 1476, 1476, 1476, 1476, 1476,    0,    0,
    0, 1476, 1476, 1476, 1476, 1476,    0,    0,    0, 1476,
    0,    0,    0,    0,    0,    0,    0, 1476, 1476, 1476,
 1476, 1476, 1476,    0,    0,    0, 1476, 1476,    0, 1476,
    0, 1476,    0, 1476, 1476, 1476,    0, 1476,    0, 1476,
 1476, 1476,    0, 1476, 1476, 1476, 1476, 1476,    0, 1476,
 1476,    0,    0,    0,    0, 1476,    0, 1476, 1476,    0,
    0, 1476, 1476, 1476,    0,    0, 1476,    0, 1476,    0,
    0, 1476, 1476, 1476, 1476,    0, 1476,    0, 1476,    0,
 1476, 1476, 1476, 1476, 1476,    0,    0, 1476, 1476, 1476,
    0, 1476, 1476,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1476, 1476, 1476,    0, 1476, 1476, 1476,    0,
 1476,    0,    0,    0, 1476,    0, 1476, 1476, 1476, 1476,
    0, 1476,    0, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 1476,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1476, 1476,    0, 1476, 1476, 1476,    0,    0,    0,    0,
 1476, 1476, 1476, 1476, 1476,    0, 1476,    0,    0, 1476,
 1476,    0,    0,    0, 1476, 1476,    0,    0, 1476, 1476,
 1476, 1476, 1476, 1476, 1476, 1476, 1476,    0, 1476,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1476, 1476,
 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,    0,
 1476, 1476, 1476, 1476, 1476, 1476,    0, 1476, 1476, 1476,
 1476,    0, 1476,    0, 1476, 1476, 1476, 1476, 1476, 1476,
 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 1476, 1476,    0, 1476, 1476, 1476, 1476,    0, 1476, 1476,
 1476, 1476, 1476,    0, 1476, 1476, 1476, 1476, 1476, 1476,
 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 1476, 1476, 1476, 1476,    0, 1476, 1476, 1476, 1476, 1476,
 1476, 1476, 1476, 1490, 1476, 1476, 1476, 1476,    0, 1476,
 1476, 1476, 1476, 1476, 1476,    0,    0, 1476, 1476, 1476,
 1476, 1476, 1476, 1476, 1476, 1476,    0,    0,    0,    0,
    0, 1476,    0, 1476, 1476, 1476, 1476, 1476, 1476,    0,
 1476,    0,    0,    0, 1490, 1490, 1490, 1490, 1490,    0,
 1490,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1490, 1490, 1490, 1490,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1490,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1490,    0, 1490,    0,    0, 1490,    0, 1490, 1490,    0,
    0, 1490, 1490,    0, 1490,    0,    0,    0,    0,    0,
    0,    0, 1490, 1490, 1490, 1490,    0, 1490,    0,    0,
 1490,    0,    0, 1490,    0,    0,    0,    0,    0,    0,
 1490,    0, 1490, 1490,    0, 1490, 1490, 1490, 1490, 1490,
    0,    0, 1490,    0,    0, 1490,    0, 1490, 1490,    0,
    0, 1490, 1490, 1490,    0, 1490, 1490, 1490, 1490, 1490,
 1490, 1490,    0,    0,    0, 1490, 1490, 1490, 1490, 1490,
    0,    0,    0, 1490,    0,    0,    0,    0,    0,    0,
    0, 1490, 1490, 1490, 1490, 1490, 1490,    0,    0,    0,
 1490, 1490,    0, 1490,    0, 1490,    0, 1490, 1490, 1490,
    0, 1490,    0, 1490, 1490, 1490,    0, 1490, 1490, 1490,
 1490, 1490,    0, 1490, 1490,    0,    0,    0,    0, 1490,
    0, 1490, 1490,    0,    0, 1490, 1490, 1490,    0,    0,
 1490,    0, 1490,    0,    0, 1490, 1490, 1490, 1490,    0,
 1490,    0, 1490,    0, 1490, 1490, 1490, 1490, 1490,    0,
    0, 1490, 1490, 1490,    0, 1490, 1490,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1490, 1490, 1490,    0,
 1490, 1490, 1490,    0, 1490,    0,    0,    0, 1490,    0,
 1490, 1490, 1490, 1490,    0, 1490,    0, 1490, 1490, 1490,
 1490, 1490, 1490, 1490, 1490,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1490, 1490,    0, 1490, 1490, 1490,
    0,    0,    0,    0, 1490, 1490, 1490, 1490, 1490,    0,
 1490,    0,    0, 1490, 1490,    0,    0,    0, 1490, 1490,
    0,    0, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490,
 1490,    0, 1490,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490,
 1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490,
 1490, 1490, 1490,    0, 1490, 1490, 1490, 1490, 1490, 1490,
    0, 1490, 1490, 1490, 1490,    0, 1490,    0, 1490, 1490,
 1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490,
 1490, 1490, 1490, 1490, 1490, 1490,    0, 1490, 1490, 1490,
 1490,    0, 1490, 1490, 1490, 1490, 1490,    0, 1490, 1490,
 1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490,
 1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490,    0, 1490,
 1490, 1490, 1490, 1490, 1490, 1490, 1490, 1488, 1490, 1490,
 1490, 1490,    0, 1490, 1490, 1490, 1490, 1490, 1490,    0,
    0, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490,
    0,    0,    0,    0,    0, 1490,    0, 1490, 1490, 1490,
 1490, 1490, 1490,    0, 1490,    0,    0,    0, 1488, 1488,
 1488, 1488, 1488,    0, 1488,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1488, 1488, 1488, 1488,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1488,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1488,    0, 1488,    0,    0, 1488,
    0, 1488, 1488,    0,    0, 1488, 1488,    0, 1488,    0,
    0,    0,    0,    0,    0,    0, 1488, 1488,    0, 1488,
    0, 1488,    0,    0, 1488,    0,    0, 1488,    0,    0,
    0,    0,    0,    0, 1488,    0, 1488, 1488,    0, 1488,
 1488, 1488, 1488, 1488,    0,    0, 1488,    0,    0, 1488,
    0, 1488, 1488,    0,    0, 1488, 1488, 1488,    0, 1488,
 1488, 1488, 1488, 1488, 1488, 1488,    0,    0,    0, 1488,
 1488, 1488, 1488, 1488,    0,    0,    0, 1488,    0,    0,
    0,    0,    0,    0,    0, 1488, 1488, 1488, 1488, 1488,
 1488,    0,    0,    0, 1488, 1488,    0, 1488,    0, 1488,
    0, 1488, 1488, 1488,    0, 1488,    0, 1488, 1488, 1488,
    0, 1488, 1488, 1488, 1488, 1488,    0, 1488, 1488,    0,
    0,    0,    0, 1488,    0, 1488, 1488,    0,    0, 1488,
 1488, 1488,    0,    0, 1488,    0, 1488,    0,    0, 1488,
 1488, 1488, 1488,    0, 1488,    0, 1488,    0, 1488, 1488,
 1488, 1488, 1488,    0,    0, 1488, 1488, 1488,    0, 1488,
 1488,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1488, 1488, 1488,    0, 1488, 1488, 1488,    0, 1488,    0,
    0,    0, 1488,    0, 1488, 1488, 1488, 1488,    0, 1488,
    0, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1488, 1488,
    0, 1488, 1488, 1488,    0,    0,    0,    0, 1488, 1488,
 1488, 1488, 1488,    0, 1488,    0,    0, 1488, 1488,    0,
    0,    0, 1488, 1488,    0,    0, 1488, 1488, 1488, 1488,
 1488, 1488, 1488, 1488, 1488,    0, 1488,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1488, 1488, 1488, 1488,
 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488,
 1488, 1488, 1488, 1488, 1488, 1488, 1488,    0, 1488, 1488,
 1488, 1488, 1488, 1488,    0, 1488, 1488, 1488, 1488,    0,
 1488,    0, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488,
 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488,
    0, 1488, 1488, 1488, 1488,    0, 1488, 1488, 1488, 1488,
 1488,    0, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488,
 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488,
 1488, 1488,    0, 1488, 1488, 1488, 1488, 1488, 1488, 1488,
 1488, 1487, 1488, 1488, 1488, 1488,    0, 1488, 1488, 1488,
 1488, 1488, 1488,    0,    0, 1488, 1488, 1488, 1488, 1488,
 1488, 1488, 1488, 1488,    0,    0,    0,    0,    0, 1488,
    0, 1488, 1488, 1488, 1488, 1488, 1488,    0, 1488,    0,
    0,    0, 1487, 1487, 1487, 1487, 1487,    0, 1487,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1487, 1487, 1487, 1487,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1487,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1487,    0,
 1487,    0,    0, 1487,    0, 1487, 1487,    0,    0, 1487,
 1487,    0, 1487,    0,    0,    0,    0,    0,    0,    0,
 1487, 1487,    0, 1487,    0, 1487,    0,    0, 1487,    0,
    0, 1487,    0,    0,    0,    0,    0,    0, 1487,    0,
 1487, 1487,    0, 1487, 1487, 1487, 1487, 1487,    0,    0,
 1487,    0,    0, 1487,    0, 1487, 1487,    0,    0, 1487,
 1487, 1487,    0, 1487, 1487, 1487, 1487, 1487, 1487, 1487,
    0,    0,    0, 1487, 1487, 1487, 1487, 1487,    0,    0,
    0, 1487,    0,    0,    0,    0,    0,    0,    0, 1487,
 1487, 1487, 1487, 1487, 1487,    0,    0,    0, 1487, 1487,
    0, 1487,    0, 1487,    0, 1487, 1487, 1487,    0, 1487,
    0, 1487, 1487, 1487,    0, 1487, 1487, 1487, 1487, 1487,
    0, 1487, 1487,    0,    0,    0,    0, 1487,    0, 1487,
 1487,    0,    0, 1487, 1487, 1487,    0,    0, 1487,    0,
 1487,    0,    0, 1487, 1487, 1487, 1487,    0, 1487,    0,
 1487,    0, 1487, 1487, 1487, 1487, 1487,    0,    0, 1487,
 1487, 1487,    0, 1487, 1487,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1487, 1487, 1487,    0, 1487, 1487,
 1487,    0, 1487,    0,    0,    0, 1487,    0, 1487, 1487,
 1487, 1487,    0, 1487,    0, 1487, 1487, 1487, 1487, 1487,
 1487, 1487, 1487,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1487, 1487,    0, 1487, 1487, 1487,    0,    0,
    0,    0, 1487, 1487, 1487, 1487, 1487,    0, 1487,    0,
    0, 1487, 1487,    0,    0,    0, 1487, 1487,    0,    0,
 1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487,    0,
 1487,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487,
 1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487,
 1487,    0, 1487, 1487, 1487, 1487, 1487, 1487,    0, 1487,
 1487, 1487, 1487,    0, 1487,    0, 1487, 1487, 1487, 1487,
 1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487,
 1487, 1487, 1487, 1487,    0, 1487, 1487, 1487, 1487,    0,
 1487, 1487, 1487, 1487, 1487,    0, 1487, 1487, 1487, 1487,
 1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487,
 1487, 1487, 1487, 1487, 1487, 1487,    0, 1487, 1487, 1487,
 1487, 1487, 1487, 1487, 1487, 1493, 1487, 1487, 1487, 1487,
    0, 1487, 1487, 1487, 1487, 1487, 1487,    0,    0, 1487,
 1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487,    0,    0,
    0,    0,    0, 1487,    0, 1487, 1487, 1487, 1487, 1487,
 1487,    0, 1487,    0,    0,    0, 1493, 1493, 1493, 1493,
 1493,    0, 1493,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1493, 1493, 1493, 1493,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1493,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1493,    0, 1493,    0,    0, 1493,    0, 1493,
 1493,    0,    0, 1493, 1493,    0, 1493,    0,    0,    0,
    0,    0,    0,    0, 1493, 1493,    0, 1493,    0, 1493,
    0,    0, 1493,    0,    0, 1493,    0,    0,    0,    0,
    0,    0, 1493,    0, 1493, 1493,    0, 1493, 1493, 1493,
 1493, 1493,    0,    0, 1493,    0,    0, 1493,    0, 1493,
 1493,    0,    0, 1493, 1493, 1493,    0, 1493, 1493, 1493,
 1493, 1493, 1493, 1493,    0,    0,    0, 1493, 1493, 1493,
 1493, 1493,    0,    0,    0, 1493,    0,    0,    0,    0,
    0,    0,    0, 1493, 1493, 1493, 1493, 1493, 1493,    0,
    0,    0, 1493, 1493,    0, 1493,    0, 1493,    0, 1493,
 1493, 1493,    0, 1493,    0, 1493, 1493, 1493,    0, 1493,
 1493, 1493, 1493, 1493,    0, 1493, 1493,    0,    0,    0,
    0, 1493,    0, 1493, 1493,    0,    0, 1493, 1493, 1493,
    0,    0, 1493,    0, 1493,    0,    0, 1493, 1493, 1493,
 1493,    0, 1493,    0, 1493,    0, 1493, 1493, 1493, 1493,
 1493,    0,    0, 1493, 1493, 1493,    0, 1493, 1493,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1493, 1493,
 1493,    0, 1493, 1493, 1493,    0, 1493,    0,    0,    0,
 1493,    0, 1493, 1493, 1493, 1493,    0, 1493,    0, 1493,
 1493, 1493, 1493, 1493, 1493, 1493, 1493,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1493, 1493,    0, 1493,
 1493, 1493,    0,    0,    0,    0, 1493, 1493, 1493, 1493,
 1493,    0, 1493,    0,    0, 1493, 1493,    0,    0,    0,
 1493, 1493,    0,    0, 1493, 1493, 1493, 1493, 1493, 1493,
 1493, 1493, 1493,    0, 1493,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1493, 1493, 1493, 1493, 1493, 1493,
 1493, 1493, 1493, 1493, 1493, 1493, 1493, 1493, 1493, 1493,
 1493, 1493, 1493, 1493, 1493,    0, 1493, 1493, 1493, 1493,
 1493, 1493,    0, 1493, 1493, 1493, 1493,    0, 1493,    0,
 1493, 1493, 1493, 1493, 1493, 1493, 1493, 1493, 1493, 1493,
 1493, 1493, 1493, 1493, 1493, 1493, 1493, 1493,    0, 1493,
 1493, 1493, 1493,    0, 1493, 1493, 1493, 1493, 1493,    0,
 1493, 1493, 1493, 1493, 1493, 1493, 1493, 1493, 1493, 1493,
 1493, 1493, 1493, 1493, 1493, 1493, 1493, 1493, 1493, 1493,
    0, 1493, 1493, 1493, 1493, 1493, 1493, 1493, 1493, 1494,
 1493, 1493, 1493, 1493,    0, 1493, 1493, 1493, 1493, 1493,
 1493,    0,    0, 1493, 1493, 1493, 1493, 1493, 1493, 1493,
 1493, 1493,    0,    0,    0,    0,    0, 1493,    0, 1493,
 1493, 1493, 1493, 1493, 1493,    0, 1493,    0,    0,    0,
 1494, 1494, 1494, 1494, 1494,    0, 1494,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1494, 1494,
 1494, 1494,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1494,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1494,    0, 1494,    0,
    0, 1494,    0, 1494, 1494,    0,    0, 1494, 1494,    0,
 1494,    0,    0,    0,    0,    0,    0,    0, 1494, 1494,
    0, 1494,    0, 1494,    0,    0, 1494,    0,    0, 1494,
    0,    0,    0,    0,    0,    0, 1494,    0, 1494, 1494,
    0, 1494, 1494, 1494, 1494, 1494,    0,    0, 1494,    0,
    0, 1494,    0, 1494, 1494,    0,    0, 1494, 1494, 1494,
    0, 1494, 1494, 1494, 1494, 1494, 1494, 1494,    0,    0,
    0, 1494, 1494, 1494, 1494, 1494,    0,    0,    0, 1494,
    0,    0,    0,    0,    0,    0,    0, 1494, 1494, 1494,
 1494, 1494, 1494,    0,    0,    0, 1494, 1494,    0, 1494,
    0, 1494,    0, 1494, 1494, 1494,    0, 1494,    0, 1494,
 1494, 1494,    0, 1494, 1494, 1494, 1494, 1494,    0, 1494,
 1494,    0,    0,    0,    0, 1494,    0, 1494, 1494,    0,
    0, 1494, 1494, 1494,    0,    0, 1494,    0, 1494,    0,
    0, 1494, 1494, 1494, 1494,    0, 1494,    0, 1494,    0,
 1494, 1494, 1494, 1494, 1494,    0,    0, 1494, 1494, 1494,
    0, 1494, 1494,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1494, 1494, 1494,    0, 1494, 1494, 1494,    0,
 1494,    0,    0,    0, 1494,    0, 1494, 1494, 1494, 1494,
    0, 1494,    0, 1494, 1494, 1494, 1494, 1494, 1494, 1494,
 1494,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1494, 1494,    0, 1494, 1494, 1494,    0,    0,    0,    0,
 1494, 1494, 1494, 1494, 1494,    0, 1494,    0,    0, 1494,
 1494,    0,    0,    0, 1494, 1494,    0,    0, 1494, 1494,
 1494, 1494, 1494, 1494, 1494, 1494, 1494,    0, 1494,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1494, 1494,
 1494, 1494, 1494, 1494, 1494, 1494, 1494, 1494, 1494, 1494,
 1494, 1494, 1494, 1494, 1494, 1494, 1494, 1494, 1494,    0,
 1494, 1494, 1494, 1494, 1494, 1494,    0, 1494, 1494, 1494,
 1494,    0, 1494,    0, 1494, 1494, 1494, 1494, 1494, 1494,
 1494, 1494, 1494, 1494, 1494, 1494, 1494, 1494, 1494, 1494,
 1494, 1494,    0, 1494, 1494, 1494, 1494,    0, 1494, 1494,
 1494, 1494, 1494,    0, 1494, 1494, 1494, 1494, 1494, 1494,
 1494, 1494, 1494, 1494, 1494, 1494, 1494, 1494, 1494, 1494,
 1494, 1494, 1494, 1494,    0, 1494, 1494, 1494, 1494, 1494,
 1494, 1494, 1494, 1489, 1494, 1494, 1494, 1494,    0, 1494,
 1494, 1494, 1494, 1494, 1494,    0,    0, 1494, 1494, 1494,
 1494, 1494, 1494, 1494, 1494, 1494,    0,    0,    0,    0,
    0, 1494,    0, 1494, 1494, 1494, 1494, 1494, 1494,    0,
 1494,    0,    0,    0, 1489,    0, 1489, 1489, 1489,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1489, 1489, 1489, 1489,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1489,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1489,    0, 1489,    0,    0, 1489,    0, 1489, 1489,    0,
    0, 1489, 1489,    0, 1489,    0,    0,    0,    0,    0,
    0,    0, 1489, 1489,    0, 1489,    0, 1489,    0,    0,
 1489,    0,    0, 1489,    0,    0,    0,    0,    0,    0,
 1489,    0, 1489, 1489,    0, 1489, 1489, 1489, 1489, 1489,
    0,    0, 1489,    0,    0, 1489,    0, 1489, 1489,    0,
    0, 1489, 1489, 1489,    0, 1489, 1489, 1489, 1489, 1489,
 1489, 1489,    0,    0,    0, 1489, 1489, 1489, 1489, 1489,
    0,    0,    0, 1489,    0,    0,    0,    0,    0,    0,
    0, 1489, 1489, 1489, 1489, 1489, 1489,    0,    0,    0,
 1489, 1489,    0, 1489,    0, 1489,    0, 1489, 1489, 1489,
    0, 1489,    0, 1489, 1489, 1489,    0, 1489, 1489, 1489,
 1489, 1489,    0, 1489, 1489,    0,    0,    0,    0, 1489,
    0, 1489, 1489,    0,    0, 1489, 1489, 1489,    0,    0,
 1489,    0, 1489,    0,    0, 1489, 1489, 1489, 1489,    0,
 1489,    0, 1489,    0, 1489, 1489, 1489, 1489, 1489,    0,
    0, 1489, 1489, 1489,    0, 1489, 1489,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1489, 1489, 1489,    0,
 1489, 1489, 1489,    0, 1489,    0,    0,    0, 1489,    0,
 1489, 1489, 1489, 1489,    0, 1489,    0, 1489, 1489, 1489,
 1489, 1489, 1489, 1489, 1489,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1489, 1489,    0, 1489, 1489, 1489,
    0,    0,    0,    0, 1489, 1489, 1489, 1489, 1489,    0,
 1489,    0,    0, 1489, 1489,    0,    0,    0, 1489, 1489,
    0,    0, 1489, 1489, 1489, 1489, 1489, 1489, 1489, 1489,
 1489,    0, 1489,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1489, 1489, 1489, 1489, 1489, 1489, 1489, 1489,
 1489, 1489, 1489, 1489, 1489, 1489, 1489, 1489, 1489, 1489,
 1489, 1489, 1489,    0, 1489, 1489, 1489, 1489, 1489, 1489,
    0, 1489, 1489, 1489, 1489,    0, 1489,    0, 1489, 1489,
 1489, 1489, 1489, 1489, 1489, 1489, 1489, 1489, 1489, 1489,
 1489, 1489, 1489, 1489, 1489, 1489,    0, 1489, 1489, 1489,
 1489,    0, 1489, 1489, 1489, 1489, 1489,    0, 1489, 1489,
 1489, 1489, 1489, 1489, 1489, 1489, 1489, 1489, 1489, 1489,
 1489, 1489, 1489, 1489, 1489, 1489, 1489, 1489,    0, 1489,
 1489, 1489, 1489, 1489, 1489, 1489, 1489, 1492, 1489, 1489,
 1489, 1489,    0, 1489, 1489, 1489, 1489, 1489, 1489,    0,
    0, 1489, 1489, 1489, 1489, 1489, 1489, 1489, 1489, 1489,
    0,    0,    0,    0,    0, 1489,    0, 1489, 1489, 1489,
 1489, 1489, 1489,    0, 1489,    0,    0,    0, 1492,    0,
 1492, 1492, 1492,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1492, 1492, 1492, 1492,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1492,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1492,    0, 1492,    0,    0, 1492,
    0, 1492, 1492,    0,    0, 1492, 1492,    0, 1492,    0,
    0,    0,    0,    0,    0,    0, 1492, 1492,    0, 1492,
    0, 1492,    0,    0, 1492,    0,    0, 1492,    0,    0,
    0,    0,    0,    0, 1492,    0, 1492, 1492,    0, 1492,
 1492, 1492, 1492, 1492,    0,    0, 1492,    0,    0, 1492,
    0, 1492, 1492,    0,    0, 1492, 1492, 1492,    0, 1492,
 1492, 1492, 1492, 1492, 1492, 1492,    0,    0,    0, 1492,
 1492, 1492, 1492, 1492,    0,    0,    0, 1492,    0,    0,
    0,    0,    0,    0,    0, 1492, 1492, 1492, 1492, 1492,
 1492,    0,    0,    0, 1492, 1492,    0, 1492,    0, 1492,
    0, 1492, 1492, 1492,    0, 1492,    0, 1492, 1492, 1492,
    0, 1492, 1492, 1492, 1492, 1492,    0, 1492, 1492,    0,
    0,    0,    0, 1492,    0, 1492, 1492,    0,    0, 1492,
 1492, 1492,    0,    0, 1492,    0, 1492,    0,    0, 1492,
 1492, 1492, 1492,    0, 1492,    0, 1492,    0, 1492, 1492,
 1492, 1492, 1492,    0,    0, 1492, 1492, 1492,    0, 1492,
 1492,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1492, 1492, 1492,    0, 1492, 1492, 1492,    0, 1492,    0,
    0,    0, 1492,    0, 1492, 1492, 1492, 1492,    0, 1492,
    0, 1492, 1492, 1492, 1492, 1492, 1492, 1492, 1492,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1492, 1492,
    0, 1492, 1492, 1492,    0,    0,    0,    0, 1492, 1492,
 1492, 1492, 1492,    0, 1492,    0,    0, 1492, 1492,    0,
    0,    0, 1492, 1492,    0,    0, 1492, 1492, 1492, 1492,
 1492, 1492, 1492, 1492, 1492,    0, 1492,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1492, 1492, 1492, 1492,
 1492, 1492, 1492, 1492, 1492, 1492, 1492, 1492, 1492, 1492,
 1492, 1492, 1492, 1492, 1492, 1492, 1492,    0, 1492, 1492,
 1492, 1492, 1492, 1492,    0, 1492, 1492, 1492, 1492,    0,
 1492,    0, 1492, 1492, 1492, 1492, 1492, 1492, 1492, 1492,
 1492, 1492, 1492, 1492, 1492, 1492, 1492, 1492, 1492, 1492,
    0, 1492, 1492, 1492, 1492,    0, 1492, 1492, 1492, 1492,
 1492,    0, 1492, 1492, 1492, 1492, 1492, 1492, 1492, 1492,
 1492, 1492, 1492, 1492, 1492, 1492, 1492, 1492, 1492, 1492,
 1492, 1492,    0, 1492, 1492, 1492, 1492, 1492, 1492, 1492,
 1492, 1469, 1492, 1492, 1492, 1492,    0, 1492, 1492, 1492,
 1492, 1492, 1492,    0,    0, 1492, 1492, 1492, 1492, 1492,
 1492, 1492, 1492, 1492,    0,    0,    0,    0,    0, 1492,
    0, 1492, 1492, 1492, 1492, 1492, 1492,    0, 1492,    0,
    0,    0, 1469,    0,    0, 1469,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1469, 1469, 1469, 1469,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1469,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1469,    0,
 1469,    0,    0, 1469,    0, 1469, 1469,    0,    0, 1469,
 1469,    0, 1469,    0,    0,    0,    0,    0,    0,    0,
 1469, 1469,    0, 1469,    0, 1469,    0,    0, 1469,    0,
    0, 1469,    0,    0,    0,    0,    0,    0, 1469,    0,
 1469, 1469,    0, 1469, 1469, 1469, 1469, 1469,    0,    0,
 1469,    0,    0, 1469,    0, 1469, 1469,    0,    0, 1469,
 1469, 1469,    0, 1469, 1469, 1469, 1469, 1469, 1469, 1469,
    0,    0,    0, 1469, 1469, 1469, 1469, 1469,    0,    0,
    0, 1469,    0,    0,    0,    0,    0,    0,    0, 1469,
 1469, 1469, 1469, 1469, 1469,    0,    0,    0, 1469, 1469,
    0, 1469,    0, 1469,    0, 1469, 1469, 1469,    0, 1469,
    0, 1469, 1469, 1469,    0, 1469, 1469, 1469, 1469, 1469,
    0, 1469, 1469,    0,    0,    0,    0, 1469,    0, 1469,
 1469,    0,    0, 1469, 1469, 1469,    0,    0, 1469,    0,
 1469,    0,    0, 1469, 1469, 1469, 1469,    0, 1469,    0,
 1469,    0, 1469, 1469, 1469, 1469, 1469,    0,    0, 1469,
 1469, 1469,    0, 1469, 1469,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1469, 1469, 1469,    0, 1469, 1469,
 1469,    0, 1469,    0,    0,    0, 1469,    0, 1469, 1469,
 1469, 1469,    0, 1469,    0, 1469, 1469, 1469, 1469, 1469,
 1469, 1469, 1469,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1469, 1469,    0, 1469, 1469, 1469,    0,    0,
    0,    0, 1469, 1469, 1469, 1469, 1469,    0, 1469,    0,
    0, 1469, 1469,    0,    0,    0, 1469, 1469,    0,    0,
 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469,    0,
 1469,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469,
 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469,
 1469,    0, 1469, 1469, 1469, 1469, 1469, 1469,    0, 1469,
 1469, 1469, 1469,    0, 1469,    0, 1469, 1469, 1469, 1469,
 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469,
 1469, 1469, 1469, 1469,    0, 1469, 1469, 1469, 1469,    0,
 1469, 1469, 1469, 1469, 1469,    0, 1469, 1469, 1469, 1469,
 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469,
 1469, 1469, 1469, 1469, 1469, 1469,    0, 1469, 1469, 1469,
 1469, 1469, 1469, 1469, 1469, 1374, 1469, 1469, 1469, 1469,
    0, 1469, 1469, 1469, 1469, 1469, 1469,    0,    0, 1469,
 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469,    0,    0,
    0,    0,    0, 1469,    0, 1469, 1469, 1469, 1469, 1469,
 1469,    0, 1469,    0,    0,    0, 1374,    0,    0, 1374,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1374, 1374, 1374, 1374,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1374,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1374,    0, 1374,    0,    0, 1374,    0, 1374,
 1374,    0,    0, 1374, 1374,    0, 1374,    0,    0,    0,
    0,    0,    0,    0, 1374, 1374,    0, 1374,    0, 1374,
    0,    0, 1374,    0,    0, 1374,    0,    0,    0,    0,
    0,    0, 1374,    0, 1374, 1374,    0, 1374, 1374, 1374,
 1374, 1374,    0,    0, 1374,    0,    0, 1374,    0, 1374,
 1374,    0,    0, 1374, 1374, 1374,    0, 1374, 1374, 1374,
 1374, 1374, 1374, 1374,    0,    0,    0, 1374, 1374, 1374,
 1374, 1374,    0,    0,    0, 1374,    0,    0,    0,    0,
    0,    0,    0, 1374, 1374, 1374, 1374, 1374, 1374,    0,
    0,    0, 1374, 1374,    0, 1374,    0, 1374,    0, 1374,
 1374, 1374,    0, 1374,    0, 1374, 1374, 1374,    0, 1374,
 1374, 1374, 1374, 1374,    0, 1374, 1374,    0,    0,    0,
    0, 1374,    0, 1374, 1374,    0,    0, 1374, 1374, 1374,
    0,    0, 1374,    0, 1374,    0,    0, 1374, 1374, 1374,
 1374,    0, 1374,    0, 1374,    0, 1374, 1374, 1374, 1374,
 1374,    0,    0, 1374, 1374, 1374,    0, 1374, 1374,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1374, 1374,
 1374,    0, 1374, 1374, 1374,    0, 1374,    0,    0,    0,
 1374,    0, 1374, 1374, 1374, 1374,    0, 1374,    0, 1374,
 1374, 1374, 1374, 1374, 1374, 1374, 1374,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1374, 1374,    0, 1374,
 1374, 1374,    0,    0,    0,    0, 1374, 1374, 1374, 1374,
 1374,    0, 1374,    0,    0, 1374, 1374,    0,    0,    0,
 1374, 1374,    0,    0, 1374, 1374, 1374, 1374, 1374, 1374,
 1374, 1374, 1374,    0, 1374,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1374, 1374, 1374, 1374, 1374, 1374,
 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374,
 1374, 1374, 1374, 1374, 1374,    0, 1374, 1374, 1374, 1374,
 1374, 1374,    0, 1374, 1374, 1374, 1374,    0, 1374,    0,
 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374,
 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374,    0, 1374,
 1374, 1374, 1374,    0, 1374, 1374, 1374, 1374, 1374,    0,
 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374,
 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374,
    0, 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1357,
 1374, 1374, 1374, 1374,    0, 1374, 1374, 1374, 1374, 1374,
 1374,    0,    0, 1374, 1374, 1374, 1374, 1374, 1374, 1374,
 1374, 1374,    0,    0,    0,    0,    0, 1374,    0, 1374,
 1374, 1374, 1374, 1374, 1374,    0, 1374,    0,    0,    0,
 1357,    0,    0, 1357,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1357, 1357,
 1357, 1357,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1357,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1357,    0, 1357,    0,
    0, 1357,    0, 1357, 1357,    0,    0, 1357, 1357,    0,
 1357,    0,    0,    0,    0,    0,    0,    0, 1357, 1357,
    0, 1357,    0, 1357,    0,    0, 1357,    0,    0, 1357,
    0,    0,    0,    0,    0,    0, 1357,    0, 1357, 1357,
    0, 1357, 1357, 1357, 1357, 1357,    0,    0, 1357,    0,
    0, 1357,    0, 1357, 1357,    0,    0, 1357, 1357, 1357,
    0, 1357, 1357, 1357, 1357, 1357, 1357, 1357,    0,    0,
    0, 1357,    0, 1357, 1357, 1357,    0,    0,    0, 1357,
    0,    0,    0,    0,    0,    0,    0, 1357, 1357, 1357,
 1357, 1357, 1357,    0,    0,    0, 1357, 1357,    0, 1357,
    0, 1357,    0, 1357, 1357, 1357,    0, 1357,    0, 1357,
 1357, 1357,    0, 1357, 1357, 1357, 1357, 1357,    0, 1357,
 1357,    0,    0,    0,    0, 1357,    0, 1357, 1357,    0,
    0, 1357, 1357, 1357,    0,    0, 1357,    0, 1357,    0,
    0, 1357, 1357, 1357, 1357,    0, 1357,    0, 1357,    0,
 1357, 1357, 1357, 1357, 1357,    0,    0, 1357, 1357, 1357,
    0, 1357, 1357,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1357, 1357, 1357,    0, 1357, 1357, 1357,    0,
 1357,    0,    0,    0, 1357,    0, 1357, 1357, 1357, 1357,
    0, 1357,    0, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 1357,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1357, 1357,    0, 1357, 1357, 1357,    0,    0,    0,    0,
 1357, 1357, 1357, 1357, 1357,    0, 1357,    0,    0, 1357,
 1357,    0,    0,    0, 1357, 1357,    0,    0, 1357, 1357,
 1357, 1357, 1357, 1357, 1357, 1357, 1357,    0, 1357,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1357, 1357,
 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,    0,
 1357, 1357, 1357, 1357, 1357, 1357,    0, 1357, 1357, 1357,
 1357,    0, 1357,    0, 1357, 1357, 1357, 1357, 1357, 1357,
 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 1357, 1357,    0, 1357, 1357, 1357, 1357,    0, 1357, 1357,
 1357, 1357, 1357,    0, 1357, 1357, 1357, 1357, 1357, 1357,
 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 1357, 1357, 1357, 1357,    0, 1357, 1357, 1357, 1357, 1357,
 1357, 1357, 1357, 1376, 1357, 1357, 1357, 1357,    0, 1357,
 1357, 1357, 1357, 1357, 1357,    0,    0, 1357, 1357, 1357,
 1357, 1357, 1357, 1357, 1357, 1357,    0,    0,    0,    0,
    0, 1357,    0, 1357, 1357, 1357, 1357, 1357, 1357,    0,
 1357,    0,    0,    0, 1376,    0,    0, 1376,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1376, 1376, 1376, 1376,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1376,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1376,    0, 1376,    0,    0, 1376,    0, 1376, 1376,    0,
    0, 1376, 1376,    0, 1376,    0,    0,    0,    0,    0,
    0,    0, 1376, 1376,    0, 1376,    0, 1376,    0,    0,
 1376,    0,    0, 1376,    0,    0,    0,    0,    0,    0,
 1376,    0, 1376, 1376,    0, 1376, 1376, 1376, 1376, 1376,
    0,    0, 1376,    0,    0, 1376,    0, 1376, 1376,    0,
    0, 1376, 1376, 1376,    0, 1376, 1376, 1376, 1376, 1376,
 1376, 1376,    0,    0,    0, 1376,    0, 1376, 1376, 1376,
    0,    0,    0, 1376,    0,    0,    0,    0,    0,    0,
    0, 1376, 1376, 1376, 1376, 1376, 1376,    0,    0,    0,
 1376, 1376,    0, 1376,    0, 1376,    0, 1376, 1376, 1376,
    0, 1376,    0, 1376, 1376, 1376,    0, 1376, 1376, 1376,
 1376, 1376,    0, 1376, 1376,    0,    0,    0,    0, 1376,
    0, 1376, 1376,    0,    0, 1376, 1376, 1376,    0,    0,
 1376,    0, 1376,    0,    0, 1376, 1376, 1376, 1376,    0,
 1376,    0, 1376,    0, 1376, 1376, 1376, 1376, 1376,    0,
    0, 1376, 1376, 1376,    0, 1376, 1376,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1376, 1376, 1376,    0,
 1376, 1376, 1376,    0, 1376,    0,    0,    0, 1376,    0,
 1376, 1376, 1376, 1376,    0, 1376,    0, 1376, 1376, 1376,
 1376, 1376, 1376, 1376, 1376,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1376, 1376,    0, 1376, 1376, 1376,
    0,    0,    0,    0, 1376, 1376, 1376, 1376, 1376,    0,
 1376,    0,    0, 1376, 1376,    0,    0,    0, 1376, 1376,
    0,    0, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
 1376,    0, 1376,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
 1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
 1376, 1376, 1376,    0, 1376, 1376, 1376, 1376, 1376, 1376,
    0, 1376, 1376, 1376, 1376,    0, 1376,    0, 1376, 1376,
 1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
 1376, 1376, 1376, 1376, 1376, 1376,    0, 1376, 1376, 1376,
 1376,    0, 1376, 1376, 1376, 1376, 1376,    0, 1376, 1376,
 1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
 1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,    0, 1376,
 1376, 1376, 1376, 1376, 1376, 1376, 1376, 1377, 1376, 1376,
 1376, 1376,    0, 1376, 1376, 1376, 1376, 1376, 1376,    0,
    0, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
    0,    0,    0,    0,    0, 1376,    0, 1376, 1376, 1376,
 1376, 1376, 1376,    0, 1376,    0,    0,    0, 1377,    0,
    0, 1377,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1377, 1377, 1377, 1377,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1377,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1377,    0, 1377,    0,    0, 1377,
    0, 1377, 1377,    0,    0, 1377, 1377,    0, 1377,    0,
    0,    0,    0,    0,    0,    0, 1377, 1377,    0, 1377,
    0, 1377,    0,    0, 1377,    0,    0, 1377,    0,    0,
    0,    0,    0,    0, 1377,    0, 1377, 1377,    0, 1377,
 1377, 1377, 1377, 1377,    0,    0, 1377,    0,    0, 1377,
    0, 1377, 1377,    0,    0, 1377, 1377, 1377,    0, 1377,
 1377, 1377, 1377, 1377, 1377, 1377,    0,    0,    0, 1377,
    0, 1377, 1377, 1377,    0,    0,    0, 1377,    0,    0,
    0,    0,    0,    0,    0, 1377, 1377, 1377, 1377, 1377,
 1377,    0,    0,    0, 1377, 1377,    0, 1377,    0, 1377,
    0, 1377, 1377, 1377,    0, 1377,    0, 1377, 1377, 1377,
    0, 1377, 1377, 1377, 1377, 1377,    0, 1377, 1377,    0,
    0,    0,    0, 1377,    0, 1377, 1377,    0,    0, 1377,
 1377, 1377,    0,    0, 1377,    0, 1377,    0,    0, 1377,
 1377, 1377, 1377,    0, 1377,    0, 1377,    0, 1377, 1377,
 1377, 1377, 1377,    0,    0, 1377, 1377, 1377,    0, 1377,
 1377,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1377, 1377, 1377,    0, 1377, 1377, 1377,    0, 1377,    0,
    0,    0, 1377,    0, 1377, 1377, 1377, 1377,    0, 1377,
    0, 1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1377, 1377,
    0, 1377, 1377, 1377,    0,    0,    0,    0, 1377, 1377,
 1377, 1377, 1377,    0, 1377,    0,    0, 1377, 1377,    0,
    0,    0, 1377, 1377,    0,    0, 1377, 1377, 1377, 1377,
 1377, 1377, 1377, 1377, 1377,    0, 1377,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1377, 1377, 1377, 1377,
 1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
 1377, 1377, 1377, 1377, 1377, 1377, 1377,    0, 1377, 1377,
 1377, 1377, 1377, 1377,    0, 1377, 1377, 1377, 1377,    0,
 1377,    0, 1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
 1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
    0, 1377, 1377, 1377, 1377,    0, 1377, 1377, 1377, 1377,
 1377,    0, 1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
 1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
 1377, 1377,    0, 1377, 1377, 1377, 1377, 1377, 1377, 1377,
 1377, 1382, 1377, 1377, 1377, 1377,    0, 1377, 1377, 1377,
 1377, 1377, 1377,    0,    0, 1377, 1377, 1377, 1377, 1377,
 1377, 1377, 1377, 1377,    0,    0,    0,    0,    0, 1377,
    0, 1377, 1377, 1377, 1377, 1377, 1377,    0, 1377,    0,
    0,    0, 1382,    0,    0, 1382,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1382, 1382, 1382, 1382,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1382,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1382,    0,
 1382,    0,    0, 1382,    0, 1382, 1382,    0,    0, 1382,
 1382,    0, 1382,    0,    0,    0,    0,    0,    0,    0,
 1382, 1382,    0, 1382,    0, 1382,    0,    0, 1382,    0,
    0, 1382,    0,    0,    0,    0,    0,    0, 1382,    0,
 1382, 1382,    0, 1382, 1382, 1382, 1382, 1382,    0,    0,
 1382,    0,    0, 1382,    0, 1382, 1382,    0,    0, 1382,
 1382, 1382,    0, 1382, 1382, 1382, 1382, 1382, 1382, 1382,
    0,    0,    0, 1382,    0, 1382, 1382, 1382,    0,    0,
    0, 1382,    0,    0,    0,    0,    0,    0,    0, 1382,
 1382, 1382, 1382, 1382, 1382,    0,    0,    0, 1382, 1382,
    0, 1382,    0, 1382,    0, 1382, 1382, 1382,    0, 1382,
    0, 1382, 1382, 1382,    0, 1382, 1382, 1382, 1382, 1382,
    0, 1382, 1382,    0,    0,    0,    0, 1382,    0, 1382,
 1382,    0,    0, 1382, 1382, 1382,    0,    0, 1382,    0,
 1382,    0,    0, 1382, 1382, 1382, 1382,    0, 1382,    0,
 1382,    0, 1382, 1382, 1382, 1382, 1382,    0,    0, 1382,
 1382, 1382,    0, 1382, 1382,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1382, 1382, 1382,    0, 1382, 1382,
 1382,    0, 1382,    0,    0,    0, 1382,    0, 1382, 1382,
 1382, 1382,    0, 1382,    0, 1382, 1382, 1382, 1382, 1382,
 1382, 1382, 1382,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1382, 1382,    0, 1382, 1382, 1382,    0,    0,
    0,    0, 1382, 1382, 1382, 1382, 1382,    0, 1382,    0,
    0, 1382, 1382,    0,    0,    0, 1382, 1382,    0,    0,
 1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382,    0,
 1382,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382,
 1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382,
 1382,    0, 1382, 1382, 1382, 1382, 1382, 1382,    0, 1382,
 1382, 1382, 1382,    0, 1382,    0, 1382, 1382, 1382, 1382,
 1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382,
 1382, 1382, 1382, 1382,    0, 1382, 1382, 1382, 1382,    0,
 1382, 1382, 1382, 1382, 1382,    0, 1382, 1382, 1382, 1382,
 1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382,
 1382, 1382, 1382, 1382, 1382, 1382,    0, 1382, 1382, 1382,
 1382, 1382, 1382, 1382, 1382, 1384, 1382, 1382, 1382, 1382,
    0, 1382, 1382, 1382, 1382, 1382, 1382,    0,    0, 1382,
 1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382,    0,    0,
    0,    0,    0, 1382,    0, 1382, 1382, 1382, 1382, 1382,
 1382,    0, 1382,    0,    0,    0, 1384,    0,    0, 1384,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1384, 1384, 1384, 1384,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1384,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1384,    0, 1384,    0,    0, 1384,    0, 1384,
 1384,    0,    0, 1384, 1384,    0, 1384,    0,    0,    0,
    0,    0,    0,    0, 1384, 1384,    0, 1384,    0, 1384,
    0,    0, 1384,    0,    0, 1384,    0,    0,    0,    0,
    0,    0, 1384,    0, 1384, 1384,    0, 1384, 1384, 1384,
 1384, 1384,    0,    0, 1384,    0,    0, 1384,    0, 1384,
 1384,    0,    0, 1384, 1384, 1384,    0, 1384, 1384, 1384,
 1384, 1384, 1384, 1384,    0,    0,    0, 1384,    0, 1384,
 1384, 1384,    0,    0,    0, 1384,    0,    0,    0,    0,
    0,    0,    0, 1384, 1384, 1384, 1384, 1384, 1384,    0,
    0,    0, 1384, 1384,    0, 1384,    0, 1384,    0, 1384,
 1384, 1384,    0, 1384,    0, 1384, 1384, 1384,    0, 1384,
 1384, 1384, 1384, 1384,    0, 1384, 1384,    0,    0,    0,
    0, 1384,    0, 1384, 1384,    0,    0, 1384, 1384, 1384,
    0,    0, 1384,    0, 1384,    0,    0, 1384, 1384, 1384,
 1384,    0, 1384,    0, 1384,    0, 1384, 1384, 1384, 1384,
 1384,    0,    0, 1384, 1384, 1384,    0, 1384, 1384,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1384, 1384,
 1384,    0, 1384, 1384, 1384,    0, 1384,    0,    0,    0,
 1384,    0, 1384, 1384, 1384, 1384,    0, 1384,    0, 1384,
 1384, 1384, 1384, 1384, 1384, 1384, 1384,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1384, 1384,    0, 1384,
 1384, 1384,    0,    0,    0,    0, 1384, 1384, 1384, 1384,
 1384,    0, 1384,    0,    0, 1384, 1384,    0,    0,    0,
 1384, 1384,    0,    0, 1384, 1384, 1384, 1384, 1384, 1384,
 1384, 1384, 1384,    0, 1384,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1384, 1384, 1384, 1384, 1384, 1384,
 1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384,
 1384, 1384, 1384, 1384, 1384,    0, 1384, 1384, 1384, 1384,
 1384, 1384,    0, 1384, 1384, 1384, 1384,    0, 1384,    0,
 1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384,
 1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384,    0, 1384,
 1384, 1384, 1384,    0, 1384, 1384, 1384, 1384, 1384,    0,
 1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384,
 1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384,
    0, 1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384, 1386,
 1384, 1384, 1384, 1384,    0, 1384, 1384, 1384, 1384, 1384,
 1384,    0,    0, 1384, 1384, 1384, 1384, 1384, 1384, 1384,
 1384, 1384,    0,    0,    0,    0,    0, 1384,    0, 1384,
 1384, 1384, 1384, 1384, 1384,    0, 1384,    0,    0,    0,
 1386,    0,    0, 1386,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1386, 1386,
 1386, 1386,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1386,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1386,    0, 1386,    0,
    0, 1386,    0, 1386, 1386,    0,    0, 1386, 1386,    0,
 1386,    0,    0,    0,    0,    0,    0,    0, 1386, 1386,
    0, 1386,    0, 1386,    0,    0, 1386,    0,    0, 1386,
    0,    0,    0,    0,    0,    0, 1386,    0, 1386, 1386,
    0, 1386, 1386, 1386, 1386, 1386,    0,    0, 1386,    0,
    0, 1386,    0, 1386, 1386,    0,    0, 1386, 1386, 1386,
    0, 1386, 1386, 1386, 1386, 1386, 1386, 1386,    0,    0,
    0, 1386,    0, 1386, 1386, 1386,    0,    0,    0, 1386,
    0,    0,    0,    0,    0,    0,    0, 1386, 1386, 1386,
 1386, 1386, 1386,    0,    0,    0, 1386, 1386,    0, 1386,
    0, 1386,    0, 1386, 1386, 1386,    0, 1386,    0, 1386,
 1386, 1386,    0, 1386, 1386, 1386, 1386, 1386,    0, 1386,
 1386,    0,    0,    0,    0, 1386,    0, 1386, 1386,    0,
    0, 1386, 1386, 1386,    0,    0, 1386,    0, 1386,    0,
    0, 1386, 1386, 1386, 1386,    0, 1386,    0, 1386,    0,
 1386, 1386, 1386, 1386, 1386,    0,    0, 1386, 1386, 1386,
    0, 1386, 1386,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1386, 1386, 1386,    0, 1386, 1386, 1386,    0,
 1386,    0,    0,    0, 1386,    0, 1386, 1386, 1386, 1386,
    0, 1386,    0, 1386, 1386, 1386, 1386, 1386, 1386, 1386,
 1386,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1386, 1386,    0, 1386, 1386, 1386,    0,    0,    0,    0,
 1386, 1386, 1386, 1386, 1386,    0, 1386,    0,    0, 1386,
 1386,    0,    0,    0, 1386, 1386,    0,    0, 1386, 1386,
 1386, 1386, 1386, 1386, 1386, 1386, 1386,    0, 1386,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1386, 1386,
 1386, 1386, 1386, 1386, 1386, 1386, 1386, 1386, 1386, 1386,
 1386, 1386, 1386, 1386, 1386, 1386, 1386, 1386, 1386,    0,
 1386, 1386, 1386, 1386, 1386, 1386,    0, 1386, 1386, 1386,
 1386,    0, 1386,    0, 1386, 1386, 1386, 1386, 1386, 1386,
 1386, 1386, 1386, 1386, 1386, 1386, 1386, 1386, 1386, 1386,
 1386, 1386,    0, 1386, 1386, 1386, 1386,    0, 1386, 1386,
 1386, 1386, 1386,    0, 1386, 1386, 1386, 1386, 1386, 1386,
 1386, 1386, 1386, 1386, 1386, 1386, 1386, 1386, 1386, 1386,
 1386, 1386, 1386, 1386,    0, 1386, 1386, 1386, 1386, 1386,
 1386, 1386, 1386, 1388, 1386, 1386, 1386, 1386,    0, 1386,
 1386, 1386, 1386, 1386, 1386,    0,    0, 1386, 1386, 1386,
 1386, 1386, 1386, 1386, 1386, 1386,    0,    0,    0,    0,
    0, 1386,    0, 1386, 1386, 1386, 1386, 1386, 1386,    0,
 1386,    0,    0,    0, 1388,    0,    0, 1388,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1388, 1388, 1388, 1388,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1388,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1388,    0, 1388,    0,    0, 1388,    0, 1388, 1388,    0,
    0, 1388, 1388,    0, 1388,    0,    0,    0,    0,    0,
    0,    0, 1388, 1388,    0, 1388,    0, 1388,    0,    0,
 1388,    0,    0, 1388,    0,    0,    0,    0,    0,    0,
 1388,    0, 1388, 1388,    0, 1388, 1388, 1388, 1388, 1388,
    0,    0, 1388,    0,    0, 1388,    0, 1388, 1388,    0,
    0, 1388, 1388, 1388,    0, 1388, 1388, 1388, 1388, 1388,
 1388, 1388,    0,    0,    0, 1388,    0, 1388, 1388, 1388,
    0,    0,    0, 1388,    0,    0,    0,    0,    0,    0,
    0, 1388, 1388, 1388, 1388, 1388, 1388,    0,    0,    0,
 1388, 1388,    0, 1388,    0, 1388,    0, 1388, 1388, 1388,
    0, 1388,    0, 1388, 1388, 1388,    0, 1388, 1388, 1388,
 1388, 1388,    0, 1388, 1388,    0,    0,    0,    0, 1388,
    0, 1388, 1388,    0,    0, 1388, 1388, 1388,    0,    0,
 1388,    0, 1388,    0,    0, 1388, 1388, 1388, 1388,    0,
 1388,    0, 1388,    0, 1388, 1388, 1388, 1388, 1388,    0,
    0, 1388, 1388, 1388,    0, 1388, 1388,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1388, 1388, 1388,    0,
 1388, 1388, 1388,    0, 1388,    0,    0,    0, 1388,    0,
 1388, 1388, 1388, 1388,    0, 1388,    0, 1388, 1388, 1388,
 1388, 1388, 1388, 1388, 1388,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1388, 1388,    0, 1388, 1388, 1388,
    0,    0,    0,    0, 1388, 1388, 1388, 1388, 1388,    0,
 1388,    0,    0, 1388, 1388,    0,    0,    0, 1388, 1388,
    0,    0, 1388, 1388, 1388, 1388, 1388, 1388, 1388, 1388,
 1388,    0, 1388,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1388, 1388, 1388, 1388, 1388, 1388, 1388, 1388,
 1388, 1388, 1388, 1388, 1388, 1388, 1388, 1388, 1388, 1388,
 1388, 1388, 1388,    0, 1388, 1388, 1388, 1388, 1388, 1388,
    0, 1388, 1388, 1388, 1388,    0, 1388,    0, 1388, 1388,
 1388, 1388, 1388, 1388, 1388, 1388, 1388, 1388, 1388, 1388,
 1388, 1388, 1388, 1388, 1388, 1388,    0, 1388, 1388, 1388,
 1388,    0, 1388, 1388, 1388, 1388, 1388,    0, 1388, 1388,
 1388, 1388, 1388, 1388, 1388, 1388, 1388, 1388, 1388, 1388,
 1388, 1388, 1388, 1388, 1388, 1388, 1388, 1388,    0, 1388,
 1388, 1388, 1388, 1388, 1388, 1388, 1388, 1381, 1388, 1388,
 1388, 1388,    0, 1388, 1388, 1388, 1388, 1388, 1388,    0,
    0, 1388, 1388, 1388, 1388, 1388, 1388, 1388, 1388, 1388,
    0,    0,    0,    0,    0, 1388,    0, 1388, 1388, 1388,
 1388, 1388, 1388,    0, 1388,    0,    0,    0, 1381,    0,
    0, 1381,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1381, 1381, 1381, 1381,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1381,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1381,    0, 1381,    0,    0, 1381,
    0, 1381, 1381,    0,    0, 1381, 1381,    0, 1381,    0,
    0,    0,    0,    0,    0,    0, 1381, 1381,    0, 1381,
    0, 1381,    0,    0, 1381,    0,    0, 1381,    0,    0,
    0,    0,    0,    0, 1381,    0, 1381, 1381,    0, 1381,
 1381, 1381,    0, 1381,    0,    0, 1381,    0,    0, 1381,
    0, 1381, 1381,    0,    0, 1381, 1381, 1381,    0, 1381,
 1381, 1381, 1381, 1381, 1381, 1381,    0,    0,    0, 1381,
    0, 1381, 1381, 1381,    0,    0,    0, 1381,    0,    0,
    0,    0,    0,    0,    0, 1381, 1381, 1381, 1381, 1381,
 1381,    0,    0,    0, 1381, 1381,    0, 1381,    0, 1381,
    0, 1381, 1381, 1381,    0, 1381,    0, 1381, 1381, 1381,
    0, 1381, 1381, 1381, 1381, 1381,    0, 1381, 1381,    0,
    0,    0,    0, 1381,    0, 1381, 1381,    0,    0, 1381,
 1381, 1381,    0,    0, 1381,    0, 1381,    0,    0, 1381,
 1381, 1381, 1381,    0, 1381,    0, 1381,    0, 1381, 1381,
 1381, 1381, 1381,    0,    0, 1381, 1381, 1381,    0, 1381,
 1381,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1381, 1381, 1381,    0, 1381, 1381, 1381,    0, 1381,    0,
    0,    0, 1381,    0, 1381, 1381, 1381, 1381,    0, 1381,
    0, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1381, 1381,
    0, 1381, 1381, 1381,    0,    0,    0,    0, 1381, 1381,
 1381, 1381, 1381,    0, 1381,    0,    0, 1381, 1381,    0,
    0,    0, 1381, 1381,    0,    0, 1381, 1381, 1381, 1381,
 1381, 1381, 1381, 1381, 1381,    0, 1381,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1381, 1381, 1381, 1381,
 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381,
 1381, 1381, 1381, 1381, 1381, 1381, 1381,    0, 1381, 1381,
 1381, 1381, 1381, 1381,    0, 1381, 1381, 1381, 1381,    0,
 1381,    0, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381,
 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381,
    0, 1381, 1381, 1381, 1381,    0, 1381, 1381, 1381, 1381,
 1381,    0, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381,
 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381,
 1381, 1381,    0, 1381, 1381, 1381, 1381, 1381, 1381, 1381,
 1381, 1383, 1381, 1381, 1381, 1381,    0, 1381, 1381, 1381,
 1381, 1381, 1381,    0,    0, 1381, 1381, 1381, 1381, 1381,
 1381, 1381, 1381, 1381,    0,    0,    0,    0,    0, 1381,
    0, 1381, 1381, 1381, 1381, 1381, 1381,    0, 1381,    0,
    0,    0, 1383,    0,    0, 1383,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1383, 1383, 1383, 1383,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1383,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1383,    0,
 1383,    0,    0, 1383,    0, 1383, 1383,    0,    0, 1383,
 1383,    0, 1383,    0,    0,    0,    0,    0,    0,    0,
 1383, 1383,    0, 1383,    0, 1383,    0,    0, 1383,    0,
    0, 1383,    0,    0,    0,    0,    0,    0, 1383,    0,
 1383, 1383,    0, 1383, 1383, 1383,    0, 1383,    0,    0,
 1383,    0,    0, 1383,    0, 1383, 1383,    0,    0, 1383,
 1383, 1383,    0, 1383, 1383, 1383, 1383, 1383, 1383, 1383,
    0,    0,    0, 1383,    0, 1383, 1383, 1383,    0,    0,
    0, 1383,    0,    0,    0,    0,    0,    0,    0, 1383,
 1383, 1383, 1383, 1383, 1383,    0,    0,    0, 1383, 1383,
    0, 1383,    0, 1383,    0, 1383, 1383, 1383,    0, 1383,
    0, 1383, 1383, 1383,    0, 1383, 1383, 1383, 1383, 1383,
    0, 1383, 1383,    0,    0,    0,    0, 1383,    0, 1383,
 1383,    0,    0, 1383, 1383, 1383,    0,    0, 1383,    0,
 1383,    0,    0, 1383, 1383, 1383, 1383,    0, 1383,    0,
 1383,    0, 1383, 1383, 1383, 1383, 1383,    0,    0, 1383,
 1383, 1383,    0, 1383, 1383,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1383, 1383, 1383,    0, 1383, 1383,
 1383,    0, 1383,    0,    0,    0, 1383,    0, 1383, 1383,
 1383, 1383,    0, 1383,    0, 1383, 1383, 1383, 1383, 1383,
 1383, 1383, 1383,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1383, 1383,    0, 1383, 1383, 1383,    0,    0,
    0,    0, 1383, 1383, 1383, 1383, 1383,    0, 1383,    0,
    0, 1383, 1383,    0,    0,    0, 1383, 1383,    0,    0,
 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383,    0,
 1383,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383,
 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383,
 1383,    0, 1383, 1383, 1383, 1383, 1383, 1383,    0, 1383,
 1383, 1383, 1383,    0, 1383,    0, 1383, 1383, 1383, 1383,
 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383,
 1383, 1383, 1383, 1383,    0, 1383, 1383, 1383, 1383,    0,
 1383, 1383, 1383, 1383, 1383,    0, 1383, 1383, 1383, 1383,
 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383,
 1383, 1383, 1383, 1383, 1383, 1383,    0, 1383, 1383, 1383,
 1383, 1383, 1383, 1383, 1383, 1385, 1383, 1383, 1383, 1383,
    0, 1383, 1383, 1383, 1383, 1383, 1383,    0,    0, 1383,
 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383,    0,    0,
    0,    0,    0, 1383,    0, 1383, 1383, 1383, 1383, 1383,
 1383,    0, 1383,    0,    0,    0, 1385,    0,    0, 1385,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1385, 1385, 1385, 1385,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1385,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1385,    0, 1385,    0,    0, 1385,    0, 1385,
 1385,    0,    0, 1385, 1385,    0, 1385,    0,    0,    0,
    0,    0,    0,    0, 1385, 1385,    0, 1385,    0, 1385,
    0,    0, 1385,    0,    0, 1385,    0,    0,    0,    0,
    0,    0, 1385,    0, 1385, 1385,    0, 1385, 1385, 1385,
    0, 1385,    0,    0, 1385,    0,    0, 1385,    0, 1385,
 1385,    0,    0, 1385, 1385, 1385,    0, 1385, 1385, 1385,
 1385, 1385, 1385, 1385,    0,    0,    0, 1385,    0, 1385,
 1385, 1385,    0,    0,    0, 1385,    0,    0,    0,    0,
    0,    0,    0, 1385, 1385, 1385, 1385, 1385, 1385,    0,
    0,    0, 1385, 1385,    0, 1385,    0, 1385,    0, 1385,
 1385, 1385,    0, 1385,    0, 1385, 1385, 1385,    0, 1385,
 1385, 1385, 1385, 1385,    0, 1385, 1385,    0,    0,    0,
    0, 1385,    0, 1385, 1385,    0,    0, 1385, 1385, 1385,
    0,    0, 1385,    0, 1385,    0,    0, 1385, 1385, 1385,
 1385,    0, 1385,    0, 1385,    0, 1385, 1385, 1385, 1385,
 1385,    0,    0, 1385, 1385, 1385,    0, 1385, 1385,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1385, 1385,
 1385,    0, 1385, 1385, 1385,    0, 1385,    0,    0,    0,
 1385,    0, 1385, 1385, 1385, 1385,    0, 1385,    0, 1385,
 1385, 1385, 1385, 1385, 1385, 1385, 1385,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1385, 1385,    0, 1385,
 1385, 1385,    0,    0,    0,    0, 1385, 1385, 1385, 1385,
 1385,    0, 1385,    0,    0, 1385, 1385,    0,    0,    0,
 1385, 1385,    0,    0, 1385, 1385, 1385, 1385, 1385, 1385,
 1385, 1385, 1385,    0, 1385,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1385, 1385, 1385, 1385, 1385, 1385,
 1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385,
 1385, 1385, 1385, 1385, 1385,    0, 1385, 1385, 1385, 1385,
 1385, 1385,    0, 1385, 1385, 1385, 1385,    0, 1385,    0,
 1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385,
 1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385,    0, 1385,
 1385, 1385, 1385,    0, 1385, 1385, 1385, 1385, 1385,    0,
 1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385,
 1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385,
    0, 1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385, 1387,
 1385, 1385, 1385, 1385,    0, 1385, 1385, 1385, 1385, 1385,
 1385,    0,    0, 1385, 1385, 1385, 1385, 1385, 1385, 1385,
 1385, 1385,    0,    0,    0,    0,    0, 1385,    0, 1385,
 1385, 1385, 1385, 1385, 1385,    0, 1385,    0,    0,    0,
 1387,    0,    0, 1387,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1387, 1387,
 1387, 1387,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1387,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1387,    0, 1387,    0,
    0, 1387,    0, 1387, 1387,    0,    0, 1387, 1387,    0,
 1387,    0,    0,    0,    0,    0,    0,    0, 1387, 1387,
    0, 1387,    0, 1387,    0,    0, 1387,    0,    0, 1387,
    0,    0,    0,    0,    0,    0, 1387,    0, 1387, 1387,
    0, 1387, 1387, 1387,    0, 1387,    0,    0, 1387,    0,
    0, 1387,    0, 1387, 1387,    0,    0, 1387, 1387, 1387,
    0, 1387, 1387, 1387, 1387, 1387, 1387, 1387,    0,    0,
    0, 1387,    0, 1387, 1387, 1387,    0,    0,    0, 1387,
    0,    0,    0,    0,    0,    0,    0, 1387, 1387, 1387,
 1387, 1387, 1387,    0,    0,    0, 1387, 1387,    0, 1387,
    0, 1387,    0, 1387, 1387, 1387,    0, 1387,    0, 1387,
 1387, 1387,    0, 1387, 1387, 1387, 1387, 1387,    0, 1387,
 1387,    0,    0,    0,    0, 1387,    0, 1387, 1387,    0,
    0, 1387, 1387, 1387,    0,    0, 1387,    0, 1387,    0,
    0, 1387, 1387, 1387, 1387,    0, 1387,    0, 1387,    0,
 1387, 1387, 1387, 1387, 1387,    0,    0, 1387, 1387, 1387,
 1342, 1387, 1387,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1387, 1387, 1387,    0, 1387, 1387, 1387,    0,
 1387,    0,    0,    0, 1387,    0, 1387, 1387, 1387, 1387,
    0, 1387,    0, 1387, 1387, 1387, 1387, 1387, 1387, 1387,
 1387, 1342,    0,    0, 1342,    0,    0,    0,    0,    0,
 1387, 1387,    0, 1387, 1387, 1387,    0,    0,    0, 1342,
 1387, 1387, 1387, 1387, 1387,    0, 1387,    0,    0, 1387,
 1387,    0,    0,    0, 1387, 1387,    0,    0, 1387, 1387,
 1387, 1387, 1387, 1387, 1387, 1387, 1387,    0, 1387,    0,
    0,    0,    0, 1342,    0,    0,    0,    0, 1387, 1387,
 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1387,
 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1387,    0,
 1387, 1387, 1387, 1387, 1387, 1387,    0, 1387, 1387, 1387,
 1387,    0, 1387,    0, 1387, 1387, 1387, 1387, 1387, 1387,
 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1387,
 1387, 1387,    0, 1387, 1387, 1387, 1387,    0, 1387, 1387,
 1387, 1387, 1387,    0, 1387, 1387, 1387, 1387, 1387, 1387,
 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1387,
 1387, 1387, 1387, 1387,    0, 1387, 1387, 1387, 1387, 1387,
 1387, 1387, 1387,    0, 1387, 1387, 1387, 1387,    0, 1387,
 1387, 1387, 1387, 1387, 1387,    0,    0, 1387, 1387, 1387,
 1387, 1387, 1387, 1387, 1387, 1387,    0,    0,    0,    0,
    0, 1387,    0, 1387, 1387, 1387, 1387, 1387, 1387,    0,
 1387,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1342,    0, 1342,
    0,    0, 1342,    0, 1342, 1342,    0,    0, 1342, 1342,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1342,
 1342,    0, 1342,    0,    0,    0,    0, 1342,    0,    0,
 1342,    0,    0,    0,    0,    0,    0, 1342,    0, 1342,
 1342,    0, 1342, 1342, 1342, 1342, 1342,    0,    0, 1342,
    0,    0, 1342,    0, 1342, 1342,    0,    0,    0, 1342,
 1342,    0, 1342, 1342, 1342,    0, 1342, 1342, 1342,    0,
    0,    0, 1342,    0, 1342, 1342, 1342,    0,    0,    0,
 1342,    0,    0,    0,    0,    0,    0,    0, 1342, 1342,
    0, 1342,    0, 1342,    0,    0,    0, 1342, 1342,    0,
 1342,    0,    0,    0, 1342,    0,    0,    0, 1342,    0,
 1342, 1342, 1342,    0, 1342, 1342, 1342, 1342, 1342,    0,
 1342, 1342,    0,    0,    0,    0, 1342,    0, 1342, 1342,
    0,    0, 1342, 1342, 1342,    0,    0, 1342,    0, 1342,
    0,    0, 1342, 1342, 1342, 1342,    0, 1342,    0, 1342,
    0, 1342,    0, 1342, 1342, 1342,    0,    0, 1342, 1342,
 1342, 1341, 1342, 1342,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1342, 1342, 1342,    0, 1342, 1342, 1342,
    0, 1342,    0,    0,    0, 1342,    0, 1342, 1342, 1342,
 1342,    0, 1342,    0, 1342, 1342, 1342, 1342, 1342, 1342,
 1342, 1342, 1341,    0,    0, 1341,    0,    0,    0,    0,
    0, 1342, 1342,    0, 1342, 1342, 1342,    0,    0,    0,
 1341, 1342, 1342, 1342, 1342, 1342,    0, 1342,    0,    0,
 1342, 1342,    0,    0,    0, 1342, 1342,    0,    0, 1342,
 1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342,    0, 1342,
    0,    0,    0,    0, 1341,    0,    0,    0,    0, 1342,
 1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342,
 1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342,
    0, 1342, 1342, 1342, 1342, 1342, 1342,    0, 1342, 1342,
 1342, 1342,    0, 1342,    0, 1342, 1342, 1342, 1342, 1342,
 1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342,
 1342, 1342, 1342,    0, 1342, 1342, 1342, 1342,    0, 1342,
 1342, 1342, 1342, 1342,    0, 1342, 1342, 1342, 1342, 1342,
 1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342,    0, 1342,
 1342, 1342, 1342, 1342, 1342,    0, 1342, 1342, 1342, 1342,
 1342, 1342, 1342, 1342,    0, 1342, 1342, 1342, 1342,    0,
 1342, 1342, 1342, 1342, 1342, 1342,    0,    0, 1342, 1342,
 1342, 1342, 1342, 1342, 1342, 1342, 1342,    0,    0,    0,
    0,    0, 1342,    0, 1342, 1342, 1342, 1342, 1342, 1342,
    0, 1342,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1341,    0,
 1341,    0,    0, 1341,    0, 1341, 1341,    0,    0, 1341,
 1341,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1341, 1341,    0, 1341,    0,    0,    0,    0, 1341,    0,
    0, 1341,    0,    0,    0,    0,    0,    0, 1341,    0,
 1341, 1341,    0, 1341, 1341, 1341, 1341, 1341,    0,    0,
 1341,    0,    0, 1341,    0, 1341, 1341,    0,    0,    0,
 1341, 1341,    0, 1341, 1341, 1341,    0, 1341, 1341, 1341,
    0,    0,    0, 1341,    0, 1341, 1341, 1341,    0,    0,
    0, 1341,    0,    0,    0,    0,    0,    0,    0, 1341,
 1341,    0, 1341,    0, 1341,    0,    0,    0, 1341, 1341,
    0, 1341,    0,    0,    0,    0,    0,    0,    0, 1341,
    0, 1341, 1341, 1341,    0, 1341, 1341, 1341, 1341, 1341,
    0, 1341, 1341,    0,    0,    0,    0, 1341,    0, 1341,
 1341,    0,    0, 1341, 1341, 1341,    0,    0, 1341,    0,
 1341,    0,    0, 1341, 1341, 1341, 1341,    0, 1341,    0,
 1341,    0, 1341,    0, 1341, 1341, 1341,    0,    0, 1341,
 1341, 1341, 1340, 1341, 1341,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1341, 1341, 1341,    0, 1341, 1341,
 1341,    0, 1341,    0,    0,    0, 1341,    0, 1341, 1341,
 1341, 1341,    0, 1341,    0, 1341, 1341, 1341, 1341, 1341,
 1341, 1341, 1341, 1340,    0,    0, 1340,    0,    0,    0,
    0,    0, 1341, 1341,    0, 1341, 1341, 1341,    0,    0,
    0, 1340, 1341, 1341, 1341, 1341, 1341,    0, 1341,    0,
    0, 1341, 1341,    0,    0,    0, 1341, 1341,    0,    0,
 1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,    0,
 1341,    0,    0,    0,    0, 1340,    0,    0,    0,    0,
 1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,
 1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,
 1341,    0, 1341, 1341, 1341, 1341, 1341, 1341,    0, 1341,
 1341, 1341, 1341,    0, 1341,    0, 1341, 1341, 1341, 1341,
 1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,
 1341, 1341, 1341, 1341,    0, 1341, 1341, 1341, 1341,    0,
 1341, 1341, 1341, 1341, 1341,    0, 1341, 1341, 1341, 1341,
 1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,    0,
 1341, 1341, 1341, 1341, 1341, 1341,    0, 1341, 1341, 1341,
 1341, 1341, 1341, 1341, 1341,    0, 1341, 1341, 1341, 1341,
    0, 1341, 1341, 1341, 1341, 1341, 1341,    0,    0, 1341,
 1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,    0,    0,
    0,    0,    0, 1341,    0, 1341, 1341, 1341, 1341, 1341,
 1341,    0, 1341,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1340,
    0, 1340,    0,    0,    0,    0, 1340, 1340,    0,    0,
 1340, 1340,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1340, 1340,    0, 1340,    0,    0,    0,    0, 1340,
    0,    0, 1340,    0,    0,    0,    0,    0,    0, 1340,
    0, 1340, 1340,    0, 1340, 1340, 1340, 1340, 1340,    0,
    0, 1340,    0,    0, 1340,    0, 1340, 1340,    0,    0,
    0, 1340, 1340,    0, 1340, 1340, 1340,    0, 1340, 1340,
 1340,    0,    0,    0, 1340,    0, 1340, 1340, 1340,    0,
    0,    0, 1340,    0,    0,    0,    0,    0,    0,    0,
 1340, 1340,    0, 1340,    0, 1340,    0,    0,    0, 1340,
 1340,    0, 1340,    0,    0,    0,    0,    0,    0,    0,
 1340,    0, 1340, 1340, 1340,    0, 1340, 1340, 1340, 1340,
 1340,    0, 1340, 1340,    0,    0,    0,    0, 1340,    0,
 1340, 1340,    0,    0, 1340, 1340, 1340,    0,    0, 1340,
    0, 1340,    0,    0, 1340, 1340, 1340, 1340,    0, 1340,
    0, 1340,    0, 1340,    0, 1340, 1340, 1340,    0,    0,
 1340, 1340, 1340, 1194, 1340, 1340,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1340, 1340, 1340,    0, 1340,
 1340, 1340,    0, 1340,    0,    0,    0, 1340,    0, 1340,
 1340, 1340, 1340,    0, 1340,    0, 1340, 1340, 1340, 1340,
 1340, 1340, 1340, 1340, 1194,    0,    0, 1194,    0,    0,
    0,    0,    0, 1340, 1340,    0, 1340, 1340, 1340,    0,
    0,    0, 1194, 1340, 1340, 1340, 1340, 1340,    0, 1340,
    0,    0, 1340, 1340,    0,    0,    0, 1340, 1340,    0,
    0, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340,
    0, 1340,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340,
 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340,
 1340, 1340,    0, 1340, 1340, 1340, 1340, 1340, 1340,    0,
 1340, 1340, 1340, 1340,    0, 1340,    0, 1340, 1340, 1340,
 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340,
 1340, 1340, 1340, 1340, 1340,    0, 1340, 1340, 1340, 1340,
    0, 1340, 1340, 1340, 1340, 1340,    0, 1340, 1340, 1340,
 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340,
    0, 1340, 1340, 1340, 1340, 1340, 1340,    0, 1340, 1340,
 1340, 1340, 1340, 1340, 1340, 1340,    0, 1340, 1340, 1340,
 1340,    0, 1340, 1340, 1340, 1340, 1340, 1340,    0,    0,
 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340,    0,
    0,    0,    0,    0, 1340,    0, 1340, 1340, 1340, 1340,
 1340, 1340,    0, 1340,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1194,    0, 1194,    0,    0,    0,    0, 1194, 1194,    0,
    0, 1194, 1194,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1194, 1194,    0, 1194,    0, 1194,    0,    0,
 1194,    0,    0, 1194,    0,    0,    0,    0,    0,    0,
 1194,    0, 1194, 1194,    0,    0,    0, 1194,    0, 1194,
    0,    0, 1194,    0,    0, 1194,    0,    0, 1194,    0,
    0,    0, 1194, 1194,    0, 1194, 1194, 1194,    0, 1194,
 1194, 1194,    0,    0,    0, 1194,    0, 1194, 1194, 1194,
    0,    0,    0, 1194,    0,    0,    0,    0,    0,    0,
    0, 1194, 1194,    0, 1194,    0, 1194,    0,    0,    0,
 1194, 1194,    0, 1194,    0,    0,    0,    0,    0,    0,
    0, 1194,    0, 1194,    0, 1194,    0, 1194, 1194, 1194,
 1194, 1194,    0, 1194, 1194,    0,    0,    0,    0, 1194,
    0, 1194, 1194,    0,    0, 1194, 1194,    0,    0,    0,
 1194,    0, 1194,    0,    0, 1194, 1194, 1194, 1194,    0,
 1194,    0, 1194,    0, 1194, 1194, 1194, 1194, 1194,    0,
    0, 1164,    0, 1194,    0, 1194, 1194,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1194,    0, 1194,    0,
 1194, 1194, 1194,    0, 1194,    0,    0,    0, 1194,    0,
 1194, 1194, 1194, 1194,    0, 1194,    0,    0,    0,    0,
    0, 1164, 1164, 1194, 1194, 1164,    0,    0,    0,    0,
    0,    0,    0,    0, 1194, 1194,    0, 1194, 1194, 1194,
 1164,    0,    0,    0, 1194, 1194, 1194, 1194, 1194,    0,
 1194,    0,    0, 1194, 1194,    0,    0,    0, 1194, 1194,
    0,    0, 1194, 1194, 1194, 1194, 1194, 1194, 1194, 1194,
 1194,    0, 1194,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1194, 1194, 1194, 1194, 1194, 1194, 1194, 1194,
 1194, 1194, 1194, 1194, 1194, 1194, 1194, 1194, 1194, 1194,
 1194, 1194, 1194,    0, 1194, 1194, 1194, 1194, 1194, 1194,
    0, 1194, 1194, 1194, 1194,    0, 1194,    0, 1194, 1194,
 1194, 1194, 1194, 1194, 1194, 1194, 1194, 1194, 1194, 1194,
 1194, 1194, 1194, 1194, 1194, 1194,    0, 1194, 1194, 1194,
 1194,    0, 1194, 1194, 1194, 1194, 1194,    0, 1194, 1194,
 1194, 1194, 1194, 1194, 1194, 1194, 1194, 1194, 1194, 1194,
 1194,    0, 1194, 1194, 1194, 1194, 1194, 1194,    0, 1194,
 1194, 1194, 1194, 1194, 1194, 1194, 1194,    0, 1194, 1194,
 1194, 1194,    0, 1194, 1194, 1194, 1194, 1194, 1194,    0,
    0, 1194, 1194, 1194, 1194, 1194, 1194, 1194, 1194, 1194,
    0,    0,    0,    0,    0, 1194,    0, 1194, 1194, 1194,
 1194, 1194, 1194,    0, 1194,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1164,    0,
 1164,    0,    0,    0,    0,    0, 1164,    0,    0, 1164,
 1164,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1164, 1164,    0, 1164,    0, 1164,    0,    0, 1164,    0,
    0, 1164,    0,    0,    0,    0,    0,    0, 1164,    0,
 1164, 1164,    0,    0,    0, 1164,    0, 1164,    0,    0,
 1164,    0,    0, 1164,    0,    0, 1164,    0,    0,    0,
 1164, 1164,    0, 1164, 1164, 1164,    0, 1164, 1164, 1164,
    0,    0,    0, 1164,    0, 1164, 1164, 1164,    0,    0,
    0, 1164,    0,    0,    0,    0,    0,    0,    0, 1164,
 1164,    0, 1164,    0, 1164,    0,    0,    0, 1164, 1164,
    0, 1164,    0,    0,    0,    0,    0,    0,    0, 1164,
    0, 1164,    0, 1164,    0, 1164, 1164, 1164, 1164, 1164,
    0, 1164, 1164,    0,    0,    0,    0, 1164,    0, 1164,
 1164,    0,    0, 1164, 1164,    0,    0,    0, 1164,    0,
 1164,    0,    0, 1164, 1164, 1164, 1164,    0, 1164,    0,
 1164, 1191, 1164, 1164, 1164, 1164, 1164,    0,    0,    0,
    0, 1164,    0, 1164, 1164,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1164,    0, 1164,    0, 1164, 1164,
 1164,    0, 1164,    0,    0,    0, 1164,    0, 1164, 1164,
 1164, 1164, 1191, 1164,    0, 1191,    0,    0,    0,    0,
    0, 1164, 1164,    0,    0,    0,    0,    0,    0,    0,
 1191,    0, 1164, 1164,    0, 1164, 1164, 1164,    0,    0,
    0,    0, 1164, 1164, 1164, 1164, 1164,    0, 1164,    0,
    0, 1164, 1164,    0,    0,    0, 1164, 1164,    0,    0,
 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,    0,
 1164,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,
 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,
 1164,    0, 1164, 1164, 1164, 1164, 1164, 1164,    0, 1164,
 1164, 1164, 1164,    0, 1164,    0, 1164, 1164, 1164, 1164,
 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,
 1164, 1164, 1164, 1164,    0, 1164, 1164, 1164, 1164,    0,
 1164, 1164, 1164, 1164, 1164,    0, 1164, 1164, 1164, 1164,
 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,    0,
 1164, 1164, 1164, 1164, 1164, 1164,    0, 1164, 1164, 1164,
 1164, 1164, 1164, 1164, 1164,    0, 1164, 1164, 1164, 1164,
    0, 1164, 1164, 1164, 1164, 1164, 1164,    0,    0, 1164,
 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,    0,    0,
    0,    0,    0, 1164,    0, 1164, 1164, 1164, 1164, 1164,
 1164,    0, 1164,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1164,    0,
 1164,    0,    0,    0,    0,    0, 1164,    0,    0, 1164,
 1164,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1164, 1164,    0, 1164,    0, 1164,    0,    0, 1164,    0,
    0, 1164,    0,    0,    0,    0,    0,    0, 1164,    0,
 1164, 1164,    0,    0,    0, 1164,    0, 1164,    0,    0,
 1164,    0,    0, 1191,    0,    0, 1191,    0,    0,    0,
 1164, 1164,    0, 1191, 1191, 1164,    0, 1164, 1191, 1164,
    0,    0,    0, 1191,    0, 1164, 1191, 1164,    0,    0,
    0, 1164,    0,    0,    0,    0,    0,    0,    0, 1164,
 1191,    0, 1164,    0, 1164,    0,    0,    0, 1164, 1164,
    0, 1191,    0,    0,    0,    0,    0,    0,    0, 1191,
    0, 1164,    0, 1191,    0, 1164, 1164, 1164, 1164, 1164,
    0, 1164, 1191,    0,    0,    0,    0, 1164,    0, 1164,
 1164,    0,    0, 1164, 1164,    0,    0,    0, 1191,    0,
 1164,    0,    0, 1164, 1164, 1164, 1164,    0, 1164,    0,
 1164, 1193, 1164, 1164, 1164, 1164, 1164,    0,    0,    0,
    0, 1164,    0, 1164, 1191,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1164,    0, 1191,    0, 1191, 1164,
 1164,    0, 1164,    0,    0,    0, 1164,    0, 1164, 1164,
 1164, 1164, 1193, 1164,    0, 1193,    0,    0,    0,    0,
    0, 1164, 1164,    0,    0,    0,    0,    0,    0,    0,
 1193,    0, 1164, 1164,    0, 1164, 1164, 1164,    0,    0,
    0,    0, 1164, 1164, 1191, 1164, 1164,    0, 1164,    0,
    0, 1164, 1164,    0,    0,    0, 1164, 1164,    0,    0,
 1191, 1191, 1164, 1164, 1164, 1191, 1164, 1164, 1164,    0,
 1164,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,
 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,
 1164,    0, 1164, 1164, 1164, 1164, 1164, 1164,    0, 1164,
 1164, 1164, 1164,    0, 1164,    0, 1164, 1164, 1164, 1164,
 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,
 1164, 1164, 1164, 1164,    0, 1164, 1164, 1164, 1164,    0,
 1164, 1164, 1164, 1164, 1164,    0, 1164, 1164, 1164, 1164,
 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,    0,
 1164, 1164, 1164, 1164, 1164, 1164,    0, 1164, 1164, 1164,
 1164, 1164, 1164, 1164, 1164,    0, 1164, 1164, 1164, 1164,
    0, 1164, 1164, 1164, 1164, 1164, 1164,    0,    0, 1164,
 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,    0,    0,
    0,    0,    0, 1164,    0, 1164, 1164, 1164, 1164, 1164,
 1164,    0, 1191,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1164,    0,
 1164,    0,    0,    0,    0,    0, 1164,    0,    0, 1164,
 1164,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1164, 1164,    0, 1164,    0, 1164,    0,    0, 1164,    0,
    0, 1164,    0,    0,    0,    0,    0,    0, 1164,    0,
 1164, 1164,    0,    0,    0, 1164,    0, 1164,    0,    0,
 1164,    0,    0, 1193,    0,    0, 1193,    0,    0,    0,
 1164, 1164,    0, 1193, 1193, 1164,    0, 1164, 1193, 1164,
    0,    0,    0, 1193,    0, 1164, 1193, 1164,    0,    0,
    0, 1164,    0,    0,    0,    0,    0,    0,    0, 1164,
 1193,    0, 1164,    0, 1164,    0,    0,    0, 1164, 1164,
    0, 1193,    0,    0,    0,    0,    0,    0,    0, 1193,
    0, 1164,    0, 1193,    0, 1164, 1164, 1164, 1164, 1164,
    0, 1164, 1193,    0,    0,    0,    0, 1164,    0, 1164,
 1164,    0,    0, 1164, 1164,    0, 1198,    0, 1193,    0,
 1164,    0,    0, 1164, 1164, 1164, 1164,    0, 1164,    0,
 1164,    0, 1164, 1164, 1164, 1164, 1164,    0,    0,    0,
    0, 1164,    0, 1164, 1193,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1164,    0, 1193,    0, 1193, 1164,
 1164,    0, 1164,    0,    0,    0, 1164,    0, 1164, 1164,
 1164, 1164,    0, 1164,    0, 1198,    0,    0,    0,    0,
    0, 1164, 1164,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1164, 1164,    0, 1164, 1164, 1164,    0,    0,
    0,    0, 1164, 1164, 1193, 1164, 1164,    0, 1164,    0,
    0, 1164, 1164,    0,    0,    0, 1164, 1164,    0,    0,
 1193, 1193, 1164, 1164, 1164, 1193, 1164, 1164, 1164,    0,
 1164,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,
 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,
 1164,    0, 1164, 1164, 1164, 1164, 1164, 1164,    0, 1164,
 1164, 1164, 1164,    0, 1164,    0, 1164, 1164, 1164, 1164,
 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,
 1164, 1164, 1164, 1164,    0, 1164, 1164, 1164, 1164,    0,
 1164, 1164, 1164, 1164, 1164,    0, 1164, 1164, 1164, 1164,
 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,    0,
 1164, 1164, 1164, 1164, 1164, 1164,    0, 1164, 1164, 1164,
 1164, 1164, 1164, 1164, 1164,    0, 1164, 1164, 1164, 1164,
    0, 1164, 1164, 1164, 1164, 1164, 1164,    0,    0, 1164,
 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,    0,    0,
    0,    0,    0, 1164,    0, 1164, 1164, 1164, 1164, 1164,
 1164,    0, 1193, 1164,    0, 1164,    0,    0,    0,    0,
    0, 1164,    0,    0, 1164, 1164,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1164, 1164,    0, 1164,    0,
 1164,    0,    0, 1164,    0,    0, 1164,    0,    0,    0,
    0,    0,    0, 1164,    0, 1164, 1164,    0,    0,    0,
 1164,    0, 1164,    0,    0, 1164,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1164, 1164,    0,    0,    0,
 1164,    0, 1164,    0, 1164,    0,    0,    0,    0,    0,
 1164,    0, 1164,    0,    0,    0, 1164,    0,    0,    0,
    0,    0,    0,    0, 1164,    0,    0, 1164,    0, 1164,
    0,    0,    0, 1164, 1164,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1164,    0, 1198,    0,
 1164, 1164, 1164, 1164, 1164,    0, 1164, 1198,    0,    0,
    0,    0, 1164,    0, 1164, 1164,    0,    0, 1164, 1164,
    0,    0, 1162,    0,    0, 1164,    0, 1198, 1164, 1164,
 1164, 1164,    0, 1164,    0, 1164,    0, 1164, 1164, 1164,
 1164, 1164,    0,    0,    0,    0, 1164,    0, 1164,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1164,
    0, 1198,    0,    0, 1164, 1164, 1162, 1164,    0,    0,
    0, 1164,    0, 1164, 1164, 1164, 1164,    0, 1164,    0,
    0, 1162,    0,    0,    0,    0, 1164, 1164,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1164, 1164,    0,
 1164, 1164, 1164,    0,    0,    0,    0, 1164, 1164, 1198,
 1164, 1164,    0, 1164,    0,    0, 1164, 1164,    0,    0,
    0, 1164, 1164,    0,    0,    0, 1198, 1164, 1164, 1164,
    0, 1164, 1164, 1164,    0, 1164,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1164, 1164, 1164, 1164,
 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,
 1164, 1164, 1164, 1164, 1164, 1164,    0, 1164, 1164, 1164,
 1164, 1164, 1164,    0, 1164, 1164, 1164, 1164,    0, 1164,
    0, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,
 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,    0,
 1164, 1164, 1164, 1164,    0, 1164, 1164, 1164, 1164, 1164,
    0, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,
 1164, 1164, 1164, 1164,    0, 1164, 1164, 1164, 1164, 1164,
 1164,    0, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,
    0, 1164, 1164, 1164, 1164,    0, 1164, 1164, 1164, 1164,
 1164, 1164,    0,    0, 1164, 1164, 1164, 1164, 1164, 1164,
 1164, 1164, 1164,    0,    0,    0,    0,    0, 1164,    0,
 1164, 1164, 1164, 1164, 1164, 1164,    0,    0,    0, 1164,
    0, 1164,    0,    0,    0,    0,    0, 1164,    0,    0,
 1164, 1164,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1164, 1164,    0, 1164,    0,    0,    0,    0, 1164,
    0,    0, 1164,    0,    0,    0,    0,    0,    0, 1164,
    0, 1164, 1164,    0,    0,    0, 1164,    0, 1164,    0,
    0, 1164,    0,    0,    0,    0, 1162,    0,    0,    0,
    0, 1164, 1164,    0,    0,    0, 1164,    0, 1164,    0,
 1164,    0,    0,    0, 1162,    0, 1164,    0, 1164,    0,
    0,    0, 1164,    0,    0,    0,    0,    0,    0,    0,
 1164,    0,    0, 1164,    0, 1164,    0,    0,    0, 1164,
 1164,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1164,    0,    0,    0, 1164, 1164, 1164, 1164,
 1164,    0, 1164,    0,    0,    0,    0,    0, 1164,    0,
 1164, 1164,    0,    0, 1164, 1164,    0,    0,    0,    0,
    0, 1164,    0,    0, 1164, 1164, 1164, 1164,    0, 1164,
    0, 1164,    0, 1164,    0, 1164, 1164, 1164,    0,    0,
    0,    0, 1164,    0, 1164,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1164,    0,    0,    0,    0,
 1164, 1164,    0, 1164,    0,    0,    0, 1164,    0, 1164,
 1164, 1164, 1164,    0, 1164,    0,    0,    0,    0,    0,
    0,    0, 1164, 1164,    0,    0,    0, 1142,    0,    0,
  879,    0,  880, 1164, 1164,    0, 1164, 1164, 1164,    0,
    0,    0,    0, 1164, 1164,  882, 1164, 1164,    0, 1164,
  883,    0, 1164, 1164,    0,    0,    0, 1164, 1164,    0,
    0,    0,    0, 1164, 1164, 1164,    0, 1164, 1164, 1164,
    0, 1164,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,
 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,
 1164, 1164,    0, 1164, 1164, 1164, 1164, 1164, 1164,    0,
 1164, 1164, 1164, 1164,    0, 1164,    0, 1164, 1164, 1164,
 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,
 1164, 1164, 1164, 1164, 1164,    0, 1164, 1164, 1164, 1164,
    0, 1164, 1164, 1164, 1164, 1164,    0, 1164, 1164, 1164,
 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,
    0, 1164, 1164, 1164, 1164, 1164, 1164,    0, 1164, 1164,
 1164, 1164, 1164, 1164, 1164, 1164,    0, 1164, 1164, 1164,
 1164,    0, 1164, 1164, 1164, 1164, 1164, 1164,    0,    0,
 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164, 1164,    0,
    0,    0,    0,    0, 1164,    0, 1164, 1164, 1164, 1164,
 1164, 1164,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,  742,  141,  142,    0,    0,    0,
    0,  743,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,  744,    0,  147,    0,    0,  148,  745,  746,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,  747,  154,    0,    0,    0,
    0,    0,    0,    0,  748,    0,  155,  749,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,  750,    0,  751,  752,  163,  753,    0,  164,    0,
  165,  754,    0,  755,  166,  167,    0,    0,    0,    0,
    0,  756,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,  757,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,  758,    0,  181,    0,    0,  182,
  183,  759,  185,    0,  186,    0,  187,  760,  188,  189,
  190,  191,  192,  761,    0,    0,    0,  193,    0,  194,
    0,    0,    0,  762,    0,    0,    0,    0,    0,    0,
  195,    0,    0,    0,    0,  196,  197,  763,  764,  765,
  508,  509,  199,    0,  200,  201,  202,  203,    0,  204,
  766, 1498, 1499, 1500, 1501, 1502, 1503, 1531, 1532,  767,
  768,  769,  770,  771,  772,  773,  774,  775,  207,  776,
    0,  209,  210,  211,  777,  778,    0,  779,  780,  781,
    0,  214,  215,  782,  216,    0,    0,  217,  218,  783,
  784,  785,  219,  220,    0,    0,    0,    0,  221,  786,
  223,    0,  787,  225,  226,    0,  227,    0,  788,  789,
  790,    0,  791,  792,    0,  793,  228,  229,  230,  231,
  232,  233,  794,  235,  795,  237,  796,  797,  798,  799,
  800,  801,  802,  803,  804,  805,  806,    0,  807,  808,
  809,  810,  811,  812,    0,  813,  814,  815,  258,    0,
  816,    0,  817,  818,  819,  820,  821,  265,  266,  822,
 1533,  823,  824,  825,  272,  826,  274,  827,  276,  828,
    0,  829,  830,  831,  832,    0,  833,  834,  835,  285,
  836,    0,  837,  838,  289,  839, 1534,  292,  840,  294,
  295,  296,  297,  298,  299,    0,  841,  301,  302,  303,
  304,  305,    0,  842,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  843,  844,    0,  318,  319,  320,
  845,  846,  847,    0,    0,  324,  848,  849,  850,  851,
  852,  853,  854,  855,  856,    0,  857,  858,  859,  333,
  860,  334,  335,  336,  337,  338,  339,    0,    0,  861,
  862,  863,  864,  865,  866,  867,  868,  869,  870,  871,
  872,  873,  874,  875,  876,  877,  878, 1142,    0,    0,
  879,    0,  880,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  882,    0,    0,    0,    0,
  883,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,  742,  141,  142,    0,    0,    0,
    0,  743,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,  744,    0,  147,    0,    0,  148,  745,  746,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,  747,  154,    0,    0,    0,
    0,    0,    0,    0,  748,    0,  155,  749,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,  750,    0,  751,  752,  163,  753,    0,  164,    0,
  165,  754,    0,  755,  166,  167,    0,    0,    0,    0,
    0,  756,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,  757,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,  758,    0,  181,    0,    0,  182,
  183,  759,  185,    0,  186,    0,  187,  760,  188,  189,
  190,  191,  192,  761,    0,    0,    0,  193,    0,  194,
    0,    0,    0,  762,    0,    0,    0,    0,    0,    0,
  195,    0,    0,    0,    0,  196,  197,  763,  764,  765,
  508,  509,  199,    0,  200,  201,  202,  203,    0,  204,
  766,    0,    0,    0,    0,    0,    0,  205,  206,  767,
  768,  769,  770,  771,  772,  773,  774,  775,  207,  776,
    0,  209,  210,  211,  777,  778,    0,  779,  780,  781,
    0,  214,  215,  782,  216,    0,    0,  217,  218,  783,
  784,  785,  219,  220,    0,    0,    0,    0,  221,  786,
  223,    0,  787,  225,  226, 1526,  227,    0,  788,  789,
  790, 1527,  791,  792, 1528,  793,  228,  229,  230,  231,
  232,  233,  794,  235,  795,  237,  796,  797,  798,  799,
  800,  801,  802,  803,  804,  805,  806,    0,  807,  808,
  809,  810,  811,  812,    0,  813,  814,  815,  258,    0,
  816,    0,  817,  818,  819,  820,  821,  265,  266,  822,
  268,  823,  824,  825,  272,  826,  274,  827,  276,  828,
    0,  829,  830,  831,  832,    0,  833,  834,  835,  285,
  836,    0,  837,  838,  289,  839,  291,  292,  840,  294,
  295,  296,  297,  298,  299,    0,  841,  301,  302,  303,
  304,  305,    0,  842,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  843,  844,    0,  318,  319,  320,
  845,  846,  847,    0,    0,  324,  848,  849,  850,  851,
  852,  853,  854,  855,  856,    0,  857,  858,  859,  333,
  860,  334,  335,  336,  337,  338,  339,    0,    0,  861,
  862,  863,  864,  865,  866,  867,  868,  869,  870,  871,
  872,  873,  874,  875,  876,  877,  878, 1142,    0,    0,
  879,    0,  880,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  882,    0,    0,    0,    0,
  883,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  138,    0,  139, 1599,    0,    0,
 1600,    0,  140,    0,  742,  141,  142,    0,    0,    0,
    0,  743,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,  744,    0,  147,    0,    0,  148,  745,  746,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,  747,  154,    0,    0,    0,
    0,    0,    0,    0,  748,    0,  155,  749,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,  750,    0,  751,  752,  163,  753,    0,  164,    0,
  165,  754,    0,  755,  166,  167,    0,    0,    0,    0,
    0,  756,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,  757,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,  758,    0,  181,    0,    0,  182,
  183,  759,  185,    0,  186, 1601,  187,  760,  188,  189,
  190,  191,  192,  761,    0,    0,    0,  193,    0,  194,
    0,    0,    0,  762,    0,    0,    0,    0,    0,    0,
  195,    0,    0,    0,    0,  196,  197,  763,  764,  765,
  508,  509,  199,    0,  200,  201,  202,  203,    0,  204,
  766,    0,    0,    0,    0,    0,    0,  205,  206,  767,
  768,  769,  770,  771,  772,  773,  774,  775,  207,  776,
    0,  209,  210,  211,  777,  778,    0,  779,  780,  781,
    0,  214,  215,  782,  216,    0,    0,  217,  218,  783,
  784,  785,  219,  220,    0,    0,    0,    0,  221,  786,
  223,    0,  787,  225,  226,    0,  227,    0,  788,  789,
  790,    0,  791,  792,    0,  793,  228,  229,  230,  231,
  232,  233,  794,  235,  795,  237,  796,  797,  798,  799,
  800,  801,  802,  803,  804,  805,  806,    0,  807,  808,
  809,  810,  811,  812,    0,  813,  814,  815,  258,    0,
  816,    0,  817,  818,  819,  820,  821,  265,  266,  822,
  268,  823,  824,  825,  272,  826,  274,  827,  276,  828,
    0,  829,  830,  831,  832,    0,  833,  834,  835,  285,
  836,    0,  837,  838,  289,  839,  291,  292,  840,  294,
  295,  296,  297,  298,  299,    0,  841,  301,  302,  303,
  304,  305,    0,  842,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  843,  844,    0,  318,  319,  320,
  845,  846,  847,    0,    0,  324,  848,  849,  850,  851,
  852,  853,  854,  855,  856,    0,  857,  858,  859,  333,
  860,  334,  335,  336,  337,  338,  339,    0,    0,  861,
  862,  863,  864,  865,  866,  867,  868,  869,  870,  871,
  872,  873,  874,  875,  876,  877,  878, 1146,    0, 1146,
 1146,    0, 1146,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1146,    0,    0,    0,    0,
 1146,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1146,    0, 1146, 1146,    0,    0,
    0,    0, 1146,    0, 1146, 1146, 1146,    0,    0,    0,
    0, 1146,    0,    0,    0,    0, 1146, 1146,    0, 1146,
    0, 1146, 1146,    0, 1146,    0,    0, 1146, 1146, 1146,
    0,    0,    0,    0, 1146, 1146, 1146, 1146,    0,    0,
    0, 1146,    0, 1146,    0, 1146, 1146,    0,    0,    0,
    0,    0,    0,    0, 1146,    0, 1146, 1146,    0,    0,
    0, 1146,    0, 1146,    0, 1146,    0,    0,    0,    0,
    0, 1146,    0, 1146,    0,    0,    0, 1146,    0,    0,
    0, 1146,    0, 1146, 1146, 1146, 1146,    0, 1146,    0,
 1146, 1146,    0, 1146, 1146, 1146,    0,    0,    0,    0,
    0, 1146,    0,    0,    0,    0,    0, 1146,    0,    0,
    0, 1146, 1146, 1146, 1146, 1146,    0, 1146,    0, 1146,
    0,    0,    0, 1146,    0, 1146, 1146,    0,    0, 1146,
 1146,    0,    0,    0, 1146,    0, 1146,    0,    0, 1146,
 1146, 1146, 1146,    0, 1146,    0, 1146, 1146, 1146, 1146,
 1146, 1146, 1146, 1146,    0,    0,    0, 1146,    0, 1146,
    0,    0,    0, 1146,    0,    0,    0,    0,    0,    0,
 1146,    0,    0,    0,    0, 1146, 1146, 1146, 1146, 1146,
 1146, 1146, 1146,    0, 1146, 1146, 1146, 1146,    0, 1146,
 1146,    0,    0,    0,    0,    0,    0, 1146, 1146, 1146,
 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
    0, 1146, 1146,    0, 1146, 1146,    0, 1146, 1146, 1146,
    0, 1146, 1146, 1146, 1146,    0,    0, 1146, 1146, 1146,
 1146, 1146, 1146, 1146,    0,    0,    0,    0, 1146, 1146,
 1146,    0, 1146, 1146, 1146,    0, 1146,    0, 1146, 1146,
 1146,    0, 1146, 1146,    0, 1146, 1146, 1146, 1146, 1146,
 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
 1146, 1146, 1146, 1146, 1146, 1146, 1146,    0, 1146, 1146,
 1146, 1146, 1146, 1146,    0, 1146, 1146, 1146, 1146,    0,
 1146,    0, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
    0, 1146, 1146, 1146, 1146,    0, 1146, 1146, 1146, 1146,
 1146,    0, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
 1146, 1146, 1146, 1146, 1146,    0, 1146, 1146, 1146, 1146,
 1146, 1146,    0, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
 1146,    0, 1146, 1146, 1146, 1146,    0, 1146, 1146, 1146,
 1146, 1146, 1146,    0,    0, 1146, 1146, 1146, 1146, 1146,
 1146, 1146, 1146, 1146, 1146,    0, 1146, 1146, 1146, 1146,
 1146, 1146, 1146, 1146, 1146, 1146, 1146,    0,    0, 1146,
 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1142,    0,    0,
  879,    0,  880,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  882,    0,    0,    0,    0,
  883,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,  742,  141,  142,    0,    0,    0,
    0,  743,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,  744,    0,  147, 1141,    0,  148,  745,  746,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,  747,  154,    0,    0,    0,
    0,    0,    0,    0,  748,    0,  155,  749,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,  750,    0,  751,  752,  163,  753,    0,  164,    0,
  165,  754,    0,  755,  166,  167,    0,    0,    0,    0,
    0,  756,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,  757,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,  758,    0,  181,    0,    0,  182,
  183,  759,  185,    0,  186,    0,  187,  760,  188,  189,
  190,  191,  192,  761,    0,    0,    0,  193,    0,  194,
    0,    0,    0,  762,    0,    0,    0,    0,    0,    0,
  195,    0,    0,    0,    0,  196,  197,  763,  764,  765,
  508,  509,  199,    0,  200,  201,  202,  203,    0,  204,
  766,    0,    0,    0,    0,    0,    0,  205,  206,  767,
  768,  769,  770,  771,  772,  773,  774,  775,  207,  776,
    0,  209,  210,  211,  777,  778,    0,  779,  780,  781,
    0,  214,  215,  782,  216,    0,    0,  217,  218,  783,
  784,  785,  219,  220,    0,    0,    0,    0,  221,  786,
  223,    0,  787,  225,  226,    0,  227,    0,  788,  789,
  790,    0,  791,  792,    0,  793,  228,  229,  230,  231,
  232,  233,  794,  235,  795,  237,  796,  797,  798,  799,
  800,  801,  802,  803,  804,  805,  806,    0,  807,  808,
  809,  810,  811,  812,    0,  813,  814,  815,  258,    0,
  816,    0,  817,  818,  819,  820,  821,  265,  266,  822,
  268,  823,  824,  825,  272,  826,  274,  827,  276,  828,
    0,  829,  830,  831,  832,    0,  833,  834,  835,  285,
  836,    0,  837,  838,  289,  839,  291,  292,  840,  294,
  295,  296,  297,  298,  299,    0,  841,  301,  302,  303,
  304,  305,    0,  842,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  843,  844,    0,  318,  319,  320,
  845,  846,  847,    0,    0,  324,  848,  849,  850,  851,
  852,  853,  854,  855,  856,    0,  857,  858,  859,  333,
  860,  334,  335,  336,  337,  338,  339,    0,    0,  861,
  862,  863,  864,  865,  866,  867,  868,  869,  870,  871,
  872,  873,  874,  875,  876,  877,  878, 1142,    0,    0,
  879,    0,  880,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  882,    0,    0,    0,    0,
  883,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,  742,  141,  142,    0,    0,    0,
    0,  743,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,  744,    0,  147,    0,    0,  148,  745,  746,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,  747,  154,    0,    0,    0,
    0,    0,    0,    0,  748,    0,  155,  749,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,  750,    0,  751,  752,  163,  753,    0,  164,    0,
  165,  754,    0,  755,  166,  167,    0,    0,    0,    0,
    0,  756,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,  757,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,  758,    0,  181,    0,    0,  182,
  183,  759,  185,    0,  186,    0,  187,  760,  188,  189,
  190,  191,  192,  761,    0,    0,    0,  193,    0,  194,
    0,    0,    0,  762,    0,    0,    0,    0,    0,    0,
  195, 1173,    0,    0,    0,  196,  197,  763,  764,  765,
  508,  509,  199,    0,  200,  201,  202,  203,    0,  204,
  766,    0,    0,    0,    0,    0,    0,  205,  206,  767,
  768,  769,  770,  771,  772,  773,  774,  775,  207,  776,
    0,  209,  210,  211,  777,  778,    0,  779,  780,  781,
    0,  214,  215,  782,  216,    0,    0,  217,  218,  783,
  784,  785,  219,  220,    0,    0,    0,    0,  221,  786,
  223,    0,  787,  225,  226,    0,  227,    0,  788,  789,
  790,    0,  791,  792,    0,  793,  228,  229,  230,  231,
  232,  233,  794,  235,  795,  237,  796,  797,  798,  799,
  800,  801,  802,  803,  804,  805,  806,    0,  807,  808,
  809,  810,  811,  812,    0,  813,  814,  815,  258,    0,
  816,    0,  817,  818,  819,  820,  821,  265,  266,  822,
  268,  823,  824,  825,  272,  826,  274,  827,  276,  828,
    0,  829,  830,  831,  832,    0,  833,  834,  835,  285,
  836,    0,  837,  838,  289,  839,  291,  292,  840,  294,
  295,  296,  297,  298,  299,    0,  841,  301,  302,  303,
  304,  305,    0,  842,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  843,  844,    0,  318,  319,  320,
  845,  846,  847,    0,    0,  324,  848,  849,  850,  851,
  852,  853,  854,  855,  856,    0,  857,  858,  859,  333,
  860,  334,  335,  336,  337,  338,  339,    0,    0,  861,
  862,  863,  864,  865,  866,  867,  868,  869,  870,  871,
  872,  873,  874,  875,  876,  877,  878, 1142,    0,    0,
  879,    0,  880,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  882,    0,    0,    0,    0,
  883,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,  742,  141,  142,    0,    0,    0,
    0,  743,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,  744,    0,  147,    0,    0,  148,  745,  746,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,  747,  154,    0,    0,    0,
    0,    0,    0,    0,  748,    0,  155,  749,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,  750,    0,  751,  752,  163,  753,    0,  164,    0,
  165,  754,    0,  755,  166,  167,    0,    0,    0,    0,
    0,  756,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,  757,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,  758,    0,  181,    0,    0,  182,
  183,  759,  185,    0,  186,    0,  187,  760,  188,  189,
  190,  191,  192,  761,    0,    0,    0,  193,    0,  194,
    0,    0,    0,  762,    0,    0,    0,    0,    0,    0,
  195,    0,    0,    0,   15,  196,  197,  763,  764,  765,
  508,  509,  199,    0,  200,  201,  202,  203,    0,  204,
  766,    0,    0,    0,    0,    0,    0,  205,  206,  767,
  768,  769,  770,  771,  772,  773,  774,  775,  207,  776,
    0,  209,  210,  211,  777,  778,    0,  779,  780,  781,
    0,  214,  215,  782,  216,    0,    0,  217,  218,  783,
  784,  785,  219,  220,    0,    0,    0,    0,  221,  786,
  223,    0,  787,  225,  226,    0,  227,    0,  788,  789,
  790,    0,  791,  792,    0,  793,  228,  229,  230,  231,
  232,  233,  794,  235,  795,  237,  796,  797,  798,  799,
  800,  801,  802,  803,  804,  805,  806,    0,  807,  808,
  809,  810,  811,  812,    0,  813,  814,  815,  258,    0,
  816,    0,  817,  818,  819,  820,  821,  265,  266,  822,
  268,  823,  824,  825,  272,  826,  274,  827,  276,  828,
    0,  829,  830,  831,  832,    0,  833,  834,  835,  285,
  836,    0,  837,  838,  289,  839,  291,  292,  840,  294,
  295,  296,  297,  298,  299,    0,  841,  301,  302,  303,
  304,  305,    0,  842,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  843,  844,    0,  318,  319,  320,
  845,  846,  847,    0,    0,  324,  848,  849,  850,  851,
  852,  853,  854,  855,  856,    0,  857,  858,  859,  333,
  860,  334,  335,  336,  337,  338,  339,    0,    0,  861,
  862,  863,  864,  865,  866,  867,  868,  869,  870,  871,
  872,  873,  874,  875,  876,  877,  878, 1142,    0, 1326,
  879,    0,  880,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  882,    0,    0,    0,    0,
  883,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,  742,  141,  142,    0,    0,    0,
    0,  743,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,  744,    0,  147,    0,    0,  148,  745,  746,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,  747,  154,    0,    0,    0,
    0,    0,    0,    0,  748,    0,  155,  749,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,  750,    0,  751,  752,  163,  753,    0,  164,    0,
  165,  754,    0,  755,  166,  167,    0,    0,    0,    0,
    0,  756,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,  757,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,  758,    0,  181,    0,    0,  182,
  183,  759,  185,    0,  186,    0,  187,  760,  188,  189,
  190,  191,  192,  761,    0,    0,    0,  193,    0,  194,
    0,    0,    0,  762,    0,    0,    0,    0,    0,    0,
  195,    0,    0,    0,    0,  196,  197,  763,  764,  765,
  508,  509,  199,    0,  200,  201,  202,  203,    0,  204,
  766,    0,    0,    0,    0,    0,    0,  205,  206,  767,
  768,  769,  770,  771,  772,  773,  774,  775,  207,  776,
    0,  209,  210,  211,  777,  778,    0,  779,  780,  781,
    0,  214,  215,  782,  216,    0,    0,  217,  218,  783,
  784,  785,  219,  220,    0,    0,    0,    0,  221,  786,
  223,    0,  787,  225,  226,    0,  227,    0,  788,  789,
  790,    0,  791,  792,    0,  793,  228,  229,  230,  231,
  232,  233,  794,  235,  795,  237,  796,  797,  798,  799,
  800,  801,  802,  803,  804,  805,  806,    0,  807,  808,
  809,  810,  811,  812,    0,  813,  814,  815,  258,    0,
  816,    0,  817,  818,  819,  820,  821,  265,  266,  822,
  268,  823,  824,  825,  272,  826,  274,  827,  276,  828,
    0,  829,  830,  831,  832,    0,  833,  834,  835,  285,
  836,    0,  837,  838,  289,  839,  291,  292,  840,  294,
  295,  296,  297,  298,  299,    0,  841,  301,  302,  303,
  304,  305,    0,  842,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  843,  844,    0,  318,  319,  320,
  845,  846,  847,    0,    0,  324,  848,  849,  850,  851,
  852,  853,  854,  855,  856,    0,  857,  858,  859,  333,
  860,  334,  335,  336,  337,  338,  339,    0,    0,  861,
  862,  863,  864,  865,  866,  867,  868,  869,  870,  871,
  872,  873,  874,  875,  876,  877,  878, 1142, 1614,    0,
  879,    0,  880,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  882,    0,    0,    0,    0,
  883,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,  742,  141,  142,    0,    0,    0,
    0,  743,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,  744,    0,  147,    0,    0,  148,  745,  746,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,  747,  154,    0,    0,    0,
    0,    0,    0,    0,  748,    0,  155,  749,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,  750,    0,  751,  752,  163,  753,    0,  164,    0,
  165,  754,    0,  755,  166,  167,    0,    0,    0,    0,
    0,  756,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,  757,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,  758,    0,  181,    0,    0,  182,
  183,  759,  185,    0,  186,    0,  187,  760,  188,  189,
  190,  191,  192,  761,    0,    0,    0,  193,    0,  194,
    0,    0,    0,  762,    0,    0,    0,    0,    0,    0,
  195,    0,    0,    0,    0,  196,  197,  763,  764,  765,
  508,  509,  199,    0,  200,  201,  202,  203,    0,  204,
  766,    0,    0,    0,    0,    0,    0,  205,  206,  767,
  768,  769,  770,  771,  772,  773,  774,  775,  207,  776,
    0,  209,  210,  211,  777,  778,    0,  779,  780,  781,
    0,  214,  215,  782,  216,    0,    0,  217,  218,  783,
  784,  785,  219,  220,    0,    0,    0,    0,  221,  786,
  223,    0,  787,  225,  226,    0,  227,    0,  788,  789,
  790,    0,  791,  792,    0,  793,  228,  229,  230,  231,
  232,  233,  794,  235,  795,  237,  796,  797,  798,  799,
  800,  801,  802,  803,  804,  805,  806,    0,  807,  808,
  809,  810,  811,  812,    0,  813,  814,  815,  258,    0,
  816,    0,  817,  818,  819,  820,  821,  265,  266,  822,
  268,  823,  824,  825,  272,  826,  274,  827,  276,  828,
    0,  829,  830,  831,  832,    0,  833,  834,  835,  285,
  836,    0,  837,  838,  289,  839,  291,  292,  840,  294,
  295,  296,  297,  298,  299,    0,  841,  301,  302,  303,
  304,  305,    0,  842,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  843,  844,    0,  318,  319,  320,
  845,  846,  847,    0,    0,  324,  848,  849,  850,  851,
  852,  853,  854,  855,  856,    0,  857,  858,  859,  333,
  860,  334,  335,  336,  337,  338,  339,    0,    0,  861,
  862,  863,  864,  865,  866,  867,  868,  869,  870,  871,
  872,  873,  874,  875,  876,  877,  878, 1142,    0,    0,
  879,    0,  880,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  882,    0,    0,    0,    0,
  883,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,  742,  141,  142,    0,    0,    0,
    0,  743,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,  744,    0,  147,    0,    0,  148,  745,  746,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,  747,  154,    0,    0,    0,
    0, 1976,    0,    0,  748,    0,  155,  749,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,  750,    0,  751,  752,  163,  753,    0,  164,    0,
  165,  754,    0,  755,  166,  167,    0,    0,    0,    0,
    0,  756,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,  757,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,  758,    0,  181,    0,    0,  182,
  183,  759,  185,    0,  186,    0,  187,  760,  188,  189,
  190,  191,  192,  761,    0,    0,    0,  193,    0,  194,
    0,    0,    0,  762,    0,    0,    0,    0,    0,    0,
  195,    0,    0,    0,    0,  196,  197,  763,  764,  765,
  508,  509,  199,    0,  200,  201,  202,  203,    0,  204,
  766,    0,    0,    0,    0,    0,    0,  205,  206,  767,
  768,  769,  770,  771,  772,  773,  774,  775,  207,  776,
    0,  209,  210,  211,  777,  778,    0,  779,  780,  781,
    0,  214,  215,  782,  216,    0,    0,  217,  218,  783,
  784,  785,  219,  220,    0,    0,    0,    0,  221,  786,
  223,    0,  787,  225,  226,    0,  227,    0,  788,  789,
  790,    0,  791,  792,    0,  793,  228,  229,  230,  231,
  232,  233,  794,  235,  795,  237,  796,  797,  798,  799,
  800,  801,  802,  803,  804,  805,  806,    0,  807,  808,
  809,  810,  811,  812,    0,  813,  814,  815,  258,    0,
  816,    0,  817,  818,  819,  820,  821,  265,  266,  822,
  268,  823,  824,  825,  272,  826,  274,  827,  276,  828,
    0,  829,  830,  831,  832,    0,  833,  834,  835,  285,
  836,    0,  837,  838,  289,  839,  291,  292,  840,  294,
  295,  296,  297,  298,  299,    0,  841,  301,  302,  303,
  304,  305,    0,  842,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  843,  844,    0,  318,  319,  320,
  845,  846,  847,    0,    0,  324,  848,  849,  850,  851,
  852,  853,  854,  855,  856,    0,  857,  858,  859,  333,
  860,  334,  335,  336,  337,  338,  339,    0,    0,  861,
  862,  863,  864,  865,  866,  867,  868,  869,  870,  871,
  872,  873,  874,  875,  876,  877,  878, 1142,    0,    0,
  879,    0,  880,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  882,    0,    0,    0,    0,
  883,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,  742,  141,  142,    0,    0,    0,
    0,  743,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,  744,    0,  147,    0,    0,  148,  745,  746,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,  747,  154,    0,    0,    0,
    0,    0,    0,    0,  748,    0,  155,  749,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,  750,    0,  751,  752,  163,  753,    0,  164,    0,
  165,  754,    0,  755,  166,  167,    0,    0,    0,    0,
    0,  756,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,  757,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,  758,    0,  181,    0,    0,  182,
  183,  759,  185,    0,  186,    0,  187,  760,  188,  189,
  190,  191,  192,  761,    0,    0, 1598,  193,    0,  194,
    0,    0,    0,  762,    0,    0,    0,    0,    0,    0,
  195,    0,    0,    0,    0,  196,  197,  763,  764,  765,
  508,  509,  199,    0,  200,  201,  202,  203,    0,  204,
  766,    0,    0,    0,    0,    0,    0,  205,  206,  767,
  768,  769,  770,  771,  772,  773,  774,  775,  207,  776,
    0,  209,  210,  211,  777,  778,    0,  779,  780,  781,
    0,  214,  215,  782,  216,    0,    0,  217,  218,  783,
  784,  785,  219,  220,    0,    0,    0,    0,  221,  786,
  223,    0,  787,  225,  226,    0,  227,    0,  788,  789,
  790,    0,  791,  792,    0,  793,  228,  229,  230,  231,
  232,  233,  794,  235,  795,  237,  796,  797,  798,  799,
  800,  801,  802,  803,  804,  805,  806,    0,  807,  808,
  809,  810,  811,  812,    0,  813,  814,  815,  258,    0,
  816,    0,  817,  818,  819,  820,  821,  265,  266,  822,
  268,  823,  824,  825,  272,  826,  274,  827,  276,  828,
    0,  829,  830,  831,  832,    0,  833,  834,  835,  285,
  836,    0,  837,  838,  289,  839,  291,  292,  840,  294,
  295,  296,  297,  298,  299,    0,  841,  301,  302,  303,
  304,  305,    0,  842,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  843,  844,    0,  318,  319,  320,
  845,  846,  847,    0,    0,  324,  848,  849,  850,  851,
  852,  853,  854,  855,  856,    0,  857,  858,  859,  333,
  860,  334,  335,  336,  337,  338,  339,    0,    0,  861,
  862,  863,  864,  865,  866,  867,  868,  869,  870,  871,
  872,  873,  874,  875,  876,  877,  878, 1142, 2370,    0,
  879,    0,  880,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  882,    0,    0,    0,    0,
  883,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,  742,  141,  142,    0,    0,    0,
    0,  743,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,  744,    0,  147,    0,    0,  148,  745,  746,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,  747,  154,    0,    0,    0,
    0,    0,    0,    0,  748,    0,  155,  749,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,  750,    0,  751,  752,  163,  753,    0,  164,    0,
  165,  754,    0,  755,  166,  167,    0,    0,    0,    0,
    0,  756,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,  757,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,  758,    0,  181,    0,    0,  182,
  183,  759,  185,    0,  186,    0,  187,  760,  188,  189,
  190,  191,  192,  761,    0,    0,    0,  193,    0,  194,
    0,    0,    0,  762,    0,    0,    0,    0,    0,    0,
  195,    0,    0,    0,    0,  196,  197,  763,  764,  765,
  508,  509,  199,    0,  200,  201,  202,  203,    0,  204,
  766,    0,    0,    0,    0,    0,    0,  205,  206,  767,
  768,  769,  770,  771,  772,  773,  774,  775,  207,  776,
    0,  209,  210,  211,  777,  778,    0,  779,  780,  781,
    0,  214,  215,  782,  216,    0,    0,  217,  218,  783,
  784,  785,  219,  220,    0,    0,    0,    0,  221,  786,
  223,    0,  787,  225,  226,    0,  227,    0,  788,  789,
  790,    0,  791,  792,    0,  793,  228,  229,  230,  231,
  232,  233,  794,  235,  795,  237,  796,  797,  798,  799,
  800,  801,  802,  803,  804,  805,  806,    0,  807,  808,
  809,  810,  811,  812,    0,  813,  814,  815,  258,    0,
  816,    0,  817,  818,  819,  820,  821,  265,  266,  822,
  268,  823,  824,  825,  272,  826,  274,  827,  276,  828,
    0,  829,  830,  831,  832,    0,  833,  834,  835,  285,
  836,    0,  837,  838,  289,  839,  291,  292,  840,  294,
  295,  296,  297,  298,  299,    0,  841,  301,  302,  303,
  304,  305,    0,  842,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  843,  844,    0,  318,  319,  320,
  845,  846,  847,    0,    0,  324,  848,  849,  850,  851,
  852,  853,  854,  855,  856,    0,  857,  858,  859,  333,
  860,  334,  335,  336,  337,  338,  339,    0,    0,  861,
  862,  863,  864,  865,  866,  867,  868,  869,  870,  871,
  872,  873,  874,  875,  876,  877,  878, 1142,    0,    0,
  879,    0,  880,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  882,    0,    0,    0,    0,
  883,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,  742,  141,  142,    0,    0,    0,
    0,  743,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,  744,    0,  147,    0,    0,  148,  745,  746,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,  747,  154,    0,    0,    0,
    0,    0,    0,    0,  748,    0,  155,  749,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,  750,    0,  751,  752,  163,  753,    0,  164,    0,
  165,  754,    0,  755,  166,  167,    0,    0,    0,    0,
    0,  756,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,  757,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,  758,    0,  181,    0,    0,  182,
  183,  759,  185,    0,  186,    0,  187,  760,  188,  189,
  190,  191,  192,  761,    0,    0,    0,  193,    0,  194,
    0,    0,    0,  762,    0,    0,    0,    0,    0,    0,
  195,    0,    0,    0,    0,  196,  197,  763,  764,  765,
  508,  509,  199,    0,  200,  201,  202,  203,    0,  204,
  766,    0,    0,    0,    0,    0,    0,  205,  206,  767,
  768,  769,  770,  771,  772,  773,  774,  775,  207,  776,
    0,  209,  210,  211,  777,  778,    0,  779,  780,  781,
 2462,  214,  215,  782,  216,    0,    0,  217,  218,  783,
  784,  785,  219,  220,    0,    0,    0,    0,  221,  786,
  223,    0,  787,  225,  226,    0,  227,    0,  788,  789,
  790,    0,  791,  792,    0,  793,  228,  229,  230,  231,
  232,  233,  794,  235,  795,  237,  796,  797,  798,  799,
  800,  801,  802,  803,  804,  805,  806,    0,  807,  808,
  809,  810,  811,  812,    0,  813,  814,  815,  258,    0,
  816,    0,  817,  818,  819,  820,  821,  265,  266,  822,
  268,  823,  824,  825,  272,  826,  274,  827,  276,  828,
    0,  829,  830,  831,  832,    0,  833,  834,  835,  285,
  836,    0,  837,  838,  289,  839,  291,  292,  840,  294,
  295,  296,  297,  298,  299,    0,  841,  301,  302,  303,
  304,  305,    0,  842,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  843,  844,    0,  318,  319,  320,
  845,  846,  847,    0,    0,  324,  848,  849,  850,  851,
  852,  853,  854,  855,  856,    0,  857,  858,  859,  333,
  860,  334,  335,  336,  337,  338,  339,    0,    0,  861,
  862,  863,  864,  865,  866,  867,  868,  869,  870,  871,
  872,  873,  874,  875,  876,  877,  878, 1144,    0, 1144,
 1144,    0, 1144,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1144,    0,    0,    0,    0,
 1144,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1144,    0, 1144, 1144,    0,    0,
    0,    0, 1144,    0, 1144, 1144, 1144,    0,    0,    0,
    0, 1144,    0,    0,    0,    0, 1144, 1144,    0, 1144,
    0, 1144, 1144,    0, 1144,    0,    0, 1144, 1144, 1144,
    0,    0,    0,    0, 1144, 1144, 1144, 1144,    0,    0,
    0, 1144,    0, 1144,    0, 1144, 1144,    0,    0,    0,
    0,    0,    0,    0, 1144,    0, 1144, 1144,    0,    0,
    0, 1144,    0, 1144,    0, 1144,    0,    0,    0,    0,
    0, 1144,    0, 1144,    0,    0,    0, 1144,    0,    0,
    0, 1144,    0, 1144, 1144, 1144, 1144,    0, 1144,    0,
 1144, 1144,    0, 1144, 1144, 1144,    0,    0,    0,    0,
    0, 1144,    0,    0,    0,    0,    0, 1144,    0,    0,
    0, 1144, 1144, 1144, 1144, 1144,    0, 1144,    0, 1144,
    0,    0,    0, 1144,    0, 1144, 1144,    0,    0, 1144,
 1144,    0,    0,    0, 1144,    0, 1144,    0,    0, 1144,
 1144, 1144, 1144,    0, 1144,    0, 1144, 1144, 1144, 1144,
 1144, 1144, 1144, 1144,    0,    0,    0, 1144,    0, 1144,
    0,    0,    0, 1144,    0,    0,    0,    0,    0,    0,
 1144,    0,    0,    0,    0, 1144, 1144, 1144, 1144, 1144,
 1144, 1144, 1144,    0, 1144, 1144, 1144, 1144,    0, 1144,
 1144,    0,    0,    0,    0,    0,    0, 1144, 1144, 1144,
 1144, 1144, 1144, 1144, 1144, 1144, 1144, 1144, 1144, 1144,
    0, 1144,    0,    0, 1144, 1144,    0, 1144, 1144, 1144,
    0, 1144, 1144, 1144, 1144,    0,    0, 1144, 1144, 1144,
 1144, 1144, 1144, 1144,    0,    0,    0,    0, 1144, 1144,
 1144,    0, 1144, 1144, 1144,    0, 1144,    0, 1144, 1144,
 1144,    0, 1144, 1144,    0, 1144, 1144, 1144, 1144, 1144,
 1144, 1144, 1144, 1144, 1144, 1144, 1144, 1144, 1144, 1144,
 1144, 1144, 1144, 1144, 1144, 1144, 1144,    0, 1144, 1144,
 1144, 1144, 1144, 1144,    0, 1144, 1144, 1144, 1144,    0,
 1144,    0, 1144, 1144, 1144, 1144, 1144, 1144, 1144, 1144,
 1144, 1144, 1144, 1144, 1144, 1144, 1144, 1144, 1144, 1144,
    0, 1144, 1144, 1144, 1144,    0, 1144, 1144, 1144, 1144,
 1144,    0, 1144, 1144, 1144, 1144, 1144, 1144, 1144, 1144,
 1144, 1144, 1144, 1144, 1144,    0, 1144, 1144, 1144, 1144,
 1144, 1144,    0, 1144, 1144, 1144, 1144, 1144, 1144, 1144,
 1144,    0, 1144, 1144, 1144, 1144,    0, 1144, 1144, 1144,
 1144, 1144, 1144,    0,    0, 1144, 1144, 1144, 1144, 1144,
 1144, 1144, 1144, 1144, 1144,    0, 1144, 1144, 1144, 1144,
 1144, 1144, 1144, 1144, 1144, 1144, 1144,    0,    0, 1144,
 1144, 1144, 1144, 1144, 1144, 1144, 1144, 1144, 1144, 1144,
 1144, 1144, 1144, 1144, 1144, 1144, 1144, 1742,    0, 1742,
 1742,    0, 1742,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1742,    0,    0,    0,    0,
 1742,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1742,    0, 1742,    0,    0,    0,
    0,    0, 1742,    0, 1742, 1742, 1742,    0,    0,    0,
    0, 1742,    0,    0,    0,    0, 1742, 1742,    0, 1742,
    0, 1742, 1742,    0, 1742,    0,    0, 1742, 1742, 1742,
    0,    0,    0,    0, 1742,    0, 1742, 1742,    0,    0,
    0, 1742,    0, 1742,    0, 1742, 1742,    0,    0,    0,
    0,    0,    0,    0, 1742,    0, 1742, 1742,    0,    0,
    0, 1742,    0, 1742,    0, 1742,    0,    0,    0,    0,
    0, 1742,    0, 1742,    0,    0,    0, 1742,    0,    0,
    0, 1742,    0, 1742, 1742, 1742, 1742,    0, 1742,    0,
 1742, 1742,    0, 1742, 1742, 1742,    0,    0,    0,    0,
    0, 1742,    0,    0,    0,    0,    0, 1742,    0,    0,
    0, 1742, 1742, 1742, 1742, 1742,    0, 1742,    0, 1742,
    0,    0,    0, 1742,    0, 1742, 1742,    0,    0, 1742,
 1742,    0,    0,    0, 1742,    0, 1742,    0,    0, 1742,
 1742, 1742, 1742,    0, 1742,    0, 1742, 1742, 1742, 1742,
 1742, 1742, 1742, 1742,    0,    0,    0, 1742,    0, 1742,
    0,    0,    0, 1742,    0,    0,    0,    0,    0,    0,
 1742,    0,    0,    0,    0, 1742, 1742, 1742, 1742, 1742,
 1742, 1742, 1742,    0, 1742, 1742, 1742, 1742,    0, 1742,
 1742,    0,    0,    0,    0,    0,    0, 1742, 1742, 1742,
 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
    0, 1742, 1742, 1742, 1742, 1742,    0, 1742, 1742, 1742,
    0, 1742, 1742, 1742, 1742,    0,    0, 1742, 1742, 1742,
 1742, 1742, 1742, 1742,    0,    0,    0,    0, 1742, 1742,
 1742,    0, 1742, 1742, 1742,    0, 1742,    0, 1742, 1742,
 1742,    0, 1742, 1742,    0, 1742, 1742, 1742, 1742, 1742,
 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
 1742, 1742, 1742, 1742, 1742, 1742, 1742,    0, 1742, 1742,
 1742, 1742, 1742, 1742,    0, 1742, 1742, 1742, 1742,    0,
 1742,    0, 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
    0, 1742, 1742, 1742, 1742,    0, 1742, 1742, 1742, 1742,
 1742,    0, 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
 1742, 1742, 1742, 1742, 1742,    0, 1742, 1742, 1742, 1742,
 1742, 1742,    0, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
 1742,    0, 1742, 1742, 1742, 1742,    0, 1742, 1742, 1742,
 1742, 1742, 1742,    0,    0, 1742, 1742, 1742, 1742, 1742,
 1742, 1742, 1742, 1742, 1742,    0, 1742, 1742, 1742, 1742,
 1742, 1742, 1742, 1742, 1742, 1742, 1742,    0,    0, 1742,
 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
 1742, 1742, 1742, 1742, 1742, 1742, 1742,  881,    0,    0,
  879,    0,  880,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  882,    0,    0,    0,    0,
  883,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,  742,  141,  142,    0,    0,    0,
    0,  743,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,  744,    0,  147,    0,    0,  148,  745,  746,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,  747,  154,    0,    0,    0,
    0,    0,    0,    0,  748,    0,  155,  749,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,  750,    0,  751,  752,  163,  753,    0,  164,    0,
  165,  754,    0,  755,  166,  167,    0,    0,    0,    0,
    0,  756,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,  757,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,  758,    0,  181,    0,    0,  182,
  183,  759,  185,    0,  186,    0,  187,  760,  188,  189,
  190,  191,  192,  761,    0,    0,    0,  193,    0,  194,
    0,    0,    0,  762,    0,    0,    0,    0,    0,    0,
  195,    0,    0,    0,    0,  196,  197,  763,  764,  765,
  508,  509,  199,    0,  200,  201,  202,  203,    0,  204,
  766,    0,    0,    0,    0,    0,    0,  205,  206,  767,
  768,  769,  770,  771,  772,  773,  774,  775,  207,  776,
    0,  209,  210,  211,  777,  778,    0,  779,  780,  781,
    0,  214,  215,  782,  216,    0,    0,  217,  218,  783,
  784,  785,  219,  220,    0,    0,    0,    0,  221,  786,
  223,    0,  787,  225,  226,    0,  227,    0,  788,  789,
  790,    0,  791,  792,    0,  793,  228,  229,  230,  231,
  232,  233,  794,  235,  795,  237,  796,  797,  798,  799,
  800,  801,  802,  803,  804,  805,  806,    0,  807,  808,
  809,  810,  811,  812,    0,  813,  814,  815,  258,    0,
  816,    0,  817,  818,  819,  820,  821,  265,  266,  822,
  268,  823,  824,  825,  272,  826,  274,  827,  276,  828,
    0,  829,  830,  831,  832,    0,  833,  834,  835,  285,
  836,    0,  837,  838,  289,  839,  291,  292,  840,  294,
  295,  296,  297,  298,  299,    0,  841,  301,  302,  303,
  304,  305,    0,  842,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  843,  844,    0,  318,  319,  320,
  845,  846,  847,    0,    0,  324,  848,  849,  850,  851,
  852,  853,  854,  855,  856,    0,  857,  858,  859,  333,
  860,  334,  335,  336,  337,  338,  339,    0,    0,  861,
  862,  863,  864,  865,  866,  867,  868,  869,  870,  871,
  872,  873,  874,  875,  876,  877,  878, 1142,    0,    0,
  879,    0,  880,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  882,    0,    0,    0,    0,
  883,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,  742,  141,  142,    0,    0,    0,
    0,  743,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,  744,    0,  147,    0,    0,  148,  745,  746,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,  747,  154,    0,    0,    0,
    0,    0,    0,    0,  748,    0,  155,  749,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,  750,    0,  751,  752,  163,  753,    0,  164,    0,
  165,  754,    0,  755,  166,  167,    0,    0,    0,    0,
    0,  756,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,  757,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,  758,    0,  181,    0,    0,  182,
  183,  759,  185,    0,  186,    0,  187,  760,  188,  189,
  190,  191,  192,  761,    0,    0,    0,  193,    0,  194,
    0,    0,    0,  762,    0,    0,    0,    0,    0,    0,
  195,    0,    0,    0,    0,  196,  197,  763,  764,  765,
  508,  509,  199,    0,  200,  201,  202,  203,    0,  204,
  766,    0,    0,    0,    0,    0,    0,  205,  206,  767,
  768,  769,  770,  771,  772,  773,  774,  775,  207,  776,
    0,  209,  210,  211,  777,  778,    0,  779,  780,  781,
    0,  214,  215,  782,  216,    0,    0,  217,  218,  783,
  784,  785,  219,  220,    0,    0,    0,    0,  221,  786,
  223,    0,  787,  225,  226,    0,  227,    0,  788,  789,
  790,    0,  791,  792,    0,  793,  228,  229,  230,  231,
  232,  233,  794,  235,  795,  237,  796,  797,  798,  799,
  800,  801,  802,  803,  804,  805,  806,    0,  807,  808,
  809,  810,  811,  812,    0,  813,  814,  815,  258,    0,
  816,    0,  817,  818,  819,  820,  821,  265,  266,  822,
  268,  823,  824,  825,  272,  826,  274,  827,  276,  828,
    0,  829,  830,  831,  832,    0,  833,  834,  835,  285,
  836,    0,  837,  838,  289,  839,  291,  292,  840,  294,
  295,  296,  297,  298,  299,    0,  841,  301,  302,  303,
  304,  305,    0,  842,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  843,  844,    0,  318,  319,  320,
  845,  846,  847,    0,    0,  324,  848,  849,  850,  851,
  852,  853,  854,  855,  856,    0,  857,  858,  859,  333,
  860,  334,  335,  336,  337,  338,  339,    0,    0,  861,
  862,  863,  864,  865,  866,  867,  868,  869,  870,  871,
  872,  873,  874,  875,  876,  877,  878, 2311,    0,    0,
  879,    0,  880,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  882,    0,    0,    0,    0,
  883,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,  742,  141,  142,    0,    0,    0,
    0,  743,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,  744,    0,  147,    0,    0,  148,  745,  746,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,  747,  154,    0,    0,    0,
    0,    0,    0,    0,  748,    0,  155,  749,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,  750,    0,  751,  752,  163,  753,    0,  164,    0,
  165,  754,    0,  755,  166,  167,    0,    0,    0,    0,
    0,  756,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,  757,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,  758,    0,  181,    0,    0,  182,
  183,  759,  185,    0,  186,    0,  187,  760,  188,  189,
  190,  191,  192,  761,    0,    0,    0,  193,    0,  194,
    0,    0,    0,  762,    0,    0,    0,    0,    0,    0,
  195,    0,    0,    0,    0,  196,  197,  763,  764,  765,
  508,  509,  199,    0,  200,  201,  202,  203,    0,  204,
  766,    0,    0,    0,    0,    0,    0,  205,  206,  767,
  768,  769,  770,  771,  772,  773,  774,  775,  207,  776,
    0,  209,  210,  211,  777,  778,    0,  779,  780,  781,
    0,  214,  215,  782,  216,    0,    0,  217,  218,  783,
  784,  785,  219,  220,    0,    0,    0,    0,  221,  786,
  223,    0,  787,  225,  226,    0,  227,    0,  788,  789,
  790,    0,  791,  792,    0,  793,  228,  229,  230,  231,
  232,  233,  794,  235,  795,  237,  796,  797,  798,  799,
  800,  801,  802,  803,  804,  805,  806,    0,  807,  808,
  809,  810,  811,  812,    0,  813,  814,  815,  258,    0,
  816,    0,  817,  818,  819,  820,  821,  265,  266,  822,
  268,  823,  824,  825,  272,  826,  274,  827,  276,  828,
    0,  829,  830,  831,  832,    0,  833,  834,  835,  285,
  836,    0,  837,  838,  289,  839,  291,  292,  840,  294,
  295,  296,  297,  298,  299,    0,  841,  301,  302,  303,
  304,  305,    0,  842,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  843,  844,    0,  318,  319,  320,
  845,  846,  847,    0,    0,  324,  848,  849,  850,  851,
  852,  853,  854,  855,  856,    0,  857,  858,  859,  333,
  860,  334,  335,  336,  337,  338,  339,    0,    0,  861,
  862,  863,  864,  865,  866,  867,  868,  869,  870,  871,
  872,  873,  874,  875,  876,  877,  878, 2934,    0,    0,
  879,    0,  880,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  882,    0,    0,    0,    0,
  883,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,  742,  141,  142,    0,    0,    0,
    0,  743,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,  744,    0,  147,    0,    0,  148,  745,  746,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,  747,  154,    0,    0,    0,
    0,    0,    0,    0,  748,    0,  155,  749,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,  750,    0,  751,  752,  163,  753,    0,  164,    0,
  165,  754,    0,  755,  166,  167,    0,    0,    0,    0,
    0,  756,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,  757,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,  758,    0,  181,    0,    0,  182,
  183,  759,  185,    0,  186,    0,  187,  760,  188,  189,
  190,  191,  192,  761,    0,    0,    0,  193,    0,  194,
    0,    0,    0,  762,    0,    0,    0,    0,    0,    0,
  195,    0,    0,    0,    0,  196,  197,  763,  764,  765,
  508,  509,  199,    0,  200,  201,  202,  203,    0,  204,
  766,    0,    0,    0,    0,    0,    0,  205,  206,  767,
  768,  769,  770,  771,  772,  773,  774,  775,  207,  776,
    0,  209,  210,  211,  777,  778,    0,  779,  780,  781,
    0,  214,  215,  782,  216,    0,    0,  217,  218,  783,
  784,  785,  219,  220,    0,    0,    0,    0,  221,  786,
  223,    0,  787,  225,  226,    0,  227,    0,  788,  789,
  790,    0,  791,  792,    0,  793,  228,  229,  230,  231,
  232,  233,  794,  235,  795,  237,  796,  797,  798,  799,
  800,  801,  802,  803,  804,  805,  806,    0,  807,  808,
  809,  810,  811,  812,    0,  813,  814,  815,  258,    0,
  816,    0,  817,  818,  819,  820,  821,  265,  266,  822,
  268,  823,  824,  825,  272,  826,  274,  827,  276,  828,
    0,  829,  830,  831,  832,    0,  833,  834,  835,  285,
  836,    0,  837,  838,  289,  839,  291,  292,  840,  294,
  295,  296,  297,  298,  299,    0,  841,  301,  302,  303,
  304,  305,    0,  842,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  843,  844,    0,  318,  319,  320,
  845,  846,  847,    0,    0,  324,  848,  849,  850,  851,
  852,  853,  854,  855,  856,    0,  857,  858,  859,  333,
  860,  334,  335,  336,  337,  338,  339,    0,    0,  861,
  862,  863,  864,  865,  866,  867,  868,  869,  870,  871,
  872,  873,  874,  875,  876,  877,  878, 1142,    0,    0,
  879,    0,  880,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  882,    0,    0,    0,    0,
  883,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,  742,  141,  142,    0,    0,    0,
    0,  743,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,  744,    0,  147,    0,    0,  148,  745,  746,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,  747,  154,    0,    0,    0,
    0,    0,    0,    0,  748,    0,  155,  749,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,  750,    0,  751,  752,  163,  753,    0,  164,    0,
  165,  754,    0,  755,  166,  167,    0,    0,    0,    0,
    0,  756,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,  757,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,  758,    0,  181,    0,    0,  182,
  183,  759,  185,    0,  186,    0,  187,  760,  188,  189,
  190,  191,  192,  761,    0,    0,    0,  193,    0,  194,
    0,    0,    0,  762,    0,    0,    0,    0,    0,    0,
  195,    0,    0,    0,    0,  196,  197,  763,  764,  765,
  508,  509,  199,    0,  200,  201,  202,  203,    0,  204,
  766,    0,    0,    0,    0,    0,    0,  205,  206,  767,
  768,  769,  770,  771,  772,  773,  774,  775,  207,  776,
    0,  209,  210,  211,  777,  778,    0,  779,  780,  781,
    0,  214,  215,  782,  216,    0,    0,  217,  218,  783,
  784,  785,  219,  220,    0,    0,    0,    0,  221,  786,
  223,    0,  787,  225,  226,    0,  227,    0,  788,  789,
  790,    0,  791,  792,    0,  793,  228,  229,  230,  231,
  232,  233,  794,  235,  795,  237,  796,  797,  798,  799,
  800,  801,  802,  803,  804,  805,  806,    0,  807,  808,
  809,  810,  811,  812,    0,  813,  814,  815,  258,    0,
  816,    0,  817,  818,  819,  820,  821,  265,  266,  822,
  268,  823,  824,  825,  272,  826,  274,  827,  276,  828,
    0,  829,  830,  831,  832,    0,  833,  834,  835,  285,
  836,    0,  837,  838,  289,  839,  291,  292,  840,  294,
  295,  296,  297,  298,  299,    0,  841,  301,  302, 3371,
  304,  305,    0,  842,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  843,  844,    0,  318,  319,  320,
  845,  846,  847,    0,    0,  324,  848,  849,  850,  851,
  852,  853,  854,  855,  856,    0,  857,  858,  859,  333,
  860,  334,  335,  336,  337,  338,  339,    0,    0,  861,
  862,  863,  864,  865,  866,  867,  868,  869,  870,  871,
  872,  873,  874,  875,  876,  877,  878, 1742,    0,    0,
 1742,    0, 1742,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1742,    0,    0,    0,    0,
 1742,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1742,    0, 1742,    0,    0,    0,
    0,    0, 1742,    0, 1742, 1742, 1742,    0,    0,    0,
    0, 1742,    0,    0,    0,    0, 1742, 1742,    0, 1742,
    0, 1742, 1742,    0, 1742,    0,    0, 1742, 1742, 1742,
    0,    0,    0,    0, 1742,    0, 1742, 1742,    0,    0,
    0, 1742,    0, 1742,    0, 1742, 1742,    0,    0,    0,
    0,    0,    0,    0, 1742,    0, 1742, 1742,    0,    0,
    0, 1742,    0, 1742,    0, 1742,    0,    0,    0,    0,
    0, 1742,    0, 1742,    0,    0,    0, 1742,    0,    0,
    0, 1742,    0, 1742, 1742, 1742, 1742,    0, 1742,    0,
 1742, 1742,    0, 1742, 1742, 1742,    0,    0,    0,    0,
    0, 1742,    0,    0,    0,    0,    0, 1742,    0,    0,
    0, 1742, 1742, 1742, 1742, 1742,    0, 1742,    0, 1742,
    0,    0,    0, 1742,    0, 1742, 1742,    0,    0, 1742,
 1742,    0,    0,    0, 1742,    0, 1742,    0,    0, 1742,
 1742, 1742, 1742,    0, 1742,    0, 1742, 1742, 1742, 1742,
 1742, 1742, 1742, 1742,    0,    0,    0, 1742,    0, 1742,
    0,    0,    0, 1742,    0,    0,    0,    0,    0,    0,
 1742,    0,    0,    0,    0, 1742, 1742, 1742, 1742, 1742,
 1742, 1742, 1742,    0, 1742, 1742, 1742, 1742,    0, 1742,
 1742,    0,    0,    0,    0,    0,    0, 1742, 1742, 1742,
 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
    0, 1742, 1742, 1742, 1742, 1742,    0, 1742, 1742, 1742,
    0, 1742, 1742, 1742, 1742,    0,    0, 1742, 1742, 1742,
 1742, 1742, 1742, 1742,    0,    0,    0,    0, 1742, 1742,
 1742,    0, 1742, 1742, 1742,    0, 1742,    0, 1742, 1742,
 1742,    0, 1742, 1742,    0, 1742, 1742, 1742, 1742, 1742,
 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
 1742, 1742, 1742, 1742, 1742, 1742, 1742,    0, 1742, 1742,
 1742, 1742, 1742, 1742,    0, 1742, 1742, 1742, 1742,    0,
 1742,    0, 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
    0, 1742, 1742, 1742, 1742,    0, 1742, 1742, 1742, 1742,
 1742,    0, 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
 1742, 1742, 1742, 1742, 1742,    0, 1742, 1742, 1742, 1742,
 1742, 1742,    0, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
 1742,    0, 1742, 1742, 1742, 1742,    0, 1742, 1742, 1742,
 1742, 1742, 1742,    0,    0, 1742, 1742, 1742, 1742, 1742,
 1742, 1742, 1742, 1742, 1742,    0, 1742, 1742, 1742, 1742,
 1742, 1742, 1742, 1742, 1742, 1742, 1742,    0,    0, 1742,
 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1742,
 1742, 1742, 1742, 1742, 1742, 1742, 1742, 1379,    0,    0,
 1379,    0, 1379,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1379,    0,    0,    0,    0,
 1379,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1379,    0, 1379,    0,    0,    0,
    0,    0, 1379,    0, 1379, 1379, 1379,    0,    0,    0,
    0, 1379,    0,    0,    0,    0, 1379, 1379,    0, 1379,
    0, 1379, 1379,    0, 1379,    0,    0, 1379, 1379, 1379,
    0,    0,    0,    0, 1379,    0, 1379, 1379,    0,    0,
    0, 1379,    0, 1379,    0, 1379, 1379,    0,    0,    0,
    0,    0,    0,    0, 1379,    0, 1379, 1379,    0,    0,
    0, 1379,    0, 1379,    0, 1379,    0,    0,    0,    0,
    0, 1379,    0, 1379,    0,    0,    0, 1379,    0,    0,
    0, 1379,    0, 1379, 1379, 1379, 1379,    0, 1379,    0,
 1379, 1379,    0, 1379, 1379, 1379,    0,    0,    0,    0,
    0, 1379,    0,    0,    0,    0,    0, 1379,    0,    0,
    0, 1379, 1379, 1379, 1379, 1379,    0, 1379,    0, 1379,
    0,    0,    0, 1379,    0, 1379, 1379,    0,    0, 1379,
 1379,    0,    0,    0, 1379,    0, 1379,    0,    0, 1379,
 1379, 1379, 1379,    0, 1379,    0, 1379, 1379, 1379, 1379,
 1379, 1379, 1379, 1379,    0,    0,    0, 1379,    0, 1379,
    0,    0,    0, 1379,    0,    0,    0,    0,    0,    0,
 1379,    0,    0,    0,    0, 1379, 1379, 1379, 1379, 1379,
 1379, 1379, 1379,    0, 1379, 1379, 1379, 1379,    0, 1379,
 1379,    0,    0,    0,    0,    0,    0, 1379, 1379, 1379,
 1379, 1379, 1379, 1379, 1379, 1379, 1379, 1379, 1379, 1379,
    0, 1379, 1379, 1379, 1379, 1379,    0, 1379, 1379, 1379,
    0, 1379, 1379, 1379, 1379,    0,    0, 1379, 1379, 1379,
 1379, 1379, 1379, 1379,    0,    0,    0,    0, 1379, 1379,
 1379,    0, 1379, 1379, 1379,    0, 1379,    0, 1379, 1379,
 1379,    0, 1379, 1379,    0, 1379, 1379, 1379, 1379, 1379,
 1379, 1379, 1379, 1379, 1379, 1379, 1379, 1379, 1379, 1379,
 1379, 1379, 1379, 1379, 1379, 1379, 1379,    0, 1379, 1379,
 1379, 1379, 1379, 1379,    0, 1379, 1379, 1379, 1379,    0,
 1379,    0, 1379, 1379, 1379, 1379, 1379, 1379, 1379, 1379,
 1379, 1379, 1379, 1379, 1379, 1379, 1379, 1379, 1379, 1379,
    0, 1379, 1379, 1379, 1379,    0, 1379, 1379, 1379, 1379,
 1379,    0, 1379, 1379, 1379, 1379, 1379, 1379, 1379, 1379,
 1379, 1379, 1379, 1379, 1379,    0, 1379, 1379, 1379, 1379,
 1379, 1379,    0, 1379, 1379, 1379, 1379, 1379, 1379, 1379,
 1379,    0, 1379, 1379, 1379, 1379,    0, 1379, 1379, 1379,
 1379, 1379, 1379,    0,    0, 1379, 1379, 1379, 1379, 1379,
 1379, 1379, 1379, 1379, 1379,    0, 1379, 1379, 1379, 1379,
 1379, 1379, 1379, 1379, 1379, 1379, 1379,    0,    0, 1379,
 1379, 1379, 1379, 1379, 1379, 1379, 1379, 1379, 1379, 1379,
 1379, 1379, 1379, 1379, 1379, 1379, 1379, 1218,    0,    0,
  879,    0,  880,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  882,    0,    0,    0,    0,
  883,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,  742,  141,  142,    0,    0,    0,
    0,  743,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,  744,    0,  147,    0,    0,  148,  745,  746,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,    0,  154,    0,    0,    0,
    0,    0,    0,    0,  748,    0,  155,  749,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,  750,    0,  751,  752,  163,  753,    0,  164,    0,
  165,  754,    0,  755,  166,  167,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,  757,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,  758,    0,  181,    0,    0,  182,
  183,  184,  185,    0,  186,    0,  187,  760,  188,  189,
  190,  191,  192,  761,    0,    0,    0,  193,    0,  194,
    0,    0,    0,  762,    0,    0,    0,    0,    0,    0,
  195,    0,    0,    0,   15,  196,  197,  763,  764,  765,
  508,  509,  199,    0,  200,  201,  202,  203,    0,  204,
  766,    0,    0,    0,    0,    0,    0,  205,  206,  767,
  768,  769,  770,  771,  772,  773,  774,  775,  207,  776,
    0,  209,  210,  211,  777,  778,    0,  779,  780,  781,
    0,  214,  215,  782,  216,    0,    0,  217,  218,    0,
    0,    0,  219,  220,    0,    0,    0,    0,  221,  786,
  223,    0,  787,  225,  226,    0,  227,    0,  788,  789,
  790,    0,  791,  792,    0,  793,  228,  229,  230,  231,
  232,  233,  794,  235,  795,  237,  796,  797,  798,  799,
  800,  801,  802,  803,  804,  805,  806,    0,  807,  808,
  809,  810,  811,  812,    0,  813,  814,  815,  258,    0,
  816,    0,  817,  818,  819,  820,  821,  265,  266,  822,
  268,  823,  824,  825,  272,  826,  274,  827,  276,  828,
    0,  829,  830,  831,  832,    0,  833,  834,  835,  285,
  836,    0,  837,  838,  289,  839,  291,  292,  840,  294,
  295,  296,  297,  298,  299,    0,  841,  301,  302,  303,
  304,  305,    0,  842,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  843,  844,    0,  318,  319,  320,
  845,  846,  847,    0,    0,  324,  848,  849,  850,  851,
  852,  853,  854,  855,  856,    0,  857,  858,  859,  333,
  860,  334,  335,  336,  337,  338,  339,    0,    0,  861,
  862,  863,  864,  865,  866,  867,  868,  869,  870,  871,
  872,  873,  874,  875,  876,  877,  878, 1218,    0,    0,
  879,    0,  880,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  882,    0,    0,    0,    0,
  883,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,  742,  141,  142,    0,    0,    0,
    0,  743,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,  744,    0,  147,    0,    0,  148,  745,  746,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,    0,  154,    0,    0,    0,
    0,    0,    0,    0,  748,    0,  155,  749,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,  750,    0,  751,  752,  163,  753,    0,  164,    0,
  165,  754,    0,  755,  166,  167,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,  757,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,  758,    0,  181,    0,    0,  182,
  183,  184,  185,    0,  186,    0,  187,  760,  188,  189,
  190,  191,  192,  761,    0,    0,    0,  193,    0,  194,
    0,    0,    0,  762,    0,    0,    0,    0,    0,    0,
  195,    0,    0,    0,    0,  196,  197,  763,  764,  765,
  508,  509,  199,    0,  200,  201,  202,  203,    0,  204,
  766,    0,    0,    0,    0,    0,    0,  205,  206,  767,
  768,  769,  770,  771,  772,  773,  774,  775,  207,  776,
    0,  209,  210,  211,  777,  778,    0,  779,  780,  781,
    0,  214,  215,  782,  216,    0,    0,  217,  218,    0,
    0,    0,  219,  220,    0,    0,    0,    0,  221,  786,
  223,    0,  787,  225,  226,    0,  227,    0,  788,  789,
  790,    0,  791,  792,    0,  793,  228,  229,  230,  231,
  232,  233,  794,  235,  795,  237,  796,  797,  798,  799,
  800,  801,  802,  803,  804,  805,  806,    0,  807,  808,
  809,  810,  811,  812,    0,  813,  814,  815,  258,    0,
  816,    0,  817,  818,  819,  820,  821,  265,  266,  822,
  268,  823,  824,  825,  272,  826,  274,  827,  276,  828,
    0,  829,  830,  831,  832,    0,  833,  834,  835,  285,
  836,    0,  837,  838,  289,  839,  291,  292,  840,  294,
  295,  296,  297,  298,  299,    0,  841,  301,  302,  303,
  304,  305,    0,  842,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  843,  844,    0,  318,  319,  320,
  845,  846,  847,    0,    0,  324,  848,  849,  850,  851,
  852,  853,  854,  855,  856,    0,  857,  858,  859,  333,
  860,  334,  335,  336,  337,  338,  339,    0,    0,  861,
  862,  863,  864,  865,  866,  867,  868,  869,  870,  871,
  872,  873,  874,  875,  876,  877,  878, 1579,    0,    0,
  879,    0,  880,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  882,    0,    0,    0,    0,
  883,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,  742,  141,  142,    0,    0,    0,
    0,  743,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,  744,    0,  147,    0,    0,  148,  745,  746,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,    0,  154,    0,    0,    0,
    0,    0,    0,    0,  748,    0,  155,  749,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,  750,    0,  751,  752,  163,  753,    0,  164,    0,
  165,  754,    0,  755,  166,  167,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,  757,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,  758,    0,  181,    0,    0,  182,
  183,  184,  185,    0,  186,    0,  187,  760,  188,  189,
  190,  191,  192,  761,    0,    0,    0,  193,    0,  194,
    0,    0,    0,  762,    0,    0,    0,    0,    0,    0,
  195,    0,    0,    0,    0,  196,  197,  763,  764,  765,
  508,  509,  199,    0,  200,  201,  202,  203,    0,  204,
  766, 1225,    0,    0,    0,    0,    0,  205,  206,  767,
  768,  769,  770,  771,  772,  773,  774,  775,  207,  776,
    0,  209,  210,  211,  777,  778,    0,  779,  780,  781,
    0,  214,  215,  782,  216,    0,    0,  217,  218,    0,
    0,    0,  219,  220,    0,    0,    0,    0,  221,  786,
  223,    0,  787,  225,  226,    0,  227,    0,  788,  789,
  790,    0,  791,  792,    0,  793,  228,  229,  230,  231,
  232,  233,  794,  235,  795,  237,  796,  797,  798,  799,
  800,  801,  802,  803,  804,  805,  806,    0,  807,  808,
  809,  810,  811,  812,    0,  813,  814,  815,  258,    0,
  816,    0,  817,  818,  819,  820,  821,  265,  266,  822,
  268,  823,  824,  825,  272,  826,  274,  827,  276,  828,
    0,  829,  830,  831,  832,    0,  833,  834,  835,  285,
  836,    0,  837,  838,  289,  839,  291,  292,  840,  294,
  295,  296,  297,  298,  299,    0,  841,  301,  302,  303,
  304,  305,    0,  842,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  843,  844,    0,  318,  319,  320,
  845,  846,  847,    0,    0,  324,  848,  849,  850,  851,
  852,  853,  854,  855,  856,    0,  857,  858,  859,  333,
  860,  334,  335,  336,  337,  338,  339,    0,    0,  861,
  862,  863,  864,  865,  866,  867,  868,  869,  870,  871,
  872,  873,  874,  875,  876,  877,  878,    0, 1933,    0,
 1933,    0,    0,    0,    0,    0, 1933,    0,    0, 1933,
 1933,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1933, 1933,    0, 1933,    0, 1933,    0,    0, 1933,    0,
    0, 1933,    0,    0,    0,    0,    0,    0, 1933,    0,
 1933, 1933,    0,    0,    0, 1933,    0, 1933,    0,    0,
 1933,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1933, 1933,    0,    0,    0, 1933,    0, 1933,    0, 1933,
 1933,    0,    0,    0,    0, 1933,    0, 1933,    0,    0,
    0, 1933,    0,    0,    0,    0,    0,    0,    0, 1933,
    0,    0, 1933,    0, 1933,    0,    0,    0, 1933, 1933,
    0, 1933,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1933,    0, 1933,    0, 1933, 1933, 1933, 1933, 1933,
    0, 1933,    0,    0,    0,    0,    0, 1933,    0, 1933,
 1933,    0,    0, 1933, 1933,    0,    0,    0,    0,    0,
 1933,    0,    0, 1933, 1933, 1933, 1933,    0, 1933,    0,
 1933,    0, 1933, 1933, 1933, 1933, 1933,    0,    0,    0,
    0, 1933,    0, 1933,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1933, 1224,    0,    0,    0, 1933,
 1933,    0, 1933,    0,    0,    0, 1933,    0, 1933, 1933,
 1933, 1933,    0, 1933,    0,    0,    0,    0,    0,    0,
    0, 1933, 1933,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1933, 1933,    0, 1933, 1933, 1933,    0,    0,
    0,    0, 1933, 1933,    0, 1933, 1933,    0, 1933,    0,
    0, 1933, 1933,    0,    0,    0, 1933, 1933,    0,    0,
    0,    0, 1933, 1933, 1933,    0, 1933, 1933, 1933,    0,
 1933,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1933, 1933, 1933, 1933, 1933, 1933, 1933, 1933, 1933, 1933,
 1933, 1933, 1933, 1933, 1933, 1933, 1933, 1933, 1933, 1933,
 1933,    0, 1933, 1933, 1933, 1933, 1933, 1933,    0, 1933,
 1933, 1933, 1933,    0, 1933,    0, 1933, 1933, 1933, 1933,
 1933, 1933, 1933, 1933, 1933, 1933, 1933, 1933, 1933, 1933,
 1933, 1933, 1933, 1933,    0, 1933, 1933, 1933, 1933,    0,
 1933, 1933, 1933, 1933, 1933,    0, 1933, 1933, 1933, 1933,
 1933, 1933, 1933, 1933, 1933, 1933, 1933, 1933, 1933,    0,
 1933, 1933, 1933, 1933, 1933, 1933,    0, 1933, 1933, 1933,
 1933, 1933, 1933, 1933, 1933,    0, 1933, 1933, 1933, 1933,
    0, 1933, 1933, 1933, 1933, 1933, 1933,    0,    0, 1933,
 1933, 1933, 1933, 1933, 1933, 1933, 1933, 1933,    0,    0,
    0,    0,    0, 1933,    0, 1933, 1933, 1933, 1933, 1933,
 1933,    0, 1837,    0, 1837,    0,    0,    0,    0,    0,
 1837,    0,    0, 1837, 1837,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1837, 1837,    0, 1837,    0, 1837,
    0,    0, 1837,    0,    0, 1837,    0,    0,    0,    0,
    0,    0, 1837,    0, 1837, 1837,    0,    0,    0, 1837,
    0, 1837,    0,    0, 1837,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1837, 1837,    0,    0,    0, 1837,
    0, 1837,    0, 1837, 1837,    0,    0,    0,    0, 1837,
    0, 1837,    0,    0,    0, 1837,    0,    0,    0,    0,
    0,    0,    0, 1837,    0,    0, 1837,    0, 1837,    0,
    0,    0, 1837, 1837,    0, 1837,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1837,    0, 1837,    0, 1837,
 1837, 1837, 1837, 1837,    0, 1837,    0,    0,    0,    0,
    0, 1837,    0, 1837, 1837,    0,    0, 1837, 1837,    0,
    0,    0,    0,    0, 1837,    0,    0, 1837, 1837, 1837,
 1837,    0, 1837,    0, 1837,    0, 1837, 1837, 1837, 1837,
 1837,    0,    0,    0,    0, 1837,    0, 1837,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1837,    0,
 1572,    0,    0, 1837, 1837,    0, 1837,    0,    0,    0,
 1837,    0, 1837, 1837, 1837, 1837,    0, 1837,  882,    0,
    0,    0,    0,    0,    0, 1837, 1837,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1837, 1837,    0, 1837,
 1837, 1837,    0,    0,    0,    0, 1837, 1837,    0, 1837,
 1837,    0, 1837,    0,    0, 1837, 1837,    0,    0,    0,
 1837, 1837,    0,    0,    0,    0, 1837, 1837, 1837,    0,
 1837, 1837, 1837,    0, 1837,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1837, 1837, 1837, 1837, 1837, 1837,
 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
 1837, 1837, 1837, 1837, 1837,    0, 1837, 1837, 1837, 1837,
 1837, 1837,    0, 1837, 1837, 1837, 1837,    0, 1837,    0,
 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,    0, 1837,
 1837, 1837, 1837,    0, 1837, 1837, 1837, 1837, 1837,    0,
 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
 1837, 1837, 1837,    0, 1837, 1837, 1837, 1837, 1837, 1837,
    0, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,    0,
 1837, 1837, 1837, 1837,    0, 1837, 1837, 1837, 1837, 1837,
 1837,    0,    0, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
 1837, 1837,    0,    0,    0,    0,    0, 1837,    0, 1837,
 1837, 1837, 1837, 1837, 1837,    0,    0,  138,    0,  139,
    0,    0,    0,    0,    0,  140,    0,    0,  141,  142,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  143,
  144,    0,  145,    0,  146,    0,    0,  147,    0,    0,
  148,    0,    0,    0,    0,    0,    0,  149,    0,  150,
  151,    0,    0,    0,  152,    0,  153,    0,    0,  154,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  155,
  156,    0,    0,    0,  157,    0,  158,    0,  159,    0,
    0,    0,    0,    0,  160,    0,  161,    0,    0,    0,
  162,    0,    0,    0,    0,    0,    0,    0,  163,    0,
    0,  164,    0,  165,    0,    0,    0,  166,  167,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  168,    0,    0,    0,  170,  171,  172,  173,  174,    0,
  175,    0,    0,    0,    0,    0,  176,    0,  177,  178,
    0,    0,  179,  180,    0,    0,    0,    0,    0,  181,
    0,    0,  182,  183,  184,  185,    0,  186,    0,  187,
    0,  188,  189,  190,  191,  192,    0,    0,    0,    0,
  193,    0,  194,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  195, 1279,    0,    0,    0,  196,  197,
    0,  198,    0,    0,    0,  199,    0,  200,  201,  202,
  203,    0,  204,    0,    0,    0,    0,    0,    0,    0,
  205,  206,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  207,  208,    0,  209,  210,  211,    0,    0,    0,
    0,  212,  213,    0,  214,  215,    0,  216,    0,    0,
  217,  218,    0,    0,    0,  219,  220,    0,    0,    0,
    0,  221,  222,  223,    0,  224,  225,  226,    0,  227,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  228,
  229,  230,  231,  232,  233,  234,  235,  236,  237,  238,
  239,  240,  241,  242,  243,  244,  245,  246,  247,  248,
    0,  249,  250,  251,  252,  253,  254,    0,  255,  256,
  257,  258,    0,  259,    0,  260,  261,  262,  263,  264,
  265,  266,  267,  268,  269,  270,  271,  272,  273,  274,
  275,  276,  277,    0,  278,  279,  280,  281,    0,  282,
  283,  284,  285,  286,    0,  287,  288,  289,  290,  291,
  292,  293,  294,  295,  296,  297,  298,  299,    0,  300,
  301,  302,  303,  304,  305,    0,  306,  307,  308,  309,
  310,  311,  312,  313,    0,  314,  315,  316,  317,    0,
  318,  319,  320,  321,  322,  323,    0,    0,  324,  325,
  326,  327,  328,  329,  330,  331,  332,    0,    0,    0,
    0,    0,  333,    0,  334,  335,  336,  337,  338,  339,
    0,  138,    0,  139,    0,    0,    0,    0,    0,  140,
    0,    0,  141,  142,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  143,  144,    0,  145,    0,  146,    0,
    0,  147,    0,    0,  148,    0,    0,    0,    0,    0,
    0,  149,    0,  150,  151,    0,    0,    0,  152,    0,
  153,    0,    0,  154,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  155,  156,    0,    0,    0,  157,    0,
  158,    0,  159,    0,    0,    0,    0,    0,  160,    0,
  161,    0,    0,    0,  162,    0,    0,    0,    0,    0,
    0,    0,  163,    0,    0,  164,    0,  165,    0,    0,
    0,  166,  167,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  168,    0,    0,    0,  170,  171,
  172,  173,  174,    0,  175,    0,    0,    0,    0,    0,
  176,    0,  177,  178,    0,    0,  179,  180,    0,    0,
    0,    0,    0,  181,    0,    0,  182,  183,  184,  185,
    0,  186,    0,  187,    0,  188,  189,  190,  191,  192,
    0,    0,    0,    0,  193,    0,  194,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  195, 1279,    0,
    0,   15,  196,  197,    0,  198,    0,    0,    0,  199,
    0,  200,  201,  202,  203,    0,  204,    0,    0,    0,
    0,    0,    0,    0,  205,  206,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  207,  208,    0,  209,  210,
  211,    0,    0,    0,    0,  212,  213,    0,  214,  215,
    0,  216,    0,    0,  217,  218,    0,    0,    0,  219,
  220,    0,    0,    0,    0,  221,  222,  223,    0,  224,
  225,  226,    0,  227,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  228,  229,  230,  231,  232,  233,  234,
  235,  236,  237,  238,  239,  240,  241,  242,  243,  244,
  245,  246,  247,  248,    0,  249,  250,  251,  252,  253,
  254,    0,  255,  256,  257,  258,    0,  259,    0,  260,
  261,  262,  263,  264,  265,  266,  267,  268,  269,  270,
  271,  272,  273,  274,  275,  276,  277,    0,  278,  279,
  280,  281,    0,  282,  283,  284,  285,  286,    0,  287,
  288,  289,  290,  291,  292,  293,  294,  295,  296,  297,
  298,  299,    0,  300,  301,  302,  303,  304,  305,    0,
  306,  307,  308,  309,  310,  311,  312,  313,    0,  314,
  315,  316,  317,    0,  318,  319,  320,  321,  322,  323,
    0,    0,  324,  325,  326,  327,  328,  329,  330,  331,
  332,    0,    0,    0,    0,    0,  333,    0,  334,  335,
  336,  337,  338,  339,    0,  138,    0,  139,    0,    0,
    0,    0,    0,  140,    0,    0,  141,  142,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  143,  144,    0,
  145,    0,  146,    0,    0,  147,    0,    0,  148,    0,
    0,    0,    0,    0,    0,  149,    0,  150,  151,    0,
    0,    0,  152,    0,  153,    0,    0,  154,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  155,  156,    0,
    0,    0,  157,    0,  158,    0,  159,    0,    0,    0,
    0,    0,  160,    0,  161,    0,    0,    0,  162,    0,
    0,    0,    0,    0,    0,    0,  163,    0,    0,  164,
    0,  165,    0,    0,    0,  166,  167,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  168,    0,
    0,    0,  170,  171,  172,  173,  174,    0,  175,    0,
    0,    0,    0,    0,  176,    0,  177,  178,    0,    0,
  179,  180,    0,    0,    0,    0,    0,  181,    0,    0,
  182,  183,  184,  185,    0,  186,    0,  187,    0,  188,
  189,  190,  191,  192,    0,    0,    0,    0,  193,    0,
  194,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  195,  678,    0,    0,    0,  196,  197,    0,  198,
    0,    0,    0,  199,    0,  200,  201,  202,  203,    0,
  204,    0,    0,    0,    0,    0,    0,    0,  205,  206,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  207,
  208,    0,  209,  210,  211,    0,    0,    0,    0,  212,
  213,    0,  214,  215,    0,  216,    0,    0,  217,  218,
    0,    0,    0,  219,  220,    0,    0,    0,    0,  221,
  222,  223,    0,  224,  225,  226,    0,  227,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  228,  229,  230,
  231,  232,  233,  234,  235,  236,  237,  238,  239,  240,
  241,  242,  243,  244,  245,  246,  247,  248,    0,  249,
  250,  251,  252,  253,  254,    0,  255,  256,  257,  258,
    0,  259,    0,  260,  261,  262,  263,  264,  265,  266,
  267,  268,  269,  270,  271,  272,  273,  274,  275,  276,
  277,    0,  278,  279,  280,  281,    0,  282,  283,  284,
  285,  286,    0,  287,  288,  289,  290,  291,  292,  293,
  294,  295,  296,  297,  298,  299,    0,  300,  301,  302,
  303,  304,  305,    0,  306,  307,  308,  309,  310,  311,
  312,  313,    0,  314,  315,  316,  317,    0,  318,  319,
  320,  321,  322,  323,    0,    0,  324,  325,  326,  327,
  328,  329,  330,  331,  332,    0,    0,    0,    0,    0,
  333,    0,  334,  335,  336,  337,  338,  339,    0,  138,
    0,  139,    0,    0,    0,    0,    0,  140,    0,    0,
  141,  142,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  143, 2750,    0,  145,    0,  146,    0,    0,  147,
    0,    0,  148,    0,    0,    0,    0,    0,    0,  149,
    0,  150,  151,    0,    0,    0,  152,    0,  153,    0,
    0,  154,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  155,  156,    0,    0,    0,  157,    0,  158,    0,
  159,    0,    0,    0,    0,    0,  160,    0,  161,    0,
    0,    0,  162,    0,    0,    0,    0,    0,    0,    0,
  163,    0,    0,  164,    0,  165,    0,    0,    0,  166,
  167,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  168,    0,    0,    0,  170,  171,  172,  173,
  174,    0,  175,    0,    0,    0,    0,    0,  176,    0,
  177,  178,    0,    0,  179,  180,    0,    0,    0,    0,
    0,  181,    0,    0,  182,  183,  184,  185,    0,  186,
    0,  187,    0,  188,  189,  190,  191,  192,    0,    0,
    0,    0,  193,    0,  194,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  195,    0, 2113,    0,    0,
  196,  197,    0,  198,    0,    0,    0,  199,    0,  200,
  201,  202,  203,    0,  204,    0,    0,    0,    0,    0,
    0,    0,  205,  206,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  207,  208,    0,  209,  210,  211,    0,
    0,    0,    0,  212,  213,    0,  214,  215,    0,  216,
    0,    0,  217,  218,    0,    0,    0,  219,  220,    0,
    0,    0,    0,  221,  222,  223,    0,  224,  225,  226,
    0,  227,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  228,  229,  230,  231,  232,  233,  234,  235,  236,
  237,  238,  239,  240,  241,  242,  243,  244,  245,  246,
  247,  248,    0,  249,  250,  251,  252,  253,  254,    0,
  255,  256,  257,  258,    0,  259,    0,  260,  261,  262,
  263,  264,  265,  266,  267,  268,  269,  270,  271,  272,
  273,  274,  275,  276,  277,    0,  278,  279,  280,  281,
    0,  282,  283,  284,  285,  286,    0,  287,  288,  289,
  290,  291,  292,  293,  294,  295,  296,  297,  298,  299,
    0,  300,  301,  302,  303,  304,  305,    0,  306,  307,
  308,  309,  310,  311,  312,  313,    0,  314,  315,  316,
  317,    0,  318,  319,  320,  321,  322,  323,    0,    0,
  324,  325,  326,  327,  328,  329,  330,  331,  332,    0,
    0,    0,    0,    0,  333,    0,  334,  335,  336,  337,
  338,  339,  138,    0,  139,    0,    0,    0,    0,    0,
  140,    0,    0,  141,  142,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  143,  144,    0,  145,    0,  146,
    0,    0,  147,    0,    0,  148,    0,  746,    0,    0,
    0,    0,  149,    0,  150,  151,    0,    0,    0,  152,
    0,  153,    0,    0,  154,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  155,  156,    0,    0,    0,  157,
    0,  158,    0,  159,    0,    0,    0,    0,    0,  160,
    0,  161,    0,    0,    0,  162,    0,    0,    0,    0,
    0,    0,    0,  163,    0,    0,  164,    0,  165,    0,
    0,    0,  166,  167,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  168,    0,    0,    0,  170,
  171,  172,  173,  174,    0,  175,    0,    0,    0,    0,
    0,  176,    0,  177,  178,    0,    0,  179,  180,    0,
    0,    0,    0,    0,  181,    0,    0,  182,  183,  184,
  185,    0,  186,    0,  187,    0,  188,  189,  190,  191,
  192,    0,    0,    0,    0,  193,    0,  194,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  195,    0,
    0,    0,    0,  196,  197, 1135,  198,    0,    0,    0,
  199,    0,  200,  201,  202,  203,    0,  204,    0,    0,
    0,    0,    0,    0,    0,  205,  206,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  207,  208,    0,  209,
  210,  211,    0,    0,    0,    0,  212,  213,    0,  214,
  215,    0,  216,    0,    0,  217,  218,    0,    0,    0,
  219,  220,    0,    0,    0,    0,  221,  222,  223,    0,
  224,  225,  226,    0,  227,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  228,  229,  230,  231,  232,  233,
  234,  235,  236,  237,  238,  239,  240,  241,  242,  243,
  244,  245,  246,  247,  248,    0,  249,  250,  251,  252,
  253,  254,    0,  255,  256,  257,  258,    0,  259,    0,
  260,  261,  262,  263,  264,  265,  266,  267,  268,  269,
  270,  271,  272,  273,  274,  275,  276,  277,    0,  278,
  279,  280,  281,    0,  282,  283,  284,  285,  286,    0,
  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,
  297,  298,  299,    0,  300,  301,  302,  303,  304,  305,
    0,  306,  307,  308,  309,  310,  311,  312,  313,    0,
  314,  315,  316,  317,    0,  318,  319,  320,  321,  322,
  323,    0,    0,  324,  325,  326,  327,  328,  329,  330,
  331,  332,    0,    0,    0,    0,    0,  333,  860,  334,
  335,  336,  337,  338,  339,    0,    0,  138,    0,  139,
    0,    0,    0,    0,    0,  140,    0,    0,  141,  142,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  143,
  144,    0,  145,    0,  146,    0,    0,  147,    0,    0,
  148,    0,    0,    0,    0,    0,    0,  149,    0,  150,
  151,    0,    0,    0,  152,    0,  153,    0,    0,  154,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  155,
  156,    0,    0,    0,  157,    0,  158,    0,  159,    0,
    0,    0,    0,    0,  160,    0,  161,    0,    0,    0,
  162,    0,    0,    0,    0,    0,    0,    0,  163,    0,
    0,  164,    0,  165,    0,    0,    0,  166,  167,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  168,    0,    0,    0,  170,  171,  172,  173,  174,    0,
  175,    0,    0,    0,    0,    0,  176,    0,  177,  178,
    0,    0,  179,  180,    0,    0,    0,    0,    0,  181,
    0,    0,  182,  183,  184,  185,    0,  186,    0,  187,
    0,  188,  189,  190,  191,  192,    0,    0,    0,    0,
  193,    0,  194,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  195,    0,    0,    0,    0,  196,  197,
    0,  198,  524,    0,    0,  199,    0,  200,  201,  202,
  203,  600,  204,    0,    0,    0,    0,    0,    0,    0,
  205,  206,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  207,  208,    0,  209,  210,  211,    0,    0,    0,
    0,  212,  213,    0,  214,  215,    0,  216,    0,    0,
  217,  218,    0,    0,    0,  219,  220,    0,    0,    0,
    0,  221,  222,  223,    0,  224,  225,  226,    0,  227,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  228,
  229,  230,  231,  232,  233,  234,  235,  236,  237,  238,
  239,  240,  241,  242,  243,  244,  245,  246,  247,  248,
    0,  249,  250,  251,  252,  253,  254,    0,  255,  256,
  257,  258,    0,  259,    0,  260,  261,  262,  263,  264,
  265,  266,  267,  268,  269,  270,  271,  272,  273,  274,
  275,  276,  277,    0,  278,  279,  280,  281,    0,  282,
  283,  284,  285,  286,    0,  287,  288,  289,  290,  291,
  292,  293,  294,  295,  296,  297,  298,  299,    0,  300,
  301,  302,  303,  304,  305,    0,  306,  307,  308,  309,
  310,  311,  312,  313,    0,  314,  315,  316,  317,    0,
  318,  319,  320,  321,  322,  323,    0,    0,  324,  325,
  326,  327,  328,  329,  330,  331,  332,    0,    0,    0,
    0,    0,  333,    0,  334,  335,  336,  337,  338,  339,
  600,    0,  600,    0,    0,    0,    0,    0,  600,    0,
    0,  600,  600,  600,    0,    0,    0,    0,    0,    0,
    0,    0,  600,  600,    0,  600,    0,  600,    0,    0,
  600,    0,    0,  600,    0,    0,    0,    0,    0,  600,
  600,    0,  600,  600,    0,    0,  600,  600,    0,  600,
  600,    0,  600,    0,    0,  600,    0,    0,    0,    0,
    0,    0,  600,  600,    0,    0,    0,  600,  600,  600,
    0,  600,    0,  600,    0,    0,    0,  600,    0,  600,
    0,    0,    0,  600,    0,    0,    0,    0,    0,  600,
    0,  600,  600,    0,  600,    0,  600,    0,  600,    0,
  600,  600,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  600,    0,    0,    0,  600,  600,  600,
  600,  600,    0,  600,    0,  600,  600,    0,    0,  600,
    0,  600,  600,    0,    0,  600,  600,    0,    0,    0,
  600,    0,  600,  600,    0,  600,  600,  600,  600,    0,
  600,    0,  600,    0,  600,  600,  600,  600,  600,    0,
    0,    0,    0,  600,    0,  600,    0,    0,  600,    0,
    0,    0,    0,    0,    0,    0,  600,  600,    0,  600,
  600,  600,  600,    0,  600,    0,    0,    0,  600,    0,
  600,  600,  600,  600, 1758,  600,  600,    0,    0,    0,
    0,    0,    0,  600,  600,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  600,  600,    0,  600,  600,  600,
    0,    0,    0,    0,  600,  600,    0,  600,  600,    0,
  600,    0,    0,  600,  600,    0,    0,    0,  600,  600,
  600,  600,  600,    0,  600,  600,  600,    0,  600,  600,
  600,    0,  600,    0,  600,  600,  600,    0,  600,  600,
    0,  600,  600,  600,  600,  600,  600,  600,  600,  600,
  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
  600,  600,  600,    0,  600,  600,  600,  600,  600,  600,
    0,  600,  600,  600,  600,    0,  600,    0,  600,  600,
  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
  600,  600,  600,  600,  600,  600,    0,  600,  600,  600,
  600,    0,  600,  600,  600,  600,  600,    0,  600,  600,
  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
  600,    0,  600,  600,  600,  600,  600,  600,    0,  600,
  600,  600,  600,  600,  600,  600,  600,    0,  600,  600,
  600,  600,    0,  600,  600,  600,  600,  600,  600,  600,
    0,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    0,    0,    0,    0,    0,  600,    0,  600,  600,  600,
  600,  600,  600,  138,    0,  139,    0,    0,    0,    0,
    0,  140,    0,    0,  141,  142, 1374,    0,    0,    0,
    0,    0,    0,    0,    0,  143,  144,    0,  145,    0,
  146,    0,    0,  147,    0,    0,  148,    0,    0,    0,
    0,    0,    5,  149,    0,  150,  151,    0,    0,    0,
  152,    0, 1744, 1745,    0, 1746,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  155,  156,    0,    0,    0,
 1747, 1748,  158,    0,  159,    0,    9,    0,    0,    0,
  160,    0,  161,    0,    0,    0,  162,    0,    0,    0,
    0,    0,  751,    0,  163,  753,    0,  164,    0,  165,
    0,   10,    0,  166,  167,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  168,    0,    0,    0,
  170,  171,  172,  173,  174,    0,  175,    0,  757, 1749,
    0,    0,  176,    0,  177,  178,    0,    0,  179,  180,
    0,    0,    0,  758,    0,  181,    0,    0,  182,  183,
  184,  185,    0,  186,    0,  187,    0,  188,  189,  190,
  191, 1750,    0,    0,    0,    0,  193,    0,  194,    0,
    0,   14,    0,    0,    0,    0,    0,    0,    0,  195,
 2178,    0,    0,   15,  196,  197,    0,  764,    0,    0,
    0,  199,    0,  200,  201,  202,  203, 1758,  204,  766,
    0,    0,    0,    0,    0,    0,  205,  206,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1751,  776,    0,
  209,  210,  211,    0,    0,    0,    0,  212,  213,    0,
  214,  215,    0,  216,    0,    0,  217, 1752,    0,    0,
    0,  219,  220, 1753, 1754, 1755,    0,  221,  222,  223,
    0,  224,  225,  226,    0,  227,    0,  788,  789,  790,
    0,  791,  792,    0,  793,  228,  229,  230,  231,  232,
  233,  794,  235,  795,  237,  796,  797,  798,  799,  800,
  801,  802,  803,  804,  805,  806,    0,  807,  808,  809,
  810,  811,  254,    0,  813,  814,  815,  258,    0,  816,
    0,  260,  818,  819,  820,  821,  265,  266,  822,  268,
  823,  824,  825,  272,  826,  274,  827,  276,  828,    0,
  829,  830,  831,  832,    0,  833,  834,  835,  285,  836,
    0,  837,  838,  289,  839,  291,  292,  840,  294,  295,
  296,  297,  298,  299,    0,  841,  301,  302,  303,  304,
  305,    0,  842,  307, 1756,  309,  310,  311,  312,  313,
    0,  314,  315,  843,  844,    0,  318,  319,  320,  845,
  846,  847, 1757,    0,  324,  325,  326,  327,  328,  329,
  330,  331,  332,    0,    0,    0,    0,    0,  333,    0,
  334,  335,  336,  337,  338,  339,  138,    0,  139,    0,
    0,    0,    0,    0,  140,    0,    0,  141,  142, 1374,
    0,    0,    0,    0,    0,    0,    0,    0,  143,  144,
    0,  145,    0,  146,    0,    0,  147,    0,    0,  148,
    0,    0,    0,    0,    0,    5,  149,    0,  150,  151,
    0,    0,    0,  152,    0, 1744, 1745,    0, 1746,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  155,  156,
    0,    0,    0, 1747, 1748,  158,    0,  159,    0,    9,
    0,    0,    0,  160,    0,  161,    0,    0,    0,  162,
    0,    0,    0,    0,    0,  751,    0,  163,  753,    0,
  164,    0,  165,    0,   10,    0,  166,  167,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  168,
    0,    0,    0,  170,  171,  172,  173,  174,    0,  175,
    0,  757, 1749,    0,    0,  176,    0,  177,  178,    0,
    0,  179,  180,    0,    0,    0,  758,    0,  181,    0,
    0,  182,  183,  184,  185,    0,  186,    0,  187,    0,
  188,  189,  190,  191, 1750,    0,    0,    0,    0,  193,
    0,  194,    0,    0,   14,    0,    0,    0,    0,    0,
    0,    0,  195,    0,    0,    0,   15,  196,  197,    0,
  764,    0,    0,    0,  199,    0,  200,  201,  202,  203,
  882,  204,  766,    0,    0,    0,    0,    0,    0,  205,
  206,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1751,  776,    0,  209,  210,  211,    0,    0,    0,    0,
  212,  213,    0,  214,  215,    0,  216,    0,    0,  217,
 1752,    0,    0,    0,  219,  220, 1753, 1754, 1755,    0,
  221,  222,  223,    0,  224,  225,  226,    0,  227,    0,
  788,  789,  790,    0,  791,  792,    0,  793,  228,  229,
  230,  231,  232,  233,  794,  235,  795,  237,  796,  797,
  798,  799,  800,  801,  802,  803,  804,  805,  806,    0,
  807,  808,  809,  810,  811,  254,    0,  813,  814,  815,
  258,    0,  816,    0,  260,  818,  819,  820,  821,  265,
  266,  822,  268,  823,  824,  825,  272,  826,  274,  827,
  276,  828,    0,  829,  830,  831,  832,    0,  833,  834,
  835,  285,  836,    0,  837,  838,  289,  839,  291,  292,
  840,  294,  295,  296,  297,  298,  299,    0,  841,  301,
  302,  303,  304,  305,    0,  842,  307, 1756,  309,  310,
  311,  312,  313,    0,  314,  315,  843,  844,    0,  318,
  319,  320,  845,  846,  847, 1757,    0,  324,  325,  326,
  327,  328,  329,  330,  331,  332,    0,    0,    0,    0,
    0,  333,    0,  334,  335,  336,  337,  338,  339,  138,
    0,  139,    0,    0,    0,    0,    0,  140,    0,    0,
  141,  142,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  143,  144,    0,  145,    0,  146,    0,    0,  147,
    0,    0,  148,    0,    0,    0,    0,    0,    0,  149,
    0,  150,  151,    0,    0,    0,  152,    0,  153,    0,
    0,  154,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  155,  156,    0,    0,    0,  157,    0,  158,    0,
  159,    0,    0,    0,    0,    0,  160,    0,  161,    0,
    0,    0,  162,    0,    0,    0,    0,    0,    0,    0,
  163,    0,    0,  164,    0,  165,    0,    0,    0,  166,
  167,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  168,    0,    0,    0,  170,  171,  172,  173,
  174,    0,  175,    0,    0,    0,    0,    0,  176,    0,
  177,  178,    0,    0,  179,  180,    0,    0,    0,    0,
    0,  181,    0,    0,  182,  183,  184,  185,    0,  186,
    0,  187,    0,  188,  189,  190,  191,  192,    0,    0,
    0,    0,  193,    0,  194,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  195,    0,    0,    0,    0,
  196,  197,    0,  198,    0,    0,    0,  199,    0,  200,
  201,  202,  203,    0,  204,    0,    0,    0,    0,    0,
    0,    0,  205,  206,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  207,  208,    0,  209,  210,  211,    0,
    0,    0,    0,  212,  213,    0,  214,  215,    0,  216,
    0,    0,  217,  218,    0,    0,    0,  219,  220,    0,
    0,    0,    0,  221,  222,  223,    0,  224,  225,  226,
    0,  227,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  228,  229,  230,  231,  232,  233,  234,  235,  236,
  237,  238,  239,  240,  241,  242,  243,  244,  245,  246,
  247,  248,    0,  249,  250,  251,  252,  253,  254,    0,
  255,  256,  257,  258,    0,  259,    0,  260,  261,  262,
  263,  264,  265,  266,  267,  268,  269,  270,  271,  272,
  273,  274,  275,  276,  277,    0,  278,  279,  280,  281,
    0,  282,  283,  284,  285,  286,    0,  287,  288,  289,
  290,  291,  292,  293,  294,  295,  296,  297,  298,  299,
    0,  300,  301,  302,  303,  304,  305,    0,  306,  307,
  308,  309,  310,  311,  312,  313,    0,  314,  315,  316,
  317,    0,  318,  319,  320,  321,  322,  323,    0,    0,
  324,  325,  326,  327,  328,  329,  330,  331,  332,    0,
    0,    0,    0,    0,  333,    0,  334,  335,  336,  337,
  338,  339, 1800, 1800, 1740, 1800, 1800, 1800,    0,    0,
    0,    0,    0, 1801, 1801, 1741, 1801, 1801, 1801,    0,
 1800, 1800, 1800,    0,    0,    0,    0,    0,    0,    0,
    0, 1801, 1801, 1801,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1800,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1801,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1846, 1846, 1738, 1846, 1846, 1846,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1846, 1846, 1846,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1846,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1800,    0,    0,    0,    0,    0,    0,    0,
    0, 1800,    0, 1801,    0,    0,    0, 1800,    0,    0,
    0, 1800, 1801,    0, 1800,    0,    0,    0, 1801,    0,
    0,    0, 1801,    0,    0, 1801,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1800, 1869,
 1869, 1739, 1869, 1869, 1869, 1800,    0,    0,    0, 1801,
    0,    0, 1846, 1800,    0,    0, 1801, 1869, 1869, 1869,
    0, 1846,    0,    0, 1801,    0,    0, 1846,    0,    0,
 1800, 1846, 1800,    0, 1846,    0,    0,    0,    0,    0,
    0, 1801, 1800, 1801, 1800, 1800, 1800,    0, 1869,    0,
    0, 1800,    0, 1801,    0, 1801, 1801, 1801,    0,    0,
    0,    0, 1801,    0,    0,    0,    0,    0, 1846,    0,
    0,    0,    0,    0,    0, 1846,    0,    0,    0,    0,
    0,    0,    0, 1846,    0,    0,    0,    0,    0,    0,
    0,    0, 1800,    0,    0,    0,    0,    0,    0,    0,
 1846,    0, 1846, 1801,    0,    0,    0,    0,    0,    0,
    0,    0, 1846,    0, 1846, 1846, 1846,    0,    0,    0,
    0, 1846,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1800, 1800, 1800, 1800, 1800, 1800,
 1800, 1800,    0,    0,    0, 1801, 1801, 1801, 1801, 1801,
 1801, 1801, 1801, 1881, 1881,    0, 1881, 1881, 1881,    0,
    0,    0, 1846,    0,    0,    0,    0,    0,    0,    0,
 1881, 1881, 1881, 1881,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1881,    0, 1846, 1846, 1846, 1846, 1846, 1846,
 1846, 1846,    0,    0,    0,    0,    0,    0,    0, 1869,
    0,    0,    0,    0,    0,    0,    0,    0, 1869,    0,
    0,    0,    0,    0, 1869,    0,    0,    0, 1869,    0,
    0, 1869,    0, 1800,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1801,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1800,
    0,    0,    0,    0,    0, 1869,    0,    0, 1800,    0,
 1801,    0, 1869,    0,    0,    0,    0,    0,    0, 1801,
 1869,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1869,    0, 1869,
    0,    0,    0, 1846,    0,    0,    0,    0,    0, 1869,
    0, 1869, 1869, 1869,    0,    0,    0,    0, 1869,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1846,
    0,    0,    0,    0,    0,    0,    0,    0, 1846,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1869,
    0,    0,    0, 1881,    0, 1881,    0,    0,    0,    0,
    0,    0, 1881,    0,    0,    0,    0,    0, 1881,    0,
    0,    0, 1881,    0,    0, 1881,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1869, 1869, 1869, 1869, 1869, 1869, 1869, 1869,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1881,
    0,    0,    0,    0,    0,    0, 1881,    0,    0,    0,
    0,    0,    0, 1881, 1881,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1881,    0, 1881,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1881,    0, 1881, 1881, 1881,    0, 1881,
    0,    0, 1881,    0,    0,    0,    0,    0,    0,    0,
    0, 1881,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1869,    0,    0, 1881,    0,    0,    0,    0,    0,  138,
    0,  139,    0,    0,    0,    0,    0,  140,    0,    0,
  141,  142,    0,    0,    0,    0, 1869,    0, 1881,    0,
    0,  143,  144,    0,  145, 1869,  146,    0,    0,  147,
    0, 1881,  148,    0,    0,    0,    0,    0,    0,  149,
    0,  150,  151,    0,    0,    0,  152,    0,  153,    0,
    0,  154,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  155,  156,    0,    0,    0,  157,    0,  158,    0,
  159,    0,    0,    0,    0,    0,  160,    0,  161,    0,
    0,    0,  162,    0,    0,    0,    0,    0,    0,    0,
  163,    0,    0,  164,    0,  165,    0,    0,    0,  166,
  167,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  168,    0,    0,    0,  170,  171,  172,  173,
  174,    0,  175,    0,    0,    0,    0,    0,  176,    0,
  177,  178,    0,    0,  179,  180,    0,    0,    0,    0,
    0,  181,    0,    0,  182,  183,  184,  185,    0,  186,
    0,  187,    0,  188,  189,  190,  191,  192,    0,    0,
    0,    0,  193,    0,  194,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  195,    0,    0,    0, 1881,
  196,  197,    0,  198,    0,    0,    0,  199,  377,  200,
  201,  202,  203,  378,  204,  379,  380,  381,  382,  383,
  384,  385,  205,  206,  386,  387,  388,  389,  390,    0,
    0,  391,  392,  207,  208,  393,  209,  210,  211,  394,
  395,  396,  397,  212,  213,  398,  214,  215,  399,  216,
  400,  401,  217,  218,  402,  403,  404,  219,  220,  405,
  406,  407,  408,  221,  222,  223,  409,  224,  225,  226,
  410,  227,  411,  412,  413,  414,  415,  416,  417,  418,
  419,  228,  229,  230,  231,  232,  233,  234,  235,  236,
  237,  238,  239,  240,  241,  242,  243,  244,  245,  246,
  247,  248,  420,  249,  250,  251,  252,  253,  254,  421,
  255,  256,  257,  258,  422,  259,  423,  260,  261,  262,
  263,  264,  265,  266,  267,  268,  269,  270,  271,  272,
  273,  274,  275,  276,  277,  424,  278,  279,  280,  281,
  425,  282,  283,  284,  285,  286,  426,  287,  288,  289,
  290,  291,  292,  293,  294,  295,  296,  297,  298,  299,
  427,  300,  301,  302,  303,  304,  305,    0,  306,  307,
  308,  309,  310,  311,  312,  313,  428,  314,  315,  316,
  317,  429,  318,  319,  320,  321,  322,  323,  430,  431,
  324,  325,  326,  327,  328,  329,  330,  331,  332,  432,
  433,  434,  435,  436,  333,  437,  334,  335,  336,  337,
  338,  339,  438,  439,  440,  441,  442,  443,  444,  445,
  446,  447,  448,  449,  450,  451,  452,  453,  454,  455,
  456,  457,  892,    0,  892,    0,    0,    0,    0,    0,
  892,    0,    0,  892,  892,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  892,  892,    0,  892,    0,  892,
    0,    0,  892,    0,    0,  892,    0,    0,    0,    0,
    0,    0,  892,    0,  892,  892,    0,    0,    0,  892,
    0,  892,    0,    0,  892,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  892,  892,    0,    0,    0,  892,
    0,  892,    0,  892,    0,    0,    0,    0,    0,  892,
    0,  892,    0,    0,    0,  892,    0,    0,    0,    0,
    0,    0,    0,  892,    0,    0,  892,    0,  892,    0,
    0,    0,  892,  892,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  892,    0,    0,    0,  892,
  892,  892,  892,  892,    0,  892,    0,    0,    0,    0,
    0,  892,    0,  892,  892,    0,    0,  892,  892,    0,
    0,    0,    0,    0,  892,    0,    0,  892,  892,  892,
  892,    0,  892,    0,  892,    0,  892,  892,  892,  892,
  892,    0,    0,    0,    0,  892,    0,  892,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  892,    0,
    0,    0,    0,  892,  892,    0,  892,    0,    0,    0,
  892,  892,  892,  892,  892,  892,    0,  892,  892,  892,
  892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
  892,  892,    0,    0,  892,  892,  892,  892,  892,  892,
  892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
  892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
  892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
  892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
  892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
  892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
  892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
  892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
  892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
  892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
  892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
  892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
  892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
    0,  892,  892,  892,  892,  892,  892,  892,  892,  892,
  892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
  892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
  892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
  892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
  892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
  892,  892,  892,  892,  892, 1753,    0, 1753,    0,    0,
    0,    0,    0, 1753,    0,    0, 1753, 1753,    0,    0,
 1753,    0,    0, 1753,    0,    0,    0, 1753, 1753,    0,
 1753,    0, 1753,    0,    0, 1753,    0, 1755, 1753, 1753,
    0, 1753,    0,    0,    0, 1753,    0, 1753, 1753,    0,
    0,    0, 1753,    0, 1753,    0,    0, 1753,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1753, 1753,    0,
    0,    0, 1753,    0, 1753,    0, 1753,    0,    0, 1753,
    0,    0, 1753,    0, 1753, 1753, 1753, 1753, 1753, 1753,
 1753, 1753,    0, 1753,    0,    0, 1753,    0,    0, 1753,
    0, 1753,    0,    0,    0, 1753, 1753, 1753,    0, 1753,
    0, 1755,    0,    0,    0,    0,    0,    0, 1753,    0,
    0,    0, 1753, 1753, 1753, 1753, 1753,    0, 1753,    0,
    0,    0,    0,    0, 1753,    0, 1753, 1753, 1753,    0,
 1753, 1753,    0,    0,    0,    0,    0, 1753,    0,    0,
 1753, 1753, 1753, 1753, 1753, 1753,    0, 1753,    0, 1753,
 1753, 1753, 1753, 1753,    0,    0,    0,    0, 1753,    0,
 1753,    0,    0,    0,    0,    0, 1753,    0,    0,    0,
    0, 1753,    0,    0,    0,    0, 1753, 1753,    0, 1753,
    0,    0,    0, 1753,    0, 1753, 1753, 1753, 1753,    0,
 1753,    0,    0,    0,    0,    0,    0,    0, 1753, 1753,
 1753, 1753,    0,    0,    0,    0,    0,    0,    0, 1753,
 1753,    0, 1753, 1753, 1753,    0,    0, 1753,    0, 1753,
 1753,    0, 1753, 1753,    0, 1753,    0,    0, 1753, 1753,
    0,    0,    0, 1753, 1753,    0,    0,    0,    0, 1753,
 1753, 1753,    0, 1753, 1753, 1753,    0, 1753,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1753, 1753, 1753,
 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,    0, 1753,
 1753, 1753, 1753, 1753, 1753,    0, 1753, 1753, 1753, 1753,
    0, 1753,    0, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 1753,    0, 1753, 1753, 1753, 1753,    0, 1753, 1753, 1753,
 1753, 1753,    0, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 1753, 1753, 1753, 1753, 1753, 1753,    0, 1753, 1753, 1753,
 1753, 1753, 1753,    0, 1753, 1753, 1753, 1753, 1753, 1753,
 1753, 1753,    0, 1753, 1753, 1753, 1753, 1755, 1753, 1753,
 1753, 1753, 1753, 1753,    0,    0, 1753, 1753, 1753, 1753,
 1753, 1753, 1753, 1753, 1753,    0, 1753,    0,    0,    0,
 1753,    0, 1753, 1753, 1753, 1753, 1753, 1753,  138,    0,
  139,    0,    0,    0,    0,    0,  140,    0,    0,  141,
  142,    0,    0, 1060,    0,    0, 1061,    0,    0,    0,
  143,  144,    0,  145,    0,  146,    0,    0,  147,    0,
    0,  148, 1062,    0, 1063,    0,    0,    0,  149,    0,
  150,  151,    0,    0,    0,  152,    0,  153,    0,    0,
  154,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  155,  156,    0,    0,    0,  157,    0,  158,    0,  159,
    0,    0, 1064,    0,    0,  160,    0,  161, 1065, 1066,
 1067,  162, 1068, 1069, 1070,    0, 1071,    0,    0,  163,
    0,    0,  164,    0,  165,    0,    0,    0,  166,  167,
 1072,    0, 1073,    0,    0,    0,    0,    0,    0,    0,
    0,  168,    0,    0,    0,  170,  171,  172,  173,  174,
    0,  175,    0,    0,    0,    0,    0,  176,    0,  177,
  178, 1074,    0,  179,  180,    0,    0,    0,    0,    0,
  181,    0,    0,  182,  183,  184,  185, 1075,  186,    0,
  187,    0,  188,  189,  190,  191,  192,    0,    0,    0,
    0,  193,    0,  194,    0,    0,    0,    0,    0, 1076,
    0,    0,    0,    0,  195,    0,    0,    0,    0,  196,
  197,    0,  198,    0,    0,    0,  199,    0,  200,  201,
  202,  203,    0, 2153,    0,    0,    0,    0,    0,    0,
    0,  205,  206, 1077, 1078,    0,    0,    0,    0,    0,
    0,    0,  207,  208,    0,  209,  210,  211,    0,    0,
 1079,    0,  212,  213,    0,  214,  215,    0,  216,    0,
    0,  217,  218,    0,    0,    0,  219,  220,    0,    0,
    0,    0,  221,  222,  223,    0,  224,  225,  226,    0,
  227,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  228,  229,  230,  231,  232,  233,  234,  235,  236,  237,
  238,  239,  240,  241,  242,  243,  244,  245,  246,  247,
  248,    0,  249,  250,  251,  252,  253,  254,    0,  255,
  256,  257,  258,    0,  259,    0,  260,  261,  262,  263,
  264,  265,  266,  267,  268,  269,  270,  271,  272,  273,
  274,  275,  276,  277,    0,  278,  279,  280,  281,    0,
  282,  283,  284,  285,  286,    0,  287,  288,  289,  290,
  291,  292,  293,  294,  295,  296,  297,  298,  299,    0,
  300,  301,  302,  303,  304,  305,    0,  306,  307,  308,
  309,  310,  311,  312,  313,    0,  314,  315,  316,  317,
    0,  318,  319,  320,  321,  322,  323,    0,    0,  324,
  325,  326,  327,  328,  329,  330,  331,  332,    0, 1080,
    0,    0,    0,  333,    0,  334,  335,  336,  337,  338,
  339,  138,    0,  139,    0,    0,    0,    0,    0,  140,
    0,    0,  141,  142,    0,    0, 1060,    0,    0, 1061,
    0,    0,    0,  143,  144,    0,  145,    0,  146,    0,
    0,  147,    0,    0,  148, 1062,    0, 1063,    0,    0,
    0,  149,    0,  150,  151,    0,    0,    0,  152,    0,
  153,    0,    0,  154,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  155,  156,    0,    0,    0,  157,    0,
  158,    0,  159,    0,    0, 1064,    0,    0,  160,    0,
  161, 1065, 1066, 1067,  162, 1068, 1069, 1070,    0, 1071,
    0,    0,  163,    0,    0,  164,    0,  165,    0,    0,
    0,  166,  167, 1072,    0, 1073,    0,    0,    0,    0,
    0,    0,    0,    0,  168,    0,    0,    0,  170,  171,
  172,  173,  174,    0,  175,    0,    0,    0,    0,    0,
  176,    0,  177,  178, 1074,    0,  179,  180,    0,    0,
    0,    0,    0,  181,    0,    0,  182,  183,  184,  185,
 1075,  186,    0,  187,    0,  188,  189,  190,  191,  192,
    0,    0,    0,    0,  193,    0,  194,    0,    0,    0,
    0,    0, 1076,    0,    0,    0,    0,  195,    0,    0,
    0,    0,  196,  197,    0,  198,    0,    0,    0,  199,
    0,  200,  201,  202,  203,    0, 2300,    0,    0,    0,
    0,    0,    0,    0,  205,  206, 1077, 1078,    0,    0,
    0,    0,    0,    0,    0,  207,  208,    0,  209,  210,
  211,    0,    0, 1079,    0,  212,  213,    0,  214,  215,
    0,  216,    0,    0,  217,  218,    0,    0,    0,  219,
  220,    0,    0,    0,    0,  221,  222,  223,    0,  224,
  225,  226,    0,  227,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  228,  229,  230,  231,  232,  233,  234,
  235,  236,  237,  238,  239,  240,  241,  242,  243,  244,
  245,  246,  247,  248,    0,  249,  250,  251,  252,  253,
  254,    0,  255,  256,  257,  258,    0,  259,    0,  260,
  261,  262,  263,  264,  265,  266,  267,  268,  269,  270,
  271,  272,  273,  274,  275,  276,  277,    0,  278,  279,
  280,  281,    0,  282,  283,  284,  285,  286,    0,  287,
  288,  289,  290,  291,  292,  293,  294,  295,  296,  297,
  298,  299,    0,  300,  301,  302,  303,  304,  305,    0,
  306,  307,  308,  309,  310,  311,  312,  313,    0,  314,
  315,  316,  317,    0,  318,  319,  320,  321,  322,  323,
    0,    0,  324,  325,  326,  327,  328,  329,  330,  331,
  332,    0, 1080,    0,    0,    0,  333,    0,  334,  335,
  336,  337,  338,  339,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,    0,  141,  142,    0,    0, 1060,
    0,    0, 1061,    0,    0,    0,  143, 2750,    0,  145,
    0,  146,    0,    0,  147,    0,    0,  148, 1062,    0,
 1063,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,    0,  154,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  155,  156,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0, 1064,    0,
    0,  160,    0,  161, 1065, 1066, 1067,  162, 1068, 1069,
 1070,    0, 1071,    0,    0,  163,    0,    0,  164,    0,
  165,    0,    0,    0,  166,  167, 1072,    0, 1073,    0,
    0,    0,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,    0,
    0,    0,    0,  176,    0,  177,  178, 1074,    0,  179,
  180,    0,    0,    0,    0,    0,  181,    0,    0,  182,
  183,  184,  185, 1075,  186,    0,  187,    0,  188,  189,
  190,  191,  192,    0,    0,    0,    0,  193,    0,  194,
    0,    0,    0,    0,    0, 1076,    0,    0,    0,    0,
  195,    0,    0,    0,    0,  196,  197,    0,  198,    0,
    0,    0,  199,    0,  200,  201,  202,  203,    0,  204,
    0,    0,    0,    0,    0,    0,    0,  205,  206, 1077,
 1078,    0,    0,    0,    0,    0,    0,    0,  207,  208,
    0,  209,  210,  211,    0,    0, 1079,    0,  212,  213,
    0,  214,  215,    0,  216,    0,    0,  217,  218,    0,
    0,    0,  219,  220,    0,    0,    0,    0,  221,  222,
  223,    0,  224,  225,  226,    0,  227,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  228,  229,  230,  231,
  232,  233,  234,  235,  236,  237,  238,  239,  240,  241,
  242,  243,  244,  245,  246,  247,  248,    0,  249,  250,
  251,  252,  253,  254,    0,  255,  256,  257, 2751,    0,
  259,    0,  260,  261,  262,  263,  264,  265,  266,  267,
  268,  269,  270,  271,  272,  273,  274,  275,  276,  277,
    0,  278,  279,  280,  281,    0,  282,  283,  284,  285,
  286,    0,  287,  288,  289,  290,  291,  292,  293,  294,
  295,  296,  297,  298,  299,    0,  300,  301,  302,  303,
  304,  305,    0,  306,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  316,  317,    0,  318,  319,  320,
  321,  322,  323,    0,    0,  324,  325,  326,  327,  328,
  329,  330,  331,  332,    0, 1080,    0,    0,    0,  333,
    0,  334,  335,  336,  337,  338,  339,  138,    0,  139,
    0,    0,    0,    0,    0,  140,    0,    0,  141,  142,
    0,    0, 1060,    0,    0, 1061,    0,    0,    0,  143,
  144,    0,  145,    0,  146,    0,    0,  147,    0,    0,
  148, 1062,    0, 1063,    0,    0,    0,  149,    0,  150,
  151,    0,    0,    0,  152,    0,  153,    0,    0,  154,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  155,
  156,    0,    0,    0,  157,    0,  158,    0,  159,    0,
    0, 1064,    0,    0,  160,    0,  161, 1065, 1066, 1067,
  162, 1068, 1069, 1070,    0, 1071,    0,    0,  163,    0,
    0,  164,    0,  165,    0,    0,    0,  166,  167, 1072,
    0, 1073,    0,    0,    0,    0,    0,    0,    0,    0,
  168,    0,    0,    0,  170,  171,  172,  173,  174,    0,
  175,    0,    0,    0,    0,    0,  176,    0,  177,  178,
 1074,    0,  179,  180,    0,    0,    0,    0,    0,  181,
    0,    0,  182,  183,  184,  185, 1075,  186,    0,  187,
    0,  188,  189,  190,  191,  192,    0,    0,    0,    0,
  193,    0,  194,    0,    0,    0,    0,    0, 1076,    0,
    0,    0,    0,  195,    0,    0,    0,    0,  196,  197,
    0,  198,    0,    0,    0,  199,    0,  200,  201,  202,
  203,    0,  204,    0,    0,    0,    0,    0,    0,    0,
  205,  206, 1077, 1078,    0,    0,    0,    0,    0,    0,
    0,  207,  208,    0,  209,  210,  211,    0,    0, 1079,
    0,  212,  213,    0,  214,  215,    0,  216,    0,    0,
  217,  218,    0,    0,    0,  219,  220,    0,    0,    0,
    0,  221,  222,  223,    0,  224,  225,  226,    0,  227,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  228,
  229,  230,  231,  232,  233,  234,  235,  236,  237,  238,
  239,  240,  241,  242,  243,  244,  245,  246,  247,  248,
    0,  249,  250,  251,  252,  253,  254,    0,  255,  256,
  257,  258,    0,  259,    0,  260,  261,  262,  263,  264,
  265,  266,  267,  268,  269,  270,  271,  272,  273,  274,
  275,  276,  277,    0,  278,  279,  280,  281,    0,  282,
  283,  284,  285,  286,    0,  287,  288,  289,  290,  291,
  292,  293,  294,  295,  296,  297,  298,  299,    0,  300,
  301,  302,  303,  304,  305,    0,  306,  307,  308,  309,
  310,  311,  312,  313,    0,  314,  315,  316,  317,    0,
  318,  319,  320,  321,  322,  323,    0,    0,  324,  325,
  326,  327,  328,  329,  330,  331,  332,    0, 1080,    0,
    0,    0,  333,    0,  334,  335,  336,  337,  338,  339,
   44,    0,   44,   32,   32,    0,    0,    0,   44,    0,
    0,   44,   44,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   44,   44,    0,   44,    0,   44,    0,   32,
   44,    0,    0,   44,    0,    0,    0,    0,    0,   32,
   44,    0,   44,   44,   32,    0,    0,   44,    0,   44,
   32,    0,   44,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   44,   44,    0,    0,    0,   44,    0,   44,
    0,   44,    0,   32,    0,    0,    0,   44,    0,   44,
    0,    0,    0,   44,    0,    0,    0,    0,    0,    0,
    0,   44,    0,    0,   44,    0,   44,    0,    0,    0,
   44,   44,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   44,    0,    0,    0,   44,   44,   44,
   44,   44,    0,   44,    0,    0,    0,    0,    0,   44,
    0,   44,   44,    0,   32,   44,   44,    0,    0,    0,
    0,    0,   44,   32,    0,   44,   44,   44,   44,    0,
   44,    0,   44,    0,   44,   44,   44,   44,   44,    0,
    0,    0,    0,   44,    0,   44,    0,    0,   32,    0,
    0,    0,    0,    0,    0,    0,   44,    0,    0,    0,
    0,   44,   44,    0,   44,    0,    0,    0,   44,    0,
   44,   44,   44,   44,    0,   44,    0,    0,    0,    0,
    0,    0,    0,   44,   44,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   44,   44,    0,   44,   44,   44,
    0,    0,    0,    0,   44,   44,    0,   44,   44,    0,
   44,    0,    0,   44,   44,    0,    0,    0,   44,   44,
    0,    0,    0,    0,   44,   44,   44,    0,   44,   44,
   44,    0,   44,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   44,   44,   44,   44,   44,   44,   44,   44,
   44,   44,   44,   44,   44,   44,   44,   44,   44,   44,
   44,   44,   44,    0,   44,   44,   44,   44,   44,   44,
    0,   44,   44,   44,   44,    0,   44,    0,   44,   44,
   44,   44,   44,   44,   44,   44,   44,   44,   44,   44,
   44,   44,   44,   44,   44,   44,    0,   44,   44,   44,
   44,    0,   44,   44,   44,   44,   44,    0,   44,   44,
   44,   44,   44,   44,   44,   44,   44,   44,   44,   44,
   44,    0,   44,   44,   44,   44,   44,   44,    0,   44,
   44,   44,   44,   44,   44,   44,   44,    0,   44,   44,
   44,   44,    0,   44,   44,   44,   44,   44,   44,    0,
    0,   44,   44,   44,   44,   44,   44,   44,   44,   44,
    0,    0,    0,    0,    0,    0,    0,   44,   44,   44,
   44,   44,   44,  121,    0,  121,    0,  119,    0,    0,
    0,  121,    0,    0,  121,  121,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  121,  121,    0,  121,    0,
  121,    0,  119,  121,    0,    0,  121,    0,    0,    0,
    0,    0,  119,  121,    0,  121,  121,  119,    0,    0,
  121,    0,  121,  119,    0,  121,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  121,  121,    0,    0,    0,
  121,    0,  121,    0,  121,    0,  119,    0,    0,    0,
  121,    0,  121,    0,    0,    0,  121,    0,    0,    0,
    0,    0,    0,    0,  121,    0,    0,  121,    0,  121,
    0,    0,    0,  121,  121,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  121,    0,    0,    0,
  121,  121,  121,  121,  121,    0,  121,    0,    0,    0,
    0,    0,  121,    0,  121,  121,    0,  119,  121,  121,
    0,    0,    0,    0,    0,  121,  119,    0,  121,  121,
  121,  121,    0,  121,    0,  121,    0,  121,  121,  121,
  121,  121,    0,    0,    0,    0,  121,    0,  121,    0,
    0,  119,    0,    0,    0,    0,    0,    0,    0,  121,
    0,    0,    0,    0,  121,  121,    0,  121,    0,    0,
    0,  121,    0,  121,  121,  121,  121,    0,  121,    0,
    0,    0,    0,    0,    0,    0,  121,  121,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  121,  121,    0,
  121,  121,  121,    0,    0,    0,    0,  121,  121,    0,
  121,  121,    0,  121,    0,    0,  121,  121,    0,    0,
    0,  121,  121,    0,    0,    0,    0,  121,  121,  121,
    0,  121,  121,  121,    0,  121,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  121,  121,  121,  121,  121,
  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,
  121,  121,  121,  121,  121,  121,    0,  121,  121,  121,
  121,  121,  121,    0,  121,  121,  121,  121,    0,  121,
    0,  121,  121,  121,  121,  121,  121,  121,  121,  121,
  121,  121,  121,  121,  121,  121,  121,  121,  121,    0,
  121,  121,  121,  121,    0,  121,  121,  121,  121,  121,
    0,  121,  121,  121,  121,  121,  121,  121,  121,  121,
  121,  121,  121,  121,    0,  121,  121,  121,  121,  121,
  121,    0,  121,  121,  121,  121,  121,  121,  121,  121,
    0,  121,  121,  121,  121,    0,  121,  121,  121,  121,
  121,  121,    0,    0,  121,  121,  121,  121,  121,  121,
  121,  121,  121,    0,    0,    0,    0,    0,    0,    0,
  121,  121,  121,  121,  121,  121,  138,    0,  139,    0,
    0,    0,    0,    0,  140,    0,    0,  141,  142,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  143,  144,
    0,  145,    0,  146,    0,    0,  147,    0,    0,  148,
    0,    0,    0,    0,    0,    0,  149,    0,  150,  151,
    0,    0,    0,  152,    0,  153,    0,    0,  154,    0,
    0,    0,    0,    0,    0, 2880,    0,    0,  155,  156,
    0, 2881,    0,  157,    0,  158,    0,  159,    0,    0,
    0,    0,    0,  160,    0,  161,    0,    0,    0,  162,
    0,    0,    0,    0,    0,    0,    0,  163,    0,    0,
  164,    0,  165,    0,    0,    0,  166,  167,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  168,
    0,    0,    0,  170,  171,  172,  173,  174,    0,  175,
    0,    0,    0,    0,    0,  176, 2882,  177,  178,    0,
    0,  179,  180,    0,    0,    0,    0,    0,  181,    0,
    0,  182,  183,  184,  185,    0,  186,    0,  187,    0,
  188,  189,  190,  191,  192,    0,    0,    0,    0,  193,
 2883,  194,    0,    0,    0, 2884,    0,    0,    0,    0,
    0, 2885,  195,    0,    0,    0,    0,  196,  197,    0,
  198,    0,    0,    0,  199,    0,  200,  201,  202, 2886,
    0,  204,    0,    0,    0,    0,    0,    0,    0,  205,
  206,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  207,  208,    0,  209,  210,  211,    0,    0,    0,    0,
  212,  213,    0,  214,  215,    0,  216,    0,    0,  217,
  218,    0,    0,    0,  219,  220,    0,    0,    0,    0,
  221,  222,  223,    0,  224,  225,  226,    0,  227,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  228,  229,
  230,  231,  232,  233,  234,  235,  236,  237,  238,  239,
  240,  241,  242,  243,  244,  245,  246,  247,  248,    0,
  249,  250,  251,  252,  253,  254,    0,  255,  256,  257,
  258,    0,  259,    0,  260,  261,  262,  263,  264,  265,
  266,  267,  268,  269,  270,  271,  272,  273,  274,  275,
  276,  277,    0,  278,  279,  280,  281,    0,  282,  283,
  284,  285,  286,    0,  287,  288,  289,  290,  291,  292,
  293,  294,  295,  296,  297,  298,  299,    0,  300,  301,
  302,  303,  304,  305,    0,  306,  307,  308,  309,  310,
  311,  312,  313,    0, 2887,  315,  316,  317,    0,  318,
  319,  320,  321,  322,  323,    0,    0,  324,  325,  326,
  327,  328,  329,  330,  331,  332,    0,    0,    0,    0,
    0,  333,    0,  334,  335,  336,  337,  338,  339,  138,
    0,  139,    0,    0,    0,    0,    0,  140,    0,    0,
  141,  142,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  143,  144,    0,  145,    0,  146,    0,    0,  147,
    0,    0,  148,    0,    0,    0,    0,    0,    0,  149,
    0,  150,  151,    0,    0,    0,  152,    0,  153,    0,
    0,  154,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  155,  156,    0,    0,    0,  157,    0,  158,    0,
  159, 3005,    0,    0,    0,    0,  160,    0,  161,    0,
    0,    0,  162,    0,    0,    0,    0,    0,    0,    0,
  163,    0,    0,  164,    0,  165,    0,    0,    0,  166,
  167,    0, 3006,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  168,    0, 3007,    0,  170,  171,  172,  173,
  174,    0,  175,    0,    0,    0,    0,    0,  176,    0,
  177,  178,    0,    0,  179,  180,    0,    0,    0,    0,
    0,  181,    0,    0,  182,  183,  184,  185,    0,  186,
    0,  187,    0,  188,  189,  190,  191,  192,    0,    0,
    0,    0,  193,    0,  194,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  195,    0,    0,    0,    0,
  196,  197,    0,  198,    0,    0,    0,  199,    0,  200,
  201,  202,  203,    0,  204,    0,    0,    0,    0,    0,
    0,    0,  205,  206,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  207,  208,    0,  209,  210,  211,    0,
    0,    0,    0,  212,  213,    0,  214,  215,    0,  216,
    0,    0,  217,  218,    0,    0,    0,  219,  220,    0,
    0,    0,    0,  221,  222,  223,    0,  224,  225,  226,
    0,  227,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  228,  229,  230,  231,  232,  233,  234,  235,  236,
  237,  238,  239,  240,  241,  242,  243,  244,  245,  246,
  247,  248,    0,  249,  250,  251,  252,  253,  254,    0,
  255,  256,  257,  258,    0,  259,    0,  260,  261,  262,
  263,  264,  265,  266,  267,  268,  269,  270,  271,  272,
  273,  274,  275,  276,  277,    0,  278,  279,  280,  281,
    0,  282,  283,  284,  285,  286,    0,  287,  288,  289,
  290,  291,  292,  293,  294,  295,  296,  297,  298,  299,
    0,  300,  301,  302,  303,  304,  305,    0,  306,  307,
  308,  309,  310,  311,  312,  313,    0,  314,  315,  316,
  317,    0,  318,  319,  320,  321,  322,  323,    0,    0,
  324,  325,  326,  327,  328,  329,  330,  331,  332,    0,
    0,    0,    0,    0,  333,    0,  334,  335,  336,  337,
  338,  339,  138,    0,  139,    0,    0,    0, 3106,    0,
  140,    0,    0,  141,  142,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  143,  144,    0,  145,    0,  146,
    0,    0,  147,    0,    0,  148,    0,    0,    0,    0,
    0,    0,  149,    0,  150,  151,    0,    0,    0,  152,
    0,  153,    0,    0,  154,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  155,  156,    0, 3107,    0,  157,
    0,  158,    0,  159,    0,    0,    0,    0,    0,  160,
    0,  161,    0,    0,    0,  162,    0,    0,    0,    0,
    0,    0,    0,  163,    0,    0,  164,    0,  165,    0,
    0,    0,  166,  167,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  168,    0,    0,    0,  170,
  171,  172,  173,  174,    0,  175,    0,    0,    0,    0,
    0,  176,    0,  177,  178,    0,    0,  179,  180,    0,
    0,    0,    0,    0,  181,    0,    0,  182,  183,  184,
  185,    0,  186,    0,  187,    0,  188,  189,  190,  191,
  192,    0,    0,    0,    0,  193,    0,  194,    0,    0,
    0, 3108,    0,    0,    0,    0,    0,    0,  195,    0,
    0,    0,    0,  196,  197,    0,  198,    0,    0,    0,
  199,    0,  200,  201,  202,  203,    0,  204,    0,    0,
    0,    0,    0,    0,    0,  205,  206,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  207,  208,    0,  209,
  210,  211,    0,    0,    0,    0,  212,  213,    0,  214,
  215,    0,  216,    0,    0,  217,  218,    0,    0,    0,
  219,  220,    0,    0,    0,    0,  221,  222,  223,    0,
  224,  225,  226,    0,  227,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  228,  229,  230,  231,  232,  233,
  234,  235,  236,  237,  238,  239,  240,  241,  242,  243,
  244,  245,  246,  247,  248,    0,  249,  250,  251,  252,
  253,  254,    0,  255,  256,  257,  258,    0,  259,    0,
  260,  261,  262,  263,  264,  265,  266,  267,  268,  269,
  270,  271,  272,  273,  274,  275,  276,  277,    0,  278,
  279,  280,  281,    0,  282,  283,  284,  285,  286,    0,
  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,
  297,  298,  299,    0,  300,  301,  302,  303,  304,  305,
    0,  306,  307,  308,  309,  310,  311,  312,  313,    0,
  314,  315,  316,  317,    0,  318,  319,  320,  321,  322,
  323,    0,    0,  324,  325,  326,  327,  328,  329,  330,
  331,  332,    0,    0,    0,    0,    0,  333,    0,  334,
  335,  336,  337,  338,  339,  138,    0,  139,    0,    0,
    0,    0,    0,  140,    0,    0,  141,  142,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  143,  144,    0,
  145,    0,  146,    0,    0,  147,    0,    0,  148,    0,
  746,    0,    0,    0,    0,  149,    0,  150,  151,    0,
    0,    0,  152,    0,  153,    0,    0,  154,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  155,  156,    0,
    0,    0,  157,    0,  158,    0,  159,    0,    0,    0,
    0,    0,  160,    0,  161,    0,    0,    0,  162,    0,
    0,    0,    0,    0,    0,    0,  163,    0,    0,  164,
    0,  165,    0,    0,    0,  166,  167,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  168,    0,
    0,    0,  170,  171,  172,  173,  174,    0,  175,    0,
    0,    0,    0,    0,  176,    0,  177,  178,    0,    0,
  179,  180,    0,    0,    0,    0,    0,  181,    0,    0,
  182,  183,  184,  185,    0,  186,    0,  187,    0,  188,
  189,  190,  191,  192,    0,    0,    0,    0,  193,    0,
  194,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  195,    0,    0,    0,    0,  196,  197,    0,  198,
    0,    0,    0,  199,    0,  200,  201,  202,  203,    0,
  204,    0,    0,    0,    0,    0,    0,    0,  205,  206,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  207,
  208,    0,  209,  210,  211,    0,    0,    0,    0,  212,
  213,    0,  214,  215,    0,  216,    0,    0,  217,  218,
    0,    0,    0,  219,  220,    0,    0,    0,    0,  221,
  222,  223,    0,  224,  225,  226,    0,  227,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  228,  229,  230,
  231,  232,  233,  234,  235,  236,  237,  238,  239,  240,
  241,  242,  243,  244,  245,  246,  247,  248,    0,  249,
  250,  251,  252,  253,  254,    0,  255,  256,  257,  258,
    0,  259,    0,  260,  261,  262,  263,  264,  265,  266,
  267,  268,  269,  270,  271,  272,  273,  274,  275,  276,
  277,    0,  278,  279,  280,  281,    0,  282,  283,  284,
  285,  286,    0,  287,  288,  289,  290,  291,  292,  293,
  294,  295,  296,  297,  298,  299,    0,  300,  301,  302,
  303,  304,  305,    0,  306,  307,  308,  309,  310,  311,
  312,  313,    0,  314,  315,  316,  317,    0,  318,  319,
  320,  321,  322,  323,    0,    0,  324,  325,  326,  327,
  328,  329,  330,  331,  332,    0,    0,    0,    0,    0,
  333,  860,  334,  335,  336,  337,  338,  339,  138,    0,
  139,    0,    0,    0,    0,    0,  140,    0,    0,  141,
  142,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  143,  144,    0,  145,    0,  146,    0,    0,  147,    0,
    0,  148,    0,    0,    0,    0,    0,    0,  149,    0,
  150,  151,    0,    0,    0,  152,    0,  153,    0,    0,
  154,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  155,  156,    0,    0,    0,  157,    0,  158,    0,  159,
    0,    0,    0,    0,    0,  160,    0,  161,    0,    0,
    0,  162,    0,    0,    0,    0,    0,    0,    0,  163,
    0,    0,  164,    0,  165,    0,    0,    0,  166,  167,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  168,    0,    0,    0,  170,  171,  172,  173,  174,
    0,  175,    0,    0,    0,    0,    0,  176,    0,  177,
  178,    0,    0,  179,  180,    0,    0,    0,    0,    0,
  181,    0,    0,  182,  183,  184,  185,    0,  186,    0,
  187,    0,  188,  189,  190,  191,  192,    0,    0,    0,
    0,  193,    0,  194,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  195,    0,    0,    0,    0,  196,
  197,    0,  198,    0,  508,  509,  199,    0,  200,  201,
  202,  203,    0,  204,    0,    0,    0,    0,    0,    0,
    0,  205,  206,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  207,  208,    0,  209,  210,  211,    0,    0,
    0,    0,  212,  213,    0,  214,  215,    0,  216,    0,
    0,  217,  218,    0,    0,    0,  219,  220,    0,    0,
    0,    0,  221,  222,  223,    0,  224,  225,  226,    0,
  227,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  228,  229,  230,  231,  232,  233,  234,  235,  236,  237,
  238,  239,  240,  241,  242,  243,  244,  245,  246,  247,
  248,    0,  249,  250,  251,  252,  253,  254,    0,  255,
  256,  257,  258,    0,  259,    0,  260,  261,  262,  263,
  264,  265,  266,  267,  268,  269,  270,  271,  272,  273,
  274,  275,  276,  277,    0,  278,  279,  280,  281,    0,
  282,  283,  284,  285,  286,    0,  287,  288,  289,  290,
  291,  292,  293,  294,  295,  296,  297,  298,  299,    0,
  300,  301,  302,  303,  304,  305,    0,  306,  307,  308,
  309,  310,  311,  312,  313,    0,  314,  315,  316,  317,
    0,  318,  319,  320,  321,  322,  323,    0,    0,  324,
  325,  326,  327,  328,  329,  330,  331,  332,    0,    0,
    0,    0,    0,  333,    0,  334,  335,  336,  337,  338,
  339,  138,    0,  139,    0,    0,    0,    0,    0,  140,
    0,    0,  141,  142,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  143,  144,    0,  145,    0,  146,    0,
    0,  147,    0,    0,  148,    0,    0,    0,    0,    0,
    0,  149,    0,  150,  151,    0,    0,    0,  152,    0,
  153,    0,    0,  154,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  155,  156,    0,    0,    0,  157,    0,
  158,    0,  159,    0,    0,    0,    0,    0,  160, 1471,
  161,    0,    0,    0,  162,    0,    0,    0,    0,    0,
    0,    0,  163,    0,    0,  164,    0,  165,    0, 1472,
    0,  166,  167,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  168,    0,    0,    0,  170,  171,
  172,  173,  174,    0,  175,    0,    0,    0,    0,    0,
  176,    0,  177,  178,    0,    0,  179,  180,    0,    0,
    0,    0,    0,  181,    0,    0,  182,  183,  184,  185,
    0,  186,    0, 2833,    0,  188,  189,  190,  191,  192,
    0,    0,    0,    0,  193,    0,  194,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  195,    0,    0,
    0,    0,  196,  197,    0,  198,    0,    0,    0,  199,
    0,  200,  201,  202,  203,    0,  204,    0,    0,    0,
    0,    0,    0,    0,  205,  206,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  207,  208,    0,  209,  210,
  211,    0,    0,    0,    0,  212,  213,    0,  214,  215,
    0,  216,    0,    0,  217,  218,    0,    0,    0,  219,
  220,    0,    0,    0,    0,  221,  222,  223,    0,  224,
  225,  226,    0,  227,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  228,  229,  230,  231,  232,  233,  234,
  235,  236,  237,  238,  239,  240,  241,  242,  243,  244,
  245,  246,  247,  248,    0,  249,  250,  251,  252,  253,
  254,    0,  255,  256,  257,  258,    0, 2834,    0,  260,
  261,  262,  263,  264,  265,  266,  267,  268,  269,  270,
  271,  272,  273,  274,  275,  276,  277,    0,  278,  279,
  280,  281,    0,  282,  283,  284,  285,  286,    0,  287,
  288,  289,  290,  291,  292,  293,  294,  295,  296,  297,
  298,  299,    0,  300,  301,  302,  303,  304,  305,    0,
  306,  307,  308,  309,  310,  311,  312,  313,    0,  314,
  315,  316,  317,    0,  318,  319,  320,  321,  322,  323,
    0,    0,  324,  325,  326,  327,  328,  329,  330,  331,
  332,    0,    0,    0,    0,    0,  333,    0,  334,  335,
  336,  337,  338,  339,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,    0,  141,  142,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,    0,    0,  147,    0,    0,  148,    0,    0,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,    0,  154,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  155,  156,    0, 3107,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,    0,    0,    0,    0,  163,    0,    0,  164,    0,
  165,    0,    0,    0,  166,  167,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,    0,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,    0,    0,  181,    0,    0,  182,
  183,  184,  185,    0,  186,    0,  187,    0,  188,  189,
  190,  191,  192,    0,    0,    0,    0,  193,    0,  194,
    0,    0,    0, 3108,    0,    0,    0,    0,    0,    0,
  195,    0,    0,    0,    0,  196,  197,    0,  198,    0,
    0,    0,  199,    0,  200,  201,  202,  203,    0,  204,
    0,    0,    0,    0,    0,    0,    0,  205,  206,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  207,  208,
    0,  209,  210,  211,    0,    0,    0,    0,  212,  213,
    0,  214,  215,    0,  216,    0,    0,  217,  218,    0,
    0,    0,  219,  220,    0,    0,    0,    0,  221,  222,
  223,    0,  224,  225,  226,    0,  227,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  228,  229,  230,  231,
  232,  233,  234,  235,  236,  237,  238,  239,  240,  241,
  242,  243,  244,  245,  246,  247,  248,    0,  249,  250,
  251,  252,  253,  254,    0,  255,  256,  257,  258,    0,
  259,    0,  260,  261,  262,  263,  264,  265,  266,  267,
  268,  269,  270,  271,  272,  273,  274,  275,  276,  277,
    0,  278,  279,  280,  281,    0,  282,  283,  284,  285,
  286,    0,  287,  288,  289,  290,  291,  292,  293,  294,
  295,  296,  297,  298,  299,    0,  300,  301,  302,  303,
  304,  305,    0,  306,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  316,  317,    0,  318,  319,  320,
  321,  322,  323,    0,    0,  324,  325,  326,  327,  328,
  329,  330,  331,  332,    0,    0,    0,    0,    0,  333,
    0,  334,  335,  336,  337,  338,  339,  138,    0,  139,
    0,    0,    0,    0,    0,  140,    0,    0,  141,  142,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  143,
  144,    0,  145,    0,  146,    0,    0,  147,    0,    0,
  148,    0,    0,    0,    0,    0,    0,  149,    0,  150,
  151,    0,    0,    0,  152,    0,  153,    0,    0,  154,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  155,
  156,    0,    0,    0,  157,    0,  158,    0,  159,    0,
    0,    0,    0,    0,  160,    0,  161,    0,    0,    0,
  162,    0,    0,    0,    0,    0,    0,    0,  163,    0,
    0,  164,    0,  165,    0,    0,    0,  166,  167,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  168,  169,    0,    0,  170,  171,  172,  173,  174,    0,
  175,    0,    0,    0,    0,    0,  176,    0,  177,  178,
    0,    0,  179,  180,    0,    0,    0,    0,    0,  181,
    0,    0,  182,  183,  184,  185,    0,  186,    0,  187,
    0,  188,  189,  190,  191,  192,    0,    0,    0,    0,
  193,    0,  194,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  195,    0,    0,    0,    0,  196,  197,
    0,  198,    0,    0,    0,  199,    0,  200,  201,  202,
  203,    0,  204,    0,    0,    0,    0,    0,    0,    0,
  205,  206,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  207,  208,    0,  209,  210,  211,    0,    0,    0,
    0,  212,  213,    0,  214,  215,    0,  216,    0,    0,
  217,  218,    0,    0,    0,  219,  220,    0,    0,    0,
    0,  221,  222,  223,    0,  224,  225,  226,    0,  227,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  228,
  229,  230,  231,  232,  233,  234,  235,  236,  237,  238,
  239,  240,  241,  242,  243,  244,  245,  246,  247,  248,
    0,  249,  250,  251,  252,  253,  254,    0,  255,  256,
  257,  258,    0,  259,    0,  260,  261,  262,  263,  264,
  265,  266,  267,  268,  269,  270,  271,  272,  273,  274,
  275,  276,  277,    0,  278,  279,  280,  281,    0,  282,
  283,  284,  285,  286,    0,  287,  288,  289,  290,  291,
  292,  293,  294,  295,  296,  297,  298,  299,    0,  300,
  301,  302,  303,  304,  305,    0,  306,  307,  308,  309,
  310,  311,  312,  313,    0,  314,  315,  316,  317,    0,
  318,  319,  320,  321,  322,  323,    0,    0,  324,  325,
  326,  327,  328,  329,  330,  331,  332,    0,    0,    0,
    0,    0,  333,    0,  334,  335,  336,  337,  338,  339,
  138,    0,  139,    0,    0,    0,    0,    0,  140,    0,
    0,  141,  142,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  143,  144,    0,  145,    0,  146,    0,    0,
  147,    0,    0,  148,    0,    0,    0,    0,    0,    0,
  149,    0,  150,  151,    0,    0,    0,  152,    0,  153,
    0,    0,  154,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  155,  156,    0,    0,    0,  157,    0,  158,
    0,  159,    0,    0,    0,    0,    0,  160,    0,  161,
    0,    0,    0,  162,    0,    0,    0,    0,    0,    0,
    0,  163,    0,    0,  164,    0,  165,    0,    0,    0,
  166,  167,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  168,    0,    0,    0,  170,  171,  172,
  173,  174,    0,  175,    0,    0,    0,    0,    0,  176,
    0,  177,  178,    0,    0,  179,  180,    0,    0,    0,
    0,    0,  181,    0,    0,  182,  183,  184,  185,    0,
  186,    0,  187,    0,  188,  189,  190,  191,  192,    0,
    0,    0,    0,  193,    0,  194,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  195,    0,    0,    0,
    0,  196,  197,    0,  198,    0,    0,    0,  199,    0,
  200,  201,  202,  203,    0,  204,    0,    0,    0,    0,
    0,    0,    0,  205,  206,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  207,  208,    0,  209,  210,  211,
    0,    0,    0,    0,  212,  213,    0,  214,  215,    0,
  216,    0,    0,  217,  218,    0,    0,    0,  219,  220,
    0,    0,    0,    0,  221,  222,  223,    0,  224,  225,
  226,    0,  227,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  228,  229,  230,  231,  232,  233,  234,  235,
  236,  237,  238,  239,  240,  241,  242,  243,  244,  245,
  246,  247,  248,    0,  249,  250,  251,  252,  253,  254,
    0,  255,  256,  257,  258,    0,  259,    0,  260,  261,
  262,  263,  264,  265,  266,  267,  268,  269,  270,  271,
  272,  273,  274,  275,  276,  277,  345,  278,  279,  280,
  281,    0,  282,  283,  284,  285,  286,    0,  287,  288,
  289,  290,  291,  292,  293,  294,  295,  296,  297,  298,
  299,    0,  300,  301,  302,  303,  304,  305,    0,  306,
  307,  308,  309,  310,  311,  312,  313,    0,  314,  315,
  316,  317,    0,  318,  319,  320,  321,  322,  323,    0,
    0,  324,  325,  326,  327,  328,  329,  330,  331,  332,
    0,    0,    0,    0,    0,  333,    0,  334,  335,  336,
  337,  338,  339,  138,    0,  139,    0,    0,    0,    0,
    0,  140,    0,    0,  141,  142,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  143,  144,    0,  145, 2196,
  146,    0,    0,  147,    0,    0,  148,    0,    0,    0,
    0,    0,    0,  149,    0,  150,  151,    0,    0,    0,
  152,    0,  153,    0,    0,  154,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  155,  156,    0,    0,    0,
  157,    0,  158,    0,  159,    0,    0,    0,    0,    0,
  160,    0,  161,    0,    0,    0,  162,    0,    0,    0,
    0,    0,    0,    0,  163,    0,    0,  164,    0,  165,
    0,    0,    0,  166,  167,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  168,    0,    0,    0,
  170,  171,  172,  173,  174,    0,  175,    0,    0,    0,
    0,    0,  176,    0,  177,  178,    0,    0,  179,  180,
    0,    0,    0,    0,    0,  181,    0,    0,  182,  183,
  184,  185,    0,  186,    0,  187,    0,  188,  189,  190,
  191,  192,    0,    0,    0,    0,  193,    0,  194,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  195,
    0,    0,    0,    0,  196,  197,    0,  198,    0,    0,
    0,  199,    0,  200,  201,  202,  203,    0,  204,    0,
    0,    0,    0,    0,    0,    0,  205,  206,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  207,  208,    0,
  209,  210,  211,    0,    0,    0,    0,  212,  213,    0,
  214,  215,    0,  216,    0,    0,  217,  218,    0,    0,
    0,  219,  220,    0,    0,    0,    0,  221,  222,  223,
    0,  224,  225,  226,    0,  227,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  228,  229,  230,  231,  232,
  233,  234,  235,  236,  237,  238,  239,  240,  241,  242,
  243,  244,  245,  246,  247,  248,    0,  249,  250,  251,
  252,  253,  254,    0,  255,  256,  257,  258,    0,  259,
    0,  260,  261,  262,  263,  264,  265,  266,  267,  268,
  269,  270,  271,  272,  273,  274,  275,  276,  277,    0,
  278,  279,  280,  281,    0,  282,  283,  284,  285,  286,
    0,  287,  288,  289,  290,  291,  292,  293,  294,  295,
  296,  297,  298,  299,    0,  300,  301,  302,  303,  304,
  305,    0,  306,  307,  308,  309,  310,  311,  312,  313,
    0,  314,  315,  316,  317,    0,  318,  319,  320,  321,
  322,  323,    0,    0,  324,  325,  326,  327,  328,  329,
  330,  331,  332,    0,    0,    0,    0,    0,  333,    0,
  334,  335,  336,  337,  338,  339,  138,    0,  139,    0,
    0,    0,    0,    0,  140,    0,    0,  141,  142,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  143,  144,
    0,  145, 2487,  146,    0,    0,  147,    0,    0,  148,
    0,    0,    0,    0,    0,    0,  149,    0,  150,  151,
    0,    0,    0,  152,    0,  153,    0,    0,  154,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  155,  156,
    0,    0,    0,  157,    0,  158,    0,  159,    0,    0,
    0,    0,    0,  160,    0,  161,    0,    0,    0,  162,
    0,    0,    0,    0,    0,    0,    0,  163,    0,    0,
  164,    0,  165,    0,    0,    0,  166,  167,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  168,
    0,    0,    0,  170,  171,  172,  173,  174,    0,  175,
    0,    0,    0,    0,    0,  176,    0,  177,  178,    0,
    0,  179,  180,    0,    0,    0,    0,    0,  181,    0,
    0,  182,  183,  184,  185,    0,  186,    0,  187,    0,
  188,  189,  190,  191,  192,    0,    0,    0,    0,  193,
    0,  194,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  195,    0,    0,    0,    0,  196,  197,    0,
  198,    0,    0,    0,  199,    0,  200,  201,  202,  203,
    0,  204,    0,    0,    0,    0,    0,    0,    0,  205,
  206,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  207,  208,    0,  209,  210,  211,    0,    0,    0,    0,
  212,  213,    0,  214,  215,    0,  216,    0,    0,  217,
  218,    0,    0,    0,  219,  220,    0,    0,    0,    0,
  221,  222,  223,    0,  224,  225,  226,    0,  227,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  228,  229,
  230,  231,  232,  233,  234,  235,  236,  237,  238,  239,
  240,  241,  242,  243,  244,  245,  246,  247,  248,    0,
  249,  250,  251,  252,  253,  254,    0,  255,  256,  257,
  258,    0,  259,    0,  260,  261,  262,  263,  264,  265,
  266,  267,  268,  269,  270,  271,  272,  273,  274,  275,
  276,  277,    0,  278,  279,  280,  281,    0,  282,  283,
  284,  285,  286,    0,  287,  288,  289,  290,  291,  292,
  293,  294,  295,  296,  297,  298,  299,    0,  300,  301,
  302,  303,  304,  305,    0,  306,  307,  308,  309,  310,
  311,  312,  313,    0,  314,  315,  316,  317,    0,  318,
  319,  320,  321,  322,  323,    0,    0,  324,  325,  326,
  327,  328,  329,  330,  331,  332,    0,    0,    0,    0,
    0,  333,    0,  334,  335,  336,  337,  338,  339,  138,
    0,  139,    0,    0,    0,    0,    0,  140,    0,    0,
  141,  142,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  143,  144,    0,  145,    0,  146,    0,    0,  147,
    0,    0,  148,    0,    0,    0,    0,    0,    0,  149,
    0,  150,  151,    0,    0,    0,  152,    0,  153,    0,
    0,  154, 2574,    0,    0,    0,    0,    0,    0,    0,
    0,  155,  156,    0,    0,    0,  157,    0,  158,    0,
  159,    0,    0,    0,    0,    0,  160,    0,  161,    0,
    0,    0,  162,    0,    0,    0,    0,    0,    0,    0,
  163,    0,    0,  164,    0,  165,    0,    0,    0,  166,
  167,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  168,    0,    0,    0,  170,  171,  172,  173,
  174,    0,  175,    0,    0,    0,    0,    0,  176,    0,
  177,  178,    0,    0,  179,  180,    0,    0,    0,    0,
    0,  181,    0,    0,  182,  183,  184,  185,    0,  186,
    0,  187,    0,  188,  189,  190,  191,  192,    0,    0,
    0,    0,  193,    0,  194,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  195,    0,    0,    0,    0,
  196,  197,    0,  198,    0,    0,    0,  199,    0,  200,
  201,  202,  203,    0,  204,    0,    0,    0,    0,    0,
    0,    0,  205,  206,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  207,  208,    0,  209,  210,  211,    0,
    0,    0,    0,  212,  213,    0,  214,  215,    0,  216,
    0,    0,  217,  218,    0,    0,    0,  219,  220,    0,
    0,    0,    0,  221,  222,  223,    0,  224,  225,  226,
    0,  227,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  228,  229,  230,  231,  232,  233,  234,  235,  236,
  237,  238,  239,  240,  241,  242,  243,  244,  245,  246,
  247,  248,    0,  249,  250,  251,  252,  253,  254,    0,
  255,  256,  257,  258,    0,  259,    0,  260,  261,  262,
  263,  264,  265,  266,  267,  268,  269,  270,  271,  272,
  273,  274,  275,  276,  277,    0,  278,  279,  280,  281,
    0,  282,  283,  284,  285,  286,    0,  287,  288,  289,
  290,  291,  292,  293,  294,  295,  296,  297,  298,  299,
    0,  300,  301,  302,  303,  304,  305,    0,  306,  307,
  308,  309,  310,  311,  312,  313,    0,  314,  315,  316,
  317,    0,  318,  319,  320,  321,  322,  323,    0,    0,
  324,  325,  326,  327,  328,  329,  330,  331,  332,    0,
    0,    0,    0,    0,  333,    0,  334,  335,  336,  337,
  338,  339,  138,    0,  139,    0,    0,    0,    0,    0,
  140,    0,    0,  141,  142,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  143,  144,    0,  145,    0,  146,
    0,    0,  147,    0,    0,  148,    0,    0,    0,    0,
    0,    0,  149,    0,  150,  151,    0,    0,    0,  152,
    0,  153,    0,    0,  154,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  155,  156,    0,    0,    0,  157,
    0,  158,    0,  159,    0,    0,    0,    0,    0,  160,
    0,  161,    0,    0,    0,  162,    0,    0,    0,    0,
    0,    0,    0,  163,    0,    0,  164,    0,  165,    0,
    0,    0,  166,  167,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  168,    0,    0,    0,  170,
  171,  172,  173,  174,    0,  175,    0,    0,    0,    0,
    0,  176,    0,  177,  178,    0,    0,  179,  180,    0,
    0,    0,    0,    0,  181,    0,    0,  182,  183,  184,
  185,    0,  186,    0,  187,    0,  188,  189,  190,  191,
  192,    0,    0,    0,    0,  193,    0,  194,    0,    0,
    0, 2673,    0,    0,    0,    0,    0,    0,  195,    0,
    0,    0,    0,  196,  197,    0,  198,    0,    0,    0,
  199,    0,  200,  201,  202,  203,    0,  204,    0,    0,
    0,    0,    0,    0,    0,  205,  206,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  207,  208,    0,  209,
  210,  211,    0,    0,    0,    0,  212,  213,    0,  214,
  215,    0,  216,    0,    0,  217,  218,    0,    0,    0,
  219,  220,    0,    0,    0,    0,  221,  222,  223,    0,
  224,  225,  226,    0,  227,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  228,  229,  230,  231,  232,  233,
  234,  235,  236,  237,  238,  239,  240,  241,  242,  243,
  244,  245,  246,  247,  248,    0,  249,  250,  251,  252,
  253,  254,    0,  255,  256,  257,  258,    0,  259,    0,
  260,  261,  262,  263,  264,  265,  266,  267,  268,  269,
  270,  271,  272,  273,  274,  275,  276,  277,    0,  278,
  279,  280,  281,    0,  282,  283,  284,  285,  286,    0,
  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,
  297,  298,  299,    0,  300,  301,  302,  303,  304,  305,
    0,  306,  307,  308,  309,  310,  311,  312,  313,    0,
  314,  315,  316,  317,    0,  318,  319,  320,  321,  322,
  323,    0,    0,  324,  325,  326,  327,  328,  329,  330,
  331,  332,    0,    0,    0,    0,    0,  333,    0,  334,
  335,  336,  337,  338,  339,  138,    0,  139,    0,    0,
    0,    0,    0,  140,    0,    0,  141,  142,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  143,  144,    0,
  145,    0,  146,    0,    0,  147,    0,    0,  148,    0,
    0,    0,    0,    0,    0,  149,    0,  150,  151,    0,
    0,    0,  152,    0,  153,    0,    0,  154,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  155,  156,    0,
    0,    0,  157,    0,  158,    0,  159,    0,    0,    0,
    0,    0,  160,    0,  161,    0,    0,    0,  162,    0,
    0,    0,    0,    0,    0,    0,  163,    0,    0,  164,
    0,  165,    0,    0,    0,  166,  167,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  168,    0,
    0,    0,  170,  171,  172,  173,  174,    0,  175,    0,
    0,    0,    0,    0,  176,    0,  177,  178,    0,    0,
  179,  180,    0,    0,    0,    0,    0,  181,    0,    0,
  182,  183,  184,  185,    0,  186,    0,  187,    0,  188,
  189,  190,  191,  192,    0,    0,    0,    0,  193,    0,
  194,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  195,    0,    0,    0,    0,  196,  197,    0,  198,
    0,    0,    0,  199,    0,  200,  201,  202,  203, 2723,
  204,    0,    0,    0,    0,    0,    0,    0,  205,  206,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  207,
  208,    0,  209,  210,  211,    0,    0,    0,    0,  212,
  213,    0,  214,  215,    0,  216,    0,    0,  217,  218,
    0,    0,    0,  219,  220,    0,    0,    0,    0,  221,
  222,  223,    0,  224,  225,  226,    0,  227,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  228,  229,  230,
  231,  232,  233,  234,  235,  236,  237,  238,  239,  240,
  241,  242,  243,  244,  245,  246,  247,  248,    0,  249,
  250,  251,  252,  253,  254,    0,  255,  256,  257,  258,
    0,  259,    0,  260,  261,  262,  263,  264,  265,  266,
  267,  268,  269,  270,  271,  272,  273,  274,  275,  276,
  277,    0,  278,  279,  280,  281,    0,  282,  283,  284,
  285,  286,    0,  287,  288,  289,  290,  291,  292,  293,
  294,  295,  296,  297,  298,  299,    0,  300,  301,  302,
  303,  304,  305,    0,  306,  307,  308,  309,  310,  311,
  312,  313,    0,  314,  315,  316,  317,    0,  318,  319,
  320,  321,  322,  323,    0,    0,  324,  325,  326,  327,
  328,  329,  330,  331,  332,    0,    0,    0,    0,    0,
  333,    0,  334,  335,  336,  337,  338,  339,  138,    0,
  139,    0,    0,    0,    0,    0,  140,    0,    0,  141,
  142,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  143,  144,    0,  145,    0,  146,    0,    0,  147,    0,
    0,  148,    0,    0,    0,    0,    0,    0,  149,    0,
  150,  151,    0,    0,    0,  152,    0,  153,    0,    0,
  154,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  155,  156,    0,    0,    0,  157,    0,  158,    0,  159,
    0,    0,    0,    0,    0,  160,    0,  161,    0,    0,
    0,  162,    0,    0,    0,    0,    0,    0,    0,  163,
    0,    0,  164,    0,  165,    0,    0,    0,  166,  167,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  168,    0,    0,    0,  170,  171,  172,  173,  174,
    0,  175,    0,    0,    0,    0,    0,  176,    0,  177,
  178,    0,    0,  179,  180,    0,    0,    0,    0,    0,
  181,    0,    0,  182,  183,  184,  185,    0,  186,    0,
  187,    0,  188,  189,  190,  191,  192,    0,    0,    0,
    0,  193,    0,  194,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  195,    0,    0,    0,    0,  196,
  197,    0,  198,    0,    0,    0,  199,    0,  200,  201,
  202,  203, 2840,  204,    0,    0,    0,    0,    0,    0,
    0,  205,  206,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  207,  208,    0,  209,  210,  211,    0,    0,
    0,    0,  212,  213,    0,  214,  215,    0,  216,    0,
    0,  217,  218,    0,    0,    0,  219,  220,    0,    0,
    0,    0,  221,  222,  223,    0,  224,  225,  226,    0,
  227,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  228,  229,  230,  231,  232,  233,  234,  235,  236,  237,
  238,  239,  240,  241,  242,  243,  244,  245,  246,  247,
  248,    0,  249,  250,  251,  252,  253,  254,    0,  255,
  256,  257,  258,    0,  259,    0,  260,  261,  262,  263,
  264,  265,  266,  267,  268,  269,  270,  271,  272,  273,
  274,  275,  276,  277,    0,  278,  279,  280,  281,    0,
  282,  283,  284,  285,  286,    0,  287,  288,  289,  290,
  291,  292,  293,  294,  295,  296,  297,  298,  299,    0,
  300,  301,  302,  303,  304,  305,    0,  306,  307,  308,
  309,  310,  311,  312,  313,    0,  314,  315,  316,  317,
    0,  318,  319,  320,  321,  322,  323,    0,    0,  324,
  325,  326,  327,  328,  329,  330,  331,  332,    0,    0,
    0,    0,    0,  333,    0,  334,  335,  336,  337,  338,
  339,  138,    0,  139,    0,    0,    0,    0,    0,  140,
    0,    0,  141,  142,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  143,  144,    0,  145,    0,  146,    0,
    0,  147,    0,    0,  148,    0,    0,    0,    0,    0,
    0,  149,    0,  150,  151, 3118,    0,    0,  152,    0,
  153,    0,    0,  154,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  155,  156,    0,    0,    0,  157,    0,
  158,    0,  159,    0,    0,    0,    0,    0,  160,    0,
  161,    0,    0,    0,  162,    0,    0,    0,    0,    0,
    0,    0,  163,    0,    0,  164,    0,  165,    0,    0,
    0,  166,  167,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  168,    0,    0,    0,  170,  171,
  172,  173,  174,    0,  175,    0,    0,    0,    0,    0,
  176,    0,  177,  178,    0,    0,  179,  180,    0,    0,
    0,    0,    0,  181,    0,    0,  182,  183,  184,  185,
    0,  186,    0,  187,    0,  188,  189,  190,  191,  192,
    0,    0,    0,    0,  193,    0,  194,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  195,    0,    0,
    0,    0,  196,  197,    0,  198,    0,    0,    0,  199,
    0,  200,  201,  202,  203,    0,  204,    0,    0,    0,
    0,    0,    0,    0,  205,  206,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  207,  208,    0,  209,  210,
  211,    0,    0,    0,    0,  212,  213,    0,  214,  215,
    0,  216,    0,    0,  217,  218,    0,    0,    0,  219,
  220,    0,    0,    0,    0,  221,  222,  223,    0,  224,
  225,  226,    0,  227,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  228,  229,  230,  231,  232,  233,  234,
  235,  236,  237,  238,  239,  240,  241,  242,  243,  244,
  245,  246,  247,  248,    0,  249,  250,  251,  252,  253,
  254,    0,  255,  256,  257,  258,    0,  259,    0,  260,
  261,  262,  263,  264,  265,  266,  267,  268,  269,  270,
  271,  272,  273,  274,  275,  276,  277,    0,  278,  279,
  280,  281,    0,  282,  283,  284,  285,  286,    0,  287,
  288,  289,  290,  291,  292,  293,  294,  295,  296,  297,
  298,  299,    0,  300,  301,  302,  303,  304,  305,    0,
  306,  307,  308,  309,  310,  311,  312,  313,    0,  314,
  315,  316,  317,    0,  318,  319,  320,  321,  322,  323,
    0,    0,  324,  325,  326,  327,  328,  329,  330,  331,
  332,    0,    0,    0,    0,    0,  333,    0,  334,  335,
  336,  337,  338,  339,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,    0,  141,  142,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,    0,    0,  147,    0,    0,  148,    0,    0,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,    0,  154,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  155,  156,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,    0,    0,    0,    0,  163,    0,    0,  164,    0,
  165,    0,    0,    0,  166,  167,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,    0,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,    0,    0,  181,    0,    0,  182,
  183,  184,  185,    0,  186,    0,  187,    0,  188,  189,
  190,  191,  192,    0,    0,    0,    0,  193,    0,  194,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  195,    0,    0,    0,    0,  196,  197,    0,  198,    0,
    0,    0,  199,    0,  200,  201,  202,  203,    0,  204,
    0,    0,    0,    0,    0,    0,    0,  205,  206,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  207,  208,
    0,  209,  210,  211,    0,    0,    0,    0,  212,  213,
    0,  214,  215,    0,  216,    0,    0,  217,  218,    0,
    0,    0,  219,  220,    0,    0,    0,    0,  221,  222,
  223,    0,  224,  225,  226,    0,  227,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  228,  229,  230,  231,
  232,  233,  234,  235,  236,  237,  238,  239,  240,  241,
  242,  243,  244,  245,  246,  247,  248,    0,  249,  250,
  251,  252,  253,  254,    0,  255,  256,  257,  258,    0,
  259,    0,  260,  261,  262,  263,  264,  265,  266,  267,
  268,  269,  270,  271,  272,  273,  274,  275,  276,  277,
    0,  278,  279,  280,  281,    0,  282,  283,  284,  285,
  286,    0,  287,  288,  289,  290,  291,  292,  293,  294,
  295,  296,  297,  298,  299,    0,  300,  301,  302,  303,
  304,  305,    0,  306,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  316,  317,    0,  318,  319,  320,
  321,  322,  323,    0,    0,  324,  325,  326,  327,  328,
  329,  330,  331,  332,    0,    0,    0,    0,    0,  333,
    0,  334,  335,  336,  337,  338,  339,  138,    0,  139,
    0,    0,    0,    0,    0,  140,    0,    0,  141,  142,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  143,
  144,    0,  145,    0,  146,    0,    0,  147,    0,    0,
  148,    0,    0,    0,    0,    0,    0,  149,    0,  150,
  151,    0,    0,    0,  152,    0,  153,    0,    0,  154,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  155,
  156,    0,    0,    0,  157,    0,  158,    0,  159,    0,
    0,    0,    0,    0,  160,    0,  161,    0,    0,    0,
  162,    0,    0,    0,    0,    0,    0,    0,  163,    0,
    0,  164,    0,  165,    0,    0,    0,  166,  167,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  168,    0,    0,    0,  170,  171,  172,  173,  174,    0,
  175,    0,    0,    0,    0,    0,  176,    0,  177,  178,
    0,    0,  179,  180,    0,    0,    0,    0,    0,  181,
    0,    0,  182,  183,  184,  185,    0,  186,    0,  187,
    0,  188,  189,  190,  191,  192,    0,    0,    0,    0,
  193,    0,  194,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  195,    0,    0,    0,    0,  196,  197,
    0,  198,    0,    0,    0,  199,    0,  200,  201,  202,
  203,    0,  204,    0,    0,    0,    0,    0,    0,    0,
  205,  206,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  207,  208,    0,  209,  210,  211,    0,    0,    0,
    0,  212,  213,    0,  214,  215,    0,  216,    0,    0,
  217,  218,    0,    0,    0,  219,  220,    0,    0,    0,
    0,  221,  222,  223,    0,  224,  225,  226,    0,  227,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  228,
  229,  230,  231,  232,  233,  234,  235,  236,  237,  238,
  239,  240,  241,  242,  243,  244,  245,  246,  247,  248,
    0,  249,  250,  251,  252,  253,  254,    0,  255,  256,
  257,  258,    0,  259,    0,  260,  261,  262,  263,  264,
  265,  266,  267,  268,  269,  270,  271,  272,  273,  274,
  275,  276,  277,    0,  278,  279,  280,  281,    0,  282,
  283,  284,  285,  286,    0,  287,  288,  289,  290,  291,
  292,  293,  294,  295,  296,  297,  298,  299,    0,  300,
  301,  302,  303,  304,  305,    0,  306,  544,  308,  309,
  310,  311,  312,  313,    0,  314,  315,  316,  317,    0,
  318,  319,  320,  321,  322,  323,    0,    0,  324,  325,
  326,  327,  328,  329,  330,  331,  332,    0,    0,    0,
    0,    0,  333,    0,  334,  335,  336,  337,  338,  339,
  138,    0,  139,    0,    0,    0,    0,    0,  140,    0,
    0,  141,  142,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  143,  144,    0,  145,    0,  146,    0,    0,
  147,    0,    0,  148,    0,    0,    0,    0,    0,    0,
  149,    0,  150,  151,    0,    0,    0,  152,    0,  153,
    0,    0,  154,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  155,  156,    0,    0,    0,  157,    0,  158,
    0,  159,    0,    0,    0,    0,    0,  160,    0,  161,
    0,    0,    0,  162,    0,    0,    0,    0,    0,    0,
    0,  163,    0,    0,  164,    0,  165,    0,    0,    0,
  166,  167,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  168,    0,    0,    0,  170,  171,  172,
  173,  174,    0,  175,    0,    0,    0,    0,    0,  176,
    0,  177,  178,    0,    0,  179,  180,    0,    0,    0,
    0,    0,  181,    0,    0,  182,  183,  184,  185,    0,
  186,    0,  187,    0,  188,  189,  190,  191,  192,    0,
    0,    0,    0,  193,    0,  194,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  195,    0,    0,    0,
    0,  196,  197,    0,  198,    0,    0,    0,  199,    0,
  200,  201,  202,  203,    0,  204,    0,    0,    0,    0,
    0,    0,    0,  205,  206,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  207,  208,    0,  209,  210,  211,
    0,    0,    0,    0,  212,  213,    0,  214,  215,    0,
  216,    0,    0,  217,  218,    0,    0,    0,  219,  220,
    0,    0,    0,    0,  221,  222,  223,    0,  224,  225,
  226,    0,  227,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  228,  229,  230,  231,  232,  233,  234,  235,
  236,  237,  238,  239,  240,  241,  242,  243,  244,  245,
  246,  247,  248,    0,  249,  250,  251,  252,  253,  254,
    0,  255,  256,  257,  258,    0,  259,    0,  260,  261,
  262,  263,  264,  265,  266,  267,  268,  269,  270,  271,
  272,  273,  274,  275,  276,  277,    0,  278,  279,  280,
  281,    0,  282,  283,  284,  285,  286,    0,  287,  288,
  289,  290,  291,  292,  293,  294,  295,  296,  297,  298,
  299,    0,  300,  301,  302,  303,  304,  305,    0,  306,
  574,  308,  309,  310,  311,  312,  313,    0,  314,  315,
  316,  317,    0,  318,  319,  320,  321,  322,  323,    0,
    0,  324,  325,  326,  327,  328,  329,  330,  331,  332,
    0,    0,    0,    0,    0,  333,    0,  334,  335,  336,
  337,  338,  339,  138,    0,  139,    0,    0,    0,    0,
    0,  140,    0,    0,  141,  142,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  143,  144,    0,  145,    0,
  146,    0,    0,  147,    0,    0,  148,    0,    0,    0,
    0,    0,    0,  149,    0,  150,  151,    0,    0,    0,
  152,    0,  153,    0,    0,  154,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  155,  156,    0,    0,    0,
  157,    0,  158,    0,  159,    0,    0,    0,    0,    0,
  160,    0,  161,    0,    0,    0,  162,    0,    0,    0,
    0,    0,    0,    0,  163,    0,    0,  164,    0,  165,
    0,    0,    0,  166,  167,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  168,    0,    0,    0,
  170,  171,  172,  173,  174,    0,  175,    0,    0,    0,
    0,    0,  176,    0,  177,  178,    0,    0,  179,  180,
    0,    0,    0,    0,    0,  181,    0,    0,  182,  183,
  184,  185,    0,  186,    0,  187,    0,  188,  189,  190,
  191,  192,    0,    0,    0,    0,  193,    0,  194,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  195,
    0,    0,    0,    0,  196,  197,    0,  198,    0,    0,
    0,  199,    0,  200,  201,  202,  203,    0,  204,    0,
    0,    0,    0,    0,    0,    0,  205,  206,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  207,  208,    0,
  209,  210,  211,    0,    0,    0,    0,  212,  213,    0,
  214,  215,    0,  216,    0,    0,  217,  218,    0,    0,
    0,  219,  220,    0,    0,    0,    0,  221,  222,  223,
    0,  224,  225,  226,    0,  227,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  228,  229,  230,  231,  232,
  233,  234,  235,  236,  237,  238,  239,  240,  241,  242,
  243,  244,  245,  246,  247,  248,    0,  249,  250,  251,
  252,  253,  254,    0,  255,  256,  257,  258,    0,  259,
    0,  260,  261,  262,  263,  264,  265,  266,  267,  268,
  269,  270,  271,  272,  273,  274,  275,  276,  277,    0,
  278,  279,  280,  281,    0,  282,  283,  284,  285,  286,
    0,  287,  288,  289,  290,  291,  292,  293,  294,  295,
  296,  297,  298,  299,    0,  300,  301,  302,  303,  304,
  305,    0,  306,  608,  308,  309,  310,  311,  312,  313,
    0,  314,  315,  316,  317,    0,  318,  319,  320,  321,
  322,  323,    0,    0,  324,  325,  326,  327,  328,  329,
  330,  331,  332,    0,    0,    0,    0,    0,  333,    0,
  334,  335,  336,  337,  338,  339, 1034,    0, 1034,    0,
    0,    0,    0,    0, 1034,    0,    0, 1034, 1034,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1034, 1034,
    0, 1034,    0, 1034,    0,    0, 1034,    0,    0, 1034,
    0,    0,    0,    0,    0,    0, 1034,    0, 1034, 1034,
    0,    0,    0, 1034,    0, 1034,    0,    0, 1034,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1034, 1034,
    0,    0,    0, 1034,    0, 1034,    0, 1034,    0,    0,
    0,    0,    0, 1034,    0, 1034,    0,    0,    0, 1034,
    0,    0,    0,    0,    0,    0,    0, 1034,    0,    0,
 1034,    0, 1034,    0,    0,    0, 1034, 1034,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1034,
    0,    0,    0, 1034, 1034, 1034, 1034, 1034,    0, 1034,
    0,    0,    0,    0,    0, 1034,    0, 1034, 1034,    0,
    0, 1034, 1034,    0,    0,    0,    0,    0, 1034,    0,
    0, 1034, 1034, 1034, 1034,    0, 1034,    0, 1034,    0,
 1034, 1034, 1034, 1034, 1034,    0,    0,    0,    0, 1034,
    0, 1034,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1034,    0,    0,    0,    0, 1034, 1034,    0,
 1034,    0,    0,    0, 1034,    0, 1034, 1034, 1034, 1034,
    0, 1034,    0,    0,    0,    0,    0,    0,    0, 1034,
 1034,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1034, 1034,    0, 1034, 1034, 1034,    0,    0,    0,    0,
 1034, 1034,    0, 1034, 1034,    0, 1034,    0,    0, 1034,
 1034,    0,    0,    0, 1034, 1034,    0,    0,    0,    0,
 1034, 1034, 1034,    0, 1034, 1034, 1034,    0, 1034,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1034, 1034,
 1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034,
 1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034,    0,
 1034, 1034, 1034, 1034, 1034, 1034,    0, 1034, 1034, 1034,
 1034,    0, 1034,    0, 1034, 1034, 1034, 1034, 1034, 1034,
 1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034,
 1034, 1034,    0, 1034, 1034, 1034, 1034,    0, 1034, 1034,
 1034, 1034, 1034,    0, 1034, 1034, 1034, 1034, 1034, 1034,
 1034, 1034, 1034, 1034, 1034, 1034, 1034,    0, 1034, 1034,
 1034, 1034, 1034, 1034,    0, 1034, 1034, 1034, 1034, 1034,
 1034, 1034, 1034,    0, 1034, 1034, 1034, 1034,    0, 1034,
 1034, 1034, 1034, 1034, 1034,    0,    0, 1034, 1034, 1034,
 1034, 1034, 1034, 1034, 1034, 1034,    0,    0,    0,    0,
    0, 1034,    0, 1034, 1034, 1034, 1034, 1034, 1034, 1116,
    0, 1116,    0,    0,    0,    0,    0, 1116,    0,    0,
 1116, 1116,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1116, 1116,    0, 1116,    0, 1116,    0,    0, 1116,
    0,    0, 1116,    0,    0,    0,    0,    0,    0, 1116,
    0, 1116, 1116,    0,    0,    0, 1116,    0, 1116,    0,
    0, 1116,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1116, 1116,    0,    0,    0, 1116,    0, 1116,    0,
 1116,    0,    0,    0,    0,    0, 1116,    0, 1116,    0,
    0,    0, 1116,    0,    0,    0,    0,    0,    0,    0,
 1116,    0,    0, 1116,    0, 1116,    0,    0,    0, 1116,
 1116,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1116,    0,    0,    0, 1116, 1116, 1116, 1116,
 1116,    0, 1116,    0,    0,    0,    0,    0, 1116,    0,
 1116, 1116,    0,    0, 1116, 1116,    0,    0,    0,    0,
    0, 1116,    0,    0, 1116, 1116, 1116, 1116,    0, 1116,
    0, 1116,    0, 1116, 1116, 1116, 1116, 1116,    0,    0,
    0,    0, 1116,    0, 1116,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1116,    0,    0,    0,    0,
 1116, 1116,    0, 1116,    0,    0,    0, 1116,    0, 1116,
 1116, 1116, 1116,    0, 1116,    0,    0,    0,    0,    0,
    0,    0, 1116, 1116,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1116, 1116,    0, 1116, 1116, 1116,    0,
    0,    0,    0, 1116, 1116,    0, 1116, 1116,    0, 1116,
    0,    0, 1116, 1116,    0,    0,    0, 1116, 1116,    0,
    0,    0,    0, 1116, 1116, 1116,    0, 1116, 1116, 1116,
    0, 1116,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116,
 1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116,
 1116, 1116,    0, 1116, 1116, 1116, 1116, 1116, 1116,    0,
 1116, 1116, 1116, 1116,    0, 1116,    0, 1116, 1116, 1116,
 1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116,
 1116, 1116, 1116, 1116, 1116,    0, 1116, 1116, 1116, 1116,
    0, 1116, 1116, 1116, 1116, 1116,    0, 1116, 1116, 1116,
 1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116,
    0, 1116, 1116, 1116, 1116, 1116, 1116,    0, 1116, 1116,
 1116, 1116, 1116, 1116, 1116, 1116,    0, 1116, 1116, 1116,
 1116,    0, 1116, 1116, 1116, 1116, 1116, 1116,    0,    0,
 1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116,    0,
    0,    0,    0,    0, 1116,    0, 1116, 1116, 1116, 1116,
 1116, 1116, 1114,    0, 1114,    0,    0,    0,    0,    0,
 1114,    0,    0, 1114, 1114,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1114, 1114,    0, 1114,    0, 1114,
    0,    0, 1114,    0,    0, 1114,    0,    0,    0,    0,
    0,    0, 1114,    0, 1114, 1114,    0,    0,    0, 1114,
    0, 1114,    0,    0, 1114,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1114, 1114,    0,    0,    0, 1114,
    0, 1114,    0, 1114,    0,    0,    0,    0,    0, 1114,
    0, 1114,    0,    0,    0, 1114,    0,    0,    0,    0,
    0,    0,    0, 1114,    0,    0, 1114,    0, 1114,    0,
    0,    0, 1114, 1114,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1114,    0,    0,    0, 1114,
 1114, 1114, 1114, 1114,    0, 1114,    0,    0,    0,    0,
    0, 1114,    0, 1114, 1114,    0,    0, 1114, 1114,    0,
    0,    0,    0,    0, 1114,    0,    0, 1114, 1114, 1114,
 1114,    0, 1114,    0, 1114,    0, 1114, 1114, 1114, 1114,
 1114,    0,    0,    0,    0, 1114,    0, 1114,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1114,    0,
    0,    0,    0, 1114, 1114,    0, 1114,    0,    0,    0,
 1114,    0, 1114, 1114, 1114, 1114,    0, 1114,    0,    0,
    0,    0,    0,    0,    0, 1114, 1114,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1114, 1114,    0, 1114,
 1114, 1114,    0,    0,    0,    0, 1114, 1114,    0, 1114,
 1114,    0, 1114,    0,    0, 1114, 1114,    0,    0,    0,
 1114, 1114,    0,    0,    0,    0, 1114, 1114, 1114,    0,
 1114, 1114, 1114,    0, 1114,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1114, 1114, 1114, 1114, 1114, 1114,
 1114, 1114, 1114, 1114, 1114, 1114, 1114, 1114, 1114, 1114,
 1114, 1114, 1114, 1114, 1114,    0, 1114, 1114, 1114, 1114,
 1114, 1114,    0, 1114, 1114, 1114, 1114,    0, 1114,    0,
 1114, 1114, 1114, 1114, 1114, 1114, 1114, 1114, 1114, 1114,
 1114, 1114, 1114, 1114, 1114, 1114, 1114, 1114,    0, 1114,
 1114, 1114, 1114,    0, 1114, 1114, 1114, 1114, 1114,    0,
 1114, 1114, 1114, 1114, 1114, 1114, 1114, 1114, 1114, 1114,
 1114, 1114, 1114,    0, 1114, 1114, 1114, 1114, 1114, 1114,
    0, 1114, 1114, 1114, 1114, 1114, 1114, 1114, 1114,    0,
 1114, 1114, 1114, 1114,    0, 1114, 1114, 1114, 1114, 1114,
 1114,    0,    0, 1114, 1114, 1114, 1114, 1114, 1114, 1114,
 1114, 1114,    0,    0,    0,    0,    0, 1114,    0, 1114,
 1114, 1114, 1114, 1114, 1114,  514,    0,  514,    0,    0,
    0,    0,    0,  514,    0,    0,  514,  514,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  514,  514,    0,
  514,    0,  514,    0,    0,  514,    0,    0,  514,    0,
    0,    0,    0,    0,    0,  514,    0,  514,  514,    0,
    0,    0,  514,    0,  514,    0,    0,  514,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  514,  514,    0,
    0,    0,  514,    0,  514,    0,  514,    0,    0,    0,
    0,    0,  514,    0,  514,    0,    0,    0,  514,    0,
    0,    0,    0,    0,    0,    0,  514,    0,    0,  514,
    0,  514,    0,    0,    0,  514,  514,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  514,    0,
    0,    0,  514,  514,  514,  514,  514,    0,  514,    0,
    0,    0,    0,    0,  514,    0,  514,  514,    0,    0,
  514,  514,    0,    0,    0,    0,    0,  514,    0,    0,
  514,  514,  514,  514,    0,  514,    0,  514,    0,  514,
  514,  514,  514,  514,    0,    0,    0,    0,  514,    0,
  514,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  514,    0,    0,    0,    0,  514,  514,    0,  514,
    0,    0,    0,  514,    0,  514,  514,  514,  514,    0,
  514,    0,    0,    0,    0,    0,    0,    0,  514,  514,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  514,
  514,    0,  514,  514,  514,    0,    0,    0,    0,  514,
  514,    0,  514,  514,    0,  514,    0,    0,  514,  514,
    0,    0,    0,  514,  514,    0,    0,    0,    0,  514,
  514,  514,    0,  514,  514,  514,    0,  514,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  514,  514,  514,
  514,  514,  514,  514,  514,  514,  514,  514,  514,  514,
  514,  514,  514,  514,  514,  514,  514,  514,    0,  514,
  514,  514,  514,  514,  514,    0,  514,  514,  514,  514,
    0,  514,    0,  514,  514,  514,  514,  514,  514,  514,
  514,  514,  514,  514,  514,  514,  514,  514,  514,  514,
  514,    0,  514,  514,  514,  514,    0,  514,  514,  514,
  514,  514,    0,  514,  514,  514,  514,  514,  514,  514,
  514,  514,  514,  514,  514,  514,    0,  514,  514,  514,
  514,  514,  514,    0,  514,  514,  514,  514,  514,  514,
  514,  514,    0,  514,  514,  514,  514,    0,  514,  514,
  514,  514,  514,  514,    0,    0,  514,  514,  514,  514,
  514,  514,  514,  514,  514,    0,    0,    0,    0,    0,
  514,    0,  514,  514,  514,  514,  514,  514,  157,    0,
  157,    0,    0,    0,    0,    0,  157,    0,    0,  157,
  157,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  157,  157,    0,  157,    0,  157,    0,    0,  157,    0,
    0,  157,    0,    0,    0,    0,    0,    0,  157,    0,
  157,  157,    0,    0,    0,  157,    0,  157,    0,    0,
  157,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  157,  157,    0,    0,    0,  157,    0,  157,    0,  157,
    0,    0,    0,    0,    0,  157,    0,  157,    0,    0,
    0,  157,    0,    0,    0,    0,    0,    0,    0,  157,
    0,    0,  157,    0,  157,    0,    0,    0,  157,  157,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  157,    0,    0,    0,  157,  157,  157,  157,  157,
    0,  157,    0,    0,    0,    0,    0,  157,    0,  157,
  157,    0,    0,  157,  157,    0,    0,    0,    0,    0,
  157,    0,    0,  157,  157,  157,  157,    0,  157,    0,
  157,    0,  157,  157,  157,  157,  157,    0,    0,    0,
    0,  157,    0,  157,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  157,    0,    0,    0,    0,  157,
  157,    0,  157,    0,    0,    0,  157,    0,  157,  157,
  157,  157,    0,  157,    0,    0,    0,    0,    0,    0,
    0,  157,  157,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  157,  157,    0,  157,  157,  157,    0,    0,
    0,    0,  157,  157,    0,  157,  157,    0,  157,    0,
    0,  157,  157,    0,    0,    0,  157,  157,    0,    0,
    0,    0,  157,  157,  157,    0,  157,  157,  157,    0,
  157,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,
  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,
  157,    0,  157,  157,  157,  157,  157,  157,    0,  157,
  157,  157,  157,    0,  157,    0,  157,  157,  157,  157,
  157,  157,  157,  157,  157,  157,  157,  157,  157,  157,
  157,  157,  157,  157,    0,  157,  157,  157,  157,    0,
  157,  157,  157,  157,  157,    0,  157,  157,  157,  157,
  157,  157,  157,  157,  157,  157,  157,  157,  157,    0,
  157,  157,  157,  157,  157,  157,    0,  157,  157,  157,
  157,  157,  157,  157,  157,    0,  157,  157,  157,  157,
    0,  157,  157,  157,  157,  157,  157,    0,    0,  157,
  157,  157,  157,  157,  157,  157,  157,  157,    0,    0,
    0,    0,    0,  157,    0,  157,  157,  157,  157,  157,
  157,   60,    0,   60,    0,    0,    0,    0,    0,   60,
    0,    0,   60,   60,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   60,   60,    0,   60,    0,   60,    0,
    0,   60,    0,    0,   60,    0,    0,    0,    0,    0,
    0,   60,    0,   60,   60,    0,    0,    0,   60,    0,
   60,    0,    0,   60,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   60,   60,    0,    0,    0,   60,    0,
   60,    0,   60,    0,    0,    0,    0,    0,   60,    0,
   60,    0,    0,    0,   60,    0,    0,    0,    0,    0,
    0,    0,   60,    0,    0,   60,    0,   60,    0,    0,
    0,   60,   60,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   60,    0,    0,    0,   60,   60,
   60,   60,   60,    0,   60,    0,    0,    0,    0,    0,
   60,    0,   60,   60,    0,    0,   60,   60,    0,    0,
    0,    0,    0,   60,    0,    0,   60,   60,   60,   60,
    0,   60,    0,   60,    0,   60,   60,   60,   60,   60,
    0,    0,    0,    0,   60,    0,   60,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   60,    0,    0,
    0,    0,   60,   60,    0,   60,    0,    0,    0,   60,
    0,   60,   60,   60,   60,    0,   60,    0,    0,    0,
    0,    0,    0,    0,   60,   60,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   60,   60,    0,   60,   60,
   60,    0,    0,    0,    0,   60,   60,    0,   60,   60,
    0,   60,    0,    0,   60,   60,    0,    0,    0,   60,
   60,    0,    0,    0,    0,   60,   60,   60,    0,   60,
   60,   60,    0,   60,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   60,   60,   60,   60,   60,   60,   60,
   60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
   60,   60,   60,   60,    0,   60,   60,   60,   60,   60,
   60,    0,   60,   60,   60,   60,    0,   60,    0,   60,
   60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
   60,   60,   60,   60,   60,   60,   60,    0,   60,   60,
   60,   60,    0,   60,   60,   60,   60,   60,    0,   60,
   60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
   60,   60,    0,   60,   60,   60,   60,   60,   60,    0,
   60,   60,   60,   60,   60,   60,   60,   60,    0,   60,
   60,   60,   60,    0,   60,   60,   60,   60,   60,   60,
    0,    0,   60,   60,   60,   60,   60,   60,   60,   60,
   60,    0,    0,    0,    0,    0,   60,    0,   60,   60,
   60,   60,   60,   60,  138,    0,  139,    0,    0,    0,
    0,    0,  140,    0,    0,  141,  142,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  143,  144,    0,  145,
    0,  146,    0,    0,  147,    0,    0,  148,    0,    0,
    0,    0,    0,    0,  149,    0,  150,  151,    0,    0,
    0,  152,    0,  153,    0,    0,  154,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  155,  156,    0,    0,
    0,  157,    0,  158,    0,  159,    0,    0,    0,    0,
    0,  160,    0,  161,    0,    0,    0,  162,    0,    0,
    0,    0,    0,    0,    0,  163,    0,    0,  164,    0,
  165,    0,    0,    0,  166,  167,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  168,    0,    0,
    0,  170,  171,  172,  173,  174,    0,  175,    0,    0,
    0,    0,    0,  176,    0,  177,  178,    0,    0,  179,
  180,    0,    0,    0,    0,    0,  181,    0,    0,  182,
  183,  184,  185,    0,  186,    0,  187,    0,  188,  189,
  190,  191,  192,    0,    0,    0,    0,  193,    0,  194,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  195,    0,    0,    0,    0,  196,  197,    0,  198,    0,
    0,    0,  199,    0,  200,  201,  202,  203,    0,  204,
    0,    0,    0,    0,    0,    0,    0,  205,  206,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  207,  208,
    0,  209,  210,  211,    0,    0,    0,    0,  212,  213,
    0,  214,  215,    0,  216,    0,    0,  217,  218,    0,
    0,    0,  219,  220,    0,    0,    0,    0,  221,  222,
  223,    0,  224,  225,  226,    0,  227,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  229,  230,  231,
  232,  233,  234,  235,  236,  237,  238,  239,  240,  241,
  242,  243,  244,  245,  246,  247,  248,    0,  249,  250,
  251,  252,  253,  254,    0,  255,  256,  257,  258,    0,
  259,    0,  260,  261,  262,  263,  264,  265,  266,  267,
  268,  269,  270,  271,  272,  273,  274,  275,  276,  277,
    0,  278,  279,  280,  281,    0,  282,  283,  284,  285,
  286,    0,  287,  288,  289,  290,  291,  292,  293,  294,
  295,  296,  297,  298,  299,    0,  300,  301,  302,  303,
  304,  305,    0,  306,  307,  308,  309,  310,  311,  312,
  313,    0,  314,  315,  316,  317,    0,  318,  319,  320,
  321,  322,  323,    0,    0,  324,  325,  326,  327,  328,
  329,  330,  331,  332,    0,    0,    0,    0,    0,  333,
    0,  334,  335,  336,  337,  338,  339,  138,    0,  139,
    0,    0,    0,    0,    0,  140,    0,    0,  141,  142,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  143,
  144,    0,  145,    0,  146,    0,    0,  147,    0,    0,
  148,    0,    0,    0,    0,    0,    0,  149,    0,  150,
  151,    0,    0,    0,  152,    0,  153,    0,    0,  154,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  155,
  156,    0,    0,    0,  157,    0,  158,    0,  159,    0,
    0,    0,    0,    0,  160,    0,  161,    0,    0,    0,
  162,    0,    0,    0,    0,    0,    0,    0,  163,    0,
    0,  164,    0,  165,    0,    0,    0,  166,  167,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  168,    0,    0,    0,  170,  171,  172,  173,  174,    0,
  175,    0,    0,    0,    0,    0,  176,    0,  177,  178,
    0,    0,  179,  180,    0,    0,    0,    0,    0,  181,
    0,    0,  182,  183,  184,  185,    0,  186,    0,  187,
    0,  188,  189,  190,  191,  192,    0,    0,    0,    0,
  193,    0,  194,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  195,    0,    0,    0,    0,  196,  197,
    0,  198,    0,    0,    0,  199,    0,  200,  201,  202,
  203,    0,  204,    0,    0,    0,    0,    0,    0,    0,
  205,  206,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  207,  208,    0,  209,  210,  211,    0,    0,    0,
    0,  212,  213,    0,  214,  215,    0,  216,    0,    0,
  217,  218,    0,    0,    0,  219,  220,    0,    0,    0,
    0,  221,  222,  223,    0,  224,  225,  226,    0,  227,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  228,
  229,  230,  231,  232,  233,  234,  235,  236,  237,  238,
  239,  240,  241,  242,  243,  244,  245,  246,  247,  248,
    0,  249,  250,  251,  252,  253,  254,    0,  255,  256,
  257,  258,    0,  259,    0,  260,  261,  262,  263,  264,
  265,  266,  267,  268,  269,  270,  271,  272,  273,  274,
  275,  276,  277,    0,  278,  279,  280,  281,    0,  282,
  283,  284,  285,  286,    0,  287,  288,  289,  290,  291,
  292,  293,  294,    0,  296,  297,  298,  299,    0,  300,
  301,  302,  303,  304,  305,    0,  306,  307,  308,  309,
  310,  311,  312,  313,    0,  314,  315,  316,  317,    0,
  318,  319,  320,  321,  322,  323,    0,    0,  324,  325,
  326,  327,  328,  329,  330,  331,  332,    0,    0,    0,
    0,    0,  333,    0,  334,  335,  336,  337,  338,  339,
  138,    0,  139,    0,    0,    0,    0,    0,  140,    0,
    0,  141,  142,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  143,  144,    0,  145,    0,  146,    0,    0,
  147,    0,    0,  148,    0,    0,    0,    0,    0,    0,
  149,    0,  150,  151,    0,    0,    0,  152,    0,  153,
    0,    0,  154,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  155,  156,    0,    0,    0,  157,    0,  158,
    0,  159,    0,    0,    0,    0,    0,  160,    0,  161,
    0,    0,    0,  162,    0,    0,    0,    0,    0,    0,
    0,  163,    0,    0,  164,    0,  165,    0,    0,    0,
  166,  167,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  168,    0,    0,    0,  170,  171,  172,
  173,  174,    0,  175,    0,    0,    0,    0,    0,  176,
    0,  177,  178,    0,    0,  179,  180,    0,    0,    0,
    0,    0,  181,    0,    0,  182,  183,  184,  185,    0,
  186,    0,  187,    0,  188,  189,  190,  191,  192,    0,
    0,    0,    0,  193,    0,  194,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  195,    0,    0,    0,
    0,  196,  197,    0,  198,    0,    0,    0,  199,    0,
  200,  201,  202,  203,    0,  204,    0,    0,    0,    0,
    0,    0,    0,  205,  206,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  207,  208,    0,  209,    0,  211,
    0,    0,    0,    0,  212,  213,    0,  214,    0,    0,
  216,    0,    0,  217,  218,    0,    0,    0,  219,  220,
    0,    0,    0,    0,  221,  222,  223,    0,    0,  225,
  226,    0,  227,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  228,  229,  230,  231,  232,  233,  234,  235,
  236,  237,  238,  239,  240,  241,  242,  243,  244,  245,
  246,  247,  248,    0,  249,  250,  251,  252,  253,  254,
    0,  255,  256,  257,  258,    0,  259,    0,  260,  261,
  262,  263,  264,  265,  266,  267,  268,  269,  270,  271,
  272,  273,  274,  275,  276,  277,    0,  278,  279,  280,
  281,    0,  282,  283,  284,  285,  286,    0,  287,  288,
  289,  290,  291,  292,  293,  294,  295,  296,  297,  298,
  299,    0,  300,  301,  302,  303,  304,  305,    0,  306,
  307,  308,  309,  310,  311,  312,  313,    0,  314,  315,
  316,  317,    0,    0,    0,    0,  321,  322,  323,    0,
    0,  324,  325,  326,  327,  328,  329,  330,  331,  332,
    0,    0,    0,    0,    0,  333,    0,  334,  335,  336,
  337,  338,  339,
};
static int yycheck[] = {                                      14,
   15,  110,   17,    0,  592,  121,  639,  640,  731,  718,
   81,  670,  728,  881,  113,   67,  114,   63, 1031,   73,
  881,   81,   14,  994,   15,   70, 1335,  126,  648, 1042,
  639,  640,  671,  693,  481,  879,  880,  881, 1374, 1173,
   94, 1374,  717,   71,  693, 1179, 1373,   62,   63, 1728,
   65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
  112,  107,   77, 1044,   92,  119,  592,   82,   83,   84,
   85,  116,   87,  656,   89,   90, 1469,   92,   93,   94,
   95,   96,  693,  952,   99, 1014,   82, 1014,  103,  117,
  105,  106,  107, 1014,  109,  110,  111,  112,  113, 1762,
  115,  116,  117,  118,  119,  120,  121,   77,  691,  124,
   14,  126,   66,  105,  129,  130, 1305, 1716,  133, 1460,
   74,  136, 2060,  115, 2062, 2102, 1960, 1230, 1804,   99,
 1832, 1279, 1801, 1421, 1331, 1146, 2220, 2221,  130, 2191,
 2240, 1421, 1572, 1355, 1384, 1039, 1462, 1730, 2129, 1421,
 1124, 1421,  678, 1421,  124, 1353,  126,  111,  696,  966,
 1591,  722, 2294, 1582, 1014,   69,  120, 1829, 1017,  632,
  633, 2126,    0,    0,    0,  491, 2376, 1417, 1919,  133,
   87,  363,   99, 1395, 1424,   89, 1426,   98,   93, 1380,
  531, 2787,   84,    0,   42, 1405, 1921,  542,    0,    0,
    0,  105, 1096, 1939,    0, 1263,   40,    0,   44,    0,
    0,   40,  123,    0,   44, 2581,   44, 1709, 1817,   59,
   41, 1403, 1309,   44,   44,  129,  130,  572,   45,   63,
    0,   59,   59,   59,   63,    0,    0,    0,   59,   41,
   61,   40,  295,    0,   41,  296,    0,   44,   41, 1402,
   44,    0,   59,    0,   41, 2210,  964,   59,   59,   59,
 1921,  881,   59,   59,   61,   45,   59,    0,   59,   59,
   45,   40,   59,  260, 1142,    0,  296, 2235,   41,  278,
 1710, 2481,  355,  262,   41,   44,   44,   44,   44,   59,
 2491,   44,  325,    0,   59,   59,   59, 1020, 1142,   45,
  573, 1162,   59, 1230,    0,   59, 1187, 1188,   41, 1238,
   59,   44,   59,   44,    0,   44,   41,    0,   41,   44,
  307,   44, 2374, 2526,  280,   41,   59,  273,  268,    0,
  345,  262, 1920,    0,   59,  350,  351,  352,  353,  354,
  355,  356,  357,   91,  359,   41,  387,  316,  363, 1024,
    0, 2826,   59, 2671,  345,  464,  500,  276, 2945,  374,
 1753, 1754, 1755,   59,  507,  475,  265,  276,    0,  275,
  500, 1232,  372,   59, 1218, 1050,   59,    0,   44,  260,
  387, 1515,  261,  296, 2584,  301,  389,  265,   59,  359,
 1234,  462,   59, 2926,    0,  505,  426, 1920,  297,  398,
 1261, 1262,    0,  264,  407, 1014,  438,  286,  302,   59,
 1254, 1255, 1256, 1257, 1258,  263, 2386,  330,  387,  297,
  450,   44,  301,  423,  264, 1294, 1762,   59,  264, 1762,
  329,  337, 2484, 1053,  264, 2405,   59,    0,    0,  418,
  549,  584,  359,  264, 2544,  364,  353,  518,  557,  464,
  354,  356, 1168,   59, 1170,  364,  277,  264, 2137,  351,
  501,   59,  264,  264,  737, 1662,  385,  264,  994, 1572,
  310,  264,  391,    0,  295, 1313, 1059,  264,   41, 1317,
  277,   44,   44,  490, 1322,  401, 2320,  418,  258,  310,
 1351,    0, 1421,  433, 2546,   41,   59,   59,  295, 3086,
 1421,  264,  448,  364,  258,  424,  650,  264,  364,  264,
  312,    0,    0,  310,   41, 2076,  270,   44, 2993,  312,
  571,  651, 1142, 1657,  364,  312, 2228,  275, 2230,  544,
  332,  301,   59,    0,  549,  587, 1156,   40,  332,  332,
  434,    0,  557, 1163, 3077,  332, 1694,  301, 2529,  303,
   59,  571,   41,   41, 2755,  312,   41,   40,  573,  574,
 2878,  314,    0, 2288, 2765,  322,  323,  364,  264,  332,
   59,   59,  587, 2776,  544,  332, 2779,  592,  335,  594,
    0,  596,  597, 1306, 2015,  584, 2952,  258,  295, 2547,
   59,  644,   59,  608, 1302,  551,  624,  393, 1218,  270,
   59,  592,   41,  594,  574,  596,    0, 1710,  442,  624,
 1697, 2030,  295,  442,  647,  372,  312,  632,  633,  634,
  635,   59,  442,  419,  381,  442, 2118, 2288,  427,  702,
  301,  401,  303,  340,  434,  437,  332,  368,  608,   59,
 1698,  264,  713,  368,  437, 1572,  393,  401,  314,  419,
  437,  257,  698,  713, 1535,  642,  372,  340, 1587, 1279,
  419,  430,  442,  678, 1297,   59,  423,  442, 1679,  434,
  434,  686,  395,  725,  437,  703,  372, 1393,  435,  437,
  437,  437,  452,  698,  699,  700,  701,  702,  703,  704,
  705, 1311,  467,  708, 2826, 2827,  442,  499, 1414, 2287,
  715,  264,  264,  718,  719,  372,  435,  722,  394,  500,
  725, 1579, 1922,  728,  381,  321, 1304,  519,    0,  519,
  326, 1582,  737,  715, 2694, 2695,  519,  423,  519,  519,
  401, 3327,  519, 3099, 3100, 1579, 1927,  264,  708, 1921,
  372,  437,  499,  500,  394, 2660,  700, 1591,  596,  312,
  483,  705, 1468, 2183,  519, 2491, 2186,  593,  483,  322,
  323,  642,  519,  593, 2287,  363,  627, 1920, 1113,  332,
  519,  627,  335,    0,  380,  264,  264,   59, 1304,  961,
 1709, 1122, 1709, 1710, 1459,  312,  593,  627, 1709,  496,
  396,  708,  593, 1109,  701,  264,  707, 1465,  646,  704,
 1661, 2782,   44,  499,  500,  332,  627,  699,   44,  372,
  363,   95, 2553,  496,  437,  719, 2868,   61,  381,  304,
  648,  648,  648,  519,  312, 1408,  372, 1353,  295, 3029,
  627,  340,   59,  500,  322,  323,   59, 2398,  593,    0,
  316,  310, 2797,  332,  332,  443,  444,  264, 1374,  948,
 1688, 1689,  519,  364,  953, 1318,  610,  611, 1321, 1709,
  423, 2993, 1711, 2190,  258,  304, 2528,  882,  500,  298,
 1396, 2068,  435,  340,  437,  437,  270,  483,  264,  347,
 1441,  340,  480,    0,  372,   44,   59,  519, 1695, 1863,
  295,  882, 2311,  381,  651,  301,  319,  400,   59, 1437,
 2870, 2871, 2872, 2873, 2874, 2875, 2876,  301, 2011,  303,
  437,  387,  302,  303,  282,  344,  987,  400,  344,  357,
 2503,  264,   59,   42,  427, 2123,  395, 3084,  526, 2077,
  496, 2247, 2363,  948,  437,  423,  499,  500,  953,  610,
  611,    0,   59,  363,  427, 3333,  961, 1394,  437,  437,
  965,  316, 1620, 2552,  437,  651,  519, 1028,  306, 1579,
  321, 1855, 1582,  978, 1035, 1036, 2565,  427, 1028,  567,
  264,  319,  499,  500,    0, 1035, 1036,  437,    0,  994,
  302,  303,   41,  953,  554,   44,  592,  312,  594,  595,
  413,    0,  519, 2233,    0,  401, 2236,  420, 2238, 2980,
   59, 3389,  268, 1450,    0,    0,  474,  401,  578,  279,
    0,  499,  500, 2847, 3199, 1006,  335,  443,  444, 1034,
    0, 2032,  387,  443,  444, 3182, 3078,  450, 1099,  496,
 2164,  519,   41,   59, 2246, 3135,  355,   59, 2468,  645,
   59,  264,   61,  306,  434,    0,   41, 1118, 1119,  560,
   59,  295,  395,   59,  290,    0,  319,  299, 1118, 1119,
  480,  965,  284,   59,   59,   59,  619, 2730,  352,   59,
 2749,  314, 1732,  357,  978,  443,  444, 2740,  644,   59,
 2183,  363,  263, 2186, 2011,  446,   41,  353,  651,   44,
  409, 3061, 3062, 3063, 3064, 3065, 3066, 3067,  259,   44,
 1709,  395,  519,  264,   59, 1966,  526,    0,  269,  332,
   59,  436,  434,  340,   59,   59, 1832, 3032, 3033, 3034,
 3035, 3036, 3037, 3038,  651,  306,  299,  264,   60,   61,
   62,  290, 1800,  519,    0, 1150,  317, 1253,   93,  615,
 1849,  260, 1157, 3300,   59,  368,  551,  567,   41,  310,
    0,   44,  422,  298,  389, 1264, 1815,  380,  506,  276,
  277,  443,  444,  651,  348,    0,   59, 2455, 2456, 1802,
 1758, 2015, 3256,  310, 2035, 2455, 2456, 1816, 3012,  298,
 1279,    0, 1857, 2455, 2456, 2455, 2456, 2455, 2456,  332,
  412,   41, 3377,   59,   44, 2208,  330, 2066,  480,  344,
   93,  363,  257, 1157,  439,  264,   41, 2404, 1867,   59,
  639,  640,  641, 1936,  437, 1230,  610,  611, 3403,  364,
 3272,  382, 3274,  420,   59,  316,  649,  450,  412,  410,
 1869,  276, 1758,   59,  553, 2576, 1762, 3422, 1253, 1230,
   59, 2254, 1313,  506,  526, 1828, 1317,  364, 1263, 1264,
  615, 1322, 3437,  312, 2930,  264, 2183,    0,  264, 2186,
 2929, 1370,    0, 1278, 1279,  295,  332, 1263, 3314,  264,
  264,  326, 1371,  332, 2937,    0,  295,  316,  307, 1939,
  276,  277,  296, 2431,  264,  567,  276,  277,    0, 1304,
 1939,  425,  296, 1308, 1309,    0,  387, 1368,   41,  316,
 3346,  443,  444, 1318,  310,  299, 1321, 3141, 1368, 1279,
  340,  273, 1308, 1304, 2448,  264,   59,  312,  480,  364,
  264,   59, 2649,  332,  488, 1340,    0,  312, 1939,   41,
  310, 1429, 1430, 1431,   59,  296,   41,  332, 1353,  271,
  385,    0,  264,  540,  257, 2479,  391,   59,  387,  264,
  547,  303,  284,   59,   59, 1370, 1371,  296, 1373, 1374,
  312,  310, 1353, 3388,  526, 2468,  310,  442,  364,   41,
  387, 3309,   44,   41,  364,  296,   44, 1373,  437,  424,
  296, 1396,  344, 1374,  368,   59,  318, 1402, 1403,   61,
 3092,  330,  467,  325, 2730,  310,    0, 2730,  264, 2122,
   59,  333,  382, 3428, 2740,  567,  280, 2740,  437,  330,
 2030,  425,  429,  326,  264,  400, 2743,  372,  350,  257,
  352,  425,    0,  264, 3087,  484, 1441,  372,  437,  264,
  362,   59, 3409,  365,  366, 3098,  381,   41,  264,  394,
  499,  500,  437, 2311,  310,  264,  368,  312,  400, 1464,
 2311,  436,  391, 1468, 1469,   59,  637, 3434,  380,    0,
  519,  400,  312,  283,  425,  400,  496, 2311,  340,  310,
  295, 2452, 2453,  323,  312,  295, 2817,  312,   42,  372,
  412,   59,  332,   47,  436, 3423,  425,  258,  326,  434,
  435,  310,    0,  295,  639,  640,  641,  332,  401,  270,
 2133,  394,  368,  279,  425, 1520,  332, 2368,  382,  425,
  388,    0, 2228,  276, 2230,  437,  382, 3116,   59, 2363,
 3183,  264,  372, 2712,  519,  403, 2455, 2456,  450, 3192,
  301,  381,  303,  475, 2455, 2456,  264,    0,  264,  264,
  271, 2468,  368,  485,  364,  419, 2415, 2681, 2941,  368,
  313,   59,  264,  284,  380,  500, 1571, 1572,  264,  264,
 1464,  276,  364,  382, 1663,  389, 1520,  264,  260,  312,
   59,  443,  444,  423,  519, 1571,   44, 2711,  452,  322,
  323, 1572,  310,  257,  310,  310,  264,  437,  554,  332,
   45,  258,  651,  369,  325, 1694,   59, 2123,  313, 1715,
  312, 2937,  437,   58, 2937,  273,  298,  316,   63,    0,
 2581,  437,  578,  310,    0,  439, 2249, 1688, 1689,    0,
  332,  352,  385,  295,  450,   93,  332,  332,    0,  372,
  401,  426,  310,  507,  301, 2218,  304, 2650,  381,   44,
  368,  259,  368,  368,   59,  371,  422,  321, 1663,  499,
  500,  269,  326,    0,   40,   41,  382,  382,   44,  596,
  264,  424,  368,  439,  499,  500,  598,  261,   59,  519,
  385,  368,   44,   59,  380,  334,  344,  551,   59, 1694,
  423,  412, 1697, 1698,  519,  382,  264,   59,   93,  393,
  368, 2311,  435,   44,  437, 1710,   42,   43, 1744,   45,
 1715,   47, 1698, 3382,  363, 1696,  380, 2430,  312,  424,
 2426, 1726,   59,  277,  393,  419, 1731,  281, 2377, 1710,
    0,  260,  396,  264, 1694,  437, 1741,  395,  332, 1744,
  389,  437,  310,  392,  401, 1731, 2445, 1752, 1753, 1754,
 1755, 1756,   93, 1758,  450, 1741,  264, 1762,  407,  257,
  368, 3087,  419, 1851, 3087,  258,  499,  500,  261,  298,
  259,    0, 3098,    0,  264, 3098,  295, 1758,  372,  310,
  269, 1762,  259,  363,  433,  264,  519,  381,  264,   59,
  448,   41,  269, 1798,   44,  452, 1801,  499,  500,  442,
  368,  315,  310, 1808, 2807, 1810, 2809,   44,  301,    0,
   59,  651,  316,  327,  382, 1801, 2253,  519, 2255,  483,
  310,  401, 1808,  321, 1810,  344,  651, 3144,  326,  423,
   59,  310,   59,  316,  310,  349,    0,  368,  487,  264,
  261, 2491,  263,  437, 1849,    0,  291, 2284,    0,  610,
  611,  382, 2491,    0, 2504,  596,   93, 3183,  507,  264,
 3183,    0,  260, 1868,    0,  286, 3192,  447,   59, 3192,
    0,  520,  310,  311,  105,  296, 2727,  598,  368,  368,
  301,  371,  380,  397, 3267,  310, 1868,  348,  264,  368,
 2491,    0,  382,    0,   41,   59,  329,   44,  396,  130,
  298, 3200,   41,  382,   59,  499,  500,   59, 2531,  330,
    0, 2560,   59,  587, 2563, 1920, 1921,  378,  651,  380,
   59,  258,  596,   59,    0,  519,  315,  332,  592,   59,
  594,  595, 2561,  270, 1939, 2564,  312,   44,  327,  315,
  401,  277, 2903,   59, 2043,  281,  322,  323,  260,  651,
   59,  327,   59, 1939,  264, 2044,  332,  475,  295,  335,
  349,    0,  474,  368,  301,  426,  303,  485,  315,   59,
    0,  360,  280,  349,   41,  380,  450,   44,  264,  368,
  327,  645,  330,   59,  360,  483,  298, 2076, 2077,  450,
    0,  503,  368,  301,    0,  440,  372,  442,  443,  444,
  310,  401,  349,  340,  425,  381, 2011, 2012,  397,  264,
 2046,  348,  276,  360,    0,  264,  303,  462,  463,  283,
   59,  397,  467,  468,  310,  312, 2012,    0,   44,   59,
 2011,   41,  437, 2038,   44,  264,   46, 2042, 2043, 2044,
 2045, 2046, 2047, 2048, 2150,  450,    0,  423,   40,   59,
  397,   61, 2038,   59,  260,   41,  425,  651,   44,  435,
 2042,  437, 2067,  260,  401, 2581, 2127, 2128,   41, 2920,
  587, 2076, 2077,   59, 2079,  412, 2934, 2127, 2128,  612,
  613,  310,    0,  332,    0, 2045,   59,   41,  260,  427,
   44,    0,  298,  401,  592,    0,  594,  595, 2079,    0,
 2934,  298,  437, 2047, 2048,   59,    0,  483,    0,  264,
  277,  401,    0,  400,  281,  504, 2076, 2077, 2123,  368,
    0,  507,  475,  499,  500,  264,  298,    0,  504,  276,
  277,  380,  485,    0,  376,  377,  283,    0,   45,  368,
   40,   59, 2123,   59,  452, 2150, 2811,  645,  264,  436,
   59,   58,  505,  382,   59,  310,   63,  504,   59,  496,
  301, 2222,  264, 2224, 2225,   59,  590,   59,  407, 2275,
  475,   59, 2222,  312, 2224, 2225,  600,  601, 2183,   59,
  485, 2186,  334,  443,  323, 2190,   59, 2900,  437, 2194,
    0, 2196,   59,  332,  639,  640,   59, 2184, 3322,  507,
  505,  450, 2183,  264, 2190, 2186, 2224, 2268, 2194,  584,
 2271, 2272, 2273,  368, 2730,  310,  332,  364, 2268, 2224,
 2225, 2271, 2272, 2273, 2740, 2230, 2051,  382, 3352,   41,
  443,  444,   44,  372, 2295,   46,  261,  389,  385,  312,
  392,  382,  381,  551,  391, 2295,    0,   58,   59,   59,
   61,  447,  368,  449,  264,  407, 2081, 3260,  264,  417,
  401,  286, 2087,  261,  380,  263, 2865,  620,  621,  622,
 2275,  475,  476,  610,  611,  651,  301,  424,  419,  329,
   46,  433, 2287, 2288,  423,  328,   40,   41,  286,  299,
   44,  264,   58,   59,  483,   61, 1752,  261,  437,   46,
 1756, 2455, 2456,  301,  310,   59,  435,   41, 2407, 2398,
   44,   58,   59,    0,   61,  620,  621,  622, 1152, 2408,
 1154,  437,  286,   46, 2934, 1159, 1160, 3330,   41,    0,
 1164,   44,  296,  483,  450,  487,  483,  301,    0,  312,
  258,   41, 2431,   59,   44,   41,   42,   43,  488,   45,
  323,   47,  270,    0,   41,  507, 1190,   44,   46,  332,
  499,  500,  368,   46,   41,  419,  330,   44,  520,  332,
   58,   59,   59,   61, 2410,   58,  382,  295,   61,   41,
  519,  264,   44,  301,  291,  303, 3092, 2903,   59, 1010,
 2395, 1012, 2397, 2398,  295,   41,  417,   59,   44,  372,
  369, 2406, 2407, 2408, 2409, 2410, 2411, 2412,  381,  379,
 2498,   41,   59, 3112,   44,   58, 2397, 3361,   61, 3363,
   46, 2937,  340,  401, 2406,   41, 2431,  391,   44,  440,
  348,  442,   58,   59,   41,   61,  400,   44, 2398,  340,
 2445,  316,   41,  379, 2532,   44,  334,  348,  258, 2409,
  423,   41,   41, 2458,   44,   44,  467,  468,  315,   41,
  270,  425,   44, 2468,  437,  333,   59, 2411, 2412,  367,
  327, 2431, 2458, 2534,  487,  363,  315,  378,   41,  380,
  273,   44, 2487,  401, 2534,  295, 2491, 2468,  327, 2053,
 2054,  301,  349,  303,  412, 2500,  335, 2148, 2149, 2504,
  401,  389,  519,  360,  392, 2491,   41,   40,  401,   44,
  349,  368,  651,   41, 2500,  304,   44, 2522, 2504,  407,
 2525,  360,  276,  277,  294,  426,  499,  500, 3177,  283,
  340,    0,  264,  440,  437,  442,  443,  444,  348,   41,
  397,  295,   44,  648,   41,  433,  519,   44,  264,  450,
   41,   46,  264,   44, 2559,  462,  463,  268,  397,   41,
  467,  468,   44,   58,   59, 2570,   61,   41,  270,  596,
   44, 3087,   41, 2559,  282,   44, 2581,  264,  496,    0,
 3293,  277, 3098,  437,  264,  281, 2591, 2592, 3439,  381,
   59,  401, 3443,  500,   41,  496,  340,   44,   41,  487,
   41,   44,  412,   44,   41,   41, 2592,   44,   44, 2591,
  364,  646,   40,  340,  276,  277,  332,   40,  280,  507,
   41,  283,   40,   44,  295,  312,  483,   41,  315,  443,
   44,  385,  520,  295,   40,  322,  323,  391,   59,   40,
  327, 2659, 2647,   41, 2649,  332,   44,  504,  335, 3298,
   41,   40,  368,   44, 2659, 2673,   41,   41,   40,   44,
   44, 2647,  349, 2649,  380,  504,   40, 3183, 2673,  340,
  424,  264, 3295,  360, 3297,   40, 3192,  348,  651,   41,
 2685,  368,   44,   40,   40,  372,  496,  334,   41,   40,
  443,   44,  610,  611,  381,   41,  347,   41,   44, 2704,
   44,  443,  364,   41, 2685,   41,   44,  378,   44,  380,
  397, 2716, 1655,   40,   40, 1658,  363,   40, 2723,   40,
   40,  437, 2704,  385,   40, 2730,   40,  394,   40,  391,
  401,  418,  639,  640,  450, 2740,  423, 2723, 2743,  332,
 2828,   40,  389,  650,   40,  392,   91,  434,  435, 2730,
  437,   40,   40,   40, 2815,  426,   40, 2743,   40, 2740,
  407,   40,  424,   40,   40, 2815,   60,   61,   62,   40,
   40, 2832, 2777,   40,   40,  368,   40,   40,   40,  450,
   40, 2880, 2832,   40,   40,   40,  433,  380,   40,   40,
   40,   40,   40, 2882,    0,   40,  483,  551,   40,   40,
  610,  611,    0,   40,   40,   40,   40,  276,  277,  614,
 3388,   44,  499,  500,  283,   40,   40,  504, 2652, 2653,
 2654, 2655, 2656, 2657,   46,  496,  295,  261,   46,   40,
  368,  370,  519, 2838,  370, 2840,   46,   40,   61,  333,
  487,  333, 2886,  264,  437,   46,  333,  499, 2883,    0,
 3428,   40,  286,   59, 2840,  295, 2838,  450,  357,  270,
  507,   59,  296, 2881,   40,  273, 2884,  301,  382,  437,
  446,   40, 3388,  520,  430, 2880, 2881, 2882, 2883, 2884,
 2885, 2886, 2887,  430,  384,   40,  341,   40, 2893,  551,
   41,  312, 2897,   44,  315,  364,  330,   91, 2903,  295,
   40,  322,  323,   40,   40,  368,  327, 2995,   59,  270,
 2971,  332, 3428,  442,  335,  374,  385,  367,  372,    0,
  257, 2971,  391,   41, 2929,  312, 2987, 2887,  349,   41,
   41,   41, 2937, 2994,   40,  419, 2941, 2987,   46,  360,
   40,  437,  386, 2929, 2994, 2932,    0,  368,  368,  368,
  290,  372,  368,   40,   46,  424, 2937,  391,  260,   44,
  381,  333,  312, 2968,  651,  312,  400,  333,  262,    0,
  264,  314,   44,   46,   44,  509,  397,  271,   59,  496,
 2985,  437,  495,  495,  321,  612,   40,   41,   41,  326,
   44,  425,  395,  306,   44,  371,  371,  483, 3003,  437,
  729,  371,  423,  316,  596,   59,  319,   61,  303,  401,
   41,   40,  437,   44,  435,  348,  437,  371,  609,   40,
   40, 3003, 3040,  355,  318,  500,   41,  756,   59,   41,
   44,  325,   41,   41,  314, 3040,   41,   91,   41,  333,
  418,  262,   44,  380,   44,   44,  314,  333,   46, 3110,
  779,  419,   40,   40, 3090,  616,  350,  277,  352,  396,
   41,  395,  483,   41,  419, 3070,  401, 3072,  362,  417,
  364,  365,  366,   44,  387, 3080,   44,  371,  499,  500,
  419,   44, 3087,  504,   41, 3090, 3091,  314, 3070,  335,
 3072,  335,  373, 3098, 3080,  368, 3138,  290,  519,  368,
    0, 3106,   41,  368,  417, 3110, 3087, 3112,  421,  340,
  435,  484,  340, 3118,  340,  275,  419, 3098,  277,  432,
   40,   59,  590,  303,   59,  276,  277,  332,  334,  280,
  332,   58,  283, 3138, 3139,  442,  334,  276,   59, 3144,
  451,  419,   59,   41,  295,   58,  483,   41,   41,   41,
   61, 3212,  645, 3139,  401,  414,  607,  363, 3144,   59,
  490,  607, 3212,  395, 3225,  363,  314,   40,  303, 3275,
  304,  303,   41,   41,  262, 3225,  419,  273, 3183,  418,
   40,  314,  264,  389,  263,  263,  392, 3192,  335,  314,
  314,  389,  523,  506,  392, 2906, 2907, 2908, 2909, 2910,
 2911,  407, 3183,  417,  258, 3210,  351,  524,   44,  407,
  264, 3192,  521,  364,  295,  322,  401,  369,   40,  273,
  276,  275,  276,  277,  344,  344,  280,  433,  275,  283,
  651,  619,  289,  420,  385,  433,  367,  332,  434,  552,
  391,  295,   40,  371,  371,  276,  277,  301,  371,  371,
  304,   41,  283,  399,  371,  592,  310,  594,  595,  340,
  358,  370, 3267, 3268,  295,   41,  371,  348, 3310,  998,
 3275,    0, 1001,  424,  446,   41,   40, 1006,   44,  446,
 1009,  487,  646, 3288, 1013,   59, 3268,   59, 1017,  487,
  344,   44,  303,  367,   60,   61,   62,  378,   41,  380,
   41,  507,  615,   41,  598, 3310,   41, 3349,  434,  507,
  364,   40,   41,   41,  520,   44,  419,  419,  419,  273,
  401,  369,  520,  522,   40,  419,  419,  431, 3333,  419,
   59,  385,   61,  364,  411,  419,  427,  391,  323,  336,
  344,  395,  312,   41, 3349,  426,    0,  401,  299,  490,
  299,  364,  295,  528,  385,  273,   40,  364,  425,  425,
  391,  330,   91,  296,  330,  419,  296,  325,  314,  450,
  424,  646,   41,  405,   41,  450,   40,   40,    0, 3384,
   40,  450,  357, 3388, 3389,   41,  314,   41,   61,   40,
   44,  446,   44,  424,  448,  314,  431, 3402,  452,  314,
  551,   40,  314,   41,  314,   59,  314, 3388,  314,  314,
   40,  395,  418, 1142,   41,  496,  280,  314,  627,   41,
 3402,  344,   44, 3428, 1153,  264,  275,  368,  344, 1158,
   40,  340,  442, 1162,  334,  418,  303,   59,  304,   61,
   63,  321,  273, 1172, 1173,  370,   44, 3428, 1177, 1178,
 1179,  312, 1181, 1182, 1183, 1184, 1185, 1186, 1187,  334,
 1189,  434, 1191,  363, 1193, 1194, 1195, 1196, 1197,   91,
   44, 1200, 1201, 1202, 1203, 1204, 1205, 1206, 1207, 1208,
 1209, 1210, 1211, 1212, 1213, 1214, 1215,   46,  363,  389,
  299,  336,  392,  336,  273,   41,  262,  551,  401,   41,
  344,  278,   46,  264, 1233,  271,   41,  407,  370,  302,
  299, 1240,  443,  264,  389,  295, 1245,  392,  284,  418,
  551,  483, 1251, 1252,   61,   41,   40,  357,   40,  258,
 1259,  289,  407,  433,  560,  264,    0,  391,  264,  567,
  582,  500,  509,  561,  273,  500,  275,  276,  277,  266,
  264,  280,  318,  448,  283,  376,  329,  628,  433,  325,
  329,  426,  310,   40,  283,   40,  295,  333,  420,  386,
  420,  368,  301,  627,  401,  304,  330,   41, 1307,  603,
   44,  310,  605,  418,  350,  368,  352,  487,   41,  418,
  368,  296,  425,  330,  336,   59,  362,   61,  364,  365,
  366,  401,   44,  445,  427,  371,   40,  507,  427,   40,
    0,  329,  487,  400,  400,  344,    0,  264,  264,   40,
  520,  264,  276,  277,  333,  400,  270,   91,  270,  283,
    0,  303,  507,  400,   40,  364,  258,   41,  395,  434,
  335,  295,  264,  314,  340,  520,  412,   40,  303,   41,
  303,  273,  264,  275,  276,  277,  385,   41,  280,  290,
   44,  283,  391,  289,  368,  335,  395,  303,   59,   41,
   41,   41,  401,  295,   44,   59,   59,  442,   59,  301,
   59,   59,  304,   59,  303,  395,   41,   41,  310,   59,
  419,   59,   61,   59,   40,  424,  314,  303,  454,  455,
  456,  457,  458,  459,  460,  461,   41,  614,   41,  314,
  364,  418,  314,    0,  264,  299,  264,  442,  442,  448,
  519,  476,  344,  452,   46,   46,   41,   42,   43,   44,
   45,  385,   47,   41,   41,  305,   46,  391,  642,  305,
  305,   44,  364,  264,  364,   60,   61,   62,  305,  519,
 1479, 1480,  363, 1482,   41, 1484,  363,   44,   41, 1488,
 1489, 1490, 1491,  385,   44,  593,  551, 1496, 1497,  391,
  424,  264,   59,  395,   61,  593,   91,   46, 1293,  401,
 1670, 2387, 1293, 1293, 1513, 1293, 1515, 2388, 1293, 2389,
 3040, 2897, 3040, 1294,  258, 2067, 2415,  419, 2893, 2291,
  264, 1530,  424, 2827,   91, 2993, 2803,  563, 1468,  273,
 1539, 1540,  276,  277,  350,    0,  280, 2974, 3344,  283,
 2753,  705,  551,   74, 3124, 2219,  448, 2200, 2782, 3255,
  452,  295,  598,  589,  354,  978, 2277,  301, 2804, 2559,
  304, 3204, 3346, 3433, 3379, 2559,  310, 3378, 3394, 2743,
 1579, 3144, 2744, 3176, 1463, 1924,   41, 1922,  608,   44,
 2945, 1032, 2184, 2184, 1593, 3389, 1595, 3390, 3301, 1598,
 1756, 2180, 3186, 3097,   59,    0,   61, 2647, 1619, 1265,
  344, 1445, 1913, 1727,  676, 1125, 2193, 1810, 1095, 1356,
 2236, 1416,  276,  277, 1426,  132, 2088,  551,  627,  283,
  364, 2417, 2422, 3070,  635,  991,  276,  277,  345,  596,
  642, 1696, 2677,  283, 2080, 3075, 1279,    0, 1656, 3003,
 3384,  385, 1699,  646, 2103,    0, 1145,  391, 1657,  551,
    0,  395,    0, 3056, 3056,    0,    0,  401, 3325,  966,
 2264, 1242, 1592, 3210,  684, 3106,  737,  262, 1709,  720,
 1439,  877, 2791, 1261,  878,  419,  271, 2848,   41, 1339,
  424,   44,  277, 2230, 1984, 2487,  281, 1696,  109,  284,
 1699,  258, 1701,  131, 2082, 2885,   59,  264,   61, 1276,
  364, 3382, 1711, 2414,  448, 1134,  273, 1918,  452,  276,
  277, 2581, 3104,  280,  364, 3273,  283, 2720,  368, 3348,
 1045,  385, 2490,  318,   12,  627, 3292,  391,  295, 3230,
  325, 1027,   -1, 2680,  301,  385,   -1,  304,  333,   -1,
 1749,  391,   -1,  310,    0,   -1,   -1,   -1, 1757,   -1,
   -1,   -1,   -1,   -1,   -1,  350,   -1,  352,   -1,   -1,
  424,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,  364,
  365,  366,   -1,   -1,  424,   -1,  371,  344,   -1,   -1,
   -1,   -1,    0,   -1,   -1,   41,   -1,   -1,   44,   -1,
   -1,   -1,   -1,  258,   -1,   -1,   -1,  364,   -1,  264,
   -1,   -1,   -1,   59,   -1,   61,   -1,  551,  273,   -1,
   -1,   -1,  277,   -1,   -1,  280,   -1,  412,  385,  483,
   -1,   -1,   -1,   41,  391,   -1,   44,    0,  395,   -1,
  295,   -1,   -1,  483,  401,   91,  301,   -1,   -1,  304,
   -1,   59,   -1,   61,   -1,  310,   -1,   -1,   -1,   -1,
   -1,   -1,  419,   -1,   -1,   -1,   -1,  424,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   41,   -1,
   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  344,
   -1,  448,   -1,  627,   -1,  452,   59,   -1,   61,   -1,
   -1,   -1,   -1,   -1,   -1,  258,   -1,   -1,   -1,  364,
   -1,  264,   -1,   -1,   -1,   -1,   41,   -1,   -1,   44,
   -1,   -1,  275,  276,  277,   -1,   -1,  280,   45,   -1,
  283,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,
  395,   -1,  295,   -1,   -1, 1944,  401,   -1,  301,   -1,
   -1, 1950,   -1,   -1,   -1,   -1, 1955,  310,   -1, 1958,
 1959, 1960,   -1,   -1,  419,   -1, 1965,   -1, 1967,   -1,
   -1,   -1,   -1,   -1,   -1, 1974,   -1, 1976,   -1,   -1,
 1979, 1980, 1981, 1982,   -1,   -1, 1985,   -1, 1987,   -1,
 1989,   -1, 1991,  448,  551,   -1,   -1,  452, 1997, 1998,
 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008,
   -1,  364,  258,  598,   -1,   -1,   -1,   -1,  264, 2018,
  605,    0,   -1,   -1, 2023,   -1,   -1,  273, 2027,   -1,
  276,  277,  385,   -1,  280,    0,   -1,  283,  391,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  399,   -1,  401,  295,
  258,   -1,   -1,   -1,   -1,  301,  264,   -1,  304,   -1,
   -1,  414,   41,   -1,  310,   44,  419,  275,  276,  277,
  627,  424,  280,   -1,   -1,  283,   41,   -1,   -1,   44,
   59,   -1,   61,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,   -1,   -1,  301,   59,  258,  551,   -1,  344,  452,
   -1,  264,  310,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
 2109,   -1,  275,  276,  277,   -1,   -1,  280,  364,   -1,
  283,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,   -1,  301,  385,
   -1,   -1,   -1,   -1,   -1,  391,   -1,  310,   -1,  395,
   -1,  276,  277,   -1,   -1,  401,  364,   -1,  283,   -1,
   -1,   -1,   -1, 2162,   -1, 2164,   41,   -1,   -1,   -1,
   -1,   -1,  627,  419,  291,   -1,   -1,  385,  424,   -1,
   -1,   -1,   -1,  391,   -1,   60,   61,   62,   -1,   -1,
   -1,  399,   -1,  401,   -1,   -1,   -1,   -1,  551,   -1,
  317,  364,  448,   -1,   -1,   -1,  452,   -1,   -1,   -1,
   -1,  419,   -1,   -1,   -1,   -1,  424,   -1,   -1,   -1,
   -1,   -1,  385,   -1,   -1,   -1,  275,  344,  391,   -1,
   -1,   -1,   -1,   41,   -1,   -1,   44,   -1,  401,  364,
   -1,  290,   -1,   -1,  452,   -1,   -1,   -1,   -1,   -1,
   -1,  300,   60,   61,   62,   -1,  419,  306,   -1,   -1,
  385,  424,  311,   -1,   -1,   -1,  391,  316,   -1,   -1,
  319,   -1,   -1,   -1,  627,   -1,   -1,   -1,   -1,  258,
   -1,   -1,   -1,   -1,   -1,  264,   -1,   -1,   -1,  452,
   -1,   -1,   -1,  410,   -1,   -1,   -1,  276,  277,  424,
    0,  280,   -1,   -1,  283,  551,   -1,   -1,   -1,  426,
   -1,  276,  277,   -1,   -1,   -1,  295,   -1,  283,  368,
   -1, 2320,  301,  440,   -1,  442,  443,  444, 2327, 2328,
   -1,  310,   -1,   -1,   -1, 2334,   -1,   -1,  387,   -1,
   -1,   41,   -1,  551,   44,  462,  463,  464,  465,  466,
  467,  468,  469,  470,   41,   -1,   -1,   44,  483,   59,
  477,  478, 2361,   -1,   -1, 2364,   -1, 2366,  417,  486,
   -1,   -1,   -1,   60,   61,   62,   -1,   -1,   -1,   -1,
   -1,  627,   -1,  432,   -1,  364,   -1,  262,  551,   -1,
   -1,   -1,   -1,    0,   -1,   -1,  271,   41,   -1,  364,
   44,  450,   -1,   -1,   -1,   -1,  385,   -1,   -1,  284,
   -1,   -1,  391,   -1,   -1,   -1,   60,   61,   62,  627,
  385,   -1,  401,   -1,   -1,   -1,  391,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   41,   -1,   -1,   44,   -1,  314,
  419,   -1,   -1,  318,   -1,  424,   -1,   -1,   -1, 2448,
  325,   -1,   59,   -1,  262,   -1,   -1,  506,  333,  424,
  509,   -1,   41,  271,  627,   44,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  452,   -1,  350,  284,  352,   -1,   -1,
 2479,   60,   61,   62,   -1,   -1,   -1,  362,   -1,  364,
  365,  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,   -1,   -1,
  637,   -1,  639,  640,  641,  333,   -1,   -1,   -1,   41,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,   -1,
   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,   60,   61,
   62,  668,  669,   -1,  362,   -1,  364,  365,  366,   41,
   -1,   -1,   -1,  371,   -1,   -1,  615,   -1,   -1,   -1,
   -1,   -1,  551,   -1,   -1,  262,  276,  277,   60,   61,
   62,   -1,   -1,  283,  271,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1, 2598,
   -1, 2600,   -1, 2602,  412,   -1,   -1, 2606,   -1,   -1,
   -1,   -1, 2611, 2612, 2613, 2614, 2615,   -1,  262,   -1,
   -1, 2620,   -1, 2622,   -1, 2624,   -1,  271,   -1,   -1,
   -1,  318,   -1,   -1,   -1,   41,   -1,   -1,  325,   -1,
  284,   -1, 2641,   -1,   -1,   -1,  333,   -1,  627,   -1,
   -1,   -1,   -1,   -1,   60,   61,   62,   -1,   -1,   -1,
   -1,   -1,   -1,  350,  364,  352,   -1,   -1,   -1,  276,
  277,   -1,   -1,   -1,  318,  362,  283,  364,  365,  366,
   41,  325, 2681,  262,  371,  385,   -1,   -1,   -1,  333,
   -1,  391,  271,   -1,   -1,   -1,   -1,   -1, 2696,   60,
   61,   62,   -1,   -1,   -1,  284,  350,   -1,  352,   -1,
   -1, 2710, 2711,   -1,   -1,   -1,   -1,   -1,  362,   -1,
  364,  365,  366,  598,  424,  412,   -1,  371,   -1, 2728,
   -1,   -1,   -1,   -1,   -1,   -1,   -1, 2736, 2737,  318,
   -1,   41,   -1,   -1,   -1,   -1,  325,   -1,   -1,   -1,
  262,   -1,   -1,    0,  333,   -1,   -1,  364,   -1,  271,
   60,   61,   62,   -1,   -1,   -1,   -1,   -1,  412, 2768,
   -1,  350,  284,  352,   -1,   -1,   -1,   -1,  385,   -1,
  262,   -1,   -1,  362,  391,  364,  365,  366,   -1,  271,
  598,   -1,  371,   -1,   41,   -1,   -1,   44,   -1,   -1,
  312,   -1,  284,   -1,   -1,   -1,  318,   -1,   -1,   -1,
   41,   -1,   59,  325,   -1,   -1,   -1,  424,   -1,   -1,
   -1,  333,   -1,   60,   61,   62,   -1,   -1,   -1,   60,
   61,   62,   -1,  412,   -1,   -1,  318,   -1,  350,   -1,
  352,   -1,   -1,  325,   -1,   -1,   -1,   -1, 2847, 2848,
  362,  333,  364,  365,  366,   -1,  262,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,  271,   -1,   -1,  350,   -1,
  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,
  362, 2879,  364,  365,  366,   -1,   -1,   -1,   -1,  371,
   -1,   -1,   -1, 2891,   -1,   -1,   -1,   -1,   -1,   -1,
  412,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  271,  598,  318,   -1, 2912, 2913,   -1,   -1,   -1,  325,
   -1,   -1,   -1,  284,   -1,   -1,   -1,  333,   -1,   -1,
  412,   -1,   -1,   -1,   -1, 2934,    0,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  598,   -1,  362,  318,  364,  365,
  366,   -1,  262,   -1,  325,  371,   -1,   -1,   -1,   -1,
   -1,  271,  333,   -1,   -1,   -1,   40,   41,   -1,   43,
   44,   45,   46,   -1,  284,   -1,   -1,   -1,   -1,  350,
   -1,  352,   -1, 2992,   58,   59,   -1,   -1,   -1,   63,
   -1,  362,   -1,  364,  365,  366,  412,   -1,   -1,   -1,
  371,   -1,   -1, 3012,   -1,   -1,   -1,   -1,  318,  598,
   -1, 3020,   -1, 3022,   -1,  325,   -1,   -1,   -1,  276,
  277,  262,   -1,  333,  271,   -1,  283,   -1,   -1,   -1,
  271,   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,   -1,
  350,  412,  352,  284,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  362,   -1,  364,  365,  366,   -1,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1, 3075,   -1,   -1,   -1,
   -1,  318,   -1,   -1,   -1,   -1,  598,  318,  325,   -1,
   -1,   -1,   -1,   -1,  325,   -1,  333,   -1,   -1,   -1,
   -1,   -1,  333,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  412,  350,   -1,  352,  598,  364,   -1,  350,
   -1,  352,   -1,   -1,   -1,  362,   -1,  364,  365,  366,
   -1,  362,   -1,  364,  365,  366,   -1,   -1,  385,   -1,
  371,   -1, 3141,   -1,  391,   -1,   -1, 3145, 3146, 3147,
 3148, 3149, 3150, 3151,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1, 3160, 3161, 3162, 3163, 3164, 3165, 3166,   -1,
   -1,   -1,   -1,   -1,   -1,  412,   -1,  424,   -1,   -1,
   -1,  412,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  598,  257,   -1,  259,   -1,   -1,   -1,   -1,
  264,  265,   -1,  267,  268,  269,   -1,   -1,   -1,   -1,
  274,   -1,   -1,   -1,   -1,  279,  280,   -1,  282,   -1,
  284,  285,   -1,  287,   -1,   -1,  290,  291,  292,   -1,
   -1,   -1,   -1,  297,   -1,  299,  300,  598,   -1,   -1,
  304,   -1,  306,   -1,  308,  309,   -1,   -1,  312,   -1,
   -1,  315,   -1,  317,   -1,  319,  320,   -1,  322,  323,
  324,   -1,  326,  327,  328,   -1,   -1,   -1,  332,   -1,
  334,  335,  336,   -1,   -1,   -1,  340,   -1,   -1,   -1,
  344,   -1,  346,  347,  348,  349,   -1,  351,   -1,  353,
  354,   -1,  356,  357,  358,   -1,  360,   -1,  598,   -1,
  364,   -1,   -1,   -1,  368, 3304,  370, 3306,  372,   -1,
  374,  375,  376,  377,  378,   -1,  380,  381,  382,   -1,
   -1,   -1,  386, 3322,  388,  389,   -1,   -1,  392,  393,
  394,   -1,   -1,  397, 3333,  399, 3335, 3336,  402,  403,
  404,  405,   -1,  407,   -1,  409,  410,  411,  412,  413,
  414,  415,  416, 3352,   -1,   -1,  420,   -1,  422,  423,
   -1,  598,  426,   -1,   -1,   -1,   -1,  598,   -1,  433,
   -1,  435,   -1,  437,  438,  439,  440,  441,  442,  443,
  444,  445,   -1,  447,  448,  449,  450,   -1,  452,  453,
   -1, 3390, 3391, 3392,   -1,   -1,  460,  461,  462,  463,
  464,  465,  466,  467,  468,  469,  470,  471,  472,   -1,
  474,  475,  476,  477,  478,   -1,  480,  481,  482,  483,
  484,  485,  486,  487,   -1,   -1,  490,  491,  492,  493,
  494,  495,  496,   -1,   -1,  499,  500,  501,  502,  503,
  504,  505,  506,  507,   -1,  509,   -1,  511,  512,  513,
   -1,  515,  516,   -1,  518,  519,  520,  521,  522,  523,
  524,  525,  526,  527,  528,  529,  530,  531,  532,  533,
  534,  535,  536,  537,  538,  539,   -1,  541,  542,  543,
  544,  545,  546,   -1,  548,  549,  550,  551,   -1,  553,
   -1,  555,  556,  557,  558,  559,  560,  561,  562,  563,
  564,  565,  566,  567,  568,  569,  570,  571,  572,   -1,
  574,  575,  576,  577,   -1,  579,  580,  581,  582,  583,
   -1,  585,  586,  587,  588,  589,  590,  591,  592,  593,
  594,  595,  596,  597,   -1,  599,  600,  601,  602,  603,
  604,   -1,  606,  607,  608,  609,  610,  611,  612,  613,
   -1,  615,  616,  617,  618,   -1,  620,  621,  622,  623,
  624,  625,   -1,   -1,  628,  629,  630,  631,  632,  633,
  634,  635,  636,  637,    0,  639,  640,  641,  642,  643,
  644,  645,  646,  647,  648,  649,   -1,  651,  652,  653,
  654,  655,  656,  657,  658,  659,  660,  661,  662,  663,
  664,  665,  666,  667,  668,  669,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   41,   42,   43,   44,   45,
   -1,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   59,   60,   61,   62,  272,   -1,   -1,
  275,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  275,   -1,  287,   -1,   -1,   -1,  291,   -1,  293,   -1,
   -1,   -1,   -1,   -1,   -1,  290,   -1,   93,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  300,   -1,   -1,   -1,   -1,
   -1,  306,  306,   -1,   -1,   -1,  311,   -1,   -1,   -1,
   -1,  316,  316,   -1,  319,  319,  331,   -1,   -1,   -1,
   -1,   -1,  337,  338,  339,   -1,  341,  342,  343,   -1,
  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,   -1,  361,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  368,  379,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  390,   -1,   -1,   -1,   -1,
   -1,   -1,  387,  387,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  406,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  417,  428,   -1,   -1,   -1,  421,   -1,   -1,
   -1,   -1,  426,   -1,   -1,   -1,   -1,  432,  432,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  450,   -1,  462,  463,   -1,
   -1,  257,  258,  259,   -1,   -1,  262,   -1,  264,  265,
   -1,   -1,  268,  269,  479,  271,   -1,   -1,   -1,   -1,
  276,  277,   -1,  279,  280,  281,  282,  283,  284,   -1,
   -1,  287,   -1,   -1,  290,   -1,   -1,   -1,   -1,   -1,
   -1,  297,   -1,  299,  300,  301,  302,  303,  304,  305,
  306,  506,  506,  309,  509,   -1,  312,   -1,  314,  315,
   -1,   -1,  318,  319,  320,   -1,  322,  323,  324,  325,
  326,  327,  328,   -1,   -1,   -1,  332,  333,  334,  335,
  336,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  348,  349,  350,  351,  352,  353,  552,   -1,
   -1,  357,  358,   -1,  360,   -1,  362,   -1,  364,  365,
  366,   -1,  368,   -1,  370,  371,  372,   -1,  374,  375,
  376,  377,  378,   -1,  380,  381,   -1,   -1,   -1,  385,
  386,    0,  388,  389,   -1,  391,  392,  393,  394,   -1,
   -1,  397,  596,  399,   -1,  401,  402,  403,  404,  405,
   -1,  407,   -1,  409,   -1,  411,  412,  413,  414,  415,
  615,  615,  418,  419,  420,   -1,  422,  423,  424,   -1,
   -1,   -1,   41,  638,   -1,   44,   -1,  433,  434,  435,
   -1,  437,  438,  439,   -1,  441,   -1,   -1,   -1,  445,
   59,  447,  448,  449,  450,   -1,  452,   -1,  454,  455,
  456,  457,  458,  459,  460,  461,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  471,  472,   41,  474,  475,
  476,   -1,   -1,   -1,   -1,  481,  482,  483,  484,  485,
   -1,  487,   -1,   -1,  490,  491,   60,   61,   62,  495,
  496,   41,   -1,  499,  500,  501,  502,  503,  504,  505,
  506,  507,   -1,  509,   -1,   -1,   -1,   -1,   -1,   -1,
   60,   61,   62,  519,  520,  521,  522,  523,  524,  525,
  526,  527,  528,  529,  530,  531,  532,  533,  534,  535,
  536,  537,  538,  539,   -1,  541,  542,  543,  544,  545,
  546,   -1,  548,  549,  550,  551,   -1,  553,   -1,  555,
  556,  557,  558,  559,  560,  561,  562,  563,  564,  565,
  566,  567,  568,  569,  570,  571,  572,   -1,  574,  575,
  576,  577,   -1,  579,  580,  581,  582,  583,   -1,  585,
  586,  587,  588,  589,  590,  591,  592,  593,  594,  595,
  596,  597,  598,  599,  600,  601,  602,  603,  604,   -1,
  606,  607,  608,  609,  610,  611,  612,  613,    0,  615,
  616,  617,  618,   -1,  620,  621,  622,  623,  624,  625,
   -1,   -1,  628,  629,  630,  631,  632,  633,  634,  635,
  636,   -1,   -1,   -1,   -1,   -1,  642,   -1,  644,  645,
  646,  647,  648,  649,   -1,  651,   -1,   -1,   -1,   41,
   42,   43,   44,   45,   -1,   47,   -1,  276,  277,   -1,
   -1,   -1,   -1,   -1,  283,   -1,   -1,   59,   60,   61,
   62,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,   -1,   -1,
   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  284,   -1,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  318,  364,   -1,   -1,   -1,   -1,
   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,
   -1,   -1,   -1,   -1,   -1,   -1,  385,   -1,  318,   -1,
   -1,   -1,  391,   -1,   -1,  325,  350,   -1,  352,   -1,
   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,  362,   -1,
  364,  365,  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,
  350,   -1,  352,   -1,   -1,  424,   -1,   -1,   -1,   -1,
   -1,   -1,  362,   -1,  364,  365,  366,   -1,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  412,   -1,   -1,  257,  258,  259,   -1,   -1,
  262,   -1,  264,  265,   -1,   -1,  268,  269,   -1,  271,
   -1,   -1,   -1,   -1,  276,  277,   -1,  279,  280,  281,
  282,  283,  284,   -1,   -1,  287,   -1,   -1,  290,   -1,
   -1,   -1,   -1,   -1,   -1,  297,   -1,  299,  300,  301,
  302,  303,  304,  305,  306,   -1,   -1,  309,   -1,   -1,
  312,   -1,  314,  315,   -1,   -1,  318,  319,  320,   -1,
  322,  323,  324,  325,  326,  327,  328,   -1,   -1,   -1,
  332,  333,  334,  335,  336,   -1,   -1,   -1,  340,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  350,  351,
  352,  353,   -1,   -1,   -1,  357,  358,   -1,  360,   -1,
  362,   -1,  364,  365,  366,   -1,  368,   -1,  370,  371,
  372,   -1,  374,  375,  376,  377,  378,   -1,  380,  381,
   -1,   -1,   -1,  385,  386,   -1,  388,  389,   -1,  391,
  392,  393,  394,   -1,   -1,  397,   -1,  399,   -1,  401,
  402,  403,  404,  405,   -1,  407,   -1,  409,   -1,  411,
  412,  413,  414,  415,  598,   -1,  418,  419,  420,   -1,
  422,  423,  424,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  433,  434,  435,   -1,  437,  438,  439,  598,  441,
   -1,   -1,   -1,  445,   -1,  447,  448,  449,  450,   -1,
  452,   -1,  454,  455,  456,  457,  458,  459,  460,  461,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  471,
  472,   41,  474,  475,  476,   -1,   -1,   -1,   -1,  481,
  482,  483,  484,  485,   -1,  487,   -1,   -1,  490,  491,
   60,   61,   62,  495,  496,   41,   -1,  499,  500,  501,
  502,  503,  504,  505,  506,  507,   -1,  509,   -1,   -1,
   -1,   -1,   -1,   -1,   60,   61,   62,  519,  520,  521,
  522,  523,  524,  525,  526,  527,  528,  529,  530,  531,
  532,  533,  534,  535,  536,  537,  538,  539,   -1,  541,
  542,  543,  544,  545,  546,   -1,  548,  549,  550,  551,
   -1,  553,   -1,  555,  556,  557,  558,  559,  560,  561,
  562,  563,  564,  565,  566,  567,  568,  569,  570,  571,
  572,   -1,  574,  575,  576,  577,   -1,  579,  580,  581,
  582,  583,   -1,  585,  586,  587,  588,  589,  590,  591,
  592,  593,  594,  595,  596,  597,  598,  599,  600,  601,
  602,  603,  604,   -1,  606,  607,  608,  609,  610,  611,
  612,  613,    0,  615,  616,  617,  618,   -1,  620,  621,
  622,  623,  624,  625,   -1,   -1,  628,  629,  630,  631,
  632,  633,  634,  635,  636,   -1,   -1,   -1,   -1,   -1,
  642,   -1,  644,  645,  646,  647,  648,  649,   -1,  651,
   -1,  261,   40,   41,   42,   43,   44,   45,   46,   47,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  278,   -1,
   58,   59,   60,   61,   62,   -1,  286,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  294,   -1,  296,   -1,   -1,   -1,
   -1,  301,  262,   -1,   -1,   -1,   -1,  307,   -1,   -1,
   -1,  271,   -1,   91,   -1,   93,   -1,   -1,   -1,   -1,
   -1,  321,   -1,   -1,  284,   -1,  262,   -1,   -1,   -1,
  330,   -1,   -1,   -1,   -1,  271,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,
   -1,   -1,   -1,   -1,   -1,  355,   -1,   -1,  318,   -1,
   -1,   -1,   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,
  350,   -1,  352,   -1,   -1,   -1,  396,  333,  398,   -1,
   -1,  401,  362,   -1,  364,  365,  366,   -1,   -1,   -1,
   -1,  371,   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  425,  362,   -1,  364,  365,
  366,   -1,   -1,   -1,   -1,  371,   -1,  437,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  412,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  473,   -1,   -1,  412,   -1,   -1,  257,
   -1,  259,   -1,   -1,  262,   -1,  264,  265,  488,  489,
  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  277,
   -1,  279,  280,  281,  282,   -1,  284,   -1,   -1,  287,
  510,   -1,  290,   -1,   -1,   -1,   -1,   -1,   -1,  297,
   -1,  299,  300,   -1,  302,  303,  304,  305,  306,   -1,
   -1,  309,   -1,   -1,  312,   -1,  314,  315,   -1,   -1,
  318,  319,  320,   -1,  322,  323,  324,  325,  326,  327,
  328,   -1,   -1,   -1,  332,  333,  334,  335,  336,   -1,
   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  348,  349,  350,  351,  352,  353,   -1,   -1,   -1,  357,
  358,   -1,  360,   -1,  362,   -1,  364,  365,  366,   -1,
  368,   -1,  370,  371,  372,   -1,  374,  375,  376,  377,
  378,   -1,  380,  381,   -1,   -1,   -1,   -1,  386,   -1,
  388,  389,   -1,   -1,  392,  393,  394,   -1,   -1,  397,
   -1,  399,   -1,   -1,  402,  403,  404,  405,   -1,  407,
   -1,  409,   -1,  411,  412,  413,  414,  415,  598,   -1,
  418,  419,  420,   -1,  422,  423,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  433,  434,  435,   -1,  437,
  438,  439,  598,  441,   -1,   -1,   -1,  445,   -1,  447,
  448,  449,  450,   -1,  452,   -1,  454,  455,  456,  457,
  458,  459,  460,  461,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  471,  472,   41,  474,  475,  476,   -1,
   -1,   -1,   -1,  481,  482,  483,  484,  485,   -1,  487,
   -1,   -1,  490,  491,   60,   61,   62,  495,  496,   41,
   -1,  499,  500,  501,  502,  503,  504,  505,  506,  507,
   -1,  509,   -1,   -1,   -1,   -1,   -1,   -1,   60,   61,
   62,  519,  520,  521,  522,  523,  524,  525,  526,  527,
  528,  529,  530,  531,  532,  533,  534,  535,  536,  537,
  538,  539,   -1,  541,  542,  543,  544,  545,  546,   -1,
  548,  549,  550,  551,   -1,  553,   -1,  555,  556,  557,
  558,  559,  560,  561,  562,  563,  564,  565,  566,  567,
  568,  569,  570,  571,  572,   -1,  574,  575,  576,  577,
   -1,  579,  580,  581,  582,  583,   -1,  585,  586,  587,
  588,  589,  590,  591,  592,  593,  594,  595,  596,  597,
  598,  599,  600,  601,  602,  603,  604,  605,  606,  607,
  608,  609,  610,  611,  612,  613,    0,  615,  616,  617,
  618,   -1,  620,  621,  622,  623,  624,  625,   -1,   -1,
  628,  629,  630,  631,  632,  633,  634,  635,  636,   -1,
   -1,   -1,   -1,   -1,  642,   -1,  644,  645,  646,  647,
  648,  649,   -1,  651,   -1,   -1,   40,   41,   42,   43,
   44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   58,   59,   60,   61,   62,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  271,   -1,   91,   -1,   93,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,
  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,
   -1,   -1,   -1,  325,  350,   -1,  352,   -1,   -1,   -1,
   -1,  333,   -1,   -1,   -1,   -1,  362,   -1,  364,  365,
  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,  350,   -1,
  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  362,   -1,  364,  365,  366,   -1,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  412,   -1,   -1,  257,   -1,  259,   -1,   -1,  262,   -1,
  264,  265,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,
   -1,   -1,   -1,  277,   -1,  279,  280,  281,  282,   -1,
  284,   -1,   -1,  287,   -1,   -1,  290,   -1,   -1,   -1,
   -1,   -1,   -1,  297,   -1,  299,  300,   -1,  302,  303,
  304,  305,  306,   -1,   -1,  309,   -1,   -1,  312,   -1,
  314,  315,   -1,   -1,  318,  319,  320,   -1,  322,  323,
  324,  325,  326,  327,  328,   -1,   -1,   -1,  332,  333,
  334,  335,  336,   -1,   -1,   -1,  340,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  348,  349,  350,  351,  352,  353,
   -1,   -1,   -1,  357,  358,   -1,  360,   -1,  362,   -1,
  364,  365,  366,   -1,  368,   -1,  370,  371,  372,   -1,
  374,  375,  376,  377,  378,   -1,  380,  381,   -1,   -1,
   -1,   -1,  386,   -1,  388,  389,   -1,   -1,  392,  393,
  394,   -1,   -1,  397,   -1,  399,   -1,   -1,  402,  403,
  404,  405,   -1,  407,   -1,  409,   -1,  411,  412,  413,
  414,  415,  598,   -1,  418,  419,  420,   -1,  422,  423,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,
  434,  435,   -1,  437,  438,  439,  598,  441,   -1,   -1,
   -1,  445,   -1,  447,  448,  449,  450,   -1,  452,   -1,
  454,  455,  456,  457,  458,  459,  460,  461,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  471,  472,   41,
  474,  475,  476,   -1,   -1,   -1,   -1,  481,  482,  483,
  484,  485,   -1,  487,   -1,   -1,  490,  491,   60,   61,
   62,  495,  496,   41,   -1,  499,  500,  501,  502,  503,
  504,  505,  506,  507,   -1,  509,   -1,   -1,   -1,   -1,
   -1,   -1,   60,   61,   62,  519,  520,  521,  522,  523,
  524,  525,  526,  527,  528,  529,  530,  531,  532,  533,
  534,  535,  536,  537,  538,  539,   -1,  541,  542,  543,
  544,  545,  546,   -1,  548,  549,  550,  551,   -1,  553,
   -1,  555,  556,  557,  558,  559,  560,  561,  562,  563,
  564,  565,  566,  567,  568,  569,  570,  571,  572,   -1,
  574,  575,  576,  577,   -1,  579,  580,  581,  582,  583,
   -1,  585,  586,  587,  588,  589,  590,  591,  592,  593,
  594,  595,  596,  597,  598,  599,  600,  601,  602,  603,
  604,  605,  606,  607,  608,  609,  610,  611,  612,  613,
    0,  615,  616,  617,  618,   -1,  620,  621,  622,  623,
  624,  625,   -1,   -1,  628,  629,  630,  631,  632,  633,
  634,  635,  636,   -1,   -1,   -1,   -1,   -1,  642,   -1,
  644,  645,  646,  647,  648,  649,   -1,  651,   -1,   -1,
   40,   41,   42,   43,   44,   45,   46,   47,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,
   60,   61,   62,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,
   -1,   91,   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  284,   -1,  262,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,
   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  333,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,  350,   -1,
  352,   -1,   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,
  362,   -1,  364,  365,  366,   -1,   -1,   -1,   -1,  371,
   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  362,   -1,  364,  365,  366,   -1,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  412,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  412,   -1,   -1,  257,   -1,  259,
   -1,   -1,  262,   -1,  264,  265,   -1,   -1,  268,  269,
   -1,  271,   -1,   -1,   -1,   -1,   -1,  277,   -1,  279,
  280,  281,  282,   -1,  284,   -1,   -1,  287,   -1,   -1,
  290,   -1,   -1,   -1,   -1,   -1,   -1,  297,   -1,  299,
  300,   -1,  302,  303,  304,  305,  306,   -1,   -1,  309,
   -1,   -1,  312,   -1,  314,  315,   -1,   -1,  318,  319,
  320,   -1,  322,  323,  324,  325,  326,  327,  328,   -1,
   -1,   -1,  332,  333,  334,  335,  336,   -1,   -1,   -1,
  340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,
  350,  351,  352,  353,   -1,   -1,   -1,  357,  358,   -1,
  360,   -1,  362,   -1,  364,  365,  366,   -1,  368,   -1,
  370,  371,  372,   -1,  374,  375,  376,  377,  378,   -1,
  380,  381,   -1,   -1,   -1,   -1,  386,   -1,  388,  389,
   -1,   -1,  392,  393,  394,   -1,   -1,  397,   -1,  399,
   -1,   -1,  402,  403,  404,  405,   -1,  407,   -1,  409,
   -1,  411,  412,  413,  414,  415,  598,   -1,  418,  419,
  420,   -1,  422,  423,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  433,  434,  435,   -1,  437,  438,  439,
  598,  441,   -1,   -1,   -1,  445,   -1,  447,  448,  449,
  450,   -1,  452,   -1,  454,  455,  456,  457,  458,  459,
  460,  461,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  471,  472,   41,  474,  475,  476,   -1,   -1,   -1,
   -1,  481,  482,  483,  484,  485,   -1,  487,   -1,   -1,
  490,  491,   60,   61,   62,  495,  496,   41,   -1,  499,
  500,  501,  502,  503,  504,  505,  506,  507,   -1,  509,
   -1,   -1,   -1,   -1,   -1,   -1,   60,   61,   62,  519,
  520,  521,  522,  523,  524,  525,  526,  527,  528,  529,
  530,  531,  532,  533,  534,  535,  536,  537,  538,  539,
   -1,  541,  542,  543,  544,  545,  546,   -1,  548,  549,
  550,  551,   -1,  553,   -1,  555,  556,  557,  558,  559,
  560,  561,  562,  563,  564,  565,  566,  567,  568,  569,
  570,  571,  572,   -1,  574,  575,  576,  577,   -1,  579,
  580,  581,  582,  583,   -1,  585,  586,  587,  588,  589,
  590,  591,  592,  593,  594,  595,  596,  597,  598,  599,
  600,  601,  602,  603,  604,  605,  606,  607,  608,  609,
  610,  611,  612,  613,    0,  615,  616,  617,  618,   -1,
  620,  621,  622,  623,  624,  625,   -1,   -1,  628,  629,
  630,  631,  632,  633,  634,  635,  636,   -1,   -1,   -1,
   -1,   -1,  642,   -1,  644,  645,  646,  647,  648,  649,
   -1,  651,   -1,   -1,   40,   41,   42,   43,   44,   45,
   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   58,   59,   60,   61,   62,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  271,   -1,   91,   -1,   93,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,  262,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,
   -1,  325,  350,   -1,  352,   -1,   -1,   -1,   -1,  333,
   -1,   -1,   -1,   -1,  362,   -1,  364,  365,  366,   -1,
   -1,   -1,   -1,  371,   -1,   -1,  350,   -1,  352,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,
  364,  365,  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  412,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,
   -1,  257,   -1,  259,   -1,   -1,  262,   -1,  264,  265,
   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,
   -1,  277,   -1,  279,  280,  281,  282,   -1,  284,   -1,
   -1,  287,   -1,   -1,  290,   -1,   -1,   -1,   -1,   -1,
   -1,  297,   -1,  299,  300,   -1,  302,  303,  304,  305,
  306,   -1,   -1,  309,   -1,   -1,  312,   -1,  314,  315,
   -1,   -1,  318,  319,  320,   -1,  322,  323,  324,  325,
  326,  327,  328,   -1,   -1,   -1,  332,  333,  334,  335,
  336,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  348,  349,  350,  351,  352,  353,   -1,   -1,
   -1,  357,  358,   -1,  360,   -1,  362,   -1,  364,  365,
  366,   -1,  368,   -1,  370,  371,  372,   -1,  374,  375,
  376,  377,  378,   -1,  380,  381,   -1,   -1,   -1,   -1,
  386,   -1,  388,  389,   -1,   -1,  392,  393,  394,   -1,
   -1,  397,   -1,  399,   -1,   -1,  402,  403,  404,  405,
   -1,  407,   -1,  409,   -1,  411,  412,  413,  414,  415,
  598,   -1,  418,  419,  420,   -1,  422,  423,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,  434,  435,
   -1,  437,  438,  439,  598,  441,   -1,   -1,   -1,  445,
   -1,  447,  448,  449,  450,   -1,  452,   -1,  454,  455,
  456,  457,  458,  459,  460,  461,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  471,  472,   41,  474,  475,
  476,   -1,   -1,   -1,   -1,  481,  482,  483,  484,  485,
   -1,  487,   -1,   -1,  490,  491,   60,   61,   62,  495,
  496,   41,   -1,  499,  500,  501,  502,  503,  504,  505,
  506,  507,   -1,  509,   -1,   -1,   -1,   -1,   -1,   -1,
   60,   61,   62,  519,  520,  521,  522,  523,  524,  525,
  526,  527,  528,  529,  530,  531,  532,  533,  534,  535,
  536,  537,  538,  539,   -1,  541,  542,  543,  544,  545,
  546,   -1,  548,  549,  550,  551,   -1,  553,   -1,  555,
  556,  557,  558,  559,  560,  561,  562,  563,  564,  565,
  566,  567,  568,  569,  570,  571,  572,   -1,  574,  575,
  576,  577,   -1,  579,  580,  581,  582,  583,   -1,  585,
  586,  587,  588,  589,  590,  591,  592,  593,  594,  595,
  596,  597,  598,  599,  600,  601,  602,  603,  604,  605,
  606,  607,  608,  609,  610,  611,  612,  613,    0,  615,
  616,  617,  618,   -1,  620,  621,  622,  623,  624,  625,
   -1,   -1,  628,  629,  630,  631,  632,  633,  634,  635,
  636,   -1,   -1,   -1,   -1,   -1,  642,   -1,  644,  645,
  646,  647,  648,  649,   -1,  651,   -1,   -1,   40,   41,
   42,   43,   44,   45,   46,   47,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60,   61,
   62,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,   -1,   91,
   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  284,   -1,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,
   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,
   -1,   -1,   -1,   -1,   -1,  325,  350,   -1,  352,   -1,
   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,  362,   -1,
  364,  365,  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,
  350,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  362,   -1,  364,  365,  366,   -1,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  412,   -1,   -1,  257,   -1,  259,   -1,   -1,
  262,   -1,  264,  265,   -1,   -1,  268,  269,   -1,  271,
   -1,   -1,   -1,   -1,   -1,  277,   -1,  279,  280,  281,
  282,   -1,  284,   -1,   -1,  287,   -1,   -1,  290,   -1,
   -1,   -1,   -1,   -1,   -1,  297,   -1,  299,  300,   -1,
  302,  303,  304,  305,  306,   -1,   -1,  309,   -1,   -1,
  312,   -1,  314,  315,   -1,   -1,  318,  319,  320,   -1,
  322,  323,  324,  325,  326,  327,  328,   -1,   -1,   -1,
  332,  333,  334,  335,  336,   -1,   -1,   -1,  340,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  350,  351,
  352,  353,   -1,   -1,   -1,  357,  358,   -1,  360,   -1,
  362,   -1,  364,  365,  366,   -1,  368,   -1,  370,  371,
  372,   -1,  374,  375,  376,  377,  378,   -1,  380,  381,
   -1,   -1,   -1,   -1,  386,   -1,  388,  389,   -1,   -1,
  392,  393,  394,   -1,   -1,  397,   -1,  399,   -1,   -1,
  402,  403,  404,  405,   -1,  407,   -1,  409,   -1,  411,
  412,  413,  414,  415,  598,   -1,  418,  419,  420,   -1,
  422,  423,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  433,  434,  435,   -1,  437,  438,  439,  598,  441,
   -1,   -1,   -1,  445,   -1,  447,  448,  449,  450,   -1,
  452,   -1,  454,  455,  456,  457,  458,  459,  460,  461,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  471,
  472,   41,  474,  475,  476,   -1,   -1,   -1,   -1,  481,
  482,  483,  484,  485,   -1,  487,   -1,   -1,  490,  491,
   60,   61,   62,  495,  496,   41,   -1,  499,  500,  501,
  502,  503,  504,  505,  506,  507,   -1,  509,   -1,   -1,
   -1,   -1,   -1,   -1,   60,   61,   62,  519,  520,  521,
  522,  523,  524,  525,  526,  527,  528,  529,  530,  531,
  532,  533,  534,  535,  536,  537,  538,  539,   -1,  541,
  542,  543,  544,  545,  546,   -1,  548,  549,  550,  551,
   -1,  553,   -1,  555,  556,  557,  558,  559,  560,  561,
  562,  563,  564,  565,  566,  567,  568,  569,  570,  571,
  572,   -1,  574,  575,  576,  577,   -1,  579,  580,  581,
  582,  583,   -1,  585,  586,  587,  588,  589,  590,  591,
  592,  593,  594,  595,  596,  597,  598,  599,  600,  601,
  602,  603,  604,  605,  606,  607,  608,  609,  610,  611,
  612,  613,    0,  615,  616,  617,  618,   -1,  620,  621,
  622,  623,  624,  625,   -1,   -1,  628,  629,  630,  631,
  632,  633,  634,  635,  636,   -1,   -1,   -1,   -1,   -1,
  642,   -1,  644,  645,  646,  647,  648,  649,   -1,  651,
   -1,   -1,   40,   41,   42,   43,   44,   45,   46,   47,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   58,   59,   60,   61,   62,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  271,   -1,   91,   -1,   93,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  284,   -1,  262,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  271,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,
   -1,   -1,   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,
  350,   -1,  352,   -1,   -1,   -1,   -1,  333,   -1,   -1,
   -1,   -1,  362,   -1,  364,  365,  366,   -1,   -1,   -1,
   -1,  371,   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,  364,  365,
  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  412,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,   -1,  257,
   -1,  259,   -1,   -1,  262,   -1,  264,  265,   -1,   -1,
  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  277,
   -1,  279,  280,  281,  282,   -1,  284,   -1,   -1,  287,
   -1,   -1,  290,   -1,   -1,   -1,   -1,   -1,   -1,  297,
   -1,  299,  300,   -1,  302,  303,  304,  305,  306,   -1,
   -1,  309,   -1,   -1,  312,   -1,  314,  315,   -1,   -1,
  318,  319,  320,   -1,  322,  323,  324,  325,  326,  327,
  328,   -1,   -1,   -1,  332,  333,  334,  335,  336,   -1,
   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  348,  349,  350,  351,  352,  353,   -1,   -1,   -1,  357,
  358,   -1,  360,   -1,  362,   -1,  364,  365,  366,   -1,
  368,   -1,  370,  371,  372,   -1,  374,  375,  376,  377,
  378,   -1,  380,  381,   -1,   -1,   -1,   -1,  386,   -1,
  388,  389,   -1,   -1,  392,  393,  394,   -1,   -1,  397,
   -1,  399,   -1,   -1,  402,  403,  404,  405,   -1,  407,
   -1,  409,   -1,  411,  412,  413,  414,  415,  598,   -1,
  418,  419,  420,   -1,  422,  423,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  433,  434,  435,   -1,  437,
  438,  439,  598,  441,   -1,   -1,   -1,  445,   -1,  447,
  448,  449,  450,   -1,  452,   -1,  454,  455,  456,  457,
  458,  459,  460,  461,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  471,  472,   41,  474,  475,  476,   -1,
   -1,   -1,   -1,  481,  482,  483,  484,  485,   -1,  487,
   -1,   -1,  490,  491,   60,   61,   62,  495,  496,   41,
   -1,  499,  500,  501,  502,  503,  504,  505,  506,  507,
   -1,  509,   -1,   -1,   -1,   -1,   -1,   -1,   60,   61,
   62,  519,  520,  521,  522,  523,  524,  525,  526,  527,
  528,  529,  530,  531,  532,  533,  534,  535,  536,  537,
  538,  539,   -1,  541,  542,  543,  544,  545,  546,   -1,
  548,  549,  550,  551,   -1,  553,   -1,  555,  556,  557,
  558,  559,  560,  561,  562,  563,  564,  565,  566,  567,
  568,  569,  570,  571,  572,   -1,  574,  575,  576,  577,
   -1,  579,  580,  581,  582,  583,   -1,  585,  586,  587,
  588,  589,  590,  591,  592,  593,  594,  595,  596,  597,
  598,  599,  600,  601,  602,  603,  604,  605,  606,  607,
  608,  609,  610,  611,  612,  613,    0,  615,  616,  617,
  618,   -1,  620,  621,  622,  623,  624,  625,   -1,   -1,
  628,  629,  630,  631,  632,  633,  634,  635,  636,   -1,
   -1,   -1,   -1,   -1,  642,   -1,  644,  645,  646,  647,
  648,  649,   -1,  651,   -1,   -1,   40,   41,   42,   43,
   44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   58,   59,   60,   61,   62,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  271,   -1,   91,   -1,   93,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,
  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,
   -1,   -1,   -1,  325,  350,   -1,  352,   -1,   -1,   -1,
   -1,  333,   -1,   -1,   -1,   -1,  362,   -1,  364,  365,
  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,  350,   -1,
  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  362,   -1,  364,  365,  366,   -1,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  412,   -1,   -1,  257,   -1,  259,   -1,   -1,  262,   -1,
  264,  265,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,
   -1,   -1,   -1,  277,   -1,  279,  280,  281,  282,   -1,
  284,   -1,   -1,  287,   -1,   -1,  290,   -1,   -1,   -1,
   -1,   -1,   -1,  297,   -1,  299,  300,   -1,  302,  303,
  304,  305,  306,   -1,   -1,  309,   -1,   -1,  312,   -1,
  314,  315,   -1,   -1,  318,  319,  320,   -1,  322,  323,
  324,  325,  326,  327,  328,   -1,   -1,   -1,  332,  333,
  334,  335,  336,   -1,   -1,   -1,  340,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  348,  349,  350,  351,  352,  353,
   -1,   -1,   -1,  357,  358,   -1,  360,   -1,  362,   -1,
  364,  365,  366,   -1,  368,   -1,  370,  371,  372,   -1,
  374,  375,  376,  377,  378,   -1,  380,  381,   -1,   -1,
   -1,   -1,  386,   -1,  388,  389,   -1,   -1,  392,  393,
  394,   -1,   -1,  397,   -1,  399,   -1,   -1,  402,  403,
  404,  405,   -1,  407,   -1,  409,   -1,  411,  412,  413,
  414,  415,  598,   -1,  418,  419,  420,   -1,  422,  423,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,
  434,  435,   -1,  437,  438,  439,  598,  441,   -1,   -1,
   -1,  445,   -1,  447,  448,  449,  450,   -1,  452,   -1,
  454,  455,  456,  457,  458,  459,  460,  461,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  471,  472,   41,
  474,  475,  476,   -1,   -1,   -1,   -1,  481,  482,  483,
  484,  485,   -1,  487,   -1,   -1,  490,  491,   60,   61,
   62,  495,  496,   41,   -1,  499,  500,  501,  502,  503,
  504,  505,  506,  507,   -1,  509,   -1,   -1,   -1,   -1,
   -1,   -1,   60,   61,   62,  519,  520,  521,  522,  523,
  524,  525,  526,  527,  528,  529,  530,  531,  532,  533,
  534,  535,  536,  537,  538,  539,   -1,  541,  542,  543,
  544,  545,  546,   -1,  548,  549,  550,  551,   -1,  553,
   -1,  555,  556,  557,  558,  559,  560,  561,  562,  563,
  564,  565,  566,  567,  568,  569,  570,  571,  572,   -1,
  574,  575,  576,  577,   -1,  579,  580,  581,  582,  583,
   -1,  585,  586,  587,  588,  589,  590,  591,  592,  593,
  594,  595,  596,  597,  598,  599,  600,  601,  602,  603,
  604,  605,  606,  607,  608,  609,  610,  611,  612,  613,
    0,  615,  616,  617,  618,   -1,  620,  621,  622,  623,
  624,  625,   -1,   -1,  628,  629,  630,  631,  632,  633,
  634,  635,  636,   -1,   -1,   -1,   -1,   -1,  642,   -1,
  644,  645,  646,  647,  648,  649,   -1,  651,   -1,   -1,
   40,   41,   42,   43,   44,   45,   46,   47,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,
   60,   61,   62,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,
   -1,   91,   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  284,   -1,  262,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,
   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  333,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,  350,   -1,
  352,   -1,   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,
  362,   -1,  364,  365,  366,   -1,   -1,   -1,   -1,  371,
   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  362,   -1,  364,  365,  366,   -1,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  412,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  412,   -1,   -1,  257,   -1,  259,
   -1,   -1,  262,   -1,  264,  265,   -1,   -1,  268,  269,
   -1,  271,   -1,   -1,   -1,   -1,   -1,  277,   -1,  279,
  280,  281,  282,   -1,  284,   -1,   -1,  287,   -1,   -1,
  290,   -1,   -1,   -1,   -1,   -1,   -1,  297,   -1,  299,
  300,   -1,  302,  303,  304,  305,  306,   -1,   -1,  309,
   -1,   -1,  312,   -1,  314,  315,   -1,   -1,  318,  319,
  320,   -1,  322,  323,  324,  325,  326,  327,  328,   -1,
   -1,   -1,  332,  333,  334,  335,  336,   -1,   -1,   -1,
  340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,
  350,  351,  352,  353,   -1,   -1,   -1,  357,  358,   -1,
  360,   -1,  362,   -1,  364,  365,  366,   -1,  368,   -1,
  370,  371,  372,   -1,  374,  375,  376,  377,  378,   -1,
  380,  381,   -1,   -1,   -1,   -1,  386,   -1,  388,  389,
   -1,   -1,  392,  393,  394,   -1,   -1,  397,   -1,  399,
   -1,   -1,  402,  403,  404,  405,   -1,  407,   -1,  409,
   -1,  411,  412,  413,  414,  415,  598,   -1,  418,  419,
  420,   -1,  422,  423,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  433,  434,  435,   -1,  437,  438,  439,
  598,  441,   -1,   -1,   -1,  445,   -1,  447,  448,  449,
  450,   -1,  452,   -1,  454,  455,  456,  457,  458,  459,
  460,  461,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  471,  472,   41,  474,  475,  476,   -1,   -1,   -1,
   -1,  481,  482,  483,  484,  485,   -1,  487,   -1,   -1,
  490,  491,   60,   61,   62,  495,  496,   41,   -1,  499,
  500,  501,  502,  503,  504,  505,  506,  507,   -1,  509,
   -1,   -1,   -1,   -1,   -1,   -1,   60,   61,   62,  519,
  520,  521,  522,  523,  524,  525,  526,  527,  528,  529,
  530,  531,  532,  533,  534,  535,  536,  537,  538,  539,
   -1,  541,  542,  543,  544,  545,  546,   -1,  548,  549,
  550,  551,   -1,  553,   -1,  555,  556,  557,  558,  559,
  560,  561,  562,  563,  564,  565,  566,  567,  568,  569,
  570,  571,  572,   -1,  574,  575,  576,  577,   -1,  579,
  580,  581,  582,  583,   -1,  585,  586,  587,  588,  589,
  590,  591,  592,  593,  594,  595,  596,  597,  598,  599,
  600,  601,  602,  603,  604,  605,  606,  607,  608,  609,
  610,  611,  612,  613,    0,  615,  616,  617,  618,   -1,
  620,  621,  622,  623,  624,  625,   -1,   -1,  628,  629,
  630,  631,  632,  633,  634,  635,  636,   -1,   -1,   -1,
   -1,   -1,  642,   -1,  644,  645,  646,  647,  648,  649,
   -1,  651,   -1,   -1,   40,   41,   42,   43,   44,   45,
   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   58,   59,   60,   61,   62,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  271,   -1,   91,   -1,   93,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,  262,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,
   -1,  325,  350,   -1,  352,   -1,   -1,   -1,   -1,  333,
   -1,   -1,   -1,   -1,  362,   -1,  364,  365,  366,   -1,
   -1,   -1,   -1,  371,   -1,   -1,  350,   -1,  352,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,
  364,  365,  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  412,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,
   -1,  257,   -1,  259,   -1,   -1,  262,   -1,  264,  265,
   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,
   -1,  277,   -1,  279,  280,  281,  282,   -1,  284,   -1,
   -1,  287,   -1,   -1,  290,   -1,   -1,   -1,   -1,   -1,
   -1,  297,   -1,  299,  300,   -1,  302,  303,  304,  305,
  306,   -1,   -1,  309,   -1,   -1,  312,   -1,  314,  315,
   -1,   -1,  318,  319,  320,   -1,  322,  323,  324,  325,
  326,  327,  328,   -1,   -1,   -1,  332,  333,  334,  335,
  336,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  348,  349,  350,  351,  352,  353,   -1,   -1,
   -1,  357,  358,   -1,  360,   -1,  362,   -1,  364,  365,
  366,   -1,  368,   -1,  370,  371,  372,   -1,  374,  375,
  376,  377,  378,   -1,  380,  381,   -1,   -1,   -1,   -1,
  386,   -1,  388,  389,   -1,   -1,  392,  393,  394,   -1,
   -1,  397,   -1,  399,   -1,   -1,  402,  403,  404,  405,
   -1,  407,   -1,  409,   -1,  411,  412,  413,  414,  415,
  598,   -1,  418,  419,  420,   -1,  422,  423,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,  434,  435,
   -1,  437,  438,  439,  598,  441,   -1,   -1,   -1,  445,
   -1,  447,  448,  449,  450,   -1,  452,   -1,  454,  455,
  456,  457,  458,  459,  460,  461,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  471,  472,   41,  474,  475,
  476,   -1,   -1,   -1,   -1,  481,  482,  483,  484,  485,
   -1,  487,   -1,   -1,  490,  491,   60,   61,   62,  495,
  496,   41,   -1,  499,  500,  501,  502,  503,  504,  505,
  506,  507,   -1,  509,   -1,   -1,   -1,   -1,   -1,   -1,
   60,   61,   62,  519,  520,  521,  522,  523,  524,  525,
  526,  527,  528,  529,  530,  531,  532,  533,  534,  535,
  536,  537,  538,  539,   -1,  541,  542,  543,  544,  545,
  546,   -1,  548,  549,  550,  551,   -1,  553,   -1,  555,
  556,  557,  558,  559,  560,  561,  562,  563,  564,  565,
  566,  567,  568,  569,  570,  571,  572,   -1,  574,  575,
  576,  577,   -1,  579,  580,  581,  582,  583,   -1,  585,
  586,  587,  588,  589,  590,  591,  592,  593,  594,  595,
  596,  597,  598,  599,  600,  601,  602,  603,  604,  605,
  606,  607,  608,  609,  610,  611,  612,  613,    0,  615,
  616,  617,  618,   -1,  620,  621,  622,  623,  624,  625,
   -1,   -1,  628,  629,  630,  631,  632,  633,  634,  635,
  636,   -1,   -1,   -1,   -1,   -1,  642,   -1,  644,  645,
  646,  647,  648,  649,   -1,  651,   -1,   -1,   40,   41,
   42,   43,   44,   45,   46,   47,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60,   61,
   62,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,   -1,   91,
   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  284,   -1,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,
   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,
   -1,   -1,   -1,   -1,   -1,  325,  350,   -1,  352,   -1,
   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,  362,   -1,
  364,  365,  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,
  350,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  362,   -1,  364,  365,  366,   -1,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  412,   -1,   -1,  257,   -1,  259,   -1,   -1,
  262,   -1,  264,  265,   -1,   -1,  268,  269,   -1,  271,
   -1,   -1,   -1,   -1,   -1,  277,   -1,  279,  280,  281,
  282,   -1,  284,   -1,   -1,  287,   -1,   -1,  290,   -1,
   -1,   -1,   -1,   -1,   -1,  297,   -1,  299,  300,   -1,
  302,  303,  304,  305,  306,   -1,   -1,  309,   -1,   -1,
  312,   -1,  314,  315,   -1,   -1,  318,  319,  320,   -1,
  322,  323,  324,  325,  326,  327,  328,   -1,   -1,   -1,
  332,  333,  334,  335,  336,   -1,   -1,   -1,  340,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  350,  351,
  352,  353,   -1,   -1,   -1,  357,  358,   -1,  360,   -1,
  362,   -1,  364,  365,  366,   -1,  368,   -1,  370,  371,
  372,   -1,  374,  375,  376,  377,  378,   -1,  380,  381,
   -1,   -1,   -1,   -1,  386,   -1,  388,  389,   -1,   -1,
  392,  393,  394,   -1,   -1,  397,   -1,  399,   -1,   -1,
  402,  403,  404,  405,   -1,  407,   -1,  409,   -1,  411,
  412,  413,  414,  415,  598,   -1,  418,  419,  420,   -1,
  422,  423,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  433,  434,  435,   -1,  437,  438,  439,  598,  441,
   -1,   -1,   -1,  445,   -1,  447,  448,  449,  450,   -1,
  452,   -1,  454,  455,  456,  457,  458,  459,  460,  461,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  471,
  472,   41,  474,  475,  476,   -1,   -1,   -1,   -1,  481,
  482,  483,  484,  485,   -1,  487,   -1,   -1,  490,  491,
   60,   61,   62,  495,  496,   41,   -1,  499,  500,  501,
  502,  503,  504,  505,  506,  507,   -1,  509,   -1,   -1,
   -1,   -1,   -1,   -1,   60,   61,   62,  519,  520,  521,
  522,  523,  524,  525,  526,  527,  528,  529,  530,  531,
  532,  533,  534,  535,  536,  537,  538,  539,   -1,  541,
  542,  543,  544,  545,  546,   -1,  548,  549,  550,  551,
   -1,  553,   -1,  555,  556,  557,  558,  559,  560,  561,
  562,  563,  564,  565,  566,  567,  568,  569,  570,  571,
  572,   -1,  574,  575,  576,  577,   -1,  579,  580,  581,
  582,  583,   -1,  585,  586,  587,  588,  589,  590,  591,
  592,  593,  594,  595,  596,  597,  598,  599,  600,  601,
  602,  603,  604,  605,  606,  607,  608,  609,  610,  611,
  612,  613,    0,  615,  616,  617,  618,   -1,  620,  621,
  622,  623,  624,  625,   -1,   -1,  628,  629,  630,  631,
  632,  633,  634,  635,  636,   -1,   -1,   -1,   -1,   -1,
  642,   -1,  644,  645,  646,  647,  648,  649,   -1,  651,
   -1,   -1,   40,   41,   42,   43,   44,   45,   46,   47,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   58,   59,   60,   61,   62,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  271,   -1,   91,   -1,   93,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  284,   -1,  262,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  271,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,
   -1,   -1,   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,
  350,   -1,  352,   -1,   -1,   -1,   -1,  333,   -1,   -1,
   -1,   -1,  362,   -1,  364,  365,  366,   -1,   -1,   -1,
   -1,  371,   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,  364,  365,
  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  412,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,   -1,  257,
   -1,  259,   -1,   -1,  262,   -1,  264,  265,   -1,   -1,
  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  277,
   -1,  279,  280,  281,  282,   -1,  284,   -1,   -1,  287,
   -1,   -1,  290,   -1,   -1,   -1,   -1,   -1,   -1,  297,
   -1,  299,  300,   -1,  302,  303,  304,  305,  306,   -1,
   -1,  309,   -1,   -1,  312,   -1,  314,  315,   -1,   -1,
  318,  319,  320,   -1,  322,  323,  324,  325,  326,  327,
  328,   -1,   -1,   -1,  332,  333,  334,  335,  336,   -1,
   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  348,  349,  350,  351,  352,  353,   -1,   -1,   -1,  357,
  358,   -1,  360,   -1,  362,   -1,  364,  365,  366,   -1,
  368,   -1,  370,  371,  372,   -1,  374,  375,  376,  377,
  378,   -1,  380,  381,   -1,   -1,   -1,   -1,  386,   -1,
  388,  389,   -1,   -1,  392,  393,  394,   -1,   -1,  397,
   -1,  399,   -1,   -1,  402,  403,  404,  405,   -1,  407,
   -1,  409,   -1,  411,  412,  413,  414,  415,  598,   -1,
  418,  419,  420,   -1,  422,  423,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  433,  434,  435,   -1,  437,
  438,  439,  598,  441,   -1,   -1,   -1,  445,   -1,  447,
  448,  449,  450,   -1,  452,   -1,  454,  455,  456,  457,
  458,  459,  460,  461,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  471,  472,   41,  474,  475,  476,   -1,
   -1,   -1,   -1,  481,  482,  483,  484,  485,   -1,  487,
   -1,   -1,  490,  491,   60,   61,   62,  495,  496,   41,
   -1,  499,  500,  501,  502,  503,  504,  505,  506,  507,
   -1,  509,   -1,   -1,   -1,   -1,   -1,   -1,   60,   61,
   62,  519,  520,  521,  522,  523,  524,  525,  526,  527,
  528,  529,  530,  531,  532,  533,  534,  535,  536,  537,
  538,  539,   -1,  541,  542,  543,  544,  545,  546,   -1,
  548,  549,  550,  551,   -1,  553,   -1,  555,  556,  557,
  558,  559,  560,  561,  562,  563,  564,  565,  566,  567,
  568,  569,  570,  571,  572,   -1,  574,  575,  576,  577,
   -1,  579,  580,  581,  582,  583,   -1,  585,  586,  587,
  588,  589,  590,  591,  592,  593,  594,  595,  596,  597,
  598,  599,  600,  601,  602,  603,  604,  605,  606,  607,
  608,  609,  610,  611,  612,  613,    0,  615,  616,  617,
  618,   -1,  620,  621,  622,  623,  624,  625,   -1,   -1,
  628,  629,  630,  631,  632,  633,  634,  635,  636,   -1,
   -1,   -1,   -1,   -1,  642,   -1,  644,  645,  646,  647,
  648,  649,   -1,  651,   -1,   -1,   40,   41,   42,   43,
   44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   58,   59,   60,   61,   62,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  271,   -1,   91,   -1,   93,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,
  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,
   -1,   -1,   -1,  325,  350,   -1,  352,   -1,   -1,   -1,
   -1,  333,   -1,   -1,   -1,   -1,  362,   -1,  364,  365,
  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,  350,   -1,
  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  362,   -1,  364,  365,  366,   -1,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  412,   -1,   -1,  257,   -1,  259,   -1,   -1,  262,   -1,
  264,  265,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,
   -1,   -1,   -1,  277,   -1,  279,  280,  281,  282,   -1,
  284,   -1,   -1,  287,   -1,   -1,  290,   -1,   -1,   -1,
   -1,   -1,   -1,  297,   -1,  299,  300,   -1,  302,  303,
  304,  305,  306,   -1,   -1,  309,   -1,   -1,  312,   -1,
  314,  315,   -1,   -1,  318,  319,  320,   -1,  322,  323,
  324,  325,  326,  327,  328,   -1,   -1,   -1,  332,  333,
  334,  335,  336,   -1,   -1,   -1,  340,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  348,  349,  350,  351,  352,  353,
   -1,   -1,   -1,  357,  358,   -1,  360,   -1,  362,   -1,
  364,  365,  366,   -1,  368,   -1,  370,  371,  372,   -1,
  374,  375,  376,  377,  378,   -1,  380,  381,   -1,   -1,
   -1,   -1,  386,   -1,  388,  389,   -1,   -1,  392,  393,
  394,   -1,   -1,  397,   -1,  399,   -1,   -1,  402,  403,
  404,  405,   -1,  407,   -1,  409,   -1,  411,  412,  413,
  414,  415,  598,   -1,  418,  419,  420,   -1,  422,  423,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,
  434,  435,   -1,  437,  438,  439,  598,  441,   -1,   -1,
   -1,  445,   -1,  447,  448,  449,  450,   -1,  452,   -1,
  454,  455,  456,  457,  458,  459,  460,  461,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  471,  472,   41,
  474,  475,  476,   -1,   -1,   -1,   -1,  481,  482,  483,
  484,  485,   -1,  487,   -1,   -1,  490,  491,   60,   61,
   62,  495,  496,   41,   -1,  499,  500,  501,  502,  503,
  504,  505,  506,  507,   -1,  509,   -1,   -1,   -1,   -1,
   -1,   -1,   60,   61,   62,  519,  520,  521,  522,  523,
  524,  525,  526,  527,  528,  529,  530,  531,  532,  533,
  534,  535,  536,  537,  538,  539,   -1,  541,  542,  543,
  544,  545,  546,   -1,  548,  549,  550,  551,   -1,  553,
   -1,  555,  556,  557,  558,  559,  560,  561,  562,  563,
  564,  565,  566,  567,  568,  569,  570,  571,  572,   -1,
  574,  575,  576,  577,   -1,  579,  580,  581,  582,  583,
   -1,  585,  586,  587,  588,  589,  590,  591,  592,  593,
  594,  595,  596,  597,  598,  599,  600,  601,  602,  603,
  604,  605,  606,  607,  608,  609,  610,  611,  612,  613,
    0,  615,  616,  617,  618,   -1,  620,  621,  622,  623,
  624,  625,   -1,   -1,  628,  629,  630,  631,  632,  633,
  634,  635,  636,   -1,   -1,   -1,   -1,   -1,  642,   -1,
  644,  645,  646,  647,  648,  649,   -1,  651,   -1,   -1,
   40,   41,   42,   43,   44,   45,   46,   47,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,
   60,   61,   62,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,
   -1,   91,   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  284,   -1,  262,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,
   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  333,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,  350,   -1,
  352,   -1,   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,
  362,   -1,  364,  365,  366,   -1,   -1,   -1,   -1,  371,
   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  362,   -1,  364,  365,  366,   -1,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  412,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  412,   -1,   -1,  257,   -1,  259,
   -1,   -1,  262,   -1,  264,  265,   -1,   -1,  268,  269,
   -1,  271,   -1,   -1,   -1,   -1,   -1,  277,   -1,  279,
  280,  281,  282,   -1,  284,   -1,   -1,  287,   -1,   -1,
  290,   -1,   -1,   -1,   -1,   -1,   -1,  297,   -1,  299,
  300,   -1,  302,  303,  304,  305,  306,   -1,   -1,  309,
   -1,   -1,  312,   -1,  314,  315,   -1,   -1,  318,  319,
  320,   -1,  322,  323,  324,  325,  326,  327,  328,   -1,
   -1,   -1,  332,  333,  334,  335,  336,   -1,   -1,   -1,
  340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,
  350,  351,  352,  353,   -1,   -1,   -1,  357,  358,   -1,
  360,   -1,  362,   -1,  364,  365,  366,   -1,  368,   -1,
  370,  371,  372,   -1,  374,  375,  376,  377,  378,   -1,
  380,  381,   -1,   -1,   -1,   -1,  386,   -1,  388,  389,
   -1,   -1,  392,  393,  394,   -1,   -1,  397,   -1,  399,
   -1,   -1,  402,  403,  404,  405,   -1,  407,   -1,  409,
   -1,  411,  412,  413,  414,  415,  598,   -1,  418,  419,
  420,   -1,  422,  423,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  433,  434,  435,   -1,  437,  438,  439,
  598,  441,   -1,   -1,   -1,  445,   -1,  447,  448,  449,
  450,   -1,  452,   -1,  454,  455,  456,  457,  458,  459,
  460,  461,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  471,  472,   41,  474,  475,  476,   -1,   -1,   -1,
   -1,  481,  482,  483,  484,  485,   -1,  487,   -1,   -1,
  490,  491,   60,   61,   62,  495,  496,   41,   -1,  499,
  500,  501,  502,  503,  504,  505,  506,  507,   -1,  509,
   -1,   -1,   -1,   -1,   -1,   -1,   60,   61,   62,  519,
  520,  521,  522,  523,  524,  525,  526,  527,  528,  529,
  530,  531,  532,  533,  534,  535,  536,  537,  538,  539,
   -1,  541,  542,  543,  544,  545,  546,   -1,  548,  549,
  550,  551,   -1,  553,   -1,  555,  556,  557,  558,  559,
  560,  561,  562,  563,  564,  565,  566,  567,  568,  569,
  570,  571,  572,   -1,  574,  575,  576,  577,   -1,  579,
  580,  581,  582,  583,   -1,  585,  586,  587,  588,  589,
  590,  591,  592,  593,  594,  595,  596,  597,  598,  599,
  600,  601,  602,  603,  604,  605,  606,  607,  608,  609,
  610,  611,  612,  613,    0,  615,  616,  617,  618,   -1,
  620,  621,  622,  623,  624,  625,   -1,   -1,  628,  629,
  630,  631,  632,  633,  634,  635,  636,   -1,   -1,   -1,
   -1,   -1,  642,   -1,  644,  645,  646,  647,  648,  649,
   -1,  651,   -1,   -1,   40,   41,   42,   43,   44,   45,
   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   58,   59,   60,   61,   62,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  271,   -1,   91,   -1,   93,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,  262,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,
   -1,  325,  350,   -1,  352,   -1,   -1,   -1,   -1,  333,
   -1,   -1,   -1,   -1,  362,   -1,  364,  365,  366,   -1,
   -1,   -1,   -1,  371,   -1,   -1,  350,   -1,  352,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,
  364,  365,  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  412,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,
   -1,  257,   -1,  259,   -1,   -1,  262,   -1,  264,  265,
   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,
   -1,  277,   -1,  279,  280,  281,  282,   -1,  284,   -1,
   -1,  287,   -1,   -1,  290,   -1,   -1,   -1,   -1,   -1,
   -1,  297,   -1,  299,  300,   -1,  302,  303,  304,  305,
  306,   -1,   -1,  309,   -1,   -1,  312,   -1,  314,  315,
   -1,   -1,  318,  319,  320,   -1,  322,  323,  324,  325,
  326,  327,  328,   -1,   -1,   -1,  332,  333,  334,  335,
  336,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  348,  349,  350,  351,  352,  353,   -1,   -1,
   -1,  357,  358,   -1,  360,   -1,  362,   -1,  364,  365,
  366,   -1,  368,   -1,  370,  371,  372,   -1,  374,  375,
  376,  377,  378,   -1,  380,  381,   -1,   -1,   -1,   -1,
  386,   -1,  388,  389,   -1,   -1,  392,  393,  394,   -1,
   -1,  397,   -1,  399,   -1,   -1,  402,  403,  404,  405,
   -1,  407,   -1,  409,   -1,  411,  412,  413,  414,  415,
  598,   -1,  418,  419,  420,   -1,  422,  423,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,  434,  435,
   -1,  437,  438,  439,  598,  441,   -1,   -1,   -1,  445,
   -1,  447,  448,  449,  450,   -1,  452,   -1,  454,  455,
  456,  457,  458,  459,  460,  461,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  471,  472,   41,  474,  475,
  476,   -1,   -1,   -1,   -1,  481,  482,  483,  484,  485,
   -1,  487,   -1,   -1,  490,  491,   60,   61,   62,  495,
  496,   41,   -1,  499,  500,  501,  502,  503,  504,  505,
  506,  507,   -1,  509,   -1,   -1,   -1,   -1,   -1,   -1,
   60,   61,   62,  519,  520,  521,  522,  523,  524,  525,
  526,  527,  528,  529,  530,  531,  532,  533,  534,  535,
  536,  537,  538,  539,   -1,  541,  542,  543,  544,  545,
  546,   -1,  548,  549,  550,  551,   -1,  553,   -1,  555,
  556,  557,  558,  559,  560,  561,  562,  563,  564,  565,
  566,  567,  568,  569,  570,  571,  572,   -1,  574,  575,
  576,  577,   -1,  579,  580,  581,  582,  583,   -1,  585,
  586,  587,  588,  589,  590,  591,  592,  593,  594,  595,
  596,  597,  598,  599,  600,  601,  602,  603,  604,  605,
  606,  607,  608,  609,  610,  611,  612,  613,    0,  615,
  616,  617,  618,   -1,  620,  621,  622,  623,  624,  625,
   -1,   -1,  628,  629,  630,  631,  632,  633,  634,  635,
  636,   -1,   -1,   -1,   -1,   -1,  642,   -1,  644,  645,
  646,  647,  648,  649,   -1,  651,   -1,   -1,   40,   41,
   42,   43,   44,   45,   46,   47,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60,   61,
   62,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,   -1,   91,
   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  284,   -1,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,
   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,
   -1,   -1,   -1,   -1,   -1,  325,  350,   -1,  352,   -1,
   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,  362,   -1,
  364,  365,  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,
  350,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  362,   -1,  364,  365,  366,   -1,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  412,   -1,   -1,  257,   -1,  259,   -1,   -1,
  262,   -1,  264,  265,   -1,   -1,  268,  269,   -1,  271,
   -1,   -1,   -1,   -1,   -1,  277,   -1,  279,  280,  281,
  282,   -1,  284,   -1,   -1,  287,   -1,   -1,  290,   -1,
   -1,   -1,   -1,   -1,   -1,  297,   -1,  299,  300,   -1,
  302,  303,  304,  305,  306,   -1,   -1,  309,   -1,   -1,
  312,   -1,  314,  315,   -1,   -1,  318,  319,  320,   -1,
  322,  323,  324,  325,  326,  327,  328,   -1,   -1,   -1,
  332,  333,  334,  335,  336,   -1,   -1,   -1,  340,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  350,  351,
  352,  353,   -1,   -1,   -1,  357,  358,   -1,  360,   -1,
  362,   -1,  364,  365,  366,   -1,  368,   -1,  370,  371,
  372,   -1,  374,  375,  376,  377,  378,   -1,  380,  381,
   -1,   -1,   -1,   -1,  386,   -1,  388,  389,   -1,   -1,
  392,  393,  394,   -1,   -1,  397,   -1,  399,   -1,   -1,
  402,  403,  404,  405,   -1,  407,   -1,  409,   -1,  411,
  412,  413,  414,  415,  598,   -1,  418,  419,  420,   -1,
  422,  423,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  433,  434,  435,   -1,  437,  438,  439,  598,  441,
   -1,   -1,   -1,  445,   -1,  447,  448,  449,  450,   -1,
  452,   -1,  454,  455,  456,  457,  458,  459,  460,  461,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  471,
  472,   41,  474,  475,  476,   -1,   -1,   -1,   -1,  481,
  482,  483,  484,  485,   -1,  487,   -1,   -1,  490,  491,
   60,   61,   62,  495,  496,   41,   -1,  499,  500,  501,
  502,  503,  504,  505,  506,  507,   -1,  509,   -1,   -1,
   -1,   -1,   -1,   -1,   60,   61,   62,  519,  520,  521,
  522,  523,  524,  525,  526,  527,  528,  529,  530,  531,
  532,  533,  534,  535,  536,  537,  538,  539,   -1,  541,
  542,  543,  544,  545,  546,   -1,  548,  549,  550,  551,
   -1,  553,   -1,  555,  556,  557,  558,  559,  560,  561,
  562,  563,  564,  565,  566,  567,  568,  569,  570,  571,
  572,   -1,  574,  575,  576,  577,   -1,  579,  580,  581,
  582,  583,   -1,  585,  586,  587,  588,  589,  590,  591,
  592,  593,  594,  595,  596,  597,  598,  599,  600,  601,
  602,  603,  604,  605,  606,  607,  608,  609,  610,  611,
  612,  613,    0,  615,  616,  617,  618,   -1,  620,  621,
  622,  623,  624,  625,   -1,   -1,  628,  629,  630,  631,
  632,  633,  634,  635,  636,   -1,   -1,   -1,   -1,   -1,
  642,   -1,  644,  645,  646,  647,  648,  649,   -1,  651,
   -1,   -1,   40,   41,   42,   43,   44,   45,   46,   47,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   58,   59,   60,   61,   62,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  271,   -1,   91,   -1,   93,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  284,   -1,  262,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  271,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,
   -1,   -1,   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,
  350,   -1,  352,   -1,   -1,   -1,   -1,  333,   -1,   -1,
   -1,   -1,  362,   -1,  364,  365,  366,   -1,   -1,   -1,
   -1,  371,   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,  364,  365,
  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  412,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,   -1,  257,
   -1,  259,   -1,   -1,  262,   -1,  264,  265,   -1,   -1,
  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  277,
   -1,  279,  280,  281,  282,   -1,  284,   -1,   -1,  287,
   -1,   -1,  290,   -1,   -1,   -1,   -1,   -1,   -1,  297,
   -1,  299,  300,   -1,  302,  303,  304,  305,  306,   -1,
   -1,  309,   -1,   -1,  312,   -1,  314,  315,   -1,   -1,
  318,  319,  320,   -1,  322,  323,  324,  325,  326,  327,
  328,   -1,   -1,   -1,  332,  333,  334,  335,  336,   -1,
   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  348,  349,  350,  351,  352,  353,   -1,   -1,   -1,  357,
  358,   -1,  360,   -1,  362,   -1,  364,  365,  366,   -1,
  368,   -1,  370,  371,  372,   -1,  374,  375,  376,  377,
  378,   -1,  380,  381,   -1,   -1,   -1,   -1,  386,   -1,
  388,  389,   -1,   -1,  392,  393,  394,   -1,   -1,  397,
   -1,  399,   -1,   -1,  402,  403,  404,  405,   -1,  407,
   -1,  409,   -1,  411,  412,  413,  414,  415,  598,   -1,
  418,  419,  420,   -1,  422,  423,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  433,  434,  435,   -1,  437,
  438,  439,  598,  441,   -1,   -1,   -1,  445,   -1,  447,
  448,  449,  450,   -1,  452,   -1,  454,  455,  456,  457,
  458,  459,  460,  461,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  471,  472,   41,  474,  475,  476,   -1,
   -1,   -1,   -1,  481,  482,  483,  484,  485,   -1,  487,
   -1,   -1,  490,  491,   60,   61,   62,  495,  496,   41,
   -1,  499,  500,  501,  502,  503,  504,  505,  506,  507,
   -1,  509,   -1,   -1,   -1,   -1,   -1,   -1,   60,   61,
   62,  519,  520,  521,  522,  523,  524,  525,  526,  527,
  528,  529,  530,  531,  532,  533,  534,  535,  536,  537,
  538,  539,   -1,  541,  542,  543,  544,  545,  546,   -1,
  548,  549,  550,  551,   -1,  553,   -1,  555,  556,  557,
  558,  559,  560,  561,  562,  563,  564,  565,  566,  567,
  568,  569,  570,  571,  572,   -1,  574,  575,  576,  577,
   -1,  579,  580,  581,  582,  583,   -1,  585,  586,  587,
  588,  589,  590,  591,  592,  593,  594,  595,  596,  597,
  598,  599,  600,  601,  602,  603,  604,  605,  606,  607,
  608,  609,  610,  611,  612,  613,    0,  615,  616,  617,
  618,   -1,  620,  621,  622,  623,  624,  625,   -1,   -1,
  628,  629,  630,  631,  632,  633,  634,  635,  636,   -1,
   -1,   -1,   -1,   -1,  642,   -1,  644,  645,  646,  647,
  648,  649,   -1,  651,   -1,   -1,   40,   41,   42,   43,
   44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   58,   59,   60,   61,   62,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  271,   -1,   91,   -1,   93,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,
  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,
   -1,   -1,   -1,  325,  350,   -1,  352,   -1,   -1,   -1,
   -1,  333,   -1,   -1,   -1,   -1,  362,   -1,  364,  365,
  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,  350,   -1,
  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  362,   -1,  364,  365,  366,   -1,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  412,   -1,   -1,  257,   -1,  259,   -1,   -1,  262,   -1,
  264,  265,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,
   -1,   -1,   -1,  277,   -1,  279,  280,  281,  282,   -1,
  284,   -1,   -1,  287,   -1,   -1,  290,   -1,   -1,   -1,
   -1,   -1,   -1,  297,   -1,  299,  300,   -1,  302,  303,
  304,  305,  306,   -1,   -1,  309,   -1,   -1,  312,   -1,
  314,  315,   -1,   -1,  318,  319,  320,   -1,  322,  323,
  324,  325,  326,  327,  328,   -1,   -1,   -1,  332,  333,
  334,  335,  336,   -1,   -1,   -1,  340,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  348,  349,  350,  351,  352,  353,
   -1,   -1,   -1,  357,  358,   -1,  360,   -1,  362,   -1,
  364,  365,  366,   -1,  368,   -1,  370,  371,  372,   -1,
  374,  375,  376,  377,  378,   -1,  380,  381,   -1,   -1,
   -1,   -1,  386,   -1,  388,  389,   -1,   -1,  392,  393,
  394,   -1,   -1,  397,   -1,  399,   -1,   -1,  402,  403,
  404,  405,   -1,  407,   -1,  409,   -1,  411,  412,  413,
  414,  415,  598,   -1,  418,  419,  420,   -1,  422,  423,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,
  434,  435,   -1,  437,  438,  439,  598,  441,   -1,   -1,
   -1,  445,   -1,  447,  448,  449,  450,   -1,  452,   -1,
  454,  455,  456,  457,  458,  459,  460,  461,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  471,  472,   41,
  474,  475,  476,   -1,   -1,   -1,   -1,  481,  482,  483,
  484,  485,   -1,  487,   -1,   -1,  490,  491,   60,   61,
   62,  495,  496,   41,   -1,  499,  500,  501,  502,  503,
  504,  505,  506,  507,   -1,  509,   -1,   -1,   -1,   -1,
   -1,   -1,   60,   61,   62,  519,  520,  521,  522,  523,
  524,  525,  526,  527,  528,  529,  530,  531,  532,  533,
  534,  535,  536,  537,  538,  539,   -1,  541,  542,  543,
  544,  545,  546,   -1,  548,  549,  550,  551,   -1,  553,
   -1,  555,  556,  557,  558,  559,  560,  561,  562,  563,
  564,  565,  566,  567,  568,  569,  570,  571,  572,   -1,
  574,  575,  576,  577,   -1,  579,  580,  581,  582,  583,
   -1,  585,  586,  587,  588,  589,  590,  591,  592,  593,
  594,  595,  596,  597,  598,  599,  600,  601,  602,  603,
  604,  605,  606,  607,  608,  609,  610,  611,  612,  613,
    0,  615,  616,  617,  618,   -1,  620,  621,  622,  623,
  624,  625,   -1,   -1,  628,  629,  630,  631,  632,  633,
  634,  635,  636,   -1,   -1,   -1,   -1,   -1,  642,   -1,
  644,  645,  646,  647,  648,  649,   -1,  651,   -1,   -1,
   40,   41,   42,   43,   44,   45,   46,   47,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,
   60,   61,   62,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,
   -1,   91,   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  284,   -1,  262,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,
   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  333,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,  350,   -1,
  352,   -1,   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,
  362,   -1,  364,  365,  366,   -1,   -1,   -1,   -1,  371,
   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  362,   -1,  364,  365,  366,   -1,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  412,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  412,   -1,   -1,  257,   -1,  259,
   -1,   -1,  262,   -1,  264,  265,   -1,   -1,  268,  269,
   -1,  271,   -1,   -1,   -1,   -1,   -1,  277,   -1,  279,
  280,  281,  282,   -1,  284,   -1,   -1,  287,   -1,   -1,
  290,   -1,   -1,   -1,   -1,   -1,   -1,  297,   -1,  299,
  300,   -1,  302,  303,  304,  305,  306,   -1,   -1,  309,
   -1,   -1,  312,   -1,  314,  315,   -1,   -1,  318,  319,
  320,   -1,  322,  323,  324,  325,  326,  327,  328,   -1,
   -1,   -1,  332,  333,  334,  335,  336,   -1,   -1,   -1,
  340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,
  350,  351,  352,  353,   -1,   -1,   -1,  357,  358,   -1,
  360,   -1,  362,   -1,  364,  365,  366,   -1,  368,   -1,
  370,  371,  372,   -1,  374,  375,  376,  377,  378,   -1,
  380,  381,   -1,   -1,   -1,   -1,  386,   -1,  388,  389,
   -1,   -1,  392,  393,  394,   -1,   -1,  397,   -1,  399,
   -1,   -1,  402,  403,  404,  405,   -1,  407,   -1,  409,
   -1,  411,  412,  413,  414,  415,  598,   -1,  418,  419,
  420,   -1,  422,  423,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  433,  434,  435,   -1,  437,  438,  439,
  598,  441,   -1,   -1,   -1,  445,   -1,  447,  448,  449,
  450,   -1,  452,   -1,  454,  455,  456,  457,  458,  459,
  460,  461,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  471,  472,   41,  474,  475,  476,   -1,   -1,   -1,
   -1,  481,  482,  483,  484,  485,   -1,  487,   -1,   -1,
  490,  491,   60,   61,   62,  495,  496,   41,   -1,  499,
  500,  501,  502,  503,  504,  505,  506,  507,   -1,  509,
   -1,   -1,   -1,   -1,   -1,   -1,   60,   61,   62,  519,
  520,  521,  522,  523,  524,  525,  526,  527,  528,  529,
  530,  531,  532,  533,  534,  535,  536,  537,  538,  539,
   -1,  541,  542,  543,  544,  545,  546,   -1,  548,  549,
  550,  551,   -1,  553,   -1,  555,  556,  557,  558,  559,
  560,  561,  562,  563,  564,  565,  566,  567,  568,  569,
  570,  571,  572,   -1,  574,  575,  576,  577,   -1,  579,
  580,  581,  582,  583,   -1,  585,  586,  587,  588,  589,
  590,  591,  592,  593,  594,  595,  596,  597,  598,  599,
  600,  601,  602,  603,  604,  605,  606,  607,  608,  609,
  610,  611,  612,  613,    0,  615,  616,  617,  618,   -1,
  620,  621,  622,  623,  624,  625,   -1,   -1,  628,  629,
  630,  631,  632,  633,  634,  635,  636,   -1,   -1,   -1,
   -1,   -1,  642,   -1,  644,  645,  646,  647,  648,  649,
   -1,  651,   -1,   -1,   40,   41,   42,   43,   44,   45,
   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   58,   59,   60,   61,   62,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  271,   -1,   91,   -1,   93,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,  262,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,
   -1,  325,  350,   -1,  352,   -1,   -1,   -1,   -1,  333,
   -1,   -1,   -1,   -1,  362,   -1,  364,  365,  366,   -1,
   -1,   -1,   -1,  371,   -1,   -1,  350,   -1,  352,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,
  364,  365,  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  412,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,
   -1,  257,   -1,  259,   -1,   -1,  262,   -1,  264,  265,
   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,
   -1,  277,   -1,  279,  280,  281,  282,   -1,  284,   -1,
   -1,  287,   -1,   -1,  290,   -1,   -1,   -1,   -1,   -1,
   -1,  297,   -1,  299,  300,   -1,  302,  303,  304,  305,
  306,   -1,   -1,  309,   -1,   -1,  312,   -1,  314,  315,
   -1,   -1,  318,  319,  320,   -1,  322,  323,  324,  325,
  326,  327,  328,   -1,   -1,   -1,  332,  333,  334,  335,
  336,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  348,  349,  350,  351,  352,  353,   -1,   -1,
   -1,  357,  358,   -1,  360,   -1,  362,   -1,  364,  365,
  366,   -1,  368,   -1,  370,  371,  372,   -1,  374,  375,
  376,  377,  378,   -1,  380,  381,   -1,   -1,   -1,   -1,
  386,   -1,  388,  389,   -1,   -1,  392,  393,  394,   -1,
   -1,  397,   -1,  399,   -1,   -1,  402,  403,  404,  405,
   -1,  407,   -1,  409,   -1,  411,  412,  413,  414,  415,
  598,   -1,  418,  419,  420,   -1,  422,  423,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,  434,  435,
   -1,  437,  438,  439,  598,  441,   -1,   -1,   -1,  445,
   -1,  447,  448,  449,  450,   -1,  452,   -1,  454,  455,
  456,  457,  458,  459,  460,  461,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  471,  472,   41,  474,  475,
  476,   -1,   -1,   -1,   -1,  481,  482,  483,  484,  485,
   -1,  487,   -1,   -1,  490,  491,   60,   61,   62,  495,
  496,   41,   -1,  499,  500,  501,  502,  503,  504,  505,
  506,  507,   -1,  509,   -1,   -1,   -1,   -1,   -1,   -1,
   60,   61,   62,  519,  520,  521,  522,  523,  524,  525,
  526,  527,  528,  529,  530,  531,  532,  533,  534,  535,
  536,  537,  538,  539,   -1,  541,  542,  543,  544,  545,
  546,   -1,  548,  549,  550,  551,   -1,  553,   -1,  555,
  556,  557,  558,  559,  560,  561,  562,  563,  564,  565,
  566,  567,  568,  569,  570,  571,  572,   -1,  574,  575,
  576,  577,   -1,  579,  580,  581,  582,  583,   -1,  585,
  586,  587,  588,  589,  590,  591,  592,  593,  594,  595,
  596,  597,  598,  599,  600,  601,  602,  603,  604,  605,
  606,  607,  608,  609,  610,  611,  612,  613,    0,  615,
  616,  617,  618,   -1,  620,  621,  622,  623,  624,  625,
   -1,   -1,  628,  629,  630,  631,  632,  633,  634,  635,
  636,   -1,   -1,   -1,   -1,   -1,  642,   -1,  644,  645,
  646,  647,  648,  649,   -1,  651,   -1,   -1,   40,   41,
   42,   43,   44,   45,   46,   47,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60,   61,
   62,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,   -1,   91,
   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  284,   -1,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,
   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,
   -1,   -1,   -1,   -1,   -1,  325,  350,   -1,  352,   -1,
   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,  362,   -1,
  364,  365,  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,
  350,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  362,   -1,  364,  365,  366,   -1,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  412,   -1,   -1,  257,   -1,  259,   -1,   -1,
  262,   -1,  264,  265,   -1,   -1,  268,  269,   -1,  271,
   -1,   -1,   -1,   -1,   -1,  277,   -1,  279,  280,  281,
  282,   -1,  284,   -1,   -1,  287,   -1,   -1,  290,   -1,
   -1,   -1,   -1,   -1,   -1,  297,   -1,  299,  300,   -1,
  302,  303,  304,  305,  306,   -1,   -1,  309,   -1,   -1,
  312,   -1,  314,  315,   -1,   -1,  318,  319,  320,   -1,
  322,  323,  324,  325,  326,  327,  328,   -1,   -1,   -1,
  332,  333,  334,  335,  336,   -1,   -1,   -1,  340,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  350,  351,
  352,  353,   -1,   -1,   -1,  357,  358,   -1,  360,   -1,
  362,   -1,  364,  365,  366,   -1,  368,   -1,  370,  371,
  372,   -1,  374,  375,  376,  377,  378,   -1,  380,  381,
   -1,   -1,   -1,   -1,  386,   -1,  388,  389,   -1,   -1,
  392,  393,  394,   -1,   -1,  397,   -1,  399,   -1,   -1,
  402,  403,  404,  405,   -1,  407,   -1,  409,   -1,  411,
  412,  413,  414,  415,  598,   -1,  418,  419,  420,   -1,
  422,  423,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  433,  434,  435,   -1,  437,  438,  439,  598,  441,
   -1,   -1,   -1,  445,   -1,  447,  448,  449,  450,   -1,
  452,   -1,  454,  455,  456,  457,  458,  459,  460,  461,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  471,
  472,   41,  474,  475,  476,   -1,   -1,   -1,   -1,  481,
  482,  483,  484,  485,   -1,  487,   -1,   -1,  490,  491,
   60,   61,   62,  495,  496,   41,   -1,  499,  500,  501,
  502,  503,  504,  505,  506,  507,   -1,  509,   -1,   -1,
   -1,   -1,   -1,   -1,   60,   61,   62,  519,  520,  521,
  522,  523,  524,  525,  526,  527,  528,  529,  530,  531,
  532,  533,  534,  535,  536,  537,  538,  539,   -1,  541,
  542,  543,  544,  545,  546,   -1,  548,  549,  550,  551,
   -1,  553,   -1,  555,  556,  557,  558,  559,  560,  561,
  562,  563,  564,  565,  566,  567,  568,  569,  570,  571,
  572,   -1,  574,  575,  576,  577,   -1,  579,  580,  581,
  582,  583,   -1,  585,  586,  587,  588,  589,  590,  591,
  592,  593,  594,  595,  596,  597,  598,  599,  600,  601,
  602,  603,  604,  605,  606,  607,  608,  609,  610,  611,
  612,  613,    0,  615,  616,  617,  618,   -1,  620,  621,
  622,  623,  624,  625,   -1,   -1,  628,  629,  630,  631,
  632,  633,  634,  635,  636,   -1,   -1,   -1,   -1,   -1,
  642,   -1,  644,  645,  646,  647,  648,  649,   -1,  651,
   -1,   -1,   40,   41,   42,   43,   44,   45,   46,   47,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   58,   59,   60,   61,   62,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  271,   -1,   91,   -1,   93,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  284,   -1,  262,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  271,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,
   -1,   -1,   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,
  350,   -1,  352,   -1,   -1,   -1,   -1,  333,   -1,   -1,
   -1,   -1,  362,   -1,  364,  365,  366,   -1,   -1,   -1,
   -1,  371,   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,  364,  365,
  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  412,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,   -1,  257,
   -1,  259,   -1,   -1,  262,   -1,  264,  265,   -1,   -1,
  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  277,
   -1,  279,  280,  281,  282,   -1,  284,   -1,   -1,  287,
   -1,   -1,  290,   -1,   -1,   -1,   -1,   -1,   -1,  297,
   -1,  299,  300,   -1,  302,  303,  304,  305,  306,   -1,
   -1,  309,   -1,   -1,  312,   -1,  314,  315,   -1,   -1,
  318,  319,  320,   -1,  322,  323,  324,  325,  326,  327,
  328,   -1,   -1,   -1,  332,  333,  334,  335,  336,   -1,
   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  348,  349,  350,  351,  352,  353,   -1,   -1,   -1,  357,
  358,   -1,  360,   -1,  362,   -1,  364,  365,  366,   -1,
  368,   -1,  370,  371,  372,   -1,  374,  375,  376,  377,
  378,   -1,  380,  381,   -1,   -1,   -1,   -1,  386,   -1,
  388,  389,   -1,   -1,  392,  393,  394,   -1,   -1,  397,
   -1,  399,   -1,   -1,  402,  403,  404,  405,   -1,  407,
   -1,  409,   -1,  411,  412,  413,  414,  415,  598,   -1,
  418,  419,  420,   -1,  422,  423,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  433,  434,  435,   -1,  437,
  438,  439,  598,  441,   -1,   -1,   -1,  445,   -1,  447,
  448,  449,  450,   -1,  452,   -1,  454,  455,  456,  457,
  458,  459,  460,  461,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  471,  472,   41,  474,  475,  476,   -1,
   -1,   -1,   -1,  481,  482,  483,  484,  485,   -1,  487,
   -1,   -1,  490,  491,   60,   61,   62,  495,  496,   41,
   -1,  499,  500,  501,  502,  503,  504,  505,  506,  507,
   -1,  509,   -1,   -1,   -1,   -1,   -1,   -1,   60,   61,
   62,  519,  520,  521,  522,  523,  524,  525,  526,  527,
  528,  529,  530,  531,  532,  533,  534,  535,  536,  537,
  538,  539,   -1,  541,  542,  543,  544,  545,  546,   -1,
  548,  549,  550,  551,   -1,  553,   -1,  555,  556,  557,
  558,  559,  560,  561,  562,  563,  564,  565,  566,  567,
  568,  569,  570,  571,  572,   -1,  574,  575,  576,  577,
   -1,  579,  580,  581,  582,  583,   -1,  585,  586,  587,
  588,  589,  590,  591,  592,  593,  594,  595,  596,  597,
  598,  599,  600,  601,  602,  603,  604,  605,  606,  607,
  608,  609,  610,  611,  612,  613,    0,  615,  616,  617,
  618,   -1,  620,  621,  622,  623,  624,  625,   -1,   -1,
  628,  629,  630,  631,  632,  633,  634,  635,  636,   -1,
   -1,   -1,   -1,   -1,  642,   -1,  644,  645,  646,  647,
  648,  649,   -1,  651,   -1,   -1,   40,   41,   42,   43,
   44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   58,   59,   60,   61,   62,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  271,   -1,   91,   -1,   93,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,
  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,
   -1,   -1,   -1,  325,  350,   -1,  352,   -1,   -1,   -1,
   -1,  333,   -1,   -1,   -1,   -1,  362,   -1,  364,  365,
  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,  350,   -1,
  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  362,   -1,  364,  365,  366,   -1,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  412,   -1,   -1,  257,   -1,  259,   -1,   -1,  262,   -1,
  264,  265,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,
   -1,   -1,   -1,  277,   -1,  279,  280,  281,  282,   -1,
  284,   -1,   -1,  287,   -1,   -1,  290,   -1,   -1,   -1,
   -1,   -1,   -1,  297,   -1,  299,  300,   -1,  302,  303,
  304,  305,  306,   -1,   -1,  309,   -1,   -1,  312,   -1,
  314,  315,   -1,   -1,  318,  319,  320,   -1,  322,  323,
  324,  325,  326,  327,  328,   -1,   -1,   -1,  332,  333,
  334,  335,  336,   -1,   -1,   -1,  340,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  348,  349,  350,  351,  352,  353,
   -1,   -1,   -1,  357,  358,   -1,  360,   -1,  362,   -1,
  364,  365,  366,   -1,  368,   -1,  370,  371,  372,   -1,
  374,  375,  376,  377,  378,   -1,  380,  381,   -1,   -1,
   -1,   -1,  386,   -1,  388,  389,   -1,   -1,  392,  393,
  394,   -1,   -1,  397,   -1,  399,   -1,   -1,  402,  403,
  404,  405,   -1,  407,   -1,  409,   -1,  411,  412,  413,
  414,  415,  598,   -1,  418,  419,  420,   -1,  422,  423,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,
  434,  435,   -1,  437,  438,  439,  598,  441,   -1,   -1,
   -1,  445,   -1,  447,  448,  449,  450,   -1,  452,   -1,
  454,  455,  456,  457,  458,  459,  460,  461,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  471,  472,   41,
  474,  475,  476,   -1,   -1,   -1,   -1,  481,  482,  483,
  484,  485,   -1,  487,   -1,   -1,  490,  491,   60,   61,
   62,  495,  496,   41,   -1,  499,  500,  501,  502,  503,
  504,  505,  506,  507,   -1,  509,   -1,   -1,   -1,   -1,
   -1,   -1,   60,   61,   62,  519,  520,  521,  522,  523,
  524,  525,  526,  527,  528,  529,  530,  531,  532,  533,
  534,  535,  536,  537,  538,  539,   -1,  541,  542,  543,
  544,  545,  546,   -1,  548,  549,  550,  551,   -1,  553,
   -1,  555,  556,  557,  558,  559,  560,  561,  562,  563,
  564,  565,  566,  567,  568,  569,  570,  571,  572,   -1,
  574,  575,  576,  577,   -1,  579,  580,  581,  582,  583,
   -1,  585,  586,  587,  588,  589,  590,  591,  592,  593,
  594,  595,  596,  597,  598,  599,  600,  601,  602,  603,
  604,  605,  606,  607,  608,  609,  610,  611,  612,  613,
    0,  615,  616,  617,  618,   -1,  620,  621,  622,  623,
  624,  625,   -1,   -1,  628,  629,  630,  631,  632,  633,
  634,  635,  636,   -1,   -1,   -1,   -1,   -1,  642,   -1,
  644,  645,  646,  647,  648,  649,   -1,  651,   -1,   -1,
   40,   41,   42,   43,   44,   45,   46,   47,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,
   60,   61,   62,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,
   -1,   91,   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  284,   -1,  262,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,
   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  333,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,  350,   -1,
  352,   -1,   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,
  362,   -1,  364,  365,  366,   -1,   -1,   -1,   -1,  371,
   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  362,   -1,  364,  365,  366,   -1,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  412,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  412,   -1,   -1,  257,   -1,  259,
   -1,   -1,  262,   -1,  264,  265,   -1,   -1,  268,  269,
   -1,  271,   -1,   -1,   -1,   -1,   -1,  277,   -1,  279,
  280,  281,  282,   -1,  284,   -1,   -1,  287,   -1,   -1,
  290,   -1,   -1,   -1,   -1,   -1,   -1,  297,   -1,  299,
  300,   -1,  302,  303,  304,  305,  306,   -1,   -1,  309,
   -1,   -1,  312,   -1,  314,  315,   -1,   -1,  318,  319,
  320,   -1,  322,  323,  324,  325,  326,  327,  328,   -1,
   -1,   -1,  332,  333,  334,  335,  336,   -1,   -1,   -1,
  340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,
  350,  351,  352,  353,   -1,   -1,   -1,  357,  358,   -1,
  360,   -1,  362,   -1,  364,  365,  366,   -1,  368,   -1,
  370,  371,  372,   -1,  374,  375,  376,  377,  378,   -1,
  380,  381,   -1,   -1,   -1,   -1,  386,   -1,  388,  389,
   -1,   -1,  392,  393,  394,   -1,   -1,  397,   -1,  399,
   -1,   -1,  402,  403,  404,  405,   -1,  407,   -1,  409,
   -1,  411,  412,  413,  414,  415,  598,   -1,  418,  419,
  420,   -1,  422,  423,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  433,  434,  435,   -1,  437,  438,  439,
  598,  441,   -1,   -1,   -1,  445,   -1,  447,  448,  449,
  450,   -1,  452,   -1,  454,  455,  456,  457,  458,  459,
  460,  461,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  471,  472,   41,  474,  475,  476,   -1,   -1,   -1,
   -1,  481,  482,  483,  484,  485,   -1,  487,   -1,   -1,
  490,  491,   60,   61,   62,  495,  496,   41,   -1,  499,
  500,  501,  502,  503,  504,  505,  506,  507,   -1,  509,
   -1,   -1,   -1,   -1,   -1,   -1,   60,   61,   62,  519,
  520,  521,  522,  523,  524,  525,  526,  527,  528,  529,
  530,  531,  532,  533,  534,  535,  536,  537,  538,  539,
   -1,  541,  542,  543,  544,  545,  546,   -1,  548,  549,
  550,  551,   -1,  553,   -1,  555,  556,  557,  558,  559,
  560,  561,  562,  563,  564,  565,  566,  567,  568,  569,
  570,  571,  572,   -1,  574,  575,  576,  577,   -1,  579,
  580,  581,  582,  583,   -1,  585,  586,  587,  588,  589,
  590,  591,  592,  593,  594,  595,  596,  597,  598,  599,
  600,  601,  602,  603,  604,  605,  606,  607,  608,  609,
  610,  611,  612,  613,    0,  615,  616,  617,  618,   -1,
  620,  621,  622,  623,  624,  625,   -1,   -1,  628,  629,
  630,  631,  632,  633,  634,  635,  636,   -1,   -1,   -1,
   -1,   -1,  642,   -1,  644,  645,  646,  647,  648,  649,
   -1,  651,   -1,   -1,   40,   41,   42,   43,   44,   45,
   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   58,   59,   60,   61,   62,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  271,   -1,   91,   -1,   93,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,  262,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  333,  272,   -1,   -1,  275,
   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,
   -1,  325,  350,   -1,  352,  291,   -1,  293,   -1,  333,
   -1,   -1,   -1,   -1,  362,   -1,  364,  365,  366,   -1,
   -1,   -1,   -1,  371,   -1,   -1,  350,   -1,  352,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,
  364,  365,  366,   -1,   -1,  331,   -1,  371,   -1,   -1,
   -1,  337,  338,  339,   -1,  341,  342,  343,   -1,  345,
   -1,   -1,   -1,   -1,  412,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,   -1,  361,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,
   -1,  257,   -1,  259,   -1,   -1,  262,   -1,  264,  265,
   -1,   -1,  268,  269,  390,  271,   -1,   -1,   -1,   -1,
   -1,  277,   -1,  279,  280,  281,  282,   -1,  284,   -1,
  406,  287,   -1,   -1,  290,   -1,   -1,   -1,   -1,   -1,
   -1,  297,   -1,  299,  300,   -1,  302,  303,  304,  305,
  306,   -1,  428,  309,   -1,   -1,  312,   -1,  314,  315,
   -1,   -1,  318,  319,  320,   -1,  322,  323,  324,  325,
  326,  327,  328,   -1,   -1,   -1,  332,  333,  334,  335,
  336,   -1,   -1,   -1,  340,   -1,  462,  463,   -1,   -1,
   -1,   -1,  348,  349,  350,  351,  352,  353,   -1,   -1,
   -1,  357,  358,  479,  360,   -1,  362,   -1,  364,  365,
  366,   -1,  368,   -1,  370,  371,  372,   -1,  374,  375,
  376,  377,  378,   -1,  380,  381,   -1,   -1,   -1,   -1,
  386,   -1,  388,  389,   -1,   -1,  392,  393,  394,   -1,
   -1,  397,   -1,  399,   -1,   -1,  402,  403,  404,  405,
   -1,  407,   -1,  409,   -1,  411,  412,  413,  414,  415,
  598,   -1,  418,  419,  420,   -1,  422,  423,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,  434,  435,
   -1,  437,  438,  439,  598,  441,   -1,   -1,   -1,  445,
   -1,  447,  448,  449,  450,   -1,  452,   -1,  454,  455,
  456,  457,  458,  459,  460,  461,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  471,  472,   41,  474,  475,
  476,   -1,   -1,   -1,   -1,  481,  482,  483,  484,  485,
   -1,  487,   -1,   -1,  490,  491,   60,   61,   62,  495,
  496,   -1,   -1,  499,  500,  501,  502,  503,  504,  505,
  506,  507,   -1,  509,   -1,   -1,   60,   61,   62,   -1,
   -1,   -1,  638,  519,  520,  521,  522,  523,  524,  525,
  526,  527,  528,  529,  530,  531,  532,  533,  534,  535,
  536,  537,  538,  539,   -1,  541,  542,  543,  544,  545,
  546,   -1,  548,  549,  550,  551,   -1,  553,   -1,  555,
  556,  557,  558,  559,  560,  561,  562,  563,  564,  565,
  566,  567,  568,  569,  570,  571,  572,   -1,  574,  575,
  576,  577,   -1,  579,  580,  581,  582,  583,   -1,  585,
  586,  587,  588,  589,  590,  591,  592,  593,  594,  595,
  596,  597,  598,  599,  600,  601,  602,  603,  604,  605,
  606,  607,  608,  609,  610,  611,  612,  613,    0,  615,
  616,  617,  618,   -1,  620,  621,  622,  623,  624,  625,
   -1,   -1,  628,  629,  630,  631,  632,  633,  634,  635,
  636,   -1,   -1,   -1,   -1,   -1,  642,   -1,  644,  645,
  646,  647,  648,  649,   -1,  651,   -1,   -1,   40,   41,
   42,   43,   44,   45,   46,   47,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60,   61,
   62,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,
   -1,   -1,   -1,  275,   -1,   -1,   -1,  271,   -1,   91,
   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,
  284,  265,   -1,   -1,   -1,   -1,   -1,  271,  300,   -1,
   -1,   -1,   -1,   -1,  306,   -1,   -1,   -1,   -1,   -1,
  284,   -1,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  297,  318,   -1,   -1,  329,   -1,   -1,
   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,
   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,
   -1,  325,   -1,   -1,   -1,   -1,  350,   -1,  352,  333,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,
  364,  365,  366,   -1,   -1,   -1,  350,  371,  352,   -1,
   -1,   -1,   -1,   -1,   -1,  387,   -1,   -1,  362,   -1,
  364,  365,  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  417,   -1,   -1,  412,  421,
   -1,   -1,   -1,   -1,  426,   -1,   -1,   -1,   -1,   -1,
  432,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,
   -1,   -1,   -1,   -1,   -1,  257,   -1,  259,  450,   -1,
  262,   -1,  264,  265,   -1,   -1,  268,  269,   -1,  271,
   -1,   -1,   -1,   -1,   -1,  277,   -1,  279,  280,  281,
  282,   -1,  284,   -1,   -1,  287,   -1,   -1,  290,   -1,
   -1,   -1,   -1,   -1,   -1,  297,   -1,  299,  300,   -1,
  302,  303,  304,  305,  306,   -1,   -1,  309,   -1,   -1,
  312,   -1,  314,  315,  506,   -1,  318,  319,  320,   -1,
  322,  323,  324,  325,  326,  327,  328,   -1,   -1,   -1,
  332,  333,  334,  335,  336,   -1,   -1,   -1,  340,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  350,  351,
  352,  353,   -1,   -1,   -1,  357,  358,   -1,  360,   -1,
  362,   -1,  364,  365,  366,   -1,  368,   -1,  370,  371,
  372,   -1,  374,  375,  376,  377,  378,   -1,  380,  381,
   -1,   -1,   -1,   -1,  386,   -1,  388,  389,   -1,   -1,
  392,  393,  394,   -1,   -1,  397,   -1,  399,   -1,   -1,
  402,  403,  404,  405,  596,  407,   -1,  409,   -1,  411,
  412,  413,  414,  415,  598,   -1,  418,  419,  420,   -1,
  422,  423,   -1,  615,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  433,  434,  435,  598,  437,  438,  439,   -1,  441,
   -1,   -1,   -1,  445,   -1,  447,  448,  449,  450,   44,
  452,   -1,  454,  455,  456,  457,  458,  459,  460,  461,
   -1,   -1,   -1,   -1,   -1,   60,   61,   62,   -1,  471,
  472,   -1,  474,  475,  476,   -1,   -1,   -1,   -1,  481,
  482,  483,  484,  485,   -1,  487,   -1,   -1,  490,  491,
   -1,   -1,   -1,  495,  496,   -1,   -1,  499,  500,  501,
  502,  503,  504,  505,  506,  507,   -1,  509,   -1,   -1,
   60,   61,   62,   -1,   -1,   -1,   -1,  519,  520,  521,
  522,  523,  524,  525,  526,  527,  528,  529,  530,  531,
  532,  533,  534,  535,  536,  537,  538,  539,   -1,  541,
  542,  543,  544,  545,  546,   -1,  548,  549,  550,  551,
   -1,  553,   -1,  555,  556,  557,  558,  559,  560,  561,
  562,  563,  564,  565,  566,  567,  568,  569,  570,  571,
  572,   -1,  574,  575,  576,  577,   -1,  579,  580,  581,
  582,  583,   -1,  585,  586,  587,  588,  589,  590,  591,
  592,  593,  594,  595,  596,  597,  598,  599,  600,  601,
  602,  603,  604,  605,  606,  607,  608,  609,  610,  611,
  612,  613,    0,  615,  616,  617,  618,   -1,  620,  621,
  622,  623,  624,  625,   -1,   -1,  628,  629,  630,  631,
  632,  633,  634,  635,  636,   -1,   -1,   -1,   -1,   -1,
  642,   -1,  644,  645,  646,  647,  648,  649,   -1,  651,
   -1,   -1,   40,   41,   42,   43,   44,   45,   46,   47,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,
   58,   59,   60,   61,   62,   -1,  271,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   91,   -1,   93,   -1,   -1,   -1,   -1,
   -1,   -1,  262,   -1,  264,   -1,   -1,   -1,   -1,   -1,
   -1,  271,   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,
  325,   -1,   -1,   -1,  284,   -1,   -1,   -1,  333,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  350,   -1,  352,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,  318,  364,
  365,  366,   -1,   -1,   -1,  325,  371,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  350,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  362,   -1,  364,  365,  366,  412,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  412,   -1,   -1,   -1,   -1,   -1,   -1,  257,
   -1,  259,   -1,   -1,  262,   -1,  264,  265,   -1,   -1,
  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  277,
   -1,  279,  280,  281,  282,   -1,  284,   -1,   -1,  287,
   -1,   -1,  290,   -1,   -1,   -1,   -1,   -1,   -1,  297,
   -1,  299,  300,   -1,  302,  303,  304,  305,  306,   -1,
   -1,  309,   -1,   -1,  312,   -1,  314,  315,   -1,   -1,
  318,  319,  320,   -1,  322,  323,  324,  325,  326,  327,
  328,   -1,   -1,   -1,  332,  333,  334,  335,  336,   -1,
   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  348,  349,  350,  351,  352,  353,   -1,   -1,   -1,  357,
  358,   -1,  360,   -1,  362,   -1,  364,  365,  366,   -1,
  368,   -1,  370,  371,  372,   -1,  374,  375,  376,  377,
  378,   -1,  380,  381,   -1,   -1,   -1,   -1,  386,   -1,
  388,  389,   -1,  598,  392,  393,  394,   -1,   -1,  397,
   -1,  399,   -1,   -1,  402,  403,  404,  405,   -1,  407,
   -1,  409,   -1,  411,  412,  413,  414,  415,   -1,   -1,
  418,  419,  420,   -1,  422,  423,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  433,  434,  435,  598,  437,
  438,  439,   -1,  441,   -1,   -1,   -1,  445,   -1,  447,
  448,  449,  450,   44,  452,   -1,  454,  455,  456,  457,
  458,  459,  460,  461,   -1,   -1,   -1,   -1,   -1,   60,
   61,   62,   -1,  471,  472,   -1,  474,  475,  476,   -1,
   -1,   -1,   -1,  481,  482,  483,  484,  485,   -1,  487,
   -1,   -1,  490,  491,   -1,   -1,   -1,  495,  496,   -1,
   -1,  499,  500,  501,  502,  503,  504,  505,  506,  507,
   -1,  509,   -1,   -1,   60,   61,   62,   -1,   -1,   -1,
   -1,  519,  520,  521,  522,  523,  524,  525,  526,  527,
  528,  529,  530,  531,  532,  533,  534,  535,  536,  537,
  538,  539,   -1,  541,  542,  543,  544,  545,  546,   -1,
  548,  549,  550,  551,   -1,  553,   -1,  555,  556,  557,
  558,  559,  560,  561,  562,  563,  564,  565,  566,  567,
  568,  569,  570,  571,  572,   -1,  574,  575,  576,  577,
   -1,  579,  580,  581,  582,  583,   -1,  585,  586,  587,
  588,  589,  590,  591,  592,  593,  594,  595,  596,  597,
  598,  599,  600,  601,  602,  603,  604,  605,  606,  607,
  608,  609,  610,  611,  612,  613,    0,  615,  616,  617,
  618,   -1,  620,  621,  622,  623,  624,  625,   -1,   -1,
  628,  629,  630,  631,  632,  633,  634,  635,  636,   -1,
   -1,   -1,   -1,   -1,  642,   -1,  644,  645,  646,  647,
  648,  649,   -1,  651,   -1,   -1,   40,   41,   42,   43,
   44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  262,   -1,   -1,   58,   59,   60,   61,   62,   -1,
  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   93,
   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  271,   -1,  318,   -1,   -1,
   -1,   -1,   -1,   -1,  325,   -1,   -1,   -1,  284,   -1,
   -1,   -1,  333,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  350,
   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,
   -1,  362,  318,  364,  365,  366,   -1,   -1,   -1,  325,
  371,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,  364,  365,
  366,  412,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,   -1,   -1,
   -1,   -1,   -1,  257,   -1,  259,   -1,   -1,  262,   -1,
  264,  265,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,
   -1,   -1,   -1,  277,   -1,  279,  280,  281,  282,   -1,
  284,   -1,   -1,  287,   -1,   -1,  290,   -1,   -1,   -1,
   -1,   -1,   -1,  297,   -1,  299,  300,   -1,  302,  303,
  304,  305,  306,   -1,   -1,  309,   -1,   -1,  312,   -1,
  314,  315,   -1,   -1,  318,  319,  320,   -1,  322,  323,
  324,  325,  326,  327,  328,   -1,   -1,   -1,  332,  333,
  334,  335,  336,   -1,   -1,   -1,  340,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  348,  349,  350,  351,  352,  353,
   -1,   -1,   -1,  357,  358,   -1,  360,   -1,  362,   -1,
  364,  365,  366,   -1,  368,   -1,  370,  371,  372,   -1,
  374,  375,  376,  377,  378,   -1,  380,  381,   -1,   -1,
   -1,   -1,  386,   -1,  388,  389,   -1,  598,  392,  393,
  394,   -1,   -1,  397,   -1,  399,   -1,   -1,  402,  403,
  404,  405,   -1,  407,   -1,  409,   -1,  411,  412,  413,
  414,  415,   -1,   -1,  418,  419,  420,   -1,  422,  423,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,
  434,  435,  598,  437,  438,  439,   -1,  441,   -1,   -1,
   -1,  445,   -1,  447,  448,  449,  450,   44,  452,   -1,
  454,  455,  456,  457,  458,  459,  460,  461,   -1,   -1,
   -1,   -1,   -1,   60,   61,   62,   -1,  471,  472,   -1,
  474,  475,  476,   -1,   -1,   -1,   -1,  481,  482,  483,
  484,  485,   -1,  487,   -1,   -1,  490,  491,   -1,   -1,
   -1,  495,  496,   -1,   -1,  499,  500,  501,  502,  503,
  504,  505,  506,  507,   -1,  509,   -1,   -1,   60,   61,
   62,   -1,   -1,   -1,   -1,  519,  520,  521,  522,  523,
  524,  525,  526,  527,  528,  529,  530,  531,  532,  533,
  534,  535,  536,  537,  538,  539,   -1,  541,  542,  543,
  544,  545,  546,   -1,  548,  549,  550,  551,   -1,  553,
   -1,  555,  556,  557,  558,  559,  560,  561,  562,  563,
  564,  565,  566,  567,  568,  569,  570,  571,  572,   -1,
  574,  575,  576,  577,   -1,  579,  580,  581,  582,  583,
   -1,  585,  586,  587,  588,  589,  590,  591,  592,  593,
  594,  595,  596,  597,  598,  599,  600,  601,  602,  603,
  604,  605,  606,  607,  608,  609,  610,  611,  612,  613,
    0,  615,  616,  617,  618,   -1,  620,  621,  622,  623,
  624,  625,   -1,   -1,  628,  629,  630,  631,  632,  633,
  634,  635,  636,   -1,   -1,   -1,   -1,   -1,  642,   -1,
  644,  645,  646,  647,  648,  649,   -1,  651,   -1,   -1,
   40,   41,   42,   43,   44,   45,   46,   47,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   58,   59,
   60,   61,   62,   -1,  271,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   91,   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,
  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,
   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,   -1,
   -1,   -1,  284,   -1,   -1,   -1,  333,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1,
   -1,   -1,  314,   -1,   -1,  362,  318,  364,  365,  366,
   -1,   -1,   -1,  325,  371,   -1,   -1,   -1,   -1,   -1,
   -1,  333,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  350,   -1,
  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  362,   -1,  364,  365,  366,  412,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  412,   -1,   -1,   -1,   -1,   -1,   -1,  257,   -1,  259,
   -1,   -1,  262,   -1,  264,  265,   -1,   -1,  268,  269,
   -1,  271,   -1,   -1,   -1,   -1,   -1,  277,   -1,  279,
  280,  281,  282,   -1,  284,   -1,   -1,  287,   -1,   -1,
  290,   -1,   -1,   -1,   -1,   -1,   -1,  297,   -1,  299,
  300,   -1,  302,  303,  304,  305,  306,   -1,   -1,  309,
   -1,   -1,  312,   -1,  314,  315,   -1,   -1,  318,  319,
  320,   -1,  322,  323,  324,  325,  326,  327,  328,   -1,
   -1,   -1,  332,  333,  334,  335,  336,   -1,   -1,   -1,
  340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,
  350,  351,  352,  353,   -1,   -1,   -1,  357,  358,   -1,
  360,   -1,  362,   -1,  364,  365,  366,   -1,  368,   -1,
  370,  371,  372,   -1,  374,  375,  376,  377,  378,   -1,
  380,  381,   -1,   -1,   -1,   -1,  386,   -1,  388,  389,
   -1,  598,  392,  393,  394,   -1,   -1,  397,   -1,  399,
   -1,   -1,  402,  403,  404,  405,   -1,  407,   -1,  409,
   -1,  411,  412,  413,  414,  415,   -1,   -1,  418,  419,
  420,   -1,  422,  423,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  433,  434,  435,  598,  437,  438,  439,
   -1,  441,   -1,   -1,   -1,  445,   -1,  447,  448,  449,
  450,   44,  452,   -1,  454,  455,  456,  457,  458,  459,
  460,  461,   -1,   -1,   -1,   -1,   -1,   60,   61,   62,
   -1,  471,  472,   -1,  474,  475,  476,   -1,   -1,   -1,
   -1,  481,  482,  483,  484,  485,   -1,  487,   -1,   -1,
  490,  491,   -1,   -1,   -1,  495,  496,   -1,   -1,  499,
  500,  501,  502,  503,  504,  505,  506,  507,   -1,  509,
   -1,   -1,   60,   61,   62,   -1,   -1,   -1,   -1,  519,
  520,  521,  522,  523,  524,  525,  526,  527,  528,  529,
  530,  531,  532,  533,  534,  535,  536,  537,  538,  539,
   -1,  541,  542,  543,  544,  545,  546,   -1,  548,  549,
  550,  551,   -1,  553,   -1,  555,  556,  557,  558,  559,
  560,  561,  562,  563,  564,  565,  566,  567,  568,  569,
  570,  571,  572,   -1,  574,  575,  576,  577,   -1,  579,
  580,  581,  582,  583,   -1,  585,  586,  587,  588,  589,
  590,  591,  592,  593,  594,  595,  596,  597,  598,  599,
  600,  601,  602,  603,  604,  605,  606,  607,  608,  609,
  610,  611,  612,  613,    0,  615,  616,  617,  618,   -1,
  620,  621,  622,  623,  624,  625,   -1,   -1,  628,  629,
  630,  631,  632,  633,  634,  635,  636,   -1,   -1,   -1,
   -1,   -1,  642,   -1,  644,  645,  646,  647,  648,  649,
   -1,  651,   -1,   -1,   40,   41,   42,   43,   44,   45,
   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,
   -1,   -1,   58,   59,   60,   61,   62,   -1,  271,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   91,   -1,   93,   -1,   -1,
   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  271,   -1,  318,   -1,   -1,   -1,   -1,
   -1,   -1,  325,   -1,   -1,   -1,  284,   -1,   -1,   -1,
  333,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  350,   -1,  352,
   -1,   -1,   -1,   -1,  312,   -1,   -1,   -1,   -1,  362,
  318,  364,  365,  366,   -1,   -1,   -1,  325,  371,   -1,
   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  362,   -1,  364,  365,  366,  412,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  412,   -1,   -1,   -1,   -1,   -1,
   -1,  257,   -1,  259,   -1,   -1,  262,   -1,  264,  265,
   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,
   -1,  277,   -1,  279,  280,  281,  282,   -1,  284,   -1,
   -1,  287,   -1,   -1,  290,   -1,   -1,   -1,   -1,   -1,
   -1,  297,   -1,  299,  300,   -1,  302,  303,  304,  305,
  306,   -1,   -1,  309,   -1,   -1,  312,   -1,  314,  315,
   -1,   -1,  318,  319,  320,   -1,  322,  323,  324,  325,
  326,  327,  328,   -1,   -1,   -1,  332,  333,  334,  335,
  336,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  348,  349,  350,  351,  352,  353,   -1,   -1,
   -1,  357,  358,   -1,  360,   -1,  362,   -1,  364,  365,
  366,   -1,  368,   -1,  370,  371,  372,   -1,  374,  375,
  376,  377,  378,   -1,  380,  381,   -1,   -1,   -1,   -1,
  386,   -1,  388,  389,   -1,  598,  392,  393,  394,   -1,
   -1,  397,   -1,  399,   -1,   -1,  402,  403,  404,  405,
   -1,  407,   -1,  409,   -1,  411,  412,  413,  414,  415,
   -1,   -1,  418,  419,  420,   -1,  422,  423,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,  434,  435,
  598,  437,  438,  439,   -1,  441,   -1,   -1,   -1,  445,
   -1,  447,  448,  449,  450,   44,  452,   -1,  454,  455,
  456,  457,  458,  459,  460,  461,   -1,   -1,   -1,   -1,
   -1,   60,   61,   62,   -1,  471,  472,   -1,  474,  475,
  476,   -1,   -1,   -1,   -1,  481,  482,  483,  484,  485,
   -1,  487,   -1,   -1,  490,  491,   -1,   -1,   -1,  495,
  496,   -1,   -1,  499,  500,  501,  502,  503,  504,  505,
  506,  507,   -1,  509,   -1,   -1,   60,   61,   62,   -1,
   -1,   -1,   -1,  519,  520,  521,  522,  523,  524,  525,
  526,  527,  528,  529,  530,  531,  532,  533,  534,  535,
  536,  537,  538,  539,   -1,  541,  542,  543,  544,  545,
  546,   -1,  548,  549,  550,  551,   -1,  553,   -1,  555,
  556,  557,  558,  559,  560,  561,  562,  563,  564,  565,
  566,  567,  568,  569,  570,  571,  572,   -1,  574,  575,
  576,  577,   -1,  579,  580,  581,  582,  583,   -1,  585,
  586,  587,  588,  589,  590,  591,  592,  593,  594,  595,
  596,  597,  598,  599,  600,  601,  602,  603,  604,  605,
  606,  607,  608,  609,  610,  611,  612,  613,    0,  615,
  616,  617,  618,   -1,  620,  621,  622,  623,  624,  625,
   -1,   -1,  628,  629,  630,  631,  632,  633,  634,  635,
  636,   -1,   -1,   -1,   -1,   -1,  642,   -1,  644,  645,
  646,  647,  648,  649,   -1,  651,   -1,   -1,   40,   41,
   42,   43,   44,   45,   46,   47,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  262,   -1,   -1,   58,   59,   60,   61,
   62,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  284,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,
   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,   -1,  318,
   -1,   -1,   -1,   -1,   -1,   -1,  325,   -1,   -1,   -1,
  284,   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  350,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,
  314,   -1,   -1,  362,  318,  364,  365,  366,   -1,   -1,
   -1,  325,  371,   -1,   -1,   -1,   -1,   -1,   -1,  333,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  350,   -1,  352,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,
  364,  365,  366,  412,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,
   -1,   -1,   -1,   -1,   -1,  257,   -1,  259,   -1,   -1,
  262,   -1,  264,  265,   -1,   -1,  268,  269,   -1,  271,
   -1,   -1,   -1,   -1,   -1,  277,   -1,  279,  280,  281,
  282,   -1,  284,   -1,   -1,  287,   -1,   -1,  290,   -1,
   -1,   -1,   -1,   -1,   -1,  297,   -1,  299,  300,   -1,
  302,  303,  304,  305,  306,   -1,   -1,  309,   -1,   -1,
  312,   -1,  314,  315,   -1,   -1,  318,  319,  320,   -1,
  322,  323,  324,  325,  326,  327,  328,   -1,   -1,   -1,
  332,  333,  334,  335,  336,   -1,   -1,   -1,  340,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  350,  351,
  352,  353,   -1,   -1,   -1,  357,  358,   -1,  360,   -1,
  362,   -1,  364,  365,  366,   -1,  368,   -1,  370,  371,
  372,   -1,  374,  375,  376,  377,  378,   -1,  380,  381,
   -1,   -1,   -1,   -1,  386,   -1,  388,  389,   -1,  598,
  392,  393,  394,   -1,   -1,  397,   -1,  399,   -1,   -1,
  402,  403,  404,  405,   -1,  407,   -1,  409,   -1,  411,
  412,  413,  414,  415,   -1,   -1,  418,  419,  420,   -1,
  422,  423,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  433,  434,  435,  598,  437,  438,  439,   -1,  441,
   -1,   -1,   -1,  445,   -1,  447,  448,  449,  450,   44,
  452,   -1,  454,  455,  456,  457,  458,  459,  460,  461,
   -1,   -1,   -1,   -1,   -1,   60,   61,   62,   -1,  471,
  472,   -1,  474,  475,  476,   -1,   -1,   -1,   -1,  481,
  482,  483,  484,  485,   -1,  487,   -1,   -1,  490,  491,
   -1,   -1,   -1,  495,  496,   -1,   -1,  499,  500,  501,
  502,  503,  504,  505,  506,  507,   -1,  509,   -1,   -1,
   60,   61,   62,   -1,   -1,   -1,   -1,  519,  520,  521,
  522,  523,  524,  525,  526,  527,  528,  529,  530,  531,
  532,  533,  534,  535,  536,  537,  538,  539,   -1,  541,
  542,  543,  544,  545,  546,   -1,  548,  549,  550,  551,
   -1,  553,   -1,  555,  556,  557,  558,  559,  560,  561,
  562,  563,  564,  565,  566,  567,  568,  569,  570,  571,
  572,   -1,  574,  575,  576,  577,   -1,  579,  580,  581,
  582,  583,   -1,  585,  586,  587,  588,  589,  590,  591,
  592,  593,  594,  595,  596,  597,  598,  599,  600,  601,
  602,  603,  604,  605,  606,  607,  608,  609,  610,  611,
  612,  613,    0,  615,  616,  617,  618,   -1,  620,  621,
  622,  623,  624,  625,   -1,   -1,  628,  629,  630,  631,
  632,  633,  634,  635,  636,   -1,   -1,   -1,   -1,   -1,
  642,   -1,  644,  645,  646,  647,  648,  649,   -1,  651,
   -1,   -1,   40,   41,   42,   43,   44,   45,   46,   47,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,
   58,   59,   60,   61,   62,   -1,  271,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   91,   -1,   93,   -1,   -1,   -1,   -1,
   -1,   -1,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  271,   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,
  325,   -1,   -1,   -1,  284,   -1,   -1,   -1,  333,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  350,   -1,  352,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,  318,  364,
  365,  366,   -1,   -1,   -1,  325,  371,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  350,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  362,   -1,  364,  365,  366,  412,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  412,   -1,   -1,   -1,   -1,   -1,   -1,  257,
   -1,  259,   -1,   -1,  262,   -1,  264,  265,   -1,   -1,
  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  277,
   -1,  279,  280,  281,  282,   -1,  284,   -1,   -1,  287,
   -1,   -1,  290,   -1,   -1,   -1,   -1,   -1,   -1,  297,
   -1,  299,  300,   -1,  302,  303,  304,  305,  306,   -1,
   -1,  309,   -1,   -1,  312,   -1,  314,  315,   -1,   -1,
  318,  319,  320,   -1,  322,  323,  324,  325,  326,  327,
  328,   -1,   -1,   -1,  332,  333,  334,  335,  336,   -1,
   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  348,  349,  350,  351,  352,  353,   -1,   -1,   -1,  357,
  358,   -1,  360,   -1,  362,   -1,  364,  365,  366,   -1,
  368,   -1,  370,  371,  372,   -1,  374,  375,  376,  377,
  378,   -1,  380,  381,   -1,   -1,   -1,   -1,  386,   -1,
  388,  389,   -1,  598,  392,  393,  394,   -1,   -1,  397,
   -1,  399,   -1,   -1,  402,  403,  404,  405,   -1,  407,
   -1,  409,   -1,  411,  412,  413,  414,  415,   -1,   -1,
  418,  419,  420,   -1,  422,  423,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  433,  434,  435,  598,  437,
  438,  439,   -1,  441,   -1,   -1,   -1,  445,   -1,  447,
  448,  449,  450,   44,  452,   -1,  454,  455,  456,  457,
  458,  459,  460,  461,   -1,   -1,   -1,   -1,   -1,   60,
   61,   62,   -1,  471,  472,   -1,  474,  475,  476,   -1,
   -1,   -1,   -1,  481,  482,  483,  484,  485,   -1,  487,
   -1,   -1,  490,  491,   -1,   -1,   -1,  495,  496,   -1,
   -1,  499,  500,  501,  502,  503,  504,  505,  506,  507,
   -1,  509,   -1,   -1,   60,   61,   62,   -1,   -1,   -1,
   -1,  519,  520,  521,  522,  523,  524,  525,  526,  527,
  528,  529,  530,  531,  532,  533,  534,  535,  536,  537,
  538,  539,   -1,  541,  542,  543,  544,  545,  546,   -1,
  548,  549,  550,  551,   -1,  553,   -1,  555,  556,  557,
  558,  559,  560,  561,  562,  563,  564,  565,  566,  567,
  568,  569,  570,  571,  572,   -1,  574,  575,  576,  577,
   -1,  579,  580,  581,  582,  583,   -1,  585,  586,  587,
  588,  589,  590,  591,  592,  593,  594,  595,  596,  597,
  598,  599,  600,  601,  602,  603,  604,  605,  606,  607,
  608,  609,  610,  611,  612,  613,    0,  615,  616,  617,
  618,   -1,  620,  621,  622,  623,  624,  625,   -1,   -1,
  628,  629,  630,  631,  632,  633,  634,  635,  636,   -1,
   -1,   -1,   -1,   -1,  642,   -1,  644,  645,  646,  647,
  648,  649,   -1,  651,   -1,   -1,   40,   41,   42,   43,
   44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  262,   -1,   -1,   58,   59,   60,   61,   62,   -1,
  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   93,
   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  271,   -1,  318,   -1,   -1,
   -1,   -1,   -1,   -1,  325,   -1,   -1,   -1,  284,   -1,
   -1,   -1,  333,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  350,
   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  362,  318,  364,  365,  366,   -1,   -1,   -1,  325,
  371,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,  364,  365,
  366,  412,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,   -1,   -1,
   -1,   -1,   -1,  257,   -1,  259,   -1,   -1,  262,   -1,
  264,  265,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,
   -1,   -1,   -1,  277,   -1,  279,  280,  281,  282,   -1,
  284,   -1,   -1,  287,   -1,   -1,  290,   -1,   -1,   -1,
   -1,   -1,   -1,  297,   -1,  299,  300,   -1,  302,  303,
  304,  305,  306,   -1,   -1,  309,   -1,   -1,  312,   -1,
  314,  315,   -1,   -1,  318,  319,  320,   -1,  322,  323,
  324,  325,  326,  327,  328,   -1,   -1,   -1,  332,  333,
  334,  335,  336,   -1,   -1,   -1,  340,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  348,  349,  350,  351,  352,  353,
   -1,   -1,   -1,  357,  358,   -1,  360,   -1,  362,   -1,
  364,  365,  366,   -1,  368,   -1,  370,  371,  372,   -1,
  374,  375,  376,  377,  378,   -1,  380,  381,   -1,   -1,
   -1,   -1,  386,   -1,  388,  389,   -1,  598,  392,  393,
  394,   -1,   -1,  397,   -1,  399,   -1,   -1,  402,  403,
  404,  405,   -1,  407,   -1,  409,   -1,  411,  412,  413,
  414,  415,   -1,   -1,  418,  419,  420,   -1,  422,  423,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,
  434,  435,  598,  437,  438,  439,   -1,  441,   -1,   -1,
   -1,  445,   -1,  447,  448,  449,  450,   44,  452,   -1,
  454,  455,  456,  457,  458,  459,  460,  461,   -1,   -1,
   -1,   -1,   -1,   60,   61,   62,   -1,  471,  472,   -1,
  474,  475,  476,   -1,   -1,   -1,   -1,  481,  482,  483,
  484,  485,   -1,  487,   -1,   -1,  490,  491,   -1,   -1,
   -1,  495,  496,   -1,   -1,  499,  500,  501,  502,  503,
  504,  505,  506,  507,   -1,  509,   -1,   -1,   60,   61,
   62,   -1,   -1,   -1,   -1,  519,  520,  521,  522,  523,
  524,  525,  526,  527,  528,  529,  530,  531,  532,  533,
  534,  535,  536,  537,  538,  539,   -1,  541,  542,  543,
  544,  545,  546,   -1,  548,  549,  550,  551,   -1,  553,
   -1,  555,  556,  557,  558,  559,  560,  561,  562,  563,
  564,  565,  566,  567,  568,  569,  570,  571,  572,   -1,
  574,  575,  576,  577,   -1,  579,  580,  581,  582,  583,
   -1,  585,  586,  587,  588,  589,  590,  591,  592,  593,
  594,  595,  596,  597,  598,  599,  600,  601,  602,  603,
  604,  605,  606,  607,  608,  609,  610,  611,  612,  613,
    0,  615,  616,  617,  618,   -1,  620,  621,  622,  623,
  624,  625,   -1,   -1,  628,  629,  630,  631,  632,  633,
  634,  635,  636,   -1,   -1,   -1,   -1,   -1,  642,   -1,
  644,  645,  646,  647,  648,  649,   -1,  651,   -1,   -1,
   40,   41,   42,   43,   44,   45,   46,   47,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   58,   59,
   60,   61,   62,   -1,  271,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   91,   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,
  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,
   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,   -1,
   -1,   -1,  284,   -1,   -1,   -1,  333,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  362,  318,  364,  365,  366,
   -1,   -1,   -1,  325,  371,   -1,   -1,   -1,   -1,   -1,
   -1,  333,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  350,   -1,
  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  362,   -1,  364,  365,  366,  412,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  412,   -1,   -1,   -1,   -1,   -1,   -1,  257,   -1,  259,
   -1,   -1,  262,   -1,  264,  265,   -1,   -1,  268,  269,
   -1,  271,   -1,   -1,   -1,   -1,   -1,  277,   -1,  279,
  280,  281,  282,   -1,  284,   -1,   -1,  287,   -1,   -1,
  290,   -1,   -1,   -1,   -1,   -1,   -1,  297,   -1,  299,
  300,   -1,  302,  303,  304,  305,  306,   -1,   -1,  309,
   -1,   -1,  312,   -1,  314,  315,   -1,   -1,  318,  319,
  320,   -1,  322,  323,  324,  325,  326,  327,  328,   -1,
   -1,   -1,  332,  333,  334,  335,  336,   -1,   -1,   -1,
  340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,
  350,  351,  352,  353,   -1,   -1,   -1,  357,  358,   -1,
  360,   -1,  362,   -1,  364,  365,  366,   -1,  368,   -1,
  370,  371,  372,   -1,  374,  375,  376,  377,  378,   -1,
  380,  381,   -1,   -1,   -1,   -1,  386,   -1,  388,  389,
   -1,  598,  392,  393,  394,   -1,   -1,  397,   -1,  399,
   -1,   -1,  402,  403,  404,  405,   -1,  407,   -1,  409,
   -1,  411,  412,  413,  414,  415,   -1,   -1,  418,  419,
  420,   -1,  422,  423,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  433,  434,  435,  598,  437,  438,  439,
   -1,  441,   -1,   -1,   -1,  445,   -1,  447,  448,  449,
  450,   44,  452,   -1,  454,  455,  456,  457,  458,  459,
  460,  461,   -1,   -1,   -1,   -1,   -1,   60,   61,   62,
   -1,  471,  472,   -1,  474,  475,  476,   -1,   -1,   -1,
   -1,  481,  482,  483,  484,  485,   -1,  487,   -1,   -1,
  490,  491,   -1,   -1,   -1,  495,  496,   -1,   -1,  499,
  500,  501,  502,  503,  504,  505,  506,  507,   -1,  509,
   -1,   -1,   60,   61,   62,   -1,   -1,   -1,   -1,  519,
  520,  521,  522,  523,  524,  525,  526,  527,  528,  529,
  530,  531,  532,  533,  534,  535,  536,  537,  538,  539,
   -1,  541,  542,  543,  544,  545,  546,   -1,  548,  549,
  550,  551,   -1,  553,   -1,  555,  556,  557,  558,  559,
  560,  561,  562,  563,  564,  565,  566,  567,  568,  569,
  570,  571,  572,   -1,  574,  575,  576,  577,   -1,  579,
  580,  581,  582,  583,   -1,  585,  586,  587,  588,  589,
  590,  591,  592,  593,  594,  595,  596,  597,  598,  599,
  600,  601,  602,  603,  604,  605,  606,  607,  608,  609,
  610,  611,  612,  613,    0,  615,  616,  617,  618,   -1,
  620,  621,  622,  623,  624,  625,   -1,   -1,  628,  629,
  630,  631,  632,  633,  634,  635,  636,   -1,   -1,   -1,
   -1,   -1,  642,   -1,  644,  645,  646,  647,  648,  649,
   -1,  651,   -1,   -1,   40,   41,   42,   43,   44,   45,
   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,
   -1,   -1,   58,   59,   60,   61,   62,   -1,  271,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   91,   -1,   93,   -1,   -1,
   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  271,   -1,  318,   -1,   -1,   -1,   -1,
   -1,   -1,  325,   -1,   -1,   -1,  284,   -1,   -1,   -1,
  333,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  350,   -1,  352,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,
  318,  364,  365,  366,   -1,   -1,   -1,  325,  371,   -1,
   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  362,   -1,  364,  365,  366,  412,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  412,   -1,   -1,   -1,   -1,   -1,
   -1,  257,   -1,  259,   -1,   -1,  262,   -1,  264,  265,
   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,
   -1,  277,   -1,  279,  280,  281,  282,   -1,  284,   -1,
   -1,  287,   -1,   -1,  290,   -1,   -1,   -1,   -1,   -1,
   -1,  297,   -1,  299,  300,   -1,  302,  303,  304,  305,
  306,   -1,   -1,  309,   -1,   -1,  312,   -1,  314,  315,
   -1,   -1,  318,  319,  320,   -1,  322,  323,  324,  325,
  326,  327,  328,   -1,   -1,   -1,  332,  333,  334,  335,
  336,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  348,  349,  350,  351,  352,  353,   -1,   -1,
   -1,  357,  358,   -1,  360,   -1,  362,   -1,  364,  365,
  366,   -1,  368,   -1,  370,  371,  372,   -1,  374,  375,
  376,  377,  378,   -1,  380,  381,   -1,   -1,   -1,   -1,
  386,   -1,  388,  389,   -1,  598,  392,  393,  394,   -1,
   -1,  397,   -1,  399,   -1,   -1,  402,  403,  404,  405,
   -1,  407,   -1,  409,   -1,  411,  412,  413,  414,  415,
   -1,   -1,  418,  419,  420,   -1,  422,  423,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,  434,  435,
  598,  437,  438,  439,   -1,  441,   -1,   -1,   -1,  445,
   -1,  447,  448,  449,  450,   44,  452,   -1,  454,  455,
  456,  457,  458,  459,  460,  461,   -1,   -1,   -1,   -1,
   -1,   60,   61,   62,   -1,  471,  472,   -1,  474,  475,
  476,   -1,   -1,   -1,   -1,  481,  482,  483,  484,  485,
   -1,  487,   -1,   -1,  490,  491,   -1,   -1,   -1,  495,
  496,   -1,   -1,  499,  500,  501,  502,  503,  504,  505,
  506,  507,   -1,  509,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  519,  520,  521,  522,  523,  524,  525,
  526,  527,  528,  529,  530,  531,  532,  533,  534,  535,
  536,  537,  538,  539,   -1,  541,  542,  543,  544,  545,
  546,   -1,  548,  549,  550,  551,   -1,  553,   -1,  555,
  556,  557,  558,  559,  560,  561,  562,  563,  564,  565,
  566,  567,  568,  569,  570,  571,  572,   -1,  574,  575,
  576,  577,   -1,  579,  580,  581,  582,  583,   -1,  585,
  586,  587,  588,  589,  590,  591,  592,  593,  594,  595,
  596,  597,  598,  599,  600,  601,  602,  603,  604,  605,
  606,  607,  608,  609,  610,  611,  612,  613,    0,  615,
  616,  617,  618,   -1,  620,  621,  622,  623,  624,  625,
   -1,   -1,  628,  629,  630,  631,  632,  633,  634,  635,
  636,   -1,   -1,   -1,   -1,   -1,  642,   -1,  644,  645,
  646,  647,  648,  649,   -1,  651,   -1,   -1,   40,   41,
   42,   43,   44,   45,   46,   47,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  262,   -1,   -1,   58,   59,   60,   61,
   62,  272,  271,   -1,  275,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  284,  287,   -1,   -1,   -1,
  291,   -1,  293,   -1,   -1,   -1,   -1,   -1,   -1,   91,
   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  272,   -1,   -1,  275,   -1,   -1,   -1,  318,
   -1,   -1,   -1,   -1,   -1,   -1,  325,  287,   -1,   -1,
  331,  291,   -1,  293,  333,   -1,  337,  338,  339,   -1,
  341,  342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1,
   -1,  350,   -1,  352,   -1,   -1,   -1,   -1,  359,   -1,
  361,   -1,   -1,  362,   -1,  364,  365,  366,   -1,   -1,
   -1,  331,  371,   -1,   -1,   -1,   -1,  337,  338,  339,
   -1,  341,  342,  343,   -1,  345,   -1,   -1,   -1,  390,
   -1,   -1,   -1,   -1,  395,   -1,   -1,   -1,   -1,  359,
   -1,  361,   -1,   -1,   -1,  406,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  412,   -1,   -1,   -1,   -1,   -1,  379,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  428,   -1,   -1,
  390,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  406,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  462,  463,   -1,   -1,  257,   -1,  259,  428,   -1,
  262,   -1,  264,  265,   -1,   -1,  268,  269,  479,  271,
   -1,   -1,   -1,   -1,   -1,  277,   -1,  279,  280,  281,
  282,   -1,  284,   -1,   -1,  287,   -1,   -1,  290,   -1,
   -1,   -1,  462,  463,   -1,  297,   -1,  299,  300,   -1,
  302,  303,  304,  305,  306,   -1,   -1,  309,   -1,  479,
  312,   -1,  314,  315,   -1,   -1,  318,  319,  320,   -1,
  322,  323,  324,  325,  326,  327,  328,   -1,   -1,   -1,
  332,  333,  334,  335,  336,   -1,   -1,   -1,  340,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  350,  351,
  352,  353,   -1,   -1,   -1,  357,  358,   -1,  360,   -1,
  362,   -1,  364,  365,  366,   -1,  368,   -1,  370,  371,
  372,   -1,  374,  375,  376,  377,  378,   -1,  380,  381,
   -1,   -1,   -1,   -1,  386,   -1,  388,  389,   -1,  598,
  392,  393,  394,   -1,   -1,  397,   -1,  399,   -1,   -1,
  402,  403,  404,  405,   -1,  407,   -1,  409,   -1,  411,
  412,  413,  414,  415,   -1,   -1,  418,  419,  420,   -1,
  422,  423,   -1,   -1,   -1,   -1,   -1,  638,   -1,   -1,
   -1,  433,  434,  435,   -1,  437,  438,  439,   -1,  441,
   -1,   -1,   -1,  445,   -1,  447,  448,  449,  450,   44,
  452,   -1,  454,  455,  456,  457,  458,  459,  460,  461,
   -1,   -1,   -1,   -1,   -1,   60,   61,   62,  638,  471,
  472,   -1,  474,  475,  476,   -1,   -1,   -1,   -1,  481,
  482,  483,  484,  485,   -1,  487,   -1,   -1,  490,  491,
   -1,   -1,   -1,  495,  496,   -1,   -1,  499,  500,  501,
  502,  503,  504,  505,  506,  507,   -1,  509,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  519,  520,  521,
  522,  523,  524,  525,  526,  527,  528,  529,  530,  531,
  532,  533,  534,  535,  536,  537,  538,  539,   -1,  541,
  542,  543,  544,  545,  546,   -1,  548,  549,  550,  551,
   -1,  553,   -1,  555,  556,  557,  558,  559,  560,  561,
  562,  563,  564,  565,  566,  567,  568,  569,  570,  571,
  572,   -1,  574,  575,  576,  577,   -1,  579,  580,  581,
  582,  583,   -1,  585,  586,  587,  588,  589,  590,  591,
  592,  593,  594,  595,  596,  597,  598,  599,  600,  601,
  602,  603,  604,  605,  606,  607,  608,  609,  610,  611,
  612,  613,    0,  615,  616,  617,  618,   -1,  620,  621,
  622,  623,  624,  625,   -1,   -1,  628,  629,  630,  631,
  632,  633,  634,  635,  636,   -1,   -1,   -1,   -1,   -1,
  642,   -1,  644,  645,  646,  647,  648,  649,   -1,  651,
   -1,   -1,   40,   41,   42,   43,   44,   45,   46,   47,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,
   58,   59,   60,   61,   62,  272,  271,   -1,  275,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,
  287,   -1,   -1,   -1,  291,   -1,  293,   -1,   -1,   -1,
   -1,   -1,   -1,   91,   -1,   93,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  272,   -1,   -1,  275,
   -1,   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,
  325,   -1,   -1,   -1,  331,  291,   -1,  293,  333,   -1,
  337,  338,  339,   -1,  341,  342,  343,   -1,  345,   -1,
   -1,   -1,   -1,   -1,   -1,  350,   -1,  352,   -1,   -1,
   -1,   -1,  359,   -1,  361,   -1,   -1,  362,   -1,  364,
  365,  366,   -1,   -1,   -1,  331,  371,   -1,   -1,   -1,
   -1,  337,  338,  339,   -1,  341,  342,  343,   -1,  345,
   -1,   -1,   -1,  390,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,   -1,  361,   -1,   -1,   -1,  406,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  428,   -1,   -1,  390,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  406,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  462,  463,   -1,   -1,  257,
   -1,  259,  428,   -1,  262,   -1,  264,  265,   -1,   -1,
  268,  269,  479,  271,   -1,   -1,   -1,   -1,   -1,  277,
   -1,  279,  280,  281,  282,   -1,  284,   -1,   -1,  287,
   -1,   -1,  290,   -1,   -1,   -1,  462,  463,   -1,  297,
   -1,  299,  300,   -1,  302,  303,  304,  305,  306,   -1,
   -1,  309,   -1,  479,  312,   -1,  314,  315,   -1,   -1,
  318,  319,  320,   -1,  322,  323,  324,  325,  326,  327,
  328,   -1,   -1,   -1,  332,  333,  334,  335,  336,   -1,
   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  348,  349,  350,  351,  352,  353,   -1,   -1,   -1,  357,
  358,   -1,  360,   -1,  362,   -1,  364,  365,  366,   -1,
  368,   -1,  370,  371,  372,   -1,  374,  375,  376,  377,
  378,   -1,  380,  381,   -1,   -1,   -1,   -1,  386,   -1,
  388,  389,   -1,  598,  392,  393,  394,   -1,   -1,  397,
   -1,  399,   -1,   -1,  402,  403,  404,  405,   -1,  407,
   -1,  409,   -1,  411,  412,  413,  414,  415,   -1,   -1,
  418,  419,  420,   -1,  422,  423,   -1,   -1,   -1,   -1,
   -1,  638,   -1,   -1,   -1,  433,  434,  435,   -1,  437,
  438,  439,   -1,  441,   -1,   -1,   -1,  445,   -1,  447,
  448,  449,  450,   44,  452,   -1,  454,  455,  456,  457,
  458,  459,  460,  461,   -1,   -1,   -1,   -1,   -1,   60,
   61,   62,  638,  471,  472,   -1,  474,  475,  476,   -1,
   -1,   -1,   -1,  481,  482,  483,  484,  485,   -1,  487,
   -1,   -1,  490,  491,   -1,   -1,   -1,  495,  496,   -1,
   -1,  499,  500,  501,  502,  503,  504,  505,  506,  507,
   -1,  509,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  519,  520,  521,  522,  523,  524,  525,  526,  527,
  528,  529,  530,  531,  532,  533,  534,  535,  536,  537,
  538,  539,   -1,  541,  542,  543,  544,  545,  546,   -1,
  548,  549,  550,  551,   -1,  553,   -1,  555,  556,  557,
  558,  559,  560,  561,  562,  563,  564,  565,  566,  567,
  568,  569,  570,  571,  572,   -1,  574,  575,  576,  577,
   -1,  579,  580,  581,  582,  583,   -1,  585,  586,  587,
  588,  589,  590,  591,  592,  593,  594,  595,  596,  597,
  598,  599,  600,  601,  602,  603,  604,  605,  606,  607,
  608,  609,  610,  611,  612,  613,    0,  615,  616,  617,
  618,   -1,  620,  621,  622,  623,  624,  625,   -1,   -1,
  628,  629,  630,  631,  632,  633,  634,  635,  636,   -1,
   -1,   -1,   -1,   -1,  642,   -1,  644,  645,  646,  647,
  648,  649,   -1,  651,   -1,   -1,   40,   41,   42,   43,
   44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  262,   -1,   -1,   58,   59,   60,   61,   62,   -1,
  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  275,  284,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   93,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  300,   -1,   -1,
   -1,   -1,   -1,  306,   -1,   -1,   -1,  318,  311,   -1,
   -1,   -1,   -1,  316,  325,   -1,  319,   -1,   -1,   -1,
   -1,   -1,  333,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  350,
   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  362,   -1,  364,  365,  366,   -1,   -1,   -1,   -1,
  371,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  387,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  412,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  417,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  432,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  450,   -1,   -1,
   -1,   -1,   -1,  257,   -1,  259,   -1,   -1,  262,   -1,
  264,  265,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,
   -1,   -1,   -1,  277,   -1,  279,  280,  281,  282,   -1,
  284,   -1,   -1,  287,   -1,   -1,  290,   -1,   -1,   -1,
   -1,   -1,   -1,  297,   -1,  299,  300,   -1,  302,  303,
  304,  305,  306,  506,   -1,  309,  509,   -1,  312,   -1,
  314,  315,   -1,   -1,  318,  319,  320,   -1,  322,  323,
  324,  325,  326,  327,  328,   -1,   -1,   -1,  332,  333,
  334,  335,  336,   -1,   -1,   -1,  340,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  348,  349,  350,  351,  352,  353,
   -1,   -1,   -1,  357,  358,   -1,  360,   -1,  362,   -1,
  364,  365,  366,   -1,  368,   -1,  370,  371,  372,   -1,
  374,  375,  376,  377,  378,   -1,  380,  381,   -1,   -1,
   -1,   -1,  386,   -1,  388,  389,   -1,  598,  392,  393,
  394,   -1,   -1,  397,   -1,  399,   -1,   -1,  402,  403,
  404,  405,   -1,  407,   -1,  409,   -1,  411,  412,  413,
  414,  415,  615,   -1,  418,  419,  420,   -1,  422,  423,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,
  434,  435,   -1,  437,  438,  439,   -1,  441,   -1,   -1,
   -1,  445,   -1,  447,  448,  449,  450,   44,  452,   -1,
  454,  455,  456,  457,  458,  459,  460,  461,   -1,   -1,
   -1,   -1,   -1,   60,   61,   62,   -1,  471,  472,   -1,
  474,  475,  476,   -1,   -1,   -1,   -1,  481,  482,  483,
  484,  485,   -1,  487,   -1,   -1,  490,  491,   -1,   -1,
   -1,  495,  496,   -1,   -1,  499,  500,  501,  502,  503,
  504,  505,  506,  507,   -1,  509,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  519,  520,  521,  522,  523,
  524,  525,  526,  527,  528,  529,  530,  531,  532,  533,
  534,  535,  536,  537,  538,  539,   -1,  541,  542,  543,
  544,  545,  546,   -1,  548,  549,  550,  551,   -1,  553,
   -1,  555,  556,  557,  558,  559,  560,  561,  562,  563,
  564,  565,  566,  567,  568,  569,  570,  571,  572,   -1,
  574,  575,  576,  577,   -1,  579,  580,  581,  582,  583,
   -1,  585,  586,  587,  588,  589,  590,  591,  592,  593,
  594,  595,  596,  597,  598,  599,  600,  601,  602,  603,
  604,  605,  606,  607,  608,  609,  610,  611,  612,  613,
    0,  615,  616,  617,  618,   -1,  620,  621,  622,  623,
  624,  625,   -1,   -1,  628,  629,  630,  631,  632,  633,
  634,  635,  636,   -1,   -1,   -1,   -1,   -1,  642,   -1,
  644,  645,  646,  647,  648,  649,   -1,  651,   -1,   -1,
   40,   41,   42,   43,   44,   45,   46,   47,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   58,   59,
   60,   61,   62,   -1,  271,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  275,  284,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   91,   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  300,   -1,   -1,   -1,   -1,   -1,  306,   -1,   -1,
   -1,  318,  311,   -1,   -1,   -1,   -1,  316,  325,   -1,
  319,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  362,   -1,  364,  365,  366,
   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  387,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  412,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  417,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  432,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  450,   -1,   -1,   -1,   -1,   -1,  257,   -1,  259,
   -1,   -1,  262,   -1,  264,  265,   -1,   -1,  268,  269,
   -1,  271,   -1,   -1,   -1,   -1,   -1,  277,   -1,  279,
  280,  281,  282,   -1,  284,   -1,   -1,  287,   -1,   -1,
  290,   -1,   -1,   -1,   -1,   -1,   -1,  297,   -1,  299,
  300,   -1,  302,  303,  304,  305,  306,  506,   -1,  309,
  509,   -1,  312,   -1,  314,  315,   -1,   -1,  318,  319,
  320,   -1,  322,  323,  324,  325,  326,  327,  328,   -1,
   -1,   -1,  332,  333,  334,  335,  336,   -1,   -1,   -1,
  340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,
  350,  351,  352,  353,   -1,   -1,   -1,  357,  358,   -1,
  360,   -1,  362,   -1,  364,  365,  366,   -1,  368,   -1,
  370,  371,  372,   -1,  374,  375,  376,  377,  378,   -1,
  380,  381,   -1,   -1,   -1,   -1,  386,   -1,  388,  389,
   -1,  598,  392,  393,  394,   -1,   -1,  397,   -1,  399,
   -1,   -1,  402,  403,  404,  405,   -1,  407,   -1,  409,
   -1,  411,  412,  413,  414,  415,  615,   -1,  418,  419,
  420,   -1,  422,  423,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  433,  434,  435,   -1,  437,  438,  439,
   -1,  441,   -1,   -1,   -1,  445,   -1,  447,  448,  449,
  450,   44,  452,   -1,  454,  455,  456,  457,  458,  459,
  460,  461,   -1,   -1,   -1,   -1,   -1,   60,   61,   62,
   -1,  471,  472,   -1,  474,  475,  476,   -1,   -1,   -1,
   -1,  481,  482,  483,  484,  485,   -1,  487,   -1,   -1,
  490,  491,   -1,   -1,   -1,  495,  496,   -1,   -1,  499,
  500,  501,  502,  503,  504,  505,  506,  507,   -1,  509,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  519,
  520,  521,  522,  523,  524,  525,  526,  527,  528,  529,
  530,  531,  532,  533,  534,  535,  536,  537,  538,  539,
   -1,  541,  542,  543,  544,  545,  546,   -1,  548,  549,
  550,  551,   -1,  553,   -1,  555,  556,  557,  558,  559,
  560,  561,  562,  563,  564,  565,  566,  567,  568,  569,
  570,  571,  572,   -1,  574,  575,  576,  577,   -1,  579,
  580,  581,  582,  583,   -1,  585,  586,  587,  588,  589,
  590,  591,  592,  593,  594,  595,  596,  597,  598,  599,
  600,  601,  602,  603,  604,  605,  606,  607,  608,  609,
  610,  611,  612,  613,    0,  615,  616,  617,  618,   -1,
  620,  621,  622,  623,  624,  625,   -1,   -1,  628,  629,
  630,  631,  632,  633,  634,  635,  636,   -1,   -1,   -1,
   -1,   -1,  642,   -1,  644,  645,  646,  647,  648,  649,
   -1,  651,   -1,   -1,   40,   41,   42,   43,   44,   45,
   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,
   -1,   -1,   58,   59,   60,   61,   62,   -1,  271,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  300,   -1,   -1,   -1,   -1,   91,  306,   93,   -1,   -1,
  310,  311,   -1,   -1,   -1,   -1,  316,   -1,   -1,  319,
   -1,   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,  329,
   -1,   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  333,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  350,   -1,  352,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,
   -1,  364,  365,  366,   -1,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  387,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  402,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  417,   -1,  412,
   -1,  421,   -1,   -1,   -1,   -1,  426,   -1,   -1,   -1,
   -1,   -1,  432,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  450,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  257,   -1,  259,   -1,   -1,  262,   -1,  264,  265,
   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,
   -1,  277,   -1,  279,  280,  281,  282,   -1,  284,   -1,
   -1,  287,   -1,   -1,  290,   -1,  506,   -1,   -1,  509,
   -1,  297,   -1,  299,  300,   -1,  302,  303,  304,  305,
  306,   -1,   -1,  309,   -1,   -1,  312,   -1,  314,  315,
   -1,   -1,  318,  319,  320,   -1,  322,  323,  324,  325,
  326,  327,  328,   -1,   -1,   -1,  332,  333,  334,  335,
  336,   -1,  552,   -1,  340,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  348,  349,  350,  351,  352,  353,   -1,   -1,
   -1,  357,  358,   -1,  360,   -1,  362,   -1,  364,  365,
  366,   -1,  368,   -1,  370,  371,  372,   -1,  374,  375,
  376,  377,  378,   -1,  380,  381,  596,   -1,   -1,   -1,
  386,   -1,  388,  389,   -1,  598,  392,  393,  394,   -1,
   -1,  397,   -1,  399,   -1,  615,  402,  403,  404,  405,
   -1,  407,   -1,  409,   -1,  411,  412,  413,  414,  415,
   -1,   -1,  418,  419,  420,   -1,  422,  423,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,  434,  435,
   -1,  437,  438,  439,   -1,  441,   -1,   -1,   -1,  445,
   -1,  447,  448,  449,  450,   44,  452,   -1,  454,  455,
  456,  457,  458,  459,  460,  461,   -1,   -1,   -1,   -1,
   -1,   60,   61,   62,   -1,  471,  472,   -1,  474,  475,
  476,   -1,   -1,   -1,   -1,  481,  482,  483,  484,  485,
   -1,  487,   -1,   -1,  490,  491,   -1,   -1,   -1,  495,
  496,   -1,   -1,  499,  500,  501,  502,  503,  504,  505,
  506,  507,   -1,  509,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  519,  520,  521,  522,  523,  524,  525,
  526,  527,  528,  529,  530,  531,  532,  533,  534,  535,
  536,  537,  538,  539,   -1,  541,  542,  543,  544,  545,
  546,   -1,  548,  549,  550,  551,   -1,  553,   -1,  555,
  556,  557,  558,  559,  560,  561,  562,  563,  564,  565,
  566,  567,  568,  569,  570,  571,  572,   -1,  574,  575,
  576,  577,   -1,  579,  580,  581,  582,  583,   -1,  585,
  586,  587,  588,  589,  590,  591,  592,  593,  594,  595,
  596,  597,  598,  599,  600,  601,  602,  603,  604,  605,
  606,  607,  608,  609,  610,  611,  612,  613,    0,  615,
  616,  617,  618,   -1,  620,  621,  622,  623,  624,  625,
   -1,   -1,  628,  629,  630,  631,  632,  633,  634,  635,
  636,   -1,   -1,   -1,   -1,   -1,  642,   -1,  644,  645,
  646,  647,  648,  649,   -1,  651,   -1,   -1,   40,   41,
   42,   43,   44,   45,   46,   47,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  262,   -1,   -1,   58,   59,   60,   61,
   62,   -1,  271,   -1,   -1,  300,   -1,   -1,   -1,   -1,
   -1,  306,   -1,   -1,   -1,  284,   -1,   -1,   -1,   -1,
   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,
   -1,   93,   -1,   -1,  329,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,
   -1,   -1,   -1,   -1,   -1,   -1,  325,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  350,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  387,  362,   -1,  364,  365,  366,   -1,   -1,
   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  417,   -1,   -1,   -1,  421,   -1,   -1,   -1,
   -1,  426,   -1,   -1,   -1,   -1,   -1,  432,   -1,   -1,
   -1,   -1,   -1,  412,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  450,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  257,   -1,  259,   -1,   -1,
  262,   -1,  264,  265,   -1,   -1,  268,  269,   -1,  271,
   -1,  506,   -1,   -1,  509,  277,   -1,  279,  280,  281,
  282,   -1,  284,   -1,   -1,  287,   -1,   -1,  290,   -1,
   -1,   -1,   -1,   -1,   -1,  297,   -1,  299,  300,   -1,
  302,  303,  304,  305,  306,   -1,   -1,  309,   -1,   -1,
  312,   -1,  314,  315,   -1,   -1,  318,  319,  320,   -1,
  322,  323,  324,  325,  326,  327,  328,   -1,   -1,   -1,
  332,  333,  334,  335,  336,   -1,   -1,   -1,  340,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  350,  351,
  352,  353,   -1,   -1,   -1,  357,  358,   -1,  360,   -1,
  362,  596,  364,  365,  366,   -1,  368,   -1,  370,  371,
  372,   -1,  374,  375,  376,  377,  378,   -1,  380,  381,
  615,   -1,   -1,   -1,  386,   -1,  388,  389,   -1,  598,
  392,  393,  394,   -1,   -1,  397,   -1,  399,   -1,   -1,
  402,  403,  404,  405,   -1,  407,   -1,  409,   -1,  411,
  412,  413,  414,  415,   -1,   -1,  418,  419,  420,   -1,
  422,  423,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  433,  434,  435,   -1,  437,  438,  439,   -1,  441,
   -1,   -1,   -1,  445,   -1,  447,  448,  449,  450,   44,
  452,   -1,  454,  455,  456,  457,  458,  459,  460,  461,
   -1,   -1,   -1,   -1,   -1,   60,   61,   62,   -1,  471,
  472,   -1,  474,  475,  476,   -1,   -1,   -1,   -1,  481,
  482,  483,  484,  485,   -1,  487,   -1,   -1,  490,  491,
   -1,   -1,   -1,  495,  496,   -1,   -1,  499,  500,  501,
  502,  503,  504,  505,  506,  507,   -1,  509,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  519,  520,  521,
  522,  523,  524,  525,  526,  527,  528,  529,  530,  531,
  532,  533,  534,  535,  536,  537,  538,  539,   -1,  541,
  542,  543,  544,  545,  546,   -1,  548,  549,  550,  551,
   -1,  553,   -1,  555,  556,  557,  558,  559,  560,  561,
  562,  563,  564,  565,  566,  567,  568,  569,  570,  571,
  572,   -1,  574,  575,  576,  577,   -1,  579,  580,  581,
  582,  583,   -1,  585,  586,  587,  588,  589,  590,  591,
  592,  593,  594,  595,  596,  597,  598,  599,  600,  601,
  602,  603,  604,  605,  606,  607,  608,  609,  610,  611,
  612,  613,    0,  615,  616,  617,  618,   -1,  620,  621,
  622,  623,  624,  625,   -1,   -1,  628,  629,  630,  631,
  632,  633,  634,  635,  636,   -1,   -1,   -1,   -1,   -1,
  642,   -1,  644,  645,  646,  647,  648,  649,   -1,  651,
   -1,   -1,   40,   41,   42,   43,   44,   45,   46,   47,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,
   58,   59,   60,   61,   62,   -1,  271,   -1,   -1,  300,
   -1,   -1,   -1,   -1,   -1,  306,   -1,   -1,   -1,  284,
   -1,   -1,   -1,   -1,   -1,  316,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   91,   -1,   93,   -1,   -1,  329,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,
  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  350,   -1,  352,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  387,  362,   -1,  364,
  365,  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  417,   -1,   -1,   -1,
  421,   -1,   -1,   -1,   -1,  426,   -1,   -1,   -1,   -1,
   -1,  432,   -1,   -1,   -1,   -1,   -1,  412,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  450,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,
   -1,  259,   -1,   -1,  262,   -1,  264,  265,   -1,   -1,
  268,  269,   -1,  271,   -1,  506,   -1,   -1,  509,  277,
   -1,  279,  280,  281,  282,   -1,  284,   -1,   -1,  287,
   -1,   -1,  290,   -1,   -1,   -1,   -1,   -1,   -1,  297,
   -1,  299,  300,   -1,  302,  303,  304,  305,  306,   -1,
   -1,  309,   -1,   -1,  312,   -1,  314,  315,   -1,   -1,
  318,  319,  320,   -1,  322,  323,  324,  325,  326,  327,
  328,   -1,   -1,   -1,  332,  333,  334,  335,  336,   -1,
   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  348,  349,  350,  351,  352,  353,   -1,   -1,   -1,  357,
  358,   -1,  360,   -1,  362,  596,  364,  365,  366,   -1,
  368,   -1,  370,  371,  372,   -1,  374,  375,  376,  377,
  378,   -1,  380,  381,  615,   -1,   -1,   -1,  386,   -1,
  388,  389,   -1,  598,  392,  393,  394,   -1,   -1,  397,
   -1,  399,   -1,   -1,  402,  403,  404,  405,   -1,  407,
   -1,  409,   -1,  411,  412,  413,  414,  415,   -1,   -1,
  418,  419,  420,   -1,  422,  423,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  433,  434,  435,   -1,  437,
  438,  439,   -1,  441,   -1,   -1,   -1,  445,   -1,  447,
  448,  449,  450,   44,  452,   -1,  454,  455,  456,  457,
  458,  459,  460,  461,   -1,   -1,   -1,   -1,   -1,   60,
   61,   62,   -1,  471,  472,   -1,  474,  475,  476,   -1,
   -1,   -1,   -1,  481,  482,  483,  484,  485,   -1,  487,
   -1,   -1,  490,  491,   -1,   -1,   -1,  495,  496,   -1,
   -1,  499,  500,  501,  502,  503,  504,  505,  506,  507,
   -1,  509,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  519,  520,  521,  522,  523,  524,  525,  526,  527,
  528,  529,  530,  531,  532,  533,  534,  535,  536,  537,
  538,  539,   -1,  541,  542,  543,  544,  545,  546,   -1,
  548,  549,  550,  551,   -1,  553,   -1,  555,  556,  557,
  558,  559,  560,  561,  562,  563,  564,  565,  566,  567,
  568,  569,  570,  571,  572,   -1,  574,  575,  576,  577,
   -1,  579,  580,  581,  582,  583,   -1,  585,  586,  587,
  588,  589,  590,  591,  592,  593,  594,  595,  596,  597,
  598,  599,  600,  601,  602,  603,  604,  605,  606,  607,
  608,  609,  610,  611,  612,  613,    0,  615,  616,  617,
  618,   -1,  620,  621,  622,  623,  624,  625,   -1,   -1,
  628,  629,  630,  631,  632,  633,  634,  635,  636,   -1,
   -1,   -1,   -1,   -1,  642,   -1,  644,  645,  646,  647,
  648,  649,   -1,  651,   -1,   -1,   40,   41,   42,   43,
   44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  262,   -1,   -1,   58,   59,   60,   61,   62,   -1,
  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   93,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,   -1,
   -1,   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  333,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  350,
   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  362,   -1,  364,  365,  366,   -1,   -1,   -1,   -1,
  371,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  412,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  257,   -1,  259,   -1,   -1,  262,   -1,
  264,  265,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,
   -1,   -1,   -1,  277,   -1,  279,  280,  281,  282,   -1,
  284,   -1,   -1,  287,   -1,   -1,  290,   -1,   -1,   -1,
   -1,   -1,   -1,  297,   -1,  299,  300,   -1,  302,  303,
  304,  305,  306,   -1,   -1,  309,   -1,   -1,  312,   -1,
  314,  315,   -1,   -1,  318,  319,  320,   -1,  322,  323,
  324,  325,  326,  327,  328,   -1,   -1,   -1,  332,  333,
  334,  335,  336,   -1,   -1,   -1,  340,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  348,  349,  350,  351,  352,  353,
   -1,   -1,   -1,  357,  358,   -1,  360,   -1,  362,   -1,
  364,  365,  366,   -1,  368,   -1,  370,  371,  372,   -1,
  374,  375,  376,  377,  378,   -1,  380,  381,   -1,   -1,
   -1,   -1,  386,   -1,  388,  389,   -1,  598,  392,  393,
  394,   -1,   -1,  397,   -1,  399,   -1,   -1,  402,  403,
  404,  405,   -1,  407,   -1,  409,   -1,  411,  412,  413,
  414,  415,   -1,   -1,  418,  419,  420,   -1,  422,  423,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,
  434,  435,   -1,  437,  438,  439,   -1,  441,   -1,   -1,
   -1,  445,   -1,  447,  448,  449,  450,   44,  452,   -1,
  454,  455,  456,  457,  458,  459,  460,  461,   -1,   -1,
   -1,   -1,   -1,   60,   61,   62,   -1,  471,  472,   -1,
  474,  475,  476,   -1,   -1,   -1,   -1,  481,  482,  483,
  484,  485,   -1,  487,   -1,   -1,  490,  491,   -1,   -1,
   -1,  495,  496,   -1,   -1,  499,  500,  501,  502,  503,
  504,  505,  506,  507,   -1,  509,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  519,  520,  521,  522,  523,
  524,  525,  526,  527,  528,  529,  530,  531,  532,  533,
  534,  535,  536,  537,  538,  539,   -1,  541,  542,  543,
  544,  545,  546,   -1,  548,  549,  550,  551,   -1,  553,
   -1,  555,  556,  557,  558,  559,  560,  561,  562,  563,
  564,  565,  566,  567,  568,  569,  570,  571,  572,   -1,
  574,  575,  576,  577,   -1,  579,  580,  581,  582,  583,
   -1,  585,  586,  587,  588,  589,  590,  591,  592,  593,
  594,  595,  596,  597,  598,  599,  600,  601,  602,  603,
  604,  605,  606,  607,  608,  609,  610,  611,  612,  613,
    0,  615,  616,  617,  618,   -1,  620,  621,  622,  623,
  624,  625,   -1,   -1,  628,  629,  630,  631,  632,  633,
  634,  635,  636,   -1,   -1,   -1,   -1,   -1,  642,   -1,
  644,  645,  646,  647,  648,  649,   -1,  651,   -1,   -1,
   40,   41,   42,   43,   44,   45,   46,   47,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   58,   59,
   60,   61,   62,   -1,  271,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   91,   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  362,   -1,  364,  365,  366,
   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  412,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,   -1,  259,
   -1,   -1,  262,   -1,  264,  265,   -1,   -1,  268,  269,
   -1,  271,   -1,   -1,   -1,   -1,   -1,  277,   -1,  279,
  280,  281,  282,   -1,  284,   -1,   -1,  287,   -1,   -1,
  290,   -1,   -1,   -1,   -1,   -1,   -1,  297,   -1,  299,
  300,   -1,  302,  303,  304,  305,  306,   -1,   -1,  309,
   -1,   -1,  312,   -1,  314,  315,   -1,   -1,  318,  319,
  320,   -1,  322,  323,  324,  325,  326,  327,  328,   -1,
   -1,   -1,  332,  333,  334,  335,  336,   -1,   -1,   -1,
  340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,
  350,  351,  352,  353,   -1,   -1,   -1,  357,  358,   -1,
  360,   -1,  362,   -1,  364,  365,  366,   -1,  368,   -1,
  370,  371,  372,   -1,  374,  375,  376,  377,  378,   -1,
  380,  381,   -1,   -1,   -1,   -1,  386,   -1,  388,  389,
   -1,  598,  392,  393,  394,   -1,   -1,  397,   -1,  399,
   -1,   -1,  402,  403,  404,  405,   -1,  407,   -1,  409,
   -1,  411,  412,  413,  414,  415,   -1,   -1,  418,  419,
  420,   -1,  422,  423,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  433,  434,  435,   -1,  437,  438,  439,
   -1,  441,   -1,   -1,   -1,  445,   -1,  447,  448,  449,
  450,   44,  452,   -1,  454,  455,  456,  457,  458,  459,
  460,  461,   -1,   -1,   -1,   -1,   -1,   60,   61,   62,
   -1,  471,  472,   -1,  474,  475,  476,   -1,   -1,   -1,
   -1,  481,  482,  483,  484,  485,   -1,  487,   -1,   -1,
  490,  491,   -1,   -1,   -1,  495,  496,   -1,   -1,  499,
  500,  501,  502,  503,  504,  505,  506,  507,   -1,  509,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  519,
  520,  521,  522,  523,  524,  525,  526,  527,  528,  529,
  530,  531,  532,  533,  534,  535,  536,  537,  538,  539,
   -1,  541,  542,  543,  544,  545,  546,   -1,  548,  549,
  550,  551,   -1,  553,   -1,  555,  556,  557,  558,  559,
  560,  561,  562,  563,  564,  565,  566,  567,  568,  569,
  570,  571,  572,   -1,  574,  575,  576,  577,   -1,  579,
  580,  581,  582,  583,   -1,  585,  586,  587,  588,  589,
  590,  591,  592,  593,  594,  595,  596,  597,  598,  599,
  600,  601,  602,  603,  604,  605,  606,  607,  608,  609,
  610,  611,  612,  613,    0,  615,  616,  617,  618,   -1,
  620,  621,  622,  623,  624,  625,   -1,   -1,  628,  629,
  630,  631,  632,  633,  634,  635,  636,   -1,   -1,   -1,
   -1,   -1,  642,   -1,  644,  645,  646,  647,  648,  649,
   -1,  651,   -1,   -1,   40,   41,   42,   43,   44,   45,
   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,
   -1,   -1,   58,   59,   60,   61,   62,   -1,  271,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   91,   -1,   93,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,   -1,
   -1,   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  333,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  350,   -1,  352,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,
   -1,  364,  365,  366,   -1,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  412,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  257,   -1,  259,   -1,   -1,  262,   -1,  264,  265,
   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,
   -1,  277,   -1,  279,  280,  281,  282,   -1,  284,   -1,
   -1,  287,   -1,   -1,  290,   -1,   -1,   -1,   -1,   -1,
   -1,  297,   -1,  299,  300,   -1,  302,  303,  304,  305,
  306,   -1,   -1,  309,   -1,   -1,  312,   -1,  314,  315,
   -1,   -1,  318,  319,  320,   -1,  322,  323,  324,  325,
  326,  327,  328,   -1,   -1,   -1,  332,  333,  334,  335,
  336,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  348,  349,  350,  351,  352,  353,   -1,   -1,
   -1,  357,  358,   -1,  360,   -1,  362,   -1,  364,  365,
  366,   -1,  368,   -1,  370,  371,  372,   -1,  374,  375,
  376,  377,  378,   -1,  380,  381,   -1,   -1,   -1,   -1,
  386,   -1,  388,  389,   -1,  598,  392,  393,  394,   -1,
   -1,  397,   -1,  399,   -1,   -1,  402,  403,  404,  405,
   -1,  407,   -1,  409,   -1,  411,  412,  413,  414,  415,
   -1,   -1,  418,  419,  420,   -1,  422,  423,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,  434,  435,
   -1,  437,  438,  439,   -1,  441,   -1,   -1,   -1,  445,
   -1,  447,  448,  449,  450,   44,  452,   -1,  454,  455,
  456,  457,  458,  459,  460,  461,   -1,   -1,   -1,   -1,
   -1,   60,   61,   62,   -1,  471,  472,   -1,  474,  475,
  476,   -1,   -1,   -1,   -1,  481,  482,  483,  484,  485,
   -1,  487,   -1,   -1,  490,  491,   -1,   -1,   -1,  495,
  496,   -1,   -1,  499,  500,  501,  502,  503,  504,  505,
  506,  507,   -1,  509,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  519,  520,  521,  522,  523,  524,  525,
  526,  527,  528,  529,  530,  531,  532,  533,  534,  535,
  536,  537,  538,  539,   -1,  541,  542,  543,  544,  545,
  546,   -1,  548,  549,  550,  551,   -1,  553,   -1,  555,
  556,  557,  558,  559,  560,  561,  562,  563,  564,  565,
  566,  567,  568,  569,  570,  571,  572,   -1,  574,  575,
  576,  577,   -1,  579,  580,  581,  582,  583,   -1,  585,
  586,  587,  588,  589,  590,  591,  592,  593,  594,  595,
  596,  597,  598,  599,  600,  601,  602,  603,  604,  605,
  606,  607,  608,  609,  610,  611,  612,  613,    0,  615,
  616,  617,  618,   -1,  620,  621,  622,  623,  624,  625,
   -1,   -1,  628,  629,  630,  631,  632,  633,  634,  635,
  636,   -1,   -1,   -1,   -1,   -1,  642,   -1,  644,  645,
  646,  647,  648,  649,   -1,  651,   -1,   -1,   40,   41,
   42,   43,   44,   45,   46,   47,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  262,   -1,   -1,   58,   59,   60,   61,
   62,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  284,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,
   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,
   -1,   -1,   -1,   -1,   -1,   -1,  325,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  350,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  362,   -1,  364,  365,  366,   -1,   -1,
   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  412,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  257,   -1,  259,   -1,   -1,
  262,   -1,  264,  265,   -1,   -1,  268,  269,   -1,  271,
   -1,   -1,   -1,   -1,   -1,  277,   -1,  279,  280,  281,
  282,   -1,  284,   -1,   -1,  287,   -1,   -1,  290,   -1,
   -1,   -1,   -1,   -1,   -1,  297,   -1,  299,  300,   -1,
  302,  303,  304,  305,  306,   -1,   -1,  309,   -1,   -1,
  312,   -1,  314,  315,   -1,   -1,  318,  319,  320,   -1,
  322,  323,  324,  325,  326,  327,  328,   -1,   -1,   -1,
  332,  333,  334,  335,  336,   -1,   -1,   -1,  340,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  350,  351,
  352,  353,   -1,   -1,   -1,  357,  358,   -1,  360,   -1,
  362,   -1,  364,  365,  366,   -1,  368,   -1,  370,  371,
  372,   -1,  374,  375,  376,  377,  378,   -1,  380,  381,
   -1,   -1,   -1,   -1,  386,   -1,  388,  389,   -1,  598,
  392,  393,  394,   -1,   -1,  397,   -1,  399,   -1,   -1,
  402,  403,  404,  405,   -1,  407,   -1,  409,   -1,  411,
  412,  413,  414,  415,   -1,   -1,  418,  419,  420,   -1,
  422,  423,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  433,  434,  435,   -1,  437,  438,  439,   -1,  441,
   -1,   -1,   -1,  445,   -1,  447,  448,  449,  450,   44,
  452,   -1,  454,  455,  456,  457,  458,  459,  460,  461,
   -1,   -1,   -1,   -1,   -1,   60,   61,   62,   -1,  471,
  472,   -1,  474,  475,  476,   -1,   -1,   -1,   -1,  481,
  482,  483,  484,  485,   -1,  487,   -1,   -1,  490,  491,
   -1,   -1,   -1,  495,  496,   -1,   -1,  499,  500,  501,
  502,  503,  504,  505,  506,  507,   -1,  509,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  519,  520,  521,
  522,  523,  524,  525,  526,  527,  528,  529,  530,  531,
  532,  533,  534,  535,  536,  537,  538,  539,   -1,  541,
  542,  543,  544,  545,  546,   -1,  548,  549,  550,  551,
   -1,  553,   -1,  555,  556,  557,  558,  559,  560,  561,
  562,  563,  564,  565,  566,  567,  568,  569,  570,  571,
  572,   -1,  574,  575,  576,  577,   -1,  579,  580,  581,
  582,  583,   -1,  585,  586,  587,  588,  589,  590,  591,
  592,  593,  594,  595,  596,  597,  598,  599,  600,  601,
  602,  603,  604,  605,  606,  607,  608,  609,  610,  611,
  612,  613,    0,  615,  616,  617,  618,   -1,  620,  621,
  622,  623,  624,  625,   -1,   -1,  628,  629,  630,  631,
  632,  633,  634,  635,  636,   -1,   -1,   -1,   -1,   -1,
  642,   -1,  644,  645,  646,  647,  648,  649,   -1,  651,
   -1,   -1,   40,   41,   42,   43,   44,   45,   46,   47,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,
   58,   59,   60,   61,   62,   -1,  271,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   91,   -1,   93,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,
  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  350,   -1,  352,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,  364,
  365,  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,
   -1,  259,   -1,   -1,  262,   -1,  264,  265,   -1,   -1,
  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  277,
   -1,  279,  280,  281,  282,   -1,  284,   -1,   -1,  287,
   -1,   -1,  290,   -1,   -1,   -1,   -1,   -1,   -1,  297,
   -1,  299,  300,   -1,  302,  303,  304,  305,  306,   -1,
   -1,  309,   -1,   -1,  312,   -1,  314,  315,   -1,   -1,
  318,  319,  320,   -1,  322,  323,  324,  325,  326,  327,
  328,   -1,   -1,   -1,  332,  333,  334,  335,  336,   -1,
   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  348,  349,  350,  351,  352,  353,   -1,   -1,   -1,  357,
  358,   -1,  360,   -1,  362,   -1,  364,  365,  366,   -1,
  368,   -1,  370,  371,  372,   -1,  374,  375,  376,  377,
  378,   -1,  380,  381,   -1,   -1,   -1,   -1,  386,   -1,
  388,  389,   -1,  598,  392,  393,  394,   -1,   -1,  397,
   -1,  399,   -1,   -1,  402,  403,  404,  405,   -1,  407,
   -1,  409,   -1,  411,  412,  413,  414,  415,   -1,   -1,
  418,  419,  420,   -1,  422,  423,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  433,  434,  435,   -1,  437,
  438,  439,   -1,  441,   -1,   -1,   -1,  445,   -1,  447,
  448,  449,  450,   44,  452,   -1,  454,  455,  456,  457,
  458,  459,  460,  461,   -1,   -1,   -1,   -1,   -1,   60,
   61,   62,   -1,  471,  472,   -1,  474,  475,  476,   -1,
   -1,   -1,   -1,  481,  482,  483,  484,  485,   -1,  487,
   -1,   -1,  490,  491,   -1,   -1,   -1,  495,  496,   -1,
   -1,  499,  500,  501,  502,  503,  504,  505,  506,  507,
   -1,  509,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  519,  520,  521,  522,  523,  524,  525,  526,  527,
  528,  529,  530,  531,  532,  533,  534,  535,  536,  537,
  538,  539,   -1,  541,  542,  543,  544,  545,  546,   -1,
  548,  549,  550,  551,   -1,  553,   -1,  555,  556,  557,
  558,  559,  560,  561,  562,  563,  564,  565,  566,  567,
  568,  569,  570,  571,  572,   -1,  574,  575,  576,  577,
   -1,  579,  580,  581,  582,  583,   -1,  585,  586,  587,
  588,  589,  590,  591,  592,  593,  594,  595,  596,  597,
  598,  599,  600,  601,  602,  603,  604,  605,  606,  607,
  608,  609,  610,  611,  612,  613,    0,  615,  616,  617,
  618,   -1,  620,  621,  622,  623,  624,  625,   -1,   -1,
  628,  629,  630,  631,  632,  633,  634,  635,  636,   -1,
   -1,   -1,   -1,   -1,  642,   -1,  644,  645,  646,  647,
  648,  649,   -1,  651,   -1,   -1,   40,   41,   42,   43,
   44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  262,   -1,   -1,   58,   59,   60,   61,   62,   -1,
  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   93,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,   -1,
   -1,   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  333,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  350,
   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  362,   -1,  364,  365,  366,   -1,   -1,   -1,   -1,
  371,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  412,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  257,   -1,  259,   -1,   -1,  262,   -1,
  264,  265,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,
   -1,   -1,   -1,  277,   -1,  279,  280,  281,  282,   -1,
  284,   -1,   -1,  287,   -1,   -1,  290,   -1,   -1,   -1,
   -1,   -1,   -1,  297,   -1,  299,  300,   -1,  302,  303,
  304,  305,  306,   -1,   -1,  309,   -1,   -1,  312,   -1,
  314,  315,   -1,   -1,  318,  319,  320,   -1,  322,  323,
  324,  325,  326,  327,  328,   -1,   -1,   -1,  332,  333,
  334,  335,  336,   -1,   -1,   -1,  340,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  348,  349,  350,  351,  352,  353,
   -1,   -1,   -1,  357,  358,   -1,  360,   -1,  362,   -1,
  364,  365,  366,   -1,  368,   -1,  370,  371,  372,   -1,
  374,  375,  376,  377,  378,   -1,  380,  381,   -1,   -1,
   -1,   -1,  386,   -1,  388,  389,   -1,  598,  392,  393,
  394,   -1,   -1,  397,   -1,  399,   -1,   -1,  402,  403,
  404,  405,   -1,  407,   -1,  409,   -1,  411,  412,  413,
  414,  415,   -1,   -1,  418,  419,  420,   -1,  422,  423,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,
  434,  435,   -1,  437,  438,  439,   -1,  441,   -1,   -1,
   -1,  445,   -1,  447,  448,  449,  450,   44,  452,   -1,
  454,  455,  456,  457,  458,  459,  460,  461,   -1,   -1,
   -1,   -1,   -1,   60,   61,   62,   -1,  471,  472,   -1,
  474,  475,  476,   -1,   -1,   -1,   -1,  481,  482,  483,
  484,  485,   -1,  487,   -1,   -1,  490,  491,   -1,   -1,
   -1,  495,  496,   -1,   -1,  499,  500,  501,  502,  503,
  504,  505,  506,  507,   -1,  509,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  519,  520,  521,  522,  523,
  524,  525,  526,  527,  528,  529,  530,  531,  532,  533,
  534,  535,  536,  537,  538,  539,   -1,  541,  542,  543,
  544,  545,  546,   -1,  548,  549,  550,  551,   -1,  553,
   -1,  555,  556,  557,  558,  559,  560,  561,  562,  563,
  564,  565,  566,  567,  568,  569,  570,  571,  572,   -1,
  574,  575,  576,  577,   -1,  579,  580,  581,  582,  583,
   -1,  585,  586,  587,  588,  589,  590,  591,  592,  593,
  594,  595,  596,  597,  598,  599,  600,  601,  602,  603,
  604,  605,  606,  607,  608,  609,  610,  611,  612,  613,
    0,  615,  616,  617,  618,   -1,  620,  621,  622,  623,
  624,  625,   -1,   -1,  628,  629,  630,  631,  632,  633,
  634,  635,  636,   -1,   -1,   -1,   -1,   -1,  642,   -1,
  644,  645,  646,  647,  648,  649,   -1,  651,   -1,   -1,
   40,   41,   42,   43,   44,   45,   46,   47,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   58,   59,
   60,   61,   62,   -1,  271,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   91,   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,  325,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  362,   -1,  364,  365,  366,
   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  412,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,   -1,  259,
   -1,   -1,  262,   -1,  264,  265,   -1,   -1,  268,  269,
   -1,  271,   -1,   -1,   -1,   -1,   -1,  277,   -1,  279,
  280,  281,  282,   -1,  284,   -1,   -1,  287,   -1,   -1,
  290,   -1,   -1,   -1,   -1,   -1,   -1,  297,   -1,  299,
  300,   -1,  302,  303,  304,  305,  306,   -1,   -1,  309,
   -1,   -1,  312,   -1,  314,  315,   -1,   -1,  318,  319,
  320,   -1,  322,  323,  324,  325,  326,  327,  328,   -1,
   -1,   -1,  332,  333,  334,  335,  336,   -1,   -1,   -1,
  340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,
  350,  351,  352,  353,   -1,   -1,   -1,  357,  358,   -1,
  360,   -1,  362,   -1,  364,  365,  366,   -1,  368,   -1,
  370,  371,  372,   -1,  374,  375,  376,  377,  378,   -1,
  380,  381,   -1,   -1,   -1,   -1,  386,   -1,  388,  389,
   -1,  598,  392,  393,  394,   -1,   -1,  397,   -1,  399,
   -1,   -1,  402,  403,  404,  405,   -1,  407,   -1,  409,
   -1,  411,  412,  413,  414,  415,   -1,   -1,  418,  419,
  420,   -1,  422,  423,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  433,  434,  435,   -1,  437,  438,  439,
   -1,  441,   -1,   -1,   -1,  445,   -1,  447,  448,  449,
  450,   -1,  452,   -1,  454,  455,  456,  457,  458,  459,
  460,  461,   -1,   -1,   -1,   -1,   -1,   60,   61,   62,
   -1,  471,  472,   -1,  474,  475,  476,   -1,   -1,   -1,
   -1,  481,  482,  483,  484,  485,   -1,  487,   -1,   -1,
  490,  491,   -1,   -1,   -1,  495,  496,   -1,   -1,  499,
  500,  501,  502,  503,  504,  505,  506,  507,   -1,  509,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  519,
  520,  521,  522,  523,  524,  525,  526,  527,  528,  529,
  530,  531,  532,  533,  534,  535,  536,  537,  538,  539,
   -1,  541,  542,  543,  544,  545,  546,   -1,  548,  549,
  550,  551,   -1,  553,   -1,  555,  556,  557,  558,  559,
  560,  561,  562,  563,  564,  565,  566,  567,  568,  569,
  570,  571,  572,   -1,  574,  575,  576,  577,   -1,  579,
  580,  581,  582,  583,   -1,  585,  586,  587,  588,  589,
  590,  591,  592,  593,  594,  595,  596,  597,  598,  599,
  600,  601,  602,  603,  604,  605,  606,  607,  608,  609,
  610,  611,  612,  613,    0,  615,  616,  617,  618,   -1,
  620,  621,  622,  623,  624,  625,   -1,   -1,  628,  629,
  630,  631,  632,  633,  634,  635,  636,   -1,   -1,   -1,
   -1,   -1,  642,   -1,  644,  645,  646,  647,  648,  649,
   -1,  651,   -1,   -1,   40,   41,   42,   43,   44,   45,
   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,
   -1,   -1,   58,   59,   60,   61,   62,   -1,  271,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   91,   -1,   93,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,   -1,
   -1,   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  333,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  350,   -1,  352,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,
   -1,  364,  365,  366,   -1,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  412,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  454,  455,  456,  457,  458,  459,  460,  461,   -1,
   -1,  257,   -1,  259,   -1,   -1,  262,   -1,  264,  265,
   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,
   -1,  277,   -1,  279,  280,  281,  282,   -1,  284,   -1,
   -1,  287,   -1,   -1,  290,   -1,   -1,   -1,   -1,   -1,
   -1,  297,   -1,  299,  300,   -1,  302,  303,  304,  305,
  306,   -1,   -1,  309,   -1,   -1,  312,   -1,  314,  315,
   -1,   -1,  318,  319,  320,   -1,  322,  323,  324,  325,
  326,  327,  328,   -1,   -1,   -1,  332,  333,  334,  335,
  336,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  348,  349,  350,  351,  352,  353,   -1,   -1,
  563,  357,  358,   -1,  360,   -1,  362,   -1,  364,  365,
  366,   -1,  368,   -1,  370,  371,  372,   -1,  374,  375,
  376,  377,  378,   -1,  380,  381,  589,   -1,   -1,   -1,
  386,   -1,  388,  389,   -1,  598,  392,  393,  394,   -1,
   -1,  397,   -1,  399,   -1,   -1,  402,  403,  404,  405,
   -1,  407,   -1,  409,   -1,  411,  412,  413,  414,  415,
   -1,   -1,  418,  419,  420,   -1,  422,  423,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,  434,  435,
   -1,  437,  438,  439,   -1,  441,   -1,   -1,   -1,  445,
   -1,  447,  448,  449,  450,   -1,  452,   -1,  454,  455,
  456,  457,  458,  459,  460,  461,   -1,   -1,   -1,   -1,
   60,   61,   62,   -1,   -1,  471,  472,   -1,  474,  475,
  476,   -1,   -1,   -1,   -1,  481,  482,  483,  484,  485,
   -1,  487,   -1,   -1,  490,  491,   60,   61,   62,  495,
  496,   -1,   -1,  499,  500,  501,  502,  503,  504,  505,
  506,  507,   -1,  509,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  519,  520,  521,  522,  523,  524,  525,
  526,  527,  528,  529,  530,  531,  532,  533,  534,  535,
  536,  537,  538,  539,   -1,  541,  542,  543,  544,  545,
  546,   -1,  548,  549,  550,  551,   -1,  553,   -1,  555,
  556,  557,  558,  559,  560,  561,  562,  563,  564,  565,
  566,  567,  568,  569,  570,  571,  572,   -1,  574,  575,
  576,  577,   -1,  579,  580,  581,  582,  583,   -1,  585,
  586,  587,  588,  589,  590,  591,  592,  593,  594,  595,
  596,  597,  598,  599,  600,  601,  602,  603,  604,  605,
  606,  607,  608,  609,  610,  611,  612,  613,    0,  615,
  616,  617,  618,   -1,  620,  621,  622,  623,  624,  625,
   -1,   -1,  628,  629,  630,  631,  632,  633,  634,  635,
  636,   -1,   -1,   -1,   -1,   -1,  642,   -1,  644,  645,
  646,  647,  648,  649,   -1,  651,   -1,   -1,   40,   41,
   42,   43,   44,   45,   46,   47,   -1,   -1,   -1,   -1,
   -1,   -1,  262,   -1,   -1,   -1,   58,   59,   60,   61,
   62,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  284,   -1,   -1,   -1,  262,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,   -1,   91,
   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,
   -1,   -1,   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,
  350,  325,  352,   -1,   -1,   -1,   -1,   -1,   -1,  333,
   -1,   -1,  362,   -1,  364,  365,  366,   -1,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,  350,   -1,  352,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,
  364,  365,  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  412,   -1,   -1,   -1,   -1,   -1,   -1,  419,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  257,   -1,  259,   -1,   -1,
  262,   -1,  264,  265,   -1,   -1,  268,  269,   -1,  271,
   -1,   -1,   -1,   -1,   -1,  277,   -1,  279,  280,  281,
  282,   -1,  284,   -1,   -1,  287,   -1,   -1,  290,   -1,
   -1,   -1,   -1,   -1,   -1,  297,   -1,  299,  300,   -1,
  302,  303,  304,  305,  306,   -1,   -1,  309,   -1,   -1,
  312,   -1,  314,  315,   -1,   -1,  318,  319,  320,   -1,
  322,  323,  324,  325,  326,  327,  328,   -1,   -1,   -1,
  332,  333,  334,  335,  336,   -1,   -1,   -1,  340,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  350,  351,
  352,  353,   -1,   -1,   -1,  357,  358,   -1,  360,   -1,
  362,   -1,  364,  365,  366,   -1,  368,   -1,  370,  371,
  372,   -1,  374,  375,  376,  377,  378,   -1,  380,  381,
   -1,   -1,   -1,   -1,  386,  569,  388,  389,  598,   -1,
  392,  393,  394,   -1,   -1,  397,   -1,  399,   -1,   -1,
  402,  403,  404,  405,   -1,  407,   -1,  409,   -1,  411,
  412,  413,  414,  415,  598,   -1,  418,  419,  420,   -1,
  422,  423,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  433,  434,  435,   -1,  437,  438,  439,   -1,  441,
   -1,   -1,   -1,  445,   -1,  447,  448,  449,  450,   -1,
  452,   -1,  454,  455,  456,  457,  458,  459,  460,  461,
   -1,   -1,   -1,   -1,   60,   61,   62,   -1,   -1,  471,
  472,   -1,  474,  475,  476,   60,   61,   62,   -1,  481,
  482,  483,  484,  485,   -1,  487,   -1,   -1,  490,  491,
   -1,   -1,   -1,  495,  496,   -1,   -1,  499,  500,  501,
  502,  503,  504,  505,  506,  507,   -1,  509,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  519,  520,  521,
  522,  523,  524,  525,  526,  527,  528,  529,  530,  531,
  532,  533,  534,  535,  536,  537,  538,  539,   -1,  541,
  542,  543,  544,  545,  546,   -1,  548,  549,  550,  551,
   -1,  553,   -1,  555,  556,  557,  558,  559,  560,  561,
  562,  563,  564,  565,  566,  567,  568,  569,  570,  571,
  572,   -1,  574,  575,  576,  577,   -1,  579,  580,  581,
  582,  583,   -1,  585,  586,  587,  588,  589,  590,  591,
  592,  593,  594,  595,  596,  597,  598,  599,  600,  601,
  602,  603,  604,  605,  606,  607,  608,  609,  610,  611,
  612,  613,    0,  615,  616,  617,  618,   -1,  620,  621,
  622,  623,  624,  625,   -1,   -1,  628,  629,  630,  631,
  632,  633,  634,  635,  636,   -1,   -1,   -1,   -1,   -1,
  642,   -1,  644,  645,  646,  647,  648,  649,   -1,  651,
   -1,   -1,   -1,   41,   42,   43,   44,   45,   46,   47,
   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,
   58,   59,   60,   61,   62,  271,   -1,  262,   -1,   -1,
   -1,   -1,  275,   -1,   -1,   -1,  271,   -1,  284,   -1,
   -1,   -1,   -1,   -1,   -1,  288,   -1,  290,   -1,  284,
   -1,   -1,   -1,   91,   -1,   93,   -1,  300,   -1,  305,
   -1,   -1,   -1,  306,   -1,   -1,   -1,  310,   -1,   -1,
   -1,   -1,  318,  316,   -1,   -1,  319,   -1,   -1,  325,
   -1,   -1,   -1,  318,   -1,   -1,  329,  333,   -1,   -1,
  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,
   -1,   -1,   -1,   -1,  350,   -1,  352,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  350,  362,  352,  364,  365,
  366,   -1,   -1,   -1,   -1,  371,   -1,  362,   -1,  364,
  365,  366,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  387,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  412,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  417,   -1,   -1,  412,  421,   -1,
   -1,   -1,   -1,  426,  419,   -1,   -1,   -1,   -1,  432,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  450,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,
   -1,  259,   -1,   -1,  262,   -1,  264,  265,   -1,   -1,
  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  277,
   -1,  279,  280,  281,  282,   -1,  284,   -1,   -1,  287,
   -1,   -1,  290,   -1,   -1,   -1,   -1,   -1,   -1,  297,
   -1,  299,  300,  506,  302,  303,  304,  305,  306,   -1,
   -1,  309,   -1,   -1,  312,   -1,  314,  315,   -1,   -1,
  318,  319,  320,   -1,  322,  323,  324,  325,  326,  327,
  328,   -1,   -1,   -1,  332,  333,  334,  335,  336,   -1,
   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  552,
  348,  349,  350,  351,  352,  353,   -1,   -1,   -1,  357,
  358,   -1,  360,   -1,  362,   -1,  364,  365,  366,   -1,
  368,   -1,  370,  371,  372,   -1,  374,  375,  376,  377,
  378,   -1,  380,  381,   -1,   -1,   -1,   -1,  386,   -1,
  388,  389,  598,  596,  392,  393,  394,   -1,   -1,  397,
   -1,  399,   -1,  598,  402,  403,  404,  405,   -1,  407,
   -1,  409,  615,  411,  412,  413,  414,  415,   -1,   -1,
  418,  419,  420,   -1,  422,  423,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  433,  434,  435,   -1,  437,
  438,  439,   -1,  441,   -1,   -1,   -1,  445,   -1,  447,
  448,  449,  450,   -1,  452,   -1,  454,  455,  456,  457,
  458,  459,  460,  461,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  471,  472,   -1,  474,  475,  476,   -1,
   -1,   -1,   -1,  481,  482,  483,  484,  485,   -1,  487,
   -1,   -1,  490,  491,   -1,   -1,   -1,  495,  496,   -1,
   -1,  499,  500,  501,  502,  503,  504,  505,  506,  507,
   -1,  509,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  519,  520,  521,  522,  523,  524,  525,  526,  527,
  528,  529,  530,  531,  532,  533,  534,  535,  536,  537,
  538,  539,   -1,  541,  542,  543,  544,  545,  546,   -1,
  548,  549,  550,  551,   -1,  553,   -1,  555,  556,  557,
  558,  559,  560,  561,  562,  563,  564,  565,  566,  567,
  568,  569,  570,  571,  572,   -1,  574,  575,  576,  577,
   -1,  579,  580,  581,  582,  583,   -1,  585,  586,  587,
  588,  589,  590,  591,  592,  593,  594,  595,  596,  597,
  598,  599,  600,  601,  602,  603,  604,  605,  606,  607,
  608,  609,  610,  611,  612,  613,    0,  615,  616,  617,
  618,   -1,  620,  621,  622,  623,  624,  625,   -1,   -1,
  628,  629,  630,  631,  632,  633,  634,  635,  636,   -1,
   -1,   -1,   -1,   -1,  642,   -1,  644,  645,  646,  647,
  648,  649,   -1,  651,   -1,   -1,   -1,   41,   42,   43,
   44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   58,   59,   60,   61,   62,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  275,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,  290,   93,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  300,   -1,
   -1,   -1,   -1,   -1,  306,   -1,   -1,   -1,  310,  311,
   -1,   -1,   -1,   -1,  316,   -1,   -1,  319,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  329,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  379,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  387,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  417,   -1,   -1,   -1,  421,
   -1,   -1,   -1,   -1,  426,   -1,   -1,   -1,   -1,   -1,
  432,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  450,  451,
   -1,   -1,   -1,  257,   -1,  259,   -1,   -1,  262,   -1,
  264,  265,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,
   -1,   -1,   -1,  277,   -1,  279,  280,  281,  282,   -1,
  284,   -1,   -1,  287,   -1,   -1,  290,   -1,   -1,   -1,
   -1,   -1,   -1,  297,   -1,  299,  300,   -1,  302,  303,
  304,  305,  306,   -1,  506,  309,   -1,  509,  312,   -1,
  314,  315,   -1,   -1,  318,  319,  320,   -1,  322,  323,
  324,  325,  326,  327,  328,   -1,   -1,   -1,  332,  333,
  334,  335,  336,   -1,   -1,   -1,  340,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  348,  349,  350,  351,  352,  353,
   -1,   -1,   -1,  357,  358,   -1,  360,   -1,  362,   -1,
  364,  365,  366,   -1,  368,   -1,  370,  371,  372,   -1,
  374,  375,  376,  377,  378,   -1,  380,  381,   -1,   -1,
   -1,   -1,  386,   -1,  388,  389,   -1,   -1,  392,  393,
  394,   -1,   -1,  397,   -1,  399,   -1,   -1,  402,  403,
  404,  405,   -1,  407,   -1,  409,   -1,  411,  412,  413,
  414,  415,   -1,  615,  418,  419,  420,   -1,  422,  423,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,
  434,  435,   -1,  437,  438,  439,   -1,  441,   -1,   -1,
   -1,  445,   -1,  447,  448,  449,  450,   -1,  452,   -1,
  454,  455,  456,  457,  458,  459,  460,  461,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  471,  472,   -1,
  474,  475,  476,   -1,   -1,   -1,   -1,  481,  482,  483,
  484,  485,   -1,  487,   -1,   -1,  490,  491,   -1,   -1,
   -1,  495,  496,   -1,   -1,  499,  500,  501,  502,  503,
  504,  505,  506,  507,   -1,  509,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  519,  520,  521,  522,  523,
  524,  525,  526,  527,  528,  529,  530,  531,  532,  533,
  534,  535,  536,  537,  538,  539,   -1, 