#include <sal/types.h>


#include <rtl/ustring.hxx>


extern "C" {

static constexpr OUStringLiteral langID = u"\x0061\x006d";
static constexpr OUStringLiteral langDefaultName = u"\x0041\x006d\x0068\x0061\x0072\x0069\x0063";
static constexpr OUStringLiteral countryID = u"\x0045\x0054";
static constexpr OUStringLiteral countryDefaultName = u"\x0045\x0074\x0068\x0069\x006f\x0070\x0069\x0061";
static constexpr OUStringLiteral Variant = u"";

static constexpr OUString LCInfoArray[] = {
	langID,
	langDefaultName,
	countryID,
	countryDefaultName,
	Variant
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLCInfo_am_ET(sal_Int16& count)
{
	count = std::size(LCInfoArray);
	return (OUString const *)LCInfoArray;
}


static constexpr OUStringLiteral LC_CTYPE_Unoid = u"\x0067\x0065\x006e\x0065\x0072\x0069\x0063";
static constexpr OUStringLiteral dateSeparator = u"\x002f";
static constexpr OUStringLiteral thousandSeparator = u"\x002c";
static constexpr OUStringLiteral decimalSeparator = u"\x002e";
static constexpr OUStringLiteral decimalSeparatorAlternative = u"";
static constexpr OUStringLiteral timeSeparator = u"\x003a";
static constexpr OUStringLiteral time100SecSeparator = u"\x002e";
static constexpr OUStringLiteral listSeparator = u"\x003b";
static constexpr OUStringLiteral LongDateDayOfWeekSeparator = u"\x0020";
static constexpr OUStringLiteral LongDateDaySeparator = u"\x0020";
static constexpr OUStringLiteral LongDateMonthSeparator = u"\x0020";
static constexpr OUStringLiteral LongDateYearSeparator = u"\x0020";
static constexpr OUStringLiteral quotationStart = u"\x2018";
static constexpr OUStringLiteral quotationEnd = u"\x2019";
static constexpr OUStringLiteral doubleQuotationStart = u"\x201c";
static constexpr OUStringLiteral doubleQuotationEnd = u"\x201d";
static constexpr OUStringLiteral timeAM = u"\x1321\x12cb\x1275";
static constexpr OUStringLiteral timePM = u"\x12a8\x1230\x12d3\x1275";
static constexpr OUStringLiteral measurementSystem = u"\x004d\x0065\x0074\x0072\x0069\x0063";

static constexpr OUString LCType[] = {
	LC_CTYPE_Unoid,
	dateSeparator,
	thousandSeparator,
	decimalSeparator,
	timeSeparator,
	time100SecSeparator,
	listSeparator,
	quotationStart,
	quotationEnd,
	doubleQuotationStart,
	doubleQuotationEnd,
	timeAM,
	timePM,
	measurementSystem,
	LongDateDayOfWeekSeparator,
	LongDateDaySeparator,
	LongDateMonthSeparator,
	LongDateYearSeparator,
	decimalSeparatorAlternative
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLocaleItem_am_ET(sal_Int16& count)
{
	count = std::size(LCType);
	return (OUString const *)LCType;
}
static const sal_Unicode replaceTo0[] = {0x5b, 0x24, 0x45, 0x54, 0x42, 0x2d, 0x34, 0x35, 0x45, 0x5d, 0x0};
extern OUString const * getAllFormats0_en_GB(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to);
SAL_DLLPUBLIC_EXPORT OUString const * getAllFormats0_am_ET(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to)
{
	to = replaceTo0;
	const sal_Unicode* tmp;
	return getAllFormats0_en_GB(count, from, tmp);
}
extern const OUString *  getDateAcceptancePatterns_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getDateAcceptancePatterns_am_ET(sal_Int16& count)
{
	return getDateAcceptancePatterns_en_GB(count);
}
extern const OUString *  getCollatorImplementation_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollatorImplementation_am_ET(sal_Int16& count)
{
	return getCollatorImplementation_en_US(count);
}
extern const OUString *  getCollationOptions_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollationOptions_am_ET(sal_Int16& count)
{
	return getCollationOptions_en_US(count);
}
extern const OUString *  getSearchOptions_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getSearchOptions_am_ET(sal_Int16& count)
{
	return getSearchOptions_en_US(count);
}
static constexpr OUStringLiteral IndexID0 = u"\x0061\x006c\x0070\x0068\x0061\x006e\x0075\x006d\x0065\x0072\x0069\x0063";
static constexpr OUStringLiteral IndexModule0 = u"";
static constexpr OUStringLiteral IndexKey0 = u"\x0041\x002d\x005a";
static constexpr OUStringLiteral defaultIndex0 = u"\x1";
static constexpr OUStringLiteral defaultPhonetic0 = u"\x0";

static constexpr OUStringLiteral unicodeScript0 = u"\x0033\x0030";
static constexpr OUStringLiteral followPageWord0 = u"\x1308\x12fd";
static constexpr OUStringLiteral followPageWord1 = u"\x1308\x12fe\x127d";
static const sal_Int16 nbOfIndexs = 1;


static constexpr OUString IndexArray[] = {
	IndexID0,
	IndexModule0,
	IndexKey0,
	defaultIndex0,
	defaultPhonetic0,
};

static const sal_Int16 nbOfUnicodeScripts = 1;

static constexpr OUString UnicodeScriptArray[] = {unicodeScript0 };

static const sal_Int16 nbOfPageWords = 2;

static constexpr OUString FollowPageWordArray[] = {
	followPageWord0,
	followPageWord1	
};

SAL_DLLPUBLIC_EXPORT OUString const *  getIndexAlgorithm_am_ET(sal_Int16& count)
{
	count = nbOfIndexs;
	return (OUString const *)IndexArray;
}
SAL_DLLPUBLIC_EXPORT OUString const *  getUnicodeScripts_am_ET(sal_Int16& count)
{
	count = nbOfUnicodeScripts;
	return (OUString const *)UnicodeScriptArray;
}
SAL_DLLPUBLIC_EXPORT OUString const *  getFollowPageWords_am_ET(sal_Int16& count)
{
	count = nbOfPageWords;
	return (OUString const *)FollowPageWordArray;
}
static constexpr OUStringLiteral calendarID0 = u"\x0067\x0072\x0065\x0067\x006f\x0072\x0069\x0061\x006e";
static constexpr OUStringLiteral defaultCalendar0 = u"\x1";
static constexpr OUStringLiteral dayID00 = u"\x0073\x0075\x006e";
static constexpr OUStringLiteral dayDefaultAbbrvName00 = u"\x12a5\x1211\x12f5";
static constexpr OUStringLiteral dayDefaultFullName00 = u"\x12a5\x1211\x12f5";
static constexpr OUStringLiteral dayDefaultNarrowName00 = u"\x12a5";
static constexpr OUStringLiteral dayID01 = u"\x006d\x006f\x006e";
static constexpr OUStringLiteral dayDefaultAbbrvName01 = u"\x1230\x129e";
static constexpr OUStringLiteral dayDefaultFullName01 = u"\x1230\x129e";
static constexpr OUStringLiteral dayDefaultNarrowName01 = u"\x1230";
static constexpr OUStringLiteral dayID02 = u"\x0074\x0075\x0065";
static constexpr OUStringLiteral dayDefaultAbbrvName02 = u"\x121b\x12ad\x1230\x129e";
static constexpr OUStringLiteral dayDefaultFullName02 = u"\x121b\x12ad\x1230\x129e";
static constexpr OUStringLiteral dayDefaultNarrowName02 = u"\x121b";
static constexpr OUStringLiteral dayID03 = u"\x0077\x0065\x0064";
static constexpr OUStringLiteral dayDefaultAbbrvName03 = u"\x1228\x1261\x12d5";
static constexpr OUStringLiteral dayDefaultFullName03 = u"\x1228\x1261\x12d5";
static constexpr OUStringLiteral dayDefaultNarrowName03 = u"\x1228";
static constexpr OUStringLiteral dayID04 = u"\x0074\x0068\x0075";
static constexpr OUStringLiteral dayDefaultAbbrvName04 = u"\x1210\x1219\x1235";
static constexpr OUStringLiteral dayDefaultFullName04 = u"\x1210\x1219\x1235";
static constexpr OUStringLiteral dayDefaultNarrowName04 = u"\x1210";
static constexpr OUStringLiteral dayID05 = u"\x0066\x0072\x0069";
static constexpr OUStringLiteral dayDefaultAbbrvName05 = u"\x12d3\x122d\x1265";
static constexpr OUStringLiteral dayDefaultFullName05 = u"\x12d3\x122d\x1265";
static constexpr OUStringLiteral dayDefaultNarrowName05 = u"\x12d3";
static constexpr OUStringLiteral dayID06 = u"\x0073\x0061\x0074";
static constexpr OUStringLiteral dayDefaultAbbrvName06 = u"\x1245\x12f3\x121c";
static constexpr OUStringLiteral dayDefaultFullName06 = u"\x1245\x12f3\x121c";
static constexpr OUStringLiteral dayDefaultNarrowName06 = u"\x1245";
static constexpr OUStringLiteral monthID00 = u"\x006a\x0061\x006e";
static constexpr OUStringLiteral monthDefaultAbbrvName00 = u"\x1303\x1295\x12e9";
static constexpr OUStringLiteral monthDefaultFullName00 = u"\x1303\x1295\x12e9\x12c8\x122a";
static constexpr OUStringLiteral monthDefaultNarrowName00 = u"\x1303";
static constexpr OUStringLiteral monthID01 = u"\x0066\x0065\x0062";
static constexpr OUStringLiteral monthDefaultAbbrvName01 = u"\x134c\x1265\x1229";
static constexpr OUStringLiteral monthDefaultFullName01 = u"\x134c\x1265\x1229\x12c8\x122a";
static constexpr OUStringLiteral monthDefaultNarrowName01 = u"\x134c";
static constexpr OUStringLiteral monthID02 = u"\x006d\x0061\x0072";
static constexpr OUStringLiteral monthDefaultAbbrvName02 = u"\x121b\x122d\x127d";
static constexpr OUStringLiteral monthDefaultFullName02 = u"\x121b\x122d\x127d";
static constexpr OUStringLiteral monthDefaultNarrowName02 = u"\x121b";
static constexpr OUStringLiteral monthID03 = u"\x0061\x0070\x0072";
static constexpr OUStringLiteral monthDefaultAbbrvName03 = u"\x12a4\x1355\x1228";
static constexpr OUStringLiteral monthDefaultFullName03 = u"\x12a4\x1355\x1228\x120d";
static constexpr OUStringLiteral monthDefaultNarrowName03 = u"\x12a4";
static constexpr OUStringLiteral monthID04 = u"\x006d\x0061\x0079";
static constexpr OUStringLiteral monthDefaultAbbrvName04 = u"\x121c\x12ed";
static constexpr OUStringLiteral monthDefaultFullName04 = u"\x121c\x12ed";
static constexpr OUStringLiteral monthDefaultNarrowName04 = u"\x121c";
static constexpr OUStringLiteral monthID05 = u"\x006a\x0075\x006e";
static constexpr OUStringLiteral monthDefaultAbbrvName05 = u"\x1301\x1295";
static constexpr OUStringLiteral monthDefaultFullName05 = u"\x1301\x1295";
static constexpr OUStringLiteral monthDefaultNarrowName05 = u"\x1301";
static constexpr OUStringLiteral monthID06 = u"\x006a\x0075\x006c";
static constexpr OUStringLiteral monthDefaultAbbrvName06 = u"\x1301\x120b\x12ed";
static constexpr OUStringLiteral monthDefaultFullName06 = u"\x1301\x120b\x12ed";
static constexpr OUStringLiteral monthDefaultNarrowName06 = u"\x1301";
static constexpr OUStringLiteral monthID07 = u"\x0061\x0075\x0067";
static constexpr OUStringLiteral monthDefaultAbbrvName07 = u"\x12a6\x1308\x1235";
static constexpr OUStringLiteral monthDefaultFullName07 = u"\x12a6\x1308\x1235\x1275";
static constexpr OUStringLiteral monthDefaultNarrowName07 = u"\x12a6";
static constexpr OUStringLiteral monthID08 = u"\x0073\x0065\x0070";
static constexpr OUStringLiteral monthDefaultAbbrvName08 = u"\x1234\x1355\x1274";
static constexpr OUStringLiteral monthDefaultFullName08 = u"\x1234\x1355\x1274\x121d\x1260\x122d";
static constexpr OUStringLiteral monthDefaultNarrowName08 = u"\x1234";
static constexpr OUStringLiteral monthID09 = u"\x006f\x0063\x0074";
static constexpr OUStringLiteral monthDefaultAbbrvName09 = u"\x12a6\x12ad\x1270";
static constexpr OUStringLiteral monthDefaultFullName09 = u"\x12a6\x12ad\x1270\x12cd\x1260\x122d";
static constexpr OUStringLiteral monthDefaultNarrowName09 = u"\x12a6";
static constexpr OUStringLiteral monthID010 = u"\x006e\x006f\x0076";
static constexpr OUStringLiteral monthDefaultAbbrvName010 = u"\x1296\x126c\x121d";
static constexpr OUStringLiteral monthDefaultFullName010 = u"\x1296\x126c\x121d\x1260\x122d";
static constexpr OUStringLiteral monthDefaultNarrowName010 = u"\x1296";
static constexpr OUStringLiteral monthID011 = u"\x0064\x0065\x0063";
static constexpr OUStringLiteral monthDefaultAbbrvName011 = u"\x12f2\x1234\x121d";
static constexpr OUStringLiteral monthDefaultFullName011 = u"\x12f2\x1234\x121d\x1260\x122d";
static constexpr OUStringLiteral monthDefaultNarrowName011 = u"\x12f2";
static constexpr OUStringLiteral genitiveMonthID00 = u"\x006a\x0061\x006e";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName00 = u"\x1303\x1295\x12e9";
static constexpr OUStringLiteral genitiveMonthDefaultFullName00 = u"\x1303\x1295\x12e9\x12c8\x122a";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName00 = u"\x1303";
static constexpr OUStringLiteral genitiveMonthID01 = u"\x0066\x0065\x0062";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName01 = u"\x134c\x1265\x1229";
static constexpr OUStringLiteral genitiveMonthDefaultFullName01 = u"\x134c\x1265\x1229\x12c8\x122a";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName01 = u"\x134c";
static constexpr OUStringLiteral genitiveMonthID02 = u"\x006d\x0061\x0072";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName02 = u"\x121b\x122d\x127d";
static constexpr OUStringLiteral genitiveMonthDefaultFullName02 = u"\x121b\x122d\x127d";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName02 = u"\x121b";
static constexpr OUStringLiteral genitiveMonthID03 = u"\x0061\x0070\x0072";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName03 = u"\x12a4\x1355\x1228";
static constexpr OUStringLiteral genitiveMonthDefaultFullName03 = u"\x12a4\x1355\x1228\x120d";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName03 = u"\x12a4";
static constexpr OUStringLiteral genitiveMonthID04 = u"\x006d\x0061\x0079";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName04 = u"\x121c\x12ed";
static constexpr OUStringLiteral genitiveMonthDefaultFullName04 = u"\x121c\x12ed";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName04 = u"\x121c";
static constexpr OUStringLiteral genitiveMonthID05 = u"\x006a\x0075\x006e";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName05 = u"\x1301\x1295";
static constexpr OUStringLiteral genitiveMonthDefaultFullName05 = u"\x1301\x1295";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName05 = u"\x1301";
static constexpr OUStringLiteral genitiveMonthID06 = u"\x006a\x0075\x006c";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName06 = u"\x1301\x120b\x12ed";
static constexpr OUStringLiteral genitiveMonthDefaultFullName06 = u"\x1301\x120b\x12ed";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName06 = u"\x1301";
static constexpr OUStringLiteral genitiveMonthID07 = u"\x0061\x0075\x0067";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName07 = u"\x12a6\x1308\x1235";
static constexpr OUStringLiteral genitiveMonthDefaultFullName07 = u"\x12a6\x1308\x1235\x1275";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName07 = u"\x12a6";
static constexpr OUStringLiteral genitiveMonthID08 = u"\x0073\x0065\x0070";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName08 = u"\x1234\x1355\x1274";
static constexpr OUStringLiteral genitiveMonthDefaultFullName08 = u"\x1234\x1355\x1274\x121d\x1260\x122d";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName08 = u"\x1234";
static constexpr OUStringLiteral genitiveMonthID09 = u"\x006f\x0063\x0074";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName09 = u"\x12a6\x12ad\x1270";
static constexpr OUStringLiteral genitiveMonthDefaultFullName09 = u"\x12a6\x12ad\x1270\x12cd\x1260\x122d";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName09 = u"\x12a6";
static constexpr OUStringLiteral genitiveMonthID010 = u"\x006e\x006f\x0076";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName010 = u"\x1296\x126c\x121d";
static constexpr OUStringLiteral genitiveMonthDefaultFullName010 = u"\x1296\x126c\x121d\x1260\x122d";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName010 = u"\x1296";
static constexpr OUStringLiteral genitiveMonthID011 = u"\x0064\x0065\x0063";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName011 = u"\x12f2\x1234\x121d";
static constexpr OUStringLiteral genitiveMonthDefaultFullName011 = u"\x12f2\x1234\x121d\x1260\x122d";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName011 = u"\x12f2";
static constexpr OUStringLiteral partitiveMonthID00 = u"\x006a\x0061\x006e";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName00 = u"\x1303\x1295\x12e9";
static constexpr OUStringLiteral partitiveMonthDefaultFullName00 = u"\x1303\x1295\x12e9\x12c8\x122a";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName00 = u"\x1303";
static constexpr OUStringLiteral partitiveMonthID01 = u"\x0066\x0065\x0062";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName01 = u"\x134c\x1265\x1229";
static constexpr OUStringLiteral partitiveMonthDefaultFullName01 = u"\x134c\x1265\x1229\x12c8\x122a";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName01 = u"\x134c";
static constexpr OUStringLiteral partitiveMonthID02 = u"\x006d\x0061\x0072";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName02 = u"\x121b\x122d\x127d";
static constexpr OUStringLiteral partitiveMonthDefaultFullName02 = u"\x121b\x122d\x127d";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName02 = u"\x121b";
static constexpr OUStringLiteral partitiveMonthID03 = u"\x0061\x0070\x0072";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName03 = u"\x12a4\x1355\x1228";
static constexpr OUStringLiteral partitiveMonthDefaultFullName03 = u"\x12a4\x1355\x1228\x120d";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName03 = u"\x12a4";
static constexpr OUStringLiteral partitiveMonthID04 = u"\x006d\x0061\x0079";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName04 = u"\x121c\x12ed";
static constexpr OUStringLiteral partitiveMonthDefaultFullName04 = u"\x121c\x12ed";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName04 = u"\x121c";
static constexpr OUStringLiteral partitiveMonthID05 = u"\x006a\x0075\x006e";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName05 = u"\x1301\x1295";
static constexpr OUStringLiteral partitiveMonthDefaultFullName05 = u"\x1301\x1295";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName05 = u"\x1301";
static constexpr OUStringLiteral partitiveMonthID06 = u"\x006a\x0075\x006c";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName06 = u"\x1301\x120b\x12ed";
static constexpr OUStringLiteral partitiveMonthDefaultFullName06 = u"\x1301\x120b\x12ed";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName06 = u"\x1301";
static constexpr OUStringLiteral partitiveMonthID07 = u"\x0061\x0075\x0067";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName07 = u"\x12a6\x1308\x1235";
static constexpr OUStringLiteral partitiveMonthDefaultFullName07 = u"\x12a6\x1308\x1235\x1275";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName07 = u"\x12a6";
static constexpr OUStringLiteral partitiveMonthID08 = u"\x0073\x0065\x0070";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName08 = u"\x1234\x1355\x1274";
static constexpr OUStringLiteral partitiveMonthDefaultFullName08 = u"\x1234\x1355\x1274\x121d\x1260\x122d";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName08 = u"\x1234";
static constexpr OUStringLiteral partitiveMonthID09 = u"\x006f\x0063\x0074";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName09 = u"\x12a6\x12ad\x1270";
static constexpr OUStringLiteral partitiveMonthDefaultFullName09 = u"\x12a6\x12ad\x1270\x12cd\x1260\x122d";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName09 = u"\x12a6";
static constexpr OUStringLiteral partitiveMonthID010 = u"\x006e\x006f\x0076";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName010 = u"\x1296\x126c\x121d";
static constexpr OUStringLiteral partitiveMonthDefaultFullName010 = u"\x1296\x126c\x121d\x1260\x122d";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName010 = u"\x1296";
static constexpr OUStringLiteral partitiveMonthID011 = u"\x0064\x0065\x0063";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName011 = u"\x12f2\x1234\x121d";
static constexpr OUStringLiteral partitiveMonthDefaultFullName011 = u"\x12f2\x1234\x121d\x1260\x122d";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName011 = u"\x12f2";
static constexpr OUStringLiteral eraID00 = u"\x0062\x0063";

static constexpr OUStringLiteral eraDefaultAbbrvName00 = u"\x12a0\x002e\x12a0\x1208\x121d";
static constexpr OUStringLiteral eraDefaultFullName00 = u"\x12a8\x12ad\x122d\x1235\x1276\x1235\x0020\x120d\x12f0\x1275\x0020\x1260\x134a\x1275";
static constexpr OUStringLiteral eraID01 = u"\x0061\x0064";

static constexpr OUStringLiteral eraDefaultAbbrvName01 = u"\x12a0\x002e\x121d";
static constexpr OUStringLiteral eraDefaultFullName01 = u"\x12a0\x1218\x1270\x0020\x121d\x1205\x1228\x1275";
static constexpr OUStringLiteral startDayOfWeek0 = u"\x0073\x0075\x006e";
static constexpr OUStringLiteral minimalDaysInFirstWeek0 = u"\x1";
static const sal_Int16 calendarsCount = 1;

static constexpr OUStringLiteral nbOfDays = u"\x7";
static constexpr OUStringLiteral nbOfMonths = u"\xc";
static constexpr OUStringLiteral nbOfGenitiveMonths = u"\xc";
static constexpr OUStringLiteral nbOfPartitiveMonths = u"\xc";
static constexpr OUStringLiteral nbOfEras = u"\x2";
static constexpr OUString calendars[] = {
	nbOfDays,
	nbOfMonths,
	nbOfGenitiveMonths,
	nbOfPartitiveMonths,
	nbOfEras,
	calendarID0,
	defaultCalendar0,
	dayID00,
	dayDefaultAbbrvName00,
	dayDefaultFullName00,
	dayDefaultNarrowName00,
	dayID01,
	dayDefaultAbbrvName01,
	dayDefaultFullName01,
	dayDefaultNarrowName01,
	dayID02,
	dayDefaultAbbrvName02,
	dayDefaultFullName02,
	dayDefaultNarrowName02,
	dayID03,
	dayDefaultAbbrvName03,
	dayDefaultFullName03,
	dayDefaultNarrowName03,
	dayID04,
	dayDefaultAbbrvName04,
	dayDefaultFullName04,
	dayDefaultNarrowName04,
	dayID05,
	dayDefaultAbbrvName05,
	dayDefaultFullName05,
	dayDefaultNarrowName05,
	dayID06,
	dayDefaultAbbrvName06,
	dayDefaultFullName06,
	dayDefaultNarrowName06,
	monthID00,
	monthDefaultAbbrvName00,
	monthDefaultFullName00,
	monthDefaultNarrowName00,
	monthID01,
	monthDefaultAbbrvName01,
	monthDefaultFullName01,
	monthDefaultNarrowName01,
	monthID02,
	monthDefaultAbbrvName02,
	monthDefaultFullName02,
	monthDefaultNarrowName02,
	monthID03,
	monthDefaultAbbrvName03,
	monthDefaultFullName03,
	monthDefaultNarrowName03,
	monthID04,
	monthDefaultAbbrvName04,
	monthDefaultFullName04,
	monthDefaultNarrowName04,
	monthID05,
	monthDefaultAbbrvName05,
	monthDefaultFullName05,
	monthDefaultNarrowName05,
	monthID06,
	monthDefaultAbbrvName06,
	monthDefaultFullName06,
	monthDefaultNarrowName06,
	monthID07,
	monthDefaultAbbrvName07,
	monthDefaultFullName07,
	monthDefaultNarrowName07,
	monthID08,
	monthDefaultAbbrvName08,
	monthDefaultFullName08,
	monthDefaultNarrowName08,
	monthID09,
	monthDefaultAbbrvName09,
	monthDefaultFullName09,
	monthDefaultNarrowName09,
	monthID010,
	monthDefaultAbbrvName010,
	monthDefaultFullName010,
	monthDefaultNarrowName010,
	monthID011,
	monthDefaultAbbrvName011,
	monthDefaultFullName011,
	monthDefaultNarrowName011,
	genitiveMonthID00,
	genitiveMonthDefaultAbbrvName00,
	genitiveMonthDefaultFullName00,
	genitiveMonthDefaultNarrowName00,
	genitiveMonthID01,
	genitiveMonthDefaultAbbrvName01,
	genitiveMonthDefaultFullName01,
	genitiveMonthDefaultNarrowName01,
	genitiveMonthID02,
	genitiveMonthDefaultAbbrvName02,
	genitiveMonthDefaultFullName02,
	genitiveMonthDefaultNarrowName02,
	genitiveMonthID03,
	genitiveMonthDefaultAbbrvName03,
	genitiveMonthDefaultFullName03,
	genitiveMonthDefaultNarrowName03,
	genitiveMonthID04,
	genitiveMonthDefaultAbbrvName04,
	genitiveMonthDefaultFullName04,
	genitiveMonthDefaultNarrowName04,
	genitiveMonthID05,
	genitiveMonthDefaultAbbrvName05,
	genitiveMonthDefaultFullName05,
	genitiveMonthDefaultNarrowName05,
	genitiveMonthID06,
	genitiveMonthDefaultAbbrvName06,
	genitiveMonthDefaultFullName06,
	genitiveMonthDefaultNarrowName06,
	genitiveMonthID07,
	genitiveMonthDefaultAbbrvName07,
	genitiveMonthDefaultFullName07,
	genitiveMonthDefaultNarrowName07,
	genitiveMonthID08,
	genitiveMonthDefaultAbbrvName08,
	genitiveMonthDefaultFullName08,
	genitiveMonthDefaultNarrowName08,
	genitiveMonthID09,
	genitiveMonthDefaultAbbrvName09,
	genitiveMonthDefaultFullName09,
	genitiveMonthDefaultNarrowName09,
	genitiveMonthID010,
	genitiveMonthDefaultAbbrvName010,
	genitiveMonthDefaultFullName010,
	genitiveMonthDefaultNarrowName010,
	genitiveMonthID011,
	genitiveMonthDefaultAbbrvName011,
	genitiveMonthDefaultFullName011,
	genitiveMonthDefaultNarrowName011,
	partitiveMonthID00,
	partitiveMonthDefaultAbbrvName00,
	partitiveMonthDefaultFullName00,
	partitiveMonthDefaultNarrowName00,
	partitiveMonthID01,
	partitiveMonthDefaultAbbrvName01,
	partitiveMonthDefaultFullName01,
	partitiveMonthDefaultNarrowName01,
	partitiveMonthID02,
	partitiveMonthDefaultAbbrvName02,
	partitiveMonthDefaultFullName02,
	partitiveMonthDefaultNarrowName02,
	partitiveMonthID03,
	partitiveMonthDefaultAbbrvName03,
	partitiveMonthDefaultFullName03,
	partitiveMonthDefaultNarrowName03,
	partitiveMonthID04,
	partitiveMonthDefaultAbbrvName04,
	partitiveMonthDefaultFullName04,
	partitiveMonthDefaultNarrowName04,
	partitiveMonthID05,
	partitiveMonthDefaultAbbrvName05,
	partitiveMonthDefaultFullName05,
	partitiveMonthDefaultNarrowName05,
	partitiveMonthID06,
	partitiveMonthDefaultAbbrvName06,
	partitiveMonthDefaultFullName06,
	partitiveMonthDefaultNarrowName06,
	partitiveMonthID07,
	partitiveMonthDefaultAbbrvName07,
	partitiveMonthDefaultFullName07,
	partitiveMonthDefaultNarrowName07,
	partitiveMonthID08,
	partitiveMonthDefaultAbbrvName08,
	partitiveMonthDefaultFullName08,
	partitiveMonthDefaultNarrowName08,
	partitiveMonthID09,
	partitiveMonthDefaultAbbrvName09,
	partitiveMonthDefaultFullName09,
	partitiveMonthDefaultNarrowName09,
	partitiveMonthID010,
	partitiveMonthDefaultAbbrvName010,
	partitiveMonthDefaultFullName010,
	partitiveMonthDefaultNarrowName010,
	partitiveMonthID011,
	partitiveMonthDefaultAbbrvName011,
	partitiveMonthDefaultFullName011,
	partitiveMonthDefaultNarrowName011,
	eraID00,
	eraDefaultAbbrvName00,
	eraDefaultFullName00,
	eraID01,
	eraDefaultAbbrvName01,
	eraDefaultFullName01,
	startDayOfWeek0,
	minimalDaysInFirstWeek0,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCalendars_am_ET(sal_Int16& count)
{
	count = calendarsCount;
	return (OUString const *)calendars;
}
static constexpr OUStringLiteral defaultCurrency0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyUsedInCompatibleFormatCodes0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyLegacyOnly0 = u"\x0";
static constexpr OUStringLiteral currencyID0 = u"\x0045\x0054\x0042";
static constexpr OUStringLiteral currencySymbol0 = u"\x0045\x0054\x0042";
static constexpr OUStringLiteral bankSymbol0 = u"\x0045\x0054\x0042";
static constexpr OUStringLiteral currencyName0 = u"\x0045\x0074\x0068\x0069\x006f\x0070\x0069\x0061\x006e\x0020\x0042\x0069\x0072\x0072";
static constexpr OUStringLiteral currencyDecimalPlaces0 = u"\x2";

static const sal_Int16 currencyCount = 1;

static constexpr OUString currencies[] = {
	currencyID0,
	currencySymbol0,
	bankSymbol0,
	currencyName0,
	defaultCurrency0,
	defaultCurrencyUsedInCompatibleFormatCodes0,
	currencyDecimalPlaces0,
	defaultCurrencyLegacyOnly0,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCurrencies_am_ET(sal_Int16& count)
{
	count = currencyCount;
	return (OUString const *)currencies;
}
extern const OUString *  getTransliterations_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getTransliterations_am_ET(sal_Int16& count)
{
	return getTransliterations_en_US(count);
}
static constexpr OUStringLiteral ReservedWord0 = u"\x12a0\x12cd\x1290\x1275";
static constexpr OUStringLiteral ReservedWord1 = u"\x1214\x1230\x1275";
static constexpr OUStringLiteral ReservedWord2 = u"\x12ad\x134d\x120d\x0020\x12a0\x1295\x12f5";
static constexpr OUStringLiteral ReservedWord3 = u"\x12ad\x134d\x120d\x0020\x1201\x1208\x1275";
static constexpr OUStringLiteral ReservedWord4 = u"\x12ad\x134d\x120d\x0020\x1236\x1235\x1275";
static constexpr OUStringLiteral ReservedWord5 = u"\x12ad\x134d\x120d\x0020\x12a0\x122b\x1275";
static constexpr OUStringLiteral ReservedWord6 = u"\x1260\x120b\x12ed";
static constexpr OUStringLiteral ReservedWord7 = u"\x1260\x1273\x127d";
static constexpr OUStringLiteral ReservedWord8 = u"\x12ad\x12a0";
static constexpr OUStringLiteral ReservedWord9 = u"\x12ad\x1201";
static constexpr OUStringLiteral ReservedWord10 = u"\x12ad\x1236";
static constexpr OUStringLiteral ReservedWord11 = u"\x12ad\x12a0";
static const sal_Int16 nbOfReservedWords = 12;


static constexpr OUString LCReservedWordsArray[] = {
	ReservedWord0,
	ReservedWord1,
	ReservedWord2,
	ReservedWord3,
	ReservedWord4,
	ReservedWord5,
	ReservedWord6,
	ReservedWord7,
	ReservedWord8,
	ReservedWord9,
	ReservedWord10,
	ReservedWord11,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getReservedWords_am_ET(sal_Int16& count)
{
	count = nbOfReservedWords;
	return (OUString const *)LCReservedWordsArray;
}
static constexpr OUStringLiteral forbiddenBegin = u"";
static constexpr OUStringLiteral forbiddenEnd = u"";
static constexpr OUStringLiteral hangingChars = u"";

static constexpr OUString LCForbiddenCharactersArray[] = {
	forbiddenBegin,
	forbiddenEnd,
	hangingChars
};

SAL_DLLPUBLIC_EXPORT OUString const *  getForbiddenCharacters_am_ET(sal_Int16& count)
{
	count = 3;
	return (OUString const *)LCForbiddenCharactersArray;
}
static constexpr OUStringLiteral EditMode = u"";
static constexpr OUStringLiteral DictionaryMode = u"";
static constexpr OUStringLiteral WordCountMode = u"";
static constexpr OUStringLiteral CharacterMode = u"";
static constexpr OUStringLiteral LineMode = u"";

static constexpr OUString LCBreakIteratorRulesArray[] = {
	EditMode,
	DictionaryMode,
	WordCountMode,
	CharacterMode,
	LineMode
};

SAL_DLLPUBLIC_EXPORT OUString const *  getBreakIteratorRules_am_ET(sal_Int16& count)
{
	count = 5;
	return (OUString const *)LCBreakIteratorRulesArray;
}
// ---> ContinuousNumbering
extern const OUString **  getContinuousNumberingLevels_en_US(sal_Int16& nStyles, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString **  getContinuousNumberingLevels_am_ET(sal_Int16& nStyles, sal_Int16& nAttributes)
{
	return getContinuousNumberingLevels_en_US(nStyles, nAttributes);
}
// ---> OutlineNumbering
extern const OUString ***  getOutlineNumberingLevels_en_US(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString ***  getOutlineNumberingLevels_am_ET(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes)
{
	return getOutlineNumberingLevels_en_US(nStyles, nLevels, nAttributes);
}
} // extern "C"

