#include <sal/types.h>


#include <rtl/ustring.hxx>


extern "C" {

static constexpr OUStringLiteral langID = u"\x0066\x0072";
static constexpr OUStringLiteral langDefaultName = u"\x0046\x0072\x0065\x006e\x0063\x0068";
static constexpr OUStringLiteral countryID = u"\x0047\x004e";
static constexpr OUStringLiteral countryDefaultName = u"\x0052\x0065\x0070\x0075\x0062\x006c\x0069\x0063\x0020\x006f\x0066\x0020\x0047\x0075\x0069\x006e\x0065\x0061";
static constexpr OUStringLiteral Variant = u"";

static constexpr OUString LCInfoArray[] = {
	langID,
	langDefaultName,
	countryID,
	countryDefaultName,
	Variant
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLCInfo_fr_GN(sal_Int16& count)
{
	count = std::size(LCInfoArray);
	return (OUString const *)LCInfoArray;
}
extern const OUString *  getLocaleItem_fr_BF(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getLocaleItem_fr_GN(sal_Int16& count)
{
	return getLocaleItem_fr_BF(count);
}
static const sal_Unicode replaceTo0[] = {0x5b, 0x24, 0x46, 0x47, 0x2d, 0x39, 0x34, 0x30, 0x43, 0x5d, 0x0};
extern OUString const * getAllFormats0_fr_BF(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to);
SAL_DLLPUBLIC_EXPORT OUString const * getAllFormats0_fr_GN(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to)
{
	to = replaceTo0;
	const sal_Unicode* tmp;
	return getAllFormats0_fr_BF(count, from, tmp);
}
extern const OUString *  getDateAcceptancePatterns_fr_BF(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getDateAcceptancePatterns_fr_GN(sal_Int16& count)
{
	return getDateAcceptancePatterns_fr_BF(count);
}
extern const OUString *  getCollatorImplementation_fr_BF(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollatorImplementation_fr_GN(sal_Int16& count)
{
	return getCollatorImplementation_fr_BF(count);
}
extern const OUString *  getCollationOptions_fr_BF(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollationOptions_fr_GN(sal_Int16& count)
{
	return getCollationOptions_fr_BF(count);
}
extern const OUString *  getSearchOptions_fr_BF(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getSearchOptions_fr_GN(sal_Int16& count)
{
	return getSearchOptions_fr_BF(count);
}
extern const OUString *  getIndexAlgorithm_fr_BF(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getIndexAlgorithm_fr_GN(sal_Int16& count)
{
	return getIndexAlgorithm_fr_BF(count);
}
extern const OUString *  getUnicodeScripts_fr_BF(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getUnicodeScripts_fr_GN(sal_Int16& count)
{
	return getUnicodeScripts_fr_BF(count);
}
extern const OUString *  getFollowPageWords_fr_BF(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getFollowPageWords_fr_GN(sal_Int16& count)
{
	return getFollowPageWords_fr_BF(count);
}
extern const OUString *  getAllCalendars_fr_BF(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getAllCalendars_fr_GN(sal_Int16& count)
{
	return getAllCalendars_fr_BF(count);
}
static constexpr OUStringLiteral defaultCurrency0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyUsedInCompatibleFormatCodes0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyLegacyOnly0 = u"\x0";
static constexpr OUStringLiteral currencyID0 = u"\x0047\x004e\x0046";
static constexpr OUStringLiteral currencySymbol0 = u"\x0046\x0047";
static constexpr OUStringLiteral bankSymbol0 = u"\x0047\x004e\x0046";
static constexpr OUStringLiteral currencyName0 = u"\x0046\x0072\x0061\x006e\x0063\x0020\x0047\x0075\x0069\x006e\x00e9\x0065\x006e";
static constexpr OUStringLiteral currencyDecimalPlaces0 = u"\x2";

static const sal_Int16 currencyCount = 1;

static constexpr OUString currencies[] = {
	currencyID0,
	currencySymbol0,
	bankSymbol0,
	currencyName0,
	defaultCurrency0,
	defaultCurrencyUsedInCompatibleFormatCodes0,
	currencyDecimalPlaces0,
	defaultCurrencyLegacyOnly0,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCurrencies_fr_GN(sal_Int16& count)
{
	count = currencyCount;
	return (OUString const *)currencies;
}
extern const OUString *  getTransliterations_fr_BF(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getTransliterations_fr_GN(sal_Int16& count)
{
	return getTransliterations_fr_BF(count);
}
extern const OUString *  getForbiddenCharacters_fr_BF(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getForbiddenCharacters_fr_GN(sal_Int16& count)
{
	return getForbiddenCharacters_fr_BF(count);
}
extern const OUString *  getBreakIteratorRules_fr_BF(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getBreakIteratorRules_fr_GN(sal_Int16& count)
{
	return getBreakIteratorRules_fr_BF(count);
}
extern const OUString *  getReservedWords_fr_BF(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getReservedWords_fr_GN(sal_Int16& count)
{
	return getReservedWords_fr_BF(count);
}
// ---> ContinuousNumbering
extern const OUString **  getContinuousNumberingLevels_fr_BF(sal_Int16& nStyles, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString **  getContinuousNumberingLevels_fr_GN(sal_Int16& nStyles, sal_Int16& nAttributes)
{
	return getContinuousNumberingLevels_fr_BF(nStyles, nAttributes);
}
// ---> OutlineNumbering
extern const OUString ***  getOutlineNumberingLevels_fr_BF(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString ***  getOutlineNumberingLevels_fr_GN(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes)
{
	return getOutlineNumberingLevels_fr_BF(nStyles, nLevels, nAttributes);
}
} // extern "C"

