// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
)

func CopyOrigSummaryDataPointSlice(dest, src []*otlpmetrics.SummaryDataPoint) []*otlpmetrics.SummaryDataPoint {
	var newDest []*otlpmetrics.SummaryDataPoint
	if cap(dest) < len(src) {
		newDest = make([]*otlpmetrics.SummaryDataPoint, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigSummaryDataPoint()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigSummaryDataPoint(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigSummaryDataPoint()
		}
	}
	for i := range src {
		CopyOrigSummaryDataPoint(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestSummaryDataPointSlice() []*otlpmetrics.SummaryDataPoint {
	orig := make([]*otlpmetrics.SummaryDataPoint, 5)
	orig[0] = NewOrigSummaryDataPoint()
	orig[1] = GenTestOrigSummaryDataPoint()
	orig[2] = NewOrigSummaryDataPoint()
	orig[3] = GenTestOrigSummaryDataPoint()
	orig[4] = NewOrigSummaryDataPoint()
	return orig
}
