// This file is generated by TypeBuilder_h.template.

// Copyright (c) 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef node_inspector_protocol_Network_h
#define node_inspector_protocol_Network_h

#include "src/node/inspector/protocol/Protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace node {
namespace inspector {
namespace protocol {
namespace Network {

// ------------- Forward and enum declarations.
using ResourceType = String;
using RequestId = String;
using TimeSinceEpoch = double;
using MonotonicTime = double;
class Request;
class Response;
using Headers = Object;
class RequestWillBeSentNotification;
class ResponseReceivedNotification;
class LoadingFailedNotification;
class LoadingFinishedNotification;

namespace ResourceTypeEnum {
 extern const char Document[];
 extern const char Stylesheet[];
 extern const char Image[];
 extern const char Media[];
 extern const char Font[];
 extern const char Script[];
 extern const char TextTrack[];
 extern const char XHR[];
 extern const char Fetch[];
 extern const char Prefetch[];
 extern const char EventSource[];
 extern const char WebSocket[];
 extern const char Manifest[];
 extern const char SignedExchange[];
 extern const char Ping[];
 extern const char CSPViolationReport[];
 extern const char Preflight[];
 extern const char Other[];
} // namespace ResourceTypeEnum

// ------------- Type and builder declarations.

class  Request : public Serializable{
    PROTOCOL_DISALLOW_COPY(Request);
public:
    static std::unique_ptr<Request> fromValue(protocol::Value* value, ErrorSupport* errors);

    ~Request() override { }

    String getUrl() { return m_url; }
    void setUrl(const String& value) { m_url = value; }

    String getMethod() { return m_method; }
    void setMethod(const String& value) { m_method = value; }

    protocol::Network::Headers* getHeaders() { return m_headers.get(); }
    void setHeaders(std::unique_ptr<protocol::Network::Headers> value) { m_headers = std::move(value); }

    std::unique_ptr<protocol::DictionaryValue> toValue() const;
    String serializeToJSON() override { return toValue()->serializeToJSON(); }
    std::vector<uint8_t> serializeToBinary() override { return toValue()->serializeToBinary(); }
    String toJSON() const { return toValue()->toJSONString(); }
    std::unique_ptr<Request> clone() const;

    template<int STATE>
    class RequestBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            MethodSet = 1 << 2,
            HeadersSet = 1 << 3,
            AllFieldsSet = (UrlSet | MethodSet | HeadersSet | 0)};


        RequestBuilder<STATE | UrlSet>& setUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->setUrl(value);
            return castState<UrlSet>();
        }

        RequestBuilder<STATE | MethodSet>& setMethod(const String& value)
        {
            static_assert(!(STATE & MethodSet), "property method should not be set yet");
            m_result->setMethod(value);
            return castState<MethodSet>();
        }

        RequestBuilder<STATE | HeadersSet>& setHeaders(std::unique_ptr<protocol::Network::Headers> value)
        {
            static_assert(!(STATE & HeadersSet), "property headers should not be set yet");
            m_result->setHeaders(std::move(value));
            return castState<HeadersSet>();
        }

        std::unique_ptr<Request> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Request;
        RequestBuilder() : m_result(new Request()) { }

        template<int STEP> RequestBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RequestBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::Request> m_result;
    };

    static RequestBuilder<0> create()
    {
        return RequestBuilder<0>();
    }

private:
    Request()
    {
    }

    String m_url;
    String m_method;
    std::unique_ptr<protocol::Network::Headers> m_headers;
};


class  Response : public Serializable{
    PROTOCOL_DISALLOW_COPY(Response);
public:
    static std::unique_ptr<Response> fromValue(protocol::Value* value, ErrorSupport* errors);

    ~Response() override { }

    String getUrl() { return m_url; }
    void setUrl(const String& value) { m_url = value; }

    int getStatus() { return m_status; }
    void setStatus(int value) { m_status = value; }

    String getStatusText() { return m_statusText; }
    void setStatusText(const String& value) { m_statusText = value; }

    protocol::Network::Headers* getHeaders() { return m_headers.get(); }
    void setHeaders(std::unique_ptr<protocol::Network::Headers> value) { m_headers = std::move(value); }

    std::unique_ptr<protocol::DictionaryValue> toValue() const;
    String serializeToJSON() override { return toValue()->serializeToJSON(); }
    std::vector<uint8_t> serializeToBinary() override { return toValue()->serializeToBinary(); }
    String toJSON() const { return toValue()->toJSONString(); }
    std::unique_ptr<Response> clone() const;

    template<int STATE>
    class ResponseBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            StatusSet = 1 << 2,
            StatusTextSet = 1 << 3,
            HeadersSet = 1 << 4,
            AllFieldsSet = (UrlSet | StatusSet | StatusTextSet | HeadersSet | 0)};


        ResponseBuilder<STATE | UrlSet>& setUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->setUrl(value);
            return castState<UrlSet>();
        }

        ResponseBuilder<STATE | StatusSet>& setStatus(int value)
        {
            static_assert(!(STATE & StatusSet), "property status should not be set yet");
            m_result->setStatus(value);
            return castState<StatusSet>();
        }

        ResponseBuilder<STATE | StatusTextSet>& setStatusText(const String& value)
        {
            static_assert(!(STATE & StatusTextSet), "property statusText should not be set yet");
            m_result->setStatusText(value);
            return castState<StatusTextSet>();
        }

        ResponseBuilder<STATE | HeadersSet>& setHeaders(std::unique_ptr<protocol::Network::Headers> value)
        {
            static_assert(!(STATE & HeadersSet), "property headers should not be set yet");
            m_result->setHeaders(std::move(value));
            return castState<HeadersSet>();
        }

        std::unique_ptr<Response> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Response;
        ResponseBuilder() : m_result(new Response()) { }

        template<int STEP> ResponseBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ResponseBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::Response> m_result;
    };

    static ResponseBuilder<0> create()
    {
        return ResponseBuilder<0>();
    }

private:
    Response()
    {
          m_status = 0;
    }

    String m_url;
    int m_status;
    String m_statusText;
    std::unique_ptr<protocol::Network::Headers> m_headers;
};


class  RequestWillBeSentNotification : public Serializable{
    PROTOCOL_DISALLOW_COPY(RequestWillBeSentNotification);
public:
    static std::unique_ptr<RequestWillBeSentNotification> fromValue(protocol::Value* value, ErrorSupport* errors);

    ~RequestWillBeSentNotification() override { }

    String getRequestId() { return m_requestId; }
    void setRequestId(const String& value) { m_requestId = value; }

    protocol::Network::Request* getRequest() { return m_request.get(); }
    void setRequest(std::unique_ptr<protocol::Network::Request> value) { m_request = std::move(value); }

    double getTimestamp() { return m_timestamp; }
    void setTimestamp(double value) { m_timestamp = value; }

    double getWallTime() { return m_wallTime; }
    void setWallTime(double value) { m_wallTime = value; }

    std::unique_ptr<protocol::DictionaryValue> toValue() const;
    String serializeToJSON() override { return toValue()->serializeToJSON(); }
    std::vector<uint8_t> serializeToBinary() override { return toValue()->serializeToBinary(); }
    String toJSON() const { return toValue()->toJSONString(); }
    std::unique_ptr<RequestWillBeSentNotification> clone() const;

    template<int STATE>
    class RequestWillBeSentNotificationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RequestIdSet = 1 << 1,
            RequestSet = 1 << 2,
            TimestampSet = 1 << 3,
            WallTimeSet = 1 << 4,
            AllFieldsSet = (RequestIdSet | RequestSet | TimestampSet | WallTimeSet | 0)};


        RequestWillBeSentNotificationBuilder<STATE | RequestIdSet>& setRequestId(const String& value)
        {
            static_assert(!(STATE & RequestIdSet), "property requestId should not be set yet");
            m_result->setRequestId(value);
            return castState<RequestIdSet>();
        }

        RequestWillBeSentNotificationBuilder<STATE | RequestSet>& setRequest(std::unique_ptr<protocol::Network::Request> value)
        {
            static_assert(!(STATE & RequestSet), "property request should not be set yet");
            m_result->setRequest(std::move(value));
            return castState<RequestSet>();
        }

        RequestWillBeSentNotificationBuilder<STATE | TimestampSet>& setTimestamp(double value)
        {
            static_assert(!(STATE & TimestampSet), "property timestamp should not be set yet");
            m_result->setTimestamp(value);
            return castState<TimestampSet>();
        }

        RequestWillBeSentNotificationBuilder<STATE | WallTimeSet>& setWallTime(double value)
        {
            static_assert(!(STATE & WallTimeSet), "property wallTime should not be set yet");
            m_result->setWallTime(value);
            return castState<WallTimeSet>();
        }

        std::unique_ptr<RequestWillBeSentNotification> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class RequestWillBeSentNotification;
        RequestWillBeSentNotificationBuilder() : m_result(new RequestWillBeSentNotification()) { }

        template<int STEP> RequestWillBeSentNotificationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RequestWillBeSentNotificationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::RequestWillBeSentNotification> m_result;
    };

    static RequestWillBeSentNotificationBuilder<0> create()
    {
        return RequestWillBeSentNotificationBuilder<0>();
    }

private:
    RequestWillBeSentNotification()
    {
          m_timestamp = 0;
          m_wallTime = 0;
    }

    String m_requestId;
    std::unique_ptr<protocol::Network::Request> m_request;
    double m_timestamp;
    double m_wallTime;
};


class  ResponseReceivedNotification : public Serializable{
    PROTOCOL_DISALLOW_COPY(ResponseReceivedNotification);
public:
    static std::unique_ptr<ResponseReceivedNotification> fromValue(protocol::Value* value, ErrorSupport* errors);

    ~ResponseReceivedNotification() override { }

    String getRequestId() { return m_requestId; }
    void setRequestId(const String& value) { m_requestId = value; }

    double getTimestamp() { return m_timestamp; }
    void setTimestamp(double value) { m_timestamp = value; }

    String getType() { return m_type; }
    void setType(const String& value) { m_type = value; }

    protocol::Network::Response* getResponse() { return m_response.get(); }
    void setResponse(std::unique_ptr<protocol::Network::Response> value) { m_response = std::move(value); }

    std::unique_ptr<protocol::DictionaryValue> toValue() const;
    String serializeToJSON() override { return toValue()->serializeToJSON(); }
    std::vector<uint8_t> serializeToBinary() override { return toValue()->serializeToBinary(); }
    String toJSON() const { return toValue()->toJSONString(); }
    std::unique_ptr<ResponseReceivedNotification> clone() const;

    template<int STATE>
    class ResponseReceivedNotificationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RequestIdSet = 1 << 1,
            TimestampSet = 1 << 2,
            TypeSet = 1 << 3,
            ResponseSet = 1 << 4,
            AllFieldsSet = (RequestIdSet | TimestampSet | TypeSet | ResponseSet | 0)};


        ResponseReceivedNotificationBuilder<STATE | RequestIdSet>& setRequestId(const String& value)
        {
            static_assert(!(STATE & RequestIdSet), "property requestId should not be set yet");
            m_result->setRequestId(value);
            return castState<RequestIdSet>();
        }

        ResponseReceivedNotificationBuilder<STATE | TimestampSet>& setTimestamp(double value)
        {
            static_assert(!(STATE & TimestampSet), "property timestamp should not be set yet");
            m_result->setTimestamp(value);
            return castState<TimestampSet>();
        }

        ResponseReceivedNotificationBuilder<STATE | TypeSet>& setType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->setType(value);
            return castState<TypeSet>();
        }

        ResponseReceivedNotificationBuilder<STATE | ResponseSet>& setResponse(std::unique_ptr<protocol::Network::Response> value)
        {
            static_assert(!(STATE & ResponseSet), "property response should not be set yet");
            m_result->setResponse(std::move(value));
            return castState<ResponseSet>();
        }

        std::unique_ptr<ResponseReceivedNotification> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ResponseReceivedNotification;
        ResponseReceivedNotificationBuilder() : m_result(new ResponseReceivedNotification()) { }

        template<int STEP> ResponseReceivedNotificationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ResponseReceivedNotificationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::ResponseReceivedNotification> m_result;
    };

    static ResponseReceivedNotificationBuilder<0> create()
    {
        return ResponseReceivedNotificationBuilder<0>();
    }

private:
    ResponseReceivedNotification()
    {
          m_timestamp = 0;
    }

    String m_requestId;
    double m_timestamp;
    String m_type;
    std::unique_ptr<protocol::Network::Response> m_response;
};


class  LoadingFailedNotification : public Serializable{
    PROTOCOL_DISALLOW_COPY(LoadingFailedNotification);
public:
    static std::unique_ptr<LoadingFailedNotification> fromValue(protocol::Value* value, ErrorSupport* errors);

    ~LoadingFailedNotification() override { }

    String getRequestId() { return m_requestId; }
    void setRequestId(const String& value) { m_requestId = value; }

    double getTimestamp() { return m_timestamp; }
    void setTimestamp(double value) { m_timestamp = value; }

    String getType() { return m_type; }
    void setType(const String& value) { m_type = value; }

    String getErrorText() { return m_errorText; }
    void setErrorText(const String& value) { m_errorText = value; }

    std::unique_ptr<protocol::DictionaryValue> toValue() const;
    String serializeToJSON() override { return toValue()->serializeToJSON(); }
    std::vector<uint8_t> serializeToBinary() override { return toValue()->serializeToBinary(); }
    String toJSON() const { return toValue()->toJSONString(); }
    std::unique_ptr<LoadingFailedNotification> clone() const;

    template<int STATE>
    class LoadingFailedNotificationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RequestIdSet = 1 << 1,
            TimestampSet = 1 << 2,
            TypeSet = 1 << 3,
            ErrorTextSet = 1 << 4,
            AllFieldsSet = (RequestIdSet | TimestampSet | TypeSet | ErrorTextSet | 0)};


        LoadingFailedNotificationBuilder<STATE | RequestIdSet>& setRequestId(const String& value)
        {
            static_assert(!(STATE & RequestIdSet), "property requestId should not be set yet");
            m_result->setRequestId(value);
            return castState<RequestIdSet>();
        }

        LoadingFailedNotificationBuilder<STATE | TimestampSet>& setTimestamp(double value)
        {
            static_assert(!(STATE & TimestampSet), "property timestamp should not be set yet");
            m_result->setTimestamp(value);
            return castState<TimestampSet>();
        }

        LoadingFailedNotificationBuilder<STATE | TypeSet>& setType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->setType(value);
            return castState<TypeSet>();
        }

        LoadingFailedNotificationBuilder<STATE | ErrorTextSet>& setErrorText(const String& value)
        {
            static_assert(!(STATE & ErrorTextSet), "property errorText should not be set yet");
            m_result->setErrorText(value);
            return castState<ErrorTextSet>();
        }

        std::unique_ptr<LoadingFailedNotification> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class LoadingFailedNotification;
        LoadingFailedNotificationBuilder() : m_result(new LoadingFailedNotification()) { }

        template<int STEP> LoadingFailedNotificationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LoadingFailedNotificationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::LoadingFailedNotification> m_result;
    };

    static LoadingFailedNotificationBuilder<0> create()
    {
        return LoadingFailedNotificationBuilder<0>();
    }

private:
    LoadingFailedNotification()
    {
          m_timestamp = 0;
    }

    String m_requestId;
    double m_timestamp;
    String m_type;
    String m_errorText;
};


class  LoadingFinishedNotification : public Serializable{
    PROTOCOL_DISALLOW_COPY(LoadingFinishedNotification);
public:
    static std::unique_ptr<LoadingFinishedNotification> fromValue(protocol::Value* value, ErrorSupport* errors);

    ~LoadingFinishedNotification() override { }

    String getRequestId() { return m_requestId; }
    void setRequestId(const String& value) { m_requestId = value; }

    double getTimestamp() { return m_timestamp; }
    void setTimestamp(double value) { m_timestamp = value; }

    std::unique_ptr<protocol::DictionaryValue> toValue() const;
    String serializeToJSON() override { return toValue()->serializeToJSON(); }
    std::vector<uint8_t> serializeToBinary() override { return toValue()->serializeToBinary(); }
    String toJSON() const { return toValue()->toJSONString(); }
    std::unique_ptr<LoadingFinishedNotification> clone() const;

    template<int STATE>
    class LoadingFinishedNotificationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RequestIdSet = 1 << 1,
            TimestampSet = 1 << 2,
            AllFieldsSet = (RequestIdSet | TimestampSet | 0)};


        LoadingFinishedNotificationBuilder<STATE | RequestIdSet>& setRequestId(const String& value)
        {
            static_assert(!(STATE & RequestIdSet), "property requestId should not be set yet");
            m_result->setRequestId(value);
            return castState<RequestIdSet>();
        }

        LoadingFinishedNotificationBuilder<STATE | TimestampSet>& setTimestamp(double value)
        {
            static_assert(!(STATE & TimestampSet), "property timestamp should not be set yet");
            m_result->setTimestamp(value);
            return castState<TimestampSet>();
        }

        std::unique_ptr<LoadingFinishedNotification> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class LoadingFinishedNotification;
        LoadingFinishedNotificationBuilder() : m_result(new LoadingFinishedNotification()) { }

        template<int STEP> LoadingFinishedNotificationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LoadingFinishedNotificationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::LoadingFinishedNotification> m_result;
    };

    static LoadingFinishedNotificationBuilder<0> create()
    {
        return LoadingFinishedNotificationBuilder<0>();
    }

private:
    LoadingFinishedNotification()
    {
          m_timestamp = 0;
    }

    String m_requestId;
    double m_timestamp;
};


// ------------- Backend interface.

class  Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse enable() = 0;

};

// ------------- Frontend interface.

class  Frontend {
public:
    explicit Frontend(FrontendChannel* frontendChannel) : m_frontendChannel(frontendChannel) { }
    void requestWillBeSent(const String& requestId, std::unique_ptr<protocol::Network::Request> request, double timestamp, double wallTime);
    void responseReceived(const String& requestId, double timestamp, const String& type, std::unique_ptr<protocol::Network::Response> response);
    void loadingFailed(const String& requestId, double timestamp, const String& type, const String& errorText);
    void loadingFinished(const String& requestId, double timestamp);

    void flush();
    void sendRawJSONNotification(String);
    void sendRawCBORNotification(std::vector<uint8_t>);
private:
    FrontendChannel* m_frontendChannel;
};

// ------------- Dispatcher.

class  Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class  Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Network
} // namespace node
} // namespace inspector
} // namespace protocol

#endif // !defined(node_inspector_protocol_Network_h)
