// python wrapper for vtkPVSelectionSource
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVSelectionSource.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVSelectionSource(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVSelectionSource_ClassNew(); }


static PyObject *
PyvtkPVSelectionSource_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVSelectionSource::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVSelectionSource::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVSelectionSource *tempr = vtkPVSelectionSource::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVSelectionSource *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVSelectionSource::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVSelectionSource::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVSelectionSource::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_AddFrustum(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddFrustum");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  const size_t size0 = 32;
  double temp0[32];
  double save0[32];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->AddFrustum(temp0);
    }
    else
    {
      op->vtkPVSelectionSource::AddFrustum(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_AddGlobalID(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddGlobalID");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->AddGlobalID(temp0);
    }
    else
    {
      op->vtkPVSelectionSource::AddGlobalID(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_RemoveAllGlobalIDs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllGlobalIDs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllGlobalIDs();
    }
    else
    {
      op->vtkPVSelectionSource::RemoveAllGlobalIDs();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_AddPedigreeID(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddPedigreeID");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  const char *temp0 = nullptr;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->AddPedigreeID(temp0, temp1);
    }
    else
    {
      op->vtkPVSelectionSource::AddPedigreeID(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_RemoveAllPedigreeIDs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllPedigreeIDs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllPedigreeIDs();
    }
    else
    {
      op->vtkPVSelectionSource::RemoveAllPedigreeIDs();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_AddPedigreeStringID(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddPedigreeStringID");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  const char *temp0 = nullptr;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->AddPedigreeStringID(temp0, temp1);
    }
    else
    {
      op->vtkPVSelectionSource::AddPedigreeStringID(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_RemoveAllPedigreeStringIDs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllPedigreeStringIDs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllPedigreeStringIDs();
    }
    else
    {
      op->vtkPVSelectionSource::RemoveAllPedigreeStringIDs();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_AddID(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddID");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->AddID(temp0, temp1);
    }
    else
    {
      op->vtkPVSelectionSource::AddID(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_RemoveAllIDs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllIDs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllIDs();
    }
    else
    {
      op->vtkPVSelectionSource::RemoveAllIDs();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_AddValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->AddValue(temp0, temp1);
    }
    else
    {
      op->vtkPVSelectionSource::AddValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_RemoveAllValues(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllValues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllValues();
    }
    else
    {
      op->vtkPVSelectionSource::RemoveAllValues();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_AddCompositeID(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddCompositeID");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  unsigned int temp0;
  long long temp1;
  long long temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->AddCompositeID(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVSelectionSource::AddCompositeID(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_RemoveAllCompositeIDs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllCompositeIDs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllCompositeIDs();
    }
    else
    {
      op->vtkPVSelectionSource::RemoveAllCompositeIDs();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_AddHierarhicalID(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddHierarhicalID");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  unsigned int temp0;
  unsigned int temp1;
  long long temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->AddHierarhicalID(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVSelectionSource::AddHierarhicalID(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_RemoveAllHierarchicalIDs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllHierarchicalIDs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllHierarchicalIDs();
    }
    else
    {
      op->vtkPVSelectionSource::RemoveAllHierarchicalIDs();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_AddThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  double temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->AddThreshold(temp0, temp1);
    }
    else
    {
      op->vtkPVSelectionSource::AddThreshold(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_RemoveAllThresholds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllThresholds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllThresholds();
    }
    else
    {
      op->vtkPVSelectionSource::RemoveAllThresholds();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_AddBlock(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddBlock");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->AddBlock(temp0);
    }
    else
    {
      op->vtkPVSelectionSource::AddBlock(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_RemoveAllBlocks(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllBlocks");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllBlocks();
    }
    else
    {
      op->vtkPVSelectionSource::RemoveAllBlocks();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_SetArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetArrayName(temp0);
    }
    else
    {
      op->vtkPVSelectionSource::SetArrayName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_AddLocation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddLocation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->AddLocation(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVSelectionSource::AddLocation(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_RemoveAllLocations(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllLocations");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllLocations();
    }
    else
    {
      op->vtkPVSelectionSource::RemoveAllLocations();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_AddBlockSelector(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddBlockSelector");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->AddBlockSelector(temp0);
    }
    else
    {
      op->vtkPVSelectionSource::AddBlockSelector(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_RemoveAllBlockSelectors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllBlockSelectors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllBlockSelectors();
    }
    else
    {
      op->vtkPVSelectionSource::RemoveAllBlockSelectors();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_SetProcessID(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetProcessID");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetProcessID(temp0);
    }
    else
    {
      op->vtkPVSelectionSource::SetProcessID(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_GetProcessIDMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProcessIDMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetProcessIDMinValue() :
      op->vtkPVSelectionSource::GetProcessIDMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_GetProcessIDMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProcessIDMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetProcessIDMaxValue() :
      op->vtkPVSelectionSource::GetProcessIDMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_GetProcessID(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProcessID");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetProcessID() :
      op->vtkPVSelectionSource::GetProcessID());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_SetFieldType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFieldType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFieldType(temp0);
    }
    else
    {
      op->vtkPVSelectionSource::SetFieldType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_GetFieldType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetFieldType() :
      op->vtkPVSelectionSource::GetFieldType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_SetContainingCells(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetContainingCells");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetContainingCells(temp0);
    }
    else
    {
      op->vtkPVSelectionSource::SetContainingCells(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_GetContainingCells(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetContainingCells");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetContainingCells() :
      op->vtkPVSelectionSource::GetContainingCells());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_SetInverse(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInverse");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInverse(temp0);
    }
    else
    {
      op->vtkPVSelectionSource::SetInverse(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_GetInverse(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInverse");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetInverse() :
      op->vtkPVSelectionSource::GetInverse());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_SetQueryString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetQueryString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetQueryString(temp0);
    }
    else
    {
      op->vtkPVSelectionSource::SetQueryString(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_GetQueryString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetQueryString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetQueryString() :
      op->vtkPVSelectionSource::GetQueryString());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_SetNumberOfLayers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfLayers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfLayers(temp0);
    }
    else
    {
      op->vtkPVSelectionSource::SetNumberOfLayers(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_GetNumberOfLayersMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfLayersMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfLayersMinValue() :
      op->vtkPVSelectionSource::GetNumberOfLayersMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_GetNumberOfLayersMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfLayersMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfLayersMaxValue() :
      op->vtkPVSelectionSource::GetNumberOfLayersMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_GetNumberOfLayers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfLayers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfLayers() :
      op->vtkPVSelectionSource::GetNumberOfLayers());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_SetRemoveSeed(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRemoveSeed");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRemoveSeed(temp0);
    }
    else
    {
      op->vtkPVSelectionSource::SetRemoveSeed(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_GetRemoveSeed(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRemoveSeed");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetRemoveSeed() :
      op->vtkPVSelectionSource::GetRemoveSeed());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_SetRemoveIntermediateLayers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRemoveIntermediateLayers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRemoveIntermediateLayers(temp0);
    }
    else
    {
      op->vtkPVSelectionSource::SetRemoveIntermediateLayers(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSelectionSource_GetRemoveIntermediateLayers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRemoveIntermediateLayers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSelectionSource *op = static_cast<vtkPVSelectionSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetRemoveIntermediateLayers() :
      op->vtkPVSelectionSource::GetRemoveIntermediateLayers());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVSelectionSource_Methods[] = {
  {"IsTypeOf", PyvtkPVSelectionSource_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVSelectionSource_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVSelectionSource_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVSelectionSource\nC++: static vtkPVSelectionSource *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVSelectionSource_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVSelectionSource\nC++: vtkPVSelectionSource *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVSelectionSource_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVSelectionSource_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"AddFrustum", PyvtkPVSelectionSource_AddFrustum, METH_VARARGS,
   "AddFrustum(self, vertices:[float, float, float, float, float,\n    float, float, float, float, float, float, float, float, float,\n     float, float, float, float, float, float, float, float,\n    float, float, float, float, float, float, float, float, float,\n     float]) -> None\nC++: void AddFrustum(double vertices[32])\n\nSet a frustum to choose within.\n"},
  {"AddGlobalID", PyvtkPVSelectionSource_AddGlobalID, METH_VARARGS,
   "AddGlobalID(self, id:int) -> None\nC++: void AddGlobalID(vtkIdType id)\n\nAdd global IDs.\n"},
  {"RemoveAllGlobalIDs", PyvtkPVSelectionSource_RemoveAllGlobalIDs, METH_VARARGS,
   "RemoveAllGlobalIDs(self) -> None\nC++: void RemoveAllGlobalIDs()\n\n"},
  {"AddPedigreeID", PyvtkPVSelectionSource_AddPedigreeID, METH_VARARGS,
   "AddPedigreeID(self, domain:str, id:int) -> None\nC++: void AddPedigreeID(const char *domain, vtkIdType id)\n\nAdd integer pedigree IDs in a particular domain.\n"},
  {"RemoveAllPedigreeIDs", PyvtkPVSelectionSource_RemoveAllPedigreeIDs, METH_VARARGS,
   "RemoveAllPedigreeIDs(self) -> None\nC++: void RemoveAllPedigreeIDs()\n\n"},
  {"AddPedigreeStringID", PyvtkPVSelectionSource_AddPedigreeStringID, METH_VARARGS,
   "AddPedigreeStringID(self, domain:str, id:str) -> None\nC++: void AddPedigreeStringID(const char *domain, const char *id)\n\nAdd string pedigree IDs in a particular domain.\n"},
  {"RemoveAllPedigreeStringIDs", PyvtkPVSelectionSource_RemoveAllPedigreeStringIDs, METH_VARARGS,
   "RemoveAllPedigreeStringIDs(self) -> None\nC++: void RemoveAllPedigreeStringIDs()\n\n"},
  {"AddID", PyvtkPVSelectionSource_AddID, METH_VARARGS,
   "AddID(self, piece:int, id:int) -> None\nC++: void AddID(vtkIdType piece, vtkIdType id)\n\nAdd a (piece, id) to the selection set. The source will generate\nonly the ids for which piece == UPDATE_PIECE_NUMBER. If piece ==\n-1, the id applies to all pieces.\n"},
  {"RemoveAllIDs", PyvtkPVSelectionSource_RemoveAllIDs, METH_VARARGS,
   "RemoveAllIDs(self) -> None\nC++: void RemoveAllIDs()\n\n"},
  {"AddValue", PyvtkPVSelectionSource_AddValue, METH_VARARGS,
   "AddValue(self, piece:int, value:int) -> None\nC++: void AddValue(vtkIdType piece, vtkIdType value)\n\nAdd a (piece, value) to the selection set. The source will\ngenerate only the values for which piece == UPDATE_PIECE_NUMBER.\nIf piece == -1, the id applies to all pieces.\n"},
  {"RemoveAllValues", PyvtkPVSelectionSource_RemoveAllValues, METH_VARARGS,
   "RemoveAllValues(self) -> None\nC++: void RemoveAllValues()\n\n"},
  {"AddCompositeID", PyvtkPVSelectionSource_AddCompositeID, METH_VARARGS,
   "AddCompositeID(self, composite_index:int, piece:int, id:int)\n    -> None\nC++: void AddCompositeID(unsigned int composite_index,\n    vtkIdType piece, vtkIdType id)\n\nAdd IDs that will be added to the selection produced by the\nselection source. The source will generate only the ids for which\npiece == UPDATE_PIECE_NUMBER. If piece == -1, the id applies to\nall pieces.\n"},
  {"RemoveAllCompositeIDs", PyvtkPVSelectionSource_RemoveAllCompositeIDs, METH_VARARGS,
   "RemoveAllCompositeIDs(self) -> None\nC++: void RemoveAllCompositeIDs()\n\n"},
  {"AddHierarhicalID", PyvtkPVSelectionSource_AddHierarhicalID, METH_VARARGS,
   "AddHierarhicalID(self, level:int, dataset:int, id:int) -> None\nC++: void AddHierarhicalID(unsigned int level,\n    unsigned int dataset, vtkIdType id)\n\nThe list of IDs that will be added to the selection produced by\nthe selection source.\n"},
  {"RemoveAllHierarchicalIDs", PyvtkPVSelectionSource_RemoveAllHierarchicalIDs, METH_VARARGS,
   "RemoveAllHierarchicalIDs(self) -> None\nC++: void RemoveAllHierarchicalIDs()\n\n"},
  {"AddThreshold", PyvtkPVSelectionSource_AddThreshold, METH_VARARGS,
   "AddThreshold(self, min:float, max:float) -> None\nC++: void AddThreshold(double min, double max)\n\nAdd a value range to threshold within.\n"},
  {"RemoveAllThresholds", PyvtkPVSelectionSource_RemoveAllThresholds, METH_VARARGS,
   "RemoveAllThresholds(self) -> None\nC++: void RemoveAllThresholds()\n\n"},
  {"AddBlock", PyvtkPVSelectionSource_AddBlock, METH_VARARGS,
   "AddBlock(self, blockno:int) -> None\nC++: void AddBlock(vtkIdType blockno)\n\nAdd the flat-index/composite index for a block.\n"},
  {"RemoveAllBlocks", PyvtkPVSelectionSource_RemoveAllBlocks, METH_VARARGS,
   "RemoveAllBlocks(self) -> None\nC++: void RemoveAllBlocks()\n\n"},
  {"SetArrayName", PyvtkPVSelectionSource_SetArrayName, METH_VARARGS,
   "SetArrayName(self, _arg:str) -> None\nC++: virtual void SetArrayName(const char *_arg)\n\nFor threshold and value selection, this controls the name of the\nscalar array that will be thresholded within.\n"},
  {"AddLocation", PyvtkPVSelectionSource_AddLocation, METH_VARARGS,
   "AddLocation(self, x:float, y:float, z:float) -> None\nC++: void AddLocation(double x, double y, double z)\n\nAdd a point in world space to probe at.\n"},
  {"RemoveAllLocations", PyvtkPVSelectionSource_RemoveAllLocations, METH_VARARGS,
   "RemoveAllLocations(self) -> None\nC++: void RemoveAllLocations()\n\n"},
  {"AddBlockSelector", PyvtkPVSelectionSource_AddBlockSelector, METH_VARARGS,
   "AddBlockSelector(self, selector:str) -> None\nC++: void AddBlockSelector(const char *selector)\n\nAdd/Remove block-selectors to make selections with\nvtkSelectionNode::BLOCK_SELECTORS as the content-type.\n"},
  {"RemoveAllBlockSelectors", PyvtkPVSelectionSource_RemoveAllBlockSelectors, METH_VARARGS,
   "RemoveAllBlockSelectors(self) -> None\nC++: void RemoveAllBlockSelectors()\n\n"},
  {"SetProcessID", PyvtkPVSelectionSource_SetProcessID, METH_VARARGS,
   "SetProcessID(self, _arg:int) -> None\nC++: virtual void SetProcessID(int _arg)\n\nGet/Set which process to limit the selection to. `-1` is treated\nas all processes.\n"},
  {"GetProcessIDMinValue", PyvtkPVSelectionSource_GetProcessIDMinValue, METH_VARARGS,
   "GetProcessIDMinValue(self) -> int\nC++: virtual int GetProcessIDMinValue()\n\n"},
  {"GetProcessIDMaxValue", PyvtkPVSelectionSource_GetProcessIDMaxValue, METH_VARARGS,
   "GetProcessIDMaxValue(self) -> int\nC++: virtual int GetProcessIDMaxValue()\n\n"},
  {"GetProcessID", PyvtkPVSelectionSource_GetProcessID, METH_VARARGS,
   "GetProcessID(self) -> int\nC++: virtual int GetProcessID()\n\n"},
  {"SetFieldType", PyvtkPVSelectionSource_SetFieldType, METH_VARARGS,
   "SetFieldType(self, _arg:int) -> None\nC++: virtual void SetFieldType(int _arg)\n\nSet the field type for the generated selection. Possible values\nare as defined by vtkSelectionNode::SelectionField.\n"},
  {"GetFieldType", PyvtkPVSelectionSource_GetFieldType, METH_VARARGS,
   "GetFieldType(self) -> int\nC++: virtual int GetFieldType()\n\n"},
  {"SetContainingCells", PyvtkPVSelectionSource_SetContainingCells, METH_VARARGS,
   "SetContainingCells(self, _arg:int) -> None\nC++: virtual void SetContainingCells(int _arg)\n\nWhen extracting by points, extract the cells that contain the\npassing points.\n"},
  {"GetContainingCells", PyvtkPVSelectionSource_GetContainingCells, METH_VARARGS,
   "GetContainingCells(self) -> int\nC++: virtual int GetContainingCells()\n\n"},
  {"SetInverse", PyvtkPVSelectionSource_SetInverse, METH_VARARGS,
   "SetInverse(self, _arg:int) -> None\nC++: virtual void SetInverse(int _arg)\n\n"},
  {"GetInverse", PyvtkPVSelectionSource_GetInverse, METH_VARARGS,
   "GetInverse(self) -> int\nC++: virtual int GetInverse()\n\n"},
  {"SetQueryString", PyvtkPVSelectionSource_SetQueryString, METH_VARARGS,
   "SetQueryString(self, _arg:str) -> None\nC++: virtual void SetQueryString(const char *_arg)\n\nSet/get the query expression string.\n"},
  {"GetQueryString", PyvtkPVSelectionSource_GetQueryString, METH_VARARGS,
   "GetQueryString(self) -> str\nC++: virtual char *GetQueryString()\n\n"},
  {"SetNumberOfLayers", PyvtkPVSelectionSource_SetNumberOfLayers, METH_VARARGS,
   "SetNumberOfLayers(self, _arg:int) -> None\nC++: virtual void SetNumberOfLayers(int _arg)\n\nSpecify number of layers to extract connected to the selected\nelements.\n"},
  {"GetNumberOfLayersMinValue", PyvtkPVSelectionSource_GetNumberOfLayersMinValue, METH_VARARGS,
   "GetNumberOfLayersMinValue(self) -> int\nC++: virtual int GetNumberOfLayersMinValue()\n\n"},
  {"GetNumberOfLayersMaxValue", PyvtkPVSelectionSource_GetNumberOfLayersMaxValue, METH_VARARGS,
   "GetNumberOfLayersMaxValue(self) -> int\nC++: virtual int GetNumberOfLayersMaxValue()\n\n"},
  {"GetNumberOfLayers", PyvtkPVSelectionSource_GetNumberOfLayers, METH_VARARGS,
   "GetNumberOfLayers(self) -> int\nC++: virtual int GetNumberOfLayers()\n\n"},
  {"SetRemoveSeed", PyvtkPVSelectionSource_SetRemoveSeed, METH_VARARGS,
   "SetRemoveSeed(self, _arg:bool) -> None\nC++: virtual void SetRemoveSeed(bool _arg)\n\nSet/Get the flag the control if, when using the number of layers\nto extract connected elements, the initial selection seed should\nbe removed. Default is falsse\n"},
  {"GetRemoveSeed", PyvtkPVSelectionSource_GetRemoveSeed, METH_VARARGS,
   "GetRemoveSeed(self) -> bool\nC++: virtual bool GetRemoveSeed()\n\n"},
  {"SetRemoveIntermediateLayers", PyvtkPVSelectionSource_SetRemoveIntermediateLayers, METH_VARARGS,
   "SetRemoveIntermediateLayers(self, _arg:bool) -> None\nC++: virtual void SetRemoveIntermediateLayers(bool _arg)\n\nSet/Get the flag the control if, when using the number of layers\nto extract connected elements, the intermediate layers should be\nremoved. Default is falsse\n"},
  {"GetRemoveIntermediateLayers", PyvtkPVSelectionSource_GetRemoveIntermediateLayers, METH_VARARGS,
   "GetRemoveIntermediateLayers(self) -> bool\nC++: virtual bool GetRemoveIntermediateLayers()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVSelectionSource_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("array_name"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSelectionSource_SetArrayName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSelectionSource_SetArrayName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetArrayName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("process_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSelectionSource_GetProcessID(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSelectionSource_SetProcessID(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSelectionSource_SetProcessID(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetProcessID/SetProcessID\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("field_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSelectionSource_GetFieldType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSelectionSource_SetFieldType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSelectionSource_SetFieldType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFieldType/SetFieldType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("containing_cells"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSelectionSource_GetContainingCells(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSelectionSource_SetContainingCells(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSelectionSource_SetContainingCells(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetContainingCells/SetContainingCells\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("inverse"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSelectionSource_GetInverse(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSelectionSource_SetInverse(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSelectionSource_SetInverse(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetInverse/SetInverse\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("query_string"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSelectionSource_GetQueryString(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSelectionSource_SetQueryString(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSelectionSource_SetQueryString(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetQueryString/SetQueryString\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("remove_seed"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSelectionSource_GetRemoveSeed(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSelectionSource_SetRemoveSeed(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSelectionSource_SetRemoveSeed(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRemoveSeed/SetRemoveSeed\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("remove_intermediate_layers"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSelectionSource_GetRemoveIntermediateLayers(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSelectionSource_SetRemoveIntermediateLayers(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSelectionSource_SetRemoveIntermediateLayers(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRemoveIntermediateLayers/SetRemoveIntermediateLayers\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_layers_min_value"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSelectionSource_GetNumberOfLayersMinValue(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfLayersMinValue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_layers_max_value"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSelectionSource_GetNumberOfLayersMaxValue(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfLayersMaxValue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_layers"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSelectionSource_GetNumberOfLayers(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSelectionSource_SetNumberOfLayers(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSelectionSource_SetNumberOfLayers(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfLayers/SetNumberOfLayers\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVSelectionSource_Doc =
  "vtkPVSelectionSource - selection source used to produce different\ntypes of vtkSelections.\n\n"
  "Superclass: vtkSelectionAlgorithm\n\n"
  "vtkPVSelectionSource is used to create different types of selections.\n"
  "It provides different APIs for different types of selections to\n"
  "create. The output selection type depends on the API used most\n"
  "recently.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVSelectionSource_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsExtraction.vtkPVSelectionSource", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVSelectionSource_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVSelectionSource_StaticNew()
{
  return vtkPVSelectionSource::New();
}

PyObject *PyvtkPVSelectionSource_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVSelectionSource_Type, PyvtkPVSelectionSource_Methods,
    "vtkPVSelectionSource",
 &PyvtkPVSelectionSource_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkSelectionAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVSelectionSource_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVSelectionSource(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVSelectionSource_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVSelectionSource", o) != 0)
  {
    Py_DECREF(o);
  }

}

