// python wrapper for vtkTimestepsAnimationPlayer
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkTimestepsAnimationPlayer.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkTimestepsAnimationPlayer(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkTimestepsAnimationPlayer_ClassNew(); }

#ifndef DECLARED_PyvtkAnimationPlayer_ClassNew
extern "C" { PyObject *PyvtkAnimationPlayer_ClassNew(); }
#define DECLARED_PyvtkAnimationPlayer_ClassNew
#endif

static PyObject *
PyvtkTimestepsAnimationPlayer_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkTimestepsAnimationPlayer::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTimestepsAnimationPlayer_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTimestepsAnimationPlayer *op = static_cast<vtkTimestepsAnimationPlayer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkTimestepsAnimationPlayer::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTimestepsAnimationPlayer_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkTimestepsAnimationPlayer *tempr = vtkTimestepsAnimationPlayer::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTimestepsAnimationPlayer_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTimestepsAnimationPlayer *op = static_cast<vtkTimestepsAnimationPlayer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkTimestepsAnimationPlayer *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkTimestepsAnimationPlayer::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTimestepsAnimationPlayer_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkTimestepsAnimationPlayer::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTimestepsAnimationPlayer_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTimestepsAnimationPlayer *op = static_cast<vtkTimestepsAnimationPlayer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkTimestepsAnimationPlayer::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTimestepsAnimationPlayer_AddTimeStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddTimeStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTimestepsAnimationPlayer *op = static_cast<vtkTimestepsAnimationPlayer *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->AddTimeStep(temp0);
    }
    else
    {
      op->vtkTimestepsAnimationPlayer::AddTimeStep(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkTimestepsAnimationPlayer_RemoveTimeStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveTimeStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTimestepsAnimationPlayer *op = static_cast<vtkTimestepsAnimationPlayer *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->RemoveTimeStep(temp0);
    }
    else
    {
      op->vtkTimestepsAnimationPlayer::RemoveTimeStep(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkTimestepsAnimationPlayer_RemoveAllTimeSteps(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllTimeSteps");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTimestepsAnimationPlayer *op = static_cast<vtkTimestepsAnimationPlayer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllTimeSteps();
    }
    else
    {
      op->vtkTimestepsAnimationPlayer::RemoveAllTimeSteps();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkTimestepsAnimationPlayer_GetNumberOfTimeSteps(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfTimeSteps");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTimestepsAnimationPlayer *op = static_cast<vtkTimestepsAnimationPlayer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfTimeSteps() :
      op->vtkTimestepsAnimationPlayer::GetNumberOfTimeSteps());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTimestepsAnimationPlayer_SetFramesPerTimestep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFramesPerTimestep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTimestepsAnimationPlayer *op = static_cast<vtkTimestepsAnimationPlayer *>(vp);

  unsigned long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFramesPerTimestep(temp0);
    }
    else
    {
      op->vtkTimestepsAnimationPlayer::SetFramesPerTimestep(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkTimestepsAnimationPlayer_GetFramesPerTimestepMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFramesPerTimestepMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTimestepsAnimationPlayer *op = static_cast<vtkTimestepsAnimationPlayer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetFramesPerTimestepMinValue() :
      op->vtkTimestepsAnimationPlayer::GetFramesPerTimestepMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTimestepsAnimationPlayer_GetFramesPerTimestepMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFramesPerTimestepMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTimestepsAnimationPlayer *op = static_cast<vtkTimestepsAnimationPlayer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetFramesPerTimestepMaxValue() :
      op->vtkTimestepsAnimationPlayer::GetFramesPerTimestepMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTimestepsAnimationPlayer_GetFramesPerTimestep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFramesPerTimestep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTimestepsAnimationPlayer *op = static_cast<vtkTimestepsAnimationPlayer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetFramesPerTimestep() :
      op->vtkTimestepsAnimationPlayer::GetFramesPerTimestep());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTimestepsAnimationPlayer_GetNextTimeStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNextTimeStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTimestepsAnimationPlayer *op = static_cast<vtkTimestepsAnimationPlayer *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    double tempr = (ap.IsBound() ?
      op->GetNextTimeStep(temp0) :
      op->vtkTimestepsAnimationPlayer::GetNextTimeStep(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTimestepsAnimationPlayer_GetPreviousTimeStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPreviousTimeStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTimestepsAnimationPlayer *op = static_cast<vtkTimestepsAnimationPlayer *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    double tempr = (ap.IsBound() ?
      op->GetPreviousTimeStep(temp0) :
      op->vtkTimestepsAnimationPlayer::GetPreviousTimeStep(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkTimestepsAnimationPlayer_Methods[] = {
  {"IsTypeOf", PyvtkTimestepsAnimationPlayer_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkTimestepsAnimationPlayer_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkTimestepsAnimationPlayer_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkTimestepsAnimationPlayer\nC++: static vtkTimestepsAnimationPlayer *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkTimestepsAnimationPlayer_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkTimestepsAnimationPlayer\nC++: vtkTimestepsAnimationPlayer *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkTimestepsAnimationPlayer_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkTimestepsAnimationPlayer_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"AddTimeStep", PyvtkTimestepsAnimationPlayer_AddTimeStep, METH_VARARGS,
   "AddTimeStep(self, time:float) -> None\nC++: void AddTimeStep(double time)\n\nAdd/Remove timesteps.\n"},
  {"RemoveTimeStep", PyvtkTimestepsAnimationPlayer_RemoveTimeStep, METH_VARARGS,
   "RemoveTimeStep(self, time:float) -> None\nC++: void RemoveTimeStep(double time)\n\n"},
  {"RemoveAllTimeSteps", PyvtkTimestepsAnimationPlayer_RemoveAllTimeSteps, METH_VARARGS,
   "RemoveAllTimeSteps(self) -> None\nC++: void RemoveAllTimeSteps()\n\nRemove all timesteps.\n"},
  {"GetNumberOfTimeSteps", PyvtkTimestepsAnimationPlayer_GetNumberOfTimeSteps, METH_VARARGS,
   "GetNumberOfTimeSteps(self) -> int\nC++: unsigned int GetNumberOfTimeSteps()\n\nGet number of timesteps.\n"},
  {"SetFramesPerTimestep", PyvtkTimestepsAnimationPlayer_SetFramesPerTimestep, METH_VARARGS,
   "SetFramesPerTimestep(self, _arg:int) -> None\nC++: virtual void SetFramesPerTimestep(unsigned long _arg)\n\nGet/Set the number of frames per timstep.\n"},
  {"GetFramesPerTimestepMinValue", PyvtkTimestepsAnimationPlayer_GetFramesPerTimestepMinValue, METH_VARARGS,
   "GetFramesPerTimestepMinValue(self) -> int\nC++: virtual unsigned long GetFramesPerTimestepMinValue()\n\n"},
  {"GetFramesPerTimestepMaxValue", PyvtkTimestepsAnimationPlayer_GetFramesPerTimestepMaxValue, METH_VARARGS,
   "GetFramesPerTimestepMaxValue(self) -> int\nC++: virtual unsigned long GetFramesPerTimestepMaxValue()\n\n"},
  {"GetFramesPerTimestep", PyvtkTimestepsAnimationPlayer_GetFramesPerTimestep, METH_VARARGS,
   "GetFramesPerTimestep(self) -> int\nC++: virtual unsigned long GetFramesPerTimestep()\n\n"},
  {"GetNextTimeStep", PyvtkTimestepsAnimationPlayer_GetNextTimeStep, METH_VARARGS,
   "GetNextTimeStep(self, time:float) -> float\nC++: double GetNextTimeStep(double time)\n\nReturns the timestep value after the given timestep. If no value\nexists, returns the argument time itself.\n"},
  {"GetPreviousTimeStep", PyvtkTimestepsAnimationPlayer_GetPreviousTimeStep, METH_VARARGS,
   "GetPreviousTimeStep(self, time:float) -> float\nC++: double GetPreviousTimeStep(double time)\n\nReturns the timestep value before the given timestep. If no value\nexists, returns the argument time itself.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkTimestepsAnimationPlayer_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("frames_per_timestep"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkTimestepsAnimationPlayer_GetFramesPerTimestep(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkTimestepsAnimationPlayer_SetFramesPerTimestep(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkTimestepsAnimationPlayer_SetFramesPerTimestep(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFramesPerTimestep/SetFramesPerTimestep\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_time_steps"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkTimestepsAnimationPlayer_GetNumberOfTimeSteps(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfTimeSteps\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkTimestepsAnimationPlayer_Doc =
  "vtkTimestepsAnimationPlayer - vtkAnimationPlayer subclass that plays\nthrough a discrete set of time values.\n\n"
  "Superclass: vtkAnimationPlayer\n\n"
  "Player to play an animation scene through a discrete set of time\n"
  "values. FramesPerTimestep controls how many frames are generated for\n"
  "each time value.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkTimestepsAnimationPlayer_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingAnimation.vtkTimestepsAnimationPlayer", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkTimestepsAnimationPlayer_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkTimestepsAnimationPlayer_StaticNew()
{
  return vtkTimestepsAnimationPlayer::New();
}

PyObject *PyvtkTimestepsAnimationPlayer_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkTimestepsAnimationPlayer_Type, PyvtkTimestepsAnimationPlayer_Methods,
    "vtkTimestepsAnimationPlayer",
 &PyvtkTimestepsAnimationPlayer_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkAnimationPlayer_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkTimestepsAnimationPlayer_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkTimestepsAnimationPlayer(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkTimestepsAnimationPlayer_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkTimestepsAnimationPlayer", o) != 0)
  {
    Py_DECREF(o);
  }

}

