// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A8__F356

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr pstring_view PACKAGE_PATH
#if defined(_WIN32)
{ LR"xyzw(amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx)xyzw" };
#else
{ R"xyzw(amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx)xyzw" };
#endif
constexpr std::string_view FUNC_NAME { R"xyzw(＊bf16@16_256_F_T_0_0)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx1153)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0x0d612045u, 0xde5bf696u, 456, 33 }, // 0d612045de5bf696 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_16_16_True__CO__wave3_warp2_stg1--Arch_gfx1153
    { 0x80ae104du, 0x50e2013cu, 456, 50 }, // 80ae104d50e2013c = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_16_16_True__CO__wave4_warp2_stg1--Arch_gfx1153
    { 0x886e45d7u, 0x7a8d213du, 0, 202 }, // 886e45d77a8d213d = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_32_16_False__CO__wave1_warp4_stg1--Arch_gfx1153
    { 0xbf298f97u, 0xdb59d174u, 0, 16 }, // bf298f97db59d174 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_32_16_False__CO__wave2_warp2_stg1--Arch_gfx1153
    { 0xf5c9d827u, 0x8787c685u, 0, 116 }, // f5c9d8278787c685 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_32_16_False__CO__wave2_warp4_stg1--Arch_gfx1153
    { 0x870133dbu, 0xc7603161u, 0, 33 }, // 870133dbc7603161 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_32_16_False__CO__wave3_warp2_stg1--Arch_gfx1153
    { 0x8309d33au, 0x1dde2a9cu, 0, 167 }, // 8309d33a1dde2a9c = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_32_16_False__CO__wave3_warp4_stg1--Arch_gfx1153
    { 0xeb9e7756u, 0x393f082du, 0, 133 }, // eb9e7756393f082d = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_32_16_False__CO__wave4_warp4_stg1--Arch_gfx1153
    { 0x2ed411c9u, 0x3a0cbfa3u, 366, 202 }, // 2ed411c93a0cbfa3 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_32_16_True__CO__wave1_warp4_stg1--Arch_gfx1153
    { 0xe5e50664u, 0xb69a0234u, 366, 116 }, // e5e50664b69a0234 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_32_16_True__CO__wave2_warp4_stg1--Arch_gfx1153
    { 0x901491c4u, 0xb4cac67eu, 366, 167 }, // 901491c4b4cac67e = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_32_16_True__CO__wave3_warp4_stg1--Arch_gfx1153
    { 0x473feb5du, 0xb1c09d85u, 366, 133 }, // 473feb5db1c09d85 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_32_16_True__CO__wave4_warp4_stg1--Arch_gfx1153
    { 0x178aaaf1u, 0xc70aa48au, 318, 202 }, // 178aaaf1c70aa48a = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_32_32_False__CO__wave1_warp4_stg1--Arch_gfx1153
    { 0x6ca8d4f5u, 0x754e6184u, 318, 116 }, // 6ca8d4f5754e6184 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_32_32_False__CO__wave2_warp4_stg1--Arch_gfx1153
    { 0x24dbc413u, 0x66e0d7bfu, 318, 167 }, // 24dbc41366e0d7bf = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_32_32_False__CO__wave3_warp4_stg1--Arch_gfx1153
    { 0x35d00a88u, 0xb757c184u, 381, 202 }, // 35d00a88b757c184 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_32_32_True__CO__wave1_warp4_stg1--Arch_gfx1153
    { 0xec0976a3u, 0x4b4e83c7u, 381, 116 }, // ec0976a34b4e83c7 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_32_32_True__CO__wave2_warp4_stg1--Arch_gfx1153
    { 0x5a3ba156u, 0x3e374eeeu, 67, 202 }, // 5a3ba1563e374eee = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_64_32_False__CO__wave1_warp4_stg1--Arch_gfx1153
    { 0x50d94c91u, 0x2c837a4cu, 67, 116 }, // 50d94c912c837a4c = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_64_32_False__CO__wave2_warp4_stg1--Arch_gfx1153
    { 0xd33568e6u, 0x6c2170efu, 67, 167 }, // d33568e66c2170ef = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_64_32_False__CO__wave3_warp4_stg1--Arch_gfx1153
    { 0x93504350u, 0x0d58cc0du, 67, 133 }, // 935043500d58cc0d = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_64_32_False__CO__wave4_warp4_stg1--Arch_gfx1153
    { 0x0b375ee8u, 0x5388b0cbu, 396, 202 }, // 0b375ee85388b0cb = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_64_32_True__CO__wave1_warp4_stg1--Arch_gfx1153
    { 0x78312775u, 0xdd67fb8bu, 396, 116 }, // 78312775dd67fb8b = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_256_F_T_0_0___gfx11xx__P__0_2_64_32_True__CO__wave2_warp4_stg1--Arch_gfx1153
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx1153_mod0
{{ 4, 4, 7, 7, 6, 6,14,14, 0, 1},
 {12, 2, 6, 6,10,11,10,15,15,15},
 {13, 7, 8, 8,10,10,11,21,21,21},
 {13, 8, 8, 8,11,10,21,17,21, 0},
 {13, 8, 8, 8,10,18,17,17,11,12},
 {13, 8, 8, 8,20,17,21, 5, 5, 5},
 {13, 8, 8,11,17,21,21,17,21,21},
 {16, 9, 8, 3,17,17,17,17,17,21},
 {15, 9, 8,19,17,17,17,17,17,17},
 {16, 8,11,10,22,20,17,17,17,17}}
// End of GPU gfx1153_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A8__F356 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 3;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 3;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*bf16:16"
// B = 0
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_bz = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 256
// Head_dim = 256
// PADDED_HEAD = False
// ENABLE_DROPOUT = True
// dropout_p = "fp32"
// philox_seed_ptr = "*u64"
// philox_offset1 = "*u64"
// philox_offset2 = "u64"
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 0
// Window_left = 0
// BIAS_TYPE = 0
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = 0
// Num_CU = "i32"

// SELECT * FROM FLASH$attn_fwd WHERE gpu IN ('gfx1100_mod0') AND inputs$Q_dtype = 'torch.bfloat16' AND inputs$BLOCK_DMODEL = 256 AND inputs$PADDED_HEAD = False AND inputs$ENABLE_DROPOUT = True AND inputs$CAUSAL_TYPE = 0 AND inputs$BIAS_TYPE = 0

// vim: set fileencoding=utf-8

