// content/common/document_scoped_interface_bundle.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_DOCUMENT_SCOPED_INTERFACE_BUNDLE_MOJOM_SHARED_H_
#define CONTENT_COMMON_DOCUMENT_SCOPED_INTERFACE_BUNDLE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "content/common/document_scoped_interface_bundle.mojom-shared-internal.h"
#include "services/service_manager/public/mojom/interface_provider.mojom-shared.h"
#include "third_party/blink/public/mojom/browser_interface_broker.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace content {
namespace mojom {
class DocumentScopedInterfaceBundleDataView;



}  // namespace mojom
}  // namespace content

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content::mojom::DocumentScopedInterfaceBundleDataView> {
  using Data = ::content::mojom::internal::DocumentScopedInterfaceBundle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace content {
namespace mojom {


class DocumentScopedInterfaceBundleDataView {
 public:
  DocumentScopedInterfaceBundleDataView() {}

  DocumentScopedInterfaceBundleDataView(
      internal::DocumentScopedInterfaceBundle_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeInterfaceProvider() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::service_manager::mojom::InterfaceProviderInterfaceBase>>(
            &data_->interface_provider, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeBrowserInterfaceBroker() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
            &data_->browser_interface_broker, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::DocumentScopedInterfaceBundle_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace content

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::DocumentScopedInterfaceBundleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::DocumentScopedInterfaceBundleDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::DocumentScopedInterfaceBundle_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::interface_provider(input)) in_interface_provider = Traits::interface_provider(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::service_manager::mojom::InterfaceProviderInterfaceBase>>(
        in_interface_provider, &(*output)->interface_provider, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->interface_provider),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid interface_provider in DocumentScopedInterfaceBundle struct");
    decltype(Traits::browser_interface_broker(input)) in_browser_interface_broker = Traits::browser_interface_broker(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
        in_browser_interface_broker, &(*output)->browser_interface_broker, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->browser_interface_broker),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid browser_interface_broker in DocumentScopedInterfaceBundle struct");
  }

  static bool Deserialize(::content::mojom::internal::DocumentScopedInterfaceBundle_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::DocumentScopedInterfaceBundleDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace content {
namespace mojom {




}  // namespace mojom
}  // namespace content

#endif  // CONTENT_COMMON_DOCUMENT_SCOPED_INTERFACE_BUNDLE_MOJOM_SHARED_H_