// content/common/navigation_client.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/navigation_client.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "content/common/navigation_client.mojom-params-data.h"
#include "content/common/navigation_client.mojom-shared-message-ids.h"

#include "content/common/navigation_client.mojom-import-headers.h"


#ifndef CONTENT_COMMON_NAVIGATION_CLIENT_MOJOM_JUMBO_H_
#define CONTENT_COMMON_NAVIGATION_CLIENT_MOJOM_JUMBO_H_
#include "content/common/frame_messages.h"
#include "content/common/resource_messages.h"
#include "third_party/blink/common/feature_policy/feature_policy_mojom_traits.h"
#endif
namespace content {
namespace mojom {
const char NavigationClient::Name_[] = "content.mojom.NavigationClient";

class NavigationClient_CommitNavigation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NavigationClient_CommitNavigation_ForwardToCallback(
      NavigationClient::CommitNavigationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NavigationClient::CommitNavigationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NavigationClient_CommitNavigation_ForwardToCallback);
};

class NavigationClient_CommitFailedNavigation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NavigationClient_CommitFailedNavigation_ForwardToCallback(
      NavigationClient::CommitFailedNavigationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NavigationClient::CommitFailedNavigationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NavigationClient_CommitFailedNavigation_ForwardToCallback);
};

NavigationClientProxy::NavigationClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NavigationClientProxy::CommitNavigation(
    ::content::mojom::CommonNavigationParamsPtr in_common_params, ::content::mojom::CommitNavigationParamsPtr in_request_params, ::network::mojom::URLResponseHeadPtr in_response_head, ::mojo::ScopedDataPipeConsumerHandle in_response_body, ::network::mojom::URLLoaderClientEndpointsPtr in_url_loader_client_endpoints, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> in_subresource_loader_factories, base::Optional<std::vector<::blink::mojom::TransferrableURLLoaderPtr>> in_subresource_overrides, ::blink::mojom::ControllerServiceWorkerInfoPtr in_controller_service_worker_info, ::blink::mojom::ServiceWorkerContainerInfoForClientPtr in_container_info, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> in_prefetch_loader_factory, const ::base::UnguessableToken& in_devtools_navigation_token, CommitNavigationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::NavigationClient::CommitNavigation", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_common_params.is_null()) {
        raw_value->SetString("common_params", "nullptr");
      } else {
        raw_value->BeginDictionary("common_params");
        in_common_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      if (in_request_params.is_null()) {
        raw_value->SetString("request_params", "nullptr");
      } else {
        raw_value->BeginDictionary("request_params");
        in_request_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      if (in_response_head.is_null()) {
        raw_value->SetString("response_head", "nullptr");
      } else {
        raw_value->BeginDictionary("response_head");
        in_response_head->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("response_body", in_response_body.is_valid());
      if (in_url_loader_client_endpoints.is_null()) {
        raw_value->SetString("url_loader_client_endpoints", "nullptr");
      } else {
        raw_value->BeginDictionary("url_loader_client_endpoints");
        in_url_loader_client_endpoints->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetString("subresource_loader_factories", base::trace_event::ValueToString(in_subresource_loader_factories, "<value of type ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle>>"));
      if (in_subresource_overrides.has_value()) {
        raw_value->BeginArray("subresource_overrides");
        for (const auto& item0 : in_subresource_overrides.value()) {
          if (item0.is_null()) {
            raw_value->AppendString("nullptr");
          } else {
            raw_value->BeginDictionary();
            item0->AsValueInto(raw_value);
            raw_value->EndDictionary();
          }
        }
        raw_value->EndArray();
      } else {
        raw_value->SetString("subresource_overrides", "base::nullopt");
      }
      if (in_controller_service_worker_info.is_null()) {
        raw_value->SetString("controller_service_worker_info", "nullptr");
      } else {
        raw_value->BeginDictionary("controller_service_worker_info");
        in_controller_service_worker_info->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      if (in_container_info.is_null()) {
        raw_value->SetString("container_info", "nullptr");
      } else {
        raw_value->BeginDictionary("container_info");
        in_container_info->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("prefetch_loader_factory", in_prefetch_loader_factory.is_valid());
      raw_value->SetString("devtools_navigation_token", base::trace_event::ValueToString(in_devtools_navigation_token, "<value of type const ::base::UnguessableToken&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNavigationClient_CommitNavigation_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::NavigationClient_CommitNavigation_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->common_params)::BaseType::BufferWriter
      common_params_writer;
  mojo::internal::Serialize<::content::mojom::CommonNavigationParamsDataView>(
      in_common_params, buffer, &common_params_writer, &serialization_context);
  params->common_params.Set(
      common_params_writer.is_null() ? nullptr : common_params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->common_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null common_params in NavigationClient.CommitNavigation request");
  typename decltype(params->request_params)::BaseType::BufferWriter
      request_params_writer;
  mojo::internal::Serialize<::content::mojom::CommitNavigationParamsDataView>(
      in_request_params, buffer, &request_params_writer, &serialization_context);
  params->request_params.Set(
      request_params_writer.is_null() ? nullptr : request_params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request_params in NavigationClient.CommitNavigation request");
  typename decltype(params->response_head)::BaseType::BufferWriter
      response_head_writer;
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
      in_response_head, buffer, &response_head_writer, &serialization_context);
  params->response_head.Set(
      response_head_writer.is_null() ? nullptr : response_head_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->response_head.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response_head in NavigationClient.CommitNavigation request");
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_response_body, &params->response_body, &serialization_context);
  typename decltype(params->url_loader_client_endpoints)::BaseType::BufferWriter
      url_loader_client_endpoints_writer;
  mojo::internal::Serialize<::network::mojom::URLLoaderClientEndpointsDataView>(
      in_url_loader_client_endpoints, buffer, &url_loader_client_endpoints_writer, &serialization_context);
  params->url_loader_client_endpoints.Set(
      url_loader_client_endpoints_writer.is_null() ? nullptr : url_loader_client_endpoints_writer.data());
  typename decltype(params->subresource_loader_factories)::BaseType::BufferWriter
      subresource_loader_factories_writer;
  mojo::internal::Serialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
      in_subresource_loader_factories, buffer, &subresource_loader_factories_writer, &serialization_context);
  params->subresource_loader_factories.Set(
      subresource_loader_factories_writer.is_null() ? nullptr : subresource_loader_factories_writer.data());
  typename decltype(params->subresource_overrides)::BaseType::BufferWriter
      subresource_overrides_writer;
  const mojo::internal::ContainerValidateParams subresource_overrides_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::TransferrableURLLoaderDataView>>(
      in_subresource_overrides, buffer, &subresource_overrides_writer, &subresource_overrides_validate_params,
      &serialization_context);
  params->subresource_overrides.Set(
      subresource_overrides_writer.is_null() ? nullptr : subresource_overrides_writer.data());
  typename decltype(params->controller_service_worker_info)::BaseType::BufferWriter
      controller_service_worker_info_writer;
  mojo::internal::Serialize<::blink::mojom::ControllerServiceWorkerInfoDataView>(
      in_controller_service_worker_info, buffer, &controller_service_worker_info_writer, &serialization_context);
  params->controller_service_worker_info.Set(
      controller_service_worker_info_writer.is_null() ? nullptr : controller_service_worker_info_writer.data());
  typename decltype(params->container_info)::BaseType::BufferWriter
      container_info_writer;
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerContainerInfoForClientDataView>(
      in_container_info, buffer, &container_info_writer, &serialization_context);
  params->container_info.Set(
      container_info_writer.is_null() ? nullptr : container_info_writer.data());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
      in_prefetch_loader_factory, &params->prefetch_loader_factory, &serialization_context);
  typename decltype(params->devtools_navigation_token)::BaseType::BufferWriter
      devtools_navigation_token_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_devtools_navigation_token, buffer, &devtools_navigation_token_writer, &serialization_context);
  params->devtools_navigation_token.Set(
      devtools_navigation_token_writer.is_null() ? nullptr : devtools_navigation_token_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtools_navigation_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtools_navigation_token in NavigationClient.CommitNavigation request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigationClient::Name_);
  message.set_method_name("CommitNavigation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NavigationClient_CommitNavigation_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NavigationClientProxy::CommitFailedNavigation(
    ::content::mojom::CommonNavigationParamsPtr in_common_params, ::content::mojom::CommitNavigationParamsPtr in_request_params, bool in_has_stale_copy_in_cache, int32_t in_error_code, const ::net::ResolveErrorInfo& in_resolve_error_info, const base::Optional<std::string>& in_error_page_content, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> in_subresource_loader_factories, CommitFailedNavigationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::NavigationClient::CommitFailedNavigation", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_common_params.is_null()) {
        raw_value->SetString("common_params", "nullptr");
      } else {
        raw_value->BeginDictionary("common_params");
        in_common_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      if (in_request_params.is_null()) {
        raw_value->SetString("request_params", "nullptr");
      } else {
        raw_value->BeginDictionary("request_params");
        in_request_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("has_stale_copy_in_cache", in_has_stale_copy_in_cache);
      raw_value->SetInteger("error_code", in_error_code);
      raw_value->SetString("resolve_error_info", base::trace_event::ValueToString(in_resolve_error_info, "<value of type const ::net::ResolveErrorInfo&>"));
      if (in_error_page_content.has_value()) {
        raw_value->SetString("error_page_content", in_error_page_content.value());
      } else {
        raw_value->SetString("error_page_content", "base::nullopt");
      }
      raw_value->SetString("subresource_loader_factories", base::trace_event::ValueToString(in_subresource_loader_factories, "<value of type ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle>>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNavigationClient_CommitFailedNavigation_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::NavigationClient_CommitFailedNavigation_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->common_params)::BaseType::BufferWriter
      common_params_writer;
  mojo::internal::Serialize<::content::mojom::CommonNavigationParamsDataView>(
      in_common_params, buffer, &common_params_writer, &serialization_context);
  params->common_params.Set(
      common_params_writer.is_null() ? nullptr : common_params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->common_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null common_params in NavigationClient.CommitFailedNavigation request");
  typename decltype(params->request_params)::BaseType::BufferWriter
      request_params_writer;
  mojo::internal::Serialize<::content::mojom::CommitNavigationParamsDataView>(
      in_request_params, buffer, &request_params_writer, &serialization_context);
  params->request_params.Set(
      request_params_writer.is_null() ? nullptr : request_params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request_params in NavigationClient.CommitFailedNavigation request");
  params->has_stale_copy_in_cache = in_has_stale_copy_in_cache;
  params->error_code = in_error_code;
  typename decltype(params->resolve_error_info)::BaseType::BufferWriter
      resolve_error_info_writer;
  mojo::internal::Serialize<::network::mojom::ResolveErrorInfoDataView>(
      in_resolve_error_info, buffer, &resolve_error_info_writer, &serialization_context);
  params->resolve_error_info.Set(
      resolve_error_info_writer.is_null() ? nullptr : resolve_error_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resolve_error_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resolve_error_info in NavigationClient.CommitFailedNavigation request");
  typename decltype(params->error_page_content)::BaseType::BufferWriter
      error_page_content_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_page_content, buffer, &error_page_content_writer, &serialization_context);
  params->error_page_content.Set(
      error_page_content_writer.is_null() ? nullptr : error_page_content_writer.data());
  typename decltype(params->subresource_loader_factories)::BaseType::BufferWriter
      subresource_loader_factories_writer;
  mojo::internal::Serialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
      in_subresource_loader_factories, buffer, &subresource_loader_factories_writer, &serialization_context);
  params->subresource_loader_factories.Set(
      subresource_loader_factories_writer.is_null() ? nullptr : subresource_loader_factories_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigationClient::Name_);
  message.set_method_name("CommitFailedNavigation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NavigationClient_CommitFailedNavigation_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class NavigationClient_CommitNavigation_ProxyToResponder {
 public:
  static NavigationClient::CommitNavigationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NavigationClient_CommitNavigation_ProxyToResponder> proxy(
        new NavigationClient_CommitNavigation_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NavigationClient_CommitNavigation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NavigationClient_CommitNavigation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NavigationClient_CommitNavigation_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NavigationClient::CommitNavigationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::std::unique_ptr<::FrameHostMsg_DidCommitProvisionalLoad_Params> in_params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr in_interface_params);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NavigationClient_CommitNavigation_ProxyToResponder);
};

bool NavigationClient_CommitNavigation_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::NavigationClient::CommitNavigationCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NavigationClient_CommitNavigation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NavigationClient_CommitNavigation_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::std::unique_ptr<::FrameHostMsg_DidCommitProvisionalLoad_Params> p_params{};
  ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr p_interface_params{};
  NavigationClient_CommitNavigation_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadParams(&p_params))
    success = false;
  if (success && !input_data_view.ReadInterfaceParams(&p_interface_params))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NavigationClient::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_params), 
std::move(p_interface_params));
  return true;
}

void NavigationClient_CommitNavigation_ProxyToResponder::Run(
    ::std::unique_ptr<::FrameHostMsg_DidCommitProvisionalLoad_Params> in_params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr in_interface_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::NavigationClient::CommitNavigationCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("params", base::trace_event::ValueToString(in_params, "<value of type ::std::unique_ptr<::FrameHostMsg_DidCommitProvisionalLoad_Params>>"));
      if (in_interface_params.is_null()) {
        raw_value->SetString("interface_params", "nullptr");
      } else {
        raw_value->BeginDictionary("interface_params");
        in_interface_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNavigationClient_CommitNavigation_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::NavigationClient_CommitNavigation_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->params)::BaseType::BufferWriter
      params_writer;
  mojo::internal::Serialize<::content::mojom::DidCommitProvisionalLoadParamsDataView>(
      in_params, buffer, &params_writer, &serialization_context);
  params->params.Set(
      params_writer.is_null() ? nullptr : params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in ");
  typename decltype(params->interface_params)::BaseType::BufferWriter
      interface_params_writer;
  mojo::internal::Serialize<::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView>(
      in_interface_params, buffer, &interface_params_writer, &serialization_context);
  params->interface_params.Set(
      interface_params_writer.is_null() ? nullptr : interface_params_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::NavigationClient::CommitNavigationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigationClient::Name_);
  message.set_method_name("CommitNavigation");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NavigationClient_CommitFailedNavigation_ProxyToResponder {
 public:
  static NavigationClient::CommitFailedNavigationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NavigationClient_CommitFailedNavigation_ProxyToResponder> proxy(
        new NavigationClient_CommitFailedNavigation_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NavigationClient_CommitFailedNavigation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NavigationClient_CommitFailedNavigation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NavigationClient_CommitFailedNavigation_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NavigationClient::CommitFailedNavigationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::std::unique_ptr<::FrameHostMsg_DidCommitProvisionalLoad_Params> in_params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr in_interface_params);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NavigationClient_CommitFailedNavigation_ProxyToResponder);
};

bool NavigationClient_CommitFailedNavigation_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::NavigationClient::CommitFailedNavigationCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NavigationClient_CommitFailedNavigation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NavigationClient_CommitFailedNavigation_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::std::unique_ptr<::FrameHostMsg_DidCommitProvisionalLoad_Params> p_params{};
  ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr p_interface_params{};
  NavigationClient_CommitFailedNavigation_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadParams(&p_params))
    success = false;
  if (success && !input_data_view.ReadInterfaceParams(&p_interface_params))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NavigationClient::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_params), 
std::move(p_interface_params));
  return true;
}

void NavigationClient_CommitFailedNavigation_ProxyToResponder::Run(
    ::std::unique_ptr<::FrameHostMsg_DidCommitProvisionalLoad_Params> in_params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr in_interface_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::NavigationClient::CommitFailedNavigationCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("params", base::trace_event::ValueToString(in_params, "<value of type ::std::unique_ptr<::FrameHostMsg_DidCommitProvisionalLoad_Params>>"));
      if (in_interface_params.is_null()) {
        raw_value->SetString("interface_params", "nullptr");
      } else {
        raw_value->BeginDictionary("interface_params");
        in_interface_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNavigationClient_CommitFailedNavigation_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::NavigationClient_CommitFailedNavigation_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->params)::BaseType::BufferWriter
      params_writer;
  mojo::internal::Serialize<::content::mojom::DidCommitProvisionalLoadParamsDataView>(
      in_params, buffer, &params_writer, &serialization_context);
  params->params.Set(
      params_writer.is_null() ? nullptr : params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in ");
  typename decltype(params->interface_params)::BaseType::BufferWriter
      interface_params_writer;
  mojo::internal::Serialize<::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView>(
      in_interface_params, buffer, &interface_params_writer, &serialization_context);
  params->interface_params.Set(
      interface_params_writer.is_null() ? nullptr : interface_params_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::NavigationClient::CommitFailedNavigationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigationClient::Name_);
  message.set_method_name("CommitFailedNavigation");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NavigationClientStubDispatch::Accept(
    NavigationClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kNavigationClient_CommitNavigation_Name: {
      break;
    }
    case internal::kNavigationClient_CommitFailedNavigation_Name: {
      break;
    }
  }
  return false;
}

// static
bool NavigationClientStubDispatch::AcceptWithResponder(
    NavigationClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNavigationClient_CommitNavigation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::NavigationClient::CommitNavigation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::NavigationClient::CommitNavigation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NavigationClient_CommitNavigation_Params_Data* params =
          reinterpret_cast<
              internal::NavigationClient_CommitNavigation_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::content::mojom::CommonNavigationParamsPtr p_common_params{};
      ::content::mojom::CommitNavigationParamsPtr p_request_params{};
      ::network::mojom::URLResponseHeadPtr p_response_head{};
      ::mojo::ScopedDataPipeConsumerHandle p_response_body{};
      ::network::mojom::URLLoaderClientEndpointsPtr p_url_loader_client_endpoints{};
      ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> p_subresource_loader_factories{};
      base::Optional<std::vector<::blink::mojom::TransferrableURLLoaderPtr>> p_subresource_overrides{};
      ::blink::mojom::ControllerServiceWorkerInfoPtr p_controller_service_worker_info{};
      ::blink::mojom::ServiceWorkerContainerInfoForClientPtr p_container_info{};
      ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> p_prefetch_loader_factory{};
      ::base::UnguessableToken p_devtools_navigation_token{};
      NavigationClient_CommitNavigation_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCommonParams(&p_common_params))
        success = false;
      if (success && !input_data_view.ReadRequestParams(&p_request_params))
        success = false;
      if (success && !input_data_view.ReadResponseHead(&p_response_head))
        success = false;
      if (success)
        p_response_body = input_data_view.TakeResponseBody();
      if (success && !input_data_view.ReadUrlLoaderClientEndpoints(&p_url_loader_client_endpoints))
        success = false;
      if (success && !input_data_view.ReadSubresourceLoaderFactories(&p_subresource_loader_factories))
        success = false;
      if (success && !input_data_view.ReadSubresourceOverrides(&p_subresource_overrides))
        success = false;
      if (success && !input_data_view.ReadControllerServiceWorkerInfo(&p_controller_service_worker_info))
        success = false;
      if (success && !input_data_view.ReadContainerInfo(&p_container_info))
        success = false;
      if (success) {
        p_prefetch_loader_factory =
            input_data_view.TakePrefetchLoaderFactory<decltype(p_prefetch_loader_factory)>();
      }
      if (success && !input_data_view.ReadDevtoolsNavigationToken(&p_devtools_navigation_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NavigationClient::Name_, 0, false);
        return false;
      }
      NavigationClient::CommitNavigationCallback callback =
          NavigationClient_CommitNavigation_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CommitNavigation(
std::move(p_common_params), 
std::move(p_request_params), 
std::move(p_response_head), 
std::move(p_response_body), 
std::move(p_url_loader_client_endpoints), 
std::move(p_subresource_loader_factories), 
std::move(p_subresource_overrides), 
std::move(p_controller_service_worker_info), 
std::move(p_container_info), 
std::move(p_prefetch_loader_factory), 
std::move(p_devtools_navigation_token), std::move(callback));
      return true;
    }
    case internal::kNavigationClient_CommitFailedNavigation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::NavigationClient::CommitFailedNavigation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::NavigationClient::CommitFailedNavigation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NavigationClient_CommitFailedNavigation_Params_Data* params =
          reinterpret_cast<
              internal::NavigationClient_CommitFailedNavigation_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::content::mojom::CommonNavigationParamsPtr p_common_params{};
      ::content::mojom::CommitNavigationParamsPtr p_request_params{};
      bool p_has_stale_copy_in_cache{};
      int32_t p_error_code{};
      ::net::ResolveErrorInfo p_resolve_error_info{};
      base::Optional<std::string> p_error_page_content{};
      ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> p_subresource_loader_factories{};
      NavigationClient_CommitFailedNavigation_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCommonParams(&p_common_params))
        success = false;
      if (success && !input_data_view.ReadRequestParams(&p_request_params))
        success = false;
      if (success)
        p_has_stale_copy_in_cache = input_data_view.has_stale_copy_in_cache();
      if (success)
        p_error_code = input_data_view.error_code();
      if (success && !input_data_view.ReadResolveErrorInfo(&p_resolve_error_info))
        success = false;
      if (success && !input_data_view.ReadErrorPageContent(&p_error_page_content))
        success = false;
      if (success && !input_data_view.ReadSubresourceLoaderFactories(&p_subresource_loader_factories))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NavigationClient::Name_, 1, false);
        return false;
      }
      NavigationClient::CommitFailedNavigationCallback callback =
          NavigationClient_CommitFailedNavigation_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CommitFailedNavigation(
std::move(p_common_params), 
std::move(p_request_params), 
std::move(p_has_stale_copy_in_cache), 
std::move(p_error_code), 
std::move(p_resolve_error_info), 
std::move(p_error_page_content), 
std::move(p_subresource_loader_factories), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNavigationClientValidationInfo[] = {
    {internal::kNavigationClient_CommitNavigation_Name,
     {&internal::NavigationClient_CommitNavigation_Params_Data::Validate,
      &internal::NavigationClient_CommitNavigation_ResponseParams_Data::Validate}},
    {internal::kNavigationClient_CommitFailedNavigation_Name,
     {&internal::NavigationClient_CommitFailedNavigation_Params_Data::Validate,
      &internal::NavigationClient_CommitFailedNavigation_ResponseParams_Data::Validate}},
};

bool NavigationClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::NavigationClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNavigationClientValidationInfo);
}

bool NavigationClientResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::NavigationClient::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kNavigationClientValidationInfo);

}
}  // namespace mojom
}  // namespace content

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif