// third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBPREFERENCES_WEB_PREFERENCES_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBPREFERENCES_WEB_PREFERENCES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/v8_cache_options.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"



#include "base/component_export.h"




namespace blink {
namespace mojom {
class WebPreferencesDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::WebPreferencesDataView> {
  using Data = ::blink::mojom::internal::WebPreferences_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class PointerType : int32_t {
  
  kPointerFirstType = 1,
  
  kPointerCoarseType = 2,
  
  kPointerFineType = 4,
  kMinValue = 1,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PointerType value);
inline bool IsKnownEnumValue(PointerType value) {
  return internal::PointerType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HoverType : int32_t {
  
  kHoverFirstType = 1,
  
  kHoverHoverType = 2,
  kMinValue = 1,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, HoverType value);
inline bool IsKnownEnumValue(HoverType value) {
  return internal::HoverType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PreferredColorScheme : int32_t {
  
  kDark = 0,
  
  kLight = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PreferredColorScheme value);
inline bool IsKnownEnumValue(PreferredColorScheme value) {
  return internal::PreferredColorScheme_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class EditingBehavior : int32_t {
  
  kEditingMacBehavior = 0,
  
  kEditingWindowsBehavior = 1,
  
  kEditingUnixBehavior = 2,
  
  kEditingAndroidBehavior = 3,
  
  kEditingChromeOSBehavior = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, EditingBehavior value);
inline bool IsKnownEnumValue(EditingBehavior value) {
  return internal::EditingBehavior_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ImageAnimationPolicy : int32_t {
  
  kImageAnimationPolicyAllowed = 0,
  
  kImageAnimationPolicyAnimateOnce = 1,
  
  kImageAnimationPolicyNoAnimation = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ImageAnimationPolicy value);
inline bool IsKnownEnumValue(ImageAnimationPolicy value) {
  return internal::ImageAnimationPolicy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ViewportStyle : int32_t {
  
  kDefault = 0,
  
  kMobile = 1,
  
  kTelevision = 2,
  
  kLast = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ViewportStyle value);
inline bool IsKnownEnumValue(ViewportStyle value) {
  return internal::ViewportStyle_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AutoplayPolicy : int32_t {
  
  kNoUserGestureRequired = 0,
  
  kUserGestureRequired = 1,
  
  kDocumentUserActivationRequired = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AutoplayPolicy value);
inline bool IsKnownEnumValue(AutoplayPolicy value) {
  return internal::AutoplayPolicy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class EffectiveConnectionType : int32_t {
  
  kEffectiveConnectionUnknownType = 0,
  
  kEffectiveConnectionOfflineType = 1,
  
  kEffectiveConnectionSlow2GType = 2,
  
  kEffectiveConnection2GType = 3,
  
  kEffectiveConnection3GType = 4,
  
  kEffectiveConnection4GType = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, EffectiveConnectionType value);
inline bool IsKnownEnumValue(EffectiveConnectionType value) {
  return internal::EffectiveConnectionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class WebPreferencesDataView {
 public:
  WebPreferencesDataView() {}

  WebPreferencesDataView(
      internal::WebPreferences_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetStandardFontFamilyMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStandardFontFamilyMap(UserType* output) {
    
    auto* pointer = data_->standard_font_family_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        pointer, output, context_);
  }
  inline void GetFixedFontFamilyMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFixedFontFamilyMap(UserType* output) {
    
    auto* pointer = data_->fixed_font_family_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        pointer, output, context_);
  }
  inline void GetSerifFontFamilyMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSerifFontFamilyMap(UserType* output) {
    
    auto* pointer = data_->serif_font_family_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        pointer, output, context_);
  }
  inline void GetSansSerifFontFamilyMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSansSerifFontFamilyMap(UserType* output) {
    
    auto* pointer = data_->sans_serif_font_family_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        pointer, output, context_);
  }
  inline void GetCursiveFontFamilyMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCursiveFontFamilyMap(UserType* output) {
    
    auto* pointer = data_->cursive_font_family_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        pointer, output, context_);
  }
  inline void GetFantasyFontFamilyMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFantasyFontFamilyMap(UserType* output) {
    
    auto* pointer = data_->fantasy_font_family_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        pointer, output, context_);
  }
  inline void GetPictographFontFamilyMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPictographFontFamilyMap(UserType* output) {
    
    auto* pointer = data_->pictograph_font_family_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        pointer, output, context_);
  }
  int32_t default_font_size() const {
    return data_->default_font_size;
  }
  int32_t default_fixed_font_size() const {
    return data_->default_fixed_font_size;
  }
  int32_t minimum_font_size() const {
    return data_->minimum_font_size;
  }
  int32_t minimum_logical_font_size() const {
    return data_->minimum_logical_font_size;
  }
  inline void GetDefaultEncodingDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDefaultEncoding(UserType* output) {
    
    auto* pointer = data_->default_encoding.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  bool context_menu_on_mouse_up() const {
    return data_->context_menu_on_mouse_up;
  }
  bool javascript_enabled() const {
    return data_->javascript_enabled;
  }
  bool web_security_enabled() const {
    return data_->web_security_enabled;
  }
  bool loads_images_automatically() const {
    return data_->loads_images_automatically;
  }
  bool images_enabled() const {
    return data_->images_enabled;
  }
  bool plugins_enabled() const {
    return data_->plugins_enabled;
  }
  bool dom_paste_enabled() const {
    return data_->dom_paste_enabled;
  }
  bool shrinks_standalone_images_to_fit() const {
    return data_->shrinks_standalone_images_to_fit;
  }
  bool text_areas_are_resizable() const {
    return data_->text_areas_are_resizable;
  }
  bool allow_scripts_to_close_windows() const {
    return data_->allow_scripts_to_close_windows;
  }
  bool remote_fonts_enabled() const {
    return data_->remote_fonts_enabled;
  }
  bool javascript_can_access_clipboard() const {
    return data_->javascript_can_access_clipboard;
  }
  bool xslt_enabled() const {
    return data_->xslt_enabled;
  }
  bool dns_prefetching_enabled() const {
    return data_->dns_prefetching_enabled;
  }
  bool data_saver_enabled() const {
    return data_->data_saver_enabled;
  }
  bool data_saver_holdback_web_api_enabled() const {
    return data_->data_saver_holdback_web_api_enabled;
  }
  bool local_storage_enabled() const {
    return data_->local_storage_enabled;
  }
  bool databases_enabled() const {
    return data_->databases_enabled;
  }
  bool application_cache_enabled() const {
    return data_->application_cache_enabled;
  }
  bool tabs_to_links() const {
    return data_->tabs_to_links;
  }
  bool disable_ipc_flooding_protection() const {
    return data_->disable_ipc_flooding_protection;
  }
  bool hyperlink_auditing_enabled() const {
    return data_->hyperlink_auditing_enabled;
  }
  bool allow_universal_access_from_file_urls() const {
    return data_->allow_universal_access_from_file_urls;
  }
  bool allow_file_access_from_file_urls() const {
    return data_->allow_file_access_from_file_urls;
  }
  bool webgl1_enabled() const {
    return data_->webgl1_enabled;
  }
  bool webgl2_enabled() const {
    return data_->webgl2_enabled;
  }
  bool pepper_3d_enabled() const {
    return data_->pepper_3d_enabled;
  }
  bool flash_3d_enabled() const {
    return data_->flash_3d_enabled;
  }
  bool flash_stage3d_enabled() const {
    return data_->flash_stage3d_enabled;
  }
  bool flash_stage3d_baseline_enabled() const {
    return data_->flash_stage3d_baseline_enabled;
  }
  bool privileged_webgl_extensions_enabled() const {
    return data_->privileged_webgl_extensions_enabled;
  }
  bool webgl_errors_to_console_enabled() const {
    return data_->webgl_errors_to_console_enabled;
  }
  bool hide_scrollbars() const {
    return data_->hide_scrollbars;
  }
  bool accelerated_2d_canvas_enabled() const {
    return data_->accelerated_2d_canvas_enabled;
  }
  bool new_canvas_2d_api_enabled() const {
    return data_->new_canvas_2d_api_enabled;
  }
  bool antialiased_2d_canvas_disabled() const {
    return data_->antialiased_2d_canvas_disabled;
  }
  bool antialiased_clips_2d_canvas_enabled() const {
    return data_->antialiased_clips_2d_canvas_enabled;
  }
  bool accelerated_filters_enabled() const {
    return data_->accelerated_filters_enabled;
  }
  bool deferred_filters_enabled() const {
    return data_->deferred_filters_enabled;
  }
  bool container_culling_enabled() const {
    return data_->container_culling_enabled;
  }
  bool allow_running_insecure_content() const {
    return data_->allow_running_insecure_content;
  }
  bool disable_reading_from_canvas() const {
    return data_->disable_reading_from_canvas;
  }
  bool strict_mixed_content_checking() const {
    return data_->strict_mixed_content_checking;
  }
  bool strict_powerful_feature_restrictions() const {
    return data_->strict_powerful_feature_restrictions;
  }
  bool allow_geolocation_on_insecure_origins() const {
    return data_->allow_geolocation_on_insecure_origins;
  }
  bool strictly_block_blockable_mixed_content() const {
    return data_->strictly_block_blockable_mixed_content;
  }
  bool block_mixed_plugin_content() const {
    return data_->block_mixed_plugin_content;
  }
  bool password_echo_enabled() const {
    return data_->password_echo_enabled;
  }
  bool should_clear_document_background() const {
    return data_->should_clear_document_background;
  }
  bool enable_scroll_animator() const {
    return data_->enable_scroll_animator;
  }
  bool prefers_reduced_motion() const {
    return data_->prefers_reduced_motion;
  }
  bool touch_event_feature_detection_enabled() const {
    return data_->touch_event_feature_detection_enabled;
  }
  bool enable_error_page() const {
    return data_->enable_error_page;
  }
  int32_t pointer_events_max_touch_points() const {
    return data_->pointer_events_max_touch_points;
  }
  int32_t available_pointer_types() const {
    return data_->available_pointer_types;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPrimaryPointerType(UserType* output) const {
    auto data_value = data_->primary_pointer_type;
    return mojo::internal::Deserialize<::blink::mojom::PointerType>(
        data_value, output);
  }

  PointerType primary_pointer_type() const {
    return static_cast<PointerType>(data_->primary_pointer_type);
  }
  int32_t available_hover_types() const {
    return data_->available_hover_types;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPrimaryHoverType(UserType* output) const {
    auto data_value = data_->primary_hover_type;
    return mojo::internal::Deserialize<::blink::mojom::HoverType>(
        data_value, output);
  }

  HoverType primary_hover_type() const {
    return static_cast<HoverType>(data_->primary_hover_type);
  }
  bool dont_send_key_events_to_javascript() const {
    return data_->dont_send_key_events_to_javascript;
  }
  bool barrel_button_for_drag_enabled() const {
    return data_->barrel_button_for_drag_enabled;
  }
  bool sync_xhr_in_documents_enabled() const {
    return data_->sync_xhr_in_documents_enabled;
  }
  int32_t number_of_cpu_cores() const {
    return data_->number_of_cpu_cores;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEditingBehavior(UserType* output) const {
    auto data_value = data_->editing_behavior;
    return mojo::internal::Deserialize<::blink::mojom::EditingBehavior>(
        data_value, output);
  }

  EditingBehavior editing_behavior() const {
    return static_cast<EditingBehavior>(data_->editing_behavior);
  }
  bool supports_multiple_windows() const {
    return data_->supports_multiple_windows;
  }
  bool viewport_enabled() const {
    return data_->viewport_enabled;
  }
  bool viewport_meta_enabled() const {
    return data_->viewport_meta_enabled;
  }
  bool shrinks_viewport_contents_to_fit() const {
    return data_->shrinks_viewport_contents_to_fit;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadViewportStyle(UserType* output) const {
    auto data_value = data_->viewport_style;
    return mojo::internal::Deserialize<::blink::mojom::ViewportStyle>(
        data_value, output);
  }

  ViewportStyle viewport_style() const {
    return static_cast<ViewportStyle>(data_->viewport_style);
  }
  bool smooth_scroll_for_find_enabled() const {
    return data_->smooth_scroll_for_find_enabled;
  }
  bool main_frame_resizes_are_orientation_changes() const {
    return data_->main_frame_resizes_are_orientation_changes;
  }
  bool initialize_at_minimum_page_scale() const {
    return data_->initialize_at_minimum_page_scale;
  }
  bool smart_insert_delete_enabled() const {
    return data_->smart_insert_delete_enabled;
  }
  bool spatial_navigation_enabled() const {
    return data_->spatial_navigation_enabled;
  }
  bool navigate_on_drag_drop() const {
    return data_->navigate_on_drag_drop;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadV8CacheOptions(UserType* output) const {
    auto data_value = data_->v8_cache_options;
    return mojo::internal::Deserialize<::blink::mojom::V8CacheOptions>(
        data_value, output);
  }

  ::blink::mojom::V8CacheOptions v8_cache_options() const {
    return static_cast<::blink::mojom::V8CacheOptions>(data_->v8_cache_options);
  }
  bool record_whole_document() const {
    return data_->record_whole_document;
  }
  bool cookie_enabled() const {
    return data_->cookie_enabled;
  }
  bool accelerated_video_decode_enabled() const {
    return data_->accelerated_video_decode_enabled;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAnimationPolicy(UserType* output) const {
    auto data_value = data_->animation_policy;
    return mojo::internal::Deserialize<::blink::mojom::ImageAnimationPolicy>(
        data_value, output);
  }

  ImageAnimationPolicy animation_policy() const {
    return static_cast<ImageAnimationPolicy>(data_->animation_policy);
  }
  bool user_gesture_required_for_presentation() const {
    return data_->user_gesture_required_for_presentation;
  }
  bool text_tracks_enabled() const {
    return data_->text_tracks_enabled;
  }
  inline void GetTextTrackBackgroundColorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTextTrackBackgroundColor(UserType* output) {
    
    auto* pointer = data_->text_track_background_color.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetTextTrackTextColorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTextTrackTextColor(UserType* output) {
    
    auto* pointer = data_->text_track_text_color.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetTextTrackTextSizeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTextTrackTextSize(UserType* output) {
    
    auto* pointer = data_->text_track_text_size.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetTextTrackTextShadowDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTextTrackTextShadow(UserType* output) {
    
    auto* pointer = data_->text_track_text_shadow.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetTextTrackFontFamilyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTextTrackFontFamily(UserType* output) {
    
    auto* pointer = data_->text_track_font_family.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetTextTrackFontStyleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTextTrackFontStyle(UserType* output) {
    
    auto* pointer = data_->text_track_font_style.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetTextTrackFontVariantDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTextTrackFontVariant(UserType* output) {
    
    auto* pointer = data_->text_track_font_variant.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetTextTrackWindowColorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTextTrackWindowColor(UserType* output) {
    
    auto* pointer = data_->text_track_window_color.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetTextTrackWindowPaddingDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTextTrackWindowPadding(UserType* output) {
    
    auto* pointer = data_->text_track_window_padding.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetTextTrackWindowRadiusDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTextTrackWindowRadius(UserType* output) {
    
    auto* pointer = data_->text_track_window_radius.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  float text_track_margin_percentage() const {
    return data_->text_track_margin_percentage;
  }
  bool immersive_mode_enabled() const {
    return data_->immersive_mode_enabled;
  }
  bool double_tap_to_zoom_enabled() const {
    return data_->double_tap_to_zoom_enabled;
  }
  bool fullscreen_supported() const {
    return data_->fullscreen_supported;
  }
  bool text_autosizing_enabled() const {
    return data_->text_autosizing_enabled;
  }
  inline void GetWebAppScopeDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadWebAppScope(UserType* output) {
    
    auto* pointer = data_->web_app_scope.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  bool force_dark_mode_enabled() const {
    return data_->force_dark_mode_enabled;
  }
  float default_minimum_page_scale_factor() const {
    return data_->default_minimum_page_scale_factor;
  }
  float default_maximum_page_scale_factor() const {
    return data_->default_maximum_page_scale_factor;
  }
  bool hide_download_ui() const {
    return data_->hide_download_ui;
  }
  bool presentation_receiver() const {
    return data_->presentation_receiver;
  }
  bool media_controls_enabled() const {
    return data_->media_controls_enabled;
  }
  bool do_not_update_selection_on_mutating_selection_range() const {
    return data_->do_not_update_selection_on_mutating_selection_range;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAutoplayPolicy(UserType* output) const {
    auto data_value = data_->autoplay_policy;
    return mojo::internal::Deserialize<::blink::mojom::AutoplayPolicy>(
        data_value, output);
  }

  AutoplayPolicy autoplay_policy() const {
    return static_cast<AutoplayPolicy>(data_->autoplay_policy);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPreferredColorScheme(UserType* output) const {
    auto data_value = data_->preferred_color_scheme;
    return mojo::internal::Deserialize<::blink::mojom::PreferredColorScheme>(
        data_value, output);
  }

  PreferredColorScheme preferred_color_scheme() const {
    return static_cast<PreferredColorScheme>(data_->preferred_color_scheme);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLowPriorityIframesThreshold(UserType* output) const {
    auto data_value = data_->low_priority_iframes_threshold;
    return mojo::internal::Deserialize<::blink::mojom::EffectiveConnectionType>(
        data_value, output);
  }

  EffectiveConnectionType low_priority_iframes_threshold() const {
    return static_cast<EffectiveConnectionType>(data_->low_priority_iframes_threshold);
  }
  bool picture_in_picture_enabled() const {
    return data_->picture_in_picture_enabled;
  }
  bool translate_service_available() const {
    return data_->translate_service_available;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNetworkQualityEstimatorWebHoldback(UserType* output) const {
    auto data_value = data_->network_quality_estimator_web_holdback;
    return mojo::internal::Deserialize<::blink::mojom::EffectiveConnectionType>(
        data_value, output);
  }

  EffectiveConnectionType network_quality_estimator_web_holdback() const {
    return static_cast<EffectiveConnectionType>(data_->network_quality_estimator_web_holdback);
  }
  bool lazy_load_enabled() const {
    return data_->lazy_load_enabled;
  }
  inline void GetLazyFrameLoadingDistanceThresholdsPxDataView(
      mojo::MapDataView<EffectiveConnectionType, int32_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLazyFrameLoadingDistanceThresholdsPx(UserType* output) {
    
    auto* pointer = data_->lazy_frame_loading_distance_thresholds_px.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::blink::mojom::EffectiveConnectionType, int32_t>>(
        pointer, output, context_);
  }
  inline void GetLazyImageLoadingDistanceThresholdsPxDataView(
      mojo::MapDataView<EffectiveConnectionType, int32_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLazyImageLoadingDistanceThresholdsPx(UserType* output) {
    
    auto* pointer = data_->lazy_image_loading_distance_thresholds_px.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::blink::mojom::EffectiveConnectionType, int32_t>>(
        pointer, output, context_);
  }
  inline void GetLazyImageFirstKFullyLoadDataView(
      mojo::MapDataView<EffectiveConnectionType, int32_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLazyImageFirstKFullyLoad(UserType* output) {
    
    auto* pointer = data_->lazy_image_first_k_fully_load.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::blink::mojom::EffectiveConnectionType, int32_t>>(
        pointer, output, context_);
  }
  bool allow_mixed_content_upgrades() const {
    return data_->allow_mixed_content_upgrades;
  }
  bool always_show_focus() const {
    return data_->always_show_focus;
  }
  bool touch_drag_drop_enabled() const {
    return data_->touch_drag_drop_enabled;
  }
 private:
  internal::WebPreferences_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::PointerType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::PointerType> {};

template <>
struct hash<::blink::mojom::HoverType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::HoverType> {};

template <>
struct hash<::blink::mojom::PreferredColorScheme>
    : public mojo::internal::EnumHashImpl<::blink::mojom::PreferredColorScheme> {};

template <>
struct hash<::blink::mojom::EditingBehavior>
    : public mojo::internal::EnumHashImpl<::blink::mojom::EditingBehavior> {};

template <>
struct hash<::blink::mojom::ImageAnimationPolicy>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ImageAnimationPolicy> {};

template <>
struct hash<::blink::mojom::ViewportStyle>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ViewportStyle> {};

template <>
struct hash<::blink::mojom::AutoplayPolicy>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AutoplayPolicy> {};

template <>
struct hash<::blink::mojom::EffectiveConnectionType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::EffectiveConnectionType> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::PointerType, ::blink::mojom::PointerType> {
  static ::blink::mojom::PointerType ToMojom(::blink::mojom::PointerType input) { return input; }
  static bool FromMojom(::blink::mojom::PointerType input, ::blink::mojom::PointerType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PointerType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::PointerType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::PointerType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::blink::mojom::HoverType, ::blink::mojom::HoverType> {
  static ::blink::mojom::HoverType ToMojom(::blink::mojom::HoverType input) { return input; }
  static bool FromMojom(::blink::mojom::HoverType input, ::blink::mojom::HoverType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::HoverType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::HoverType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::HoverType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::blink::mojom::PreferredColorScheme, ::blink::mojom::PreferredColorScheme> {
  static ::blink::mojom::PreferredColorScheme ToMojom(::blink::mojom::PreferredColorScheme input) { return input; }
  static bool FromMojom(::blink::mojom::PreferredColorScheme input, ::blink::mojom::PreferredColorScheme* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PreferredColorScheme, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::PreferredColorScheme, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::PreferredColorScheme>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::blink::mojom::EditingBehavior, ::blink::mojom::EditingBehavior> {
  static ::blink::mojom::EditingBehavior ToMojom(::blink::mojom::EditingBehavior input) { return input; }
  static bool FromMojom(::blink::mojom::EditingBehavior input, ::blink::mojom::EditingBehavior* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::EditingBehavior, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::EditingBehavior, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::EditingBehavior>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::blink::mojom::ImageAnimationPolicy, ::blink::mojom::ImageAnimationPolicy> {
  static ::blink::mojom::ImageAnimationPolicy ToMojom(::blink::mojom::ImageAnimationPolicy input) { return input; }
  static bool FromMojom(::blink::mojom::ImageAnimationPolicy input, ::blink::mojom::ImageAnimationPolicy* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ImageAnimationPolicy, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ImageAnimationPolicy, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::ImageAnimationPolicy>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::blink::mojom::ViewportStyle, ::blink::mojom::ViewportStyle> {
  static ::blink::mojom::ViewportStyle ToMojom(::blink::mojom::ViewportStyle input) { return input; }
  static bool FromMojom(::blink::mojom::ViewportStyle input, ::blink::mojom::ViewportStyle* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ViewportStyle, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ViewportStyle, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::ViewportStyle>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::blink::mojom::AutoplayPolicy, ::blink::mojom::AutoplayPolicy> {
  static ::blink::mojom::AutoplayPolicy ToMojom(::blink::mojom::AutoplayPolicy input) { return input; }
  static bool FromMojom(::blink::mojom::AutoplayPolicy input, ::blink::mojom::AutoplayPolicy* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AutoplayPolicy, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AutoplayPolicy, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::AutoplayPolicy>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::blink::mojom::EffectiveConnectionType, ::blink::mojom::EffectiveConnectionType> {
  static ::blink::mojom::EffectiveConnectionType ToMojom(::blink::mojom::EffectiveConnectionType input) { return input; }
  static bool FromMojom(::blink::mojom::EffectiveConnectionType input, ::blink::mojom::EffectiveConnectionType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::EffectiveConnectionType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::EffectiveConnectionType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::EffectiveConnectionType>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPreferencesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebPreferencesDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::WebPreferences_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::standard_font_family_map(input)) in_standard_font_family_map = Traits::standard_font_family_map(input);
    typename decltype((*output)->standard_font_family_map)::BaseType::BufferWriter
        standard_font_family_map_writer;
    const mojo::internal::ContainerValidateParams standard_font_family_map_validate_params(
        new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        in_standard_font_family_map, buffer, &standard_font_family_map_writer, &standard_font_family_map_validate_params,
        context);
    (*output)->standard_font_family_map.Set(
        standard_font_family_map_writer.is_null() ? nullptr : standard_font_family_map_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->standard_font_family_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null standard_font_family_map in WebPreferences struct");
    decltype(Traits::fixed_font_family_map(input)) in_fixed_font_family_map = Traits::fixed_font_family_map(input);
    typename decltype((*output)->fixed_font_family_map)::BaseType::BufferWriter
        fixed_font_family_map_writer;
    const mojo::internal::ContainerValidateParams fixed_font_family_map_validate_params(
        new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        in_fixed_font_family_map, buffer, &fixed_font_family_map_writer, &fixed_font_family_map_validate_params,
        context);
    (*output)->fixed_font_family_map.Set(
        fixed_font_family_map_writer.is_null() ? nullptr : fixed_font_family_map_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->fixed_font_family_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fixed_font_family_map in WebPreferences struct");
    decltype(Traits::serif_font_family_map(input)) in_serif_font_family_map = Traits::serif_font_family_map(input);
    typename decltype((*output)->serif_font_family_map)::BaseType::BufferWriter
        serif_font_family_map_writer;
    const mojo::internal::ContainerValidateParams serif_font_family_map_validate_params(
        new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        in_serif_font_family_map, buffer, &serif_font_family_map_writer, &serif_font_family_map_validate_params,
        context);
    (*output)->serif_font_family_map.Set(
        serif_font_family_map_writer.is_null() ? nullptr : serif_font_family_map_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->serif_font_family_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null serif_font_family_map in WebPreferences struct");
    decltype(Traits::sans_serif_font_family_map(input)) in_sans_serif_font_family_map = Traits::sans_serif_font_family_map(input);
    typename decltype((*output)->sans_serif_font_family_map)::BaseType::BufferWriter
        sans_serif_font_family_map_writer;
    const mojo::internal::ContainerValidateParams sans_serif_font_family_map_validate_params(
        new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        in_sans_serif_font_family_map, buffer, &sans_serif_font_family_map_writer, &sans_serif_font_family_map_validate_params,
        context);
    (*output)->sans_serif_font_family_map.Set(
        sans_serif_font_family_map_writer.is_null() ? nullptr : sans_serif_font_family_map_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->sans_serif_font_family_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sans_serif_font_family_map in WebPreferences struct");
    decltype(Traits::cursive_font_family_map(input)) in_cursive_font_family_map = Traits::cursive_font_family_map(input);
    typename decltype((*output)->cursive_font_family_map)::BaseType::BufferWriter
        cursive_font_family_map_writer;
    const mojo::internal::ContainerValidateParams cursive_font_family_map_validate_params(
        new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        in_cursive_font_family_map, buffer, &cursive_font_family_map_writer, &cursive_font_family_map_validate_params,
        context);
    (*output)->cursive_font_family_map.Set(
        cursive_font_family_map_writer.is_null() ? nullptr : cursive_font_family_map_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->cursive_font_family_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cursive_font_family_map in WebPreferences struct");
    decltype(Traits::fantasy_font_family_map(input)) in_fantasy_font_family_map = Traits::fantasy_font_family_map(input);
    typename decltype((*output)->fantasy_font_family_map)::BaseType::BufferWriter
        fantasy_font_family_map_writer;
    const mojo::internal::ContainerValidateParams fantasy_font_family_map_validate_params(
        new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        in_fantasy_font_family_map, buffer, &fantasy_font_family_map_writer, &fantasy_font_family_map_validate_params,
        context);
    (*output)->fantasy_font_family_map.Set(
        fantasy_font_family_map_writer.is_null() ? nullptr : fantasy_font_family_map_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->fantasy_font_family_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fantasy_font_family_map in WebPreferences struct");
    decltype(Traits::pictograph_font_family_map(input)) in_pictograph_font_family_map = Traits::pictograph_font_family_map(input);
    typename decltype((*output)->pictograph_font_family_map)::BaseType::BufferWriter
        pictograph_font_family_map_writer;
    const mojo::internal::ContainerValidateParams pictograph_font_family_map_validate_params(
        new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        in_pictograph_font_family_map, buffer, &pictograph_font_family_map_writer, &pictograph_font_family_map_validate_params,
        context);
    (*output)->pictograph_font_family_map.Set(
        pictograph_font_family_map_writer.is_null() ? nullptr : pictograph_font_family_map_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->pictograph_font_family_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pictograph_font_family_map in WebPreferences struct");
    (*output)->default_font_size = Traits::default_font_size(input);
    (*output)->default_fixed_font_size = Traits::default_fixed_font_size(input);
    (*output)->minimum_font_size = Traits::minimum_font_size(input);
    (*output)->minimum_logical_font_size = Traits::minimum_logical_font_size(input);
    decltype(Traits::default_encoding(input)) in_default_encoding = Traits::default_encoding(input);
    typename decltype((*output)->default_encoding)::BaseType::BufferWriter
        default_encoding_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_default_encoding, buffer, &default_encoding_writer, context);
    (*output)->default_encoding.Set(
        default_encoding_writer.is_null() ? nullptr : default_encoding_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->default_encoding.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null default_encoding in WebPreferences struct");
    (*output)->context_menu_on_mouse_up = Traits::context_menu_on_mouse_up(input);
    (*output)->javascript_enabled = Traits::javascript_enabled(input);
    (*output)->web_security_enabled = Traits::web_security_enabled(input);
    (*output)->loads_images_automatically = Traits::loads_images_automatically(input);
    (*output)->images_enabled = Traits::images_enabled(input);
    (*output)->plugins_enabled = Traits::plugins_enabled(input);
    (*output)->dom_paste_enabled = Traits::dom_paste_enabled(input);
    (*output)->shrinks_standalone_images_to_fit = Traits::shrinks_standalone_images_to_fit(input);
    (*output)->text_areas_are_resizable = Traits::text_areas_are_resizable(input);
    (*output)->allow_scripts_to_close_windows = Traits::allow_scripts_to_close_windows(input);
    (*output)->remote_fonts_enabled = Traits::remote_fonts_enabled(input);
    (*output)->javascript_can_access_clipboard = Traits::javascript_can_access_clipboard(input);
    (*output)->xslt_enabled = Traits::xslt_enabled(input);
    (*output)->dns_prefetching_enabled = Traits::dns_prefetching_enabled(input);
    (*output)->data_saver_enabled = Traits::data_saver_enabled(input);
    (*output)->data_saver_holdback_web_api_enabled = Traits::data_saver_holdback_web_api_enabled(input);
    (*output)->local_storage_enabled = Traits::local_storage_enabled(input);
    (*output)->databases_enabled = Traits::databases_enabled(input);
    (*output)->application_cache_enabled = Traits::application_cache_enabled(input);
    (*output)->tabs_to_links = Traits::tabs_to_links(input);
    (*output)->disable_ipc_flooding_protection = Traits::disable_ipc_flooding_protection(input);
    (*output)->hyperlink_auditing_enabled = Traits::hyperlink_auditing_enabled(input);
    (*output)->allow_universal_access_from_file_urls = Traits::allow_universal_access_from_file_urls(input);
    (*output)->allow_file_access_from_file_urls = Traits::allow_file_access_from_file_urls(input);
    (*output)->webgl1_enabled = Traits::webgl1_enabled(input);
    (*output)->webgl2_enabled = Traits::webgl2_enabled(input);
    (*output)->pepper_3d_enabled = Traits::pepper_3d_enabled(input);
    (*output)->flash_3d_enabled = Traits::flash_3d_enabled(input);
    (*output)->flash_stage3d_enabled = Traits::flash_stage3d_enabled(input);
    (*output)->flash_stage3d_baseline_enabled = Traits::flash_stage3d_baseline_enabled(input);
    (*output)->privileged_webgl_extensions_enabled = Traits::privileged_webgl_extensions_enabled(input);
    (*output)->webgl_errors_to_console_enabled = Traits::webgl_errors_to_console_enabled(input);
    (*output)->hide_scrollbars = Traits::hide_scrollbars(input);
    (*output)->accelerated_2d_canvas_enabled = Traits::accelerated_2d_canvas_enabled(input);
    (*output)->new_canvas_2d_api_enabled = Traits::new_canvas_2d_api_enabled(input);
    (*output)->antialiased_2d_canvas_disabled = Traits::antialiased_2d_canvas_disabled(input);
    (*output)->antialiased_clips_2d_canvas_enabled = Traits::antialiased_clips_2d_canvas_enabled(input);
    (*output)->accelerated_filters_enabled = Traits::accelerated_filters_enabled(input);
    (*output)->deferred_filters_enabled = Traits::deferred_filters_enabled(input);
    (*output)->container_culling_enabled = Traits::container_culling_enabled(input);
    (*output)->allow_running_insecure_content = Traits::allow_running_insecure_content(input);
    (*output)->disable_reading_from_canvas = Traits::disable_reading_from_canvas(input);
    (*output)->strict_mixed_content_checking = Traits::strict_mixed_content_checking(input);
    (*output)->strict_powerful_feature_restrictions = Traits::strict_powerful_feature_restrictions(input);
    (*output)->allow_geolocation_on_insecure_origins = Traits::allow_geolocation_on_insecure_origins(input);
    (*output)->strictly_block_blockable_mixed_content = Traits::strictly_block_blockable_mixed_content(input);
    (*output)->block_mixed_plugin_content = Traits::block_mixed_plugin_content(input);
    (*output)->password_echo_enabled = Traits::password_echo_enabled(input);
    (*output)->should_clear_document_background = Traits::should_clear_document_background(input);
    (*output)->enable_scroll_animator = Traits::enable_scroll_animator(input);
    (*output)->prefers_reduced_motion = Traits::prefers_reduced_motion(input);
    (*output)->touch_event_feature_detection_enabled = Traits::touch_event_feature_detection_enabled(input);
    (*output)->enable_error_page = Traits::enable_error_page(input);
    (*output)->pointer_events_max_touch_points = Traits::pointer_events_max_touch_points(input);
    (*output)->available_pointer_types = Traits::available_pointer_types(input);
    mojo::internal::Serialize<::blink::mojom::PointerType>(
        Traits::primary_pointer_type(input), &(*output)->primary_pointer_type);
    (*output)->available_hover_types = Traits::available_hover_types(input);
    mojo::internal::Serialize<::blink::mojom::HoverType>(
        Traits::primary_hover_type(input), &(*output)->primary_hover_type);
    (*output)->dont_send_key_events_to_javascript = Traits::dont_send_key_events_to_javascript(input);
    (*output)->barrel_button_for_drag_enabled = Traits::barrel_button_for_drag_enabled(input);
    (*output)->sync_xhr_in_documents_enabled = Traits::sync_xhr_in_documents_enabled(input);
    (*output)->number_of_cpu_cores = Traits::number_of_cpu_cores(input);
    mojo::internal::Serialize<::blink::mojom::EditingBehavior>(
        Traits::editing_behavior(input), &(*output)->editing_behavior);
    (*output)->supports_multiple_windows = Traits::supports_multiple_windows(input);
    (*output)->viewport_enabled = Traits::viewport_enabled(input);
    (*output)->viewport_meta_enabled = Traits::viewport_meta_enabled(input);
    (*output)->shrinks_viewport_contents_to_fit = Traits::shrinks_viewport_contents_to_fit(input);
    mojo::internal::Serialize<::blink::mojom::ViewportStyle>(
        Traits::viewport_style(input), &(*output)->viewport_style);
    (*output)->smooth_scroll_for_find_enabled = Traits::smooth_scroll_for_find_enabled(input);
    (*output)->main_frame_resizes_are_orientation_changes = Traits::main_frame_resizes_are_orientation_changes(input);
    (*output)->initialize_at_minimum_page_scale = Traits::initialize_at_minimum_page_scale(input);
    (*output)->smart_insert_delete_enabled = Traits::smart_insert_delete_enabled(input);
    (*output)->spatial_navigation_enabled = Traits::spatial_navigation_enabled(input);
    (*output)->navigate_on_drag_drop = Traits::navigate_on_drag_drop(input);
    mojo::internal::Serialize<::blink::mojom::V8CacheOptions>(
        Traits::v8_cache_options(input), &(*output)->v8_cache_options);
    (*output)->record_whole_document = Traits::record_whole_document(input);
    (*output)->cookie_enabled = Traits::cookie_enabled(input);
    (*output)->accelerated_video_decode_enabled = Traits::accelerated_video_decode_enabled(input);
    mojo::internal::Serialize<::blink::mojom::ImageAnimationPolicy>(
        Traits::animation_policy(input), &(*output)->animation_policy);
    (*output)->user_gesture_required_for_presentation = Traits::user_gesture_required_for_presentation(input);
    (*output)->text_tracks_enabled = Traits::text_tracks_enabled(input);
    decltype(Traits::text_track_background_color(input)) in_text_track_background_color = Traits::text_track_background_color(input);
    typename decltype((*output)->text_track_background_color)::BaseType::BufferWriter
        text_track_background_color_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_text_track_background_color, buffer, &text_track_background_color_writer, context);
    (*output)->text_track_background_color.Set(
        text_track_background_color_writer.is_null() ? nullptr : text_track_background_color_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->text_track_background_color.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_background_color in WebPreferences struct");
    decltype(Traits::text_track_text_color(input)) in_text_track_text_color = Traits::text_track_text_color(input);
    typename decltype((*output)->text_track_text_color)::BaseType::BufferWriter
        text_track_text_color_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_text_track_text_color, buffer, &text_track_text_color_writer, context);
    (*output)->text_track_text_color.Set(
        text_track_text_color_writer.is_null() ? nullptr : text_track_text_color_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->text_track_text_color.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_text_color in WebPreferences struct");
    decltype(Traits::text_track_text_size(input)) in_text_track_text_size = Traits::text_track_text_size(input);
    typename decltype((*output)->text_track_text_size)::BaseType::BufferWriter
        text_track_text_size_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_text_track_text_size, buffer, &text_track_text_size_writer, context);
    (*output)->text_track_text_size.Set(
        text_track_text_size_writer.is_null() ? nullptr : text_track_text_size_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->text_track_text_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_text_size in WebPreferences struct");
    decltype(Traits::text_track_text_shadow(input)) in_text_track_text_shadow = Traits::text_track_text_shadow(input);
    typename decltype((*output)->text_track_text_shadow)::BaseType::BufferWriter
        text_track_text_shadow_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_text_track_text_shadow, buffer, &text_track_text_shadow_writer, context);
    (*output)->text_track_text_shadow.Set(
        text_track_text_shadow_writer.is_null() ? nullptr : text_track_text_shadow_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->text_track_text_shadow.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_text_shadow in WebPreferences struct");
    decltype(Traits::text_track_font_family(input)) in_text_track_font_family = Traits::text_track_font_family(input);
    typename decltype((*output)->text_track_font_family)::BaseType::BufferWriter
        text_track_font_family_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_text_track_font_family, buffer, &text_track_font_family_writer, context);
    (*output)->text_track_font_family.Set(
        text_track_font_family_writer.is_null() ? nullptr : text_track_font_family_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->text_track_font_family.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_font_family in WebPreferences struct");
    decltype(Traits::text_track_font_style(input)) in_text_track_font_style = Traits::text_track_font_style(input);
    typename decltype((*output)->text_track_font_style)::BaseType::BufferWriter
        text_track_font_style_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_text_track_font_style, buffer, &text_track_font_style_writer, context);
    (*output)->text_track_font_style.Set(
        text_track_font_style_writer.is_null() ? nullptr : text_track_font_style_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->text_track_font_style.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_font_style in WebPreferences struct");
    decltype(Traits::text_track_font_variant(input)) in_text_track_font_variant = Traits::text_track_font_variant(input);
    typename decltype((*output)->text_track_font_variant)::BaseType::BufferWriter
        text_track_font_variant_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_text_track_font_variant, buffer, &text_track_font_variant_writer, context);
    (*output)->text_track_font_variant.Set(
        text_track_font_variant_writer.is_null() ? nullptr : text_track_font_variant_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->text_track_font_variant.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_font_variant in WebPreferences struct");
    decltype(Traits::text_track_window_color(input)) in_text_track_window_color = Traits::text_track_window_color(input);
    typename decltype((*output)->text_track_window_color)::BaseType::BufferWriter
        text_track_window_color_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_text_track_window_color, buffer, &text_track_window_color_writer, context);
    (*output)->text_track_window_color.Set(
        text_track_window_color_writer.is_null() ? nullptr : text_track_window_color_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->text_track_window_color.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_window_color in WebPreferences struct");
    decltype(Traits::text_track_window_padding(input)) in_text_track_window_padding = Traits::text_track_window_padding(input);
    typename decltype((*output)->text_track_window_padding)::BaseType::BufferWriter
        text_track_window_padding_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_text_track_window_padding, buffer, &text_track_window_padding_writer, context);
    (*output)->text_track_window_padding.Set(
        text_track_window_padding_writer.is_null() ? nullptr : text_track_window_padding_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->text_track_window_padding.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_window_padding in WebPreferences struct");
    decltype(Traits::text_track_window_radius(input)) in_text_track_window_radius = Traits::text_track_window_radius(input);
    typename decltype((*output)->text_track_window_radius)::BaseType::BufferWriter
        text_track_window_radius_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_text_track_window_radius, buffer, &text_track_window_radius_writer, context);
    (*output)->text_track_window_radius.Set(
        text_track_window_radius_writer.is_null() ? nullptr : text_track_window_radius_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->text_track_window_radius.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_window_radius in WebPreferences struct");
    (*output)->text_track_margin_percentage = Traits::text_track_margin_percentage(input);
    (*output)->immersive_mode_enabled = Traits::immersive_mode_enabled(input);
    (*output)->double_tap_to_zoom_enabled = Traits::double_tap_to_zoom_enabled(input);
    (*output)->fullscreen_supported = Traits::fullscreen_supported(input);
    (*output)->text_autosizing_enabled = Traits::text_autosizing_enabled(input);
    decltype(Traits::web_app_scope(input)) in_web_app_scope = Traits::web_app_scope(input);
    typename decltype((*output)->web_app_scope)::BaseType::BufferWriter
        web_app_scope_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_web_app_scope, buffer, &web_app_scope_writer, context);
    (*output)->web_app_scope.Set(
        web_app_scope_writer.is_null() ? nullptr : web_app_scope_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->web_app_scope.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null web_app_scope in WebPreferences struct");
    (*output)->force_dark_mode_enabled = Traits::force_dark_mode_enabled(input);
    (*output)->default_minimum_page_scale_factor = Traits::default_minimum_page_scale_factor(input);
    (*output)->default_maximum_page_scale_factor = Traits::default_maximum_page_scale_factor(input);
    (*output)->hide_download_ui = Traits::hide_download_ui(input);
    (*output)->presentation_receiver = Traits::presentation_receiver(input);
    (*output)->media_controls_enabled = Traits::media_controls_enabled(input);
    (*output)->do_not_update_selection_on_mutating_selection_range = Traits::do_not_update_selection_on_mutating_selection_range(input);
    mojo::internal::Serialize<::blink::mojom::AutoplayPolicy>(
        Traits::autoplay_policy(input), &(*output)->autoplay_policy);
    mojo::internal::Serialize<::blink::mojom::PreferredColorScheme>(
        Traits::preferred_color_scheme(input), &(*output)->preferred_color_scheme);
    mojo::internal::Serialize<::blink::mojom::EffectiveConnectionType>(
        Traits::low_priority_iframes_threshold(input), &(*output)->low_priority_iframes_threshold);
    (*output)->picture_in_picture_enabled = Traits::picture_in_picture_enabled(input);
    (*output)->translate_service_available = Traits::translate_service_available(input);
    mojo::internal::Serialize<::blink::mojom::EffectiveConnectionType>(
        Traits::network_quality_estimator_web_holdback(input), &(*output)->network_quality_estimator_web_holdback);
    (*output)->lazy_load_enabled = Traits::lazy_load_enabled(input);
    decltype(Traits::lazy_frame_loading_distance_thresholds_px(input)) in_lazy_frame_loading_distance_thresholds_px = Traits::lazy_frame_loading_distance_thresholds_px(input);
    typename decltype((*output)->lazy_frame_loading_distance_thresholds_px)::BaseType::BufferWriter
        lazy_frame_loading_distance_thresholds_px_writer;
    const mojo::internal::ContainerValidateParams lazy_frame_loading_distance_thresholds_px_validate_params(
        new mojo::internal::ContainerValidateParams(0, ::blink::mojom::internal::EffectiveConnectionType_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::MapDataView<::blink::mojom::EffectiveConnectionType, int32_t>>(
        in_lazy_frame_loading_distance_thresholds_px, buffer, &lazy_frame_loading_distance_thresholds_px_writer, &lazy_frame_loading_distance_thresholds_px_validate_params,
        context);
    (*output)->lazy_frame_loading_distance_thresholds_px.Set(
        lazy_frame_loading_distance_thresholds_px_writer.is_null() ? nullptr : lazy_frame_loading_distance_thresholds_px_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->lazy_frame_loading_distance_thresholds_px.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lazy_frame_loading_distance_thresholds_px in WebPreferences struct");
    decltype(Traits::lazy_image_loading_distance_thresholds_px(input)) in_lazy_image_loading_distance_thresholds_px = Traits::lazy_image_loading_distance_thresholds_px(input);
    typename decltype((*output)->lazy_image_loading_distance_thresholds_px)::BaseType::BufferWriter
        lazy_image_loading_distance_thresholds_px_writer;
    const mojo::internal::ContainerValidateParams lazy_image_loading_distance_thresholds_px_validate_params(
        new mojo::internal::ContainerValidateParams(0, ::blink::mojom::internal::EffectiveConnectionType_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::MapDataView<::blink::mojom::EffectiveConnectionType, int32_t>>(
        in_lazy_image_loading_distance_thresholds_px, buffer, &lazy_image_loading_distance_thresholds_px_writer, &lazy_image_loading_distance_thresholds_px_validate_params,
        context);
    (*output)->lazy_image_loading_distance_thresholds_px.Set(
        lazy_image_loading_distance_thresholds_px_writer.is_null() ? nullptr : lazy_image_loading_distance_thresholds_px_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->lazy_image_loading_distance_thresholds_px.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lazy_image_loading_distance_thresholds_px in WebPreferences struct");
    decltype(Traits::lazy_image_first_k_fully_load(input)) in_lazy_image_first_k_fully_load = Traits::lazy_image_first_k_fully_load(input);
    typename decltype((*output)->lazy_image_first_k_fully_load)::BaseType::BufferWriter
        lazy_image_first_k_fully_load_writer;
    const mojo::internal::ContainerValidateParams lazy_image_first_k_fully_load_validate_params(
        new mojo::internal::ContainerValidateParams(0, ::blink::mojom::internal::EffectiveConnectionType_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::MapDataView<::blink::mojom::EffectiveConnectionType, int32_t>>(
        in_lazy_image_first_k_fully_load, buffer, &lazy_image_first_k_fully_load_writer, &lazy_image_first_k_fully_load_validate_params,
        context);
    (*output)->lazy_image_first_k_fully_load.Set(
        lazy_image_first_k_fully_load_writer.is_null() ? nullptr : lazy_image_first_k_fully_load_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->lazy_image_first_k_fully_load.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lazy_image_first_k_fully_load in WebPreferences struct");
    (*output)->allow_mixed_content_upgrades = Traits::allow_mixed_content_upgrades(input);
    (*output)->always_show_focus = Traits::always_show_focus(input);
    (*output)->touch_drag_drop_enabled = Traits::touch_drag_drop_enabled(input);
  }

  static bool Deserialize(::blink::mojom::internal::WebPreferences_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebPreferencesDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void WebPreferencesDataView::GetStandardFontFamilyMapDataView(
    mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->standard_font_family_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>(pointer, context_);
}
inline void WebPreferencesDataView::GetFixedFontFamilyMapDataView(
    mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->fixed_font_family_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>(pointer, context_);
}
inline void WebPreferencesDataView::GetSerifFontFamilyMapDataView(
    mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->serif_font_family_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>(pointer, context_);
}
inline void WebPreferencesDataView::GetSansSerifFontFamilyMapDataView(
    mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->sans_serif_font_family_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>(pointer, context_);
}
inline void WebPreferencesDataView::GetCursiveFontFamilyMapDataView(
    mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->cursive_font_family_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>(pointer, context_);
}
inline void WebPreferencesDataView::GetFantasyFontFamilyMapDataView(
    mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->fantasy_font_family_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>(pointer, context_);
}
inline void WebPreferencesDataView::GetPictographFontFamilyMapDataView(
    mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->pictograph_font_family_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>(pointer, context_);
}
inline void WebPreferencesDataView::GetDefaultEncodingDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->default_encoding.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void WebPreferencesDataView::GetTextTrackBackgroundColorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_track_background_color.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void WebPreferencesDataView::GetTextTrackTextColorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_track_text_color.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void WebPreferencesDataView::GetTextTrackTextSizeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_track_text_size.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void WebPreferencesDataView::GetTextTrackTextShadowDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_track_text_shadow.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void WebPreferencesDataView::GetTextTrackFontFamilyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_track_font_family.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void WebPreferencesDataView::GetTextTrackFontStyleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_track_font_style.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void WebPreferencesDataView::GetTextTrackFontVariantDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_track_font_variant.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void WebPreferencesDataView::GetTextTrackWindowColorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_track_window_color.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void WebPreferencesDataView::GetTextTrackWindowPaddingDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_track_window_padding.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void WebPreferencesDataView::GetTextTrackWindowRadiusDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_track_window_radius.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void WebPreferencesDataView::GetWebAppScopeDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->web_app_scope.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void WebPreferencesDataView::GetLazyFrameLoadingDistanceThresholdsPxDataView(
    mojo::MapDataView<EffectiveConnectionType, int32_t>* output) {
  auto pointer = data_->lazy_frame_loading_distance_thresholds_px.Get();
  *output = mojo::MapDataView<EffectiveConnectionType, int32_t>(pointer, context_);
}
inline void WebPreferencesDataView::GetLazyImageLoadingDistanceThresholdsPxDataView(
    mojo::MapDataView<EffectiveConnectionType, int32_t>* output) {
  auto pointer = data_->lazy_image_loading_distance_thresholds_px.Get();
  *output = mojo::MapDataView<EffectiveConnectionType, int32_t>(pointer, context_);
}
inline void WebPreferencesDataView::GetLazyImageFirstKFullyLoadDataView(
    mojo::MapDataView<EffectiveConnectionType, int32_t>* output) {
  auto pointer = data_->lazy_image_first_k_fully_load.Get();
  *output = mojo::MapDataView<EffectiveConnectionType, int32_t>(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBPREFERENCES_WEB_PREFERENCES_MOJOM_SHARED_H_