// automatically generated
/*
Copyright (c) 2018 Advanced Micro Devices, Inc. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef INC_HIP_OSTREAM_OPS_H_
#define INC_HIP_OSTREAM_OPS_H_

#include <hip/hip_runtime.h>
#include <hip/hip_deprecated.h>
#include "src/core/session/tracer/src/roctracer.h"

#ifdef __cplusplus
#include <iostream>
#include <string>

namespace roctracer {
namespace hip_support {
static int HIP_depth_max = 1;
static int HIP_depth_max_cnt = 0;
static std::string HIP_structs_regex = "";
// begin ostream ops for HIP 
// basic ostream ops
namespace detail {
template <typename T>
  inline static std::ostream& operator<<(std::ostream& out, const T& v) {
     using std::operator<<;
     static bool recursion = false;
     if (recursion == false) { recursion = true; out << v; recursion = false; }
     return out;
  }

  inline static std::ostream &operator<<(std::ostream &out, const unsigned char &v) {
    out << (unsigned int)v;
    return out;
  }

  inline static std::ostream &operator<<(std::ostream &out, const char &v) {
    out << (unsigned char)v;
    return out;
  }
// End of basic ostream ops

inline static std::ostream& operator<<(std::ostream& out, const div_t& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("div_t::rem").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "rem=");
      roctracer::hip_support::detail::operator<<(out, v.rem);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("div_t::quot").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "quot=");
      roctracer::hip_support::detail::operator<<(out, v.quot);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const ldiv_t& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("ldiv_t::rem").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "rem=");
      roctracer::hip_support::detail::operator<<(out, v.rem);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("ldiv_t::quot").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "quot=");
      roctracer::hip_support::detail::operator<<(out, v.quot);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const lldiv_t& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("lldiv_t::rem").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "rem=");
      roctracer::hip_support::detail::operator<<(out, v.rem);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("lldiv_t::quot").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "quot=");
      roctracer::hip_support::detail::operator<<(out, v.quot);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const timeval& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("timeval::tv_usec").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "tv_usec=");
      roctracer::hip_support::detail::operator<<(out, v.tv_usec);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("timeval::tv_sec").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "tv_sec=");
      roctracer::hip_support::detail::operator<<(out, v.tv_sec);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const timespec& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("timespec::tv_nsec").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "tv_nsec=");
      roctracer::hip_support::detail::operator<<(out, v.tv_nsec);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("timespec::tv_sec").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "tv_sec=");
      roctracer::hip_support::detail::operator<<(out, v.tv_sec);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const random_data& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("random_data::end_ptr").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "end_ptr=");
      roctracer::hip_support::detail::operator<<(out, v.end_ptr);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("random_data::rand_sep").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "rand_sep=");
      roctracer::hip_support::detail::operator<<(out, v.rand_sep);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("random_data::rand_deg").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "rand_deg=");
      roctracer::hip_support::detail::operator<<(out, v.rand_deg);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("random_data::rand_type").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "rand_type=");
      roctracer::hip_support::detail::operator<<(out, v.rand_type);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("random_data::state").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "state=");
      roctracer::hip_support::detail::operator<<(out, v.state);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("random_data::rptr").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "rptr=");
      roctracer::hip_support::detail::operator<<(out, v.rptr);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("random_data::fptr").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "fptr=");
      roctracer::hip_support::detail::operator<<(out, v.fptr);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const drand48_data& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("drand48_data::__a").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "__a=");
      roctracer::hip_support::detail::operator<<(out, v.__a);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("drand48_data::__init").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "__init=");
      roctracer::hip_support::detail::operator<<(out, v.__init);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("drand48_data::__c").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "__c=");
      roctracer::hip_support::detail::operator<<(out, v.__c);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("drand48_data::__old_x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "__old_x=");
      roctracer::hip_support::detail::operator<<(out, v.__old_x);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("drand48_data::__x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "__x=");
      roctracer::hip_support::detail::operator<<(out, v.__x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipDeviceArch_t& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipDeviceArch_t::hasDynamicParallelism").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hasDynamicParallelism=");
      roctracer::hip_support::detail::operator<<(out, v.hasDynamicParallelism);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceArch_t::has3dGrid").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "has3dGrid=");
      roctracer::hip_support::detail::operator<<(out, v.has3dGrid);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceArch_t::hasSurfaceFuncs").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hasSurfaceFuncs=");
      roctracer::hip_support::detail::operator<<(out, v.hasSurfaceFuncs);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceArch_t::hasSyncThreadsExt").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hasSyncThreadsExt=");
      roctracer::hip_support::detail::operator<<(out, v.hasSyncThreadsExt);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceArch_t::hasThreadFenceSystem").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hasThreadFenceSystem=");
      roctracer::hip_support::detail::operator<<(out, v.hasThreadFenceSystem);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceArch_t::hasFunnelShift").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hasFunnelShift=");
      roctracer::hip_support::detail::operator<<(out, v.hasFunnelShift);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceArch_t::hasWarpShuffle").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hasWarpShuffle=");
      roctracer::hip_support::detail::operator<<(out, v.hasWarpShuffle);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceArch_t::hasWarpBallot").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hasWarpBallot=");
      roctracer::hip_support::detail::operator<<(out, v.hasWarpBallot);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceArch_t::hasWarpVote").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hasWarpVote=");
      roctracer::hip_support::detail::operator<<(out, v.hasWarpVote);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceArch_t::hasDoubles").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hasDoubles=");
      roctracer::hip_support::detail::operator<<(out, v.hasDoubles);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceArch_t::hasSharedInt64Atomics").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hasSharedInt64Atomics=");
      roctracer::hip_support::detail::operator<<(out, v.hasSharedInt64Atomics);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceArch_t::hasGlobalInt64Atomics").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hasGlobalInt64Atomics=");
      roctracer::hip_support::detail::operator<<(out, v.hasGlobalInt64Atomics);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceArch_t::hasFloatAtomicAdd").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hasFloatAtomicAdd=");
      roctracer::hip_support::detail::operator<<(out, v.hasFloatAtomicAdd);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceArch_t::hasSharedFloatAtomicExch").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hasSharedFloatAtomicExch=");
      roctracer::hip_support::detail::operator<<(out, v.hasSharedFloatAtomicExch);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceArch_t::hasSharedInt32Atomics").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hasSharedInt32Atomics=");
      roctracer::hip_support::detail::operator<<(out, v.hasSharedInt32Atomics);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceArch_t::hasGlobalFloatAtomicExch").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hasGlobalFloatAtomicExch=");
      roctracer::hip_support::detail::operator<<(out, v.hasGlobalFloatAtomicExch);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceArch_t::hasGlobalInt32Atomics").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hasGlobalInt32Atomics=");
      roctracer::hip_support::detail::operator<<(out, v.hasGlobalInt32Atomics);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipUUID& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipUUID::bytes").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "bytes=");
      roctracer::hip_support::detail::operator<<(out, v.bytes);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipDeviceProp_tR0600& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipDeviceProp_tR0600::asicRevision").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "asicRevision=");
      roctracer::hip_support::detail::operator<<(out, v.asicRevision);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::isLargeBar").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "isLargeBar=");
      roctracer::hip_support::detail::operator<<(out, v.isLargeBar);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::cooperativeMultiDeviceUnmatchedSharedMem").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "cooperativeMultiDeviceUnmatchedSharedMem=");
      roctracer::hip_support::detail::operator<<(out, v.cooperativeMultiDeviceUnmatchedSharedMem);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::cooperativeMultiDeviceUnmatchedBlockDim").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "cooperativeMultiDeviceUnmatchedBlockDim=");
      roctracer::hip_support::detail::operator<<(out, v.cooperativeMultiDeviceUnmatchedBlockDim);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::cooperativeMultiDeviceUnmatchedGridDim").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "cooperativeMultiDeviceUnmatchedGridDim=");
      roctracer::hip_support::detail::operator<<(out, v.cooperativeMultiDeviceUnmatchedGridDim);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::cooperativeMultiDeviceUnmatchedFunc").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "cooperativeMultiDeviceUnmatchedFunc=");
      roctracer::hip_support::detail::operator<<(out, v.cooperativeMultiDeviceUnmatchedFunc);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::hdpRegFlushCntl").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hdpRegFlushCntl=");
      roctracer::hip_support::detail::operator<<(out, v.hdpRegFlushCntl);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::hdpMemFlushCntl").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hdpMemFlushCntl=");
      roctracer::hip_support::detail::operator<<(out, v.hdpMemFlushCntl);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::arch").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "arch=");
      roctracer::hip_support::detail::operator<<(out, v.arch);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::clockInstructionRate").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "clockInstructionRate=");
      roctracer::hip_support::detail::operator<<(out, v.clockInstructionRate);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxSharedMemoryPerMultiProcessor").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxSharedMemoryPerMultiProcessor=");
      roctracer::hip_support::detail::operator<<(out, v.maxSharedMemoryPerMultiProcessor);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::gcnArchName").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "gcnArchName=");
      roctracer::hip_support::detail::operator<<(out, v.gcnArchName);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::hipReserved").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hipReserved=");
      roctracer::hip_support::detail::operator<<(out, v.hipReserved);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::reserved").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "reserved=");
      roctracer::hip_support::detail::operator<<(out, v.reserved);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::unifiedFunctionPointers").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "unifiedFunctionPointers=");
      roctracer::hip_support::detail::operator<<(out, v.unifiedFunctionPointers);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::clusterLaunch").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "clusterLaunch=");
      roctracer::hip_support::detail::operator<<(out, v.clusterLaunch);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::ipcEventSupported").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "ipcEventSupported=");
      roctracer::hip_support::detail::operator<<(out, v.ipcEventSupported);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::deferredMappingHipArraySupported").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "deferredMappingHipArraySupported=");
      roctracer::hip_support::detail::operator<<(out, v.deferredMappingHipArraySupported);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::memoryPoolSupportedHandleTypes").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "memoryPoolSupportedHandleTypes=");
      roctracer::hip_support::detail::operator<<(out, v.memoryPoolSupportedHandleTypes);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::gpuDirectRDMAWritesOrdering").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "gpuDirectRDMAWritesOrdering=");
      roctracer::hip_support::detail::operator<<(out, v.gpuDirectRDMAWritesOrdering);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::gpuDirectRDMAFlushWritesOptions").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "gpuDirectRDMAFlushWritesOptions=");
      roctracer::hip_support::detail::operator<<(out, v.gpuDirectRDMAFlushWritesOptions);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::gpuDirectRDMASupported").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "gpuDirectRDMASupported=");
      roctracer::hip_support::detail::operator<<(out, v.gpuDirectRDMASupported);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::memoryPoolsSupported").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "memoryPoolsSupported=");
      roctracer::hip_support::detail::operator<<(out, v.memoryPoolsSupported);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::timelineSemaphoreInteropSupported").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "timelineSemaphoreInteropSupported=");
      roctracer::hip_support::detail::operator<<(out, v.timelineSemaphoreInteropSupported);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::hostRegisterReadOnlySupported").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hostRegisterReadOnlySupported=");
      roctracer::hip_support::detail::operator<<(out, v.hostRegisterReadOnlySupported);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::sparseHipArraySupported").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "sparseHipArraySupported=");
      roctracer::hip_support::detail::operator<<(out, v.sparseHipArraySupported);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::hostRegisterSupported").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hostRegisterSupported=");
      roctracer::hip_support::detail::operator<<(out, v.hostRegisterSupported);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::reservedSharedMemPerBlock").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "reservedSharedMemPerBlock=");
      roctracer::hip_support::detail::operator<<(out, v.reservedSharedMemPerBlock);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::accessPolicyMaxWindowSize").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "accessPolicyMaxWindowSize=");
      roctracer::hip_support::detail::operator<<(out, v.accessPolicyMaxWindowSize);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxBlocksPerMultiProcessor").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxBlocksPerMultiProcessor=");
      roctracer::hip_support::detail::operator<<(out, v.maxBlocksPerMultiProcessor);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::directManagedMemAccessFromHost").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "directManagedMemAccessFromHost=");
      roctracer::hip_support::detail::operator<<(out, v.directManagedMemAccessFromHost);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::pageableMemoryAccessUsesHostPageTables").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "pageableMemoryAccessUsesHostPageTables=");
      roctracer::hip_support::detail::operator<<(out, v.pageableMemoryAccessUsesHostPageTables);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::sharedMemPerBlockOptin").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "sharedMemPerBlockOptin=");
      roctracer::hip_support::detail::operator<<(out, v.sharedMemPerBlockOptin);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::cooperativeMultiDeviceLaunch").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "cooperativeMultiDeviceLaunch=");
      roctracer::hip_support::detail::operator<<(out, v.cooperativeMultiDeviceLaunch);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::cooperativeLaunch").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "cooperativeLaunch=");
      roctracer::hip_support::detail::operator<<(out, v.cooperativeLaunch);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::canUseHostPointerForRegisteredMem").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "canUseHostPointerForRegisteredMem=");
      roctracer::hip_support::detail::operator<<(out, v.canUseHostPointerForRegisteredMem);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::computePreemptionSupported").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "computePreemptionSupported=");
      roctracer::hip_support::detail::operator<<(out, v.computePreemptionSupported);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::concurrentManagedAccess").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "concurrentManagedAccess=");
      roctracer::hip_support::detail::operator<<(out, v.concurrentManagedAccess);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::pageableMemoryAccess").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "pageableMemoryAccess=");
      roctracer::hip_support::detail::operator<<(out, v.pageableMemoryAccess);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::singleToDoublePrecisionPerfRatio").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "singleToDoublePrecisionPerfRatio=");
      roctracer::hip_support::detail::operator<<(out, v.singleToDoublePrecisionPerfRatio);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::hostNativeAtomicSupported").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hostNativeAtomicSupported=");
      roctracer::hip_support::detail::operator<<(out, v.hostNativeAtomicSupported);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::multiGpuBoardGroupID").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "multiGpuBoardGroupID=");
      roctracer::hip_support::detail::operator<<(out, v.multiGpuBoardGroupID);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::isMultiGpuBoard").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "isMultiGpuBoard=");
      roctracer::hip_support::detail::operator<<(out, v.isMultiGpuBoard);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::managedMemory").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "managedMemory=");
      roctracer::hip_support::detail::operator<<(out, v.managedMemory);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::regsPerMultiprocessor").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "regsPerMultiprocessor=");
      roctracer::hip_support::detail::operator<<(out, v.regsPerMultiprocessor);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::sharedMemPerMultiprocessor").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "sharedMemPerMultiprocessor=");
      roctracer::hip_support::detail::operator<<(out, v.sharedMemPerMultiprocessor);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::localL1CacheSupported").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "localL1CacheSupported=");
      roctracer::hip_support::detail::operator<<(out, v.localL1CacheSupported);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::globalL1CacheSupported").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "globalL1CacheSupported=");
      roctracer::hip_support::detail::operator<<(out, v.globalL1CacheSupported);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::streamPrioritiesSupported").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "streamPrioritiesSupported=");
      roctracer::hip_support::detail::operator<<(out, v.streamPrioritiesSupported);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxThreadsPerMultiProcessor").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxThreadsPerMultiProcessor=");
      roctracer::hip_support::detail::operator<<(out, v.maxThreadsPerMultiProcessor);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::persistingL2CacheMaxSize").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "persistingL2CacheMaxSize=");
      roctracer::hip_support::detail::operator<<(out, v.persistingL2CacheMaxSize);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::l2CacheSize").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "l2CacheSize=");
      roctracer::hip_support::detail::operator<<(out, v.l2CacheSize);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::memoryBusWidth").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "memoryBusWidth=");
      roctracer::hip_support::detail::operator<<(out, v.memoryBusWidth);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::memoryClockRate").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "memoryClockRate=");
      roctracer::hip_support::detail::operator<<(out, v.memoryClockRate);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::unifiedAddressing").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "unifiedAddressing=");
      roctracer::hip_support::detail::operator<<(out, v.unifiedAddressing);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::asyncEngineCount").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "asyncEngineCount=");
      roctracer::hip_support::detail::operator<<(out, v.asyncEngineCount);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::tccDriver").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "tccDriver=");
      roctracer::hip_support::detail::operator<<(out, v.tccDriver);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::pciDomainID").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "pciDomainID=");
      roctracer::hip_support::detail::operator<<(out, v.pciDomainID);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::pciDeviceID").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "pciDeviceID=");
      roctracer::hip_support::detail::operator<<(out, v.pciDeviceID);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::pciBusID").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "pciBusID=");
      roctracer::hip_support::detail::operator<<(out, v.pciBusID);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::ECCEnabled").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "ECCEnabled=");
      roctracer::hip_support::detail::operator<<(out, v.ECCEnabled);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::concurrentKernels").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "concurrentKernels=");
      roctracer::hip_support::detail::operator<<(out, v.concurrentKernels);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::surfaceAlignment").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "surfaceAlignment=");
      roctracer::hip_support::detail::operator<<(out, v.surfaceAlignment);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxSurfaceCubemapLayered").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxSurfaceCubemapLayered=");
      roctracer::hip_support::detail::operator<<(out, v.maxSurfaceCubemapLayered);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxSurfaceCubemap").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxSurfaceCubemap=");
      roctracer::hip_support::detail::operator<<(out, v.maxSurfaceCubemap);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxSurface2DLayered").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxSurface2DLayered=");
      roctracer::hip_support::detail::operator<<(out, v.maxSurface2DLayered);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxSurface1DLayered").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxSurface1DLayered=");
      roctracer::hip_support::detail::operator<<(out, v.maxSurface1DLayered);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxSurface3D").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxSurface3D=");
      roctracer::hip_support::detail::operator<<(out, v.maxSurface3D);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxSurface2D").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxSurface2D=");
      roctracer::hip_support::detail::operator<<(out, v.maxSurface2D);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxSurface1D").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxSurface1D=");
      roctracer::hip_support::detail::operator<<(out, v.maxSurface1D);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxTextureCubemapLayered").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxTextureCubemapLayered=");
      roctracer::hip_support::detail::operator<<(out, v.maxTextureCubemapLayered);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxTexture2DLayered").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxTexture2DLayered=");
      roctracer::hip_support::detail::operator<<(out, v.maxTexture2DLayered);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxTexture1DLayered").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxTexture1DLayered=");
      roctracer::hip_support::detail::operator<<(out, v.maxTexture1DLayered);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxTextureCubemap").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxTextureCubemap=");
      roctracer::hip_support::detail::operator<<(out, v.maxTextureCubemap);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxTexture3DAlt").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxTexture3DAlt=");
      roctracer::hip_support::detail::operator<<(out, v.maxTexture3DAlt);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxTexture3D").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxTexture3D=");
      roctracer::hip_support::detail::operator<<(out, v.maxTexture3D);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxTexture2DGather").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxTexture2DGather=");
      roctracer::hip_support::detail::operator<<(out, v.maxTexture2DGather);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxTexture2DLinear").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxTexture2DLinear=");
      roctracer::hip_support::detail::operator<<(out, v.maxTexture2DLinear);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxTexture2DMipmap").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxTexture2DMipmap=");
      roctracer::hip_support::detail::operator<<(out, v.maxTexture2DMipmap);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxTexture2D").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxTexture2D=");
      roctracer::hip_support::detail::operator<<(out, v.maxTexture2D);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxTexture1DLinear").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxTexture1DLinear=");
      roctracer::hip_support::detail::operator<<(out, v.maxTexture1DLinear);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxTexture1DMipmap").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxTexture1DMipmap=");
      roctracer::hip_support::detail::operator<<(out, v.maxTexture1DMipmap);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxTexture1D").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxTexture1D=");
      roctracer::hip_support::detail::operator<<(out, v.maxTexture1D);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::computeMode").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "computeMode=");
      roctracer::hip_support::detail::operator<<(out, v.computeMode);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::canMapHostMemory").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "canMapHostMemory=");
      roctracer::hip_support::detail::operator<<(out, v.canMapHostMemory);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::integrated").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "integrated=");
      roctracer::hip_support::detail::operator<<(out, v.integrated);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::kernelExecTimeoutEnabled").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "kernelExecTimeoutEnabled=");
      roctracer::hip_support::detail::operator<<(out, v.kernelExecTimeoutEnabled);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::multiProcessorCount").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "multiProcessorCount=");
      roctracer::hip_support::detail::operator<<(out, v.multiProcessorCount);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::deviceOverlap").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "deviceOverlap=");
      roctracer::hip_support::detail::operator<<(out, v.deviceOverlap);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::texturePitchAlignment").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "texturePitchAlignment=");
      roctracer::hip_support::detail::operator<<(out, v.texturePitchAlignment);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::textureAlignment").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "textureAlignment=");
      roctracer::hip_support::detail::operator<<(out, v.textureAlignment);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::minor").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "minor=");
      roctracer::hip_support::detail::operator<<(out, v.minor);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::major").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "major=");
      roctracer::hip_support::detail::operator<<(out, v.major);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::totalConstMem").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "totalConstMem=");
      roctracer::hip_support::detail::operator<<(out, v.totalConstMem);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::clockRate").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "clockRate=");
      roctracer::hip_support::detail::operator<<(out, v.clockRate);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxGridSize").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxGridSize=");
      roctracer::hip_support::detail::operator<<(out, v.maxGridSize);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxThreadsDim").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxThreadsDim=");
      roctracer::hip_support::detail::operator<<(out, v.maxThreadsDim);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::maxThreadsPerBlock").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxThreadsPerBlock=");
      roctracer::hip_support::detail::operator<<(out, v.maxThreadsPerBlock);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::memPitch").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "memPitch=");
      roctracer::hip_support::detail::operator<<(out, v.memPitch);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::warpSize").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "warpSize=");
      roctracer::hip_support::detail::operator<<(out, v.warpSize);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::regsPerBlock").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "regsPerBlock=");
      roctracer::hip_support::detail::operator<<(out, v.regsPerBlock);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::sharedMemPerBlock").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "sharedMemPerBlock=");
      roctracer::hip_support::detail::operator<<(out, v.sharedMemPerBlock);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::totalGlobalMem").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "totalGlobalMem=");
      roctracer::hip_support::detail::operator<<(out, v.totalGlobalMem);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::luidDeviceNodeMask").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "luidDeviceNodeMask=");
      roctracer::hip_support::detail::operator<<(out, v.luidDeviceNodeMask);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::luid").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "luid=");
      roctracer::hip_support::detail::operator<<(out, v.luid);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::uuid").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "uuid=");
      roctracer::hip_support::detail::operator<<(out, v.uuid);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0600::name").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "name=");
      roctracer::hip_support::detail::operator<<(out, v.name);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipPointerAttribute_t& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipPointerAttribute_t::allocationFlags").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "allocationFlags=");
      roctracer::hip_support::detail::operator<<(out, v.allocationFlags);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipPointerAttribute_t::isManaged").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "isManaged=");
      roctracer::hip_support::detail::operator<<(out, v.isManaged);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipPointerAttribute_t::device").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "device=");
      roctracer::hip_support::detail::operator<<(out, v.device);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipPointerAttribute_t::type").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "type=");
      roctracer::hip_support::detail::operator<<(out, v.type);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipChannelFormatDesc& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipChannelFormatDesc::f").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "f=");
      roctracer::hip_support::detail::operator<<(out, v.f);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipChannelFormatDesc::w").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "w=");
      roctracer::hip_support::detail::operator<<(out, v.w);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipChannelFormatDesc::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipChannelFormatDesc::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipChannelFormatDesc::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const HIP_ARRAY_DESCRIPTOR& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("HIP_ARRAY_DESCRIPTOR::NumChannels").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "NumChannels=");
      roctracer::hip_support::detail::operator<<(out, v.NumChannels);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_ARRAY_DESCRIPTOR::Format").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "Format=");
      roctracer::hip_support::detail::operator<<(out, v.Format);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_ARRAY_DESCRIPTOR::Height").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "Height=");
      roctracer::hip_support::detail::operator<<(out, v.Height);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_ARRAY_DESCRIPTOR::Width").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "Width=");
      roctracer::hip_support::detail::operator<<(out, v.Width);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const HIP_ARRAY3D_DESCRIPTOR& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("HIP_ARRAY3D_DESCRIPTOR::Flags").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "Flags=");
      roctracer::hip_support::detail::operator<<(out, v.Flags);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_ARRAY3D_DESCRIPTOR::NumChannels").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "NumChannels=");
      roctracer::hip_support::detail::operator<<(out, v.NumChannels);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_ARRAY3D_DESCRIPTOR::Format").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "Format=");
      roctracer::hip_support::detail::operator<<(out, v.Format);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_ARRAY3D_DESCRIPTOR::Depth").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "Depth=");
      roctracer::hip_support::detail::operator<<(out, v.Depth);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_ARRAY3D_DESCRIPTOR::Height").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "Height=");
      roctracer::hip_support::detail::operator<<(out, v.Height);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_ARRAY3D_DESCRIPTOR::Width").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "Width=");
      roctracer::hip_support::detail::operator<<(out, v.Width);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hip_Memcpy2D& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hip_Memcpy2D::Height").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "Height=");
      roctracer::hip_support::detail::operator<<(out, v.Height);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hip_Memcpy2D::WidthInBytes").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "WidthInBytes=");
      roctracer::hip_support::detail::operator<<(out, v.WidthInBytes);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hip_Memcpy2D::dstPitch").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstPitch=");
      roctracer::hip_support::detail::operator<<(out, v.dstPitch);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hip_Memcpy2D::dstArray").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstArray=");
      roctracer::hip_support::detail::operator<<(out, v.dstArray);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hip_Memcpy2D::dstDevice").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstDevice=");
      roctracer::hip_support::detail::operator<<(out, v.dstDevice);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hip_Memcpy2D::dstMemoryType").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstMemoryType=");
      roctracer::hip_support::detail::operator<<(out, v.dstMemoryType);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hip_Memcpy2D::dstY").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstY=");
      roctracer::hip_support::detail::operator<<(out, v.dstY);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hip_Memcpy2D::dstXInBytes").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstXInBytes=");
      roctracer::hip_support::detail::operator<<(out, v.dstXInBytes);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hip_Memcpy2D::srcPitch").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcPitch=");
      roctracer::hip_support::detail::operator<<(out, v.srcPitch);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hip_Memcpy2D::srcArray").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcArray=");
      roctracer::hip_support::detail::operator<<(out, v.srcArray);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hip_Memcpy2D::srcDevice").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcDevice=");
      roctracer::hip_support::detail::operator<<(out, v.srcDevice);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hip_Memcpy2D::srcMemoryType").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcMemoryType=");
      roctracer::hip_support::detail::operator<<(out, v.srcMemoryType);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hip_Memcpy2D::srcY").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcY=");
      roctracer::hip_support::detail::operator<<(out, v.srcY);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hip_Memcpy2D::srcXInBytes").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcXInBytes=");
      roctracer::hip_support::detail::operator<<(out, v.srcXInBytes);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipMipmappedArray& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipMipmappedArray::num_channels").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "num_channels=");
      roctracer::hip_support::detail::operator<<(out, v.num_channels);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMipmappedArray::format").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "format=");
      roctracer::hip_support::detail::operator<<(out, v.format);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMipmappedArray::flags").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "flags=");
      roctracer::hip_support::detail::operator<<(out, v.flags);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMipmappedArray::max_mipmap_level").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "max_mipmap_level=");
      roctracer::hip_support::detail::operator<<(out, v.max_mipmap_level);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMipmappedArray::min_mipmap_level").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "min_mipmap_level=");
      roctracer::hip_support::detail::operator<<(out, v.min_mipmap_level);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMipmappedArray::depth").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "depth=");
      roctracer::hip_support::detail::operator<<(out, v.depth);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMipmappedArray::height").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "height=");
      roctracer::hip_support::detail::operator<<(out, v.height);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMipmappedArray::width").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "width=");
      roctracer::hip_support::detail::operator<<(out, v.width);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMipmappedArray::type").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "type=");
      roctracer::hip_support::detail::operator<<(out, v.type);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMipmappedArray::desc").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "desc=");
      roctracer::hip_support::detail::operator<<(out, v.desc);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const HIP_TEXTURE_DESC& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("HIP_TEXTURE_DESC::reserved").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "reserved=");
      roctracer::hip_support::detail::operator<<(out, v.reserved);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_TEXTURE_DESC::borderColor").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "borderColor=");
      roctracer::hip_support::detail::operator<<(out, v.borderColor);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_TEXTURE_DESC::maxMipmapLevelClamp").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxMipmapLevelClamp=");
      roctracer::hip_support::detail::operator<<(out, v.maxMipmapLevelClamp);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_TEXTURE_DESC::minMipmapLevelClamp").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "minMipmapLevelClamp=");
      roctracer::hip_support::detail::operator<<(out, v.minMipmapLevelClamp);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_TEXTURE_DESC::mipmapLevelBias").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "mipmapLevelBias=");
      roctracer::hip_support::detail::operator<<(out, v.mipmapLevelBias);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_TEXTURE_DESC::mipmapFilterMode").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "mipmapFilterMode=");
      roctracer::hip_support::detail::operator<<(out, v.mipmapFilterMode);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_TEXTURE_DESC::maxAnisotropy").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxAnisotropy=");
      roctracer::hip_support::detail::operator<<(out, v.maxAnisotropy);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_TEXTURE_DESC::flags").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "flags=");
      roctracer::hip_support::detail::operator<<(out, v.flags);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_TEXTURE_DESC::filterMode").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "filterMode=");
      roctracer::hip_support::detail::operator<<(out, v.filterMode);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_TEXTURE_DESC::addressMode").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "addressMode=");
      roctracer::hip_support::detail::operator<<(out, v.addressMode);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipResourceDesc& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipResourceDesc::resType").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "resType=");
      roctracer::hip_support::detail::operator<<(out, v.resType);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const HIP_RESOURCE_DESC& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("HIP_RESOURCE_DESC::flags").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "flags=");
      roctracer::hip_support::detail::operator<<(out, v.flags);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_RESOURCE_DESC::resType").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "resType=");
      roctracer::hip_support::detail::operator<<(out, v.resType);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipResourceViewDesc& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipResourceViewDesc::lastLayer").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "lastLayer=");
      roctracer::hip_support::detail::operator<<(out, v.lastLayer);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipResourceViewDesc::firstLayer").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "firstLayer=");
      roctracer::hip_support::detail::operator<<(out, v.firstLayer);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipResourceViewDesc::lastMipmapLevel").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "lastMipmapLevel=");
      roctracer::hip_support::detail::operator<<(out, v.lastMipmapLevel);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipResourceViewDesc::firstMipmapLevel").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "firstMipmapLevel=");
      roctracer::hip_support::detail::operator<<(out, v.firstMipmapLevel);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipResourceViewDesc::depth").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "depth=");
      roctracer::hip_support::detail::operator<<(out, v.depth);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipResourceViewDesc::height").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "height=");
      roctracer::hip_support::detail::operator<<(out, v.height);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipResourceViewDesc::width").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "width=");
      roctracer::hip_support::detail::operator<<(out, v.width);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipResourceViewDesc::format").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "format=");
      roctracer::hip_support::detail::operator<<(out, v.format);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const HIP_RESOURCE_VIEW_DESC& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("HIP_RESOURCE_VIEW_DESC::reserved").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "reserved=");
      roctracer::hip_support::detail::operator<<(out, v.reserved);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_RESOURCE_VIEW_DESC::lastLayer").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "lastLayer=");
      roctracer::hip_support::detail::operator<<(out, v.lastLayer);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_RESOURCE_VIEW_DESC::firstLayer").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "firstLayer=");
      roctracer::hip_support::detail::operator<<(out, v.firstLayer);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_RESOURCE_VIEW_DESC::lastMipmapLevel").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "lastMipmapLevel=");
      roctracer::hip_support::detail::operator<<(out, v.lastMipmapLevel);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_RESOURCE_VIEW_DESC::firstMipmapLevel").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "firstMipmapLevel=");
      roctracer::hip_support::detail::operator<<(out, v.firstMipmapLevel);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_RESOURCE_VIEW_DESC::depth").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "depth=");
      roctracer::hip_support::detail::operator<<(out, v.depth);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_RESOURCE_VIEW_DESC::height").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "height=");
      roctracer::hip_support::detail::operator<<(out, v.height);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_RESOURCE_VIEW_DESC::width").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "width=");
      roctracer::hip_support::detail::operator<<(out, v.width);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_RESOURCE_VIEW_DESC::format").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "format=");
      roctracer::hip_support::detail::operator<<(out, v.format);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipPitchedPtr& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipPitchedPtr::ysize").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "ysize=");
      roctracer::hip_support::detail::operator<<(out, v.ysize);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipPitchedPtr::xsize").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "xsize=");
      roctracer::hip_support::detail::operator<<(out, v.xsize);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipPitchedPtr::pitch").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "pitch=");
      roctracer::hip_support::detail::operator<<(out, v.pitch);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipExtent& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipExtent::depth").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "depth=");
      roctracer::hip_support::detail::operator<<(out, v.depth);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipExtent::height").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "height=");
      roctracer::hip_support::detail::operator<<(out, v.height);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipExtent::width").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "width=");
      roctracer::hip_support::detail::operator<<(out, v.width);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipPos& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipPos::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipPos::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipPos::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipMemcpy3DParms& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipMemcpy3DParms::kind").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "kind=");
      roctracer::hip_support::detail::operator<<(out, v.kind);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpy3DParms::extent").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "extent=");
      roctracer::hip_support::detail::operator<<(out, v.extent);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpy3DParms::dstPtr").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstPtr=");
      roctracer::hip_support::detail::operator<<(out, v.dstPtr);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpy3DParms::dstPos").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstPos=");
      roctracer::hip_support::detail::operator<<(out, v.dstPos);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpy3DParms::dstArray").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstArray=");
      roctracer::hip_support::detail::operator<<(out, v.dstArray);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpy3DParms::srcPtr").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcPtr=");
      roctracer::hip_support::detail::operator<<(out, v.srcPtr);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpy3DParms::srcPos").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcPos=");
      roctracer::hip_support::detail::operator<<(out, v.srcPos);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpy3DParms::srcArray").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcArray=");
      roctracer::hip_support::detail::operator<<(out, v.srcArray);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const HIP_MEMCPY3D& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("HIP_MEMCPY3D::Depth").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "Depth=");
      roctracer::hip_support::detail::operator<<(out, v.Depth);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_MEMCPY3D::Height").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "Height=");
      roctracer::hip_support::detail::operator<<(out, v.Height);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_MEMCPY3D::WidthInBytes").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "WidthInBytes=");
      roctracer::hip_support::detail::operator<<(out, v.WidthInBytes);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_MEMCPY3D::dstHeight").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstHeight=");
      roctracer::hip_support::detail::operator<<(out, v.dstHeight);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_MEMCPY3D::dstPitch").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstPitch=");
      roctracer::hip_support::detail::operator<<(out, v.dstPitch);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_MEMCPY3D::dstArray").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstArray=");
      roctracer::hip_support::detail::operator<<(out, v.dstArray);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_MEMCPY3D::dstDevice").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstDevice=");
      roctracer::hip_support::detail::operator<<(out, v.dstDevice);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_MEMCPY3D::dstMemoryType").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstMemoryType=");
      roctracer::hip_support::detail::operator<<(out, v.dstMemoryType);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_MEMCPY3D::dstLOD").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstLOD=");
      roctracer::hip_support::detail::operator<<(out, v.dstLOD);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_MEMCPY3D::dstZ").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstZ=");
      roctracer::hip_support::detail::operator<<(out, v.dstZ);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_MEMCPY3D::dstY").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstY=");
      roctracer::hip_support::detail::operator<<(out, v.dstY);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_MEMCPY3D::dstXInBytes").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstXInBytes=");
      roctracer::hip_support::detail::operator<<(out, v.dstXInBytes);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_MEMCPY3D::srcHeight").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcHeight=");
      roctracer::hip_support::detail::operator<<(out, v.srcHeight);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_MEMCPY3D::srcPitch").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcPitch=");
      roctracer::hip_support::detail::operator<<(out, v.srcPitch);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_MEMCPY3D::srcArray").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcArray=");
      roctracer::hip_support::detail::operator<<(out, v.srcArray);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_MEMCPY3D::srcDevice").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcDevice=");
      roctracer::hip_support::detail::operator<<(out, v.srcDevice);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_MEMCPY3D::srcMemoryType").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcMemoryType=");
      roctracer::hip_support::detail::operator<<(out, v.srcMemoryType);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_MEMCPY3D::srcLOD").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcLOD=");
      roctracer::hip_support::detail::operator<<(out, v.srcLOD);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_MEMCPY3D::srcZ").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcZ=");
      roctracer::hip_support::detail::operator<<(out, v.srcZ);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_MEMCPY3D::srcY").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcY=");
      roctracer::hip_support::detail::operator<<(out, v.srcY);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_MEMCPY3D::srcXInBytes").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcXInBytes=");
      roctracer::hip_support::detail::operator<<(out, v.srcXInBytes);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipMemLocation& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipMemLocation::id").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "id=");
      roctracer::hip_support::detail::operator<<(out, v.id);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemLocation::type").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "type=");
      roctracer::hip_support::detail::operator<<(out, v.type);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipMemcpyAttributes& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipMemcpyAttributes::flags").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "flags=");
      roctracer::hip_support::detail::operator<<(out, v.flags);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpyAttributes::dstLocHint").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstLocHint=");
      roctracer::hip_support::detail::operator<<(out, v.dstLocHint);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpyAttributes::srcLocHint").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcLocHint=");
      roctracer::hip_support::detail::operator<<(out, v.srcLocHint);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpyAttributes::srcAccessOrder").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcAccessOrder=");
      roctracer::hip_support::detail::operator<<(out, v.srcAccessOrder);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipOffset3D& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipOffset3D::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipOffset3D::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipOffset3D::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipMemcpy3DOperand& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipMemcpy3DOperand::type").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "type=");
      roctracer::hip_support::detail::operator<<(out, v.type);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipMemcpy3DBatchOp& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipMemcpy3DBatchOp::flags").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "flags=");
      roctracer::hip_support::detail::operator<<(out, v.flags);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpy3DBatchOp::srcAccessOrder").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcAccessOrder=");
      roctracer::hip_support::detail::operator<<(out, v.srcAccessOrder);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpy3DBatchOp::extent").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "extent=");
      roctracer::hip_support::detail::operator<<(out, v.extent);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpy3DBatchOp::dst").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dst=");
      roctracer::hip_support::detail::operator<<(out, v.dst);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpy3DBatchOp::src").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "src=");
      roctracer::hip_support::detail::operator<<(out, v.src);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipMemcpy3DPeerParms& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipMemcpy3DPeerParms::extent").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "extent=");
      roctracer::hip_support::detail::operator<<(out, v.extent);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpy3DPeerParms::dstDevice").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstDevice=");
      roctracer::hip_support::detail::operator<<(out, v.dstDevice);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpy3DPeerParms::dstPtr").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstPtr=");
      roctracer::hip_support::detail::operator<<(out, v.dstPtr);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpy3DPeerParms::dstPos").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstPos=");
      roctracer::hip_support::detail::operator<<(out, v.dstPos);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpy3DPeerParms::dstArray").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dstArray=");
      roctracer::hip_support::detail::operator<<(out, v.dstArray);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpy3DPeerParms::srcDevice").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcDevice=");
      roctracer::hip_support::detail::operator<<(out, v.srcDevice);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpy3DPeerParms::srcPtr").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcPtr=");
      roctracer::hip_support::detail::operator<<(out, v.srcPtr);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpy3DPeerParms::srcPos").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcPos=");
      roctracer::hip_support::detail::operator<<(out, v.srcPos);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpy3DPeerParms::srcArray").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "srcArray=");
      roctracer::hip_support::detail::operator<<(out, v.srcArray);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const uchar1& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("uchar1::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const uchar2& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("uchar2::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("uchar2::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const uchar3& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("uchar3::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("uchar3::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("uchar3::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const uchar4& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("uchar4::w").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "w=");
      roctracer::hip_support::detail::operator<<(out, v.w);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("uchar4::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("uchar4::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("uchar4::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const char1& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("char1::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const char2& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("char2::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("char2::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const char3& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("char3::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("char3::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("char3::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const char4& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("char4::w").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "w=");
      roctracer::hip_support::detail::operator<<(out, v.w);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("char4::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("char4::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("char4::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const ushort1& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("ushort1::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const ushort2& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("ushort2::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("ushort2::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const ushort3& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("ushort3::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("ushort3::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("ushort3::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const ushort4& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("ushort4::w").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "w=");
      roctracer::hip_support::detail::operator<<(out, v.w);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("ushort4::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("ushort4::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("ushort4::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const short1& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("short1::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const short2& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("short2::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("short2::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const short3& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("short3::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("short3::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("short3::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const short4& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("short4::w").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "w=");
      roctracer::hip_support::detail::operator<<(out, v.w);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("short4::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("short4::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("short4::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const uint1& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("uint1::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const uint2& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("uint2::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("uint2::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const uint3& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("uint3::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("uint3::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("uint3::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const uint4& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("uint4::w").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "w=");
      roctracer::hip_support::detail::operator<<(out, v.w);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("uint4::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("uint4::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("uint4::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const int1& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("int1::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const int2& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("int2::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("int2::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const int3& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("int3::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("int3::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("int3::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const int4& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("int4::w").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "w=");
      roctracer::hip_support::detail::operator<<(out, v.w);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("int4::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("int4::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("int4::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const ulong1& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("ulong1::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const ulong2& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("ulong2::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("ulong2::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const ulong3& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("ulong3::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("ulong3::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("ulong3::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const ulong4& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("ulong4::w").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "w=");
      roctracer::hip_support::detail::operator<<(out, v.w);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("ulong4::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("ulong4::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("ulong4::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const long1& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("long1::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const long2& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("long2::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("long2::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const long3& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("long3::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("long3::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("long3::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const long4& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("long4::w").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "w=");
      roctracer::hip_support::detail::operator<<(out, v.w);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("long4::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("long4::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("long4::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const ulonglong1& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("ulonglong1::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const ulonglong2& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("ulonglong2::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("ulonglong2::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const ulonglong3& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("ulonglong3::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("ulonglong3::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("ulonglong3::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const ulonglong4& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("ulonglong4::w").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "w=");
      roctracer::hip_support::detail::operator<<(out, v.w);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("ulonglong4::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("ulonglong4::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("ulonglong4::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const longlong1& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("longlong1::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const longlong2& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("longlong2::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("longlong2::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const longlong3& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("longlong3::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("longlong3::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("longlong3::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const longlong4& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("longlong4::w").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "w=");
      roctracer::hip_support::detail::operator<<(out, v.w);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("longlong4::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("longlong4::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("longlong4::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const float1& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("float1::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const float2& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("float2::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("float2::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const float3& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("float3::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("float3::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("float3::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const float4& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("float4::w").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "w=");
      roctracer::hip_support::detail::operator<<(out, v.w);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("float4::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("float4::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("float4::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const double1& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("double1::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const double2& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("double2::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("double2::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const double3& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("double3::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("double3::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("double3::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const double4& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("double4::w").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "w=");
      roctracer::hip_support::detail::operator<<(out, v.w);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("double4::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("double4::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("double4::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const textureReference& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("textureReference::format").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "format=");
      roctracer::hip_support::detail::operator<<(out, v.format);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("textureReference::numChannels").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "numChannels=");
      roctracer::hip_support::detail::operator<<(out, v.numChannels);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("textureReference::textureObject").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "textureObject=");
      roctracer::hip_support::detail::operator<<(out, v.textureObject);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("textureReference::maxMipmapLevelClamp").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxMipmapLevelClamp=");
      roctracer::hip_support::detail::operator<<(out, v.maxMipmapLevelClamp);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("textureReference::minMipmapLevelClamp").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "minMipmapLevelClamp=");
      roctracer::hip_support::detail::operator<<(out, v.minMipmapLevelClamp);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("textureReference::mipmapLevelBias").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "mipmapLevelBias=");
      roctracer::hip_support::detail::operator<<(out, v.mipmapLevelBias);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("textureReference::mipmapFilterMode").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "mipmapFilterMode=");
      roctracer::hip_support::detail::operator<<(out, v.mipmapFilterMode);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("textureReference::maxAnisotropy").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxAnisotropy=");
      roctracer::hip_support::detail::operator<<(out, v.maxAnisotropy);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("textureReference::sRGB").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "sRGB=");
      roctracer::hip_support::detail::operator<<(out, v.sRGB);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("textureReference::channelDesc").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "channelDesc=");
      roctracer::hip_support::detail::operator<<(out, v.channelDesc);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("textureReference::filterMode").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "filterMode=");
      roctracer::hip_support::detail::operator<<(out, v.filterMode);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("textureReference::readMode").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "readMode=");
      roctracer::hip_support::detail::operator<<(out, v.readMode);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("textureReference::normalized").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "normalized=");
      roctracer::hip_support::detail::operator<<(out, v.normalized);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipTextureDesc& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipTextureDesc::maxMipmapLevelClamp").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxMipmapLevelClamp=");
      roctracer::hip_support::detail::operator<<(out, v.maxMipmapLevelClamp);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipTextureDesc::minMipmapLevelClamp").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "minMipmapLevelClamp=");
      roctracer::hip_support::detail::operator<<(out, v.minMipmapLevelClamp);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipTextureDesc::mipmapLevelBias").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "mipmapLevelBias=");
      roctracer::hip_support::detail::operator<<(out, v.mipmapLevelBias);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipTextureDesc::mipmapFilterMode").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "mipmapFilterMode=");
      roctracer::hip_support::detail::operator<<(out, v.mipmapFilterMode);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipTextureDesc::maxAnisotropy").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxAnisotropy=");
      roctracer::hip_support::detail::operator<<(out, v.maxAnisotropy);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipTextureDesc::normalizedCoords").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "normalizedCoords=");
      roctracer::hip_support::detail::operator<<(out, v.normalizedCoords);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipTextureDesc::borderColor").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "borderColor=");
      roctracer::hip_support::detail::operator<<(out, v.borderColor);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipTextureDesc::sRGB").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "sRGB=");
      roctracer::hip_support::detail::operator<<(out, v.sRGB);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipTextureDesc::readMode").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "readMode=");
      roctracer::hip_support::detail::operator<<(out, v.readMode);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipTextureDesc::filterMode").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "filterMode=");
      roctracer::hip_support::detail::operator<<(out, v.filterMode);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const surfaceReference& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("surfaceReference::surfaceObject").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "surfaceObject=");
      roctracer::hip_support::detail::operator<<(out, v.surfaceObject);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipIpcMemHandle_t& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipIpcMemHandle_t::reserved").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "reserved=");
      roctracer::hip_support::detail::operator<<(out, v.reserved);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipIpcEventHandle_t& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipIpcEventHandle_t::reserved").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "reserved=");
      roctracer::hip_support::detail::operator<<(out, v.reserved);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipFuncAttributes& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipFuncAttributes::sharedSizeBytes").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "sharedSizeBytes=");
      roctracer::hip_support::detail::operator<<(out, v.sharedSizeBytes);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipFuncAttributes::ptxVersion").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "ptxVersion=");
      roctracer::hip_support::detail::operator<<(out, v.ptxVersion);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipFuncAttributes::preferredShmemCarveout").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "preferredShmemCarveout=");
      roctracer::hip_support::detail::operator<<(out, v.preferredShmemCarveout);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipFuncAttributes::numRegs").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "numRegs=");
      roctracer::hip_support::detail::operator<<(out, v.numRegs);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipFuncAttributes::maxThreadsPerBlock").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxThreadsPerBlock=");
      roctracer::hip_support::detail::operator<<(out, v.maxThreadsPerBlock);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipFuncAttributes::maxDynamicSharedSizeBytes").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxDynamicSharedSizeBytes=");
      roctracer::hip_support::detail::operator<<(out, v.maxDynamicSharedSizeBytes);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipFuncAttributes::localSizeBytes").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "localSizeBytes=");
      roctracer::hip_support::detail::operator<<(out, v.localSizeBytes);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipFuncAttributes::constSizeBytes").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "constSizeBytes=");
      roctracer::hip_support::detail::operator<<(out, v.constSizeBytes);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipFuncAttributes::cacheModeCA").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "cacheModeCA=");
      roctracer::hip_support::detail::operator<<(out, v.cacheModeCA);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipFuncAttributes::binaryVersion").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "binaryVersion=");
      roctracer::hip_support::detail::operator<<(out, v.binaryVersion);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipStreamBatchMemOpParams& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipStreamBatchMemOpParams::pad").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "pad=");
      roctracer::hip_support::detail::operator<<(out, v.pad);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipStreamBatchMemOpParams::memoryBarrier").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "memoryBarrier=");
      roctracer::hip_support::detail::operator<<(out, v.memoryBarrier);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipStreamBatchMemOpParams::flushRemoteWrites").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "flushRemoteWrites=");
      roctracer::hip_support::detail::operator<<(out, v.flushRemoteWrites);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipStreamBatchMemOpParams::writeValue").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "writeValue=");
      roctracer::hip_support::detail::operator<<(out, v.writeValue);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipStreamBatchMemOpParams::waitValue").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "waitValue=");
      roctracer::hip_support::detail::operator<<(out, v.waitValue);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipStreamBatchMemOpParams::operation").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "operation=");
      roctracer::hip_support::detail::operator<<(out, v.operation);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipBatchMemOpNodeParams& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipBatchMemOpNodeParams::flags").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "flags=");
      roctracer::hip_support::detail::operator<<(out, v.flags);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipBatchMemOpNodeParams::paramArray").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "paramArray=");
      roctracer::hip_support::detail::operator<<(out, v.paramArray);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipBatchMemOpNodeParams::count").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "count=");
      roctracer::hip_support::detail::operator<<(out, v.count);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipBatchMemOpNodeParams::ctx").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "ctx=");
      roctracer::hip_support::detail::operator<<(out, v.ctx);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipMemAccessDesc& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipMemAccessDesc::flags").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "flags=");
      roctracer::hip_support::detail::operator<<(out, v.flags);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemAccessDesc::location").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "location=");
      roctracer::hip_support::detail::operator<<(out, v.location);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipMemPoolProps& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipMemPoolProps::reserved").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "reserved=");
      roctracer::hip_support::detail::operator<<(out, v.reserved);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemPoolProps::maxSize").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxSize=");
      roctracer::hip_support::detail::operator<<(out, v.maxSize);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemPoolProps::location").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "location=");
      roctracer::hip_support::detail::operator<<(out, v.location);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemPoolProps::handleTypes").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "handleTypes=");
      roctracer::hip_support::detail::operator<<(out, v.handleTypes);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemPoolProps::allocType").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "allocType=");
      roctracer::hip_support::detail::operator<<(out, v.allocType);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipMemPoolPtrExportData& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipMemPoolPtrExportData::reserved").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "reserved=");
      roctracer::hip_support::detail::operator<<(out, v.reserved);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const dim3& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("dim3::z").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "z=");
      roctracer::hip_support::detail::operator<<(out, v.z);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("dim3::y").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "y=");
      roctracer::hip_support::detail::operator<<(out, v.y);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("dim3::x").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "x=");
      roctracer::hip_support::detail::operator<<(out, v.x);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipLaunchParams& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipLaunchParams::stream").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "stream=");
      roctracer::hip_support::detail::operator<<(out, v.stream);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipLaunchParams::sharedMem").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "sharedMem=");
      roctracer::hip_support::detail::operator<<(out, v.sharedMem);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipLaunchParams::blockDim").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "blockDim=");
      roctracer::hip_support::detail::operator<<(out, v.blockDim);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipLaunchParams::gridDim").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "gridDim=");
      roctracer::hip_support::detail::operator<<(out, v.gridDim);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipFunctionLaunchParams& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipFunctionLaunchParams::hStream").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hStream=");
      roctracer::hip_support::detail::operator<<(out, v.hStream);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipFunctionLaunchParams::sharedMemBytes").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "sharedMemBytes=");
      roctracer::hip_support::detail::operator<<(out, v.sharedMemBytes);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipFunctionLaunchParams::blockDimZ").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "blockDimZ=");
      roctracer::hip_support::detail::operator<<(out, v.blockDimZ);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipFunctionLaunchParams::blockDimY").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "blockDimY=");
      roctracer::hip_support::detail::operator<<(out, v.blockDimY);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipFunctionLaunchParams::blockDimX").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "blockDimX=");
      roctracer::hip_support::detail::operator<<(out, v.blockDimX);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipFunctionLaunchParams::gridDimZ").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "gridDimZ=");
      roctracer::hip_support::detail::operator<<(out, v.gridDimZ);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipFunctionLaunchParams::gridDimY").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "gridDimY=");
      roctracer::hip_support::detail::operator<<(out, v.gridDimY);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipFunctionLaunchParams::gridDimX").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "gridDimX=");
      roctracer::hip_support::detail::operator<<(out, v.gridDimX);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipFunctionLaunchParams::function").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "function=");
      roctracer::hip_support::detail::operator<<(out, v.function);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipExternalMemoryHandleDesc& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipExternalMemoryHandleDesc::reserved").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "reserved=");
      roctracer::hip_support::detail::operator<<(out, v.reserved);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipExternalMemoryHandleDesc::flags").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "flags=");
      roctracer::hip_support::detail::operator<<(out, v.flags);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipExternalMemoryHandleDesc::size").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "size=");
      roctracer::hip_support::detail::operator<<(out, v.size);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipExternalMemoryHandleDesc_st::union ::handle.fd").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "handle.fd=");
      roctracer::hip_support::detail::operator<<(out, v.handle.fd);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipExternalMemoryHandleDesc::type").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "type=");
      roctracer::hip_support::detail::operator<<(out, v.type);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipExternalMemoryBufferDesc& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipExternalMemoryBufferDesc::reserved").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "reserved=");
      roctracer::hip_support::detail::operator<<(out, v.reserved);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipExternalMemoryBufferDesc::flags").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "flags=");
      roctracer::hip_support::detail::operator<<(out, v.flags);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipExternalMemoryBufferDesc::size").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "size=");
      roctracer::hip_support::detail::operator<<(out, v.size);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipExternalMemoryBufferDesc::offset").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "offset=");
      roctracer::hip_support::detail::operator<<(out, v.offset);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipExternalMemoryMipmappedArrayDesc& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipExternalMemoryMipmappedArrayDesc::numLevels").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "numLevels=");
      roctracer::hip_support::detail::operator<<(out, v.numLevels);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipExternalMemoryMipmappedArrayDesc::flags").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "flags=");
      roctracer::hip_support::detail::operator<<(out, v.flags);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipExternalMemoryMipmappedArrayDesc::extent").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "extent=");
      roctracer::hip_support::detail::operator<<(out, v.extent);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipExternalMemoryMipmappedArrayDesc::formatDesc").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "formatDesc=");
      roctracer::hip_support::detail::operator<<(out, v.formatDesc);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipExternalMemoryMipmappedArrayDesc::offset").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "offset=");
      roctracer::hip_support::detail::operator<<(out, v.offset);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipExternalSemaphoreHandleDesc& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipExternalSemaphoreHandleDesc::reserved").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "reserved=");
      roctracer::hip_support::detail::operator<<(out, v.reserved);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipExternalSemaphoreHandleDesc::flags").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "flags=");
      roctracer::hip_support::detail::operator<<(out, v.flags);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipExternalSemaphoreHandleDesc_st::union ::handle.fd").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "handle.fd=");
      roctracer::hip_support::detail::operator<<(out, v.handle.fd);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipExternalSemaphoreHandleDesc::type").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "type=");
      roctracer::hip_support::detail::operator<<(out, v.type);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipExternalSemaphoreSignalParams& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipExternalSemaphoreSignalParams::reserved").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "reserved=");
      roctracer::hip_support::detail::operator<<(out, v.reserved);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipExternalSemaphoreSignalParams::flags").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "flags=");
      roctracer::hip_support::detail::operator<<(out, v.flags);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipExternalSemaphoreWaitParams& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipExternalSemaphoreWaitParams::reserved").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "reserved=");
      roctracer::hip_support::detail::operator<<(out, v.reserved);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipExternalSemaphoreWaitParams::flags").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "flags=");
      roctracer::hip_support::detail::operator<<(out, v.flags);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipHostNodeParams& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipHostNodeParams::fn").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "fn=");
      roctracer::hip_support::detail::operator<<(out, v.fn);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipKernelNodeParams& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipKernelNodeParams::sharedMemBytes").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "sharedMemBytes=");
      roctracer::hip_support::detail::operator<<(out, v.sharedMemBytes);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipKernelNodeParams::gridDim").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "gridDim=");
      roctracer::hip_support::detail::operator<<(out, v.gridDim);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipKernelNodeParams::blockDim").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "blockDim=");
      roctracer::hip_support::detail::operator<<(out, v.blockDim);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipMemsetParams& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipMemsetParams::width").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "width=");
      roctracer::hip_support::detail::operator<<(out, v.width);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemsetParams::value").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "value=");
      roctracer::hip_support::detail::operator<<(out, v.value);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemsetParams::pitch").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "pitch=");
      roctracer::hip_support::detail::operator<<(out, v.pitch);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemsetParams::height").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "height=");
      roctracer::hip_support::detail::operator<<(out, v.height);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemsetParams::elementSize").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "elementSize=");
      roctracer::hip_support::detail::operator<<(out, v.elementSize);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipMemAllocNodeParams& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipMemAllocNodeParams::bytesize").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "bytesize=");
      roctracer::hip_support::detail::operator<<(out, v.bytesize);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemAllocNodeParams::accessDescCount").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "accessDescCount=");
      roctracer::hip_support::detail::operator<<(out, v.accessDescCount);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemAllocNodeParams::accessDescs").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "accessDescs=");
      roctracer::hip_support::detail::operator<<(out, v.accessDescs);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemAllocNodeParams::poolProps").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "poolProps=");
      roctracer::hip_support::detail::operator<<(out, v.poolProps);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipAccessPolicyWindow& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipAccessPolicyWindow::num_bytes").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "num_bytes=");
      roctracer::hip_support::detail::operator<<(out, v.num_bytes);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipAccessPolicyWindow::missProp").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "missProp=");
      roctracer::hip_support::detail::operator<<(out, v.missProp);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipAccessPolicyWindow::hitRatio").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hitRatio=");
      roctracer::hip_support::detail::operator<<(out, v.hitRatio);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipAccessPolicyWindow::hitProp").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hitProp=");
      roctracer::hip_support::detail::operator<<(out, v.hitProp);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipLaunchMemSyncDomainMap& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipLaunchMemSyncDomainMap::remote").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "remote=");
      roctracer::hip_support::detail::operator<<(out, v.remote);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipLaunchMemSyncDomainMap::default_").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "default_=");
      roctracer::hip_support::detail::operator<<(out, v.default_);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipLaunchAttributeValue& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipLaunchAttributeValue::memSyncDomain").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "memSyncDomain=");
      roctracer::hip_support::detail::operator<<(out, v.memSyncDomain);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipLaunchAttributeValue::memSyncDomainMap").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "memSyncDomainMap=");
      roctracer::hip_support::detail::operator<<(out, v.memSyncDomainMap);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipLaunchAttributeValue::syncPolicy").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "syncPolicy=");
      roctracer::hip_support::detail::operator<<(out, v.syncPolicy);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipLaunchAttributeValue::priority").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "priority=");
      roctracer::hip_support::detail::operator<<(out, v.priority);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipLaunchAttributeValue::cooperative").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "cooperative=");
      roctracer::hip_support::detail::operator<<(out, v.cooperative);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipLaunchAttributeValue::accessPolicyWindow").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "accessPolicyWindow=");
      roctracer::hip_support::detail::operator<<(out, v.accessPolicyWindow);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipLaunchAttributeValue::pad").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "pad=");
      roctracer::hip_support::detail::operator<<(out, v.pad);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipGraphInstantiateParams& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipGraphInstantiateParams::uploadStream").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "uploadStream=");
      roctracer::hip_support::detail::operator<<(out, v.uploadStream);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipGraphInstantiateParams::result_out").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "result_out=");
      roctracer::hip_support::detail::operator<<(out, v.result_out);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipGraphInstantiateParams::flags").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "flags=");
      roctracer::hip_support::detail::operator<<(out, v.flags);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipGraphInstantiateParams::errNode_out").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "errNode_out=");
      roctracer::hip_support::detail::operator<<(out, v.errNode_out);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipMemAllocationProp& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipMemAllocationProp::location").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "location=");
      roctracer::hip_support::detail::operator<<(out, v.location);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemAllocationProp::type").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "type=");
      roctracer::hip_support::detail::operator<<(out, v.type);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipExternalSemaphoreSignalNodeParams& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipExternalSemaphoreSignalNodeParams::numExtSems").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "numExtSems=");
      roctracer::hip_support::detail::operator<<(out, v.numExtSems);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipExternalSemaphoreSignalNodeParams::paramsArray").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "paramsArray=");
      roctracer::hip_support::detail::operator<<(out, v.paramsArray);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipExternalSemaphoreSignalNodeParams::extSemArray").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "extSemArray=");
      roctracer::hip_support::detail::operator<<(out, v.extSemArray);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipExternalSemaphoreWaitNodeParams& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipExternalSemaphoreWaitNodeParams::numExtSems").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "numExtSems=");
      roctracer::hip_support::detail::operator<<(out, v.numExtSems);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipExternalSemaphoreWaitNodeParams::paramsArray").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "paramsArray=");
      roctracer::hip_support::detail::operator<<(out, v.paramsArray);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipExternalSemaphoreWaitNodeParams::extSemArray").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "extSemArray=");
      roctracer::hip_support::detail::operator<<(out, v.extSemArray);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipArrayMapInfo& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipArrayMapInfo::reserved").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "reserved=");
      roctracer::hip_support::detail::operator<<(out, v.reserved);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipArrayMapInfo::flags").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "flags=");
      roctracer::hip_support::detail::operator<<(out, v.flags);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipArrayMapInfo::deviceBitMask").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "deviceBitMask=");
      roctracer::hip_support::detail::operator<<(out, v.deviceBitMask);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipArrayMapInfo::offset").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "offset=");
      roctracer::hip_support::detail::operator<<(out, v.offset);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipArrayMapInfo::union ::memHandle.memHandle").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "memHandle.memHandle=");
      roctracer::hip_support::detail::operator<<(out, v.memHandle.memHandle);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipArrayMapInfo::memHandleType").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "memHandleType=");
      roctracer::hip_support::detail::operator<<(out, v.memHandleType);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipArrayMapInfo::memOperationType").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "memOperationType=");
      roctracer::hip_support::detail::operator<<(out, v.memOperationType);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipArrayMapInfo::subresourceType").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "subresourceType=");
      roctracer::hip_support::detail::operator<<(out, v.subresourceType);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipArrayMapInfo::resourceType").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "resourceType=");
      roctracer::hip_support::detail::operator<<(out, v.resourceType);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipMemcpyNodeParams& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipMemcpyNodeParams::copyParams").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "copyParams=");
      roctracer::hip_support::detail::operator<<(out, v.copyParams);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpyNodeParams::reserved").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "reserved=");
      roctracer::hip_support::detail::operator<<(out, v.reserved);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipMemcpyNodeParams::flags").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "flags=");
      roctracer::hip_support::detail::operator<<(out, v.flags);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipChildGraphNodeParams& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipChildGraphNodeParams::graph").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "graph=");
      roctracer::hip_support::detail::operator<<(out, v.graph);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipEventWaitNodeParams& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipEventWaitNodeParams::event").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "event=");
      roctracer::hip_support::detail::operator<<(out, v.event);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipEventRecordNodeParams& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipEventRecordNodeParams::event").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "event=");
      roctracer::hip_support::detail::operator<<(out, v.event);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipMemFreeNodeParams& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipGraphNodeParams& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipGraphNodeParams::reserved2").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "reserved2=");
      roctracer::hip_support::detail::operator<<(out, v.reserved2);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipGraphNodeParams::reserved0").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "reserved0=");
      roctracer::hip_support::detail::operator<<(out, v.reserved0);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipGraphNodeParams::type").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "type=");
      roctracer::hip_support::detail::operator<<(out, v.type);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipGraphEdgeData& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipGraphEdgeData::type").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "type=");
      roctracer::hip_support::detail::operator<<(out, v.type);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipGraphEdgeData::to_port").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "to_port=");
      roctracer::hip_support::detail::operator<<(out, v.to_port);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipGraphEdgeData::reserved").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "reserved=");
      roctracer::hip_support::detail::operator<<(out, v.reserved);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipGraphEdgeData::from_port").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "from_port=");
      roctracer::hip_support::detail::operator<<(out, v.from_port);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipLaunchAttribute& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipLaunchAttribute::id").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "id=");
      roctracer::hip_support::detail::operator<<(out, v.id);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipLaunchConfig_t& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipLaunchConfig_t::numAttrs").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "numAttrs=");
      roctracer::hip_support::detail::operator<<(out, v.numAttrs);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipLaunchConfig_t::attrs").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "attrs=");
      roctracer::hip_support::detail::operator<<(out, v.attrs);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipLaunchConfig_t::stream").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "stream=");
      roctracer::hip_support::detail::operator<<(out, v.stream);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipLaunchConfig_t::dynamicSmemBytes").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "dynamicSmemBytes=");
      roctracer::hip_support::detail::operator<<(out, v.dynamicSmemBytes);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipLaunchConfig_t::blockDim").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "blockDim=");
      roctracer::hip_support::detail::operator<<(out, v.blockDim);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipLaunchConfig_t::gridDim").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "gridDim=");
      roctracer::hip_support::detail::operator<<(out, v.gridDim);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const HIP_LAUNCH_CONFIG& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("HIP_LAUNCH_CONFIG::numAttrs").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "numAttrs=");
      roctracer::hip_support::detail::operator<<(out, v.numAttrs);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_LAUNCH_CONFIG::attrs").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "attrs=");
      roctracer::hip_support::detail::operator<<(out, v.attrs);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_LAUNCH_CONFIG::hStream").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hStream=");
      roctracer::hip_support::detail::operator<<(out, v.hStream);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_LAUNCH_CONFIG::sharedMemBytes").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "sharedMemBytes=");
      roctracer::hip_support::detail::operator<<(out, v.sharedMemBytes);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_LAUNCH_CONFIG::blockDimZ").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "blockDimZ=");
      roctracer::hip_support::detail::operator<<(out, v.blockDimZ);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_LAUNCH_CONFIG::blockDimY").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "blockDimY=");
      roctracer::hip_support::detail::operator<<(out, v.blockDimY);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_LAUNCH_CONFIG::blockDimX").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "blockDimX=");
      roctracer::hip_support::detail::operator<<(out, v.blockDimX);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_LAUNCH_CONFIG::gridDimZ").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "gridDimZ=");
      roctracer::hip_support::detail::operator<<(out, v.gridDimZ);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_LAUNCH_CONFIG::gridDimY").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "gridDimY=");
      roctracer::hip_support::detail::operator<<(out, v.gridDimY);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("HIP_LAUNCH_CONFIG::gridDimX").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "gridDimX=");
      roctracer::hip_support::detail::operator<<(out, v.gridDimX);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipDeviceProp_tR0000& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipDeviceProp_tR0000::pageableMemoryAccessUsesHostPageTables").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "pageableMemoryAccessUsesHostPageTables=");
      roctracer::hip_support::detail::operator<<(out, v.pageableMemoryAccessUsesHostPageTables);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::pageableMemoryAccess").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "pageableMemoryAccess=");
      roctracer::hip_support::detail::operator<<(out, v.pageableMemoryAccess);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::concurrentManagedAccess").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "concurrentManagedAccess=");
      roctracer::hip_support::detail::operator<<(out, v.concurrentManagedAccess);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::directManagedMemAccessFromHost").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "directManagedMemAccessFromHost=");
      roctracer::hip_support::detail::operator<<(out, v.directManagedMemAccessFromHost);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::managedMemory").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "managedMemory=");
      roctracer::hip_support::detail::operator<<(out, v.managedMemory);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::asicRevision").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "asicRevision=");
      roctracer::hip_support::detail::operator<<(out, v.asicRevision);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::isLargeBar").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "isLargeBar=");
      roctracer::hip_support::detail::operator<<(out, v.isLargeBar);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::cooperativeMultiDeviceUnmatchedSharedMem").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "cooperativeMultiDeviceUnmatchedSharedMem=");
      roctracer::hip_support::detail::operator<<(out, v.cooperativeMultiDeviceUnmatchedSharedMem);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::cooperativeMultiDeviceUnmatchedBlockDim").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "cooperativeMultiDeviceUnmatchedBlockDim=");
      roctracer::hip_support::detail::operator<<(out, v.cooperativeMultiDeviceUnmatchedBlockDim);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::cooperativeMultiDeviceUnmatchedGridDim").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "cooperativeMultiDeviceUnmatchedGridDim=");
      roctracer::hip_support::detail::operator<<(out, v.cooperativeMultiDeviceUnmatchedGridDim);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::cooperativeMultiDeviceUnmatchedFunc").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "cooperativeMultiDeviceUnmatchedFunc=");
      roctracer::hip_support::detail::operator<<(out, v.cooperativeMultiDeviceUnmatchedFunc);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::tccDriver").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "tccDriver=");
      roctracer::hip_support::detail::operator<<(out, v.tccDriver);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::ECCEnabled").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "ECCEnabled=");
      roctracer::hip_support::detail::operator<<(out, v.ECCEnabled);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::kernelExecTimeoutEnabled").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "kernelExecTimeoutEnabled=");
      roctracer::hip_support::detail::operator<<(out, v.kernelExecTimeoutEnabled);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::texturePitchAlignment").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "texturePitchAlignment=");
      roctracer::hip_support::detail::operator<<(out, v.texturePitchAlignment);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::textureAlignment").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "textureAlignment=");
      roctracer::hip_support::detail::operator<<(out, v.textureAlignment);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::memPitch").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "memPitch=");
      roctracer::hip_support::detail::operator<<(out, v.memPitch);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::hdpRegFlushCntl").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hdpRegFlushCntl=");
      roctracer::hip_support::detail::operator<<(out, v.hdpRegFlushCntl);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::hdpMemFlushCntl").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "hdpMemFlushCntl=");
      roctracer::hip_support::detail::operator<<(out, v.hdpMemFlushCntl);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::maxTexture3D").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxTexture3D=");
      roctracer::hip_support::detail::operator<<(out, v.maxTexture3D);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::maxTexture2D").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxTexture2D=");
      roctracer::hip_support::detail::operator<<(out, v.maxTexture2D);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::maxTexture1D").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxTexture1D=");
      roctracer::hip_support::detail::operator<<(out, v.maxTexture1D);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::maxTexture1DLinear").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxTexture1DLinear=");
      roctracer::hip_support::detail::operator<<(out, v.maxTexture1DLinear);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::cooperativeMultiDeviceLaunch").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "cooperativeMultiDeviceLaunch=");
      roctracer::hip_support::detail::operator<<(out, v.cooperativeMultiDeviceLaunch);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::cooperativeLaunch").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "cooperativeLaunch=");
      roctracer::hip_support::detail::operator<<(out, v.cooperativeLaunch);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::integrated").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "integrated=");
      roctracer::hip_support::detail::operator<<(out, v.integrated);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::gcnArchName").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "gcnArchName=");
      roctracer::hip_support::detail::operator<<(out, v.gcnArchName);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::gcnArch").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "gcnArch=");
      roctracer::hip_support::detail::operator<<(out, v.gcnArch);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::canMapHostMemory").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "canMapHostMemory=");
      roctracer::hip_support::detail::operator<<(out, v.canMapHostMemory);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::isMultiGpuBoard").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "isMultiGpuBoard=");
      roctracer::hip_support::detail::operator<<(out, v.isMultiGpuBoard);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::maxSharedMemoryPerMultiProcessor").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxSharedMemoryPerMultiProcessor=");
      roctracer::hip_support::detail::operator<<(out, v.maxSharedMemoryPerMultiProcessor);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::pciDeviceID").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "pciDeviceID=");
      roctracer::hip_support::detail::operator<<(out, v.pciDeviceID);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::pciBusID").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "pciBusID=");
      roctracer::hip_support::detail::operator<<(out, v.pciBusID);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::pciDomainID").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "pciDomainID=");
      roctracer::hip_support::detail::operator<<(out, v.pciDomainID);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::concurrentKernels").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "concurrentKernels=");
      roctracer::hip_support::detail::operator<<(out, v.concurrentKernels);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::arch").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "arch=");
      roctracer::hip_support::detail::operator<<(out, v.arch);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::clockInstructionRate").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "clockInstructionRate=");
      roctracer::hip_support::detail::operator<<(out, v.clockInstructionRate);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::computeMode").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "computeMode=");
      roctracer::hip_support::detail::operator<<(out, v.computeMode);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::maxThreadsPerMultiProcessor").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxThreadsPerMultiProcessor=");
      roctracer::hip_support::detail::operator<<(out, v.maxThreadsPerMultiProcessor);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::l2CacheSize").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "l2CacheSize=");
      roctracer::hip_support::detail::operator<<(out, v.l2CacheSize);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::multiProcessorCount").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "multiProcessorCount=");
      roctracer::hip_support::detail::operator<<(out, v.multiProcessorCount);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::minor").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "minor=");
      roctracer::hip_support::detail::operator<<(out, v.minor);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::major").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "major=");
      roctracer::hip_support::detail::operator<<(out, v.major);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::totalConstMem").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "totalConstMem=");
      roctracer::hip_support::detail::operator<<(out, v.totalConstMem);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::memoryBusWidth").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "memoryBusWidth=");
      roctracer::hip_support::detail::operator<<(out, v.memoryBusWidth);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::memoryClockRate").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "memoryClockRate=");
      roctracer::hip_support::detail::operator<<(out, v.memoryClockRate);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::clockRate").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "clockRate=");
      roctracer::hip_support::detail::operator<<(out, v.clockRate);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::maxGridSize").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxGridSize=");
      roctracer::hip_support::detail::operator<<(out, v.maxGridSize);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::maxThreadsDim").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxThreadsDim=");
      roctracer::hip_support::detail::operator<<(out, v.maxThreadsDim);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::maxThreadsPerBlock").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "maxThreadsPerBlock=");
      roctracer::hip_support::detail::operator<<(out, v.maxThreadsPerBlock);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::warpSize").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "warpSize=");
      roctracer::hip_support::detail::operator<<(out, v.warpSize);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::regsPerBlock").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "regsPerBlock=");
      roctracer::hip_support::detail::operator<<(out, v.regsPerBlock);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::sharedMemPerBlock").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "sharedMemPerBlock=");
      roctracer::hip_support::detail::operator<<(out, v.sharedMemPerBlock);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::totalGlobalMem").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "totalGlobalMem=");
      roctracer::hip_support::detail::operator<<(out, v.totalGlobalMem);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipDeviceProp_tR0000::name").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "name=");
      roctracer::hip_support::detail::operator<<(out, v.name);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipStreamBatchMemOpParams_union::hipStreamMemOpWaitValueParams_t& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipStreamBatchMemOpParams_union::hipStreamMemOpWaitValueParams_t::alias").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "alias=");
      roctracer::hip_support::detail::operator<<(out, v.alias);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipStreamBatchMemOpParams_union::hipStreamMemOpWaitValueParams_t::flags").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "flags=");
      roctracer::hip_support::detail::operator<<(out, v.flags);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipStreamBatchMemOpParams_union::hipStreamMemOpWaitValueParams_t::address").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "address=");
      roctracer::hip_support::detail::operator<<(out, v.address);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipStreamBatchMemOpParams_union::hipStreamMemOpWaitValueParams_t::operation").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "operation=");
      roctracer::hip_support::detail::operator<<(out, v.operation);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipStreamBatchMemOpParams_union::hipStreamMemOpWriteValueParams_t& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipStreamBatchMemOpParams_union::hipStreamMemOpWriteValueParams_t::alias").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "alias=");
      roctracer::hip_support::detail::operator<<(out, v.alias);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipStreamBatchMemOpParams_union::hipStreamMemOpWriteValueParams_t::flags").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "flags=");
      roctracer::hip_support::detail::operator<<(out, v.flags);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipStreamBatchMemOpParams_union::hipStreamMemOpWriteValueParams_t::address").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "address=");
      roctracer::hip_support::detail::operator<<(out, v.address);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipStreamBatchMemOpParams_union::hipStreamMemOpWriteValueParams_t::operation").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "operation=");
      roctracer::hip_support::detail::operator<<(out, v.operation);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipStreamBatchMemOpParams_union::hipStreamMemOpFlushRemoteWritesParams_t& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipStreamBatchMemOpParams_union::hipStreamMemOpFlushRemoteWritesParams_t::flags").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "flags=");
      roctracer::hip_support::detail::operator<<(out, v.flags);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipStreamBatchMemOpParams_union::hipStreamMemOpFlushRemoteWritesParams_t::operation").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "operation=");
      roctracer::hip_support::detail::operator<<(out, v.operation);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
inline static std::ostream& operator<<(std::ostream& out, const hipStreamBatchMemOpParams_union::hipStreamMemOpMemoryBarrierParams_t& v)
{
  std::operator<<(out, '{');
  HIP_depth_max_cnt++;
  if (HIP_depth_max == -1 || HIP_depth_max_cnt <= HIP_depth_max) {
    if (std::string("hipStreamBatchMemOpParams_union::hipStreamMemOpMemoryBarrierParams_t::flags").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "flags=");
      roctracer::hip_support::detail::operator<<(out, v.flags);
      roctracer::hip_support::detail::operator<<(out, ", ");
    }
    if (std::string("hipStreamBatchMemOpParams_union::hipStreamMemOpMemoryBarrierParams_t::operation").find(HIP_structs_regex) != std::string::npos)   {
      roctracer::hip_support::detail::operator<<(out, "operation=");
      roctracer::hip_support::detail::operator<<(out, v.operation);
    }
  };
  HIP_depth_max_cnt--;
  std::operator<<(out, '}');
  return out;
}
// end ostream ops for HIP 
};};};

inline static std::ostream& operator<<(std::ostream& out, const div_t& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const ldiv_t& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const lldiv_t& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const timeval& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const timespec& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const random_data& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const drand48_data& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipDeviceArch_t& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipUUID& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipDeviceProp_tR0600& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipPointerAttribute_t& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipChannelFormatDesc& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const HIP_ARRAY_DESCRIPTOR& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const HIP_ARRAY3D_DESCRIPTOR& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hip_Memcpy2D& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipMipmappedArray& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const HIP_TEXTURE_DESC& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipResourceDesc& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const HIP_RESOURCE_DESC& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipResourceViewDesc& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const HIP_RESOURCE_VIEW_DESC& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipPitchedPtr& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipExtent& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipPos& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipMemcpy3DParms& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const HIP_MEMCPY3D& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipMemLocation& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipMemcpyAttributes& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipOffset3D& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipMemcpy3DOperand& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipMemcpy3DBatchOp& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipMemcpy3DPeerParms& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const uchar1& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const uchar2& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const uchar3& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const uchar4& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const char1& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const char2& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const char3& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const char4& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const ushort1& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const ushort2& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const ushort3& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const ushort4& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const short1& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const short2& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const short3& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const short4& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const uint1& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const uint2& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const uint3& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const uint4& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const int1& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const int2& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const int3& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const int4& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const ulong1& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const ulong2& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const ulong3& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const ulong4& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const long1& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const long2& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const long3& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const long4& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const ulonglong1& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const ulonglong2& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const ulonglong3& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const ulonglong4& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const longlong1& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const longlong2& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const longlong3& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const longlong4& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const float1& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const float2& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const float3& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const float4& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const double1& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const double2& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const double3& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const double4& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const textureReference& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipTextureDesc& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const surfaceReference& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipIpcMemHandle_t& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipIpcEventHandle_t& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipFuncAttributes& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipStreamBatchMemOpParams& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipBatchMemOpNodeParams& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipMemAccessDesc& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipMemPoolProps& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipMemPoolPtrExportData& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const dim3& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipLaunchParams& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipFunctionLaunchParams& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipExternalMemoryHandleDesc& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipExternalMemoryBufferDesc& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipExternalMemoryMipmappedArrayDesc& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipExternalSemaphoreHandleDesc& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipExternalSemaphoreSignalParams& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipExternalSemaphoreWaitParams& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipHostNodeParams& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipKernelNodeParams& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipMemsetParams& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipMemAllocNodeParams& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipAccessPolicyWindow& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipLaunchMemSyncDomainMap& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipLaunchAttributeValue& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipGraphInstantiateParams& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipMemAllocationProp& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipExternalSemaphoreSignalNodeParams& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipExternalSemaphoreWaitNodeParams& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipArrayMapInfo& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipMemcpyNodeParams& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipChildGraphNodeParams& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipEventWaitNodeParams& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipEventRecordNodeParams& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipMemFreeNodeParams& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipGraphNodeParams& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipGraphEdgeData& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipLaunchAttribute& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipLaunchConfig_t& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const HIP_LAUNCH_CONFIG& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipDeviceProp_tR0000& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipStreamBatchMemOpParams_union::hipStreamMemOpWaitValueParams_t& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipStreamBatchMemOpParams_union::hipStreamMemOpWriteValueParams_t& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipStreamBatchMemOpParams_union::hipStreamMemOpFlushRemoteWritesParams_t& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

inline static std::ostream& operator<<(std::ostream& out, const hipStreamBatchMemOpParams_union::hipStreamMemOpMemoryBarrierParams_t& v)
{
  roctracer::hip_support::detail::operator<<(out, v);
  return out;
}

#endif //__cplusplus
#endif // INC_HIP_OSTREAM_OPS_H_
 
#include <hip/amd_detail/hip_prof_str.h>