/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "bin/default/librpc/gen_ndr/ndr_mgmt.h"
#include "bin/default/librpc/gen_ndr/ndr_mgmt_c.h"

/* mgmt - client functions generated by pidl */

struct dcerpc_mgmt_inq_if_ids_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_mgmt_inq_if_ids_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_mgmt_inq_if_ids_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct mgmt_inq_if_ids *r)
{
	struct tevent_req *req;
	struct dcerpc_mgmt_inq_if_ids_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_mgmt_inq_if_ids_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_mgmt,
			NDR_MGMT_INQ_IF_IDS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_mgmt_inq_if_ids_r_done, req);

	return req;
}

static void dcerpc_mgmt_inq_if_ids_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_mgmt_inq_if_ids_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_mgmt_inq_if_ids_r_state *state =
		tevent_req_data(req,
		struct dcerpc_mgmt_inq_if_ids_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_mgmt_inq_if_ids_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct mgmt_inq_if_ids *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_mgmt,
			NDR_MGMT_INQ_IF_IDS, mem_ctx, r);

	return status;
}

struct dcerpc_mgmt_inq_if_ids_state {
	struct mgmt_inq_if_ids orig;
	struct mgmt_inq_if_ids tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_mgmt_inq_if_ids_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_mgmt_inq_if_ids_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct rpc_if_id_vector_t **_if_id_vector /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_mgmt_inq_if_ids_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_mgmt_inq_if_ids_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.if_id_vector = _if_id_vector;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_mgmt_inq_if_ids_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_mgmt_inq_if_ids_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_mgmt_inq_if_ids_done, req);
	return req;
}

static void dcerpc_mgmt_inq_if_ids_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_mgmt_inq_if_ids_state *state = tevent_req_data(
		req, struct dcerpc_mgmt_inq_if_ids_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_mgmt_inq_if_ids_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.if_id_vector = *state->tmp.out.if_id_vector;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_mgmt_inq_if_ids_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_mgmt_inq_if_ids_state *state = tevent_req_data(
		req, struct dcerpc_mgmt_inq_if_ids_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_mgmt_inq_if_ids(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct rpc_if_id_vector_t **_if_id_vector /* [out] [ref] */,
				WERROR *result)
{
	struct mgmt_inq_if_ids r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */
	r.out.if_id_vector = _if_id_vector;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_mgmt_inq_if_ids_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_if_id_vector = *r.out.if_id_vector;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_mgmt_inq_stats_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_mgmt_inq_stats_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_mgmt_inq_stats_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct mgmt_inq_stats *r)
{
	struct tevent_req *req;
	struct dcerpc_mgmt_inq_stats_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_mgmt_inq_stats_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_mgmt,
			NDR_MGMT_INQ_STATS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_mgmt_inq_stats_r_done, req);

	return req;
}

static void dcerpc_mgmt_inq_stats_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_mgmt_inq_stats_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_mgmt_inq_stats_r_state *state =
		tevent_req_data(req,
		struct dcerpc_mgmt_inq_stats_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_mgmt_inq_stats_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct mgmt_inq_stats *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_mgmt,
			NDR_MGMT_INQ_STATS, mem_ctx, r);

	return status;
}

struct dcerpc_mgmt_inq_stats_state {
	struct mgmt_inq_stats orig;
	struct mgmt_inq_stats tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_mgmt_inq_stats_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_mgmt_inq_stats_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      uint32_t _max_count /* [in]  */,
					      uint32_t _unknown /* [in]  */,
					      struct mgmt_statistics *_statistics /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_mgmt_inq_stats_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_mgmt_inq_stats_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.max_count = _max_count;
	state->orig.in.unknown = _unknown;

	/* Out parameters */
	state->orig.out.statistics = _statistics;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_mgmt_inq_stats_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_mgmt_inq_stats_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_mgmt_inq_stats_done, req);
	return req;
}

static void dcerpc_mgmt_inq_stats_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_mgmt_inq_stats_state *state = tevent_req_data(
		req, struct dcerpc_mgmt_inq_stats_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_mgmt_inq_stats_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.statistics = *state->tmp.out.statistics;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_mgmt_inq_stats_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct dcerpc_mgmt_inq_stats_state *state = tevent_req_data(
		req, struct dcerpc_mgmt_inq_stats_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_mgmt_inq_stats(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       uint32_t _max_count /* [in]  */,
			       uint32_t _unknown /* [in]  */,
			       struct mgmt_statistics *_statistics /* [out] [ref] */,
			       WERROR *result)
{
	struct mgmt_inq_stats r;
	NTSTATUS status;

	/* In parameters */
	r.in.max_count = _max_count;
	r.in.unknown = _unknown;

	/* Out parameters */
	r.out.statistics = _statistics;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_mgmt_inq_stats_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_statistics = *r.out.statistics;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_mgmt_is_server_listening_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_mgmt_is_server_listening_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_mgmt_is_server_listening_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct mgmt_is_server_listening *r)
{
	struct tevent_req *req;
	struct dcerpc_mgmt_is_server_listening_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_mgmt_is_server_listening_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_mgmt,
			NDR_MGMT_IS_SERVER_LISTENING, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_mgmt_is_server_listening_r_done, req);

	return req;
}

static void dcerpc_mgmt_is_server_listening_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_mgmt_is_server_listening_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_mgmt_is_server_listening_r_state *state =
		tevent_req_data(req,
		struct dcerpc_mgmt_is_server_listening_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_mgmt_is_server_listening_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct mgmt_is_server_listening *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_mgmt,
			NDR_MGMT_IS_SERVER_LISTENING, mem_ctx, r);

	return status;
}

struct dcerpc_mgmt_is_server_listening_state {
	struct mgmt_is_server_listening orig;
	struct mgmt_is_server_listening tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_mgmt_is_server_listening_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_mgmt_is_server_listening_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							uint32_t *_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_mgmt_is_server_listening_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_mgmt_is_server_listening_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.status = _status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_mgmt_is_server_listening_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_mgmt_is_server_listening_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_mgmt_is_server_listening_done, req);
	return req;
}

static void dcerpc_mgmt_is_server_listening_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_mgmt_is_server_listening_state *state = tevent_req_data(
		req, struct dcerpc_mgmt_is_server_listening_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_mgmt_is_server_listening_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.status = *state->tmp.out.status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_mgmt_is_server_listening_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      uint32_t *result)
{
	struct dcerpc_mgmt_is_server_listening_state *state = tevent_req_data(
		req, struct dcerpc_mgmt_is_server_listening_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_mgmt_is_server_listening(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 uint32_t *_status /* [out] [ref] */,
					 uint32_t *result)
{
	struct mgmt_is_server_listening r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */
	r.out.status = _status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_mgmt_is_server_listening_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_status = *r.out.status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_mgmt_stop_server_listening_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_mgmt_stop_server_listening_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_mgmt_stop_server_listening_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct mgmt_stop_server_listening *r)
{
	struct tevent_req *req;
	struct dcerpc_mgmt_stop_server_listening_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_mgmt_stop_server_listening_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_mgmt,
			NDR_MGMT_STOP_SERVER_LISTENING, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_mgmt_stop_server_listening_r_done, req);

	return req;
}

static void dcerpc_mgmt_stop_server_listening_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_mgmt_stop_server_listening_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_mgmt_stop_server_listening_r_state *state =
		tevent_req_data(req,
		struct dcerpc_mgmt_stop_server_listening_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_mgmt_stop_server_listening_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct mgmt_stop_server_listening *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_mgmt,
			NDR_MGMT_STOP_SERVER_LISTENING, mem_ctx, r);

	return status;
}

struct dcerpc_mgmt_stop_server_listening_state {
	struct mgmt_stop_server_listening orig;
	struct mgmt_stop_server_listening tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_mgmt_stop_server_listening_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_mgmt_stop_server_listening_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_mgmt_stop_server_listening_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_mgmt_stop_server_listening_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_mgmt_stop_server_listening_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_mgmt_stop_server_listening_done, req);
	return req;
}

static void dcerpc_mgmt_stop_server_listening_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_mgmt_stop_server_listening_state *state = tevent_req_data(
		req, struct dcerpc_mgmt_stop_server_listening_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_mgmt_stop_server_listening_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_mgmt_stop_server_listening_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_mgmt_stop_server_listening_state *state = tevent_req_data(
		req, struct dcerpc_mgmt_stop_server_listening_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_mgmt_stop_server_listening(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct mgmt_stop_server_listening r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_mgmt_stop_server_listening_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_mgmt_inq_princ_name_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_mgmt_inq_princ_name_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_mgmt_inq_princ_name_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct mgmt_inq_princ_name *r)
{
	struct tevent_req *req;
	struct dcerpc_mgmt_inq_princ_name_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_mgmt_inq_princ_name_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_mgmt,
			NDR_MGMT_INQ_PRINC_NAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_mgmt_inq_princ_name_r_done, req);

	return req;
}

static void dcerpc_mgmt_inq_princ_name_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_mgmt_inq_princ_name_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_mgmt_inq_princ_name_r_state *state =
		tevent_req_data(req,
		struct dcerpc_mgmt_inq_princ_name_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_mgmt_inq_princ_name_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct mgmt_inq_princ_name *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_mgmt,
			NDR_MGMT_INQ_PRINC_NAME, mem_ctx, r);

	return status;
}

struct dcerpc_mgmt_inq_princ_name_state {
	struct mgmt_inq_princ_name orig;
	struct mgmt_inq_princ_name tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_mgmt_inq_princ_name_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_mgmt_inq_princ_name_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   uint32_t _authn_proto /* [in]  */,
						   uint32_t _princ_name_size /* [in]  */,
						   const char *_princ_name /* [out] [charset(DOS),size_is(princ_name_size)] */)
{
	struct tevent_req *req;
	struct dcerpc_mgmt_inq_princ_name_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_mgmt_inq_princ_name_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.authn_proto = _authn_proto;
	state->orig.in.princ_name_size = _princ_name_size;

	/* Out parameters */
	state->orig.out.princ_name = _princ_name;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_mgmt_inq_princ_name_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_mgmt_inq_princ_name_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_mgmt_inq_princ_name_done, req);
	return req;
}

static void dcerpc_mgmt_inq_princ_name_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_mgmt_inq_princ_name_state *state = tevent_req_data(
		req, struct dcerpc_mgmt_inq_princ_name_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_mgmt_inq_princ_name_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_princ_name;
		_copy_len_princ_name = ndr_charset_length(state->tmp.out.princ_name, CH_UNIX);
		if (_copy_len_princ_name > state->tmp.in.princ_name_size) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		if (state->orig.out.princ_name != state->tmp.out.princ_name) {
			memcpy(discard_const_p(uint8_t *, state->orig.out.princ_name), state->tmp.out.princ_name, _copy_len_princ_name * sizeof(*state->orig.out.princ_name));
		}
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_mgmt_inq_princ_name_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_mgmt_inq_princ_name_state *state = tevent_req_data(
		req, struct dcerpc_mgmt_inq_princ_name_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_mgmt_inq_princ_name(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    uint32_t _authn_proto /* [in]  */,
				    uint32_t _princ_name_size /* [in]  */,
				    const char *_princ_name /* [out] [charset(DOS),size_is(princ_name_size)] */,
				    WERROR *result)
{
	struct mgmt_inq_princ_name r;
	NTSTATUS status;

	/* In parameters */
	r.in.authn_proto = _authn_proto;
	r.in.princ_name_size = _princ_name_size;

	/* Out parameters */
	r.out.princ_name = _princ_name;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_mgmt_inq_princ_name_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_princ_name;
		_copy_len_princ_name = ndr_charset_length(r.out.princ_name, CH_UNIX);
		if (_copy_len_princ_name > r.in.princ_name_size) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		if (_princ_name != r.out.princ_name) {
			memcpy(discard_const_p(uint8_t *, _princ_name), r.out.princ_name, _copy_len_princ_name * sizeof(*_princ_name));
		}
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

